typedef struct
{
	unsigned int nOffset;
	unsigned int nLength;
} PHONEME_INFO, *PPHONEME_INFO;

static const PHONEME_INFO g_nPhonemeInfo[62] = 
{
	{0x00000000,0x00000A60},{0x00000A60,0x00000A4C},
	{0x000014AC,0x00000A22},{0x00001ECE,0x00000A93},
	{0x00002961,0x00000ABA},{0x0000341B,0x00000A46},
	{0x00003E61,0x00000A54},{0x000048B5,0x00000C83},
	{0x00005538,0x00000A4F},{0x00005F87,0x00000A95},
	{0x00006A1C,0x00000A21},{0x0000743D,0x00000A11},
	{0x00007E4E,0x000009F4},{0x00008842,0x00000A91},
	{0x000092D3,0x00000A3C},{0x00009D0F,0x00000A5F},
	{0x0000A76E,0x00000AAB},{0x0000B219,0x00000A4F},
	{0x0000BC68,0x00000AAF},{0x0000C717,0x00000A74},
	{0x0000D18B,0x00000A2E},{0x0000DBB9,0x00000A49},
	{0x0000E602,0x00000A72},{0x0000F074,0x00000A5D},
	{0x0000FAD1,0x000009FB},{0x000104CC,0x00000A12},
	{0x00010EDE,0x00000A4B},{0x00011929,0x00000A5A},
	{0x00012383,0x00000A67},{0x00012DEA,0x00000A23},
	{0x0001380D,0x000009D0},{0x000141DD,0x00000A61},
	{0x00014C3E,0x00000A3A},{0x00015678,0x00000A31},
	{0x000160A9,0x000003F4},{0x0001649D,0x00000383},
	{0x00016820,0x00000A83},{0x000172A3,0x00000380},
	{0x00017623,0x00000370},{0x00017993,0x00000389},
	{0x00017D1C,0x00000A0F},{0x0001872B,0x00000C7F},
	{0x000193AA,0x00000A37},{0x00019DE1,0x00000D2D},
	{0x0001AB0E,0x000009EB},{0x0001B4F9,0x00000A3A},
	{0x0001BF33,0x00000A2B},{0x0001C95E,0x00000A58},
	{0x0001D3B6,0x00000A52},{0x0001DE08,0x00000A28},
	{0x0001E830,0x00000A60},{0x0001F290,0x00000A0E},
	{0x0001FC9E,0x00000AA0},{0x0002073E,0x00000A65},
	{0x000211A3,0x00000A4E},{0x00021BF1,0x00000AAB},
	{0x0002269C,0x00000A53},{0x000230EF,0x00000A22},
	{0x00023B11,0x00000A18},{0x00024529,0x00000A53},
	{0x00024F7C,0x00000A04},{0x00025980,0x00000A16},
};

static const unsigned short g_nPhonemeData[156566] = 
{
	0xFE64,0xFE8A,0xFD76,0xFCAF,0xFCBA,0xFCF5,0xFD5F,0xFD8C,
	0xFDE2,0xFDBF,0xFDCE,0xFD1A,0xFCB4,0xFCCD,0xFD67,0xFDC8,
	0xFE24,0xFE37,0xFE1E,0xFDC7,0xFD49,0xFD59,0xFD92,0xFDFB,
	0xFE30,0xFE41,0xFDC7,0xFD87,0xFD75,0xFD6F,0xFD43,0xFDDC,
	0xFE1E,0xFE39,0xFDE3,0xFD96,0xFD85,0xFD61,0xFD85,0xFE01,
	0xFE42,0xFE31,0xFE52,0xFE18,0xFD8A,0xFD71,0xFDF0,0xFE49,
	0xFE8A,0xFE7C,0xFE0B,0xFD9E,0xFD76,0xFDB0,0xFE3E,0xFE2F,
	0xFE39,0xFE7D,0xFEA1,0xFE31,0xFE2B,0xFED8,0xFFF0,0x0065,
	0x02D7,0x01F1,0x005B,0x014E,0x0202,0x0319,0x0443,0x054D,
	0x05EE,0x0751,0x08A7,0x091B,0x07EC,0x0701,0x0681,0x069A,
	0x06C5,0x06D5,0x0679,0x057E,0x04F2,0x049E,0x04A6,0x0515,
	0x0638,0x0666,0x05AA,0x0506,0x0554,0x063F,0x065A,0x0673,
	0x06F3,0x07E8,0x0910,0x09AE,0x09E3,0x0A35,0x0A6B,0x0B1B,
	0x0C4C,0x0D7D,0x0E89,0x0ED6,0x0E66,0x0E60,0x0F12,0x1027,
	0x10B1,0x10A8,0x106F,0x11DF,0x1356,0x1472,0x148F,0x1400,
	0x13A0,0x1341,0x13E7,0x15AF,0x1756,0x1799,0x16E7,0x154A,
	0x1324,0x12E0,0x13AC,0x1438,0x153C,0x1623,0x15D4,0x14E2,
	0x13E9,0x13B5,0x1427,0x14C9,0x1593,0x15AE,0x14C0,0x1451,
	0x1342,0x131F,0x1445,0x149C,0x14EF,0x1573,0x146E,0x1294,
	0x1163,0x118B,0x12CF,0x13C7,0x13FD,0x1347,0x128B,0x119F,
	0x10AA,0x0FB1,0x0F20,0x0FC2,0x114E,0x1256,0x11D0,0x0F89,
	0x0D8B,0x0C34,0x0C62,0x0F0C,0x0F87,0x0ECF,0x0E17,0x0C94,
	0x0AE3,0x0A5F,0x0A70,0x0AA7,0x0AE1,0x0ADE,0x0AEC,0x0B6F,
	0x0B3C,0x0A08,0x092E,0x0852,0x0802,0x0855,0x08F4,0x0914,
	0x084F,0x06EA,0x0527,0x041A,0x0432,0x0459,0x048D,0x03DC,
	0x0317,0x0340,0x032F,0x02AE,0x0044,0xFCAC,0xF6E4,0xF020,
	0xE768,0xDD48,0xD48B,0xD1C0,0xD8D8,0xE8ED,0xF9F8,0x0177,
	0xF8AB,0xE3B0,0xCF3D,0xC837,0xD3CE,0xEDA5,0x0916,0x19A9,
	0x1A87,0x0E3F,0xFD82,0xF0F1,0xEF06,0xFAD0,0x0ED8,0x2332,
	0x2F87,0x2F6E,0x22F6,0x11CF,0x04C3,0x016F,0x0883,0x1464,
	0x1BFA,0x1C21,0x158C,0x0C12,0x0298,0xFA88,0xF5CA,0xF399,
	0xF11C,0xEF77,0xF069,0xEE90,0xED50,0xEB1F,0xE74D,0xE27E,
	0xDDA9,0xD9BB,0xD73E,0xD88A,0xDE49,0xE684,0xEDBE,0xEFEB,
	0xEC01,0xE465,0xDDE7,0xDE22,0xE62F,0xF282,0xFE8E,0x04D4,
	0x04AB,0xFF6E,0xF95A,0xF5BE,0xF695,0xFB0D,0x02C4,0x0A76,
	0x0EC6,0x0DDD,0x06B3,0xFD54,0xF6A4,0xF51C,0xF782,0xFB4E,
	0xFDC8,0xFC78,0xF778,0xF161,0xECC8,0xEA32,0xE770,0xE52D,
	0xE30F,0xE28A,0xE392,0xE4B3,0xE4F6,0xE309,0xE029,0xDDA5,
	0xDCF1,0xDE50,0xE124,0xE412,0xE6C0,0xE986,0xEE1C,0xF064,
	0xF000,0xEF0E,0xEE0E,0xEEF9,0xF24F,0xF7FA,0xFD84,0x0074,
	0xFFB9,0xFCD2,0xFA42,0xF9C9,0xFA80,0xFBF5,0xFD65,0xFEE1,
	0xFFB1,0xFE97,0xFBD6,0xF866,0xF42A,0xF136,0xF0ED,0xF249,
	0xF33C,0xF233,0xEEDA,0xEB64,0xE924,0xE850,0xE7E4,0xE775,
	0xE6C6,0xE727,0xE771,0xE7B1,0xE8AF,0xE9CA,0xEA62,0xE978,
	0xE842,0xE92D,0xEB9F,0xED78,0xEFC9,0xF329,0xF56E,0xF621,
	0xF4E7,0xF3EF,0xF444,0xF6B2,0xF984,0xFBDF,0xFC84,0xFC47,
	0xFB14,0xF8A6,0xF66C,0xF6F5,0xF892,0xFA8A,0xFAE8,0xF97D,
	0xF6E3,0xF405,0xF274,0xF2C2,0xF335,0xF2EB,0xF1E5,0xF09A,
	0xEF7C,0xEF2A,0xEEB8,0xED9D,0xECF0,0xEDA7,0xEEE4,0xEF00,
	0xEE34,0xEDF1,0xEE35,0xEE7E,0xEF8A,0xF1A6,0xF3C5,0xF407,
	0xF2C2,0xF221,0xF3F2,0xF74C,0xF97A,0xFA3A,0xFA4E,0xFA86,
	0xFB6E,0xFBED,0xFC59,0xFC92,0xFD04,0xFDB5,0xFEA6,0xFF18,
	0xFEDC,0xFD30,0xFABA,0xF9BC,0xFAF6,0xFCA5,0xFD04,0xFA89,
	0xF6FA,0xF50A,0xF54C,0xF664,0xF7D2,0xF86A,0xF6F2,0xF571,
	0xF511,0xF21A,0xF36F,0xF4EA,0xF573,0xF62F,0xF6D7,0xF706,
	0xF683,0xF57A,0xF5AE,0xF79A,0xFA38,0xFB4E,0xFA68,0xF9E9,
	0xF8B6,0xF464,0xEB03,0xD941,0xC424,0xBF0A,0xC00D,0xC021,
	0xC0C3,0xDCEE,0x027D,0x0AC3,0xEDCA,0xC500,0xBFF6,0xC260,
	0xC0F4,0xEF2E,0x2FA5,0x3DAF,0x3CCC,0x25B3,0xF9C7,0xE25A,
	0xE889,0x0E86,0x3899,0x3F57,0x3EC7,0x3EB3,0x3F3D,0x2C1D,
	0x1486,0x1878,0x30DA,0x401A,0x3E8F,0x3F4F,0x3CED,0x285C,
	0x15AA,0x0BFB,0x059F,0xFEDB,0xF760,0xF1B5,0xF06D,0xF263,
	0xF2EB,0xF0CA,0xE7D5,0xD860,0xC6C7,0xBF8F,0xBF5D,0xC562,
	0xDC31,0xF39C,0x0046,0xFCA8,0xEAA8,0xD4DC,0xC933,0xD229,
	0xEE3B,0x10CB,0x29FA,0x3199,0x2A13,0x192F,0x081B,0x0197,
	0x09A6,0x1CFB,0x3331,0x3F0C,0x3F30,0x3999,0x279F,0x1632,
	0x0C6E,0x0D48,0x14B5,0x1B87,0x1C31,0x15FE,0x0C85,0x02AD,
	0xF9E7,0xF226,0xEB44,0xE69D,0xE256,0xE08E,0xE2B1,0xE6EA,
	0xEA1C,0xE90A,0xE3A1,0xDC29,0xD54D,0xD2FA,0xD7DF,0xE396,
	0xF1D3,0xFDB9,0x034E,0x009C,0xF884,0xF15C,0xF01A,0xF800,
	0x06C2,0x168F,0x2155,0x24B6,0x1FFA,0x164B,0x0D5C,0x09DB,
	0x0D5B,0x15BB,0x1F93,0x2529,0x23FC,0x1BC0,0x1030,0x0556,
	0xFF7B,0xFEA0,0x005D,0x02A5,0x0331,0x008D,0xFB18,0xF4C7,
	0xEE1E,0xE94F,0xE692,0xE547,0xE654,0xE8C2,0xEB68,0xED42,
	0xEDEB,0xED8C,0xECB2,0xEB2B,0xEA03,0xEB36,0xEFD8,0xF779,
	0xFFBA,0x05AC,0x08BF,0x07AC,0x0486,0x01AA,0x01CA,0x065A,
	0x0E04,0x150D,0x1966,0x1988,0x156B,0x105E,0x0C60,0x0A8A,
	0x0931,0x0D28,0x0F96,0x0F89,0x0E38,0x0965,0x02FF,0xFD25,
	0xF9C3,0xF8E6,0xF912,0xF8C0,0xF7D7,0xF63A,0xF4B4,0xF2D9,
	0xF0B9,0xEE77,0xED00,0xEC62,0xED95,0xF015,0xF2EB,0xF514,
	0xF668,0xF70B,0xF718,0xF77C,0xF854,0xFA16,0xFD2B,0x00D1,
	0x0472,0x07C5,0x0918,0x0873,0x071D,0x06E6,0x07E1,0x096E,
	0x0BAC,0x0D6D,0x0DD5,0x0BFD,0x0A54,0x08E9,0x078C,0x0656,
	0x049B,0x0313,0x0254,0x0204,0x00A7,0xFE66,0xFC25,0xFA64,
	0xF901,0xF85E,0xF81D,0xF70E,0xF580,0xF584,0xF7F1,0xF98F,
	0xFA6F,0xF9A0,0xF731,0xF52A,0xF55F,0xF7FC,0xFBA2,0xFED3,
	0xFFC1,0xFFC6,0xFF89,0xFD33,0xF660,0xE8DB,0xD296,0xC0EA,
	0xBFD7,0xC02B,0xC00A,0xC821,0xF044,0x0F75,0x0DCC,0xE4EC,
	0xBFBF,0xC217,0xC05E,0xC939,0x0F60,0x3DFF,0x3B71,0x3CDA,
	0x1F12,0xF248,0xE254,0xF529,0x2531,0x3F95,0x3DD3,0x3E89,
	0x3DF1,0x3EB6,0x2AED,0x1639,0x20A4,0x3949,0x3F89,0x3E62,
	0x3EED,0x3C4F,0x283B,0x15AD,0x0B00,0x02C6,0xFA01,0xF24D,
	0xEE84,0xF0DB,0xF6F8,0xFA12,0xF331,0xE2E3,0xCC92,0xBE79,
	0xBF1F,0xBF67,0xCF55,0xE901,0xFC51,0x01FE,0xF79C,0xE26C,
	0xCEDA,0xC94F,0xDA1E,0xFC9E,0x208A,0x3631,0x3731,0x266D,
	0x0FF1,0x0249,0x03D0,0x1406,0x2AA8,0x3BA8,0x3DE2,0x3D6B,
	0x3285,0x2144,0x13F3,0x0D8A,0x0E6F,0x1376,0x180E,0x17FA,
	0x126E,0x0923,0xFEFB,0xF5D5,0xED47,0xE51F,0xDF14,0xDBD0,
	0xDC79,0xE16A,0xE6AC,0xE961,0xE5E6,0xDCFB,0xD265,0xCB98,
	0xCCF8,0xD7EC,0xE866,0xF82B,0x010B,0x007C,0xF85A,0xF065,
	0xEBAE,0xF009,0xFF96,0x1078,0x1DF1,0x2428,0x221D,0x19F4,
	0x1114,0x0B80,0x0D01,0x13FE,0x1D41,0x23DF,0x2478,0x1F36,
	0x15A7,0x0C12,0x0508,0x0192,0x0103,0x0112,0x0048,0xFF25,
	0xFCA1,0xF87D,0xF2C4,0xEC29,0xE67D,0xE34E,0xE2B9,0xE3BB,
	0xE6C9,0xEA73,0xED39,0xED85,0xEB62,0xE880,0xE6F5,0xE7F6,
	0xEC31,0xF31C,0xFB87,0x02E4,0x060F,0x05D5,0x03E6,0x02BA,
	0x0374,0x063A,0x0AE1,0x1133,0x1657,0x1895,0x1754,0x140D,
	0x1041,0x0CD6,0x0B70,0x0C0A,0x0DD4,0x0F07,0x0EC0,0x0A8D,
	0x05A0,0x0113,0xFBD4,0xF713,0xF457,0xF47F,0xF6B6,0xF7F6,
	0xF6EB,0xF419,0xF03E,0xEC9E,0xEA41,0xE957,0xEAAC,0xEE3B,
	0xF1F3,0xF583,0xF6C5,0xF6FA,0xF71C,0xF662,0xF630,0xF8D4,
	0xFD2A,0x0142,0x0540,0x084F,0x0985,0x0A25,0x0A57,0x09A5,
	0x09E6,0x0AAC,0x0C8D,0x0EC5,0x1094,0x10F3,0x0F77,0x0CC5,
	0x0A30,0x086F,0x0853,0x07DC,0x0526,0x0370,0x0310,0x0364,
	0x0309,0xFFC7,0xFAAA,0xF5BD,0xF35B,0xF487,0xF85A,0xFB90,
	0xFBE8,0xFA84,0xF838,0xF661,0xF453,0xF381,0xF546,0xF8E7,
	0xFCE6,0x0062,0x01C2,0x0195,0x0014,0xFE58,0xFDBC,0xFBF9,
	0xF67B,0xE9A7,0xD294,0xC151,0xC0B0,0xC17C,0xC07B,0xCC46,
	0xF785,0x1440,0x0B2C,0xDBD0,0xBFA3,0xC3BB,0xC03D,0xD224,
	0x1E13,0x3F60,0x3CF4,0x39B5,0x1164,0xEA6E,0xE337,0xFD51,
	0x2D21,0x4096,0x3ED1,0x3F5F,0x3F90,0x3CB4,0x2291,0x16A3,
	0x286E,0x3E97,0x3FCA,0x3F12,0x4035,0x38A5,0x227E,0x145E,
	0x0B93,0x02E4,0xFA8E,0xF401,0xF20F,0xF492,0xF977,0xF869,
	0xF030,0xE23A,0xCD9D,0xC0FB,0xC06E,0xC26C,0xD42F,0xECBD,
	0xFF83,0x03C9,0xF6CA,0xE049,0xCDB1,0xCCB5,0xE14E,0x034C,
	0x245B,0x3753,0x369A,0x25C0,0x1018,0x02EF,0x0520,0x15EA,
	0x2E78,0x3E06,0x3EB8,0x3E26,0x316C,0x1D3C,0x1041,0x0D20,
	0x1263,0x19ED,0x1D05,0x1A40,0x12D2,0x08BD,0xFEC1,0xF5C0,
	0xEDEE,0xE6DF,0xE08E,0xDDB9,0xE01C,0xE59B,0xE99E,0xE93D,
	0xE2C6,0xD9D2,0xD209,0xCEEB,0xD246,0xDCB0,0xEB04,0xF7D2,
	0xFEB7,0xFDCA,0xF848,0xF07A,0xEE31,0xF5A5,0x02C9,0x12E7,
	0x2077,0x25AA,0x2129,0x17FA,0x0F84,0x0C58,0x0F91,0x1700,
	0x1E3D,0x21E5,0x20D6,0x1BCC,0x1355,0x0AAA,0x047B,0x00C2,
	0xFF4C,0xFE85,0xFEB7,0xFD80,0xFA4B,0xF58B,0xF05B,0xEA68,
	0xE576,0xE136,0xDEB1,0xDF78,0xE317,0xE815,0xEC13,0xEC71,
	0xE957,0xE38C,0xDFF6,0xE1F9,0xE8B6,0xF1D3,0xFA71,0x000A,
	0x0228,0x00D8,0xFD49,0xFB11,0xFD1C,0x01F8,0x09ED,0x1201,
	0x1702,0x16CB,0x1288,0x0CFB,0x096A,0x0844,0x0990,0x0BCB,
	0x0D0B,0x0BFE,0x0A0E,0x05A7,0xFFF6,0xFB68,0xF889,0xF70D,
	0xF68A,0xF5AC,0xF398,0xF0AD,0xEF35,0xEEC1,0xEE72,0xEC94,
	0xE9F2,0xE7BB,0xE7F3,0xEAB3,0xEE9A,0xF1E1,0xF367,0xF3B1,
	0xF365,0xF32D,0xF45E,0xF6FC,0xFA6D,0xFEAD,0x029B,0x0607,
	0x077E,0x06F8,0x05BC,0x05BA,0x069B,0x0928,0x0BF4,0x0DA2,
	0x0DF5,0x0D1D,0x0C22,0x0A3D,0x0765,0x0486,0x02EA,0x029B,
	0x0392,0x03C3,0x027B,0xFFDD,0xFC51,0xF82B,0xF5A4,0xF516,
	0xF62C,0xF6D1,0xF5D9,0xF53F,0xF556,0xF510,0xF491,0xF465,
	0xF08D,0xF20D,0xF5FF,0xF97D,0xFB0D,0xFC49,0xFC01,0xFBE8,
	0xFC17,0xFCE6,0xFD96,0xFAF0,0xF270,0xE1E8,0xC937,0xBED5,
	0xBFFD,0xC077,0xBF64,0xD77B,0x045E,0x1640,0xFFBC,0xCEC5,
	0xBF4A,0xC32E,0xBF2F,0xE4A2,0x2E0E,0x3DC5,0x3D59,0x3351,
	0x065E,0xE74E,0xE7D2,0x0941,0x3646,0x3FAC,0x3EB4,0x3ED6,
	0x3FD1,0x3861,0x1E14,0x1827,0x2CF2,0x3F27,0x3F3D,0x3EC0,
	0x3FD3,0x32AC,0x1E50,0x1360,0x0ACC,0x014B,0xF793,0xF0A4,
	0xEFE5,0xF4D2,0xF9E5,0xF971,0xEFAB,0xDDFF,0xC921,0xBE8D,
	0xBF08,0xC215,0xD6FC,0xF07D,0x00CA,0x00C6,0xF0B7,0xD948,
	0xC976,0xCE4D,0xE869,0x0C97,0x2ACF,0x3702,0x2FF3,0x1D66,
	0x0BD7,0x042B,0x0A2E,0x1C55,0x327D,0x3E50,0x3ECF,0x3D3D,
	0x2E93,0x1C39,0x10BF,0x0F3B,0x14C2,0x1B2A,0x1CD1,0x190A,
	0x110B,0x0760,0xFE29,0xF5D8,0xEDAB,0xE66C,0xE151,0xDF88,
	0xE1A1,0xE66D,0xEBC6,0xEAAA,0xE431,0xDBD6,0xD42A,0xD079,
	0xD444,0xDEFD,0xEDBD,0xFBEB,0x037F,0x02AD,0xFA57,0xF1F1,
	0xF02B,0xF751,0x0619,0x174F,0x23DC,0x26F8,0x21F4,0x19A5,
	0x12BA,0x0FC4,0x124A,0x18EA,0x1F8C,0x240A,0x2362,0x1D57,
	0x14A5,0x0B92,0x04DA,0x00FE,0xFF7A,0xFFC7,0x004A,0xFFB5,
	0xFD09,0xF887,0xF225,0xEBA6,0xE60A,0xE291,0xE2E3,0xE59D,
	0xE9E6,0xEDD0,0xEF11,0xEE39,0xEB29,0xE84C,0xE72F,0xE8D9,
	0xEE01,0xF673,0xFF8C,0x0643,0x0845,0x055E,0x01C2,0xFFF1,
	0x01D8,0x0737,0x0EB6,0x153A,0x184E,0x17E5,0x147E,0x1021,
	0x0C5C,0x0A4E,0x0A23,0x0B84,0x0D17,0x0E81,0x0D97,0x0804,
	0x037C,0xFDF7,0xF8C8,0xF6D6,0xF693,0xF6D9,0xF602,0xF48A,
	0xF315,0xF181,0xF09C,0xEECF,0xEBE4,0xE916,0xE925,0xECCC,
	0xF244,0xF635,0xF796,0xF6C5,0xF5B2,0xF4B3,0xF55D,0xF7C2,
	0xFC57,0x0243,0x06EE,0x0909,0x0999,0x08F6,0x06A4,0x0451,
	0x0518,0x0A38,0x0FB4,0x128F,0x114B,0x0D57,0x094D,0x066B,
	0x0591,0x05FB,0x0701,0x064F,0x0468,0x0262,0x00AF,0xFF37,
	0xFCAE,0xF9E2,0xF750,0xF662,0xF72F,0xF7E6,0xF6CD,0xF58D,
	0xF4E1,0xF453,0xF48D,0xF4E0,0xF65A,0xF7E7,0xF779,0xFA22,
	0xFDF4,0x00A5,0x012E,0xFF64,0xFD21,0xFB1A,0xF6DE,0xED2E,
	0xDABC,0xC4CB,0xBFBB,0xC07A,0xC0A5,0xC2A7,0xE3E1,0x0B3D,
	0x124E,0xF175,0xC59D,0xC081,0xC208,0xC2B8,0xFCCD,0x3960,
	0x3C5B,0x3DBA,0x2761,0xF88B,0xE29B,0xEF2C,0x1A51,0x3CDA,
	0x3E47,0x3E83,0x3E1C,0x3F34,0x308B,0x18F6,0x1C7E,0x3473,
	0x3F6F,0x3DB7,0x3DAD,0x3D79,0x2BCB,0x1866,0x0D33,0x0518,
	0xFCC3,0xF3E5,0xEE2A,0xEED0,0xF4A1,0xF8BA,0xF53B,0xE88A,
	0xD3DB,0xC157,0xBEE6,0xBEB2,0xC780,0xE148,0xF91C,0x0397,
	0xFC67,0xE783,0xD0B2,0xC72A,0xD3B9,0xF29E,0x170C,0x3167,
	0x37E3,0x2AA1,0x1494,0x0457,0x02AC,0x0EDC,0x2306,0x373A,
	0x3E26,0x3E03,0x36CD,0x240D,0x147B,0x0C8C,0x0D23,0x1320,
	0x191C,0x19FA,0x13C9,0x08AF,0xFD5A,0xF466,0xEDF3,0xE78F,
	0xE138,0xDC65,0xDAC8,0xDD93,0xE30C,0xE766,0xE5F1,0xDE8B,
	0xD45F,0xCC33,0xCBA4,0xD391,0xE221,0xF150,0xFC36,0xFF42,
	0xFB1F,0xF230,0xEBC7,0xED39,0xF794,0x07FB,0x1B2A,0x24D0,
	0x232B,0x1B27,0x1037,0x09BC,0x0A3B,0x10D7,0x19D5,0x20BF,
	0x220B,0x1D38,0x1478,0x0BA6,0x04E2,0x0095,0xFF56,0xFF5D,
	0xFF42,0xFDBA,0xFAAB,0xF635,0xF145,0xEBBF,0xE6CC,0xE3C4,
	0xE259,0xE192,0xE20C,0xE517,0xE91B,0xEBAE,0xEB54,0xE93D,
	0xE6B4,0xE58A,0xE6F2,0xEC82,0xF4FB,0xFDEB,0x0451,0x0629,
	0x0398,0x0003,0xFE7D,0x0036,0x055E,0x0D07,0x13A8,0x1784,
	0x16EC,0x1212,0x0C45,0x0914,0x0827,0x0988,0x0B93,0x0D5F,
	0x0D23,0x09FE,0x0592,0x001B,0xFAA0,0xF534,0xF0ED,0xF076,
	0xF35A,0xF4E8,0xF479,0xF188,0xECD5,0xE8A2,0xE662,0xE675,
	0xE94A,0xED57,0xF06A,0xF25E,0xF227,0xF152,0xF110,0xF25A,
	0xF465,0xF5E9,0xF92D,0xFE25,0x0229,0x045F,0x0592,0x0598,
	0x05AC,0x060E,0x073F,0x08AE,0x0AE9,0x0CAC,0x0E28,0x0DA3,
	0x0C71,0x0AF2,0x08F4,0x06D1,0x04C8,0x0417,0x0432,0x0421,
	0x0256,0x016A,0x00DC,0xFD29,0xF953,0xF5A8,0xF363,0xF397,
	0xF5CA,0xF7FC,0xF8AC,0xF77B,0xF50E,0xF2B0,0xF1C4,0xF38A,
	0xF744,0xFA91,0xFC9A,0xFDCB,0xFE30,0xFEDE,0xFEBE,0xFE24,
	0xFE65,0xFD9C,0xF91F,0xEDC5,0xD7C7,0xC2BB,0xC0BE,0xC1D0,
	0xC0FF,0xC8C4,0xF405,0x1587,0x1125,0xE4D6,0xC187,0xC2F4,
	0xC1BC,0xC99E,0x0FB2,0x3E27,0x3CAA,0x3DF7,0x1D52,0xEFA8,
	0xE0F2,0xF476,0x24D4,0x4002,0x3EE8,0x3F80,0x3F12,0x3F12,
	0x2997,0x16AB,0x2150,0x39EA,0x4030,0x3F19,0x3FC8,0x3D3D,
	0x2882,0x164B,0x0BCD,0x03D0,0xFBFC,0xF504,0xF12E,0xF33E,
	0xF84A,0xFA5A,0xF3E9,0xE44E,0xD09D,0xC282,0xC053,0xC0B9,
	0xD0F9,0xE855,0xFB92,0x02B8,0xFA0D,0xE669,0xD2FB,0xCCC1,
	0xDB95,0xFB02,0x1D8F,0x342E,0x3785,0x2A00,0x1627,0x07D5,
	0x0661,0x12EE,0x284D,0x3B2B,0x3F03,0x3F29,0x3947,0x2718,
	0x1710,0x0DB4,0x0DC4,0x14B9,0x1C06,0x1D29,0x1795,0x0D55,
	0x0227,0xF806,0xEEA9,0xE6B2,0xE064,0xDE0B,0xE077,0xE65C,
	0xEC05,0xECCC,0xE6E0,0xDC54,0xD23B,0xCE16,0xD163,0xDBD0,
	0xE9FF,0xF6FE,0xFE9D,0xFEC8,0xF90E,0xF168,0xECB2,0xEF7F,
	0xFB47,0x0D5E,0x1E63,0x2703,0x2641,0x1BC3,0x0F3D,0x092E,
	0x0BBA,0x144B,0x1D9C,0x2366,0x233E,0x1DD2,0x151D,0x0B23,
	0x0371,0xFF54,0xFEBB,0x000C,0x00DD,0xFF62,0xFC10,0xF6CA,
	0xF12C,0xEC8C,0xE755,0xE2A5,0xE022,0xE057,0xE40C,0xEA45,
	0xEEFB,0xEEBF,0xEA2F,0xE499,0xE1D5,0xE373,0xE90A,0xF1A3,
	0xFA9A,0x0176,0x03EE,0x029D,0xFFE7,0xFD46,0xFCA8,0x0080,
	0x0858,0x104E,0x169B,0x188F,0x14B4,0x0E5E,0x096E,0x07B6,
	0x08FC,0x0BEE,0x0E8E,0x0E0C,0x0ABE,0x061F,0x0133,0xFCDA,
	0xF855,0xF5D2,0xF453,0xF347,0xF28D,0xF224,0xF18F,0xEFBF,
	0xECA7,0xE9FC,0xE7B2,0xE6C6,0xE772,0xEA02,0xEDDC,0xF0ED,
	0xF1F9,0xF168,0xF105,0xF174,0xF2C2,0xF4C9,0xF865,0xFCD8,
	0x016F,0x04B7,0x0690,0x05BE,0x0402,0x02F1,0x0364,0x05BD,
	0x096B,0x0C9B,0x0D5D,0x0C8D,0x0A26,0x07B1,0x050D,0x0379,
	0x02D8,0x0316,0x03A1,0x036B,0x01AA,0xFEEE,0xFC29,0xF8F4,
	0xF677,0xF4B2,0xF4B7,0xF597,0xF621,0xF557,0xF42A,0xF43A,
	0xF4F5,0xF45E,0xF363,0xF3BB,0xF3E5,0xF614,0xFA2B,0xFAA6,
	0xFC98,0xFCF7,0xFBB8,0xFB91,0xFC48,0xFB63,0xF658,0xEAA1,
	0xD884,0xC3A9,0xBF18,0xC083,0xC00E,0xD7B2,0xFD1D,0x1032,
	0x0582,0xDF65,0xC1A6,0xC226,0xBFA3,0xDAD0,0x1A7A,0x3B18,
	0x3DAF,0x3127,0x0AA7,0xEDCC,0xE928,0xFE25,0x272E,0x3F03,
	0x3E4A,0x3EAB,0x3F7F,0x32E1,0x182C,0x10AB,0x1D57,0x3442,
	0x3F71,0x3EC4,0x3DA4,0x2C0B,0x199B,0x0E86,0x07ED,0x0155,
	0xFAF3,0xF618,0xF506,0xF749,0xFA88,0xFACF,0xF438,0xE6BC,
	0xD6EF,0xCB1A,0xC836,0xD049,0xE090,0xF297,0xFE00,0xFFE3,
	0xF5F1,0xE432,0xD698,0xD70A,0xE811,0x0383,0x1D58,0x2B26,
	0x288F,0x1A30,0x0925,0xFF49,0x0307,0x1234,0x24DC,0x3316,
	0x3755,0x3131,0x2544,0x16ED,0x0C16,0x08EC,0x0D14,0x1400,
	0x17AD,0x15EF,0x0F0E,0x0596,0xFD47,0xF6BA,0xF1F9,0xEE1A,
	0xEA70,0xE7E2,0xE7A3,0xEA6A,0xEECA,0xF01B,0xECA0,0xE54B,
	0xDD94,0xDB44,0xDE80,0xE650,0xF149,0xFAAC,0xFFEC,0xFFEA,
	0xFB2B,0xF5B7,0xF400,0xF811,0x01BE,0x0DD7,0x185B,0x1E3E,
	0x1DAD,0x1707,0x0F22,0x0B02,0x0BD3,0x1116,0x17EE,0x1D27,
	0x1E98,0x1A4F,0x11F1,0x09D3,0x0463,0x01C2,0x0120,0x0200,
	0x0252,0x0124,0xFF05,0xFAFD,0xF613,0xF05D,0xEB72,0xE873,
	0xE8BC,0xEB10,0xEE30,0xF0CC,0xF248,0xF22F,0xEFAC,0xECFD,
	0xEB0A,0xEC24,0xEFE0,0xF5DB,0xFD09,0x02C8,0x04F1,0x02D7,
	0xFF24,0xFCFF,0xFE02,0x0270,0x093B,0x0F22,0x122A,0x1157,
	0x0DD3,0x0A20,0x07D8,0x06CD,0x0763,0x0850,0x0995,0x09A2,
	0x087A,0x05F3,0x01F1,0xFE2B,0xFACE,0xF885,0xF64E,0xF81D,
	0xF868,0xF68F,0xF58E,0xF4C0,0xF34E,0xF065,0xEDA4,0xEC40,
	0xED49,0xEFFD,0xF392,0xF6EF,0xF85F,0xF7CA,0xF60B,0xF4AE,
	0xF5D5,0xF875,0xFC72,0xFF7C,0x02A7,0x059A,0x06F1,0x053A,
	0x0272,0x01AA,0x037D,0x06F3,0x0A39,0x0B69,0x0A7F,0x085B,
	0x0612,0x04F9,0x04DB,0x04EC,0x0458,0x0292,0x0137,0x007B,
	0x000D,0xFEB1,0xFC4E,0xF9F8,0xF884,0xF77B,0xF6BD,0xF673,
	0xF562,0xF476,0xF45E,0xF65A,0xF815,0xF85B,0xF667,0xF3B1,
	0xF209,0xF36C,0xF7E1,0xFD92,0x0175,0x009F,0xFEEC,0xFD2C,
	0xFB06,0xF7C6,0xF42D,0xF02D,0xEBF1,0xE861,0xE7BA,0xECDF,
	0xF764,0x0227,0x069B,0x010F,0xF467,0xE792,0xE226,0xE885,
	0xFABE,0x0F3F,0x1AFB,0x19A1,0x0E66,0x001F,0xF720,0xF7E9,
	0x0234,0x1100,0x1D72,0x232D,0x1F82,0x15AA,0x0AF4,0x0393,
	0x0280,0x07CD,0x0FE5,0x1622,0x167E,0x10C3,0x092B,0x0365,
	0xFF51,0xFD8B,0xFE47,0xFDF4,0xFC3F,0xFB34,0xFB40,0xFC4D,
	0xFCA6,0xFB42,0xF7B2,0xF269,0xEDB3,0xEC39,0xEFA3,0xF588,
	0xFC52,0x00B0,0x00BF,0xFC0C,0xF4A7,0xEF24,0xF030,0xF832,
	0x0376,0x0C8C,0x0F2A,0x0AB1,0x031A,0xFCEA,0xFB6C,0xFF65,
	0x0706,0x0DAF,0x1062,0x0E6D,0x0AE4,0x06F9,0x0303,0x0036,
	0xFF13,0x0109,0x03E3,0x054A,0x0339,0xFF07,0xFB3A,0xF9E1,
	0xFA00,0xFA9D,0xF920,0xF66F,0xF435,0xF37D,0xF4A5,0xF6C8,
	0xF7C2,0xF5C5,0xF2AF,0xF012,0xEEBE,0xEF05,0xEFBA,0xF088,
	0xF0A9,0xF0DB,0xF0A5,0xF025,0xEF42,0xEE5D,0xEF2E,0xF3E4,
	0xF9DE,0xFED4,0x0071,0xFDE1,0xF948,0xF8DC,0xF7BB,0xF8ED,
	0xFD26,0xFEC4,0xFEE2,0xFE5C,0xFD0A,0xFBE4,0xFB17,0xFA12,
	0xF97F,0xF8A1,0xF7E5,0xF74D,0xF687,0xF580,0xF3E9,0xF32E,
	0xF281,0xF25C,0xF1C1,0xF159,0xF017,0xEF56,0xEE9C,0xEE53,
	0xEE38,0xED6F,0xECCF,0xEC85,0xEBE8,0xEB9E,0xEB41,0xEAA9,
	0xEAE0,0xEA7D,0xEAA1,0xEA52,0xEA2D,0xEA12,0xE98C,0xE945,
	0xE96A,0xE96A,0xE9AE,0xEA12,0xE9B6,0xE920,0xE8F5,0xE90A,
	0xE90B,0xE981,0xE97F,0xE987,0xE9A0,0xE9F6,0xEA45,0xE9F1,
	0xEA23,0xEA37,0xEA62,0xEA98,0xEACF,0xE94A,0xE843,0xE915,
	0xE9AD,0xE98F,0xEA6A,0xEAD5,0xEB34,0xEBBF,0xEBE2,0xEC52,
	0xEC9F,0xED73,0xEE44,0xEEAF,0xEF28,0xEFC9,0xF023,0xF088,
	0xF03E,0xF08B,0xF1EF,0xF304,0xF31D,0xF3AF,0xF406,0xF479,
	0xF4BE,0xF518,0xF5C9,0xF6C7,0xF6FF,0xF744,0xF7E6,0xF7AA,
	0xF7CF,0xF83D,0xF894,0xF928,0xF9EC,0xFA4E,0xFB01,0xFAD0,
	0xFB93,0xFC5B,0xFB94,0xFC23,0xFCBE,0xFD68,0xFE3E,0xFE7E,
	0xFEA2,0xFF3A,0x0008,0x0092,0x01B0,0x022F,0x02FC,0x03DC,
	0x0401,0x0412,0x04B8,0x04CF,0x04F2,0x04ED,0x0534,0x059C,
	0x0627,0x063E,0x0667,0x06DB,0x0782,0x0761,0x0781,0x080A,
	0x07EB,0x0751,0x0794,0x07FA,0x0844,0x0892,0x08B5,0x08CC,
	0x08B1,0x08F0,0x08DD,0x08D5,0x0922,0x0964,0x09A8,0x09E5,
	0x09E0,0x09F7,0x0A11,0x0A67,0x0ADB,0x0AE3,0x0AF4,0x0B18,
	0x0B39,0x0B86,0x0BC2,0x0BC8,0x0C2F,0x0C74,0x0C65,0x0C05,
	0x0C21,0x0C5D,0x0CD6,0x0CE7,0x0CF8,0x0CB0,0x0CB1,0x0C44,
	0x0CEF,0x0D30,0x0D9B,0x0D4F,0x0D9C,0x0CB0,0x0CBC,0x0E8E,
	0x0D64,0x0D69,0x0DAA,0x0E17,0x0E13,0x0D8A,0x0D98,0x0E3C,
	0x0E3B,0x0E3F,0x0EA3,0x0EAE,0x0E7E,0x0E23,0x0E19,0x0E9B,
	0x0F06,0x0EE2,0x0EEC,0x0E92,0x0E4B,0x0E44,0x0E4E,0x0E13,
	0x0E72,0x0E5A,0x0E37,0x0E5C,0x0E6E,0x0E7B,0x0E4A,0x0DF5,
	0x0DC1,0x0DD2,0x0E1D,0x0DC6,0x0D87,0x0D5B,0x0D15,0x0D1F,
	0x0D09,0x0D4C,0x0D56,0x0D01,0x0D26,0x0D23,0x0D05,0x0D1A,
	0x0D2E,0x0CE3,0x0C61,0x0C0E,0x0C33,0x0C84,0x0C29,0x0C10,
	0x0BF7,0x0BF6,0x0C31,0x0E49,0x0ED8,0x0E5A,0x0DEF,0x0D40,
	0x0CFC,0x0C8F,0x0C92,0x0D46,0x0D49,0x0D20,0x0C79,0x0C36,
	0x0C0B,0x0C04,0x0B77,0x0B91,0x0B89,0x0B4A,0x0AA5,0x0A6C,
	0x0B62,0x0B4E,0x0A3F,0x0A3C,0x0A7F,0x0A5B,0x0A03,0x099B,
	0x0991,0x09FB,0x09C4,0x09D1,0x098E,0x091A,0x095E,0x0955,
	0x093F,0x08E4,0x0893,0x0899,0x0883,0x08AA,0x089F,0x0858,
	0x06EA,0x070C,0x07D8,0x07D0,0x0828,0x07EB,0x07BB,0x07BD,
	0x0797,0x068E,0x0685,0x067C,0x05A1,0x0557,0x051C,0x04D2,
	0x0496,0x04A9,0x04B3,0x0485,0x03C7,0x035B,0x0335,0x03D5,
	0x040E,0x03FB,0x0402,0x0415,0x0404,0x03C1,0x0404,0x03F0,
	0x0373,0x030C,0x02EC,0x02BD,0x02F7,0x031A,0x0377,0x0367,
	0x02E1,0x02E6,0x02AF,0x02D1,0x02E3,0x028F,0x025E,0x02D8,
	0x02EF,0x02FE,0x02DE,0x02E8,0x02D5,0x0288,0x02AA,0x02D9,
	0x02B1,0x026F,0x0213,0x0250,0x0235,0x021A,0x021E,0x01EA,
	0x0143,0x0150,0x013E,0x0125,0x0110,0x0110,0x013B,0x015C,
	0x0111,0x0188,0x0212,0x0125,0x01B8,0x02B0,0x0074,0x0156,
	0x0195,0x016B,0x0160,0x011E,0x0099,0x0131,0x0148,0x0100,
	0x00F5,0x00B4,0x00CF,0x0130,0x0121,0x012B,0x00FA,0x0072,
	0xFE45,0xFEE3,0xFEC0,0xFEFB,0xFF07,0xFF47,0xFF00,0xFF37,
	0xFF47,0xFF4C,0xFED3,0xFF43,0xFF51,0xFEEF,0xFED4,0xFED1,
	0xFF31,0xFEEF,0xFF22,0xFF02,0xFF19,0xFE77,0xFE64,0xFEC2,
	0xFF6A,0xFF24,0xFF11,0xFF48,0xFF4F,0xFF50,0xFF27,0xFEC3,
	0xFE68,0xFF19,0xFF57,0xFF65,0xFF71,0xFFAC,0xFF29,0xFEFD,
	0xFF2E,0xFF6C,0xFFA5,0xFFF0,0xFFF0,0xFFAF,0xFFE7,0x0067,
	0x018C,0x019A,0x00B1,0x00E4,0x02E8,0x050E,0x0653,0x0631,
	0x0718,0x0955,0x0BD0,0x0C90,0x0CBC,0x0C82,0x0B5C,0x0B93,
	0x0D82,0x0E18,0x0E17,0x0CB5,0x0B28,0x0BAD,0x0E19,0x10BF,
	0x11D7,0x119D,0x1146,0x11DA,0x12AB,0x126A,0x1204,0x12B5,
	0x148D,0x1483,0x13CF,0x1473,0x159F,0x15F3,0x16C7,0x17C7,
	0x1756,0x1542,0x1272,0x1005,0x106F,0x12D9,0x155B,0x175E,
	0x184D,0x17A0,0x1552,0x10EB,0x0D31,0x0DB4,0x11FE,0x167B,
	0x1842,0x17ED,0x177F,0x14DF,0x1261,0x1164,0x11ED,0x1329,
	0x149F,0x1638,0x1835,0x18F0,0x1824,0x16F6,0x1582,0x155D,
	0x1664,0x176E,0x1806,0x18D0,0x1983,0x1A00,0x1AD6,0x1AAB,
	0x1885,0x15AF,0x1461,0x1563,0x1778,0x1985,0x19DF,0x1861,
	0x1589,0x125E,0x11F2,0x1336,0x1466,0x136A,0x1176,0x108F,
	0x114A,0x11DF,0x10B7,0x0E49,0x0BBA,0x09EA,0x09B0,0x0A2D,
	0x09C1,0x08C2,0x0736,0x05C8,0x05B7,0x0667,0x0564,0x0201,
	0xFE22,0xFCE7,0xFF11,0x0251,0x02EF,0x00B8,0xFE29,0xFBB8,
	0xF992,0xF96B,0xFA74,0xFBC2,0xFC76,0xFC3B,0xFB9A,0xFAFE,
	0xF954,0xF800,0xF746,0xF803,0xFA53,0xFC2D,0xFA42,0xF76C,
	0xF7CD,0xF6F9,0xF8B4,0xFA1C,0xF9B3,0xF883,0xF7A8,0xF738,
	0xF739,0xF809,0xF9F7,0xFB0F,0xFACC,0xF902,0xF7C5,0xF75C,
	0xF710,0xF6DE,0xF78F,0xF92C,0xF9EF,0xF941,0xF796,0xF668,
	0xF63C,0xF65D,0xF63A,0xF68C,0xF763,0xF747,0xF5B9,0xF455,
	0xF3CA,0xF52B,0xF59D,0xF45F,0xF1F1,0xF062,0xF148,0xF338,
	0xF45E,0xF398,0xF1CC,0xEFA0,0xEEE0,0xEEBD,0xEF8D,0xF090,
	0xF067,0xEFCB,0xEF2E,0xEEDC,0xEEC0,0xEEDD,0xECF6,0xEBDE,
	0xEC71,0xEE04,0xEF1F,0xEEBF,0xEFC9,0xEF65,0xEDFD,0xEE15,
	0xEF63,0xEFF7,0xEF52,0xEDE5,0xED98,0xEEC3,0xF008,0xF065,
	0xEFD4,0xEED7,0xEE82,0xEEBC,0xEF76,0xF002,0xF032,0xEF95,
	0xF016,0xF1EB,0xF202,0xF0E8,0xEFB7,0xEF5A,0xEF71,0xF131,
	0xF25E,0xF2D7,0xF225,0xF119,0xF097,0xF104,0xF15A,0xF11A,
	0xF0A2,0xF10F,0xF261,0xF35A,0xF289,0xF149,0xEFC9,0xEFCB,
	0xF169,0xF256,0xF266,0xF285,0xF154,0xF005,0xF075,0xF1EC,
	0xF2D9,0xF233,0xF0BF,0xEFD2,0xEFB5,0xEFD0,0xF0AF,0xF0FA,
	0xF06D,0xEFC8,0xEE28,0xEC3A,0xEBB6,0xED3C,0xEFCF,0xF192,
	0xF1E1,0xF0F8,0xEEC9,0xED06,0xECAD,0xEE3C,0xF0A0,0xF256,
	0xF2A1,0xF1C6,0xF113,0xF07C,0xEFFF,0xF013,0xF0D3,0xF203,
	0xF271,0xF1C5,0xEFBD,0xED46,0xE887,0xE0CB,0xD721,0xCEF3,
	0xCC1C,0xD0E1,0xDC5A,0xE8B7,0xED0E,0xE589,0xD546,0xC543,
	0xBED0,0xC44A,0xD2D2,0xE281,0xEC58,0xEDC2,0xE849,0xE083,
	0xDAB3,0xD9C1,0xDE8C,0xE7BD,0xF2D6,0xFBC1,0x0059,0x01C7,
	0x00E8,0x004E,0x01C7,0x05CF,0x08CC,0x0ADA,0x0EE2,0x11F1,
	0x1A45,0x2368,0x27BE,0x25E4,0x1FB8,0x18DD,0x1638,0x19A6,
	0x2170,0x2A7D,0x2F9F,0x2FD4,0x2AD3,0x23FF,0x1D27,0x188D,
	0x1664,0x186C,0x1D08,0x218B,0x21EA,0x1CDC,0x14F6,0x0D81,
	0x0823,0x058D,0x04D5,0x045A,0x0313,0x015A,0xFFD8,0xFE71,
	0xFC3B,0xF73E,0xF06A,0xEB18,0xE882,0xE8F7,0xEAA2,0xEBD6,
	0xEC86,0xEB69,0xE8C6,0xE44A,0xDF97,0xDCC7,0xDC5A,0xDF08,
	0xE3A7,0xE7AE,0xE95E,0xE903,0xE733,0xE54E,0xE488,0xE4F6,
	0xE681,0xEA39,0xEF24,0xF385,0xF610,0xF5CF,0xF3D4,0xF362,
	0xF410,0xF5A5,0xF87C,0xFC91,0x00AA,0x03E5,0x064F,0x073C,
	0x06FA,0x05EA,0x04F7,0x05C7,0x0856,0x0AD0,0x0CBC,0x0F0A,
	0x1083,0x0FD0,0x0EC3,0x0CD2,0x0A2F,0x0902,0x0A6A,0x0D04,
	0x0E29,0x0DDB,0x0C34,0x09DC,0x077D,0x05D4,0x046A,0x02F7,
	0x01B7,0x0149,0x011B,0x0023,0xFF2F,0xFDCA,0xFBBF,0xF8F0,
	0xF64E,0xF563,0xF55B,0xF3F0,0xF36B,0xF461,0xF53B,0xF39D,
	0xF063,0xED55,0xEC92,0xED8E,0xEF1F,0xF064,0xF17B,0xF2C3,
	0xF361,0xF265,0xF13F,0xF08D,0xF0A9,0xF1AD,0xF384,0xF5DD,
	0xF7C6,0xF7FF,0xF78A,0xF78F,0xF8BE,0xF9E8,0xFAC8,0xFBCA,
	0xFD32,0xFEFF,0x0086,0x00C1,0x018A,0x02C8,0x03D8,0x0452,
	0x04DA,0x05E4,0x0606,0x0644,0x073F,0x095D,0x0AD3,0x0A8D,
	0x089D,0x070B,0x0741,0x088D,0x0983,0x0922,0x0875,0x080F,
	0x07B0,0x06F6,0x061F,0x053E,0x0416,0x03A3,0x0432,0x04DE,
	0x048E,0x02DF,0x00CD,0xFF19,0xFF4E,0xFF19,0xFE3A,0xFC42,
	0xFBB2,0xFCBA,0xFDB0,0xFCCA,0xFA76,0xF7FC,0xF566,0xF781,
	0xFA0A,0xFA18,0xF972,0xF7CA,0xF588,0xF56E,0xF77B,0xF940,
	0xF9E0,0xF8B5,0xF7DA,0xF825,0xF81A,0xF7D2,0xF7BD,0xF8E2,
	0xFADE,0xFD14,0xFE05,0xFCDD,0xF9CA,0xF58A,0xF0B1,0xEAF4,
	0xE353,0xD920,0xCFD5,0xCD45,0xD533,0xE56A,0xF440,0xF624,
	0xE8B8,0xD29D,0xC2FC,0xBFD3,0xC9E1,0xDE8D,0xF00D,0xF7A8,
	0xF660,0xEFCA,0xE774,0xE231,0xE28B,0xE970,0xF5E6,0x0401,
	0x0D95,0x1172,0x10E8,0x0FE6,0x10FA,0x15F8,0x1A94,0x1CCF,
	0x1D21,0x1F4B,0x2778,0x352D,0x3F8E,0x4023,0x3E66,0x333E,
	0x2A14,0x2943,0x3059,0x3B98,0x3FDC,0x3F7D,0x3FC1,0x3EB6,
	0x34F3,0x2AC8,0x25D2,0x26CC,0x2D2E,0x3392,0x34DE,0x2E4E,
	0x2418,0x1AE2,0x151C,0x12FA,0x11D0,0x0EBB,0x0A54,0x057F,
	0x0258,0x01AD,0x018E,0xFF81,0xF97E,0xEFFA,0xE7A4,0xE3D0,
	0xE3DC,0xE6AD,0xE9F2,0xEC21,0xEA39,0xE448,0xDCEF,0xD79A,
	0xD530,0xD66A,0xDC31,0xE3DC,0xE7ED,0xE85E,0xE568,0xE13C,
	0xDF68,0xE0A2,0xE49C,0xE964,0xED8E,0xF083,0xF2A1,0xF3C9,
	0xF53F,0xF777,0xF894,0xF908,0xFB2C,0xFEA9,0x02DA,0x0662,
	0x091A,0x0B11,0x0D47,0x0ED7,0x0E82,0x0CEB,0x0C01,0x0D8A,
	0x1185,0x15C1,0x18B3,0x190F,0x172A,0x13D9,0x10C3,0x0F8E,
	0x10C6,0x126A,0x132F,0x12E8,0x119F,0x0F9A,0x0C8B,0x093C,
	0x0751,0x0646,0x0474,0x0204,0x0059,0xFFBD,0xFF36,0xFE30,
	0xFC67,0xF9DD,0xF63C,0xF28E,0xEFD6,0xEEF5,0xF009,0xF1E3,
	0xF2F6,0xF1E6,0xEDA9,0xE9A9,0xE69B,0xE661,0xE7F1,0xEB08,
	0xED7F,0xEE0D,0xECFE,0xEB24,0xE8BA,0xEA68,0xEBDF,0xEC8C,
	0xEFE8,0xF20B,0xF346,0xF2FB,0xF33B,0xF433,0xF6C0,0xF940,
	0xFADB,0xFBA7,0xFC6D,0xFCDA,0xFDCB,0x003D,0x02F4,0x05F0,
	0x0663,0x05CB,0x0552,0x05D8,0x063E,0x0798,0x0A10,0x0CBD,
	0x0D8F,0x0C5A,0x0AF6,0x0A39,0x0A5C,0x0A98,0x0B3A,0x0BDD,
	0x0CB0,0x0BB4,0x0A35,0x0927,0x08EC,0x090F,0x0842,0x075B,
	0x05FF,0x0408,0x02BE,0x029D,0x0375,0x03C6,0x028F,0xFF61,
	0xFC5D,0xFABE,0xFBA3,0xFD19,0xFD2D,0xFB64,0xF861,0xF6F6,
	0xF713,0xF7C5,0xF739,0xF5F7,0xF4A9,0xF390,0xF3AD,0xF533,
	0xF4DF,0xF384,0xF26E,0xF369,0xF5D7,0xF7D5,0xF7D6,0xF693,
	0xF602,0xF77D,0xF9F0,0xFB5D,0xFB7E,0xFAEF,0xFB22,0xFC9D,
	0xFBC0,0xF8EA,0xF408,0xEB27,0xDFEE,0xD61B,0xD164,0xD359,
	0xDCBD,0xEAC9,0xF577,0xF5A8,0xE855,0xD369,0xC311,0xC0B2,
	0xCD91,0xE47F,0xF793,0xFF30,0xFB0A,0xF04F,0xE63B,0xE21A,
	0xE769,0xF2DA,0xFE0F,0x080C,0x0FA5,0x1413,0x15B7,0x1529,
	0x148A,0x15EB,0x195D,0x1D5A,0x217C,0x271E,0x2FE4,0x398D,
	0x3FC0,0x403C,0x3BC6,0x3365,0x2C4D,0x2BDC,0x32B6,0x3D88,
	0x40A5,0x405B,0x40A7,0x3BE1,0x3167,0x2A67,0x281A,0x2937,
	0x2C88,0x2F88,0x2F63,0x2BA3,0x25F0,0x1E7F,0x16D2,0x10E0,
	0x0D56,0x0AC5,0x090C,0x0759,0x0591,0x03F5,0x014B,0xFBD5,
	0xF454,0xED6A,0xE8FC,0xE68C,0xE614,0xE839,0xEBC0,0xED08,
	0xEA19,0xE38E,0xDD6E,0xD9FB,0xD9B8,0xDC7B,0xE143,0xE621,
	0xE8A0,0xE7D0,0xE570,0xE347,0xE350,0xE4AB,0xE72D,0xEA9E,
	0xEF1C,0xF2F9,0xF60D,0xF7C0,0xFA34,0xFB4E,0xFC01,0xFE60,
	0xFD58,0xFE1C,0x0286,0x0885,0x0DE3,0x1169,0x11CC,0x1010,
	0x0DE1,0x0D11,0x0E53,0x11DB,0x15F6,0x187D,0x19A2,0x190D,
	0x179D,0x1604,0x13BE,0x11C1,0x110D,0x11C2,0x137C,0x1409,
	0x12E6,0x101B,0x0CFB,0x09B0,0x06A3,0x04DF,0x03E4,0x02F2,
	0x01C8,0x0189,0x0127,0xFF04,0xFBC8,0xF7BC,0xF46C,0xF2F0,
	0xF282,0xF242,0xF2A8,0xF21C,0xF0EB,0xEE6F,0xECF1,0xEBEF,
	0xEB30,0xEA63,0xE9F2,0xEA61,0xEAD2,0xEBC1,0xEC9C,0xED2A,
	0xED27,0xECFF,0xED74,0xEFE3,0xF1BD,0xF2BC,0xF4AA,0xF71C,
	0xF8AB,0xF955,0xF9E6,0xFB61,0xFC27,0xFBBD,0xFC24,0xFE5D,
	0x02D3,0x0702,0x0889,0x06C0,0x047E,0x042A,0x05C4,0x0812,
	0x0A3C,0x0B08,0x0B9A,0x0C95,0x0C97,0x0B5B,0x0AD1,0x0AD2,
	0x0AF3,0x0B80,0x0C44,0x0CFC,0x0BDD,0x0969,0x082E,0x0882,
	0x0995,0x08CE,0x063F,0x03E3,0x02B6,0x02A6,0x0344,0x0335,
	0x0149,0xFEAF,0xFDE1,0xFCAB,0xFC04,0xFB59,0xFA92,0xFA18,
	0xF945,0xF92F,0xF8AF,0xF749,0xF4B0,0xF21F,0xF0A5,0xF150,
	0xF43A,0xF5AC,0xF52B,0xF2D8,0xF0B4,0xF050,0xF16E,0xF387,
	0xF4FA,0xF485,0xF3AF,0xF3D3,0xF560,0xF735,0xF7EB,0xF707,
	0xF60A,0xF790,0xFA56,0xFBA0,0xF9D7,0xF555,0xEED8,0xE622,
	0xDB59,0xD11A,0xCBB3,0xCFA3,0xDCE1,0xEDA1,0xF78F,0xF239,
	0xDE53,0xC6AB,0xBED4,0xC121,0xD284,0xE950,0xF783,0xF9F3,
	0xF2B5,0xE8AC,0xE0FD,0xDEC3,0xE388,0xEEB2,0xFCA0,0x082B,
	0x0EB8,0x0F4D,0x0D78,0x0D31,0x103A,0x1535,0x19CA,0x1BA1,
	0x1BFE,0x20D5,0x2A97,0x3546,0x3CC4,0x3EE9,0x35C7,0x2CAA,
	0x270B,0x27D5,0x309E,0x3BDD,0x3F03,0x3E92,0x3EFC,0x38CA,
	0x2E39,0x25AB,0x228D,0x258E,0x2C78,0x31A2,0x3113,0x2AB9,
	0x2071,0x16BF,0x105A,0x0DF0,0x0D86,0x0C14,0x084B,0x0502,
	0x03BB,0x02C5,0xFFE4,0xFA0B,0xF29B,0xEC6A,0xE826,0xE629,
	0xE640,0xE83F,0xEAF7,0xEB9F,0xE88F,0xE38A,0xDE58,0xD984,
	0xD75A,0xD95F,0xDF69,0xE6FE,0xEAFB,0xE989,0xE533,0xE209,
	0xE17E,0xE342,0xE5AE,0xE9FC,0xEF88,0xF4F6,0xF805,0xF8B8,
	0xF844,0xF88B,0xF9BB,0xFBD3,0xFE5A,0xFF99,0x0318,0x0641,
	0x092C,0x0CDB,0x1022,0x101D,0x0CD8,0x097E,0x098D,0x0CF1,
	0x1281,0x1772,0x19A3,0x1828,0x13E0,0x0F9B,0x0E4E,0x0E97,
	0x0F29,0x10F6,0x1306,0x13AE,0x1190,0x0E1E,0x0A26,0x0718,
	0x05A6,0x0542,0x051B,0x0415,0x01E0,0xFF35,0xFCBD,0xFC46,
	0xFBCC,0xFA3B,0xF6A7,0xF2C2,0xF0CF,0xF021,0xF0D2,0xF168,
	0xF2D5,0xF251,0xEEF4,0xEBD3,0xE901,0xE7F0,0xE857,0xEAF4,
	0xEE6F,0xF0AC,0xEFF1,0xEDA0,0xEC17,0xEBC4,0xED8F,0xF04D,
	0xF2B8,0xF592,0xF7E2,0xF83D,0xF768,0xF797,0xF923,0xFA2C,
	0xFB50,0xFD17,0xFFD5,0x02D7,0x041F,0x0443,0x048A,0x057C,
	0x063D,0x070B,0x07EE,0x0933,0x0AD6,0x0C1A,0x0D56,0x0DBA,
	0x0D3F,0x0BFC,0x0B32,0x0C0C,0x0C6A,0x0C49,0x0BFF,0x0C15,
	0x0C93,0x0BFA,0x09CF,0x078C,0x06C5,0x06D7,0x0651,0x04F2,
	0x049A,0x0559,0x050D,0x0267,0xFFF9,0xFF3B,0xFEE8,0xFE27,
	0xFCA4,0xFBF4,0xFBB8,0xFC14,0xFB3E,0xFA16,0xF91D,0xF7C1,
	0xF5EB,0xF473,0xF51F,0xF734,0xF958,0xF6FA,0xF6E8,0xF5DE,
	0xF385,0xF3A7,0xF519,0xF692,0xF77E,0xF7FB,0xF856,0xF83B,
	0xF83E,0xF8B9,0xF914,0xF97D,0xFA2C,0xFC30,0xFD63,0xFBD1,
	0xF5D1,0xECF4,0xE2AE,0xD900,0xD1E3,0xCFA6,0xD505,0xE259,
	0xF0F6,0xF743,0xEF8D,0xDC4D,0xC864,0xBFD4,0xC4DA,0xD8F5,
	0xEEE6,0xFC60,0xFCE8,0xF371,0xE881,0xE2AB,0xE345,0xE96B,
	0xF3E7,0x00AC,0x0BC7,0x1231,0x14B0,0x1486,0x1402,0x14B8,
	0x16A1,0x1953,0x1CF0,0x21AA,0x28F8,0x327B,0x3B30,0x3EB6,
	0x3E83,0x360E,0x2C90,0x29D8,0x2CFA,0x37FB,0x4028,0x3FDF,
	0x3FA6,0x3FEB,0x3826,0x2C8E,0x262F,0x258A,0x2929,0x2F07,
	0x32DE,0x319A,0x29E2,0x1EB1,0x1533,0x0FD4,0x0E3E,0x0DDC,
	0x0BA3,0x06EC,0x0320,0x01CD,0x0096,0xFDDC,0xF8AF,0xF0AE,
	0xE855,0xE2E6,0xE229,0xE4E5,0xE806,0xE980,0xE8CD,0xE4E6,
	0xE01A,0xDA10,0xD526,0xD3E9,0xD7B9,0xDEDC,0xE5FC,0xE8A7,
	0xE58D,0xE1CC,0xDEF4,0xDE63,0xE1F2,0xE6C9,0xEAFE,0xEE4C,
	0xF228,0xF615,0xF8C1,0xF897,0xF717,0xF6D5,0xF854,0xFB4D,
	0xFFC3,0x0360,0x069B,0x09A0,0x0C7D,0x0E70,0x0E09,0x0BC9,
	0x090B,0x0944,0x0D51,0x1401,0x187C,0x1849,0x14F7,0x115C,
	0x0EF1,0x0E36,0x0E36,0x0EB6,0x0F84,0x104D,0x0FE1,0x0E30,
	0x0B7D,0x07B7,0x04EB,0x0311,0x0284,0x0106,0xFF13,0xFD60,
	0xFCA7,0xFD33,0xFC58,0xF81D,0xF2C1,0xEF44,0xEE36,0xEEA1,
	0xEF79,0xEFAD,0xEF6F,0xEDFC,0xEB5C,0xE90C,0xE751,0xE60F,
	0xE64B,0xE70E,0xE930,0xEBCD,0xEC43,0xEA87,0xE8F8,0xE8F3,
	0xEB75,0xED81,0xEDBD,0xED3E,0xF080,0xF219,0xF312,0xF5DA,
	0xF6F0,0xF84C,0xF90D,0xF98C,0xFA8C,0xFCB7,0xFE7C,0xFFF8,
	0x011A,0x0382,0x05A6,0x061C,0x0524,0x043F,0x051A,0x06AA,
	0x08CE,0x0A53,0x0BAC,0x0B2D,0x09EC,0x0958,0x09D9,0x09D6,
	0x0895,0x0737,0x07E3,0x0A07,0x0B45,0x0A33,0x0721,0x0488,
	0x02FA,0x02D5,0x02DC,0x02B2,0x01A1,0x0077,0xFF7E,0xFED7,
	0xFE5A,0xFCC8,0xFAB2,0xF92F,0xF8AB,0xF844,0xF875,0xF90C,
	0xF833,0xF69D,0xF4D9,0xF44D,0xF4D1,0xF552,0xF518,0xF402,
	0xF3BC,0xF4F7,0xF5D6,0xF53C,0xF24C,0xF08B,0xF1C3,0xF396,
	0xF52B,0xF5B3,0xF63B,0xF6F4,0xF771,0xF7A0,0xF883,0xFA58,
	0xFB08,0xFACE,0xFA2B,0xF81A,0xF3EE,0xEC42,0xE26D,0xD6DF,
	0xCED9,0xCEC3,0xD7B1,0xE6B1,0xF43C,0xF6A5,0xE9A5,0xD3AA,
	0xC33E,0xBFF1,0xC8D2,0xDE82,0xF259,0xFCF2,0xFAEE,0xF0C5,
	0xE5A5,0xE073,0xE2BD,0xEC9B,0xF9F0,0x06B9,0x0F3C,0x12B7,
	0x12A5,0x1050,0x1144,0x153E,0x1938,0x1BD6,0x1D95,0x2169,
	0x2966,0x33E8,0x3C22,0x3F2D,0x3B79,0x3394,0x2D54,0x2BC4,
	0x3030,0x3A26,0x40A7,0x4040,0x40A2,0x3F23,0x352A,0x29EA,
	0x23E1,0x25BE,0x2C61,0x3281,0x3329,0x2DA3,0x247D,0x1B71,
	0x14C3,0x10C6,0x0F48,0x0D99,0x0B49,0x083A,0x061B,0x0455,
	0x01F1,0xFD74,0xF696,0xEFCE,0xE9BA,0xE58C,0xE4DE,0xE7F1,
	0xEC57,0xEE9D,0xEBC1,0xE50B,0xDD98,0xD7E0,0xD620,0xD980,
	0xE0D1,0xE760,0xEA3C,0xE8EB,0xE572,0xE286,0xE147,0xE26D,
	0xE6D1,0xECA5,0xF236,0xF573,0xF57F,0xF4E7,0xF5BA,0xF941,
	0xFCEB,0xFED0,0xFFB7,0x0115,0x026C,0x051F,0x0BDB,0x0FD4,
	0x11E6,0x11FD,0x0F61,0x0CBC,0x0C33,0x0EF6,0x141E,0x19AC,
	0x1C88,0x1BB7,0x183E,0x1393,0x105B,0x0FF7,0x11F2,0x141E,
	0x162A,0x1622,0x13AB,0x1021,0x0CE0,0x0A65,0x08CC,0x0764,
	0x0631,0x0539,0x03E7,0x0283,0x0159,0x0029,0xFE10,0xFAAB,
	0xF6B7,0xF393,0xF24A,0xF2B3,0xF39A,0xF493,0xF447,0xF128,
	0xED2A,0xEA85,0xE9F3,0xEA5A,0xEB41,0xEC95,0xEDD4,0xEE06,
	0xED5B,0xEC2F,0xEBBF,0xEC82,0xED67,0xEF08,0xEF83,0xF01A,
	0xF18F,0xF48A,0xF973,0xFBD7,0xFB68,0xFAA2,0xF9DC,0xFA42,
	0xFC62,0xFF0B,0x0228,0x0528,0x06A7,0x0709,0x062B,0x047D,
	0x0460,0x05C5,0x0878,0x0B0A,0x0C49,0x0BDB,0x0B1D,0x0B77,
	0x0AC5,0x09DB,0x0A5B,0x0B1E,0x0B2E,0x0B4B,0x0AD5,0x0A13,
	0x08CB,0x06EA,0x05E7,0x06B5,0x0708,0x0601,0x0373,0x00EA,
	0xFFD9,0x0062,0x0104,0x006A,0xFEB4,0xFC8F,0xFB3F,0xF91B,
	0xF763,0xF851,0xF96F,0xF9AB,0xF927,0xF761,0xF56A,0xF3E3,
	0xF387,0xF35F,0xF362,0xF300,0xF254,0xF176,0xF179,0xF30E,
	0xF3B8,0xF30B,0xF1B4,0xF12D,0xF1FB,0xF389,0xF527,0xF5C6,
	0xF674,0xF72D,0xF76E,0xF776,0xF7A2,0xF835,0xF856,0xF61D,
	0xF04B,0xE70E,0xDB28,0xCFFE,0xCA86,0xCE09,0xDA7A,0xEA47,
	0xF39A,0xF05B,0xE02D,0xCAC5,0xBF68,0xBF5C,0xCB2E,0xE307,
	0xF552,0xFB78,0xF4DE,0xE8DA,0xDF50,0xDCFD,0xE292,0xEE26,
	0xFB80,0x0656,0x0C69,0x0E20,0x0DFA,0x0ECD,0x10BC,0x13C2,
	0x1723,0x19E7,0x1CB5,0x20B8,0x2852,0x325F,0x3AF7,0x3DA9,
	0x38CA,0x2F34,0x2634,0x24D0,0x2DE1,0x390C,0x3F0F,0x3E87,
	0x3EF0,0x37E7,0x2B43,0x2382,0x21D3,0x2548,0x2B50,0x2FD1,
	0x2FFD,0x2AEA,0x2136,0x1733,0x0F63,0x0B88,0x0A51,0x0A96,
	0x09C5,0x06E0,0x0301,0xFF4D,0xFCC7,0xF9B6,0xF413,0xEC4E,
	0xE549,0xE2B0,0xE4AC,0xE879,0xEA97,0xE986,0xE617,0xE16A,
	0xDBC6,0xD706,0xD62B,0xD8FB,0xDE4E,0xE40B,0xE787,0xE752,
	0xE436,0xE0AA,0xDF44,0xE0C1,0xE4F7,0xE9D4,0xEE64,0xF23A,
	0xF4FA,0xF6C8,0xF70A,0xF7D6,0xF981,0xFB53,0xFD25,0xFEF7,
	0x02AE,0x0825,0x0D22,0x0F01,0x0D77,0x0C56,0x0B0F,0x0A23,
	0x0B47,0x0ED9,0x13C1,0x1829,0x1A0A,0x1891,0x150D,0x112C,
	0x0ED9,0x0F0F,0x1131,0x13AD,0x145B,0x12AD,0x0F67,0x0C44,
	0x0B6E,0x0A88,0x083D,0x0526,0x02A6,0x019C,0x010C,0x00E5,
	0x003C,0xFE0F,0xFBAB,0xF904,0xF653,0xF366,0xF15D,0xEFE5,
	0xF117,0xF266,0xF2BC,0xF0AF,0xED2A,0xEA8B,0xE959,0xEA82,
	0xEAB7,0xEACB,0xEC21,0xED81,0xEE56,0xED6E,0xEC6A,0xEBF6,
	0xEC3D,0xED9F,0xF0B9,0xF3BA,0xF50D,0xF5CD,0xF77B,0xF975,
	0xFAA3,0xFA9D,0xFA17,0xFA7C,0xFD5E,0x018D,0x04E6,0x05FA,
	0x04D0,0x034F,0x0389,0x05A8,0x0881,0x0A7A,0x0B3B,0x0B02,
	0x0B50,0x0C9E,0x0CD1,0x0C18,0x0AB6,0x0A71,0x0B0D,0x0C68,
	0x0D0C,0x0C17,0x0AB8,0x0A5A,0x0A27,0x09F6,0x08D2,0x06A8,
	0x0453,0x0309,0x040C,0x05DC,0x05A3,0x03B8,0x0102,0xFF2A,
	0xFE9C,0xFDA9,0xFC0B,0xFB0A,0xFB6E,0xFC59,0xFC40,0xFAAE,
	0xF91C,0xF708,0xF622,0xF59C,0xF5EB,0xF606,0xF66B,0xF6B7,
	0xF6A4,0xF6E8,0xF6E0,0xF63F,0xF307,0xF426,0xF67A,0xF7BE,
	0xF982,0xF9D7,0xF982,0xF914,0xF97A,0xFA66,0xFB24,0xFC1E,
	0xFCB2,0xFC46,0xFB27,0xF8EA,0xF546,0xF0F2,0xED03,0xEC03,
	0xEEB6,0xF41C,0xFA0C,0xFD45,0xFB91,0xF516,0xECC2,0xE7BC,
	0xE9D8,0xF0F7,0xF8D5,0xFE5F,0x009D,0xFF96,0xFCB6,0xF95A,
	0xF797,0xF8A2,0xFC57,0x011E,0x05AA,0x0996,0x0C33,0x0CA8,
	0x0AFA,0x0A32,0x0AAE,0x0B43,0x0BBF,0x0D0B,0x101F,0x14B4,
	0x181B,0x198C,0x1932,0x1709,0x12F5,0x1012,0x1003,0x134D,
	0x17D8,0x1B07,0x1CEF,0x1B29,0x17E4,0x13B0,0x0F15,0x0C9D,
	0x0D0A,0x0F50,0x1125,0x1207,0x10BA,0x0CED,0x07ED,0x03BB,
	0x01C7,0x01DD,0x0242,0x01C1,0x00AC,0xFF43,0xFEE7,0xFE10,
	0xFBE6,0xF988,0xF711,0xF325,0xF114,0xF29D,0xF5B4,0xF75F,
	0xF6D4,0xF4F2,0xF272,0xF031,0xEE9C,0xEE03,0xEE95,0xF12B,
	0xF45F,0xF65C,0xF65A,0xF515,0xF3A0,0xF3A9,0xF33F,0xF2D2,
	0xF5DB,0xF9B3,0xFBB7,0xFC52,0xFCDB,0xFD74,0xFCC5,0xFBF0,
	0xFBD4,0xFDAD,0xFFC1,0x0109,0x01D2,0x0275,0x0312,0x03D5,
	0x0395,0x0259,0x01B7,0x01B6,0x02EA,0x04C5,0x0692,0x077A,
	0x071D,0x05D2,0x0414,0x0224,0x01B8,0x0216,0x0383,0x04A1,
	0x0507,0x0432,0x0211,0x0025,0xFF2D,0xFF0F,0xFE81,0xFC49,
	0xFADC,0xFBFC,0xFE44,0xFE55,0xFC65,0xFA2D,0xF86F,0xF69E,
	0xF4F7,0xF520,0xF6B6,0xF7FD,0xF85E,0xF822,0xF7AE,0xF632,
	0xF301,0xF024,0xF08C,0xF3EA,0xF790,0xF923,0xF76D,0xF515,
	0xF35C,0xF354,0xF432,0xF56D,0xF6B0,0xF86F,0xF906,0xF97D,
	0xFAAE,0xFB2B,0xF9F6,0xFAE1,0xFA93,0xFA79,0xFD36,0xFD8C,
	0xFDEB,0xFE9B,0xFFEA,0x0104,0x023A,0x01DA,0x00D7,0xFF6A,
	0xFEBC,0x0085,0x037A,0x0594,0x0570,0x0444,0x0360,0x035E,
	0x02FF,0x0245,0x00DB,0x00CA,0x01E3,0x02F6,0x0307,0x0179,
	0xFF53,0xFDA4,0xFCCE,0xFC7B,0xFCC5,0xFC6C,0xFBBF,0xFB19,
	0xFA2E,0xF928,0xF831,0xF898,0xF94F,0xFA4A,0xFAB0,0xFADF,
	0xFB37,0xFAFC,0xF9E0,0xF8C5,0xF7DE,0xF8BB,0xF9DE,0xFA20,
	0xF96A,0xF7FC,0xF726,0xF6EA,0xF68B,0xF5D1,0xF52A,0xF483,
	0xF3F2,0xF2FE,0xF1F8,0xEF8E,0xEE67,0xEEF5,0xEE81,0xEE28,
	0xED87,0xEC7D,0xEBA4,0xEB2E,0xEAF7,0xEAFD,0xEAEB,0xEA6C,
	0xE9F2,0xE95E,0xE8D5,0xE817,0xE81E,0xE863,0xE756,0xE6F1,
	0xE7AE,0xE7FF,0xE765,0xE6CA,0xE6E0,0xE6D7,0xE6E5,0xE711,
	0xE6C0,0xE698,0xE685,0xE6DC,0xE6D2,0xE6BC,0xE69B,0xE6C0,
	0xE6F7,0xE735,0xE759,0xE765,0xE7E7,0xE83E,0xE88D,0xE992,
	0xE8ED,0xE867,0xE878,0xE8E7,0xE95B,0xE9C0,0xEA3E,0xEA91,
	0xEACA,0xEBBD,0xECF4,0xED9D,0xEE3F,0xEF3C,0xEFB6,0xEFF3,
	0xF061,0xF100,0xF16F,0xF1E5,0xF298,0xF35A,0xF3E9,0xF46A,
	0xF4A7,0xF4EF,0xF562,0xF5F6,0xF5F4,0xF5D8,0xF5F2,0xF662,
	0xF697,0xF721,0xF767,0xF7A8,0xF855,0xF8D8,0xF8F0,0xF942,
	0xFA20,0xFA61,0xFA3F,0xFA84,0xFB31,0xFB8A,0xFBD1,0xFBEF,
	0xFC6B,0xFC8D,0xFCF1,0xFD6E,0xFD9C,0xFE3D,0xFE7C,0xFEFC,
	0xFF4D,0xFFC2,0xFFE5,0x0054,0x00F7,0x012B,0x016F,0x01D1,
	0x027E,0x028C,0x0327,0x0373,0x03AA,0x03D7,0x045B,0x04A6,
	0x0520,0x05B9,0x0670,0x05F2,0x0559,0x07DE,0x0786,0x073B,
	0x07A7,0x07FF,0x085A,0x085C,0x089A,0x08FF,0x092C,0x09AD,
	0x099D,0x09B9,0x0A05,0x0A12,0x0A38,0x0A7D,0x0A71,0x0AA1,
	0x0AA2,0x0B0A,0x0B64,0x0BC9,0x0BB5,0x0B70,0x0B6C,0x0B7E,
	0x0BA0,0x0B9A,0x0BDA,0x0C5B,0x0C12,0x0C17,0x0C57,0x0C62,
	0x0C03,0x0C2E,0x0C18,0x0C3B,0x0C40,0x0CAA,0x0CB4,0x0C8C,
	0x0C77,0x0CD5,0x0D1E,0x0CDF,0x0D33,0x0D13,0x0D5C,0x0D53,
	0x0D3B,0x0D15,0x0D45,0x0D81,0x0D5F,0x0D85,0x0DCF,0x0E08,
	0x0E6F,0x1048,0x105F,0x0F8E,0x0FAB,0x0FA8,0x0FB5,0x0F7E,
	0x0F25,0x0F22,0x0EE8,0x0F1A,0x0F63,0x0F43,0x0F2D,0x0F22,
	0x0F15,0x0EBF,0x0E3F,0x0E7E,0x0E77,0x0DFB,0x0F25,0x0F17,
	0x0E54,0x0DF6,0x0E1C,0x0D80,0x0D93,0x0D77,0x0D70,0x0DCF,
	0x0DA8,0x0D48,0x0D3E,0x0D0E,0x0D2B,0x0D49,0x0D98,0x0DBC,
	0x0D01,0x0CD0,0x0CE0,0x0CBD,0x0D0F,0x0D0B,0x0BCE,0x0B22,
	0x0BE1,0x0C3E,0x0C26,0x0C37,0x0C4A,0x0C13,0x0BB0,0x0B3D,
	0x0ADB,0x0A79,0x09E2,0x097F,0x098D,0x08C8,0x0890,0x08E0,
	0x08EB,0x08D6,0x08A4,0x08C0,0x0885,0x081B,0x0825,0x0831,
	0x0855,0x08D1,0x08C8,0x08A7,0x0879,0x07F7,0x0824,0x0865,
	0x0893,0x0811,0x07FA,0x0816,0x07C2,0x07B6,0x07EA,0x0803,
	0x0824,0x080C,0x07E1,0x0766,0x073C,0x0777,0x07BC,0x0776,
	0x0773,0x079C,0x07DB,0x07CE,0x0732,0x0736,0x0712,0x069E,
	0x0665,0x065C,0x0669,0x069B,0x0663,0x0675,0x0623,0x05FA,
	0x05B4,0x0582,0x0504,0x0551,0x059D,0x05E4,0x055A,0x0547,
	0x0599,0x053F,0x050F,0x06BB,0x04BC,0x04FA,0x055B,0x0536,
	0x0527,0x04FC,0x053F,0x0510,0x0541,0x052A,0x0556,0x04B7,
	0x0467,0x0480,0x04CD,0x04B6,0x0452,0x0402,0x03F6,0x0452,
	0x0439,0x03C6,0x0370,0x03BE,0x0364,0x0387,0x0358,0x035C,
	0x034D,0x02F9,0x033D,0x034C,0x0349,0x0308,0x035A,0x02F3,
	0x031C,0x02E0,0x02D8,0x030E,0x0363,0x035C,0x037E,0x02D8,
	0x02B1,0x0304,0x0308,0x02CD,0x029F,0x02C8,0x0314,0x0306,
	0x02A1,0x02EE,0x02FD,0x026A,0x027F,0x02D2,0x02ED,0x0329,
	0x02F7,0x0289,0x0185,0xFF5F,0xFFAF,0xFFCE,0xFFBC,0xFFDA,
	0xFFB2,0xFF70,0xFF48,0xFFC6,0xFF9C,0xFF5B,0xFF44,0xFF7B,
	0xFF51,0xFFB3,0x005E,0x01A2,0x01E0,0x0187,0x0093,0x00CB,
	0x01DE,0x0350,0x04EA,0x0635,0x0623,0x048C,0x075A,0x083E,
	0x093D,0x0ADF,0x0BA2,0x0BAD,0x0BB5,0x0BCD,0x0C23,0x0C50,
	0x0D10,0x0D84,0x0D7A,0x0D1F,0x0C39,0x0B8B,0x0B7A,0x0C2D,
	0x0D78,0x0DD0,0x0DEE,0x0E19,0x0EA4,0x0E77,0x0E15,0x0E56,
	0x0F0C,0x0FFD,0x1071,0x1101,0x11B7,0x123D,0x1259,0x119C,
	0x11D8,0x1279,0x133F,0x13CB,0x1452,0x1556,0x15A1,0x14A3,
	0x139D,0x13A7,0x150A,0x16A3,0x1722,0x16CE,0x15A3,0x1496,
	0x13B6,0x1399,0x14CE,0x16F8,0x17C8,0x174C,0x161B,0x14DF,
	0x13C8,0x136F,0x1653,0x18DF,0x189A,0x17DA,0x16A9,0x1585,
	0x1539,0x1541,0x1458,0x13AC,0x13B2,0x13C4,0x13DA,0x13FD,
	0x1362,0x12CF,0x1198,0x104C,0x1039,0x0FED,0x0FC2,0x1017,
	0x0F2F,0x0DCC,0x0DB4,0x0EB8,0x0EB9,0x0E57,0x0C91,0x0A77,
	0x0946,0x097D,0x0AA2,0x0B94,0x0AA5,0x07AE,0x0333,0xFDBC,
	0xF941,0xF66A,0xF753,0xFAE1,0xFF4F,0x0404,0x05BA,0x0184,
	0xF8C5,0xF1B2,0xEDDC,0xEF74,0xF6F9,0xFFEE,0x0642,0x07D0,
	0x04A5,0xFEB4,0xF89E,0xF57E,0xF703,0xFC1E,0x0237,0x07A9,
	0x0ABD,0x0A54,0x077E,0x038D,0x00C6,0x0061,0x027E,0x05B1,
	0x0813,0x0A36,0x0B2C,0x0AD2,0x090C,0x06D7,0x0578,0x0444,
	0x02D0,0x01F1,0x0199,0x0226,0x031F,0x0324,0x023A,0x006B,
	0xFD8B,0xF9EF,0xF60D,0xF3A2,0xF380,0xF463,0xF5E1,0xF71A,
	0xF6DC,0xF4D1,0xF0C3,0xEC43,0xE97F,0xE860,0xE83A,0xEA25,
	0xEC8A,0xEF1C,0xEFF7,0xEE0C,0xEA7D,0xE69F,0xE467,0xE455,
	0xE650,0xE9DE,0xED76,0xEEED,0xEF46,0xEE7D,0xEDAC,0xEC71,
	0xEBA1,0xEC1B,0xED0F,0xEED5,0xF347,0xF3F1,0xF505,0xF627,
	0xF57C,0xF48E,0xF353,0xF260,0xF236,0xF35E,0xF53A,0xF71B,
	0xF8FB,0xFA30,0xF919,0xF664,0xF35F,0xF173,0xF112,0xF2F8,
	0xF5AE,0xF733,0xF6C9,0xF48E,0xF1CA,0xEF84,0xEE7C,0xEE4E,
	0xEEAF,0xEEFC,0xEEF9,0xEF19,0xEEF9,0xEE74,0xED1A,0xEBA4,
	0xEAEC,0xEA89,0xEAFD,0xEB60,0xEB3C,0xEA4A,0xEA0B,0xEABE,
	0xEC49,0xED7A,0xED4A,0xEC74,0xEB96,0xEB1C,0xEB89,0xEC8B,
	0xEDEA,0xEFF0,0xF0FA,0xF143,0xF115,0xF067,0xEFEF,0xEFD9,
	0xF0FF,0xF2EB,0xF4A3,0xF4A3,0xF1EB,0xF165,0xF1AC,0xF23C,
	0xF36C,0xF501,0xF66A,0xF5D9,0xF487,0xF40D,0xF4A0,0xF589,
	0xF61F,0xF63D,0xF6A3,0xF681,0xF5A5,0xF56B,0xF544,0xF486,
	0xF4A1,0xF4BA,0xF485,0xF539,0xF673,0xF5BE,0xF410,0xF243,
	0xF141,0xF20B,0xF313,0xF3B2,0xF4C9,0xF3EA,0xF2C2,0xF20E,
	0xF230,0xF320,0xF345,0xF32B,0xF31E,0xF35B,0xF3B7,0xF51A,
	0xF5CD,0xF4B9,0xF4D6,0xF541,0xF4D5,0xF55D,0xF64F,0xF699,
	0xF735,0xF739,0xF811,0xF92B,0xF9E1,0xFA41,0xFADA,0xFB02,
	0xFB75,0xFB7C,0xFB5A,0xFC27,0xFD02,0xFCC2,0xFC04,0xFC01,
	0xFCC2,0xFD69,0xFD8D,0xFCF4,0xFC57,0xFBFF,0xFBB5,0xFC49,
	0xFCF0,0xFD35,0xFCEC,0xFC1A,0xFB6C,0xFAB5,0xFA5D,0xFA4F,
	0xFA92,0xFAE0,0xFAE1,0xFAC6,0xFA99,0xFAE4,0xF8D5,0xF4FB,
	0xF01A,0xE9F9,0xE337,0xDBDA,0xD7AA,0xD891,0xDF2E,0xEA03,
	0xF3AA,0xF706,0xEFEC,0xE18B,0xD378,0xCC67,0xD0FC,0xDFBB,
	0xF1B0,0xFFF7,0x0676,0x03ED,0xFA82,0xEF60,0xE909,0xEA8E,
	0xF3F6,0x02B2,0x11FF,0x1CFF,0x1DF4,0x1A64,0x1354,0x0ACA,
	0x08EF,0x0D94,0x15FA,0x1E7D,0x23DA,0x25C5,0x24CF,0x21F7,
	0x1E8D,0x1B74,0x1990,0x17E4,0x163A,0x14BC,0x1420,0x150B,
	0x16AA,0x170A,0x14F5,0x102D,0x092B,0x01B8,0xFBB1,0xF896,
	0xF955,0xFC7C,0xFF92,0x00C4,0xFE3A,0xF7AD,0xEFE6,0xE8E6,
	0xE44D,0xE39B,0xE799,0xED92,0xF214,0xF36B,0xF0B1,0xEBB7,
	0xE6DE,0xE3A1,0xE38B,0xE692,0xEB85,0xF107,0xF500,0xF6D0,
	0xF718,0xF5EE,0xF44C,0xF3E9,0xF5AA,0xF965,0xFD7E,0x0115,
	0x045B,0x0775,0x0AE5,0x0AAF,0x0A2A,0x0A85,0x0B57,0x0BB3,
	0x0C03,0x0D78,0x0E7C,0x0EF5,0x0F9A,0x1028,0x1022,0x0E6E,
	0x0CC0,0x0B59,0x0A6A,0x08E7,0x07C7,0x0706,0x0818,0x0890,
	0x0719,0x03E5,0x003B,0xFC2C,0xF8EB,0xF834,0xF93E,0xFB12,
	0xFBA4,0xFA5B,0xF775,0xF471,0xF194,0xEF7A,0xEE73,0xEF69,
	0xF106,0xF2F6,0xF391,0xF264,0xF07E,0xF012,0xEF38,0xEEC6,
	0xF110,0xF2D3,0xF48B,0xF615,0xF6CC,0xF7BC,0xF8AA,0xF9F2,
	0xFB18,0xFB8D,0xFC4B,0xFD63,0xFDA2,0xFD9A,0xFDE1,0xFFFD,
	0x02B4,0x0527,0x0674,0x0658,0x044F,0x020A,0x014D,0x02B7,
	0x0546,0x086F,0x0A1D,0x09A2,0x06BA,0x0327,0x0038,0xFF1D,
	0xFF9D,0x016F,0x0359,0x03B0,0x0245,0x0016,0xFD7D,0xFB53,
	0xFA62,0xFA0F,0xFA17,0xFA99,0xFB11,0xFA9A,0xF979,0xF7BC,
	0xF6C2,0xF619,0xF598,0xF646,0xF6DE,0xF750,0xF6EB,0xF55B,
	0xF48A,0xF621,0xF7E8,0xF90B,0xF8C0,0xF824,0xF725,0xF690,
	0xF807,0xFAF0,0xFCF6,0xFDDA,0xFE6A,0xFF00,0xFE72,0xFE35,
	0xFE96,0xFFB9,0x004E,0x02CE,0x04FE,0x052B,0x06B2,0x04B5,
	0x02D6,0x0221,0x02D8,0x0402,0x05E0,0x0797,0x07F6,0x06D8,
	0x04F5,0x032C,0x0299,0x029D,0x027B,0x02A8,0x02E5,0x0377,
	0x03A5,0x024C,0x0057,0xFE9D,0xFDD4,0xFE85,0xFEE7,0xFF3B,
	0xFEE7,0xFD81,0xFA48,0xF5BE,0xEF4F,0xE7C6,0xDEF1,0xD662,
	0xD1B6,0xD44B,0xDE6C,0xEBFB,0xF5CC,0xF524,0xE9F6,0xD9A0,
	0xCBB8,0xC74D,0xD021,0xE305,0xF75D,0x0545,0x09DC,0x04EB,
	0xFA6D,0xF001,0xEAE1,0xEF21,0xFC18,0x0DEA,0x1E60,0x28E2,
	0x29B1,0x22FC,0x1891,0x0FE7,0x0F03,0x1819,0x23DB,0x2D67,
	0x3203,0x3139,0x2D5E,0x29A8,0x2797,0x25DB,0x241B,0x219B,
	0x1F10,0x1DF0,0x1DE3,0x1E96,0x1ED2,0x1DAB,0x1928,0x1316,
	0x0DA3,0x06F1,0xFF98,0xFB35,0xFA86,0xFD39,0x00F2,0x035F,
	0x0189,0xF978,0xEE18,0xE2F5,0xDE62,0xE14E,0xE83D,0xEFFC,
	0xF48F,0xF483,0xEFCF,0xE887,0xE2FE,0xE0F0,0xE352,0xE9C4,
	0xF006,0xF65A,0xFACD,0xFB88,0xF9B0,0xF705,0xF5BB,0xF811,
	0xFC66,0x018C,0x066C,0x09B3,0x0BD6,0x0E7E,0x1110,0x12EB,
	0x141C,0x1380,0x11F6,0x114E,0x129D,0x1578,0x183C,0x1A91,
	0x1C48,0x1CBF,0x1AB7,0x15B4,0x1039,0x0D3A,0x0C06,0x0DD1,
	0x1114,0x139B,0x13C1,0x0FC1,0x0878,0x0176,0xFD33,0xFBB2,
	0xFC58,0xFDE0,0xFF1A,0xFECA,0xFC2E,0xF8FA,0xF4C1,0xF0FA,
	0xEEA1,0xEDC7,0xEEEC,0xF0FB,0xF37A,0xF3BA,0xF2EB,0xF1F3,
	0xF0D0,0xF049,0xF0B5,0xF1B0,0xF23C,0xF30A,0xF504,0xF7D2,
	0xFA59,0xFBC6,0xFCBB,0xFCCD,0xFC83,0xFC4D,0xFD4A,0xFFB6,
	0x028D,0x0573,0x086E,0x0967,0x08CE,0x0AD6,0x08F6,0x072C,
	0x07EB,0x0993,0x0B7A,0x0DE8,0x0FB6,0x0FE3,0x0DBE,0x0ABF,
	0x0895,0x0744,0x0787,0x07E6,0x089C,0x095A,0x0928,0x078C,
	0x0538,0x02D3,0x0015,0xFE6E,0xFD47,0xFD6C,0xFE03,0xFE8F,
	0xFE05,0xFC1E,0xFA1F,0xF845,0xF656,0xF5D7,0xF6A9,0xF78F,
	0xF829,0xF795,0xF727,0xF650,0xF605,0xF642,0xF6D9,0xF73C,
	0xF75B,0xF7B8,0xF872,0xF9C3,0xFB06,0xFBA5,0xFBD8,0xFC4A,
	0xFD46,0xFE63,0xFEB9,0xFEB2,0xFF68,0x01A9,0x0400,0x0591,
	0x061A,0x075B,0x074F,0x0597,0x057D,0x06B0,0x0986,0x0AF9,
	0x0A6B,0x090D,0x07C5,0x06B3,0x05A7,0x0577,0x05DA,0x0699,
	0x05FB,0x05AA,0x0528,0x03F8,0x0222,0xFFE8,0xFF27,0xFF59,
	0xFF4E,0xFFD4,0xFFCD,0xFD76,0xFB2A,0xF9A2,0xF78B,0xF382,
	0xECA4,0xE3B0,0xDA2D,0xD20D,0xCF80,0xD539,0xE16F,0xEE65,
	0xF592,0xF1B4,0xE441,0xD2CA,0xC6A1,0xC682,0xD357,0xE807,
	0xFD77,0x09C6,0x0A36,0x01B4,0xF505,0xEB95,0xEA3E,0xF289,
	0x01FA,0x1428,0x2276,0x28DD,0x266F,0x1D50,0x14B6,0x10DB,
	0x155B,0x1E8B,0x27F8,0x2EAE,0x316F,0x30BE,0x2E82,0x2C26,
	0x2A7F,0x2809,0x24EB,0x2197,0x1EF1,0x1DA5,0x1E12,0x1FA9,
	0x20CE,0x202E,0x1BDF,0x13A3,0x09AA,0x0031,0xF9DC,0xF8DC,
	0xFC45,0x0224,0x0587,0x038C,0xFB25,0xEFC9,0xE500,0xDE5A,
	0xDDFD,0xE35B,0xEAE4,0xF008,0xF12F,0xEEEC,0xE993,0xE30E,
	0xDE89,0xDDEC,0xE194,0xE7C6,0xEE39,0xF373,0xF5D3,0xF5F3,
	0xF42C,0xF369,0xF42C,0xF71B,0xFAA2,0xFDDE,0x00BB,0x0449,
	0x07B1,0x0AB6,0x0DC4,0x1137,0x0ED2,0x0C97,0x0BC8,0x0C49,
	0x0F89,0x1361,0x1671,0x1830,0x186A,0x168F,0x132F,0x0F71,
	0x0C86,0x0AC4,0x0ABA,0x0BB0,0x0DB9,0x0F5B,0x0DB7,0x0989,
	0x034A,0xFDE8,0xFAD3,0xFA46,0xFAF4,0xFB93,0xFB9E,0xFA6F,
	0xF7B5,0xF3EC,0xF19C,0xF0D1,0xEFC2,0xEE24,0xEDA7,0xEDCA,
	0xEEA7,0xEED0,0xEEFE,0xEF6E,0xEFAB,0xF08D,0xF059,0xF02A,
	0xF077,0xF130,0xF2AA,0xF4E5,0xF837,0xFBE4,0xFE2F,0xFD56,
	0xFBBC,0xFB35,0xFC10,0xFEE6,0x025B,0x05EF,0x086E,0x090C,
	0x08E1,0x08B1,0x0790,0x059C,0x05FC,0x0799,0x094A,0x0A8A,
	0x0B18,0x0AF3,0x0A13,0x0899,0x073B,0x066D,0x060A,0x0578,
	0x0462,0x03B7,0x034E,0x029C,0x024C,0x0156,0xFED4,0xFD14,
	0xFAEF,0xF93B,0xF90E,0xF966,0xF98F,0xF9A5,0xF988,0xF837,
	0xF60F,0xF46C,0xF335,0xF3A8,0xF510,0xF611,0xF689,0xF66C,
	0xF518,0xF436,0xF3FB,0xF5A1,0xF739,0xF7F7,0xF9EC,0xFB95,
	0xFAB5,0xFAE2,0xFBA4,0xFC58,0xFDC0,0xFF89,0x00BF,0x01FB,
	0x02D9,0x0323,0x0422,0x0576,0x0662,0x07A6,0x07F0,0x07F8,
	0x07D2,0x0826,0x0867,0x08CE,0x08C5,0x07ED,0x07F8,0x08A2,
	0x0951,0x0956,0x081C,0x065C,0x04BE,0x041A,0x03C6,0x040D,
	0x041A,0x0341,0x0268,0x0138,0xFFC1,0xFEE3,0xFF01,0xFE72,
	0xFCD4,0xF91C,0xF2E3,0xEAF5,0xE223,0xDA81,0xD4FC,0xD483,
	0xDAD0,0xE61D,0xF16B,0xF61B,0xF086,0xE19E,0xD0D6,0xC80C,
	0xCC12,0xDB90,0xEFBC,0x009A,0x08F6,0x06B3,0xFCFB,0xF2B0,
	0xED83,0xF021,0xF99D,0x06EB,0x15F6,0x2234,0x2883,0x26C8,
	0x1F9A,0x18EA,0x1705,0x17E2,0x1FD5,0x29E6,0x3032,0x33BE,
	0x3298,0x2FDF,0x2D1E,0x2AA4,0x2765,0x22EB,0x1FD9,0x1F02,
	0x2016,0x2191,0x2218,0x21B4,0x1EAC,0x17FA,0x0F39,0x06E2,
	0x0082,0xFD01,0xFC20,0xFE0B,0x00E5,0x01F2,0xFF0F,0xF833,
	0xEEA0,0xE635,0xE130,0xE023,0xE314,0xE905,0xEDA0,0xEFCA,
	0xEE3D,0xE99F,0xE3F5,0xE04B,0xDFD3,0xE277,0xE7B4,0xEE0B,
	0xF362,0xF64D,0xF700,0xF661,0xF602,0xF674,0xF7F1,0xFABC,
	0xFE99,0x027C,0x06D6,0x0AB8,0x0DCC,0x1024,0x106F,0x0F6F,
	0x0F64,0x11F2,0x12A0,0x1406,0x1650,0x18FF,0x1AA1,0x1AB3,
	0x1942,0x1641,0x1255,0x0E3B,0x0BBF,0x0CA1,0x0ECE,0x1055,
	0x0FCE,0x0D78,0x0966,0x03CB,0xFE59,0xFBD1,0xFBC6,0xFB64,
	0xFB37,0xFB82,0xFAEB,0xF8FB,0xF5D9,0xF13E,0xEDEB,0xEC4F,
	0xEBE2,0xECF0,0xEEF9,0xF07D,0xF10C,0xF036,0xEDE7,0xEC4A,
	0xEC17,0xED0F,0xEEDE,0xF14A,0xF33A,0xF3DD,0xF38E,0xF4B6,
	0xF735,0xF9A7,0xFB98,0xFCA2,0xFD00,0xFD39,0xFE5E,0x004A,
	0x02D1,0x0528,0x064F,0x069E,0x05BD,0x04E1,0x04D0,0x0516,
	0x05C2,0x06C4,0x07F6,0x098E,0x0A1E,0x0A5B,0x088A,0x056C,
	0x02B8,0x017C,0x02B2,0x04A7,0x058D,0x04DB,0x028E,0xFFE4,
	0xFD0F,0xFB0F,0xFA74,0xFA7C,0xFA68,0xF98E,0xF8EC,0xF8C7,
	0xF7C2,0xF5EA,0xF397,0xF2AC,0xF2AE,0xF3D3,0xF4EF,0xF521,
	0xF4D8,0xF367,0xF198,0xF10A,0xF287,0xF525,0xF70B,0xF734,
	0xF6A0,0xF698,0xF6EA,0xF70A,0xF7B8,0xF8E2,0xFAE5,0xFC89,
	0xFDA3,0xFE53,0xFF0A,0xFF51,0xFF31,0xFF85,0x0106,0x0365,
	0x0570,0x052E,0x05B5,0x061E,0x03E1,0x04D6,0x0507,0x0578,
	0x05E2,0x0567,0x0473,0x03D9,0x03D0,0x043F,0x0406,0x036B,
	0x0338,0x0254,0x0110,0xFF53,0xFE03,0xFD8C,0xFE71,0xFF7D,
	0x0045,0xFF69,0xFD32,0xF9FB,0xF5CF,0xF201,0xEE4B,0xE89F,
	0xE012,0xD70A,0xD0A3,0xD158,0xD92F,0xE5E9,0xF17F,0xF4EB,
	0xEC38,0xDB77,0xCC27,0xC5DC,0xCD27,0xDE57,0xF2C6,0x02EA,
	0x09B6,0x0675,0xFBF2,0xF046,0xEA64,0xED7B,0xF9C3,0x0BA3,
	0x1DFC,0x29CB,0x2B79,0x2475,0x19BB,0x128C,0x139E,0x1B9C,
	0x26D0,0x2FD5,0x32C9,0x30C0,0x2E11,0x2B38,0x2923,0x27BC,
	0x2560,0x22B6,0x2066,0x1E75,0x1DA4,0x1DDA,0x1E73,0x1D9E,
	0x1ACC,0x1568,0x0E49,0x061B,0xFF67,0xFABA,0xF9AF,0xFCFC,
	0x0152,0x0380,0x013D,0xF997,0xEE08,0xE3CA,0xDE4A,0xDFDE,
	0xE6BD,0xEF3E,0xF48E,0xF3AD,0xEDF9,0xE63B,0xE045,0xDE56,
	0xE130,0xE75E,0xEF04,0xF58F,0xF966,0xF969,0xF834,0xF4DF,
	0xF31D,0xF519,0xFA20,0x014C,0x06FD,0x09BB,0x098B,0x09B9,
	0x0B77,0x0E6A,0x10AB,0x1284,0x1429,0x14AF,0x137C,0x1327,
	0x14A9,0x1761,0x1936,0x190F,0x1812,0x15C2,0x12AA,0x0E9D,
	0x0B2B,0x0AD4,0x0CBE,0x0EF4,0x0FD7,0x0DF0,0x097E,0x0357,
	0xFD2D,0xF9BA,0xF937,0xFA90,0xFC3B,0xFD30,0xFC03,0xF863,
	0xF385,0xEF27,0xEC56,0xEC36,0xEE1E,0xF05F,0xF1F7,0xF1FB,
	0xF085,0xEDFE,0xEBB1,0xEB46,0xED1A,0xEF25,0xF1D6,0xF3D6,
	0xF4A1,0xF46C,0xF4AB,0xF65B,0xF8E6,0xFBAF,0xFD1E,0xFE01,
	0xFE29,0xFECA,0xFFED,0x0158,0x0381,0x06AB,0x0937,0x094F,
	0x082E,0x07C8,0x071F,0x0639,0x08D8,0x09C1,0x0B5E,0x0CB3,
	0x0C6C,0x0A5C,0x085B,0x06C6,0x05B1,0x053E,0x05DE,0x06B1,
	0x065B,0x0414,0x01A3,0x0013,0xFEA2,0xFD74,0xFC5A,0xFBAE,
	0xFB1D,0xFACF,0xFA2C,0xF8BA,0xF713,0xF5D2,0xF446,0xF3FA,
	0xF47D,0xF4C8,0xF450,0xF38E,0xF2F2,0xF3B0,0xF560,0xF5BC,
	0xF526,0xF434,0xF3C8,0xF4F6,0xF68C,0xF875,0xFAB9,0xFBE5,
	0xFB41,0xFA97,0xFA87,0xFBA6,0xFD41,0xFE61,0xFF8C,0x01B8,
	0x03ED,0x04B4,0x041A,0x02C4,0x019D,0x01D8,0x03AB,0x0697,
	0x0A75,0x0BBE,0x0989,0x0782,0x0612,0x062A,0x073C,0x07CF,
	0x07DF,0x07B4,0x0684,0x04B2,0x0305,0x02D4,0x02DE,0x036C,
	0x0339,0x0214,0x0094,0xFE71,0xFD75,0xFE16,0xFD39,0xFB32,
	0xF95C,0xF5C9,0xEF1F,0xE654,0xDBFC,0xD289,0xCDD0,0xD169,
	0xDE16,0xED8C,0xF74C,0xF50A,0xE7DC,0xD55B,0xC693,0xC3FA,
	0xD008,0xE510,0xF9BF,0x06AE,0x08BD,0x00D9,0xF577,0xED5C,
	0xEAE0,0xF0BD,0xFF18,0x113B,0x1FFE,0x276E,0x26F8,0x211D,
	0x189D,0x1343,0x1474,0x1B79,0x24CA,0x2CB7,0x30D7,0x30C9,
	0x2EF1,0x2C9D,0x29F9,0x2748,0x2410,0x209F,0x1D39,0x1BDF,
	0x1CFB,0x1FF2,0x21A4,0x1F76,0x19DF,0x11E5,0x0874,0x0009,
	0xFAB4,0xF98A,0xFB6A,0xFEB6,0x0176,0x011D,0xFC4B,0xF332,
	0xE844,0xDF8E,0xDCB9,0xDF5B,0xE5BE,0xEC43,0xEFEA,0xEF08,
	0xEB06,0xE495,0xDF97,0xDD7D,0xDED5,0xE3D3,0xEAAC,0xF1B4,
	0xF66B,0xF7CC,0xF67C,0xF495,0xF36B,0xF3FF,0xF718,0xFB4A,
	0x0083,0x049E,0x0808,0x0B64,0x0E5E,0x0F26,0x0D9D,0x0B0F,
	0x0984,0x0AA1,0x0FD3,0x1235,0x1576,0x1886,0x17BC,0x15CB,
	0x1205,0x0E3A,0x0BA2,0x0A0E,0x0951,0x0A9C,0x0C67,0x0D70,
	0x0BC4,0x081A,0x0335,0xFEEB,0xFB88,0xF907,0xF7D9,0xF7C5,
	0xF839,0xF86F,0xF792,0xF57F,0xF31D,0xEFE6,0xEC31,0xE99D,
	0xE982,0xEA7E,0xEBB5,0xECF3,0xEE2F,0xF012,0xF095,0xEE58,
	0xEBDB,0xEA94,0xEB34,0xEE37,0xF19E,0xF585,0xF96B,0xFAF7,
	0xFAA3,0xF95B,0xF967,0xFA62,0xFC2E,0xFE14,0x00A6,0x0474,
	0x0744,0x08AA,0x08BB,0x0832,0x07A8,0x065E,0x0697,0x07FC,
	0x09E7,0x0B28,0x0924,0x08AB,0x083B,0x0754,0x0665,0x048C,
	0x03A9,0x0345,0x0309,0x02E8,0x02C7,0x0305,0x02C1,0x0175,
	0xFE94,0xFC35,0xF9C8,0xF93B,0xF934,0xF8D5,0xF995,0xF9ED,
	0xF948,0xF74D,0xF649,0xF569,0xF422,0xF295,0xF180,0xF238,
	0xF48E,0xF678,0xF7E3,0xF894,0xF7CF,0xF6A3,0xF5FB,0xF5D5,
	0xF722,0xF940,0xFACF,0xFC4A,0xFD55,0xFFC2,0x0153,0x003F,
	0xFF50,0xFF23,0xFFFB,0x0133,0x029E,0x04BB,0x0718,0x0880,
	0x0910,0x0895,0x0749,0x06AE,0x06B8,0x066D,0x0702,0x08E7,
	0x0A3F,0x0A63,0x0977,0x07A1,0x054C,0x0319,0x01DB,0x0263,
	0x03DC,0x057D,0x05F8,0x04D1,0x027C,0xFF8F,0xFD1B,0xFCBF,
	0xFD4C,0xFDC7,0xFD27,0xFA4A,0xF573,0xEEE6,0xE77F,0xE015,
	0xDA81,0xD908,0xDC6C,0xE47D,0xEE3B,0xF514,0xF273,0xE824,
	0xDB01,0xD23A,0xD24A,0xDBFF,0xEB9F,0xFA8B,0x03DA,0x052E,
	0xFF8C,0xF7C2,0xF21E,0xF16F,0xF6D7,0x00CA,0x0E34,0x1A4C,
	0x2173,0x2142,0x1B97,0x1560,0x127E,0x1429,0x193A,0x1FEE,
	0x264F,0x2A2D,0x287E,0x2884,0x2897,0x260D,0x232F,0x1EAC,
	0x1A7A,0x1893,0x191D,0x1AF2,0x1C5E,0x1C86,0x19CE,0x14CA,
	0x0E21,0x0714,0x0144,0xFD69,0xFC36,0xFD06,0xFF05,0x0006,
	0xFE87,0xF9FD,0xF33C,0xEC7E,0xE771,0xE545,0xE671,0xEA31,
	0xEE91,0xF098,0xEFCD,0xED4C,0xEA42,0xE7CC,0xE680,0xE6F1,
	0xE9BC,0xEE53,0xF28B,0xF650,0xF8E3,0xFA45,0xFA1E,0xF907,
	0xF811,0xF931,0xFD4B,0x0203,0x05BB,0x0888,0x0AF3,0x0BD5,
	0x0C09,0x0C34,0x0C78,0x0BEB,0x0B2C,0x0BBE,0x0E89,0x12C5,
	0x17D5,0x1808,0x1633,0x1353,0x0F3E,0x0BD7,0x09CC,0x09B6,
	0x0A7C,0x0C2C,0x0C47,0x0AE8,0x0825,0x042C,0x0009,0xFC5B,
	0xF9F9,0xF886,0xF853,0xF823,0xF900,0xF930,0xF711,0xF3C1,
	0xF051,0xEE0B,0xED71,0xEDAF,0xEED8,0xEFAB,0xF037,0xF0B9,
	0xF0C7,0xF133,0xF073,0xF002,0xEF72,0xEF51,0xF05E,0xF335,
	0xF6DD,0xF993,0xFB2A,0xFBD5,0xFB86,0xFA3F,0xF9F0,0xFB7D,
	0xFD5A,0x0068,0x03F7,0x06A8,0x07CD,0x07C9,0x06FF,0x059B,
	0x048D,0x04EA,0x068A,0x0810,0x0891,0x0938,0x0928,0x082D,
	0x06C8,0x0517,0x045B,0x041E,0x0416,0x03D0,0x02F6,0x028C,
	0x021F,0x0157,0x0009,0xFE65,0xFD44,0xFBBA,0xFA01,0xF94D,
	0xF9F1,0xFB48,0xFB8E,0xFAE1,0xF8AB,0xF664,0xF464,0xF3B2,
	0xF41A,0xF514,0xF63A,0xF6DA,0xF6FD,0xF695,0xF59C,0xF565,
	0xF597,0xF6A1,0xF798,0xF86C,0xF955,0xFA6D,0xFAFF,0xFAF0,
	0xFA77,0xFB61,0xFCD1,0xFEBD,0xFF85,0xFFCB,0xFF69,0xFF70,
	0xFF5B,0x0016,0x024C,0x0535,0x0667,0x051E,0x036E,0x02BE,
	0x016F,0x0367,0x0500,0x046D,0x06F2,0x06A3,0x0481,0x0369,
	0x0256,0x0111,0x005C,0xFFF3,0x00BD,0x0212,0x02EC,0x0287,
	0x0043,0xFDC5,0xFB6E,0xFAA1,0xFC10,0xFDD7,0xFEEE,0xFD6C,
	0xFA4A,0xF60E,0xF23F,0xEEFA,0xEC69,0xEBFF,0xEF14,0xF4F5,
	0xFA8F,0xFC76,0xFA61,0xF3F8,0xECFE,0xE95A,0xEB27,0xF242,
	0xFB3A,0x020C,0x03C0,0x0254,0xFF36,0xFBEF,0xF9C0,0xFA71,
	0xFE32,0x0363,0x08F4,0x0DB6,0x107A,0x0FAD,0x0C73,0x08B9,
	0x0784,0x09F6,0x0D84,0x10E1,0x129B,0x12C5,0x1148,0x0FA7,
	0x0F25,0x0DC5,0x0C86,0x0BB5,0x09CB,0x0827,0x075E,0x0849,
	0x0996,0x0A65,0x09D3,0x0719,0x030C,0xFF1B,0xFCE6,0xFC8D,
	0xFCD3,0xFCD7,0xFDEA,0xFF20,0xFE68,0xFC61,0xF92E,0xF4B8,
	0xF0E4,0xEFCA,0xF20B,0xF671,0xFA81,0xFC2C,0xF9FA,0xF607,
	0xF29D,0xF08A,0xF188,0xF3A4,0xF630,0xF83E,0xF920,0xF8DB,
	0xF825,0xF77B,0xF6E9,0xF68F,0xF6E3,0xF8DE,0xF866,0xF7CB,
	0xF756,0xF705,0xF66E,0xF5B2,0xF618,0xF6E4,0xF820,0xF946,
	0xFA02,0xFA76,0xFAF6,0xFB91,0xFC6A,0xFC5B,0xFBED,0xFB2D,
	0xFA5C,0xF9A8,0xF935,0xF96E,0xF903,0xF893,0xF82D,0xF782,
	0xF666,0xF58B,0xF4B1,0xF3E3,0xF309,0xF26F,0xF1F9,0xF129,
	0xF09C,0xEFF2,0xEF21,0xEE4F,0xED71,0xEC8B,0xEBEF,0xEBCF,
	0xEBA3,0xEB66,0xEB45,0xEAC1,0xE9FE,0xE997,0xE970,0xE93B,
	0xE95E,0xE979,0xE96D,0xE8B9,0xE8B0,0xE8C6,0xE89F,0xE82D,
	0xE81D,0xE809,0xE84B,0xE892,0xE8E1,0xE90B,0xE94C,0xE8A3,
	0xE8C6,0xE89A,0xE933,0xE91B,0xE978,0xEA4D,0xEAB8,0xEB3F,
	0xEC37,0xEB78,0xE9F3,0xEBEA,0xEB9C,0xEBC9,0xEC77,0xECF7,
	0xED5B,0xED89,0xEDBC,0xED90,0xEDEE,0xEE6E,0xEEEB,0xEF5D,
	0xEF83,0xEF86,0xF031,0xF066,0xF0B1,0xF16E,0xF1F1,0xF21C,
	0xF2A6,0xF336,0xF355,0xF39F,0xF3E5,0xF445,0xF4B7,0xF5CD,
	0xF665,0xF71A,0xF73A,0xF74B,0xF7B0,0xF81C,0xF8C9,0xF9C4,
	0xFA99,0xFAFC,0xFB50,0xFB99,0xFBF8,0xFBED,0xFBF5,0xFC9E,
	0xFCE7,0xFD28,0xFDD4,0xFE48,0xFED4,0xFED5,0xFEC6,0xFEE3,
	0xFF71,0x0011,0x00AE,0x0168,0x0169,0x01A9,0x0226,0x042B,
	0x05C2,0x0554,0x0542,0x056B,0x0570,0x0570,0x057C,0x05B0,
	0x05DE,0x0683,0x06C3,0x070F,0x071F,0x06E9,0x06EE,0x06EC,
	0x07A9,0x0829,0x0801,0x084A,0x09D2,0x09FD,0x0960,0x08EE,
	0x0908,0x091A,0x0954,0x09A6,0x0A21,0x0A6B,0x0A8F,0x0A35,
	0x0A45,0x0A64,0x0AE9,0x0B47,0x0B99,0x0B54,0x0B35,0x0B1F,
	0x0B35,0x0AB0,0x0B50,0x0BB9,0x0B52,0x0AD5,0x0B8F,0x0BDC,
	0x0B6F,0x0B85,0x0BAF,0x0C26,0x0C5C,0x0C1B,0x0B86,0x0B26,
	0x0AA5,0x0A99,0x0ADC,0x0A49,0x0A32,0x0A9F,0x0AD4,0x0A9F,
	0x0A57,0x0A20,0x0A2A,0x0A5E,0x0AC5,0x0B37,0x0BA9,0x0B49,
	0x0B24,0x0B1F,0x0B61,0x0BCD,0x0C0E,0x0C44,0x0C01,0x0B93,
	0x0B2C,0x0B3A,0x0B9B,0x0BE2,0x0BC1,0x0BC0,0x0BCD,0x0B61,
	0x0AEA,0x0B3D,0x0B70,0x0B9C,0x0B96,0x0BB6,0x0B9D,0x0BD3,
	0x0B8F,0x0B65,0x0B5B,0x0B43,0x0B78,0x0B9F,0x0B5A,0x0B1D,
	0x0AF9,0x0B1E,0x0AFD,0x0AA8,0x0AD4,0x0B5E,0x0B47,0x0B8B,
	0x0B5E,0x0B4D,0x0B6E,0x0BE3,0x0B6A,0x0B6D,0x0BC5,0x0BA4,
	0x0ADD,0x0CB4,0x0B32,0x0ACD,0x0B99,0x0B03,0x0B26,0x0B3A,
	0x0B13,0x0B37,0x0B56,0x0B15,0x0B6E,0x0B28,0x0B14,0x0ABA,
	0x0AC5,0x0AAD,0x0A88,0x0A62,0x09EE,0x0A2D,0x0A0B,0x09F1,
	0x09BF,0x09CE,0x09EB,0x09EE,0x09B3,0x0993,0x0997,0x09B3,
	0x0A06,0x09C4,0x0976,0x0939,0x0936,0x0990,0x09DC,0x09DC,
	0x0988,0x090D,0x08B6,0x08D7,0x08C6,0x0901,0x0921,0x08E5,
	0x08F0,0x08A8,0x082F,0x0834,0x083F,0x0820,0x07D2,0x0769,
	0x075B,0x0798,0x0798,0x071D,0x0722,0x0734,0x0727,0x06E5,
	0x0656,0x03F8,0x03EF,0x045D,0x0453,0x04A4,0x04EF,0x051E,
	0x04F6,0x04CB,0x04A2,0x0458,0x0496,0x04C3,0x04B2,0x049B,
	0x04B8,0x04FA,0x04EC,0x04ED,0x041C,0x0480,0x056A,0x0573,
	0x0515,0x0515,0x0593,0x059B,0x05BB,0x0592,0x05CD,0x0600,
	0x05A9,0x05C8,0x0624,0x05DE,0x059E,0x05B9,0x05DC,0x05D2,
	0x0582,0x05A5,0x05CD,0x05AD,0x06A9,0x0670,0x051F,0x04A6,
	0x044A,0x03E3,0x03DC,0x0431,0x0498,0x046C,0x0499,0x04F0,
	0x051B,0x0592,0x05A7,0x0625,0x05C4,0x0563,0x0504,0x04D2,
	0x052C,0x0538,0x049B,0x04D7,0x04E9,0x04B1,0x0494,0x0487,
	0x042D,0x03B2,0x03A1,0x0373,0x039F,0x036D,0x030E,0x0298,
	0x0258,0x0282,0x0293,0x0289,0x02B6,0x022C,0x0242,0x01C6,
	0x01EA,0x0234,0x0252,0x021A,0x01BF,0x01DF,0x0199,0x0195,
	0x019E,0x01B0,0x0184,0x0159,0x017D,0x0167,0x0137,0x0150,
	0x0126,0x00FE,0x00E0,0x0103,0x016E,0x012A,0x0109,0x00E0,
	0x0114,0x0105,0x00C2,0x007D,0x0070,0x008F,0xFE98,0xFEA5,
	0xFEB0,0xFF32,0xFF96,0xFF4A,0xFEA7,0xFE1A,0xFE19,0xFE77,
	0xFEB4,0xFEC5,0xFE99,0xFE79,0xFEA9,0xFED4,0xFEE2,0xFE91,
	0xFDFE,0xFE61,0xFECC,0xFE03,0xFD91,0xFE7C,0xFE67,0xFE00,
	0xFDEC,0xFE95,0xFEF2,0xFE93,0xFE9F,0xFE91,0xFE66,0xFE36,
	0xFD75,0xFD32,0xFC3D,0xFC43,0xFCFC,0xFD63,0xFD63,0xFCF1,
	0xFCAB,0xFC98,0xFCA6,0xFCFF,0xFD52,0xFD3F,0xFD3F,0xFD53,
	0xFD14,0xFD41,0xFDAF,0xFD88,0xFD46,0xFDEB,0xFE21,0xFDB2,
	0xFD92,0xFD80,0xFDA9,0xFDA9,0xFDBB,0xFDDC,0xFDCB,0xFD95,
	0xFD6A,0xFD56,0xFDA4,0xFE16,0xFDE8,0xFDEC,0xFDF7,0xFDAA,
	0xFD69,0xFD55,0xFD59,0xFD56,0xFD69,0xFDC2,0xFE02,0xFDC9,
	0xFD6D,0xFD6F,0xFD14,0xFCA3,0xFD36,0xFD36,0xFD70,0xFCE3,
	0xFC8B,0xFCA1,0xFD66,0xFD9B,0xFE8E,0x001F,0x013B,0x01B3,
	0x0372,0x01C4,0x0239,0x03CF,0x03D3,0x0546,0x0733,0x0892,
	0x095A,0x099B,0x0988,0x09B7,0x09B1,0x0A78,0x0B6B,0x0C72,
	0x0CAF,0x0CAA,0x0CB1,0x0BEB,0x0B60,0x0B3E,0x0BE6,0x0D8E,
	0x1003,0x10E7,0x10EE,0x1013,0x0FDD,0x0FC2,0x0FC8,0x104A,
	0x119B,0x12F2,0x13DE,0x13C6,0x12AE,0x126C,0x12CD,0x14E1,
	0x1643,0x1656,0x155A,0x147A,0x14B6,0x15D5,0x1763,0x17E0,
	0x1776,0x167C,0x15F0,0x15B8,0x1629,0x16C4,0x1689,0x16AE,
	0x16F7,0x170C,0x1702,0x167C,0x1570,0x1491,0x1473,0x146A,
	0x1393,0x13D2,0x137A,0x12A4,0x1243,0x11A7,0x10BF,0x10DA,
	0x1194,0x128C,0x124F,0x1179,0x1007,0x0E9A,0x0DF2,0x0E47,
	0x0FFB,0x11A7,0x1171,0x0E56,0x0C22,0x0BF1,0x0CF0,0x0D67,
	0x0DFA,0x0DDD,0x0D23,0x0C9C,0x0C2A,0x0BE5,0x0B64,0x0B0B,
	0x0B17,0x0A43,0x08F5,0x0807,0x07B0,0x06B2,0x049A,0x0004,
	0xF917,0xF03A,0xE86E,0xE62D,0xEB06,0xF4C4,0xFFDA,0x03FF,
	0xFD50,0xEEBD,0xE0B8,0xDB11,0xE1AF,0xF196,0x02D2,0x0D52,
	0x0CC3,0x049F,0xFB74,0xF615,0xF803,0x001A,0x0B1F,0x14EF,
	0x1A69,0x1ABC,0x17FE,0x141C,0x119C,0x1214,0x143C,0x16DF,
	0x18D1,0x1A4C,0x1C10,0x1DA1,0x1D9C,0x1AC0,0x1578,0x0E47,
	0x0801,0x05E3,0x089F,0x0D2E,0x108A,0x0FDF,0x0973,0xFE5D,
	0xF2B1,0xEBB8,0xEC0A,0xF163,0xF6C2,0xF932,0xF75C,0xF0C4,
	0xE796,0xDFD2,0xDC88,0xDEE7,0xE49C,0xE9B8,0xEC06,0xEB66,
	0xE886,0xE4EA,0xE323,0xE3C6,0xE6CF,0xEA86,0xEDD4,0xEF9E,
	0xF03C,0xF19D,0xF42E,0xF6A4,0xF6B5,0xF646,0xF708,0xF941,
	0xF8A6,0xFC49,0x01C9,0x03A5,0x03AF,0x013B,0xFDF8,0xFC46,
	0xFBF4,0xFD73,0xFFE6,0x028B,0x02FF,0xFFE9,0xFB61,0xF75D,
	0xF534,0xF400,0xF3D4,0xF3FA,0xF429,0xF35A,0xF11E,0xEDE4,
	0xEAE8,0xE8EC,0xE833,0xE778,0xE71A,0xE78D,0xE7A4,0xE6E0,
	0xE606,0xE5AE,0xE48D,0xE349,0xE29C,0xE2EF,0xE54A,0xE877,
	0xEA83,0xEA67,0xE98D,0xE940,0xEA4D,0xEC01,0xEDCE,0xEEB1,
	0xF02D,0xF2A8,0xF4BE,0xF59D,0xF4F1,0xF431,0xF4F6,0xF6E6,
	0xF8E8,0xFA09,0xFA37,0xF9CD,0xF980,0xFAAD,0xFD75,0xFD8F,
	0xFC75,0xFB3D,0xFA7F,0xFA08,0xF96C,0xF879,0xF71A,0xF67D,
	0xF60F,0xF5C4,0xF4AC,0xF2E5,0xF05C,0xEE38,0xECE4,0xEDFE,
	0xF0A8,0xF157,0xEFE7,0xED03,0xE99F,0xE856,0xE9AD,0xEB88,
	0xED03,0xEE82,0xEEDB,0xEDF8,0xEB4F,0xEA0D,0xEB55,0xECDF,
	0xEF3E,0xF164,0xF25D,0xF2DD,0xF1E6,0xF0EF,0xF241,0xF44C,
	0xF5EA,0xF6C0,0xF696,0xF54B,0xF632,0xF8F0,0xFAF2,0xFB5C,
	0xFAA6,0xF98D,0xF8E8,0xF956,0xF906,0xF8C7,0xF8A4,0xF937,
	0xF9D8,0xF9A2,0xF74D,0xF4EE,0xF30B,0xF263,0xF32A,0xF4BA,
	0xF5F5,0xF610,0xF43E,0xF1BF,0xF00A,0xF009,0xF14D,0xF1FB,
	0xF1F3,0xF1C1,0xF162,0xF0FB,0xF02C,0xEF4E,0xEF68,0xF18E,
	0xF438,0xF4FE,0xF3BE,0xF1C1,0xF0D1,0xF177,0xF3A0,0xF6CA,
	0xF856,0xF741,0xF52C,0xF48A,0xF5DF,0xF82A,0xF9B3,0xF96F,
	0xF795,0xF2A1,0xEA36,0xDDA2,0xCAC8,0xBE42,0xBF05,0xBF4B,
	0xBE51,0xD094,0xEB10,0xF28D,0xDD5A,0xC17F,0xBED7,0xC064,
	0xBEAA,0xD4EB,0x0047,0x1410,0x0E78,0xF7B8,0xDE8E,0xD53D,
	0xDEC5,0xF6D2,0x188D,0x3495,0x3E03,0x3E16,0x355A,0x276D,
	0x228D,0x287A,0x36AE,0x3EE2,0x3EE7,0x3F3A,0x3F3E,0x3F60,
	0x3ED4,0x3F6E,0x3BB8,0x2D57,0x2221,0x1FEF,0x264B,0x3079,
	0x3612,0x3155,0x201F,0x0844,0xF23F,0xE52C,0xE543,0xEFC6,
	0xFC8D,0x0283,0xFCB2,0xEBFD,0xD72F,0xC745,0xC211,0xC871,
	0xD47E,0xDF42,0xE49C,0xE340,0xDD50,0xD777,0xD469,0xD5FA,
	0xDB7F,0xE2DC,0xEB48,0xF3B4,0xFB27,0x018F,0x050B,0x05D0,
	0x05DE,0x0571,0x0699,0x0B60,0x14BB,0x2019,0x2923,0x2BD9,
	0x27E5,0x208F,0x18E6,0x146E,0x1622,0x1DAF,0x2697,0x2B93,
	0x2A01,0x2222,0x171C,0x0C1C,0x04E1,0x03B7,0x066C,0x0A1A,
	0x0B25,0x07E9,0xFEF5,0xF513,0xEE29,0xE97E,0xE6E8,0xE645,
	0xE6BA,0xE6FD,0xE670,0xE5F2,0xE3CB,0xE04E,0xDD69,0xDB8A,
	0xDB80,0xDDA3,0xE1E3,0xE681,0xEAFE,0xEDB9,0xEEDE,0xEE85,
	0xEE17,0xEEC0,0xF130,0xF776,0xFE82,0x04A0,0x0915,0x0AAD,
	0x0A7A,0x09BC,0x0950,0x0AB3,0x0E9A,0x139D,0x17B4,0x19C3,
	0x19BA,0x191A,0x170E,0x13EB,0x111A,0x0F87,0x10AB,0x1212,
	0x12C0,0x1093,0x0D2C,0x08FB,0x0468,0xFFE3,0xFD4A,0xFBDD,
	0xFBD5,0xFBDB,0xFA75,0xF7F7,0xF4D6,0xF15C,0xEE01,0xEC4E,
	0xEC81,0xED64,0xEDCB,0xEE97,0xEEE6,0xEE2C,0xED91,0xED78,
	0xEE79,0xF006,0xF184,0xF38C,0xF5F2,0xF7D6,0xF981,0xFBE8,
	0xFE54,0xFF69,0xFFF6,0x0085,0x02E4,0x0650,0x09B0,0x0BC9,
	0x0CFF,0x0D83,0x0D82,0x0D2D,0x0D06,0x0CAD,0x0D57,0x0E0E,
	0x0EB5,0x0F27,0x0F39,0x0D1E,0x095B,0x0636,0x05BA,0x057D,
	0x0425,0x04DA,0x02AE,0x00CA,0xFFDE,0xFDC9,0xFAC1,0xF814,
	0xF5C0,0xF554,0xF64B,0xF829,0xF7F0,0xF585,0xF255,0xF0F8,
	0xF13D,0xF29A,0xF327,0xF36D,0xF4C9,0xF6E8,0xF82B,0xF6F6,
	0xF5C3,0xF61E,0xF77C,0xFA31,0xFD34,0xFFCD,0x0060,0xFF9A,
	0x0002,0x0201,0x04CD,0x060F,0x0332,0xFBFF,0xF1E3,0xE328,
	0xCD64,0xBFD7,0xC05F,0xBF56,0xC4FE,0xE746,0x0067,0xFD03,
	0xD915,0xBF44,0xC0B9,0xC013,0xC43A,0xEEAF,0x1640,0x1F6A,
	0x1031,0xF5AD,0xDFEA,0xDA5C,0xE8E1,0x09DC,0x2FAB,0x4018,
	0x3EEB,0x405B,0x3C05,0x2E3F,0x2E91,0x3A3D,0x400D,0x3FB2,
	0x3FC8,0x3FDD,0x3FE2,0x3FE7,0x3FA1,0x3F59,0x3F67,0x329C,
	0x2809,0x2A35,0x35D8,0x3E9A,0x3F0B,0x394B,0x2373,0x0867,
	0xF12F,0xE47B,0xE6D9,0xF596,0x05A7,0x0BDE,0x019E,0xE8AB,
	0xCD07,0xC07E,0xBFAA,0xC929,0xDB9D,0xE788,0xE887,0xE16E,
	0xD83B,0xD1FB,0xD039,0xD309,0xDB5B,0xE546,0xEEE4,0xF78C,
	0xFE0B,0x01DC,0x036F,0x0434,0x04E1,0x054D,0x06A1,0x0C10,
	0x1709,0x236C,0x2CB4,0x2FA0,0x2A88,0x213A,0x1838,0x1439,
	0x17E3,0x224E,0x2D1E,0x31A0,0x2CEE,0x214A,0x1427,0x09C4,
	0x049C,0x0488,0x07AE,0x0B43,0x0B50,0x075C,0xFEC4,0xF3EB,
	0xEA19,0xE40A,0xE217,0xE2E4,0xE493,0xE4DF,0xE35C,0xE0EF,
	0xDEDF,0xDC97,0xD977,0xD601,0xD439,0xD655,0xDC97,0xE55B,
	0xEC14,0xEE14,0xEC47,0xE8D7,0xE764,0xE96D,0xEF22,0xF768,
	0x0007,0x06B2,0x0A95,0x0B28,0x086F,0x04F7,0x049E,0x096E,
	0x1280,0x1A05,0x1B51,0x18AC,0x1538,0x1377,0x1390,0x15A4,
	0x1249,0x0F87,0x0ED9,0x0ECE,0x0F6A,0x0F58,0x0CD6,0x0792,
	0x016F,0xFC92,0xFA79,0xF99C,0xF8AC,0xF74C,0xF678,0xF59E,
	0xF37A,0xEEA2,0xE958,0xE565,0xE4AD,0xE6A0,0xE9E4,0xED78,
	0xEDE1,0xEB23,0xE883,0xE7F4,0xE905,0xEA79,0xECC3,0xEFC1,
	0xF3E7,0xF844,0xFAFA,0xFB40,0xFA31,0xF937,0xFA9D,0xFE8E,
	0x035B,0x06FF,0x092A,0x0A2D,0x0AA0,0x0B3E,0x0B62,0x0BA8,
	0x0B5F,0x0B6C,0x0C94,0x0DE1,0x0F8F,0x1013,0x0E4B,0x0ACE,
	0x0773,0x05F8,0x05DE,0x05B3,0x058D,0x04A5,0x0224,0xFD6B,
	0xFA81,0xF849,0xF615,0xF59A,0xF5F5,0xF5B6,0xF466,0xF293,
	0xF17C,0xF149,0xF0F9,0xF0DC,0xF0E4,0xF0C3,0xF03A,0xF05C,
	0xF229,0xF428,0xF524,0xF64E,0xF72D,0xF803,0xF907,0xFA80,
	0xFBFB,0xFDB0,0x00DA,0x037D,0x0418,0x03CF,0x03AD,0x0202,
	0xFC30,0xF04F,0xDDCF,0xC766,0xBFE3,0xC188,0xBFA6,0xD073,
	0xF22D,0x0234,0xF72E,0xD15F,0xBF77,0xC1EA,0xC04D,0xCC2C,
	0xFE17,0x21C3,0x252F,0x0E22,0xEE97,0xDA71,0xDCF8,0xF4C1,
	0x1988,0x3AC1,0x40B6,0x3FC0,0x411C,0x3896,0x2D67,0x3204,
	0x3E31,0x40DC,0x4077,0x40B3,0x4094,0x40D2,0x409F,0x402B,
	0x4091,0x3E1B,0x2E79,0x25AD,0x2B04,0x396F,0x3FA9,0x3FF2,
	0x3724,0x1AAB,0xFE52,0xEA33,0xE53B,0xEEF7,0x002F,0x0CBF,
	0x0B94,0xFB08,0xE0E5,0xC9D7,0xC0C6,0xC29C,0xD11F,0xE247,
	0xEBB6,0xEA31,0xE16C,0xD789,0xD221,0xD281,0xD8B4,0xE29A,
	0xED3C,0xF5A2,0xFB6C,0x0011,0x034B,0x0544,0x06B2,0x078C,
	0x089A,0x0BEC,0x126B,0x1BBE,0x2656,0x2F7C,0x32C7,0x2BCE,
	0x2242,0x19C3,0x15AE,0x1B52,0x2637,0x3031,0x3376,0x2E26,
	0x2222,0x1314,0x074B,0x0340,0x0613,0x0B82,0x0EE0,0x0D1E,
	0x063A,0xFB6A,0xF010,0xE8A1,0xE5CD,0xE67F,0xE781,0xE71C,
	0xE658,0xE520,0xE39D,0xE13B,0xDE70,0xDBC6,0xD9D8,0xD979,
	0xDC15,0xE1DF,0xE946,0xEED9,0xF0A7,0xEEC8,0xEBEA,0xEA60,
	0xEC45,0xF27D,0xFAE5,0x03FC,0x0B1F,0x0D3D,0x0BC3,0x0884,
	0x0622,0x06F0,0x0B27,0x117A,0x1816,0x1B84,0x1A6C,0x16F9,
	0x1301,0x115D,0x10F9,0x1106,0x11CF,0x1365,0x11BD,0x1001,
	0x0E08,0x0B6D,0x07CE,0x035D,0xFF12,0xFAD9,0xF7AF,0xF6F6,
	0xF86E,0xF8E1,0xF6F9,0xF2C6,0xECFC,0xE800,0xE4D6,0xE49F,
	0xE6EF,0xEB61,0xEE3C,0xED96,0xEB8D,0xE96C,0xE7A9,0xE6BF,
	0xE92E,0xED8E,0xF250,0xF5F6,0xF7AE,0xF87B,0xF8D8,0xF8AD,
	0xF9F6,0xFC79,0xFF73,0x01E8,0x03EE,0x064F,0x0966,0x0B06,
	0x0B7A,0x09BF,0x072E,0x07DE,0x09AE,0x0B77,0x0D87,0x0EDE,
	0x0E71,0x0C73,0x0962,0x06B9,0x040D,0x0291,0x0220,0x0218,
	0x021A,0x008A,0xFE76,0xFBF9,0xF898,0xF582,0xF32F,0xF2AD,
	0xF3A4,0xF4AF,0xF40A,0xF245,0xF0EF,0xEFC4,0xEEB8,0xEDB5,
	0xEE02,0xEF97,0xF16C,0xF390,0xF482,0xF4BE,0xF451,0xF3F0,
	0xF472,0xF67E,0xF921,0xFAB9,0xFBF0,0xFD09,0xFECD,0x0195,
	0x032C,0x027F,0xFF60,0xFAC6,0xF4A2,0xEA09,0xD7E1,0xC2A2,
	0xBE72,0xBFEC,0xBE30,0xD1CF,0xF372,0xFF6C,0xEB06,0xC5C0,
	0xBE4F,0xC06E,0xBE5B,0xD355,0x0526,0x1ED7,0x1A30,0x0034,
	0xE3C6,0xD546,0xDC97,0xF730,0x1C2F,0x3969,0x3EAC,0x3E86,
	0x3E0F,0x31B0,0x2903,0x2F51,0x3C15,0x3F4F,0x3ED9,0x3F18,
	0x3F1E,0x3F35,0x3F2A,0x3EB1,0x3F81,0x3821,0x2AB6,0x278C,
	0x2F19,0x3A90,0x3EDE,0x3D74,0x2CD3,0x12D3,0xFA33,0xE951,
	0xE5CA,0xF022,0x0040,0x0A7F,0x0642,0xF3BE,0xDAC4,0xC641,
	0xBFE1,0xC298,0xD217,0xE39B,0xEB9C,0xE824,0xDDA6,0xD44E,
	0xD06D,0xD29C,0xD9C0,0xE2F4,0xEBCF,0xF35B,0xFA09,0xFF91,
	0x0339,0x057A,0x0603,0x0611,0x0717,0x0B46,0x1387,0x1F0F,
	0x29E8,0x30B1,0x3069,0x28EF,0x1F5B,0x17E4,0x15E9,0x1B83,
	0x273B,0x2F5E,0x3002,0x289C,0x1B61,0x0D5B,0x04E2,0x038E,
	0x0794,0x0BDE,0x0CB1,0x08D4,0x00C4,0xF71D,0xEE6C,0xE875,
	0xE5AF,0xE45C,0xE460,0xE5E5,0xE5C6,0xE3A9,0xE114,0xDE3A,
	0xDBA7,0xD9B3,0xD941,0xD9E0,0xDCB2,0xE136,0xE723,0xEC27,
	0xEE78,0xEE2A,0xED2D,0xEC29,0xED47,0xF1E8,0xF99B,0x03AC,
	0x0B9B,0x0E0E,0x0CF8,0x08F8,0x0652,0x0763,0x0C0F,0x132A,
	0x198A,0x1D08,0x1C13,0x1840,0x14A1,0x1299,0x1144,0x10A2,
	0x11A2,0x1374,0x1427,0x11CC,0x0DE0,0x098D,0x05A8,0x0136,
	0xFD68,0xFAA0,0xF9C1,0xF9EA,0xFAC4,0xFA5A,0xF803,0xF2D4,
	0xEC9F,0xE86F,0xE766,0xE909,0xEB49,0xED6A,0xEE63,0xEDF1,
	0xEC1B,0xEA57,0xE8F4,0xE90E,0xEB26,0xF04A,0xF5ED,0xF965,
	0xFA70,0xF911,0xF7DE,0xF9AA,0xFD47,0x00FA,0x03AB,0x05ED,
	0x078D,0x090A,0x0AA9,0x0BE1,0x0D49,0x0D01,0x0BD0,0x0B6F,
	0x0CD9,0x0EF6,0x0FC3,0x0F9C,0x0E62,0x0D21,0x0ADF,0x07D3,
	0x0472,0x02B4,0x02DB,0x03FE,0x051F,0x0534,0x0176,0xFB12,
	0xF833,0xF49D,0xF42B,0xF6ED,0xF8FB,0xF8E8,0xF68F,0xF353,
	0xF137,0xF023,0xEF89,0xF098,0xF256,0xF430,0xF540,0xF609,
	0xF566,0xF4F1,0xF4E2,0xF640,0xF8B5,0xFB3C,0xFBF5,0xFCC1,
	0xFE1B,0xFFC6,0x0252,0x03E4,0x0461,0x03F5,0x01D3,0xFDD7,
	0xF5E2,0xE7AC,0xD251,0xC0F1,0xBFE4,0xC023,0xC0FB,0xDCA5,
	0xFA9D,0xFFCF,0xE365,0xC166,0xC002,0xC140,0xBFA7,0xDF4E,
	0x0F32,0x220C,0x1749,0xFA8C,0xDF3B,0xD540,0xE1C3,0xFF17,
	0x23CD,0x3C52,0x3E5E,0x3EEE,0x3E16,0x2F1F,0x29F5,0x342E,
	0x3F4F,0x3FC0,0x3FD9,0x3FE0,0x3FD4,0x3FEA,0x3FDF,0x3F5B,
	0x3FB4,0x34B1,0x2788,0x276A,0x31EC,0x3D22,0x3F6B,0x390E,
	0x22FF,0x0A1C,0xF43B,0xE6E3,0xE68B,0xF127,0xFFC7,0x07AB,
	0x00FF,0xEB9B,0xD0D2,0xC15C,0xBF49,0xC51D,0xD743,0xE4A1,
	0xE6E0,0xDFBA,0xD5BE,0xCF87,0xD03E,0xD44F,0xD9CD,0xE122,
	0xEA49,0xF2B2,0xF95E,0xFF59,0x0342,0x0419,0x0323,0x031F,
	0x0614,0x0C29,0x154F,0x20B8,0x2B2A,0x3078,0x2CFE,0x2195,
	0x1588,0x10FD,0x170A,0x22C7,0x2C7B,0x2FA1,0x2ACB,0x1FC9,
	0x1359,0x0A57,0x0618,0x0592,0x06E0,0x0943,0x0A7E,0x075E,
	0xFEC9,0xF2E6,0xE890,0xE3F1,0xE39D,0xE480,0xE4AC,0xE37A,
	0xE13C,0xDFA4,0xDF0B,0xDE6B,0xDBF5,0xD7FC,0xD4C9,0xD561,
	0xDA72,0xE205,0xE913,0xED2C,0xEDA9,0xEB7F,0xE935,0xE846,
	0xEAD8,0xF271,0xFC8F,0x0699,0x0C73,0x0C5A,0x07E3,0x0338,
	0x0220,0x0740,0x0FF1,0x1740,0x1B47,0x1AB3,0x17F0,0x1551,
	0x1390,0x118C,0x10F0,0x1044,0x107D,0x11B1,0x13EA,0x1036,
	0x0BAE,0x06C8,0x0117,0xFE39,0xFC7A,0xFB7A,0xFA15,0xF93F,
	0xF744,0xF5BD,0xF395,0xF0B3,0xEBB9,0xE795,0xE6AA,0xE873,
	0xEB4F,0xED24,0xEDF8,0xECDD,0xEA17,0xE771,0xE7BA,0xEA95,
	0xEEBB,0xF204,0xF479,0xF664,0xF7C3,0xF868,0xF91E,0xFA2B,
	0xFC2C,0xFF7E,0x0350,0x06E3,0x08AE,0x0923,0x08F7,0x0A33,
	0x0BAC,0x0CCD,0x0CA3,0x0BF7,0x0C67,0x0DFA,0x107D,0x1103,
	0x0F75,0x0C09,0x089C,0x069F,0x0713,0x0782,0x0705,0x0581,
	0x0341,0x0141,0xFF8A,0xFD73,0xFAA0,0xF7CC,0xF4DA,0xF578,
	0xF5DD,0xF43B,0xF1EC,0xF03C,0xEFAD,0xF02A,0xF120,0xF188,
	0xF1CA,0xF196,0xF144,0xF190,0xF370,0xF547,0xF640,0xF7C1,
	0xF96D,0xFA17,0xFB2E,0xFC2A,0xFC80,0xFE93,0x01A4,0x0475,
	0x0507,0x029B,0xFB39,0xEE6C,0xDCC2,0xC881,0xBFC0,0xC0F5,
	0xBF97,0xC782,0xE954,0xFEBC,0xF952,0xD639,0xBFF6,0xC1B4,
	0xC0B8,0xC64D,0xF309,0x19D1,0x2209,0x1010,0xF32F,0xDD1B,
	0xD98D,0xEA2D,0x0A65,0x2FE4,0x403F,0x3F0A,0x40FA,0x39AE,
	0x2B8A,0x2C47,0x3960,0x4105,0x406F,0x40BC,0x40AD,0x40A1,
	0x40BC,0x4058,0x4075,0x3F01,0x2E26,0x244B,0x2911,0x36FE,
	0x3F60,0x3FAD,0x365A,0x1E7F,0x03CA,0xED7E,0xE456,0xE98D,
	0xF7BE,0x0545,0x0936,0xFE64,0xE72A,0xCD6F,0xC176,0xC0CE,
	0xCA99,0xDC51,0xE72B,0xE86F,0xE2D2,0xDA62,0xD351,0xD080,
	0xD33A,0xDAF4,0xE5D3,0xF0DA,0xF9F4,0xFFF0,0x0325,0x03D9,
	0x039E,0x03F4,0x0591,0x0951,0x0FDC,0x1960,0x2417,0x2CC7,
	0x305A,0x2B58,0x20AD,0x1724,0x1513,0x1B8E,0x23B1,0x2D2B,
	0x30DA,0x2B86,0x2199,0x1516,0x09AA,0x0461,0x0556,0x091E,
	0x0CCC,0x0CF3,0x07DC,0xFDEF,0xF2D0,0xE9C1,0xE50F,0xE3C6,
	0xE476,0xE573,0xE60F,0xE603,0xE51D,0xE1FE,0xDCEB,0xD7F8,
	0xD575,0xD6EE,0xDBCB,0xE1CE,0xE74C,0xEC0A,0xEE58,0xED07,
	0xE96B,0xE6B5,0xE8C6,0xF01E,0xFA0B,0x02CE,0x0876,0x09C9,
	0x07B5,0x0540,0x04B1,0x06AA,0x0AF8,0x0F4F,0x1433,0x184C,
	0x19D1,0x1761,0x12F4,0x0F25,0x0D6F,0x0E0E,0x0F27,0x0FBD,
	0x0EEE,0x0DB0,0x0BDB,0x09BA,0x07AB,0x025D,0xFE46,0xFBFB,
	0xFAB5,0xF9EF,0xF8BA,0xF770,0xF63F,0xF3ED,0xF036,0xEB4F,
	0xE6E8,0xE4F6,0xE6BB,0xEB60,0xEFA2,0xF0C6,0xED4E,0xE855,
	0xE68D,0xE7AE,0xE9A7,0xED03,0xF1DB,0xF5E6,0xF867,0xF9A5,
	0xF9D7,0xF8F4,0xF84F,0xFA5B,0xFEFF,0x0424,0x0789,0x0953,
	0x09F3,0x0A8E,0x0A58,0x09FB,0x0A51,0x0A4D,0x0AA1,0x0C68,
	0x0E37,0x0E9B,0x0E96,0x0D3D,0x098A,0x078F,0x0693,0x0591,
	0x03DC,0x02D5,0x0311,0x0363,0x01BC,0xFDAF,0xF7FD,0xF35B,
	0xF1C7,0xF424,0xF63C,0xF6C1,0xF463,0xF0AD,0xEE38,0xEE5E,
	0xF006,0xF0BA,0xEF7B,0xEDEE,0xEE42,0xF0F8,0xF446,0xF585,
	0xF5B5,0xF4FC,0xF472,0xF4F0,0xF6FA,0xF9A9,0xFC94,0xFFD3,
	0x0215,0x02F7,0x01D5,0xFF42,0xFD79,0xFBF5,0xF8E7,0xF1C3,
	0xE2EC,0xCC10,0xBE9F,0xBFCB,0xBE69,0xCF5C,0xF20B,0x0216,
	0xF55A,0xCF3B,0xBDD7,0xC0C8,0xBEC4,0xCDAE,0xFAE2,0x1939,
	0x1B03,0x07FA,0xEDDB,0xDB98,0xDB7C,0xEE98,0x0F0E,0x31FA,
	0x3E4D,0x3DF3,0x3BA4,0x2C08,0x22BF,0x298F,0x3784,0x3E0F,
	0x3F0B,0x3EE7,0x3EEE,0x3F10,0x3F0D,0x3E90,0x3F31,0x35DF,
	0x2733,0x225D,0x2778,0x31AD,0x39A4,0x392C,0x2CCC,0x16B2,
	0xFDBA,0xEB00,0xE5BD,0xEE35,0xFCDF,0x07B7,0x060B,0xF688,
	0xDFEF,0xCC48,0xC38F,0xC7CA,0xD4C3,0xE1CD,0xE7BF,0xE5C1,
	0xDF8B,0xD9B9,0xD620,0xD67D,0xDA54,0xE151,0xE94D,0xF12A,
	0xF7EE,0xFE44,0x035B,0x05DF,0x0631,0x0568,0x0547,0x0769,
	0x0D9A,0x187F,0x24AB,0x2D5A,0x2E13,0x26C6,0x1C11,0x1442,
	0x13D4,0x1B2D,0x252C,0x2C05,0x2C94,0x251C,0x18C1,0x0D29,
	0x04EC,0x02B4,0x05E6,0x0A80,0x0CF9,0x0AA5,0x0351,0xF8BE,
	0xEF5E,0xEA0C,0xE8DE,0xEA73,0xEAE9,0xE914,0xE689,0xE525,
	0xE42E,0xE356,0xE298,0xDFD1,0xDBE8,0xDA8B,0xDDE2,0xE459,
	0xEB1D,0xEF85,0xF0A2,0xEFDE,0xEE07,0xEC9A,0xEDF2,0xF310,
	0xFB63,0x041E,0x09B0,0x0B89,0x09EB,0x06D0,0x0552,0x074C,
	0x0CEF,0x13E1,0x167D,0x16CB,0x1625,0x1585,0x1514,0x1348,
	0x1024,0x0D10,0x0C5F,0x0EA9,0x1101,0x1120,0x0E6C,0x0ACA,
	0x069A,0x0176,0xFD7A,0xFB86,0xFB68,0xFB5F,0xFABE,0xF9FB,
	0xF87C,0xF543,0xF031,0xEB55,0xE942,0xEA85,0xED95,0xEFB7,
	0xF071,0xEFB9,0xED73,0xEBB6,0xEBBC,0xED26,0xEF3B,0xF1C1,
	0xF45B,0xF74E,0xF9A8,0xFB37,0xFBBE,0xFBF7,0xFD28,0xFEDE,
	0x00F7,0x02E7,0x045C,0x06F6,0x0A2F,0x0C88,0x0C54,0x0A68,
	0x08AE,0x07E5,0x08FB,0x0AD0,0x0D7A,0x0F1E,0x0EDF,0x0C55,
	0x0871,0x051A,0x0401,0x03DA,0x0416,0x040D,0x03C6,0x01E8,
	0xFFC5,0xFC91,0xF96B,0xF708,0xF789,0xF7D5,0xF707,0xF85D,
	0xF655,0xF3E0,0xF2E4,0xF24A,0xF26A,0xF263,0xF277,0xF308,
	0xF366,0xF3DF,0xF4B0,0xF5B7,0xF607,0xF635,0xF6E3,0xF8B5,
	0xF9F6,0xFAC8,0xFBC2,0xFDA8,0xFF96,0x007A,0x0170,0x01FB,
	0x021D,0x0032,0xFD83,0xFA59,0xF5A9,0xEFA6,0xE942,0xE5CE,
	0xEB0C,0xF611,0x0086,0x0314,0xFB00,0xEC7E,0xDF28,0xDAFE,
	0xE308,0xF319,0x0273,0x097D,0x061C,0xFCF6,0xF3BB,0xEE68,
	0xEF7C,0xF7A2,0x0361,0x0E36,0x146B,0x135E,0x0D24,0x0753,
	0x056B,0x095D,0x0FEE,0x16AB,0x192A,0x171A,0x169F,0x184E,
	0x19F0,0x18E8,0x1430,0x0E38,0x0A8C,0x0A61,0x0D01,0x109C,
	0x12C7,0x1294,0x0EE5,0x0737,0xFDF5,0xF73F,0xF581,0xF9A0,
	0x019A,0x0760,0x0668,0xFF47,0xF5A0,0xECC2,0xE9DA,0xECF5,
	0xF35D,0xF9B8,0xFD40,0xFBF9,0xF7CF,0xF230,0xEEA2,0xEE84,
	0xF12D,0xF5D7,0xFACB,0xFEA4,0xFFEB,0xFE8E,0xFC8E,0xFC65,
	0xFD21,0xFEEF,0x00CE,0x0208,0x03A4,0x0773,0x0B98,0x0CEC,
	0x0AAE,0x0726,0x0491,0x03C7,0x04B6,0x07B2,0x0B21,0x0BD8,
	0x0B63,0x0935,0x064D,0x032A,0x0019,0xFED6,0x005F,0x0354,
	0x04C0,0x035E,0x003C,0xFD2B,0xFA6F,0xF896,0xF84D,0xF8DC,
	0xF970,0xF95C,0xF8D4,0xF896,0xF7C1,0xF5FF,0xF433,0xF347,
	0xF38D,0xF53E,0xF6B7,0xF827,0xF90F,0xF915,0xF883,0xF849,
	0xF875,0xF8AE,0xF850,0xF924,0xFAF2,0xFCD7,0xFE0F,0xFD23,
	0xFBA8,0xFA04,0xF90F,0xF8C4,0xF862,0xF7AD,0xF6EC,0xF63C,
	0xF480,0xF48A,0xF512,0xF5B1,0xF4E7,0xF3ED,0xF454,0xF5D4,
	0xF60D,0xF512,0xF3EC,0xF2B9,0xF1B6,0xF324,0xF11A,0xF106,
	0xF0D9,0xEF96,0xEF08,0xEE97,0xEDE6,0xED60,0xECA3,0xEBE7,
	0xEB8E,0xEAD4,0xEAC9,0xEA38,0xEA06,0xE9E3,0xE9D6,0xE95A,
	0xE89A,0xE7E3,0xE7ED,0xE800,0xE84C,0xE83D,0xE838,0xE7D5,
	0xE78F,0xE76F,0xE751,0xE74B,0xE7C4,0xE7B8,0xE7D9,0xE7FD,
	0xE844,0xE848,0xE860,0xE8CF,0xE8FD,0xE88C,0xE869,0xE8EA,
	0xE916,0xE9A0,0xE990,0xE981,0xE9D0,0xE9B9,0xE9D0,0xEA59,
	0xEAA8,0xEAC4,0xEB00,0xEB31,0xEBB0,0xEBDD,0xEBF7,0xEC48,
	0xECB5,0xED5A,0xEE57,0xEEB1,0xEDCA,0xEC47,0xECF5,0xEE06,
	0xEEAB,0xEF07,0xEF84,0xEFFC,0xF086,0xF16C,0xF202,0xF24D,
	0xF2A7,0xF2B8,0xF30A,0xF429,0xF4E3,0xF563,0xF611,0xF60B,
	0xF579,0xF6D4,0xF889,0xF8C9,0xF888,0xF8B6,0xF974,0xFA22,
	0xFB11,0xFBD1,0xFC2F,0xFC44,0xFC44,0xFCD5,0xFD71,0xFE14,
	0xFE12,0xFEAC,0xFF23,0xFF5F,0xFF89,0xFFFF,0x0048,0x0086,
	0x01A4,0x027D,0x021F,0x01D6,0x020B,0x0250,0x0261,0x030A,
	0x03DF,0x03F1,0x049A,0x0580,0x0626,0x0653,0x0741,0x0884,
	0x0846,0x0898,0x092E,0x09B2,0x0A0D,0x0A46,0x0A3F,0x09E3,
	0x0A0A,0x0A7D,0x0B44,0x0BA9,0x0B8E,0x0B75,0x0B6D,0x0B38,
	0x0B87,0x0C15,0x0C34,0x0C0D,0x0C1A,0x0C00,0x0C4E,0x0C1F,
	0x0C15,0x0C19,0x0C1E,0x0C7E,0x0CB8,0x0CCC,0x0CE1,0x0CBF,
	0x0C9A,0x0CE6,0x0CA1,0x0D1A,0x0D04,0x0CEB,0x0D4E,0x0D3C,
	0x0D66,0x0D7D,0x0D5F,0x0DC7,0x0EA0,0x0E81,0x0ED3,0x0EDD,
	0x0ECA,0x0EBD,0x0E6D,0x0EB6,0x0EF1,0x0F09,0x0ECE,0x0EB2,
	0x0E9F,0x0E99,0x0EF2,0x0F45,0x0FB9,0x0DAA,0x0E80,0x0F63,
	0x0E41,0x0E9E,0x0EE6,0x0EAE,0x0E8B,0x0E85,0x0E37,0x0E32,
	0x0E0D,0x0E9B,0x0EEA,0x0EA0,0x0E47,0x0E83,0x0E35,0x0DD5,
	0x0DA6,0x0DCC,0x0DFF,0x0DDC,0x0DEF,0x0DEF,0x0DF0,0x0E0B,
	0x0DA3,0x0D7B,0x0D54,0x0D69,0x0D76,0x0DA7,0x0D84,0x0D83,
	0x0D42,0x0CEB,0x0CE3,0x0CB5,0x0C94,0x0C8E,0x0BFC,0x0C10,
	0x0BE6,0x0BC5,0x0BD8,0x0BD5,0x0B45,0x0B21,0x0B2B,0x0AFC,
	0x0B64,0x0BB7,0x0B6E,0x0B73,0x0B1A,0x0AC7,0x0A77,0x0A21,
	0x0A3F,0x0A83,0x0B6B,0x0D28,0x0C2B,0x0B6D,0x0B06,0x0AF9,
	0x0AFE,0x0AC6,0x0A98,0x09FD,0x09C3,0x09DC,0x09DB,0x0977,
	0x0956,0x0989,0x094F,0x0911,0x0939,0x0924,0x07ED,0x0865,
	0x091B,0x08A3,0x07CA,0x0812,0x07F9,0x078B,0x0781,0x0731,
	0x0757,0x0777,0x074B,0x0743,0x0721,0x06D2,0x0710,0x070E,
	0x06DC,0x06DD,0x0724,0x0708,0x0700,0x0651,0x061F,0x0622,
	0x057C,0x05C0,0x06D1,0x0675,0x0616,0x05FE,0x05F3,0x05DC,
	0x0600,0x05DD,0x0541,0x04A7,0x0486,0x0475,0x03F7,0x034A,
	0x0303,0x0314,0x033F,0x030F,0x0339,0x0318,0x02C3,0x02D7,
	0x032A,0x0386,0x0375,0x036A,0x0346,0x02FA,0x0295,0x02DE,
	0x0331,0x0350,0x033B,0x0343,0x0326,0x02CF,0x02EF,0x02C5,
	0x0283,0x0264,0x0292,0x02DB,0x0307,0x0306,0x02C6,0x02A9,
	0x02CA,0x0279,0x0225,0x0282,0x02BD,0x02D9,0x028C,0x0241,
	0x0202,0x01F3,0x0219,0x0202,0x0222,0x01F1,0x01B5,0x0136,
	0x00EC,0x0116,0x019B,0x0173,0x01A9,0x01D7,0x01E3,0x014B,
	0x00DE,0x010F,0x01BB,0x00E8,0x020E,0x021A,0x008F,0x01AF,
	0x0184,0x0163,0x0166,0x017D,0x0122,0x0162,0x0183,0x0191,
	0x01AD,0x0169,0x00F9,0x00EA,0x018E,0x01A0,0x015F,0x00D6,
	0x0117,0x00D9,0x0122,0x011E,0x012B,0x00DB,0x0085,0x00B3,
	0x0088,0x00BD,0x00DB,0x012C,0x0125,0x0177,0x01B8,0x0154,
	0x00C9,0xFF15,0xFF28,0xFF44,0xFF2E,0xFEFF,0xFEFD,0xFE6B,
	0xFE94,0xFF93,0xFFAA,0xFEE3,0xFEF9,0xFF1E,0xFED3,0xFE62,
	0xFE47,0xFE87,0xFE5F,0xFE23,0xFE33,0xFE8E,0xFDF6,0xFD90,
	0xFD45,0xFD1C,0xFD58,0xFD52,0xFE3D,0xFE2B,0xFDE1,0xFDD1,
	0xFDBB,0xFC90,0xFBF0,0xFCC3,0xFDEB,0xFE4A,0xFE59,0xFE82,
	0xFE13,0xFDF9,0xFD70,0xFCEA,0xFC8A,0xFCA6,0xFCCD,0xFCF3,
	0xFBFC,0xFBF1,0xFC1F,0xFC09,0xFBFB,0xFC4A,0xFC4F,0xFC0A,
	0xFC45,0xFC3F,0xFC5F,0xFCBF,0xFC8B,0xFC53,0xFCA8,0xFC87,
	0xFC47,0xFC48,0xFC62,0xFCB2,0xFCFE,0xFCF9,0xFC8F,0xFC66,
	0xFC94,0xFC77,0xFC6E,0xFC81,0xFC21,0xFC4C,0xFC99,0xFCA0,
	0xFCE1,0xFCE2,0xFCC1,0xFC9B,0xFCCB,0xFCE1,0xFCDB,0xFCFB,
	0xFD2C,0xFD94,0xFD9E,0xFD4B,0xFD17,0xFD1A,0xFD1A,0xFD22,
	0xFCBC,0xFD19,0xFDB9,0xFDED,0xFDAB,0xFD3C,0xFD08,0xFD80,
	0xFDF8,0xFD66,0xFD7A,0xFDFB,0xFD52,0xFD1B,0xFEE0,0xFD48,
	0xFE36,0xFEF6,0xFE84,0xFDD4,0xFDAE,0xFD93,0xFDF6,0xFE73,
	0xFE96,0xFF0F,0xFEE0,0xFE8C,0xFDE9,0xFE2E,0xFE0B,0xFE53,
	0xFF04,0xFF22,0xFF22,0xFF34,0xFF17,0xFE88,0xFEB5,0xFEC6,
	0xFF39,0xFF60,0xFF8D,0xFF63,0xFF23,0xFF06,0xFF19,0xFF67,
	0xFFA6,0xFFEA,0x0008,0x001E,0x00B8,0x015C,0x0199,0x017C,
	0x01F3,0x02D0,0x02E4,0x036C,0x03B2,0x044A,0x05F9,0x07B2,
	0x087D,0x0735,0x05B8,0x05D1,0x061E,0x067E,0x0657,0x0659,
	0x05D7,0x05E5,0x0674,0x07B6,0x083E,0x0746,0x04BD,0x0426,
	0x0517,0x06F9,0x0873,0x0936,0x09D6,0x09D7,0x092E,0x08C6,
	0x096A,0x0AF9,0x0CD3,0x0E72,0x0F79,0x1078,0x0FD3,0x0E61,
	0x0D9B,0x0EA6,0x123E,0x14F9,0x14EC,0x13B9,0x12F0,0x1387,
	0x1482,0x15D7,0x160F,0x1575,0x1532,0x15F8,0x1759,0x1858,
	0x18D6,0x1844,0x1747,0x1676,0x1687,0x174D,0x1862,0x1840,
	0x1862,0x1984,0x1966,0x16E5,0x1586,0x1660,0x1809,0x1887,
	0x181E,0x1738,0x1643,0x1628,0x167F,0x171C,0x17B4,0x17EF,
	0x17EF,0x1746,0x1752,0x170E,0x1622,0x1512,0x14CF,0x15BE,
	0x1691,0x15E9,0x1382,0x118F,0x1208,0x143A,0x151C,0x141B,
	0x1261,0x108B,0x0EFE,0x0E8D,0x0F9F,0x112D,0x1110,0x0FC5,
	0x0DFE,0x0D57,0x0D50,0x0C14,0x0A47,0x09C9,0x0BD0,0x0DD7,
	0x0D13,0x09FC,0x06A5,0x05CD,0x0788,0x092E,0x08C3,0x066B,
	0x0401,0x03BF,0x0562,0x05B9,0x04CF,0x0264,0x013F,0x019D,
	0x01E9,0x0139,0xFE33,0xF92D,0xF49F,0xF188,0xF060,0xF0F4,
	0xF41B,0xF87C,0xFAA3,0xF841,0xF178,0xE8F3,0xE1B7,0xE504,
	0xEE2B,0xF516,0xF8B6,0xF736,0xF1E7,0xEB60,0xE82A,0xE9CF,
	0xEF84,0xF5AC,0xF91B,0xF9EC,0xF918,0xF75F,0xF6C8,0xF740,
	0xF85B,0xFACE,0xFCFA,0xFF4F,0x010A,0x02BF,0x03F7,0x0400,
	0x0321,0x0235,0x01E4,0x022D,0x033E,0x05CF,0x08E5,0x0AD1,
	0x0AB2,0x06F0,0x0235,0xFE9C,0xFEA7,0x019D,0x04BC,0x061A,
	0x04E2,0x0284,0xFEF5,0xFAEC,0xF746,0xF66B,0xF802,0xFA99,
	0xFC33,0xFB7E,0xF767,0xF1EA,0xED34,0xEB31,0xEC5C,0xEDB4,
	0xEE2C,0xEE08,0xED2B,0xECB2,0xEC74,0xE893,0xE5CD,0xE518,
	0xE5AB,0xE760,0xE8DE,0xE9CD,0xE93F,0xE73C,0xE513,0xE3B4,
	0xE35C,0xE41E,0xE603,0xE928,0xEC00,0xECCC,0xEA50,0xE6BA,
	0xE5E8,0xE7BC,0xEA1A,0xED15,0xEFB4,0xF08E,0xF077,0xEFDA,
	0xEEFB,0xEEBF,0xEE8E,0xEF87,0xF27C,0xF64E,0xF830,0xF769,
	0xF4C7,0xF349,0xF3E1,0xF620,0xF87E,0xF973,0xF906,0xF89C,
	0xF8A1,0xF7BF,0xF7DF,0xF881,0xF782,0xF6CA,0xF733,0xF7F8,
	0xF85E,0xF887,0xF82B,0xF781,0xF567,0xF348,0xF1D0,0xF091,
	0xF003,0xF1BB,0xF3A2,0xF40F,0xF19C,0xEDE0,0xEAF7,0xEA77,
	0xEC68,0xEE98,0xEF74,0xEDCB,0xEB86,0xEABC,0xEAA5,0xEB85,
	0xEB75,0xEB04,0xEB3C,0xEB59,0xEB0B,0xEB8D,0xEC34,0xEC95,
	0xEC23,0xEB77,0xEBAF,0xEC27,0xEC3E,0xECCA,0xEF66,0xF20E,
	0xF2A0,0xF04D,0xEDDF,0xEDA0,0xEF95,0xF215,0xF422,0xF5FC,
	0xF68F,0xF5E3,0xF44A,0xF3B9,0xF3D7,0xF4F3,0xF6BD,0xF9F7,
	0xFB9B,0xFB46,0xF910,0xF5F7,0xF43A,0xF740,0xFBE4,0xFE91,
	0xFCE9,0xF9F7,0xF957,0xFA69,0xF9ED,0xFB0A,0xFAA9,0xF96E,
	0xFA99,0xFA75,0xFB07,0xFB1E,0xFA1B,0xF7DC,0xF765,0xF8DE,
	0xFA9D,0xFA07,0xF7D7,0xF6B8,0xF7AC,0xF941,0xF8F6,0xF72C,
	0xF4FA,0xF479,0xF588,0xF7D8,0xF8C1,0xF763,0xF499,0xF30E,
	0xF44F,0xF600,0xF785,0xF749,0xF6D5,0xF5CA,0xF561,0xF5DA,
	0xF724,0xF7CD,0xF848,0xF84F,0xF896,0xF8B7,0xF87B,0xF887,
	0xF8B5,0xFA3A,0xFAEF,0xFA80,0xF70E,0xF0EA,0xE93E,0xE174,
	0xDC3E,0xDA4F,0xDE5A,0xE76A,0xF155,0xF4E7,0xECCE,0xDCB5,
	0xCE3A,0xC9F5,0xD3B0,0xE584,0xF3E8,0xF7D4,0xF23A,0xE8A9,
	0xDF7E,0xDBBE,0xE051,0xEBA8,0xF951,0x0451,0x0833,0x052C,
	0xFFA7,0xFCD5,0xFEF8,0x04FE,0x0C76,0x12C6,0x16D2,0x1A77,
	0x1D0D,0x201A,0x225B,0x2118,0x1D8F,0x1BE9,0x1E77,0x24E9,
	0x2CFC,0x32DE,0x3381,0x2EA1,0x25FA,0x1F6E,0x1CF3,0x1F7A,
	0x24EE,0x2AC4,0x2DCA,0x2B01,0x234A,0x186E,0x0F2F,0x0B23,
	0x0FDC,0x169C,0x18F2,0x1656,0x0E48,0x04FD,0xFE63,0xFB58,
	0xFA87,0xFAF5,0xFBEB,0xFB40,0xF967,0xF6D2,0xF3DC,0xF115,
	0xED96,0xEA99,0xE8B8,0xE8F8,0xEA24,0xEB7F,0xED26,0xED17,
	0xEA4B,0xE6D2,0xE3B7,0xE371,0xE6A7,0xEB36,0xF012,0xF2D4,
	0xF287,0xF04E,0xEDB3,0xED13,0xEF6F,0xF43F,0xFA5D,0xFE6D,
	0xFECB,0xFD32,0xFCC2,0xFE08,0x000F,0x01C4,0x03C7,0x06AC,
	0x08F0,0x0A7E,0x0B11,0x0B90,0x0C16,0x0C48,0x0C32,0x0C56,
	0x0D53,0x0EAB,0x0FE3,0x1111,0x1212,0x1232,0x102E,0x0C68,
	0x09F1,0x0A31,0x0C24,0x0DC3,0x0E1C,0x0C99,0x08CA,0x04FF,
	0x02F2,0x0138,0x0072,0x0059,0x02A3,0x02DC,0xFFD8,0xFD06,
	0xF73A,0xF433,0xF4F8,0xF6F5,0xF801,0xF732,0xF4BD,0xF26D,
	0xF170,0xF126,0xF13A,0xF0C5,0xEFEA,0xF084,0xF193,0xF182,
	0xF07E,0xEFE0,0xF0CE,0xF26F,0xF2F5,0xF21B,0xF0E1,0xF178,
	0xF4D5,0xF869,0xFA2D,0xF88D,0xF5A0,0xF51E,0xF82E,0xFC6A,
	0xFF2E,0xFF6A,0xFE4E,0xFE23,0x0002,0x028B,0x0473,0x03FF,
	0x0349,0x0478,0x06AB,0x07E3,0x075C,0x0669,0x075A,0x0971,
	0x0A84,0x094C,0x074A,0x05EF,0x067F,0x08AB,0x0B20,0x0C4E,
	0x0A4B,0x05D3,0x0329,0x064B,0x0A40,0x0B15,0x0937,0x05E6,
	0x0432,0x0427,0x0428,0x02D2,0x00E1,0x006E,0x00EE,0x018E,
	0x01A6,0xFF97,0xFCB8,0xFB00,0xFB8F,0xFD6D,0xFD81,0xFC3D,
	0xFAAD,0xF8E8,0xF901,0xFA89,0xFB71,0xFA06,0xF82C,0xF692,
	0xF6E7,0xF8D0,0xFB31,0xFD03,0xFC81,0xF9C4,0xF7AD,0xF7D2,
	0xF9D0,0xFBF3,0xFCC1,0xFE25,0xFEDE,0xFD9C,0xFC04,0xF95D,
	0xF60E,0xF3C9,0xED9D,0xE3CE,0xDB12,0xD813,0xDE36,0xEB65,
	0xF80F,0xFAAA,0xEF07,0xDA4A,0xC7CC,0xC46E,0xD358,0xEA89,
	0xFD0B,0x00DA,0xF6D9,0xE74E,0xDB51,0xD8D4,0xE20C,0xF347,
	0x05C3,0x105E,0x0FC0,0x0753,0xFF0F,0xFD79,0x0336,0x0DA9,
	0x17E7,0x1E32,0x200C,0x2035,0x224B,0x25FE,0x28AB,0x2709,
	0x2322,0x2116,0x251E,0x2DD6,0x35AB,0x38F8,0x36E5,0x30BF,
	0x29AF,0x23BB,0x2108,0x2376,0x2A5D,0x3156,0x32A2,0x2BB6,
	0x201A,0x14AF,0x0E77,0x0F98,0x155F,0x19D3,0x194F,0x1356,
	0x0A38,0x0388,0xFEFA,0xFC5C,0xFA00,0xF906,0xF976,0xF9F4,
	0xF785,0xF357,0xEF16,0xEB80,0xE972,0xE93F,0xE4CA,0xE371,
	0xE3D1,0xE639,0xE969,0xEAC0,0xE82E,0xE2E0,0xDEC9,0xDEA0,
	0xE2E1,0xE902,0xEE14,0xF08E,0xF06C,0xEDD0,0xEB8D,0xEA7F,
	0xECA8,0xF152,0xF706,0xFBF5,0xFF40,0x00A7,0xFEC4,0xFC80,
	0xFBC4,0xFEFB,0x0463,0x090F,0x0AD2,0x0BA2,0x0C2C,0x0D84,
	0x0E33,0x0D5F,0x0CCA,0x0D86,0x0FBF,0x11F0,0x131A,0x12A1,
	0x1219,0x11E5,0x10E7,0x0E12,0x0BA3,0x0B69,0x0D5A,0x0FA6,
	0x100D,0x0CDF,0x08ED,0x0581,0x0351,0x033F,0x0317,0x01F3,
	0x00A2,0x001B,0xFF07,0xFCF4,0xF928,0xF420,0xF29F,0xF37A,
	0xF493,0xF423,0xF22D,0xF083,0xEF8D,0xEFC7,0xEFF4,0xEED6,
	0xECDA,0xEBEC,0xED0F,0xEF3C,0xF149,0xF0EC,0xEFAF,0xEE7B,
	0xEE67,0xF056,0xF246,0xF2AB,0xF3E7,0xF633,0xF773,0xF805,
	0xF8F1,0xF9C3,0xF92F,0xF8C2,0xFA23,0xFE49,0x0251,0x0420,
	0x039A,0x027B,0x026E,0x02C2,0x03A4,0x0599,0x0877,0x0A12,
	0x0AD1,0x0A20,0x08E6,0x08BB,0x07FB,0x06EC,0x07B6,0x0A6E,
	0x0C83,0x0C1F,0x0A89,0x0A08,0x0A2B,0x09C2,0x08BE,0x0818,
	0x0801,0x08E5,0x0855,0x0796,0x0631,0x0464,0x028F,0x00C6,
	0x0091,0x0191,0x01C9,0x00C8,0xFEF2,0xFDA4,0xFCBB,0xFC22,
	0xFAE4,0xF9AB,0xF9A6,0xFA86,0xFB6A,0xFB35,0xF950,0xF728,
	0xF652,0xF6E1,0xF87E,0xF9AB,0xF9EC,0xF903,0xF7BB,0xF799,
	0xF90B,0xFAB1,0xFBAE,0xFB2A,0xFAA9,0xFB4E,0xFBD7,0xFC15,
	0xFD60,0xFFAF,0x0178,0xFF4A,0xF943,0xF17A,0xE881,0xDFBB,
	0xDAB0,0xDD7D,0xE81F,0xF52B,0xFBFB,0xF76A,0xE824,0xD475,
	0xC849,0xCC38,0xDED8,0xF52D,0x02EB,0xFF84,0xF40B,0xE642,
	0xDCCE,0xDF8A,0xEC11,0xFC13,0x0902,0x0EB0,0x0D48,0x086F,
	0x043F,0x035D,0x0762,0x0FA8,0x17F0,0x1DCC,0x2082,0x2314,
	0x2634,0x28D1,0x28B1,0x261D,0x2264,0x2144,0x2576,0x2DFF,
	0x3740,0x3C73,0x3987,0x2F3D,0x2436,0x1E4A,0x1FF3,0x26CF,
	0x2E42,0x32B0,0x316B,0x29C2,0x1DC8,0x1271,0x0DC6,0x0FD5,
	0x14F0,0x18B9,0x189E,0x138D,0x0B25,0x0319,0xFD3F,0xF9EB,
	0xF840,0xF7E4,0xF802,0xF881,0xF7C1,0xF50F,0xF05B,0xEB79,
	0xE636,0xE2CD,0xE310,0xE7CB,0xEC18,0xEF1C,0xEF0E,0xEB59,
	0xE5A9,0xE0AF,0xDF82,0xE21C,0xE845,0xEF14,0xF39A,0xF406,
	0xF19A,0xEE0B,0xEB04,0xEABD,0xEF7E,0xF71D,0xFCE6,0x0108,
	0x019E,0xFFBE,0xFE05,0xFD9C,0xFE17,0x018F,0x06F4,0x0B36,
	0x0DF9,0x0F25,0x0E8E,0x0D0E,0x0B60,0x0B78,0x0DB6,0x0FF7,
	0x1224,0x130A,0x139F,0x1391,0x1266,0x104A,0x0E0D,0x0BA2,
	0x09F5,0x0BB2,0x0E73,0x0E5E,0x0C42,0x09BB,0x0717,0x042C,
	0x01B3,0xFF2D,0xFE1B,0xFE47,0xFEC2,0xFF30,0xFDDD,0xFA54,
	0xF565,0xF0BE,0xEED6,0xEFC0,0xF283,0xF465,0xF422,0xF1EB,
	0xEE1D,0xE9FA,0xE8E2,0xEAC6,0xECBD,0xEE59,0xEED3,0xEF28,
	0xEE9B,0xED25,0xEC58,0xECBD,0xEE6C,0xF086,0xF200,0xF31E,
	0xF2CB,0xF237,0xF35E,0xF5DD,0xF7FF,0xF869,0xF81A,0xF807,
	0xFA0A,0xFCA6,0xFF1A,0xFFE3,0xFFBE,0xFFA0,0xFFB9,0x00F1,
	0x0344,0x0560,0x067D,0x064D,0x0597,0x04F0,0x052C,0x05F9,
	0x0735,0x0814,0x08F3,0x0902,0x07A9,0x0557,0x04CF,0x05B4,
	0x07D5,0x08D1,0x0800,0x04D5,0x03C0,0x0200,0x0074,0x0248,
	0x0360,0x02D3,0x008C,0xFECD,0xFDB6,0xFE00,0xFD79,0xFBC7,
	0xF9B8,0xF9BC,0xFB57,0xFC27,0xFA84,0xF7DD,0xF64A,0xF68D,
	0xF894,0xF8FA,0xF827,0xF682,0xF663,0xF748,0xF7F8,0xF80A,
	0xF78D,0xF7AF,0xF8B7,0xFA06,0xFA86,0xFA58,0xF977,0xF894,
	0xF94A,0xFB57,0xFD6D,0xFDFC,0xFD82,0xFCED,0xFB30,0xF708,
	0xEF42,0xE5ED,0xDDB8,0xDA11,0xDD3A,0xE789,0xF446,0xFA8F,
	0xF416,0xE2CD,0xD038,0xC86C,0xD034,0xE2A0,0xF59E,0x001F,
	0xFDD8,0xF17B,0xE3DF,0xDD7E,0xE06D,0xEBD7,0xFB51,0x0746,
	0x0D46,0x0BFB,0x06B7,0x027A,0x02EF,0x08EB,0x1097,0x16CC,
	0x1B5A,0x1F12,0x22E7,0x2708,0x29A7,0x2904,0x2503,0x1FFE,
	0x201F,0x27FB,0x32C6,0x3A1E,0x3BC6,0x363D,0x2D7F,0x256F,
	0x2143,0x21F1,0x27DB,0x2F9B,0x3407,0x3191,0x28A9,0x1D41,
	0x139C,0x0FCF,0x1169,0x166F,0x1AAB,0x19C2,0x12B7,0x09D9,
	0x03D9,0xFF5F,0xFC92,0xF9D7,0xF8B5,0xF93C,0xF9E6,0xF8BA,
	0xF534,0xF07D,0xEC17,0xE86F,0xE61B,0xE668,0xE992,0xED17,
	0xEEB7,0xEDD7,0xEB76,0xE791,0xE375,0xE1A9,0xE438,0xEA37,
	0xF125,0xF4B9,0xF353,0xF086,0xEEAE,0xEE84,0xF07A,0xF4B0,
	0xF9AA,0xFE11,0xFF87,0x0012,0x00F9,0x027B,0x038E,0x03CF,
	0x0505,0x07C6,0x0B42,0x0DF4,0x0F53,0x0FC9,0x104D,0x1009,
	0x0F4A,0x0F03,0x0F85,0x107B,0x1273,0x1460,0x152C,0x1475,
	0x1154,0x0DB0,0x0BD8,0x0BDB,0x0D43,0x0E90,0x0EAC,0x0DA6,
	0x0B1F,0x073E,0x0371,0x0171,0x00FC,0x023D,0x031B,0x028C,
	0xFFA4,0xFBE8,0xF853,0xF6D3,0xF56C,0xF43C,0xF5E2,0xF509,
	0xF430,0xF3A0,0xF20C,0xF038,0xEEAF,0xED50,0xECEB,0xEE7F,
	0xF008,0xF10F,0xF09A,0xEF88,0xEECB,0xEE84,0xEEB9,0xEF71,
	0xF0CE,0xF373,0xF645,0xF78B,0xF6AB,0xF4A9,0xF42D,0xF5DE,
	0xF9BA,0xFD72,0xFFB1,0xFF40,0xFE5B,0xFE3A,0xFEC4,0xFF8C,
	0x0081,0x02B0,0x0551,0x075F,0x0808,0x0731,0x05DD,0x052F,
	0x06A3,0x08F4,0x0A66,0x0AE8,0x0A11,0x0872,0x07A3,0x084E,
	0x0A73,0x0B55,0x09A2,0x07A9,0x0601,0x061D,0x06F9,0x066B,
	0x054F,0x046E,0x05DE,0x05FF,0x048D,0x0345,0x01BE,0x0035,
	0xFFBA,0xFFF0,0x0038,0xFE4F,0xFBA8,0xFA25,0xFA77,0xFAF0,
	0xFAF1,0xFA4C,0xFA41,0xF983,0xF81E,0xF611,0xF535,0xF6F8,
	0xF878,0xF8EC,0xF92C,0xF8C9,0xF665,0xF51F,0xF587,0xF713,
	0xF9F8,0xFB9C,0xFA82,0xF867,0xF72B,0xF878,0xFB0F,0xFCFC,
	0xFD2C,0xFBE4,0xF89F,0xF230,0xE9AE,0xE0B1,0xDA09,0xD7AC,
	0xDC47,0xE8DC,0xF550,0xF924,0xEF9C,0xDC2D,0xC9D8,0xC5BF,
	0xD1BF,0xE608,0xF701,0xFDC5,0xF894,0xEB99,0xDDF4,0xD887,
	0xDE99,0xED03,0xFD80,0x0906,0x0C5D,0x08AE,0x01A0,0xFD35,
	0xFF23,0x0750,0x10E3,0x17F4,0x1B97,0x1E2A,0x21EB,0x25AC,
	0x262D,0x235A,0x1F5C,0x1DCD,0x214F,0x28EB,0x3180,0x363F,
	0x3509,0x2F13,0x27EE,0x2254,0x1F50,0x1FEE,0x24F3,0x2C25,
	0x2F95,0x2BC9,0x20D2,0x1422,0x0C5A,0x0BD9,0x104C,0x1486,
	0x1597,0x122A,0x0B19,0x033D,0xFD23,0xF919,0xF650,0xF512,
	0xF5FC,0xF730,0xF69D,0xF2CB,0xED57,0xE878,0xE6C7,0xE65F,
	0xE5E6,0xE485,0xE2E9,0xE3CE,0xE86A,0xE8B3,0xE7B3,0xE3F8,
	0xDF83,0xDE90,0xE1B7,0xE6F5,0xEBC4,0xEE60,0xEE3A,0xED26,
	0xEC69,0xECC9,0xEE0C,0xF08D,0xF4F2,0xFA57,0xFE8C,0x002F,
	0xFF03,0xFDB4,0xFEAC,0x014A,0x0450,0x063B,0x085A,0x0B02,
	0x0DFD,0x1060,0x102D,0x0D8A,0x0AA7,0x0A5A,0x0DCF,0x12E9,
	0x15C7,0x1508,0x11BB,0x0F02,0x0DBE,0x0D7D,0x0D7A,0x0DE2,
	0x0EA2,0x0E2B,0x0C9F,0x0AD8,0x08C3,0x067E,0x03DB,0x02BC,
	0x0328,0x0388,0x02CD,0x00FB,0xFE7C,0xFC1A,0xF92A,0xF6CD,
	0xF598,0xF5A8,0xF580,0xF463,0xF1BE,0xF08D,0xEFD3,0xEEDA,
	0xEDBD,0xECFA,0xECF7,0xEDB9,0xEE9B,0xEE9E,0xEF72,0xF05F,
	0xF03D,0xEFF0,0xEF5E,0xEF79,0xF05A,0xF25B,0xF428,0xF624,
	0xF8E7,0xFACB,0xF9F7,0xF7A2,0xF6F5,0xF901,0xFCBD,0x0066,
	0x02CA,0x0385,0x02A8,0x00B8,0xFF93,0x0155,0x050D,0x0804,
	0x0927,0x094A,0x0917,0x08B7,0x0854,0x07CB,0x07C9,0x0A91,
	0x0B70,0x0B20,0x0AC9,0x0986,0x084F,0x073E,0x0795,0x07BF,
	0x073C,0x05D8,0x05C2,0x0702,0x0826,0x0760,0x04BC,0x0163,
	0xFFF6,0x011E,0x0266,0x0259,0x00F9,0xFF39,0xFD74,0xFC43,
	0xFA78,0xF935,0xF9E6,0xFAF0,0xFBA3,0xFBBA,0xFAFB,0xF869,
	0xF55C,0xF473,0xF651,0xF95B,0xFABE,0xF991,0xF74A,0xF5B1,
	0xF510,0xF5FF,0xF80C,0xFA62,0xFB44,0xFAFD,0xFA08,0xF8EF,
	0xF902,0xFAB4,0xFD27,0xFFE2,0x0074,0xFDBB,0xF7EE,0xEF3D,
	0xE735,0xE0C5,0xDC65,0xDBFD,0xE21A,0xED00,0xF69D,0xF64E,
	0xEA20,0xD787,0xC9C3,0xCA15,0xD7C8,0xEB95,0xFB62,0xFFB1,
	0xF71B,0xE7E3,0xDC8A,0xDBFF,0xE474,0xF545,0x0539,0x0C9F,
	0x0DCF,0x08D6,0x01A5,0xFDC2,0x0167,0x0B71,0x168D,0x1E50,
	0x210B,0x20F0,0x20FD,0x2272,0x245B,0x2598,0x24E8,0x239A,
	0x2507,0x2B11,0x32AC,0x383C,0x3775,0x309B,0x2701,0x208E,
	0x20EC,0x2623,0x2BE1,0x2F83,0x2F52,0x2A98,0x2230,0x1805,
	0x1052,0x0E96,0x11F9,0x1723,0x1A0F,0x16F9,0x0E81,0x0463,
	0xFCB2,0xF96D,0xF9B9,0xFAD4,0xFA62,0xF8E5,0xF6D9,0xF446,
	0xF035,0xEB12,0xE6A1,0xE472,0xE4D4,0xE676,0xE85E,0xEA22,
	0xEA56,0xE9E7,0xE89E,0xE420,0xE1AC,0xE259,0xE551,0xEAA1,
	0xF01C,0xF287,0xF165,0xEDDB,0xEA43,0xEA63,0xEDF0,0xF3E8,
	0xF961,0xFD58,0xFFAF,0xFF81,0xFD36,0xFA56,0xFAFF,0xFF76,
	0x057D,0x0B07,0x0DA4,0x0BB0,0x0852,0x0776,0x0A0B,0x0E2B,
	0x10B3,0x0FEE,0x0DB7,0x0D52,0x0F9B,0x1248,0x1213,0x1001,
	0x0D9F,0x0C5D,0x0C00,0x0BA6,0x0BEF,0x0CAA,0x0C41,0x0A49,
	0x0987,0x0757,0x02CD,0xFEE8,0xFE56,0x0165,0x0485,0x0423,
	0xFF0C,0xF85A,0xF463,0xF3DE,0xF4EA,0xF4E8,0xF311,0xF1C7,
	0xF119,0xF122,0xF097,0xEECA,0xEC66,0xEAF9,0xEB1D,0xECC7,
	0xEEED,0xEFD6,0xEF0F,0xEDBB,0xED05,0xED99,0xEE6E,0xEE5F,
	0xEE33,0xF02B,0xF34A,0xF68D,0xF815,0xF729,0xF587,0xF4BC,
	0xF5BB,0xF824,0xFB3E,0xFD43,0xFE68,0xFEE6,0xFEF3,0xFF4C,
	0xFEF0,0xFECF,0x0077,0x03F8,0x06F6,0x075E,0x057B,0x0390,
	0x03D9,0x063C,0x082B,0x08DF,0x07EF,0x06F8,0x0582,0x0594,
	0x065C,0x0780,0x07FA,0x06D8,0x04A0,0x0360,0x02FD,0x0346,
	0x0363,0x02BE,0x014A,0x0295,0x024F,0xFEB3,0xFD53,0xFB77,
	0xFBDD,0xFC9C,0xFCDD,0xFC54,0xFB58,0xF9CD,0xF873,0xF7D7,
	0xF7B0,0xF7A6,0xF77F,0xF777,0xF7B6,0xF7E6,0xF727,0xF64D,
	0xF4EF,0xF510,0xF5F9,0xF771,0xF929,0xF915,0xF83C,0xF732,
	0xF754,0xF886,0xF991,0xFA1C,0xFB06,0xFBE2,0xFC58,0xFC93,
	0xFC31,0xF94A,0xF2E0,0xEA1D,0xE317,0xE128,0xE474,0xECA5,
	0xF5DE,0xFB38,0xF805,0xEBDE,0xDD6B,0xD610,0xDAAE,0xE88F,
	0xF772,0xFFDF,0xFEB6,0xF66D,0xEC23,0xE67B,0xE8EA,0xF213,
	0xFE3B,0x07C1,0x0BB8,0x0949,0x0480,0x01A2,0x0206,0x0621,
	0x0C49,0x123F,0x15C9,0x17EC,0x1B15,0x1E59,0x1FE3,0x1E01,
	0x1AE0,0x195A,0x1AC9,0x1F8B,0x2530,0x2A49,0x2BD9,0x2993,
	0x24F2,0x1DC1,0x17A2,0x1669,0x1ACB,0x2191,0x26BC,0x2672,
	0x1F9C,0x15AC,0x0D4B,0x0A46,0x0BDF,0x0F03,0x11A6,0x1299,
	0x0FF9,0x0A05,0x028E,0xFBC0,0xF859,0xF891,0xFA19,0xFCC0,
	0xFCA3,0xFA85,0xF670,0xF14D,0xED99,0xEBC7,0xEB77,0xEBA3,
	0xECAD,0xEED4,0xF188,0xF250,0xF068,0xEC11,0xE87F,0xE780,
	0xE9DA,0xEEBD,0xF325,0xF59A,0xF587,0xF3D3,0xF1C7,0xF102,
	0xF27B,0xF557,0xF8B5,0xFCE8,0x000B,0x0125,0xFFEA,0xFEB2,
	0xFF6C,0x00AB,0x0280,0x0481,0x0768,0x09BB,0x0B3F,0x0BEF,
	0x0BF8,0x0BD0,0x0B8C,0x0AFC,0x0ADB,0x0C60,0x0EE5,0x10E1,
	0x118C,0x0FD6,0x0C4F,0x0987,0x08BF,0x092B,0x098E,0x09EF,
	0x0A5A,0x0A33,0x091A,0x06A6,0x035A,0x00E1,0xFF92,0xFF4E,
	0x00B1,0x0209,0x01FD,0xFEAE,0xFA1D,0xF76C,0xF721,0xF745,
	0xF6F4,0xF70E,0xF820,0xF83E,0xF638,0xF551,0xF1D1,0xF02D,
	0xF073,0xF19E,0xF362,0xF57A,0xF5F9,0xF4AD,0xF27C,0xF174,
	0xF1D1,0xF351,0xF461,0xF572,0xF776,0xF9AC,0xFA61,0xF8B3,
	0xF711,0xF784,0xFAA6,0xFDCF,0xFE9C,0xFE7F,0xFEC4,0x0015,
	0x0129,0x01B3,0x0248,0x028C,0x029F,0x0363,0x0503,0x0688,
	0x06BD,0x0641,0x063A,0x070A,0x0754,0x0750,0x05FD,0x0573,
	0x063A,0x074E,0x07DC,0x076C,0x05FB,0x0497,0x0432,0x0445,
	0x0463,0x03CA,0x02FC,0x0253,0x0233,0x01DE,0x00B0,0xFF4D,
	0xFE1A,0xFFD2,0x0073,0x0012,0xFFBA,0xFEC1,0xFD4D,0xFBB2,
	0xFA91,0xF9CF,0xF9D0,0xFAB0,0xFBF4,0xFC4B,0xFB25,0xF896,
	0xF6CE,0xF73C,0xF91C,0xF9E9,0xF972,0xF91A,0xF9C8,0xF996,
	0xF8D1,0xF943,0xFA41,0xF9D0,0xF9E8,0xFB79,0xFDDE,0xFE00,
	0xFBF3,0xFA43,0xFAB9,0xFCBB,0xFEB9,0xFE78,0xFCE7,0xFB0E,
	0xF8EF,0xF754,0xF708,0xF9C3,0xFD9E,0x00EB,0xFFB6,0xFBC5,
	0xF8A6,0xF5F2,0xF5AA,0xF8C6,0xFF00,0x0411,0x04BA,0x002A,
	0xFA7B,0xF802,0xF93A,0xFC62,0xFFE2,0x01ED,0x0366,0x02F7,
	0x000A,0xFE24,0xFE71,0x002E,0x01C6,0x02FA,0x044E,0x04FE,
	0x0460,0x0393,0x03D7,0x0474,0x0475,0x0454,0x04F8,0x0626,
	0x06A9,0x068C,0x0703,0x0733,0x0557,0x0298,0x0022,0x00E7,
	0x03A6,0x05D9,0x0605,0x03E3,0x0167,0xFFB9,0xFF10,0xFF5F,
	0xFFCB,0xFFFD,0x0020,0x0049,0xFFF2,0xFF0C,0xFD2D,0xFC00,
	0xFBB3,0xFBFB,0xFD2E,0xFDF3,0xFD2F,0xFB62,0xF8FE,0xF8E3,
	0xFABD,0xFCCD,0xFC66,0xFA11,0xF85C,0xF960,0xFB48,0xFCAB,
	0xFD05,0xFBE8,0xFB47,0xFC81,0xFA1F,0xFA19,0xFBBD,0xFDB6,
	0x0042,0x0136,0xFFAB,0xFCFA,0xFB27,0xFB54,0xFD90,0x00BB,
	0x0374,0x036F,0x01BA,0xFF02,0xFDB1,0xFDDC,0xFE9C,0xFEF2,
	0xFF10,0xFFB5,0xFFD0,0xFF58,0xFDE6,0xFC76,0xFB89,0xFB42,
	0xFA91,0xF9C7,0xF900,0xF831,0xF715,0xF5FE,0xF560,0xF5E8,
	0xF68F,0xF704,0xF799,0xF829,0xF876,0xF826,0xF73B,0xF645,
	0xF521,0xF488,0xF44B,0xF42B,0xF442,0xF4CC,0xF42D,0xF390,
	0xF306,0xF1E5,0xF17F,0xF179,0xF16D,0xF0D8,0xEFDD,0xEF8C,
	0xEEEB,0xEE7F,0xED89,0xEB03,0xEA60,0xEA6F,0xEA30,0xEA08,
	0xEA15,0xEA0F,0xE9CA,0xE945,0xE905,0xE8D6,0xE875,0xE7DE,
	0xE79F,0xE7A2,0xE7DD,0xE7CD,0xE82E,0xE77B,0xE637,0xE698,
	0xE766,0xE770,0xE78B,0xE7DA,0xE7D9,0xE85E,0xE8A6,0xE886,
	0xE86C,0xE87C,0xE84A,0xE8C4,0xE938,0xE9C8,0xE9EC,0xEA3B,
	0xEA3E,0xE9F6,0xEA87,0xEB06,0xEBC0,0xEB58,0xED14,0xEE08,
	0xED32,0xED21,0xED37,0xED97,0xEDB8,0xEE8A,0xEF93,0xF035,
	0xF0C2,0xF138,0xF199,0xF210,0xF2E6,0xF43D,0xF4AD,0xF4E3,
	0xF57C,0xF5B5,0xF5FD,0xF63C,0xF690,0xF6C5,0xF78D,0xF855,
	0xF86B,0xF8F2,0xF8C1,0xF8CF,0xF94C,0xF9BC,0xFAAC,0xFB0E,
	0xFB1C,0xFAF1,0xFAFA,0xFB88,0xFC50,0xFCF4,0xFD77,0xFDAB,
	0xFD94,0xFD94,0xFDE1,0xFE22,0xFE66,0xFEAF,0xFF46,0xFFD5,
	0x001E,0x0026,0x001B,0xFFF5,0x0084,0x0127,0x019A,0x0217,
	0x0264,0x029B,0x02C4,0x0329,0x0365,0x03F2,0x0459,0x04BC,
	0x04C1,0x0556,0x05E5,0x060A,0x05FD,0x069E,0x070C,0x0734,
	0x0771,0x0851,0x08C7,0x0717,0x0897,0x092B,0x085E,0x08CD,
	0x08E8,0x08E9,0x0937,0x0924,0x0950,0x09B6,0x0A2B,0x0A52,
	0x0A54,0x0A30,0x0A46,0x0A9B,0x0B72,0x0B9F,0x0B09,0x0ADF,
	0x0AE3,0x0B97,0x0B9A,0x0BE2,0x0BFB,0x0C18,0x0BE1,0x0BE0,
	0x0BE0,0x0C29,0x0C85,0x0CA8,0x0CD1,0x0CDF,0x0D3A,0x0D09,
	0x0CB2,0x0C8F,0x0CCC,0x0D0A,0x0D87,0x0D74,0x0D35,0x0D43,
	0x0D93,0x0D8B,0x0DA7,0x0DB9,0x0D76,0x0D79,0x0D67,0x0DA7,
	0x0DAE,0x0E02,0x0DDA,0x0DBC,0x0D8F,0x0DC1,0x0DE5,0x0DFE,
	0x0EFA,0x10F0,0x105D,0x0FF4,0x0FE2,0x0F72,0x0F49,0x0F13,
	0x0EFB,0x0F15,0x0E8D,0x0E91,0x0EBA,0x0E8D,0x0E4A,0x0DFF,
	0x0E0E,0x0DB1,0x0D73,0x0D95,0x0D15,0x0DB8,0x0E26,0x0D53,
	0x0CED,0x0D52,0x0CB0,0x0C83,0x0C97,0x0C65,0x0CC2,0x0C50,
	0x0BEE,0x0BEB,0x0C00,0x0BBC,0x0BDE,0x0BDC,0x0BE6,0x0BC4,
	0x0B79,0x0B56,0x0AE6,0x0AC8,0x0B88,0x0B78,0x0A4C,0x0A88,
	0x0B79,0x0B3A,0x0AD4,0x0AAE,0x0ADE,0x0A7E,0x0A7D,0x0A7D,
	0x0A0D,0x09C4,0x097C,0x08E9,0x0870,0x0873,0x087A,0x07E3,
	0x0796,0x0746,0x06F2,0x0725,0x07BC,0x0805,0x07B4,0x07B2,
	0x07C1,0x0755,0x078A,0x07CD,0x07B2,0x0728,0x06F7,0x0737,
	0x06EA,0x068B,0x065A,0x0690,0x06C8,0x06A7,0x067E,0x0683,
	0x0669,0x05F2,0x05F5,0x05E7,0x0606,0x0604,0x0655,0x069C,
	0x061B,0x05BF,0x05B9,0x055E,0x055C,0x0589,0x05D1,0x05D5,
	0x0595,0x0511,0x04FA,0x04DB,0x0535,0x04E1,0x04BF,0x04AC,
	0x0517,0x04AB,0x047D,0x0509,0x05DA,0x0572,0x04FC,0x04E4,
	0x058A,0x04A2,0x06B0,0x0663,0x0453,0x056B,0x0520,0x051B,
	0x056B,0x056F,0x051F,0x04F3,0x051C,0x055F,0x051A,0x0508,
	0x04F2,0x04BD,0x04DC,0x0491,0x0462,0x045B,0x0449,0x044D,
	0x0435,0x0434,0x03EF,0x0416,0x03D1,0x03DF,0x03EF,0x03D4,
	0x0372,0x03C5,0x03E8,0x03FA,0x0410,0x042D,0x047A,0x0428,
	0x039A,0x03BA,0x03A8,0x0323,0x030F,0x02FE,0x02DF,0x032C,
	0x0360,0x036D,0x0372,0x02FE,0x02CE,0x0322,0x0336,0x033E,
	0x0359,0x03B2,0x03DA,0x03A7,0x034C,0x0314,0x02F9,0x02A1,
	0x02D8,0x02BC,0x0119,0x0028,0x006B,0x00BB,0x0133,0x0161,
	0x0181,0x01CA,0x01D3,0x0204,0x01DA,0x01B8,0x01D3,0x019B,
	0x0111,0x00F2,0x013D,0x01BE,0x0245,0x0224,0x01B0,0x0143,
	0x00A6,0x0119,0x01D7,0x0247,0x02A4,0x0313,0x03A2,0x03C3,
	0x03B6,0x03FD,0x04AA,0x05B8,0x0693,0x0760,0x08F7,0x0A66,
	0x0A9C,0x09AF,0x0920,0x090F,0x08D2,0x08E1,0x08D1,0x0887,
	0x085C,0x07FF,0x07D5,0x07F2,0x0885,0x08B8,0x088E,0x0837,
	0x07F6,0x07B3,0x074F,0x06C9,0x0773,0x095B,0x0C72,0x0DD4,
	0x0DBC,0x0D08,0x0CBF,0x0D1F,0x0DB0,0x0F44,0x118A,0x1091,
	0x118C,0x135A,0x124D,0x1305,0x14BC,0x1600,0x15D9,0x15C6,
	0x1626,0x163C,0x1613,0x1562,0x1507,0x15F1,0x175B,0x1825,
	0x17EF,0x1717,0x16D6,0x166A,0x1613,0x15FA,0x1676,0x1673,
	0x1622,0x1658,0x1758,0x17B8,0x17A9,0x16B5,0x1572,0x14A6,
	0x1490,0x1503,0x1521,0x1567,0x14B8,0x13F7,0x1355,0x1395,
	0x1490,0x14D5,0x13FA,0x12BD,0x11F8,0x1187,0x116B,0x1200,
	0x125F,0x126F,0x120C,0x1169,0x10FF,0x0FE7,0x0DE8,0x0BBC,
	0x0970,0x064B,0x0237,0xFD47,0xF966,0xF8B8,0xF91C,0xFE5A,
	0x05E9,0x0B9F,0x0C2D,0x07BB,0x0057,0xFA71,0xF90B,0xFC76,
	0x0452,0x0BC2,0x107F,0x1223,0x128C,0x128F,0x11BA,0x0FEE,
	0x0DAD,0x0E4E,0x10C6,0x123F,0x12F2,0x13F7,0x13E0,0x133C,
	0x128A,0x11FF,0x10BF,0x0D43,0x0780,0x00DA,0xFDDB,0xFEB1,
	0x020D,0x04B6,0x04E2,0x00E7,0xFBAE,0xF6C5,0xF20D,0xEF60,
	0xEE80,0xEE76,0xEEB9,0xF149,0xF477,0xF53C,0xF36A,0xF0D4,
	0xEEE5,0xEF09,0xF082,0xF1F7,0xF28E,0xF2AE,0xF371,0xF5A4,
	0xF8FC,0xFC1A,0xFD12,0xFB77,0xF8F4,0xF7A2,0xF7E8,0xF9D9,
	0xFBB0,0xFC6C,0xFD4B,0xFE57,0xFEB2,0xFD9D,0xFB14,0xF6A7,
	0xF3EB,0xF369,0xF426,0xF507,0xF4E0,0xF34A,0xF0E9,0xEF71,
	0xEEA9,0xEE1A,0xECAB,0xEA48,0xE772,0xE6D3,0xE855,0xEA75,
	0xEB96,0xEBE3,0xEAD3,0xE9B3,0xE986,0xE9C8,0xE9EB,0xE9A5,
	0xEA32,0xEBF7,0xEDED,0xF012,0xF1B4,0xF2E7,0xF306,0xF2FC,
	0xF2BF,0xF229,0xF26E,0xF32E,0xF36D,0xF47B,0xF6F1,0xF815,
	0xF880,0xF6BD,0xF3EC,0xF28B,0xF2B1,0xF174,0xF292,0xF265,
	0xEF73,0xEF82,0xEF24,0xF089,0xF0F5,0xEEFC,0xEC29,0xEA7F,
	0xEA04,0xEAD7,0xEBA3,0xEBE1,0xEC1E,0xEBB0,0xEBD8,0xEC7F,
	0xEE18,0xEEB5,0xEDD7,0xEBF6,0xEC45,0xEE13,0xF026,0xF21D,
	0xF2E1,0xF26C,0xF1FB,0xF2BE,0xF375,0xF404,0xF3E5,0xF3C4,
	0xF3F4,0xF53C,0xF667,0xF70E,0xF6EA,0xF61E,0xF52F,0xF490,
	0xF4EA,0xF502,0xF4D0,0xF3C2,0xF2F2,0xF2F2,0xF339,0xF2C5,
	0xF1EF,0xF171,0xF0B2,0xEFF6,0xEF59,0xEF29,0xEEFD,0xEEF7,
	0xEE91,0xEE75,0xEF43,0xF045,0xF00E,0xEEF7,0xED59,0xEC5C,
	0xEDC0,0xEEDA,0xEFFB,0xF14E,0xF231,0xF293,0xF27D,0xF35A,
	0xF42B,0xF43F,0xF42D,0xF441,0xF563,0xF616,0xF593,0xF56B,
	0xF65C,0xF700,0xF70D,0xF779,0xF77C,0xF6C0,0xF53A,0xF4D8,
	0xF562,0xF63E,0xF6E8,0xF681,0xF632,0xF5D2,0xF573,0xF46C,
	0xF44C,0xF457,0xF4D5,0xF4B2,0xF417,0xF49B,0xF52B,0xF4C0,
	0xF442,0xF46B,0xF70A,0xF7EE,0xF73E,0xF5DA,0xF532,0xF5F8,
	0xF7A8,0xF8C5,0xF707,0xF18C,0xE77C,0xDA19,0xC9FC,0xC0E1,
	0xC142,0xC1E8,0xC0B1,0xCD4F,0xEB45,0xFDC8,0xFE50,0xECB3,
	0xD3AC,0xC35E,0xC33E,0xD4FE,0xF281,0x0E06,0x2009,0x2855,
	0x29E3,0x284B,0x2589,0x22D9,0x2219,0x2485,0x29DB,0x2FE1,
	0x34DD,0x38FB,0x3C49,0x3EC5,0x4006,0x3DF0,0x344F,0x2344,
	0x0FB2,0x000B,0xFACC,0x0049,0x0B48,0x1353,0x12E1,0x08AE,
	0xF742,0xE4F2,0xD72A,0xD000,0xCF68,0xD4C3,0xDD10,0xE4C4,
	0xE93E,0xE9EB,0xE732,0xE420,0xE32A,0xE545,0xE8D1,0xEBF5,
	0xEDFE,0xF2BA,0xFBBF,0x07FD,0x1474,0x1DCF,0x1FFF,0x1B41,
	0x1735,0x11AE,0x0FFC,0x1434,0x1ADE,0x22BE,0x29DB,0x2DBD,
	0x2C3F,0x245D,0x18B2,0x0DDB,0x06FC,0x041B,0x0466,0x05CA,
	0x05C2,0x02BB,0xFD30,0xF7E7,0xF3EB,0xF065,0xEBD5,0xE5FE,
	0xE025,0xDD09,0xDC93,0xDFA3,0xE48A,0xEA1B,0xEDD2,0xEEB7,
	0xEC9C,0xE995,0xE6F8,0xE6A0,0xE9F3,0xF136,0xFB4E,0x04CB,
	0x0AA6,0x0C24,0x0AEE,0x0945,0x086F,0x093A,0x0B8E,0x0ED4,
	0x1193,0x12B0,0x1305,0x1326,0x1334,0x1263,0x1006,0x0C67,
	0x07C2,0x02B0,0xFE32,0xFACE,0xFBB4,0xFE51,0xFF52,0xFEBA,
	0xFAFC,0xF4E3,0xEE5D,0xE91C,0xE61D,0xE67C,0xE848,0xEB12,
	0xED28,0xEE18,0xEE62,0xEE23,0xEE16,0xEEBE,0xEFCD,0xF16D,
	0xF3A8,0xF749,0xFA59,0xFC74,0xFF55,0x035D,0x062C,0x08AB,
	0x0A04,0x0A06,0x08BF,0x077E,0x08AA,0x0BA4,0x0E53,0x0F7D,
	0x0F17,0x0D75,0x0BD9,0x092C,0x06C8,0x04D6,0x024D,0x0002,
	0xFF42,0xFEAC,0xFD01,0xFBF0,0xF95D,0xF6B6,0xF572,0xF48F,
	0xF3AB,0xF299,0xF164,0xF021,0xEF8C,0xF026,0xF24F,0xF429,
	0xF46E,0xF3E7,0xF437,0xF4FF,0xF6BF,0xF7B3,0xF907,0xFBD1,
	0xFF2A,0x02A7,0x04DD,0x055A,0x04A4,0x03C3,0x03C9,0x0517,
	0x0801,0x0A0C,0x0A04,0x093B,0x082F,0x0769,0x0770,0x069C,
	0x0591,0x0399,0x0159,0x0015,0xFFBC,0xFF65,0xFDBE,0xFB69,
	0xFA04,0xFA45,0xFA32,0xF991,0xF7E6,0xF5EC,0xF430,0xF302,
	0xF3FD,0xF5F7,0xF828,0xF8D5,0xF868,0xF7CA,0xF7F2,0xF86A,
	0xF911,0xFA3E,0xFBF6,0xFE3C,0xFEBC,0xFC06,0xF581,0xEA28,
	0xDA14,0xC6B8,0xBECA,0xBFCE,0xBF87,0xC0AA,0xDD2A,0xFA75,
	0x094E,0x03BA,0xEBDE,0xD10C,0xC377,0xC92F,0xDFF6,0xFF6B,
	0x1D05,0x309E,0x37AF,0x367D,0x323F,0x2EB3,0x2B82,0x2A53,
	0x2D12,0x3371,0x3A85,0x3E88,0x3F67,0x3F3C,0x3F25,0x3EE3,
	0x3F8A,0x3902,0x22D5,0x0DC0,0x007A,0xFF3C,0x087E,0x1518,
	0x1C15,0x1806,0x0A01,0xF620,0xE2A7,0xD4D5,0xCEBF,0xD0B8,
	0xD86A,0xE1AF,0xE94E,0xECC4,0xEBEA,0xE94F,0xE74D,0xE6F7,
	0xE8D6,0xEB46,0xEDA0,0xF11B,0xF77F,0x0274,0x10A5,0x1D26,
	0x2449,0x2493,0x1FDB,0x1882,0x1396,0x134E,0x176E,0x2024,
	0x292D,0x2EF5,0x2F59,0x2A25,0x2135,0x1711,0x0E9B,0x090F,
	0x0571,0x03F9,0x03B5,0x035A,0x016A,0xFDA8,0xF8DB,0xF46A,
	0xEFAD,0xE883,0xE240,0xDE0D,0xDBE0,0xDC71,0xE04D,0xE71E,
	0xEDF0,0xF17C,0xF0A0,0xEC24,0xE86A,0xE814,0xEB64,0xF178,
	0xF8E7,0x00E1,0x0866,0x0CFA,0x0ECB,0x1007,0x1017,0x0F7C,
	0x0EF4,0x1090,0x1344,0x14B3,0x1619,0x1774,0x18EA,0x1962,
	0x1846,0x147A,0x0EFD,0x0904,0x0400,0x0100,0xFF60,0xFF7B,
	0x0132,0x019F,0xFED8,0xF9DF,0xF42C,0xEE9C,0xEACC,0xE9B0,
	0xE9E1,0xEB13,0xEC4C,0xED8C,0xEF32,0xF000,0xF0C5,0xF1B4,
	0xF29E,0xF460,0xF5B2,0xF6A5,0xF82D,0xFB4F,0xFFA6,0x0476,
	0x08F6,0x0C06,0x0C99,0x0BC0,0x0B12,0x0B5A,0x0C3A,0x0D64,
	0x0EB6,0x1072,0x118C,0x11C5,0x1070,0x0D53,0x0A38,0x074E,
	0x0435,0x0298,0x023A,0x01A6,0xFF9E,0xFD3B,0xFB9B,0xFAC9,
	0xF9BF,0xF746,0xF42E,0xF274,0xF1C3,0xF1B6,0xF11B,0xF0E7,
	0xF1C5,0xF468,0xF654,0xF754,0xF758,0xF727,0xF49D,0xF5AD,
	0xFA4E,0xFE01,0x021B,0x04C3,0x0580,0x05F9,0x06CE,0x0759,
	0x07FD,0x0870,0x0972,0x0A5E,0x0AC5,0x0AC4,0x0B33,0x0AF9,
	0x0A66,0x08F4,0x07C3,0x07A1,0x06B4,0x0460,0x01B2,0xFF0B,
	0xFDD8,0xFDA4,0xFD45,0xFCF3,0xFC14,0xFA33,0xF7F7,0xF591,
	0xF4AC,0xF4F4,0xF5DD,0xF6FC,0xF76A,0xF765,0xF756,0xF7DF,
	0xF927,0xFA7B,0xFB5C,0xFBD1,0xFD09,0xFDFD,0xFF1C,0x0046,
	0xFFE3,0xFD01,0xF5F5,0xE906,0xD848,0xC611,0xBEEA,0xC010,
	0xBF80,0xC5B1,0xE535,0x02BB,0x0EDF,0x02FF,0xE7DF,0xCD8D,
	0xC2D6,0xCDCB,0xE870,0x097E,0x243D,0x339E,0x38E6,0x36B8,
	0x31BA,0x2CB2,0x2A38,0x2B8D,0x3033,0x36E4,0x3DD5,0x3F31,
	0x3F6E,0x3FD1,0x3F9B,0x3E9B,0x3F64,0x36BF,0x1F03,0x0A6E,
	0xFE8B,0xFF95,0x0B2E,0x18EE,0x1EFB,0x1875,0x06F8,0xF0D2,
	0xDD85,0xD2C6,0xCFD7,0xD33F,0xDAC2,0xE38D,0xEA2F,0xEDAA,
	0xECE6,0xE7AD,0xE36D,0xE38A,0xE68D,0xEAFF,0xEF7E,0xF350,
	0xF88B,0x00A0,0x0D38,0x1A7E,0x22E9,0x233F,0x1CBC,0x1384,
	0x0CD1,0x0D7B,0x1500,0x1FD5,0x2940,0x2E06,0x2D2F,0x274F,
	0x1DEE,0x1281,0x08CB,0x034C,0x02AC,0x040B,0x0467,0x02B7,
	0xFEC6,0xF994,0xF4B0,0xF0D8,0xEC79,0xE76E,0xE07A,0xDA7C,
	0xD876,0xDA99,0xDFEF,0xE5A9,0xE9F4,0xECBB,0xEC88,0xE975,
	0xE5D7,0xE44D,0xE5F1,0xEBCD,0xF4C8,0xFE73,0x06D6,0x0B24,
	0x0BF1,0x0AC1,0x0975,0x096F,0x0A2D,0x0C20,0x0F0C,0x1138,
	0x12A5,0x1480,0x155A,0x1518,0x1327,0x0F91,0x0AD2,0x0585,
	0x0083,0xFD6E,0xFC6D,0xFCD0,0xFC7D,0xFD0A,0xFC3A,0xF60F,
	0xF1A7,0xEC9F,0xE8FA,0xE747,0xE698,0xE650,0xE822,0xEB2B,
	0xEE76,0xF049,0xEFFF,0xEF04,0xEDA2,0xEDA1,0xEF20,0xF326,
	0xF7D2,0xFBB9,0xFEBC,0x0116,0x0411,0x07A4,0x09B5,0x0967,
	0x07DB,0x0753,0x0871,0x0ACC,0x0D29,0x0E7C,0x0F00,0x0E24,
	0x0CA3,0x0B38,0x09EA,0x074C,0x0346,0xFF37,0xFCFD,0xFD3D,
	0xFE34,0xFE71,0xFCB5,0xF9AF,0xF61B,0xF375,0xF16B,0xF074,
	0xF05C,0xF08D,0xF14A,0xF313,0xF4DF,0xF544,0xF4CF,0xF4C4,
	0xF4D4,0xF634,0xF7E1,0xF9BA,0xFAB2,0xFA14,0xFA63,0xFDD3,
	0x01FE,0x04C7,0x058D,0x0557,0x0587,0x062D,0x06B1,0x06BE,
	0x0700,0x07DE,0x08ED,0x0AD0,0x0C21,0x0B79,0x08C3,0x05BD,
	0x0247,0x005C,0x00D6,0x0159,0x0109,0x0033,0xFF43,0xFDB3,
	0xFB87,0xFAF8,0xFA49,0xF924,0xF7BC,0xF6F4,0xF72E,0xF762,
	0xF7C2,0xF888,0xFA56,0xFBBA,0xFC82,0xFD08,0xFCC3,0xFC66,
	0xFCA4,0xFF34,0x00FD,0x02DE,0x02AA,0xFE8B,0xF481,0xE5A9,
	0xD29B,0xC27E,0xC060,0xC149,0xC076,0xCF7B,0xF1BA,0x0911,
	0x0CC8,0xFB63,0xDFDB,0xC998,0xC514,0xD4D8,0xF1A7,0x1007,
	0x27A2,0x34F3,0x39A0,0x37C6,0x3283,0x2D32,0x2A58,0x2B46,
	0x2FB9,0x3676,0x3D40,0x4052,0x401D,0x4048,0x4042,0x3FAD,
	0x3F79,0x2EB6,0x164E,0x045F,0xFDF8,0x0430,0x1139,0x1C02,
	0x1DD7,0x13F3,0x0130,0xEC31,0xDAF6,0xD164,0xCF84,0xD43A,
	0xDD25,0xE655,0xEC3C,0xEDF1,0xEC1B,0xE916,0xE6FD,0xE6F6,
	0xE8A9,0xEBD7,0xEF5B,0xF3E6,0xFC0A,0x08B8,0x1718,0x2255,
	0x2767,0x2402,0x1B15,0x12EC,0x1063,0x136E,0x1A92,0x269B,
	0x2DAC,0x3109,0x300E,0x28F4,0x1E4E,0x1290,0x08E9,0x0392,
	0x0365,0x05A4,0x0714,0x0514,0x001E,0xFAD0,0xF5EF,0xF18A,
	0xEC65,0xE603,0xDF84,0xDACD,0xD9A9,0xDCFC,0xE3D4,0xEAE4,
	0xEFA0,0xF02A,0xED8E,0xE9AF,0xE68E,0xE630,0xE9CD,0xF13B,
	0xFAF8,0x043B,0x0A27,0x0CD9,0x0D41,0x0CDC,0x0BC7,0x0BF5,
	0x0D25,0x0F3B,0x116B,0x132F,0x1490,0x166E,0x17BD,0x17B3,
	0x1543,0x1080,0x0AC4,0x0553,0x001F,0xFC50,0xFB0D,0xFC1A,
	0xFD24,0xFD29,0xFBC3,0xF91C,0xF370,0xEB67,0xE6C3,0xE5FB,
	0xE82A,0xEA7C,0xED33,0xEEE6,0xEF44,0xEEE1,0xEE5C,0xEEC4,
	0xEFC8,0xF12C,0xF2A6,0xF48B,0xF75F,0xFAA4,0xFED3,0x035C,
	0x07F0,0x0A87,0x09C5,0x0839,0x0758,0x06B6,0x0793,0x0A2D,
	0x0CA5,0x0FBA,0x10F2,0x1065,0x0DB6,0x097B,0x0572,0x026F,
	0x0000,0xFE89,0xFE49,0xFEC6,0xFF01,0xFC91,0xF8DE,0xF6B4,
	0xF3EC,0xF205,0xF0D2,0xEF3B,0xEEE6,0xEF4A,0xEFFB,0xF154,
	0xF2BF,0xF45C,0xF4CB,0xF464,0xF410,0xF468,0xF548,0xF533,
	0xF6CC,0xFA1D,0xFE1B,0x01F4,0x0450,0x04CE,0x0477,0x0364,
	0x02FC,0x03BA,0x04BF,0x062B,0x07D4,0x08A3,0x091A,0x0989,
	0x0884,0x05EB,0x0395,0x0201,0x012F,0x0127,0x0090,0xFEE0,
	0xFCEC,0xFB5D,0xFB4C,0xFB6A,0xFA99,0xF85D,0xF565,0xF33B,
	0xF290,0xF33D,0xF521,0xF6B6,0xF6C6,0xF5AE,0xF4DB,0xF586,
	0xF6F3,0xF812,0xF85A,0xF92C,0xFAB2,0xFC36,0xFD5B,0xFB58,
	0xF53C,0xEA92,0xDB2E,0xC8E0,0xBEC1,0xBF05,0xBF93,0xBF4B,
	0xD141,0xF341,0x0788,0x0663,0xF02F,0xD5DC,0xC2AA,0xC2D4,
	0xD7AC,0xF6A4,0x1508,0x29DF,0x3365,0x34DA,0x3292,0x2E52,
	0x2AE3,0x2865,0x28FA,0x2D4F,0x3506,0x3CF4,0x3F40,0x3F1B,
	0x3F53,0x3EEF,0x3F57,0x3B09,0x26D5,0x10BB,0xFFE0,0xFB4D,
	0x02D7,0x10E0,0x1A99,0x199D,0x0CAC,0xF896,0xE49D,0xD63D,
	0xCFE0,0xD00C,0xD50B,0xDC56,0xE3F4,0xEA6D,0xED4E,0xEBF1,
	0xE857,0xE55E,0xE540,0xE826,0xEBF5,0xF06C,0xF658,0xFEEF,
	0x0BFF,0x19C2,0x2366,0x25F3,0x20E1,0x1868,0x1252,0x11F1,
	0x16AE,0x1E39,0x26D5,0x2DB3,0x2FCC,0x2B64,0x236F,0x19E4,
	0x0F73,0x070B,0x024D,0x0176,0x02B5,0x037A,0x0159,0xFD57,
	0xF995,0xF5CD,0xF0BB,0xE9E7,0xE21E,0xDBF7,0xD9B3,0xDB80,
	0xDFA2,0xE658,0xEC97,0xEF3A,0xEE72,0xEC70,0xEA71,0xE8F3,
	0xE93F,0xEC79,0xF409,0xFE20,0x06BB,0x0C67,0x0E69,0x0E23,
	0x0D52,0x0D24,0x0D98,0x0ED9,0x10D6,0x1282,0x1435,0x15C9,
	0x18BB,0x1A7C,0x1808,0x1335,0x0DCF,0x084E,0x034B,0xFF02,
	0xFCEE,0xFD44,0xFEA9,0xFFDD,0xFEB1,0xFA92,0xF52D,0xEF44,
	0xE9F7,0xE6D3,0xE73B,0xE97B,0xEB50,0xECBF,0xEDBC,0xEF85,
	0xF158,0xF24B,0xF1F5,0xF13C,0xF160,0xF34D,0xF661,0xF9D9,
	0xFE8F,0x037A,0x07A4,0x0A6C,0x0BCB,0x0B75,0x097D,0x0839,
	0x0822,0x0AA1,0x0DC5,0x0FB4,0x1068,0x1005,0x0EFA,0x0CFC,
	0x0A5A,0x07EA,0x04B8,0x015E,0xFF10,0xFE14,0xFE24,0xFE59,
	0xFD78,0xFB40,0xF800,0xF507,0xF2C5,0xF1A1,0xF14B,0xF099,
	0xEFB3,0xEECA,0xEFCE,0xF200,0xF52B,0xF6BD,0xF5FA,0xF47D,
	0xF3EB,0xF513,0xF82D,0xFC1D,0xFF7A,0xFEEC,0x00D2,0x04BB,
	0x05D3,0x0746,0x077C,0x0632,0x0612,0x0722,0x085E,0x099F,
	0x0A00,0x0916,0x0858,0x07C9,0x0693,0x0602,0x04E1,0x02D8,
	0xFFA4,0xFD26,0xFC8B,0xFD64,0xFDFF,0xFD22,0xFB22,0xF90B,
	0xF692,0xF457,0xF414,0xF447,0xF42F,0xF446,0xF537,0xF6A9,
	0xF825,0xF89B,0xF7CA,0xF775,0xF86B,0xFA69,0xFBD2,0xFC8B,
	0xFDB7,0xFE71,0xFEBF,0xFD58,0xF774,0xEC6C,0xDB8F,0xC6D6,
	0xBEF8,0xBFDE,0xBFBC,0xC195,0xDBC8,0xFA92,0x0932,0x0299,
	0xEA94,0xCF32,0xC14E,0xC783,0xDFA1,0xFFB9,0x1D4F,0x3027,
	0x3778,0x3645,0x31CC,0x2D89,0x2ADB,0x2A83,0x2CCF,0x31C3,
	0x3884,0x3ED4,0x3FBB,0x3FA1,0x3FB0,0x3F21,0x3F57,0x38E3,
	0x236E,0x0DCF,0xFF27,0xFD28,0x06C3,0x148E,0x1D0F,0x1A47,
	0x0B53,0xF54F,0xE078,0xD210,0xCCD4,0xCFB2,0xD836,0xE242,
	0xE9E0,0xECA0,0xEBDC,0xE8EE,0xE5DD,0xE4CF,0xE655,0xE90E,
	0xEBB7,0xF070,0xF814,0x02C1,0x102D,0x1C98,0x2404,0x2452,
	0x1ECD,0x16AD,0x1123,0x108D,0x15AF,0x1EA6,0x2849,0x2E48,
	0x2FD0,0x2B42,0x2126,0x15DF,0x0B8E,0x043A,0x0179,0x0237,
	0x0403,0x03BB,0x00E5,0xFC89,0xF7B6,0xF2C4,0xED0A,0xE626,
	0xDF4F,0xDAAC,0xD8F6,0xDA6E,0xDEF8,0xE50F,0xEAE3,0xED9A,
	0xED03,0xEA5B,0xE705,0xE4B1,0xE557,0xE9A9,0xF25C,0xFD02,
	0x061F,0x0B25,0x0CEE,0x0C2E,0x0A3D,0x08F6,0x0962,0x0B41,
	0x0E77,0x10CC,0x12AE,0x149C,0x15E3,0x15C8,0x13F6,0x1049,
	0x0BBD,0x0671,0x0113,0xFD27,0xFB55,0xFBA6,0xFDD3,0xFD7B,
	0xFBD4,0xF90D,0xF40F,0xECD9,0xE80B,0xE638,0xE3F2,0xE6DF,
	0xEA24,0xED44,0xEF73,0xF03D,0xEF66,0xEE5C,0xED80,0xEEA5,
	0xF19D,0xF4C5,0xF7D5,0xFACE,0xFEA6,0x0251,0x062E,0x08C9,
	0x0A0A,0x09B5,0x083E,0x0756,0x07C5,0x0A11,0x0CC7,0x0EC4,
	0x0F71,0x0F0D,0x0DE0,0x0C3A,0x0909,0x0513,0x018D,0xFF00,
	0xFEC1,0xFEF5,0xFF0E,0xFE40,0xFC8E,0xFA2B,0xF763,0xF42C,
	0xF154,0xEFF2,0xEFB1,0xEFB0,0xF00B,0xF158,0xF2C1,0xF3DB,
	0xF444,0xF54B,0xF5C3,0xF533,0xF4EB,0xF5F0,0xF82F,0xFB82,
	0xFEC0,0x01E7,0x0484,0x058D,0x0486,0x02DE,0x0355,0x0434,
	0x04AE,0x051E,0x064A,0x088E,0x0A1E,0x09FE,0x08B4,0x0720,
	0x0592,0x03FF,0x026F,0x0114,0x000E,0xFF58,0xFEF9,0xFDDE,
	0xFC80,0xFC68,0xFB49,0xF92D,0xF6E7,0xF5A7,0xF534,0xF4D4,
	0xF515,0xF52E,0xF58C,0xF684,0xF7CD,0xF921,0xF951,0xF8B2,
	0xF866,0xF968,0xFB18,0xFD95,0xFF39,0xFFF5,0xFFAF,0xFCCE,
	0xF6EE,0xEB04,0xDAFC,0xC979,0xC01F,0xC0E5,0xC055,0xCDEE,
	0xEB56,0x01CB,0x08CF,0xFDA0,0xE6F7,0xD223,0xCA6C,0xD410,
	0xEB28,0x06F6,0x1ECE,0x2D1E,0x3190,0x2E88,0x28F8,0x2482,
	0x22DC,0x2407,0x27A9,0x2C8B,0x3251,0x37C6,0x3C7C,0x3FAF,
	0x4037,0x4028,0x39B1,0x29DF,0x1701,0x05DC,0xFD70,0x0012,
	0x0A9A,0x1575,0x1A0F,0x1490,0x0513,0xF140,0xE011,0xD628,
	0xD464,0xD964,0xE14A,0xE8A4,0xED84,0xEF4E,0xEE81,0xEBF7,
	0xE98C,0xE95A,0xEA4B,0xEBB7,0xEE6F,0xF395,0xFB43,0x05F5,
	0x11BB,0x1AFC,0x1EFA,0x1D99,0x17B9,0x115B,0x0CD5,0x0E09,
	0x14FE,0x1ED0,0x270D,0x2B61,0x2A14,0x21E8,0x19EF,0x1042,
	0x0827,0x04C4,0x0427,0x0505,0x0587,0x0440,0x00B9,0xFC35,
	0xF852,0xF487,0xF00C,0xEA74,0xE43D,0xDF8A,0xDE59,0xE146,
	0xE6E3,0xECDB,0xEFAE,0xEFEA,0xEEB5,0xECB1,0xEA80,0xE93E,
	0xEAEF,0xF04F,0xF904,0x0209,0x08B2,0x0BD1,0x0BC1,0x09D9,
	0x088A,0x0899,0x0AAA,0x0D90,0x1000,0x1188,0x1309,0x145C,
	0x1482,0x13AF,0x11B5,0x0E69,0x096A,0x043C,0xFFEE,0xFD65,
	0xFD65,0xFEA5,0xFF4F,0xFF18,0xFCF1,0xF832,0xF201,0xECC7,
	0xE9EA,0xE95B,0xEC22,0xEFD2,0xF26A,0xF457,0xF3FD,0xF295,
	0xF19C,0xF272,0xF3D8,0xF55C,0xF68E,0xF7EC,0xF9B2,0xFCD3,
	0x00CC,0x0561,0x08D6,0x0A38,0x09DD,0x077A,0x0692,0x07AF,
	0x08F1,0x097A,0x0B18,0x0D77,0x0E9F,0x0E39,0x0CAC,0x0A07,
	0x0678,0x02B9,0xFFB7,0xFEAB,0xFEA8,0x0037,0x007B,0xFE61,
	0xFB0A,0xF820,0xF66F,0xF4DA,0xF375,0xF2DD,0xF27E,0xF1B0,
	0xF078,0xF188,0xF33D,0xF463,0xF538,0xF6B7,0xF7D7,0xF808,
	0xF77A,0xF643,0xF6BD,0xF96E,0xFD5F,0x0187,0x0331,0x030D,
	0x029C,0x0161,0x00F4,0x01BC,0x02FC,0x0474,0x052E,0x0647,
	0x06BD,0x067C,0x04EF,0x0316,0x0152,0x006C,0xFF78,0xFEA4,
	0xFE35,0xFDC6,0xFD30,0xFBFE,0xFA8B,0xF9E6,0xF8DA,0xF78A,
	0xF5B4,0xF433,0xF2D0,0xF2AC,0xF315,0xF3E5,0xF5A0,0xF6F1,
	0xF79D,0xF773,0xF6BD,0xF5EF,0xF584,0xF67A,0xF875,0xFBB4,
	0xFE4D,0xFF4C,0xFD5F,0xF8BA,0xF333,0xECFE,0xE6F4,0xE205,
	0xE144,0xE502,0xEE86,0xF9CC,0x0293,0x04A7,0xFF67,0xF519,
	0xECE1,0xEAB0,0xEF94,0xF845,0x051E,0x0CE7,0x112C,0x1323,
	0x11CA,0x1006,0x0E23,0x0CAD,0x0BC2,0x0C6C,0x0E7F,0x11DF,
	0x1462,0x1613,0x171E,0x17A0,0x1610,0x121D,0x0C56,0x0588,
	0x0055,0xFD36,0xFE36,0x021C,0x06D8,0x0933,0x073E,0x0146,
	0xF98B,0xF311,0xEF36,0xEEC8,0xF0D7,0xF504,0xF8ED,0xFB57,
	0xFB8F,0xFA9C,0xF95E,0xF859,0xF805,0xF8F4,0xFA00,0xFB4D,
	0xFCB6,0xFF24,0x038A,0x08A1,0x0C08,0x0C07,0x0A5C,0x087C,
	0x06A7,0x0551,0x0563,0x07EB,0x0B4F,0x0E26,0x0F41,0x0EC1,
	0x0CDA,0x0962,0x04C7,0x0095,0xFD7E,0xFDC4,0xFF50,0xFF61,
	0xFECD,0xFE40,0xFD11,0xFB58,0xFA36,0xF839,0xF628,0xF456,
	0xF356,0xF3E6,0xF4DF,0xF6CC,0xF89F,0xF9F0,0xFAEA,0xFAAD,
	0xF9BA,0xF96C,0xF85E,0xF8C6,0xFAFB,0xFDCD,0x00AD,0x0398,
	0x057B,0x05B6,0x057F,0x04A8,0x046E,0x0430,0x03FF,0x04DC,
	0x0672,0x0724,0x076D,0x0740,0x074F,0x0704,0x04EC,0x03DA,
	0x01FF,0xFF74,0xFE5F,0xFDFB,0xFE2D,0xFE37,0xFE11,0xFD51,
	0xFC45,0xFB2F,0xFA31,0xF933,0xF90F,0xF94F,0xF9C0,0xF914,
	0xF834,0xF871,0xF879,0xF7E6,0xF771,0xF703,0xF68C,0xF5D8,
	0xF55F,0xF4CD,0xF3F5,0xF36C,0xF418,0xF4FE,0xF4EF,0xF47A,
	0xF310,0xF230,0xF1BD,0xF23C,0xF310,0xF3FE,0xF47E,0xF439,
	0xF365,0xF2DA,0xF25B,0xF1C1,0xF194,0xF122,0xF070,0xF017,
	0xEF84,0xEF07,0xEE74,0xEE06,0xED4F,0xEC8A,0xEC2F,0xEC03,
	0xEB81,0xEB17,0xEABF,0xEA9B,0xEA23,0xE9AE,0xE98B,0xEA0B,
	0xE98F,0xE930,0xE8DF,0xE968,0xE978,0xE922,0xE8CD,0xE8DC,
	0xE90E,0xE8AA,0xE8D1,0xE9B5,0xE859,0xE8BD,0xEA90,0xE962,
	0xE956,0xE9F2,0xEA06,0xE9E3,0xE9EE,0xEA67,0xEA74,0xEA67,
	0xEAF9,0xEA91,0xEA45,0xEA5A,0xEA31,0xEA84,0xEB01,0xEB78,
	0xEBB9,0xEBFB,0xEC2A,0xEC4C,0xECC1,0xED2F,0xEDD3,0xEDEA,
	0xEE25,0xEE9C,0xEF2D,0xEFCE,0xF070,0xF0BC,0xF13A,0xF195,
	0xF238,0xF30E,0xF2DA,0xF31C,0xF362,0xF3C5,0xF46F,0xF52E,
	0xF591,0xF600,0xF6B7,0xF71C,0xF750,0xF802,0xF815,0xF864,
	0xF8B3,0xF8E0,0xF989,0xF9FD,0xFA56,0xFABB,0xFB02,0xFB70,
	0xFC1D,0xFD3A,0xFFBC,0xFFD1,0xFF72,0xFF97,0xFFFC,0x003E,
	0x0036,0x00B4,0x018C,0x01E4,0x01F1,0x024D,0x0290,0x02B2,
	0x02E4,0x0325,0x0394,0x0452,0x044F,0x03A9,0x0482,0x05C6,
	0x0578,0x0501,0x05C8,0x064F,0x05DF,0x0632,0x0693,0x06E4,
	0x0716,0x070B,0x0774,0x07A1,0x078B,0x07F2,0x07F0,0x082B,
	0x0851,0x087D,0x08FD,0x0905,0x0909,0x090E,0x0944,0x08B8,
	0x08EF,0x0A30,0x0AA1,0x0AE1,0x0ACF,0x0B41,0x0B73,0x0B49,
	0x0B2F,0x0B5D,0x0B2C,0x0ADB,0x0B00,0x0B3A,0x0A7C,0x0AB7,
	0x0A92,0x0A9D,0x0AAF,0x0ACF,0x0B12,0x0B13,0x0B46,0x0B76,
	0x0B89,0x0BEF,0x0BF8,0x0C22,0x0C35,0x0C38,0x0C1E,0x0C3E,
	0x0C21,0x0BC1,0x0C12,0x0C4F,0x0C65,0x0C95,0x0C67,0x0C35,
	0x0C04,0x0BC5,0x0BEF,0x0C0B,0x0C2A,0x0C85,0x0C1D,0x0C00,
	0x0C24,0x0C93,0x0C94,0x0C55,0x0C93,0x0CC6,0x0CE9,0x0C87,
	0x0C44,0x0CA9,0x0C8D,0x0C0F,0x0C14,0x0C83,0x0C00,0x0BFE,
	0x0C32,0x0BED,0x0C38,0x0C09,0x0BC9,0x0C6B,0x0C9C,0x0C1E,
	0x0C4D,0x0CCF,0x0BD4,0x0D01,0x0E16,0x0C66,0x0CE0,0x0CA4,
	0x0C0B,0x0C2B,0x0C84,0x0BDC,0x0C28,0x0BF7,0x0C3E,0x0C46,
	0x0C0A,0x0C59,0x0C1D,0x0BDF,0x0C0A,0x0C0F,0x0B7E,0x0B55,
	0x0B58,0x0B3C,0x0B5D,0x0B3B,0x0B56,0x0B66,0x0BB6,0x0B48,
	0x0B3C,0x0AED,0x0ADA,0x0ACA,0x0AEF,0x0B14,0x0B45,0x0B40,
	0x0AD1,0x0AFC,0x0ABB,0x0A86,0x0A7A,0x0AD7,0x0AB8,0x0A82,
	0x0A57,0x0A57,0x0A53,0x09F6,0x09C3,0x09E7,0x0A36,0x0A02,
	0x09A9,0x0942,0x090A,0x0939,0x093A,0x0958,0x0949,0x0973,
	0x0962,0x0958,0x08C9,0x075C,0x05EC,0x062A,0x0668,0x0659,
	0x064C,0x06B3,0x06B9,0x06A2,0x06A4,0x0672,0x0683,0x068E,
	0x0619,0x0636,0x0620,0x05FB,0x05C0,0x0628,0x0601,0x056F,
	0x05CE,0x0619,0x05E0,0x05AE,0x05A3,0x05D6,0x05F4,0x063A,
	0x0605,0x05E3,0x0614,0x060D,0x062C,0x060E,0x05D6,0x05D8,
	0x061F,0x0601,0x05BC,0x0598,0x0586,0x05D9,0x059E,0x067C,
	0x0658,0x05A4,0x052F,0x04F4,0x0531,0x0520,0x0513,0x052F,
	0x0510,0x0505,0x0579,0x05DA,0x059D,0x060D,0x067F,0x0622,
	0x05BB,0x0582,0x0585,0x05B4,0x054F,0x04D4,0x04F0,0x050C,
	0x0514,0x04E4,0x049B,0x0478,0x046E,0x0414,0x03C9,0x03DA,
	0x039C,0x03A5,0x03B4,0x0388,0x0377,0x035C,0x033E,0x02F2,
	0x02CE,0x02CB,0x02D7,0x02EC,0x02F0,0x0291,0x0225,0x01DF,
	0x01C3,0x01CB,0x01C8,0x0188,0x01B0,0x0183,0x0102,0x00CB,
	0x00E6,0x014C,0x013A,0x00F6,0x00F8,0x00F5,0x0124,0x00B0,
	0x009C,0xFF26,0xFFAA,0x001D,0x00BE,0x0249,0x04D3,0x06AE,
	0x06CA,0x07F2,0x060B,0x06D1,0x07BD,0x07B5,0x075D,0x0724,
	0x0711,0x0623,0x05A3,0x05A4,0x06C2,0x07D6,0x083B,0x07F1,
	0x07E3,0x07A7,0x0765,0x0760,0x0857,0x0A2C,0x0B98,0x0CF9,
	0x0DE4,0x0E04,0x0D63,0x0CA4,0x0C1F,0x0D4B,0x0F75,0x11A4,
	0x12B0,0x1283,0x1151,0x10D3,0x1193,0x128A,0x13AB,0x144A,
	0x1422,0x13E9,0x13AB,0x148C,0x15BD,0x1631,0x1637,0x1649,
	0x1691,0x1683,0x1659,0x1661,0x1686,0x1672,0x1701,0x17B3,
	0x17A2,0x174F,0x1698,0x15A6,0x155E,0x14DE,0x14B3,0x1448,
	0x1313,0x0F3B,0x0A80,0x0422,0xFD0C,0xF7B5,0xF6AF,0xFB32,
	0x049F,0x0F0B,0x1596,0x1528,0x0EC9,0x0561,0xFDA9,0xFB85,
	0x0120,0x0CD4,0x19E3,0x22CF,0x24AB,0x226C,0x1D9F,0x1736,
	0x122A,0x11D4,0x164F,0x1CBD,0x21B4,0x2460,0x2392,0x2039,
	0x19FC,0x14A5,0x1196,0x0FE8,0x0E76,0x0BE1,0x08F1,0x0775,
	0x06F0,0x074A,0x0793,0x060C,0x039C,0xFEE9,0xF7C0,0xF36E,
	0xF22F,0xF4B2,0xFA00,0xFF40,0x027A,0x02F8,0x0110,0xFDED,
	0xFA25,0xF872,0xFA98,0x0014,0x0572,0x096A,0x0C2F,0x0CFF,
	0x0BEB,0x0995,0x072F,0x0560,0x0557,0x05E9,0x06AF,0x0805,
	0x093B,0x08D0,0x07A8,0x063A,0x0405,0x0013,0xFB89,0xF7EE,
	0xF5F5,0xF624,0xF7E9,0xF97C,0xF981,0xF7EB,0xF4AC,0xF0F6,
	0xEE11,0xEC18,0xEC37,0xEDC9,0xEFAD,0xF1E6,0xF41A,0xF56A,
	0xF525,0xF37D,0xF278,0xF2E4,0xF430,0xF5B9,0xF70C,0xF88C,
	0xFA1C,0xFBB3,0xFD36,0xFE38,0xFE79,0xFD18,0xFAA6,0xF8B7,
	0xF76D,0xF6F4,0xF751,0xF8EE,0xFAAD,0xFB46,0xF967,0xF617,
	0xF2C3,0xED57,0xECD8,0xEDFD,0xEED6,0xF0CA,0xF0CB,0xEFA8,
	0xEE21,0xECD6,0xEC17,0xEB23,0xEA5E,0xEA50,0xEB23,0xEC27,
	0xEDC6,0xEFBA,0xF0D5,0xF078,0xEFA1,0xEFF6,0xF0EA,0xF1AB,
	0xF1DF,0xF2AC,0xF38D,0xF49D,0xF5BC,0xF6D2,0xF75A,0xF6CC,
	0xF565,0xF3C4,0xF371,0xF3DE,0xF4A7,0xF51B,0xF531,0xF559,
	0xF40E,0xF174,0xEF4E,0xEDF8,0xEE2F,0xEF3E,0xEFB6,0xF048,
	0xF020,0xEF15,0xED02,0xEB63,0xEBA7,0xECAB,0xEE0B,0xEE95,
	0xEDF5,0xECFF,0xECB5,0xED77,0xEF35,0xF10C,0xF345,0xF5D7,
	0xF4BD,0xF387,0xF33C,0xF348,0xF3BC,0xF4B4,0xF659,0xF7EB,
	0xF855,0xF75B,0xF5ED,0xF472,0xF39E,0xF3AE,0xF413,0xF561,
	0xF6B5,0xF5B1,0xF30B,0xF163,0xF16B,0xF132,0xF0F6,0xF1E6,
	0xF25E,0xF21B,0xF0D5,0xEF2C,0xEE78,0xEF76,0xF10C,0xF231,
	0xF2A1,0xF1FA,0xF161,0xF058,0xEFC8,0xF050,0xF26F,0xF415,
	0xF4F5,0xF577,0xF631,0xF539,0xF22D,0xF103,0xF2C7,0xF5EA,
	0xF83B,0xF9B5,0xF961,0xF795,0xF5DC,0xF4A2,0xF483,0xF52F,
	0xF5C4,0xF556,0xF274,0xEBC1,0xE1E4,0xD303,0xC1FF,0xBDC8,
	0xBE64,0xBEE7,0xBE19,0xCEE6,0xEE34,0xFF90,0xFC90,0xE6BF,
	0xCA1C,0xBFB7,0xBF28,0xCEF0,0xF71C,0x1CFC,0x3637,0x3D85,
	0x358B,0x234A,0x1218,0x08E6,0x0B2C,0x1821,0x2BF0,0x3C0E,
	0x3DEE,0x3E15,0x3897,0x27AF,0x18C6,0x0E7A,0x0895,0x048D,
	0x004C,0xFAC5,0xF759,0xF791,0xF976,0xF947,0xF3F7,0xE847,
	0xD865,0xC9A7,0xC17E,0xC1F6,0xCBE1,0xDAD2,0xE9DB,0xF3EF,
	0xF69C,0xF112,0xE7BC,0xDE2E,0xDBBD,0xE369,0xF369,0x0612,
	0x195D,0x238C,0x2274,0x1D9A,0x1597,0x0F44,0x0D56,0x10CC,
	0x16D5,0x1DF9,0x22FE,0x24FB,0x2255,0x1C52,0x1480,0x0B9F,
	0x037C,0xFCCC,0xF7D0,0xF4F5,0xF4E3,0xF595,0xF548,0xF369,
	0xF05B,0xEB98,0xE49B,0xDD8B,0xD89F,0xD734,0xDA19,0xE16C,
	0xEAC8,0xF389,0xF810,0xF76D,0xF408,0xF081,0xEE78,0xF0C8,
	0xF784,0x00CE,0x0B35,0x1398,0x1863,0x18D0,0x15FA,0x1171,
	0x0CF9,0x0B06,0x0CFD,0x10BA,0x146B,0x1673,0x167C,0x135A,
	0x0E08,0x0820,0x0255,0xFD08,0xF8E7,0xF702,0xF639,0xF5E4,
	0xF3F5,0xF18C,0xF042,0xEEBA,0xEC4C,0xE98D,0xE6FC,0xE565,
	0xE627,0xE912,0xED86,0xF31D,0xF839,0xFB22,0xFB3C,0xF9B5,
	0xF8D0,0xFA49,0xFDDF,0x01B3,0x0654,0x0BF5,0x1051,0x1201,
	0x1206,0x0FF3,0x0CFE,0x0A7D,0x09A7,0x09D2,0x0BAE,0x0D84,
	0x0DDA,0x0BB5,0x0840,0x043B,0x00B1,0xFDB8,0xFAC7,0xF888,
	0xF6CB,0xF5A9,0xF52F,0xF54E,0xF720,0xF5BD,0xF2ED,0xF1C8,
	0xF014,0xEE80,0xEEEE,0xF0B0,0xF37B,0xF77B,0xFB2E,0xFE76,
	0x0060,0x007E,0xFFFE,0x0014,0x0092,0x02A6,0x04D9,0x07D2,
	0x0B5B,0x0E13,0x0E52,0x0D37,0x0B79,0x09BF,0x085B,0x0743,
	0x0739,0x07FC,0x083D,0x074B,0x05C0,0x03BA,0x01F6,0xFF6A,
	0xFCBB,0xFABB,0xF957,0xF840,0xF763,0xF74A,0xF842,0xF975,
	0xF964,0xF87C,0xF6BF,0xF535,0xF471,0xF4D4,0xF76C,0xFAB7,
	0xFDCA,0x0053,0x00C6,0x003C,0xFFD7,0x000A,0x0118,0x0288,
	0x04DA,0x07DE,0x09C9,0x0A17,0x08D5,0x079A,0x0731,0x0725,
	0x06D3,0x06D9,0x06B8,0x0624,0x0384,0xFF83,0xFA87,0xF293,
	0xE45E,0xCEB1,0xC0E2,0xBFFF,0xBFAE,0xC0E0,0xBF7D,0xD299,
	0xFC43,0x108E,0x07D1,0xE47D,0xC353,0xC1CB,0xC0AC,0xD23C,
	0x0CEA,0x39DF,0x3F11,0x3E27,0x3FCB,0x3705,0x1F28,0x159E,
	0x1CAD,0x3383,0x3FFB,0x3EEA,0x3F63,0x3F04,0x3FB3,0x3B15,
	0x282A,0x1D9E,0x191E,0x1561,0x0FB3,0x076B,0x00CA,0xFF02,
	0x0033,0xFF64,0xF77D,0xE6F4,0xD104,0xC184,0xC02C,0xBFA6,
	0xC48F,0xDA82,0xEE33,0xF9B9,0xFA98,0xF19A,0xE1A3,0xD49A,
	0xD2E1,0xE06B,0xF9E7,0x17CD,0x3034,0x3C12,0x3B81,0x2F58,
	0x2006,0x18E9,0x1A8D,0x2268,0x2CCA,0x3606,0x3B05,0x3A48,
	0x3467,0x2A7D,0x1ED5,0x133C,0x093A,0x017B,0xFC1B,0xF7FE,
	0xF4EC,0xF2AB,0xF24E,0xF26A,0xEFCE,0xE852,0xDD7E,0xD200,
	0xC971,0xC879,0xCF41,0xDB98,0xE904,0xF31A,0xF6C1,0xF418,
	0xEE3B,0xEA24,0xEA46,0xEFC4,0xFA2C,0x074C,0x15A0,0x1FF0,
	0x23A8,0x21A7,0x1C31,0x15E3,0x1403,0x14FB,0x187D,0x1DBD,
	0x205D,0x1FA1,0x1C10,0x176F,0x1246,0x0BE4,0x04D3,0xFD84,
	0xF6C3,0xF10F,0xED32,0xECC1,0xEEEA,0xF032,0xEEDE,0xEB2C,
	0xE50C,0xDE35,0xD995,0xD8DC,0xDCA9,0xE325,0xEACF,0xF1AB,
	0xF63F,0xF778,0xF6C3,0xF49D,0xF3AC,0xF62C,0xFC97,0x056D,
	0x0E10,0x142B,0x15FA,0x148A,0x11A0,0x0F84,0x0F22,0x1041,
	0x1127,0x1159,0x100B,0x0E49,0x0CB3,0x0AEF,0x08DB,0x0552,
	0x0106,0xFC12,0xF6E8,0xF30D,0xF0C4,0xEF74,0xEFBC,0xF03C,
	0xF098,0xF025,0xED85,0xE97A,0xE635,0xE4A8,0xE6EB,0xEB82,
	0xF0C2,0xF570,0xF928,0xFA87,0xFB1B,0xFB0F,0xFB02,0xFCF0,
	0x0318,0x05D1,0x098E,0x0CAB,0x0E02,0x0E52,0x0E60,0x0DEC,
	0x0E62,0x0FCA,0x0F28,0x0C84,0x090E,0x073F,0x06F6,0x0737,
	0x0741,0x062E,0x0334,0xFEC8,0xFA5C,0xF651,0xF54A,0xF53F,
	0xF5EC,0xF5E9,0xF554,0xF44F,0xF324,0xF1BD,0xF0D1,0xF131,
	0xF2A5,0xF59F,0xF8C9,0xFB61,0xFCEC,0xFE22,0xFEAF,0xFF8A,
	0x013F,0x03CD,0x071D,0x0990,0x0A57,0x09E6,0x0981,0x0A3E,
	0x0C12,0x0CEC,0x0DA1,0x0D4C,0x0B56,0x087A,0x05B7,0x0460,
	0x0446,0x02BA,0xFD02,0xF283,0xE212,0xCA6E,0xBF2D,0xBF6E,
	0xBE7D,0xBF38,0xBED0,0xDB84,0x0273,0x0D0D,0xF9A4,0xD0DE,
	0xBEFE,0xC198,0xC088,0xDE3F,0x1A70,0x3C9D,0x3D79,0x3DFB,
	0x3E82,0x2F13,0x1ACD,0x157F,0x21D9,0x39E5,0x3FF1,0x3EB9,
	0x3F65,0x3F03,0x3FC8,0x39D0,0x28DE,0x201F,0x1AC7,0x1457,
	0x0C33,0x0481,0x017C,0x0351,0x05BB,0x0250,0xF5EB,0xE147,
	0xC968,0xC00C,0xC11F,0xC0CB,0xCAF3,0xE1A9,0xF30E,0xFBD8,
	0xF8BE,0xEBF4,0xDC73,0xD2C4,0xD62B,0xE8DE,0x0548,0x220C,
	0x3620,0x3CF2,0x37A1,0x2BCE,0x209D,0x1C6D,0x1FB0,0x2801,
	0x3188,0x3929,0x3C52,0x3B0E,0x356C,0x2C99,0x2172,0x1585,
	0x09FF,0x007D,0xFA00,0xF684,0xF5DC,0xF67C,0xF71D,0xF506,
	0xEED7,0xE4B7,0xD8A7,0xCDD1,0xC7DE,0xC966,0xD23C,0xDF85,
	0xEC10,0xF383,0xF558,0xF1B4,0xEBF2,0xE7C5,0xE8C9,0xF077,
	0xFD1D,0x0B33,0x17C0,0x2071,0x2398,0x213A,0x1C02,0x1744,
	0x1556,0x15FE,0x18BB,0x1CAE,0x1FF2,0x20BE,0x1E70,0x19F7,
	0x12CC,0x0AB9,0x022F,0xFA31,0xF3E4,0xF091,0xEFC1,0xF0BD,
	0xEFBB,0xF01D,0xEF19,0xE95C,0xE2BC,0xDC27,0xD87A,0xD946,
	0xDD83,0xE488,0xEC2F,0xF2C6,0xF6B1,0xF705,0xF5AA,0xF482,
	0xF59F,0xF92F,0xFF4B,0x069C,0x0DEA,0x13CB,0x1728,0x178A,
	0x167D,0x1435,0x115F,0x0F9E,0x0FE2,0x1168,0x1286,0x1271,
	0x11CF,0x1022,0x0C3B,0x063E,0x006A,0xFB7E,0xF775,0xF3D8,
	0xF199,0xF21A,0xF355,0xF36D,0xF205,0xEF2C,0xEC14,0xE85C,
	0xE66D,0xE75A,0xEA53,0xEE92,0xF2D0,0xF627,0xF924,0xFBC1,
	0xFCCB,0xFCF1,0xFD4F,0xFEBF,0x0163,0x0650,0x0D02,0x113A,
	0x13F9,0x14A4,0x12B7,0x103A,0x0E6C,0x0D4A,0x0CB1,0x0CDE,
	0x0CE0,0x0D09,0x0CDF,0x0AB9,0x074E,0x03A7,0xFFD7,0xFC0E,
	0xF8F0,0xF772,0xF7E7,0xF7B8,0xF5CA,0xF402,0xF3EC,0xF363,
	0xF227,0xF139,0xF014,0xEF8D,0xEFE3,0xF1E0,0xF539,0xF911,
	0xFBFD,0xFE63,0xFEEF,0xFED5,0xFE06,0xFDEB,0x0039,0x037C,
	0x0661,0x091F,0x0AA7,0x0A60,0x0A90,0x0A6D,0x08CB,0x0782,
	0x060E,0x04A2,0x049F,0x0512,0x02D7,0xFAEA,0xECF3,0xD741,
	0xC1A9,0xBE04,0xBE18,0xBEB1,0xBE20,0xC370,0xE5C7,0x01F8,
	0x04C7,0xEC84,0xC805,0xBE4E,0xC064,0xC20E,0xEB23,0x23BF,
	0x3CDC,0x3C95,0x3DAC,0x3BFE,0x27AD,0x1857,0x1952,0x296C,
	0x3C2E,0x3E4D,0x3E2C,0x3E81,0x3DCD,0x3E9D,0x3815,0x2643,
	0x1C4D,0x15FF,0x0FC8,0x0955,0x0412,0x01E3,0x0292,0x022A,
	0xFCB1,0xEEBB,0xD99E,0xC4B7,0xBEAF,0xBFA4,0xBF02,0xCCF5,
	0xE24F,0xF1ED,0xF7D3,0xF354,0xE62F,0xD7CE,0xD107,0xD735,
	0xEA96,0x06D5,0x21DA,0x3344,0x3797,0x3115,0x249B,0x1CCB,
	0x1933,0x1AB9,0x24DF,0x2F33,0x3719,0x3AEC,0x39A7,0x3245,
	0x2776,0x1A25,0x0D8A,0x03FF,0xFDDC,0xFA4D,0xF83F,0xF7CF,
	0xF719,0xF53B,0xF0C5,0xEA3D,0xE129,0xD6E8,0xCE42,0xCAB4,
	0xCD6C,0xD5A7,0xE1A8,0xECA5,0xF2FD,0xF3E0,0xF177,0xEDA1,
	0xEB68,0xEC5F,0xF39A,0xFF52,0x0CE6,0x1932,0x2196,0x249E,
	0x223E,0x1C9E,0x16C2,0x13E8,0x14E2,0x1941,0x1E0D,0x2183,
	0x2193,0x1E7E,0x18D6,0x1192,0x09A7,0x0228,0xFB5A,0xF5CE,
	0xF311,0xF270,0xF2A8,0xF29A,0xF0BD,0xECE4,0xE812,0xE158,
	0xDAFC,0xD90A,0xD952,0xDCBE,0xE2FF,0xEB79,0xF352,0xF79A,
	0xF8F0,0xF6EB,0xF4A0,0xF453,0xF7DD,0xFEC8,0x070B,0x0F32,
	0x15FC,0x1987,0x18C1,0x156F,0x126A,0x0F4D,0x0DC0,0x0ED8,
	0x1221,0x149A,0x1455,0x1195,0x0D74,0x086F,0x03F5,0x001F,
	0xFC89,0xF899,0xF4C7,0xF1C9,0xF04C,0xEFEF,0xF0E0,0xF17C,
	0xF00E,0xED38,0xEA5F,0xE9A6,0xE855,0xE864,0xEB14,0xEFF7,
	0xF554,0xF9B7,0xFCF8,0xFEB4,0xFE52,0xFD7F,0xFD4F,0xFFAF,
	0x0579,0x0C51,0x10F0,0x129C,0x11E3,0x0FD6,0x0E0A,0x0D7D,
	0x0D54,0x0D49,0x0C35,0x0A9C,0x0977,0x096B,0x08F3,0x06A3,
	0x02F8,0xFF81,0xFCEF,0xFAA2,0xF822,0xF603,0xF41D,0xF2D9,
	0xF22F,0xF2DF,0xF4F7,0xF6E0,0xF605,0xF271,0xEFA7,0xEF42,
	0xF181,0xF5AD,0xF9C7,0xFDC3,0x0021,0xFFFD,0xFEF3,0xFF4C,
	0x0147,0x038F,0x04EB,0x06E3,0x0955,0x0BB7,0x0D04,0x0C54,
	0x0AA7,0x0997,0x08E3,0x08F2,0x0964,0x08CB,0x06CC,0x0253,
	0xFC2D,0xF312,0xE784,0xD4D9,0xC1AA,0xBFC4,0xC052,0xC0BF,
	0xBECA,0xC9CA,0xF278,0x0B7C,0x0716,0xE5FA,0xC428,0xC153,
	0xC127,0xC9C0,0xFCF4,0x31B5,0x3F26,0x3DD3,0x3F85,0x3A89,
	0x2385,0x1538,0x1973,0x2EF5,0x3FC3,0x3F33,0x3F72,0x3F2D,
	0x3F01,0x3DDC,0x2E19,0x20E6,0x1B8D,0x163B,0x0F45,0x07EF,
	0x01C0,0xFF9A,0x00A7,0x00BC,0xF9F2,0xEA02,0xD300,0xC158,
	0xBFC6,0xC004,0xC0CC,0xD35E,0xE9CB,0xF7E5,0xFA51,0xF13A,
	0xE190,0xD3B9,0xD02A,0xDB2E,0xF312,0x1130,0x2B77,0x3952,
	0x3901,0x2E7E,0x2121,0x1821,0x177E,0x203A,0x2BFA,0x3574,
	0x3BB1,0x3BBA,0x36BC,0x2E13,0x237E,0x1879,0x0D74,0x03E7,
	0xFC1C,0xF6BF,0xF3FC,0xF415,0xF5C0,0xF594,0xF178,0xE971,
	0xDD7E,0xD0CB,0xC810,0xC5A8,0xCB5C,0xD7A0,0xE556,0xEFDD,
	0xF53C,0xF384,0xED8D,0xE7FC,0xE62C,0xEAD1,0xF5F8,0x0452,
	0x12A1,0x1D8B,0x2232,0x20AB,0x1C00,0x1756,0x14E8,0x14D3,
	0x16CC,0x198C,0x1BBA,0x1CF5,0x1E11,0x1BB8,0x158B,0x0DD5,
	0x0510,0xFCF1,0xF596,0xF0E0,0xEE2C,0xEDA2,0xEE75,0xEFC4,
	0xEF68,0xEACB,0xE372,0xDB12,0xD4FA,0xD40E,0xD7D6,0xDF2A,
	0xE7C7,0xEECA,0xF2C3,0xF38C,0xF23C,0xF0F8,0xF16F,0xF3D3,
	0xF86F,0xFFF6,0x08E5,0x108B,0x1485,0x1519,0x12C6,0x100A,
	0x0EA0,0x0E86,0x0F00,0x0F79,0x0F25,0x0E6F,0x0D53,0x0C6F,
	0x0B1D,0x080C,0x0345,0xFD3C,0xF657,0xF0BD,0xEE5C,0xEE0E,
	0xEFB9,0xF217,0xF2D3,0xF0DB,0xEC82,0xE758,0xE35C,0xE231,
	0xE3F6,0xE841,0xEE0D,0xF3F6,0xF7B0,0xF92C,0xF885,0xF767,
	0xF7B0,0xFA3D,0xFECA,0x04DA,0x0A0E,0x0C1B,0x0C69,0x0EB7,
	0x0D20,0x0DCE,0x0E5C,0x0DDE,0x0CDD,0x0AFA,0x08CA,0x07F8,
	0x0859,0x087C,0x0789,0x053E,0x0225,0xFE37,0xF9A8,0xF55E,
	0xF278,0xF1DE,0xF2F8,0xF4E5,0xF5B0,0xF55C,0xF38E,0xF07F,
	0xED42,0xECAF,0xEEDA,0xF26A,0xF656,0xF929,0xFB0A,0xFC0F,
	0xFC27,0xFC84,0xFEAB,0x01D7,0x0474,0x0580,0x063F,0x07BB,
	0x0969,0x0ADF,0x0C48,0x0D8D,0x0CFD,0x0B29,0x08E2,0x0788,
	0x06E0,0x0698,0x0622,0x048D,0xFF90,0xF514,0xE42C,0xCBA7,
	0xBF1F,0xC014,0xBFA1,0xC0EB,0xBF48,0xD4C5,0xFBAC,0x085A,
	0xFB61,0xD68E,0xBEE8,0xC15F,0xBF6C,0xD4A2,0x0F7D,0x3948,
	0x3DAC,0x3D87,0x3F18,0x3297,0x1D51,0x1765,0x2195,0x373F,
	0x3FA9,0x3EFC,0x3EFC,0x3EE0,0x3F4C,0x3DA0,0x2EDB,0x2295,
	0x1BE6,0x14DF,0x0CA9,0x055C,0x01CE,0x02EE,0x052C,0x03FA,
	0xFA77,0xE650,0xCCC9,0xC058,0xC112,0xC024,0xC753,0xDE51,
	0xF115,0xF9F4,0xF8D3,0xEDC8,0xDD1F,0xD29A,0xD44F,0xE3F7,
	0xFE44,0x1B2A,0x3065,0x391F,0x344B,0x28B6,0x1F07,0x1C61,
	0x210A,0x2919,0x30C6,0x3634,0x388C,0x3808,0x34BE,0x2E8A,
	0x2591,0x1A50,0x0E01,0x038E,0xFBF0,0xF7AD,0xF55A,0xF5A0,
	0xF65D,0xF606,0xF247,0xE9BC,0xDD32,0xD04F,0xC7AD,0xC700,
	0xCFFF,0xDE3C,0xEBEC,0xF424,0xF4EC,0xF0D2,0xEA91,0xE70C,
	0xE91F,0xF12E,0xFD71,0x0A65,0x1510,0x1C8D,0x1FC7,0x1F9B,
	0x1D82,0x1A46,0x1811,0x1776,0x18B1,0x1B21,0x1DA1,0x1F24,
	0x1E33,0x1AD6,0x15AA,0x0E6F,0x05EC,0xFDB2,0xF6E1,0xF174,
	0xEE6D,0xEE63,0xF063,0xF194,0xEF80,0xEA9A,0xE46B,0xDC25,
	0xD934,0xDA3E,0xDD1A,0xE32C,0xE9BF,0xEF2C,0xF32F,0xF59D,
	0xF5C9,0xF58E,0xF64C,0xF8AF,0xFD70,0x0374,0x09B2,0x0FCE,
	0x14BF,0x1783,0x176D,0x154F,0x1259,0x1033,0x0E3A,0x0D24,
	0x0DA9,0x0EF7,0x0FA6,0x0E6F,0x0B1E,0x0650,0x0010,0xF93D,
	0xF401,0xF109,0xF00E,0xF071,0xF0C3,0xF0A0,0xEF3F,0xECA2,
	0xE943,0xE6AF,0xE553,0xE568,0xE6BF,0xE95F,0xEC94,0xF09D,
	0xF4A1,0xF75B,0xF98B,0xFB30,0xFC67,0xFC9E,0xFD41,0xFEE4,
	0x0221,0x0700,0x0C4B,0x101C,0x128A,0x12F2,0x0F61,0x0C03,
	0x09A2,0x08AB,0x08A2,0x0971,0x0A9E,0x0A6D,0x0847,0x041C,
	0xFF6D,0xFB29,0xF771,0xF4B1,0xF499,0xF59F,0xF62D,0xF4CB,
	0xF1D2,0xF06B,0xF067,0xEFC0,0xF018,0xF1D6,0xF334,0xF359,
	0xF380,0xF43C,0xF6F9,0xFA8A,0xFDAF,0x001B,0x01F8,0x0296,
	0x02BD,0x0255,0x0287,0x03AA,0x06A5,0x0ABB,0x0DC6,0x0E26,
	0x0C3A,0x07E8,0x029A,0x00C7,0x02A0,0x047F,0x042C,0xFE67,
	0xF169,0xDD9E,0xC527,0xBE64,0xBF24,0xBEDD,0xBF4B,0xBFA8,
	0xDF45,0x00EA,0x0748,0xF139,0xCA9C,0xBE03,0xC09F,0xC066,
	0xE195,0x1C54,0x3BB2,0x3CA7,0x3D7A,0x3C5C,0x299D,0x17AF,
	0x1528,0x22A4,0x3916,0x3E8A,0x3DEB,0x3E64,0x3DD9,0x3E6E,
	0x3827,0x2771,0x1E5C,0x184C,0x1273,0x0B25,0x0485,0x0177,
	0x0225,0x0341,0xFF97,0xF33B,0xDE93,0xC720,0xBEBE,0xBFB8,
	0xBEF0,0xCAA0,0xE0E1,0xF08D,0xF689,0xF1FE,0xE58A,0xD86E,
	0xD15E,0xD520,0xE615,0x00BA,0x1CFF,0x30B3,0x36F8,0x3138,
	0x25E8,0x1B1D,0x1711,0x1ABC,0x23C8,0x2D14,0x3672,0x39B9,
	0x3653,0x31F6,0x28E7,0x1D9E,0x1145,0x0692,0xFE96,0xFA5A,
	0xF7E7,0xF673,0xF57E,0xF490,0xF1F0,0xEC8D,0xE403,0xD8B9,
	0xCEA1,0xC8FD,0xCA80,0xD348,0xE0E0,0xED26,0xF418,0xF45D,
	0xF003,0xEB12,0xE882,0xEB84,0xF3DE,0x0016,0x0D47,0x18C8,
	0x2032,0x2287,0x20BD,0x1C2C,0x1795,0x1595,0x1739,0x1A9F,
	0x1E23,0x2107,0x21C5,0x1F56,0x1AAB,0x13FA,0x0C1C,0x03EC,
	0xFBE9,0xF63A,0xF36C,0xF31D,0xF46C,0xF4B2,0xF322,0xEF03,
	0xE950,0xE330,0xDE14,0xDBE0,0xDCB5,0xE06D,0xE52F,0xEB11,
	0xF190,0xF49F,0xF4EB,0xF3F0,0xF371,0xF4E0,0xF8DC,0xFEB7,
	0x0614,0x0CE7,0x118C,0x1420,0x1554,0x156E,0x13F3,0x11EE,
	0x1057,0x0ED6,0x0ED1,0x10BD,0x1178,0x10ED,0x0F02,0x0AE9,
	0x05B7,0x006D,0xFB64,0xF680,0xF2F9,0xF108,0xF0F8,0xF296,
	0xF342,0xF26C,0xEFA0,0xEB99,0xE7FF,0xE663,0xE717,0xE9CC,
	0xEDD1,0xF238,0xF7AB,0xF98F,0xFA61,0xFAF8,0xFAAC,0xFAE4,
	0xFCF9,0x015F,0x0690,0x0B1D,0x0E66,0x103A,0x10AA,0x1020,
	0x0FD9,0x0F5F,0x0EEC,0x0E53,0x0D46,0x0CBE,0x0C9A,0x0C01,
	0x09EE,0x06D2,0x0348,0x004B,0xFD77,0xFB41,0xF98D,0xF807,
	0xF62F,0xF3EF,0xF2F8,0xF3B9,0xF4B2,0xF4CC,0xF339,0xF13A,
	0xEFA4,0xEF45,0xF141,0xF54E,0xF9C7,0xFD7C,0xFEAF,0xFE66,
	0xFE3D,0xFE1D,0xFF0E,0x0143,0x048F,0x07EB,0x0A6B,0x0BF5,
	0x0C32,0x0B1D,0x08C3,0x06A4,0x065B,0x073F,0x08C2,0x091A,
	0x0754,0x03D8,0xFF46,0xFA7F,0xF5AF,0xEFAE,0xE6AE,0xDC1C,
	0xD2D6,0xCF67,0xD4B6,0xE0FD,0xF06A,0xFBD2,0xFC2A,0xF140,
	0xE481,0xD866,0xD5ED,0xE0E1,0xF418,0x0941,0x1A5F,0x2197,
	0x1F24,0x169F,0x0D52,0x0794,0x0851,0x0F60,0x1ACF,0x261C,
	0x2C8E,0x2C15,0x2601,0x1D43,0x15B3,0x10F7,0x0E1D,0x0BF9,
	0x0841,0x0411,0x00C3,0xFF47,0xFFFB,0x0108,0xFF2B,0xF929,
	0xF010,0xE640,0xDECC,0xDD19,0xE11E,0xE87D,0xF0B5,0xF6B3,
	0xF961,0xF6EA,0xF0EC,0xEB46,0xE956,0xED0B,0xF54B,0x0013,
	0x0A26,0x10BE,0x1296,0x1060,0x0C94,0x0A03,0x09EA,0x0BAB,
	0x0F69,0x13DB,0x1712,0x17E9,0x1834,0x15B4,0x1114,0x0DE3,
	0x0AE5,0x0748,0x037B,0x0045,0xFD0C,0xFA9F,0xFA6C,0xFC30,
	0xFCF2,0xFB03,0xF5CD,0xEF7A,0xEA27,0xE79F,0xE8C9,0xED55,
	0xF38D,0xF994,0xFBE5,0xF9BB,0xF66F,0xF48A,0xF359,0xF5AB,
	0xFA89,0x014C,0x0718,0x0AF9,0x0BA7,0x0A9B,0x08F2,0x08A1,
	0x09B6,0x0B2F,0x0C2C,0x0C5E,0x0C0E,0x0AB5,0x0969,0x0825,
	0x0881,0x07BC,0x05C3,0x044A,0x016C,0xFC32,0xF725,0xF495,
	0xF54B,0xF8DE,0xFC17,0xFC46,0xF96B,0xF3EB,0xEE00,0xE9CD,
	0xE8EE,0xEC7D,0xF252,0xF746,0xF9F9,0xFA6F,0xF92D,0xF6A1,
	0xF4F5,0xF5C4,0xF8DA,0xFD24,0x01F9,0x0559,0x0696,0x060D,
	0x04C2,0x049F,0x0547,0x06A4,0x0760,0x070D,0x0626,0x059C,
	0x04FE,0x047F,0x03FC,0x0390,0x0299,0x0154,0xFEB8,0xFBE4,
	0xF96B,0xF813,0xF7B4,0xF7D9,0xF759,0xF6AA,0xF5D4,0xF467,
	0xF2D5,0xF218,0xF1F0,0xF2EE,0xF4AD,0xF751,0xF9FC,0xFBB3,
	0xFC10,0xFB40,0xFAC1,0xFA9E,0xFB74,0xFD2D,0xFEDE,0x000A,
	0x0081,0xFFA5,0xFF30,0xFF2E,0xFE4A,0xFD7B,0xFED1,0xFC00,
	0xFB14,0xFACD,0xF91F,0xF85C,0xF797,0xF6C5,0xF583,0xF4D3,
	0xF3A1,0xF299,0xF127,0xF08F,0xEFA4,0xEF1A,0xEE95,0xEDB3,
	0xECBD,0xEBC1,0xEAD9,0xEA12,0xE9EA,0xE940,0xE904,0xE8CA,
	0xE88C,0xE7EF,0xE765,0xE702,0xE6C6,0xE6BD,0xE673,0xE667,
	0xE640,0xE619,0xE5DB,0xE5FD,0xE61D,0xE63A,0xE66E,0xE666,
	0xE635,0xE580,0xE529,0xE506,0xE53F,0xE574,0xE5C1,0xE63F,
	0xE69E,0xE659,0xE5FD,0xE5C3,0xE5B8,0xE60C,0xE668,0xE732,
	0xE78E,0xE7EF,0xE824,0xE82F,0xE7DB,0xE756,0xE629,0xE664,
	0xE798,0xE859,0xE915,0xE961,0xE98B,0xE9F2,0xEA7E,0xEB4E,
	0xEC16,0xED3B,0xED88,0xEDA0,0xEDD9,0xEE8B,0xEEE0,0xF005,
	0xF106,0xF0BB,0xF0FE,0xF245,0xF2C9,0xF2A3,0xF305,0xF3AD,
	0xF3F5,0xF51B,0xF622,0xF684,0xF71B,0xF75B,0xF766,0xF775,
	0xF7D0,0xF86D,0xF974,0xFA41,0xFA97,0xFA70,0xFA8C,0xFB41,
	0xFBBE,0xFD42,0xFE29,0xFD92,0xFDE9,0xFE43,0xFE90,0xFF6C,
	0x0018,0x0097,0x0166,0x0211,0x0339,0x0393,0x03BD,0x0448,
	0x0513,0x0586,0x05B9,0x0632,0x0697,0x06CF,0x068B,0x069F,
	0x0735,0x0788,0x081A,0x0810,0x0839,0x08A9,0x0871,0x086A,
	0x087D,0x089C,0x08C6,0x093E,0x0979,0x0983,0x09C2,0x0A3B,
	0x0A43,0x0A01,0x0A78,0x0AEA,0x0B56,0x0B81,0x0B9B,0x0B9E,
	0x0BAF,0x0BCF,0x0C38,0x0C4F,0x0C4E,0x0C9F,0x0C91,0x0CFB,
	0x0CEF,0x0CF4,0x0CE6,0x0CBF,0x0D16,0x0D00,0x0D57,0x0D7B,
	0x0DD1,0x0E20,0x0DE9,0x0DD8,0x0DFE,0x0E58,0x0E17,0x0DB9,
	0x0DB1,0x0DCC,0x0D9E,0x0E5B,0x0EBC,0x0F49,0x0D6C,0x0DF3,
	0x0F47,0x0DF2,0x0E06,0x0E4E,0x0E2F,0x0E97,0x0E29,0x0DBA,
	0x0DC7,0x0DE4,0x0DB3,0x0D90,0x0D5B,0x0D75,0x0E23,0x0E18,
	0x0DD2,0x0E34,0x0E71,0x0E40,0x0E5F,0x0E95,0x0E66,0x0E07,
	0x0DBE,0x0D50,0x0D6D,0x0D6E,0x0DBF,0x0DEA,0x0DA0,0x0D96,
	0x0D5E,0x0D17,0x0CD5,0x0CAA,0x0CA7,0x0CFB,0x0D11,0x0D19,
	0x0CEB,0x0C64,0x0BEC,0x0C57,0x0C69,0x0C9B,0x0CBC,0x0C6A,
	0x0C5A,0x0C20,0x0BFB,0x0C42,0x0CB0,0x0C75,0x0C75,0x0C08,
	0x0BBE,0x0BD5,0x0BCD,0x0CA7,0x0E6C,0x0E3F,0x0DF2,0x0D9E,
	0x0D16,0x0CC2,0x0CAF,0x0C4F,0x0BFC,0x0BEB,0x0C44,0x0C44,
	0x0BF5,0x0BB5,0x0BB4,0x0B7F,0x0B5D,0x0B4C,0x0B0F,0x0A60,
	0x0A9E,0x0B02,0x0A40,0x09BD,0x09D7,0x0A21,0x09BB,0x097A,
	0x0957,0x092F,0x08EC,0x08B5,0x0854,0x0818,0x07D6,0x0830,
	0x0830,0x0848,0x07C6,0x078C,0x079D,0x0748,0x0729,0x078E,
	0x073A,0x05B8,0x05F1,0x071D,0x0766,0x0718,0x06A9,0x06A6,
	0x066F,0x0647,0x0647,0x0642,0x0582,0x04F6,0x047A,0x04A8,
	0x0475,0x043B,0x0442,0x03E2,0x0363,0x030D,0x036A,0x03BF,
	0x03F1,0x03D7,0x03BD,0x034D,0x0354,0x03B7,0x041A,0x039C,
	0x038E,0x039A,0x03A2,0x0389,0x0371,0x0333,0x032A,0x0358,
	0x036D,0x034A,0x02CD,0x02DB,0x02A1,0x026B,0x0282,0x029E,
	0x029E,0x0230,0x01F5,0x01F2,0x0255,0x027A,0x023E,0x0235,
	0x0236,0x023D,0x0233,0x01C6,0x01CF,0x01BA,0x0181,0x01AB,
	0x013D,0x0141,0x018F,0x01C9,0x0198,0x018E,0x01FD,0x0313,
	0x02A0,0x0285,0x02D1,0x029E,0x0160,0x028D,0x032E,0x018F,
	0x02B0,0x02C2,0x0289,0x022D,0x0280,0x022F,0x02B9,0x02BF,
	0x02D3,0x0200,0x01CB,0x021D,0x0201,0x0262,0x0272,0x0279,
	0x023B,0x02A1,0x0286,0x023C,0x0257,0x01FB,0x01FE,0x0224,
	0x0244,0x0266,0x02EB,0x0238,0x0229,0x0245,0x0271,0x0278,
	0x028C,0x02B4,0x0242,0x01DA,0x01AB,0x021B,0x0234,0x01F5,
	0x021B,0x0235,0x0258,0x021E,0x0202,0x0213,0x0195,0x019E,
	0x01B9,0x01E4,0x01FF,0x0232,0x0237,0x0207,0x0174,0x0143,
	0x0172,0x0158,0x0195,0x0154,0x00D6,0xFFFF,0xFFD7,0xFF73,
	0xFF58,0xFF38,0xF5B6,0xF1ED,0xF7B6,0xFA5F,0xFAF8,0xF9B4,
	0xFA07,0xFE8A,0x04CF,0x04D1,0x0124,0xFD5B,0xFA23,0xFBC5,
	0xFE67,0x0164,0x037A,0x03A1,0x01D2,0xFF7C,0xFF83,0x0143,
	0x0215,0x0167,0x003C,0x0078,0x01D2,0x022C,0x0163,0x00A4,
	0x0092,0x01B3,0x036E,0x0446,0x040F,0x0257,0xFF9F,0xFDC6,
	0xFED3,0x01E2,0x0422,0x03AE,0x0242,0x0124,0x0057,0xFFF7,
	0xFFEC,0x0059,0x0078,0x00A2,0x0020,0x004E,0x0169,0x0153,
	0x0077,0x003D,0x00DF,0x0163,0x016F,0x006B,0xFF1D,0xFE76,
	0xFE90,0xFFFD,0x014A,0x0235,0x01B5,0x00A6,0xFF70,0xFF30,
	0x0043,0x02FB,0x032F,0x0276,0x022B,0x0239,0x0288,0x027D,
	0x0234,0x01E2,0x01EE,0x01A2,0x01AC,0x0136,0x00CC,0x002F,
	0xFFA2,0x000B,0x00BC,0x019A,0x00E9,0x0083,0x001E,0xFEEC,
	0xFE55,0xFED3,0xFF6E,0xFFDB,0x0002,0xFFD9,0xFFC8,0xFF68,
	0xFF27,0xFF2A,0xFF35,0xFF12,0xFF0D,0xFF17,0xFE8D,0xFDF7,
	0xFE09,0xFE3D,0xFE83,0xFE9D,0xFF34,0xFE96,0xFCD3,0xFC1D,
	0xFCFA,0xFE0F,0xFEF9,0xFEBB,0xFEBE,0xFEC4,0xFE95,0xFDE4,
	0xFDBA,0xFD46,0xFCBF,0xFD07,0xFC92,0xFBE7,0xFCDE,0xFCB8,
	0xFC3B,0xFC21,0xFC4A,0xFC97,0xFCBC,0xFCC1,0xFC8B,0xFC76,
	0xFCA2,0xFCB4,0xFCFA,0xFD68,0xFDD7,0xFDAA,0xFD0E,0xFD0F,
	0xFCE1,0xFCD3,0xFCA3,0xFC41,0xFC5B,0xFC57,0xFC70,0xFCC6,
	0xFCB9,0xFC30,0xFC3D,0xFC76,0xFC71,0xFCA6,0xFCA0,0xFC72,
	0xFBFC,0xFBFA,0xFC38,0xFCB7,0xFD05,0xFD0C,0xFCA7,0xFC5C,
	0xFC40,0xFC03,0xFC54,0xFBCF,0xFBF4,0xFC15,0xFBF2,0xFC1E,
	0xFC9C,0xFC41,0xFC1F,0xFC56,0xFD39,0xFD7B,0xFD6C,0xFD5A,
	0xFD82,0xFC82,0xFDED,0xFED2,0xFCEB,0xFE4E,0xFE56,0xFDE2,
	0xFDA7,0xFDD4,0xFD94,0xFD9A,0xFDB9,0xFDFF,0xFE32,0xFE18,
	0xFE54,0xFDA4,0xFDCC,0xFDC3,0xFDD2,0xFE3D,0xFEBB,0xFEE3,
	0xFEDA,0xFE85,0xFE7F,0xFE91,0xFE7B,0xFE64,0xFE35,0xFE27,
	0xFE28,0xFE86,0xFE5F,0xFE8B,0xFEC7,0xFED4,0xFEE8,0xFEE7,
	0xFF1D,0xFF3B,0xFF31,0xFED8,0xFF1B,0xFF4D,0xFF89,0xFFC7,
	0xFFDE,0xFFFC,0xFFA5,0xFF63,0xFF28,0xFF70,0xFF64,0xFFA1,
	0xFFF5,0xFFFC,0xFFDF,0x001E,0x0018,0x0012,0x0010,0xFFB8,
	0xFFAB,0xFFB1,0xFE9D,0xFCC9,0xFD6B,0xFD71,0xFD8E,0xFDA1,
	0xFDE7,0xFE5D,0xFE7D,0xFE6A,0xFE5C,0xFE86,0xFE9F,0xFE6D,
	0xFE8A,0xFEF4,0xFF02,0xFF1A,0xFF7D,0xFF00,0xFE07,0xFED7,
	0xFFC7,0xFF93,0xFF97,0x0014,0x0050,0xFFD9,0x0004,0x0023,
	0xFFE9,0x0052,0x0072,0x007A,0x0048,0x0057,0x0043,0x0036,
	0x0057,0x0063,0x0080,0x0081,0x004C,0x001F,0x018A,0x00CC,
	0x0054,0x002E,0x005C,0x0064,0x0063,0x003A,0x003E,0x0049,
	0x00B0,0x0147,0x017F,0x01A6,0x0203,0x025F,0x0201,0x01EA,
	0x021E,0x01F9,0x020A,0x0200,0x01F7,0x01FB,0x01DA,0x01DF,
	0x0216,0x01BA,0x017D,0x01FB,0x01EE,0x01A9,0x0153,0x012D,
	0x012B,0x0123,0x019F,0x01FE,0x01FB,0x01BB,0x018E,0x0121,
	0x00F8,0x011B,0x014D,0x0191,0x01C2,0x01C2,0x015B,0x0107,
	0x0102,0x00CB,0x00C1,0x00F1,0x00E9,0x00E9,0x00FA,0x0090,
	0x00A8,0x008B,0x00B8,0x0105,0x0120,0x0109,0x00ED,0x00D1,
	0x0059,0x0081,0x005C,0x003C,0x0028,0x0073,0x0072,0x0020,
	0xFFC3,0x0033,0x0001,0xFEBF,0x009A,0x0029,0xFFB0,0xFFFC,
	0xFFA8,0xFF2D,0xFF15,0xFF10,0xFF3B,0xFF52,0xFF82,0xFF6A,
	0xFF2C,0xFF2A,0xFEC0,0xFED4,0xFEEE,0xFEF7,0xFF3A,0xFF2D,
	0xFF56,0xFF5C,0xFF2D,0xFF27,0xFEE4,0xFF87,0xFFE4,0xFFB0,
	0xFFDA,0xFFE7,0xFF98,0xFEE4,0xFED4,0xFE99,0xFE45,0xFEBD,
	0xFF76,0xFEB9,0xFE0F,0xFDFE,0xFE02,0xFE59,0xFE7C,0xFE73,
	0xFE92,0xFEC2,0xFEAA,0xFE4A,0xFDD2,0xFDD0,0xFE5B,0xFE64,
	0xFE49,0xFE8D,0xFE46,0xFE17,0xFDF2,0xFE0E,0xFE1F,0xFEAA,
	0x0095,0x0199,0x00D4,0x009E,0xFFF9,0xFF89,0xFF78,0xFFD4,
	0x0034,0x009D,0x0054,0xFFD0,0xFFA3,0xFF68,0xFF63,0xFF3E,
	0xFF89,0xFFBC,0xFFFE,0xFFC0,0xFEF5,0xFFC5,0xFFAC,0xFECC,
	0xFE5E,0xFF4A,0xFF3A,0xFEDD,0xFE79,0xFE13,0xFDFB,0xFE1A,
	0xFE6F,0xFF24,0xFF07,0xFEC5,0xFEC7,0xFE83,0xFE3E,0xFE92,
	0xFEDA,0xFEF5,0xFEB0,0xFEDF,0xFF74,0xFECE,0xFDBE,0xFE8A,
	0xFF40,0xFF3D,0xFF3A,0xFF2C,0xFED6,0xFEAD,0xFE77,0xFE67,
	0xFE77,0xFDE3,0xFD8D,0xFE32,0xFCD9,0xFC40,0xFCC8,0xFC98,
	0xFCD2,0xFD28,0xFD13,0xFD1E,0xFD0D,0xFD17,0xFD2D,0xFCEB,
	0xFCE4,0xFD2F,0xFCF8,0xFD3C,0xFD92,0xFD7B,0xFD44,0xFD3B,
	0xFD13,0xFD10,0xFD49,0xFD89,0xFDB5,0xFD82,0xFDC9,0xFD44,
	0xFD40,0xFDA3,0xFDD1,0xFDA3,0xFD9E,0xFD43,0xFD41,0xFD41,
	0xFD27,0xFCE5,0xFD3B,0xFD02,0xFD12,0xFD3B,0xFD91,0xFD4E,
	0xFD73,0xFD0E,0xFD19,0xFD2B,0xFD5F,0xFD5C,0xFDF1,0xFDCA,
	0xFD85,0xFD2F,0xFD56,0xFDC8,0xFE84,0xFE4F,0xFE48,0xFE74,
	0xFE50,0xFE06,0xFFEF,0xFE61,0xFE1F,0xFF1D,0xFEC1,0xFEE5,
	0xFF00,0xFF12,0xFECD,0xFED5,0xFEA2,0xFEEA,0xFF36,0xFF3B,
	0xFF30,0xFF3F,0xFF24,0xFEF1,0xFF45,0xFF0E,0xFF40,0xFF8F,
	0xFF93,0xFF85,0xFFA3,0xFF53,0xFF7C,0xFFB0,0xFF81,0xFF5A,
	0xFFAF,0xFFD0,0xFFB0,0xFF30,0xFF3F,0x002E,0x007E,0x018A,
	0x026C,0x035D,0x0383,0x0350,0x034E,0x035F,0x04AB,0x0672,
	0x0812,0x0976,0x0A32,0x0A5F,0x0A90,0x0AE8,0x0B56,0x0B63,
	0x0B68,0x0B51,0x0B06,0x0AE9,0x0AE1,0x0B3B,0x0BF8,0x0CB2,
	0x0CC2,0x0CA8,0x0B8A,0x0C1B,0x0D44,0x0CD3,0x0BD1,0x0C0A,
	0x0D91,0x0F58,0x10A5,0x11A7,0x1240,0x11E4,0x10E0,0x10CC,
	0x11CD,0x1341,0x139D,0x13BE,0x139F,0x130C,0x13C1,0x1533,
	0x15C3,0x1582,0x14F6,0x150A,0x14E7,0x1546,0x15D0,0x15BB,
	0x15A1,0x156F,0x1572,0x1634,0x1727,0x1755,0x176D,0x1769,
	0x16FA,0x16ED,0x16E3,0x16E0,0x166F,0x17AD,0x17E8,0x167B,
	0x1680,0x176B,0x17E3,0x16A4,0x1532,0x1407,0x13C8,0x1459,
	0x1541,0x168C,0x16BA,0x159B,0x1458,0x13E4,0x141B,0x145E,
	0x1444,0x13A0,0x1294,0x111C,0x0FD4,0x0E57,0x0C3A,0x0913,
	0x04E7,0x0009,0xFA3B,0xF49E,0xF20E,0xF37F,0xF951,0x0218,
	0x0A44,0x0E38,0x0CF6,0x0701,0xFF52,0xFAD7,0xFB35,0x000F,
	0x080B,0x111C,0x183D,0x1C32,0x1BE9,0x195F,0x1601,0x12FB,
	0x1004,0x0E7C,0x0EEE,0x1147,0x130E,0x1374,0x127F,0x1125,
	0x0F64,0x0D20,0x09F5,0x0602,0x0152,0xFBD5,0xF6D6,0xF467,
	0xF50F,0xF7D5,0xFAE4,0xFBC7,0xFA16,0xF6CD,0xF206,0xED4B,
	0xEAB9,0xEB01,0xEBA4,0xF01A,0xF5F5,0xF8C2,0xFB94,0xFC85,
	0xFBAD,0xF9E6,0xF89A,0xF92D,0xFB08,0xFD23,0xFEF4,0x001C,
	0x0128,0x01CC,0x026F,0x038F,0x0417,0x0367,0x0067,0xFBCF,
	0xF7D7,0xF5C0,0xF5C1,0xF701,0xF7A3,0xF84C,0xF7B4,0xF532,
	0xF17C,0xED60,0xE9D3,0xE77E,0xE67B,0xE671,0xE815,0xEA54,
	0xEBAB,0xEB9F,0xEAA6,0xE98E,0xE993,0xEA5F,0xEB58,0xEC68,
	0xEC96,0xED2F,0xEE7C,0xF086,0xF35F,0xF5DE,0xF6EE,0xF690,
	0xF562,0xF4FA,0xF4E5,0xF4FD,0xF548,0xF610,0xF71A,0xF854,
	0xFA67,0xF94A,0xF75C,0xF4D3,0xF2C6,0xF16F,0xF0E6,0xEFD1,
	0xEEA0,0xEE3C,0xED68,0xEC74,0xEBA1,0xEB5C,0xEB2F,0xEA40,
	0xE982,0xE8F9,0xE8A2,0xE7CF,0xE878,0xEA66,0xEB9D,0xEC39,
	0xED54,0xEEC1,0xEF38,0xEF7D,0xEECC,0xEE7D,0xEF70,0xF18E,
	0xF320,0xF43F,0xF4EB,0xF572,0xF523,0xF41D,0xF395,0xF413,
	0xF46E,0xF399,0xF2D4,0xF28E,0xF25D,0xF0E9,0xF08A,0xF0FE,
	0xF10A,0xF00C,0xEF0F,0xEDEE,0xEDAF,0xEDED,0xED61,0xECB1,
	0xEC1F,0xEBF1,0xEC40,0xEC27,0xEB90,0xEC35,0xEC2D,0xEC97,
	0xED7A,0xEDD7,0xEEC0,0xEF70,0xF077,0xF0FB,0xF1DB,0xF28B,
	0xF310,0xF346,0xF32E,0xF38A,0xF437,0xF4DC,0xF631,0xF760,
	0xF7AB,0xF76B,0xF647,0xF527,0xF487,0xF480,0xF543,0xF596,
	0xF523,0xF498,0xF439,0xF3B8,0xF2F5,0xF293,0xF287,0xF23A,
	0xF1FD,0xF207,0xF23C,0xF24D,0xF1DB,0xF178,0xF1ED,0xF3B9,
	0xF4C8,0xF526,0xF504,0xF4C6,0xF43D,0xF407,0xF3DF,0xF4A4,
	0xF5EE,0xF751,0xF8E6,0xF9D6,0xF995,0xF8BF,0xF893,0xF8B0,
	0xF834,0xF9BC,0xFAC7,0xF944,0xFAC2,0xFAB9,0xF9FC,0xF9E2,
	0xF875,0xF452,0xED5F,0xE215,0xD19D,0xC198,0xBF25,0xBF8E,
	0xBFD6,0xBFAE,0xC3A9,0xE315,0x0032,0x0A83,0x000A,0xE7CE,
	0xCE63,0xC1F9,0xCA55,0xE4A2,0x081E,0x2ABD,0x3DFA,0x3EC1,
	0x3EE8,0x3F59,0x3920,0x2E9E,0x28BC,0x28D8,0x2DBE,0x34E9,
	0x3A95,0x3C8E,0x3A8C,0x3628,0x302B,0x28D9,0x1ED5,0x0FDA,
	0xFCD2,0xE8EA,0xDA4D,0xD5EA,0xDBD5,0xE843,0xF33F,0xF7AB,
	0xF31C,0xE5E5,0xD4A6,0xC59A,0xC02F,0xC131,0xCB7D,0xDCF9,
	0xEF29,0xFD9F,0x05A1,0x08B0,0x0648,0x01F2,0xFFA1,0x012E,
	0x0711,0x1099,0x19BB,0x2096,0x25E1,0x2A3B,0x2DED,0x2FD8,
	0x2E21,0x2830,0x1EF1,0x14D5,0x0A2D,0x03AC,0x0342,0x0611,
	0x08E3,0x09E8,0x0804,0x016A,0xF75C,0xEBB8,0xDFBC,0xD619,
	0xD1F1,0xD3F8,0xDB36,0xE392,0xEA0B,0xECCD,0xEBA2,0xE757,
	0xE326,0xE2D9,0xE69B,0xEBC6,0xF14D,0xF915,0xFFB0,0x064D,
	0x0D11,0x1292,0x163F,0x1768,0x1641,0x147F,0x1404,0x14A5,
	0x160F,0x16D4,0x17B5,0x19AA,0x1B62,0x1AFC,0x189B,0x12E4,
	0x09D1,0xFFF6,0xF899,0xF4E1,0xF4B6,0xF661,0xF79C,0xF81C,
	0xF557,0xF03E,0xEB57,0xE78F,0xE522,0xE45C,0xE550,0xE821,
	0xEBDF,0xEF72,0xF2FC,0xF5EB,0xF8EB,0xFB0D,0xFDD2,0x008B,
	0x02B9,0x0480,0x0561,0x069E,0x0929,0x0D3E,0x1240,0x1693,
	0x189C,0x1806,0x14CA,0x103B,0x0B6C,0x0848,0x0748,0x07FB,
	0x0907,0x0933,0x08C5,0x062B,0x01F6,0xFC9F,0xF74E,0xF304,
	0xF0C0,0xEF53,0xEFA2,0xF05F,0xF0E5,0xEFC1,0xEE77,0xEE74,
	0xF0A4,0xF27B,0xF194,0xF416,0xF45D,0xF45E,0xF59C,0xF783,
	0xFB3D,0x008A,0x04F1,0x06F9,0x0834,0x085D,0x0860,0x0830,
	0x07BF,0x0826,0x092F,0x0AC3,0x0C72,0x0D5C,0x0CD1,0x0A8A,
	0x0763,0x04FC,0x037C,0x01E9,0xFF75,0xFDBD,0xFC81,0xFB52,
	0xF9A2,0xF84D,0xF7CB,0xF6D3,0xF535,0xF35D,0xF2B0,0xF270,
	0xF25D,0xF2AF,0xF39A,0xF4BC,0xF659,0xF89D,0xFA83,0xFC75,
	0xFDFC,0xFE6A,0xFF05,0xFF7C,0xFFB0,0x0198,0x04BA,0x078B,
	0x091E,0x09A9,0x09F4,0x09AC,0x084F,0x06FB,0x06DC,0x08D0,
	0x09B9,0x07C8,0x0634,0x041E,0xFE3F,0xF2E7,0xE205,0xCBF6,
	0xBFE4,0xC050,0xBFCB,0xC093,0xBFCD,0xC760,0xEC2F,0x06E4,
	0x0BAC,0xFB39,0xDC6B,0xC3F2,0xC0B9,0xC90D,0xEA50,0x13C2,
	0x3777,0x3F15,0x3E97,0x3F02,0x3EC8,0x3ECB,0x370F,0x3163,
	0x34D3,0x3C71,0x3F34,0x3ECB,0x3EF5,0x3EC2,0x3EC2,0x3CC1,
	0x33FB,0x271E,0x1435,0xFD18,0xE667,0xD69B,0xD33B,0xDAC4,
	0xE8F5,0xF54F,0xF8DE,0xF078,0xDF51,0xCA1A,0xBF1D,0xBF9E,
	0xBEB1,0xC364,0xD86B,0xEEAA,0x0014,0x09E6,0x0B5C,0x06C2,
	0x00B4,0xFED6,0x0324,0x0CE0,0x18B4,0x23CA,0x2BF9,0x31C1,
	0x36F3,0x3A4B,0x3C0F,0x3A7F,0x345D,0x293F,0x1BC4,0x107A,
	0x0A42,0x0978,0x0C0B,0x0F59,0x110E,0x0E77,0x05B4,0xF782,
	0xE6D4,0xD6F4,0xCCA2,0xCA53,0xCF7D,0xD8BD,0xE1BC,0xE743,
	0xE7E3,0xE4D6,0xE0E4,0xDE57,0xDEBD,0xE23D,0xE7B5,0xEEC3,
	0xF66F,0xFEEB,0x071B,0x0EEB,0x14E7,0x1990,0x1BE6,0x1C71,
	0x1A6B,0x16E5,0x14E9,0x155C,0x17B5,0x1BF5,0x20CC,0x22E3,
	0x20D2,0x1CC0,0x10C3,0x0507,0xFCD9,0xF65A,0xF373,0xF2B1,
	0xF35B,0xF415,0xF33F,0xF01E,0xEBB6,0xE6B0,0xE27F,0xDF2A,
	0xDDC7,0xDD81,0xDFBA,0xE39E,0xE87A,0xEDB5,0xF28B,0xF7A7,
	0xFBDC,0xFE66,0xFE8A,0xFE06,0xFF1C,0x01EE,0x0639,0x0BE6,
	0x1236,0x1767,0x1A87,0x1A78,0x191A,0x166F,0x131D,0x0F55,
	0x0C7F,0x0B99,0x0B59,0x0B6A,0x0AD5,0x0906,0x062C,0x01DE,
	0xFD1B,0xF8EF,0xF533,0xF1FA,0xEEF9,0xEC75,0xEBE8,0xED3A,
	0xEEC6,0xF09B,0xF1D3,0xF2AC,0xF262,0xF0B6,0xEFD2,0xF090,
	0xF31F,0xF5CA,0xFA1C,0xFEF3,0x038E,0x0715,0x08DB,0x097B,
	0x0A12,0x0AB8,0x0BF7,0x0CBD,0x0E17,0x0F5D,0x10C1,0x11AE,
	0x1182,0x101C,0x0EF0,0x0D1D,0x0909,0x05B8,0x02F2,0x0091,
	0xFE78,0xFD8C,0xFD5A,0xFCD9,0xFBF8,0xFA01,0xF6D1,0xF46B,
	0xF29F,0xF1BE,0xF1BE,0xF297,0xF40C,0xF538,0xF65E,0xF816,
	0xF995,0xFB52,0xFCCA,0xFD4F,0xFED9,0x012E,0x0247,0x0435,
	0x0688,0x085C,0x09E4,0x0B6F,0x0C87,0x0D6A,0x0D32,0x0C8A,
	0x0B4E,0x0AC2,0x0AD4,0x0AA3,0x0A2C,0x08F9,0x0741,0x0301,
	0xFB00,0xEE74,0xDCE1,0xC70A,0xC053,0xC0F7,0xC08C,0xC1A3,
	0xC01C,0xCDFB,0xF496,0x0A4D,0x0A00,0xF4C8,0xD4E6,0xC226,
	0xC1E7,0xD08B,0xF738,0x2256,0x3E25,0x3F77,0x3FE8,0x3FEA,
	0x3FEF,0x3F68,0x382E,0x359E,0x3B63,0x4012,0x3FEA,0x3FD7,
	0x3FEB,0x3FE2,0x3FCA,0x3D78,0x340C,0x25D2,0x119B,0xFA24,
	0xE544,0xD879,0xD71C,0xE033,0xEE36,0xF825,0xF85C,0xEDE8,
	0xDC2C,0xC772,0xBFEB,0xC0B2,0xC021,0xCB6F,0xE246,0xF828,
	0x07FF,0x0D56,0x0CB3,0x08F1,0x03C3,0x0468,0x0A8A,0x1492,
	0x1FAD,0x290E,0x3049,0x3608,0x3A68,0x3D7F,0x3E01,0x3AB9,
	0x3315,0x2879,0x1CE2,0x12A4,0x0C0A,0x0A3C,0x0C9B,0x0FDA,
	0x10F6,0x0D53,0x03B3,0xF459,0xE2A3,0xD495,0xCCE5,0xCBC4,
	0xD14C,0xD9CE,0xE20B,0xE769,0xE785,0xE3D6,0xDFA5,0xDD8D,
	0xDE4E,0xE1E0,0xE7C0,0xEF9A,0xF8A7,0x0195,0x09D3,0x10D3,
	0x165B,0x1980,0x1AA5,0x19F7,0x18A8,0x1759,0x160C,0x169F,
	0x1887,0x1C36,0x1FA1,0x209B,0x1E34,0x17E9,0x0EDC,0x065A,
	0xFCB1,0xF5FC,0xF2F3,0xF20F,0xF279,0xF21D,0xF12A,0xEEDB,
	0xEB1C,0xE67F,0xE142,0xDD2C,0xDB0A,0xDBA9,0xDDD9,0xE235,
	0xE7E6,0xEDDC,0xF262,0xF69A,0xFA34,0xFBC8,0xFC9D,0xFE09,
	0xFF8C,0x01FA,0x0693,0x0C5F,0x1203,0x1698,0x192F,0x19E5,
	0x18B4,0x14DB,0x10FD,0x0D4C,0x0B5E,0x0A1C,0x08BE,0x083C,
	0x081A,0x072C,0x0499,0xFFC2,0xF92A,0xF415,0xEFF7,0xECB0,
	0xEB02,0xEA0F,0xEAAF,0xEBA6,0xECF2,0xEDB9,0xEE22,0xEDC8,
	0xECF9,0xECE1,0xECF0,0xEDFF,0xF08B,0xF458,0xF8F5,0xFDFA,
	0x0278,0x061F,0x07ED,0x086C,0x0850,0x081D,0x089F,0x09B0,
	0x0B31,0x0CEA,0x0EC7,0x0FB8,0x0EEA,0x0CD9,0x0AB9,0x07D1,
	0x04BB,0x01F8,0x0016,0xFE9F,0xFD3D,0xFBA0,0xF9A3,0xF7DB,
	0xF647,0xF482,0xF31F,0xF1C7,0xF093,0xEF06,0xED21,0xED05,
	0xEE51,0xF109,0xF3DF,0xF606,0xF76D,0xF7FE,0xF7FE,0xF80D,
	0xF9A2,0xFC02,0xFEDE,0x01A6,0x03EA,0x0682,0x08DC,0x09E7,
	0x0984,0x08CA,0x0845,0x07C4,0x07C4,0x089B,0x092D,0x0835,
	0x0837,0x06E5,0x0169,0xFD17,0xF4B9,0xE88F,0xD655,0xC21D,
	0xBEEF,0xBF52,0xBF21,0xC05E,0xBEEE,0xD6E9,0xFC76,0x0B26,
	0x0375,0xE971,0xCB09,0xC014,0xC21F,0xD80D,0x0185,0x2C01,
	0x3F05,0x3E3F,0x3F0A,0x3EDC,0x3F69,0x3C3D,0x356A,0x3739,
	0x3D6F,0x3F6C,0x3F35,0x3F74,0x3F71,0x3F48,0x3F4D,0x3D49,
	0x32DB,0x21C9,0x0A70,0xF20A,0xDEB1,0xD589,0xD847,0xE44B,
	0xF1DD,0xF8AF,0xF50B,0xE812,0xD492,0xC2A8,0xBFE2,0xC0B8,
	0xC06C,0xCFB1,0xE805,0xFC2E,0x0896,0x0CBE,0x0A69,0x050C,
	0x008C,0x00F1,0x0950,0x149B,0x1F87,0x2870,0x2F91,0x3598,
	0x3A3A,0x3DB0,0x3D18,0x379B,0x2E1B,0x21CC,0x1608,0x0DAB,
	0x0A75,0x0B61,0x0F5C,0x1171,0x0FD1,0x09EA,0xFE3D,0xEE4C,
	0xDE43,0xD243,0xCC7D,0xCD47,0xD3FD,0xDCB6,0xE431,0xE819,
	0xE711,0xE307,0xDEB5,0xDD15,0xDF0E,0xE43D,0xEB8B,0xF421,
	0xFCD0,0x0555,0x0D45,0x1455,0x1AE3,0x1D13,0x1C96,0x1B3F,
	0x192A,0x1834,0x1820,0x18F6,0x1B77,0x1F52,0x2252,0x234F,
	0x206C,0x1997,0x0FA9,0x0540,0xFBDA,0xF556,0xF2A7,0xF333,
	0xF4EA,0xF531,0xF396,0xEFC4,0xEA87,0xE4B0,0xDF46,0xDC54,
	0xDCA0,0xDF6A,0xE394,0xE814,0xEC97,0xF11F,0xF4DA,0xF7E7,
	0xFB08,0xFE03,0x0057,0x0195,0x02F4,0x05C8,0x0A25,0x0F1B,
	0x1377,0x179A,0x1ACD,0x1B57,0x1A1F,0x1760,0x133D,0x0EF1,
	0x0B5F,0x098E,0x097E,0x0A90,0x0A95,0x08E7,0x053B,0xFF97,
	0xF949,0xF3EE,0xEFE6,0xEDB2,0xEC5A,0xEBBD,0xEB23,0xEBA2,
	0xECC5,0xED7B,0xED6B,0xEDE0,0xEE29,0xEE3A,0xEEFE,0xF1D2,
	0xF435,0xF5C9,0xFAC3,0xFE15,0x0226,0x06EF,0x09F6,0x0BCC,
	0x0BF8,0x0AC8,0x0995,0x0978,0x0A5E,0x0C08,0x0E2C,0x0F64,
	0x0FEB,0x0EC4,0x0BA6,0x085B,0x0531,0x01F1,0xFED4,0xFC60,
	0xFAF2,0xFA24,0xF9DC,0xF8CC,0xF6F1,0xF4F5,0xF319,0xF177,
	0xF08E,0xF072,0xF00F,0xEF66,0xEFD3,0xF195,0xF401,0xF688,
	0xF8D1,0xFA98,0xFBD2,0xFD62,0xFEB6,0xFFB9,0x0072,0x0158,
	0x032F,0x060E,0x0911,0x0ABA,0x0C2E,0x0C8E,0x0AF2,0x090A,
	0x07AF,0x0651,0x0575,0x0586,0x0634,0x059D,0x026F,0xF8DE,
	0xE819,0xD1EA,0xC092,0xC063,0xBFFB,0xC06D,0xC0C1,0xC2C4,
	0xE2E7,0x029D,0x0BC0,0xFEF8,0xE2E7,0xC77F,0xC081,0xC5CD,
	0xE215,0x09F2,0x3105,0x3FC4,0x3EFE,0x3F33,0x3EB1,0x3FA4,
	0x3AFB,0x3340,0x34CA,0x3BEC,0x3F33,0x3F36,0x3F0F,0x3EDB,
	0x3EAF,0x3EFB,0x39F4,0x2CBA,0x19AA,0x025A,0xEBC4,0xDBA8,
	0xD607,0xDBF3,0xE91D,0xF3D2,0xF66D,0xF0E6,0xE294,0xCF1F,
	0xC090,0xBFAF,0xBF7E,0xC1A9,0xD36D,0xE93B,0xFCBC,0x08E6,
	0x0B8B,0x075A,0x00F3,0xFECD,0x015C,0x088D,0x1278,0x1CF4,
	0x26B6,0x2E96,0x3520,0x3A43,0x3CC8,0x3A6E,0x3258,0x26B5,
	0x1B09,0x10E5,0x0A21,0x07CC,0x095F,0x0D04,0x0E9C,0x0C04,
	0x049D,0xF86E,0xE889,0xD8EF,0xCD15,0xC80B,0xC9FF,0xD183,
	0xDA02,0xE0D8,0xE41E,0xE369,0xE124,0xDE7F,0xDCCA,0xDD97,
	0xE165,0xE78B,0xF001,0xF9F3,0x03C5,0x0C52,0x1286,0x1679,
	0x1950,0x19B9,0x17D7,0x144F,0x119D,0x116E,0x1451,0x1893,
	0x1D57,0x2064,0x1FE4,0x19E6,0x1144,0x07B4,0xFE82,0xF687,
	0xF37C,0xEF83,0xEF83,0xF105,0xF0DF,0xEF64,0xEC9F,0xE839,
	0xE247,0xDD3F,0xDA9F,0xDAAF,0xDCEB,0xE0B9,0xE58F,0xEB45,
	0xEFF5,0xF38C,0xF701,0xFA88,0xFCD9,0xFDA3,0xFE0D,0xFEFA,
	0x02B9,0x0856,0x0E2A,0x1329,0x170B,0x18AD,0x17B6,0x1545,
	0x129D,0x0F7D,0x0C69,0x09F4,0x088B,0x0879,0x0861,0x07D1,
	0x058E,0x0101,0xFC35,0xF6A1,0xF22D,0xEF4C,0xED51,0xEBC3,
	0xEAFB,0xEAD6,0xEB18,0xEC7D,0xEDF9,0xEEDB,0xEF61,0xEE77,
	0xEE0A,0xEE8A,0xF05F,0xF3EB,0xF8A6,0xFD6B,0x0157,0x03C2,
	0x047A,0x0682,0x0853,0x094E,0x0A1B,0x0A03,0x0A79,0x0B95,
	0x0D8C,0x1017,0x10BC,0x0F2A,0x0CE0,0x0A80,0x0826,0x05BA,
	0x03BC,0x01B6,0xFE5E,0xFA3A,0xF8A2,0xF92F,0xF9EE,0xF974,
	0xF76A,0xF40F,0xF103,0xEE98,0xEDA3,0xEF53,0xF212,0xF348,
	0xF3F8,0xF4DE,0xF744,0xFA03,0xFC68,0xFD59,0xFD2B,0xFD82,
	0xFED8,0x017C,0x04B7,0x0819,0x0AF3,0x0B18,0x0B1F,0x0B19,
	0x0BA8,0x0C2F,0x0BAB,0x0A04,0x0885,0x081B,0x0897,0x08DA,
	0x07A4,0x0462,0xFDBE,0xF268,0xE246,0xCC7F,0xC059,0xC113,
	0xC0AE,0xC163,0xC0E2,0xC82F,0xEDF6,0x0A64,0x0E9C,0xFC8E,
	0xDCE7,0xC4CF,0xC161,0xCB48,0xEECA,0x1AE7,0x3BC1,0x3FD7,
	0x3FD4,0x402F,0x3FE3,0x407B,0x3A7B,0x354C,0x3A28,0x3FDB,
	0x3FFE,0x3FEF,0x4016,0x3FDB,0x4008,0x3E56,0x3715,0x2BA5,
	0x18F2,0x0006,0xE794,0xD77E,0xD415,0xDCC1,0xEACA,0xF6A5,
	0xF977,0xF11E,0xDFB6,0xCA99,0xC04F,0xC0E0,0xC00C,0xC57A,
	0xDCA0,0xF33B,0x042C,0x0C89,0x0B77,0x05AD,0x00DA,0x01B0,
	0x06E2,0x12C6,0x1F00,0x265E,0x2D0F,0x326E,0x3741,0x3BB5,
	0x3DC1,0x3C19,0x34FD,0x295A,0x1C7E,0x118F,0x0B9C,0x0A03,
	0x0B52,0x0DE3,0x0F47,0x0D75,0x0601,0xF7EF,0xE640,0xD5EA,
	0xCB44,0xC8C1,0xCE39,0xD7B3,0xE0E7,0xE67B,0xE669,0xE29A,
	0xDF8E,0xDE9B,0xDEBF,0xE0AF,0xE5A8,0xED4C,0xF68F,0xFFCE,
	0x0898,0x105D,0x15F6,0x1852,0x197B,0x1A8C,0x1B1B,0x1995,
	0x169D,0x14DF,0x15BF,0x1971,0x1E63,0x21BC,0x20F6,0x1B0F,
	0x10EA,0x0540,0xFB0C,0xF412,0xF0EC,0xF199,0xF3FC,0xF3CA,
	0xF277,0xF02B,0xEC97,0xE795,0xE203,0xDD69,0xDB01,0xDBC4,
	0xDF2B,0xE440,0xE918,0xECAA,0xEF9E,0xF2D5,0xF77B,0xFC1D,
	0xFF79,0x007E,0x00F9,0x020C,0x03B2,0x077D,0x0E02,0x141F,
	0x183E,0x1ADE,0x19CC,0x16A4,0x1255,0x0D9B,0x0927,0x06AA,
	0x05C2,0x06D4,0x080C,0x0805,0x0501,0xFF32,0xF84A,0xF1CF,
	0xECFB,0xEA96,0xEA2B,0xE93B,0xE8BE,0xE91C,0xE87C,0xE860,
	0xEA1F,0xEBA0,0xEC65,0xEC90,0xEC7B,0xED54,0xEF06,0xF10F,
	0xF42C,0xF764,0xFB0F,0x0003,0x0409,0x072A,0x0803,0x06E9,
	0x0538,0x0458,0x05C6,0x0820,0x0ABB,0x0C11,0x0C4B,0x0B3A,
	0x08CD,0x05D1,0x02A0,0xFF59,0xFCF5,0xFB51,0xF9E0,0xF852,
	0xF62A,0xF498,0xF262,0xF0AF,0xEFE3,0xEFFF,0xEFA8,0xEEE4,
	0xEDC7,0xEC35,0xEC08,0xECF9,0xEEC1,0xF210,0xF535,0xF79D,
	0xF8FF,0xF99F,0xFA1C,0xFAAB,0xFB76,0xFCB8,0xFF57,0x02A7,
	0x05ED,0x083A,0x0890,0x0822,0x065C,0x051F,0x05D6,0x06D2,
	0x0752,0x06DC,0x057F,0x0377,0x0117,0xFDB5,0xF656,0xED22,
	0xE03C,0xCA4C,0xBF03,0xBF82,0xBF23,0xBFFB,0xBF0C,0xCFB0,
	0xF30F,0x06F0,0x05F0,0xF205,0xD6EC,0xC3FD,0xC2E3,0xD647,
	0xF771,0x1D58,0x398F,0x3EE4,0x3E9E,0x3EF4,0x3F32,0x37A4,
	0x3032,0x2F4C,0x344F,0x3C7C,0x3F5E,0x3F03,0x3EF2,0x3F4A,
	0x3BFA,0x34EA,0x2C98,0x206B,0x0EC7,0xF9C1,0xE733,0xDC12,
	0xDC14,0xE463,0xEF93,0xF730,0xF67B,0xED13,0xDD48,0xCD01,
	0xC23C,0xC011,0xC233,0xCF9F,0xE2C5,0xF5D6,0x049A,0x0BCF,
	0x0B43,0x06C3,0x0276,0x024D,0x0809,0x1214,0x1C80,0x2371,
	0x28AE,0x2E63,0x3342,0x36D1,0x377E,0x33E5,0x2BDD,0x21C9,
	0x1817,0x10D7,0x0D71,0x0D06,0x0D18,0x0DA2,0x0D88,0x0A4A,
	0x0387,0xF958,0xEA66,0xDBD7,0xD2F1,0xD183,0xD614,0xDE9E,
	0xE768,0xEC72,0xEC31,0xE8DE,0xE55C,0xE3BC,0xE4AD,0xE7BF,
	0xECCF,0xF350,0xFAD8,0x0334,0x0BB0,0x121F,0x1667,0x189F,
	0x196D,0x1986,0x1920,0x1A04,0x184C,0x15E4,0x1693,0x1929,
	0x1C8D,0x1E7D,0x1DBA,0x1906,0x108B,0x067B,0xFDC5,0xF7C7,
	0xF51D,0xF509,0xF659,0xF6CC,0xF60A,0xF3A2,0xEFB5,0xEB17,
	0xE703,0xE454,0xE262,0xE2D8,0xE5AD,0xE9E0,0xEE41,0xF216,
	0xF631,0xF9A3,0xFC38,0xFEA6,0x00DF,0x02DD,0x0428,0x056D,
	0x08CF,0x0CE3,0x1116,0x14A4,0x1760,0x1870,0x1785,0x1542,
	0x1282,0x0FAE,0x0CD4,0x0AA3,0x0985,0x0958,0x093F,0x0777,
	0x0471,0x0087,0xFC95,0xF8B5,0xF4FA,0xF1DD,0xEF21,0xED51,
	0xECCC,0xEDCA,0xEFE4,0xF117,0xF16E,0xF093,0xEFA9,0xEF61,
	0xF033,0xF23B,0xF579,0xF89E,0xFB8F,0xFE87,0x02E4,0x05AA,
	0x0695,0x098E,0x096E,0x093B,0x09CB,0x0A4F,0x0B95,0x0CE6,
	0x0D82,0x0D1F,0x0C5C,0x0B3B,0x0A36,0x0949,0x07A0,0x048E,
	0x002C,0xFC76,0xFA55,0xF9A9,0xF91D,0xF8F0,0xF83C,0xF685,
	0xF3C6,0xF134,0xF060,0xF0D6,0xF0A0,0xF016,0xF049,0xF183,
	0xF3E1,0xF64E,0xF7BA,0xF8EC,0xF9A9,0xF9B4,0xFAB8,0xFD1A,
	0x0008,0x01AF,0x01C5,0x0265,0x038F,0x05B0,0x07EE,0x09BB,
	0x0A25,0x08E1,0x0725,0x056F,0x0458,0x03C2,0x0363,0x02C4,
	0x00E7,0xFCB9,0xF658,0xEE1E,0xE4E9,0xDC92,0xD571,0xD0C8,
	0xD3C3,0xDE21,0xEC77,0xF8E9,0xFDB2,0xFA34,0xF020,0xE527,
	0xDF9E,0xE2DB,0xEE05,0xFDB5,0x0C35,0x168C,0x1C9B,0x1E4E,
	0x1D30,0x1A06,0x17B1,0x15FC,0x1518,0x16D4,0x1B42,0x1ECF,
	0x2065,0x1FAC,0x1CE3,0x1A2E,0x1770,0x13D2,0x0ECD,0x0654,
	0xFC17,0xF3BA,0xEF75,0xF099,0xF51E,0xF950,0xFB5D,0xF8A0,
	0xF217,0xEADB,0xE481,0xE01A,0xE057,0xE371,0xE912,0xF0CB,
	0xF8A4,0xFDE4,0x0014,0xFF1A,0xFCB8,0xFB35,0xFC73,0xFFF5,
	0x0541,0x096C,0x0CC0,0x0FBD,0x11DF,0x1366,0x14A5,0x1498,
	0x12E8,0x0F74,0x0B41,0x077F,0x04B0,0x03F2,0x04E1,0x05C4,
	0x0576,0x03F3,0x009E,0xFC8B,0xF6C4,0xF084,0xEB7C,0xE97F,
	0xEAC9,0xEE09,0xF101,0xF2A6,0xF2AE,0xF0DF,0xEE8C,0xED31,
	0xED8F,0xEF36,0xF16F,0xF3E8,0xF728,0xFA78,0xFDC2,0x0061,
	0x02B6,0x04DB,0x066A,0x075E,0x0752,0x06D1,0x066F,0x0601,
	0x06EC,0x08ED,0x0BB2,0x0DD5,0x0D7F,0x0B34,0x06A0,0x01DD,
	0xFE18,0xFBE3,0xFB50,0xFC6B,0xFCF7,0xFC5B,0xFAD0,0xFAAF,
	0xF623,0xF357,0xF24D,0xF15B,0xF163,0xF127,0xF17B,0xF2D8,
	0xF528,0xF701,0xF7C6,0xF7F8,0xF93D,0xFAAE,0xFB75,0xFBC1,
	0xFBCE,0xFBCF,0xFC02,0xFC7D,0xFDCC,0xFF01,0xFEA3,0xFE7B,
	0xFE06,0xFD67,0xFCED,0xFCE9,0xFCEF,0xFCA8,0xFD0A,0xFDB6,
	0xFDC2,0xFD48,0xFD29,0xFB85,0xF98F,0xF758,0xF5DD,0xF486,
	0xF40B,0xF3D8,0xF304,0xF223,0xF13C,0xF08A,0xEFF7,0xEF30,
	0xEE9D,0xEE05,0xED43,0xEC8C,0xEC2A,0xEB7A,0xEB0C,0xEB05,
	0xEAC4,0xEAA2,0xEA58,0xE9F8,0xE9D9,0xE95E,0xE860,0xE649,
	0xE5D9,0xE671,0xE6E1,0xE726,0xE673,0xE682,0xE60C,0xE5C0,
	0xE57E,0xE558,0xE5BF,0xE600,0xE5B6,0xE552,0xE58B,0xE587,
	0xE5B0,0xE627,0xE5B1,0xE5AF,0xE644,0xE623,0xE640,0xE700,
	0xE7A8,0xE815,0xE84B,0xE8B6,0xE8D5,0xE9A7,0xEA52,0xEADC,
	0xEB41,0xEB2B,0xEBC4,0xECA4,0xED56,0xEE1C,0xEEBF,0xEEF7,
	0xEF40,0xEF69,0xF109,0xF1AC,0xF0C3,0xF0E9,0xF16C,0xF1F4,
	0xF2ED,0xF369,0xF3A3,0xF413,0xF448,0xF4F9,0xF627,0xF6E9,
	0xF7C0,0xF89B,0xF8E2,0xF91B,0xF901,0xF8F2,0xF99A,0xFA13,
	0xFA8D,0xFB06,0xFB55,0xFBA0,0xFBDC,0xFC67,0xFD0A,0xFD6C,
	0xFDC9,0xFDFF,0xFE63,0xFF3E,0xFF7C,0xFF87,0x0013,0x0067,
	0x00D6,0x016D,0x0225,0x026C,0x02AB,0x02D7,0x0339,0x03AD,
	0x0410,0x0455,0x04B4,0x04E8,0x04F8,0x04EE,0x0536,0x055B,
	0x0561,0x059E,0x05D9,0x0620,0x062E,0x0659,0x0640,0x0652,
	0x0675,0x06ED,0x0787,0x0808,0x0841,0x0862,0x087A,0x08A5,
	0x08FA,0x08ED,0x0987,0x09DD,0x0987,0x09BE,0x0B11,0x0997,
	0x0AA6,0x0C10,0x0B3C,0x0B6C,0x0BDA,0x0C18,0x0C12,0x0C00,
	0x0BAA,0x0BA1,0x0B93,0x0C31,0x0C95,0x0C65,0x0C4C,0x0BD0,
	0x0BA3,0x0C13,0x0C26,0x0C4B,0x0C7B,0x0CC4,0x0C62,0x0C4D,
	0x0C9A,0x0CC4,0x0D96,0x0CFC,0x0CEE,0x0D10,0x0D16,0x0CCF,
	0x0C9A,0x0D3E,0x0D84,0x0D4C,0x0D30,0x0D5D,0x0D98,0x0DAA,
	0x0E09,0x0E42,0x0DE8,0x0D7C,0x0E17,0x0E40,0x0E43,0x0E3F,
	0x0DF0,0x0E1C,0x0E17,0x0E39,0x0E1C,0x0E08,0x0DC7,0x0D7B,
	0x0D84,0x0DB0,0x0DB3,0x0E1A,0x0EB4,0x10BB,0x102B,0x0F59,
	0x0F39,0x0EF2,0x0EC2,0x0EB7,0x0EE9,0x0EFD,0x0EFA,0x0E9E,
	0x0E63,0x0E41,0x0DE9,0x0DFB,0x0E23,0x0E52,0x0E41,0x0D8F,
	0x0CB7,0x0D18,0x0DBF,0x0D58,0x0C79,0x0C9F,0x0CC3,0x0C0D,
	0x0C29,0x0BFF,0x0BA4,0x0B85,0x0B4B,0x0B18,0x0B04,0x0AAC,
	0x0AE9,0x0AE9,0x0A43,0x09B2,0x09E6,0x09CB,0x097C,0x0937,
	0x09C9,0x099A,0x0830,0x08D7,0x096A,0x0991,0x09A8,0x096F,
	0x0949,0x092A,0x095A,0x092A,0x08B6,0x0853,0x0818,0x07C6,
	0x0746,0x0694,0x0669,0x0663,0x061B,0x066A,0x05F1,0x05FC,
	0x05FE,0x05FA,0x05D8,0x05B4,0x0599,0x057F,0x05BD,0x0605,
	0x06A4,0x06BF,0x064A,0x0603,0x0609,0x05DA,0x05B1,0x05B6,
	0x057A,0x0596,0x054C,0x0505,0x0534,0x0519,0x050A,0x0540,
	0x0519,0x04B3,0x0463,0x048D,0x0475,0x0450,0x0462,0x047D,
	0x0494,0x048E,0x04DC,0x04BC,0x04D5,0x04C7,0x0446,0x045F,
	0x0471,0x03FC,0x03FA,0x03AE,0x03DC,0x0434,0x03FD,0x03D3,
	0x0467,0x042B,0x044D,0x041E,0x0423,0x0369,0x04CA,0x04F7,
	0x038F,0x04CE,0x0458,0x042D,0x03B6,0x03B9,0x039C,0x03A8,
	0x03B1,0x0372,0x0378,0x03A1,0x03BD,0x03AE,0x03DD,0x03B6,
	0x03C5,0x036A,0x03AF,0x03D5,0x03FF,0x03AE,0x0395,0x039B,
	0x0335,0x0337,0x02F4,0x0332,0x0306,0x02FA,0x02FF,0x02FD,
	0x0306,0x030E,0x0333,0x033D,0x032D,0x02DA,0x02C1,0x02DC,
	0x0324,0x02CF,0x030E,0x033E,0x031E,0x0322,0x02C5,0x02C4,
	0x02A1,0x02A7,0x02CA,0x030B,0x0302,0x02F6,0x0300,0x02F6,
	0x02D4,0x02C7,0x02DF,0x0311,0x02F5,0x027F,0x00E4,0xFF3C,
	0xFFD3,0x0017,0x006E,0x0084,0x0091,0x00C7,0x00E9,0x00F9,
	0x010E,0x010B,0x01B8,0x0259,0x01AB,0x0193,0x0171,0x0156,
	0x0139,0x0138,0x01C2,0x0172,0x00E4,0x00F9,0x01B5,0x01EF,
	0x01E0,0x015C,0x0157,0x016B,0x01E6,0x028C,0x038E,0x048A,
	0x0517,0x058F,0x0612,0x0732,0x0809,0x085B,0x0861,0x08C4,
	0x08E1,0x08D6,0x08B3,0x08D2,0x08DF,0x085C,0x0864,0x0904,
	0x096D,0x0978,0x0943,0x0893,0x083E,0x07EF,0x083D,0x09A8,
	0x0AAC,0x0B7C,0x0C3E,0x0CDB,0x0D90,0x0DE9,0x0DC3,0x0D88,
	0x0DEC,0x0F1A,0x0FFC,0x10C8,0x11AF,0x11AF,0x1220,0x1396,
	0x1494,0x132A,0x140E,0x14CE,0x13A9,0x1403,0x1524,0x16B0,
	0x1773,0x16B0,0x15FA,0x15FE,0x1710,0x1887,0x18C8,0x17C6,
	0x1626,0x139E,0x10DC,0x0D8A,0x0913,0x03B1,0xFD63,0xF72E,
	0xF55F,0xFABF,0x0636,0x13E2,0x1DF9,0x21B5,0x1F1A,0x1933,
	0x13C8,0x11A3,0x146D,0x19BE,0x1F76,0x2536,0x2A7F,0x2E16,
	0x2F45,0x2D84,0x2AFF,0x27B8,0x22EC,0x1E0C,0x1923,0x1397,
	0x0DDE,0x0A39,0x09D7,0x0C67,0x0FE1,0x11B8,0x0F7C,0x09AE,
	0x01E9,0xFA85,0xF604,0xF5E7,0xF912,0xFDC0,0x034D,0x09D1,
	0x0CBA,0x0E8B,0x0F5A,0x0F4B,0x0EBA,0x0E65,0x0E3B,0x0DF7,
	0x0E4C,0x0F89,0x1101,0x1282,0x13C2,0x151C,0x1609,0x151F,
	0x10E9,0x09FE,0x025E,0xFD7E,0xFB1A,0xF98D,0xFA3C,0xFBE1,
	0xFB35,0xF8F2,0xF755,0xF5D2,0xF412,0xF1B9,0xEFF5,0xEECF,
	0xEE8A,0xEFD3,0xF27A,0xF4FB,0xF758,0xF933,0xFB7A,0xFEE1,
	0x0130,0x00E5,0xFEDF,0xFC35,0xF991,0xFA00,0xFC86,0xFF0B,
	0x00DD,0x019E,0x0009,0xFD93,0xFABC,0xF7C7,0xF43E,0xF03F,
	0xED32,0xECC6,0xEC59,0xEB5A,0xEAF0,0xEA31,0xEA13,0xEA00,
	0xE9BD,0xE997,0xE9B5,0xE965,0xE89D,0xE835,0xE83F,0xEA7F,
	0xEE56,0xF209,0xF525,0xF645,0xF641,0xF5EC,0xF4A0,0xF422,
	0xF423,0xF3D2,0xF420,0xF411,0xF4DA,0xF5FB,0xF542,0xF309,
	0xF0E8,0xEF82,0xEE42,0xED84,0xEC80,0xEAF2,0xE9B7,0xE841,
	0xE7AA,0xE87B,0xEA2E,0xEB72,0xEB07,0xE9CB,0xE954,0xE944,
	0xE962,0xE9E2,0xEB3F,0xECAD,0xEE5A,0xEF88,0xF109,0xF388,
	0xF431,0xF448,0xF3BA,0xF2A4,0xF286,0xF303,0xF2D2,0xF157,
	0xF253,0xF21A,0xF182,0xF382,0xF318,0xF192,0xEF2D,0xECF7,
	0xEB9A,0xEBD2,0xEBEC,0xEC43,0xEC71,0xECA9,0xECC9,0xEDAB,
	0xEF0C,0xF033,0xF05F,0xEFF6,0xEFE1,0xEFD7,0xF0CF,0xF1B9,
	0xF272,0xF310,0xF46A,0xF690,0xF877,0xF8EE,0xF848,0xF738,
	0xF5D5,0xF502,0xF4DE,0xF5A5,0xF663,0xF6A9,0xF5CF,0xF4E0,
	0xF441,0xF426,0xF412,0xF398,0xF24D,0xF19A,0xF17D,0xF16C,
	0xF203,0xF1C0,0xF112,0xF148,0xF22C,0xF379,0xF55C,0xF681,
	0xF617,0xF50B,0xF413,0xF4CD,0xF6AE,0xF866,0xF921,0xF96F,
	0xF7A6,0xF5F4,0xF6CA,0xF734,0xF7F3,0xF78E,0xF6ED,0xF670,
	0xF605,0xF613,0xF5C5,0xF46B,0xF13A,0xEAFB,0xE1A6,0xD3A3,
	0xC309,0xBF0C,0xBF9D,0xBF24,0xC01D,0xBEF0,0xCBAE,0xF517,
	0x12B6,0x1C1C,0x1269,0xFF9F,0xF0A1,0xED86,0xF95F,0x0E9F,
	0x2531,0x38A7,0x3FDE,0x3F78,0x3FDA,0x3FCF,0x3F6D,0x3F15,
	0x3265,0x2137,0x0F9F,0xFEFF,0xF2FD,0xEB96,0xED07,0xF541,
	0xFEA7,0x022A,0xFAB4,0xE7E7,0xCE72,0xC090,0xC10E,0xC0A8,
	0xC3CF,0xD5FC,0xE7A9,0xF537,0xFE58,0x04E0,0x0A1D,0x0E18,
	0x108B,0x117A,0x1158,0x1341,0x16C4,0x1B66,0x219E,0x29B3,
	0x3237,0x380E,0x38BE,0x316F,0x221A,0x0D10,0xF915,0xEB8C,
	0xE7CE,0xEA68,0xEF05,0xF11F,0xEFD9,0xEB27,0xE474,0xDDE7,
	0xD8DD,0xD4AC,0xD21F,0xD1FF,0xD50C,0xDADE,0xE2D6,0xEC04,
	0xF60E,0x00D7,0x0B2E,0x128B,0x15ED,0x14A0,0x0FEC,0x0BA9,
	0x0AAD,0x0EE3,0x1650,0x1DD4,0x21F7,0x219D,0x1C54,0x147C,
	0x0BD3,0x038E,0xFB2B,0xF3B9,0xED8E,0xE8C7,0xE596,0xE579,
	0xE526,0xE460,0xE71D,0xE698,0xE5F7,0xE582,0xE387,0xE111,
	0xE007,0xE227,0xE80C,0xF117,0xFC52,0x060B,0x0C4C,0x0EE8,
	0x0EEF,0x0E90,0x0E75,0x0D64,0x0CC2,0x0D3F,0x0E91,0x0FC3,
	0x1010,0x0EFB,0x0D14,0x0A50,0x0644,0x01CD,0xFCC8,0xF5FE,
	0xEE2C,0xE7B6,0xE4E0,0xE54B,0xE7F0,0xEB04,0xEDB6,0xEF19,
	0xEE5A,0xEC51,0xEB34,0xEB69,0xECD0,0xEFA9,0xF456,0xF9D0,
	0xFF32,0x0411,0x07CF,0x0ACD,0x0CE0,0x0E66,0x0EBC,0x0D83,
	0x0BC3,0x0974,0x0796,0x0702,0x07D5,0x0844,0x092B,0x0813,
	0x049F,0x00B9,0xFC27,0xF779,0xF336,0xEFCB,0xEE41,0xEE23,
	0xEF3D,0xF15C,0xF387,0xF40B,0xF4A7,0xF5BC,0xF705,0xF813,
	0xF915,0xF9E4,0xFBBA,0xFFB8,0x0373,0x066E,0x0A1F,0x0D03,
	0x0DB7,0x0D98,0x0D74,0x0C4B,0x0B58,0x0A19,0x07DC,0x05D8,
	0x04AD,0x044C,0x03C7,0x027F,0x00F8,0xFE93,0xFB9F,0xF90E,
	0xF6B8,0xF547,0xF3C4,0xF210,0xF183,0xF3C7,0xF67F,0xF86C,
	0xFA8F,0xFC04,0xFCE7,0xFD27,0xFDBD,0xFEF7,0x0049,0x019C,
	0x02FC,0x0541,0x0689,0x07DE,0x0900,0x09D4,0x0A4F,0x09C3,
	0x0849,0x0673,0x04CC,0x02E1,0x011C,0xFFD0,0xFF18,0xFD52,
	0xF85B,0xEE21,0xDDF5,0xC785,0xBE04,0xBE9E,0xBE29,0xBE44,
	0xC029,0xBDF0,0xCF3A,0x052C,0x26D4,0x2DC1,0x1DAA,0x03F1,
	0xF24F,0xF3FA,0x0816,0x26E3,0x3C95,0x3DF8,0x3E42,0x3E54,
	0x3E73,0x3E7E,0x3E3F,0x3DD0,0x3E34,0x30F6,0x17B2,0x0357,
	0xF46C,0xEDCA,0xF043,0xFABB,0x0603,0x077C,0xFA50,0xDD97,
	0xC249,0xBEF8,0xBF87,0xBF52,0xBF5A,0xD0B7,0xE8AF,0xF8F5,
	0x07DE,0x101E,0x16D0,0x1B7F,0x1D34,0x1EC9,0x219B,0x24FC,
	0x29BB,0x3052,0x3967,0x3F31,0x3EFF,0x3F39,0x3E88,0x3F36,
	0x323B,0x1576,0xFC8F,0xEC99,0xE737,0xE933,0xEDE2,0xF091,
	0xEFFE,0xEB42,0xE293,0xD83D,0xCF50,0xC907,0xC61E,0xC76B,
	0xCD54,0xD703,0xE2F2,0xF038,0xFE91,0x0D4F,0x1A07,0x22DD,
	0x2663,0x245D,0x1E2B,0x1912,0x1914,0x1EC7,0x28D0,0x321A,
	0x36E5,0x3591,0x2F6A,0x256B,0x186C,0x0ACE,0xFDCE,0xF251,
	0xE9AB,0xE53D,0xE419,0xE3D8,0xE33E,0xE234,0xE125,0xE02C,
	0xDDCE,0xDC65,0xDA41,0xD8BD,0xD91A,0xDD86,0xE6DB,0xF3AC,
	0x0184,0x0E19,0x168A,0x1A76,0x1B57,0x1A6E,0x18CF,0x170B,
	0x1615,0x1722,0x18BA,0x19D2,0x1B12,0x1AA8,0x1767,0x1214,
	0x0B20,0x022C,0xF90A,0xF11F,0xE9C0,0xE3B7,0xE0CA,0xE0AB,
	0xE27B,0xE4E7,0xE718,0xE8BF,0xE99E,0xE8EF,0xE821,0xE7CC,
	0xE993,0xED1E,0xF339,0xFC3E,0x0473,0x0C46,0x1176,0x13F5,
	0x14F1,0x1577,0x1686,0x16BD,0x153C,0x129C,0x0F90,0x0D78,
	0x0D8F,0x0DCA,0x0DBF,0x0B82,0x06AA,0x0035,0xF8B0,0xF250,
	0xEE03,0xEA90,0xE842,0xE77C,0xE8BF,0xEB5F,0xEE52,0xF0A7,
	0xF1A3,0xF20B,0xF28A,0xF438,0xF784,0xFB1C,0xFDAC,0xFF80,
	0x0313,0x0823,0x0DAB,0x1244,0x158A,0x1695,0x14A2,0x1146,
	0x0E46,0x0C74,0x0B25,0x098A,0x081E,0x06CF,0x0626,0x0477,
	0x014E,0xFDAA,0xF9B5,0xF61E,0xF2B7,0xF026,0xEE7E,0xEDD7,
	0xEE19,0xEF0B,0xF103,0xF469,0xF780,0xF91C,0xFA30,0xFBC2,
	0xFE36,0xFF9A,0x006F,0x01F2,0x0465,0x083D,0x0CD0,0x1099,
	0x1037,0x112D,0x101C,0x0C97,0x0AE5,0x09F6,0x0864,0x0629,
	0x02B6,0x00BF,0xFDE4,0xF7B7,0xEC08,0xD859,0xC354,0xBF4B,
	0xBF8B,0xBF3F,0xBF6B,0xC142,0xBF4F,0xD8F4,0x0D71,0x2841,
	0x2882,0x1478,0xFC8A,0xF0D8,0xF854,0x0E76,0x2DE9,0x3EDA,
	0x3ECE,0x3F39,0x3F45,0x3F4E,0x3F51,0x3F23,0x3E96,0x3E63,
	0x2ED4,0x1587,0x0019,0xF103,0xED2A,0xF408,0xFFD7,0x07A4,
	0x041B,0xF13B,0xD0EE,0xBED9,0xBFB9,0xBF61,0xBFCF,0xBFB0,
	0xD193,0xE991,0xFA97,0x06EE,0x0FF8,0x16CB,0x1C9F,0x1EAA,
	0x20CE,0x24B9,0x29D0,0x2ED1,0x3560,0x3DBA,0x4011,0x3FD7,
	0x3FAE,0x3F3D,0x3EBC,0x2CFC,0x107E,0xFA29,0xED2D,0xE915,
	0xEAE4,0xEE3E,0xF0DD,0xEEF2,0xE764,0xDDA3,0xD450,0xCB41,
	0xC534,0xC365,0xC69D,0xCD53,0xD6DD,0xE2BD,0xF0C1,0x003D,
	0x0EFC,0x1B30,0x21E9,0x22A4,0x1F61,0x1B0E,0x1858,0x198F,
	0x1FB8,0x29E1,0x31C6,0x34F6,0x3446,0x2D4F,0x212A,0x12F6,
	0x04A9,0xF810,0xEF1F,0xE8C7,0xE43F,0xE169,0xDFC2,0xDE7D,
	0xDD61,0xDC65,0xDBCE,0xDB9D,0xDA30,0xD7FC,0xD65B,0xD728,
	0xDC95,0xE725,0xF4F0,0x02E7,0x0E50,0x1623,0x191C,0x18DC,
	0x17A6,0x1650,0x15BA,0x15E4,0x16B3,0x18E7,0x1B45,0x1BB2,
	0x19E1,0x14EA,0x0EA8,0x0787,0xFF3D,0xF739,0xEF1D,0xE7AD,
	0xE188,0xDE30,0xDDFA,0xE14D,0xE510,0xE740,0xE75E,0xE682,
	0xE55C,0xE4BA,0xE54A,0xE7EC,0xED1C,0xF3FA,0xFB83,0x0389,
	0x0B00,0x106E,0x1325,0x1478,0x149A,0x14BF,0x1478,0x12FF,
	0x118A,0x1022,0x0E2D,0x0CC2,0x0B9D,0x0A5F,0x0761,0x04D3,
	0xFF09,0xF646,0xF006,0xEA3C,0xE6E9,0xE62A,0xE72D,0xE8CF,
	0xEAB7,0xEC4A,0xED83,0xEE0C,0xEF15,0xF13B,0xF386,0xF668,
	0xF93B,0xFD4C,0x0164,0x058B,0x0931,0x0D87,0x115C,0x13B9,
	0x1456,0x137D,0x117E,0x0EE0,0x0C03,0x09C6,0x089F,0x07ED,
	0x06E9,0x04C2,0x01AB,0xFDFD,0xFA28,0xF69A,0xF3B6,0xF1CC,
	0xEF98,0xEDC6,0xEC42,0xEBE5,0xECE3,0xEF4A,0xF292,0xF5E5,
	0xF889,0xF975,0xFA30,0xFC4F,0xFE57,0x00C9,0x02F8,0x05E6,
	0x0996,0x0D39,0x0EFA,0x0EFC,0x0E91,0x0D8E,0x0B95,0x083E,
	0x0649,0x05D9,0x045F,0x01C5,0xFE75,0xFBE1,0xF830,0xF0AA,
	0xE394,0xCDF6,0xBF11,0xBF3E,0xBED9,0xBED4,0xBF73,0xC0C0,
	0xC033,0xE9C9,0x1A1A,0x2C9D,0x2617,0x0E1B,0xF67F,0xEFE2,
	0xFD97,0x19C0,0x3833,0x3FCB,0x3F3E,0x3FB8,0x3FD1,0x3FB3,
	0x3FC2,0x3F9A,0x3F79,0x3D76,0x2880,0x0EF7,0xFB07,0xEE98,
	0xEE17,0xF7AC,0x0557,0x0D3E,0x047C,0xEB1B,0xCA78,0xBF93,
	0xC099,0xC083,0xC05D,0xC515,0xDC3B,0xF0CC,0xFFE5,0x0B7F,
	0x13F1,0x1A2B,0x1E32,0x206F,0x22AB,0x25A0,0x2A38,0x2F5E,
	0x36B8,0x3F21,0x40C4,0x40AC,0x4046,0x4074,0x3C95,0x2337,
	0x065B,0xF1A3,0xE7EA,0xE845,0xEC5D,0xEF09,0xEDF1,0xE961,
	0xE210,0xD909,0xCF89,0xC8B4,0xC50C,0xC4BD,0xC79E,0xCE78,
	0xD95B,0xE6EF,0xF51F,0x0467,0x1316,0x1EBF,0x24E4,0x2477,
	0x1F05,0x198F,0x17EF,0x1B41,0x22DF,0x2C85,0x344E,0x3673,
	0x32B3,0x295D,0x1CE1,0x0EE2,0x0112,0xF58D,0xED14,0xE6E2,
	0xE268,0xDEEF,0xDDBE,0xDE8D,0xDF82,0xDFC8,0xE01A,0xDD7E,
	0xD9F5,0xD957,0xD6D2,0xD8FB,0xE1AC,0xEE26,0xFB55,0x0883,
	0x139C,0x1A23,0x1C7E,0x1B94,0x19FB,0x18B7,0x1810,0x1862,
	0x197F,0x1B41,0x1C95,0x1C11,0x192C,0x14A1,0x0EA0,0x079F,
	0xFF66,0xF66A,0xED6B,0xE5D3,0xE0D6,0xDEE3,0xDF37,0xE22A,
	0xE5A3,0xE7E0,0xE7FA,0xE6A0,0xE5FE,0xE652,0xE7D7,0xEAFB,
	0xF028,0xF6F7,0xFEF8,0x06A7,0x0D65,0x1282,0x1554,0x164F,
	0x1697,0x1622,0x14CC,0x12F1,0x10B3,0x0E21,0x0CB1,0x0BC8,
	0x0B08,0x0952,0x064E,0x017D,0xFB9A,0xF6E4,0xF18C,0xEBB5,
	0xE8DE,0xE782,0xE7A2,0xE8FA,0xEB39,0xED72,0xEEF6,0xF083,
	0xF17E,0xF28F,0xF448,0xF6D5,0xFA8B,0xFF11,0x03A3,0x07B2,
	0x0AFF,0x0E66,0x1293,0x14B5,0x145E,0x12A5,0x109D,0x0D5F,
	0x0B04,0x093B,0x07F8,0x06CA,0x051E,0x02F0,0x0006,0xFCCC,
	0xF980,0xF547,0xF153,0xEE36,0xEC2B,0xEBC4,0xECA7,0xEE14,
	0xF02A,0xF22B,0xF30A,0xF3D0,0xF73D,0xFA06,0xFBB7,0xFCFC,
	0xFECA,0x0243,0x05ED,0x08D9,0x0B48,0x0CDB,0x0DDD,0x0DD1,
	0x0CE5,0x0C04,0x0B8D,0x09CC,0x0788,0x0578,0x0332,0x011E,
	0xFF5F,0xFD11,0xF81B,0xEDCE,0xDDCC,0xC6C1,0xBD9A,0xBEA7,
	0xBE17,0xBE2F,0xBF27,0xBF37,0xC58E,0xF65D,0x2059,0x2C06,
	0x1F75,0x0652,0xF226,0xEF9E,0x0109,0x206D,0x3B4B,0x3E25,
	0x3E00,0x3E4F,0x3E8B,0x3E89,0x3E6F,0x3DC1,0x3E69,0x36BE,
	0x1DFD,0x06D1,0xF535,0xEBA6,0xEC40,0xF61C,0x0213,0x0681,
	0xFB70,0xDF69,0xC299,0xBE86,0xBF0D,0xBF74,0xBEAC,0xC687,
	0xDF68,0xF2BF,0x0089,0x0A4B,0x117C,0x15E6,0x1987,0x1E59,
	0x1F9A,0x2367,0x283A,0x2DC0,0x3633,0x3E63,0x3F13,0x3EF9,
	0x3EB0,0x3F29,0x35C7,0x19FF,0xFFE3,0xED11,0xE4ED,0xE568,
	0xEAAC,0xEE79,0xEDDE,0xE893,0xDFDC,0xD5E0,0xCC14,0xC50A,
	0xC154,0xC2CF,0xC817,0xD0CF,0xDC37,0xE9A7,0xF837,0x0748,
	0x1542,0x1FDA,0x24F3,0x2395,0x1E03,0x18A7,0x1809,0x1D4F,
	0x25DD,0x2EAB,0x345B,0x3529,0x309D,0x2707,0x1A02,0x0BB7,
	0xFD53,0xF16C,0xE8C7,0xE3B4,0xE1D4,0xE1A6,0xE070,0xDEB4,
	0xDDA0,0xDD9C,0xDCD2,0xDB65,0xD93E,0xD70C,0xD678,0xD7AC,
	0xE046,0xEDE8,0xFCAF,0x09D1,0x12B5,0x177A,0x1962,0x18FA,
	0x1799,0x1662,0x1611,0x16DF,0x180D,0x19AB,0x1AF4,0x1A6F,
	0x186F,0x12F5,0x0A4A,0x0267,0xFAAE,0xF243,0xEA40,0xE370,
	0xDF00,0xDDAA,0xDF3E,0xE1B4,0xE486,0xE68E,0xE73C,0xE657,
	0xE48A,0xE485,0xE6EB,0xEBBE,0xF233,0xF9EC,0x017B,0x08CB,
	0x0EEC,0x1396,0x1741,0x18BC,0x1758,0x1591,0x13C3,0x119D,
	0x0FAC,0x0EC5,0x0E70,0x0DC9,0x0C2E,0x09B4,0x0619,0x013B,
	0xFB2C,0xF47C,0xEE3C,0xE90D,0xE6A0,0xE650,0xE799,0xE9E5,
	0xEC1C,0xED57,0xEE72,0xEFE4,0xF173,0xF3DF,0xF656,0xF8E8,
	0xFC44,0xFFB6,0x03D7,0x096B,0x0ED4,0x12F9,0x14D0,0x14FA,
	0x1398,0x1199,0x0F75,0x0D5A,0x0BC6,0x0A3C,0x08CF,0x06CB,
	0x0524,0x033E,0x018B,0xFE47,0xF9A0,0xF50E,0xF124,0xEEC3,
	0xEDAD,0xED0F,0xED86,0xEEEE,0xF0A8,0xF308,0xF5EB,0xF812,
	0xFA1A,0xFBAE,0xFD33,0xFE9B,0x000D,0x0248,0x0571,0x08C3,
	0x0BAB,0x0EB8,0x106F,0x1037,0x0EAB,0x0D16,0x0BF0,0x0862,
	0x07CD,0x06DA,0x0408,0x0289,0xFFEE,0xF918,0xED51,0xDB6D,
	0xC524,0xBF26,0xBFD5,0xBF69,0xBF8B,0xC0F5,0xBF2A,0xCF0E,
	0x0499,0x25B6,0x2A67,0x18C8,0x0026,0xF0BC,0xF3DF,0x077C,
	0x269A,0x3DA0,0x3F08,0x3F49,0x3F68,0x3F5B,0x3F59,0x3F30,
	0x3EA2,0x3F48,0x331D,0x1993,0x0388,0xF2E0,0xEC9F,0xF249,
	0xFE5B,0x07E7,0x0795,0xF74F,0xD816,0xC0F0,0xBFBE,0xBF82,
	0xC008,0xBF3F,0xCB43,0xE42B,0xF654,0x0483,0x0E99,0x1471,
	0x187B,0x1B5F,0x1E0A,0x2179,0x26AE,0x2DBE,0x33B3,0x3C18,
	0x4055,0x4011,0x3FE1,0x3F24,0x4010,0x32B5,0x14C0,0xFBFB,
	0xEC34,0xE679,0xE8A5,0xEDB9,0xF047,0xEDF1,0xE6B6,0xDD4E,
	0xD30D,0xCA96,0xC4BE,0xC145,0xC292,0xC94E,0xD241,0xDD22,
	0xEABA,0xFABC,0x0ACC,0x1821,0x20CF,0x234C,0x1FE1,0x196F,
	0x14E2,0x158F,0x1C98,0x26E2,0x306C,0x3544,0x3476,0x2D4E,
	0x2157,0x12D4,0x040F,0xF8C0,0xF034,0xE8A4,0xE321,0xE000,
	0xDE7C,0xDD74,0xDCCF,0xDD75,0xDE2B,0xDD13,0xD993,0xD5D0,
	0xD387,0xD4BC,0xDA24,0xE41D,0xF1DB,0x0061,0x0C25,0x1409,
	0x1754,0x17CD,0x16C6,0x1540,0x1451,0x151B,0x16F8,0x1898,
	0x19AE,0x18BE,0x1656,0x1388,0x0FE0,0x0A35,0x0259,0xF87E,
	0xEE4F,0xE554,0xDF12,0xDC11,0xDCBB,0xDF20,0xE15A,0xE379,
	0xE3E3,0xE370,0xE272,0xE1A9,0xE24D,0xE564,0xEB1F,0xF1FF,
	0xF8A5,0xFF52,0x05E3,0x0BDF,0x10BB,0x13C1,0x14A8,0x142F,
	0x127B,0x1007,0x0E4E,0x0C4F,0x0AEA,0x09D6,0x097D,0x0937,
	0x077B,0x02A7,0xFC52,0xF59C,0xEF84,0xE901,0xE6D8,0xE580,
	0xE40A,0xE618,0xE72F,0xE89C,0xEAE3,0xED67,0xEEAE,0xF02E,
	0xF1D6,0xF4ED,0xF840,0xFB6D,0xFE92,0x02C1,0x07BD,0x0C68,
	0x10C8,0x13AC,0x14E4,0x13FE,0x11BD,0x0EB9,0x0CDC,0x0BB9,
	0x0A12,0x0816,0x0691,0x0503,0x0272,0x001D,0xFCCB,0xF956,
	0xF5AE,0xF225,0xEF3B,0xED7C,0xED03,0xED61,0xEE91,0xF08B,
	0xF35F,0xF5AD,0xF744,0xF8D5,0xFAB5,0xFC9E,0xFEAF,0x0150,
	0x045B,0x06DD,0x089C,0x0A0D,0x0BFF,0x0DF1,0x0ED7,0x0ED2,
	0x0DA9,0x0B7E,0x08F1,0x06B1,0x04AB,0x0308,0xFFA7,0xFC04,
	0xF881,0xF163,0xE5FA,0xD24F,0xC058,0xBEF4,0xBEF1,0xBEC9,
	0xBEF9,0xC098,0xBFB1,0xDD10,0x0FE4,0x27C4,0x2580,0x1148,
	0xFAB6,0xEFB0,0xF8AB,0x1159,0x314A,0x3F9A,0x3EC5,0x3F9A,
	0x3FB7,0x3FA0,0x3FD9,0x3F51,0x3F4B,0x3E46,0x2C52,0x1376,
	0xFE30,0xF029,0xECA5,0xF3FE,0x0073,0x08C1,0x03F7,0xEF57,
	0xCEC6,0xBFE5,0xC175,0xC083,0xC06F,0xC1A2,0xD47B,0xEAB6,
	0xFB30,0x0820,0x1151,0x177C,0x1B9B,0x1EA5,0x2058,0x234E,
	0x282A,0x2E44,0x3585,0x3E14,0x40ED,0x4082,0x4080,0x4034,
	0x3EA3,0x2932,0x0C1A,0xF5A6,0xE91D,0xE707,0xEB3C,0xEF80,
	0xEFA2,0xEAA1,0xE27F,0xDA05,0xD154,0xC9A8,0xC431,0xC2AE,
	0xC530,0xCC09,0xD654,0xE395,0xF2C3,0x024F,0x107F,0x1C0D,
	0x2386,0x24EA,0x2035,0x19F0,0x176E,0x1A83,0x22AD,0x2CB7,
	0x34CC,0x37D1,0x3449,0x2B39,0x1F08,0x11C3,0x0465,0xF883,
	0xEECC,0xE7BD,0xE40A,0xE1B7,0xDFD0,0xDEBF,0xDDCA,0xDDEC,
	0xDDF0,0xDE02,0xDBFF,0xD93D,0xD747,0xD909,0xDF21,0xE9C2,
	0xFA49,0x07BE,0x11AB,0x1830,0x1A27,0x19BE,0x1809,0x16D8,
	0x173C,0x18A7,0x1A21,0x1B72,0x1BFB,0x1B71,0x195B,0x1541,
	0x0F41,0x07D4,0xFF84,0xF72E,0xEF24,0xE770,0xE16D,0xDE3C,
	0xDDA6,0xE032,0xE3BD,0xE6B8,0xE724,0xE5BD,0xE3F6,0xE35E,
	0xE571,0xE959,0xEED5,0xF5ED,0xFDFA,0x04D1,0x0AED,0x10B0,
	0x14DE,0x1693,0x1698,0x1532,0x1337,0x11CD,0x1054,0x0F1A,
	0x0DE0,0x0CE1,0x0C1D,0x0A93,0x06A4,0x01B4,0xFB61,0xF555,
	0xEF45,0xE970,0xE603,0xE5A4,0xE96D,0xEAE1,0xEB42,0xEC39,
	0xEDDF,0xEF86,0xF077,0xF204,0xF496,0xF74A,0xF9AC,0xFC78,
	0x0106,0x06B7,0x0C2A,0x1027,0x125C,0x1374,0x13D0,0x1246,
	0x1087,0x0F24,0x0D4E,0x0AE6,0x0923,0x07EA,0x05DB,0x044C,
	0x011C,0xFD89,0xF9F9,0xF5DB,0xF1D3,0xEF5B,0xED8C,0xEC76,
	0xEBFA,0xEC55,0xEDD1,0xF00C,0xF2A7,0xF51B,0xF753,0xF935,
	0xFA7E,0xFABA,0xFC61,0x0079,0x03BD,0x0681,0x0910,0x0BFB,
	0x0DE5,0x0E83,0x0E9F,0x0DB7,0x0BE9,0x09A1,0x0764,0x04F4,
	0x02A3,0x011B,0xFF76,0xFD76,0xFAB0,0xF574,0xED3F,0xE255,
	0xD5B3,0xC7D8,0xBEB5,0xBEC2,0xBE5E,0xC367,0xDC44,0xF64D,
	0x086C,0x0E77,0x09DF,0xFF9A,0xF820,0xF8AE,0x0183,0x0F1C,
	0x1C4B,0x277B,0x2FF0,0x36AA,0x3AA7,0x3B0E,0x3764,0x3039,
	0x2654,0x1AB3,0x0E82,0x0386,0xFB1A,0xF649,0xF650,0xFA71,
	0xFEB9,0xFF7D,0xF922,0xEC42,0xDD46,0xD07F,0xCAB8,0xCC8A,
	0xD412,0xDFB3,0xEB93,0xF506,0xFBE2,0x01D3,0x068E,0x09A0,
	0x0ACD,0x0B5A,0x0D82,0x104F,0x12DA,0x15D9,0x1BCF,0x1FB3,
	0x25BC,0x2989,0x293A,0x249D,0x1B15,0x0D84,0x0068,0xF7DC,
	0xF455,0xF487,0xF584,0xF659,0xF588,0xF3E2,0xEFE7,0xEAF8,
	0xE6AE,0xE2F9,0xE08C,0xE08C,0xE32A,0xE820,0xEE33,0xF48D,
	0xFAE9,0x01BF,0x0969,0x0EF4,0x10D3,0x0FB7,0x0D26,0x0AD0,
	0x0AAD,0x0DEB,0x12F4,0x17A8,0x19A5,0x18D9,0x1698,0x12CC,
	0x0D7A,0x06E4,0xFFEE,0xF945,0xF45E,0xF1DC,0xF06F,0xEFB8,
	0xEF3D,0xEE80,0xEDF3,0xED97,0xED52,0xED16,0xEC15,0xEB48,
	0xEB03,0xEC50,0xF0AD,0xF718,0xFE27,0x036B,0x0547,0x07A8,
	0x093D,0x0978,0x096A,0x0909,0x095A,0x0A17,0x0A6C,0x0ACE,
	0x0B27,0x0ADE,0x0983,0x0781,0x0448,0x00A7,0xFCCB,0xF8D6,
	0xF4BD,0xF062,0xEE45,0xEE31,0xEE8F,0xEF42,0xF17F,0xF33B,
	0xF3A0,0xF286,0xF10E,0xF0D6,0xF2FD,0xF5C3,0xF8F3,0xFC79,
	0xFFA5,0x02B0,0x05B5,0x07F8,0x0A34,0x0BAB,0x0BCE,0x0A8F,
	0x0948,0x09AB,0x09AB,0x0834,0x0705,0x060D,0x04FE,0x03DF,
	0x02C6,0x0150,0xFF14,0xFC52,0xF9D4,0xF76C,0xF5B4,0xF571,
	0xF5C4,0xF537,0xF461,0xF3AD,0xF2F3,0xF1D8,0xF116,0xF12D,
	0xF1AB,0xF1F5,0xF2B6,0xF391,0xF595,0xF827,0xF9F0,0xFB0A,
	0xFB8B,0xFBEC,0xFC90,0xFC83,0xFC00,0xFB4C,0xFAB4,0xFA02,
	0xF988,0xF8F3,0xF854,0xF79F,0xF67C,0xF553,0xF44F,0xF398,
	0xF2C5,0xF1F6,0xF12D,0xF03C,0xEFC4,0xEF2E,0xEEB9,0xEE26,
	0xED81,0xECF0,0xECEB,0xEC7E,0xEC28,0xEBF7,0xEBCC,0xEB98,
	0xEB2B,0xEB2C,0xEB7E,0xEB4D,0xEB3E,0xEB35,0xEAC3,0xE9F5,
	0xE9A0,0xE9B8,0xE9AF,0xE97F,0xE938,0xE97B,0xE794,0xE88A,
	0xE929,0xE7AD,0xE81D,0xE84F,0xE82A,0xE867,0xE898,0xE854,
	0xE880,0xE8B7,0xE93C,0xE972,0xE97F,0xE9DB,0xEA1C,0xEA3A,
	0xEAAA,0xEB2F,0xEBCA,0xEBF3,0xEC3B,0xECBC,0xED6B,0xEDAF,
	0xEE13,0xEE8D,0xEF28,0xEF63,0xEF7F,0xEFAC,0xF027,0xF07F,
	0xF08F,0xF0A2,0xF0EA,0xF155,0xF20D,0xF1DA,0xF233,0xF2B8,
	0xF37E,0xF39C,0xF3E7,0xF468,0xF4CA,0xF55C,0xF5A9,0xF648,
	0xF6B2,0xF73C,0xF7A5,0xF827,0xF850,0xF91B,0xF983,0xF9FA,
	0xFA87,0xFAF9,0xFB25,0xFC5B,0xFF2F,0xFEAC,0xFEFB,0xFF42,
	0xFF11,0xFF3A,0xFF97,0xFFB7,0x0006,0x005C,0x00B5,0x0101,
	0x010D,0x0153,0x0211,0x0211,0x0244,0x02D2,0x02AB,0x01EF,
	0x02DC,0x03EE,0x03A3,0x0354,0x0410,0x0412,0x03FC,0x048C,
	0x04E6,0x053E,0x0575,0x056B,0x05C7,0x05FB,0x067D,0x06EA,
	0x06F4,0x0746,0x0726,0x0789,0x07CC,0x07B5,0x07BC,0x0826,
	0x0812,0x06F7,0x07CB,0x08C6,0x0944,0x0957,0x0935,0x090F,
	0x0944,0x09C0,0x09DD,0x098E,0x0947,0x08EA,0x08DE,0x088F,
	0x0875,0x0948,0x0934,0x0901,0x08E3,0x090E,0x0929,0x0971,
	0x09EE,0x0A5C,0x0AA9,0x0AAF,0x0AD4,0x0AFA,0x0B1C,0x0AF5,
	0x0B2C,0x0B3D,0x0B3B,0x0B18,0x0B70,0x0BAB,0x0BA7,0x0BC4,
	0x0C08,0x0BF4,0x0B9E,0x0B94,0x0B30,0x0B48,0x0B47,0x0B7C,
	0x0BC2,0x0BF4,0x0B92,0x0BC3,0x0BA3,0x0BCD,0x0BA0,0x0B9C,
	0x0BD2,0x0BE0,0x0BAD,0x0BD7,0x0C67,0x0CC0,0x0C30,0x0C0D,
	0x0C3B,0x0C87,0x0C3A,0x0C5F,0x0C82,0x0C4B,0x0C88,0x0D12,
	0x0CDC,0x0D09,0x0D38,0x0D16,0x0C25,0x0D5A,0x0D48,0x0C01,
	0x0D09,0x0CE3,0x0CA0,0x0CC5,0x0CEF,0x0C82,0x0CA7,0x0CB6,
	0x0CB2,0x0C8A,0x0C31,0x0C44,0x0C27,0x0C50,0x0C25,0x0C41,
	0x0C71,0x0CE3,0x0C83,0x0C6C,0x0C41,0x0C53,0x0BD0,0x0B99,
	0x0B87,0x0B53,0x0B64,0x0BB4,0x0C20,0x0BFA,0x0BC7,0x0B42,
	0x0B3C,0x0B17,0x0B0B,0x0B00,0x0A95,0x0A2E,0x0A28,0x0A3A,
	0x09E5,0x0A2C,0x09E1,0x09DE,0x09F8,0x09C5,0x0981,0x099C,
	0x09FB,0x09C1,0x09BF,0x0979,0x0943,0x0952,0x0953,0x0957,
	0x0940,0x08DC,0x0895,0x088F,0x0870,0x06A6,0x0575,0x0614,
	0x05FA,0x0621,0x062C,0x0677,0x068F,0x066A,0x05E3,0x05F0,
	0x062E,0x0605,0x05F3,0x0664,0x0653,0x0624,0x0654,0x065C,
	0x05E4,0x05C6,0x0680,0x0723,0x06A7,0x0652,0x0673,0x06BA,
	0x06C4,0x06AE,0x0623,0x0670,0x06D9,0x06DB,0x06C3,0x06BB,
	0x06E7,0x0733,0x06D8,0x0660,0x05EC,0x0634,0x068B,0x062D,
	0x065E,0x078D,0x069C,0x05BA,0x058B,0x05B9,0x05A8,0x057D,
	0x054A,0x053B,0x05CA,0x064F,0x06B9,0x06B7,0x06DE,0x0745,
	0x06F3,0x0698,0x0626,0x059A,0x0559,0x04EB,0x051F,0x057C,
	0x058E,0x05A0,0x0549,0x04EB,0x04C3,0x0501,0x051E,0x050D,
	0x04B9,0x04B6,0x04A4,0x04BA,0x0491,0x04B3,0x043A,0x0415,
	0x0403,0x0426,0x0418,0x03FE,0x03CB,0x0342,0x033B,0x037F,
	0x0362,0x0346,0x02F4,0x0268,0x0244,0x01C5,0x01B2,0x0233,
	0x0231,0x01C4,0x0191,0x017D,0x01D4,0x019D,0x01CD,0x01F8,
	0x01B4,0x0175,0x0180,0x016C,0x0168,0x011A,0x0082,0xFF63,
	0xFFDD,0xFFD6,0xFF94,0xFF9D,0xFF6C,0xFF25,0xFF18,0xFF1A,
	0xFF4D,0xFF7D,0xFF53,0xFF2B,0xFEA2,0xFE69,0xFE44,0xFE4E,
	0xFE7D,0xFE95,0xFE67,0xFE4E,0xFDED,0xFC7C,0xFD63,0xFEB9,
	0xFEE3,0xFF09,0xFF14,0xFE9B,0xFE89,0xFE31,0xFDE3,0xFDC1,
	0xFD59,0xFD4C,0xFD48,0xFCB3,0xFC5D,0xFC71,0xFC21,0xFC52,
	0xFC4A,0xFC51,0xFC7A,0xFC57,0xFC1B,0xFC0F,0xFBDD,0xFBDB,
	0xFC69,0xFCC1,0xFCE7,0xFCE5,0xFCF2,0xFCBA,0xFC77,0xFCCF,
	0xFD2F,0xFD64,0xFD54,0xFD36,0xFD3D,0xFCFF,0xFD1B,0xFD48,
	0xFD1E,0xFD58,0xFD68,0xFD95,0xFD86,0xFD1C,0xFD0F,0xFD51,
	0xFD65,0xFD4B,0xFDBA,0xFDF2,0xFDF8,0xFD61,0xFC9F,0xFD4A,
	0xFDBD,0xFE02,0xFEF1,0xFF98,0xFF81,0xFF9D,0xFF4E,0x0014,
	0x01D0,0x0402,0x05DC,0x06C0,0x06DA,0x0763,0x07AA,0x078A,
	0x06E2,0x08E1,0x0938,0x083A,0x0935,0x08AC,0x088A,0x08A2,
	0x08DA,0x09B8,0x0B71,0x0CEC,0x0D73,0x0C8D,0x0B50,0x0A4B,
	0x0A85,0x0C86,0x0E8B,0x1033,0x1075,0x1074,0x109B,0x1083,
	0x1063,0x0FDF,0x0ECC,0x0D69,0x0BD0,0x0951,0x066C,0x0409,
	0x0413,0x07A1,0x0FA3,0x1869,0x1F40,0x20E0,0x1CFD,0x1748,
	0x1346,0x12A4,0x1607,0x1BFF,0x2234,0x2646,0x279A,0x26FA,
	0x24E6,0x22CA,0x2049,0x1CEA,0x1AC3,0x1A48,0x19AD,0x17F7,
	0x1553,0x140E,0x1433,0x150B,0x15DC,0x160E,0x1435,0x0FBE,
	0x0A17,0x053F,0x0504,0x098B,0x0E3B,0x12B0,0x1541,0x1618,
	0x1534,0x12E4,0x10F0,0x1094,0x116A,0x122F,0x13E0,0x15C0,
	0x167C,0x1647,0x14BF,0x1435,0x132B,0x1292,0x111C,0x0DEC,
	0x0A64,0x07CA,0x0667,0x05E2,0x064D,0x083B,0x094E,0x08A7,
	0x067A,0x035A,0x00F7,0xFED6,0xFE0D,0xFFFE,0x0314,0x0597,
	0x07D0,0x0848,0x07B8,0x0735,0x0700,0x0707,0x05BA,0x057A,
	0x05CD,0x060B,0x0555,0x0514,0x0588,0x0586,0x0546,0x03E9,
	0x02AD,0x0107,0xFE78,0xFC35,0xFA26,0xF9FA,0xFB1D,0xFBBA,
	0xFC50,0xFC3F,0xFB26,0xF94D,0xF765,0xF658,0xF6A0,0xF7A2,
	0xF856,0xF8FF,0xFA5E,0xFB2E,0xFB98,0xFB6E,0xFB00,0xFAF0,
	0xFAC0,0xFA4A,0xFA5D,0xFA28,0xF9E8,0xF905,0xF84E,0xF899,
	0xF96E,0xF8C3,0xF796,0xF5F3,0xF430,0xF31A,0xF21C,0xF1D7,
	0xF1F6,0xF1AC,0xF143,0xF104,0xF0EC,0xF110,0xF099,0xF041,
	0xF016,0xF0DE,0xF165,0xF180,0xF213,0xF2AA,0xF348,0xF35C,
	0xF39E,0xF461,0xF45E,0xF39D,0xF33E,0xF2A6,0xF258,0xF250,
	0xF43D,0xF367,0xF2D2,0xF3E7,0xF1A4,0xF050,0xEFA4,0xEF34,
	0xEF13,0xEEDE,0xEF16,0xEF3F,0xEF12,0xEE2C,0xEDE0,0xEE76,
	0xEEEA,0xEF5F,0xEF4C,0xEF9A,0xF03B,0xF007,0xEFA5,0xEFAC,
	0xF188,0xF31B,0xF38E,0xF357,0xF2E4,0xF227,0xF1E6,0xF167,
	0xF122,0xF1BA,0xF286,0xF308,0xF31C,0xF290,0xF172,0xEFE7,
	0xEE92,0xEE59,0xEFC2,0xF0F4,0xF10C,0xF0A8,0xEFC4,0xEED6,
	0xEEB5,0xEF7F,0xF090,0xF258,0xF369,0xF2AE,0xF16A,0xF0BC,
	0xF098,0xF142,0xF305,0xF46E,0xF4BF,0xF438,0xF2E4,0xF49C,
	0xF4EA,0xF4AC,0xF4C8,0xF481,0xF458,0xF455,0xF42B,0xF2E4,
	0xF1A0,0xF0D9,0xF0C3,0xF16E,0xF2B7,0xF3BF,0xF3F2,0xF249,
	0xF0BF,0xF05A,0xF094,0xF0A8,0xEF34,0xE918,0xDD52,0xCBB4,
	0xBFBD,0xBF73,0xBF59,0xBF6F,0xC0A3,0xC0D4,0xDECF,0x0E65,
	0x270E,0x245C,0x0C6C,0xEF8A,0xDD9F,0xE0B3,0xF866,0x1B65,
	0x3917,0x3EA3,0x3E61,0x3E75,0x3E4F,0x3ACD,0x2979,0x18B8,
	0x0BC6,0x01DF,0xF9BD,0xF36E,0xEEF8,0xED14,0xEE90,0xF1FD,
	0xF31E,0xEC17,0xDA1E,0xC37C,0xBDD9,0xBEFE,0xBE44,0xC496,
	0xE10D,0xFD07,0x0E2A,0x1341,0x0F52,0x06FC,0xFF4C,0xFC95,
	0x0112,0x0D01,0x1C9C,0x2A16,0x3239,0x3435,0x3128,0x2A44,
	0x214C,0x1701,0x0AB8,0xFD12,0xEEED,0xE36C,0xDE1B,0xDFB4,
	0xE560,0xEB2D,0xED51,0xE9B8,0xDFF6,0xD2BD,0xC644,0xC019,
	0xC343,0xCF51,0xE01B,0xF1D6,0x009C,0x0968,0x0BED,0x0A6F,
	0x072C,0x062A,0x07B8,0x0B30,0x0FAA,0x1426,0x178A,0x1964,
	0x1AC9,0x1B79,0x193B,0x12DC,0x0872,0xFB7C,0xEF3E,0xE510,
	0xDFE4,0xE15C,0xE315,0xE859,0xEC15,0xEC29,0xE930,0xE3C5,
	0xDD76,0xD9CD,0xD9C0,0xDED2,0xE80B,0xF2F6,0xFD7C,0x059F,
	0x0B0B,0x0E0A,0x0EDF,0x0E87,0x0E48,0x0E7E,0x0ED4,0x0F57,
	0x0F3E,0x0FC2,0x10CB,0x1240,0x118E,0x0D39,0x065E,0xFE56,
	0xF659,0xEF0E,0xE9B1,0xE726,0xE75F,0xE95E,0xEC3F,0xEDFE,
	0xEE69,0xED23,0xEAF0,0xE958,0xE9F5,0xECDC,0xF11D,0xF6A0,
	0xFC91,0x0207,0x07F9,0x0D0D,0x1040,0x1178,0x1087,0x0E9A,
	0x0D0F,0x0C4D,0x0C10,0x0BDE,0x0BE5,0x0B19,0x094D,0x06DD,
	0x03B3,0xFDED,0xF8F4,0xF2E3,0xEE04,0xEBAE,0xEBBF,0xECF0,
	0xEE62,0xEFEB,0xF126,0xF222,0xF2C8,0xF379,0xF4C9,0xF59A,
	0xF781,0xFADD,0x002E,0x04CE,0x0762,0x0A53,0x0CDB,0x0DFF,
	0x0E63,0x0EB3,0x0DD4,0x0B9F,0x09B2,0x0787,0x0694,0x064C,
	0x0617,0x056A,0x0362,0x006F,0xFCF6,0xFA0E,0xF726,0xF4D6,
	0xF36B,0xF2C2,0xF368,0xF534,0xF8B5,0xFADD,0xFB2A,0xFB13,
	0xFAE7,0xFBE5,0xFDAB,0x0022,0x02A5,0x0558,0x07E1,0x0A57,
	0x0C6B,0x0DD2,0x0ED6,0x0F30,0x0E38,0x0C86,0x0A1C,0x0811,
	0x06B8,0x0517,0x03B5,0x0296,0x026B,0x01CB,0x0016,0xFDB6,
	0xFAAE,0xF7EA,0xF669,0xF62C,0xF754,0xF8B0,0xF842,0xF481,
	0xEAFC,0xD9EB,0xC4F3,0xC012,0xC088,0xC030,0xC10A,0xC192,
	0xC583,0xFA7B,0x333A,0x3DBE,0x3D81,0x219A,0xF8D7,0xE600,
	0xEF14,0x13B6,0x3B90,0x3FE4,0x3F72,0x3FDB,0x3FD1,0x3F62,
	0x3FC3,0x3B54,0x258E,0x13C9,0x07A2,0xFD8C,0xF506,0xF038,
	0xF017,0xF576,0xFAFA,0xFADB,0xEEC8,0xD3F6,0xC08D,0xC098,
	0xC19A,0xBEFA,0xCEF5,0xF97E,0x19B0,0x2CF3,0x3039,0x2767,
	0x1B29,0x11FF,0x1073,0x174A,0x26D1,0x3983,0x3FCD,0x3F4C,
	0x3F93,0x3F58,0x3ED9,0x3460,0x256C,0x1524,0x01A2,0xED66,
	0xDF11,0xDA78,0xDEFC,0xE927,0xF26A,0xF46A,0xEC8B,0xDD28,
	0xCB86,0xC100,0xBFF2,0xC296,0xD33D,0xEA6D,0x0176,0x143C,
	0x1ED4,0x20B7,0x1DC4,0x1974,0x1745,0x18E7,0x1DA0,0x22DD,
	0x26C8,0x291D,0x2AA5,0x2C26,0x2B74,0x26D3,0x1C48,0x0CE5,
	0xFAC5,0xEA28,0xDE65,0xD91C,0xDA6D,0xE005,0xE81C,0xEE5D,
	0xED86,0xE8D5,0xE0E2,0xD8A3,0xD3A1,0xD5F6,0xDFD2,0xEEA1,
	0xFDCB,0x09C7,0x1206,0x167A,0x18CD,0x1AD7,0x1C9A,0x1D1B,
	0x1B9A,0x1897,0x15E4,0x1640,0x1915,0x1AE5,0x1A41,0x17DC,
	0x11CA,0x085A,0xFCB3,0xF0DA,0xE71A,0xE0A9,0xDEA7,0xE0D5,
	0xE594,0xEA39,0xECCF,0xEBD0,0xE922,0xE63C,0xE567,0xE6E3,
	0xEB28,0xF1E8,0xFAA6,0x02B5,0x08CB,0x1058,0x15FC,0x17D6,
	0x174B,0x15D2,0x137B,0x114E,0x0F9B,0x0EAC,0x0DA5,0x0C9B,
	0x0B72,0x09CF,0x0673,0x014B,0xFB16,0xF2E7,0xEB4D,0xE534,
	0xE2A7,0xE3A6,0xE632,0xE8F4,0xEB58,0xED62,0xEECE,0xEFBC,
	0xF05D,0xF0B1,0xF254,0xF4E4,0xF8ED,0xFE4D,0x0546,0x0BC4,
	0x0FBF,0x118C,0x11E5,0x10C0,0x0F1F,0x0D11,0x0AD0,0x0870,
	0x067A,0x04DB,0x0407,0x03CF,0x0314,0xFFFA,0xFAEC,0xF580,
	0xF0CC,0xEDDC,0xEBCC,0xEA9E,0xEAA4,0xEC6A,0xEE5C,0xF0B8,
	0xF366,0xF5D4,0xF77D,0xF7CB,0xF8BD,0xFAF3,0xFE0B,0x0161,
	0x042D,0x06D9,0x0975,0x0BD2,0x0E2E,0x0FD5,0x0F66,0x0C3D,
	0x0A63,0x066F,0x02E0,0x02C3,0x01C2,0x0139,0x001C,0xFE00,
	0xFB31,0xF8D9,0xF691,0xF4DE,0xF30A,0xF1F9,0xF148,0xF1D4,
	0xF293,0xF379,0xF38D,0xF016,0xE74E,0xD578,0xC1E0,0xBF2B,
	0xBF6E,0xBF58,0xC0D0,0xBFE2,0xD035,0x11FC,0x3AF7,0x3CAE,
	0x3A84,0x179C,0xF11F,0xE3F7,0xF436,0x1E12,0x3E1D,0x3EA1,
	0x3F40,0x3F65,0x3F6A,0x3EAF,0x3F63,0x3283,0x1BF4,0x0C90,
	0x011B,0xF831,0xF193,0xEEAB,0xF002,0xF5DD,0xFCFD,0xFC18,
	0xECA0,0xCEB1,0xBFB9,0xC096,0xC10E,0xC0E5,0xD99B,0x04D4,
	0x214F,0x2E68,0x2C80,0x21E2,0x15C2,0x0DAE,0x0C9E,0x1588,
	0x2686,0x38DD,0x3EFA,0x3E8B,0x3EB8,0x3F08,0x3A76,0x2BBC,
	0x1C4A,0x0B44,0xF905,0xE687,0xDA6A,0xD89C,0xDFBD,0xEADF,
	0xF37F,0xF3F5,0xEAC5,0xDA90,0xC82F,0xC041,0xC06A,0xC5BD,
	0xDA25,0xF1F6,0x0847,0x1875,0x1FD0,0x1FEE,0x1BE3,0x182E,
	0x1653,0x182B,0x1C6D,0x22B3,0x2787,0x2982,0x2AD7,0x2ACA,
	0x28CC,0x22AD,0x1787,0x073A,0xF63C,0xE712,0xDD06,0xDA4A,
	0xDD99,0xE4B4,0xEC66,0xF058,0xEE0B,0xE7B2,0xDEF8,0xD7BA,
	0xD5DE,0xDAF4,0xE5A1,0xF37C,0x01A6,0x0D0A,0x152C,0x19C2,
	0x1C3B,0x1D06,0x1CE6,0x1C03,0x1A7A,0x17E5,0x1606,0x1636,
	0x186B,0x1B88,0x1BDF,0x17FC,0x1064,0x05AF,0xF92C,0xEE14,
	0xE615,0xE14E,0xE046,0xE2F3,0xE80D,0xED83,0xF007,0xEE6A,
	0xEA8E,0xE764,0xE78F,0xEB40,0xF12F,0xF7F9,0xFEF5,0x05D1,
	0x0C2D,0x1260,0x17E1,0x1B5D,0x1BD2,0x18E8,0x1458,0x10E2,
	0x0F40,0x0EC5,0x0E44,0x0DE3,0x0D9C,0x0C06,0x0883,0x03B4,
	0xFA85,0xF29B,0xEE41,0xE8BB,0xE669,0xE7C6,0xEAC8,0xEDB1,
	0xEF69,0xF08A,0xF271,0xF407,0xF4CC,0xF5DE,0xF7AE,0xFAAF,
	0xFECF,0x043D,0x0989,0x0EE9,0x1348,0x1602,0x15F5,0x141D,
	0x1132,0x0DF4,0x0B3D,0x0977,0x08C9,0x0885,0x078D,0x0573,
	0x024B,0xFF6A,0xFC01,0xF7B9,0xF37B,0xF023,0xEE08,0xED61,
	0xEE43,0xEFB6,0xF1EA,0xF491,0xF6CE,0xF8AB,0xF9D5,0xFBD3,
	0xFDC2,0xFECE,0x000A,0x02C1,0x0672,0x09F2,0x0D2C,0x0F7A,
	0x107A,0x0F94,0x0D1A,0x0ABC,0x08ED,0x07AB,0x0836,0x069A,
	0x0488,0x02A7,0xFFE7,0xFCFD,0xFB83,0xFAA3,0xF966,0xF6FC,
	0xF4AE,0xF2E4,0xF25A,0xF305,0xF54E,0xF793,0xF78A,0xF1DE,
	0xE56E,0xD001,0xC03F,0xC011,0xBF9C,0xBF49,0xC10A,0xBF74,
	0xDE50,0x238E,0x3D89,0x3CAB,0x33DC,0x0A49,0xEA24,0xE5BA,
	0xFDE7,0x2A21,0x3F99,0x3E0F,0x3ECA,0x3ED3,0x3EB8,0x3E53,
	0x3D8F,0x2D0A,0x184D,0x0927,0xFE84,0xF73F,0xF12E,0xEEFB,
	0xF29D,0xFA34,0xFF1A,0xF9C5,0xE5C9,0xC7DE,0xBE7B,0xBF92,
	0xBF69,0xC254,0xE414,0x0D9E,0x27A0,0x303D,0x29D6,0x1C20,
	0x0FBD,0x0A8C,0x0F02,0x1B78,0x2CA6,0x3BB7,0x3E1F,0x3DE5,
	0x3DE3,0x3E04,0x3587,0x266B,0x16EF,0x04DD,0xF243,0xE231,
	0xD7CC,0xD74D,0xDFD7,0xEC23,0xF3F8,0xF131,0xE430,0xD0E8,
	0xC147,0xBF42,0xBEE9,0xC835,0xDFCB,0xF640,0x0922,0x15CF,
	0x1B96,0x1BA9,0x1831,0x1437,0x132F,0x1623,0x1AEA,0x1FAA,
	0x23B7,0x25E2,0x2667,0x25F7,0x239F,0x1D77,0x1218,0x01DB,
	0xF028,0xE070,0xD6F3,0xD600,0xDC5C,0xE597,0xEAB5,0xEB07,
	0xE84B,0xDFB6,0xD9B0,0xD577,0xD524,0xDA1C,0xE48C,0xF156,
	0xFF40,0x0B9D,0x13CB,0x187E,0x1A53,0x1991,0x1805,0x16B6,
	0x158B,0x14D8,0x1375,0x139D,0x15BA,0x1850,0x18D9,0x14EF,
	0x0C67,0x0086,0xF3BE,0xE87E,0xE17C,0xDF50,0xE0AA,0xE465,
	0xE7D1,0xEAFB,0xECB0,0xEBA0,0xE93E,0xE6BC,0xE6D2,0xE9E6,
	0xEEC1,0xF5A7,0xFE1D,0x0625,0x0D8B,0x134D,0x16EC,0x18CB,
	0x18B2,0x1681,0x12D6,0x0EEF,0x0C81,0x0C2C,0x0C11,0x0CD5,
	0x0D10,0x0B96,0x07B2,0x0091,0xF7B7,0xEF66,0xE912,0xE4B0,
	0xE255,0xE52B,0xE9A3,0xED8B,0xEF13,0xEF59,0xEFDA,0xF098,
	0xF1D1,0xF312,0xF579,0xF9BA,0xFE6B,0x033E,0x0838,0x0D7A,
	0x11A3,0x1367,0x125B,0x0FEF,0x0EE7,0x0D76,0x0B08,0x07E1,
	0x05C3,0x0410,0x0346,0x0398,0x02EC,0x0046,0xFB8B,0xF506,
	0xEF36,0xEBDE,0xEAD0,0xEBC2,0xEDEA,0xEFFF,0xF26A,0xF530,
	0xF7C3,0xF961,0xFA04,0xFB75,0xFC06,0xFCD0,0x0010,0x04D1,
	0x08E2,0x0ADF,0x0B44,0x0BE2,0x0D2D,0x0E64,0x0ECB,0x0DB7,
	0x0AEA,0x0776,0x0448,0x01F9,0x0181,0x01A0,0x0178,0x005D,
	0xFDC1,0xFAED,0xF7B9,0xF489,0xF26F,0xF274,0xF402,0xF5ED,
	0xF708,0xF470,0xEC09,0xDCDA,0xC7DD,0xC02B,0xC0C9,0xC021,
	0xC0AB,0xC246,0xC2C5,0xEE7A,0x2F29,0x3E32,0x3E67,0x2C90,
	0x01BA,0xE8CD,0xEB2E,0x09EA,0x3505,0x407D,0x3F27,0x4013,
	0x3FD9,0x3F6B,0x3FC0,0x3C62,0x260D,0x125D,0x064E,0xFD86,
	0xF682,0xF130,0xEFE3,0xF334,0xF92E,0xFB9C,0xF3F4,0xDBFB,
	0xC2D1,0xBFF3,0xC0EF,0xC04D,0xC94D,0xF1C4,0x1716,0x2CBB,
	0x2FD5,0x2A28,0x1E3D,0x12F5,0x0FBD,0x148B,0x2183,0x341F,
	0x3F3D,0x3F3B,0x3F8C,0x3F75,0x3EA6,0x3374,0x2414,0x1407,
	0x01C6,0xEF29,0xDFE1,0xD81F,0xDA47,0xE43D,0xEF06,0xF37A,
	0xED75,0xDEBA,0xCD07,0xC114,0xC004,0xC0D3,0xCE5C,0xE5A0,
	0xFD22,0x1117,0x1D23,0x2115,0x1ECB,0x19C6,0x15B9,0x1610,
	0x1A3B,0x1FF9,0x2505,0x292C,0x2B84,0x2B98,0x298F,0x24C3,
	0x1C6A,0x0F1F,0xFD71,0xEBCF,0xDE76,0xD7CD,0xD886,0xDE8F,
	0xE5F9,0xEB23,0xEB1E,0xE623,0xDEC7,0xD8C2,0xD6E7,0xD767,
	0xDE31,0xEA53,0xF8F7,0x071C,0x1216,0x1872,0x1B50,0x1BE8,
	0x1A62,0x18AD,0x1784,0x167F,0x1639,0x165E,0x1723,0x181A,
	0x17F6,0x15AE,0x112A,0x08A7,0xFC24,0xEEF0,0xE509,0xDE71,
	0xDC17,0xDE4C,0xE234,0xE693,0xE993,0xEA19,0xE847,0xE4A6,
	0xE22D,0xE383,0xE7DC,0xEEAB,0xF678,0xFF0B,0x06CC,0x0CF3,
	0x1133,0x1415,0x14E0,0x13F2,0x1298,0x1004,0x0D7D,0x0BBC,
	0x09CF,0x091E,0x0915,0x094E,0x075C,0x0247,0xFA94,0xF241,
	0xEACC,0xE442,0xE0F1,0xE14A,0xE389,0xE697,0xE93A,0xEBA6,
	0xED79,0xEE78,0xEF0C,0xEFD2,0xF1B7,0xF50B,0xF8AE,0xFD0B,
	0x0225,0x0757,0x0C32,0x0EFC,0x10A4,0x10AB,0x0FBC,0x0D79,
	0x0A1D,0x0799,0x0531,0x0380,0x027B,0x0181,0x004D,0xFE19,
	0xFAA6,0xF660,0xF1F1,0xEE6D,0xEBC3,0xE9E1,0xE9A2,0xEBA9,
	0xEEB4,0xF1CD,0xF3F6,0xF4FA,0xF5ED,0xF788,0xF9C1,0xFC1E,
	0xFEA9,0x00CF,0x02BE,0x052A,0x0809,0x0B60,0x0DF7,0x0EA6,
	0x0D12,0x0B35,0x0845,0x05DC,0x0417,0x02E1,0x00DC,0x010D,
	0xFEFD,0xFC6D,0xFBF8,0xF9B0,0xF6B4,0xF3F6,0xF23C,0xF18A,
	0xF228,0xF2DB,0xF444,0xF5F8,0xF661,0xF2EA,0xEA34,0xD990,
	0xC518,0xBF2C,0xBF6A,0xBF3E,0xC045,0xC04F,0xC87C,0x0371,
	0x3803,0x3CAE,0x3C90,0x20FE,0xF6A0,0xE39E,0xEE03,0x1416,
	0x3AC2,0x3F5C,0x3EF2,0x3F6A,0x3F7C,0x3ED0,0x3F6F,0x3734,
	0x202C,0x0F1E,0x03EC,0xFAA6,0xF36A,0xEF17,0xEFC5,0xF5FE,
	0xFD1C,0xFD66,0xF174,0xD5A7,0xC04B,0xC043,0xC11D,0xBFF3,
	0xD1BF,0xFDBD,0x1F16,0x2FD4,0x2FDF,0x24E0,0x1662,0x0BC1,
	0x0AA0,0x13D0,0x2298,0x34F1,0x3E9C,0x3E72,0x3E6E,0x3ED9,
	0x3C05,0x2EE9,0x1FCE,0x0EED,0xFBFC,0xEA63,0xDC63,0xD66F,
	0xDB14,0xE807,0xF2AF,0xF5C1,0xEE5C,0xDD74,0xC973,0xBFF8,
	0xC04D,0xC34D,0xD65D,0xEEED,0x0542,0x160F,0x1E2C,0x1FCE,
	0x1D64,0x1992,0x1754,0x1901,0x1D46,0x222B,0x26A7,0x2963,
	0x2B11,0x2B38,0x2A9E,0x262B,0x1BBF,0x0D8B,0xFBCE,0xEA4C,
	0xDD5D,0xD84C,0xDB66,0xE36D,0xEBCA,0xF010,0xEE42,0xE7CC,
	0xDF7D,0xD8D0,0xD6EF,0xDA6B,0xE406,0xF128,0xFE93,0x09FC,
	0x1265,0x179F,0x1AC7,0x1BB0,0x1C42,0x1BAA,0x199D,0x1759,
	0x15FF,0x16DE,0x180C,0x190C,0x193C,0x179C,0x1248,0x089F,
	0xFC30,0xF02B,0xE706,0xE107,0xDF69,0xE287,0xE7CD,0xEC06,
	0xECD8,0xEB6E,0xE9F7,0xE8D2,0xE83A,0xE8F3,0xEC72,0xF30B,
	0xFAC9,0x0207,0x0992,0x10D2,0x15F8,0x1864,0x1812,0x1666,
	0x141C,0x1110,0x0E4F,0x0CB0,0x0C9D,0x0D9E,0x0DE6,0x0C66,
	0x081F,0x01C8,0xFAA6,0xF30E,0xEC8B,0xE88B,0xE793,0xE6BF,
	0xE73E,0xEB8E,0xEDA1,0xEF75,0xF121,0xF1B8,0xF1F2,0xF291,
	0xF465,0xF738,0xFBE3,0x0149,0x05ED,0x0ACC,0x0EB1,0x11BD,
	0x132F,0x1292,0x0F66,0x0B45,0x0842,0x06B4,0x060B,0x05EF,
	0x0511,0x03D5,0x01BB,0xFE75,0xFA3B,0xF5A0,0xF17D,0xEDCB,
	0xEB26,0xEA9F,0xEB59,0xED4D,0xF055,0xF38F,0xF627,0xF7A0,
	0xF85B,0xF8AC,0xFA25,0xFC27,0xFDF1,0x001A,0x0378,0x078E,
	0x0B56,0x0E06,0x0F9C,0x0F7A,0x0D49,0x09A5,0x061B,0x040F,
	0x034D,0x0326,0x0213,0x006A,0xFEE4,0xFFA8,0xFD76,0xFAAD,
	0xF865,0xF622,0xF3C1,0xF152,0xF046,0xF19F,0xF3C4,0xF437,
	0xF02B,0xE589,0xD1C3,0xC0E5,0xBFE7,0xBF96,0xBFB6,0xC14E,
	0xBF77,0xD344,0x16E8,0x3C8D,0x3CA1,0x3794,0x116D,0xED0D,
	0xE3AD,0xF689,0x21F0,0x3EC6,0x3E07,0x3ECD,0x3F0D,0x3ECC,
	0x3E50,0x3EBE,0x3134,0x19E9,0x0A10,0xFE26,0xF464,0xED31,
	0xEB97,0xEEFD,0xF454,0xF84C,0xF655,0xE5C9,0xC94F,0xBEBE,
	0xBFDF,0xC031,0xC09D,0xDBE0,0x06A3,0x22A0,0x2E73,0x2AB4,
	0x1EB0,0x11CB,0x0C00,0x0F02,0x198E,0x29ED,0x3A03,0x3DF8,
	0x3DE2,0x3DC6,0x3E0F,0x387C,0x2983,0x1941,0x0740,0xF370,
	0xE2D6,0xD7DD,0xD60C,0xDDC3,0xE9E9,0xF18B,0xEF3F,0xE34F,
	0xD264,0xC323,0xBEFF,0xBEB8,0xC626,0xDB7D,0xF220,0x06CC,
	0x15A0,0x1D44,0x1E68,0x1B08,0x16BE,0x14E6,0x1706,0x1C05,
	0x2154,0x2566,0x27F4,0x2944,0x2895,0x2502,0x1E5B,0x1368,
	0x03B0,0xF162,0xE184,0xD866,0xD6FD,0xDAE8,0xE0D5,0xE674,
	0xE95D,0xE785,0xE1E1,0xDA7F,0xD53A,0xD361,0xD7CA,0xE285,
	0xEE65,0xFE4B,0x0B62,0x12A5,0x16C4,0x1943,0x1A9E,0x1AA5,
	0x18D0,0x1664,0x1467,0x137F,0x1425,0x165D,0x19AB,0x19B2,
	0x152D,0x0C32,0x0165,0xF5EC,0xEBA4,0xE416,0xDF87,0xDEB8,
	0xE10E,0xE537,0xE94F,0xEB7F,0xEB47,0xE937,0xE71F,0xE68A,
	0xE8BB,0xED84,0xF415,0xFB43,0x037B,0x0B08,0x1170,0x1611,
	0x18A2,0x18BA,0x16A3,0x132A,0x0FAA,0x0D6C,0x0C57,0x0B82,
	0x0B25,0x0AC9,0x097F,0x068A,0x00DA,0xF8EA,0xF061,0xE8CC,
	0xE4E0,0xE488,0xE694,0xE968,0xEB15,0xEC74,0xECA4,0xECA5,
	0xEF07,0xF1A9,0xF3A1,0xF55A,0xF724,0xFAE2,0x006C,0x06DC,
	0x0C34,0x0F49,0x114E,0x125E,0x11D9,0x0FA2,0x0CD1,0x0927,
	0x06F6,0x0508,0x0386,0x03F0,0x03A9,0x0131,0xFD76,0xF923,
	0xF492,0xF0CC,0xEE7B,0xECD7,0xEBBD,0xEBEA,0xEDB1,0xF0F9,
	0xF469,0xF6C5,0xF8BF,0xFA29,0xFA26,0xFAF6,0xFCF7,0x009B,
	0x0462,0x0791,0x0B4C,0x0D3B,0x0DFF,0x0F34,0x0EDE,0x0D57,
	0x0AFD,0x085B,0x0605,0x041D,0x0321,0x0269,0x01A9,0xFFD5,
	0xFD9C,0xFBC6,0xF9CC,0xF78B,0xF554,0xF321,0xF1F7,0xF220,
	0xF448,0xF692,0xF938,0xFA46,0xF77C,0xEF99,0xE4F0,0xD8E7,
	0xCBAE,0xC1F1,0xC0F2,0xC3AB,0xD8D0,0xF8D8,0x1799,0x2BA2,
	0x2D16,0x1E46,0x08EE,0xF955,0xF76B,0x045F,0x18AC,0x2C67,
	0x3AF1,0x3F78,0x3F97,0x3985,0x2D28,0x1F3A,0x10B7,0x04F5,
	0xFDC4,0xF9CD,0xF797,0xF5FA,0xF5CB,0xF805,0xFBF1,0xFEF4,
	0xFC73,0xF311,0xE3B9,0xD4E1,0xCDC9,0xD35D,0xE3F6,0xF954,
	0x0C49,0x1898,0x1C75,0x19AA,0x1330,0x0DA0,0x09B2,0x073B,
	0x0CDF,0x14D0,0x1CB3,0x23B6,0x2705,0x24CF,0x1EC7,0x16E8,
	0x0EA2,0x06C3,0xFE5D,0xF549,0xED31,0xE8AF,0xE9E7,0xEF91,
	0xF639,0xFA0A,0xF928,0xF334,0xEB54,0xE3DB,0xE050,0xE1A4,
	0xE768,0xF19D,0xFD86,0x08B1,0x10AE,0x1390,0x124C,0x0EE6,
	0x0B0C,0x092E,0x093F,0x0BC7,0x0F92,0x1245,0x12BF,0x11F8,
	0x1068,0x0DF6,0x0AA5,0x0461,0xFCED,0xF582,0xEE82,0xEA30,
	0xE9A7,0xEC4B,0xF103,0xF557,0xF75D,0xF602,0xF29A,0xEE85,
	0xEB83,0xEB52,0xEEBE,0xF54F,0xFE50,0x0604,0x09D6,0x0C67,
	0x0DEB,0x0DD0,0x0DBE,0x0C11,0x0A87,0x09F7,0x09AE,0x095B,
	0x0943,0x094F,0x095C,0x0912,0x0787,0x0439,0xFF14,0xF85C,
	0xF215,0xEF0A,0xEE6A,0xEEC0,0xF126,0xF53E,0xF760,0xF77C,
	0xF5EE,0xF402,0xF371,0xF3AF,0xF516,0xF7F6,0xFBF0,0x0019,
	0x03CF,0x063B,0x0854,0x091C,0x0893,0x077F,0x06F8,0x075D,
	0x0724,0x04A8,0x0105,0x00D0,0x01E4,0x0278,0x020D,0x0073,
	0xFD62,0xF984,0xF553,0xF1C7,0xEFCA,0xF03E,0xF251,0xF46C,
	0xF5C6,0xF651,0xF632,0xF589,0xF576,0xF625,0xF770,0xF95A,
	0xFB7F,0xFD8A,0x00A4,0x033A,0x0482,0x0518,0x0515,0x04A0,
	0x043A,0x040B,0x0386,0x023B,0x0090,0xFE84,0xFDDA,0xFE24,
	0xFDFA,0xFD14,0xFAF2,0xF8DF,0xF728,0xF573,0xF3FD,0xF315,
	0xF23C,0xF13F,0xF07D,0xEFB7,0xEF2E,0xEEE2,0xEE8B,0xEDB6,
	0xECE0,0xED60,0xEF45,0xF0C0,0xF16F,0xF22B,0xF307,0xF3C3,
	0xF46B,0xF4B7,0xF562,0xF52C,0xF3EB,0xF2EE,0xF20A,0xF1C2,
	0xF19F,0xF0F0,0xEFF3,0xEFAB,0xEF39,0xEDDA,0xEF44,0xED8D,
	0xEC23,0xEC9A,0xEB71,0xEB06,0xEB00,0xEAEB,0xEAB1,0xEAEF,
	0xEAAB,0xEA7E,0xE9FE,0xEA3D,0xEA0C,0xE9CE,0xE9B7,0xE98F,
	0xE9B6,0xE9B7,0xE979,0xE97F,0xE9B8,0xE902,0xE94E,0xE8F3,
	0xE8B3,0xE89E,0xE873,0xE8C9,0xE8BE,0xE8B9,0xE915,0xE964,
	0xE969,0xE98F,0xEA1A,0xEA35,0xEA21,0xEA11,0xEA87,0xEAE5,
	0xEB26,0xEB3C,0xEBC7,0xEC6E,0xED05,0xED74,0xEDAE,0xEDCE,
	0xEE46,0xEE84,0xEF04,0xEFDE,0xF03A,0xF089,0xF10F,0xF17C,
	0xF1E6,0xF262,0xF27D,0xF2AA,0xF2F2,0xF30C,0xF190,0xF0F8,
	0xF203,0xF29B,0xF2EC,0xF350,0xF3CD,0xF44F,0xF51E,0xF584,
	0xF5B1,0xF649,0xF699,0xF732,0xF7ED,0xF8C1,0xF9A1,0xFA6E,
	0xFADE,0xFA68,0xFAB1,0xFC42,0xFD2F,0xFD5C,0xFDA1,0xFE44,
	0xFEB1,0xFF29,0xFFC7,0xFFDF,0x0014,0x004B,0x00BC,0x012D,
	0x0174,0x01C5,0x0269,0x02B7,0x02B0,0x02FD,0x0330,0x0384,
	0x03BC,0x0470,0x0574,0x049B,0x0485,0x04E8,0x05BE,0x066E,
	0x06AC,0x06C2,0x06F4,0x0745,0x07C5,0x08F2,0x09DF,0x0A07,
	0x0A90,0x0B1B,0x0B00,0x0B00,0x0B0D,0x0B72,0x0B9F,0x0B51,
	0x0B6A,0x0B9D,0x0B92,0x0B32,0x0B6D,0x0BD6,0x0C63,0x0C78,
	0x0C5F,0x0C00,0x0C0F,0x0C58,0x0C73,0x0C8E,0x0CE6,0x0D3F,
	0x0D4B,0x0D42,0x0D3D,0x0D5B,0x0D54,0x0D34,0x0D45,0x0D3C,
	0x0D89,0x0DC6,0x0DE0,0x0DCA,0x0DDE,0x0DC2,0x0D9F,0x0DAD,
	0x0D8F,0x0DB6,0x0DF7,0x0DDA,0x0D53,0x0D60,0x0D94,0x0D95,
	0x0DDF,0x0E22,0x0E2C,0x0DEF,0x0DB9,0x0DCE,0x0DD3,0x0DA4,
	0x0D24,0x0D96,0x0E3F,0x0E32,0x0E18,0x0ED7,0x0D00,0x0D00,
	0x0EE1,0x0DF3,0x0DAD,0x0DEB,0x0D5A,0x0DA5,0x0D6D,0x0D53,
	0x0D92,0x0DDA,0x0D99,0x0D42,0x0CEF,0x0CD7,0x0D0A,0x0D32,
	0x0D27,0x0CD2,0x0CE1,0x0CE0,0x0CB0,0x0C65,0x0CAB,0x0C4C,
	0x0C6B,0x0CA8,0x0CCC,0x0CC2,0x0C2A,0x0C19,0x0C03,0x0C38,
	0x0C42,0x0BE0,0x0BBF,0x0B9E,0x0B7E,0x0B1E,0x0B38,0x0B7E,
	0x0B87,0x0B3C,0x0B4D,0x0B61,0x0B2A,0x0ADD,0x0A97,0x0AB9,
	0x0AE2,0x0AAF,0x0ACD,0x0AEF,0x0B05,0x0A73,0x09F8,0x099E,
	0x095D,0x096D,0x09BF,0x09D6,0x0BCC,0x0BA2,0x0ACB,0x0AB8,
	0x0AA7,0x0A9A,0x0A9D,0x0A41,0x09DA,0x09FD,0x09FF,0x09D5,
	0x09B5,0x0987,0x096D,0x0944,0x08D9,0x08A8,0x08C3,0x0849,
	0x0844,0x08F3,0x0870,0x077E,0x07E0,0x082F,0x077C,0x0727,
	0x0720,0x0733,0x06EE,0x06A4,0x0657,0x064E,0x05E2,0x05C9,
	0x0612,0x0610,0x05F9,0x05DF,0x05CC,0x056B,0x057A,0x0556,
	0x0589,0x043C,0x0445,0x0577,0x0600,0x05F4,0x05D9,0x058E,
	0x052D,0x053B,0x0527,0x0546,0x049C,0x036F,0x0349,0x0306,
	0x025E,0x0279,0x02B1,0x0278,0x0274,0x0232,0x023E,0x0259,
	0x0236,0x0249,0x021B,0x020F,0x0286,0x029B,0x0251,0x020D,
	0x0293,0x0274,0x029D,0x02BF,0x02EA,0x029F,0x0295,0x0273,
	0x01D6,0x01FA,0x0189,0x019F,0x01BB,0x01DA,0x017C,0x015F,
	0x017F,0x0108,0x00FE,0x010A,0x01A0,0x017C,0x0127,0x00EE,
	0x00FF,0x00F9,0x00DD,0x011D,0x013D,0x013B,0x0115,0x00B6,
	0x0116,0x00FA,0x00E6,0x00EE,0x00E3,0x00B3,0x012F,0x0201,
	0x01E1,0x0174,0x0182,0x01B9,0x0123,0x019B,0x02CB,0x010A,
	0x0222,0x0210,0x01EC,0x0203,0x01E4,0x0184,0x01E7,0x01EB,
	0x0183,0x0190,0x015A,0x0196,0x014C,0x0169,0x017A,0x01A4,
	0x016D,0x014F,0x00E5,0x00F9,0x00F3,0x010C,0x00AF,0x009A,
	0x0104,0x014F,0x0118,0x010E,0x0136,0x012C,0x010E,0x00B2,
	0x0094,0x00A3,0x008B,0x0077,0xFF6A,0xFF4D,0xFF8E,0xFF52,
	0xFF91,0xFFB6,0xFFE0,0xFF9A,0xFF5F,0xFF99,0xFF57,0xFF5E,
	0xFF76,0xFFB0,0xFFDB,0xFF87,0xFF05,0xFF00,0xFED4,0xFEA9,
	0xFF25,0xFF78,0xFFB3,0xFF83,0xFF49,0xFEE0,0xFEF0,0xFF0F,
	0xFF19,0xFF0D,0xFF5C,0xFF6C,0xFF5B,0xFF53,0xFF51,0xFFA9,
	0x003E,0x0113,0x0171,0x01A8,0x011B,0x0112,0x011E,0x0177,
	0x010C,0x01F8,0x0390,0x0474,0x060F,0x0765,0x0818,0x081D,
	0x0879,0x08AE,0x091D,0x0941,0x0957,0x095A,0x08FB,0x086B,
	0x0829,0x0966,0x0B4B,0x0B8D,0x0BC3,0x0C05,0x0BF2,0x0C30,
	0x0D64,0x0E6A,0x0F19,0x1007,0x1089,0x0FA0,0x0D4E,0x0A1A,
	0x0673,0x02C5,0x0035,0x007E,0x05A2,0x0DDB,0x1706,0x1F2D,
	0x23AB,0x22D4,0x1DB2,0x1927,0x17AA,0x17C6,0x1B0B,0x1FEB,
	0x2488,0x2805,0x2933,0x27A3,0x242E,0x2002,0x1BA0,0x17B1,
	0x1400,0x119F,0x11A1,0x1263,0x12F0,0x13FE,0x1502,0x1561,
	0x15BC,0x14E0,0x128C,0x1077,0x0F67,0x0FDC,0x121A,0x1632,
	0x1B60,0x2018,0x2279,0x223F,0x1FAD,0x1C5A,0x195D,0x16EC,
	0x1505,0x1402,0x1485,0x143C,0x13E6,0x135F,0x131E,0x1171,
	0x0DDC,0x097D,0x05A0,0x0323,0x0281,0x0321,0x0462,0x0649,
	0x081C,0x09F4,0x0B56,0x0BF4,0x0C08,0x0B1A,0x09E7,0x0962,
	0x0969,0x0A67,0x0BA7,0x0D6C,0x0E4E,0x0EDF,0x0DE3,0x0BDC,
	0x08B1,0x04D9,0x015F,0xFFC7,0xFEA2,0xFE3C,0xFE05,0xFE59,
	0xFCB3,0xFBD8,0xFD1F,0xFBC1,0xFB8A,0xFB23,0xFA25,0xF971,
	0xFA03,0xFB9D,0xFD7F,0xFEEE,0x0096,0x01E9,0x01A9,0x0121,
	0xFFED,0xFEE4,0xFDDF,0xFC64,0xFB4D,0xFAC3,0xFACE,0xFB4C,
	0xFAEC,0xF9DB,0xF7C4,0xF539,0xF3AF,0xF27B,0xF1B7,0xF13E,
	0xF0FD,0xF17E,0xF2DE,0xF43F,0xF57C,0xF5EF,0xF59B,0xF524,
	0xF48D,0xF43D,0xF4C9,0xF5C0,0xF6DF,0xF835,0xF866,0xF7A4,
	0xF708,0xF65D,0xF566,0xF4C6,0xF36E,0xF1D6,0xF06B,0xEF06,
	0xEF18,0xEF24,0xEFF9,0xF02B,0xEF9E,0xF011,0xF2CA,0xF1DE,
	0xF017,0xEFBF,0xEF88,0xEFE5,0xF0CF,0xF2DA,0xF4AC,0xF50C,
	0xF3F2,0xF35F,0xF3A6,0xF3BE,0xF33A,0xF27B,0xF221,0xF1FA,
	0xF15C,0xF0D3,0xF0F7,0xF13A,0xEFF5,0xEE3D,0xEDBE,0xEDD1,
	0xED2F,0xEC7F,0xEBDF,0xEBBB,0xEC4D,0xEC8B,0xEC8B,0xED78,
	0xEE77,0xEF82,0xEFC9,0xEFDE,0xEF7E,0xEEF6,0xEF13,0xEFFA,
	0xF097,0xF13F,0xF1E0,0xF09D,0xEFA9,0xF0B2,0xF118,0xF10E,
	0xF0AC,0xEFFA,0xEF43,0xEEBE,0xEDF6,0xED40,0xED37,0xED12,
	0xEDAD,0xEE04,0xECF3,0xED34,0xECF7,0xECEC,0xECFB,0xEDD5,
	0xEEEE,0xEF83,0xEFD9,0xF019,0xF13A,0xF1F1,0xF201,0xF162,
	0xF125,0xF114,0xF0A6,0xF0B3,0xF114,0xF1D7,0xF1F8,0xF149,
	0xF0D6,0xF0BC,0xF0CE,0xF07E,0xEFD8,0xEFA6,0xEECD,0xED11,
	0xE903,0xE14E,0xD4A0,0xC38C,0xBE25,0xBEA4,0xBE7C,0xBFB9,
	0xBECC,0xCEA8,0x03EF,0x2FA2,0x3D4D,0x3786,0x19E3,0xFA3D,
	0xEA9F,0xF263,0x0BB3,0x2C27,0x3E00,0x3DC7,0x3DE7,0x3E62,
	0x3035,0x1689,0xFF7F,0xEB99,0xDC37,0xD1E2,0xCACF,0xC8F2,
	0xCCD8,0xD1A4,0xDD03,0xE912,0xEF89,0xEC13,0xDF68,0xCF4B,
	0xC583,0xC9D4,0xDEA7,0xFECF,0x2035,0x390C,0x3E67,0x3ED3,
	0x3592,0x2255,0x1358,0x09AA,0x063E,0x091C,0x0E24,0x1155,
	0x101E,0x08B0,0xFE77,0xF2DD,0xE77B,0xDC79,0xD28D,0xC97D,
	0xC2DD,0xC0A9,0xC7A4,0xD7A1,0xEBCA,0xFE31,0x08A5,0x0A7C,
	0x05A8,0xFEA8,0xF9D8,0xFB31,0x033D,0x1008,0x1DFB,0x28E0,
	0x2E44,0x2C75,0x22FF,0x1530,0x068A,0xFA2C,0xF19E,0xEC3C,
	0xE8E9,0xE6E1,0xE5F1,0xE5E8,0xE670,0xE71B,0xE725,0xE4A6,
	0xDFDD,0xDD2B,0xDBAC,0xDE35,0xE5BF,0xF177,0xFFEF,0x0EC1,
	0x1905,0x1CCE,0x1AEB,0x1534,0x0EB7,0x0A3F,0x0858,0x09AF,
	0x0C25,0x0E94,0x0DA4,0x08D8,0x0305,0xFC4D,0xF4FD,0xED56,
	0xE6DC,0xE23E,0xDEF6,0xDDA5,0xDF22,0xE3BD,0xEB1C,0xF2B8,
	0xF8AA,0xFC61,0xFD48,0xFC2F,0xFBC6,0xFD20,0x0116,0x06D2,
	0x0E6B,0x15A4,0x19D9,0x1BC0,0x18E9,0x123D,0x0B65,0x0497,
	0xFF3E,0xFB62,0xF8F9,0xF734,0xF63A,0xF51F,0xF407,0xF2E2,
	0xF168,0xF06F,0xF043,0xEEED,0xED8D,0xECC6,0xEF1E,0xF528,
	0xFCC9,0x052A,0x0BDB,0x0FB4,0x101A,0x0E1F,0x0C62,0x0B47,
	0x0B53,0x0C00,0x0C46,0x0C6D,0x0C8D,0x0B66,0x0883,0x0456,
	0xFF77,0xFADE,0xF6C6,0xF320,0xF0BC,0xEF59,0xEF5A,0xF08C,
	0xF230,0xF449,0xF76C,0xFA7B,0xFC40,0xFC02,0xFBAD,0xFC8E,
	0xFF2A,0x0252,0x06A5,0x0B1C,0x0ED1,0x1061,0x0EFB,0x0CD8,
	0x0AA1,0x07F2,0x04F8,0x023A,0x0104,0xFFFA,0xFE36,0xFBC4,
	0xFA41,0xF919,0xF7B1,0xF5A6,0xF402,0xF384,0xF3C1,0xF3DC,
	0xF391,0xF83A,0xFC32,0xFEF1,0x0273,0x0513,0x06A7,0x06F8,
	0x0752,0x0835,0x085B,0x0818,0x0875,0x092B,0x0934,0x089B,
	0x075A,0x050F,0x0249,0xFFB3,0xFD1B,0xFAC1,0xF8CC,0xF738,
	0xF61F,0xF65C,0xF734,0xF5F6,0xF0B1,0xE58A,0xD173,0xC0FA,
	0xBFBB,0xBF76,0xBF78,0xC169,0xC0CC,0xE682,0x2B40,0x3ED0,
	0x3C33,0x3EA2,0x2905,0x03FB,0xF7C2,0x05EF,0x2992,0x3F65,
	0x3E67,0x3F0D,0x3EBB,0x3E95,0x3B06,0x1F11,0x0093,0xE933,
	0xD837,0xCD72,0xC77C,0xC67C,0xCB7F,0xD8AA,0xEA45,0xF95B,
	0x0030,0xF95F,0xE634,0xD0E2,0xC6CD,0xD29A,0xF257,0x1E7F,
	0x3CF7,0x3F5B,0x3F7C,0x3F4A,0x3FE9,0x3437,0x202A,0x14EE,
	0x11BF,0x1407,0x1A34,0x1D86,0x1980,0x0EEB,0x0181,0xF3BD,
	0xE769,0xDBBF,0xCF5D,0xC394,0xBFBA,0xBF86,0xC83B,0xDF63,
	0xFA0B,0x103C,0x1A7C,0x195C,0x111B,0x0895,0x0417,0x0679,
	0x1094,0x1FF9,0x2F4C,0x397B,0x3DDB,0x39C3,0x2D71,0x1BD0,
	0x0907,0xF948,0xEE89,0xE82D,0xE41B,0xE200,0xE106,0xE240,
	0xE5A2,0xE78F,0xE742,0xE48E,0xDFA2,0xDB5D,0xDAD8,0xE03F,
	0xEBE0,0xFC17,0x0D40,0x1BA3,0x25A3,0x28ED,0x255F,0x1E18,
	0x163C,0x101A,0x0C5E,0x0B54,0x0CEE,0x0F06,0x0F4F,0x0BE6,
	0x04A4,0xFB29,0xF0F3,0xE66B,0xDDE8,0xD897,0xD624,0xD700,
	0xDB1D,0xE283,0xEBD7,0xF47E,0xFA27,0xFDAB,0xFEF5,0xFE96,
	0xFE7D,0x00F4,0x05DF,0x0C81,0x1442,0x1B02,0x1F22,0x1F2F,
	0x1B80,0x14CA,0x0C78,0x03CF,0xFB94,0xF5E1,0xF250,0xF04D,
	0xEF3C,0xEFE5,0xF0FF,0xF0A2,0xEE0E,0xE9EB,0xE631,0xE77B,
	0xE7B7,0xEA22,0xF0AA,0xF802,0xFFF2,0x0733,0x0D87,0x1290,
	0x14FD,0x12EF,0x0FCF,0x0C88,0x0B4A,0x0BB6,0x0C7B,0x0D30,
	0x0CFD,0x0AF2,0x0788,0x02B5,0xFD1A,0xF780,0xF1D5,0xED59,
	0xEA2B,0xE93B,0xEA9A,0xEDE0,0xF111,0xF43C,0xF767,0xF99F,
	0xFB77,0xFC8C,0xFE28,0x001E,0x02FE,0x0690,0x0AA1,0x0E55,
	0x1118,0x1304,0x130C,0x1091,0x0C9C,0x084F,0x0471,0x0100,
	0xFD8E,0xFB9C,0xFA22,0xF924,0xF85E,0xF6D3,0xF4F4,0xF2E7,
	0xF0C3,0xEFB5,0xF031,0xF193,0xF41D,0xF747,0xFA98,0xFC98,
	0xFF88,0x02A5,0x0562,0x0766,0x0783,0x062C,0x05C7,0x06CC,
	0x07BB,0x07F6,0x0758,0x0668,0x051A,0x0328,0xFFE2,0xFC00,
	0xF93C,0xF721,0xF35C,0xF187,0xF21F,0xF2BA,0xF135,0xEB2A,
	0xDE27,0xC94E,0xBF5C,0xC042,0xBFC1,0xC087,0xC153,0xC458,
	0xFA35,0x36B0,0x3E97,0x3DA6,0x3E22,0x1F80,0xFF77,0xFC6A,
	0x1296,0x3637,0x413A,0x3F61,0x3FD6,0x3F04,0x4000,0x36AC,
	0x16CD,0xF9C7,0xE230,0xD24A,0xC981,0xC5D2,0xC6ED,0xCD67,
	0xDA76,0xEB76,0xF9B1,0xFCB0,0xF25F,0xDEFB,0xCD4C,0xC990,
	0xDAFF,0xFE1C,0x2A37,0x4002,0x3FDA,0x4055,0x4065,0x3F42,
	0x2F11,0x1D30,0x142B,0x12D9,0x169F,0x1ACD,0x1ADE,0x1583,
	0x0A85,0xFC96,0xEDD6,0xE106,0xD5D2,0xC9D6,0xC10D,0xC0E4,
	0xC161,0xCE39,0xE653,0xFF32,0x127E,0x1B2E,0x196D,0x1087,
	0x0783,0x04A7,0x0A6B,0x16E5,0x2689,0x35AD,0x3E3C,0x3FB8,
	0x3844,0x27AC,0x1562,0x03B2,0xF584,0xEC90,0xE7C7,0xE407,
	0xE214,0xE15B,0xE28C,0xE500,0xE773,0xE7A0,0xE57B,0xDEB1,
	0xDABC,0xDD92,0xE45D,0xF1D5,0x02AE,0x13D0,0x21BD,0x29B8,
	0x2B39,0x26CE,0x1E7B,0x1545,0x0E6B,0x0C61,0x0E95,0x1197,
	0x12B4,0x107B,0x0A3D,0x01A3,0xF721,0xED7C,0xE59F,0xDECE,
	0xDA22,0xD810,0xD9CD,0xDFC1,0xE7CE,0xEFAE,0xF78B,0xFE53,
	0x02C9,0x03D9,0x02ED,0x027C,0x045D,0x0900,0x1051,0x193C,
	0x20B5,0x2466,0x2340,0x1DAE,0x1547,0x0B74,0x0196,0xFA5B,
	0xF6FA,0xF4DF,0xF3F4,0xF302,0xF186,0xF05B,0xEE19,0xEB91,
	0xEA01,0xE956,0xE96F,0xEA56,0xED73,0xF535,0xFD77,0x0568,
	0x0CCD,0x12B1,0x1640,0x170C,0x1533,0x122A,0x0F64,0x0DD8,
	0x0D8B,0x0E5D,0x0F84,0x1010,0x0DA7,0x083F,0x0130,0xFA7C,
	0xF4A0,0xF09F,0xEE8C,0xECC3,0xEB6A,0xEBA8,0xEDB6,0xF101,
	0xF558,0xF906,0xFABF,0xFBB7,0xFCE2,0xFE6E,0x0080,0x0342,
	0x0735,0x0B38,0x0F4C,0x11B2,0x1357,0x134B,0x0FE8,0x09FF,
	0x0487,0xFF57,0xFD39,0xFD29,0xFCB2,0xFBAA,0xFA38,0xF6F8,
	0xF426,0xF260,0xF1BD,0xF12F,0xF018,0xEF6D,0xF086,0xF2FE,
	0xF69E,0xFA3E,0xFF18,0x03EA,0x0632,0x06A1,0x0679,0x06AC,
	0x05E8,0x053F,0x05CC,0x079D,0x09BD,0x0A29,0x0852,0x0509,
	0x0159,0xFD23,0xF8F7,0xF67E,0xF5C5,0xF594,0xF464,0xF2F5,
	0xF246,0xF1B1,0xEF73,0xE7A0,0xD904,0xC4D4,0xBE02,0xBEA2,
	0xBE48,0xBF9A,0xBF51,0xCC3E,0x0D56,0x3BE9,0x3C06,0x3D26,
	0x3851,0x1310,0xF6A6,0xF83E,0x1448,0x37FC,0x3EB6,0x3DC5,
	0x3E23,0x3D72,0x3D8F,0x28DE,0x08B5,0xEEB7,0xD9F9,0xCCAE,
	0xC645,0xC477,0xC612,0xCCEE,0xDABF,0xEB20,0xF82D,0xFAA9,
	0xED6F,0xDA5F,0xC8FB,0xC78A,0xDD4B,0x0564,0x3091,0x3F2B,
	0x3E4B,0x3EB7,0x3F26,0x39A2,0x247D,0x14CF,0x0EF3,0x0F70,
	0x14EB,0x1A09,0x1A34,0x1366,0x05B0,0xF5E6,0xE854,0xDCDF,
	0xD24B,0xC6E8,0xBFFC,0xBFFB,0xC1F2,0xD309,0xECBD,0x05A5,
	0x16F9,0x1CE3,0x1818,0x0DAD,0x04CF,0x02C2,0x09E0,0x185D,
	0x29A6,0x38D3,0x3EA9,0x3E7B,0x341F,0x21BD,0x0E2F,0xFCA7,
	0xF11D,0xEB7A,0xE8B7,0xE6A7,0xE499,0xE308,0xE375,0xE671,
	0xE957,0xEA59,0xE77D,0xE1CD,0xDD37,0xDDF0,0xE55E,0xF2CC,
	0x062C,0x17E6,0x24D7,0x2AE4,0x29C0,0x22F3,0x1A36,0x1235,
	0x0D71,0x0CD4,0x0FCA,0x12EA,0x133D,0x0F3E,0x0773,0xFEDE,
	0xF661,0xED34,0xE442,0xDDE9,0xDA45,0xD8A3,0xDA9F,0xE14D,
	0xEACB,0xF3FE,0xFB8D,0xFFC9,0x01A0,0x0201,0x01F5,0x028E,
	0x0503,0x0A96,0x12AC,0x1ADD,0x20B8,0x2301,0x205D,0x195F,
	0x0FED,0x06E3,0x012A,0xFC03,0xF705,0xF3A1,0xF1F4,0xF0A5,
	0xEF9C,0xEE64,0xED66,0xEBF4,0xEA02,0xE919,0xE918,0xEB20,
	0xEFBC,0xF562,0xFC0D,0x0479,0x0CB2,0x1215,0x144F,0x1443,
	0x120C,0x0F33,0x0D6E,0x0DA8,0x0F2D,0x0FD9,0x0EDD,0x0C73,
	0x0919,0x04E4,0xFFBD,0xF9F8,0xF499,0xF09C,0xED99,0xEACC,
	0xEA5F,0xEC13,0xEF8C,0xF330,0xF651,0xF8DE,0xFB35,0xFC8A,
	0xFD7A,0xFEBD,0x0142,0x0592,0x0A55,0x0DFB,0x10A4,0x1281,
	0x1249,0x106A,0x0DB1,0x0A2D,0x0685,0x0310,0x003C,0xFDE1,
	0xFBD7,0xF974,0xF786,0xF6B1,0xF605,0xF535,0xF3EA,0xF1FB,
	0xF039,0xF01C,0xF2A7,0xF646,0xFA57,0xFECE,0x0247,0x02D9,
	0x066B,0x07ED,0x0833,0x093B,0x0973,0x0988,0x0997,0x0997,
	0x0928,0x0880,0x06FF,0x04B5,0x01CD,0xFF27,0xFC84,0xF9C5,
	0xF66B,0xF34B,0xF195,0xF1AB,0xF2C2,0xF2A8,0xEF62,0xE67F,
	0xD4F6,0xC1C1,0xBF40,0xBF99,0xBF36,0xC106,0xBFAF,0xD9B7,
	0x2062,0x3F0F,0x3BF1,0x3EC8,0x3065,0x09A2,0xF6B6,0x0040,
	0x2274,0x3DCB,0x3EAB,0x3EFC,0x3EDB,0x3E8D,0x3BC2,0x2322,
	0x0482,0xEA9D,0xD622,0xC9B2,0xC3EE,0xC372,0xC804,0xD16A,
	0xE015,0xF064,0xFB32,0xF8B9,0xEA51,0xD649,0xC834,0xCE59,
	0xE9A9,0x1449,0x3997,0x3F9E,0x3F7A,0x3F44,0x3FD6,0x35CB,
	0x2243,0x154A,0x0FEE,0x10DF,0x156A,0x196A,0x1899,0x10F9,
	0x038A,0xF542,0xE73F,0xDA29,0xCE56,0xC479,0xBFE7,0xBFA0,
	0xC4C7,0xDAC6,0xF505,0x0BB8,0x18E9,0x1A83,0x13B4,0x09D5,
	0x0384,0x04A7,0x0DFB,0x1B58,0x29F2,0x367E,0x3D7C,0x3B8F,
	0x2F9C,0x1C20,0x06A4,0xF677,0xEC53,0xE6A2,0xE3BD,0xE21A,
	0xE0CE,0xE079,0xE1DC,0xE4EE,0xE6AC,0xE52E,0xE00B,0xDB27,
	0xD919,0xDC75,0xE6EB,0xF66A,0x079F,0x1796,0x22D7,0x27A2,
	0x25C9,0x1EC3,0x14EE,0x0C6F,0x0805,0x07DE,0x0ADF,0x0D95,
	0x0D80,0x098B,0x01C2,0xF889,0xEE3A,0xE480,0xDCDF,0xD7F1,
	0xD5DA,0xD63F,0xD948,0xDF29,0xE73E,0xEFD6,0xF6AE,0xFB5B,
	0xFDEE,0xFE6C,0xFDA2,0xFDE8,0x00D3,0x07A5,0x108C,0x1856,
	0x1D12,0x1E65,0x1ACE,0x1314,0x097F,0x00CF,0xF9CD,0xF4BB,
	0xF14F,0xEEF4,0xEE88,0xEE9C,0xEE56,0xEC59,0xEA2B,0xE7F6,
	0xE68E,0xE617,0xE6D2,0xEA1F,0xEF00,0xF3D4,0xFCD7,0x0488,
	0x0C26,0x120D,0x125C,0x102F,0x0D98,0x0B9F,0x0B0C,0x0B5C,
	0x0C36,0x0CEB,0x0BDF,0x094F,0x05C7,0x01F9,0xFD59,0xF796,
	0xF1CF,0xECA7,0xE967,0xE8A0,0xEA20,0xECAA,0xF036,0xF3C0,
	0xF69B,0xF88F,0xF96C,0xFADE,0xFC3C,0xFEAE,0x0190,0x055F,
	0x09CF,0x0E2A,0x10C0,0x118B,0x10B3,0x0E66,0x0BA2,0x07FB,
	0x0403,0x001B,0xFD5B,0xFB9A,0xF9D9,0xF7DA,0xF6E9,0xF67B,
	0xF58A,0xF39C,0xF12A,0xEF67,0xEEFF,0xF091,0xF343,0xF69B,
	0xFB72,0xFFCD,0x02B7,0x04DF,0x0694,0x072B,0x05B5,0x053C,
	0x05DF,0x0674,0x0722,0x0751,0x06F7,0x067C,0x0520,0x028C,
	0xFF3F,0xFC10,0xF91C,0xF6C1,0xF49F,0xF3A0,0xF3B2,0xF3D7,
	0xF1D9,0xEA1A,0xDE16,0xCC7E,0xBFF0,0xBF8F,0xBF72,0xBFC3,
	0xC179,0xC1D3,0xEBB7,0x2F88,0x3F31,0x3CD0,0x3F49,0x2856,
	0x0461,0xFB60,0x0CB6,0x2FF7,0x4096,0x3F16,0x3FB6,0x3F48,
	0x3F5F,0x39EC,0x1D7B,0xFE75,0xE666,0xD620,0xCC51,0xC6D1,
	0xC544,0xC922,0xD465,0xE4E6,0xF4CC,0xFBBC,0xF559,0xE384,
	0xD0BB,0xC8EB,0xD554,0xF539,0x214D,0x3E98,0x4017,0x4044,
	0x401E,0x4046,0x3257,0x1E9D,0x14DA,0x12F3,0x167C,0x1B3E,
	0x1C75,0x183E,0x0E16,0xFF14,0xEEED,0xE0C1,0xD615,0xCC1C,
	0xC325,0xC0BF,0xC0F8,0xCAA6,0xE099,0xF992,0x0EC7,0x1A59,
	0x1AE6,0x12FE,0x090E,0x04F5,0x0898,0x1382,0x22A2,0x3237,
	0x3CDE,0x3F9C,0x394E,0x2A61,0x1825,0x0619,0xF799,0xEE31,
	0xE8FA,0xE5E5,0xE2B9,0xE061,0xDFFD,0xE24E,0xE5A9,0xE6DE,
	0xE5AD,0xE249,0xDE4B,0xDCCE,0xE17E,0xED7B,0xFCA7,0x0E96,
	0x1FA7,0x28B2,0x2B8F,0x282B,0x1F90,0x1620,0x0F5D,0x0CFB,
	0x0D9E,0x0FAE,0x1056,0x0E34,0x096F,0x017F,0xF7F5,0xEEE9,
	0xE6A8,0xDF62,0xD9B8,0xD638,0xD62B,0xD9CA,0xE181,0xEB3D,
	0xF4BD,0xFC07,0xFFFE,0x0158,0x0094,0x0061,0x0204,0x05DB,
	0x0CC6,0x1568,0x1CFD,0x2113,0x20C3,0x1C73,0x14A2,0x0AD0,
	0x01AB,0xFB0F,0xF773,0xF4F3,0xF273,0xF02F,0xEE1A,0xECA5,
	0xEB94,0xEAD3,0xEA73,0xE9E9,0xE967,0xE925,0xEAC2,0xEEF7,
	0xF5C9,0xFE33,0x070E,0x0EE3,0x1667,0x18B2,0x16D1,0x121C,
	0x0DEF,0x0BCC,0x0C38,0x0DFC,0x0EFE,0x0E89,0x0BF3,0x06EB,
	0x00BA,0xFA92,0xF4D4,0xEFE6,0xECD5,0xEB74,0xEC18,0xEC06,
	0xECC1,0xEEB4,0xF10A,0xF4BD,0xF922,0xFC4F,0xFE06,0xFF1C,
	0xFF99,0x011C,0x0481,0x09BE,0x0EDA,0x1235,0x1260,0x117B,
	0x0F9B,0x0C20,0x073A,0x028A,0xFF25,0xFC8F,0xFAA3,0xFA58,
	0xF9DF,0xF7D4,0xF4D6,0xF2C9,0xF0CC,0xEFCA,0xF0B0,0xF181,
	0xF2B6,0xF4B5,0xF782,0xFA15,0xFD99,0x017E,0x052A,0x079E,
	0x07C9,0x077D,0x065B,0x0597,0x0578,0x0625,0x070D,0x074E,
	0x069A,0x03ED,0x0074,0xFC9A,0xF949,0xF654,0xF381,0xF1D6,
	0xF197,0xF208,0xF2E2,0xF247,0xEE93,0xE6C7,0xD9F4,0xC723,
	0xBE1A,0xBE89,0xBE22,0xBF2C,0xBF75,0xC4B0,0xFEDD,0x38AA,
	0x3C7E,0x3CB6,0x3A5D,0x1853,0xF95B,0xF66F,0x0DBA,0x31C4,
	0x3EDA,0x3DCC,0x3E72,0x3D7D,0x3E33,0x2E75,0x0D52,0xF255,
	0xDDB6,0xCFC3,0xC768,0xC309,0xC369,0xC9E1,0xD7C1,0xE934,
	0xF7A2,0xFAE1,0xEFFB,0xDB06,0xC7A6,0xC563,0xD972,0xFBBE,
	0x293D,0x3E85,0x3E1B,0x3E68,0x3F37,0x3AEB,0x26AD,0x16F2,
	0x1048,0x10A6,0x15CE,0x1A2E,0x1948,0x126D,0x0667,0xF8CC,
	0xEBC1,0xE094,0xD5CE,0xCA24,0xC10A,0xBFFB,0xC0AE,0xCEB6,
	0xE7D4,0x0140,0x1448,0x1C48,0x19C5,0x0F92,0x0577,0x0212,
	0x076B,0x147A,0x2522,0x34D3,0x3DF6,0x3E75,0x347E,0x2274,
	0x0F58,0xFF6E,0xF3CB,0xEC3C,0xE774,0xE3B7,0xE0DB,0xDF66,
	0xE058,0xE413,0xE7F7,0xE8E3,0xE5AE,0xE01C,0xDBC2,0xDBC6,
	0xE222,0xEFBB,0x01D1,0x13E5,0x21FE,0x2877,0x26FA,0x2202,
	0x18F1,0x102D,0x0AF1,0x09C3,0x0C90,0x1000,0x10D6,0x0D13,
	0x05C5,0xFCAE,0xF352,0xEB0A,0xE446,0xDEDD,0xDA55,0xD7B3,
	0xD6EC,0xDAD2,0xE494,0xEFA1,0xF895,0xFE99,0x01E6,0x01E4,
	0xFFEB,0xFFB5,0x0263,0x0849,0x108F,0x1893,0x1F28,0x2222,
	0x2095,0x1AA3,0x11D7,0x0844,0x005C,0xFA85,0xF68E,0xF4D3,
	0xF33A,0xF30F,0xF0AA,0xED71,0xEBEC,0xEAB8,0xE9D3,0xE8B8,
	0xE845,0xE92A,0xEBD6,0xF0E4,0xF956,0x032F,0x0BE3,0x123D,
	0x152F,0x146F,0x11E2,0x0EFB,0x0D07,0x0CB4,0x0D44,0x0DDD,
	0x0E45,0x0D50,0x0A99,0x06BD,0x0155,0xFAF0,0xF40F,0xEF0B,
	0xEBC7,0xEA8C,0xEB7E,0xED58,0xEFF9,0xF30B,0xF642,0xF941,
	0xFB51,0xFCF1,0xFDD5,0xFE71,0x0013,0x043F,0x0929,0x0DB5,
	0x1169,0x132B,0x1339,0x113C,0x0DC2,0x0A36,0x06EA,0x0388,
	0x0067,0xFD3B,0xFACA,0xF946,0xF823,0xF708,0xF5C5,0xF4B8,
	0xF36A,0xF155,0xEFB9,0xEF75,0xF10A,0xF469,0xF8A7,0xFCF8,
	0x019D,0x0532,0x06EE,0x0799,0x07BA,0x0779,0x058E,0x0745,
	0x08C1,0x0903,0x09BD,0x0878,0x060F,0x02E5,0x0019,0xFD60,
	0xFADB,0xF907,0xF715,0xF468,0xF245,0xF1B2,0xF269,0xF329,
	0xF377,0xF12F,0xEB27,0xE233,0xD6A3,0xCC02,0xC629,0xCA06,
	0xDA33,0xF500,0x1315,0x29F0,0x313E,0x282D,0x15DC,0x0579,
	0xFDD3,0x022A,0x0F69,0x1EED,0x2A73,0x2E03,0x2998,0x1FDC,
	0x1475,0x0821,0xFB9B,0xF154,0xEA1B,0xE5C5,0xE383,0xE26B,
	0xE414,0xE9E0,0xF222,0xF9E6,0xFDEC,0xFCFD,0xF780,0xEF64,
	0xEA06,0xED42,0xF98F,0x0CFD,0x2053,0x2BCD,0x2EDA,0x29D4,
	0x1F96,0x1449,0x0B5D,0x073A,0x05DD,0x05F6,0x06D6,0x0708,
	0x0660,0x02CF,0xFC59,0xF5CB,0xF164,0xEEB7,0xEB23,0xE6B4,
	0xE4D1,0xE528,0xE84D,0xF0B9,0xFCB8,0x07F0,0x0EAC,0x0F02,
	0x0A77,0x0593,0x0362,0x043C,0x078B,0x0C2D,0x1201,0x16A4,
	0x1812,0x1697,0x1102,0x08D6,0xFFAA,0xF81E,0xF408,0xF2AC,
	0xF137,0xF068,0xF0A4,0xF120,0xF2C6,0xF4EC,0xF6A0,0xF665,
	0xF4C7,0xF338,0xF298,0xF415,0xF7A2,0xFD5D,0x0553,0x0BAC,
	0x1020,0x115C,0x0F59,0x0B03,0x05E6,0x0253,0x0107,0x0124,
	0x0182,0x0214,0x01EA,0x0080,0xFDBA,0xF9E9,0xF559,0xF0EE,
	0xEDE0,0xEC46,0xEBF0,0xED7B,0xEF9F,0xF1E8,0xF4C0,0xF891,
	0xFCC3,0xFF18,0xFFDC,0xFF71,0xFEC1,0xFF81,0x015A,0x03B1,
	0x067A,0x088B,0x09B7,0x0AA9,0x08F0,0x05B4,0x020E,0xFE3A,
	0xFAEB,0xF861,0xF76B,0xF732,0xF722,0xF679,0xF55D,0xF463,
	0xF2F8,0xF230,0xF0F9,0xF089,0xEFAE,0xEEC8,0xEE69,0xEEC6,
	0xF006,0xF1E0,0xF39B,0xF4B1,0xF494,0xF687,0xF4D2,0xF2CC,
	0xF2FE,0xF2CA,0xF311,0xF2F3,0xF2B3,0xF1ED,0xF0D3,0xEF4F,
	0xEE5B,0xED05,0xEC45,0xEB69,0xEB1B,0xEAA0,0xE9EF,0xE9D5,
	0xE9E5,0xE95D,0xE8DD,0xE8B1,0xE874,0xE8AE,0xE8B9,0xE8A6,
	0xE88A,0xE83C,0xE83B,0xE86E,0xE871,0xE876,0xE8A9,0xE833,
	0xE7D8,0xE75A,0xE744,0xE779,0xE72C,0xE72E,0xE78B,0xE7C2,
	0xE77D,0xE770,0xE76F,0xE70E,0xE74B,0xE7C4,0xE7FF,0xE835,
	0xE8FE,0xE950,0xE9BD,0xE9EF,0xEA79,0xEAF1,0xEB60,0xEC1A,
	0xECB7,0xED44,0xEDAB,0xEDE3,0xED8E,0xEBFB,0xEB94,0xED12,
	0xED99,0xED99,0xEDD8,0xEE2A,0xEE48,0xEE83,0xEEE4,0xEF45,
	0xF050,0xF0D0,0xF159,0xF1F3,0xF27D,0xF31B,0xF3BC,0xF459,
	0xF407,0xF495,0xF618,0xF71A,0xF750,0xF821,0xF8DD,0xF934,
	0xF9DB,0xFA81,0xFAD0,0xFB94,0xFBFA,0xFC5C,0xFCE3,0xFD38,
	0xFD49,0xFDA0,0xFE33,0xFE72,0xFE81,0xFE8E,0xFF3E,0xFEEF,
	0x005C,0x00E1,0x004B,0x00CD,0x0115,0x012F,0x01C1,0x026A,
	0x02F4,0x037C,0x03B7,0x045F,0x0566,0x0647,0x068E,0x077E,
	0x07A7,0x07CE,0x07E1,0x082A,0x08A4,0x08C3,0x0904,0x08E8,
	0x08F0,0x08BD,0x08B9,0x0923,0x098D,0x09AE,0x09C3,0x099F,
	0x0A12,0x0A4B,0x0A3F,0x0A60,0x0AC1,0x0ABD,0x0AC6,0x0B55,
	0x0BBD,0x0BAC,0x0C30,0x0C5F,0x0C50,0x0C95,0x0CAC,0x0C8F,
	0x0C74,0x0CBC,0x0CE4,0x0C99,0x0C64,0x0CAE,0x0CDD,0x0C8B,
	0x0C61,0x0C54,0x0CC5,0x0CB4,0x0CDA,0x0D20,0x0CDB,0x0D03,
	0x0D1E,0x0D92,0x0D64,0x0D42,0x0DC0,0x0DF6,0x0D9B,0x0D29,
	0x0D43,0x0D6E,0x0DCE,0x0DCE,0x0EE0,0x0D6F,0x0D6E,0x0E9F,
	0x0D95,0x0DD1,0x0E5A,0x0DFC,0x0DFD,0x0DED,0x0DC7,0x0DC3,
	0x0DB4,0x0DC5,0x0DC8,0x0DDC,0x0DB6,0x0DB0,0x0DC4,0x0DCD,
	0x0DAC,0x0D6B,0x0D5F,0x0D6E,0x0D3A,0x0D1A,0x0D2F,0x0D10,
	0x0CA0,0x0CC7,0x0CEF,0x0CB6,0x0CC7,0x0C99,0x0C88,0x0C96,
	0x0C30,0x0C42,0x0CB9,0x0CB5,0x0C73,0x0C8A,0x0CEB,0x0CF9,
	0x0C9E,0x0C1D,0x0BB5,0x0BCE,0x0C0B,0x0BF8,0x0BF3,0x0C0F,
	0x0BCD,0x0BB2,0x0B9B,0x0B76,0x0B7C,0x0BB5,0x0B52,0x0B3F,
	0x0B29,0x0BAE,0x0C05,0x0DB5,0x0DA4,0x0DA9,0x0D9B,0x0CFA,
	0x0CC0,0x0C8D,0x0C3A,0x0BE9,0x0BB5,0x0B79,0x0B75,0x0B70,
	0x0B75,0x0B4E,0x0AFF,0x0AAC,0x0A4D,0x0A63,0x09ED,0x09E4,
	0x0A99,0x0A42,0x0931,0x08D0,0x097D,0x0919,0x08E0,0x08AE,
	0x08A3,0x0845,0x0809,0x080D,0x082C,0x07BB,0x07E0,0x07BE,
	0x07C4,0x079B,0x07ED,0x07CD,0x077B,0x077C,0x0714,0x073D,
	0x064F,0x05F0,0x06EF,0x0739,0x0706,0x0702,0x06C2,0x0663,
	0x05FE,0x0617,0x05E2,0x055E,0x04B4,0x047A,0x03DE,0x02E1,
	0x03A6,0x0402,0x041C,0x03EA,0x03FA,0x0353,0x038A,0x0358,
	0x030A,0x0304,0x02E8,0x02E6,0x02ED,0x02E0,0x02FC,0x0300,
	0x02C7,0x02DE,0x031F,0x0320,0x02F8,0x02BC,0x02DA,0x02B4,
	0x02D0,0x02AF,0x02F5,0x0282,0x025D,0x023A,0x02A2,0x029C,
	0x024C,0x0220,0x0220,0x02A9,0x028B,0x0232,0x020B,0x021E,
	0x01F3,0x0218,0x0218,0x01E9,0x01D7,0x018C,0x0162,0x0135,
	0x0133,0x0199,0x0147,0x0127,0x00E0,0x0107,0x0195,0x016A,
	0x0160,0x0196,0x01EA,0x0162,0x0208,0x0343,0x0117,0x018E,
	0x0162,0x0132,0x0183,0x019E,0x0179,0x0170,0x013F,0x0154,
	0x0168,0x0169,0x018A,0x0132,0x0120,0x00EB,0x0103,0x0121,
	0x0170,0x014D,0x0168,0x013B,0x013F,0x0140,0x0109,0x00A3,
	0x007B,0x00C5,0x00C3,0x00EB,0x00FC,0x0123,0x0104,0x00C9,
	0x00E6,0x0144,0x00D5,0x00A3,0x0092,0xFF9A,0xFFF5,0x0078,
	0x018E,0x0207,0x01FA,0x0121,0x00DC,0x012F,0x01A9,0x0358,
	0x0592,0x072D,0x082E,0x095C,0x09F5,0x0A7B,0x0AAD,0x0AB2,
	0x0ABD,0x0B1E,0x0B74,0x0BE0,0x0B7E,0x0ACE,0x0ADD,0x0C83,
	0x0C02,0x0CCD,0x0F2D,0x0DEA,0x0CBB,0x0C4B,0x0CF7,0x0E42,
	0x0FD1,0x10C7,0x1154,0x11F0,0x1226,0x1200,0x1259,0x12C6,
	0x1313,0x1397,0x14A5,0x1603,0x16D1,0x1654,0x15AE,0x154C,
	0x160C,0x16D3,0x1755,0x17CC,0x182B,0x1757,0x1663,0x161C,
	0x1663,0x168E,0x16BA,0x1659,0x1661,0x1699,0x1696,0x16A5,
	0x1675,0x1610,0x163E,0x165F,0x16F8,0x1799,0x1733,0x15C6,
	0x1515,0x14CE,0x14A7,0x1515,0x14DA,0x1485,0x13D9,0x12C0,
	0x126A,0x1294,0x123B,0x1282,0x1247,0x1219,0x136B,0x1213,
	0x10F6,0x10ED,0x10ED,0x10AA,0x1033,0x0FD3,0x0F3A,0x0E57,
	0x0DD6,0x0D9B,0x0D28,0x0CD3,0x0D28,0x0CBC,0x0BEF,0x0AD2,
	0x099B,0x08B7,0x0889,0x0912,0x088A,0x07DE,0x0811,0x06E9,
	0x055E,0x04CD,0x03DA,0x03D7,0x03CB,0x0414,0x03C4,0x036E,
	0x027A,0x0178,0x0031,0xFE7C,0xFB6E,0xF6FC,0xF0F6,0xE978,
	0xE0EE,0xD84D,0xD243,0xD21F,0xDD03,0xF29E,0x09DF,0x1B5E,
	0x2345,0x218B,0x19DD,0x10E4,0x0AF5,0x09BF,0x09E8,0x09F7,
	0x08BA,0x0738,0x05AC,0x0520,0x0413,0x0214,0xFECF,0xF99F,
	0xF225,0xE831,0xDD7B,0xD442,0xCF4F,0xD22A,0xDC7F,0xEAAB,
	0xF7FD,0x00F3,0x03A4,0x023D,0xFF43,0xFDBB,0xFE03,0xFEA3,
	0xFF49,0xFFFF,0x010E,0x01E4,0x026D,0x0246,0x01BD,0x0054,
	0xFD5D,0xF807,0xF09B,0xE724,0xDDA1,0xD640,0xD365,0xD5B3,
	0xDC53,0xE4B6,0xEBB2,0xEFDB,0xF11F,0xF0A6,0xF064,0xF0CF,
	0xF2CC,0xF533,0xF677,0xF75E,0xF881,0xFAAC,0xFD76,0xFF3F,
	0x003F,0xFFFC,0xFD06,0xF878,0xF246,0xEB1A,0xE334,0xDECE,
	0xDDCA,0xDD31,0xE1D5,0xE5CB,0xE883,0xE921,0xE90F,0xE8E9,
	0xEA0E,0xEC23,0xEEAB,0xF071,0xF144,0xF18C,0xF300,0xF70D,
	0xFB73,0xFE8E,0x003C,0x0036,0xFE69,0xFAA7,0xF5EC,0xEF89,
	0xEACF,0xE7A4,0xE6B7,0xE733,0xE8F8,0xEA67,0xE9C7,0xE82B,
	0xE6F8,0xE6FA,0xE8E6,0xEBD3,0xEDE5,0xEE8A,0xEE6B,0xEEF4,
	0xF12B,0xF50E,0xF934,0xFD44,0xFFDA,0xFFBA,0xFDBB,0xFA9C,
	0xF718,0xF4C4,0xF2B0,0xF089,0xEFC8,0xEFB5,0xEF70,0xEE5D,
	0xECF7,0xEB7E,0xEAEE,0xEB39,0xEBE1,0xECAD,0xED9C,0xECBB,
	0xEBC1,0xED13,0xEF45,0xF276,0xF627,0xF96E,0xFB67,0xFC6D,
	0xFC57,0xFA98,0xF7EA,0xF5AB,0xF44F,0xF438,0xF450,0xF4A3,
	0xF40D,0xF2C4,0xF0A5,0xEF27,0xEF63,0xEFC1,0xEF70,0xEE9D,
	0xEDAC,0xEDAC,0xEEB0,0xF015,0xF203,0xF461,0xF715,0xF986,
	0xFB19,0xFBAD,0xFBEF,0xFC00,0xFBED,0xFB13,0xFACB,0xFAC7,
	0xFA47,0xF972,0xF8A5,0xF946,0xF8E6,0xF70E,0xF5AA,0xF4A2,
	0xF365,0xF25B,0xF1CE,0xF1A1,0xF24D,0xF303,0xF4F3,0xF749,
	0xF98D,0xFB87,0xFD1B,0xFCFF,0xFD6C,0xFDD1,0xFDE9,0xFEAE,
	0xFE9D,0xFE45,0xFDD8,0xFDA2,0xFD4C,0xFD11,0xFD1E,0xFCCF,
	0xFBDD,0xFA7B,0xF88D,0xF75D,0xF6AC,0xF66C,0xF667,0xF707,
	0xF80B,0xF900,0xF9A0,0xF9C4,0xFA89,0xFB6B,0xFD0E,0xFE88,
	0xFEB3,0xFE93,0xFE95,0xFE97,0xFE80,0xFECB,0xFD80,0xF80E,
	0xEC73,0xDA39,0xC568,0xBFB4,0xC01F,0xBFCB,0xC019,0xC25D,
	0xC030,0xEACD,0x30C8,0x3FFD,0x3E61,0x3F5B,0x4049,0x3AF7,
	0x2E62,0x2D23,0x303E,0x3102,0x2EC5,0x2CBF,0x2D57,0x2E60,
	0x2A56,0x24B4,0x15F4,0xFF59,0xE37C,0xC6CC,0xBFB6,0xC03B,
	0xC010,0xC087,0xC31D,0xE4BE,0x0EBD,0x2776,0x2F62,0x2B3F,
	0x23DF,0x2079,0x2214,0x25D0,0x28D9,0x2A1F,0x2B4D,0x2E94,
	0x33DB,0x385F,0x387A,0x31E7,0x23A1,0x0E04,0xF2FA,0xD548,
	0xC10C,0xBFBB,0xC021,0xBF52,0xC581,0xDDDE,0xF1C5,0xFD37,
	0x0168,0x01DE,0x0347,0x079A,0x0D34,0x1250,0x1648,0x19CB,
	0x1F74,0x26EA,0x2FCE,0x37EE,0x3B3F,0x3680,0x2966,0x16F2,
	0x0124,0xEA8E,0xD673,0xC8DD,0xC510,0xCB72,0xD62E,0xDF39,
	0xE6E9,0xEBB9,0xED9B,0xEE7D,0xF0E6,0xF597,0xFA62,0xFEDE,
	0x03D9,0x0A02,0x1284,0x1D1A,0x27D3,0x3030,0x3475,0x3276,
	0x28D9,0x1A84,0x0AF9,0xFB9A,0xED48,0xE324,0xDEBD,0xDF3A,
	0xE1D1,0xE492,0xE59B,0xE5D0,0xE58D,0xE580,0xE614,0xE81F,
	0xEB25,0xEE87,0xF297,0xF95B,0x029D,0x0ED4,0x1A98,0x236C,
	0x2701,0x269B,0x20E2,0x1808,0x0FA7,0x066D,0xFE1D,0xF801,
	0xF3E0,0xF13D,0xEF7D,0xEE2C,0xEBA7,0xE92E,0xE708,0xE5A9,
	0xE4DC,0xE396,0xE317,0xE4DD,0xE8A9,0xEF67,0xF8D2,0x037C,
	0x0CD6,0x13AD,0x1778,0x18EC,0x1888,0x159A,0x1110,0x0BD9,
	0x0738,0x03B2,0x0077,0xFD52,0xFAEB,0xF925,0xF716,0xF40C,
	0xF03E,0xED28,0xEA3C,0xE741,0xE50E,0xE5DD,0xE8E3,0xEDA6,
	0xF474,0xFCD8,0x04EA,0x0AE4,0x0E17,0x0F75,0x103B,0x107D,
	0x0F8D,0x0DA5,0x0BF4,0x0AB6,0x0872,0x05B4,0x0385,0x01F4,
	0x009E,0xFDCE,0xF8BF,0xF43A,0xEFF4,0xED0E,0xEA19,0xE95D,
	0xEB67,0xEEFA,0xF2F4,0xF7B2,0xFD19,0x0216,0x0559,0x098F,
	0x0917,0x093D,0x0B4F,0x0B89,0x0B46,0x0B2F,0x0B36,0x0A7B,
	0x098B,0x07EE,0x0666,0x03DA,0x0066,0xFC1A,0xF7E2,0xF42C,
	0xF11E,0xEFA3,0xEEF1,0xF02A,0xF27E,0xF63B,0xF9CD,0xFC82,
	0xFE87,0xFFC1,0x010B,0x0388,0x05E6,0x0776,0x0885,0x08B9,
	0x086F,0x0625,0xFF87,0xF2DB,0xDFC2,0xC70F,0xBEE7,0xBFDD,
	0xBF31,0xC023,0xC14D,0xC2F2,0xFBFA,0x380F,0x3EEE,0x3E68,
	0x3EFC,0x3FBC,0x363F,0x2BA7,0x2DF6,0x32EB,0x352A,0x34B0,
	0x3423,0x35CB,0x3771,0x348D,0x2B2E,0x1B25,0x03A0,0xE377,
	0xC4DA,0xBE88,0xBF09,0xBF77,0xBF0E,0xC821,0xF02D,0x1500,
	0x29C4,0x2DD1,0x2803,0x20A2,0x1DD6,0x20A7,0x251E,0x2983,
	0x2C91,0x2F71,0x32F3,0x38E0,0x3DBD,0x3E4B,0x3672,0x2604,
	0x0F7C,0xF482,0xD762,0xC25C,0xBFF7,0xC0BB,0xBFE7,0xCD33,
	0xE5B9,0xF721,0x0041,0x026A,0x01DD,0x02B9,0x0684,0x0C49,
	0x117E,0x1503,0x1AE1,0x2219,0x2A3C,0x33CB,0x3B4B,0x3D73,
	0x376E,0x2A14,0x1764,0x01D1,0xEC04,0xD9A3,0xCE4B,0xCBFE,
	0xD1AA,0xDB90,0xE49F,0xEB1F,0xEE0D,0xEF94,0xF041,0xF2EA,
	0xF66B,0xFA20,0xFE7A,0x0374,0x0B56,0x1546,0x2044,0x2A71,
	0x3205,0x3549,0x32CE,0x2A4D,0x1D0C,0x0CCA,0xFCFE,0xF0AF,
	0xE8FD,0xE544,0xE5B5,0xE80E,0xE97F,0xE970,0xE96D,0xE928,
	0xE983,0xEA4F,0xEB17,0xEC8A,0xEF65,0xF575,0xFDE3,0x079A,
	0x1216,0x1C31,0x23BE,0x27D9,0x2806,0x23DD,0x1C79,0x12B5,
	0x0863,0xFFC6,0xFA8D,0xF82D,0xF66C,0xF48A,0xF219,0xEFA5,
	0xED9F,0xEBB0,0xEAB5,0xE946,0xE82F,0xE7D4,0xE9BC,0xEC6C,
	0xF351,0xFE77,0x06E0,0x0FD8,0x16FB,0x1AD7,0x1C4F,0x1B0E,
	0x1786,0x1305,0x0DDC,0x0906,0x0551,0x0324,0x01F6,0xFFD4,
	0xFCBE,0xF992,0xF621,0xF31B,0xF029,0xEC9A,0xE9C0,0xE874,
	0xE886,0xEA76,0xEF1E,0xF698,0xFEB3,0x055D,0x0ACA,0x0F27,
	0x1200,0x130A,0x11E8,0x0F9A,0x0E3D,0x0CCC,0x0B86,0x09EE,
	0x07FF,0x05F1,0x03E5,0x0134,0xFDF2,0xFA81,0xF6DE,0xF29F,
	0xEEC6,0xEC63,0xEC30,0xED78,0xEFE2,0xF335,0xF748,0xFC83,
	0x0177,0x057E,0x082F,0x0934,0x09BD,0x0C34,0x0C7B,0x0CC3,
	0x0DB6,0x0D2C,0x0B5B,0x098C,0x087F,0x0814,0x0644,0x0347,
	0xFF28,0xF9E0,0xF4A8,0xF16D,0xF072,0xF127,0xF27F,0xF3D9,
	0xF4DD,0xF81C,0xFC6A,0xFF91,0x0151,0x02BF,0x0333,0x033D,
	0x0506,0x070D,0x0901,0x09AE,0x0849,0x040B,0xFB0B,0xEC55,
	0xD734,0xC209,0xBEB8,0xBEED,0xBEBD,0xC068,0xBF88,0xCA44,
	0x0EC7,0x3C54,0x3CCB,0x3DA6,0x3EA4,0x3DF1,0x3190,0x2B4B,
	0x2E8B,0x32D3,0x3465,0x3380,0x3335,0x3346,0x32D4,0x2EFD,
	0x24AF,0x124C,0xF987,0xD8B9,0xC02B,0xBE58,0xBE43,0xBF0D,
	0xBE24,0xCE5E,0xFA19,0x1B59,0x2A7E,0x2A37,0x22B5,0x1C91,
	0x1BEF,0x200A,0x258A,0x2987,0x2C34,0x2EBF,0x32B3,0x3806,
	0x3BBD,0x3A6D,0x314A,0x201D,0x076F,0xE964,0xCAE3,0xBE77,
	0xBF2D,0xBF1A,0xBF46,0xD0AD,0xE711,0xF59D,0xFD38,0xFEDC,
	0xFEE9,0x00A6,0x04B5,0x09E5,0x0EB5,0x137D,0x1A6D,0x22CC,
	0x2C4E,0x3431,0x38FB,0x39BA,0x32E7,0x2490,0x0FDF,0xF851,
	0xE1AE,0xCFB3,0xC60C,0xC6E7,0xCFE4,0xDA74,0xE3A1,0xE87C,
	0xE778,0xE916,0xEBC4,0xEF34,0xF434,0xF8C8,0xFCC8,0x0185,
	0x0943,0x1484,0x2136,0x2C22,0x32AB,0x337C,0x2E77,0x2390,
	0x14ED,0x048E,0xF5A4,0xE9C7,0xE2A2,0xE13E,0xE382,0xE660,
	0xE742,0xE60D,0xE446,0xE38B,0xE54B,0xE7D5,0xE9F3,0xEB3F,
	0xED15,0xF227,0xFB11,0x0736,0x13FF,0x1F05,0x2601,0x279A,
	0x24F7,0x1F91,0x1786,0x0DB7,0x03D0,0xFC47,0xF7F3,0xF597,
	0xF3FA,0xF232,0xEFCD,0xED44,0xEAC5,0xE872,0xE6CC,0xE55D,
	0xE4D0,0xE4DD,0xE6C2,0xEB67,0xF380,0xFD00,0x05CB,0x0D3E,
	0x14AF,0x197B,0x1A1A,0x1745,0x1228,0x0D0F,0x0911,0x0621,
	0x03AB,0x014F,0xFE86,0xFAA1,0xF771,0xF4F1,0xF23F,0xEF90,
	0xEC56,0xE796,0xE384,0xE36B,0xE5F7,0xE99A,0xEE3B,0xF432,
	0xFC08,0x040B,0x0B23,0x0FB3,0x10A6,0x0F58,0x0DC6,0x0C59,
	0x0BCF,0x0BF1,0x0BC2,0x0A7A,0x07F4,0x051A,0x022B,0xFFC4,
	0xFCFA,0xF8F1,0xF5E5,0xF10C,0xEC43,0xE9DC,0xE99C,0xEBB3,
	0xEF50,0xF439,0xF8D9,0xFD96,0x02ED,0x06FE,0x099B,0x0ABA,
	0x0B2C,0x0C47,0x0CBB,0x0CB8,0x0D20,0x0E23,0x0D9C,0x0BC4,
	0x09DA,0x0801,0x05DE,0x0262,0xFD7D,0xF895,0xF52A,0xF285,
	0xF165,0xF1B6,0xF3BD,0xF64E,0xF8DC,0xFBAD,0xFEE8,0x0233,
	0x03DF,0x0437,0x051A,0x06E2,0x08D9,0x0A12,0x0A98,0x0B25,
	0x0AA2,0x05E2,0xFB3A,0xEAEE,0xD39B,0xC10E,0xC022,0xBFCB,
	0xBFD6,0xC1D8,0xBFC9,0xD95F,0x223D,0x3FF3,0x3E3A,0x3F4C,
	0x3FE5,0x3D7B,0x3128,0x2E60,0x31D5,0x3423,0x3436,0x33A1,
	0x33E2,0x35A2,0x35C7,0x2F6D,0x2282,0x0F11,0xF4D7,0xD177,
	0xBFF9,0xC0AE,0xBFCC,0xC0FC,0xC007,0xDA8E,0x05A9,0x20DC,
	0x2C15,0x2A3C,0x229D,0x1DB1,0x1E78,0x234C,0x27F0,0x2A79,
	0x2C58,0x304A,0x368F,0x3C46,0x3EE8,0x3B35,0x2F30,0x1B6B,
	0x0187,0xE412,0xC8C0,0xBF77,0xC061,0xBFCE,0xC41D,0xDA37,
	0xEEEA,0xFB03,0x00C1,0x0224,0x02BB,0x0514,0x092F,0x0DEE,
	0x12CF,0x1801,0x1EB7,0x26C8,0x3001,0x384B,0x3CB9,0x3B0A,
	0x31DA,0x213B,0x0B4A,0xF337,0xDDC7,0xCFA2,0xC9B9,0xCBDB,
	0xD2C6,0xDC65,0xE4A9,0xE9B1,0xED61,0xF072,0xF1EF,0xF460,
	0xF755,0xFAB5,0xFFE8,0x0703,0x1003,0x1B03,0x25D4,0x2EE7,
	0x34BB,0x3539,0x2F13,0x23C2,0x145E,0x03C8,0xF4FA,0xEA17,
	0xE47B,0xE4F9,0xE6D8,0xE778,0xE77F,0xE7DC,0xE7B9,0xE7CD,
	0xE814,0xE89B,0xEA14,0xEC5F,0xF0EC,0xF7CF,0x0162,0x0C3A,
	0x1767,0x2054,0x2606,0x2811,0x25E7,0x1F17,0x156A,0x0B05,
	0x024C,0xFAEC,0xF5CB,0xF4C1,0xF468,0xF267,0xEF8A,0xECD9,
	0xEAF6,0xE9A7,0xE811,0xE5E2,0xE473,0xE50A,0xE81C,0xEDF6,
	0xF5AC,0xFE50,0x0767,0x0F30,0x152D,0x189A,0x190E,0x16B2,
	0x11F9,0x0C4F,0x0755,0x0404,0x015F,0xFF30,0xFC9D,0xFA2B,
	0xF7CA,0xF49D,0xF12B,0xEDD2,0xEA30,0xE68E,0xE474,0xE4B1,
	0xE7BF,0xEBB4,0xEFCB,0xF531,0xFC39,0x03E7,0x0A2C,0x0DE8,
	0x0F99,0x0F93,0x0E34,0x0BCF,0x098B,0x0919,0x08A8,0x06C2,
	0x03E8,0x01AC,0xFFD7,0xFD69,0xF9D8,0xF4E8,0xF063,0xEC41,
	0xE9B5,0xE877,0xE92C,0xEB01,0xEE5A,0xF22A,0xF75B,0xFD63,
	0x026B,0x058C,0x06F3,0x07CA,0x089A,0x082B,0x09F4,0x08FD,
	0x082F,0x08F6,0x0861,0x07AD,0x06BD,0x050B,0x018D,0xFD0B,
	0xF813,0xF433,0xF196,0xF01C,0xEF56,0xEF3F,0xF04D,0xF24D,
	0xF591,0xF96C,0xFD5F,0xFF9A,0x00F8,0x01D8,0x0214,0x02C7,
	0x0548,0x074F,0x088F,0x0701,0x0082,0xF47F,0xE2E0,0xCAD9,
	0xBEFE,0xBFE6,0xBF24,0xBF9D,0xC193,0xC030,0xEB34,0x2EFC,
	0x3F2E,0x3E08,0x3EEB,0x3FCD,0x38D0,0x2C37,0x2AD8,0x2D8A,
	0x3050,0x3137,0x31C7,0x3342,0x347E,0x3260,0x2AF0,0x1BB0,
	0x063F,0xEBF3,0xCC0D,0xBF5D,0xC03D,0xBFE5,0xBF55,0xC213,
	0xE527,0x0CEC,0x231C,0x294A,0x24C4,0x1E48,0x1AE5,0x1BE4,
	0x1F19,0x224B,0x2547,0x2944,0x2EC0,0x349B,0x38CC,0x394E,
	0x3386,0x255F,0x1154,0xF7F0,0xD9AC,0xC2DD,0xBFE1,0xC093,
	0xBF93,0xC792,0xDFF1,0xF194,0xFB14,0xFDC0,0xFDEB,0xFEAD,
	0x0263,0x07DB,0x0DCC,0x12A6,0x16F5,0x1D8C,0x2699,0x308B,
	0x37B9,0x3B07,0x383C,0x2C07,0x1A0C,0x046E,0xEDC6,0xD972,
	0xCCD0,0xC921,0xCE3A,0xD7B7,0xE1AC,0xE88A,0xEB61,0xEBA5,
	0xECC1,0xEFBF,0xF416,0xF8CD,0xFCE6,0x0160,0x081A,0x11C3,
	0x1D1B,0x2818,0x303E,0x344A,0x32B3,0x2ACC,0x1E97,0x0F0C,
	0xFEAA,0xF05E,0xE749,0xE4F9,0xE651,0xE857,0xE8E0,0xE82A,
	0xE711,0xE67D,0xE6F3,0xE877,0xEACA,0xECBB,0xEE8A,0xF29C,
	0xF9FC,0x03B2,0x0E5D,0x1867,0x208D,0x25C5,0x2655,0x224C,
	0x1AB9,0x1183,0x0822,0xFFA0,0xF948,0xF61D,0xF4F0,0xF43A,
	0xF233,0xEF2C,0xEBD0,0xE9C6,0xE883,0xE7DB,0xE75C,0xE6BF,
	0xE761,0xEA7C,0xEFEC,0xF7F4,0x02BD,0x0E0E,0x143D,0x1841,
	0x1BFE,0x19DE,0x160B,0x1173,0x0C9B,0x0893,0x0536,0x0230,
	0x00B8,0xFF50,0xFC7B,0xF7B6,0xF379,0xF052,0xEE01,0xEC48,
	0xEA71,0xE898,0xE76F,0xE84A,0xEBE5,0xF1CA,0xF9F8,0x0273,
	0x08B2,0x0D32,0x0EF7,0x0E98,0x0DC0,0x0CF3,0x0B88,0x0A02,
	0x08C3,0x07CC,0x0666,0x0484,0x0154,0xFE0F,0xFA4A,0xF6CC,
	0xF2FC,0xF00F,0xED08,0xEA64,0xE863,0xE83F,0xEA2C,0xEE80,
	0xF420,0xF9C2,0xFEAD,0x0223,0x04BC,0x0660,0x068F,0x06E6,
	0x07F4,0x08E0,0x0997,0x0AA7,0x0C17,0x0A72,0x07B0,0x05A6,
	0x0317,0x007D,0xFD26,0xF96D,0xF520,0xF14D,0xEF15,0xEF40,
	0xF0F9,0xF2FF,0xF4D9,0xF805,0xFB94,0xFDD8,0xFF6F,0x000F,
	0x01FF,0x0464,0x054A,0x05D5,0x073C,0x08C1,0x084F,0x04AF,
	0xFC13,0xEEF1,0xDB2F,0xC3BE,0xBEB5,0xBF4F,0xBECB,0xBFC0,
	0xC087,0xC319,0xFCAF,0x37C5,0x3E1C,0x3D8B,0x3E4F,0x3E10,
	0x31F3,0x284F,0x2B85,0x3135,0x32B6,0x3169,0x3086,0x3204,
	0x3302,0x310F,0x28A1,0x17F1,0xFF70,0xDEB9,0xC1ED,0xBE86,
	0xBE57,0xBEF1,0xBE18,0xC702,0xF095,0x143B,0x268E,0x2930,
	0x2275,0x1B40,0x1A11,0x1EC3,0x24B4,0x2907,0x2AE5,0x2C6E,
	0x301A,0x3600,0x3B85,0x3CE9,0x35F1,0x257E,0x0CE4,0xEFA5,
	0xD087,0xBF77,0xBF17,0xBF3E,0xBEA8,0xCC89,0xE4A6,0xF4CD,
	0xFCE3,0xFE44,0xFDD2,0xFF16,0x03FF,0x0AAA,0x1065,0x1496,
	0x190D,0x1F76,0x2863,0x324E,0x39D2,0x3C06,0x36AE,0x290B,
	0x1450,0xFC36,0xE4FF,0xD2FC,0xC8EF,0xC78D,0xCE3C,0xD89C,
	0xE19A,0xE6C5,0xE846,0xE90B,0xE9C2,0xEE2C,0xF496,0xF76E,
	0xFC39,0x006E,0x0671,0x1154,0x1D82,0x2922,0x31A5,0x34C9,
	0x31BA,0x2821,0x1A42,0x0A62,0xFAA5,0xED45,0xE4C0,0xE277,
	0xE3EF,0xE6EC,0xE852,0xE77E,0xE5E3,0xE51D,0xE585,0xE782,
	0xEA4B,0xECEF,0xEF95,0xF3B6,0xFB19,0x062B,0x12AD,0x1DBC,
	0x258C,0x289D,0x272F,0x2279,0x1A88,0x116E,0x083C,0xFF9C,
	0xF96B,0xF61F,0xF535,0xF49F,0xF29C,0xEF5F,0xEBA7,0xE923,
	0xE855,0xE863,0xE7F1,0xE7E8,0xE87A,0xEB4B,0xF1FF,0xFBCB,
	0x076C,0x1132,0x1763,0x1A5C,0x1A62,0x17EB,0x13F1,0x108F,
	0x0B82,0x063B,0x0271,0x0001,0xFE42,0xFC3E,0xF98C,0xF69A,
	0xF2EC,0xEF99,0xECFB,0xEAB7,0xE76D,0xE4CE,0xE482,0xE864,
	0xEE6C,0xF599,0xFE6A,0x0550,0x09DC,0x0D29,0x0F70,0x10E2,
	0x110C,0x1008,0x0E27,0x0C7E,0x0B6C,0x0A61,0x091C,0x066F,
	0x0398,0x00BA,0xFDB0,0xFAF1,0xF775,0xF298,0xEDF4,0xEADC,
	0xEA22,0xEDB0,0xF142,0xF54F,0xFA51,0xFE2C,0x00F6,0x0428,
	0x072B,0x0985,0x0AF2,0x0BCE,0x0C76,0x0CCA,0x0CF5,0x0D7D,
	0x0DD1,0x0D13,0x0B40,0x08D6,0x055F,0x0229,0xFE0B,0xF9C9,
	0xF515,0xF20E,0xF095,0xF0F4,0xF2E3,0xF61E,0xF8F3,0xFB2B,
	0xFC20,0xFD5E,0xFF5B,0x0223,0x04F4,0x0737,0x0937,0x095D,
	0x08F7,0x098C,0x09EC,0x0776,0x0023,0xF2D1,0xDF9F,0xC89A,
	0xBFBA,0xC060,0xC005,0xC186,0xC041,0xD200,0x0D47,0x38FA,
	0x3EEE,0x3E95,0x4018,0x3631,0x26C6,0x2457,0x2789,0x2B01,
	0x2BDA,0x2AEC,0x2B04,0x2BFF,0x2CA8,0x29CE,0x21C4,0x11D3,
	0xFA9F,0xDE4D,0xC448,0xBFAC,0xC088,0xC101,0xBFA0,0xD859,
	0xFC66,0x13BB,0x2098,0x2233,0x1CF5,0x17D2,0x1731,0x1A87,
	0x1ECD,0x21FB,0x2420,0x2783,0x2C5B,0x3164,0x3404,0x321B,
	0x2A3C,0x1B2C,0x0586,0xECE9,0xD418,0xC287,0xC00D,0xBFB1,
	0xC6DF,0xDA5E,0xEBAF,0xF6E0,0xFC11,0xFD34,0xFE2D,0x00A0,
	0x03FE,0x076C,0x0A9B,0x0EA3,0x146D,0x1C14,0x2548,0x2D75,
	0x3150,0x2FFF,0x290E,0x1D10,0x0CEC,0xFA3F,0xE849,0xDA60,
	0xD23E,0xD18E,0xD79D,0xDFE0,0xE6CE,0xEA75,0xEB8B,0xECAD,
	0xEEF9,0xF225,0xF54A,0xF8B6,0xFCDB,0x011C,0x088A,0x12A0,
	0x1D07,0x25E6,0x2AFD,0x2B71,0x26E6,0x1F44,0x146A,0x06CC,
	0xF9D3,0xEFA2,0xEA25,0xE995,0xEA39,0xEAE1,0xEAC6,0xE9EF,
	0xEA52,0xEA46,0xE9FD,0xEB1D,0xECC2,0xEDC2,0xF013,0xF509,
	0xFCDE,0x05C3,0x0F4F,0x171A,0x1CD0,0x1F58,0x1E1B,0x1980,
	0x11FB,0x0A1F,0x028E,0xFCBA,0xF8B2,0xF5CD,0xF445,0xF312,
	0xF04D,0xED8E,0xEC7B,0xEC9C,0xEB80,0xE9CA,0xE81F,0xE7E4,
	0xEA3A,0xEED5,0xF52E,0xFC64,0x036B,0x09A3,0x0E9D,0x1185,
	0x1261,0x119A,0x0DBD,0x08F4,0x0502,0x0221,0x0004,0xFE44,
	0xFC2F,0xF976,0xF6B5,0xF43E,0xF2C3,0xF0D4,0xEDC9,0xEA4A,
	0xE806,0xE75B,0xE911,0xEC89,0xF062,0xF4FF,0xFA53,0xFFD9,
	0x0511,0x0974,0x0BE8,0x0C10,0x0A9B,0x08E6,0x07C2,0x06EC,
	0x0523,0x0357,0x0243,0x01C0,0x00BF,0xFE4B,0xFA6C,0xF636,
	0xF2A4,0xEFF0,0xEDE1,0xED05,0xECFA,0xED2A,0xEEBA,0xF13E,
	0xF580,0xFB2E,0xFF7A,0x021A,0x03B5,0x0590,0x06B6,0x06E3,
	0x065B,0x0671,0x069A,0x06A8,0x06A0,0x099B,0x0774,0x0310,
	0xFFF6,0xFC7E,0xFA4B,0xF930,0xF7F3,0xF578,0xF350,0xF140,
	0xF0C8,0xF256,0xF60C,0xFA25,0xFDC0,0xFFBF,0x0078,0x01D2,
	0x0291,0x035D,0x04AB,0x0631,0x07B0,0x08A6,0x0893,0x06D0,
	0x0375,0xFE38,0xF86A,0xF21A,0xECB3,0xE96D,0xE975,0xED3D,
	0xF491,0xFCA6,0x0333,0x079A,0x08BE,0x07BA,0x0651,0x053F,
	0x04F8,0x04F3,0x0587,0x0773,0x0988,0x0BAC,0x0D5A,0x0D84,
	0x0C6C,0x0A28,0x074C,0x03DA,0xFF0B,0xF936,0xF3FD,0xF0CF,
	0xF0B6,0xF315,0xF6F3,0xFAC0,0xFD81,0xFD96,0xFD38,0xFE22,
	0xFEBE,0xFF36,0xFED7,0xFEBB,0x0064,0x02E7,0x0520,0x0702,
	0x082A,0x08E8,0x09E8,0x093D,0x0738,0x0407,0x00E5,0xFD8A,
	0xF989,0xF773,0xF76D,0xF73A,0xF6FE,0xF747,0xF77E,0xF720,
	0xF663,0xF56F,0xF488,0xF41E,0xF315,0xF2DA,0xF393,0xF47D,
	0xF629,0xF86C,0xFA14,0xFAEE,0xFB7B,0xFB32,0xFABF,0xF8FC,
	0xF700,0xF5FA,0xF383,0xF160,0xF08D,0xF0DE,0xF0BB,0xF0F7,
	0xF0A7,0xEFEE,0xEF79,0xEF18,0xEEF3,0xEEA9,0xEE2A,0xEE61,
	0xEE31,0xED73,0xED76,0xECC4,0xEC8F,0xECA3,0xEC25,0xEC36,
	0xEC13,0xEB13,0xE9D4,0xE97F,0xE932,0xE8FD,0xE909,0xE8D8,
	0xE8DF,0xE8C0,0xE8A0,0xE841,0xE837,0xE79F,0xE75C,0xE733,
	0xE732,0xE784,0xE7BF,0xE7AF,0xE7F4,0xE871,0xE8CC,0xE916,
	0xE969,0xE9BD,0xEA3E,0xEA14,0xE9F5,0xEA15,0xEA0E,0xEA72,
	0xEA8E,0xEB09,0xEB53,0xEBA1,0xEBE9,0xEBFB,0xEC37,0xEC7F,
	0xED05,0xED80,0xEDD2,0xEDC8,0xEE99,0xEF15,0xEF48,0xEFCC,
	0xF07E,0xF124,0xF195,0xF1EA,0xF32E,0xF2C5,0xF2EA,0xF502,
	0xF491,0xF4D5,0xF5AE,0xF671,0xF6FC,0xF758,0xF719,0xF706,
	0xF770,0xF7BC,0xF7FD,0xF87F,0xF8A0,0xF95C,0xF9DB,0xFA07,
	0xFA79,0xFAD0,0xFAF3,0xFB70,0xFBF1,0xFC10,0xFC46,0xFCEE,
	0xFD7A,0xFDBE,0xFE05,0xFE9D,0xFEE8,0xFF23,0x000B,0x0027,
	0x00A2,0x0113,0x014D,0x0134,0x01A0,0x023D,0x02A9,0x02E3,
	0x036C,0x03B0,0x03CB,0x041B,0x049B,0x0469,0x0434,0x04FA,
	0x04F2,0x0587,0x05E0,0x065A,0x06B8,0x06D3,0x071C,0x0728,
	0x0778,0x0807,0x0909,0x0BBA,0x0BF4,0x0B85,0x0B47,0x0B76,
	0x0B5C,0x0B1C,0x0B25,0x0B4B,0x0B87,0x0C0E,0x0B9C,0x0BA3,
	0x0BD3,0x0C1D,0x0B97,0x0B6E,0x0BA8,0x0BDA,0x0B4B,0x0B5F,
	0x0C6F,0x0C32,0x0BBA,0x0BFE,0x0C27,0x0BD2,0x0C01,0x0C17,
	0x0BE9,0x0BDB,0x0BED,0x0BA6,0x0C07,0x0BFF,0x0C26,0x0BED,
	0x0C09,0x0C05,0x0BD7,0x0C8C,0x0CB0,0x0CAA,0x0CE9,0x0D1A,
	0x0BA8,0x0B14,0x0C40,0x0CC2,0x0CBD,0x0CAC,0x0C64,0x0C15,
	0x0BEE,0x0BDF,0x0BC9,0x0B91,0x0B41,0x0A8D,0x0A91,0x0A33,
	0x0A36,0x0A4E,0x0A36,0x0A10,0x099C,0x09F5,0x0A61,0x0AF6,
	0x0AC8,0x0A61,0x0A4D,0x0A58,0x0A86,0x0AA2,0x0AE2,0x0A8D,
	0x0A93,0x0A85,0x0A84,0x0A80,0x0A8C,0x0AD6,0x0B02,0x0AD3,
	0x0AFB,0x0B56,0x0B06,0x0AA7,0x0ABA,0x0B0B,0x0B56,0x0B58,
	0x0B4B,0x0ABB,0x0ACB,0x0AE0,0x0A64,0x0A60,0x0A3B,0x0A45,
	0x0A40,0x0A41,0x0A67,0x0A16,0x0A0D,0x09C8,0x0A26,0x09D8,
	0x09CE,0x0A0B,0x09EB,0x0993,0x08F2,0x0948,0x0A37,0x0A6B,
	0x0A5C,0x0A46,0x0A55,0x0988,0x09B6,0x0AFC,0x090B,0x09E3,
	0x09FE,0x0972,0x096A,0x09BB,0x0951,0x0969,0x09AC,0x0988,
	0x098A,0x0977,0x09AA,0x08FA,0x08FA,0x091D,0x0947,0x092A,
	0x0933,0x0956,0x0957,0x0901,0x0886,0x0883,0x0863,0x08D9,
	0x08E7,0x08AD,0x088F,0x0869,0x07FE,0x0828,0x0809,0x07AF,
	0x07BA,0x07B4,0x0754,0x0728,0x076C,0x0740,0x06FE,0x0716,
	0x071E,0x06A8,0x0694,0x0694,0x06A5,0x067A,0x06A5,0x0662,
	0x0665,0x0652,0x067D,0x067D,0x0635,0x05CD,0x057F,0x0599,
	0x05C7,0x05BA,0x05F3,0x05C5,0x0400,0x01E3,0x0237,0x0284,
	0x02D9,0x02E0,0x02C6,0x02EB,0x031F,0x0347,0x0323,0x02E8,
	0x030E,0x0303,0x0329,0x0328,0x0367,0x039A,0x03D7,0x03BF,
	0x0389,0x0419,0x0415,0x038C,0x0343,0x036A,0x038E,0x0375,
	0x036C,0x036F,0x0328,0x03A7,0x03BB,0x0394,0x0374,0x02F7,
	0x02E5,0x02F1,0x0311,0x031C,0x0302,0x0334,0x034C,0x0311,
	0x0488,0x043E,0x031A,0x02D5,0x02E1,0x02BE,0x02C7,0x02F8,
	0x02F6,0x032C,0x0358,0x03D9,0x040E,0x0417,0x0416,0x0456,
	0x043B,0x040E,0x03BF,0x0387,0x0337,0x0336,0x038A,0x038F,
	0x038E,0x0381,0x032A,0x033E,0x0302,0x02F7,0x034D,0x0313,
	0x029E,0x024F,0x0235,0x0279,0x0254,0x025B,0x0248,0x0212,
	0x0208,0x0204,0x01CF,0x01B6,0x01AB,0x015C,0x0132,0x0128,
	0x0104,0x0102,0x00A9,0x0081,0x0095,0x0090,0x00CB,0x01A1,
	0x02B4,0x03C6,0x0495,0x04DE,0x0558,0x05DC,0x0617,0x0625,
	0x065F,0x068E,0x065D,0x062E,0x0603,0x064F,0x06CE,0x070B,
	0x06F3,0x06ED,0x06BC,0x0715,0x0790,0x087E,0x0928,0x097B,
	0x09C5,0x0972,0x0A54,0x0BC6,0x0CDF,0x0D35,0x0D0F,0x0D11,
	0x0DA8,0x0E8F,0x0F59,0x1045,0x10E7,0x10B3,0x107F,0x1111,
	0x1244,0x1342,0x138D,0x136A,0x13D6,0x1487,0x151A,0x15BB,
	0x1631,0x16D0,0x16DF,0x16CB,0x15FC,0x1415,0x1401,0x1475,
	0x14D6,0x1511,0x1541,0x151A,0x14ED,0x14DB,0x14A9,0x150B,
	0x15A0,0x15E9,0x1536,0x148A,0x14D5,0x14E9,0x150C,0x1548,
	0x1491,0x14D7,0x14C6,0x13BA,0x1310,0x13B0,0x147C,0x1481,
	0x1489,0x140F,0x135F,0x12FE,0x127E,0x12AB,0x125C,0x1201,
	0x11C3,0x118E,0x1171,0x10BD,0x0FCD,0x0EB4,0x0E1C,0x0D09,
	0x0C7E,0x084C,0x022C,0xFD74,0xF860,0xF1F1,0xEA8C,0xE405,
	0xE22F,0xE73E,0xF1F3,0x0062,0x0EF4,0x1B37,0x24B0,0x2C64,
	0x33F2,0x3C46,0x406E,0x4087,0x3BCA,0x2F9D,0x216D,0x1266,
	0x0418,0xF819,0xEE9D,0xE749,0xE2B9,0xE1C0,0xE2D3,0xE549,
	0xE8EA,0xEE49,0xF56C,0xFD90,0x0550,0x0B90,0x0EED,0x0E93,
	0x0C33,0x0A73,0x0B16,0x0C86,0x0D94,0x0E09,0x0D7F,0x0CF8,
	0x0BD4,0x0B61,0x0B06,0x0A72,0x07C2,0x043E,0xFFC6,0xFA54,
	0xF2E2,0xEA30,0xE283,0xDDCE,0xDBD0,0xDBC5,0xDD73,0xE0D3,
	0xE4FB,0xE972,0xEFFD,0xF8E9,0x01EC,0x09F3,0x0F25,0x120A,
	0x1326,0x11A5,0x0E01,0x098E,0x0463,0xFD0A,0xF8CA,0xF37C,
	0xEC46,0xE7FF,0xE48B,0xE29C,0xE216,0xE1FA,0xE38E,0xE5E8,
	0xE7F4,0xE90B,0xE991,0xEA9C,0xEC27,0xEE83,0xF036,0xF1F9,
	0xF446,0xF630,0xF79A,0xF922,0xFB7C,0xFD7D,0xFEC1,0xFF6F,
	0xFFD0,0xFF62,0xFD06,0xF893,0xF381,0xEEC2,0xEA4F,0xE683,
	0xE2FE,0xDFDF,0xDDB3,0xDC53,0xDC81,0xDE32,0xE198,0xE5AD,
	0xE993,0xEDD1,0xF303,0xF71C,0xF9D4,0xFBE0,0xFD29,0xFD78,
	0xFD31,0xFC5E,0xFB4E,0xF989,0xF6F5,0xF41F,0xF21C,0xF029,
	0xEDFD,0xEC40,0xEC29,0xED69,0xEC74,0xEB47,0xEA82,0xEA0D,
	0xE9AD,0xE92D,0xE932,0xEA74,0xECA0,0xEEBD,0xF0BB,0xF2B6,
	0xF4A4,0xF689,0xF8A4,0xFA93,0xFCD6,0xFEAB,0xFE72,0xFDA8,
	0xFBDC,0xF912,0xF62D,0xF453,0xF1B9,0xEF5C,0xEC8B,0xE9A6,
	0xE7D9,0xE76C,0xE7EC,0xE83D,0xE8CE,0xEA05,0xECA7,0xEEE0,
	0xF12A,0xF2B7,0xF487,0xF674,0xF7DE,0xF872,0xF97B,0xF992,
	0xF8DD,0xF8E8,0xF8C9,0xF841,0xF7D5,0xF700,0xF5CC,0xF46A,
	0xF397,0xF2A0,0xF0B7,0xEEE6,0xEDDC,0xED7D,0xEC67,0xEB61,
	0xEBA8,0xEC96,0xEE06,0xEF0A,0xEF8C,0xF100,0xF2F6,0xF575,
	0xF744,0xF8AD,0xF9E2,0xFAC3,0xFAFB,0xFB40,0xFB0C,0xFA7C,
	0xF8D3,0xF74F,0xF607,0xF4B5,0xF3C3,0xF1D1,0xF06A,0xF01E,
	0xF014,0xF008,0xEFDC,0xEF94,0xF01F,0xF10A,0xF2BA,0xF3F4,
	0xF4F9,0xF577,0xF5D9,0xF67A,0xF7D7,0xF927,0xFA31,0xFA5E,
	0xF96D,0xF7E7,0xF428,0xEC4B,0xE12B,0xD680,0xCB9E,0xC061,
	0xBE38,0xBE98,0xBE76,0xBF02,0xBF3F,0xC213,0xE2AF,0x08DA,
	0x25F6,0x3ACF,0x3ED0,0x3E44,0x3F8C,0x3F1B,0x3E70,0x3E56,
	0x3EBF,0x37A4,0x154C,0xF1CB,0xD185,0xC05D,0xBF99,0xBF81,
	0xBF4B,0xBF69,0xBFD1,0xBF7F,0xC979,0xDD8D,0xF46F,0x0A57,
	0x19B2,0x1FCB,0x1E47,0x1A56,0x18B6,0x1B11,0x1FCB,0x23BC,
	0x26C2,0x28A4,0x29C5,0x2AA6,0x2A46,0x28CE,0x2591,0x2025,
	0x17F6,0x0CA9,0xFD22,0xEA6C,0xD5CC,0xC3E7,0xBFBE,0xC008,
	0xC00D,0xBFB4,0xC451,0xD120,0xDFE9,0xF223,0x07CA,0x1E6A,
	0x3316,0x3E5E,0x3F6D,0x3F52,0x3F86,0x3E8C,0x333C,0x24D6,
	0x1607,0x07BF,0xFAC3,0xEE0B,0xE229,0xD8D6,0xD453,0xD28B,
	0xD438,0xD898,0xDE37,0xE318,0xE628,0xE897,0xEA89,0xED72,
	0xF1AA,0xF6F6,0xFD52,0x03B3,0x095E,0x0EBD,0x1447,0x1949,
	0x1E2C,0x244A,0x286D,0x284E,0x249D,0x1D70,0x139F,0x087E,
	0xFC9B,0xF078,0xE65E,0xDD4D,0xD570,0xCFE0,0xCDFA,0xCF52,
	0xD348,0xDA13,0xE3FE,0xF011,0xFC91,0x0767,0x1096,0x1845,
	0x1EC9,0x20E6,0x20CA,0x1FA1,0x1DC5,0x1AB4,0x165D,0x1031,
	0x0996,0x02FC,0xFD0F,0xF938,0xF70B,0xF506,0xF396,0xF072,
	0xECED,0xEA30,0xE8B4,0xE8E5,0xE9C5,0xEB41,0xEDAD,0xF0DB,
	0xF549,0xFA3E,0xFFB0,0x05C3,0x0B9F,0x1134,0x1673,0x1B65,
	0x1EBA,0x1EFC,0x1C4B,0x16C0,0x10CB,0x0AC4,0x04BF,0xFE8A,
	0xF7BA,0xF0B2,0xEA88,0xE56E,0xE2E1,0xE36B,0xE5AE,0xE912,
	0xED4F,0xF1E2,0xF693,0xFAEA,0xFF8B,0x040E,0x084F,0x0C36,
	0x0EE2,0x0FE8,0x0F51,0x0EA5,0x0D6E,0x0C7A,0x0B90,0x0A6F,
	0x08CD,0x065C,0x02CF,0xFF3F,0xFC20,0xF8F7,0xF58F,0xF2B0,
	0xF0D0,0xEF6F,0xEE3C,0xEDEF,0xED28,0xEE15,0xF2FE,0xF656,
	0xFB2D,0x0077,0x04D7,0x0824,0x0B27,0x0E38,0x111B,0x12BE,
	0x12C7,0x10D6,0x0D9C,0x0999,0x05AF,0x0260,0xFF2D,0xFB35,
	0xF7CE,0xF513,0xF2DE,0xF1B5,0xF1B6,0xF263,0xF44B,0xF591,
	0xF6F6,0xF909,0xFBC5,0xFE7B,0x0077,0x0251,0x050F,0x074E,
	0x08A2,0x0963,0x0A58,0x0B13,0x0A91,0x0788,0xFFDD,0xF476,
	0xE6A5,0xD976,0xCA99,0xBF6B,0xBF5F,0xBF26,0xBF0A,0xBFD7,
	0xBFCF,0xC4D7,0xED8C,0x1857,0x37A7,0x3F23,0x3EAE,0x3F59,
	0x3F37,0x3FAB,0x404D,0x401E,0x3EFE,0x3E96,0x1F14,0xF362,
	0xCF93,0xC08C,0xC080,0xBFE4,0xBFDE,0xC00A,0xC08A,0xBFD6,
	0xC851,0xE2A7,0xFF72,0x17BF,0x25C7,0x2860,0x2522,0x225E,
	0x22B9,0x26D2,0x2DCC,0x33E5,0x361D,0x36D9,0x37C8,0x39AE,
	0x3B33,0x399A,0x3582,0x2E34,0x22DE,0x1284,0xFCEF,0xE45A,
	0xCAD2,0xBF04,0xBF93,0xBF0B,0xBEE4,0xBF60,0xBF53,0xC686,
	0xD933,0xF289,0x0F17,0x2C5D,0x3DD3,0x3EB3,0x3ED2,0x3EF2,
	0x3ECF,0x3EA3,0x3C80,0x2D36,0x1A91,0x0929,0xF8A8,0xEB22,
	0xDF7A,0xD55F,0xCED7,0xCC4E,0xCF2D,0xD616,0xDCA0,0xE143,
	0xE256,0xE212,0xE3BA,0xE8E6,0xF0CF,0xF91F,0xFFE6,0x0467,
	0x0950,0x102C,0x19D0,0x23B1,0x2BF4,0x3148,0x3365,0x3240,
	0x2DB7,0x2548,0x1A26,0x0BD0,0xFBFB,0xECDB,0xDFFE,0xD5C8,
	0xCCB8,0xC55F,0xC162,0xC1F8,0xC889,0xD3B2,0xE171,0xEF65,
	0xFCA6,0x07FE,0x123A,0x1B83,0x22CC,0x2793,0x28D8,0x2661,
	0x2218,0x1D3F,0x17B7,0x1158,0x0A47,0x0332,0xFDCF,0xF899,
	0xF4FE,0xF241,0xEE5D,0xEABE,0xE879,0xE386,0xE28D,0xE2C6,
	0xE3BB,0xE51B,0xE789,0xEAC2,0xEFC6,0xF69D,0xFE71,0x0709,
	0x0F35,0x1660,0x1C90,0x21BA,0x24F8,0x253B,0x229E,0x1D87,
	0x16CD,0x0E5F,0x05AE,0xFCF3,0xF4FE,0xED2B,0xE598,0xDFAD,
	0xDD84,0xDE43,0xE0A6,0xE3E4,0xE877,0xEE20,0xF443,0xFABD,
	0x0089,0x05C3,0x0A6D,0x0E2F,0x1134,0x135B,0x143B,0x13CA,
	0x1242,0x1088,0x0FB8,0x0E61,0x0C35,0x0871,0x04CE,0x00D7,
	0xFCAC,0xF89A,0xF503,0xF19C,0xEE02,0xEB76,0xEA14,0xE9F3,
	0xEB2B,0xED1F,0xEF6D,0xF2A6,0xF632,0xFC8D,0x0355,0x0918,
	0x0D61,0x1068,0x129B,0x1429,0x14AE,0x1357,0x10FB,0x0D4D,
	0x0836,0x032A,0xFF18,0xFAFE,0xF657,0xF315,0xF00D,0xEDBC,
	0xEE0A,0xEF71,0xF070,0xF0F9,0xF255,0xF4F7,0xF906,0xFD80,
	0x00B2,0x02A2,0x0454,0x0665,0x0910,0x0BDF,0x0E29,0x0E3E,
	0x0A7E,0x016E,0xF4DD,0xE7C6,0xDB3A,0xCB01,0xC01F,0xC098,
	0xC055,0xBFBE,0xC0E4,0xBFD2,0xCC4B,0xF88D,0x1F0E,0x3A83,
	0x3FC8,0x3FAF,0x4030,0x405C,0x407A,0x409B,0x3FE8,0x4038,
	0x3910,0x11C0,0xEAA8,0xCAC3,0xC0A0,0xC113,0xC095,0xC086,
	0xC0AE,0xC0F2,0xC1F7,0xD2A5,0xEC1D,0x05F0,0x1A82,0x25D8,
	0x26BB,0x2241,0x1F1B,0x20A3,0x25F0,0x2BC4,0x302C,0x32AE,
	0x33E8,0x361B,0x393A,0x3AD7,0x393D,0x3441,0x2BCC,0x2001,
	0x0F7C,0xFACB,0xE30E,0xCA6D,0xBFE3,0xC076,0xC021,0xC023,
	0xC022,0xC19E,0xCF2F,0xE39F,0xFBF9,0x1684,0x314C,0x3F7B,
	0x3F75,0x3FE3,0x3FE1,0x3FA7,0x3FF2,0x39AD,0x28BC,0x187C,
	0x07F1,0xF8C7,0xEC1A,0xE23E,0xD81E,0xD423,0xD421,0xD669,
	0xDBF7,0xE1BA,0xE5B7,0xE7CB,0xE93B,0xEAEF,0xEE25,0xF397,
	0xFA34,0x0131,0x0812,0x0EAF,0x15C6,0x1D9A,0x2584,0x2C74,
	0x31A0,0x334D,0x31CE,0x2CBE,0x245B,0x18A9,0x0A86,0xFB0D,
	0xEC1C,0xDF12,0xD4DF,0xCD53,0xC873,0xC649,0xC7CF,0xCE78,
	0xD8C2,0xE5AA,0xF3E7,0x019A,0x0D62,0x1725,0x1E45,0x23CF,
	0x26DA,0x27B4,0x262F,0x21BA,0x1C5B,0x15F7,0x0F29,0x0880,
	0x027C,0xFD20,0xF844,0xF3E8,0xF0A1,0xEDFC,0xEB3F,0xE8AB,
	0xE692,0xE593,0xE5E3,0xE5AC,0xE7EA,0xEB58,0xEEF3,0xF34F,
	0xF8F6,0x0070,0x08A3,0x10A1,0x1819,0x1E13,0x21F6,0x2344,
	0x22A9,0x2054,0x1B64,0x1445,0x0BA7,0x02BA,0xFA98,0xF2B0,
	0xEAC9,0xE500,0xE190,0xDFDD,0xDF7D,0xE0E7,0xE4F6,0xEA99,
	0xF09E,0xF65D,0xFBE9,0x0126,0x05A8,0x0A68,0x0E12,0x1070,
	0x11E9,0x127D,0x1191,0x106B,0x100E,0x0E2A,0x0A23,0x07EC,
	0x0569,0x0339,0xFFD1,0xFB04,0xF60A,0xF210,0xEEE1,0xECC5,
	0xEA7C,0xE8FE,0xE8C4,0xE9D2,0xEBF4,0xEF03,0xF309,0xF8E6,
	0xFE90,0x034B,0x0810,0x0CC0,0x10B6,0x12B8,0x1252,0x10E7,
	0x0F2F,0x0C95,0x08FC,0x054D,0x00DA,0xFBF0,0xF68A,0xF246,
	0xF019,0xEF60,0xEE70,0xEDA7,0xED7C,0xEE14,0xEFB2,0xF277,
	0xF5A9,0xF88E,0xFB25,0xFDD5,0x001B,0x02C0,0x057A,0x07E1,
	0x09D6,0x0B13,0x0B8B,0x09F5,0x04C2,0xFADD,0xED22,0xDE90,
	0xD01A,0xC1DC,0xBE59,0xBE85,0xBE2C,0xBE7E,0xBFD2,0xBE72,
	0xD11E,0x0139,0x26DE,0x3C4E,0x3E10,0x3E97,0x3F0E,0x3EC6,
	0x3ED5,0x3EB3,0x3D10,0x3F75,0x3102,0x0461,0xDE4F,0xC2DB,
	0xBF76,0xBF49,0xBF22,0xBF4D,0xBF83,0xBFA8,0xC11F,0xD458,
	0xEF8A,0x09A3,0x1D71,0x2664,0x25B7,0x213E,0x1E7A,0x217E,
	0x2831,0x2F7A,0x33AC,0x362A,0x3886,0x3B06,0x3C34,0x3BDD,
	0x391F,0x33C9,0x2AC8,0x1D2E,0x0B56,0xF4E1,0xDA6E,0xC3BE,
	0xBFA3,0xBFF3,0xBF95,0xBFCB,0xBFDE,0xC2C0,0xD1B0,0xE73C,
	0x017F,0x1E5B,0x37B6,0x3F76,0x3F23,0x3F94,0x3F7A,0x3EE5,
	0x3F87,0x36A8,0x2441,0x1358,0x0403,0xF618,0xE880,0xDCDF,
	0xD400,0xCF7B,0xD048,0xD40C,0xD9D2,0xDFD7,0xE277,0xE388,
	0xE45C,0xE7AC,0xECEE,0xF2FD,0xF956,0x0047,0x0814,0x0FCE,
	0x16C3,0x1DB2,0x2574,0x2C7D,0x321A,0x351C,0x332B,0x2CDA,
	0x222C,0x13CB,0x038F,0xF451,0xE79B,0xDBB3,0xD222,0xCAAD,
	0xC500,0xC304,0xC5B3,0xCDFA,0xDA58,0xE8B2,0xF788,0x04CD,
	0x1024,0x19C8,0x20B6,0x256C,0x282C,0x28D3,0x27EE,0x2270,
	0x1CA6,0x1670,0x0EBF,0x06DD,0x0015,0xFB7D,0xF898,0xF683,
	0xF380,0xEF46,0xEB14,0xE72F,0xE487,0xE4AF,0xE62B,0xE819,
	0xEA49,0xEC24,0xEF33,0xF447,0xFB94,0x03EF,0x0CAD,0x14F3,
	0x1C67,0x21F3,0x24D5,0x2517,0x232F,0x202F,0x1B17,0x141E,
	0x0BE5,0x027A,0xF953,0xF024,0xE7F7,0xE24A,0xDF87,0xDE9A,
	0xE000,0xE2A7,0xE682,0xEB26,0xF062,0xF5F3,0xFC56,0x030A,
	0x0906,0x0D74,0x100E,0x11AD,0x1268,0x1255,0x1177,0x10D4,
	0x1095,0x0FB0,0x0CE6,0x0922,0x0526,0x0178,0xFD95,0xF9D2,
	0xF634,0xF275,0xEF6C,0xEC20,0xE985,0xE83C,0xE8CF,0xEA50,
	0xECEA,0xF0B5,0xF78C,0xFD26,0x0180,0x07CB,0x0AC9,0x0F08,
	0x1399,0x1627,0x1730,0x1653,0x13A9,0x0ED1,0x093E,0x052F,
	0x0151,0xFD18,0xF83C,0xF48A,0xF1B8,0xEFD3,0xEE89,0xEE14,
	0xEED9,0xF0A0,0xF31E,0xF61A,0xF8CD,0xFBAC,0xFE53,0x00CC,
	0x02E6,0x054D,0x083F,0x0AFF,0x0CDD,0x0D57,0x0C82,0x0997,
	0x0301,0xF846,0xEB57,0xDE53,0xCFAC,0xC170,0xBF0E,0xBF13,
	0xBF01,0xBF42,0xC081,0xBFDD,0xDF27,0x0C98,0x2E92,0x3E5A,
	0x3E79,0x3F13,0x3F49,0x3F13,0x3EEF,0x3EC1,0x3DBA,0x3E56,
	0x274E,0xFCFA,0xD847,0xC1B4,0xC0B1,0xC028,0xC009,0xC004,
	0xC04E,0xC01F,0xC3BC,0xDA6E,0xF6DD,0x1102,0x219D,0x2663,
	0x230C,0x1EB0,0x1DE2,0x216D,0x291C,0x2FFA,0x3545,0x372C,
	0x36AB,0x380F,0x39FD,0x3981,0x3704,0x30FC,0x270E,0x187A,
	0x03B7,0xEAEE,0xD03E,0xC049,0xBF7D,0xBF63,0xBF0D,0xBF48,
	0xBF39,0xC2CE,0xD2E3,0xE8CC,0x0423,0x21CE,0x3932,0x3E41,
	0x3E97,0x3F1E,0x3EE0,0x3EDE,0x3D73,0x30BB,0x2075,0x1006,
	0xFEE5,0xEECB,0xE096,0xD608,0xCFA2,0xCC93,0xCEDD,0xD491,
	0xDA6C,0xDD98,0xDEB5,0xDFB8,0xE291,0xE77F,0xEDBE,0xF466,
	0xFA6E,0x0065,0x0666,0x0D32,0x14F7,0x1DFF,0x2699,0x2D28,
	0x313A,0x3202,0x2E87,0x269D,0x1A6C,0x0D36,0xFF38,0xF108,
	0xE3A5,0xD79A,0xCD99,0xC5C0,0xC07A,0xC031,0xC5C3,0xD037,
	0xDCEB,0xEA54,0xF809,0x0488,0x0FA3,0x1874,0x1FC1,0x2537,
	0x2830,0x27F7,0x24A4,0x1EA9,0x1767,0x1046,0x09AC,0x03CE,
	0xFEC5,0xFA4E,0xF59D,0xF135,0xED5C,0xE9E0,0xE724,0xE51D,
	0xE424,0xE32D,0xE41B,0xE655,0xE53A,0xE792,0xEC51,0xF298,
	0xFAF4,0x0442,0x0CB4,0x1414,0x1A06,0x1EB1,0x2166,0x22E3,
	0x227A,0x1F8B,0x19CA,0x1139,0x081B,0xFE70,0xF52F,0xECD9,
	0xE603,0xE1D3,0xDF36,0xDE3C,0xDECA,0xE1BE,0xE614,0xEB9B,
	0xF164,0xF79A,0xFE9C,0x0546,0x0A7F,0x0DE7,0x1025,0x11D4,
	0x1225,0x1206,0x126C,0x1282,0x1165,0x0EB8,0x0AB0,0x06D0,
	0x03C0,0x011F,0xFE04,0xFA3C,0xF602,0xF27F,0xEEA9,0xEB25,
	0xE9AA,0xE9B8,0xEAA0,0xEC73,0xEEB8,0xF30A,0xF80C,0xFD37,
	0x027B,0x0795,0x0B68,0x0EC0,0x129A,0x14A4,0x1456,0x12EB,
	0x0FBA,0x0C02,0x07F3,0x03F1,0xFFC8,0xFBAB,0xF685,0xF1AE,
	0xEE3B,0xECF0,0xED00,0xEDF9,0xEFEF,0xF170,0xF255,0xF48D,
	0xF755,0xFA6B,0xFE31,0x01EF,0x048E,0x05CD,0x0790,0x0981,
	0x0B08,0x0C79,0x0D12,0x0AE6,0x0364,0xF6CC,0xE877,0xDB36,
	0xCB97,0xBFEF,0xC019,0xBFCB,0xBFF5,0xC07C,0xC184,0xC52B,
	0xEB55,0x155E,0x3501,0x3FAE,0x3F5A,0x3FE8,0x400B,0x4038,
	0x3FEE,0x3FCF,0x3F64,0x3DC8,0x1F04,0xF4EA,0xD0D4,0xC120,
	0xC165,0xC0D3,0xC0AD,0xC0B6,0xC15F,0xC0B8,0xCA4E,0xE411,
	0xFE22,0x1545,0x2378,0x26E9,0x2435,0x20CC,0x20D8,0x24A7,
	0x2A66,0x3014,0x33B0,0x3579,0x37B5,0x3A28,0x3BBD,0x3AF8,
	0x36FE,0x2F2F,0x23A7,0x13B6,0xFF04,0xE713,0xCDDB,0xC0B4,
	0xC088,0xC04C,0xC01B,0xC07C,0xC02F,0xC80D,0xDB44,0xF328,
	0x0ED9,0x2B1A,0x3DAF,0x3FCE,0x3FB5,0x4031,0x3FD5,0x3FD4,
	0x3D6D,0x2E14,0x1B9E,0x0964,0xF93D,0xEBD5,0xE0DA,0xD7C9,
	0xD182,0xD019,0xD2E8,0xD623,0xDD26,0xE297,0xE3C5,0xE535,
	0xE780,0xEB77,0xF170,0xF7B5,0xFD4E,0x0377,0x0A1E,0x118B,
	0x1A9C,0x2389,0x2AE6,0x3024,0x3272,0x31E2,0x2E3D,0x270E,
	0x1BB9,0x0DE8,0xFE8F,0xEEC2,0xE01E,0xD542,0xCC69,0xC60A,
	0xC2A8,0xC32B,0xC8AA,0xD2DC,0xDFCB,0xEDD9,0xFBB3,0x088F,
	0x1349,0x1B74,0x2261,0x26C3,0x2821,0x266B,0x222F,0x1D41,
	0x172F,0x1076,0x08E0,0x020D,0xFCD2,0xF7F6,0xF2F2,0xEF9B,
	0xED78,0xEAEF,0xE72B,0xE387,0xE17B,0xE153,0xE290,0xE42F,
	0xE775,0xEC9B,0xF099,0xF5FF,0xFD8F,0x05EB,0x0E67,0x1644,
	0x1C7D,0x20C6,0x2391,0x24A4,0x2259,0x1D4C,0x163A,0x0EA4,
	0x0640,0xFD42,0xF47F,0xEC2A,0xE506,0xE0B5,0xDDD8,0xDCEA,
	0xDF3F,0xE436,0xE8E5,0xEE30,0xF3A1,0xF909,0xFF54,0x04ED,
	0x09F6,0x0D70,0x1017,0x114D,0x11BA,0x1105,0x0FC8,0x0E71,
	0x0D3B,0x0BA9,0x08E3,0x05FA,0x0324,0xFEDA,0xF94D,0xF558,
	0xF26A,0xEF81,0xEC9B,0xE9C7,0xE7AD,0xE718,0xE780,0xE949,
	0xEC2B,0xF070,0xF630,0xFC4A,0x018E,0x069D,0x0B64,0x0EF9,
	0x1157,0x120E,0x1207,0x10E5,0x0E94,0x0B69,0x06A7,0x00C6,
	0xFAC7,0xF58F,0xF1D1,0xF02D,0xEF67,0xEE24,0xEC8C,0xEBFE,
	0xECED,0xEEFD,0xF1EB,0xF58C,0xF8CF,0xFB8C,0xFD24,0xFED1,
	0x0179,0x0495,0x06E7,0x0772,0x084D,0x0961,0x07D2,0x00D0,
	0xF5AA,0xE9AB,0xDE88,0xD154,0xC16F,0xBE46,0xBEA7,0xBE7C,
	0xBF96,0xBE1B,0xCE29,0xF698,0x1541,0x2EDD,0x3D60,0x3DF5,
	0x3E74,0x3E86,0x3E87,0x3E96,0x3DC1,0x3EA3,0x30F9,0x0CAB,
	0xEC90,0xCF84,0xC088,0xBFB6,0xBEBD,0xBF2D,0xBF56,0xBF44,
	0xC737,0xD7BC,0xEC22,0x02B1,0x145E,0x1D88,0x1DFF,0x1966,
	0x15C8,0x16F1,0x1B98,0x21C4,0x26B4,0x28A1,0x2A11,0x2C52,
	0x2EC4,0x2FA8,0x2DFD,0x29AC,0x239B,0x1AE1,0x0E45,0xFD25,
	0xE835,0xD26C,0xC22A,0xBF9A,0xBFDC,0xBF86,0xC1EA,0xCB53,
	0xD62E,0xE518,0xF8DA,0x0F7B,0x25C9,0x388A,0x3F7B,0x3F37,
	0x3F4D,0x3FA3,0x3A81,0x2E27,0x20B5,0x12CA,0x05AA,0xFA3E,
	0xF04A,0xE705,0xDF93,0xDA61,0xD961,0xDC29,0xE16C,0xE758,
	0xEB83,0xEC72,0xE9B0,0xE8C7,0xEC31,0xF18E,0xF85F,0xFEEE,
	0x04BB,0x09A6,0x0E5A,0x13F9,0x1B68,0x221D,0x2718,0x29A7,
	0x2943,0x2544,0x1DE9,0x13BA,0x079D,0xF9EE,0xEDA1,0xE478,
	0xDCE1,0xD668,0xD1B2,0xCF9D,0xD04E,0xD5FA,0xDF66,0xEAAF,
	0xF6BE,0x01FC,0x0BB8,0x132D,0x1895,0x1C36,0x1F57,0x20C9,
	0x2049,0x1D08,0x1828,0x12B4,0x0C7F,0x0716,0x0358,0xFECC,
	0xFBD0,0xFA06,0xF799,0xF48A,0xF105,0xEDC6,0xEBBB,0xEAD1,
	0xEBB3,0xEE1A,0xF004,0xF117,0xF2CB,0xF64D,0xFBCE,0x02F2,
	0x0A14,0x10AF,0x168F,0x1B92,0x1E43,0x1F28,0x1EBA,0x1CBB,
	0x18DC,0x1369,0x0D2B,0x0681,0xFF26,0xF71F,0xEFC3,0xEABD,
	0xE7B6,0xE6E4,0xE7E4,0xEA36,0xED60,0xEFF1,0xF358,0xF882,
	0xFE74,0x036F,0x076C,0x0AB8,0x0D79,0x0F34,0x0F56,0x0EEC,
	0x0EBB,0x0F04,0x0EC6,0x0DB6,0x0B92,0x08AB,0x0501,0x01E0,
	0xFF11,0xFCEB,0xFAA1,0xF7A3,0xF3D4,0xF0C4,0xEDD1,0xECA8,
	0xED28,0xEF11,0xF0E4,0xF3E5,0xF743,0xFB23,0xFFA6,0x03DD,
	0x07CC,0x0BAC,0x0E0E,0x0FEE,0x1356,0x1257,0x0F52,0x0C19,
	0x07E8,0x0418,0x0129,0xFE6F,0xFB3A,0xF7E5,0xF515,0xF29B,
	0xF15C,0xF0E0,0xF1C2,0xF417,0xF5F1,0xF76E,0xF90C,0xFAE7,
	0xFCD3,0xFE86,0x0044,0x02D7,0x0563,0x072D,0x081B,0x0866,
	0x08D1,0x0846,0x05B0,0x01E1,0xFE11,0xF9AB,0xF495,0xED2A,
	0xE2AD,0xD75F,0xCE85,0xCB73,0xD074,0xDC85,0xEBFD,0xFA2A,
	0x04FE,0x0E91,0x1872,0x23FE,0x2F55,0x375C,0x39FF,0x364E,
	0x2CE7,0x2068,0x124F,0x053D,0xF9B0,0xEF9D,0xE866,0xE4DE,
	0xE591,0xE5DC,0xE563,0xE5D8,0xE949,0xF090,0xF9E0,0x01F3,
	0x0795,0x08CE,0x07A2,0x0585,0x0528,0x07EC,0x0C29,0x0F41,
	0x1057,0x1058,0x10F8,0x1219,0x13FD,0x16D9,0x16F4,0x14BC,
	0x12D9,0x0E8D,0x0718,0xFE82,0xF5A4,0xED60,0xE6BB,0xE2AE,
	0xE258,0xE3FB,0xE558,0xE6F7,0xEA5F,0xF106,0xFABA,0x055A,
	0x0E90,0x15BD,0x1973,0x1A16,0x1858,0x1532,0x1354,0x1252,
	0x0F3F,0x0ABF,0x0678,0x0296,0xFEFF,0xFBEE,0xF92F,0xF7BE,
	0xF6B6,0xF611,0xF548,0xF406,0xF220,0xF0F5,0xF01B,0xF03F,
	0xF261,0xF4FF,0xF646,0xF6A4,0xF734,0xF8CD,0xFB1D,0xFD78,
	0xFFFF,0x0298,0x041B,0x0423,0x03DE,0x032C,0x018A,0xFFB3,
	0xFDB0,0xFB9A,0xF9E9,0xF861,0xF734,0xF5AD,0xF3FC,0xF295,
	0xF1EE,0xF19C,0xF13E,0xF12E,0xF101,0xF08F,0xEFEB,0xEF52,
	0xEEC2,0xEDC1,0xED11,0xEC67,0xEBB7,0xEAD0,0xE9F7,0xE91F,
	0xE8A1,0xE816,0xE7FB,0xE78B,0xE6C6,0xE618,0xE5AA,0xE512,
	0xE3F6,0xE299,0xE220,0xE1CF,0xE1BC,0xE1C5,0xE224,0xE20D,
	0xE1C4,0xE263,0xE49E,0xE355,0xE446,0xE51B,0xE4C3,0xE489,
	0xE530,0xE587,0xE504,0xE4DC,0xE516,0xE555,0xE539,0xE552,
	0xE599,0xE5DC,0xE5BB,0xE632,0xE697,0xE6AE,0xE71C,0xE7F4,
	0xE831,0xE82A,0xE7E2,0xE7C6,0xE828,0xE88C,0xE980,0xEA93,
	0xEB63,0xEC6A,0xECE2,0xED5F,0xEE45,0xEF26,0xEFB4,0xF033,
	0xF046,0xF0DC,0xF0E7,0xF0E9,0xF16F,0xF22B,0xF25E,0xF2B9,
	0xF33E,0xF3CE,0xF45F,0xF4C4,0xF54C,0xF540,0xF54E,0xF600,
	0xF667,0xF6EC,0xF768,0xF7BD,0xF84B,0xF8EF,0xF990,0xFAB2,
	0xFB2D,0xFAE7,0xF9CF,0xFABE,0xFB3D,0xFB48,0xFC18,0xFC64,
	0xFCF4,0xFD6C,0xFD8A,0xFDBF,0xFE34,0xFEB0,0xFEED,0xFF9F,
	0x002B,0x0031,0x003C,0x0158,0x01BF,0x017B,0x0233,0x0366,
	0x03A6,0x0341,0x0413,0x04A3,0x04A8,0x054B,0x0609,0x0663,
	0x06F1,0x073A,0x07CA,0x0801,0x0803,0x080D,0x08A6,0x090D,
	0x0948,0x0933,0x09DB,0x0A20,0x0A41,0x0B92,0x0B71,0x0A4B,
	0x0A35,0x0A3B,0x0A74,0x0AD8,0x0B24,0x0B86,0x0B8B,0x0C1F,
	0x0CEF,0x0DAA,0x0DBE,0x0E00,0x0E45,0x0E4F,0x0E25,0x0E6E,
	0x0E52,0x0E7B,0x0E92,0x0EC4,0x0E9A,0x0EE4,0x0F0F,0x0F2C,
	0x0F22,0x0F2D,0x0EAD,0x0EDF,0x0EBA,0x0EB0,0x0E5E,0x0E4A,
	0x0E56,0x0E48,0x0F12,0x0F43,0x0EFE,0x0EC6,0x0EBC,0x0EEB,
	0x0F5B,0x0F43,0x0FB0,0x0F73,0x0F19,0x0FBB,0x0FB7,0x0F88,
	0x0F4A,0x0F61,0x0F48,0x0F46,0x0F4E,0x0F2F,0x0F14,0x0EC2,
	0x0E6E,0x0ED8,0x0F1C,0x0F12,0x0F06,0x0EC6,0x0EDD,0x0E8D,
	0x0EB4,0x0EDF,0x0EEC,0x0E92,0x0E0E,0x0E1F,0x0E4F,0x0E6B,
	0x0E7B,0x0EDC,0x0D49,0x0E6D,0x0F3C,0x0EAA,0x0E69,0x0E67,
	0x0E6C,0x0DF2,0x0DE4,0x0DC2,0x0D82,0x0DCB,0x0D97,0x0D60,
	0x0D0C,0x0D14,0x0D21,0x0CDA,0x0C70,0x0C48,0x0C02,0x0BD1,
	0x0BC5,0x0B58,0x0B46,0x0B8C,0x0B61,0x0B2F,0x0ADF,0x0B0B,
	0x0AF7,0x0A8E,0x0AB7,0x0A44,0x0A59,0x0A87,0x0A88,0x0A5D,
	0x0A69,0x0A6F,0x0A46,0x0A0A,0x0A3F,0x09EC,0x09D7,0x0994,
	0x093D,0x08B0,0x086E,0x087C,0x08C5,0x08B3,0x08A7,0x084A,
	0x082A,0x0884,0x0814,0x0814,0x0811,0x0825,0x07D1,0x0924,
	0x0B10,0x09D2,0x0979,0x098A,0x0975,0x0961,0x0978,0x0984,
	0x095A,0x08E4,0x0889,0x0840,0x086E,0x08B0,0x08A1,0x085B,
	0x086C,0x0836,0x0833,0x074F,0x07E2,0x0866,0x0790,0x06AB,
	0x06F0,0x06CD,0x0651,0x067C,0x063D,0x0634,0x0626,0x05DC,
	0x059E,0x0535,0x04F4,0x051D,0x04B8,0x04A4,0x0465,0x04A3,
	0x0486,0x046A,0x0493,0x0536,0x04F7,0x03CD,0x03D3,0x04A9,
	0x04BA,0x046D,0x045C,0x0445,0x042C,0x03B1,0x036B,0x0356,
	0x028C,0x024B,0x0220,0x0189,0x011F,0x0155,0x0147,0x0141,
	0x015E,0x0134,0x0110,0x012C,0x0144,0x016F,0x011B,0x0111,
	0x011E,0x0160,0x016A,0x0133,0x013E,0x01AE,0x01D1,0x0196,
	0x01B2,0x01F0,0x01AD,0x0171,0x0168,0x0169,0x0165,0x01CD,
	0x0215,0x0225,0x0226,0x01B8,0x0121,0x00F4,0x010B,0x0120,
	0x00F4,0x00C2,0x00EA,0x00D6,0x013B,0x013C,0x00FA,0x00B9,
	0x00C1,0x0083,0xFFF0,0xFFCB,0xFFCF,0xFF7C,0xFF9E,0xFF00,
	0xFED4,0xFF97,0xFF8C,0xFEC1,0xFED8,0xFF1D,0xFE9D,0xFE8A,
	0xFEB5,0xFEDA,0xFED4,0xFED8,0xFF0A,0xFF33,0xFEE9,0xFF0F,
	0xFF21,0xFEF7,0xFEF8,0xFE6C,0xFE88,0xFE3C,0xFDBE,0xFE52,
	0xFE7F,0xFD5E,0xFC6C,0xFD61,0xFE39,0xFE64,0xFE7E,0xFE75,
	0xFE90,0xFE5F,0xFE2E,0xFE4A,0xFD4B,0xFD00,0xFD19,0xFD19,
	0xFC55,0xFC84,0xFCE4,0xFCA4,0xFC6F,0xFC42,0xFC46,0xFC16,
	0xFC5E,0xFC68,0xFC74,0xFC72,0xFBE8,0xFBE7,0xFC5A,0xFCB0,
	0xFD14,0xFD77,0xFD94,0xFD22,0xFCCD,0xFCFC,0xFD2D,0xFD08,
	0xFCF4,0xFD4E,0xFD65,0xFD2C,0xFCD9,0xFC8D,0xFCAD,0xFCB0,
	0xFCA7,0xFCFE,0xFD27,0xFD5C,0xFD4F,0xFD0C,0xFCF8,0xFCBD,
	0xFD02,0xFD19,0xFD54,0xFD7A,0xFD70,0xFDFE,0xFDAB,0xFD9F,
	0xFD60,0xFD22,0xFDA9,0xFDA0,0xFD8D,0xFD0A,0xFD6B,0xFD7E,
	0xFD25,0xFD41,0xFDA0,0xFDBB,0xFD6C,0xFD76,0xFF4A,0xFD5A,
	0xFD92,0xFE2B,0xFDD2,0xFD9D,0xFE04,0xFE11,0xFE30,0xFE58,
	0xFDFE,0xFE06,0xFE1E,0xFE76,0xFE9A,0xFEBA,0xFECA,0xFF1D,
	0xFEDE,0xFF02,0xFED2,0xFEA4,0xFEE8,0xFF0E,0xFF27,0xFEF0,
	0xFF12,0xFF2D,0xFEDD,0xFEBC,0xFEF9,0xFF1A,0xFF4A,0xFF51,
	0xFF10,0xFEF7,0xFED5,0xFF08,0xFF62,0xFF66,0xFF36,0xFF41,
	0xFECB,0xFEBB,0xFE90,0xFE90,0xFF11,0xFF0A,0xFF1B,0xFEC7,
	0xFEF7,0xFF80,0xFFD2,0x0074,0x0155,0x022E,0x036A,0x041B,
	0x046A,0x03F2,0x0444,0x055E,0x0689,0x0794,0x06B5,0x072C,
	0x07FB,0x082B,0x0870,0x08A1,0x0906,0x0979,0x09C1,0x0A52,
	0x0A5E,0x09F3,0x0991,0x0962,0x0954,0x0A14,0x0B26,0x0CFD,
	0x0D42,0x0BA3,0x0BED,0x0DA3,0x0EBA,0x0F32,0x0FC7,0x104D,
	0x1095,0x1117,0x1137,0x1213,0x12A5,0x1259,0x120C,0x1266,
	0x1396,0x149A,0x153F,0x14C6,0x14EA,0x1553,0x1590,0x1554,
	0x15AD,0x1792,0x17D6,0x1677,0x162A,0x1684,0x16A8,0x167C,
	0x15E4,0x15B0,0x15F6,0x16B1,0x17BB,0x1878,0x17B3,0x1748,
	0x17B1,0x17E7,0x185F,0x182C,0x17B6,0x1740,0x173E,0x173D,
	0x16EF,0x16A5,0x1673,0x15C9,0x152C,0x14D3,0x1553,0x1669,
	0x15C6,0x143C,0x12BA,0x1203,0x124C,0x126E,0x1232,0x117C,
	0x1082,0x0FA3,0x0EDF,0x0F28,0x0EF4,0x0EF7,0x0E7D,0x0D8D,
	0x0CF6,0x0D64,0x0D89,0x0D67,0x0CA0,0x0BD4,0x0B03,0x0A11,
	0x0A07,0x0A47,0x0A5A,0x09AB,0x08B8,0x0766,0x06D8,0x06E9,
	0x06F4,0x06D1,0x0648,0x0513,0x0381,0x004A,0xFA42,0xF224,
	0xE9BC,0xE19B,0xD7CC,0xCC11,0xC2AC,0xC0A7,0xC2FF,0xD66C,
	0xF07D,0x0A57,0x2023,0x2EB6,0x3770,0x3D53,0x3F84,0x3F1B,
	0x3F99,0x3839,0x265B,0x12E0,0xFF0C,0xEE5F,0xE2F7,0xDCC6,
	0xDA36,0xDBBB,0xE02D,0xE6B8,0xEA41,0xEA36,0xE85A,0xE70B,
	0xE843,0xEB49,0xEEAA,0xF0B4,0xEFBE,0xEE87,0xF0E5,0xF923,
	0x061E,0x13BA,0x1EE2,0x2576,0x2759,0x2524,0x1FED,0x18B6,
	0x0E5E,0x01BA,0xF41D,0xE6F1,0xDB7A,0xD221,0xCAFA,0xC748,
	0xC6DE,0xCB07,0xD349,0xDE3F,0xE936,0xF0B2,0xF4B1,0xF6B6,
	0xF8C0,0xFB6D,0xFF27,0x033E,0x067D,0x04F8,0x0256,0x00CB,
	0x01EC,0x046A,0x0716,0x079B,0x055D,0x0176,0xFB80,0xF411,
	0xEBC7,0xE319,0xDB0D,0xD535,0xD1EF,0xD07C,0xD0B8,0xD234,
	0xD6DE,0xDD53,0xE4EF,0xEDA1,0xF7CA,0x0027,0x0582,0x076C,
	0x070E,0x05CD,0x03C0,0x0172,0xFF5F,0xFC92,0xF88D,0xF4D0,
	0xF11A,0xEDD1,0xEB37,0xE9E7,0xE8BF,0xE743,0xE588,0xE3C2,
	0xE088,0xDC44,0xDAAF,0xDB87,0xDDA1,0xE0D9,0xE511,0xE9EF,
	0xEF43,0xF476,0xF945,0xFDBE,0x0198,0x049B,0x0678,0x0654,
	0x042F,0x009D,0xFAA4,0xF41F,0xEF85,0xEC51,0xE9B4,0xE6F8,
	0xE463,0xE234,0xE158,0xE16C,0xE214,0xE36A,0xE593,0xE80D,
	0xEA4D,0xEBA3,0xEC64,0xED44,0xEEE6,0xF162,0xF4ED,0xF939,
	0xFCC1,0xFEB8,0xFFEE,0x0083,0x0116,0x0116,0xFF6E,0xFCE6,
	0xF9B0,0xF58B,0xF16A,0xECF8,0xE91D,0xE6A7,0xE54D,0xE444,
	0xE47C,0xE6A6,0xEA64,0xECFC,0xEE74,0xEFF4,0xF34C,0xF784,
	0xFAA1,0xFC83,0xFD0D,0xFDF1,0xFD6B,0xFCE7,0xFDBF,0xFF4A,
	0x0078,0x0017,0xFE2F,0xFC8F,0xFA2B,0xFA14,0xF805,0xF3FF,
	0xF28A,0xF034,0xEDFA,0xEBEE,0xEB4C,0xEB6D,0xEC38,0xECF3,
	0xEF61,0xF28E,0xF60C,0xF928,0xFBC8,0xFE2A,0xFFBD,0x01AC,
	0x0244,0x0260,0x0256,0x0140,0x0003,0xFEA6,0xFCE1,0xFB48,
	0xFA02,0xF8D8,0xF7EE,0xF651,0xF519,0xF49B,0xF463,0xF374,
	0xF29A,0xF1D4,0xF1E7,0xF246,0xF390,0xF585,0xF77E,0xF8F7,
	0xFA6C,0xFC5C,0xFE26,0x0007,0x01B8,0x02F5,0x02B0,0x00DB,
	0xFBC7,0xF1C3,0xE3C8,0xD27A,0xC25B,0xBF91,0xBFC4,0xBF53,
	0xBF8D,0xBFC3,0xC19F,0xBFA4,0xE05B,0x2161,0x3D81,0x3D50,
	0x3E7A,0x3EF6,0x3ECB,0x3EC0,0x3EAD,0x3D77,0x3EBC,0x2BDC,
	0xFFA4,0xDE0B,0xC664,0xBF74,0xBFE3,0xC031,0xCC36,0xD73F,
	0xD9E1,0xD6EE,0xD322,0xD1AD,0xD548,0xDD51,0xE424,0xE6A4,
	0xE5DC,0xE79E,0xF2C6,0x0A07,0x2BA6,0x3F35,0x3F60,0x3FDE,
	0x4005,0x4009,0x3F8D,0x3F96,0x3B56,0x1FAD,0x010D,0xE439,
	0xCA5A,0xC0D6,0xC0C5,0xC013,0xC05E,0xC066,0xC2C8,0xD80A,
	0xEEC9,0xFE38,0x0798,0x0D65,0x12E2,0x19F9,0x21CC,0x27F9,
	0x2A7A,0x29EF,0x2941,0x2B1A,0x2EEC,0x3355,0x36E6,0x3750,
	0x33AA,0x2B29,0x1C78,0x0883,0xF20C,0xDC45,0xC902,0xC0E7,
	0xC0DB,0xC08F,0xC095,0xC082,0xC379,0xD3E7,0xE8EC,0xFF87,
	0x14F2,0x266E,0x3222,0x36F3,0x370B,0x343A,0x2F4F,0x28DD,
	0x21E4,0x1B8C,0x14DD,0x0D91,0x05C7,0xFE5A,0xF90E,0xF522,
	0xF18C,0xED83,0xE86A,0xE234,0xDADD,0xD38E,0xCE5D,0xCD54,
	0xD0C4,0xD75E,0xE155,0xED27,0xFAC3,0x0834,0x14B9,0x2019,
	0x2A8A,0x32CB,0x36A0,0x3553,0x3050,0x2602,0x19D0,0x0EF8,
	0x01C7,0xF789,0xEFEF,0xE985,0xE48F,0xE119,0xDF7D,0xDEEC,
	0xE027,0xE2B7,0xE625,0xE9DE,0xEDC3,0xF0F0,0xF36D,0xF649,
	0xFB09,0x0123,0x0860,0x0F87,0x1749,0x1D8A,0x20E2,0x229A,
	0x2270,0x2065,0x1C75,0x15EC,0x0DFF,0x0514,0xFAE0,0xF0CB,
	0xE779,0xE0C3,0xDC7C,0xDB4B,0xDCC0,0xE0A2,0xE58E,0xEAC0,
	0xEF94,0xF4E8,0xFAF5,0x00EE,0x068F,0x0A8E,0x0DA6,0x0F20,
	0x1037,0x1143,0x11A4,0x11F9,0x127B,0x11A6,0x0F74,0x0CBD,
	0x0918,0x049F,0xFF2D,0xFAD3,0xF56B,0xF002,0xEC7E,0xE912,
	0xE66A,0xE541,0xE65A,0xE9D8,0xEE77,0xF491,0xFAB9,0x00F6,
	0x06A0,0x0BB1,0x0FE1,0x127C,0x13B9,0x13FA,0x128E,0x11A4,
	0x10F3,0x0DC7,0x0904,0x04BD,0x0137,0xFE3C,0xFBCD,0xF954,
	0xF697,0xF407,0xF161,0xEEF6,0xEDAA,0xEDA7,0xEE76,0xEFE7,
	0xF205,0xF4F6,0xF915,0xFCF4,0x008D,0x04DB,0x0982,0x0D87,
	0x0F5A,0x10DF,0x112B,0x0BBD,0xFEA7,0xECD9,0xD8A6,0xC472,
	0xBEAE,0xBF1D,0xBE86,0xBE7E,0xBEEB,0xC020,0xC142,0xEF86,
	0x2DB0,0x3DC4,0x3CD0,0x3DDF,0x3E09,0x3DF4,0x3DE4,0x3DA7,
	0x3CAF,0x3DC9,0x2554,0xFC57,0xE052,0xCDFD,0xC46C,0xC42E,
	0xCCA8,0xD90C,0xE230,0xE349,0xDD94,0xD717,0xD49C,0xD7AC,
	0xDE2C,0xE317,0xE2E7,0xE10D,0xE403,0xF306,0x0E9D,0x310B,
	0x3EA3,0x3DCD,0x3E70,0x3E85,0x3E84,0x3DDA,0x3E8E,0x3863,
	0x1AE6,0xFCE2,0xE095,0xC757,0xBE62,0xBEFF,0xBEA2,0xBEFC,
	0xBE6A,0xC6DB,0xDEAC,0xF15A,0xFC6F,0x0309,0x080C,0x0E48,
	0x1546,0x1C3C,0x2107,0x21DB,0x2242,0x24B1,0x2649,0x2D47,
	0x3396,0x3738,0x37A7,0x3357,0x28C9,0x189B,0x03BB,0xED31,
	0xD8D1,0xC7BE,0xC00D,0xBF73,0xBF71,0xBFE7,0xBF56,0xC4C2,
	0xD797,0xED3A,0x038F,0x177C,0x2663,0x2FFA,0x33DB,0x339A,
	0x30D6,0x2C66,0x26B0,0x215C,0x1B24,0x14B9,0x0DD2,0x0739,
	0x0118,0xFC6A,0xF872,0xF48D,0xF05D,0xEB07,0xE3D7,0xDA78,
	0xD162,0xCCD5,0xCD35,0xD1A2,0xDA0C,0xE43B,0xEFA0,0xFBD5,
	0x078C,0x144C,0x2159,0x2CDF,0x3426,0x35C2,0x332F,0x2C3E,
	0x22B0,0x1751,0x0C2E,0x01E6,0xF81E,0xED9C,0xE6B1,0xE312,
	0xE156,0xE059,0xDF7A,0xE023,0xE2AF,0xE607,0xE93B,0xEC43,
	0xEEC4,0xF167,0xF4D8,0xF98D,0x00B2,0x0989,0x1214,0x189E,
	0x1CBF,0x2052,0x22C6,0x230C,0x2117,0x1CF7,0x1619,0x0D6F,
	0x0445,0xFA2A,0xF0E2,0xE95D,0xE2F0,0xDF7F,0xDEFE,0xE041,
	0xE367,0xE885,0xED71,0xF314,0xF89A,0xFDF5,0x03E8,0x08A9,
	0x0D8D,0x1043,0x1137,0x123A,0x134D,0x1448,0x149A,0x1428,
	0x1368,0x12AB,0x106D,0x0CB8,0x07D2,0x01F7,0xFC9D,0xF7DF,
	0xF285,0xEE3C,0xEB0B,0xE8B7,0xE7EC,0xE99F,0xED9A,0xF28C,
	0xF861,0xFE5D,0x03E1,0x09FD,0x0F46,0x135A,0x1660,0x1803,
	0x1828,0x166A,0x13F6,0x116C,0x0EAD,0x0C4F,0x095F,0x05D9,
	0x021E,0xFE5F,0xFB72,0xF932,0xF767,0xF55A,0xF37C,0xF22F,
	0xF1C3,0xF236,0xF32E,0xF4E6,0xF782,0xFAF9,0x0062,0x0597,
	0x09DF,0x0D26,0x0F7E,0x110A,0x121A,0x12E2,0x10F8,0x09C4,
	0xFBA3,0xE7F1,0xD15D,0xC131,0xBFEF,0xBFB0,0xBF46,0xBF75,
	0xC0ED,0xC065,0xC95F,0x03A6,0x3765,0x3EDD,0x3EF8,0x3FFA,
	0x3F70,0x3FC1,0x3F9F,0x3F10,0x3E4F,0x3DA9,0x1F79,0xF8B8,
	0xDE0A,0xCCC1,0xC544,0xC7A0,0xD0D3,0xDBB4,0xE22E,0xE171,
	0xDBEA,0xD6B3,0xD5F8,0xDA29,0xDFBF,0xE2E4,0xE26E,0xE270,
	0xEA84,0xFDC9,0x1BCF,0x39AD,0x3F78,0x3EF4,0x3F79,0x3F7C,
	0x3F5F,0x3E75,0x3F97,0x3482,0x14A6,0xF7E4,0xDC7A,0xC50A,
	0xBF4E,0xBFC2,0xBF8A,0xC01E,0xBF89,0xCD50,0xE40F,0xF3BD,
	0xFEC2,0x060C,0x0C61,0x135C,0x1A55,0x1FA7,0x22C6,0x243E,
	0x25E8,0x2919,0x2E5F,0x3551,0x39B9,0x3C60,0x3ABC,0x344D,
	0x27FA,0x16B0,0x018C,0xEADA,0xD612,0xC5E1,0xC053,0xC052,
	0xC003,0xC059,0xC07D,0xCC07,0xDECC,0xF303,0x089D,0x1CF5,
	0x2B30,0x327E,0x3506,0x3463,0x3050,0x2B40,0x25C1,0x1FDF,
	0x1979,0x12B5,0x0B62,0x04EB,0xFFE7,0xFB4A,0xF75E,0xF2A5,
	0xECCA,0xE587,0xDD8A,0xD531,0xCEA1,0xCB15,0xCBB8,0xCFFF,
	0xD711,0xE20A,0xF01C,0xFDD5,0x0B4D,0x181C,0x2345,0x2CCB,
	0x331E,0x347A,0x30A3,0x282A,0x1D29,0x1151,0x04CB,0xFA02,
	0xF1C8,0xEA9D,0xE44F,0xDF43,0xDCB0,0xDC29,0xDCDA,0xDDF1,
	0xDFB9,0xE2B6,0xE5A9,0xE83E,0xEB53,0xEEFC,0xF332,0xF7A2,
	0xFD68,0x05A5,0x0EC6,0x167F,0x1BA1,0x1E94,0x2070,0x1FB7,
	0x1C74,0x1706,0x104A,0x0838,0xFDE1,0xF335,0xEA11,0xE2FD,
	0xDE05,0xD9F0,0xD8BE,0xDAE0,0xDEF9,0xE46D,0xEA57,0xEFD4,
	0xF4F2,0xF9F4,0xFF99,0x04FF,0x0936,0x0B7F,0x0CE5,0x0D8D,
	0x0F09,0x1047,0x112D,0x107E,0x0FA8,0x0E80,0x0C3C,0x07D1,
	0x0213,0xFC31,0xF567,0xEEBE,0xEBD8,0xE868,0xE4CF,0xE4C0,
	0xE41A,0xE521,0xE855,0xED24,0xF47B,0xFC6C,0x034D,0x0903,
	0x0CD0,0x0FEA,0x11DA,0x12F0,0x1392,0x12A0,0x1149,0x0EAB,
	0x0B11,0x07C3,0x0462,0x00C0,0xFD6B,0xFA61,0xF7F7,0xF60F,
	0xF47A,0xF277,0xEF95,0xEDCD,0xECF6,0xEE3C,0xF0B4,0xF3E7,
	0xF6FA,0xF9C3,0xFD66,0x01D1,0x068D,0x0AF6,0x0E4F,0x1038,
	0x113C,0x10EA,0x0D7A,0x047E,0xF46A,0xE09B,0xCAD8,0xBFCE,
	0xBFD3,0xBF75,0xBF66,0xBF9B,0xC166,0xBF5C,0xD1A3,0x13EE,
	0x3BCE,0x3EA9,0x3F36,0x3F76,0x3E98,0x3DEC,0x3E64,0x3D9F,
	0x3E16,0x37F2,0x11E6,0xEF7D,0xD72D,0xC753,0xC1F1,0xC699,
	0xD118,0xDBBF,0xE0FD,0xDF63,0xD898,0xD36B,0xD414,0xD8FE,
	0xDF93,0xE3C5,0xE39D,0xE3C8,0xECF6,0x01BD,0x22B8,0x3D98,
	0x3F69,0x3F7F,0x3FE6,0x3FEA,0x3FBC,0x3F0D,0x3F88,0x2DF7,
	0x0D34,0xF022,0xD3D2,0xC183,0xC084,0xC061,0xC03D,0xC0E9,
	0xC1A5,0xD31F,0xE8C9,0xF80C,0x0239,0x0833,0x0D91,0x1425,
	0x1B8F,0x2152,0x24A7,0x2674,0x2841,0x2BA9,0x3104,0x36BD,
	0x3B3F,0x3D0D,0x3AAB,0x3325,0x2656,0x13E7,0xFD0A,0xE561,
	0xD0EF,0xC374,0xC0CA,0xC0D2,0xC0D7,0xC10B,0xC1B5,0xCF20,
	0xE46A,0xFAE3,0x10D6,0x21EE,0x2CE4,0x32F4,0x3568,0x358F,
	0x323E,0x2C48,0x24C5,0x1D5F,0x1817,0x130D,0x0D5C,0x067E,
	0x0008,0xFA62,0xF638,0xF2DE,0xEE61,0xE74D,0xDDF2,0xD414,
	0xCD12,0xCB49,0xCEA6,0xD55B,0xDDC7,0xE78E,0xF30E,0x00D5,
	0x0FA0,0x1DD7,0x2939,0x30D7,0x343F,0x33FD,0x2FD9,0x28EC,
	0x1EA2,0x129E,0x06FB,0xFD16,0xF33E,0xEC07,0xE9D2,0xE510,
	0xE170,0xE068,0xE10B,0xE334,0xE58B,0xE7C6,0xE9F4,0xEC50,
	0xEF45,0xF1F3,0xF687,0xFD37,0x049F,0x0BB0,0x127A,0x1933,
	0x1F80,0x2318,0x23E5,0x227B,0x1F11,0x1911,0x112C,0x0885,
	0xFEEB,0xF4DE,0xEB42,0xE3C5,0xDF45,0xDDB4,0xDE0D,0xDFB9,
	0xE30A,0xE8A2,0xEEDE,0xF4C4,0xFA9C,0xFFFB,0x04C1,0x089B,
	0x0BD9,0x0EEF,0x1141,0x12E1,0x1388,0x13C5,0x13D1,0x1378,
	0x126F,0x105D,0x0DA6,0x096F,0x03A2,0xFD02,0xF5F1,0xF08A,
	0xECE9,0xE9E7,0xE8E5,0xE7C7,0xE6E4,0xE8F6,0xED0C,0xF29D,
	0xF958,0xFF9D,0x05A2,0x0B46,0x1084,0x143B,0x154C,0x14C3,
	0x1424,0x12EF,0x119C,0x0F9E,0x0CB7,0x07DD,0x032E,0xFFD7,
	0xFCD3,0xFAB1,0xF943,0xF708,0xF35D,0xF082,0xEF56,0xEECD,
	0xEEDD,0xEF60,0xF060,0xF30D,0xF6FD,0xFB7E,0xFFCF,0x03AD,
	0x0685,0x0983,0x0D0A,0x106D,0x10E6,0x0C5C,0x00E6,0xEEE8,
	0xDAE5,0xC78A,0xBEFA,0xBF3C,0xBEDB,0xBEEB,0xBF31,0xC0EC,
	0xBEE7,0xE22F,0x2270,0x3D32,0x3D21,0x3E28,0x3DFF,0x3DE6,
	0x3DF7,0x3DDA,0x3CA2,0x3DEB,0x2CDE,0x0322,0xE352,0xCD12,
	0xC1E2,0xC163,0xC9FC,0xD68D,0xDFF8,0xE226,0xDDF2,0xD781,
	0xD3E5,0xD640,0xDC56,0xE108,0xE0CB,0xDE50,0xE0EC,0xEDF1,
	0x0660,0x2811,0x3DAB,0x3DE8,0x3E48,0x3E92,0x3E69,0x3DF9,
	0x3E25,0x3A47,0x1F39,0x00BA,0xE5E0,0xCBFF,0xBEDD,0xBF17,
	0xBEB4,0xBF34,0xBE9E,0xC3C2,0xDACD,0xEF04,0xFB52,0x018D,
	0x064D,0x0C0B,0x13B7,0x1A1B,0x1E93,0x2092,0x2189,0x22ED,
	0x2677,0x2C15,0x3150,0x356A,0x37BC,0x3298,0x2A98,0x1DA9,
	0x097E,0xF178,0xDA93,0xC7D3,0xBF96,0xBF87,0xBF49,0xBFA9,
	0xBF73,0xC229,0xD23C,0xE7A5,0xFF0A,0x142F,0x2294,0x2B6B,
	0x3050,0x31A0,0x301A,0x2C09,0x25AF,0x1EB8,0x1811,0x11FD,
	0x0CF3,0x0791,0x01FF,0xFC06,0xF6E0,0xF322,0xF039,0xEBE8,
	0xE452,0xDB25,0xD23B,0xCCC5,0xCBD1,0xCFC3,0xD792,0xE16A,
	0xEB7D,0xF6CD,0x040E,0x11FA,0x1F78,0x29CD,0x303C,0x3235,
	0x3043,0x2AFF,0x2369,0x190D,0x0CBC,0x0107,0xF7AF,0xF053,
	0xEAC6,0xE719,0xE3ED,0xE0E3,0xDD81,0xDDEB,0xE0CB,0xE4CB,
	0xE7D0,0xE9C7,0xEB9F,0xED91,0xF120,0xF5F5,0xFCC0,0x04C0,
	0x0C45,0x12CC,0x1837,0x1CEA,0x2036,0x2198,0x1ED1,0x1965,
	0x1361,0x0C99,0x0433,0xFA7E,0xF153,0xE8D7,0xE274,0xDECA,
	0xDDB0,0xDF0B,0xE1C3,0xE5A3,0xEA4C,0xF055,0xF68D,0xFB9A,
	0x00A3,0x053B,0x0A31,0x0DC9,0x0F74,0x104B,0x112A,0x13C1,
	0x14E7,0x13C6,0x132F,0x128E,0x1008,0x0B70,0x0670,0x01DB,
	0xFD39,0xF767,0xF1A9,0xED9C,0xEB54,0xE99D,0xE8DF,0xE8F6,
	0xEBC1,0xF00A,0xF57E,0xFC01,0x02A6,0x086C,0x0CFE,0x1086,
	0x1343,0x158A,0x167E,0x156F,0x1355,0x10A5,0x0E26,0x0AFC,
	0x0752,0x0438,0x00E6,0xFDE5,0xFB65,0xF8F1,0xF6A1,0xF481,
	0xF1E5,0xEFE0,0xEF40,0xF062,0xF1FC,0xF3C2,0xF5C2,0xF8D5,
	0xFCAD,0x00C9,0x04FD,0x094A,0x0D35,0x0FCF,0x10BB,0x105D,
	0x0E72,0x0837,0xFBB4,0xE9E6,0xD521,0xC373,0xBFFB,0xC015,
	0xBFD8,0xBFEF,0xC09F,0xC1B3,0xC291,0xF50E,0x30E7,0x3FA5,
	0x3ECC,0x3FB1,0x400C,0x403C,0x3F28,0x3F88,0x3E8F,0x3F8D,
	0x28C3,0xFDFC,0xE038,0xCCDB,0xC425,0xC545,0xCDF0,0xD972,
	0xE18B,0xE190,0xDB2A,0xD464,0xD38C,0xD8D9,0xE01C,0xE48B,
	0xE425,0xE2A5,0xE72B,0xF6C6,0x134B,0x3574,0x3FEF,0x3EDC,
	0x3F90,0x3FAE,0x3F7A,0x3EFF,0x3F7D,0x3770,0x19F5,0xFBED,
	0xE02B,0xC727,0xBF7C,0xBFDB,0xBF92,0xC02E,0xBF31,0xC88B,
	0xE0E6,0xF245,0xFD15,0x0352,0x088E,0x1014,0x1810,0x1F0E,
	0x227E,0x22C6,0x2318,0x253B,0x29FB,0x300E,0x35A8,0x3874,
	0x37F6,0x3454,0x2BE6,0x1B25,0x05A4,0xED7C,0xD725,0xC5F0,
	0xC04C,0xC06A,0xBFF7,0xC03B,0xC029,0xC55F,0xD7D1,0xEED7,
	0x068B,0x1AAF,0x2862,0x3029,0x33D4,0x3364,0x3267,0x2E96,
	0x281C,0x20B6,0x19C6,0x1334,0x0CB6,0x06B6,0x00D8,0xFB20,
	0xF67F,0xF1E0,0xECF7,0xE732,0xE026,0xD808,0xCFBC,0xCA75,
	0xC96F,0xCEB0,0xD820,0xE2D8,0xEDDF,0xFAC2,0x07B1,0x1461,
	0x217C,0x2C6A,0x330D,0x34BA,0x3127,0x2A47,0x216B,0x1694,
	0x0A5E,0xFDBE,0xF2CB,0xEBDB,0xE7A5,0xE3AD,0xDF4F,0xDC2B,
	0xDB10,0xDC51,0xDF69,0xE304,0xE6A8,0xE98C,0xEAE2,0xECCA,
	0xF026,0xF6A4,0xFE83,0x0640,0x0D9A,0x1490,0x1A8A,0x1EAA,
	0x2068,0x2043,0x1E0C,0x18AC,0x11B2,0x094B,0xFFF6,0xF6FC,
	0xECFA,0xE409,0xDDF4,0xDB50,0xDB6A,0xDD40,0xE03C,0xE48E,
	0xE9BD,0xEF86,0xF58C,0xFB85,0x015E,0x05BA,0x0903,0x0BF3,
	0x0E60,0x0FFA,0x10A8,0x1168,0x11C7,0x11B8,0x10C3,0x0F3F,
	0x0C9C,0x08BC,0x0292,0xFC40,0xF6CE,0xF1B3,0xECDD,0xE833,
	0xE470,0xE277,0xE19F,0xE4BE,0xE7D4,0xEC2F,0xF45A,0xFA78,
	0xFFD1,0x05AC,0x0AF8,0x0E53,0x112A,0x12FE,0x13BD,0x12E4,
	0x104B,0x0C94,0x0997,0x0701,0x047D,0x01B8,0xFDFD,0xFA5C,
	0xF706,0xF44F,0xF28E,0xF161,0xEFDD,0xEE4C,0xED09,0xED39,
	0xEF19,0xF22A,0xF5BE,0xF9B7,0xFD53,0x00E6,0x0567,0x0A71,
	0x0EA4,0x1183,0x11EA,0x1155,0x0EE4,0x0888,0xFDB1,0xEF24,
	0xDEEE,0xCC86,0xC00F,0xBF93,0xBF7F,0xBF73,0xC0A9,0xBF8D,
	0xD0F1,0x0062,0x27AB,0x3D3C,0x3EFB,0x3F56,0x3FA6,0x3F9C,
	0x3F81,0x3E9B,0x3FD8,0x340A,0x12E0,0xFA41,0xE748,0xDB6A,
	0xD763,0xDA25,0xE09B,0xE6A2,0xE9B2,0xE7E1,0xE313,0xDE8E,
	0xDD62,0xDFA9,0xE364,0xE592,0xE59A,0xE6BB,0xEBF3,0xF9AD,
	0x104C,0x2A1A,0x3D26,0x3F6C,0x3F69,0x3FA0,0x3F31,0x3FEB,
	0x3953,0x2478,0x0EE7,0xF9BD,0xE781,0xD737,0xC855,0xC0C7,
	0xC0E0,0xC0DE,0xCBD7,0xDCBD,0xEC16,0xF804,0xFF6E,0x02A7,
	0x045D,0x0887,0x0EB1,0x138E,0x16AA,0x18F1,0x1AF1,0x1D35,
	0x20A0,0x24EB,0x2966,0x2BCE,0x2B3B,0x278A,0x1F98,0x1291,
	0x02BB,0xF1B3,0xE2C5,0xD750,0xCFC7,0xCBD9,0xCAAD,0xCC97,
	0xD242,0xDB64,0xE7D0,0xF689,0x05BF,0x1382,0x1DB9,0x236D,
	0x2557,0x248A,0x21F6,0x1F10,0x1B85,0x183F,0x14B0,0x0FB8,
	0x0AF3,0x0693,0x030D,0xFF78,0xFB90,0xF7EA,0xF3C6,0xEED0,
	0xE89F,0xE247,0xDD46,0xDA12,0xDA36,0xDD15,0xE27D,0xEB31,
	0xF52F,0xFEBD,0x0780,0x0FF3,0x1809,0x1F05,0x23BD,0x25B7,
	0x238D,0x1E15,0x16C4,0x0E5D,0x0658,0xFF5F,0xF918,0xF3B8,
	0xF023,0xED8E,0xEC35,0xE909,0xE6FE,0xEA26,0xEB85,0xED22,
	0xEEDC,0xF005,0xF193,0xF3BA,0xF641,0xFAA2,0x00E7,0x074B,
	0x0BD4,0x1035,0x144C,0x17FC,0x19DE,0x19AB,0x1732,0x1395,
	0x0E5E,0x07C5,0x001E,0xF9B2,0xF3B6,0xEE01,0xE8B7,0xE67B,
	0xE69F,0xE803,0xEA46,0xECE9,0xF03C,0xF43D,0xF7FF,0xFC73,
	0x00DF,0x0401,0x05C7,0x0700,0x08A5,0x0A9B,0x0C8A,0x0DE4,
	0x0DDB,0x0CE4,0x0BF5,0x0AA2,0x088C,0x0647,0x02D1,0xFEA7,
	0xF9D7,0xF4DF,0xF142,0xEEBC,0xEC8F,0xEB05,0xEA5E,0xEB95,
	0xEEDA,0xF504,0xFA3E,0xFE3E,0x0260,0x05B6,0x087A,0x0ADE,
	0x0D80,0x0F1A,0x0F20,0x0E22,0x0C56,0x0AEE,0x097E,0x0761,
	0x04B7,0x0237,0x0048,0xFEB3,0xFC38,0xFA16,0xF86D,0xF64B,
	0xF407,0xF356,0xF394,0xF390,0xF3D9,0xF4E3,0xF73C,0xFA41,
	0xFD7D,0x002E,0x0289,0x05A2,0x09E0,0x0C30,0x0C32,0x0B94,
	0x090E,0x05A7,0x00A0,0xFC32,0xF8D3,0xF421,0xEC53,0xE624,
	0xE42F,0xE5D9,0xEABF,0xF1B2,0xF98E,0x00E9,0x062C,0x0941,
	0x0B09,0x0CA3,0x0E6E,0x0F75,0x0E7E,0x0A73,0x0668,0x0343,
	0xFFB4,0xFD13,0xFC26,0xFCBC,0xFDFF,0xFEDF,0xFF37,0xFEE6,
	0xFD36,0xFA6C,0xF7C0,0xF5A4,0xF4E2,0xF480,0xF423,0xF3A7,
	0xF3BB,0xF55D,0xF833,0xFC9A,0x022E,0x080F,0x0BE3,0x0DCD,
	0x0E7A,0x0E79,0x0D28,0x0AA6,0x07CC,0x0492,0x0171,0xFE60,
	0xFC0B,0xFA2B,0xF86B,0xF76F,0xF61D,0xF5E2,0xF6A2,0xF63C,
	0xF59D,0xF4D1,0xF3E1,0xF2A2,0xF1C4,0xF0D0,0xF02B,0xEF92,
	0xEF2E,0xEEF4,0xF005,0xF2DF,0xF5B9,0xF780,0xF7DC,0xF7D8,
	0xF7B2,0xF6BB,0xF60D,0xF6BA,0xF308,0xF1C4,0xF0B5,0xEF52,
	0xEE9E,0xEDDC,0xED18,0xEC28,0xEC3D,0xEBEA,0xEBD2,0xEBE2,
	0xEB9B,0xEB43,0xEAEF,0xEA16,0xE975,0xE8A6,0xE89B,0xE85E,
	0xE877,0xE8CC,0xE930,0xE8EC,0xE833,0xE7EB,0xE83C,0xE832,
	0xE7EF,0xE79E,0xE71E,0xE6FF,0xE680,0xE5DF,0xE629,0xE645,
	0xE67F,0xE6F7,0xE767,0xE7BC,0xE832,0xE847,0xE8C8,0xE8FE,
	0xE92C,0xE9D6,0xEA4C,0xEA6C,0xEA92,0xEAD6,0xEB3C,0xEBA4,
	0xEBA4,0xEBCE,0xEC7A,0xED01,0xECF3,0xECD9,0xED10,0xED08,
	0xED1D,0xED45,0xECAF,0xEB37,0xEC03,0xECC6,0xED07,0xED70,
	0xEE21,0xEF39,0xF002,0xF08C,0xF13E,0xF1C1,0xF280,0xF2B4,
	0xF360,0xF3C0,0xF453,0xF50F,0xF60F,0xF679,0xF65E,0xF75B,
	0xF8A4,0xF88C,0xF89C,0xF968,0xF9D6,0xFA5D,0xFB36,0xFB8F,
	0xFB3B,0xFB69,0xFC10,0xFD22,0xFDA5,0xFE21,0xFEC5,0xFF4B,
	0xFFCF,0x000B,0x0053,0x00DD,0x017F,0x025A,0x03EF,0x040B,
	0x0386,0x03BC,0x03F5,0x0458,0x04BE,0x058D,0x0591,0x05DB,
	0x0609,0x0688,0x0752,0x075F,0x0830,0x08DD,0x08F6,0x08F4,
	0x089F,0x0893,0x091E,0x0969,0x09B6,0x0A20,0x0A17,0x0A5D,
	0x0A8A,0x0A7C,0x0AA5,0x0ADB,0x0B81,0x0BB2,0x0BAE,0x0C20,
	0x0C96,0x0C2F,0x0BEC,0x0C19,0x0C06,0x0C86,0x0C96,0x0C61,
	0x0C41,0x0C78,0x0C74,0x0C2D,0x0C20,0x0C45,0x0CD7,0x0CC8,
	0x0CBB,0x0C8F,0x0CE3,0x0CFF,0x0CDE,0x0D2F,0x0D0B,0x0D88,
	0x0E14,0x0DFD,0x0DBE,0x0E0E,0x0E38,0x0E5C,0x0E78,0x0E80,
	0x0EA0,0x0E97,0x0E6C,0x0E44,0x0E2B,0x0E24,0x0E3E,0x0E79,
	0x0EB7,0x0EC9,0x0ED4,0x0CB4,0x0DA1,0x0EBC,0x0DB6,0x0E28,
	0x0E7E,0x0E69,0x0DFE,0x0E07,0x0E3D,0x0E34,0x0E70,0x0E9B,
	0x0EAF,0x0E89,0x0E54,0x0E06,0x0E2F,0x0E55,0x0E58,0x0E8C,
	0x0E73,0x0DF2,0x0D8D,0x0D4C,0x0D2A,0x0D14,0x0DBA,0x0D5E,
	0x0CED,0x0D0F,0x0CEE,0x0D2E,0x0CA2,0x0CBF,0x0D2A,0x0D25,
	0x0CEE,0x0CFF,0x0CBD,0x0C3C,0x0C21,0x0C22,0x0C20,0x0C39,
	0x0C77,0x0CB0,0x0C99,0x0BF5,0x0B9B,0x0BB4,0x0BCB,0x0BCE,
	0x0BB9,0x0B6B,0x0B53,0x0B55,0x0B06,0x0AD2,0x0AD7,0x0AD1,
	0x0BFE,0x0DBA,0x0CE9,0x0C92,0x0C77,0x0C05,0x0BC5,0x0BDA,
	0x0BE7,0x0BF6,0x0BD5,0x0B5D,0x0B82,0x0B96,0x0B65,0x0B9F,
	0x0B75,0x0B3B,0x0B48,0x0AD9,0x0A54,0x0A9F,0x0AE6,0x09FF,
	0x0977,0x099A,0x0997,0x0947,0x093E,0x08FA,0x0915,0x08F5,
	0x0903,0x0946,0x08DB,0x0851,0x0853,0x08B2,0x083D,0x07E5,
	0x07FE,0x07B2,0x07A1,0x07ED,0x083B,0x07F4,0x0666,0x06B0,
	0x077D,0x0787,0x06F9,0x06CF,0x0693,0x06CD,0x071F,0x0686,
	0x061F,0x0593,0x051A,0x04BB,0x042E,0x03AB,0x0432,0x0420,
	0x03C2,0x03DE,0x03AB,0x036E,0x039E,0x03B6,0x03E6,0x03BB,
	0x03B2,0x0389,0x036A,0x0374,0x037C,0x036D,0x0365,0x03C8,
	0x03E5,0x038B,0x0370,0x0356,0x0332,0x039C,0x035B,0x030E,
	0x02F0,0x02E9,0x02C8,0x0314,0x02FA,0x02D9,0x02C1,0x02F6,
	0x02BC,0x027E,0x0286,0x0295,0x021B,0x024E,0x0240,0x01EF,
	0x01B0,0x0196,0x01E8,0x01AF,0x016A,0x00D2,0x00BD,0x00CC,
	0x00DE,0x00A7,0x00C0,0x0129,0x01A8,0x0180,0x017A,0x01B2,
	0x018C,0x00B9,0x0254,0x0244,0x008E,0x0159,0x0124,0x0118,
	0x0167,0x01C5,0x0186,0x012D,0x00D7,0x00A5,0x006F,0x0109,
	0x00E8,0x00D9,0x00FF,0x011D,0x0144,0x00E8,0x0098,0x00A1,
	0x00B6,0x0095,0x00AE,0xFFAC,0xFFB3,0xFFB7,0x0056,0x0087,
	0x002B,0x0077,0x0091,0x0092,0x0109,0x010F,0x0183,0x0284,
	0x025A,0x01AD,0x0157,0x016C,0x013D,0x010D,0x014F,0x015B,
	0x01AF,0x0148,0x014E,0x01AE,0x01A1,0x01B8,0x00F0,0x0127,
	0x0105,0x0111,0x0107,0x00E7,0x010A,0x012A,0x00CC,0x00C2,
	0x009C,0x00D9,0x00DE,0x00BE,0x00C1,0x00BF,0x00E0,0x014E,
	0x01A4,0x0296,0x0353,0x03AC,0x0356,0x03B1,0x04FE,0x0621,
	0x0780,0x08D1,0x0A0F,0x0A86,0x0B4C,0x0B92,0x0BB7,0x0BC3,
	0x0C0B,0x0C8E,0x0C96,0x0C29,0x0C3C,0x0C57,0x0C4C,0x0C56,
	0x0CBA,0x0CCE,0x0CF8,0x0E6A,0x1038,0x0EAD,0x0F59,0x0FE9,
	0x0EED,0x0F94,0x1105,0x1247,0x1348,0x136B,0x126E,0x11B7,
	0x11DB,0x129E,0x139B,0x1435,0x14BB,0x14C5,0x14C1,0x1458,
	0x150A,0x159A,0x15D0,0x15BA,0x15FD,0x169C,0x1766,0x173C,
	0x1684,0x1638,0x15F0,0x15F8,0x16E0,0x177D,0x17D1,0x1807,
	0x1728,0x15F0,0x156F,0x159A,0x1623,0x163D,0x15F7,0x158A,
	0x14A6,0x1415,0x1380,0x12FA,0x1311,0x1320,0x12B5,0x1283,
	0x1291,0x122A,0x10FA,0x0FD7,0x0F9F,0x1080,0x112F,0x102C,
	0x0E7D,0x0BC1,0x0897,0x05E1,0x01F7,0xFF01,0xFC6E,0xF7DD,
	0xF188,0xEBF7,0xE973,0xEADA,0xF13D,0xFB08,0x0603,0x106C,
	0x190F,0x20C9,0x2893,0x3038,0x36DA,0x3B95,0x3C11,0x3972,
	0x3403,0x29C8,0x1DDA,0x11B0,0x050C,0xF940,0xEFA1,0xE7A3,
	0xE26D,0xDF64,0xDD7C,0xDCDF,0xDDE6,0xE2A6,0xEBC1,0xF5F1,
	0xFF89,0x06B7,0x0BC3,0x0EC8,0x1143,0x13BB,0x15FE,0x164B,
	0x139C,0x1249,0x1019,0x0BFC,0x07BB,0x046B,0x00F9,0xFE03,
	0xFC0D,0xFAC1,0xFA3B,0xF94D,0xF5F7,0xF1A0,0xED32,0xE9D7,
	0xE7FA,0xE6BF,0xE608,0xE564,0xE40F,0xE280,0xE21E,0xE4D1,
	0xE8A3,0xECDB,0xF18C,0xF75A,0xFE17,0x038F,0x06ED,0x08C3,
	0x09B3,0x0A0C,0x090C,0x078E,0x0536,0x01A2,0xFB54,0xF364,
	0xEBB3,0xE5C2,0xE1BB,0xDF05,0xDD59,0xDBFC,0xDACB,0xDAEB,
	0xDCB6,0xDFE5,0xE440,0xE904,0xECAF,0xEFE7,0xF342,0xF6F7,
	0xFA85,0xFC40,0xFC46,0xFB68,0xFAA0,0xF9DF,0xF934,0xF881,
	0xF772,0xF59B,0xF2BC,0xF033,0xEF08,0xEED5,0xEDD0,0xEBCB,
	0xE978,0xE829,0xE717,0xE53B,0xE5C1,0xE519,0xE384,0xE384,
	0xE31F,0xE458,0xE6AA,0xE978,0xEBD8,0xEDB3,0xEF54,0xF27A,
	0xF57F,0xF901,0xFB90,0xFD88,0xFD94,0xFC70,0xFAA0,0xF938,
	0xF7CF,0xF59C,0xF311,0xEFE0,0xECFA,0xEA02,0xE7C3,0xE5FC,
	0xE46B,0xE441,0xE4F6,0xE61A,0xE776,0xE927,0xEB9B,0xEDEF,
	0xEFEF,0xF1C0,0xF39B,0xF56F,0xF7B3,0xF9B1,0xFA89,0xFA65,
	0xF9B2,0xF8D5,0xF84C,0xF855,0xF8F3,0xF8E0,0xF7AB,0xF569,
	0xF359,0xF292,0xF1A3,0xF0B8,0xEFFA,0xEF02,0xEE44,0xED33,
	0xECD7,0xED30,0xEE00,0xEE16,0xEC6A,0xEBBC,0xEE8A,0xF14D,
	0xF347,0xF50F,0xF654,0xF719,0xF82C,0xF9B1,0xFB72,0xFD5C,
	0xFD68,0xFC13,0xFA25,0xF8BE,0xF79C,0xF660,0xF584,0xF392,
	0xF1DC,0xF116,0xF01A,0xEEEF,0xEEB2,0xEED1,0xEEF1,0xEF8C,
	0xF0E5,0xF25E,0xF401,0xF517,0xF5A0,0xF704,0xF8F2,0xFA79,
	0xFB87,0xFBF1,0xFC21,0xFC52,0xFC28,0xFC25,0xFC4F,0xFC9C,
	0xFD42,0xFC05,0xFA6E,0xF945,0xF7D9,0xF717,0xF728,0xF7BF,
	0xF7C9,0xF760,0xF612,0xF46E,0xF155,0xEC72,0xE6DA,0xE01D,
	0xD986,0xD2FB,0xC752,0xC06F,0xC0E5,0xC08B,0xC114,0xC115,
	0xC431,0xDE70,0xFA37,0x10E0,0x25E9,0x3AED,0x409E,0x4020,
	0x4073,0x406E,0x403B,0x4028,0x3F69,0x3FE4,0x2ED1,0x0CA8,
	0xEDB8,0xCFE6,0xC0C3,0xC0AE,0xC038,0xC007,0xC02D,0xC060,
	0xC0F2,0xC083,0xD087,0xEE38,0x05DF,0x17AD,0x239F,0x2D9B,
	0x3782,0x3EE1,0x3FB1,0x3FCC,0x3F00,0x36B7,0x2C91,0x238E,
	0x1ABA,0x127C,0x0AE0,0x0594,0x02B1,0x0131,0xFF13,0xFA34,
	0xF24A,0xE95E,0xE1D7,0xDDAD,0xDAB9,0xD7AD,0xD670,0xD118,
	0xCC6B,0xCC49,0xD144,0xDACF,0xE7E4,0xF68A,0x04CA,0x12AB,
	0x2018,0x2C04,0x370B,0x3E7F,0x3F71,0x3F4E,0x3EF6,0x3866,
	0x2D39,0x1E9E,0x0CED,0xFAC7,0xEA2D,0xDB9C,0xCFE8,0xC7C1,
	0xC29B,0xC031,0xBFBA,0xC2B9,0xCA7F,0xD60A,0xE2B6,0xEF4F,
	0xFB6F,0x06BE,0x1069,0x17D4,0x1D3F,0x2163,0x23A4,0x2359,
	0x217C,0x1E97,0x1AF3,0x1653,0x1036,0x09C6,0x0491,0x0077,
	0xFCF4,0xF977,0xF585,0xF13A,0xECBE,0xE83C,0xE474,0xE1D2,
	0xE0F9,0xE02A,0xE0FC,0xE1CA,0xE304,0xE69D,0xEB8B,0xF138,
	0xF7C7,0xFF7F,0x0781,0x0FC5,0x1718,0x1D33,0x20C1,0x21CB,
	0x219F,0x207E,0x1EA2,0x19BE,0x11BF,0x087A,0xFF08,0xF6A3,
	0xEE25,0xE65D,0xE0F7,0xDD51,0xDA44,0xD9E0,0xDB94,0xDE68,
	0xE286,0xE7BF,0xEDD1,0xF529,0xFC1C,0x0323,0x098B,0x0E1C,
	0x10F9,0x120E,0x1299,0x1315,0x12C0,0x121F,0x10DB,0x0D5F,
	0x0872,0x053B,0x01A8,0xFE75,0xFC2D,0xFA15,0xF7BB,0xF489,
	0xF0E9,0xEE4B,0xEC76,0xEB1A,0xEA1E,0xEA4B,0xEB1B,0xEC34,
	0xEE22,0xF140,0xF4D7,0xF8E7,0xFD68,0x01A4,0x05E6,0x0AE6,
	0x0F04,0x11F6,0x131F,0x136E,0x12BC,0x1083,0x0E06,0x0B10,
	0x07A6,0x0319,0xFD7B,0xF783,0xF282,0xEF72,0xED27,0xEB2C,
	0xEA51,0xEA86,0xEB73,0xED58,0xF012,0xF3BD,0xF7A3,0xFBC5,
	0xFFF3,0x03BA,0x0721,0x09B8,0x0BBD,0x0D49,0x0DD3,0x0D78,
	0x0CB7,0x0BC8,0x0A07,0x0831,0x05F8,0x045C,0x01FF,0xFE87,
	0xFC68,0xFAFE,0xFA0B,0xF878,0xF6D0,0xF4FC,0xF406,0xF250,
	0xEEE9,0xE805,0xDF7A,0xD7BC,0xD2CB,0xC89E,0xBFC2,0xBF28,
	0xBEF1,0xBEE0,0xBFE2,0xBED7,0xC94A,0xED81,0x0BCE,0x270D,
	0x3BFF,0x3F14,0x3F17,0x3F5E,0x3F38,0x3F1F,0x3F28,0x3F0F,
	0x3E0F,0x3ECE,0x2DB0,0x0574,0xDED5,0xC321,0xBFCE,0xBFAC,
	0xBF50,0xBF5B,0xBF5B,0xBFC7,0xC06E,0xC11D,0xD807,0xFB8A,
	0x16DF,0x2B7B,0x3A86,0x3F46,0x3F4D,0x3F8D,0x3FA0,0x3F8D,
	0x3F37,0x3FB5,0x3ADE,0x2D6D,0x21A5,0x168A,0x0DF8,0x0809,
	0x04AF,0x0299,0xFF11,0xF87A,0xEF22,0xE5BE,0xDDFE,0xD8F0,
	0xD621,0xD37A,0xCFCD,0xCB8C,0xC7FE,0xCA75,0xD1D2,0xDDB5,
	0xED92,0xFF5F,0x114C,0x2233,0x3318,0x3DFB,0x3EC8,0x3EEE,
	0x3F31,0x3F42,0x3E7E,0x3F21,0x35A0,0x2288,0x0CF4,0xF508,
	0xDFFC,0xCFD7,0xC3F8,0xBF9D,0xBFE3,0xC002,0xC018,0xC030,
	0xC8F7,0xD812,0xE868,0xF900,0x082F,0x1566,0x2002,0x2845,
	0x2E72,0x3213,0x3271,0x3067,0x2D18,0x298A,0x24D6,0x1F55,
	0x17D1,0x0EB9,0x07CA,0x0205,0xFD6E,0xF93E,0xF58F,0xF141,
	0xEC7F,0xE804,0xE3F3,0xE0DF,0xDF13,0xDED6,0xE0A2,0xE292,
	0xE542,0xE9AB,0xEF88,0xF6D5,0xFF6D,0x0913,0x130D,0x1C3F,
	0x2430,0x2A96,0x2EEE,0x3116,0x2FD8,0x2B86,0x253E,0x1E1D,
	0x15A7,0x0C10,0x0180,0xF694,0xEBC2,0xE200,0xDB0C,0xD754,
	0xD613,0xD6F4,0xD952,0xDDB3,0xE396,0xEAB5,0xF2A6,0xFB5C,
	0x0457,0x0CAC,0x127D,0x1693,0x19D3,0x1BF8,0x1D81,0x1D9A,
	0x1C42,0x190D,0x14AD,0x105A,0x0C4E,0x089A,0x051E,0x012A,
	0xFC53,0xF7A5,0xF3E2,0xF0EF,0xEE6C,0xEC71,0xEAA7,0xE9AC,
	0xE96B,0xEA37,0xEBED,0xEEBC,0xEFDC,0xF404,0xF886,0xFCC4,
	0x0405,0x0A8B,0x0F20,0x1273,0x14EA,0x1743,0x18D6,0x1976,
	0x18A9,0x16E1,0x12E1,0x0CED,0x0702,0x015D,0xFBF6,0xF6B0,
	0xF19C,0xED71,0xEA58,0xE832,0xE78A,0xE7D5,0xE9D8,0xECEF,
	0xF09C,0xF4C9,0xF958,0xFE00,0x0299,0x06D1,0x0A2A,0x0CD7,
	0x0F2F,0x1098,0x1106,0x1086,0x1074,0x0F4E,0x0CB5,0x092E,
	0x05C5,0x03D5,0x014E,0xFEA0,0xFBD9,0xF954,0xF67E,0xF444,
	0xF204,0xF0D7,0xEEF2,0xE999,0xE063,0xD722,0xD084,0xCBAB,
	0xC3BC,0xBF64,0xC0EF,0xC051,0xC059,0xC130,0xC03F,0xD512,
	0xFA5B,0x15ED,0x2F4C,0x3F07,0x3F9E,0x3FCF,0x3FFA,0x3FEF,
	0x3FB4,0x3F75,0x3F38,0x3E75,0x3D3F,0x21A6,0xF794,0xD127,
	0xBF59,0xBFF1,0xBF74,0xBF43,0xBF37,0xBF72,0xBFA7,0xBFBD,
	0xC33F,0xE19F,0x04CC,0x1D5E,0x2E9E,0x3B44,0x3EE3,0x3EAC,
	0x3EF6,0x3F07,0x3EDF,0x3ECA,0x3EC6,0x35B3,0x288C,0x1CC7,
	0x1215,0x0A54,0x04C0,0x0196,0xFF47,0xFA86,0xF255,0xE731,
	0xDCD6,0xD5B4,0xD281,0xD149,0xCF5A,0xCAEF,0xC5E7,0xC3F0,
	0xC7C3,0xD244,0xE1BB,0xF352,0x0514,0x1614,0x2668,0x363C,
	0x3E09,0x3DF7,0x3E17,0x3E5D,0x3E26,0x3E0E,0x3C85,0x2E42,
	0x18FC,0x014E,0xE977,0xD592,0xC657,0xBEF6,0xBEBF,0xBE88,
	0xBE93,0xBEE6,0xBE89,0xC5FB,0xD6C4,0xE7C3,0xF889,0x07A8,
	0x14B2,0x1F8D,0x2748,0x2C57,0x2E4C,0x2DE9,0x2C65,0x295C,
	0x24C4,0x1F5C,0x1885,0x10B8,0x07E0,0x0028,0xFA07,0xF6DC,
	0xF3A3,0xEF9F,0xEA81,0xE44F,0xDF69,0xDBE9,0xDA15,0xD97E,
	0xDA3B,0xDB63,0xDC13,0xE06D,0xE6A3,0xECD8,0xF6FC,0xFF44,
	0x07DE,0x1179,0x1B4C,0x24C6,0x2BC7,0x2E87,0x2E87,0x2BA3,
	0x273F,0x21D0,0x1AC1,0x11EE,0x06A9,0xFA81,0xEEF6,0xE596,
	0xDDF1,0xD7E4,0xD41C,0xD281,0xD398,0xD74B,0xDD1A,0xE404,
	0xEBBA,0xF3C3,0xFC49,0x04D2,0x0D24,0x13D1,0x1969,0x1C33,
	0x1DC6,0x1D98,0x1CD0,0x1B61,0x190B,0x161A,0x1203,0x0D30,
	0x080C,0x0350,0xFF9A,0xFBFF,0xF80B,0xF428,0xF068,0xED9B,
	0xEBB2,0xEAC8,0xEA1A,0xEA69,0xEADC,0xEC28,0xEE99,0xF265,
	0xF793,0xFCBF,0x0185,0x04B0,0x08FD,0x0EEB,0x13E9,0x1815,
	0x1A3D,0x1ACB,0x19FE,0x17D0,0x14B3,0x1081,0x0B8C,0x05D0,
	0xFF5D,0xF977,0xF3F2,0xEED3,0xEAAF,0xE7E7,0xE58B,0xE53F,
	0xE721,0xEA16,0xEDAA,0xF1F3,0xF607,0xFA64,0xFF30,0x04BB,
	0x0978,0x0D07,0x1043,0x125E,0x1391,0x1377,0x127A,0x11F6,
	0x1073,0x0E33,0x0B76,0x0838,0x0578,0x0218,0xFEE2,0xFD25,
	0xFA26,0xF765,0xF503,0xF290,0xF14E,0xF05C,0xEE42,0xE92C,
	0xE15E,0xD934,0xD379,0xCE53,0xC4C3,0xC071,0xC10F,0xC0C5,
	0xC12D,0xC17C,0xC3CE,0xE25D,0x056D,0x20E6,0x3949,0x40CA,
	0x4021,0x40D3,0x40A4,0x4083,0x405A,0x407A,0x3FB2,0x3FE3,
	0x3A79,0x16C8,0xEE2A,0xCB66,0xC03B,0xC0C9,0xC04F,0xC02F,
	0xC047,0xC04C,0xC143,0xC04E,0xCC70,0xF103,0x103B,0x26C6,
	0x37BC,0x3FA8,0x3FBD,0x4011,0x400B,0x4018,0x3FB7,0x3FDB,
	0x3E55,0x325B,0x25C7,0x1AE1,0x1127,0x099B,0x04CF,0x0273,
	0x002B,0xFB05,0xF23C,0xE747,0xDE19,0xD7E1,0xD5CC,0xD4B8,
	0xD2AD,0xCECE,0xCB71,0xC933,0xCD33,0xDA70,0xE914,0xFA80,
	0x0C1E,0x1D14,0x2D59,0x3B43,0x3F9D,0x3F6C,0x3FB2,0x3F9B,
	0x3F36,0x3F87,0x3A5F,0x2890,0x138B,0xFCCE,0xE6D8,0xD402,
	0xC56F,0xBFD3,0xBFEC,0xBF99,0xBFD3,0xBF6E,0xC21B,0xCF66,
	0xDEED,0xEF28,0xFEC9,0x0D2D,0x196D,0x2314,0x29F9,0x2DE1,
	0x2F0B,0x2DD9,0x2B6E,0x283A,0x23A4,0x1D1C,0x154D,0x0DAA,
	0x06EB,0x000E,0xFA80,0xF62F,0xF272,0xEE49,0xE916,0xE419,
	0xE016,0xDCFC,0xDAFF,0xD9F2,0xDA03,0xDB95,0xDEDC,0xE2F9,
	0xE8A8,0xF17D,0xF9DB,0x01D7,0x0AF2,0x1526,0x1EBF,0x26CB,
	0x2B85,0x2CA9,0x2B98,0x2929,0x256E,0x1F11,0x16AE,0x0D06,
	0x0292,0xF6D7,0xEB0B,0xE139,0xDA23,0xD54B,0xD2B6,0xD168,
	0xD307,0xD7C1,0xDE0C,0xE3DB,0xEB0D,0xF3B0,0xFC4A,0x0454,
	0x0BD7,0x1273,0x172E,0x1946,0x1993,0x1903,0x17CB,0x160E,
	0x12F1,0x0FC3,0x0BF5,0x06E8,0x01E1,0xFCF1,0xF759,0xF455,
	0xF1D7,0xEF89,0xED48,0xEAC9,0xE89A,0xE6E4,0xE5D3,0xE67F,
	0xE81E,0xEA7C,0xED3B,0xF0BC,0xF460,0xF7B7,0xFC90,0x022F,
	0x0761,0x0C69,0x1052,0x1365,0x14A9,0x14E0,0x13F6,0x1287,
	0x1010,0x0B81,0x0600,0x006E,0xFAB3,0xF4AC,0xEF73,0xEB27,
	0xE7E6,0xE57E,0xE3AB,0xE393,0xE507,0xE7B2,0xEB49,0xEF1B,
	0xF3C8,0xF900,0xFDD4,0x027F,0x06A7,0x0A48,0x0CB9,0x0E16,
	0x0ED3,0x0F62,0x0F24,0x0D41,0x0ABD,0x08EC,0x069A,0x03D2,
	0x0091,0xFD47,0xFA9D,0xF7F6,0xF550,0xF36C,0xF135,0xF007,
	0xEF58,0xEE52,0xEB2B,0xE5AE,0xDE37,0xD6CD,0xD099,0xCA28,
	0xC0B4,0xBEA6,0xBECF,0xBFAD,0xBF66,0xBF31,0xC610,0xE6A7,
	0x0802,0x231D,0x39C7,0x3F40,0x3EE4,0x3F7D,0x3F59,0x3F17,
	0x3F3A,0x3F1C,0x3E3A,0x3F2C,0x3343,0x0B69,0xE3B5,0xC48C,
	0xBFA3,0xBFB5,0xBF55,0xBF77,0xBF60,0xBF82,0xC075,0xBFDA,
	0xD2BD,0xF78F,0x14AF,0x29CA,0x3904,0x3F32,0x3F54,0x3F7D,
	0x3F88,0x3FA5,0x3F40,0x3FD7,0x3C08,0x2ED9,0x2291,0x1770,
	0x0E6E,0x0792,0x03BA,0x0194,0xFEAF,0xF89D,0xEFF6,0xE570,
	0xDCEB,0xD7F6,0xD604,0xD474,0xD1A9,0xCE8B,0xCBD6,0xCC50,
	0xD1C8,0xDCE7,0xEB83,0xFB54,0x0D86,0x1EF0,0x2F5F,0x3C3C,
	0x3EEC,0x3EDB,0x3F04,0x3F12,0x3E88,0x3EFD,0x3766,0x2488,
	0x0F39,0xF802,0xE236,0xD0B8,0xC526,0xC01C,0xBF4F,0xBF69,
	0xC012,0xBF9B,0xC4FB,0xD3EB,0xE398,0xF438,0x044C,0x1261,
	0x1DD4,0x2749,0x2D4E,0x301D,0x3087,0x2F85,0x2DAB,0x2A97,
	0x25DE,0x1F3A,0x1720,0x0E77,0x0696,0x0204,0xFCD1,0xF876,
	0xF523,0xF057,0xEB1F,0xE5D2,0xE12F,0xDE89,0xDD6E,0xDDE3,
	0xDF41,0xE0EE,0xE375,0xE751,0xED13,0xF4BF,0xFCD3,0x065B,
	0x10AC,0x1A5A,0x2242,0x27FE,0x2C2D,0x2E5E,0x2D46,0x29A1,
	0x253F,0x1FB7,0x175B,0x0CD4,0x0141,0xF5B4,0xEAF8,0xE1C8,
	0xDB38,0xD70C,0xD576,0xD56D,0xD691,0xDA31,0xE087,0xE81A,
	0xF064,0xF896,0x00D7,0x092B,0x1061,0x163B,0x1A81,0x1C8A,
	0x1CA9,0x1C20,0x1A78,0x18FB,0x16A1,0x12EA,0x0DE9,0x084B,
	0x032D,0xFF60,0xFB8A,0xF7A4,0xF431,0xF1AF,0xEF72,0xED02,
	0xEABC,0xE9D5,0xE9D4,0xEAEA,0xEC38,0xEE11,0xF164,0xF61C,
	0xFA73,0xFF15,0x04CC,0x07FF,0x0E26,0x1399,0x15F6,0x18E5,
	0x1B11,0x1A7D,0x18F5,0x167D,0x1322,0x0DFD,0x07D0,0x01F5,
	0xFC01,0xF67C,0xF132,0xECB0,0xE942,0xE6BB,0xE50B,0xE5D1,
	0xE870,0xEC1C,0xF029,0xF419,0xF80B,0xFC0C,0x0034,0x055C,
	0x0A09,0x0DA0,0x0F11,0x0F90,0x1038,0x104D,0x0FE8,0x0E3C,
	0x0BB4,0x0805,0x04A3,0x01F3,0x003F,0xFE00,0xFB1C,0xF7C4,
	0xF3BE,0xF167,0xF06F,0xEFF0,0xEEAF,0xEA10,0xE14F,0xD7D1,
	0xD026,0xCBB5,0xC444,0xBEDF,0xBF46,0xBF05,0xBF35,0xC038,
	0xBFB2,0xCEEB,0xF3C6,0x10A7,0x2A36,0x3DD4,0x3FAE,0x3FDF,
	0x401B,0x3FE3,0x3FCF,0x3FB0,0x3F74,0x3E82,0x3F3C,0x28E3,
	0xFDED,0xD5B5,0xC003,0xC040,0xBF4B,0xBF85,0xBFD3,0xBF70,
	0xBF79,0xC068,0xC096,0xD90D,0xFCFE,0x1721,0x29DA,0x383C,
	0x3EAF,0x3EE4,0x3F06,0x3EEC,0x3EDA,0x3EAF,0x3EA8,0x3571,
	0x285F,0x1CB1,0x117E,0x087B,0x027F,0xFE93,0xFB7A,0xF89D,
	0xF1FE,0xE8B9,0xDF17,0xD7B5,0xD2DD,0xD0D7,0xCF07,0xCBF4,
	0xC7B3,0xC501,0xC6F8,0xCF0C,0xDBC1,0xEBA6,0xFE39,0x10F4,
	0x2240,0x31CA,0x3C98,0x3DC6,0x3DF7,0x3E1F,0x3DE8,0x3DB0,
	0x3D26,0x300D,0x1AC5,0x0431,0xEE42,0xDAA1,0xCA33,0xBFDD,
	0xBE99,0xBE91,0xBE62,0xBEF0,0xBE51,0xC3D2,0xD427,0xE5AC,
	0xF6D0,0x057F,0x1217,0x1C5E,0x24E6,0x2B30,0x2E9B,0x2F8A,
	0x2E44,0x2AF9,0x2574,0x1F6D,0x184B,0x110D,0x08E8,0x0210,
	0xFCDF,0xF8FF,0xF4FC,0xEF34,0xE99F,0xE4E0,0xE113,0xDDFA,
	0xDC66,0xDB5B,0xDB2E,0xDBCA,0xDD5D,0xE10A,0xE668,0xEC8B,
	0xF3D6,0xFBFA,0x07B7,0x1255,0x19E6,0x2203,0x2735,0x2A99,
	0x2BFD,0x2B5C,0x2861,0x243B,0x1C9C,0x12B5,0x073E,0xFB63,
	0xF07F,0xE725,0xDF91,0xDA0B,0xD61A,0xD39B,0xD3B0,0xD62D,
	0xDB1A,0xE259,0xEAFC,0xF330,0xFB70,0x0368,0x0AFD,0x11E5,
	0x1679,0x19B6,0x1BB2,0x1C22,0x1B69,0x1A6A,0x1877,0x14B3,
	0x0F45,0x0A1E,0x0605,0x0254,0xFEF8,0xFB0A,0xF6EC,0xF2CB,
	0xEF48,0xECB4,0xEB26,0xEAF8,0xEA7B,0xE9DD,0xEA0C,0xEBB8,
	0xEEDF,0xF298,0xF680,0xFAB2,0xFF96,0x049B,0x096B,0x0E69,
	0x1319,0x165C,0x16D4,0x1707,0x1803,0x16FB,0x13E2,0x0F9F,
	0x0B0B,0x0601,0x0073,0xFAB7,0xF4D3,0xF00C,0xEBE0,0xE894,
	0xE69F,0xE658,0xE787,0xEA06,0xEE28,0xF144,0xF4E5,0xF99F,
	0xFE88,0x0308,0x07A3,0x0C7B,0x106D,0x1216,0x127E,0x1250,
	0x121D,0x1166,0x0FC5,0x0DC6,0x0B66,0x085C,0x04E4,0x019B,
	0xFEAE,0xFBC6,0xF8E6,0xF6F0,0xF5E6,0xF5A8,0xF593,0xF3D1,
	0xF0E0,0xEC66,0xE5FF,0xDF47,0xDABE,0xD79C,0xD1A9,0xC5D1,
	0xBFFE,0xC0CB,0xC12B,0xC0EC,0xC605,0xE2B9,0x00A6,0x195A,
	0x2E52,0x3EF6,0x4070,0x4068,0x40D3,0x408D,0x409D,0x406C,
	0x3FC7,0x404A,0x3778,0x164F,0xF4E9,0xD647,0xC270,0xC0AB,
	0xC08D,0xC067,0xC03E,0xC06A,0xC143,0xC060,0xCEA3,0xEEB8,
	0x09B1,0x1E95,0x2D2B,0x378C,0x3EF0,0x4016,0x3FF5,0x3FF2,
	0x3FBB,0x3F04,0x35BF,0x2AE9,0x2054,0x1556,0x0BEB,0x05B9,
	0x0213,0xFFB7,0xFCC8,0xF904,0xF363,0xEC26,0xE470,0xDEF2,
	0xDD08,0xDBF5,0xD990,0xD66C,0xD43B,0xD473,0xD841,0xDF4D,
	0xEA9F,0xF90E,0x0729,0x147F,0x2461,0x3073,0x3A5A,0x3F90,
	0x3FA6,0x3F71,0x3F8A,0x3B77,0x3098,0x2288,0x1157,0xFEE1,
	0xECBC,0xDCA2,0xD098,0xC809,0xC2D3,0xC06D,0xC03B,0xC386,
	0xCAEA,0xD4F8,0xE152,0xEEB6,0xFBDB,0x086A,0x139F,0x1CB7,
	0x22F3,0x262D,0x26EC,0x25E1,0x23E5,0x21D2,0x1F02,0x19AD,
	0x1341,0x0BAF,0x04A1,0xFF03,0xFA61,0xF6F4,0xF457,0xF103,
	0xED12,0xE8CB,0xE538,0xE2FD,0xE15F,0xE05A,0xE064,0xE24A,
	0xE539,0xE8BA,0xECF4,0xF229,0xF863,0xFF37,0x069F,0x0E99,
	0x18A1,0x2073,0x23C2,0x250C,0x24A3,0x22A7,0x1F24,0x19AC,
	0x1303,0x0BDF,0x0351,0xF979,0xEFC6,0xE7AD,0xE1C1,0xDDB3,
	0xDAA5,0xD9F8,0xDC03,0xDF30,0xE386,0xE9C5,0xEFAE,0xF59A,
	0xFBF7,0x031B,0x09D7,0x1023,0x1440,0x15C4,0x158E,0x143B,
	0x12E9,0x1166,0x0F24,0x0CF8,0x0A6E,0x0617,0x009F,0xFC49,
	0xF8F6,0xF5B1,0xF370,0xF1D5,0xF0C1,0xEE72,0xEC0D,0xEB8E,
	0xEB18,0xEB6D,0xEC6E,0xEDD8,0xF048,0xF41E,0xF813,0xFB39,
	0xFE79,0x01D6,0x05E7,0x0933,0x0B8B,0x0EF5,0x11A8,0x12EE,
	0x1181,0x0EDC,0x0BF5,0x0813,0x0334,0xFEDD,0xFAEF,0xF727,
	0xF2F3,0xEE54,0xEA41,0xE77D,0xE663,0xE6A2,0xE82D,0xEBB4,
	0xF001,0xF3BF,0xF6D6,0xF97C,0xFCC5,0x0080,0x049F,0x082A,
	0x0A87,0x0C38,0x0C57,0x0BC1,0x0A72,0x0978,0x078A,0x04FF,
	0x0291,0x016A,0x008B,0xFE50,0xFB59,0xF7FD,0xF5C3,0xF432,
	0xF328,0xF29B,0xF2FE,0xF347,0xF1FC,0xEF45,0xECCE,0xEBAA,
	0xEBDB,0xEB33,0xE977,0xE5BF,0xE191,0xDE9D,0xDFDB,0xE698,
	0xF0A9,0xFB91,0x078A,0x0F01,0x179A,0x20A8,0x2892,0x3060,
	0x35BF,0x36CB,0x340E,0x2DD4,0x2491,0x1996,0x0CDF,0xFF51,
	0xF196,0xE5B3,0xDCD3,0xD7EF,0xD5D8,0xD4A0,0xD505,0xD777,
	0xDD60,0xE6A2,0xF255,0xFE44,0x089C,0x1066,0x15DF,0x1A23,
	0x1E3D,0x210C,0x213E,0x1F3E,0x1C13,0x1815,0x13D4,0x0F78,
	0x0B1A,0x066F,0x0213,0xFE7A,0xFC0D,0xFB27,0xFAE0,0xFA02,
	0xF7F9,0xF553,0xF326,0xF183,0xF0F4,0xF123,0xF18D,0xF203,
	0xF1E9,0xF27E,0xF472,0xF8C3,0xFE23,0x042F,0x08EA,0x0DB6,
	0x1268,0x162B,0x17C7,0x1A3F,0x1B4B,0x19D5,0x16A7,0x123C,
	0x0DCB,0x08CD,0x02AB,0xFB7E,0xF4CD,0xF023,0xECD2,0xEA2A,
	0xE899,0xE80A,0xE7BA,0xE819,0xE878,0xE94D,0xEBA0,0xED8B,
	0xEDED,0xEE21,0xEE6D,0xEEFF,0xEF43,0xEED6,0xEDB6,0xEBA7,
	0xE923,0xE791,0xE625,0xE403,0xE225,0xE0ED,0xDF72,0xDDE7,
	0xDCE1,0xDC71,0xDC52,0xDB82,0xDACC,0xDB87,0xDC04,0xDAEC,
	0xDAF1,0xDB05,0xDB14,0xDB44,0xDBF6,0xDCEC,0xDE1B,0xDEDD,
	0xDFDB,0xE11C,0xE17A,0xE1EE,0xE359,0xE495,0xE503,0xE584,
	0xE601,0xE633,0xE646,0xE6AE,0xE711,0xE745,0xE7D9,0xE816,
	0xE89A,0xE8CF,0xE947,0xE9D0,0xE9F8,0xEA68,0xEB15,0xEBC2,
	0xECC3,0xEE19,0xEF07,0xEFC5,0xF075,0xF114,0xF160,0xF251,
	0xF344,0xF44B,0xF518,0xF58A,0xF5C3,0xF67D,0xF709,0xF7A9,
	0xF82A,0xF881,0xF8E9,0xF91E,0xF9A0,0xFA15,0xFA5B,0xFAB3,
	0xFB15,0xFB6A,0xFBEB,0xFC7E,0xFCEC,0xFD7E,0xFE79,0xFED2,
	0xFF39,0xFFA4,0x0017,0x00B0,0x0100,0x01E2,0x0299,0x034D,
	0x041A,0x050B,0x032A,0x04A9,0x062E,0x058B,0x0637,0x0655,
	0x0671,0x0668,0x0687,0x06A9,0x0735,0x0729,0x072F,0x0725,
	0x075A,0x07CA,0x0836,0x0886,0x0894,0x08E7,0x096B,0x0A20,
	0x0A66,0x0AC2,0x0AFC,0x0ADB,0x0B22,0x0BD2,0x0C21,0x0C65,
	0x0C7C,0x0CC9,0x0CA2,0x0CB8,0x0CE6,0x0CF9,0x0D82,0x0D94,
	0x0DA2,0x0D52,0x0D8D,0x0DCB,0x0DC9,0x0DF2,0x0DD2,0x0DA1,
	0x0D74,0x0D8A,0x0D7E,0x0DA6,0x0E0A,0x0E4D,0x0EA3,0x0E87,
	0x0E7E,0x0EB5,0x0E9B,0x0F17,0x0F0D,0x0EE1,0x0F17,0x102A,
	0x1290,0x11A1,0x10C4,0x1092,0x10EA,0x10AB,0x10C8,0x10E0,
	0x10D9,0x10C9,0x1091,0x1052,0x1032,0x0FCE,0x0FA3,0x0F65,
	0x0F7F,0x0F36,0x0EC1,0x0E58,0x0F05,0x0F6E,0x0F16,0x0EC2,
	0x0EA4,0x0E8B,0x0E5E,0x0EA4,0x0E53,0x0E3B,0x0E53,0x0E0F,
	0x0E24,0x0E2D,0x0E0A,0x0E57,0x0E0D,0x0DEE,0x0DC3,0x0D3F,
	0x0D30,0x0D4F,0x0D4E,0x0D83,0x0D3F,0x0BB5,0x0C87,0x0D46,
	0x0CF4,0x0CF3,0x0CB4,0x0BFB,0x0BE1,0x0BC9,0x0B81,0x0AF1,
	0x0A94,0x0A02,0x09BE,0x09B2,0x0997,0x09B5,0x09C2,0x098C,
	0x09B4,0x09B5,0x0961,0x093C,0x0947,0x093E,0x0941,0x0928,
	0x0904,0x0954,0x0947,0x0951,0x0944,0x0922,0x08F0,0x08A4,
	0x0875,0x0857,0x084E,0x083C,0x07F0,0x07E3,0x081C,0x0840,
	0x082B,0x07D2,0x07B9,0x07A9,0x07A0,0x07BC,0x07A1,0x0782,
	0x0718,0x075F,0x078E,0x07B4,0x07B9,0x07B8,0x07A4,0x075B,
	0x06F9,0x072D,0x0748,0x0739,0x0655,0x064A,0x065D,0x06AC,
	0x06A2,0x067F,0x068E,0x06B7,0x06B2,0x066B,0x0700,0x074B,
	0x062A,0x0710,0x06FF,0x053A,0x06BA,0x06B3,0x06BC,0x068E,
	0x06AB,0x066A,0x0630,0x062F,0x05FE,0x0609,0x0607,0x061F,
	0x05BA,0x05C3,0x058C,0x0622,0x05F9,0x0590,0x05C4,0x0623,
	0x05F9,0x05AD,0x05AC,0x0574,0x0538,0x057B,0x05B4,0x05CF,
	0x05AC,0x055A,0x04F7,0x04BF,0x0500,0x0509,0x04CC,0x04DD,
	0x04E9,0x04AE,0x0482,0x04E4,0x04ED,0x04FB,0x050E,0x04E3,
	0x04DF,0x050D,0x04DC,0x04A6,0x0452,0x0462,0x0464,0x04AE,
	0x049C,0x0434,0x03B0,0x0396,0x040C,0x0475,0x04B9,0x043D,
	0x038C,0x01AE,0x0079,0x0152,0x0198,0x01CC,0x01EA,0x0214,
	0x01F5,0x01D7,0x01C0,0x01B3,0x018F,0x017F,0x01C7,0x0202,
	0x0218,0x0209,0x0158,0x0232,0x01B9,0x01C6,0x02EF,0x034E,
	0x0252,0x01C3,0x0198,0x01D5,0x0216,0x01F9,0x01E9,0x0238,
	0x0234,0x0257,0x027A,0x02A2,0x0238,0x0248,0x0226,0x022A,
	0x0249,0x0280,0x02BF,0x0265,0x02C2,0x03D4,0x02AB,0x0252,
	0x01EB,0x015C,0x01B4,0x020E,0x0240,0x022D,0x0296,0x02EE,
	0x0322,0x0320,0x0359,0x0404,0x0428,0x03F0,0x03AD,0x0350,
	0x0331,0x0381,0x02F9,0x02E0,0x02E7,0x0303,0x02F0,0x02B9,
	0x026C,0x0239,0x023B,0x0270,0x0245,0x0268,0x0271,0x0249,
	0x01C3,0x0187,0x0172,0x019B,0x0169,0x0144,0x0125,0x00F6,
	0x00F2,0x00DE,0x00D5,0x00D8,0x0095,0x0085,0x00A4,0xFEF1,
	0xFF08,0xFF85,0xFF5E,0xFF50,0xFF01,0xFEFF,0xFF4D,0xFF5C,
	0xFEE4,0xFECA,0xFEF9,0xFF3A,0xFEE7,0xFF1E,0xFF3A,0xFF54,
	0xFF83,0xFF3D,0xFEDA,0xFEDF,0xFF27,0xFDED,0xFDB9,0xFF14,
	0xFFA5,0xFF6B,0xFF7F,0xFF5C,0xFE9C,0xFE4F,0xFE79,0xFE99,
	0xFD4A,0xFD65,0xFD91,0xFD37,0xFC5D,0xFC92,0xFCAC,0xFC78,
	0xFCA0,0xFC8D,0xFC94,0xFC84,0xFCBF,0xFCAC,0xFCB9,0xFCF9,
	0xFCD0,0xFCDC,0xFD0B,0xFD36,0xFD8D,0xFD5B,0xFD25,0xFCE5,
	0xFCFB,0xFD2D,0xFD06,0xFCD5,0xFC9F,0xFD20,0xFD45,0xFCF6,
	0xFCA7,0xFCF5,0xFD68,0xFDC7,0xFE2A,0xFEAC,0xFEE1,0xFF56,
	0xFF82,0x0048,0x0137,0x021B,0x02B3,0x03A7,0x04B9,0x051C,
	0x052D,0x050A,0x0514,0x0502,0x048B,0x046E,0x0497,0x04A8,
	0x049C,0x04A2,0x0530,0x059A,0x060F,0x05E2,0x0620,0x06C1,
	0x06A4,0x07C2,0x0929,0x085B,0x0A94,0x0B02,0x0A8E,0x0B21,
	0x0C9E,0x0D65,0x0D5F,0x0DB5,0x0E72,0x0EEA,0x0F09,0x0FE4,
	0x1086,0x10E6,0x10C6,0x1115,0x1142,0x117A,0x11C9,0x12E6,
	0x144A,0x1463,0x1375,0x12A5,0x136C,0x14E9,0x15DB,0x159D,
	0x15E3,0x1585,0x14FE,0x14CE,0x1566,0x161D,0x16B1,0x1633,
	0x152F,0x1534,0x155D,0x15B1,0x1596,0x1582,0x1531,0x1580,
	0x1592,0x15B1,0x155E,0x1543,0x1508,0x147B,0x1438,0x14DD,
	0x14F1,0x13FE,0x12B5,0x11E1,0x1190,0x114D,0x11FC,0x11CC,
	0x10FA,0x0E94,0x0C55,0x0C66,0x0BFD,0x0AF2,0x090E,0x0756,
	0x0668,0x0599,0x039B,0xFF1B,0xF99F,0xF4AF,0xF13F,0xF15E,
	0xF354,0xF52E,0xF660,0xF7D9,0xF8F1,0xFBDB,0x020F,0x0958,
	0x1092,0x174E,0x1CB7,0x20A1,0x23AB,0x2645,0x27FC,0x2821,
	0x2712,0x2535,0x2312,0x1F59,0x1A49,0x13BA,0x0D1F,0x068B,
	0x00F1,0xFCFB,0xFA0F,0xF6F6,0xF2E9,0xF035,0xEDD2,0xEC52,
	0xED76,0xEFF5,0xF18F,0xF236,0xF2D5,0xF3FE,0xF59E,0xF7BF,
	0xF952,0xFA3A,0xFAF0,0xFCA1,0xFEB6,0xFF86,0x005F,0x0071,
	0x004D,0x00F9,0x02A3,0x05B4,0x07C5,0x08B6,0x08EB,0x088E,
	0x083F,0x0874,0x091F,0x099A,0x083B,0x04F3,0x0146,0xFE2E,
	0xFBD8,0xF92C,0xF57A,0xF1BC,0xEE63,0xEB1F,0xE84E,0xE6AB,
	0xE5C7,0xE5C2,0xE54C,0xE533,0xE660,0xE8B7,0xEB4B,0xED11,
	0xEE87,0xF05C,0xF32A,0xF61B,0xF8EB,0xFB5B,0xFCC5,0xFCA2,
	0xFC1A,0xFC45,0xFCD1,0xFDA5,0xFDAC,0xFD03,0xFB92,0xF9AE,
	0xF894,0xF7A1,0xF690,0xF53C,0xF49C,0xF4C0,0xF3FA,0xF234,
	0xF0E1,0xEF38,0xEBEB,0xECF5,0xEC7E,0xEB63,0xEB00,0xE982,
	0xE777,0xE608,0xE5FC,0xE68C,0xE6C0,0xE720,0xE81D,0xE994,
	0xEADD,0xEBBA,0xED43,0xEF65,0xF130,0xF2F5,0xF51E,0xF784,
	0xF878,0xF83E,0xF835,0xF8E3,0xF9DA,0xFA1D,0xF8E8,0xF701,
	0xF598,0xF496,0xF2FB,0xF142,0xEFEB,0xEEA7,0xED6F,0xEC0B,
	0xEB1B,0xEAA9,0xEA4B,0xE92B,0xE8BA,0xE923,0xE969,0xE9EB,
	0xEA2E,0xEAA9,0xEB75,0xEBEB,0xEC3D,0xEC7F,0xED70,0xEEA7,
	0xEFAD,0xF03B,0xF135,0xF1D2,0xF27F,0xF285,0xF31A,0xF5D4,
	0xF8D3,0xF9B6,0xF9CC,0xF8F9,0xF843,0xF82A,0xF871,0xF88B,
	0xF87C,0xF88C,0xF7F9,0xF631,0xF4A5,0xF3F4,0xF30C,0xF244,
	0xF163,0xEFF2,0xEEFE,0xEE51,0xEF2A,0xEF7B,0xEE4D,0xEDDE,
	0xEEE3,0xEFB1,0xF0E5,0xF1BD,0xF257,0xF37B,0xF448,0xF4C0,
	0xF5A9,0xF6E9,0xF7CD,0xF87D,0xF898,0xF8B8,0xF88D,0xF904,
	0xF918,0xF8EC,0xF8B9,0xF8C3,0xF84C,0xF6CA,0xF697,0xF714,
	0xF716,0xF672,0xF658,0xF5AF,0xF510,0xF488,0xF467,0xF41D,
	0xF334,0xF2A2,0xF29B,0xF1B6,0xF0F1,0xF115,0xF0F1,0xF0E2,
	0xEEF9,0xEAA0,0xE530,0xE0B4,0xDDDD,0xDB4C,0xD409,0xC55D,
	0xBDEF,0xBE54,0xBE2C,0xBE4C,0xBE42,0xBE54,0xBE9D,0xBE5C,
	0xC28F,0xD344,0xEAA8,0x0530,0x1F5F,0x361B,0x3E69,0x3DE2,
	0x3E68,0x3E70,0x3E33,0x3E65,0x3E77,0x3E72,0x3E4E,0x3DF0,
	0x3DF3,0x2E05,0x1453,0xFF3A,0xEFA9,0xE4EE,0xDAB8,0xCF61,
	0xC3E9,0xBEF4,0xBED1,0xBEAB,0xBE9A,0xC371,0xCAAD,0xD1AA,
	0xD881,0xDF14,0xE4C5,0xE970,0xED55,0xF1DE,0xF7B7,0xFDBB,
	0x02E4,0x08D2,0x0993,0x09C9,0x0D47,0x128C,0x1A80,0x22AF,
	0x2A10,0x2EF0,0x31B7,0x32DC,0x3416,0x35B4,0x3702,0x35B8,
	0x312B,0x289B,0x1E34,0x139C,0x0867,0xFC4B,0xEFF9,0xE45D,
	0xD99B,0xD0DD,0xC95E,0xC371,0xC039,0xBFB4,0xBF86,0xC10F,
	0xC8B5,0xD1D2,0xDB6C,0xE4AB,0xED95,0xF6E3,0x003F,0x0A47,
	0x1416,0x1C10,0x2183,0x24CC,0x26C8,0x278C,0x2731,0x2580,
	0x22D1,0x1FF6,0x1D8F,0x1B0A,0x17E3,0x1389,0x0E4C,0x08D7,
	0x04DC,0x0274,0x00BD,0xFE94,0xFBA3,0xF723,0xF18D,0xEC4A,
	0xE85F,0xE4A4,0xE262,0xE091,0xDDFE,0xDC42,0xDB50,0xDB08,
	0xDB88,0xDDA9,0xE151,0xE686,0xEC98,0xF24E,0xF86F,0xFE8B,
	0x045F,0x0A52,0x10F6,0x183A,0x1D5D,0x20BD,0x2298,0x2200,
	0x2032,0x1ED8,0x1CF7,0x1A5F,0x168D,0x11E4,0x0B9E,0x053A,
	0xFF38,0xF986,0xF52D,0xF180,0xEE97,0xEC18,0xE95E,0xE7D3,
	0xE71F,0xE6A0,0xE6EB,0xE800,0xEAF3,0xEE7A,0xEFC4,0xF1AD,
	0xF411,0xF668,0xF79B,0xF9A6,0xFD4A,0x01E3,0x0570,0x07A5,
	0x098F,0x0B83,0x0D2B,0x0FBE,0x12BD,0x14A7,0x15C4,0x15C6,
	0x15DB,0x15F0,0x1588,0x13CE,0x1077,0x0D58,0x0AC4,0x0878,
	0x05B2,0x0138,0xFC19,0xF788,0xF3B1,0xF149,0xF012,0xEF19,
	0xED8F,0xEBF2,0xEAD8,0xEB21,0xED2E,0xF04A,0xF34B,0xF5F1,
	0xF8E1,0xFC15,0xFEFC,0x01F7,0x0545,0x0875,0x0B7D,0x0D66,
	0x0E99,0x0F84,0x1038,0x10B1,0x1060,0x0FFB,0x0F67,0x0E74,
	0x0D4F,0x0BE3,0x0A96,0x0899,0x05CE,0x0395,0x020D,0x0103,
	0x000D,0xFDC8,0xFB48,0xF95E,0xF7FC,0xF6B5,0xF5E5,0xF5DF,
	0xF63D,0xF3C3,0xF13B,0xEF75,0xE989,0xE442,0xE0CA,0xDEB4,
	0xDAFA,0xD02D,0xC22E,0xBF5F,0xBF94,0xBF74,0xBF8A,0xBF58,
	0xBF98,0xBF68,0xC23A,0xCF75,0xE483,0x0085,0x2034,0x3AC2,
	0x3F35,0x3EDD,0x3F32,0x3F43,0x3F5E,0x3F53,0x3F2A,0x3F46,
	0x3F34,0x3F05,0x3E7E,0x3EDC,0x2E25,0x1078,0xF9BC,0xE920,
	0xDD77,0xD34F,0xC738,0xBF8E,0xBF98,0xBF6D,0xBF97,0xBF59,
	0xC3AF,0xCD39,0xD51B,0xDBD0,0xE312,0xEA8D,0xF120,0xF667,
	0xFC2B,0x029A,0x094A,0x0F3F,0x131C,0x14E6,0x162D,0x1B83,
	0x226A,0x2B98,0x34A0,0x3AA9,0x3D33,0x3E11,0x3EE8,0x3FA7,
	0x400A,0x4007,0x3E76,0x3652,0x2B83,0x1F60,0x1244,0x0447,
	0xF61D,0xE925,0xDC87,0xD1FA,0xC959,0xC175,0xBF90,0xBF86,
	0xBFAA,0xBFBB,0xC003,0xC901,0xD443,0xDEC3,0xE8D8,0xF303,
	0xFDB9,0x0835,0x13B6,0x1E04,0x26BA,0x2C04,0x2E79,0x2ED2,
	0x2E16,0x2C33,0x2A87,0x2860,0x243B,0x20EA,0x1CE1,0x170A,
	0x112C,0x0B71,0x074E,0x033B,0xFFCD,0xFD0A,0xF9D5,0xF53D,
	0xEF51,0xE988,0xE4A5,0xE06A,0xDE35,0xDCB6,0xDAD3,0xD868,
	0xD653,0xD559,0xD5C3,0xD820,0xDCA7,0xE1C5,0xE75F,0xEE1C,
	0xF578,0xFC7E,0x0338,0x0A2A,0x117B,0x18E9,0x1F51,0x244F,
	0x26A1,0x26FF,0x2629,0x243C,0x217F,0x1EBD,0x1B00,0x152D,
	0x0E08,0x06D3,0x0051,0xF9AE,0xF393,0xEE25,0xE9EA,0xE67B,
	0xE356,0xE160,0xE008,0xDF5B,0xE023,0xE1AA,0xE371,0xE642,
	0xE904,0xEB5C,0xEDDA,0xF058,0xF3FA,0xF770,0xFAFB,0xFE8C,
	0x01D4,0x0560,0x0848,0x0AA9,0x0CB9,0x0ECC,0x10EC,0x1287,
	0x155C,0x17D3,0x15A1,0x1586,0x1456,0x1238,0x10B2,0x0E8A,
	0x0B5F,0x07EF,0x0428,0xFF03,0xFA3F,0xF638,0xF34C,0xEFB6,
	0xEC44,0xE8FA,0xE7E0,0xE7C3,0xE7E8,0xE7F1,0xE83F,0xE9BA,
	0xECA6,0xF0C9,0xF4A9,0xF8ED,0xFD2F,0xFFDD,0x0216,0x0470,
	0x0810,0x0C2F,0x0F91,0x1193,0x11B3,0x109D,0x1018,0x1058,
	0x1091,0x1015,0x0F1D,0x0D21,0x0B46,0x08D1,0x06F7,0x04BC,
	0x0283,0x00C5,0xFF02,0xFD8C,0xFBCC,0xF9D3,0xF774,0xF5A3,
	0xF41E,0xF306,0xF2D6,0xF345,0xF361,0xF32A,0xF145,0xEC92,
	0xE579,0xDF78,0xDEC7,0xDECB,0xDB7E,0xCF3E,0xC098,0xBEAB,
	0xBEFE,0xBEBE,0xBEBF,0xBF18,0xBF32,0xC095,0xC863,0xD6A8,
	0xEDBB,0x09CA,0x292B,0x3DC1,0x3E6E,0x3EFB,0x3F95,0x3F79,
	0x3F5E,0x3F62,0x3F77,0x3F57,0x3F7D,0x3F3E,0x3F25,0x3CE3,
	0x256E,0x0B06,0xF76A,0xE8CE,0xDD11,0xD1B6,0xC5D1,0xC029,
	0xC03B,0xC057,0xC047,0xC19D,0xCBB8,0xD433,0xDB8E,0xE2FC,
	0xE9EE,0xEF79,0xF499,0xFABD,0x021E,0x09BC,0x0FAE,0x1349,
	0x154E,0x161F,0x18C2,0x1E54,0x2610,0x2E71,0x354D,0x395A,
	0x3B7B,0x3D4C,0x3EC1,0x4044,0x40C3,0x3F65,0x3A23,0x329D,
	0x2851,0x1C61,0x0F2F,0x014D,0xF32E,0xE652,0xDB00,0xD132,
	0xC7C1,0xC0BC,0xC0A3,0xC06F,0xC08A,0xC03C,0xC33A,0xCD9F,
	0xD738,0xE067,0xEAF3,0xF6A9,0x0273,0x0DA6,0x17BF,0x2060,
	0x272C,0x2BBB,0x2E14,0x2E8C,0x2E04,0x2C6F,0x294F,0x268A,
	0x232F,0x1F0A,0x19FC,0x1372,0x0D62,0x091E,0x0563,0x0227,
	0xFE97,0xFAD0,0xF6B0,0xF28F,0xEEB2,0xEAFA,0xE77E,0xE576,
	0xE335,0xDE20,0xDD9B,0xDCCA,0xDAFB,0xDB1A,0xDB97,0xDD96,
	0xE1A9,0xE758,0xEDAB,0xF365,0xF91C,0xFF01,0x05DA,0x0E34,
	0x164F,0x1CA4,0x2086,0x2314,0x24E2,0x26A5,0x2747,0x25D8,
	0x2234,0x1D7A,0x1886,0x130F,0x0D49,0x074A,0x004C,0xF903,
	0xF300,0xEE19,0xEB20,0xE832,0xE5E4,0xE35B,0xE165,0xE12D,
	0xE27D,0xE4D1,0xE722,0xE908,0xEB7F,0xEE87,0xF14B,0xF453,
	0xF73A,0xFA8B,0xFD4F,0xFFF8,0x02FD,0x0594,0x08A3,0x0AD6,
	0x0CDC,0x0EF4,0x1162,0x1376,0x1482,0x14FA,0x1656,0x174F,
	0x158D,0x148D,0x12AC,0x0F9B,0x0C01,0x086F,0x0443,0x0044,
	0xFBB5,0xF735,0xF35F,0xF077,0xEE3A,0xEC2D,0xEA40,0xE8E0,
	0xE86F,0xE8DB,0xEA71,0xEDF3,0xF197,0xF398,0xF58F,0xF8C2,
	0xFC91,0x00D8,0x04E0,0x07BC,0x0A34,0x0C20,0x0D5B,0x0E8C,
	0x0F38,0x0FC1,0x0FE0,0x0F3E,0x0E97,0x0D0C,0x0BD7,0x0AC9,
	0x093F,0x06C7,0x0475,0x01F6,0xFF80,0xFE88,0xFD8E,0xFB59,
	0xF999,0xF82F,0xF5E0,0xF455,0xF332,0xF33E,0xF2C9,0xF13B,
	0xF015,0xF041,0xEE24,0xEA65,0xE556,0xE109,0xDF3D,0xDD7A,
	0xD783,0xC95E,0xBE17,0xBE4A,0xBE00,0xBDFA,0xBE11,0xBE57,
	0xBE4C,0xC0A2,0xCA4E,0xD9F8,0xF25B,0x1080,0x2EDD,0x3DDB,
	0x3DB6,0x3E3F,0x3E5C,0x3E43,0x3E25,0x3E54,0x3E52,0x3E55,
	0x3E41,0x3DC1,0x3E29,0x37C1,0x1C7A,0x02B9,0xF010,0xE266,
	0xD777,0xCC2E,0xC1B3,0xBE9F,0xBEB5,0xBEE2,0xBE66,0xC0A3,
	0xCA73,0xD226,0xD8C3,0xDF2D,0xE6DC,0xEE8E,0xF552,0xF9FA,
	0xFF3D,0x0510,0x0B78,0x1020,0x1332,0x1539,0x170A,0x1A62,
	0x22AD,0x2AA2,0x32AC,0x390B,0x3A31,0x3A4B,0x3AD3,0x3C4E,
	0x3CAD,0x3B44,0x3663,0x2E78,0x22AE,0x15CD,0x08D7,0xFC67,
	0xEF75,0xE220,0xD5C8,0xCBCC,0xC408,0xBF76,0xBF86,0xBF84,
	0xBFD0,0xBF3B,0xC3DB,0xCF34,0xD8C2,0xE26D,0xECC4,0xF845,
	0x0427,0x0F36,0x1961,0x21FD,0x2826,0x2C35,0x2E4A,0x2FA8,
	0x2F76,0x2D9B,0x29D7,0x25B1,0x2291,0x1F74,0x1B44,0x15B1,
	0x0FEC,0x0AA2,0x061A,0x02A0,0xFFD0,0xFC8E,0xF8CA,0xF37C,
	0xEEDB,0xEB73,0xE812,0xE503,0xE289,0xDFAD,0xDD00,0xDB9D,
	0xD9B9,0xDA2E,0xDB8A,0xDD6C,0xE0EE,0xE696,0xED8A,0xF47D,
	0xFB36,0x01F4,0x08FD,0x0F85,0x1603,0x1C97,0x21B0,0x24CB,
	0x2681,0x2708,0x26C6,0x2428,0x20A1,0x1C6C,0x181D,0x129E,
	0x0C33,0x05FB,0xFF47,0xF8B7,0xF2E3,0xEE16,0xEA94,0xE812,
	0xE598,0xE40B,0xE36D,0xE357,0xE472,0xE5E8,0xE75C,0xE98B,
	0xEC99,0xEFCA,0xF330,0xF6D0,0xF9F6,0xFAF4,0xFD65,0x0059,
	0x0396,0x072B,0x0A88,0x0D3F,0x0ED0,0x1036,0x1260,0x147F,
	0x1639,0x16FD,0x178C,0x174F,0x153E,0x128F,0x0F6E,0x0CBD,
	0x0B07,0x07C7,0x02A6,0xFD70,0xF94D,0xF59A,0xF2A1,0xEF4B,
	0xEC33,0xEA01,0xE86E,0xE7DA,0xE897,0xEA0B,0xEB67,0xECD4,
	0xEF79,0xF32C,0xF733,0xFB2B,0xFE5F,0x014C,0x03D5,0x0705,
	0x09ED,0x0C9C,0x0ED8,0x100B,0x104B,0x0FD9,0x0F2D,0x0EAB,
	0x0E3D,0x0D94,0x0BBD,0x09A5,0x07A8,0x0604,0x046D,0x0288,
	0x00A1,0xFE72,0xFB9F,0xF9B3,0xF8DD,0xF840,0xF6BE,0xF4D5,
	0xF2A9,0xF11B,0xF0B5,0xF1D1,0xF20E,0xEF26,0xE99B,0xE3D4,
	0xDE95,0xDDFC,0xDE40,0xD51A,0xC4B9,0xBF4B,0xBFE8,0xBFA5,
	0xBF88,0xBF71,0xBFD5,0xBF8C,0xC33F,0xCEE2,0xE1FA,0xFC60,
	0x1B14,0x37F3,0x3F65,0x3ED9,0x3F6A,0x3F7A,0x3F66,0x3F6E,
	0x3F5B,0x3F3F,0x3F37,0x3F4E,0x3E70,0x3F60,0x32EF,0x1550,
	0xFDEF,0xEBCC,0xDF76,0xD52E,0xC95E,0xC086,0xBF62,0xBF69,
	0xBF85,0xBF2B,0xC2B6,0xCC4B,0xD3D5,0xDAED,0xE1DE,0xE8CD,
	0xEF55,0xF5A7,0xFC2E,0x0344,0x091F,0x0DBF,0x1192,0x1386,
	0x1532,0x1873,0x1E44,0x26CE,0x2F6E,0x35FD,0x3BF8,0x3D84,
	0x3E4E,0x3F68,0x3FD6,0x3F10,0x3B8D,0x351F,0x2C15,0x20CF,
	0x1346,0x04C0,0xF687,0xE90E,0xDD03,0xD29B,0xC9B2,0xC200,
	0xBF93,0xBF94,0xBF7D,0xC01A,0xC01A,0xC635,0xD083,0xDA3D,
	0xE44E,0xEF78,0xFAC1,0x0699,0x1218,0x1B21,0x21A8,0x27A7,
	0x2C5E,0x2EDD,0x2E31,0x2BCE,0x28AB,0x2654,0x243A,0x2105,
	0x1C2E,0x1652,0x1039,0x0985,0x03FF,0x01B6,0xFF0C,0xFBC3,
	0xF7E0,0xF2E6,0xEE50,0xEA3A,0xE692,0xE30A,0xDF83,0xDCA1,
	0xD9F0,0xD7A8,0xD53F,0xD502,0xD5CB,0xD763,0xDAAE,0xDEB1,
	0xE460,0xEAFD,0xF23B,0xF94D,0xFFE6,0x06F9,0x0E17,0x14C1,
	0x1B7D,0x20C0,0x23EE,0x251E,0x2438,0x2281,0x20E0,0x1E7F,
	0x1A20,0x1441,0x0DB0,0x06F4,0x002E,0xF95E,0xF37B,0xEE92,
	0xEA4F,0xE622,0xE2DF,0xE152,0xE034,0xDF86,0xDF71,0xE09C,
	0xE2DE,0xE5B7,0xE91D,0xEC33,0xEDE1,0xEFB5,0xF242,0xF57E,
	0xF992,0xFDE2,0x00E4,0x030B,0x056F,0x07DD,0x0A7D,0x0D09,
	0x0FE9,0x1178,0x1313,0x140A,0x14E3,0x14B4,0x125E,0x1106,
	0x102F,0x0BD5,0x0A60,0x0764,0x02DB,0xFDB0,0xF893,0xF41B,
	0xF1B8,0xEEB7,0xEB9C,0xE929,0xE700,0xE5A2,0xE540,0xE645,
	0xE896,0xEB5B,0xED95,0xEFD9,0xF2F6,0xF777,0xFB8E,0xFECE,
	0x01FA,0x057C,0x0863,0x0B3A,0x0DD5,0x0F68,0x109F,0x1006,
	0x0F23,0x0F6E,0x101F,0x0FBF,0x0E59,0x0BFE,0x0993,0x06F0,
	0x052C,0x046B,0x03D8,0x0214,0xFF15,0xFBBA,0xF9CC,0xF8C4,
	0xF7CC,0xF738,0xF65A,0xF50E,0xF395,0xF2A9,0xF2AF,0xF35D,
	0xF298,0xEF15,0xEA94,0xE681,0xE44F,0xE23A,0xDDBD,0xD25A,
	0xC15B,0xBE19,0xBEC5,0xBE6D,0xBE90,0xBEEF,0xBF11,0xBF0F,
	0xC585,0xD2E5,0xE802,0x03AD,0x2209,0x3B1B,0x3EEC,0x3EB7,
	0x3F3A,0x3F80,0x3F70,0x3EDD,0x3F1C,0x3F7A,0x3F79,0x3F13,
	0x3ED6,0x3E38,0x2C74,0x10F8,0xFB27,0xEA51,0xDE56,0xD417,
	0xC894,0xC079,0xC01B,0xC02F,0xC027,0xC08B,0xC7CC,0xD14E,
	0xD98F,0xE14E,0xE81A,0xEFAA,0xF5DD,0xFA0C,0xFF6D,0x066B,
	0x0D22,0x1241,0x14F9,0x1638,0x1821,0x1C81,0x2355,0x2C28,
	0x340F,0x39BF,0x3D3F,0x3E8D,0x4000,0x40D4,0x409C,0x406B,
	0x3C3E,0x352F,0x2BE3,0x209E,0x13DA,0x0594,0xF785,0xEA3E,
	0xDE35,0xD462,0xCC37,0xC47E,0xC070,0xC095,0xC0E3,0xC036,
	0xC3AF,0xCE0F,0xD6CD,0xE036,0xEA35,0xF5A8,0x01E6,0x0D56,
	0x171D,0x1F43,0x25E3,0x2B18,0x2EB2,0x3099,0x3010,0x2D23,
	0x2A05,0x2777,0x24FE,0x2114,0x1B49,0x154A,0x0F7C,0x0AA5,
	0x070C,0x0450,0x015B,0xFD10,0xF7E5,0xF30E,0xEFC2,0xECED,
	0xE9A0,0xE64C,0xE385,0xE0DF,0xDE5B,0xDC30,0xDBCA,0xDBA3,
	0xDAFD,0xDE92,0xE259,0xE660,0xEC28,0xF274,0xF8A9,0xFEE1,
	0x0541,0x0C8B,0x1473,0x1BA4,0x207F,0x23A9,0x2575,0x26B6,
	0x26C0,0x25C9,0x23B0,0x1FB1,0x1A68,0x145D,0x0DF8,0x07BA,
	0x01CD,0xFBA9,0xF57E,0xEFBD,0xEB93,0xE8BD,0xE6DB,0xE507,
	0xE336,0xE16D,0xE1C0,0xE3E0,0xE734,0xE9D7,0xEB66,0xED11,
	0xEF14,0xF1FD,0xF57D,0xF96C,0xFC9C,0xFF4D,0x0147,0x033A,
	0x066C,0x09D1,0x0C48,0x0E12,0x0F87,0x117C,0x12B4,0x1328,
	0x1389,0x12F6,0x1209,0x1046,0x0E53,0x0DDA,0x0C07,0x0705,
	0x0275,0xFDDF,0xF961,0xF516,0xF1A3,0xEEA4,0xEB9C,0xE925,
	0xE72E,0xE6AB,0xE6C6,0xE745,0xE847,0xEAED,0xEE46,0xF18E,
	0xF412,0xF6E3,0xFB07,0xFEF3,0x01DC,0x0525,0x0894,0x0A2A,
	0x0ACD,0x0C39,0x0D3D,0x0E48,0x0E9E,0x0E2B,0x0CE2,0x0AFD,
	0x0A11,0x0903,0x072A,0x049E,0x020F,0x008B,0xFE98,0xFC6B,
	0xFA4A,0xF94E,0xF78B,0xF413,0xF325,0xF295,0xF1BF,0xF0D7,
	0xF01B,0xEF5B,0xEF63,0xEFA3,0xEE93,0xEB77,0xE6BD,0xE2BA,
	0xDFF1,0xDDDD,0xDA89,0xD19A,0xC252,0xBDC3,0xBE1D,0xBDFA,
	0xBE30,0xBE00,0xC04B,0xC735,0xCDFB,0xDA20,0xED97,0x0646,
	0x219B,0x3864,0x3E2F,0x3DC8,0x3E3A,0x3E33,0x3E4D,0x3E4B,
	0x3E3C,0x3E3F,0x3E44,0x3DC0,0x3E6F,0x342F,0x1B70,0x0511,
	0xF28B,0xE4FA,0xDAC0,0xD18F,0xC8A1,0xBFEC,0xBE96,0xBEF5,
	0xBE71,0xC45C,0xCE12,0xD555,0xDBCC,0xE21A,0xE88D,0xEEA7,
	0xF439,0xF9B1,0xFDED,0x0277,0x072F,0x0BEE,0x0ED3,0x10A1,
	0x120D,0x1503,0x1A78,0x21D3,0x28E3,0x2D80,0x2EFB,0x3116,
	0x30E3,0x3157,0x338E,0x3236,0x2D85,0x2652,0x1CD3,0x12F7,
	0x08E4,0xFDD8,0xF22A,0xE687,0xDBBC,0xD2A9,0xCBC3,0xC693,
	0xC274,0xC033,0xBF21,0xC207,0xC99C,0xD2E2,0xDCA2,0xE591,
	0xEE25,0xF6A0,0xFF48,0x0A09,0x146A,0x1C9B,0x2290,0x24FC,
	0x25D3,0x2669,0x26B5,0x268F,0x24A4,0x20FA,0x1D6C,0x19B5,
	0x1550,0x112C,0x0C93,0x080F,0x040B,0x0112,0xFED4,0xFBFD,
	0xF91E,0xF513,0xF09E,0xEC95,0xEA1C,0xE8C7,0xE7D6,0xE5C9,
	0xE320,0xE0AB,0xDF9B,0xDFF5,0xE1B7,0xE3EE,0xE713,0xE97E,
	0xED77,0xF357,0xF8B0,0xFE89,0x0530,0x0BDA,0x1236,0x183A,
	0x1D07,0x1FCA,0x20B8,0x20F6,0x2137,0x2079,0x1E0A,0x1A8A,
	0x1699,0x1126,0x09C3,0x03D6,0xFFC2,0xFAF8,0xF600,0xF138,
	0xED92,0xEB00,0xE9AB,0xE86D,0xE767,0xE738,0xE78F,0xE8D7,
	0xEB86,0xEE88,0xF150,0xF369,0xF51C,0xF756,0xFA58,0xFD4A,
	0x00F7,0x0392,0x06A4,0x09A2,0x0AD2,0x0C77,0x0EB1,0x1147,
	0x12C8,0x1407,0x14BF,0x1558,0x15F2,0x1546,0x1451,0x1357,
	0x11B6,0x0F9F,0x0CA3,0x0902,0x0555,0x019F,0xFDC8,0xFA40,
	0xF759,0xF4CB,0xF1EB,0xEFE7,0xEF42,0xEEDC,0xEE8A,0xEECE,
	0xEFD3,0xF1E3,0xF436,0xF762,0xFA17,0xFCF8,0xFFD5,0x029B,
	0x05CD,0x088B,0x0A78,0x0C67,0x0DF5,0x0EF0,0x0F6E,0x0FB3,
	0x0F54,0x0E61,0x0D82,0x0D3B,0x0C65,0x0A86,0x083D,0x0609,
	0x0436,0x0272,0x014A,0xFFFE,0xFE49,0xFBA3,0xF98A,0xF83F,
	0xF78A,0xF6E8,0xF5C9,0xF53B,0xF506,0xF546,0xF50E,0xF3DA,
	0xF227,0xF098,0xEFD8,0xF094,0xF1C5,0xF0FB,0xED3B,0xE52B,
	0xDF74,0xDF48,0xE02D,0xE4C5,0xEA87,0xEEAF,0xF112,0xF3F9,
	0xF9C7,0x02FB,0x0DEE,0x1882,0x21E1,0x2996,0x2F0C,0x3235,
	0x3403,0x341F,0x32FD,0x3140,0x2E62,0x29F3,0x2321,0x1A6D,
	0x0F93,0x049C,0xFAF4,0xF468,0xF075,0xED96,0xEA3E,0xE631,
	0xE1CC,0xDF24,0xDF63,0xE339,0xE85A,0xED38,0xF16E,0xF4A8,
	0xF6E7,0xF890,0xFAF9,0xFE44,0x01CB,0x04F8,0x079B,0x0996,
	0x0A72,0x09A7,0x0966,0x0A5A,0x0CBC,0x103B,0x12F7,0x1417,
	0x1398,0x1388,0x133D,0x1306,0x12A0,0x149D,0x1406,0x10E0,
	0x0D32,0x088E,0x02FE,0xFDD2,0xF895,0xF3BF,0xF116,0xEEF1,
	0xEC69,0xE868,0xE521,0xE387,0xE38B,0xE56A,0xE8E4,0xECFC,
	0xF054,0xF2E1,0xF66E,0xFA56,0xFEE2,0x03A4,0x07BD,0x0AF4,
	0x0D5F,0x0EE3,0x0FD8,0x1052,0x0FD3,0x0E93,0x0DB2,0x0C81,
	0x0AE7,0x08D9,0x0607,0x0366,0x0157,0xFF3C,0xFD48,0xFC13,
	0xFB0A,0xF98A,0xF691,0xF434,0xF417,0xF33E,0xF223,0xF19A,
	0xF129,0xF082,0xF02E,0xEF0B,0xEE90,0xEEA4,0xEF7D,0xF0E2,
	0xF253,0xF363,0xF540,0xF6E3,0xF90C,0xFB48,0xFDDF,0x0118,
	0x0495,0x069C,0x07EF,0x0905,0x0972,0x093B,0x0971,0x08D0,
	0x0847,0x0777,0x0674,0x04AB,0x02D5,0x00E7,0xFF7D,0xFDEF,
	0xFC6E,0xFB10,0xFA2F,0xF932,0xF7D2,0xF769,0xF818,0xF890,
	0xF863,0xF8C5,0xF8E4,0xF96F,0xFA38,0xF9F4,0xF995,0xF94F,
	0xF97E,0xF94F,0xF8B6,0xF824,0xF7B5,0xF757,0xF6A7,0xF5E8,
	0xF543,0xF472,0xF37C,0xF290,0xF18F,0xF136,0xF024,0xEFA0,
	0xEE95,0xEDBE,0xECF5,0xEC0B,0xEB85,0xE9E7,0xE98E,0xE9E7,
	0xE72F,0xE798,0xE7C9,0xE6EE,0xE658,0xE642,0xE5D8,0xE50E,
	0xE48D,0xE4B8,0xE493,0xE469,0xE417,0xE40C,0xE41E,0xE43A,
	0xE48D,0xE4AC,0xE43E,0xE3C8,0xE2E6,0xE301,0xE3F5,0xE488,
	0xE4B7,0xE4FE,0xE4BB,0xE4CF,0xE513,0xE5A0,0xE653,0xE69B,
	0xE6BB,0xE68A,0xE6D1,0xE6C2,0xE706,0xE6F9,0xE72C,0xE76E,
	0xE7B1,0xE7F1,0xE888,0xE8B5,0xE91E,0xE98F,0xEA06,0xEAF9,
	0xEB97,0xEC80,0xECBB,0xECEA,0xED22,0xED98,0xEDEF,0xEE7A,
	0xEEDA,0xEF6B,0xF012,0xF02A,0xF092,0xF14A,0xF0C9,0xEF8A,
	0xF0ED,0xF1E2,0xF29B,0xF341,0xF3AC,0xF476,0xF4F8,0xF56B,
	0xF582,0xF5BD,0xF59B,0xF59B,0xF647,0xF73B,0xF801,0xF87D,
	0xF9A3,0xF9EE,0xF983,0xFA77,0xFB89,0xFC0B,0xFC40,0xFCD6,
	0xFD22,0xFDD1,0xFE6E,0xFE36,0xFEFE,0x0009,0x0073,0x00F1,
	0x01BA,0x028D,0x029F,0x02F0,0x037D,0x0428,0x04BD,0x0537,
	0x0594,0x05E2,0x06E8,0x06EB,0x05B0,0x0646,0x06E7,0x0765,
	0x07C1,0x07FE,0x0837,0x0848,0x08D2,0x09A0,0x0A57,0x0AA4,
	0x0AB2,0x0B49,0x0B51,0x0B77,0x0B49,0x0BA1,0x0C4C,0x0CAB,
	0x0CBD,0x0C88,0x0C99,0x0D36,0x0D57,0x0DE3,0x0DCA,0x0DB2,
	0x0DC2,0x0DF8,0x0E6B,0x0E93,0x0E55,0x0E22,0x0E0C,0x0E2B,
	0x0EBA,0x0F2D,0x0EEE,0x0E76,0x0E58,0x0E2C,0x0EE7,0x0F14,
	0x0EC4,0x0E99,0x0ECB,0x0EA2,0x0ED9,0x0F1D,0x0ED8,0x0EAE,
	0x0EBB,0x0EB0,0x0E9D,0x0F0F,0x0F55,0x0FAE,0x0FBF,0x0FD2,
	0x0F97,0x0F62,0x0F57,0x0F83,0x0F7A,0x0F81,0x0FA9,0x0F51,
	0x0F7A,0x0F64,0x0F4A,0x0F5D,0x0F79,0x0FF2,0x103C,0x0E52,
	0x0FB7,0x0F8C,0x0E91,0x0F4B,0x0FD6,0x0F9E,0x0FA7,0x0F9F,
	0x0F5C,0x0F3E,0x0F2D,0x0F6E,0x0F5F,0x0F43,0x0EEC,0x0F48,
	0x0F22,0x0EC7,0x0E9A,0x0E9D,0x0E95,0x0E64,0x0E99,0x0EBA,
	0x0E77,0x0E0E,0x0DAF,0x0CE8,0x0D41,0x0D8E,0x0DB5,0x0D72,
	0x0D73,0x0D1D,0x0D69,0x0D64,0x0D4F,0x0D96,0x0D46,0x0CE2,
	0x0C5D,0x0C13,0x0C26,0x0C78,0x0C16,0x0BDD,0x0BE6,0x0BD2,
	0x0BEE,0x0BB5,0x0B6F,0x0B26,0x0AF8,0x0AF2,0x0ADE,0x0A8C,
	0x0A7F,0x0A24,0x0A32,0x0A8C,0x0BF2,0x0E05,0x0CF2,0x0CAE,
	0x0C56,0x0C00,0x0BB1,0x0B8E,0x0B9E,0x0B41,0x0B5B,0x0B68,
	0x0B3A,0x0AFF,0x0AA2,0x0A33,0x0A46,0x0A81,0x0A99,0x0A1B,
	0x095F,0x098F,0x09BF,0x092D,0x0933,0x09D6,0x0979,0x08FF,
	0x08A5,0x084A,0x0854,0x0843,0x07F9,0x07DE,0x077D,0x075B,
	0x070C,0x06E9,0x0712,0x06B5,0x06A5,0x06B0,0x065A,0x0627,
	0x066D,0x0627,0x0477,0x04C5,0x05E3,0x057E,0x057C,0x0580,
	0x0546,0x0537,0x0568,0x0558,0x0500,0x043D,0x03F7,0x03B3,
	0x02F2,0x02B7,0x031E,0x02A3,0x0283,0x02D3,0x028C,0x023A,
	0x0262,0x0270,0x023A,0x021C,0x021D,0x0221,0x020F,0x0221,
	0x01FC,0x01CD,0x01C3,0x020B,0x0265,0x0259,0x0208,0x01B0,
	0x0187,0x01AB,0x0166,0x0146,0x01CB,0x0210,0x01C3,0x01B3,
	0x017C,0x0134,0x015D,0x0175,0x0126,0x010E,0x0176,0x0187,
	0x0168,0x013D,0x0136,0x0175,0x00FB,0x0084,0xFFF3,0xFFE4,
	0xFFDA,0xFF91,0xFF69,0xFF21,0xFEF3,0xFED4,0xFEF1,0xFEEA,
	0xFEEA,0xFED7,0xFE8F,0xFEBD,0xFEDB,0xFEB6,0xFEB0,0xFEF1,
	0xFE44,0xFD70,0xFE83,0xFF1E,0xFF15,0xFEC7,0xFED7,0xFEA0,
	0xFE54,0xFE2B,0xFE36,0xFDC7,0xFD8F,0xFD4D,0xFD44,0xFC93,
	0xFC88,0xFCDE,0xFC86,0xFC94,0xFC97,0xFD0C,0xFCD8,0xFC84,
	0xFC91,0xFCC6,0xFCA7,0xFC8D,0xFC62,0xFC1A,0xFC4D,0xFCAB,
	0xFC83,0xFC6F,0xFC4A,0xFC55,0xFC95,0xFC83,0xFCAC,0xFCAC,
	0xFC99,0xFCD5,0xFD1C,0xFCE1,0xFD15,0xFD70,0xFD73,0xFD2E,
	0xFD40,0xFD17,0xFCFD,0xFD01,0xFC52,0xFCAC,0xFD12,0xFCC8,
	0xFCFB,0xFD4E,0xFD43,0xFD47,0xFD59,0xFD9B,0xFD96,0xFD7E,
	0xFD8A,0xFDD7,0xFDD6,0xFE44,0xFDC8,0xFE17,0xFE3A,0xFE86,
	0xFE61,0xFEBA,0xFEB5,0xFE4B,0xFE07,0xFFA5,0xFD7A,0xFE5B,
	0xFEC0,0xFE5E,0xFE43,0xFE79,0xFE9C,0xFE95,0xFEAB,0xFE60,
	0xFED5,0xFECF,0xFEF9,0xFEAA,0xFF1C,0xFF71,0xFFDE,0xFFFC,
	0x007F,0x0153,0x01FF,0x01A3,0x015E,0x02ED,0x0510,0x067E,
	0x0728,0x0834,0x08C2,0x0862,0x0886,0x0915,0x0907,0x092D,
	0x08CC,0x08AB,0x091C,0x08EC,0x0934,0x0965,0x099A,0x0999,
	0x098F,0x09A2,0x09ED,0x0A6D,0x0B0B,0x0BA4,0x0BB5,0x0BFB,
	0x0CCA,0x0D90,0x0E33,0x0EDD,0x0FC4,0x1093,0x10F6,0x1124,
	0x11C2,0x12C0,0x1326,0x138E,0x12F7,0x111B,0x11EB,0x1297,
	0x12FE,0x1308,0x1371,0x1422,0x1486,0x149C,0x143E,0x14A8,
	0x1518,0x1593,0x1544,0x14C6,0x14C4,0x150F,0x15F3,0x1656,
	0x15A2,0x1598,0x159F,0x1573,0x14ED,0x1542,0x15C9,0x1651,
	0x16C3,0x1712,0x1660,0x1537,0x1478,0x14AB,0x14D9,0x14F3,
	0x153A,0x158E,0x145A,0x133C,0x12DB,0x12FB,0x137B,0x12D8,
	0x12F7,0x1293,0x1185,0x10B4,0x0FA0,0x0F03,0x0EA9,0x0EA8,
	0x0E54,0x0E7C,0x0E85,0x0E3D,0x0D9A,0x0D23,0x0CFF,0x0DCE,
	0x0DD0,0x0CF0,0x0C2E,0x0BF7,0x0BA1,0x0AFD,0x0AD0,0x0AF2,
	0x0AF5,0x09BE,0x0885,0x084A,0x07EA,0x0620,0x039C,0x00E2,
	0xFF1D,0xFD0F,0xF902,0xF3C9,0xEDAC,0xE7C3,0xE43E,0xE3B9,
	0xE53E,0xE6AD,0xE713,0xE756,0xE917,0xED82,0xF41B,0xFBC8,
	0x03FB,0x0B60,0x1176,0x16DB,0x1B89,0x1F90,0x223C,0x237E,
	0x2415,0x2436,0x23C7,0x2233,0x1DFE,0x185A,0x1297,0x0DCE,
	0x0A91,0x07FE,0x0501,0x01BA,0xFD62,0xF8F0,0xF62E,0xF4C3,
	0xF497,0xF4C6,0xF3FA,0xF246,0xF02D,0xECA4,0xECD4,0xECA0,
	0xE98C,0xE74A,0xE51D,0xE423,0xE3C0,0xE35C,0xE318,0xE2BE,
	0xE35D,0xE50F,0xE7EB,0xEB52,0xEEF6,0xF244,0xF58D,0xF93F,
	0xFCC2,0x00B7,0x04DC,0x0733,0x086B,0x0925,0x0984,0x0975,
	0x08A7,0x06ED,0x04DC,0x0225,0xFEB0,0xFB54,0xF7FF,0xF5A4,
	0xF379,0xF131,0xEE8E,0xEC38,0xEA4E,0xE964,0xE880,0xE7A7,
	0xE715,0xE603,0xE564,0xE50F,0xE48A,0xE3EB,0xE3C9,0xE3AD,
	0xE35E,0xE336,0xE391,0xE3F6,0xE45E,0xE54D,0xE6DB,0xE863,
	0xEA15,0xEC03,0xEF70,0xF3D7,0xF533,0xF694,0xF8F2,0xFB7D,
	0xFD18,0xFE17,0xFF11,0xFFB3,0xFF60,0xFEC2,0xFE54,0xFD68,
	0xFB70,0xF90A,0xF6E6,0xF59A,0xF3E7,0xF16E,0xEE68,0xED4F,
	0xEC1E,0xE9E8,0xE804,0xE7A3,0xE779,0xE65D,0xE5EC,0xE538,
	0xE573,0xE58B,0xE5BE,0xE5A0,0xE653,0xE6CF,0xE8A5,0xE8EA,
	0xE900,0xE91E,0xEA4D,0xEBC6,0xED34,0xEDF5,0xEFAE,0xF0DA,
	0xF093,0xF266,0xF448,0xF5CE,0xF792,0xF8E4,0xF9A4,0xFA63,
	0xFA6D,0xFA13,0xF9C0,0xF8C6,0xF802,0xF6FE,0xF564,0xF395,
	0xF35D,0xF2E7,0xF1C4,0xEFCB,0xEE48,0xECDF,0xEB91,0xEBE5,
	0xEC54,0xECA9,0xEC0F,0xEADD,0xEA48,0xEABB,0xEB8B,0xEC50,
	0xEC5E,0xECA6,0xED86,0xEE4A,0xEEA3,0xEF8B,0xF094,0xF11C,
	0xF150,0xF18D,0xF310,0xF48C,0xF5BB,0xF5EE,0xF619,0xF698,
	0xF7E4,0xF885,0xF8BF,0xF9C8,0xFA3C,0xFA53,0xFA8A,0xFAE2,
	0xFABD,0xF9FC,0xF93D,0xF91F,0xF976,0xF93D,0xF7CD,0xF627,
	0xF5D9,0xF54A,0xF44F,0xF38E,0xF409,0xF481,0xF431,0xF376,
	0xF302,0xF340,0xF36D,0xF288,0xF457,0xF52F,0xF49F,0xF65E,
	0xF670,0xF71B,0xF7F7,0xF853,0xF833,0xF8FD,0xFA3B,0xFADE,
	0xF88C,0xF3A3,0xEE69,0xEB32,0xE969,0xE4EF,0xDB9E,0xCBEE,
	0xBFEA,0xBF6D,0xBF5A,0xBF2E,0xBF73,0xBF61,0xBF87,0xBFB4,
	0xC01B,0xCCEA,0xE19D,0xF6C6,0x0BA1,0x1E1E,0x2F18,0x3C72,
	0x3F30,0x3F43,0x3F6E,0x3F61,0x3F99,0x3F62,0x3F5C,0x3F62,
	0x3F19,0x3F2E,0x3892,0x2BC8,0x2341,0x1DE0,0x193E,0x1269,
	0x089D,0xFEB5,0xF7D0,0xF5A2,0xF656,0xF649,0xF451,0xF0F0,
	0xECE8,0xE80B,0xE428,0xE029,0xDA76,0xD52F,0xD229,0xD0A4,
	0xD033,0xCF8B,0xCE29,0xCD47,0xCF71,0xD6F4,0xE163,0xECF8,
	0xF73B,0x009F,0x08D3,0x1154,0x1B81,0x26A6,0x319C,0x3889,
	0x3B9A,0x3CE8,0x3D0A,0x3B5C,0x3831,0x3416,0x2E72,0x27A9,
	0x20B3,0x1910,0x10EC,0x096E,0x01E7,0xFB1E,0xF537,0xF199,
	0xEFFF,0xEE70,0xEB7E,0xE7E2,0xE4F0,0xE2F2,0xE28A,0xE336,
	0xE525,0xE43A,0xE1C1,0xDF76,0xDE06,0xDE47,0xE076,0xE2AD,
	0xE4FC,0xE742,0xEA5A,0xEF47,0xF499,0xF9FF,0xFFFC,0x067E,
	0x0C87,0x1287,0x18AE,0x1E6B,0x22D2,0x2560,0x260F,0x2606,
	0x269E,0x269D,0x24FD,0x20E6,0x1BA5,0x1672,0x112C,0x0B2D,
	0x05AB,0x0118,0xFD22,0xF861,0xF3DD,0xF005,0xED5F,0xEAEE,
	0xE8E7,0xE7D2,0xE7B0,0xE7F9,0xE86A,0xE8B2,0xE886,0xE8B7,
	0xE8F4,0xE9D9,0xEC4D,0xEE5A,0xF022,0xF16D,0xF23E,0xF401,
	0xF776,0xFB24,0xFEA9,0x0195,0x0478,0x081B,0x0BC1,0x0F10,
	0x11D2,0x135E,0x14FD,0x170B,0x1847,0x18BC,0x181D,0x15F0,
	0x1311,0x10A4,0x0E62,0x0D0B,0x0903,0x039E,0x00D5,0xFBEB,
	0xF8FE,0xF736,0xF4A0,0xF1D3,0xEFC4,0xEE56,0xEDD5,0xEDAA,
	0xED83,0xED31,0xED62,0xEE3A,0xEF54,0xF090,0xF1EC,0xF352,
	0xF436,0xF54C,0xF6F1,0xF8EE,0xFBE4,0xFD6B,0xFEC4,0x00B9,
	0x035C,0x057F,0x06CC,0x0885,0x0AA9,0x0C92,0x0DBA,0x0EB7,
	0x0FA5,0x1064,0x0F90,0x0E1C,0x0DC4,0x0D9C,0x0C2E,0x0A27,
	0x0813,0x0580,0x025A,0x001D,0xFE3E,0xFC59,0xFA84,0xF885,
	0xF66F,0xF484,0xF3EC,0xF388,0xF34B,0xF3B3,0xF37F,0xF35D,
	0xF489,0xF61B,0xF949,0xFAD5,0xFACD,0xFB4C,0xFC14,0xFD80,
	0xFF79,0x0128,0x01D3,0x0087,0xFCDC,0xF807,0xF478,0xF28A,
	0xF085,0xEA26,0xDCFC,0xC958,0xBFA1,0xBFD2,0xBF51,0xBFC9,
	0xBFC4,0xBF43,0xBF91,0xBFD3,0xC163,0xD10B,0xE83B,0x00A0,
	0x1715,0x2A88,0x3AB2,0x3F16,0x3ED2,0x3EEF,0x3EEC,0x3ED7,
	0x3EE4,0x3ED3,0x3EDB,0x3EC0,0x3E4C,0x3EF9,0x39A0,0x2D61,
	0x25D1,0x212E,0x1A57,0x116D,0x0803,0x002E,0xFAB6,0xF852,
	0xF7BF,0xF754,0xF62F,0xF334,0xEE4B,0xE91E,0xE2DD,0xDD4B,
	0xD929,0xD5B1,0xD27F,0xD052,0xCF12,0xCD10,0xCB69,0xCC1B,
	0xD038,0xD7A2,0xE201,0xEE0D,0xF9FE,0x0446,0x0DCD,0x17D9,
	0x21C8,0x2C2B,0x35B9,0x3D22,0x3E59,0x3E47,0x3E3A,0x3E2C,
	0x39EE,0x3447,0x2ED3,0x2810,0x20C0,0x1928,0x101C,0x0651,
	0xFD4D,0xF6A4,0xF2BA,0xF000,0xEDDF,0xEB8E,0xE891,0xE565,
	0xE2A6,0xE12D,0xE0CE,0xE161,0xE156,0xE0AD,0xDF45,0xDDC1,
	0xDD42,0xDD21,0xDDF6,0xDE9C,0xE200,0xE624,0xEAF3,0xEEC1,
	0xF2BA,0xF796,0xFD54,0x0469,0x0DBF,0x1457,0x1AF9,0x1FF4,
	0x2239,0x24BD,0x26F6,0x2851,0x2835,0x2728,0x2434,0x1F98,
	0x1A17,0x1493,0x0F3B,0x095B,0x0398,0xFE3A,0xF9A5,0xF5D7,
	0xF18F,0xED56,0xEA15,0xE7C6,0xE6B6,0xE651,0xE6D5,0xE71C,
	0xE71B,0xE72C,0xE6F1,0xE78F,0xE8EB,0xEA8E,0xEBCC,0xED03,
	0xEEAC,0xF152,0xF3B5,0xF50D,0xF6C9,0xF9D1,0xFDF9,0x0293,
	0x06D9,0x0A3E,0x0DA4,0x1078,0x12E6,0x150E,0x1813,0x1AA9,
	0x1B42,0x1A09,0x183B,0x1718,0x159B,0x1319,0x0F8A,0x0BA9,
	0x07EF,0x03CF,0x0015,0xFC4D,0xF785,0xF3D2,0xF0DF,0xEE10,
	0xEC9E,0xEC5E,0xEC86,0xEC20,0xEB4C,0xEA7B,0xEAD2,0xEC7B,
	0xEECE,0xF103,0xF24E,0xF319,0xF3D8,0xF5BF,0xF7CB,0xF9C3,
	0xFCA4,0xFF20,0x0068,0x01F7,0x049F,0x082F,0x0A54,0x0B4A,
	0x0C25,0x0D25,0x0F63,0x1051,0x1199,0x125E,0x1155,0x0F8A,
	0x0E23,0x0D7E,0x0CE7,0x0B15,0x07FE,0x0510,0x0259,0x00FA,
	0xFF08,0xFB8C,0xF94E,0xF75D,0xF52B,0xF395,0xF313,0xF2FD,
	0xF281,0xF1CA,0xF28A,0xF44A,0xF5E5,0xF72B,0xF80D,0xF86E,
	0xF992,0xFB00,0xFC85,0xFE1E,0xFFBB,0x0097,0xFF1D,0xFB29,
	0xF60E,0xF25B,0xF0E2,0xEEAF,0xE726,0xD7F9,0xC555,0xC02C,
	0xC0B5,0xC055,0xC059,0xC05B,0xC044,0xC0AC,0xC0A7,0xC7FD,
	0xDAF0,0xF164,0x090C,0x1EF9,0x32A7,0x3ED7,0x3FE7,0x3FD0,
	0x3FFA,0x3FFA,0x3FF3,0x3FF3,0x4003,0x3FE7,0x3F93,0x3FAB,
	0x3F06,0x350A,0x2A7A,0x24A3,0x1F5E,0x17B4,0x0D44,0x02AF,
	0xFB4E,0xF80F,0xF7D1,0xF7FB,0xF643,0xF3BA,0xF0C4,0xED69,
	0xE8C3,0xE33C,0xDE34,0xDA59,0xD4BF,0xD310,0xD33D,0xD13A,
	0xCFE8,0xCE07,0xCE8E,0xD436,0xDE69,0xEA40,0xF53E,0xFEB5,
	0x081A,0x1197,0x1BF8,0x2789,0x32FC,0x3B6C,0x3ED1,0x3F5D,
	0x3F6D,0x3F72,0x3F3C,0x3A11,0x329C,0x2BD7,0x24E2,0x1DB8,
	0x15DD,0x0D31,0x03EC,0xFB42,0xF44E,0xF07D,0xEEEC,0xECA7,
	0xE9A9,0xE616,0xE2E8,0xE118,0xE09F,0xE14A,0xE1EB,0xE13C,
	0xDF6A,0xDD90,0xDCAE,0xDD25,0xDD7D,0xDE5B,0xE027,0xE2D9,
	0xE60D,0xEA41,0xEEDE,0xF3B5,0xF911,0xFF39,0x0667,0x0E10,
	0x1520,0x1B6F,0x21A7,0x23F6,0x25C0,0x2794,0x28D3,0x286B,
	0x264E,0x21F2,0x1D0D,0x185E,0x1355,0x0E27,0x082B,0x026C,
	0xFD1C,0xF7CC,0xF332,0xF019,0xED57,0xEA51,0xE859,0xE782,
	0xE6C2,0xE642,0xE6F2,0xE711,0xE714,0xE71D,0xE740,0xE8F8,
	0xEA83,0xECA1,0xEDC4,0xEF38,0xF0B5,0xF313,0xF5C2,0xF90D,
	0xFBFD,0xFF72,0x02C3,0x067F,0x09F6,0x0DC8,0x10B4,0x1253,
	0x1435,0x16F0,0x1895,0x19FE,0x1990,0x172A,0x1428,0x1197,
	0x0F42,0x0D17,0x08D7,0x039C,0xFF2B,0xFB1F,0xF6CF,0xF3F6,
	0xF226,0xF05F,0xED50,0xEAA0,0xE9DA,0xEA74,0xEA95,0xEA76,
	0xEA15,0xEAC5,0xEC17,0xED94,0xEF54,0xF134,0xF20D,0xF2EF,
	0xF45F,0xF648,0xF8E5,0xFBAB,0xFE03,0xFEFD,0xFFB8,0x0123,
	0x03F4,0x070C,0x0949,0x0AFC,0x0BD6,0x0CA9,0x0D3E,0x0E1D,
	0x0ED2,0x0EF3,0x0E32,0x0C5F,0x09F2,0x08C9,0x07B6,0x05A2,
	0x0276,0xFF45,0xFC9B,0xFA60,0xF83B,0xF695,0xF4AA,0xF368,
	0xF1D0,0xF0B2,0xF082,0xF11B,0xF20F,0xF1E1,0xF267,0xF398,
	0xF54F,0xF64E,0xF6C2,0xF951,0xFAD1,0xFAA7,0xFD3B,0xFEC6,
	0x0085,0x0131,0xFF27,0xF9FC,0xF4EA,0xF1CE,0xF062,0xECE0,
	0xE3A8,0xD299,0xC1BF,0xBF20,0xBF6D,0xBF25,0xBF32,0xBF57,
	0xBF5D,0xBFB8,0xBFC9,0xC968,0xDE1B,0xF5A8,0x0D4A,0x21BF,
	0x3410,0x3E7D,0x3F2A,0x3F44,0x3F4C,0x3F5C,0x3F68,0x3F71,
	0x3F66,0x3F97,0x3F2B,0x3F52,0x3DC2,0x32E3,0x2991,0x2412,
	0x1E41,0x1627,0x0BE4,0x0220,0xFBC3,0xF92F,0xF867,0xF8D2,
	0xF85B,0xF622,0xF236,0xED46,0xE85F,0xE314,0xDE2D,0xD9E1,
	0xD6C7,0xD508,0xD3FB,0xCFFD,0xCBE9,0xCB44,0xCDC4,0xD4B5,
	0xDF00,0xEB84,0xF745,0x00C5,0x0884,0x11FA,0x1CEB,0x28E4,
	0x335E,0x3BA5,0x3ED5,0x3F37,0x3F43,0x3F6A,0x3ED7,0x390C,
	0x32FD,0x2CCE,0x2626,0x1F5E,0x1737,0x0DAC,0x03C8,0xFC35,
	0xF695,0xF3B0,0xF1F1,0xEFDD,0xECA8,0xE8E6,0xE63A,0xE5A5,
	0xE5BD,0xE5C8,0xE523,0xE450,0xE2FA,0xE195,0xE130,0xE1DB,
	0xE0B9,0xE0B8,0xE278,0xE546,0xE928,0xEE0B,0xF2D8,0xF7B8,
	0xFCEB,0x02FC,0x0AD9,0x1307,0x19AB,0x1FCF,0x24A7,0x279A,
	0x2944,0x2A6A,0x2ADB,0x2AB9,0x28BE,0x24A5,0x1F8B,0x1A56,
	0x14F6,0x0EB8,0x08B3,0x0389,0xFE9D,0xFA13,0xF569,0xF09D,
	0xED80,0xEAFE,0xE952,0xE7C5,0xE707,0xE751,0xE7DC,0xE7C7,
	0xE7A0,0xE7F6,0xE8B2,0xE93B,0xEA5F,0xEBDC,0xEDF9,0xEFFA,
	0xF109,0xF2E5,0xF5C9,0xF8F5,0xFC1D,0xFF5C,0x02E7,0x06FC,
	0x0AC3,0x0DDD,0x10F7,0x13F6,0x1688,0x1802,0x1881,0x18BD,
	0x1921,0x177F,0x15EF,0x1313,0x102A,0x0CAE,0x0877,0x04EB,
	0x012B,0xFDD7,0xFAEB,0xF640,0xF1BE,0xF1C0,0xEFB6,0xEDBE,
	0xECBB,0xEC19,0xEC34,0xEBA7,0xEC10,0xED5E,0xEEED,0xF055,
	0xF12E,0xF190,0xF2E8,0xF470,0xF612,0xF7CB,0xFA14,0xFC8C,
	0xFE70,0xFF84,0x0154,0x041D,0x05F1,0x0784,0x0936,0x0B19,
	0x0D4C,0x0E7B,0x0F4F,0x0F39,0x0EF7,0x0EB1,0x0E35,0x0D4B,
	0x0B87,0x09C9,0x0778,0x04E7,0x01C6,0xFF19,0xFCF5,0xFA6F,
	0xF7C9,0xF5DD,0xF43D,0xF2B1,0xF150,0xF01F,0xF002,0xEFED,
	0xF073,0xF14D,0xF1F1,0xF2B0,0xF36D,0xF462,0xF575,0xF70D,
	0xF8F4,0xFCE4,0xFE5A,0xFE72,0xFF01,0xFECC,0xFC92,0xF7E1,
	0xF2EE,0xEF85,0xED96,0xE95E,0xDF51,0xCC89,0xC007,0xC027,
	0xBFFD,0xBFDA,0xBFD7,0xBFB7,0xBF8D,0xC007,0xC001,0xCA33,
	0xE16B,0xFA19,0x10EF,0x23C3,0x35BC,0x3EBE,0x3EFE,0x3F31,
	0x3F21,0x3F2C,0x3F08,0x3EFD,0x3F0D,0x3F25,0x3E78,0x3F02,
	0x37E3,0x2AE2,0x242A,0x1F46,0x19B6,0x101B,0x0577,0xFCBE,
	0xF739,0xF63B,0xF757,0xF78C,0xF55C,0xF0FD,0xEC43,0xE869,
	0xE469,0xDF80,0xD998,0xD49C,0xD0E0,0xCEAE,0xCE01,0xCC7F,
	0xCAAA,0xCA7E,0xCD1F,0xD41B,0xDEA1,0xEA59,0xF617,0x0025,
	0x08F1,0x11B4,0x1C88,0x28AC,0x3396,0x3ACC,0x3DE1,0x3E6A,
	0x3E41,0x3E05,0x39EF,0x3469,0x2E1A,0x269A,0x1EF3,0x1704,
	0x0ED1,0x06B7,0xFE29,0xF662,0xF0D0,0xEDDC,0xEBC2,0xE959,
	0xE661,0xE3C5,0xE1D5,0xE0DC,0xE001,0xDFC1,0xDFD8,0xDF0F,
	0xDD94,0xDC95,0xDC67,0xDC5A,0xDC3D,0xDD06,0xDED8,0xE2B2,
	0xE6E8,0xEBB1,0xEFE9,0xF55F,0xFB2E,0x0276,0x09A5,0x110A,
	0x17A3,0x1C9F,0x1F70,0x23C8,0x2404,0x25D0,0x275C,0x2556,
	0x21B0,0x1D4C,0x18A7,0x1420,0x0F29,0x0923,0x0352,0xFD50,
	0xF7D1,0xF393,0xF05D,0xEDB3,0xEA66,0xE730,0xE4D7,0xE44D,
	0xE531,0xE669,0xE613,0xE57C,0xE53E,0xE5B3,0xE688,0xE82F,
	0xE9CC,0xEB5C,0xEC6B,0xECE0,0xEE5F,0xF12D,0xF519,0xF85E,
	0xFB5E,0xFEEA,0x0311,0x0691,0x0A40,0x0D6E,0x104E,0x1301,
	0x1526,0x1761,0x190B,0x1960,0x1775,0x1512,0x1322,0x1121,
	0x0F02,0x0BAD,0x079E,0x030A,0xFEFB,0xFB37,0xF7CD,0xF525,
	0xF343,0xF0F3,0xEDE2,0xEA75,0xEA3D,0xEA88,0xEA6F,0xEAC1,
	0xEB68,0xECC2,0xEEC3,0xF036,0xF0D7,0xF1C6,0xF347,0xF4FB,
	0xF6B8,0xF930,0xFBD5,0xFE50,0x004F,0x0169,0x0299,0x05D4,
	0x0910,0x0B06,0x0C0E,0x0D71,0x0EB6,0x1018,0x11DE,0x12F5,
	0x1279,0x1179,0x1058,0x0F9A,0x0E99,0x0CE1,0x0A06,0x06CF,
	0x036C,0x013B,0xFF2F,0xFD4A,0xFB0A,0xF97B,0xF7E0,0xF4EF,
	0xF35D,0xF2CD,0xF325,0xF402,0xF47A,0xF440,0xF44A,0xF580,
	0xF7BA,0xF99F,0xFB12,0xFC25,0xFD7F,0xFF5E,0x003E,0x0133,
	0x0153,0xFE15,0xF8CC,0xF430,0xF1A6,0xF004,0xEA46,0xDD40,
	0xC960,0xC061,0xC108,0xC07B,0xC09E,0xC072,0xC06A,0xC0B7,
	0xC0AA,0xC332,0xD4DB,0xED45,0x05C6,0x1B51,0x2E1A,0x3CFC,
	0x4045,0x4003,0x4048,0x4004,0x400F,0x401C,0x4008,0x3FF1,
	0x3FDD,0x3F72,0x4004,0x37EE,0x2C38,0x251C,0x1E7F,0x176C,
	0x0E48,0x04B5,0xFCD5,0xF87E,0xF6D8,0xF71D,0xF74B,0xF58C,
	0xF225,0xEDA5,0xE88F,0xE3A7,0xDE7D,0xDA32,0xD743,0xD552,
	0xD371,0xD123,0xCF1F,0xCC5F,0xCE7B,0xD4AC,0xDBF5,0xE670,
	0xF1AA,0xFC19,0x05F8,0x103E,0x1A76,0x252E,0x2FE2,0x3909,
	0x3F23,0x3F7C,0x3F71,0x3F75,0x3F66,0x3AD3,0x3543,0x2F47,
	0x281B,0x2049,0x17B8,0x0EE6,0x066F,0xFE37,0xF789,0xF2C8,
	0xEFAC,0xED8F,0xEB56,0xE8AA,0xE5B6,0xE2DE,0xE14F,0xE0DE,
	0xE161,0xE27A,0xE2A6,0xE099,0xDDE3,0xDC7A,0xDD06,0xDEA5,
	0xE0D4,0xE3BB,0xE6CE,0xEA4E,0xEE5E,0xF2CB,0xF873,0xFF25,
	0x057A,0x0BF1,0x1357,0x1A6B,0x1FD2,0x227E,0x2403,0x24EC,
	0x26EC,0x2931,0x279F,0x24E9,0x20A8,0x1AC7,0x1444,0x0DA7,
	0x0807,0x033D,0xFE4A,0xF8D4,0xF406,0xF082,0xECDF,0xE9EF,
	0xE757,0xE616,0xE591,0xE5C3,0xE595,0xE676,0xE752,0xE691,
	0xE5FC,0xE799,0xE951,0xEAD7,0xEC05,0xED3F,0xEF29,0xF10F,
	0xF3B2,0xF65F,0xF9AB,0xFCE1,0x00C1,0x045F,0x0877,0x0BCD,
	0x0E91,0x1184,0x13B4,0x15BB,0x178A,0x184C,0x16D5,0x154E,
	0x1371,0x113E,0x0F2D,0x0C9D,0x089E,0x0447,0xFFCE,0xFB1F,
	0xF719,0xF36C,0xF114,0xEF6E,0xED0C,0xEA4C,0xE86F,0xE7B1,
	0xE84E,0xE89F,0xE8D3,0xE9A1,0xEB16,0xECBC,0xEDC7,0xEEE8,
	0xF052,0xF1C1,0xF348,0xF4E2,0xF723,0xF9A0,0xFB6B,0xFCBB,
	0xFE57,0xFFFA,0x0278,0x0502,0x074F,0x0985,0x0AE8,0x0B52,
	0x0BB1,0x0C8C,0x0D22,0x0D01,0x0CEC,0x0BE9,0x0A5F,0x0871,
	0x06D9,0x04D8,0x01AE,0xFEE5,0xFC73,0xFA48,0xF853,0xF655,
	0xF46D,0xF245,0xF06F,0xEF91,0xEF6E,0xEF3D,0xEF73,0xEFDA,
	0xF0F5,0xF1A6,0xF25F,0xF3AC,0xF4C2,0xF65F,0xF7EE,0xF9B7,
	0xFB54,0xFB90,0xFD06,0xFDC9,0xFBD8,0xFB54,0xF7DB,0xF506,
	0xF38B,0xF0C1,0xEA34,0xDF4B,0xD0AB,0xC3DD,0xBF40,0xBF59,
	0xBF27,0xC27E,0xC4FE,0xC590,0xC8A9,0xD1AA,0xE07C,0xF23D,
	0x04E4,0x150E,0x2335,0x2F50,0x3AAC,0x3F6D,0x3F12,0x3F41,
	0x3F3F,0x3F61,0x3F76,0x3F0C,0x3F5C,0x3BCB,0x2F84,0x2591,
	0x1EA8,0x1ABF,0x163C,0x0FB0,0x083C,0x00A5,0xFAD4,0xF8EF,
	0xF980,0xFA50,0xF9E5,0xF714,0xF380,0xF088,0xEDB2,0xEA97,
	0xE709,0xE368,0xE0D4,0xDEF8,0xDD3A,0xDBB3,0xDA82,0xD9FC,
	0xDB2F,0xDEF5,0xE462,0xEBA6,0xF4ED,0xFC20,0x02D4,0x0AFA,
	0x13D4,0x1CA8,0x248D,0x2B02,0x2EDB,0x3116,0x3238,0x3182,
	0x2FBC,0x2C9D,0x2743,0x2103,0x1B7B,0x1585,0x101F,0x0A9C,
	0x04B7,0xFE0F,0xF859,0xF55E,0xF3EF,0xF2D4,0xF0E8,0xEEFC,
	0xECC6,0xEAD9,0xEA2B,0xEA65,0xEA3B,0xE99D,0xE88F,0xE805,
	0xE852,0xE81F,0xE77A,0xE78B,0xE84B,0xEA6E,0xEE9C,0xF156,
	0xF46C,0xF84A,0xFC3E,0x0096,0x05D6,0x0BAB,0x10F1,0x153C,
	0x18AF,0x1BE5,0x1ED0,0x203E,0x207E,0x1FA8,0x1D87,0x1B46,
	0x1811,0x147D,0x1088,0x0C00,0x0746,0x022F,0xFD96,0xFA86,
	0xF86E,0xF5D9,0xF2D9,0xF02F,0xEEAE,0xEDC8,0xEE01,0xEE29,
	0xEDA6,0xED51,0xED69,0xED9D,0xEEB2,0xEFDC,0xF0B6,0xF143,
	0xF195,0xF1F6,0xF372,0xF60F,0xF91E,0xFB6A,0xFCF9,0xFE73,
	0x003F,0x039C,0x0731,0x0A84,0x0CF7,0x0EFF,0x103D,0x10FF,
	0x1243,0x13BF,0x145F,0x12C7,0x0FF2,0x0DA1,0x0C02,0x0AE3,
	0x08D8,0x05ED,0x01BF,0xFDB0,0xFA8A,0xF87D,0xF74E,0xF631,
	0xF4B5,0xF31C,0xF083,0xEEA7,0xF181,0xF23E,0xF27A,0xF309,
	0xF31E,0xF3AA,0xF498,0xF5A0,0xF71F,0xF86B,0xF9A3,0xFA85,
	0xFC12,0xFD8C,0xFEEB,0x0032,0x0172,0x031E,0x0512,0x070E,
	0x08AC,0x0926,0x09FB,0x0B42,0x0C58,0x0CB1,0x0C9C,0x0BF5,
	0x0B28,0x0A11,0x084F,0x0707,0x065C,0x0545,0x0247,0xFF90,
	0xFD91,0xFC0E,0xFA1E,0xF89D,0xF74D,0xF65A,0xF566,0xF4B4,
	0xF472,0xF4C6,0xF43F,0xF3E9,0xF462,0xF5D4,0xF728,0xF760,
	0xF839,0xF918,0xFA56,0xFAB5,0xFB58,0xFC88,0xFEC6,0x0076,
	0x0212,0x0115,0xFE94,0xFE41,0xFEDB,0xFE0D,0xFB9C,0xF741,
	0xF251,0xEE58,0xEC7E,0xED4E,0xEEF8,0xEFAC,0xEF4D,0xEF5D,
	0xF152,0xF52F,0xFA85,0xFF4A,0x0399,0x0872,0x0BD5,0x0F29,
	0x1304,0x16D6,0x1751,0x16B9,0x1628,0x15C9,0x15D4,0x14CD,
	0x126D,0x0E83,0x09FF,0x06D7,0x0516,0x044B,0x02E1,0x00E1,
	0xFF33,0xFD4C,0xFBE3,0xFC5D,0xFD78,0xFD3A,0xFB85,0xFB78,
	0xFBAF,0xFB56,0xFA85,0xF962,0xF80A,0xF6C4,0xF515,0xF399,
	0xF2E0,0xF2D0,0xF308,0xF2EC,0xF1D4,0xF26C,0xF4ED,0xF839,
	0xFB5D,0xFD54,0xFF54,0x01C9,0x0491,0x06DC,0x087B,0x0A70,
	0x0B9E,0x0B75,0x0ACE,0x0AC7,0x0A67,0x093A,0x0728,0x04CC,
	0x02D2,0x0171,0xFFCF,0xFDC7,0xFC2E,0xFA9F,0xF9AE,0xF921,
	0xF8AF,0xF899,0xF8CE,0xF841,0xF700,0xF6DA,0xF766,0xF878,
	0xF84E,0xF791,0xF6E6,0xF6F7,0xF719,0xF752,0xF7D2,0xF80F,
	0xF7E7,0xF7F7,0xF8B2,0xF9BD,0xFB87,0xFCBF,0xFE1B,0xFF68,
	0x00EE,0x01FD,0x03B9,0x04B4,0x0587,0x0637,0x0677,0x06B7,
	0x067E,0x05C5,0x0689,0x03FA,0x02DB,0x0284,0x00DB,0xFFF6,
	0xFEF0,0xFDD6,0xFC94,0xFB08,0xF89E,0xF69E,0xF53F,0xF573,
	0xF628,0xF687,0xF63A,0xF4F2,0xF3D9,0xF38E,0xF3E8,0xF475,
	0xF453,0xF3D1,0xF36F,0xF37E,0xF315,0xF2AE,0xF2C5,0xF216,
	0xF168,0xF165,0xF166,0xF0DA,0xF02D,0xEFA8,0xEF24,0xEEC2,
	0xEE87,0xEE29,0xEDF6,0xED2E,0xECD0,0xEC4C,0xEBC3,0xEB4B,
	0xEB60,0xEB19,0xEA8F,0xEA12,0xE980,0xE967,0xE8E0,0xE8E4,
	0xE84D,0xE812,0xE7EF,0xE7AB,0xE7AD,0xE7BD,0xE778,0xE766,
	0xE74A,0xE6BA,0xE51A,0xE4FC,0xE537,0xE562,0xE565,0xE618,
	0xE6A3,0xE6BF,0xE72E,0xE788,0xE723,0xE78F,0xE7EB,0xE842,
	0xE904,0xE99A,0xEA52,0xEB31,0xEB52,0xEA71,0xEB24,0xEC0D,
	0xEC3B,0xEC6F,0xED0F,0xED30,0xED5E,0xEDE6,0xEE1E,0xEE3C,
	0xEEE5,0xEF72,0xF08D,0xF0B0,0xF0F9,0xF17A,0xF1F8,0xF1E1,
	0xF230,0xF2CA,0xF374,0xF3E6,0xF431,0xF5C8,0xF640,0xF50F,
	0xF557,0xF5F9,0xF6A1,0xF759,0xF801,0xF894,0xF91F,0xF968,
	0xFA71,0xFB37,0xFBE4,0xFC21,0xFCBE,0xFD38,0xFD98,0xFDD9,
	0xFE43,0xFF0A,0xFFA6,0x0028,0x0086,0x00C4,0x015D,0x01A3,
	0x0222,0x02A4,0x024A,0x0282,0x02A5,0x02A0,0x0326,0x0333,
	0x0361,0x03D3,0x0455,0x04AF,0x051C,0x056E,0x059B,0x0564,
	0x05AA,0x05C5,0x05B8,0x0637,0x0687,0x06D1,0x0721,0x0738,
	0x074C,0x0798,0x07FE,0x085D,0x08E4,0x0934,0x0907,0x0947,
	0x09AA,0x0A2F,0x0A7A,0x0ABF,0x0B36,0x0B44,0x0B58,0x0B46,
	0x0AE6,0x0B21,0x0A98,0x0A9F,0x0AE5,0x0B3A,0x0BCD,0x0C14,
	0x0C0F,0x0CAD,0x0AA5,0x0B6E,0x0CF6,0x0BCD,0x0C41,0x0CDA,
	0x0CF6,0x0D27,0x0CE0,0x0CF9,0x0D1F,0x0D1A,0x0D3E,0x0D61,
	0x0D68,0x0D7B,0x0D90,0x0D7B,0x0DA3,0x0E03,0x0E02,0x0E20,
	0x0E0E,0x0DA3,0x0D56,0x0D20,0x0D7B,0x0D5D,0x0D79,0x0D8E,
	0x0D7C,0x0D34,0x0CFD,0x0CFC,0x0D13,0x0D61,0x0D66,0x0D57,
	0x0D33,0x0D31,0x0CF6,0x0D10,0x0CF4,0x0CDA,0x0D1C,0x0D6E,
	0x0D6F,0x0D0D,0x0C86,0x0C88,0x0C6E,0x0CFE,0x0D22,0x0D40,
	0x0D5B,0x0D45,0x0D23,0x0CAE,0x0C7B,0x0C8C,0x0D30,0x0E13,
	0x0FD5,0x0F36,0x0E84,0x0E22,0x0DF6,0x0DDB,0x0E2A,0x0E65,
	0x0E88,0x0E71,0x0E1B,0x0DA3,0x0D7D,0x0D32,0x0D37,0x0D34,
	0x0CD9,0x0CC5,0x0C99,0x0BB9,0x0C20,0x0C91,0x0C02,0x0B8F,
	0x0C41,0x0C08,0x0B94,0x0B24,0x0AD5,0x0AC5,0x0AE9,0x0B43,
	0x0AFE,0x0A86,0x0A67,0x0A71,0x09D9,0x098E,0x0987,0x09D1,
	0x09B7,0x0934,0x086A,0x0863,0x0852,0x0767,0x07E1,0x08F4,
	0x091B,0x08AB,0x0842,0x07F0,0x07FC,0x07A4,0x0777,0x071F,
	0x069A,0x0661,0x067C,0x05CD,0x050D,0x0536,0x04DD,0x0511,
	0x050B,0x0563,0x0507,0x04BC,0x0491,0x04BF,0x0497,0x0502,
	0x04F0,0x04F1,0x04DC,0x04A3,0x0498,0x0487,0x0469,0x0490,
	0x04FD,0x04BB,0x04A1,0x045F,0x047C,0x04AA,0x0438,0x043A,
	0x04A8,0x0485,0x047F,0x0447,0x0426,0x045C,0x040B,0x03C7,
	0x03B7,0x03C5,0x042C,0x0421,0x043C,0x043C,0x03FB,0x0412,
	0x03A5,0x0330,0x0334,0x031B,0x0298,0x02CC,0x0276,0x02E7,
	0x02DD,0x02E5,0x034D,0x0310,0x034A,0x02ED,0x02BB,0x02DC,
	0x021C,0x0344,0x03D1,0x02A2,0x039C,0x02FB,0x02F9,0x034F,
	0x035D,0x0322,0x030A,0x034C,0x033B,0x0315,0x0300,0x02F9,
	0x02EC,0x0333,0x02EE,0x032E,0x0334,0x0335,0x02E5,0x02AB,
	0x02C1,0x02B2,0x02D1,0x0342,0x0391,0x036D,0x031C,0x0297,
	0x029B,0x02A6,0x0268,0x02F2,0x0307,0x02F9,0x0327,0x030A,
	0x02D8,0x02BA,0x02C7,0x028C,0x02A5,0x02CA,0x0309,0x02F9,
	0x02DA,0x0284,0x0255,0x028D,0x02D8,0x02CC,0x0299,0x028A,
	0x021C,0x01CF,0x01D3,0x01FA,0x021E,0x0274,0x023B,0x0205,
	0x01CE,0xFFEA,0x00B1,0x01C7,0x022C,0x0332,0x04A0,0x04EC,
	0x05BE,0x065E,0x06DC,0x0726,0x07EE,0x08A7,0x095A,0x0A82,
	0x0B45,0x0B48,0x0B6A,0x0B4A,0x0B54,0x0B56,0x0B30,0x0BAF,
	0x0BE7,0x0CA4,0x0C74,0x0BEE,0x0BEF,0x0C40,0x0CDF,0x0D64,
	0x0D66,0x0D5F,0x0D35,0x0E00,0x0F30,0x102E,0x1045,0x102A,
	0x1070,0x1158,0x1268,0x130F,0x13CD,0x1425,0x1461,0x13D7,
	0x13CC,0x14B6,0x159D,0x15E7,0x1550,0x1509,0x1587,0x168C,
	0x172D,0x1788,0x17A5,0x17C9,0x1744,0x1722,0x17FC,0x18AB,
	0x18A4,0x1811,0x1812,0x189C,0x16AA,0x171D,0x18E5,0x17B5,
	0x1799,0x1764,0x16A8,0x16D6,0x16E8,0x16BE,0x165A,0x1610,
	0x160E,0x158C,0x1514,0x1497,0x144D,0x140F,0x1390,0x12DC,
	0x11CE,0x1012,0x0DF7,0x0B88,0x085E,0x0524,0x01D8,0xFD63,
	0xF832,0xF49D,0xF255,0xF328,0xF5E9,0xF94E,0xFDC9,0x0313,
	0x0884,0x0E22,0x13BB,0x1A05,0x2059,0x25AE,0x28D8,0x2A36,
	0x2A2C,0x286E,0x2576,0x20C6,0x1BE6,0x17CE,0x13A3,0x0FA2,
	0x0B74,0x07B5,0x040F,0x00E7,0xFE35,0xFCA5,0xFCA7,0xFD53,
	0xFCF8,0xFC7B,0xFCBE,0xF9EC,0xF7EE,0xF6AD,0xF5EA,0xF4E4,
	0xF4AE,0xF45F,0xF493,0xF60C,0xF7BA,0xFA2E,0xFCCA,0xFF95,
	0x0357,0x0703,0x0AE2,0x0EC1,0x1088,0x106F,0x1059,0x103A,
	0x0E8A,0x0C7F,0x0A58,0x0749,0x02C5,0xFE1B,0xF959,0xF5CB,
	0xF34F,0xF14D,0xEF14,0xED88,0xEC78,0xEC11,0xEB82,0xEB1A,
	0xEADA,0xEB62,0xEBFD,0xEC36,0xED10,0xEE49,0xEE7E,0xED2D,
	0xED4D,0xEEFF,0xF051,0xF1C7,0xF3E5,0xF5F6,0xF873,0xFA2B,
	0xFB11,0xFC02,0xFC9E,0xFD7B,0xFE2D,0xFDAA,0xFC8B,0xFBD5,
	0xFA36,0xF6E9,0xF41E,0xF22A,0xEFEA,0xED4E,0xEA7D,0xE868,
	0xE6DE,0xE5C8,0xE478,0xE3D1,0xE427,0xE536,0xE650,0xE68E,
	0xE761,0xE932,0xEA2F,0xEA68,0xEB71,0xECB6,0xEDB7,0xEE81,
	0xEF4C,0xF075,0xF12F,0xF1BC,0xF2A7,0xF393,0xF48C,0xF518,
	0xF50A,0xF4F4,0xF532,0xF5B7,0xF58A,0xF4F8,0xF3A9,0xF214,
	0xF022,0xEE78,0xEDB3,0xEC84,0xEAE7,0xE97E,0xE7C0,0xE696,
	0xE61D,0xE619,0xE63F,0xE72C,0xE89D,0xE959,0xE9C6,0xEA6B,
	0xEBAC,0xED1C,0xEDC4,0xEFB7,0xF175,0xF110,0xF2D9,0xF336,
	0xF37A,0xF427,0xF47F,0xF406,0xF429,0xF4D7,0xF67C,0xF6A0,
	0xF59D,0xF54E,0xF4A1,0xF416,0xF362,0xF32C,0xF2BC,0xF24F,
	0xF11E,0xEFA6,0xEE8E,0xEE04,0xED4C,0xEC4A,0xEC58,0xED36,
	0xEE26,0xEE61,0xEEC7,0xEED2,0xEFDC,0xF119,0xF259,0xF388,
	0xF46B,0xF5B7,0xF68D,0xF74D,0xF7C4,0xF7C5,0xF7FD,0xF8DC,
	0xF988,0xFA65,0xFA42,0xF9AB,0xF8F6,0xF87C,0xF888,0xF810,
	0xF7C0,0xF7CC,0xF7CB,0xF6C9,0xF5BE,0xF48B,0xF452,0xF456,
	0xF423,0xF38A,0xF30A,0xF13E,0xEFC9,0xEFCE,0xF026,0xF1B5,
	0xF2A2,0xF30E,0xF38D,0xF3AF,0xF49A,0xF604,0xF6CB,0xF7B3,
	0xF85B,0xF914,0xF94C,0xF708,0xF1F0,0xEBD1,0xE3C8,0xDC5E,
	0xD5D5,0xCA56,0xC02F,0xBF6E,0xBFA0,0xBF9E,0xBFAA,0xC053,
	0xBFA7,0xC5AE,0xD6FA,0xE7D4,0xFC05,0x14B2,0x3145,0x3FC1,
	0x3F7F,0x3FD7,0x3FDB,0x3FFD,0x3FFF,0x3FCD,0x3F96,0x3FC4,
	0x3409,0x2548,0x1A1C,0x0F70,0x0363,0xF6B8,0xEB45,0xE3E9,
	0xE2E0,0xE6FC,0xEBF8,0xEDC2,0xEA92,0xE490,0xDD98,0xD77D,
	0xD451,0xD2EA,0xD252,0xD170,0xD13C,0xD291,0xD635,0xDC7D,
	0xE626,0xF320,0x022F,0x12AD,0x2394,0x3379,0x3E1E,0x406F,
	0x405A,0x405E,0x4069,0x400A,0x3FF6,0x38D9,0x2BA2,0x1C33,
	0x0BAC,0xFD16,0xF239,0xE9E1,0xE2E6,0xDDC9,0xDA2E,0xD7BE,
	0xD654,0xD69C,0xD82A,0xD9FD,0xDC24,0xDE5A,0xE1C8,0xE4B4,
	0xE70B,0xE786,0xE78F,0xE901,0xECAD,0xF231,0xF917,0x00BD,
	0x085B,0x0EA0,0x154D,0x1BC7,0x2201,0x27DA,0x2C19,0x2E65,
	0x2EE6,0x2CF6,0x28F1,0x21E2,0x1770,0x0F4A,0x0515,0xFBAE,
	0xF430,0xECE2,0xE587,0xDEE5,0xD967,0xD692,0xD602,0xD7F8,
	0xDB36,0xDED1,0xE2C6,0xE68E,0xEA14,0xED96,0xF11E,0xF4BC,
	0xF884,0xFBB2,0xFF49,0x0258,0x0599,0x081B,0x0A1E,0x0CB5,
	0x100B,0x134F,0x16B8,0x19A3,0x1B15,0x1B04,0x1980,0x174F,
	0x14DD,0x1150,0x0C98,0x076B,0x015F,0xFAFD,0xF3DA,0xEDCC,
	0xE8A1,0xE455,0xE0F9,0xDE20,0xDD8D,0xDE82,0xE0DA,0xE3FE,
	0xE748,0xEB08,0xEF1E,0xF325,0xF779,0xFB57,0xFF86,0x0357,
	0x0640,0x0A43,0x0CAF,0x0D6B,0x0DE0,0x0F41,0x102C,0x10E0,
	0x10D5,0x104C,0x103B,0x102B,0x0EDC,0x0CB2,0x0A15,0x07A1,
	0x0522,0x01DC,0xFE04,0xFA58,0xF623,0xF124,0xEEBD,0xECA0,
	0xEAA0,0xE98C,0xE9A4,0xE975,0xEA07,0xEBB4,0xEE2A,0xF18B,
	0xF5F1,0xFA43,0xFE20,0x0177,0x0421,0x0695,0x08B1,0x0AAA,
	0x0BCF,0x0CF1,0x0DDE,0x0E59,0x0E2B,0x0D3C,0x0ACA,0x0907,
	0x08EF,0x0820,0x06A9,0x058D,0x047A,0x02AA,0xFFBE,0xFCD9,
	0xFA4B,0xF7BB,0xF5CF,0xF412,0xF337,0xF1D3,0xF070,0xEF50,
	0xEE6C,0xEF23,0xF0B7,0xF26B,0xF456,0xF6BE,0xF9A5,0xFBF6,
	0xFE17,0x0013,0x028C,0x04EB,0x0712,0x0887,0x0919,0x06CD,
	0x009E,0xF748,0xED40,0xE466,0xDA77,0xCA3C,0xBE92,0xBE80,
	0xBE51,0xBE5F,0xBE63,0xBF07,0xBE40,0xC4C6,0xD828,0xEAF9,
	0x02A8,0x218D,0x3B3E,0x3E3F,0x3E35,0x3E6C,0x3E7D,0x3E68,
	0x3E5F,0x3E69,0x3DFB,0x3E6B,0x3AEB,0x2C50,0x1FD2,0x14C2,
	0x07F2,0xFAE9,0xEF9D,0xEA96,0xEB9E,0xF092,0xF44B,0xF404,
	0xEEB1,0xE5D6,0xDD09,0xD964,0xD4F0,0xD2A9,0xD067,0xCCC9,
	0xCB82,0xCDCC,0xD3FC,0xDCD1,0xE880,0xF655,0x070A,0x18F8,
	0x2CB9,0x3C1D,0x3F37,0x3EF7,0x3F5B,0x3F45,0x3F6D,0x3F49,
	0x3EFD,0x3ED5,0x33CC,0x21AB,0x1046,0x0190,0xF64F,0xEDD6,
	0xE6C9,0xE08C,0xDC52,0xDA1E,0xD930,0xD925,0xDA44,0xDC19,
	0xDF21,0xE1C3,0xE3CC,0xE620,0xE726,0xE666,0xE64C,0xE827,
	0xEC98,0xF356,0xFAAA,0x0231,0x09CD,0x1197,0x1974,0x20EE,
	0x28FB,0x3069,0x35F7,0x384D,0x37ED,0x3462,0x2E87,0x2668,
	0x1DB8,0x13D2,0x087B,0xFBFE,0xF1AB,0xE94F,0xE14F,0xDAD1,
	0xD628,0xD3B6,0xD2E6,0xD3E7,0xD6C2,0xDB1D,0xDFCE,0xE36A,
	0xE6E7,0xEA54,0xEE42,0xF259,0xF747,0xFC03,0xFEE0,0x01A1,
	0x0457,0x0703,0x0A8A,0x0EEA,0x136E,0x175A,0x1B42,0x1E23,
	0x1FAC,0x2009,0x1F5A,0x1DFC,0x1B46,0x16F4,0x1159,0x0B69,
	0x0493,0xFD85,0xF5ED,0xEF00,0xE965,0xE4CC,0xE26D,0xE083,
	0xDF09,0xDFF4,0xE1A3,0xE3FF,0xE712,0xEBA9,0xF149,0xF681,
	0xFB23,0xFFB6,0x03F9,0x0798,0x0A4F,0x0D0A,0x0FA5,0x116A,
	0x12D9,0x138D,0x1406,0x14BB,0x1535,0x14ED,0x146A,0x1376,
	0x123A,0x1067,0x0E9A,0x0C13,0x08CF,0x04E9,0xFFF6,0xFB11,
	0xF765,0xF439,0xF13E,0xEE2F,0xEB60,0xE916,0xE799,0xE817,
	0xEA49,0xEDB3,0xF110,0xF3E4,0xF635,0xF984,0xFDA3,0x022B,
	0x05E0,0x098F,0x0C25,0x0D54,0x0E2B,0x0F38,0x102F,0x1032,
	0x0F68,0x0E59,0x0E03,0x0DA1,0x0C57,0x0A5C,0x0866,0x0680,
	0x0468,0x0222,0x0071,0xFE28,0xFB43,0xF872,0xF5DC,0xF446,
	0xF351,0xF24F,0xF15D,0xEE70,0xEF5E,0xF18C,0xF191,0xF316,
	0xF51A,0xF777,0xFA8C,0xFD5B,0x0002,0x037B,0x05DC,0x0734,
	0x089D,0x0A97,0x0B0A,0x07A8,0x0000,0xF672,0xED2F,0xE447,
	0xD97E,0xC8A7,0xBF34,0xBFD1,0xBF5B,0xBF56,0xBF85,0xC01C,
	0xBFA3,0xCCA1,0xDFC4,0xF22A,0x0A43,0x2A12,0x3E56,0x3E98,
	0x3F22,0x3F47,0x3F15,0x3F38,0x3F44,0x3F2D,0x3EA7,0x3F4E,
	0x38A0,0x2AAC,0x2007,0x1471,0x0710,0xF982,0xEF21,0xEA9C,
	0xECEA,0xF291,0xF5F6,0xF473,0xEE27,0xE584,0xDCF9,0xD687,
	0xD46A,0xD4AB,0xD2AE,0xD013,0xCEE8,0xD0E9,0xD68A,0xDF43,
	0xEB06,0xFA3C,0x0C83,0x1FA4,0x326D,0x3EA3,0x3FB4,0x3FBB,
	0x3FC4,0x3FD9,0x3FD8,0x3F71,0x3F3A,0x3D8E,0x2EC1,0x1CA3,
	0x0BB4,0xFDA6,0xF2B0,0xEA38,0xE470,0xDF76,0xDBD3,0xD9A9,
	0xD915,0xD978,0xDA59,0xDB81,0xDE2D,0xE0F8,0xE488,0xE633,
	0xE62D,0xE575,0xE559,0xE75C,0xEC95,0xF35E,0xF9F2,0x0230,
	0x0AEC,0x126E,0x1A70,0x22A2,0x2A35,0x30E1,0x3520,0x36A1,
	0x3545,0x318F,0x2B19,0x226B,0x17E1,0x0CC4,0x0220,0xF7E4,
	0xEF3D,0xE793,0xE094,0xD9D1,0xD3FD,0xD146,0xD1FC,0xD524,
	0xD948,0xDD19,0xE110,0xE467,0xE737,0xEB26,0xF050,0xF531,
	0xF8C4,0xFB73,0xFDC0,0x0061,0x03DF,0x0816,0x0BDD,0x0ED0,
	0x1232,0x160E,0x1977,0x1C4D,0x1E13,0x1E6B,0x1D0E,0x19A7,
	0x1627,0x125A,0x0D98,0x0742,0x0021,0xF88D,0xF140,0xEAAF,
	0xE54B,0xE1FF,0xDFAE,0xDDC8,0xDCB2,0xDC76,0xDE81,0xE27F,
	0xE74E,0xEBCC,0xF010,0xF474,0xF8A9,0xFCC0,0x0086,0x040D,
	0x06EA,0x07E8,0x0AF3,0x0D82,0x0D5C,0x0F47,0x0FE5,0x1058,
	0x1122,0x119C,0x11A6,0x115E,0x0F9F,0x0D72,0x0A68,0x06BF,
	0x03E9,0x00FF,0xFD90,0xF933,0xF4E8,0xF041,0xEC81,0xE90B,
	0xE759,0xE6AE,0xE796,0xE8C3,0xE9F2,0xEB99,0xEDE1,0xF15D,
	0xF57B,0xF9DE,0xFE18,0x021C,0x0575,0x07E8,0x09EC,0x0BCF,
	0x0CF0,0x0DEF,0x0EA4,0x0F36,0x0F06,0x0D95,0x0BFB,0x0B40,
	0x0AB6,0x09EB,0x078B,0x0531,0x035A,0x01A6,0xFFF4,0xFDBE,
	0xFB82,0xF8AC,0xF537,0xF29F,0xF18A,0xF09F,0xF039,0xEFEF,
	0xEFB1,0xF034,0xEFBE,0xEF90,0xF2BB,0xF5E5,0xF9CC,0xFCE9,
	0xFF71,0x01F0,0x049E,0x06E2,0x07E9,0x0721,0x02D0,0xFC05,
	0xF3AC,0xEBB7,0xE35F,0xD5CD,0xC450,0xBF12,0xBF31,0xBF45,
	0xBF80,0xBFB4,0xBFAB,0xC12A,0xD1CB,0xE3F6,0xF914,0x1480,
	0x3488,0x3FD8,0x3F1A,0x3FD5,0x3FD7,0x3FC1,0x3FBC,0x3FE5,
	0x3FB4,0x3F9A,0x3E88,0x331D,0x25F5,0x1B39,0x0FA2,0x01A7,
	0xF3DE,0xEB7D,0xE9F4,0xEECE,0xF522,0xF79F,0xF39F,0xEB08,
	0xE1E1,0xDBF4,0xD8BC,0xD6CE,0xD52B,0xD1CE,0xCEBB,0xCE54,
	0xD198,0xD8C9,0xE30B,0xF081,0x0039,0x1165,0x249F,0x379B,
	0x4055,0x4050,0x408B,0x407B,0x4086,0x408D,0x4011,0x4073,
	0x3A2C,0x279E,0x152D,0x046B,0xF837,0xEFAF,0xE8DA,0xE2D7,
	0xDDEA,0xDA0C,0xD86F,0xD8B3,0xDA06,0xDC33,0xDEEE,0xE149,
	0xE378,0xE5FB,0xE7FA,0xE822,0xE6F5,0xE72C,0xEA13,0xEFD1,
	0xF748,0xFF66,0x06B0,0x0DA9,0x148A,0x1C0F,0x23F6,0x2BF4,
	0x3228,0x35E9,0x3694,0x3493,0x3021,0x298F,0x20D8,0x16C3,
	0x0BB4,0x02B2,0xF912,0xEECE,0xE89F,0xE07D,0xD978,0xD5D8,
	0xD4F9,0xD70B,0xDA9D,0xDE2E,0xE0B3,0xE353,0xE7AF,0xEC3E,
	0xF069,0xF44F,0xF80D,0xFB1A,0xFD80,0xFFD2,0x0364,0x0708,
	0x0A60,0x0D81,0x10B1,0x144B,0x1822,0x1BA4,0x1E32,0x1F06,
	0x1D83,0x1BC1,0x19A4,0x16AF,0x1258,0x0CD4,0x05C8,0xFDF7,
	0xF5F6,0xEEFE,0xE97B,0xE4F1,0xE104,0xDDE7,0xDBEF,0xDC03,
	0xDDA8,0xE0D5,0xE4C6,0xE828,0xEC55,0xF0F2,0xF564,0xFA56,
	0xFED3,0x01FE,0x0450,0x061B,0x07C0,0x09C4,0x0BDD,0x0E27,
	0x1113,0x1260,0x117D,0x10F7,0x115B,0x1136,0x104D,0x0F1D,
	0x0D80,0x0ADE,0x0739,0x03A0,0x0035,0xFC8C,0xF85B,0xF3DA,
	0xF019,0xED13,0xEAD0,0xE886,0xE714,0xE89C,0xEA6A,0xEB83,
	0xECFF,0xF06E,0xF3BF,0xF838,0xFCC6,0x0060,0x0378,0x05AA,
	0x07D8,0x09F8,0x0C4D,0x0DAB,0x0D99,0x0D0D,0x0C7B,0x0C07,
	0x0C45,0x0C25,0x0AB5,0x089E,0x0712,0x04EB,0x028F,0x0294,
	0x017A,0xFFAC,0xFD25,0xF9DF,0xF736,0xF564,0xF48D,0xF338,
	0xF0E2,0xEEB1,0xEE29,0xEEBD,0xEF4C,0xF0C3,0xF2E2,0xF532,
	0xF749,0xFA02,0xFCDB,0x00AD,0x038B,0x05B0,0x070B,0x087D,
	0x0916,0x072E,0x025F,0xF9B1,0xEFEF,0xE6AF,0xDCE2,0xCDEB,
	0xBFA3,0xBE8D,0xBE69,0xBE35,0xBE68,0xBED4,0xBE28,0xC38D,
	0xD6DE,0xE8AE,0xFD72,0x194D,0x37A9,0x3EBB,0x3DE0,0x3E73,
	0x3E7F,0x3E63,0x3E5C,0x3E57,0x3E13,0x3E73,0x3C11,0x2F16,
	0x22C2,0x16F0,0x09EB,0xFC70,0xF0F9,0xE9FD,0xE9CB,0xEE26,
	0xF2EE,0xF387,0xEF33,0xE66B,0xDD29,0xD5F0,0xD1AA,0xCFB2,
	0xCE14,0xCC04,0xCCAE,0xCB70,0xCE68,0xD716,0xE162,0xEFE6,
	0x0123,0x1411,0x2779,0x397C,0x3F20,0x3EF5,0x3F0E,0x3F3C,
	0x3F3F,0x3F53,0x3EE9,0x3EE3,0x347B,0x21C7,0x1040,0x0113,
	0xF58B,0xEC9F,0xE587,0xDFFA,0xDC05,0xD972,0xD7C0,0xD736,
	0xD81F,0xD9B8,0xDBD9,0xDEAC,0xE111,0xE403,0xE59D,0xE542,
	0xE3E2,0xE40C,0xE7D2,0xEEB9,0xF6EF,0xFFA5,0x07E3,0x0F33,
	0x15F2,0x1DA8,0x25AB,0x2D69,0x33B9,0x36B1,0x36AA,0x3444,
	0x2F63,0x2843,0x1EE3,0x13FF,0x09AB,0xFFA1,0xF63E,0xEDA3,
	0xE5D9,0xDED5,0xD765,0xD313,0xD250,0xD465,0xD839,0xDCE4,
	0xE08F,0xE3C5,0xE740,0xEA7E,0xEE64,0xF23D,0xF635,0xFAC3,
	0xFE06,0x0099,0x036D,0x0731,0x0AC2,0x0D64,0x1123,0x1579,
	0x19A9,0x1CAE,0x1EFA,0x2046,0x1F28,0x1CC2,0x1974,0x15B8,
	0x11A4,0x0BC6,0x0548,0xFE1B,0xF6C0,0xEF33,0xE944,0xE4C7,
	0xE11E,0xDE90,0xDDD4,0xDED8,0xE018,0xE391,0xE734,0xE9CB,
	0xEDA3,0xF224,0xF702,0xFC2B,0x0071,0x036C,0x05A9,0x07A6,
	0x09FB,0x0CE3,0x0EE3,0x111B,0x1384,0x145F,0x13CB,0x12ED,
	0x12C6,0x12F0,0x12ED,0x1179,0x0F69,0x0C88,0x08ED,0x04A2,
	0x006E,0xFBC6,0xF74A,0xF353,0xEF67,0xEC96,0xEA28,0xE8E4,
	0xE828,0xE7BE,0xE89F,0xEB1D,0xEEEE,0xF2D2,0xF637,0xF99F,
	0xFCE3,0x00B0,0x0474,0x0710,0x09AF,0x0BD5,0x0CFD,0x0D8C,
	0x0DAC,0x0DCA,0x0E39,0x0DC9,0x0C63,0x0AA2,0x097E,0x0900,
	0x087C,0x06D6,0x045B,0x01FB,0x0040,0xFE06,0xFC23,0xF9C0,
	0xF6EB,0xF539,0xF2F6,0xF0A7,0xEF4B,0xEEC4,0xEEC9,0xEF30,
	0xF084,0xF258,0xF24C,0xF55F,0xF917,0xFB4E,0xFEF4,0x0209,
	0x03FC,0x060F,0x080E,0x093A,0x0953,0x0715,0x014C,0xF7F4,
	0xEDD8,0xE54A,0xDB52,0xCAB6,0xBF8E,0xBFBE,0xBF5C,0xBF34,
	0xBF6B,0xC01B,0xBF3B,0xC754,0xDAAF,0xECE1,0x0456,0x234D,
	0x3D32,0x3EDC,0x3F04,0x3F62,0x3F3A,0x3F1C,0x3F38,0x3F22,
	0x3EE9,0x3F45,0x3917,0x2B1E,0x201A,0x1451,0x0759,0xF9B4,
	0xEEC6,0xE966,0xEAA4,0xF014,0xF418,0xF3B8,0xEE32,0xE522,
	0xDC17,0xD5A7,0xD285,0xD06E,0xCE1D,0xCB71,0xCAB9,0xCD12,
	0xD444,0xDC39,0xE6BB,0xF4A9,0x05B7,0x189C,0x2C55,0x3C4C,
	0x3FCF,0x3FC3,0x3FE1,0x3FD8,0x3FDF,0x3F9A,0x3F8D,0x3DD7,
	0x2FE3,0x1DF9,0x0C4D,0xFD40,0xF2EF,0xEB79,0xE495,0xDE5A,
	0xDA8D,0xD8D2,0xD851,0xD8E1,0xD97F,0xDAA7,0xDC93,0xDF65,
	0xE25E,0xE4C5,0xE5BF,0xE5AE,0xE4A1,0xE4D5,0xE894,0xEFF2,
	0xF94D,0x01B9,0x0927,0x0F9A,0x168E,0x1D64,0x25FF,0x2F03,
	0x3503,0x3707,0x35AE,0x31E0,0x2C1B,0x24B8,0x1B75,0x10FC,
	0x0562,0xFA85,0xF14F,0xE8F6,0xE0EE,0xDA1D,0xD3F6,0xD054,
	0xD0D9,0xD3C9,0xD815,0xDBB3,0xDEB2,0xE186,0xE47C,0xE829,
	0xED2A,0xF205,0xF678,0xF9AD,0xFBC2,0xFDBF,0x0104,0x051D,
	0x094D,0x0D5C,0x1025,0x132C,0x16C3,0x1A04,0x1BF2,0x1C02,
	0x1AFA,0x188C,0x14E3,0x1113,0x0D3A,0x07C1,0x00BF,0xF831,
	0xEFBD,0xE92E,0xE450,0xE0F6,0xDEEB,0xDCC3,0xDB8C,0xDB90,
	0xDCF0,0xE057,0xE47F,0xE9E1,0xEE7D,0xF283,0xF705,0xFBC8,
	0xFFDD,0x039D,0x0662,0x0814,0x0998,0x0AF1,0x0D61,0x0FD9,
	0x0FFA,0x1184,0x1100,0x0E39,0x0F50,0x0FB9,0x0F8A,0x0E75,
	0x0C58,0x08A5,0x043C,0xFF95,0xFCB1,0xF97C,0xF592,0xF16B,
	0xEE0B,0xEB61,0xE937,0xE80E,0xE7A2,0xE867,0xE98B,0xEBB5,
	0xEEEE,0xF312,0xF6E2,0xFA3D,0xFDDE,0x0168,0x0478,0x07BF,
	0x0A66,0x0C62,0x0DFF,0x0E4C,0x0EBB,0x0EA7,0x0E55,0x0DDC,
	0x0D0F,0x0B55,0x0A1B,0x09CB,0x08FB,0x0765,0x0477,0x0159,
	0xFF7C,0xFE1C,0xFBF9,0xFA49,0xF89A,0xF696,0xF417,0xF17E,
	0xF007,0xF055,0xF1D0,0xF2F7,0xF431,0xF550,0xF755,0xF902,
	0xFAA5,0xFCC8,0xFF5F,0x0315,0x05C1,0x0766,0x08D0,0x08DF,
	0x055C,0xFEC7,0xF6A0,0xEEC8,0xE686,0xDB8F,0xC9AD,0xBF0C,
	0xBF65,0xBF45,0xBF28,0xBFCC,0xBF56,0xC253,0xD3AE,0xE43D,
	0xF689,0x0E63,0x2CDB,0x3FA9,0x3EFC,0x3F93,0x3F98,0x3F9A,
	0x3FDF,0x3FB1,0x3F50,0x3FCE,0x3CD0,0x2F3A,0x23DB,0x19F0,
	0x0F27,0x0263,0xF5D4,0xECDC,0xEA46,0xEF65,0xF471,0xF708,
	0xF4F3,0xEE89,0xE59B,0xDE1D,0xD9CE,0xD77C,0xD60F,0xD3C7,
	0xD21C,0xD1A3,0xD3D2,0xDA3B,0xE3C1,0xEEF3,0xFD01,0x0DC9,
	0x1F4D,0x30BA,0x3E37,0x40B6,0x4056,0x40A9,0x4099,0x408A,
	0x4026,0x404C,0x3850,0x27AC,0x16CB,0x0774,0xFB58,0xF288,
	0xEBB1,0xE61A,0xE116,0xDDF1,0xDC7D,0xDBD7,0xDCC6,0xDE52,
	0xE023,0xE235,0xE465,0xE6FC,0xE917,0xE9B5,0xE8FF,0xE861,
	0xE9F0,0xEE78,0xF569,0xFDC9,0x0536,0x0BA5,0x11E6,0x18C2,
	0x2027,0x27D1,0x2E31,0x3236,0x3330,0x30F8,0x2D0F,0x2721,
	0x1FAD,0x16D1,0x0C5B,0x0228,0xF893,0xF017,0xE8A9,0xE2DC,
	0xDF0F,0xDA23,0xD641,0xD8C3,0xDA87,0xDD9F,0xE203,0xE5C1,
	0xE99B,0xECF2,0xEFD1,0xF319,0xF69D,0xFA8F,0xFD37,0xFF09,
	0x019F,0x0589,0x0914,0x0C3D,0x0EE9,0x115C,0x143D,0x1751,
	0x1A2E,0x1BB2,0x1BF6,0x1AA5,0x174D,0x13CD,0x103D,0x0B2A,
	0x04E4,0xFDA9,0xF696,0xF012,0xEA60,0xE5D6,0xE223,0xDF7C,
	0xDE21,0xDD85,0xDE35,0xE15A,0xE5B0,0xE987,0xECF2,0xF07F,
	0xF48B,0xF87C,0xFCDF,0x0046,0x034D,0x0603,0x07F7,0x0893,
	0x09BF,0x0B52,0x0CA2,0x0D1E,0x0D3C,0x0D63,0x0D8B,0x0FBD,
	0x0FBA,0x0D43,0x0B7C,0x09B9,0x06EF,0x033B,0xFFDA,0xFBF3,
	0xF7E9,0xF3A7,0xF033,0xED7B,0xEAF8,0xE9CF,0xE936,0xE8B5,
	0xE927,0xEA80,0xEC6E,0xEFFA,0xF518,0xF8B1,0xFB23,0xFDF1,
	0x01B5,0x04C3,0x0741,0x095A,0x0ACD,0x0B54,0x0B90,0x0B8E,
	0x0B88,0x0B52,0x0AC7,0x0994,0x0853,0x0740,0x05B4,0x04C6,
	0x03AA,0x020B,0xFFC5,0xFD57,0xFA14,0xF79E,0xF73F,0xF6D3,
	0xF51E,0xF2B2,0xF08A,0xEEF7,0xEE98,0xEF3D,0xF11F,0xF228,
	0xF29D,0xF36C,0xF5F5,0xF8C2,0xFC47,0xFEC6,0x010A,0x02DE,
	0x04C3,0x067E,0x0818,0x0847,0x06C1,0x02B7,0xFE0B,0xFA45,
	0xF6B0,0xF251,0xEAEF,0xE067,0xD639,0xCFE7,0xD032,0xD4F0,
	0xDC74,0xE3CC,0xE982,0xEE72,0xF56F,0xFF4C,0x0B55,0x16D0,
	0x1F3D,0x23C1,0x2628,0x2727,0x25E9,0x238F,0x1F21,0x18E1,
	0x12E3,0x0E9F,0x0B60,0x08E0,0x063E,0x02C2,0xFEAE,0xFB9F,
	0xFB98,0xFD77,0xFFC3,0x0021,0xFDEF,0xFA74,0xF603,0xF2E7,
	0xF079,0xEF5E,0xEE3F,0xEC02,0xE98C,0xE80B,0xE953,0xECB4,
	0xF047,0xF6A8,0xF9F8,0xFFCE,0x06D4,0x0CD2,0x12F7,0x1801,
	0x1ADB,0x1B25,0x1B25,0x1AAA,0x1A07,0x17ED,0x13DB,0x0E22,
	0x0850,0x03D3,0x00CD,0xFDC2,0xFA91,0xF83B,0xF6AF,0xF54A,
	0xF437,0xF44C,0xF590,0xF5DD,0xF56C,0xF4AD,0xF504,0xF5F0,
	0xF5AC,0xF503,0xF4E2,0xF520,0xF539,0xF6DB,0xF94E,0xFC7C,
	0xFF9A,0x0197,0x0427,0x0881,0x0C58,0x0F8E,0x1126,0x12BB,
	0x1397,0x1333,0x11B6,0x1005,0x0E58,0x0B2C,0x0766,0x0300,
	0xFF9F,0xFD40,0xFADE,0xF89C,0xF694,0xF4B9,0xF3C1,0xF3C8,
	0xF437,0xF3C3,0xF4AA,0xF5AE,0xF638,0xF6DA,0xF82E,0xF9E4,
	0xFB64,0xFC59,0xFCFD,0xFD07,0xFDB9,0xFF1E,0x012D,0x02A9,
	0x03D5,0x04E3,0x06C7,0x0913,0x09CD,0x0A87,0x0B30,0x0AA7,
	0x09E6,0x08F3,0x07BA,0x06A2,0x049E,0x01E6,0xFE9D,0xFC6F,
	0xFA77,0xF8E5,0xF7A0,0xF623,0xF505,0xF461,0xF37C,0xF306,
	0xF2D8,0xF32F,0xF329,0xF278,0xF392,0xF358,0xF169,0xF03E,
	0xF011,0xF010,0xF052,0xF0C8,0xF14C,0xF2BA,0xF432,0xF49A,
	0xF512,0xF591,0xF5D9,0xF6AC,0xF690,0xF69D,0xF64A,0xF601,
	0xF50F,0xF4A6,0xF42F,0xF342,0xF2B4,0xF1FA,0xF17B,0xF0AD,
	0xF051,0xF00C,0xEF56,0xEEA0,0xEDEF,0xEDE6,0xED82,0xECDE,
	0xEC85,0xEC63,0xEC77,0xEC33,0xEBC6,0xEBF1,0xEBDC,0xEB8E,
	0xEB55,0xEB10,0xEAC3,0xEAAE,0xEACD,0xEAD6,0xEA9D,0xEA60,
	0xEA63,0xE9F2,0xE9FC,0xEA2C,0xEA11,0xEA0D,0xEA0E,0xEA00,
	0xEA1E,0xEA1F,0xEA76,0xEA7F,0xEA55,0xEAE5,0xEA82,0xEA7C,
	0xEB06,0xEB32,0xEB96,0xEB79,0xEB94,0xEC3D,0xEC6F,0xECB7,
	0xEE1E,0xECDC,0xEDFE,0xEF73,0xEE6A,0xEE94,0xEF61,0xF017,
	0xF0EF,0xF18D,0xF1FF,0xF294,0xF2B8,0xF306,0xF2D6,0xF2C9,
	0xF344,0xF396,0xF414,0xF4A0,0xF4D9,0xF4E7,0xF548,0xF5AA,
	0xF609,0xF6F0,0xF739,0xF751,0xF73F,0xF778,0xF78D,0xF818,
	0xF859,0xF8E2,0xF98D,0xFA06,0xFA9B,0xFB41,0xFBA7,0xFBF9,
	0xFC2E,0xFC88,0xFD7A,0xFDEE,0xFE2C,0xFEA1,0xFEC2,0xFF10,
	0xFF63,0xFF6E,0x005B,0x00A0,0x0112,0x0139,0x00E2,0x0129,
	0x01E9,0x0239,0x02A5,0x02BF,0x02FD,0x038E,0x046B,0x06D4,
	0x06AB,0x0601,0x068F,0x06E9,0x074E,0x0737,0x0762,0x079F,
	0x07F1,0x082E,0x0890,0x08FF,0x0944,0x0975,0x093A,0x095C,
	0x0998,0x099D,0x093F,0x0A04,0x0AF2,0x0A8E,0x0997,0x0A4E,
	0x0A70,0x0A2C,0x0A3A,0x0A87,0x0B00,0x0AF9,0x0AC9,0x0B00,
	0x0AD4,0x0AAA,0x0B42,0x0B1F,0x0B8E,0x0B6D,0x0B95,0x0BAE,
	0x0BB1,0x0B7B,0x0BC9,0x0B8C,0x0A73,0x0A7F,0x0BD2,0x0C42,
	0x0BFB,0x0C6A,0x0BFB,0x0C0E,0x0C3A,0x0C85,0x0CB5,0x0C16,
	0x0BD6,0x0C25,0x0B81,0x0A61,0x0AE1,0x0AD8,0x0AB0,0x0A88,
	0x0AF3,0x0AD2,0x0AC5,0x0AAF,0x0AF8,0x0B22,0x0B08,0x0AEC,
	0x0AFE,0x0B1B,0x0B78,0x0B34,0x0B17,0x0B97,0x0C0E,0x0BB8,
	0x0B6E,0x0BB3,0x0BA1,0x0B6E,0x0B43,0x0B46,0x0B55,0x0B71,
	0x0B3E,0x0B58,0x0B58,0x0B38,0x0B30,0x0B56,0x0B74,0x0BE4,
	0x0C2C,0x0BD0,0x0BD0,0x0B7A,0x0B9D,0x0BA0,0x0B92,0x0BC0,
	0x0B64,0x0AE8,0x0AEF,0x0AE3,0x0AFC,0x0ACC,0x0B12,0x0ACE,
	0x0A75,0x0AAD,0x0AEB,0x0AF7,0x0AF6,0x0B40,0x0B34,0x09F1,
	0x0BAF,0x0C00,0x0A1A,0x0B78,0x0B21,0x0AEC,0x0B06,0x0B5D,
	0x0B7E,0x0B5F,0x0ADF,0x0B04,0x0ABB,0x0A8D,0x0A9C,0x0A9A,
	0x0A83,0x0A9B,0x0AB4,0x0A52,0x0A7A,0x0A0E,0x09A7,0x0957,
	0x0938,0x097A,0x09B8,0x09AE,0x09CD,0x09A2,0x08F8,0x092E,
	0x092B,0x08E7,0x0908,0x08B4,0x0868,0x0875,0x0889,0x08A5,
	0x0866,0x086D,0x088F,0x088C,0x0877,0x0838,0x081C,0x080D,
	0x080F,0x07EB,0x07A7,0x080A,0x081E,0x07BA,0x07E6,0x07D6,
	0x0793,0x076D,0x0747,0x0757,0x0704,0x06C4,0x06AE,0x066C,
	0x04DC,0x0382,0x0432,0x03E4,0x0404,0x041B,0x041B,0x042D,
	0x043D,0x045F,0x0478,0x0472,0x0444,0x0487,0x043C,0x0443,
	0x0457,0x04C3,0x0586,0x04D5,0x03D0,0x0446,0x045F,0x042B,
	0x0418,0x04C0,0x04C2,0x046F,0x0454,0x0418,0x03FD,0x03F3,
	0x045E,0x048F,0x04A3,0x048D,0x0440,0x0462,0x044F,0x0499,
	0x0468,0x0419,0x043A,0x04C2,0x05FA,0x051D,0x03F6,0x03D6,
	0x040C,0x03FB,0x03EE,0x0428,0x03F6,0x03BE,0x046F,0x04EF,
	0x0544,0x051E,0x05FE,0x0611,0x05BB,0x055E,0x055D,0x051F,
	0x04E6,0x051F,0x0566,0x05A3,0x052E,0x049D,0x047C,0x0470,
	0x04A8,0x0444,0x0420,0x042B,0x0409,0x03DC,0x0357,0x0370,
	0x039C,0x0372,0x0366,0x0308,0x02A9,0x026C,0x02A2,0x024D,
	0x0226,0x0239,0x0265,0x0237,0x0238,0x024A,0x01F3,0x01A0,
	0x0169,0x0166,0x01C6,0x01C1,0x01BC,0x0201,0x01CA,0x0169,
	0x017E,0x01DD,0x01D3,0x01BC,0x01D7,0x0132,0x00A4,0x0116,
	0x0123,0x0070,0x0093,0x00D2,0x0136,0x0138,0x00ED,0x0102,
	0xFFCE,0xFF96,0xFF50,0xFFAE,0xFF7B,0xFF6C,0xFF0A,0xFEF2,
	0xFF61,0xFFC5,0xFF52,0xFEEB,0xFEA4,0xFDE9,0xFEB0,0xFF10,
	0xFED8,0xFE8B,0xFEA7,0xFE72,0xFE22,0xFE28,0xFDC3,0xFE01,
	0xFE29,0xFDD3,0xFDCC,0xFD97,0xFD97,0xFDF4,0xFE00,0xFE2B,
	0xFE05,0xFE0A,0xFE35,0xFE4E,0xFDFD,0xFEBA,0xFEB6,0xFD29,
	0xFD22,0xFE41,0xFE48,0xFE73,0xFE36,0xFE2A,0xFE1C,0xFDCD,
	0xFD8E,0xFD2D,0xFD1A,0xFD2B,0xFCFF,0xFCC4,0xFC2D,0xFC85,
	0xFC4A,0xFC58,0xFCE7,0xFCD7,0xFCC7,0xFC3E,0xFC3B,0xFC9F,
	0xFD0E,0xFD11,0xFCE7,0xFCF2,0xFD16,0xFD27,0xFD46,0xFC97,
	0xFC7F,0xFCB4,0xFD1E,0xFD39,0xFD14,0xFD2C,0xFD53,0xFCD9,
	0xFD18,0xFD7B,0xFD39,0xFD73,0xFD86,0xFD94,0xFD92,0xFD7F,
	0xFD71,0xFD54,0xFD2F,0xFD6B,0xFD7B,0xFDF1,0xFDEC,0xFDD3,
	0xFD57,0xFD59,0xFD9D,0xFD52,0xFD5E,0xFDA2,0xFD51,0xFD42,
	0xFD22,0xFD85,0xFD8A,0xFDF9,0xFF2A,0xFFFF,0x0029,0x006E,
	0x0152,0x0209,0x016B,0x02EB,0x04AE,0x0451,0x0658,0x0729,
	0x07A6,0x0873,0x087E,0x0815,0x0888,0x08D7,0x08CC,0x08CC,
	0x0857,0x089A,0x084D,0x0914,0x09B0,0x0A32,0x0AB3,0x0AC9,
	0x0A1B,0x0A87,0x0C17,0x0D43,0x0E2D,0x0E30,0x0ECB,0x0EC9,
	0x0E82,0x0E62,0x0E65,0x0DD7,0x0D38,0x0C08,0x0B84,0x0C3A,
	0x0DA2,0x0F3B,0x1113,0x12E4,0x138C,0x133A,0x12E1,0x141D,
	0x1511,0x1570,0x1542,0x1528,0x15D3,0x173E,0x18EB,0x1A98,
	0x1BAA,0x1CD3,0x1D72,0x1D5B,0x1DBF,0x1E5F,0x1F12,0x1E9C,
	0x1D60,0x1CB9,0x1CDE,0x1B74,0x1A1C,0x1AED,0x1BC8,0x1C8C,
	0x1C0D,0x1B72,0x1ABB,0x191E,0x177B,0x1599,0x1437,0x13D6,
	0x1415,0x13BB,0x12CD,0x1214,0x1172,0x10E1,0x0F24,0x0E83,
	0x0EBA,0x0D96,0x0BC0,0x0AA4,0x0A85,0x0A46,0x0999,0x096A,
	0x095E,0x0973,0x09FB,0x0A5B,0x0A0A,0x09BC,0x08D8,0x081C,
	0x081C,0x0839,0x08D1,0x0903,0x088C,0x07E2,0x084B,0x0AA1,
	0x09FF,0x0933,0x0933,0x089F,0x080C,0x0710,0x066F,0x05F6,
	0x060A,0x0695,0x0787,0x06F0,0x05D7,0x056E,0x04C2,0x0406,
	0x03BC,0x0321,0x02DE,0x0253,0x00BB,0xFF66,0xFDDA,0xFD2E,
	0xFD21,0xFCD2,0xFC18,0xFB7B,0xFAED,0xFA77,0xFA07,0xF933,
	0xF82D,0xF7B3,0xF78F,0xF785,0xF74D,0xF6C9,0xF694,0xF637,
	0xF5D9,0xF564,0xF5BB,0xF62C,0xF666,0xF6C4,0xF69D,0xF642,
	0xF599,0xF473,0xF40B,0xF51A,0xF561,0xF5AF,0xF62F,0xF706,
	0xF76E,0xF6D2,0xF5FB,0xF600,0xF637,0xF610,0xF603,0xF5CB,
	0xF5A6,0xF4A6,0xF4A1,0xF3CE,0xF489,0xF51D,0xF4BC,0xF3D1,
	0xF269,0xF1F2,0xF2AC,0xF259,0xF15A,0xF288,0xF0C5,0xEFA3,
	0xEF90,0xEFAC,0xEFE3,0xEFAA,0xEF32,0xEF12,0xEFA2,0xEFD3,
	0xEFC1,0xEFE6,0xEF7C,0xEEB1,0xEE70,0xEE76,0xEF3E,0xEFC0,
	0xF046,0xEF9A,0xEEF5,0xEF76,0xF0AE,0xF1A6,0xF205,0xF16B,
	0xF0B7,0xF08A,0xF0D1,0xF18D,0xF1DB,0xF259,0xF278,0xF1C4,
	0xF208,0xF2A8,0xF350,0xF2F7,0xF2BA,0xF277,0xF2D4,0xF2C4,
	0xF301,0xF2DE,0xF23D,0xF192,0xF10D,0xF165,0xF21C,0xF284,
	0xF252,0xF1E7,0xF12E,0xF03E,0xF03D,0xF116,0xF1BC,0xF186,
	0xF0AD,0xF18E,0xF257,0xF20D,0xF2D2,0xF309,0xF2EB,0xF324,
	0xF2FE,0xF28A,0xF2A0,0xF243,0xF21F,0xF25A,0xF2E5,0xF2EA,
	0xF355,0xF3DC,0xF3E2,0xF333,0xF265,0xF29E,0xF3FA,0xF3D6,
	0xF31F,0xF2E4,0xF29D,0xEF99,0xEABA,0xE436,0xDC7B,0xD32F,
	0xC78F,0xBF93,0xBF57,0xBF71,0xBF6B,0xC98B,0xD897,0xE29D,
	0xE629,0xE3EF,0xDF42,0xDB96,0xDA8B,0xDCAB,0xDF3D,0xE45A,
	0xEBFF,0xF32B,0xFB15,0x03CF,0x0CFF,0x1656,0x1E66,0x250B,
	0x291A,0x28F3,0x2466,0x1E99,0x196C,0x174D,0x1A73,0x2185,
	0x2970,0x2F6E,0x30D6,0x2E4C,0x285B,0x2273,0x1D72,0x1861,
	0x1294,0x0BCF,0x0500,0xFEBA,0xF95B,0xF5DD,0xF4F1,0xF517,
	0xF4DE,0xF3F2,0xF1A5,0xED9F,0xE7BA,0xE087,0xD88B,0xD242,
	0xD01B,0xD19F,0xD4B1,0xD8BE,0xDC52,0xDEE4,0xE0C6,0xE1AD,
	0xE3DD,0xE699,0xE904,0xEA9C,0xEB0B,0xEB6B,0xECDB,0xEF44,
	0xF306,0xF889,0xFF86,0x0604,0x0AD7,0x0E16,0x102F,0x1126,
	0x105C,0x0EC5,0x0CD7,0x0CC6,0x0DB5,0x0FC4,0x10C8,0x11EF,
	0x11E9,0x10C5,0x0F53,0x10B3,0x0E38,0x0BC2,0x07F2,0x022D,
	0xFD29,0xF993,0xF66C,0xF42B,0xF32F,0xF30B,0xF32B,0xF21E,
	0xF003,0xED1E,0xEACC,0xE83E,0xE611,0xE44E,0xE32D,0xE26E,
	0xE18D,0xE24C,0xE41A,0xE705,0xE991,0xEC5F,0xEE58,0xEFFD,
	0xF1F9,0xF349,0xF3DC,0xF495,0xF54A,0xF68C,0xF90D,0xFCB9,
	0x014D,0x0428,0x0656,0x0808,0x09DE,0x0B25,0x0C00,0x0CA0,
	0x0CAC,0x0BD7,0x0A2B,0x099A,0x0960,0x096D,0x0937,0x0984,
	0x0A3B,0x09B3,0x07C6,0x05FB,0x03F6,0x020E,0xFFAC,0xFCD9,
	0xFA06,0xF87C,0xF6BB,0xF3FF,0xF39E,0xF445,0xF44B,0xF2F4,
	0xF0A3,0xEF4E,0xEF31,0xEFE8,0xF02E,0xEE85,0xEE1D,0xEE59,
	0xEF13,0xF006,0xF20C,0xF477,0xF693,0xF7A0,0xF767,0xF906,
	0xFB96,0xFCF0,0xFDEA,0xFE77,0xFF36,0x00AB,0x02CC,0x0506,
	0x06D4,0x083C,0x08A2,0x08FA,0x0A1A,0x0AED,0x0BD7,0x0C0C,
	0x0B62,0x09F4,0x0896,0x088D,0x0866,0x07FD,0x0904,0x0883,
	0x06C8,0x0585,0x042E,0x0314,0x0190,0x0028,0xFE76,0xFDBE,
	0xFD36,0xFD00,0xFC82,0xFC15,0xFBD9,0xFBCE,0xFB9C,0xFB92,
	0xFBD1,0xFC24,0xFBC7,0xFA8E,0xF93D,0xF89A,0xF946,0xFACE,
	0xFC8C,0xFD8A,0xFE6C,0xFE48,0xFE49,0xFF12,0x0055,0x0210,
	0x0374,0x0410,0x03CC,0x03BD,0x049D,0x0529,0x03A7,0xFF8A,
	0xF89B,0xEEE3,0xE31D,0xD477,0xC482,0xBFEC,0xC095,0xC0CB,
	0xC07B,0xCFED,0xE3D4,0xEEE7,0xF100,0xEBD4,0xE3EC,0xDE6A,
	0xDDC3,0xE1AE,0xE80F,0xEF2D,0xF6CE,0xFF2A,0x0A1A,0x16F2,
	0x244E,0x3181,0x3C55,0x3FAF,0x3F65,0x3FA5,0x3EC0,0x37D7,
	0x3194,0x3052,0x35BD,0x3CC7,0x3F90,0x3FFA,0x3F98,0x3F81,
	0x3F90,0x3E62,0x371E,0x2F92,0x2760,0x1E3B,0x14A3,0x0C1F,
	0x05ED,0x02C0,0x01C2,0x0191,0x0170,0xFF94,0xFBC9,0xF554,
	0xECB9,0xE1FA,0xD731,0xCF2D,0xCCC8,0xCF43,0xD41E,0xD8DA,
	0xDC9E,0xDF5F,0xE1A5,0xE45C,0xE763,0xEABE,0xEC29,0xEC1C,
	0xEC29,0xED5F,0xF11E,0xF59F,0xFAF6,0x01B5,0x09BC,0x1290,
	0x1A2D,0x1FD2,0x2279,0x21B5,0x1E00,0x1AB3,0x19BB,0x1B1E,
	0x1D4C,0x1EC6,0x1EFC,0x1F0E,0x1F31,0x1F61,0x1F11,0x1D88,
	0x1A8A,0x16F8,0x1071,0x0A70,0x0523,0xFFB4,0xFA0F,0xF616,
	0xF3D9,0xF350,0xF3D5,0xF432,0xF313,0xEFCA,0xEAE8,0xE544,
	0xE159,0xDF8D,0xDEAB,0xDE56,0xDDA1,0xDEBA,0xE0AB,0xE2B7,
	0xE59A,0xE950,0xEC8F,0xEDCE,0xEF2C,0xF11C,0xF37C,0xF5B3,
	0xF6A9,0xF7B1,0xFA01,0xFD74,0x023B,0x07B8,0x0CB7,0x1008,
	0x1175,0x11C7,0x1206,0x1221,0x12EE,0x131F,0x112A,0x10A5,
	0x10C5,0x1047,0x0FFE,0x1008,0x1018,0x0FBC,0x0E47,0x0C1C,
	0x0941,0x059D,0x00F9,0xFC82,0xF8A8,0xF586,0xF4AE,0xF4C3,
	0xF45F,0xF30E,0xF0A3,0xEEE3,0xEE07,0xEDE6,0xEE04,0xED27,
	0xEB72,0xE942,0xE7DC,0xE867,0xEA5C,0xECFB,0xEF8B,0xF165,
	0xF279,0xF434,0xF648,0xF819,0xF949,0xFAA0,0xFBF1,0xFCC9,
	0xFDDA,0xFFBB,0x0271,0x04D4,0x06AD,0x0850,0x0A55,0x0C11,
	0x0D2D,0x0D54,0x0C7B,0x0B7B,0x0AB0,0x0A05,0x0988,0x0A4E,
	0x0A91,0x0941,0x076F,0x05BA,0x051D,0x04C1,0x0428,0x035B,
	0x013A,0xFD7E,0xF9F9,0xF886,0xF819,0xF797,0xF6D6,0xF6A6,
	0xF657,0xF4D3,0xF5AA,0xF5A3,0xF378,0xF360,0xF229,0xF265,
	0xF357,0xF498,0xF501,0xF519,0xF536,0xF604,0xF7D1,0xFA5C,
	0xFD2E,0xFED4,0xFEF8,0xFF00,0xFF97,0x00D6,0x0233,0x02DE,
	0x034D,0x01E6,0xFDB9,0xF672,0xEC66,0xDFC0,0xD0E4,0xC242,
	0xBF34,0xBFFE,0xBF1F,0xC4B1,0xD98A,0xEA68,0xF2C0,0xF248,
	0xEBCE,0xE4A4,0xE129,0xE2A7,0xE6F7,0xEC2F,0xF1DC,0xF914,
	0x0339,0x100D,0x1D8B,0x2A83,0x36B3,0x3E53,0x3F3E,0x3F4C,
	0x3F8F,0x3D2B,0x34E3,0x2F9A,0x308F,0x381C,0x3F3F,0x3F6F,
	0x3FA3,0x3F7A,0x3E87,0x3E09,0x3BDC,0x3475,0x2C95,0x23C7,
	0x19DB,0x10E0,0x09C9,0x048D,0x019F,0x00A3,0x00B2,0x017A,
	0x0042,0xFC57,0xF547,0xEB75,0xE05A,0xD596,0xCF09,0xCE7D,
	0xD28B,0xD82E,0xDCDC,0xE07A,0xE2CD,0xE4E0,0xE7A7,0xEAF2,
	0xEE2A,0xEFE5,0xEF91,0xEF6B,0xF03A,0xF32B,0xF851,0xFEFA,
	0x0676,0x0EFB,0x16E1,0x1E15,0x2200,0x22F5,0x228B,0x1F22,
	0x1B65,0x1A32,0x1B7F,0x1DE3,0x2083,0x2138,0x20DE,0x2045,
	0x2034,0x205B,0x1F47,0x1C64,0x1874,0x1269,0x0AB5,0x03AB,
	0xFE93,0xFB4F,0xF8E9,0xF839,0xF80E,0xF7CB,0xF657,0xF3CD,
	0xF068,0xEC38,0xE77F,0xE3D0,0xE24C,0xE1A9,0xE15A,0xE175,
	0xE22D,0xE34A,0xE58C,0xE962,0xEDAB,0xF19E,0xF423,0xF526,
	0xF513,0xF4C4,0xF517,0xF6EA,0xFA59,0xFE5A,0x02C4,0x0708,
	0x0B44,0x0ED9,0x10B0,0x11E3,0x1253,0x12B6,0x1319,0x128B,
	0x11B3,0x1076,0x0F40,0x0EA1,0x0E9A,0x0F1C,0x0F4E,0x0F98,
	0x0F15,0x0DB3,0x0A62,0x0648,0x020C,0xFDD8,0xFABF,0xF97C,
	0xF87F,0xF79A,0xF5B8,0xF2D4,0xF3AB,0xF2C3,0xF14D,0xF0BF,
	0xEFAC,0xEE3C,0xECB7,0xEB0A,0xE9C0,0xE92B,0xE9C3,0xEB14,
	0xED80,0xF075,0xF2FA,0xF466,0xF5D7,0xF71C,0xF845,0xF9CF,
	0xFB6E,0xFCB8,0xFE5E,0xFFF8,0x0162,0x02FC,0x04A4,0x0715,
	0x09B3,0x0BC2,0x0C98,0x0C8D,0x0C4D,0x0B19,0x0AA1,0x0AB3,
	0x0AA1,0x0A69,0x095B,0x0869,0x087F,0x08BA,0x0819,0x0733,
	0x0573,0x03A9,0x013E,0xFEC6,0xFD0F,0xFB80,0xFA06,0xF899,
	0xF704,0xF652,0xF644,0xF648,0xF5D4,0xF566,0xF4CC,0xF4CA,
	0xF604,0xF6AE,0xF5EE,0xF680,0xF67C,0xF5F3,0xF61E,0xF715,
	0xF8EA,0xFAB2,0xFCBA,0xFE2F,0xFF01,0xFEF0,0xFF35,0xFF1D,
	0x0098,0x01D7,0x02BD,0x02A5,0x0241,0x00B6,0xFB3C,0xF24C,
	0xE837,0xDC12,0xCBA1,0xC007,0xBF65,0xBFBF,0xBEE4,0xC56E,
	0xDA55,0xE95D,0xEF97,0xED16,0xE5AB,0xDE6A,0xDB7D,0xDD69,
	0xE1E5,0xE747,0xED8D,0xF5A1,0x00D2,0x0D03,0x19FD,0x27A4,
	0x33F5,0x3C43,0x3ECF,0x3E97,0x3E76,0x3765,0x2ECE,0x2B41,
	0x2D04,0x34BA,0x3CF4,0x3E78,0x3DFA,0x3DBC,0x3DF1,0x3DEF,
	0x377D,0x2FE2,0x28A3,0x1FD7,0x164A,0x0CFD,0x0538,0x00A4,
	0xFF39,0xFF7F,0xFFCF,0xFE78,0xFBC2,0xF730,0xEFEC,0xE573,
	0xD9F0,0xD028,0xCA9A,0xCAC2,0xCF10,0xD5A1,0xDB6B,0xDEA2,
	0xE03C,0xE1C4,0xE4A7,0xE7FE,0xEB2B,0xEC4C,0xEBDC,0xEB98,
	0xEC7B,0xEF3E,0xF4DC,0xFC5F,0x058C,0x0EAB,0x165F,0x1C11,
	0x1F65,0x1F81,0x1CE6,0x195C,0x1784,0x1765,0x18F9,0x1AE5,
	0x1CBA,0x1DC0,0x1ECB,0x1EB8,0x1E35,0x1D90,0x1C55,0x18D9,
	0x1345,0x0C3C,0x071C,0xFE98,0xF934,0xF683,0xF4F4,0xF52C,
	0xF504,0xF4D7,0xF441,0xF18D,0xECE5,0xE80F,0xE3A7,0xE111,
	0xDFC5,0xDF89,0xDF4E,0xDF56,0xE043,0xE1ED,0xE4F2,0xE985,
	0xEE26,0xF14C,0xF2E8,0xF331,0xF3EB,0xF4A3,0xF5C4,0xF80E,
	0xFAEB,0xFEE9,0x036E,0x0807,0x0C5E,0x100A,0x1272,0x13BF,
	0x139F,0x135C,0x1399,0x144B,0x1420,0x130E,0x1167,0x0FFA,
	0x1057,0x117C,0x12EF,0x13A6,0x1257,0x0EA8,0x0A23,0x0638,
	0x0328,0x0144,0xFEB8,0xFB7D,0xF89C,0xF686,0xF638,0xF64B,
	0xF62F,0xF478,0xF074,0xEE34,0xED52,0xECBF,0xED4D,0xECDB,
	0xEB05,0xE967,0xE9B4,0xEB7C,0xEE6E,0xF189,0xF47D,0xF6AF,
	0xF771,0xF7E3,0xF8A9,0xFB23,0xFD60,0xFDEA,0xFE94,0x00AF,
	0x032D,0x0598,0x07EB,0x09D2,0x0B78,0x0CDB,0x0E38,0x0EDA,
	0x0FB6,0x0F41,0x0E24,0x0C67,0x0A75,0x0A21,0x0B1E,0x0BB0,
	0x0B63,0x0A31,0x08FE,0x07CB,0x05BB,0x04D9,0x0403,0x014F,
	0xFE9A,0xFC5C,0xFABB,0xFA2A,0xF9A5,0xF8E1,0xF7FE,0xF781,
	0xF766,0xF715,0xF668,0xF6E2,0xF78D,0xF666,0xF501,0xF448,
	0xF4DF,0xF653,0xF774,0xF8A4,0xFA14,0xFBBE,0xFC5E,0xFCDD,
	0xFE0F,0xFFF0,0x012D,0x0165,0x01D0,0x02A0,0x03F6,0x0521,
	0x03CD,0x00C6,0xFB53,0xF23F,0xE6C0,0xD97A,0xC9BE,0xC045,
	0xC08E,0xC0E3,0xC00B,0xCCD8,0xE253,0xEFB6,0xF3A5,0xEF3A,
	0xE6CA,0xDF99,0xDDF4,0xE17E,0xE7A5,0xEE24,0xF417,0xFC1E,
	0x06C6,0x1373,0x20E3,0x2DC7,0x393D,0x3F91,0x3FA2,0x3FD2,
	0x3EFF,0x3810,0x3033,0x2D52,0x3059,0x3A86,0x3FF8,0x3F89,
	0x3FD4,0x400B,0x3F15,0x3EE3,0x38B1,0x2F8C,0x289B,0x20CC,
	0x1746,0x0DAF,0x063B,0x020B,0x009C,0x00AB,0x00A6,0x0049,
	0xFD8A,0xF83A,0xEFE2,0xE511,0xD9FF,0xD19E,0xCD11,0xCD49,
	0xD1B5,0xD7EB,0xDD0A,0xE078,0xE2B7,0xE4E5,0xE7F6,0xEA1F,
	0xEBDB,0xECBA,0xED0D,0xEDB9,0xEF6D,0xF2D5,0xF867,0xFF8B,
	0x074E,0x0F4D,0x16B8,0x1D0B,0x1FF1,0x1FA3,0x1D4E,0x1A8A,
	0x1893,0x1893,0x19F4,0x1B7B,0x1D1B,0x1E65,0x1EC6,0x1E44,
	0x1DD2,0x1C2A,0x197C,0x154F,0x104C,0x0B13,0x05C4,0xFFC5,
	0xFBB6,0xF719,0xF51C,0xF4B9,0xF4D1,0xF4AD,0xF3B3,0xF0FD,
	0xEC5B,0xE6C6,0xE221,0xDF69,0xDE6D,0xDE30,0xDEA2,0xDF84,
	0xE13A,0xE2E2,0xE55E,0xE858,0xEC2A,0xEF91,0xF103,0xF21C,
	0xF3D3,0xF465,0xF4B0,0xF609,0xF833,0xFBA6,0x0077,0x0635,
	0x0B55,0x0EBB,0x0F6E,0x0FAE,0x0F85,0x0F37,0x0FB1,0x10D7,
	0x1142,0x1054,0x0ED7,0x0DEE,0x0CC1,0x0CB0,0x0DF9,0x0DF0,
	0x0D68,0x0C05,0x0927,0x0573,0x00CB,0xFBA7,0xF7A0,0xF5CD,
	0xF53F,0xF47D,0xF3C2,0xF224,0xEFBB,0xEE23,0xECBF,0xEB7E,
	0xEA9E,0xE9AD,0xE90D,0xE8C1,0xE8D8,0xE862,0xE7DA,0xE88D,
	0xEAE1,0xEDF0,0xF0F0,0xF3AD,0xF5FB,0xF6EA,0xF6A3,0xF66D,
	0xF789,0xFA33,0xFD3C,0xFEF5,0x0038,0x0279,0x04B9,0x0669,
	0x0852,0x09C1,0x0A7A,0x09C4,0x0987,0x0A32,0x0AC0,0x0ACA,
	0x0964,0x077E,0x0634,0x067F,0x073B,0x0778,0x0742,0x0608,
	0x039D,0x00ED,0xFE69,0xFCBE,0xFB58,0xFAA9,0xF94D,0xF7A2,
	0xF5CD,0xF4BD,0xF4A6,0xF498,0xF40D,0xF36E,0xF301,0xF1F9,
	0xF0E3,0xF305,0xF3D5,0xF0D2,0xF12B,0xF1B6,0xF3C3,0xF692,
	0xF88D,0xF976,0xFA1E,0xFA70,0xFB02,0xFC56,0xFE22,0xFF74,
	0xFFE9,0x004D,0x0074,0xFFB7,0xFC8C,0xF650,0xED0E,0xE147,
	0xD2C2,0xC3C0,0xBF2F,0xBFAB,0xBFBF,0xC067,0xD20C,0xE53D,
	0xEFBE,0xF10E,0xEB93,0xE39C,0xDEC9,0xDF43,0xE358,0xE96F,
	0xF00A,0xF72B,0xFFF0,0x0B01,0x172F,0x2454,0x3190,0x3CC8,
	0x3F6C,0x3EFE,0x3FB7,0x3C69,0x342E,0x2F69,0x2F7A,0x3533,
	0x3DA8,0x3FBF,0x3F7A,0x3FA6,0x3F62,0x3F9D,0x3DCC,0x3663,
	0x2ED7,0x24F7,0x19DC,0x1116,0x0996,0x0398,0x0000,0xFF12,
	0xFFB4,0x0031,0xFEF3,0xFB82,0xF5DB,0xEC6E,0xE0CF,0xD62D,
	0xCFE4,0xCEC1,0xD161,0xD57B,0xD988,0xDD4D,0xE0D7,0xE364,
	0xE598,0xE909,0xED12,0xEE5B,0xEDB6,0xEDE2,0xEF08,0xF1BE,
	0xF5BD,0xFBAB,0x0443,0x0D07,0x1516,0x1BAD,0x1FDA,0x2125,
	0x2086,0x1D8C,0x1B38,0x1AF6,0x1CF7,0x1EF7,0x1EF1,0x1E73,
	0x1E79,0x1EED,0x1F63,0x1F91,0x1ECC,0x1C0C,0x170B,0x105B,
	0x09FA,0x0453,0xFF22,0xFB58,0xF847,0xF707,0xF72E,0xF6E9,
	0xF4DF,0xF16D,0xEE25,0xEB49,0xE832,0xE53C,0xE317,0xE181,
	0xE047,0xDF22,0xDF73,0xE27C,0xE633,0xEA06,0xECCB,0xEF65,
	0xF1CF,0xF3D5,0xF4C2,0xF537,0xF64D,0xF736,0xF97A,0xFCD7,
	0x0150,0x061D,0x09CA,0x0C82,0x0EB5,0x10C2,0x12F7,0x13FA,
	0x13A5,0x12B4,0x1144,0x0FF0,0x0EA8,0x0E49,0x0F67,0x1053,
	0x1039,0x0F27,0x0D7F,0x0C08,0x0AF1,0x082D,0x0470,0x006E,
	0xFCAB,0xF9BD,0xF808,0xF699,0xF56A,0xF40E,0xF220,0xF0C6,
	0xF0B8,0xF12E,0xEF63,0xEF19,0xEC2A,0xE9D9,0xE933,0xE971,
	0xEA4D,0xEC60,0xEDDD,0xEEC3,0xF05A,0xF27C,0xF575,0xF833,
	0xF976,0xF970,0xF964,0xFA6D,0xFC68,0xFE5A,0x00E5,0x031F,
	0x04D1,0x0607,0x073A,0x0993,0x0C04,0x0D39,0x0CE1,0x0B55,
	0x09E7,0x091D,0x08A0,0x0877,0x0870,0x07ED,0x06D6,0x05C1,
	0x0569,0x0540,0x042D,0x022D,0xFFDF,0xFD5A,0xFBE2,0xFAC7,
	0xF9C6,0xF83E,0xF656,0xF496,0xF348,0xF370,0xF45B,0xF4E6,
	0xF455,0xF2F6,0xF1A6,0xF065,0xEFC4,0xF0AF,0xF1F4,0xF4AF,
	0xF5EF,0xF5B7,0xF6B7,0xF8A3,0xF9B6,0xFAC1,0xFBC8,0xFD07,
	0xFE5D,0xFF0C,0x0050,0x01B8,0x025C,0x0227,0x0146,0xFFD3,
	0xFBFA,0xF583,0xEB35,0xDE80,0xCF8D,0xC19C,0xBF4E,0xBFC5,
	0xBF78,0xC2FB,0xD7C7,0xE8D9,0xF039,0xEEB7,0xE6D2,0xDE45,
	0xDAD2,0xDCEB,0xE278,0xE918,0xEF59,0xF641,0xFF7B,0x0B49,
	0x1882,0x25BF,0x3271,0x3CA2,0x3E76,0x3DD7,0x3EC3,0x39F8,
	0x30D1,0x2B94,0x2CA2,0x34DD,0x3E24,0x3ED9,0x3EB9,0x3E9D,
	0x3E29,0x3E2F,0x3872,0x306B,0x29A2,0x2278,0x1989,0x0FAA,
	0x0699,0x007F,0xFDC8,0xFDA7,0xFEE0,0xFF40,0xFE36,0xFA5C,
	0xF222,0xE752,0xDB96,0xD205,0xCC31,0xCAD4,0xCE3A,0xD497,
	0xDA58,0xDDD9,0xDFA9,0xE0EB,0xE2CA,0xE5EC,0xE92D,0xEBDF,
	0xED69,0xED5D,0xED1E,0xEDFA,0xF23E,0xFA29,0x0374,0x0C8E,
	0x1564,0x1C86,0x1FE1,0x1FA4,0x1D31,0x1A5D,0x187C,0x1867,
	0x195D,0x1B7A,0x1D51,0x1E4A,0x1DDC,0x1D8C,0x1CE0,0x1C77,
	0x1AC1,0x17F0,0x1356,0x0E2C,0x06B2,0xFEB6,0xF88B,0xF4C6,
	0xF3B1,0xF5D0,0xF4C6,0xF448,0xF3DB,0xF062,0xEC2B,0xE764,
	0xE3D3,0xE119,0xDEEF,0xDD75,0xDD06,0xDE07,0xDF8D,0xE183,
	0xE470,0xE7DE,0xEBAB,0xEF57,0xF18D,0xF31D,0xF387,0xF41B,
	0xF488,0xF610,0xF85A,0xFC6E,0x01BC,0x06F9,0x0B4C,0x0EA9,
	0x114B,0x12B4,0x12FE,0x12DF,0x1329,0x1330,0x12DD,0x11D3,
	0x1131,0x10BE,0x10DB,0x1071,0x1010,0x102B,0x0FF4,0x0EF6,
	0x0C65,0x08E3,0x04D8,0x0039,0xFC06,0xF98E,0xF8A6,0xF86A,
	0xF7B7,0xF6FA,0xF5D0,0xF45A,0xF23C,0xF0BF,0xEF3F,0xEDCD,
	0xEC24,0xE9C2,0xE924,0xE9C0,0xEA23,0xEAFA,0xEC51,0xEEF1,
	0xF16A,0xF45A,0xF735,0xF942,0xFA3D,0xFA0F,0xF992,0xF9CD,
	0xFB7E,0xFE81,0x01FD,0x0548,0x0701,0x08A1,0x096C,0x09DC,
	0x0A95,0x0C30,0x0DBC,0x0DAE,0x0D1B,0x0C30,0x0B28,0x0A47,
	0x08E1,0x0869,0x08EF,0x092F,0x08BE,0x0918,0x0811,0x05DD,
	0x0226,0xFE85,0xFC2E,0xFB32,0xFBF7,0xFCD4,0xFB32,0xF9CF,
	0xF7A7,0xF5F4,0xF536,0xF5EE,0xF6C0,0xF6C9,0xF5F5,0xF570,
	0xF59D,0xF592,0xF53D,0xF5E0,0xF6D8,0xF8C6,0xFAB9,0xFC67,
	0xFDBE,0xFE8E,0xFED2,0xFF3E,0x0002,0x0193,0x0345,0x0474,
	0x0530,0x0575,0x05BD,0x04FA,0x0306,0xFFDE,0xFB2C,0xF565,
	0xEE80,0xE78F,0xE345,0xE2B3,0xE63F,0xECDB,0xF4DD,0xFAE8,
	0xFDE1,0xFC2F,0xF821,0xF4EC,0xF308,0xF332,0xF430,0xF61B,
	0xF93C,0xFCD3,0x008A,0x04CC,0x0A1D,0x104C,0x15D4,0x1943,
	0x1A72,0x19D4,0x175E,0x143B,0x1132,0x1039,0x11DE,0x159B,
	0x19F0,0x1D0D,0x1F2A,0x1F78,0x1E24,0x1AB5,0x16A6,0x13B6,
	0x1142,0x0BD9,0x08DA,0x06AB,0x02CB,0x015A,0x0132,0x01E4,
	0x0303,0x032A,0x019D,0xFE49,0xFA81,0xF684,0xF25B,0xEEF0,
	0xECD2,0xECAD,0xEDFA,0xEF50,0xF083,0xF25C,0xF483,0xF61E,
	0xF6BB,0xF681,0xF656,0xF61B,0xF571,0xF4DD,0xF585,0xF72E,
	0xF978,0xFBDA,0xFF8A,0x038C,0x0716,0x08D8,0x0969,0x0927,
	0x08BD,0x084B,0x080E,0x075A,0x073B,0x076B,0x0777,0x08BB,
	0x0A71,0x0BC9,0x0BCF,0x0B28,0x08F1,0x0621,0x03C1,0x0212,
	0x00D6,0xFF4D,0xFCE3,0xFAAF,0xF9A6,0xF9A2,0xFA87,0xFCBF,
	0xFBEF,0xFADE,0xF947,0xF6B7,0xF571,0xF48F,0xF3C8,0xF2B7,
	0xF181,0xF161,0xF28A,0xF464,0xF5EB,0xF75F,0xF7DF,0xF83C,
	0xF7EB,0xF70B,0xF778,0xF9C7,0xFBD6,0xFBE9,0xFB3A,0xFC5B,
	0xFE3C,0xFF71,0x0159,0x03A0,0x0577,0x066F,0x0617,0x04DF,
	0x04A6,0x045A,0x0443,0x03C5,0x041E,0x0587,0x06A5,0x06BE,
	0x054C,0x0427,0x03A7,0x0308,0x01E5,0x0131,0x0174,0x0003,
	0xFDD6,0xFBF1,0xFAF1,0xFADF,0xFAC8,0xFA6B,0xF9E6,0xFA3B,
	0xFA42,0xF910,0xF6E3,0xF49F,0xF4BF,0xF546,0xF553,0xF55B,
	0xF591,0xF613,0xF5E8,0xF6AD,0xF80E,0xFA1B,0xFB2B,0xFAA8,
	0xF9A5,0xFA34,0xFBC3,0xFCDD,0xFD41,0xFDBE,0xFE0E,0xFE2D,
	0xFE9A,0xFFEC,0x01FC,0x0355,0x0386,0x0329,0x024A,0x0215,
	0x0241,0x024F,0x0233,0x0269,0x026E,0x01AE,0x0071,0xFF5A,
	0xFEA6,0xFE07,0xFD5A,0xFC64,0xFB4A,0xFA5F,0xF94B,0xF823,
	0xF6A9,0xF5AF,0xF4C2,0xF399,0xF375,0xF488,0xF5F0,0xF547,
	0xF3EE,0xF34C,0xF35D,0xF3EA,0xF4BD,0xF4B9,0xF47A,0xF31A,
	0xF3C8,0xF3CB,0xF19F,0xF293,0xF1DF,0xF133,0xF0AB,0xF095,
	0xF02A,0xEFC1,0xEEFA,0xEE97,0xEE5E,0xEDE8,0xED7A,0xECF6,
	0xECCE,0xEC33,0xEBCD,0xEB9A,0xEB02,0xEAA1,0xEA42,0xE9F1,
	0xE9D8,0xE99F,0xE910,0xE87A,0xE871,0xE80A,0xE81B,0xE7FA,
	0xE7AF,0xE768,0xE6DE,0xE6B5,0xE723,0xE749,0xE73C,0xE6F9,
	0xE73C,0xE722,0xE761,0xE7AD,0xE7AA,0xE792,0xE7F5,0xE85F,
	0xE903,0xE999,0xE9C3,0xE9E3,0xE9ED,0xE9F0,0xEA59,0xEB20,
	0xEB90,0xEB7B,0xEBC3,0xEC21,0xECE9,0xECD1,0xED8F,0xEDFE,
	0xEC94,0xEBCC,0xEC9C,0xED1C,0xEDC0,0xEE80,0xEF2B,0xEF7E,
	0xEFB9,0xF038,0xF0A8,0xF10D,0xF16B,0xF1D5,0xF2A2,0xF340,
	0xF38E,0xF3CC,0xF4E9,0xF4B7,0xF4AC,0xF5B4,0xF6D3,0xF6C4,
	0xF6E9,0xF7A3,0xF7D8,0xF845,0xF920,0xF954,0xF9AC,0xFA9D,
	0xFB0A,0xFB2C,0xFB8F,0xFC07,0xFC54,0xFCC6,0xFD78,0xFE69,
	0xFF23,0xFFD6,0xFFF9,0x0008,0x018A,0x017A,0x00F3,0x0178,
	0x01B6,0x01D0,0x0257,0x02FC,0x0389,0x03CE,0x0413,0x053D,
	0x0601,0x0666,0x0732,0x0777,0x07BF,0x0844,0x0810,0x082A,
	0x0894,0x08C7,0x08EA,0x08CD,0x095E,0x09BF,0x0996,0x09F8,
	0x0A41,0x0A41,0x0A50,0x0AA0,0x0A91,0x0ACD,0x0AE4,0x0AAF,
	0x0AF5,0x0B33,0x0B61,0x0B9D,0x0B61,0x0B8B,0x0B97,0x0B96,
	0x0BFB,0x0C50,0x0CA1,0x0C99,0x0C7A,0x0C91,0x0C82,0x0CD1,
	0x0CEC,0x0D5F,0x0DD0,0x0DB9,0x0DA9,0x0DC7,0x0DDD,0x0DA8,
	0x0DA6,0x0DCF,0x0E22,0x0E65,0x0E3F,0x0E44,0x0E16,0x0DE4,
	0x0DCD,0x0DAD,0x0DE5,0x0E0C,0x0E1F,0x0DEE,0x0D7F,0x0E73,
	0x0EBB,0x0D8F,0x0F9B,0x0EFA,0x0E24,0x0E1E,0x0E32,0x0E88,
	0x0EBA,0x0E62,0x0EB0,0x0ED4,0x0EEB,0x0EA1,0x0E7C,0x0E88,
	0x0E56,0x0E44,0x0E2E,0x0DDD,0x0DEB,0x0E36,0x0D9B,0x0CFC,
	0x0D0A,0x0D68,0x0D83,0x0D8C,0x0DDE,0x0D7F,0x0D4E,0x0D68,
	0x0D2C,0x0D2F,0x0D2A,0x0D2D,0x0D01,0x0CC0,0x0CD7,0x0C8C,
	0x0C3F,0x0C5A,0x0C2B,0x0C14,0x0C44,0x0C77,0x0BE4,0x0BAA,
	0x0B8C,0x0B5D,0x0B72,0x0B83,0x0B92,0x0B7A,0x0B24,0x0B44,
	0x0B0C,0x0AF5,0x0B00,0x0AE4,0x0B16,0x0B76,0x0D3E,0x0E1B,
	0x0D25,0x0CAF,0x0C36,0x0C19,0x0BCF,0x0BBC,0x0BB4,0x0B7D,
	0x0B49,0x0B3A,0x0B52,0x0AB6,0x0AB5,0x0A79,0x0A8B,0x0A4C,
	0x09AE,0x0960,0x0920,0x0A02,0x09D9,0x0952,0x09AD,0x0A1C,
	0x095F,0x0915,0x08D5,0x0863,0x08AF,0x08FD,0x08C2,0x08C3,
	0x08A8,0x08A6,0x0867,0x0810,0x0832,0x0832,0x0879,0x0835,
	0x0779,0x0740,0x0758,0x066D,0x0640,0x076E,0x07E3,0x07F9,
	0x0771,0x0738,0x0726,0x06B8,0x066F,0x0640,0x05EF,0x05AD,
	0x0575,0x054B,0x045F,0x0418,0x0471,0x0462,0x0483,0x048F,
	0x0482,0x03D7,0x036E,0x0394,0x0406,0x0432,0x0418,0x042C,
	0x03FD,0x03BA,0x0391,0x03C6,0x03F4,0x03B1,0x0393,0x03C1,
	0x03C8,0x0408,0x0431,0x03B0,0x03B9,0x039D,0x0337,0x033C,
	0x0367,0x0367,0x02F7,0x02C5,0x02F9,0x0290,0x027F,0x02D5,
	0x0287,0x0201,0x01A4,0x01A3,0x017D,0x017D,0x0172,0x017E,
	0x01FF,0x01C9,0x015B,0x013A,0x014A,0x0184,0x01A4,0x0109,
	0x00EF,0x011F,0x0182,0x0127,0x013C,0x016E,0x0129,0x008A,
	0x025A,0x00D7,0x00DB,0x01B9,0x0166,0x014E,0x0164,0x0118,
	0x00C0,0x00E8,0x00D7,0x00CF,0x00ED,0x015F,0x010A,0x0154,
	0x00CA,0x00F9,0x0118,0x012D,0x013F,0x00EB,0x0082,0x009A,
	0x0065,0x005A,0x00D7,0x0073,0x00A2,0x00E0,0x00CA,0x0043,
	0xFFEC,0xFFF5,0x003D,0x004A,0x0068,0x004C,0x0062,0x0003,
	0x0055,0x0083,0x0090,0x00F8,0x00DD,0x00B5,0x00B8,0xFED2,
	0xFDA2,0xFE5C,0xFE5A,0xFE76,0xFE9B,0xFE77,0xFE7B,0xFEAB,
	0xFE71,0xFE46,0xFE40,0xFE85,0xFEA6,0xFEAA,0xFED3,0xFED8,
	0xFEDC,0xFF6D,0xFE94,0xFDCD,0xFE62,0xFEBB,0xFE90,0xFE7A,
	0xFEDC,0xFEFF,0xFEDC,0xFF82,0xFFE7,0x0035,0x009B,0x00C9,
	0x0126,0x01C1,0x02DE,0x045C,0x054F,0x05A4,0x0676,0x0699,
	0x06D3,0x0794,0x08DF,0x0ADE,0x0A94,0x09F4,0x0979,0x09BC,
	0x0958,0x09A6,0x0A51,0x0ADA,0x0B3E,0x0B76,0x0C54,0x0C9A,
	0x0CAD,0x0D63,0x0E33,0x0EA7,0x0E5C,0x0E06,0x0E44,0x0EA2,
	0x0F7B,0x1051,0x1075,0x103A,0x10B4,0x11EE,0x133C,0x1393,
	0x1419,0x1414,0x1423,0x146F,0x14DE,0x155A,0x1580,0x1588,
	0x1564,0x15AE,0x16DD,0x17A2,0x176B,0x168E,0x15CC,0x161D,
	0x1700,0x17F4,0x1850,0x17EE,0x1716,0x15F7,0x15C9,0x164D,
	0x16F6,0x1776,0x1765,0x16A3,0x15ED,0x1563,0x1566,0x15C8,
	0x15D2,0x15DF,0x159D,0x152C,0x14F1,0x141A,0x13C5,0x13F2,
	0x13AF,0x12C6,0x128D,0x12DD,0x12FA,0x12E6,0x1309,0x11D1,
	0x0F6C,0x10A3,0x1027,0x0F53,0x1002,0x1000,0x0FA9,0x0EAB,
	0x0CF5,0x0C1D,0x0BDB,0x0C19,0x0C25,0x0C42,0x0C29,0x0B6D,
	0x0AA0,0x09F4,0x0974,0x09B7,0x0A01,0x093C,0x0811,0x0795,
	0x0739,0x0684,0x05AC,0x04D8,0x04C5,0x04C0,0x03E6,0x03A3,
	0x0395,0x0295,0x010E,0xFE81,0xFB60,0xF7DB,0xF3EA,0xEF06,
	0xE966,0xE3CE,0xDFD3,0xDEE1,0xE119,0xE5F5,0xEB56,0xF019,
	0xF3BD,0xF5EB,0xF776,0xF95D,0xFBF1,0xFE2A,0xFFB6,0x006E,
	0xFFDA,0xFF00,0xFEE6,0x0115,0x046A,0x0A1C,0x0F2F,0x1253,
	0x1581,0x177B,0x17B9,0x1692,0x14B3,0x1209,0x0F52,0x0C5A,
	0x0940,0x060A,0x024B,0xFECC,0xFC11,0xFB0B,0xFAA0,0xFAA7,
	0xF967,0xF7A6,0xF661,0xF433,0xF0C7,0xED7B,0xEA32,0xE6E3,
	0xE462,0xE277,0xE0AA,0xE06D,0xE13D,0xE1F7,0xE31C,0xE4F5,
	0xE7B1,0xEA87,0xECD5,0xEE61,0xEF0B,0xEF51,0xEF16,0xEF4C,
	0xF09C,0xF298,0xF3AA,0xF46A,0xF68C,0xF8C7,0xFA48,0xFC2A,
	0xFDE0,0xFF67,0x003F,0x0087,0xFFF1,0xFE51,0xFBB5,0xF94D,
	0xF7A2,0xF5F8,0xF4D0,0xF394,0xF240,0xF0F2,0xEFF4,0xEEB1,
	0xED6A,0xECCA,0xEC82,0xEB75,0xE9D1,0xE827,0xE600,0xE445,
	0xE282,0xE18F,0xE177,0xE210,0xE27B,0xE2CF,0xE3A4,0xE54A,
	0xE6B6,0xE7DC,0xE8DB,0xE992,0xEA79,0xEC05,0xED1C,0xEDD0,
	0xEE90,0xEECD,0xEF32,0xEFF2,0xF1A2,0xF3F8,0xF668,0xF874,
	0xF998,0xF9C3,0xF951,0xF957,0xF923,0xF866,0xF7CF,0xF696,
	0xF537,0xF497,0xF3DA,0xF30B,0xF18C,0xF0F8,0xF044,0xF0C4,
	0xF107,0xF108,0xF08C,0xEF5B,0xEDDC,0xEBB6,0xEA67,0xEBDB,
	0xEA47,0xE972,0xE9FA,0xE99B,0xE9FA,0xE9FD,0xEA92,0xEB5B,
	0xECC8,0xEDBE,0xEE92,0xEFDC,0xF0F4,0xF163,0xF1E9,0xF1E7,
	0xF1C6,0xF28C,0xF36C,0xF527,0xF6DE,0xF78C,0xF74F,0xF75C,
	0xF84A,0xF9C2,0xFB01,0xFB51,0xFB12,0xFAA0,0xF9AF,0xF920,
	0xF938,0xF95D,0xF891,0xF715,0xF666,0xF673,0xF74D,0xF818,
	0xF79D,0xF661,0xF50A,0xF47D,0xF441,0xF4AF,0xF4F3,0xF491,
	0xF398,0xF2A8,0xF1BD,0xF165,0xF213,0xF2D8,0xF37C,0xF3B2,
	0xF409,0xF51B,0xF614,0xF60E,0xF634,0xF6CC,0xF6FC,0xF5C6,
	0xF62A,0xF77C,0xF7D5,0xF81C,0xF7E4,0xF8B6,0xF9EA,0xFAB6,
	0xFBD0,0xFCE2,0xFC9B,0xFC31,0xFBE4,0xFC54,0xFCC2,0xFCEF,
	0xFD44,0xFD68,0xFC60,0xFBEE,0xFBD5,0xFAF4,0xFA71,0xFAAA,
	0xFB0B,0xFB69,0xFBAA,0xFB86,0xFA59,0xF77E,0xF2F0,0xEDD1,
	0xE728,0xDF0D,0xD4D1,0xC71F,0xBFF4,0xC02E,0xC01C,0xC05D,
	0xC03D,0xC20C,0xD129,0xDFA6,0xE782,0xED71,0xF2F8,0xF8D1,
	0x003F,0x0749,0x0CBA,0x0F7B,0x1047,0x10CE,0x12F8,0x1809,
	0x20CC,0x2DA5,0x3BCC,0x40E6,0x408D,0x40DB,0x4096,0x408C,
	0x40B2,0x4092,0x3FFC,0x3A37,0x32E0,0x2A98,0x2120,0x1744,
	0x1039,0x0C5E,0x0B01,0x0AD1,0x0AB6,0x08A2,0x038C,0xFBB8,
	0xF248,0xE81D,0xDEBB,0xD74B,0xD21E,0xCFB2,0xCF0F,0xCF48,
	0xCFA7,0xD113,0xD4F4,0xDB13,0xE35C,0xEC95,0xF3BA,0xF889,
	0xFAE8,0xFBE3,0xFCD1,0xFDE9,0x002A,0x03DB,0x08C5,0x0E40,
	0x1464,0x1A33,0x1F5D,0x2398,0x2717,0x2A2D,0x2D04,0x2DCB,
	0x2CD7,0x294B,0x240C,0x1D88,0x16F5,0x116B,0x0DFE,0x092F,
	0x06DE,0x0646,0x02C1,0x0043,0xFD2D,0xF94D,0xF55B,0xF126,
	0xED3F,0xE94B,0xE57D,0xE1A3,0xDD1B,0xD90E,0xD67C,0xD65A,
	0xD841,0xDB8F,0xDFAA,0xE3C7,0xE787,0xEA45,0xED70,0xF0F8,
	0xF423,0xF6C6,0xF88D,0xFB20,0xFDDF,0x007D,0x02F3,0x0639,
	0x093D,0x0C95,0x0FA2,0x12EF,0x16DA,0x19B9,0x1B1B,0x1AB2,
	0x1894,0x163A,0x1458,0x11EA,0x0F9E,0x0D32,0x0B02,0x080B,
	0x04B3,0x020D,0x0079,0xFF3F,0xFD9C,0xFBB4,0xF966,0xF71D,
	0xF4CE,0xF212,0xEE84,0xEB5D,0xE975,0xEADB,0xEA88,0xEA7F,
	0xEAF8,0xEC25,0xECEF,0xEDD4,0xEF43,0xF2B1,0xF642,0xF8C4,
	0xFA52,0xFB6A,0xFCD0,0xFE37,0xFFA1,0x016B,0x03B4,0x0608,
	0x07C9,0x0A17,0x0D80,0x0E9E,0x0F6A,0x1062,0x10FF,0x1106,
	0x111A,0x104B,0x0EEC,0x0D1D,0x0ACF,0x082A,0x05E1,0x03FA,
	0x029B,0x0165,0x00A3,0xFF2E,0xFD93,0xFC18,0xFA03,0xF7D1,
	0xF664,0xF4DC,0xF23F,0xF08B,0xF0D7,0xF06E,0xEFF0,0xEF47,
	0xEF1D,0xEFD8,0xF0D5,0xF260,0xF4B0,0xF57F,0xF57D,0xF6B5,
	0xF727,0xF81E,0xFA3F,0xFBD9,0xFD61,0xFE37,0xFEFA,0x0033,
	0x01BE,0x0492,0x065E,0x075C,0x0879,0x093F,0x09CF,0x0A1C,
	0x09C9,0x08EC,0x0888,0x0833,0x073E,0x059E,0x0448,0x0340,
	0x0243,0x0162,0x00B5,0x0039,0xFF23,0xFD9F,0xFBE2,0xFA35,
	0xF6F8,0xF156,0xE8E6,0xDF90,0xD598,0xC7FE,0xBF17,0xBED4,
	0xBEA3,0xBEBD,0xBED8,0xBF02,0xC01F,0xCE55,0xDC3B,0xE3F2,
	0xEA7F,0xF28B,0xFC66,0x06B0,0x0DFF,0x11D2,0x1238,0x12A0,
	0x15A4,0x1B4F,0x229F,0x2D83,0x3A5D,0x3ECC,0x3EB9,0x3F86,
	0x3E80,0x3EFA,0x3EF8,0x3EFF,0x3EF0,0x3EB8,0x3F1D,0x3A30,
	0x2DF2,0x21BC,0x1771,0x10AE,0x0E47,0x0DFC,0x0D88,0x0BB5,
	0x074A,0x0039,0xF6C2,0xEB5E,0xE04A,0xD578,0xCC7F,0xC71E,
	0xC491,0xC48C,0xC561,0xC670,0xC8DF,0xCEC6,0xD824,0xE2AE,
	0xECFC,0xF561,0xF984,0xFAF4,0xFBA7,0xFCAD,0xFF6B,0x0338,
	0x0858,0x0E46,0x14EC,0x1B82,0x2238,0x28A7,0x2EDD,0x3343,
	0x366B,0x3899,0x3906,0x3755,0x327E,0x2B5D,0x230E,0x1AF8,
	0x1487,0x10AF,0x0E85,0x0C2E,0x0908,0x043D,0xFED8,0xF926,
	0xF63D,0xF2FF,0xEF04,0xE9CF,0xE405,0xDE56,0xD984,0xD5A0,
	0xD29F,0xD092,0xD005,0xD29B,0xD782,0xDCFD,0xE23C,0xE5F3,
	0xE9B4,0xEC60,0xEE8C,0xF2CA,0xF729,0xFAE6,0xFDDD,0x0098,
	0x028B,0x0472,0x081D,0x0CF0,0x122F,0x1799,0x1BDC,0x1F25,
	0x20ED,0x20D1,0x1F45,0x1DD0,0x1C31,0x1A52,0x171E,0x1477,
	0x110B,0x0D97,0x0B49,0x078C,0x035F,0x0165,0xFFA6,0xFDA8,
	0xFBC6,0xF919,0xF57C,0xF102,0xECBF,0xE9DE,0xE7B4,0xE5E1,
	0xE644,0xE706,0xE6DE,0xE6C2,0xE795,0xE90E,0xEBDA,0xEF8F,
	0xF35D,0xF6AD,0xF839,0xF92B,0xFA2D,0xFC47,0xFEFB,0x013F,
	0x02FA,0x05BB,0x08B2,0x0B85,0x0E59,0x10EB,0x12C4,0x13F5,
	0x13E6,0x143D,0x15B7,0x16B9,0x1576,0x1259,0x0EAD,0x0C8A,
	0x0B10,0x09CF,0x0875,0x06AD,0x0445,0x021D,0xFFFB,0xFDFA,
	0xFBCC,0xFA0B,0xF7E9,0xF5C9,0xF3F2,0xF1F9,0xF01F,0xEEC9,
	0xECC7,0xEC3B,0xEC29,0xED3B,0xEE99,0xF099,0xF26D,0xF39E,
	0xF466,0xF5A8,0xF7C2,0xF9B8,0xFBD9,0xFE64,0xFFBA,0xFFBF,
	0x0366,0x04F7,0x05D4,0x0790,0x091B,0x0B13,0x0D94,0x0F61,
	0x0FAF,0x0F36,0x0E26,0x0D9A,0x0D46,0x0CB6,0x0B3A,0x0A36,
	0x08FE,0x0773,0x0624,0x053A,0x03F8,0x026C,0x009A,0xFF9D,
	0xFF6A,0xFE8C,0xFCA0,0xF94A,0xF444,0xED56,0xE45F,0xDB2B,
	0xD14D,0xC548,0xBF13,0xBF79,0xBF30,0xBF46,0xBFA4,0xBF22,
	0xC301,0xD4A5,0xE162,0xE81C,0xEDCA,0xF66F,0x016D,0x0B9A,
	0x11DD,0x14AA,0x15DC,0x1705,0x19FE,0x1FA1,0x2851,0x34D3,
	0x3E0B,0x3EF7,0x3F06,0x3F3E,0x4010,0x40A8,0x403A,0x4009,
	0x3FE6,0x3FA1,0x3FDD,0x3A91,0x2E47,0x221C,0x172D,0x1074,
	0x0EF2,0x0FFF,0x0F89,0x0C59,0x0589,0xFCD1,0xF36F,0xE8C8,
	0xDE01,0xD514,0xCD2C,0xC68A,0xC3A4,0xC40E,0xC5C1,0xC8C0,
	0xCC41,0xD159,0xD9CB,0xE45A,0xEEE7,0xF716,0xFB8E,0xFC94,
	0xFC89,0xFD49,0x00A5,0x0631,0x0D1C,0x138F,0x18BA,0x1E10,
	0x2416,0x2990,0x2EE3,0x34BB,0x3870,0x3A28,0x38FD,0x3549,
	0x2FA2,0x28C3,0x2155,0x19C8,0x134D,0x0E44,0x0B4B,0x093A,
	0x05D3,0x011B,0xFCE3,0xF8AA,0xF4A5,0xF0CC,0xED01,0xE91B,
	0xE400,0xDD7B,0xD6FB,0xD221,0xCF9D,0xCF7E,0xD144,0xD4A9,
	0xD897,0xDD1C,0xE141,0xE510,0xE927,0xECFB,0xF096,0xF4A5,
	0xF7FB,0xFB09,0xFD9B,0xFF7A,0x019B,0x0488,0x08D9,0x0D88,
	0x1273,0x1721,0x1B4F,0x1E33,0x2034,0x206E,0x1F54,0x1D1D,
	0x1A74,0x184F,0x157D,0x11A7,0x0CFF,0x0826,0x0438,0x015F,
	0xFF2D,0xFDA1,0xFC1F,0xF995,0xF685,0xF2FA,0xEFD9,0xEC60,
	0xE8CF,0xE559,0xE2F5,0xE149,0xE019,0xDFD9,0xE28E,0xE23A,
	0xE20D,0xE4AE,0xE7AF,0xEC21,0xF00C,0xF25E,0xF449,0xF666,
	0xF822,0xFA35,0xFC6F,0xFF0B,0x0189,0x03FB,0x0655,0x0958,
	0x0CED,0x0FAE,0x1133,0x11A5,0x1205,0x130C,0x1405,0x140A,
	0x1308,0x103E,0x0D4D,0x0A95,0x08F8,0x07E2,0x0671,0x0433,
	0x0235,0x0072,0xFF19,0xFD34,0xFA87,0xF831,0xF60F,0xF449,
	0xF217,0xF0A9,0xEFBE,0xEE70,0xECC7,0xEB90,0xEBE6,0xED7C,
	0xEF08,0xF08E,0xF212,0xF3AB,0xF4B8,0xF62C,0xF79D,0xF9D9,
	0xFC80,0xFE75,0xFFF3,0x0097,0x01A1,0x028B,0x0285,0x043C,
	0x06D9,0x090F,0x0B10,0x0C2D,0x0C31,0x0BBD,0x0BAF,0x0B59,
	0x0A00,0x088B,0x07D7,0x07E3,0x073C,0x054F,0x02D6,0x00D8,
	0xFF42,0xFD36,0xFCD1,0xFDB3,0xFD0B,0xFA6F,0xF778,0xF430,
	0xF01D,0xEA2F,0xE1F9,0xD7EB,0xCC4F,0xC1BE,0xBFC4,0xC006,
	0xBFB7,0xBFCD,0xC07C,0xBFB8,0xC517,0xD7BB,0xE405,0xEB52,
	0xF0BA,0xF909,0x0311,0x0BBE,0x1221,0x157A,0x166B,0x1763,
	0x1B14,0x2139,0x2B8F,0x3964,0x4053,0x406A,0x4089,0x40B2,
	0x4103,0x40D4,0x40B2,0x409A,0x4094,0x4086,0x3F41,0x3675,
	0x2AE2,0x1F06,0x15F3,0x106E,0x0F37,0x0F32,0x0E29,0x0A2B,
	0x03CE,0xFAFB,0xF08A,0xE593,0xDB01,0xD1BE,0xCA4E,0xC53E,
	0xC321,0xC43E,0xC68C,0xC96F,0xCE16,0xD4BA,0xDE60,0xE8A6,
	0xF2A6,0xF9B2,0xFD70,0xFEB4,0xFF02,0x0104,0x0489,0x093D,
	0x0E1C,0x13ED,0x1A13,0x2093,0x27CC,0x2E59,0x33DA,0x3781,
	0x39E2,0x3A8D,0x39A3,0x36D9,0x317B,0x2A8D,0x219E,0x18EA,
	0x1281,0x0E4F,0x0BE8,0x0A1B,0x0747,0x03E1,0xFDA9,0xF925,
	0xF6D2,0xF22B,0xEDBF,0xE8D6,0xE301,0xDD10,0xD76E,0xD348,
	0xD14D,0xD11A,0xD23A,0xD4C7,0xD904,0xDEDE,0xE542,0xE98B,
	0xEC89,0xEF5D,0xF23E,0xF591,0xF93E,0xFD0A,0x0069,0x0293,
	0x0385,0x05A9,0x0A35,0x1029,0x15C9,0x1A2B,0x1D03,0x1EC7,
	0x1F73,0x200A,0x1FE4,0x1E0E,0x1ABF,0x16AE,0x128E,0x0ECC,
	0x0BA8,0x08CC,0x0614,0x032B,0x001E,0xFD73,0xFB57,0xFA07,
	0xF7DB,0xF440,0xF041,0xEBEA,0xE815,0xE4A6,0xE27E,0xE119,
	0xDFB0,0xDEFF,0xDF3E,0xE107,0xE5DE,0xE968,0xEC7E,0xEF4A,
	0xF179,0xF3F6,0xF68A,0xF8C0,0xFABB,0xFCF2,0xFE75,0xFFA1,
	0x01BF,0x049E,0x085A,0x0AEB,0x0CF6,0x0EC2,0x1105,0x126C,
	0x13D4,0x159E,0x14AC,0x11D2,0x0FBC,0x0D6C,0x0B4E,0x09EA,
	0x0788,0x0456,0x016F,0xFFAC,0xFEE1,0xFDD0,0xFBCD,0xF998,
	0xF72B,0xF4F8,0xF326,0xF1C3,0xF013,0xEDD8,0xEBA9,0xE9F9,
	0xE92A,0xE8E2,0xEA43,0xEC08,0xED81,0xEE50,0xF00A,0xF231,
	0xF502,0xF790,0xF920,0xF9BD,0xF9F1,0xFAAE,0xFC93,0xFEBF,
	0x0020,0x01D5,0x02D9,0x03D4,0x058A,0x081E,0x09FC,0x0B05,
	0x0B03,0x0AE9,0x0AB4,0x0A7D,0x09FD,0x0976,0x07F7,0x058C,
	0x032C,0x0180,0x0160,0x0117,0xFFEF,0xFE7B,0xFC9C,0xFB20,
	0xF962,0xF75E,0xF4A0,0xEF98,0xE77A,0xDD64,0xD28C,0xC5A0,
	0xBE9E,0xBE88,0xBE49,0xBE67,0xBEA9,0xBF1F,0xBE75,0xC7AB,
	0xD821,0xE135,0xE7B0,0xEF91,0xF954,0x03AD,0x0BF5,0x1043,
	0x1122,0x118A,0x13B0,0x1912,0x2153,0x2BD2,0x38BF,0x3EB4,
	0x3E9F,0x3EE3,0x3ED9,0x3EEA,0x3E84,0x3F0A,0x3F63,0x3E25,
	0x3EFC,0x3A4F,0x2F1D,0x2344,0x1884,0x109F,0x0D10,0x0C98,
	0x0C91,0x0ABB,0x0618,0xFF0A,0xF59A,0xEB67,0xE01F,0xD4F7,
	0xCC17,0xC653,0xC2F6,0xC18F,0xC21B,0xC444,0xC7F8,0xCCFB,
	0xD445,0xDE80,0xE92D,0xF22B,0xF79F,0xF9B6,0xFA85,0xFC13,
	0xFF28,0x034A,0x0854,0x0E13,0x145B,0x1AA3,0x2180,0x2892,
	0x2EA8,0x333B,0x3614,0x382A,0x3949,0x384B,0x3484,0x2DD3,
	0x251D,0x1C6E,0x1535,0x109E,0x0E7D,0x0CB3,0x0A2E,0x0639,
	0x00AC,0xFB97,0xF819,0xF52F,0xF1E7,0xEC4F,0xE47B,0xDE55,
	0xD888,0xD32B,0xCFEF,0xCEE9,0xCFE1,0xD2F1,0xD687,0xDADB,
	0xDFCE,0xE3FD,0xE7AD,0xEB63,0xEFA5,0xF45D,0xF8A1,0xFC9B,
	0xFEBB,0x0009,0x020B,0x0416,0x0736,0x0CDC,0x13A3,0x19A3,
	0x1E25,0x20C0,0x2189,0x21CE,0x2137,0x205A,0x1F56,0x1D0A,
	0x198A,0x15B0,0x1143,0x0D5E,0x09D4,0x0668,0x0384,0x01A0,
	0x0010,0x001F,0xFDDD,0xF970,0xF50E,0xF007,0xEBC1,0xE8D9,
	0xE781,0xE681,0xE504,0xE32F,0xE1CC,0xE205,0xE3B1,0xE734,
	0xEB7E,0xEE82,0xF18E,0xF4D4,0xF743,0xF8E3,0xFA2A,0xFBE5,
	0xFD9B,0xFFE5,0x02CF,0x0621,0x0900,0x0B28,0x0D39,0x0F06,
	0x114F,0x1398,0x15A2,0x1759,0x1825,0x178A,0x1594,0x12AC,
	0x0FA4,0x0D51,0x0B40,0x09B5,0x08E7,0x078A,0x04B2,0x01B3,
	0xFF61,0xFD3E,0xFB69,0xF9A9,0xF82D,0xF695,0xF489,0xF179,
	0xEEBD,0xED03,0xEBC3,0xEB07,0xEB52,0xECAD,0xEE85,0xEFE1,
	0xF0F2,0xF22A,0xF416,0xF5CE,0xF77C,0xF9B5,0xFC13,0xFE3F,
	0xFF70,0x0058,0x00E4,0x01A4,0x0375,0x05C6,0x0723,0x0BE2,
	0x0D5B,0x0C38,0x0C9D,0x0C9B,0x0CA0,0x0C80,0x0CC6,0x0D15,
	0x0C5D,0x0A57,0x080D,0x05FA,0x03E5,0x02DF,0x01D4,0x012B,
	0x0086,0xFF39,0xFD51,0xFBB0,0xF9AB,0xF76F,0xF405,0xEDB0,
	0xE509,0xDBF6,0xD277,0xC5B7,0xBF68,0xBF92,0xBF2A,0xBF50,
	0xBF76,0xBF8C,0xC08D,0xCF00,0xDD1C,0xE3D7,0xEA67,0xF343,
	0xFE5E,0x0820,0x0F2B,0x12E5,0x1407,0x146F,0x16DE,0x1C99,
	0x254C,0x3060,0x3C11,0x3F41,0x3ED9,0x3F1A,0x3F3F,0x3F1E,
	0x3F0C,0x3F1E,0x3F44,0x3FC1,0x40B3,0x3ACB,0x2EB7,0x2224,
	0x16C3,0x0EFE,0x0C1A,0x0C73,0x0D64,0x0B6C,0x0557,0xFCCF,
	0xF2D7,0xE81D,0xDD19,0xD291,0xCA9E,0xC4CA,0xC16F,0xC0B4,
	0xC326,0xC63F,0xC8B5,0xCD12,0xD56D,0xDFE0,0xEADB,0xF3D1,
	0xF8F0,0xFABC,0xFADA,0xFAF8,0xFCFC,0x01A8,0x0834,0x0F0F,
	0x1570,0x1B49,0x20A3,0x2777,0x2DA6,0x3202,0x3565,0x3756,
	0x36AA,0x3391,0x2FDC,0x29B9,0x2125,0x1895,0x11A9,0x0CDB,
	0x0A5C,0x08A3,0x0644,0x0204,0xFCA2,0xF7AB,0xF3E1,0xF020,
	0xEC64,0xE78C,0xE145,0xDB08,0xD5A1,0xD155,0xCE6C,0xCD47,
	0xCDF7,0xCFFE,0xD44A,0xD9B6,0xDF88,0xE471,0xE80F,0xEA9E,
	0xED55,0xF17E,0xF593,0xF92E,0xFC4F,0xFE73,0xFFE5,0x021D,
	0x05A0,0x0A9A,0x1019,0x1540,0x19F3,0x1CD0,0x1DF5,0x1D87,
	0x1CD0,0x1B45,0x18B1,0x1577,0x129B,0x1040,0x0D43,0x0971,
	0x0557,0x015D,0xFE31,0xFC77,0xFB63,0xFA20,0xF845,0xF45E,
	0xEEE8,0xEA2C,0xE691,0xE47C,0xE158,0xDF9B,0xDF09,0xDF5B,
	0xDFEA,0xE046,0xE180,0xE324,0xE585,0xEB20,0xEDCC,0xF12A,
	0xF575,0xF6C0,0xF7F5,0xF923,0xFAF7,0xFDC5,0x009F,0x03E4,
	0x071B,0x09A0,0x0BBD,0x0DBC,0x0FEB,0x11F1,0x137E,0x14BE,
	0x1536,0x14D6,0x12FD,0x1089,0x0DF2,0x0BED,0x0A0C,0x0780,
	0x0531,0x03D8,0x02C7,0x0152,0xFF08,0xFC03,0xF9F1,0xF81E,
	0xF602,0xF466,0xF304,0xF196,0xEF15,0xECB3,0xEBC4,0xEC21,
	0xECE3,0xED9A,0xEE38,0xEF95,0xF18C,0xF33C,0xF518,0xF738,
	0xF8AB,0xFA03,0xFB3D,0xFC82,0xFEA7,0x00F7,0x0325,0x043C,
	0x0544,0x06EA,0x08F1,0x0A09,0x0B59,0x0B6C,0x0B9C,0x0C08,
	0x0B68,0x0AEC,0x0A75,0x0985,0x08B5,0x07FA,0x06A0,0x05BC,
	0x0487,0x0363,0x0219,0x0067,0xFE7A,0xFD02,0xFC4A,0xFB90,
	0xF998,0xF7AB,0xF4CB,0xEEC3,0xE69E,0xDE55,0xD631,0xCCED,
	0xC2A3,0xBF98,0xBFD3,0xBFF2,0xC048,0xC06A,0xCD6E,0xDC77,
	0xE620,0xEC8D,0xF1D7,0xF8F7,0x015C,0x08A9,0x0D96,0x0F6A,
	0x112C,0x140C,0x163C,0x1AFE,0x221F,0x2A88,0x3505,0x3E92,
	0x3FE6,0x3FC4,0x4003,0x4027,0x4056,0x406C,0x3FD3,0x3A9E,
	0x33A6,0x2B72,0x224F,0x1948,0x121A,0x0D35,0x0B15,0x0A42,
	0x08FE,0x0641,0x018B,0xFBB6,0xF48C,0xEBE4,0xE31E,0xDB2E,
	0xD57B,0xD169,0xCF95,0xCF73,0xD137,0xD3ED,0xD7C4,0xDCBA,
	0xE3C8,0xEBA6,0xF3A1,0xF93A,0xFC39,0xFD93,0xFE87,0x0061,
	0x0318,0x0669,0x0A9C,0x0F58,0x1407,0x1927,0x1E56,0x2373,
	0x2801,0x2ABD,0x2C9F,0x2DFE,0x2DC8,0x2B4C,0x26B6,0x2061,
	0x1A4D,0x14E0,0x1078,0x0CFA,0x0A4D,0x074B,0x039B,0x0032,
	0xFE0D,0xFBCB,0xF855,0xF4F2,0xF14E,0xEB83,0xE6F3,0xE445,
	0xDF1F,0xDC8C,0xDB26,0xDA6B,0xDAF6,0xDD6F,0xE128,0xE512,
	0xE888,0xEB9B,0xEF02,0xF1F4,0xF4F2,0xF7DA,0xFA97,0xFD74,
	0xFF2D,0x0091,0x0228,0x0566,0x0949,0x0D2A,0x10B0,0x13B3,
	0x163C,0x1863,0x1932,0x1947,0x1882,0x171C,0x14BF,0x1182,
	0x0E67,0x0BFC,0x09E6,0x0736,0x03D8,0x012B,0xFEDE,0xFDD0,
	0xFCE1,0xFB4D,0xF936,0xF5F8,0xF1E9,0xEE3E,0xEC92,0xEB34,
	0xE97A,0xE777,0xE5C9,0xE4DF,0xE55E,0xE73C,0xEA25,0xEC76,
	0xEED2,0xF137,0xF36C,0xF7AC,0xF9A6,0xFB1B,0xFCE3,0xFE2B,
	0xFEE4,0x00B8,0x0337,0x05C5,0x07E7,0x099D,0x0AAB,0x0BB6,
	0x0D79,0x1018,0x1260,0x12C6,0x11BA,0x0F00,0x0BCF,0x0A94,
	0x0B1C,0x0A2C,0x0873,0x06AD,0x03E7,0x013D,0xFF64,0xFE6D,
	0xFD9E,0xFCFE,0xFC2F,0xF9EC,0xF78A,0xF5AA,0xF456,0xF276,
	0xF0F3,0xEFA5,0xEF37,0xEFAA,0xF045,0xF134,0xF246,0xF279,
	0xF205,0xF354,0xF675,0xF91A,0xFBC2,0xFD4B,0xFDD7,0xFD9F,
	0xFE0A,0xFF97,0x00CD,0x01E8,0x02CC,0x03D2,0x0581,0x05E6,
	0x072B,0x07D9,0x0841,0x0832,0x07F9,0x0777,0x0766,0x06AC,
	0x055B,0x0368,0x020B,0x014C,0x0079,0xFF38,0xFE49,0xFD7E,
	0xFC8F,0xFB0B,0xF96F,0xF83F,0xF767,0xF5C9,0xF3B7,0xF11E,
	0xEE27,0xEAE4,0xE740,0xE36F,0xE0A3,0xDF34,0xE016,0xE3AB,
	0xE8F3,0xEDF5,0xF173,0xF417,0xF62F,0xF84D,0xFAF0,0xFE89,
	0x015A,0x02BE,0x02FF,0x039E,0x0430,0x0501,0x06A0,0x0991,
	0x0D7C,0x11B7,0x1600,0x18CB,0x1940,0x188F,0x1750,0x1637,
	0x14EA,0x13C2,0x11DB,0x0E6C,0x0BC0,0x0975,0x03F0,0x02E5,
	0x0219,0x01CB,0x00FE,0xFFE2,0xFE45,0xFCC4,0xF9C0,0xF70C,
	0xF4B1,0xF2BF,0xF156,0xEF68,0xEDFC,0xEDB0,0xEF1D,0xEFC0,
	0xF074,0xF10B,0xF2C3,0xF5AA,0xF90C,0xFB92,0xFD03,0xFE25,
	0xFE21,0xFE4D,0xFF29,0x01BE,0x044C,0x060D,0x0709,0x07CE,
	0x092B,0x0B2E,0x0D52,0x0EE8,0x0F7A,0x0F96,0x0FB6,0x0ED8,
	0x0DEE,0x0CD6,0x0AF4,0x0823,0x05EC,0x04BE,0x0423,0x03F8,
	0x0361,0x01C4,0xFF6C,0xFDB5,0xFCE0,0xFBBA,0xFB12,0xFAB7,
	0xF95F,0xF6E0,0xF4B7,0xF378,0xF204,0xF08C,0xF0FD,0xF1E0,
	0xF399,0xF566,0xF6BC,0xF7A2,0xF830,0xF895,0xF8D9,0xF91C,
	0xFA6B,0xFB3B,0xFBC0,0xFB8D,0xFB30,0xFABE,0xFAB7,0xF9EF,
	0xF91E,0xF93F,0xF927,0xF86E,0xF6C7,0xF5CE,0xF4F9,0xF4C9,
	0xF598,0xF545,0xF441,0xF35A,0xF2A2,0xF20B,0xF17C,0xF072,
	0xEFD7,0xEF47,0xEF28,0xEEC7,0xEEBA,0xEE6A,0xED41,0xEC2F,
	0xED05,0xEC17,0xEAE3,0xEA96,0xEA84,0xEA10,0xE97D,0xE8F5,
	0xE8A9,0xE8B7,0xE8C7,0xE93A,0xE9A1,0xE9B3,0xE9FC,0xEA91,
	0xEA52,0xE9E7,0xE9AB,0xE98C,0xE9DE,0xEA4A,0xEA6E,0xEA64,
	0xEA97,0xEACB,0xEAB2,0xEA8D,0xEA9E,0xEB06,0xEB3F,0xEB43,
	0xEB7E,0xEB96,0xEBDD,0xEBD6,0xEBD7,0xEC0D,0xEC39,0xEC1F,
	0xEBE1,0xEC03,0xEC69,0xEC89,0xECD7,0xED54,0xED82,0xEDCE,
	0xEE0D,0xEE3B,0xEE7B,0xEEE3,0xEF33,0xEF86,0xEFE1,0xF02A,
	0xF0AD,0xF119,0xF1AB,0xF257,0xF287,0xF301,0xF34D,0xF3B3,
	0xF41F,0xF4E0,0xF546,0xF5CE,0xF639,0xF64F,0xF656,0xF6DA,
	0xF7A8,0xF803,0xF859,0xF983,0xF9E0,0xF847,0xFA83,0xFB4E,
	0xFA6C,0xFB3A,0xFB8B,0xFB79,0xFC19,0xFC46,0xFC85,0xFCEA,
	0xFD55,0xFDAE,0xFDD6,0xFE3A,0xFE6E,0xFEBA,0xFEED,0xFF25,
	0xFF88,0xFFFF,0x0054,0x00B6,0x0142,0x016D,0x01A8,0x01FB,
	0x0280,0x02CF,0x034A,0x03B8,0x0488,0x04EF,0x04BD,0x050B,
	0x05FB,0x063F,0x0689,0x0692,0x06DD,0x070F,0x0702,0x0726,
	0x076A,0x07DA,0x07F2,0x0861,0x088B,0x08C8,0x091A,0x0963,
	0x098B,0x090B,0x08F3,0x08FB,0x0923,0x0957,0x096B,0x098A,
	0x0A24,0x0A9C,0x0BFE,0x0D31,0x0CAD,0x0CB9,0x0CB2,0x0C58,
	0x0C53,0x0C5A,0x0C76,0x0C86,0x0CBD,0x0D22,0x0CD5,0x0CBA,
	0x0CDA,0x0D1B,0x0D2C,0x0D72,0x0D77,0x0CC8,0x0C52,0x0D89,
	0x0DF5,0x0D5C,0x0D24,0x0D78,0x0D77,0x0D18,0x0D34,0x0D65,
	0x0D75,0x0D2B,0x0D72,0x0D78,0x0D44,0x0CED,0x0D21,0x0D0A,
	0x0CF8,0x0D04,0x0CC3,0x0CB5,0x0CAF,0x0CB7,0x0CCD,0x0CBE,
	0x0BB8,0x0C27,0x0C94,0x0CE3,0x0C98,0x0C37,0x0C17,0x0C6E,
	0x0CA5,0x0C4C,0x0C36,0x0B83,0x0B6A,0x0BB3,0x0AA8,0x0A1A,
	0x0A57,0x0AA3,0x0ADB,0x0AB5,0x0AB3,0x0B32,0x0AE5,0x0A99,
	0x0A7D,0x0A6C,0x0A69,0x0A87,0x0A77,0x0A74,0x0A24,0x0A46,
	0x0A4A,0x0A7F,0x0A46,0x0A42,0x0A75,0x09FB,0x0A1E,0x0A1E,
	0x0A68,0x0A85,0x0A53,0x0A20,0x0997,0x095C,0x091D,0x0946,
	0x0944,0x08F5,0x0903,0x08B6,0x08D9,0x0897,0x08E5,0x08C7,
	0x083B,0x0832,0x0808,0x081F,0x081A,0x0823,0x07C2,0x0751,
	0x0774,0x07A7,0x0851,0x080C,0x0821,0x0802,0x0818,0x07E9,
	0x07F4,0x086B,0x082E,0x07A4,0x0978,0x0808,0x0742,0x0811,
	0x07FC,0x080E,0x0836,0x0838,0x083A,0x0870,0x07F2,0x0832,
	0x07D4,0x07E3,0x076F,0x0780,0x0724,0x072E,0x0781,0x0711,
	0x06F9,0x06B7,0x0704,0x0718,0x0710,0x06D8,0x06E2,0x06FA,
	0x06BF,0x06FA,0x075C,0x0768,0x070A,0x06C2,0x0676,0x06AA,
	0x063E,0x0626,0x0622,0x0632,0x05E9,0x062F,0x0623,0x0623,
	0x0679,0x060A,0x05E1,0x05BF,0x0588,0x059E,0x05B6,0x057A,
	0x058A,0x05CA,0x05F2,0x0600,0x05D9,0x05BA,0x059B,0x055A,
	0x0589,0x05B4,0x059E,0x04C8,0x033E,0x02F7,0x0383,0x0336,
	0x0377,0x0379,0x0375,0x0391,0x0385,0x0389,0x0331,0x02A5,
	0x02C2,0x02D6,0x0349,0x039B,0x0392,0x0383,0x037E,0x02B3,
	0x02D3,0x0324,0x0355,0x0340,0x02E8,0x02EF,0x0355,0x0374,
	0x03AD,0x034C,0x034E,0x02CB,0x0329,0x0385,0x0397,0x036C,
	0x02DC,0x02B3,0x030C,0x0345,0x0349,0x03B0,0x0357,0x0352,
	0x0371,0x0250,0x0259,0x0280,0x02A4,0x02D9,0x02FD,0x02A8,
	0x02E2,0x02D0,0x033F,0x0396,0x0371,0x03BF,0x04B2,0x04EC,
	0x0495,0x0450,0x046A,0x048D,0x049E,0x040F,0x03C3,0x0368,
	0x0363,0x0361,0x0326,0x033C,0x02E5,0x02CD,0x02F2,0x02D9,
	0x0275,0x0243,0x01FB,0x01B7,0x01C1,0x01C5,0x01B4,0x01E6,
	0x01E9,0x01E7,0x01F7,0x01C5,0x01CF,0x01B9,0x0180,0x0177,
	0x019C,0x0156,0x0123,0x011F,0x014F,0x012B,0x00DE,0x00A7,
	0x00CC,0x0094,0x008F,0xFF5A,0xFF1F,0xFECB,0xFF55,0xFFB5,
	0xFF41,0xFF33,0xFED7,0xFECF,0xFEE6,0xFF16,0xFF01,0xFF50,
	0xFF41,0xFF3B,0xFFB9,0xFFB5,0xFFCF,0xFF7B,0xFFAC,0xFFC1,
	0xFFDD,0xFFFE,0x0034,0x0047,0x0048,0x002E,0x0082,0x00A8,
	0x00D3,0x01F4,0x0300,0x03E3,0x04B1,0x05D8,0x074A,0x08D4,
	0x09A8,0x09BC,0x09FC,0x0A86,0x0B03,0x0B40,0x0B50,0x0BCB,
	0x0BA0,0x0B66,0x0C63,0x0E19,0x0D38,0x0D23,0x0D21,0x0D16,
	0x0D44,0x0DBC,0x0DD7,0x0DFC,0x0E8D,0x0EC1,0x0F77,0x0FFE,
	0x105E,0x1131,0x11C4,0x12A1,0x134E,0x12C0,0x1263,0x13A5,
	0x1497,0x13D1,0x135C,0x1404,0x13F7,0x1428,0x148B,0x14C4,
	0x1544,0x1533,0x1498,0x1465,0x14E6,0x160C,0x174F,0x1723,
	0x16CA,0x1670,0x15D7,0x1578,0x14C0,0x14B7,0x148A,0x12AB,
	0x0FBA,0x0E9B,0x0DE4,0x0B8B,0x086F,0x05F7,0x0457,0x0380,
	0x0317,0x02FB,0x03E2,0x0520,0x063F,0x0715,0x079B,0x09B5,
	0x0D7F,0x10F9,0x13D6,0x15EA,0x17FC,0x19A5,0x19D6,0x19B6,
	0x19DE,0x1A4B,0x1A1C,0x19CF,0x19BD,0x194D,0x18A4,0x16FF,
	0x1575,0x145B,0x13E6,0x13AB,0x1354,0x1327,0x1353,0x1361,
	0x11FE,0x107B,0x0EBE,0x0CE3,0x0BB7,0x09E7,0x0802,0x05C2,
	0x03C1,0x0121,0xFE8A,0xFC1A,0xFA2C,0xF847,0xF5F2,0xF398,
	0xF2FA,0xF32F,0xF325,0xF34F,0xF3F2,0xF464,0xF4A6,0xF437,
	0xF4F3,0xF680,0xF850,0xF94C,0xF9C8,0xFA4F,0xFAAA,0xFA71,
	0xFA19,0xFA80,0xFAD2,0xFA57,0xFC24,0xFB95,0xFBC7,0xFD20,
	0xFC71,0xFC66,0xFD61,0xFDC8,0xFDE9,0xFEB7,0xFFB2,0x00DE,
	0x0085,0x0032,0xFF28,0xFE7D,0xFCF5,0xFBAE,0xFA94,0xFA22,
	0xF969,0xF765,0xF5D0,0xF466,0xF289,0xF0C4,0xEFA9,0xEEDA,
	0xEE7C,0xEE22,0xEE20,0xED71,0xECC8,0xEC17,0xEB8B,0xEB97,
	0xEBF4,0xEC97,0xECB6,0xECAB,0xECCF,0xEC47,0xEBE7,0xEBB4,
	0xEBC1,0xEC2F,0xECB5,0xED6C,0xEDD8,0xEE04,0xEE6E,0xEF48,
	0xEF94,0xF0B6,0xF1F8,0xF2D4,0xF342,0xF37A,0xF471,0xF5BF,
	0xF73B,0xF6A1,0xF595,0xF4F9,0xF31D,0xF272,0xF36A,0xF3B5,
	0xF395,0xF2EF,0xF1B1,0xF0D3,0xF0E5,0xF0C0,0xF069,0xF000,
	0xEFF9,0xF009,0xEFB9,0xEF43,0xEEF9,0xEF1F,0xEF70,0xEE9E,
	0xEE30,0xEE4C,0xEE54,0xEE2C,0xEE1F,0xED87,0xED3C,0xED8D,
	0xEDDC,0xEDBF,0xED6C,0xEDE8,0xEE73,0xEEF9,0xEEB3,0xEF0F,
	0xF0AD,0xF222,0xF23C,0xF275,0xF2E8,0xF3D0,0xF43F,0xF52C,
	0xF71E,0xF6FA,0xF6A0,0xF5F2,0xF60F,0xF635,0xF64B,0xF681,
	0xF6AA,0xF6FD,0xF757,0xF725,0xF7AB,0xF81C,0xF8B2,0xF87B,
	0xF7E9,0xF7C1,0xF785,0xF789,0xF7BD,0xF737,0xF733,0xF701,
	0xF631,0xF57A,0xF530,0xF4D9,0xF402,0xF397,0xF3AF,0xF3DC,
	0xF368,0xF31E,0xF2C7,0xF2C5,0xF296,0xF217,0xF2CC,0xF388,
	0xF3F3,0xF409,0xF43E,0xF466,0xF45D,0xF4A3,0xF57E,0xF6A9,
	0xF6FF,0xF6E9,0xF68D,0xF693,0xF727,0xF793,0xF796,0xF67E,
	0xF3E0,0xF031,0xEC71,0xE9A2,0xE62F,0xE11A,0xD90D,0xCD13,
	0xC1C3,0xBFDD,0xBFF5,0xBFEE,0xBFC6,0xBFC5,0xBFE1,0xBFB3,
	0xC30D,0xCAC9,0xD515,0xE3FE,0xF12A,0xFDC2,0x0BAF,0x1619,
	0x1FCA,0x2814,0x2E08,0x31FC,0x3418,0x3451,0x3423,0x3485,
	0x351C,0x3550,0x33D4,0x2FD5,0x2B45,0x2804,0x2686,0x26EB,
	0x28C9,0x2B0E,0x2C08,0x2AD0,0x27BA,0x2451,0x2164,0x1EA3,
	0x1A3A,0x149B,0x0EA3,0x07A3,0xFFBE,0xF750,0xEF2D,0xE723,
	0xDE1F,0xD576,0xCF20,0xCC35,0xCB41,0xCB76,0xCB78,0xCBF7,
	0xCD0A,0xCE7F,0xD223,0xD7DA,0xDE8C,0xE4F5,0xEA31,0xEEB6,
	0xF277,0xF5CF,0xF905,0xFC27,0xFF2C,0x00C2,0x0249,0x042F,
	0x06F1,0x0A2E,0x0EC4,0x1129,0x11A8,0x12DC,0x1548,0x1821,
	0x1BD2,0x1F73,0x21EF,0x2252,0x21D3,0x209A,0x1FC0,0x1E63,
	0x1C47,0x194B,0x156D,0x103D,0x0AAF,0x049A,0xFFBA,0xFBA2,
	0xF69E,0xF0AE,0xEB9B,0xE7FB,0xE59F,0xE456,0xE384,0xE2A9,
	0xE17B,0xE0D7,0xE0C0,0xE109,0xE201,0xE3F3,0xE522,0xE57E,
	0xE5DA,0xE6BE,0xE83B,0xE95F,0xEAD3,0xEC7E,0xEE4C,0xEF2E,
	0xF123,0xF480,0xF78D,0xFB46,0xFEEB,0x01CC,0x044A,0x0738,
	0x0A70,0x0DF7,0x1088,0x121D,0x1323,0x13B3,0x134B,0x138D,
	0x1334,0x125D,0x10C4,0x0E2A,0x0BAA,0x09A5,0x07F9,0x05D7,
	0x02C9,0xFFEB,0xFD74,0xFBBB,0xFA40,0xF920,0xF841,0xF6F5,
	0xF521,0xF31F,0xF1A9,0xF0F4,0xF0A6,0xEFAB,0xEE0A,0xEC9D,
	0xEBB9,0xEB86,0xEB2B,0xEAB6,0xEB2B,0xEB87,0xEB8E,0xEBC6,
	0xECB0,0xEEF6,0xF164,0xF3F3,0xF5B1,0xF77A,0xF9AE,0xFC2A,
	0xFE86,0x00EA,0x0394,0x058D,0x06CD,0x07E7,0x08BE,0x09E6,
	0x0B54,0x0BCD,0x0B8C,0x0B55,0x0B83,0x0B27,0x0AB8,0x0A0B,
	0x0910,0x07AC,0x0603,0x05F1,0x0761,0x0520,0x04CF,0x0375,
	0x016E,0xFFD2,0xFEAC,0xFD91,0xFCE9,0xFC1C,0xFA55,0xF866,
	0xF6A2,0xF588,0xF4DB,0xF455,0xF34A,0xF2A4,0xF1F6,0xF1AA,
	0xF1B8,0xF22A,0xF32C,0xF42B,0xF4AA,0xF576,0xF647,0xF80A,
	0xFA10,0xFB91,0xFCAF,0xFD4E,0xFE25,0xFEDA,0xFFDD,0x01AA,
	0x038C,0x049B,0x0404,0x01BC,0xFE80,0xFA91,0xF6BF,0xF330,
	0xEE82,0xE6FA,0xDBD4,0xCC99,0xC0CA,0xBFB3,0xBFA8,0xBF77,
	0xBFA6,0xBF83,0xBFBD,0xBFAE,0xC414,0xCDB9,0xD9BA,0xE904,
	0xF9E7,0x0AF4,0x1A3E,0x269B,0x2FDB,0x394D,0x3DED,0x3E64,
	0x3E81,0x3EA1,0x3ED1,0x3E93,0x3EC7,0x3EA3,0x3EBA,0x3E93,
	0x3A40,0x375A,0x36F1,0x38AF,0x3AF2,0x3DC6,0x3E84,0x3CBB,
	0x3A68,0x373B,0x331B,0x2E39,0x2927,0x22D5,0x1B6D,0x131B,
	0x0928,0xFE6B,0xF2F3,0xE7DC,0xDDE5,0xD5C7,0xCFEA,0xCBE6,
	0xC9DB,0xC8E8,0xC8DB,0xC989,0xCB9B,0xCEF8,0xD39A,0xDB2C,
	0xE174,0xE787,0xEE1B,0xF317,0xF6FF,0xFAF2,0xFEB5,0x0192,
	0x03C4,0x0658,0x09F7,0x0DDE,0x1030,0x1246,0x1504,0x1736,
	0x1968,0x1B85,0x1F24,0x2457,0x294C,0x2C63,0x2E04,0x2E6C,
	0x2E64,0x2D51,0x2BC9,0x2A26,0x27FB,0x2443,0x1E77,0x188A,
	0x1253,0x0BFB,0x04A0,0xFDE8,0xF889,0xF354,0xEE85,0xEA8F,
	0xE7CF,0xE603,0xE40D,0xE18F,0xDFE7,0xE05F,0xE15A,0xE269,
	0xE41A,0xE550,0xE5F5,0xE623,0xE643,0xE6C0,0xE820,0xEA08,
	0xEB60,0xECB9,0xEDF5,0xF09A,0xF3A6,0xF6BD,0xF9DE,0xFD10,
	0x0061,0x03DA,0x07BA,0x0C5C,0x1161,0x15A2,0x17DE,0x1949,
	0x1A07,0x1B13,0x1C81,0x1CEC,0x1AB8,0x1AE6,0x19CE,0x162B,
	0x12EF,0x0FE8,0x0D16,0x0A66,0x07BB,0x04A6,0x022E,0xFFF1,
	0xFD93,0xFB59,0xF939,0xF787,0xF5C4,0xF425,0xF2B1,0xF16F,
	0xF083,0xEF5A,0xEDB9,0xEC0E,0xEAA4,0xE9C2,0xE93B,0xE933,
	0xE95C,0xE9F4,0xEA81,0xEB0C,0xEC5B,0xEDD9,0xEFF1,0xF23F,
	0xF4EC,0xF730,0xFA44,0xFD66,0x0074,0x02D2,0x04FC,0x06DC,
	0x08A4,0x09BE,0x0AF2,0x0C16,0x0D8A,0x0EAA,0x0E4D,0x0D8D,
	0x0D11,0x0C19,0x0B47,0x0AB8,0x0A71,0x0AA1,0x0A20,0x08A7,
	0x071F,0x06D4,0x070E,0x05AB,0x0471,0x0356,0x01FC,0x0009,
	0xFE27,0xFC50,0xFAD3,0xF95E,0xF771,0xF590,0xF4D4,0xF4C8,
	0xF3A4,0xF29F,0xF1F9,0xF240,0xF22A,0xF246,0xF3A8,0xF4F1,
	0xF566,0xF629,0xF816,0xF930,0xFA1E,0xFB5E,0xFCC8,0xFE65,
	0xFFFA,0x0142,0x024B,0x0355,0x03CB,0x039B,0x01CB,0xFE5D,
	0xFAB7,0xF735,0xF351,0xEDA2,0xE51A,0xD98A,0xC9F4,0xBE8F,
	0xBEE8,0xBF19,0xBF15,0xBF08,0xBF1A,0xBF12,0xC053,0xC6A5,
	0xD0ED,0xDF36,0xEFBE,0x005D,0x0F4C,0x1B82,0x27A5,0x3294,
	0x3A8D,0x3DC9,0x3DB8,0x3DF5,0x3E10,0x3DF5,0x3E09,0x3DF8,
	0x3DEC,0x3E41,0x3AFB,0x358A,0x3386,0x33D8,0x367A,0x391C,
	0x3AD0,0x3A02,0x37CA,0x34B2,0x31C9,0x2E89,0x29FF,0x23EC,
	0x1C98,0x14A5,0x0BFD,0x02A2,0xF8D6,0xEE47,0xE34E,0xD943,
	0xD141,0xCBBF,0xC8CF,0xC7C0,0xC776,0xC76B,0xC88E,0xCB17,
	0xCEC4,0xD3F8,0xDA84,0xE202,0xE8B2,0xEE0A,0xF233,0xF675,
	0xFA88,0xFEB8,0x00D4,0x0306,0x04FA,0x076D,0x0A37,0x0D09,
	0x1003,0x11CE,0x130C,0x1730,0x1942,0x1BD6,0x214B,0x2533,
	0x2890,0x2A6D,0x2AE7,0x2A08,0x2969,0x282B,0x25FF,0x22CB,
	0x1EA3,0x193E,0x130F,0x0C9D,0x0616,0x0042,0xF9EC,0xF40B,
	0xEE08,0xE970,0xE648,0xE416,0xE1F5,0xE0C0,0xDFBA,0xDF05,
	0xDF01,0xDF8D,0xE106,0xE256,0xE38E,0xE429,0xE515,0xE598,
	0xE69A,0xE72C,0xE859,0xEA53,0xEC6F,0xEDBF,0xEFA1,0xF236,
	0xF575,0xF917,0xFC6C,0x001A,0x040C,0x07B8,0x0B6B,0x0F4B,
	0x1339,0x15BF,0x1756,0x184E,0x194B,0x1A09,0x1A3C,0x1966,
	0x1796,0x1555,0x1224,0x0DC0,0x0A2E,0x07D6,0x051C,0x0259,
	0xFF8D,0xFD8C,0xFBDA,0xF9C6,0xF7A9,0xF58C,0xF427,0xF2EE,
	0xF1EF,0xF0FF,0xEFED,0xEF2B,0xEDD1,0xECD5,0xEAEE,0xEA73,
	0xEB1F,0xEA8A,0xE9D3,0xE9CA,0xEA9B,0xEB60,0xECA1,0xEE23,
	0xEF7D,0xF206,0xF466,0xF7AD,0xFAF7,0xFDA9,0xFFDF,0x0264,
	0x048A,0x06E5,0x0934,0x0B71,0x0D82,0x0E6F,0x0FA5,0x1112,
	0x0FF9,0x0F3F,0x0EDF,0x0E88,0x0E84,0x0EB8,0x0E5D,0x0D3B,
	0x0C13,0x0BF6,0x0BE2,0x0A4C,0x092F,0x0898,0x07E2,0x0655,
	0x04CB,0x02FE,0x0197,0xFFF1,0xFE2F,0xFC61,0xFAEC,0xFA0D,
	0xF89A,0xF740,0xF5E9,0xF50C,0xF4F7,0xF4E1,0xF456,0xF465,
	0xF512,0xF5CD,0xF690,0xF7BA,0xF8F3,0xFA8B,0xFBF2,0xFD42,
	0xFEB8,0x003B,0x01BA,0x02DD,0x03AB,0x04AD,0x060E,0x0690,
	0x06F3,0x05D5,0x035F,0xFF97,0xFBE6,0xF7B2,0xF398,0xED87,
	0xE3E3,0xD656,0xC726,0xBFD8,0xC03B,0xBFE0,0xBFF0,0xBFF8,
	0xC019,0xBFF5,0xC19B,0xC90C,0xD400,0xE2C0,0xF37D,0x03F2,
	0x13A2,0x212B,0x2D2B,0x3529,0x3BFB,0x3FFD,0x3F72,0x3F9E,
	0x3FB5,0x3FD2,0x3F84,0x3F89,0x3F83,0x3F8B,0x3BE1,0x36FF,
	0x34F1,0x3558,0x381B,0x3B74,0x3D2B,0x3BC6,0x38BE,0x3548,
	0x31C7,0x2DC2,0x29BD,0x2466,0x1D2A,0x1485,0x0ADB,0x0150,
	0xF6FA,0xEC7A,0xE256,0xD883,0xD047,0xCB3E,0xC92B,0xC91A,
	0xC9DB,0xCAB5,0xCABD,0xCB93,0xCF0C,0xD574,0xDCE9,0xE516,
	0xEC5B,0xF12C,0xF455,0xF70F,0xFA8C,0xFE2B,0x01C0,0x04AB,
	0x070E,0x0918,0x0B67,0x0DC1,0x106B,0x1367,0x15B0,0x180B,
	0x1ACB,0x2070,0x2529,0x28E0,0x2C5E,0x2E16,0x2DC4,0x2B90,
	0x2945,0x27EB,0x2631,0x23B2,0x2035,0x1B09,0x1459,0x0C2A,
	0x04EC,0xFEC8,0xF981,0xF4A1,0xEF65,0xEBA2,0xE961,0xE66B,
	0xE359,0xE11D,0xE05E,0xDFBB,0xDFE1,0xE087,0xE1B1,0xE32A,
	0xE400,0xE4C4,0xE52D,0xE51F,0xE5BD,0xE67D,0xE810,0xEA34,
	0xECA4,0xEEA3,0xF03E,0xF231,0xF56A,0xF94C,0xFBEB,0xFF4B,
	0x0462,0x08AE,0x0D25,0x1115,0x1459,0x1695,0x17CB,0x184F,
	0x1888,0x18F5,0x1910,0x189B,0x16D9,0x13D1,0x10BE,0x0D6F,
	0x0ACB,0x0808,0x05E6,0x0383,0x008D,0xFDE5,0xFB33,0xF938,
	0xF7BB,0xF646,0xF4F6,0xF325,0xF1AB,0xEFF5,0xEE7F,0xED86,
	0xECC8,0xEBB3,0xEA96,0xE963,0xE85E,0xE7FC,0xE7CE,0xE7ED,
	0xE897,0xE955,0xE974,0xEA7E,0xECAC,0xEF6F,0xF230,0xF481,
	0xF6DF,0xF947,0xFBFA,0xFEBD,0x01A1,0x043B,0x0665,0x0774,
	0x089A,0x09DD,0x0AEE,0x0B83,0x0C4C,0x0C01,0x0BAA,0x0B0B,
	0x0AE9,0x0B17,0x0A03,0x0953,0x0826,0x0767,0x061A,0x0536,
	0x04AA,0x0358,0x02EA,0x0260,0xFDDA,0xFC8A,0xFBC2,0xFAAB,
	0xF9BF,0xF890,0xF64B,0xF3EC,0xF205,0xF081,0xF06A,0xF09B,
	0xF095,0xEF32,0xEF17,0xEF2E,0xF029,0xF159,0xF2FD,0xF431,
	0xF514,0xF62C,0xF6F8,0xF8A5,0xFB3A,0xFE19,0xFFA6,0xFFCB,
	0xFFE6,0x0096,0x01BD,0x0378,0x0450,0x0373,0x009F,0xFBCE,
	0xF6C3,0xF2BF,0xEF56,0xE9E8,0xDFD2,0xD0DE,0xC332,0xBF91,
	0xBFCF,0xBF58,0xBF83,0xBFA5,0xBFB2,0xBFA1,0xC0F2,0xC9B9,
	0xD68B,0xE5E0,0xF6D5,0x0716,0x15A6,0x22A8,0x2D8F,0x36B9,
	0x3D2E,0x3F2A,0x3EC1,0x3DE2,0x3E37,0x3E68,0x3E82,0x3E70,
	0x3EDC,0x3BFA,0x366B,0x3263,0x3117,0x3312,0x36E0,0x3A06,
	0x3AAC,0x38A8,0x3584,0x3237,0x2FBC,0x2BF9,0x2680,0x212B,
	0x1A92,0x1174,0x07F6,0xFE6C,0xF458,0xE9EF,0xDFAA,0xD5E5,
	0xCEE1,0xCB48,0xC9A8,0xC954,0xC9B2,0xCA21,0xCADC,0xCCE0,
	0xD0F5,0xD7D9,0xDF86,0xE6E7,0xED0B,0xF15F,0xF606,0xF960,
	0xFB8B,0xFF61,0x02D0,0x04F8,0x06D6,0x08DC,0x0B3E,0x0E17,
	0x112F,0x145C,0x1777,0x19B4,0x1C7F,0x2069,0x249A,0x2929,
	0x2C19,0x2D51,0x2CA9,0x2AFF,0x2954,0x27A2,0x25A7,0x2272,
	0x1DA4,0x17A8,0x1146,0x0A29,0x03F7,0xFE2C,0xF817,0xF283,
	0xED46,0xE918,0xE6D0,0xE55F,0xE42F,0xE344,0xE1F1,0xE0B8,
	0xDFFE,0xE07A,0xE226,0xE3EA,0xE533,0xE5F5,0xE673,0xE6C8,
	0xE736,0xE804,0xE958,0xEB3F,0xECF9,0xEEFC,0xF165,0xF47A,
	0xF7FE,0xFBB1,0xFF16,0x02D0,0x0630,0x09E9,0x0DC3,0x12C7,
	0x1688,0x1972,0x1AA9,0x1AE1,0x1AC4,0x1AF5,0x1AB7,0x19E9,
	0x18CA,0x16E6,0x13E8,0x0E58,0x0C27,0x09F6,0x0687,0x04AD,
	0x02AF,0xFF85,0xFD05,0xFB15,0xF97A,0xF7EB,0xF672,0xF480,
	0xF297,0xF167,0xF01E,0xEF96,0xEE7C,0xED0C,0xEB9D,0xEA20,
	0xE939,0xE873,0xE83F,0xE94D,0xEA7A,0xEB74,0xEC38,0xED34,
	0xEF02,0xF1CD,0xF4E0,0xF77D,0xF9D6,0xFC24,0xFEB1,0x016D,
	0x03D4,0x06B1,0x094E,0x0A5C,0x0A5C,0x0AA1,0x0B7B,0x0CC9,
	0x0D8C,0x0D8A,0x0D35,0x0C6B,0x0B13,0x09D7,0x0978,0x094F,
	0x0886,0x0761,0x060A,0x053C,0x04DB,0x03AB,0x02B2,0x0161,
	0x009B,0x0084,0xFE0C,0xFC75,0xFB81,0xFA6B,0xF8E1,0xF640,
	0xF431,0xF2CE,0xF241,0xF25B,0xF1DB,0xF18C,0xF1EE,0xF1BD,
	0xF1D3,0xF29A,0xF3F8,0xF4F1,0xF5AC,0xF77B,0xF897,0xFA46,
	0xFC12,0xFD71,0xFE01,0xFECD,0xFFB4,0x008F,0x01AF,0x020F,
	0x00F5,0xFE5C,0xFA52,0xF5EE,0xF207,0xED5B,0xE64C,0xDADA,
	0xCBC6,0xC059,0xBEE6,0xBED8,0xBEF8,0xBE9F,0xBE4A,0xBF08,
	0xBF6C,0xC43F,0xCDDD,0xDB60,0xEBEA,0xFCC0,0x0C95,0x1A68,
	0x26A4,0x3075,0x3876,0x3D86,0x3DF4,0x3DCA,0x3E07,0x3DFB,
	0x3E00,0x3DFD,0x3DF9,0x3E32,0x3B84,0x363A,0x32E2,0x3239,
	0x34B6,0x3813,0x3A52,0x3A78,0x38C7,0x35CC,0x31BD,0x2DB7,
	0x2986,0x24E2,0x1F08,0x1748,0x0E69,0x0450,0xF9AE,0xEEC9,
	0xE41C,0xDA38,0xD28E,0xCC7A,0xC8DC,0xC783,0xC759,0xC75C,
	0xC80F,0xC99D,0xCC64,0xD121,0xD7AE,0xDF64,0xE690,0xECD6,
	0xF167,0xF496,0xF762,0xFAA3,0xFE3A,0x0084,0x02EC,0x058A,
	0x087C,0x0A43,0x0C0A,0x0E6F,0x10B6,0x12E8,0x1603,0x19A4,
	0x1E17,0x21DC,0x26DF,0x2805,0x27B1,0x28EE,0x27AF,0x2661,
	0x24CD,0x2230,0x1E75,0x199F,0x13AB,0x0DA3,0x073F,0x0124,
	0xF9FF,0xF41F,0xEF7B,0xEB77,0xE7E6,0xE51B,0xE357,0xE1DB,
	0xE0C1,0xDF56,0xDF14,0xDFBB,0xE192,0xE342,0xE459,0xE56B,
	0xE65A,0xE65F,0xE643,0xE7AE,0xE908,0xEAE0,0xECF5,0xEE50,
	0xF049,0xF2F9,0xF60C,0xF902,0xFC53,0x0080,0x0490,0x0827,
	0x0BB6,0x0F5F,0x12D9,0x1551,0x1791,0x19A1,0x1AB9,0x1B19,
	0x1AD3,0x19EE,0x1844,0x165A,0x1435,0x11A0,0x0EAC,0x0B90,
	0x087A,0x04FF,0xFFF3,0xFCD0,0xFBDF,0xFA98,0xF8B3,0xF6A0,
	0xF54F,0xF3D6,0xF2AA,0xF0FF,0xEF3E,0xEE60,0xED60,0xECB8,
	0xEB99,0xEAA8,0xEA26,0xEA03,0xE920,0xE817,0xE84E,0xEA9D,
	0xEC07,0xECAC,0xEE8D,0xF093,0xF2E1,0xF523,0xF7EE,0xFAAE,
	0xFDE8,0x00C8,0x0340,0x05B0,0x07B3,0x09AE,0x0B25,0x0BFB,
	0x0CAE,0x0DB1,0x0E85,0x0F06,0x0F13,0x0EE5,0x0D27,0x0C35,
	0x0B92,0x0B2D,0x0B28,0x0A96,0x09C2,0x0874,0x06EB,0x0587,
	0x04FF,0x049D,0x03CF,0x02A7,0x013E,0xFEDF,0xFCC6,0xFAB7,
	0xF93D,0xF846,0xF719,0xF578,0xF453,0xF36C,0xF381,0xF399,
	0xF2B2,0xF270,0xF2E4,0xF3C7,0xF554,0xF6AF,0xF87F,0xF9CD,
	0xFA6C,0xFAD0,0xFBE5,0xFD35,0xFF5A,0x00DE,0x0219,0x0334,
	0x0409,0x042F,0x042B,0x0448,0x0339,0x0083,0xFC89,0xF91D,
	0xF597,0xF118,0xE8CB,0xDD60,0xD022,0xC3DA,0xBFCF,0xC00F,
	0xBFFD,0xBFEA,0xC0C7,0xC44D,0xC7DC,0xCDF3,0xD6EC,0xE341,
	0xF1AD,0x0118,0x0F28,0x1B32,0x2599,0x2E82,0x352F,0x39AA,
	0x3CCD,0x3E44,0x3D9C,0x3D06,0x3F2B,0x3EA0,0x3D75,0x3A7D,
	0x3664,0x321F,0x2F86,0x2F8D,0x31CB,0x3497,0x3633,0x358D,
	0x33AE,0x30E0,0x2DA7,0x29F0,0x2614,0x219E,0x1BD3,0x1497,
	0x0C55,0x039A,0xFAB1,0xF0E5,0xE69F,0xDE28,0xD75D,0xD292,
	0xCFEC,0xCEF3,0xCEEB,0xCF15,0xCEB8,0xCF4E,0xD247,0xD7DF,
	0xDE3E,0xE4FE,0xEAEB,0xEFAB,0xF336,0xF63D,0xF8DF,0xFC0C,
	0xFF01,0x018D,0x02EC,0x0456,0x06F5,0x098A,0x0C0C,0x0DDA,
	0x0FBD,0x11FA,0x14F4,0x180A,0x1B8E,0x1F4F,0x22C7,0x253A,
	0x2840,0x27CE,0x25F9,0x23D8,0x21B3,0x1F58,0x1B4A,0x1640,
	0x10EE,0x0B5B,0x055F,0xFF7E,0xF9FF,0xF4B0,0xEFF5,0xEC33,
	0xE928,0xE6BC,0xE56A,0xE398,0xE22E,0xE1D0,0xE131,0xE13A,
	0xE2B8,0xE483,0xE578,0xE6AB,0xE712,0xE6C3,0xE6DC,0xE7AF,
	0xE931,0xEB55,0xEC35,0xEE32,0xF06B,0xF235,0xF4B6,0xF737,
	0xF9FE,0xFD01,0x007D,0x04C0,0x08F1,0x0B58,0x0EB2,0x11D8,
	0x1340,0x13A0,0x1426,0x14D4,0x157B,0x1556,0x1403,0x1202,
	0x0ECE,0x0B7D,0x08D5,0x0699,0x0403,0x0219,0xFF9F,0xFD2F,
	0xFB03,0xF905,0xF7DD,0xF6EE,0xF540,0xF3AC,0xF264,0xF158,
	0xF017,0xEF75,0xEEC6,0xED42,0xEBAF,0xEAAB,0xE9D1,0xE954,
	0xE8D4,0xE90B,0xE9CF,0xEA37,0xEAC2,0xEBFE,0xEDC6,0xF017,
	0xF268,0xF478,0xF70C,0xF9DD,0xFC51,0xFEDA,0x012B,0x031B,
	0x04FF,0x0660,0x076E,0x0838,0x095A,0x09FF,0x0A3E,0x09FD,
	0x0950,0x088E,0x0818,0x07C5,0x070E,0x05F9,0x055A,0x054F,
	0x0514,0x03CF,0x0364,0x02C3,0x017D,0xFFB4,0xFE81,0xFD97,
	0xFC54,0xFB85,0xFBEC,0xF87A,0xF734,0xF56B,0xF3E2,0xF341,
	0xF362,0xF361,0xF285,0xF1E3,0xF1E5,0xF24F,0xF257,0xF358,
	0xF484,0xF5F5,0xF758,0xF834,0xF9FC,0xFB74,0xFC86,0xFD2D,
	0xFE57,0xFFEA,0x0129,0x0272,0x0359,0x049B,0x0550,0x04ED,
	0x037C,0x0221,0x0116,0x00E3,0x0051,0xFE99,0xFA4D,0xF4BE,
	0xEE94,0xE912,0xE58D,0xE45C,0xE55C,0xE717,0xE89D,0xE991,
	0xEB75,0xEDA6,0xF105,0xF5B8,0xFB12,0x0107,0x0756,0x0C42,
	0x1025,0x133A,0x1501,0x155B,0x1531,0x1559,0x1689,0x17C3,
	0x179F,0x1648,0x1388,0x12C2,0x113D,0x0FE2,0x0F60,0x104D,
	0x11D2,0x1313,0x1414,0x147F,0x147F,0x1383,0x1165,0x0F6C,
	0x0E0C,0x0CE1,0x0BB6,0x0A1B,0x06FD,0x02D9,0xFEEC,0xFAA2,
	0xF5E3,0xF1CC,0xF057,0xEFCD,0xEF0D,0xEEB7,0xEE68,0xEE0B,
	0xEDF5,0xEE36,0xEFA1,0xF20A,0xF451,0xF6DE,0xF969,0xFB2C,
	0xFCF5,0xFD8B,0xFDF8,0xFEA4,0xFF04,0x00F8,0x027E,0x029D,
	0x0307,0x02F4,0x03A0,0x0473,0x0552,0x064C,0x076D,0x091D,
	0x0B4C,0x0D0D,0x0E4D,0x0F98,0x1090,0x103E,0x0F79,0x0EF7,
	0x0EB5,0x0DD8,0x0C24,0x0A84,0x08D3,0x0640,0x03BA,0x0224,
	0x006E,0xFEC1,0xFC99,0xFB6E,0xFA5F,0xF8C0,0xF7AE,0xF74D,
	0xF6DE,0xF6CD,0xF754,0xF737,0xF74B,0xF761,0xF7AD,0xF7C9,
	0xF7F0,0xF837,0xF811,0xF877,0xF8C0,0xF91E,0xF9B1,0xFA83,
	0xFB04,0xFB70,0xFC6A,0xFD77,0xFEC4,0x0013,0x0201,0x02E0,
	0x03F4,0x04E8,0x06BB,0x07DE,0x08E0,0x0944,0x0920,0x08A8,
	0x07C4,0x0741,0x0752,0x078F,0x06C1,0x059F,0x043F,0x034D,
	0x02C1,0x01F3,0xFF69,0x009E,0xFFD6,0xFE20,0xFDCE,0xFDD9,
	0xFD71,0xFC26,0xFB11,0xFAC0,0xFAF1,0xFA70,0xF987,0xF930,
	0xF967,0xF8F8,0xF869,0xF775,0xF73B,0xF6F4,0xF735,0xF736,
	0xF69D,0xF609,0xF597,0xF561,0xF4EF,0xF489,0xF432,0xF376,
	0xF333,0xF338,0xF354,0xF1D4,0xEE50,0xE9E0,0xE727,0xE5FE,
	0xE676,0xE7AE,0xE939,0xE9AD,0xE8B8,0xE733,0xE690,0xE6E3,
	0xE785,0xE830,0xE8D9,0xE95B,0xE8FC,0xE924,0xE8B0,0xE886,
	0xE853,0xE80F,0xE7BA,0xE75D,0xE772,0xE740,0xE764,0xE852,
	0xE9CE,0xE8A5,0xE84B,0xE886,0xE8A8,0xE89B,0xE8CD,0xE85C,
	0xE842,0xE821,0xE804,0xE83A,0xE86E,0xE86C,0xE855,0xE84E,
	0xE851,0xE86E,0xE8AD,0xE8DF,0xE9A9,0xEA42,0xEA30,0xEA7E,
	0xEB84,0xEC0D,0xEC55,0xEBEC,0xEB45,0xEAF7,0xEB69,0xEBA0,
	0xEC60,0xECC9,0xECC0,0xECA1,0xED25,0xED5E,0xEDD8,0xEE6D,
	0xEED8,0xEF7B,0xF003,0xF0AE,0xF0BC,0xF015,0xF0ED,0xF1BA,
	0xF208,0xF2A3,0xF2EE,0xF357,0xF3D5,0xF44D,0xF462,0xF40D,
	0xF40C,0xF44C,0xF520,0xF56B,0xF5D5,0xF62D,0xF67C,0xF6B9,
	0xF706,0xF74A,0xF804,0xF88E,0xF90C,0xF99D,0xFA2C,0xFA74,
	0xFAA1,0xFB06,0xFB81,0xFC1D,0xFCA9,0xFDB3,0xFE57,0xFF05,
	0xFF51,0xFF24,0xFEBC,0xFEAD,0xFED0,0xFF84,0x005E,0x00F2,
	0x0153,0x0190,0x01F7,0x0226,0x0276,0x033E,0x0392,0x0408,
	0x03D8,0x03F0,0x03EF,0x0436,0x049E,0x0498,0x0479,0x049A,
	0x0536,0x0586,0x063C,0x0671,0x0698,0x074A,0x073D,0x0819,
	0x0876,0x0913,0x0916,0x0928,0x091F,0x095B,0x0A01,0x09CE,
	0x095F,0x0B83,0x0B2D,0x0A5F,0x0BF3,0x0B9C,0x0BAD,0x0C49,
	0x0C52,0x0C2E,0x0C74,0x0C95,0x0CF1,0x0D38,0x0D78,0x0D50,
	0x0D6E,0x0D6E,0x0D67,0x0D79,0x0DAB,0x0E51,0x0E32,0x0E20,
	0x0DE2,0x0E0A,0x0DF7,0x0DFD,0x0E25,0x0EC5,0x0F40,0x0F17,
	0x0F25,0x0F5B,0x0F20,0x0E8E,0x0E95,0x0ED4,0x0F1A,0x0F00,
	0x0F80,0x0FD6,0x0F83,0x0F46,0x0F31,0x0F93,0x0F63,0x0FB4,
	0x0F83,0x0F4B,0x0EF8,0x0EE6,0x0EA8,0x0E88,0x0E93,0x0E71,
	0x0ED6,0x0E87,0x0E65,0x0EA0,0x0EA2,0x0E70,0x0EC0,0x0E46,
	0x0D93,0x0BE8,0x0B49,0x0C19,0x0C4C,0x0C3C,0x0BDB,0x0BF7,
	0x0B7A,0x0B92,0x0C16,0x0C16,0x0C70,0x0C3A,0x0C50,0x0C82,
	0x0C91,0x0CCC,0x0CF5,0x0D00,0x0C32,0x0C55,0x0C87,0x0C9C,
	0x0D15,0x0CD4,0x0CDB,0x0CBC,0x0C90,0x0D0A,0x0D2E,0x0D87,
	0x0D76,0x0D2F,0x0CF3,0x0CC9,0x0CAA,0x0D07,0x0CEE,0x0C93,
	0x0C6A,0x0C85,0x0C82,0x0C38,0x0C57,0x0D59,0x0C28,0x0B65,
	0x0AF5,0x0AE5,0x0AEB,0x0B33,0x0B16,0x0AFC,0x0AE8,0x0B47,
	0x0B7E,0x0B8E,0x0BC5,0x0C27,0x0BD5,0x0BB0,0x0BB1,0x0B23,
	0x0B40,0x0B37,0x0B4B,0x0B3D,0x0B26,0x0B1E,0x0ACB,0x0A60,
	0x09E1,0x09F0,0x09E6,0x09AC,0x0983,0x0942,0x0907,0x08A4,
	0x0897,0x08CC,0x08C8,0x08A7,0x0850,0x0859,0x0895,0x0853,
	0x0807,0x07F3,0x0818,0x0790,0x0761,0x078F,0x07AF,0x073B,
	0x06FE,0x073F,0x0752,0x074C,0x0735,0x070C,0x069B,0x0643,
	0x05EB,0x05D5,0x05BB,0x05F0,0x0610,0x05B9,0x05CC,0x05A0,
	0x05AD,0x0563,0x051E,0x04EA,0x0563,0x0546,0x04CA,0x04C0,
	0x0549,0x0423,0x03B8,0x0580,0x0474,0x0480,0x0491,0x041F,
	0x03BD,0x0364,0x0372,0x03E4,0x03F9,0x03E4,0x038B,0x0344,
	0x0324,0x030B,0x0292,0x0289,0x0291,0x029E,0x02A0,0x0290,
	0x022B,0x01DB,0x01D7,0x0231,0x0274,0x0253,0x0276,0x0264,
	0x0213,0x01D9,0x014B,0x01BD,0x01D1,0x0209,0x01B7,0x019F,
	0x0155,0x00D8,0x0092,0x006F,0x00A7,0x00B3,0x0093,0x00C1,
	0x0089,0xFF35,0xFFD0,0xFFF5,0xFFC1,0xFF76,0xFF66,0xFF2B,
	0xFF20,0xFF61,0xFFAD,0xFF4F,0xFF2E,0xFF4A,0xFF4E,0xFF45,
	0xFEFE,0xFF09,0xFEAC,0xFE93,0xFED8,0xFEE2,0xFE27,0xFD14,
	0xFDF7,0xFF11,0xFEAD,0xFE1A,0xFDCC,0xFDEF,0xFE07,0xFDFB,
	0xFDE3,0xFE2C,0xFDA4,0xFD4F,0xFDB4,0xFCF3,0xFC58,0xFCA7,
	0xFC61,0xFC8E,0xFC9C,0xFCCB,0xFCBB,0xFCC4,0xFCD0,0xFC8E,
	0xFD02,0xFCEB,0xFCB2,0xFCF6,0xFD16,0xFD55,0xFD6B,0xFD6C,
	0xFD63,0xFD84,0xFDA0,0xFDAE,0xFD7F,0xFD84,0xFD76,0xFDBA,
	0xFDAE,0xFD78,0xFD88,0xFDCB,0xFDD8,0xFDB6,0xFDB1,0xFDB5,
	0xFDC8,0xFDCC,0xFD97,0xFDD4,0xFDF2,0xFDF6,0xFE22,0xFDF2,
	0xFE1A,0xFDFF,0xFE0B,0xFE53,0xFEA0,0xFF50,0xFF29,0xFFF4,
	0x0079,0x0100,0x0160,0x01FC,0x0344,0x042F,0x054E,0x065B,
	0x0768,0x07F4,0x07FE,0x09F5,0x0885,0x0813,0x092D,0x08B9,
	0x087A,0x08EA,0x0913,0x08BC,0x08CB,0x08DF,0x09B3,0x0A6E,
	0x0B3A,0x0B9B,0x0BC2,0x0C35,0x0C4C,0x0C89,0x0CA9,0x0D4F,
	0x0D7A,0x0E7A,0x0F46,0x1052,0x110A,0x11BB,0x1183,0x110F,
	0x10E9,0x10ED,0x119E,0x129A,0x13F1,0x149B,0x14E3,0x1439,
	0x13C9,0x13B3,0x146E,0x1526,0x15D9,0x167D,0x16D4,0x16FD,
	0x1700,0x16F1,0x1733,0x178D,0x179C,0x17B3,0x1776,0x1725,
	0x1734,0x172E,0x172F,0x175A,0x176A,0x1772,0x16EE,0x163E,
	0x1685,0x1693,0x15C7,0x136E,0x129B,0x12BD,0x1243,0x120D,
	0x11FA,0x1180,0x1126,0x10DA,0x10CC,0x108B,0x106F,0x0FEC,
	0x0F38,0x0ED0,0x0EA4,0x0E67,0x0E90,0x0E6F,0x0D15,0x0C74,
	0x0CC9,0x0C80,0x0C03,0x0C31,0x0BDF,0x0AF2,0x0A1C,0x09E9,
	0x098C,0x0988,0x09E0,0x0993,0x08EA,0x080A,0x0742,0x06B3,
	0x06E8,0x06EF,0x0752,0x079B,0x070B,0x05EE,0x064B,0x05F3,
	0x0462,0x03BB,0x02FB,0x027C,0x01CA,0x0143,0x00B6,0xFFA8,
	0xFE0B,0xFBE1,0xF9BC,0xF6D4,0xF498,0xF38C,0xF281,0xF1B8,
	0xF0CF,0xEF85,0xEE31,0xECF5,0xEC6D,0xECC4,0xEDCE,0xEF86,
	0xF146,0xF2B7,0xF487,0xF69B,0xF89E,0xFA3C,0xFC2D,0xFE1A,
	0x0004,0x020F,0x0398,0x0520,0x0678,0x0760,0x07B8,0x0774,
	0x06D6,0x06E7,0x0746,0x06B8,0x068E,0x0641,0x05C2,0x04A6,
	0x038B,0x0301,0x024A,0x0217,0x01FF,0x0275,0x0295,0x0296,
	0x021A,0x0169,0x00ED,0x005E,0xFF90,0xFEA0,0xFD98,0xFD38,
	0xFCE6,0xFB69,0xF9FF,0xF84A,0xF65D,0xF39F,0xF1FA,0xF0A5,
	0xEF8B,0xEE16,0xED90,0xEA87,0xE92D,0xE92C,0xE678,0xE58F,
	0xE56A,0xE45D,0xE396,0xE3B4,0xE438,0xE465,0xE472,0xE4E8,
	0xE576,0xE574,0xE54B,0xE5A8,0xE69B,0xE7B6,0xE87E,0xE93E,
	0xE949,0xE98D,0xE980,0xE928,0xE9D3,0xEAFB,0xEBA1,0xEC07,
	0xECB2,0xEDB7,0xEE5D,0xEECE,0xEF12,0xEFA0,0xF07B,0xF185,
	0xF264,0xF3E5,0xF5CF,0xF693,0xF663,0xF653,0xF6A7,0xF779,
	0xF818,0xF8CC,0xF9AE,0xFA4E,0xF9C6,0xF8C6,0xF7FC,0xF798,
	0xF76F,0xF6CB,0xF65E,0xF66E,0xF604,0xF4F6,0xF3EC,0xF3B5,
	0xF39F,0xF543,0xF3E5,0xF2D4,0xF254,0xF1E3,0xF19B,0xF14A,
	0xF101,0xEFFF,0xEF4A,0xEEC1,0xEEBB,0xEF55,0xEF1A,0xEE6F,
	0xEE04,0xED90,0xED37,0xED47,0xECE7,0xED34,0xEDDE,0xED28,
	0xEC95,0xED40,0xEDAB,0xED57,0xEDD8,0xEE77,0xEEAD,0xEEE8,
	0xEF26,0xEF92,0xF038,0xF0C8,0xF15C,0xF2A8,0xF39E,0xF3D6,
	0xF433,0xF562,0xF663,0xF722,0xF795,0xF804,0xF7D1,0xF79E,
	0xF890,0xF92D,0xF969,0xFA74,0xFB00,0xFAB1,0xFAAC,0xFAD3,
	0xFA27,0xF95B,0xF91E,0xF982,0xFA4E,0xF98B,0xF917,0xF898,
	0xF86C,0xF84F,0xF847,0xF833,0xF7F0,0xF809,0xF7EE,0xF712,
	0xF6DB,0xF6F5,0xF6E1,0xF6ED,0xF674,0xF5C6,0xF5AF,0xF571,
	0xF55C,0xF589,0xF56B,0xF4DB,0xF442,0xF449,0xF421,0xF415,
	0xF424,0xF414,0xF3FA,0xF3E0,0xF3D9,0xF3C0,0xF40A,0xF3EA,
	0xF414,0xF47A,0xF464,0xF452,0xF440,0xF46E,0xF4BD,0xF4E4,
	0xF4C4,0xF4FA,0xF5E6,0xF672,0xF674,0xF579,0xF488,0xF2D1,
	0xF134,0xF0AC,0xF056,0xEEFA,0xEC36,0xE726,0xE0DC,0xDA3F,
	0xD432,0xCF69,0xCE5C,0xCE7F,0xCB37,0xCA7D,0xC903,0xC82B,
	0xC8C9,0xCAC5,0xCE54,0xD37A,0xD9DB,0xE0AE,0xE7DC,0xEFEC,
	0xF7F5,0xFEF6,0x052A,0x0B15,0x112B,0x1709,0x1CFB,0x2324,
	0x2871,0x2C5D,0x2E77,0x2E74,0x2DE6,0x2E05,0x2E1D,0x2E2E,
	0x2EA4,0x2EEE,0x2EF4,0x2E22,0x2CA5,0x2B1A,0x2A37,0x2A1E,
	0x29BF,0x29A0,0x29EC,0x2A2A,0x2A6C,0x2A41,0x297F,0x281A,
	0x262A,0x22F2,0x1FD9,0x1D3E,0x1B6F,0x1922,0x155A,0x10B0,
	0x0B8A,0x05A4,0xFF51,0xF9AD,0xF4A1,0xF088,0xEC61,0xE8BA,
	0xE4D8,0xE153,0xDD0A,0xD8FE,0xD7A3,0xD6B6,0xD648,0xD68B,
	0xD794,0xD913,0xDA84,0xDBE5,0xDD61,0xDE9B,0xE083,0xE262,
	0xE4EB,0xE7C2,0xEA0C,0xEC1E,0xEE8F,0xEFA1,0xEFE8,0xF1A9,
	0xF39C,0xF539,0xF713,0xF96F,0xFB54,0xFCA4,0xFE21,0x0034,
	0x0215,0x0436,0x0718,0x0A23,0x0C39,0x0E53,0x10C4,0x12E3,
	0x145E,0x164E,0x1849,0x1A8A,0x1B70,0x1B15,0x1B60,0x1B03,
	0x1A2F,0x1975,0x17F5,0x16CF,0x1556,0x1331,0x108B,0x0E43,
	0x0C83,0x0BC6,0x0A23,0x073E,0x04F9,0x0336,0x010D,0xFF41,
	0xFD97,0xFC8F,0xFB8D,0xFA56,0xF8CB,0xF701,0xF5A6,0xF4F9,
	0xF408,0xF332,0xF2B4,0xF237,0xF171,0xF03D,0xEFB0,0xEF35,
	0xEEB0,0xEE6A,0xEDF9,0xED9F,0xEDAA,0xED81,0xEDA0,0xEE10,
	0xEF4F,0xF068,0xF0C4,0xF13D,0xF2AC,0xF4B6,0xF6AA,0xF850,
	0xFA07,0xFBF6,0xFD21,0xFE62,0x0076,0x02C3,0x045C,0x0599,
	0x06E4,0x0860,0x0989,0x0A58,0x0AE6,0x0BD7,0x0C6C,0x0CAB,
	0x0C87,0x0C99,0x0C58,0x0C18,0x0BB6,0x0B56,0x0BDD,0x0BC4,
	0x0B57,0x0AC0,0x09FF,0x0816,0x0A00,0x09F6,0x088C,0x0823,
	0x07D4,0x06EE,0x05E3,0x0510,0x04D4,0x040B,0x02BF,0x016E,
	0x0055,0xFF49,0xFE59,0xFD6B,0xFC25,0xFB01,0xFA1C,0xF93D,
	0xF875,0xF804,0xF780,0xF6F9,0xF63E,0xF59A,0xF4D8,0xF591,
	0xF665,0xF6B8,0xF661,0xF6C0,0xF734,0xF799,0xF85A,0xF8FF,
	0xF990,0xFA3B,0xFABE,0xFB25,0xFBAF,0xFC8C,0xFDDE,0xFE4B,
	0xFDDC,0xFC5B,0xFA38,0xF905,0xF850,0xF759,0xF51D,0xF1A6,
	0xEBD1,0xE405,0xDC23,0xD707,0xD417,0xD1E8,0xD0EB,0xCFD3,
	0xCF99,0xCFAA,0xCE2C,0xCF16,0xD292,0xD751,0xDC87,0xE2D2,
	0xEA4D,0xF288,0xFB22,0x0378,0x0B82,0x1236,0x1845,0x1E00,
	0x23AA,0x2997,0x2FA8,0x3465,0x36B1,0x3924,0x390C,0x3752,
	0x3664,0x36C8,0x365E,0x35FA,0x34D5,0x341B,0x32AC,0x30C1,
	0x2FB6,0x2F7A,0x2EBB,0x2DBB,0x2D5B,0x2CEF,0x2D35,0x2D30,
	0x2D4D,0x2CDC,0x2B2B,0x283F,0x253C,0x21AB,0x1D57,0x1AB4,
	0x1806,0x14EB,0x105D,0x0AB4,0x045A,0xFE35,0xF812,0xF24B,
	0xED03,0xE814,0xE475,0xE148,0xDD9C,0xDA81,0xD79D,0xD577,
	0xD450,0xD455,0xD517,0xD671,0xD82C,0xD9FD,0xDC1A,0xDE2A,
	0xE001,0xE193,0xE3A6,0xE613,0xE816,0xEA2F,0xECD0,0xEFA5,
	0xF192,0xF25A,0xF30D,0xF3D0,0xF58A,0xF7A8,0xF988,0xFC1E,
	0xFE3F,0xFFEB,0x0172,0x035B,0x05E1,0x0891,0x0AB8,0x0CA0,
	0x0F30,0x1143,0x13B0,0x167E,0x1819,0x1977,0x1A48,0x1AD2,
	0x1A9C,0x1A1D,0x19C5,0x198A,0x18C9,0x1758,0x1564,0x1332,
	0x111B,0x0E65,0x0B52,0x089B,0x06D4,0x044D,0x023B,0x003F,
	0xFE1F,0xFBC5,0xFBEB,0xF85F,0xF5EC,0xF590,0xF39E,0xF26A,
	0xF1F3,0xF12A,0xF076,0xEFCF,0xEEE6,0xEDFA,0xECF9,0xEC17,
	0xEB4F,0xEB1D,0xEB1A,0xEB35,0xEB44,0xEA5E,0xE9C6,0xE961,
	0xE9D2,0xEAAD,0xEBC9,0xECDB,0xEDB5,0xEEF2,0xF008,0xF106,
	0xF2AE,0xF498,0xF70E,0xF8E0,0xFA9F,0xFCB3,0xFEAA,0x0046,
	0x0266,0x0419,0x0586,0x06B3,0x07B5,0x085B,0x0971,0x0AB7,
	0x0C61,0x0D33,0x0CD9,0x0C2F,0x0BCA,0x0C25,0x0CF4,0x0D3E,
	0x0C6F,0x0BD7,0x0B33,0x0A6A,0x097A,0x09C9,0x09A9,0x08DC,
	0x07DB,0x05DE,0x0299,0x01F0,0x025F,0x01EF,0x01D8,0x013A,
	0xFFA1,0xFE4D,0xFD11,0xFC01,0xFAC9,0xF98A,0xF8FB,0xF8C1,
	0xF803,0xF6F3,0xF604,0xF5CD,0xF506,0xF2D1,0xF221,0xF2E1,
	0xF33F,0xF30A,0xF387,0xF433,0xF3F1,0xF40A,0xF485,0xF568,
	0xF618,0xF6F6,0xF7B3,0xF829,0xF8FE,0xF9DA,0xFB67,0xFC72,
	0xFCF0,0xFD19,0xFD70,0xFD78,0xFD04,0xFCB3,0xFC0A,0xF9B0,
	0xF88E,0xF71A,0xF4B2,0xF0C2,0xEAEC,0xE350,0xDBB2,0xD697,
	0xD422,0xD30C,0xD207,0xD0BA,0xD020,0xCED7,0xCE2B,0xCF30,
	0xD2A8,0xD81D,0xDE18,0xE44E,0xEBFB,0xF43C,0xFCE1,0x0524,
	0x0CBF,0x1386,0x18F1,0x1DF1,0x23D4,0x2A00,0x300A,0x34F3,
	0x3883,0x39A0,0x3936,0x37AF,0x3685,0x36BA,0x3721,0x371E,
	0x36A6,0x354D,0x340C,0x3227,0x314F,0x30C1,0x3003,0x2F4F,
	0x2F1A,0x2F01,0x2F6A,0x2FF5,0x2F86,0x2E59,0x2C4B,0x296E,
	0x265E,0x2357,0x210C,0x1E4A,0x1A67,0x1644,0x10D7,0x0B1A,
	0x0500,0xFEAD,0xF93C,0xF4E9,0xEFC4,0xEB3A,0xE7A9,0xE3CD,
	0xE140,0xDFE2,0xDC49,0xDA39,0xDAFD,0xD9FA,0xDA31,0xDBD1,
	0xDDF6,0xE015,0xE1E5,0xE30F,0xE413,0xE5DE,0xE78C,0xE9D0,
	0xECD4,0xEF66,0xF125,0xF286,0xF398,0xF455,0xF5A9,0xF735,
	0xF890,0xFA7F,0xFC12,0xFD53,0xFF7C,0x01CE,0x0406,0x0659,
	0x085A,0x0A00,0x0C33,0x0E58,0x10F7,0x1381,0x166B,0x1897,
	0x19D1,0x1A3C,0x1A92,0x1B38,0x1BC7,0x1BE9,0x1C0E,0x1B7B,
	0x1A41,0x1810,0x1641,0x13DD,0x11B6,0x0FA2,0x0D2E,0x0A4E,
	0x0829,0x05DC,0x0391,0x01A4,0xFF27,0xFCBE,0xFB14,0xF9B0,
	0xFAF5,0xF9B3,0xF804,0xF74F,0xF644,0xF4F1,0xF346,0xF238,
	0xF1BF,0xF0B6,0xEFDB,0xEF8C,0xEFC1,0xEF60,0xEE30,0xECB0,
	0xEC00,0xEBBB,0xEB6E,0xEAF5,0xEBF5,0xED48,0xED64,0xED3C,
	0xEE67,0xF028,0xF0D8,0xF22E,0xF36F,0xF56F,0xF7E4,0xFA1C,
	0xFC07,0xFDBE,0xFF1A,0x0056,0x016E,0x02D3,0x0483,0x0672,
	0x0811,0x08E5,0x0940,0x09CD,0x0A70,0x0938,0x09B4,0x0B5E,
	0x0BAF,0x0BA1,0x0B91,0x0B61,0x0B6A,0x0B12,0x0A55,0x0943,
	0x085D,0x07C2,0x06F4,0x069C,0x0618,0x0597,0x04D9,0x0386,
	0x026A,0x01BB,0x0113,0x0044,0xFF8D,0xFE8E,0xFD06,0xFBF1,
	0xFAE1,0xF99F,0xF864,0xF79C,0xF699,0xF553,0xF40F,0xF31D,
	0xF2CB,0xF25D,0xF1A6,0xF13C,0xF0E8,0xF035,0xEF93,0xEFB3,
	0xF0D5,0xF1C4,0xF2A8,0xF2A3,0xF297,0xF2C3,0xF309,0xF3C1,
	0xF4EF,0xF61E,0xF6F0,0xF763,0xF7C2,0xF8D6,0xF95D,0xF910,
	0xF80C,0xF6B3,0xF543,0xF44B,0xF39B,0xF2D6,0xF082,0xEB97,
	0xE476,0xDC04,0xD56B,0xD11E,0xCECB,0xCDD1,0xCE37,0xCD2D,
	0xCA2E,0xC948,0xCA67,0xCA73,0xCF42,0xD4EA,0xDB26,0xE200,
	0xE96C,0xF1DE,0xFB14,0x0394,0x0AB5,0x10CE,0x16A9,0x1CC1,
	0x225A,0x28AC,0x2EA0,0x338D,0x364A,0x365E,0x3592,0x350C,
	0x34BA,0x343B,0x33F5,0x340C,0x3392,0x3242,0x30ED,0x2FEB,
	0x2EEC,0x2DD4,0x2CE2,0x2C99,0x2CBC,0x2D34,0x2D7B,0x2DF1,
	0x2D8B,0x2C24,0x2978,0x26AA,0x2400,0x2128,0x1E73,0x1B98,
	0x17F6,0x1369,0x0DF3,0x07E1,0x0210,0xFC78,0xF6F1,0xF1D8,
	0xED49,0xE903,0xE566,0xE1AC,0xDE76,0xDC36,0xDABE,0xD976,
	0xD854,0xD6F8,0xD5D7,0xD74D,0xD8B0,0xDAB4,0xDD91,0xDFD5,
	0xE1C0,0xE347,0xE541,0xE7C2,0xE9F4,0xEC10,0xEE20,0xEFF3,
	0xF171,0xF264,0xF3AC,0xF64C,0xF80D,0xF885,0xFA60,0xFCC8,
	0xFEB1,0x000F,0x0259,0x0549,0x07CE,0x0A62,0x0C13,0x0E84,
	0x110C,0x1358,0x15E2,0x1718,0x1877,0x1A1B,0x1B34,0x1B1F,
	0x1B42,0x1B50,0x1B24,0x19B3,0x1850,0x17B6,0x1500,0x1275,
	0x108E,0x0DD8,0x0B99,0x094C,0x066B,0x035F,0x01E0,0x0050,
	0xFEAC,0xFD45,0xFB59,0xFA68,0xF987,0xF7A3,0xF688,0xF56E,
	0xF4C3,0xF41A,0xF24E,0xF148,0xF129,0xF127,0xF06C,0xEF5F,
	0xEECC,0xEE4D,0xED50,0xEC67,0xEC51,0xECAC,0xED28,0xECEA,
	0xED16,0xEDC3,0xEE5D,0xEF20,0xEFCD,0xF107,0xF297,0xF419,
	0xF4D5,0xF70D,0xF9E1,0xFC32,0xFD6A,0xFEFC,0x00D8,0x0236,
	0x0316,0x042E,0x0669,0x0937,0x0AC8,0x0AEB,0x0AFD,0x0B98,
	0x0C04,0x0C21,0x0BF6,0x0C7A,0x0D95,0x0D99,0x0D4B,0x0CAC,
	0x0CB3,0x0BED,0x0AF2,0x09D2,0x091E,0x0973,0x095C,0x0918,
	0x0979,0x095C,0x067A,0x06E8,0x0592,0x0336,0x02BA,0x0241,
	0x01B3,0x015D,0x009A,0xFF2B,0xFD5F,0xFB8D,0xFA0D,0xF95D,
	0xF8BD,0xF82D,0xF7A4,0xF6EB,0xF5DB,0xF4EC,0xF453,0xF41D,
	0xF43C,0xF468,0xF425,0xF408,0xF46F,0xF512,0xF58A,0xF5BF,
	0xF65E,0xF704,0xF77E,0xF793,0xF849,0xF9A6,0xFAD9,0xFBDA,
	0xFC53,0xFC63,0xFB89,0xFA33,0xF90D,0xF7ED,0xF766,0xF6C3,
	0xF554,0xF1E0,0xEC13,0xE4EA,0xDCDE,0xD699,0xD2FD,0xD0F3,
	0xCFA9,0xCE91,0xCCDC,0xCC1A,0xCB84,0xCC13,0xCE29,0xD41E,
	0xDB31,0xE0FD,0xE819,0xF050,0xF8D5,0x010E,0x088C,0x0F52,
	0x1593,0x1B1B,0x2089,0x26C1,0x2D68,0x3314,0x36D1,0x382D,
	0x37C5,0x367B,0x3515,0x344F,0x357C,0x361D,0x34C4,0x332A,
	0x327F,0x3125,0x2F6A,0x2E03,0x2CBC,0x2C31,0x2C37,0x2BF6,
	0x2C28,0x2CBF,0x2CC2,0x2BCE,0x298E,0x26C0,0x2391,0x20A3,
	0x1DD2,0x1ADC,0x17A5,0x141D,0x0F1F,0x0856,0x02CD,0xFD16,
	0xF7AD,0xF296,0xEDDA,0xE92C,0xE4E2,0xE105,0xDD99,0xDA35,
	0xD760,0xD592,0xD4B5,0xD342,0xD303,0xD41A,0xD5E0,0xD7EC,
	0xDA24,0xDBD1,0xDD51,0xDF00,0xE0B6,0xE26E,0xE526,0xE837,
	0xEB1A,0xED79,0xEEC8,0xEFEF,0xF0D2,0xF1F3,0xF36D,0xF54A,
	0xF761,0xF91F,0xFA8A,0xFCB7,0xFF05,0x0190,0x0396,0x051E,
	0x06F4,0x0927,0x0B99,0x0E68,0x11A7,0x1442,0x160F,0x1636,
	0x1678,0x16E4,0x17DA,0x184F,0x185B,0x181F,0x1732,0x1557,
	0x130A,0x1067,0x0E81,0x0CD6,0x0A25,0x07CC,0x052A,0x0313,
	0x00C2,0xFE65,0xFCB2,0xFABF,0xF869,0xF67B,0xF50A,0xF36E,
	0xF1FB,0xF3F6,0xF258,0xF089,0xF00B,0xEE3C,0xECF2,0xEC43,
	0xEC56,0xEC48,0xEC91,0xEBDD,0xEABF,0xE9FD,0xEA04,0xE9C0,
	0xE9FC,0xEA37,0xEAC3,0xEBAF,0xEB5B,0xEBD5,0xED1C,0xEECF,
	0xF030,0xF188,0xF2B5,0xF495,0xF6A5,0xF86E,0xFA93,0xFCFA,
	0xFF66,0x0130,0x02A5,0x0421,0x05D5,0x0770,0x08BA,0x09E5,
	0x0B17,0x0B6C,0x0B9C,0x0B97,0x0C02,0x0D34,0x0D3D,0x0C96,
	0x0C35,0x0BFD,0x0B77,0x0AF9,0x0A99,0x0ACE,0x0B42,0x0A90,
	0x0954,0x087A,0x07BB,0x07AD,0x068D,0x062E,0x05F4,0x04D8,
	0x02E5,0xFF85,0xFE2A,0xFE0E,0xFD55,0xFC9E,0xFB70,0xF9FB,
	0xF852,0xF71D,0xF67B,0xF629,0xF5D4,0xF4AE,0xF3F2,0xF328,
	0xF245,0xF199,0xF22C,0xF35B,0xF30F,0xF2B7,0xF2B1,0xF2EC,
	0xF36B,0xF40A,0xF4E5,0xF5F8,0xF787,0xF85B,0xF89B,0xF9C1,
	0xFA90,0xFB69,0xFBB8,0xFC69,0xFD2A,0xFE03,0xFE2F,0xFDCD,
	0xFCA0,0xFAB1,0xF99D,0xF88E,0xF745,0xF436,0xEDEA,0xE606,
	0xDE5B,0xD7C5,0xD422,0xD27C,0xD1AD,0xD0F4,0xCFC0,0xCE68,
	0xCDFF,0xCEC4,0xD1EC,0xD788,0xDDC5,0xE43D,0xEBCD,0xF34C,
	0xFB20,0x02F2,0x0ABE,0x1224,0x18D9,0x1DF4,0x22D1,0x2851,
	0x2EA3,0x33B3,0x3737,0x38E7,0x38C0,0x37A1,0x3637,0x3572,
	0x357B,0x35B2,0x353E,0x3437,0x3345,0x3270,0x3158,0x307C,
	0x2F9B,0x2E47,0x2D7D,0x2D52,0x2E4D,0x2F03,0x2F46,0x2E80,
	0x2C6A,0x2972,0x25F9,0x225D,0x1F49,0x1C95,0x1A14,0x168D,
	0x11CD,0x0C05,0x0539,0xFE20,0xF809,0xF35F,0xEF3E,0xEB3B,
	0xE796,0xE43E,0xE15C,0xDE15,0xDC05,0xDA0B,0xD896,0xD808,
	0xD90B,0xD88A,0xDAF3,0xDED4,0xE02A,0xE1CB,0xE31F,0xE400,
	0xE585,0xE781,0xEA29,0xECEE,0xEF60,0xF10E,0xF246,0xF2EA,
	0xF40D,0xF53D,0xF6DA,0xF861,0xF99C,0xFBB6,0xFDC2,0x0012,
	0x0246,0x0421,0x0667,0x0880,0x0A33,0x0B93,0x0E1B,0x1171,
	0x1492,0x1691,0x1850,0x1948,0x1922,0x1969,0x197A,0x196C,
	0x1968,0x18FA,0x18B3,0x1767,0x1529,0x12A4,0x101D,0x0D82,
	0x0AF1,0x0895,0x0627,0x0406,0x0209,0x008F,0xFED0,0xFC65,
	0xFA36,0xF865,0xF66D,0xF489,0xF3CA,0xF39C,0xF42C,0xF620,
	0xF438,0xF271,0xF0A9,0xEF5C,0xEEB6,0xEE85,0xEECB,0xEE31,
	0xED85,0xECBE,0xEB9B,0xEB45,0xEB90,0xEBC7,0xEBEC,0xEBF3,
	0xEBC4,0xEC21,0xECC9,0xEF12,0xF11B,0xF1A3,0xF20E,0xF392,
	0xF5C3,0xF736,0xF962,0xFBD1,0xFE43,0xFFAC,0x00B0,0x01F8,
	0x0374,0x04E8,0x066D,0x078B,0x083B,0x08E3,0x095A,0x0A3B,
	0x0A8C,0x0A3C,0x0AD3,0x0AFD,0x09B8,0x0880,0x0942,0x098E,
	0x09A3,0x08BC,0x07EC,0x080B,0x0768,0x0658,0x0541,0x047A,
	0x039E,0x02D2,0x0210,0x00BF,0xFFBE,0xFF13,0xFE02,0xFC8F,
	0xFB2A,0xFA1A,0xF9AC,0xF8E3,0xF828,0xF752,0xF5F9,0xF4AD,
	0xF374,0xF2F5,0xF1F0,0xF12B,0xF053,0xF049,0xF08D,0xF0D0,
	0xF0C5,0xF0B3,0xF020,0xEFE2,0xF05A,0xF108,0xF267,0xF419,
	0xF553,0xF514,0xF4DF,0xF532,0xF636,0xF75D,0xF837,0xF959,
	0xFA3C,0xFAC2,0xFA4D,0xF8CA,0xF7DA,0xF78B,0xF788,0xF65E,
	0xF42A,0xF0CA,0xEBD4,0xE5FA,0xE08E,0xDC4F,0xDA6C,0xD96E,
	0xD77A,0xD686,0xD5C7,0xD558,0xD55F,0xD6DA,0xD9E3,0xDCC7,
	0xE216,0xE864,0xECF8,0xF4E6,0xFBB0,0x01FF,0x078A,0x0CA1,
	0x1152,0x162B,0x1AAA,0x1FA0,0x2469,0x2823,0x2992,0x2A1C,
	0x2A43,0x29EB,0x29B1,0x294F,0x28D7,0x2859,0x278C,0x26B0,
	0x262C,0x260E,0x25B7,0x24DE,0x2374,0x2259,0x21E6,0x21BB,
	0x2221,0x230B,0x22F8,0x21FE,0x1FC6,0x1DCE,0x1B7C,0x193A,
	0x1704,0x1439,0x1138,0x0D7D,0x09A0,0x052B,0x00F2,0xFCEF,
	0xF8DE,0xF457,0xF03A,0xEC41,0xE93E,0xE688,0xE4AB,0xE3A4,
	0xE259,0xE0C4,0xDF53,0xDED5,0xDF1E,0xE048,0xE201,0xE3AB,
	0xE40E,0xE3F8,0xE543,0xE701,0xE8D6,0xEABB,0xECF7,0xEF06,
	0xF0CC,0xF1F6,0xF2FF,0xF413,0xF590,0xF741,0xF870,0xF947,
	0xFA14,0xFB39,0xFE19,0xFFD4,0x00F6,0x0392,0x05E7,0x06D9,
	0x07EC,0x09E7,0x0C78,0x0F16,0x1137,0x12A7,0x133B,0x13D6,
	0x14B4,0x15C8,0x165C,0x1681,0x1639,0x158C,0x13F3,0x129C,
	0x118B,0x0FE9,0x0E9C,0x0C67,0x0B02,0x08D6,0x0678,0x040B,
	0x0259,0x00EE,0xFF93,0xFE06,0xFC81,0xFAF1,0xF9EB,0xF975,
	0xF91D,0xF87B,0xF816,0xF7F5,0xF6D0,0xF616,0xF544,0xF4A7,
	0xF431,0xF3AE,0xF34B,0xF2C9,0xF299,0xF2E3,0xF2AE,0xF276,
	0xF1F4,0xF1A0,0xF1EF,0xF208,0xF244,0xF320,0xF4C9,0xF615,
	0xF6ED,0xF823,0xF95E,0xFA39,0xFAE1,0xFBF3,0xFE6B,0x00C3,
	0x0227,0x0313,0x03DF,0x055D,0x065A,0x06F0,0x07A5,0x08DB,
	0x09D0,0x09EB,0x09F8,0x0A92,0x0B0A,0x0AF4,0x0A9A,0x09E9,
	0x095F,0x097C,0x096C,0x09A0,0x09CB,0x09AE,0x095C,0x087C,
	0x0759,0x0683,0x05EE,0x0582,0x05B6,0x052A,0x046F,0x04AB,
	0x03C4,0x0153,0x01EA,0x0102,0xFEF0,0xFDDA,0xFD31,0xFCEC,
	0xFC88,0xFB2C,0xFA56,0xF922,0xF88D,0xF71B,0xF655,0xF61E,
	0xF655,0xF62C,0xF5C6,0xF59A,0xF5D8,0xF59A,0xF5CE,0xF5C4,
	0xF5E1,0xF6D5,0xF7B2,0xF880,0xF87F,0xF8DC,0xF941,0xF9C2,
	0xFAA2,0xFBB0,0xFB81,0xFB9B,0xFC08,0xFC5A,0xFC98,0xFCBA,
	0xFCDE,0xFD15,0xFD12,0xFC48,0xFA9E,0xF852,0xF6EB,0xF5B3,
	0xF4F4,0xF4C7,0xF4C9,0xF473,0xF3ED,0xF2D6,0xF22F,0xF287,
	0xF406,0xF5D4,0xF70F,0xF8EB,0xFAAF,0xFD06,0x00FB,0x0473,
	0x05C8,0x0753,0x08E5,0x09BD,0x0AD7,0x0C84,0x0EAE,0x0FF4,
	0x10AD,0x1078,0x1012,0x0EE2,0x0DEF,0x0DF1,0x0E1C,0x0D95,
	0x0D44,0x0C28,0x0BA3,0x0BFE,0x0B4B,0x099F,0x08DE,0x08FC,
	0x08B2,0x0862,0x08E0,0x0939,0x0905,0x0893,0x0769,0x06C3,
	0x05EE,0x0544,0x056F,0x0521,0x048E,0x0394,0x01BD,0xFFE7,
	0xFDDF,0xFCA2,0xFBD3,0xFA58,0xF827,0xF867,0xF828,0xF6E0,
	0xF585,0xF4C2,0xF48B,0xF488,0xF455,0xF413,0xF3A6,0xF3DA,
	0xF434,0xF4A2,0xF44F,0xF507,0xF677,0xF709,0xF754,0xF7E5,
	0xF8C9,0xF99A,0xF9FB,0xFA43,0xFAD9,0xFAC8,0xFAA6,0xFAE3,
	0xFB91,0xFCD9,0xFD35,0xFCB6,0xFC0E,0xFC5E,0xFD6D,0xFE3C,
	0xFF2D,0x0013,0x00B8,0x0036,0xFFE2,0x001F,0x00A8,0x0145,
	0x018F,0x013C,0x00EE,0x0096,0x001E,0xFF51,0xFE8D,0xFD72,
	0xFCBA,0xFC22,0xFB5B,0xFAF3,0xF8D2,0xF41A,0xEE76,0xE985,
	0xE6BF,0xE5C1,0xE5D5,0xE683,0xE6CE,0xE5AB,0xE48A,0xE2D4,
	0xE1EB,0xE229,0xE2AF,0xE2E1,0xE347,0xE38A,0xE3B4,0xE2EC,
	0xE478,0xE327,0xE352,0xE38F,0xE265,0xE1F1,0xE245,0xE296,
	0xE313,0xE325,0xE2CB,0xE269,0xE27A,0xE2E3,0xE2C4,0xE38E,
	0xE421,0xE48A,0xE4E7,0xE543,0xE53A,0xE583,0xE5F4,0xE619,
	0xE633,0xE683,0xE678,0xE70C,0xE766,0xE7A6,0xE7A7,0xE7D8,
	0xE81E,0xE8E6,0xE93C,0xE977,0xE985,0xE9BE,0xE9FD,0xE9F1,
	0xEA55,0xEB81,0xEC4B,0xECB0,0xED11,0xEDBB,0xEDE8,0xEE36,
	0xEE86,0xEEE9,0xEF82,0xEFE1,0xF065,0xF110,0xF14B,0xF1C0,
	0xF292,0xF2F4,0xF330,0xF388,0xF3D9,0xF4BC,0xF57C,0xF58C,
	0xF45B,0xF485,0xF60D,0xF6A3,0xF772,0xF7BC,0xF82C,0xF89D,
	0xF923,0xF9BF,0xF9CF,0xFA3B,0xFAED,0xFB53,0xFBBC,0xFC97,
	0xFD29,0xFD74,0xFE0B,0xFDD0,0xFE48,0xFF5B,0xFFEF,0x0057,
	0x00D5,0x0171,0x0179,0x0195,0x01CC,0x01CE,0x02C7,0x0364,
	0x03A4,0x03F1,0x0430,0x041C,0x04F1,0x052E,0x0578,0x0639,
	0x06B9,0x0719,0x06CE,0x085C,0x08E3,0x0800,0x07D6,0x0780,
	0x07B7,0x0823,0x08AC,0x0959,0x09B4,0x0A08,0x0AC1,0x0B5B,
	0x0BB3,0x0C4D,0x0DC5,0x0E18,0x0E04,0x0DD4,0x0DC5,0x0E05,
	0x0E17,0x0EA6,0x0EB3,0x0E8D,0x0EAC,0x0F43,0x0F35,0x0F3D,
	0x0F8C,0x0FA7,0x0F3B,0x0F8E,0x0FAE,0x0F9B,0x0FD0,0x1015,
	0x102A,0x1065,0x0FB9,0x0F30,0x0EDF,0x0EE8,0x0FC2,0x1055,
	0x1063,0x1086,0x108B,0x103B,0x1031,0x1059,0x1064,0x1039,
	0x0FE7,0x0F9C,0x0FD5,0x0FCC,0x0FAE,0x0FC1,0x0FAA,0x0FA7,
	0x1002,0x1000,0x103E,0x105C,0x0FF5,0x0FC0,0x0EEA,0x0EDE,
	0x0F0E,0x0F33,0x0EE6,0x0EE0,0x0F4D,0x0EB7,0x0E9A,0x0F7E,
	0x0E2E,0x0E89,0x1014,0x0E9A,0x0EBC,0x0EDD,0x0ED6,0x0E6D,
	0x0E2A,0x0DE7,0x0DEF,0x0E17,0x0E11,0x0DC8,0x0DCC,0x0DD2,
	0x0DE8,0x0D5A,0x0D22,0x0D3A,0x0D7C,0x0D20,0x0CBC,0x0C80,
	0x0C44,0x0C2E,0x0C8E,0x0CB8,0x0CB5,0x0CB5,0x0C87,0x0C66,
	0x0C56,0x0C55,0x0C4A,0x0BF6,0x0BD8,0x0BF4,0x0BAD,0x0BB0,
	0x0C03,0x0BDF,0x0C15,0x0BFE,0x0BAB,0x0BAC,0x0B5D,0x0AE6,
	0x0AC4,0x0AD5,0x0B0D,0x0AD1,0x0AF6,0x0AD2,0x0A7E,0x0A9E,
	0x0AAA,0x0A9F,0x0ACD,0x0A5D,0x0A6C,0x0ACB,0x0CB0,0x0CB6,
	0x0BC0,0x0AF9,0x0A93,0x0A92,0x0A7C,0x0A25,0x0A06,0x09F3,
	0x09B4,0x0944,0x096F,0x0932,0x095C,0x08EA,0x0889,0x08B8,
	0x0880,0x079F,0x0831,0x08F8,0x085A,0x0786,0x0741,0x0733,
	0x06CC,0x0714,0x06D3,0x0738,0x0705,0x0646,0x064D,0x06B7,
	0x0667,0x0666,0x0620,0x05F5,0x0591,0x057E,0x0528,0x04D5,
	0x04B3,0x04AC,0x048E,0x03BC,0x03C7,0x04DF,0x04DE,0x04C8,
	0x0415,0x03DD,0x03BA,0x03A7,0x037B,0x034B,0x02F4,0x0264,
	0x0251,0x01FA,0x0174,0x01D6,0x0218,0x01C1,0x0183,0x010C,
	0x00AB,0x0085,0x0099,0x00D7,0x00EA,0x011E,0x00D1,0x00DD,
	0x00AE,0x00C4,0x0113,0x014C,0x014B,0x00C6,0x00B3,0x00C8,
	0x00AE,0x0097,0xFD51,0xFD5D,0xFDE9,0xFE0F,0xFE00,0xFDD0,
	0xFE53,0xFE4D,0xFE5A,0xFE3D,0xFE5E,0xFE7A,0xFE75,0xFEBE,
	0xFEAB,0xFEDA,0xFEDD,0xFF19,0xFF39,0xFE87,0xFEDB,0xFFC0,
	0x0029,0x0081,0x0150,0x01CA,0x01E2,0x01F5,0x0267,0x02B3,
	0x035C,0x04A1,0x065F,0x079D,0x07FB,0x07DD,0x0849,0x0890,
	0x0896,0x0940,0x0955,0x0913,0x0925,0x0A8F,0x0B4B,0x0A02,
	0x098C,0x0976,0x09A4,0x0A90,0x0BCF,0x0CFA,0x0CD9,0x0CBF,
	0x0CDF,0x0E6F,0x1050,0x11FE,0x1330,0x12ED,0x12A1,0x12C0,
	0x1328,0x1489,0x15DA,0x15D5,0x15B8,0x15DF,0x1698,0x1763,
	0x1797,0x177E,0x1781,0x1798,0x17BB,0x186C,0x189E,0x18DC,
	0x1916,0x18B5,0x1875,0x18C9,0x19D6,0x1A9C,0x1A57,0x18D6,
	0x1840,0x1843,0x1832,0x188C,0x193A,0x195F,0x1835,0x1710,
	0x1793,0x17C7,0x17D9,0x1768,0x164F,0x15EB,0x164B,0x166D,
	0x167F,0x15E9,0x14C1,0x13E4,0x13B7,0x1403,0x144F,0x141E,
	0x132C,0x1293,0x1245,0x1242,0x1122,0x0EEB,0x0B59,0x06E1,
	0x0249,0xFD48,0xF42E,0xEBBC,0xE4DB,0xDE48,0xDEF6,0xE6A0,
	0xF2AC,0xFE96,0x07CC,0x0DFB,0x12A3,0x183A,0x1F01,0x24BE,
	0x282E,0x2874,0x25B3,0x2158,0x1D3B,0x1AD2,0x19DF,0x1A28,
	0x1B75,0x1E19,0x2096,0x2156,0x1F84,0x1AFD,0x147C,0x0DBF,
	0x0768,0x0210,0xFC7E,0xF4DA,0xECC7,0xE4E7,0xE036,0xDF7F,
	0xE2BF,0xE80E,0xEDDE,0xF1C9,0xF422,0xF660,0xF952,0xFC41,
	0xFDC9,0xFEBE,0xFF55,0x0038,0x0087,0x01CD,0x02FF,0x0501,
	0x074C,0x0A6D,0x0DDE,0x11F8,0x1450,0x13D1,0x1088,0x0C17,
	0x092E,0x04A3,0x0030,0xFB4C,0xF5CE,0xEFF3,0xEB00,0xE7AF,
	0xE668,0xE616,0xE68A,0xE7C2,0xE8A1,0xE95D,0xE94A,0xE8A6,
	0xE7F8,0xE7B2,0xE757,0xE75B,0xE91E,0xEC24,0xEE00,0xF014,
	0xF396,0xF6F4,0xFA28,0xFE24,0x0176,0x03AC,0x0490,0x041C,
	0x02AE,0x00BF,0xFDCF,0xFB0C,0xF807,0xF579,0xF300,0xF0CC,
	0xEF3E,0xEDA8,0xEBE7,0xEAEA,0xE9EB,0xE7E2,0xE733,0xE6A5,
	0xE45B,0xE31F,0xE20E,0xE079,0xE010,0xE133,0xE3A5,0xE53F,
	0xE67D,0xE809,0xEB3A,0xEE08,0xF034,0xF359,0xF60C,0xF7C3,
	0xF81A,0xF78C,0xF715,0xF709,0xF745,0xF6D7,0xF6AB,0xF649,
	0xF569,0xF404,0xF34B,0xF2F7,0xF278,0xF0EC,0xEF54,0xEDD0,
	0xEC4E,0xE98B,0xE6D8,0xE4FF,0xE3E4,0xE34D,0xE431,0xE536,
	0xE59C,0xE5B2,0xE61B,0xE799,0xEA5D,0xEDA1,0xF01E,0xF188,
	0xF1EE,0xF27A,0xF3B1,0xF4AE,0xF571,0xF603,0xF68D,0xF764,
	0xF7D4,0xF8C9,0xF994,0xF99A,0xF7EB,0xF6C9,0xF6A1,0xF706,
	0xF697,0xF4AF,0xF2C7,0xEFE4,0xEDB0,0xEC60,0xEC60,0xECFD,
	0xEC90,0xED4C,0xEDA4,0xEBCD,0xED33,0xEE20,0xEF4A,0xF07D,
	0xF160,0xF1B4,0xF1D8,0xF243,0xF39E,0xF4F6,0xF5B3,0xF65A,
	0xF71E,0xF92B,0xFA8D,0xFB13,0xFABF,0xFA81,0xFB15,0xFBB7,
	0xFB6C,0xFACD,0xF9D7,0xF85B,0xF6E8,0xF594,0xF4E8,0xF4F8,
	0xF49B,0xF3A8,0xF318,0xF33B,0xF35D,0xF2F1,0xF28F,0xF241,
	0xF240,0xF269,0xF2DB,0xF2EE,0xF2E4,0xF368,0xF3C4,0xF470,
	0xF5D6,0xF781,0xF78F,0xF7FE,0xF953,0xFAFD,0xFBFD,0xFB28,
	0xF82C,0xF22D,0xE923,0xDE63,0xD209,0xC39E,0xBF4A,0xBFEC,
	0xBF61,0xBE93,0xBE49,0xBF0C,0xC0A8,0xD924,0xF272,0x02D9,
	0x120C,0x22A6,0x3503,0x3E79,0x3E94,0x3E9B,0x3F1C,0x3B7B,
	0x3233,0x2E23,0x2DF7,0x31FE,0x3969,0x3EB9,0x3F3F,0x3F35,
	0x3FB0,0x3B08,0x29AC,0x18BA,0x096F,0xFB6B,0xEB43,0xD746,
	0xC383,0xBFDF,0xC04F,0xC048,0xBFED,0xC3FD,0xD22F,0xDD03,
	0xE68B,0xEEB9,0xF5A5,0xFB8A,0x0082,0x05AA,0x082D,0x0AAA,
	0x0D29,0x1051,0x1552,0x1BD5,0x2508,0x3034,0x3C6C,0x4087,
	0x4009,0x40BC,0x3EEC,0x34B4,0x28DB,0x1CBF,0x1054,0x0314,
	0xF557,0xE7E7,0xDCCF,0xD605,0xD3AD,0xD4E8,0xD832,0xDBA1,
	0xDE33,0xDEDA,0xDF1F,0xDE72,0xDCFE,0xDCDB,0xDEA1,0xE201,
	0xE6AB,0xEC48,0xF2E8,0xF9DA,0x02B1,0x0D05,0x187C,0x23E9,
	0x2C4E,0x30B0,0x3157,0x2F05,0x2B26,0x2551,0x1E5A,0x172A,
	0x1027,0x0A3C,0x0513,0xFFEF,0xFA81,0xF5A5,0xF22C,0xF0A7,
	0xEF93,0xEDC3,0xEAF4,0xE601,0xDFF7,0xDAA4,0xD6E6,0xD5CE,
	0xD784,0xD9AC,0xDD89,0xE21D,0xE8B2,0xF08B,0xF847,0x0048,
	0x08A5,0x0E5D,0x121C,0x1815,0x199C,0x1924,0x176B,0x14BD,
	0x12F9,0x126F,0x1201,0x1199,0x1019,0x0E01,0x0AC0,0x07A7,
	0x0565,0x02A0,0xFF8F,0xFAFC,0xF4EE,0xEEDD,0xE8A9,0xE3E2,
	0xE079,0xDE8B,0xDEE1,0xE11A,0xE3A1,0xE621,0xE91B,0xED11,
	0xF1AE,0xF635,0xFAC7,0xFF2D,0x0211,0x0394,0x0489,0x06B3,
	0x0914,0x0AA3,0x0C17,0x0DD7,0x104D,0x124C,0x12CA,0x1209,
	0x1136,0x0F31,0x0C61,0x096B,0x0630,0x02BD,0xFDC8,0xF7C6,
	0xF226,0xEE76,0xED05,0xECC6,0xEC58,0xEBEC,0xEB1C,0xECF2,
	0xEF08,0xF0D3,0xF321,0xF488,0xF500,0xF600,0xF7AC,0xF9AF,
	0xFC5A,0xFF4E,0x0277,0x052E,0x07C8,0x0A48,0x0D0C,0x0FC3,
	0x1110,0x10F7,0x0FBB,0x0E9A,0x0E13,0x0C80,0x094D,0x067F,
	0x0397,0xFFC0,0xFC9F,0xFB02,0xFA92,0xF9F5,0xF7EC,0xF5BC,
	0xF436,0xF309,0xF2AA,0xF284,0xF281,0xF226,0xF1FC,0xF2D2,
	0xF3CB,0xF4B7,0xF6C1,0xF96C,0xFB28,0xFD7B,0x01F5,0x0558,
	0x076C,0x08C6,0x090F,0x0828,0x051E,0xFDD2,0xF1F1,0xE285,
	0xCE9A,0xBEFC,0xBE5E,0xBDC9,0xBDA6,0xBDDF,0xBE89,0xBEA7,
	0xC178,0xDF12,0xFCAC,0x0FFB,0x20E3,0x34C1,0x3E7F,0x3DC9,
	0x3E3A,0x3E23,0x3E48,0x3E34,0x3E56,0x3C6E,0x3D83,0x3E8E,
	0x3E74,0x3E80,0x3EA1,0x3E86,0x3DE4,0x3EBB,0x37A3,0x21F7,
	0x0FA7,0xFD5E,0xE882,0xCEDF,0xBEC3,0xBF04,0xBEEF,0xBF10,
	0xBEDE,0xC187,0xD165,0xDE49,0xE81F,0xF165,0xF8C3,0xFE54,
	0x02D6,0x06C1,0x0B03,0x0F9F,0x13F3,0x18C1,0x1E17,0x25DC,
	0x315D,0x3D67,0x3F03,0x3EF6,0x3EFC,0x3ED5,0x3ED6,0x3DA8,
	0x3199,0x24F4,0x1446,0x0336,0xF2EA,0xE3F0,0xD916,0xD286,
	0xD023,0xD0A3,0xD3B4,0xD75A,0xDC5E,0xDEFD,0xDF08,0xDBE9,
	0xD826,0xD72C,0xD968,0xDE35,0xE461,0xEB57,0xF355,0xFC82,
	0x073E,0x14C9,0x22FC,0x2FD8,0x38F9,0x3DD0,0x3F40,0x3D17,
	0x373C,0x2F02,0x25EB,0x1CC4,0x1505,0x0EA6,0x098C,0x0451,
	0xFE91,0xF889,0xF44F,0xF1D2,0xF074,0xEE1C,0xEA02,0xE3EE,
	0xDC82,0xD55F,0xD06C,0xCEFD,0xD0C7,0xD4A6,0xD9B8,0xE00A,
	0xE886,0xF1E2,0xFB20,0x03CA,0x0CEF,0x15A3,0x1BFC,0x1F8B,
	0x1FB5,0x1D20,0x1B9A,0x194D,0x1761,0x167D,0x164E,0x159C,
	0x1432,0x1216,0x0FC2,0x0C56,0x07E7,0x035F,0xFEC4,0xF900,
	0xF259,0xEB3A,0xE4B4,0xDE80,0xD8CD,0xD73A,0xD8A0,0xDB12,
	0xDDF0,0xE187,0xE60C,0xEB42,0xF0EF,0xF67C,0xFADB,0xFF5F,
	0x030B,0x0588,0x079E,0x0A18,0x0CD6,0x0F28,0x10A2,0x127C,
	0x1545,0x187C,0x19ED,0x1908,0x1859,0x158D,0x107F,0x0B7E,
	0x0760,0x02E8,0xFE72,0xF870,0xF262,0xEDD7,0xEABE,0xEA1B,
	0xE9C9,0xEA51,0xEC20,0xEDE6,0xEE1C,0xEF05,0xF0AE,0xF28F,
	0xF479,0xF646,0xF887,0xFB5F,0xFEB9,0x01BA,0x0485,0x0757,
	0x0AAA,0x0E2F,0x11DB,0x1480,0x16B4,0x17DE,0x16B2,0x13AC,
	0x10F0,0x0F8A,0x0D9B,0x0A61,0x0642,0x02CC,0xFFC2,0xFC78,
	0xF979,0xF7FC,0xF7CC,0xF685,0xF4F1,0xF3B4,0xF2FC,0xF251,
	0xF134,0xF049,0xF06E,0xF193,0xF384,0xF56B,0xF72E,0xF97A,
	0xFBCB,0xFE4C,0x0141,0x050B,0x085C,0x0B25,0x0AC8,0x05D4,
	0xFC2C,0xEEC4,0xDF18,0xCB59,0xBFA2,0xC003,0xBF90,0xBFBA,
	0xC03D,0xC00D,0xBF99,0xCAE2,0xEC48,0x04E0,0x16F4,0x28DE,
	0x3C37,0x3FBA,0x3F46,0x3F90,0x3F67,0x3F47,0x3F65,0x3E40,
	0x3B0C,0x3C9A,0x3F4C,0x3F9A,0x3F95,0x3F6E,0x3F54,0x3EED,
	0x3F83,0x32D0,0x1D16,0x0C0B,0xF9EF,0xE487,0xCA6E,0xBF07,
	0xC02C,0xBF85,0xBFE4,0xBF34,0xC778,0xD83B,0xE449,0xEE9D,
	0xF6B6,0xFDBE,0x02B2,0x0610,0x08A2,0x0C03,0x1084,0x151C,
	0x1909,0x1E4C,0x269A,0x3351,0x3E5E,0x3F2C,0x3F28,0x3F42,
	0x3EE4,0x3F5E,0x3AC4,0x2BC7,0x1E5C,0x100B,0x000E,0xF15C,
	0xE341,0xD966,0xD485,0xD31F,0xD4D8,0xD838,0xDC24,0xDFB0,
	0xE1C3,0xE126,0xDE98,0xDA8A,0xD886,0xDA2A,0xDFFD,0xE73D,
	0xEE02,0xF566,0xFE3F,0x09D0,0x17B0,0x24EB,0x310F,0x3A54,
	0x3D87,0x3C1B,0x37F7,0x31AB,0x29DD,0x215F,0x189E,0x1071,
	0x0976,0x0366,0xFE25,0xF8D8,0xF509,0xF259,0xF018,0xEDA3,
	0xEA1A,0xE5CE,0xDFDF,0xD890,0xD16F,0xCDDC,0xCE1B,0xCFE3,
	0xD40E,0xD96F,0xDF82,0xE6DE,0xEFF3,0xF9A7,0x03F5,0x0C97,
	0x1361,0x17F8,0x1A5A,0x1A47,0x19E5,0x17FA,0x160D,0x1488,
	0x133E,0x1233,0x10C4,0x0F2F,0x0CE0,0x0A60,0x0830,0x04F7,
	0x0054,0xFA58,0xF397,0xEC93,0xE5B1,0xDFC6,0xDACB,0xD771,
	0xD62F,0xD6BF,0xD913,0xDCD1,0xE19C,0xE673,0xEB20,0xEFF2,
	0xF56C,0xFAB9,0xFE96,0x00E1,0x0306,0x04C3,0x060A,0x07C8,
	0x09EA,0x0D2E,0x10B2,0x1305,0x13BC,0x137E,0x12ED,0x1236,
	0x1017,0x0CEC,0x08BB,0x036C,0xFDA9,0xF72C,0xF1DE,0xEE05,
	0xEB0C,0xE8B9,0xE731,0xE689,0xE79C,0xE8F7,0xEA21,0xEA5A,
	0xECDB,0xEE72,0xEE6C,0xF1A3,0xF409,0xF5F2,0xF7C0,0xF9C8,
	0xFC64,0x0010,0x0428,0x08CE,0x0C9F,0x0F2C,0x10B4,0x122A,
	0x12BA,0x1262,0x10FD,0x0E88,0x0BFA,0x0862,0x04A9,0x014C,
	0xFE83,0xFBD6,0xF976,0xF6F0,0xF510,0xF3E6,0xF33C,0xF28E,
	0xF10F,0xEF77,0xEE26,0xEDAC,0xED8B,0xEE67,0xF029,0xF1F2,
	0xF377,0xF49D,0xF70E,0xFAE4,0xFF14,0x0255,0x0551,0x077A,
	0x0905,0x09A9,0x07CD,0x018E,0xF706,0xE913,0xD959,0xC616,
	0xBF20,0xBFD3,0xBF4F,0xBF67,0xBF99,0xC0AF,0xBF6D,0xCF69,
	0xEFC8,0x0480,0x162E,0x286B,0x3AB0,0x3EAD,0x3E6B,0x3E94,
	0x3EA4,0x3EA8,0x3EBE,0x3BFA,0x3BA9,0x3EDC,0x3F1B,0x3F0D,
	0x3F2F,0x3F23,0x3F49,0x3EBA,0x3DF5,0x2E1B,0x18DC,0x0719,
	0xF4C6,0xDE5D,0xC60F,0xBF7C,0xC047,0xBFEB,0xC05D,0xC040,
	0xCC0C,0xDC2C,0xE62E,0xEEDA,0xF718,0xFE38,0x0285,0x0543,
	0x0806,0x0C31,0x10FE,0x1667,0x1D5F,0x23AB,0x2BB0,0x38A4,
	0x400C,0x3FA9,0x401C,0x4005,0x3F6F,0x4070,0x3915,0x28AF,
	0x1B95,0x0DAD,0xFE89,0xEEB5,0xDFC1,0xD67A,0xD297,0xD2D8,
	0xD528,0xD8EE,0xDD54,0xE032,0xE0CD,0xDF6A,0xDC3C,0xD8A8,
	0xD724,0xD975,0xE08D,0xE8C4,0xF087,0xF794,0x00CD,0x0C34,
	0x19D2,0x2851,0x353D,0x3D23,0x3F2E,0x3CC0,0x3773,0x3118,
	0x29F8,0x21A3,0x1884,0x1033,0x09A5,0x04AE,0xFFDC,0xFAC9,
	0xF63B,0xF2BD,0xF066,0xEEB6,0xEBAD,0xE75A,0xE0FF,0xD8E9,
	0xD1E8,0xCEB5,0xCEEF,0xD269,0xD6D9,0xDBEA,0xE247,0xEA97,
	0xF49C,0xFF36,0x0863,0x108D,0x16F4,0x1B36,0x1DCB,0x1FDE,
	0x1EAA,0x1B79,0x1B11,0x1790,0x15A2,0x1620,0x163A,0x148F,
	0x11A1,0x0E08,0x0A3C,0x06CC,0x0256,0xFD14,0xF6BE,0xEF41,
	0xE7C8,0xE184,0xDD29,0xDAB5,0xD981,0xDA3F,0xDC1F,0xDF66,
	0xE3CE,0xE93A,0xEEDE,0xF418,0xF8C2,0xFCEE,0x004B,0x034D,
	0x0688,0x0949,0x0B2D,0x0CC4,0x0EBC,0x111F,0x13D3,0x160C,
	0x17BE,0x1811,0x172C,0x154C,0x1283,0x0F8A,0x0BCC,0x05D8,
	0xFF58,0xF99E,0xF491,0xF0AC,0xEDA0,0xEAD1,0xE8CA,0xE7E7,
	0xE84D,0xE942,0xEB35,0xECA6,0xEDCD,0xEECC,0xF25B,0xF5D7,
	0xF731,0xF967,0xFB2A,0xFDD1,0x0116,0x04E8,0x092A,0x0D13,
	0x1015,0x11CE,0x1362,0x14AE,0x1600,0x15B6,0x149A,0x11EE,
	0x0E2E,0x09AE,0x066A,0x04D5,0x01C5,0xFD70,0xFA61,0xF8E9,
	0xF74A,0xF5C7,0xF41C,0xF1ED,0xF0EF,0xF030,0xEFB2,0xF04C,
	0xF0C8,0xF0A6,0xEF8E,0xEFD2,0xF29A,0xF679,0xFA60,0xFD52,
	0xFFDC,0x0238,0x04BB,0x06ED,0x08BE,0x0AA5,0x088C,0x0002,
	0xF3D2,0xE66A,0xD5E8,0xC2F0,0xBE77,0xBEFF,0xBE6B,0xBE2C,
	0xBE8C,0xBF31,0xBF80,0xD698,0xF435,0x072C,0x1864,0x2D7C,
	0x3CD6,0x3D9E,0x3DBA,0x3DF6,0x3DE8,0x3E20,0x3CA4,0x3820,
	0x3A67,0x3E73,0x3E2D,0x3E65,0x3E5F,0x3E59,0x3DDA,0x3E50,
	0x386F,0x2407,0x1182,0x001D,0xEC3A,0xD337,0xC018,0xBEB9,
	0xBEA3,0xBEDA,0xBEEE,0xBF81,0xCBEF,0xD9E7,0xE35F,0xEBE7,
	0xF3B1,0xFA8C,0xFFD4,0x03E6,0x06B3,0x09D9,0x0E1C,0x1274,
	0x17C4,0x1EC9,0x29A0,0x385C,0x3EBE,0x3E4E,0x3EB2,0x3E4F,
	0x3E8B,0x3D0E,0x30F0,0x228D,0x13D7,0x044F,0xF371,0xE308,
	0xD805,0xCEDF,0xCC81,0xCE37,0xD0D7,0xD53A,0xD906,0xDAAB,
	0xDAAF,0xD8B3,0xD627,0xD561,0xD5CA,0xD902,0xDE79,0xE56A,
	0xEC3A,0xF4C4,0x0023,0x0DD3,0x1C7B,0x2967,0x33E3,0x398D,
	0x3B08,0x3898,0x3385,0x2D33,0x256F,0x1C5C,0x136F,0x0B7A,
	0x0513,0xFFD7,0xFB07,0xF768,0xF3AB,0xF0BB,0xEE75,0xEC58,
	0xE8A0,0xE25B,0xDAB9,0xD3C1,0xCFDE,0xCE78,0xCF0D,0xD151,
	0xD538,0xDAC8,0xE1DF,0xEA84,0xF4D1,0x0047,0x0A31,0x110F,
	0x1564,0x1990,0x1C85,0x1CE9,0x1B49,0x1925,0x1753,0x15AA,
	0x1310,0x11F7,0x1143,0x0FB5,0x0D25,0x09FE,0x06DE,0x03EF,
	0xFF6D,0xF8B8,0xF100,0xE9C2,0xE321,0xDDDD,0xDA3F,0xD806,
	0xD769,0xD8CF,0xDB4B,0xDE8C,0xE437,0xEA4A,0xEFAE,0xF498,
	0xF932,0xFDFE,0x0205,0x048D,0x05F2,0x076A,0x0A07,0x0D01,
	0x0F87,0x11B7,0x13C3,0x15D8,0x1754,0x17B4,0x172C,0x15D3,
	0x1302,0x0E95,0x0971,0x052A,0x00E9,0xFA16,0xF43F,0xEF31,
	0xEC01,0xEA26,0xE9D0,0xE9CC,0xEA9F,0xEB61,0xEBF6,0xED37,
	0xEF44,0xF1CD,0xF4B2,0xF6B4,0xF7DA,0xF8EE,0xFAE4,0xFD7A,
	0x00BF,0x05A2,0x0A28,0x0DD6,0x104B,0x1227,0x13B6,0x14A5,
	0x1561,0x14D7,0x1303,0x106D,0x0CFE,0x09B3,0x06AE,0x0385,
	0xFFED,0xFD0E,0xFA88,0xF8EE,0xF7CC,0xF686,0xF4FA,0xF2A0,
	0xF12A,0xF01E,0xEFDC,0xF083,0xF0A1,0xF0D9,0xF123,0xF277,
	0xF4E5,0xF803,0xFB17,0xFED6,0x0181,0x0496,0x079B,0x09E4,
	0x0A0D,0x06C1,0xFE8B,0xF23E,0xE34A,0xD0CC,0xC114,0xBFE3,
	0xBFDA,0xBF8F,0xBF75,0xC05A,0xC03B,0xC655,0xE617,0x01A6,
	0x1142,0x22CB,0x37F4,0x3F9A,0x3F43,0x3F9E,0x3F88,0x3F57,
	0x3FA1,0x3D0F,0x39A1,0x3CCA,0x3F97,0x3F6E,0x3F71,0x3F92,
	0x3F81,0x3EC9,0x3F67,0x3602,0x1FCF,0x0CFD,0xFB0F,0xE68A,
	0xCCF8,0xBFC0,0xBFD1,0xBF92,0xBFD0,0xBF77,0xC2DB,0xD224,
	0xDF48,0xE943,0xF261,0xF9F7,0xFF8D,0x02C2,0x059E,0x0923,
	0x0D7D,0x11BE,0x169B,0x1BE5,0x23F1,0x3004,0x3CFA,0x3F53,
	0x3EFA,0x3F59,0x3EDF,0x3F4D,0x3B02,0x2C68,0x1E51,0x0F53,
	0xFF58,0xEFAB,0xE09D,0xD509,0xCF4D,0xCF9D,0xD462,0xD6E1,
	0xD9B6,0xDCF1,0xDF08,0xDECF,0xDC2F,0xD8DE,0xD7E3,0xD9A7,
	0xDE0B,0xE41D,0xEAB2,0xF256,0xFB84,0x0691,0x135A,0x2135,
	0x2DC1,0x3662,0x3B92,0x3C1D,0x3838,0x315A,0x2962,0x2049,
	0x1854,0x11C7,0x0B1B,0x03DA,0xFCC0,0xF6DD,0xF36D,0xF11F,
	0xEF44,0xEDB4,0xEA60,0xE520,0xDEC7,0xD879,0xD373,0xCF77,
	0xCD0B,0xCD36,0xD04B,0xD556,0xDDDE,0xE68F,0xEF18,0xF7A8,
	0x002D,0x0904,0x11A0,0x187D,0x1BC8,0x1C31,0x1A24,0x16C7,
	0x1540,0x1462,0x1366,0x12CD,0x11D9,0x1073,0x0DCE,0x0AF4,
	0x0812,0x04F0,0x017D,0xFCAD,0xF622,0xEEB9,0xE7FD,0xE15C,
	0xDB81,0xD74F,0xD5D9,0xD64F,0xD879,0xDBD5,0xE0B8,0xE5D2,
	0xEA2E,0xEE46,0xF305,0xF8CE,0xFE30,0x0288,0x0500,0x0590,
	0x0676,0x0809,0x0AB9,0x0E0F,0x1141,0x1342,0x1431,0x1475,
	0x1500,0x1427,0x1203,0x0E00,0x092D,0x0483,0xFFCF,0xFACB,
	0xF4F4,0xEF5C,0xEA75,0xE77B,0xE65E,0xE6A8,0xE725,0xE7D6,
	0xE890,0xE99F,0xEB7D,0xEDE1,0xF018,0xF1BF,0xF28B,0xF5BA,
	0xF8EF,0xFA0E,0xFE05,0x00E8,0x0484,0x0856,0x0BD2,0x0E6A,
	0x1133,0x12F3,0x135D,0x12DB,0x11E9,0x1092,0x0DEC,0x0A5C,
	0x06EC,0x03C6,0x00AA,0xFDE9,0xFB34,0xF978,0xF7EE,0xF5BD,
	0xF3B5,0xF22F,0xF1A3,0xF14B,0xF0F8,0xF04D,0xF006,0xEF54,
	0xF01B,0xF1D0,0xF429,0xF6EA,0xF921,0xFB1B,0xFE83,0x024D,
	0x05E3,0x08DB,0x0A6F,0x0AA5,0x0940,0x0512,0xFC69,0xF0B7,
	0xE2FF,0xD0F1,0xC0F5,0xBFBB,0xBFC3,0xBFA6,0xBFD0,0xC0A0,
	0xBFB4,0xCE55,0xEDFF,0x0324,0x1239,0x214B,0x332A,0x3DCA,
	0x3DF0,0x3E6E,0x3E3B,0x3EDE,0x3A5E,0x3266,0x313E,0x35BE,
	0x3D38,0x3F08,0x3EDB,0x3EF1,0x3EAF,0x3EC6,0x3CC4,0x2BB5,
	0x19D2,0x0A1D,0xF868,0xE43B,0xCD7A,0xC016,0xBFDB,0xBF9A,
	0xBFF0,0xC07F,0xCCDE,0xDBDC,0xE5B4,0xEDA2,0xF488,0xF99B,
	0xFE80,0x033E,0x06EB,0x0A63,0x0D7A,0x1164,0x1666,0x1BBC,
	0x2356,0x2F94,0x3D9A,0x404C,0x3F9B,0x3FC6,0x3F81,0x3EDF,
	0x32D4,0x250A,0x1998,0x0CF1,0xFEB0,0xEFE1,0xE2F9,0xDA08,
	0xD535,0xD4FD,0xD757,0xDB31,0xDF2C,0xE12C,0xE18A,0xE017,
	0xDD3B,0xDADD,0xDA54,0xDC94,0xE117,0xE720,0xEDC3,0xF56A,
	0xFE3B,0x089A,0x1481,0x2107,0x2BE4,0x339B,0x373A,0x36B0,
	0x3258,0x2BC2,0x2480,0x1D56,0x1622,0x0F8D,0x09E9,0x0436,
	0xFF34,0xFABD,0xF7A8,0xF546,0xF36B,0xF143,0xEDBA,0xE8F9,
	0xE367,0xDDBA,0xD831,0xD492,0xD36E,0xD515,0xD838,0xDCDC,
	0xE39F,0xEB0D,0xF455,0xFCFC,0x0567,0x0D1C,0x136E,0x1758,
	0x1962,0x1911,0x18B2,0x1790,0x15C2,0x146F,0x1420,0x1319,
	0x10F8,0x1120,0x0EB6,0x0CCA,0x0AE8,0x07D1,0x0346,0xFDFE,
	0xF745,0xF03F,0xEA40,0xE51C,0xE0A3,0xDE1E,0xDCE1,0xDCC0,
	0xDDDD,0xE065,0xE479,0xE985,0xEEFD,0xF436,0xF881,0xFBD6,
	0xFEC5,0x00A9,0x0263,0x04ED,0x07E3,0x0A6C,0x0C68,0x0E09,
	0x1028,0x1205,0x1385,0x145C,0x1523,0x1430,0x1208,0x0E6B,
	0x0A17,0x0569,0x00C5,0xFBC7,0xF62A,0xF133,0xEE8F,0xED34,
	0xEC10,0xEACC,0xE9ED,0xEA93,0xEB53,0xECD1,0xEF5F,0xF1B8,
	0xF316,0xF35C,0xF3E4,0xF58E,0xF837,0xFD08,0x0078,0x0277,
	0x0601,0x09C1,0x0D33,0x0FD5,0x1089,0x10FC,0x119F,0x11D0,
	0x1158,0x0FB4,0x0D0E,0x0967,0x0538,0x018E,0xFF75,0xFD8C,
	0xFB36,0xF8F3,0xF81F,0xF719,0xF584,0xF3E6,0xF230,0xF0DE,
	0xF0C7,0xF0F2,0xF115,0xF11A,0xF143,0xF138,0xF263,0xF4D2,
	0xF883,0xFC8C,0xFF7E,0x00F7,0x026C,0x0564,0x07EC,0x09A0,
	0x0978,0x070D,0x0138,0xFAFF,0xF63F,0xEFBD,0xE60C,0xDA65,
	0xD014,0xCB3A,0xCE30,0xD80A,0xE487,0xEFF1,0xF8C3,0xFED6,
	0x03A5,0x08B0,0x0EE6,0x14A1,0x17A6,0x16E6,0x12E0,0x0EAD,
	0x0BB9,0x0B38,0x0CF5,0x0FE7,0x141F,0x194C,0x1D88,0x2010,
	0x1FA1,0x1BB4,0x15B4,0x0E60,0x07CC,0x0257,0xFC46,0xF494,
	0xEBE1,0xE3CE,0xDF9E,0xE038,0xE46A,0xEA2B,0xEFC9,0xF425,
	0xF666,0xF781,0xF8ED,0xFAB5,0xFC27,0xFC90,0xFC97,0xFD84,
	0xFEC8,0xFFB1,0x0138,0x041B,0x08E7,0x0EDB,0x14F2,0x195F,
	0x1B17,0x1AF4,0x17CE,0x13ED,0x1027,0x0C95,0x07E2,0x032A,
	0xFE51,0xF9E2,0xF67D,0xF3CC,0xF293,0xF2D4,0xF3D8,0xF732,
	0xF617,0xF602,0xF5E1,0xF39A,0xF1FD,0xF147,0xF1D5,0xF2DC,
	0xF3ED,0xF439,0xF64D,0xF972,0xFE2D,0x0260,0x0716,0x0B6F,
	0x0EA9,0x1065,0x1116,0x10F7,0x0F37,0x0CD0,0x0A4A,0x0909,
	0x0765,0x05AF,0x03BA,0x0222,0x0067,0xFED1,0xFDE9,0xFDBA,
	0xFE6E,0xFD91,0xFB9B,0xF87A,0xF539,0xF2DA,0xF140,0xF01F,
	0xF037,0xF147,0xF264,0xF31C,0xF41B,0xF6AF,0xFA81,0xFDFD,
	0x011D,0x0401,0x0626,0x06B8,0x0658,0x0534,0x04F2,0x05FB,
	0x066D,0x0634,0x05F8,0x0665,0x05DC,0x04D2,0x03C8,0x01A4,
	0x0159,0x00F8,0x0038,0xFECA,0xFCAD,0xFA9E,0xF8B3,0xF6A5,
	0xF572,0xF471,0xF401,0xF31F,0xF1D3,0xF09B,0xEFED,0xEF24,
	0xEF83,0xF122,0xF212,0xF429,0xF512,0xF488,0xF3BE,0xF3CE,
	0xF4D4,0xF613,0xF73B,0xF805,0xF7B3,0xF820,0xF831,0xF821,
	0xF840,0xF7EB,0xF710,0xF68F,0xF5EE,0xF565,0xF4A7,0xF3F9,
	0xF303,0xF26F,0xF25A,0xF197,0xF031,0xEEEA,0xEE35,0xED4D,
	0xECF8,0xECCF,0xEC6D,0xEC06,0xEBB0,0xEBEF,0xEC0D,0xEBA2,
	0xEB36,0xEBF2,0xEBA3,0xEB5D,0xEB1D,0xEAE6,0xEADD,0xEADC,
	0xEACF,0xEAA5,0xEA31,0xE9F4,0xE9C5,0xE9B7,0xE959,0xE8D6,
	0xE8EF,0xE927,0xE8DF,0xE8C2,0xE868,0xE835,0xE839,0xE861,
	0xE88E,0xE899,0xE890,0xE8D2,0xE8D3,0xE917,0xE940,0xE9D9,
	0xEA2D,0xEA36,0xEA95,0xEAFE,0xEB6A,0xEBD9,0xEC53,0xECA7,
	0xED19,0xED36,0xED64,0xEDF9,0xEEA2,0xEEDC,0xEF19,0xEF53,
	0xEFDB,0xF048,0xF0A0,0xF0DB,0xF10E,0xF141,0xF1A1,0xF1E9,
	0xF222,0xF251,0xF31E,0xF3A5,0xF425,0xF499,0xF5A2,0xF3C8,
	0xF4CB,0xF6B2,0xF603,0xF699,0xF73B,0xF7CA,0xF803,0xF854,
	0xF8C6,0xF8E6,0xF925,0xF9F6,0xFAA0,0xFB3E,0xFBEC,0xFC39,
	0xFC69,0xFC71,0xFCB7,0xFD8E,0xFE23,0xFEDF,0xFED1,0xFF26,
	0xFF87,0xFFAA,0x0033,0x0057,0x010B,0x0163,0x01BB,0x01CA,
	0x01D5,0x025D,0x0235,0x021A,0x02B5,0x0330,0x0331,0x0360,
	0x03BE,0x03EF,0x0421,0x0441,0x04EB,0x05C7,0x05F8,0x0638,
	0x06B0,0x06EA,0x0742,0x0751,0x0799,0x07E8,0x086D,0x08A4,
	0x0939,0x0943,0x0987,0x09C1,0x0AD5,0x0D41,0x0CDA,0x0C6B,
	0x0C97,0x0C97,0x0C88,0x0C75,0x0CA4,0x0C97,0x0CE7,0x0D14,
	0x0D15,0x0D09,0x0CBD,0x0CDE,0x0CAC,0x0CAF,0x0D28,0x0D40,
	0x0C8E,0x0CE0,0x0DD5,0x0D64,0x0CB0,0x0D1C,0x0D96,0x0DC4,
	0x0DFD,0x0DA6,0x0D9E,0x0D34,0x0CE2,0x0CDB,0x0D76,0x0DE6,
	0x0E46,0x0DD0,0x0D7E,0x0D3C,0x0D2B,0x0D23,0x0D9D,0x0D5A,
	0x0D7B,0x0D10,0x0C09,0x0C19,0x0D5A,0x0DF0,0x0DC7,0x0E1D,
	0x0E33,0x0DC7,0x0D8F,0x0D5B,0x0D09,0x0C8E,0x0C16,0x0C7C,
	0x0C53,0x0BCE,0x0C13,0x0BC2,0x0BB6,0x0BCC,0x0BDD,0x0BEC,
	0x0B89,0x0B30,0x0AB5,0x0B5F,0x0BC4,0x0BA9,0x0BA2,0x0C45,
	0x0C5C,0x0BF9,0x0BA2,0x0B1C,0x0AB0,0x0AB7,0x0ABE,0x0AC5,
	0x0B29,0x0AEF,0x0A6B,0x0A42,0x0A64,0x0AA6,0x0AFC,0x0AD8,
	0x0B02,0x0A83,0x0A34,0x0A44,0x0A1D,0x09FE,0x09FC,0x09B8,
	0x0A48,0x0A96,0x0A23,0x09E2,0x09D4,0x09BA,0x09F9,0x0A0D,
	0x09F4,0x0964,0x0970,0x0928,0x095C,0x0973,0x094C,0x096D,
	0x09A9,0x097A,0x0996,0x0967,0x0960,0x082F,0x092F,0x094D,
	0x07DC,0x0930,0x08EE,0x08AC,0x08C0,0x08DF,0x08E7,0x08F3,
	0x0918,0x0945,0x08D2,0x085A,0x08BB,0x0888,0x0834,0x082B,
	0x082E,0x080E,0x0809,0x07E2,0x0852,0x0829,0x07C0,0x07DA,
	0x0770,0x0769,0x07BA,0x07D9,0x07D8,0x072B,0x071E,0x0720,
	0x06EE,0x0715,0x0705,0x06E9,0x0700,0x066D,0x0640,0x0651,
	0x0689,0x0668,0x0600,0x0626,0x0627,0x05FD,0x061B,0x05E9,
	0x0577,0x05A8,0x05C6,0x056C,0x058C,0x0592,0x057A,0x0549,
	0x0535,0x0553,0x056C,0x056B,0x0587,0x0519,0x03B8,0x02AD,
	0x0314,0x031B,0x031A,0x032C,0x0366,0x039A,0x0315,0x02E0,
	0x02F7,0x0324,0x030C,0x02FC,0x0309,0x0361,0x032C,0x0321,
	0x037B,0x0301,0x0341,0x0403,0x03B8,0x033F,0x0339,0x02E2,
	0x030C,0x0349,0x0387,0x0381,0x0330,0x0362,0x035F,0x0364,
	0x0386,0x0395,0x0399,0x03A1,0x02BF,0x02D8,0x02E5,0x02E3,
	0x0304,0x030F,0x0442,0x03A5,0x026B,0x01EF,0x0225,0x0255,
	0x028B,0x0269,0x0281,0x023E,0x02CA,0x0372,0x03C6,0x0399,
	0x03FA,0x041C,0x03A7,0x03B8,0x035F,0x0354,0x02FD,0x02FC,
	0x02F2,0x0316,0x0354,0x031D,0x0272,0x01F0,0x01FA,0x01E3,
	0x021E,0x0267,0x026A,0x026B,0x01B4,0x01FB,0x0233,0x01F7,
	0x0221,0x01BD,0x0195,0x016B,0x0169,0x01C7,0x01E3,0x01A4,
	0x01CF,0x022E,0x0221,0x01C1,0x0123,0x00CF,0x00DD,0x00BF,
	0x0098,0x00C3,0x009C,0x0080,0xFFB0,0xFF93,0xFF61,0xFF5D,
	0xFF2F,0xFF32,0xFF01,0xFF39,0xFED4,0xFF37,0xFF8F,0xFF60,
	0xFF86,0xFF6A,0xFF7A,0xFF3F,0xFF4E,0xFF3E,0xFEE9,0xFF3B,
	0xFFEF,0xFFF7,0x0047,0x0051,0x00A7,0x0084,0x00B0,0x0147,
	0x01F0,0x0328,0x0437,0x0444,0x03B1,0x02BE,0x035B,0x04D0,
	0x058F,0x0607,0x065C,0x0666,0x0602,0x0645,0x06A6,0x0742,
	0x07ED,0x07D2,0x0802,0x087A,0x08E4,0x0909,0x098B,0x0BA6,
	0x0C14,0x0C60,0x0CA3,0x0D39,0x0E16,0x0EAC,0x0E80,0x0E58,
	0x0F51,0x10D8,0x11BF,0x129E,0x12A8,0x132B,0x12F8,0x12CF,
	0x1386,0x147F,0x1474,0x14A1,0x149A,0x1483,0x14E6,0x15D2,
	0x1578,0x157B,0x1620,0x166D,0x1698,0x162C,0x161B,0x1652,
	0x15FD,0x1554,0x15F4,0x167C,0x16C2,0x15F0,0x155E,0x1581,
	0x1613,0x15AA,0x155C,0x1517,0x1424,0x14A8,0x14EC,0x1415,
	0x137C,0x13C9,0x13B2,0x1329,0x12DC,0x12CB,0x122E,0x1035,
	0x0ED2,0x0F53,0x103B,0x0FA7,0x0F1E,0x0EEB,0x0ED4,0x0E3A,
	0x0D6A,0x0CA4,0x0CB0,0x0D52,0x0D9F,0x0CFF,0x0BF6,0x0ADD,
	0x0A00,0x09D3,0x0A5E,0x0ACD,0x0A09,0x08D7,0x0847,0x07E4,
	0x07D3,0x0755,0x0651,0x05CF,0x053C,0x052E,0x052B,0x04B2,
	0x03F8,0x0321,0x01DF,0x0193,0x023E,0x0293,0x024A,0x014B,
	0x00E6,0x00B5,0x004A,0x0008,0xFFDF,0xFF7D,0xFEF3,0xFEAA,
	0xFE4E,0xFE18,0xFDED,0xFD01,0xFB2F,0xFAC0,0xFBD9,0xFC76,
	0xFC2E,0xFBBA,0xFB1C,0xFA22,0xF9F2,0xF9FE,0xFA28,0xF924,
	0xF9D8,0xF9A9,0xF6D9,0xF587,0xF1A9,0xED7C,0xE90E,0xE47F,
	0xDD82,0xD4B2,0xCA51,0xC36C,0xC26D,0xC865,0xD394,0xE10D,
	0xEE4C,0xF8C4,0x01A9,0x0AD0,0x1621,0x21E4,0x2AAD,0x2D65,
	0x2B3E,0x265A,0x1E98,0x159E,0x0C78,0x0422,0xFE36,0xF976,
	0xF604,0xF3B2,0xF1AC,0xEF52,0xEBE6,0xE90B,0xE824,0xE979,
	0xEA43,0xE8A2,0xE3B1,0xDD32,0xD7A4,0xD4E8,0xD5BE,0xD9A2,
	0xDF3C,0xE4F2,0xEA18,0xEFB8,0xF6E2,0xFF0A,0x06F4,0x0E34,
	0x1454,0x17DD,0x18F5,0x1693,0x1187,0x0A84,0x0411,0xFE50,
	0xF7F7,0xF209,0xEE8E,0xE9C7,0xE4E3,0xE173,0xDFE4,0xE07C,
	0xE1BA,0xE345,0xE400,0xE39A,0xE224,0xE047,0xDEAD,0xDEBC,
	0xDFED,0xE1E4,0xE4E3,0xE7B4,0xEAAC,0xEE79,0xF254,0xF6CB,
	0xFC5F,0x0272,0x0754,0x0A80,0x0B76,0x0A29,0x0794,0x042C,
	0x0058,0xFC20,0xF7C2,0xF3D6,0xEFD1,0xEBB4,0xE714,0xE3DC,
	0xE1C9,0xE18C,0xE294,0xE418,0xE6B5,0xE6B3,0xE64D,0xE5C4,
	0xE5FE,0xE7CD,0xE9CA,0xEBA1,0xED32,0xEF91,0xF25B,0xF47C,
	0xF68D,0xF942,0xFD85,0x0185,0x03A3,0x0589,0x06FF,0x070F,
	0x053D,0x01F4,0xFF52,0xFDCC,0xFB8E,0xF7C1,0xF358,0xEFB4,
	0xEC3F,0xE9AE,0xE7C0,0xE79C,0xE908,0xEA11,0xEA36,0xEA39,
	0xEB7D,0xEDE4,0xEF41,0xF064,0xF20C,0xF40C,0xF58C,0xF690,
	0xF72E,0xF845,0xF9D7,0xFBD5,0xFD8D,0xFF54,0x00C2,0x0118,
	0x00EE,0x0128,0x0163,0x0137,0xFFA2,0xFD11,0xFA6E,0xF7FA,
	0xF569,0xF2F2,0xF089,0xEF37,0xEDF6,0xED2B,0xECA9,0xED37,
	0xEDE1,0xEE94,0xEEDC,0xF064,0xF304,0xF4F4,0xF6A7,0xF860,
	0xF872,0xF837,0xFB5F,0xFBFB,0xFC7A,0xFDDB,0xFE13,0xFD7B,
	0xFD8C,0xFE60,0xFF15,0xFF2D,0xFEBA,0xFDCE,0xFC69,0xFAEB,
	0xF93E,0xF7D0,0xF669,0xF4FD,0xF359,0xF219,0xF14C,0xF171,
	0xF139,0xF0CD,0xF0FD,0xF1CC,0xF389,0xF577,0xF6F7,0xF8B0,
	0xF9A0,0xFA34,0xFADA,0xFB69,0xFCED,0xFE66,0xFF6B,0xFF8F,
	0xFED8,0xFE60,0xFE5D,0xFE9E,0xFF4D,0xFF6A,0xFF23,0xFEA0,
	0xFD83,0xFC3A,0xFB8B,0xFB1A,0xFA1C,0xF8B7,0xF768,0xF69E,
	0xF642,0xF614,0xF5F1,0xF56C,0xF582,0xF531,0xF5B7,0xF1A8,
	0xE81A,0xDCFA,0xD1EE,0xC554,0xBFC0,0xC004,0xBFB6,0xBFC5,
	0xC02F,0xC0E0,0xBFC7,0xD32A,0xF5AB,0x0E8C,0x283E,0x3D7B,
	0x3F8A,0x3F11,0x3F4B,0x3FD2,0x3F9C,0x3F0D,0x3EC9,0x3F5F,
	0x3A28,0x25E0,0x13F4,0x0860,0x017A,0xFC80,0xF679,0xEE6B,
	0xE5CC,0xE1A2,0xE3A9,0xE7AA,0xE7FF,0xE138,0xD2F5,0xC2E4,
	0xBEDF,0xBF8D,0xBF1A,0xC2AB,0xCF68,0xDE06,0xEE33,0x0169,
	0x175C,0x2EC9,0x3E1E,0x3EB9,0x3EDB,0x3F04,0x3EE4,0x3E4B,
	0x3DD9,0x3D55,0x2D60,0x1BC2,0x0EC1,0x026F,0xF55F,0xE7F7,
	0xDC48,0xD48A,0xD256,0xD4B7,0xD8F8,0xDC1B,0xDBED,0xD9E9,
	0xD707,0xD4A8,0xD3D4,0xD487,0xD675,0xDA4E,0xE092,0xE8E7,
	0xF3CF,0xFF71,0x0BBB,0x18D3,0x2669,0x341A,0x3D84,0x3E5F,
	0x3E16,0x3EB5,0x3A6D,0x2F94,0x24C0,0x1885,0x0B20,0xFD4F,
	0xEF64,0xE3B3,0xDB77,0xD66C,0xD3AC,0xD2C3,0xD2CD,0xD49F,
	0xD7A3,0xDB7B,0xDEA0,0xE08E,0xE36C,0xE5C5,0xE93A,0xECD6,
	0xF167,0xF6E4,0xFCAA,0x02DA,0x09F2,0x12D8,0x1B3A,0x2228,
	0x292B,0x2A61,0x2BA1,0x2BDC,0x28E5,0x23A7,0x1B4A,0x1173,
	0x0656,0xFBF9,0xF2C8,0xEAAB,0xE371,0xDD6C,0xD8D1,0xD733,
	0xD820,0xDA8D,0xDE30,0xE174,0xE4AD,0xE8CD,0xEDFB,0xF256,
	0xF610,0xF9CF,0xFD04,0xFFA2,0x02CD,0x06E6,0x0BBC,0x105D,
	0x1410,0x1702,0x1937,0x1B1B,0x1C64,0x1C3F,0x1A62,0x16F9,
	0x1176,0x0AFF,0x0458,0xFD86,0xF6AF,0xEFE7,0xE9D4,0xE595,
	0xE274,0xE0D0,0xE018,0xE0B3,0xE340,0xE6E6,0xEACF,0xEF3E,
	0xF38A,0xF79A,0xFB71,0xFF88,0x02BA,0x056E,0x07F0,0x09C7,
	0x0A8F,0x0C94,0x0EA9,0x0F75,0x0FE5,0x106A,0x10C3,0x1116,
	0x1073,0x0DEB,0x09C8,0x04EA,0x00B4,0xFC8E,0xF894,0xF489,
	0xF097,0xED26,0xEA7F,0xE746,0xE667,0xE800,0xEA19,0xED68,
	0xF154,0xF4C3,0xF78A,0xFB37,0xFF1A,0x02C4,0x05E0,0x08BA,
	0x0BE9,0x0DA0,0x0DD8,0x0E0E,0x0EA6,0x0EB8,0x0E07,0x0D70,
	0x0D92,0x0D85,0x0C61,0x09F9,0x075F,0x035D,0x001B,0xFCCE,
	0xFAA0,0xF990,0xF762,0xF42E,0xF087,0xEEE8,0xEF58,0xF10C,
	0xF21A,0xF111,0xECC2,0xE3D6,0xD96A,0xCFD9,0xC4F9,0xC06B,
	0xC0B6,0xC07D,0xC079,0xC167,0xC0A0,0xC82F,0xEA65,0x08EF,
	0x21E1,0x3957,0x406F,0x3FF7,0x4079,0x4069,0x4073,0x402D,
	0x3FFC,0x3F82,0x4021,0x33EC,0x1D20,0x0CE1,0x015D,0xFA83,
	0xF58E,0xEFE0,0xE8DB,0xE334,0xE199,0xE468,0xE840,0xE80F,
	0xE021,0xD28C,0xC530,0xC039,0xC04D,0xC2FE,0xCE42,0xDC6A,
	0xEC0C,0xFCDD,0x1067,0x2608,0x3A05,0x4004,0x3FAD,0x3FF9,
	0x3FE8,0x3FD9,0x3F3F,0x3FD2,0x3C41,0x2911,0x17AF,0x0A10,
	0xFC35,0xF150,0xE6AD,0xDAE9,0xD416,0xD2C9,0xD617,0xDBA3,
	0xDF9F,0xE068,0xDECA,0xDBFC,0xDA4D,0xDA94,0xDC35,0xDE83,
	0xE365,0xEB5D,0xF4E8,0xFFAC,0x0A4A,0x1572,0x20E0,0x2D95,
	0x3AB0,0x3F72,0x3F28,0x3F30,0x3F3C,0x36F0,0x2A93,0x1F01,
	0x13A8,0x07F0,0xFAF7,0xECCF,0xE0D5,0xD844,0xD3A0,0xD279,
	0xD352,0xD5FF,0xDA27,0xDE0A,0xE10F,0xE3B3,0xE5F3,0xE867,
	0xEB57,0xEFD5,0xF4FB,0xFAA0,0xFF54,0x03ED,0x08CF,0x0F03,
	0x16D5,0x1EDF,0x2655,0x2C84,0x2FDC,0x3035,0x2EC8,0x28B1,
	0x216D,0x1996,0x113E,0x0737,0xFCAE,0xF245,0xE89E,0xE0E8,
	0xDBF5,0xDA23,0xDAAA,0xDC30,0xDE8E,0xE1A3,0xE668,0xEAE6,
	0xEEA2,0xF253,0xF707,0xFC1C,0xFF9F,0x02BC,0x06C4,0x09ED,
	0x0C2D,0x0E4A,0x1128,0x157E,0x19D5,0x1CE6,0x1DAF,0x1CAB,
	0x1A2B,0x16EB,0x12D3,0x0E48,0x0902,0x0334,0xFBFA,0xF3BE,
	0xECB5,0xE754,0xE354,0xE020,0xDFC2,0xE216,0xE4C8,0xE707,
	0xE984,0xED13,0xF21A,0xF793,0xFBFC,0xFFA9,0x0308,0x05FE,
	0x08AF,0x0AB0,0x0B87,0x0D49,0x0EB9,0x0FE6,0x113C,0x12DE,
	0x1397,0x1216,0x0F3C,0x0C30,0x0A13,0x079A,0x0401,0xFFA7,
	0xFB18,0xF62B,0xF16E,0xED48,0xE9E7,0xE7FE,0xE6D2,0xE775,
	0xE993,0xEB98,0xEE44,0xF162,0xF444,0xF7C4,0xFC2B,0x0093,
	0x0487,0x0777,0x092D,0x0A33,0x0B1E,0x0BB7,0x0CA0,0x0D73,
	0x0DCE,0x0DA6,0x0D3E,0x0BA1,0x093E,0x06DC,0x045D,0x0229,
	0xFF2E,0xFCB9,0xFA6D,0xF7AD,0xF444,0xF0F1,0xEE48,0xECA8,
	0xECE8,0xEE47,0xEFD7,0xF10C,0xF0B3,0xED55,0xE629,0xDF6E,
	0xD7AE,0xCD42,0xC291,0xBEAD,0xBF2F,0xBEEC,0xBF00,0xBFED,
	0xBF02,0xCC21,0xEFE4,0x0ADD,0x22EB,0x3959,0x3F17,0x3EDA,
	0x3F4D,0x3F2F,0x3F46,0x3F1F,0x3EDA,0x3EE8,0x3D31,0x28F1,
	0x1461,0x0672,0xFD97,0xF895,0xF45A,0xED70,0xE5DA,0xE119,
	0xE203,0xE6E5,0xEB89,0xEA22,0xDFE3,0xD039,0xC20B,0xBFDD,
	0xBFC6,0xC47D,0xD129,0xDF94,0xEE57,0xFF53,0x1299,0x27B8,
	0x3AEF,0x3FBA,0x3F6D,0x3FD3,0x3FAC,0x3F85,0x3F02,0x3F95,
	0x3552,0x21D5,0x1327,0x05DB,0xF95B,0xECBB,0xE06F,0xD5AE,
	0xCFB7,0xD0CA,0xD5D8,0xDBB7,0xDF01,0xDEFF,0xDCCD,0xDA40,
	0xD8C3,0xD861,0xD9B0,0xDDDA,0xE3FC,0xEBEC,0xF4BA,0xFE56,
	0x08A1,0x1531,0x214D,0x2DD8,0x3ADE,0x3F74,0x3F12,0x3F7B,
	0x3C92,0x3203,0x2707,0x1B2B,0x0E8A,0x023A,0xF593,0xE920,
	0xDE31,0xD6B4,0xD304,0xD2B8,0xD4BB,0xD873,0xDC3D,0xE02D,
	0xE341,0xE533,0xE700,0xEAF2,0xEDE0,0xF132,0xF56E,0xF9C2,
	0xFE4A,0x0309,0x08E4,0x0FC8,0x1780,0x1FA3,0x27AC,0x2CC8,
	0x2EAD,0x2DF9,0x2AC4,0x253E,0x1D58,0x14F7,0x0D06,0x0444,
	0xFA11,0xEF97,0xE5B6,0xDF7F,0xDBFC,0xDA84,0xDB34,0xDDBC,
	0xE0DE,0xE46F,0xE81F,0xEC03,0xF059,0xF496,0xF91A,0xFDC5,
	0x022E,0x0579,0x0843,0x0A43,0x0D08,0x10DD,0x14A2,0x18D3,
	0x1CB7,0x1F4B,0x2006,0x1EA3,0x1C8F,0x19CF,0x1562,0x1005,
	0x0A67,0x0352,0xFB64,0xF459,0xEE61,0xEA17,0xE6B8,0xE4C8,
	0xE4A8,0xE5C1,0xE805,0xEA36,0xED6C,0xF1A4,0xF6E2,0xFB06,
	0xFF3C,0x0251,0x056C,0x0846,0x0A83,0x0C51,0x0F13,0x10CB,
	0x10E4,0x1345,0x1320,0x1354,0x1404,0x135C,0x11C5,0x0F44,
	0x0BDD,0x0851,0x03C5,0xFF78,0xFB8F,0xF715,0xF21A,0xEDD7,
	0xEB3C,0xEA47,0xEA16,0xEA37,0xEB38,0xEDBA,0xF104,0xF450,
	0xF7E1,0xFBC8,0xFF51,0x025D,0x0540,0x081E,0x0AB4,0x0BC5,
	0x0C15,0x0C7D,0x0D20,0x0D93,0x0D35,0x0C76,0x0BFB,0x0ADC,
	0x08C2,0x06C5,0x0570,0x03E2,0x015F,0xFD8E,0xF98F,0xF696,
	0xF4AA,0xF2C7,0xF136,0xEFFF,0xEF8A,0xEF0A,0xEF44,0xF0FC,
	0xF163,0xEE3B,0xE70A,0xDDB0,0xD4C2,0xCC7F,0xC266,0xBFE3,
	0xC007,0xBFE2,0xC005,0xC0EF,0xBFDF,0xD4C3,0xF906,0x11FA,
	0x29EC,0x3D5E,0x3FA2,0x3F8B,0x3FF8,0x3FB8,0x3F97,0x3F8D,
	0x3EF7,0x3F19,0x3B2B,0x25B0,0x10D4,0x038A,0xFCB1,0xF8C5,
	0xF44A,0xED4D,0xE59D,0xE1A4,0xE37D,0xE862,0xEBC9,0xE7F0,
	0xDC2F,0xCC66,0xC0AE,0xBF91,0xBFA9,0xC7BD,0xD426,0xE0D2,
	0xF0C6,0x03AE,0x175A,0x2D32,0x3D6A,0x3F13,0x3F06,0x3F38,
	0x3F14,0x3EE5,0x3E96,0x3E05,0x2F2B,0x1B87,0x0CEC,0xFF81,
	0xF2FE,0xE67D,0xDB7E,0xD3E2,0xD0FD,0xD2B9,0xD6BC,0xDAC1,
	0xDCC0,0xDC3F,0xDABE,0xD9B5,0xD8D2,0xD80C,0xD90B,0xDCA8,
	0xE2AB,0xEAC4,0xF4E8,0xFF89,0x0B4B,0x17A9,0x243B,0x3065,
	0x3ABA,0x3E6F,0x3DE4,0x3E81,0x3991,0x2E23,0x231A,0x1603,
	0x086C,0xFBB9,0xEFBA,0xE4FF,0xDB6B,0xD4B8,0xD129,0xD0D3,
	0xD2D4,0xD644,0xDA1A,0xDD9A,0xE0EB,0xE39D,0xE657,0xE924,
	0xEBB0,0xEEAD,0xF2B9,0xF87B,0xFE7E,0x04BA,0x0ACD,0x1142,
	0x186F,0x1F9F,0x2591,0x2A13,0x2C15,0x2A8C,0x2675,0x21F3,
	0x1812,0x0F6E,0x06D1,0xFCCD,0xF2F6,0xEA80,0xE31A,0xDD72,
	0xD9B9,0xD7A4,0xD81E,0xDB22,0xDF48,0xE376,0xE7D2,0xEB33,
	0xEE89,0xF199,0xF5BE,0xFAA1,0xFE7E,0x0219,0x0553,0x0828,
	0x0B47,0x0EF3,0x12EB,0x16A6,0x1963,0x1ADD,0x1B5D,0x1AF4,
	0x1948,0x1605,0x10DC,0x0A1F,0x02DC,0xFC6C,0xF63A,0xF05F,
	0xEB19,0xE676,0xE2D1,0xE062,0xE081,0xE320,0xE6FE,0xEA66,
	0xEDD4,0xF161,0xF546,0xF907,0xFCD0,0x00BD,0x04E3,0x07CE,
	0x092B,0x0A8B,0x0C3B,0x0E38,0x0F8C,0x10D9,0x10D0,0x0FAD,
	0x0FCC,0x0F27,0x0D68,0x0B58,0x080A,0x03A3,0xFF47,0xFB48,
	0xF77C,0xF2F3,0xEEB2,0xEA9B,0xE7C5,0xE695,0xE72A,0xE92E,
	0xEB96,0xEDF3,0xEF86,0xF2A4,0xF6DD,0xFAA3,0xFE21,0x01AF,
	0x049F,0x0721,0x0948,0x0ACD,0x0B9D,0x0B61,0x0AF8,0x0BA0,
	0x0C6D,0x0D00,0x0C8C,0x0AFE,0x08B0,0x061E,0x03C1,0x01C0,
	0xFFB2,0xFC87,0xFB29,0xF8AF,0xF4E6,0xF1BD,0xEF84,0xEEA9,
	0xEF23,0xF05C,0xF167,0xF109,0xEC06,0xE346,0xDA7B,0xD1A9,
	0xC67B,0xC0BE,0xC106,0xC06E,0xC083,0xC11A,0xC1A2,0xC306,
	0xE08C,0x01AA,0x1AB6,0x33C0,0x402A,0x4026,0x4091,0x4084,
	0x407D,0x406C,0x4058,0x3F98,0x4076,0x37FC,0x215D,0x0FD7,
	0x039F,0xFBAC,0xF68F,0xF124,0xEA3B,0xE420,0xE183,0xE34B,
	0xE759,0xE7D9,0xE1C2,0xD5A7,0xC721,0xC034,0xC0A3,0xC10F,
	0xCA5A,0xD872,0xE753,0xF7D0,0x0A9E,0x1F78,0x35FD,0x3FE7,
	0x3FB0,0x3FF9,0x401F,0x4003,0x3F93,0x3FA0,0x3D9C,0x2B13,
	0x1837,0x09D6,0xFE08,0xF244,0xE5B0,0xDAB5,0xD3E0,0xD050,
	0xD3A2,0xD9F1,0xDC9C,0xDD98,0xDC7D,0xDB23,0xDA99,0xDA36,
	0xD9EC,0xDBB6,0xE021,0xE755,0xF120,0xFC9C,0x0803,0x12C3,
	0x1D2F,0x2852,0x35CB,0x3ED4,0x3F30,0x3F30,0x3F64,0x3844,
	0x2B4A,0x1FEC,0x148E,0x08FB,0xFBEE,0xEE33,0xE22B,0xD8CF,
	0xD378,0xD12C,0xD18C,0xD3B0,0xD6F3,0xDA9D,0xDEBC,0xE240,
	0xE461,0xE546,0xE743,0xEB09,0xF06E,0xF6C2,0xFCC5,0x01C7,
	0x059D,0x0A84,0x113B,0x1A28,0x233D,0x2A01,0x2CEF,0x2BCA,
	0x283F,0x23AF,0x1D6A,0x1617,0x0E3F,0x0692,0xFC9B,0xF284,
	0xE951,0xE24F,0xDD24,0xD91E,0xD7B6,0xD948,0xDCFA,0xE1DB,
	0xE5C8,0xE914,0xEC12,0xEF93,0xF3CE,0xF8AE,0xFD6E,0x017C,
	0x0481,0x07EC,0x0B61,0x0DAB,0x1036,0x1507,0x1926,0x1B58,
	0x1CEC,0x1D12,0x1B83,0x1805,0x135A,0x0E0E,0x08A1,0x024E,
	0xFBBF,0xF48E,0xEDB8,0xE7A5,0xE26B,0xDF56,0xDEE1,0xE07A,
	0xE2F5,0xE4E7,0xE64A,0xE9E3,0xEF90,0xF41A,0xF8A6,0xFCBC,
	0x009B,0x040B,0x06A4,0x089A,0x09DB,0x0ACD,0x0C07,0x0DFE,
	0x0FB4,0x107B,0x10AD,0x0FDE,0x0DDD,0x0B59,0x0871,0x061A,
	0x02E3,0xFE6C,0xF97C,0xF412,0xEF40,0xEB8D,0xE8BD,0xE702,
	0xE67C,0xE721,0xE79C,0xE84B,0xEA6A,0xEDF9,0xF223,0xF700,
	0xFB35,0xFE5A,0x00E2,0x0372,0x068D,0x08CB,0x0A1D,0x0B09,
	0x0B98,0x0C53,0x0C78,0x0BFD,0x0AD9,0x09DF,0x0814,0x05AC,
	0x03B9,0x023A,0x001A,0xFD17,0xF944,0xF5E4,0xF384,0xF155,
	0xEF1A,0xED06,0xECE2,0xEE11,0xEF09,0xEF18,0xEE63,0xECE6,
	0xE930,0xE18F,0xD8F0,0xD01B,0xC41A,0xBE46,0xBF3C,0xBF52,
	0xBE7A,0xBFED,0xBF51,0xC545,0xE82F,0x06A9,0x1E88,0x3614,
	0x3EF7,0x3EDF,0x3F31,0x3F3E,0x3F1B,0x3EFA,0x3EC5,0x3E95,
	0x3E00,0x2CE8,0x17DC,0x0997,0x007A,0xFB3B,0xF65F,0xEF14,
	0xE74B,0xE16D,0xE11F,0xE5A6,0xEAF6,0xEA9F,0xE276,0xD396,
	0xC48D,0xBFCD,0xBFC5,0xC2B5,0xCFB8,0xDE4E,0xED05,0xFD1F,
	0x0F51,0x233C,0x38B0,0x3FB6,0x3F22,0x3FB6,0x3FB0,0x3F76,
	0x3F10,0x3FCC,0x3831,0x2449,0x14DC,0x08B9,0xFDEA,0xF1C6,
	0xE4D5,0xD95C,0xD2E5,0xD2B2,0xD77A,0xDD94,0xE0AB,0xDFAF,
	0xDD36,0xD9AD,0xD817,0xD7F0,0xD9EE,0xDD8F,0xE2EF,0xEAB3,
	0xF34B,0xFC9D,0x0707,0x122B,0x1E73,0x2BE1,0x390A,0x3EF5,
	0x3F2F,0x3F33,0x3CB2,0x32AC,0x28BC,0x1DA8,0x119E,0x0578,
	0xF8F9,0xEBEF,0xE0AF,0xD866,0xD3EF,0xD35B,0xD4F8,0xD829,
	0xDC2A,0xE049,0xE34C,0xE50A,0xE6A9,0xE9C1,0xEDF1,0xF2AA,
	0xF760,0xFB8B,0x00DA,0x0491,0x08B0,0x0F78,0x17D3,0x20A7,
	0x2804,0x2CC1,0x2E1B,0x2D0C,0x29B6,0x251C,0x1FF0,0x189A,
	0x106B,0x071F,0xFC33,0xF1B4,0xE8D8,0xE211,0xDE03,0xDC5F,
	0xDD00,0xDF69,0xE243,0xE5A1,0xE88D,0xEC13,0xF051,0xF572,
	0xFA6B,0xFEF3,0x02A1,0x0462,0x0666,0x0876,0x0BBC,0x103D,
	0x148A,0x17B8,0x1A43,0x1C29,0x1D0C,0x1C8B,0x1B12,0x1826,
	0x148C,0x0F51,0x08F8,0x0297,0xFBD4,0xF463,0xED15,0xE701,
	0xE3A4,0xE304,0xE2C8,0xE350,0xE4E0,0xE7CA,0xEB4A,0xEF17,
	0xF334,0xF7E8,0xFCCA,0x0139,0x0453,0x0668,0x087F,0x0A5A,
	0x0B6D,0x0D5B,0x0FE9,0x1190,0x1254,0x12BE,0x116E,0x0F15,
	0x1072,0x0ECD,0x0B05,0x079B,0x03C7,0xFF21,0xFA2F,0xF59D,
	0xF1B7,0xEE5A,0xEAF1,0xE84D,0xE80F,0xE941,0xEAC9,0xEC64,
	0xEEF4,0xF1C8,0xF57B,0xF9B1,0xFE55,0x01D6,0x0473,0x06D8,
	0x08F8,0x09E5,0x0AFF,0x0C37,0x0D03,0x0D00,0x0C22,0x0B85,
	0x0AE5,0x09CE,0x0850,0x05FC,0x03A2,0x00FE,0xFE0A,0xFB75,
	0xF921,0xF6E2,0xF3A1,0xF0FA,0xEEAF,0xED5F,0xED6D,0xEE7F,
	0xF050,0xF18E,0xF173,0xEF6E,0xEB1F,0xE5B5,0xDFBF,0xD9F0,
	0xD19B,0xC342,0xBEA6,0xBF92,0xC0A6,0xC101,0xC3E9,0xDD53,
	0xF7DF,0x0C5C,0x1E46,0x3216,0x3F8B,0x3F7B,0x3FE6,0x3FC2,
	0x3FC2,0x3F69,0x3F36,0x3E36,0x2EF6,0x1B7C,0x0C6C,0x0162,
	0xFBB9,0xF8AC,0xF50E,0xEF76,0xEA3F,0xE832,0xE8F6,0xECCD,
	0xEFAC,0xEE0C,0xE6B6,0xDBD7,0xD28D,0xCE60,0xCF21,0xD4B8,
	0xDD71,0xE7B1,0xF33E,0xFFA2,0x0E34,0x1E1E,0x2D54,0x3A2A,
	0x3EFD,0x3E69,0x3E39,0x3E50,0x3E83,0x333E,0x231E,0x14E1,
	0x0872,0xFDF1,0xF4DE,0xECA2,0xE4D2,0xDE99,0xDBD8,0xDC89,
	0xDE61,0xE16E,0xE42D,0xE53A,0xE52D,0xE470,0xE326,0xE261,
	0xE27A,0xE4EC,0xE93E,0xEF58,0xF636,0xFD82,0x0578,0x0E21,
	0x1773,0x2141,0x2924,0x2E48,0x2FEE,0x2E3A,0x2A02,0x2353,
	0x1ACE,0x10F8,0x06B8,0xFBF9,0xF286,0xEB17,0xE50B,0xE0B1,
	0xDD11,0xDAFD,0xDBA6,0xDECA,0xE28E,0xE68C,0xE988,0xEBBF,
	0xEDC3,0xEF1D,0xF0ED,0xF3A6,0xF739,0xFB10,0xFEA6,0x0205,
	0x0600,0x0AC0,0x1120,0x1642,0x1A07,0x1C84,0x1E54,0x1EDD,
	0x1D52,0x197A,0x13E7,0x0CD1,0x048F,0xFC87,0xF7CC,0xF0FF,
	0xEBD6,0xE783,0xE2F2,0xE09A,0xE105,0xE34E,0xE6D7,0xEAC9,
	0xEE52,0xF185,0xF40C,0xF6C1,0xF9DC,0xFD39,0x0046,0x02BA,
	0x04C2,0x06DC,0x09CE,0x0BDD,0x0DA7,0x101C,0x12D3,0x1446,
	0x152B,0x14D3,0x12D7,0x0FC3,0x0BF3,0x0817,0x03F0,0xFFCE,
	0xFB2E,0xF64C,0xF148,0xECEB,0xEA2C,0xE995,0xE90C,0xE987,
	0xEBA0,0xEE6E,0xF259,0xF55E,0xF798,0xFA0B,0xFD0C,0x0036,
	0x03AC,0x0692,0x086C,0x0998,0x09AC,0x09AB,0x0AE7,0x0CCC,
	0x0DF6,0x0DD2,0x0C9F,0x0BB3,0x0A79,0x0817,0x03AB,0x009E,
	0xFE28,0xFAB8,0xF7C5,0xF5B4,0xF34C,0xF04C,0xECE3,0xEA3D,
	0xEA30,0xEC27,0xEF12,0xF173,0xF2C5,0xF448,0xF651,0xF9B8,
	0xFD4A,0xFF86,0x0292,0x056A,0x06C4,0x0776,0x07DE,0x086A,
	0x0836,0x084A,0x0841,0x0863,0x08B3,0x07FD,0x06A0,0x04A8,
	0x02B7,0x0121,0xFF95,0xFDAC,0xFC44,0xFAAC,0xF8CE,0xF6E2,
	0xF4E3,0xF45E,0xF578,0xF53B,0xF521,0xF58B,0xF650,0xF62B,
	0xF572,0xF36A,0xF20D,0xF0E0,0xEE27,0xEAB2,0xE7B6,0xE83C,
	0xED6F,0xF521,0xFDA0,0x053D,0x0C0B,0x1208,0x17CC,0x1DCA,
	0x2325,0x26FC,0x277C,0x249C,0x1F83,0x1934,0x1255,0x0B5E,
	0x054D,0x009E,0xFCB0,0xF9FB,0xF858,0xF78C,0xF6E5,0xF609,
	0xF610,0xF748,0xF945,0xFA85,0xFA57,0xF8C0,0xF685,0xF4F1,
	0xF483,0xF5C7,0xF832,0xFACF,0xFD34,0x005C,0x048D,0x09A4,
	0x0E5B,0x11DD,0x141B,0x15EB,0x17AE,0x17F0,0x15D7,0x1197,
	0x0C12,0x073A,0x0268,0xFE82,0xFB38,0xF866,0xF59E,0xF2C1,
	0xF0E7,0xF1A7,0xF37F,0xF4BC,0xF5A1,0xF71F,0xF676,0xF7D5,
	0xFA21,0xF95F,0xF9F7,0xF9C9,0xFA5D,0xFB78,0xFE3F,0x015D,
	0x03C1,0x04FC,0x0635,0x074C,0x0915,0x0ACE,0x0BC5,0x0B7C,
	0x0A3F,0x08F9,0x077A,0x05BD,0x041F,0x02A2,0x00E0,0xFFB9,
	0xFE67,0xFD27,0xFC9D,0xFC0D,0xFB4A,0xFBB4,0xFD2B,0xFE99,
	0xFFE2,0x00D3,0x014F,0x0116,0x0115,0x00DB,0x0030,0x0004,
	0x0061,0x009D,0x0065,0xFF91,0xFEFB,0xFE48,0xFCF1,0xFC34,
	0xFBC1,0xFAF1,0xFA87,0xF974,0xF7AD,0xF63D,0xF4AA,0xF2D1,
	0xF151,0xF091,0xEFEC,0xF011,0xF17C,0xF03B,0xEE85,0xED83,
	0xECB7,0xEC17,0xEBA8,0xEB29,0xEAE6,0xEA64,0xE9A3,0xE8AC,
	0xE7E3,0xE75C,0xE6FD,0xE661,0xE694,0xE6A8,0xE638,0xE525,
	0xE53C,0xE5C9,0xE52E,0xE461,0xE487,0xE406,0xE310,0xE2D7,
	0xE289,0xE23B,0xE1F7,0xE271,0xE2E7,0xE285,0xE226,0xE254,
	0xE227,0xE26A,0xE29F,0xE2D9,0xE317,0xE339,0xE334,0xE3FB,
	0xE453,0xE34D,0xE47F,0xE630,0xE6D0,0xE722,0xE7CA,0xE832,
	0xE86D,0xE907,0xE8E3,0xE921,0xE955,0xE90D,0xE933,0xE955,
	0xE932,0xE9EF,0xE9D0,0xEA2F,0xEACF,0xEB22,0xEB30,0xEB53,
	0xEBE0,0xEC6C,0xECAE,0xED8D,0xEE35,0xEE8D,0xEF04,0xEFB3,
	0xF098,0xF133,0xF1D2,0xF287,0xF328,0xF381,0xF3D3,0xF485,
	0xF511,0xF5A3,0xF619,0xF680,0xF70C,0xF788,0xF81C,0xF8DB,
	0xF92B,0xF987,0xFA46,0xFAC6,0xFB0B,0xFB4F,0xFBEA,0xFC66,
	0xFC9B,0xFD15,0xFD24,0xFD8E,0xFDF0,0xFE34,0xFE63,0xFE8A,
	0xFEA4,0xFF7D,0x0034,0x00CD,0x0156,0x01C4,0x022F,0x02EA,
	0x0370,0x03E1,0x0490,0x04FB,0x0440,0x058A,0x0687,0x0564,
	0x06CA,0x0700,0x0707,0x0758,0x080D,0x081E,0x08A4,0x088A,
	0x0864,0x08BE,0x08AA,0x08E8,0x095F,0x09D3,0x09A1,0x0A77,
	0x0AA8,0x0AA3,0x0AE7,0x0B1B,0x0B3E,0x0BA4,0x0C5D,0x0C4F,
	0x0C6B,0x0C99,0x0CC6,0x0CDA,0x0D5E,0x0D75,0x0DAF,0x0D8C,
	0x0E21,0x0E2D,0x0E32,0x0E31,0x0E3C,0x0E55,0x0E45,0x0EBE,
	0x0EEB,0x0ED8,0x0EB0,0x0F0B,0x0ECB,0x0F1C,0x0F65,0x0F5D,
	0x0F83,0x0F9C,0x0F32,0x0F3C,0x0EE1,0x0F27,0x0F81,0x0FC7,
	0x0FFD,0x0FD8,0x0FA7,0x0F38,0x0F8B,0x0E41,0x0CE3,0x0D4C,
	0x0D53,0x0D84,0x0DC6,0x0E1E,0x0E66,0x0E6C,0x0E37,0x0E0A,
	0x0E69,0x0E68,0x0EAC,0x0E9D,0x0E23,0x0E42,0x0E81,0x0F10,
	0x0E81,0x0DFF,0x0E77,0x0EB9,0x0E32,0x0E7E,0x0EDC,0x0EDA,
	0x0EC1,0x0EF6,0x0EED,0x0E7D,0x0E2C,0x0E3B,0x0E3D,0x0E9D,
	0x0E9F,0x0EFD,0x0EE6,0x0E9C,0x0EB1,0x0E82,0x0E59,0x0E24,
	0x0E05,0x0F2C,0x0EB7,0x0DC2,0x0D41,0x0D88,0x0DED,0x0DFA,
	0x0E5A,0x0DF5,0x0DE7,0x0E4A,0x0E6A,0x0EA0,0x0E81,0x0EB3,
	0x0F10,0x0EB4,0x0EBE,0x0EC7,0x0E56,0x0DBA,0x0DB7,0x0D66,
	0x0D1A,0x0D26,0x0D02,0x0D0D,0x0C74,0x0C43,0x0C0A,0x0C0F,
	0x0BF2,0x0C1C,0x0BD2,0x0B9C,0x0BBD,0x0B3B,0x0B2D,0x0B61,
	0x0B24,0x0ADE,0x0A2B,0x09C0,0x0A16,0x0A0B,0x09C7,0x09CF,
	0x09BB,0x0992,0x095F,0x08EA,0x0908,0x08B0,0x0879,0x0829,
	0x0842,0x0876,0x0805,0x07E4,0x07A1,0x0787,0x079D,0x075D,
	0x07DF,0x079F,0x0734,0x06F2,0x0710,0x0712,0x06CE,0x06B4,
	0x06A1,0x070C,0x06E9,0x0677,0x06EA,0x0632,0x0490,0x0665,
	0x05FB,0x059F,0x05AA,0x052C,0x0522,0x053D,0x0558,0x0589,
	0x054A,0x051E,0x04B0,0x0445,0x040E,0x03DF,0x0428,0x03CD,
	0x03C5,0x0416,0x0414,0x040A,0x03B4,0x039B,0x03B8,0x0353,
	0x031D,0x0322,0x034C,0x036E,0x033F,0x0326,0x0304,0x02F4,
	0x028F,0x0299,0x02A4,0x029E,0x02DD,0x02D6,0x02DE,0x02AC,
	0x028A,0x030D,0x02FF,0x02B5,0x02ED,0x027E,0x0227,0x0272,
	0x028C,0x0287,0x02A1,0x02BA,0x0283,0x022B,0x0264,0x0298,
	0x026A,0x0258,0x0268,0x03DA,0x04D8,0x043A,0x046A,0x0496,
	0x0473,0x03F6,0x036B,0x0316,0x0327,0x02E7,0x02DA,0x02F6,
	0x0312,0x02E6,0x02EB,0x029B,0x027C,0x028F,0x01EA,0x0163,
	0x020F,0x0268,0x01AA,0x0112,0x012C,0x0155,0x0157,0x00EE,
	0x00AF,0xFF9F,0xFFB3,0xFF98,0xFFFF,0x00EC,0x0117,0x0145,
	0x0196,0x0233,0x032E,0x0418,0x04DC,0x0576,0x0613,0x0635,
	0x0637,0x06C9,0x087A,0x0A24,0x0B12,0x0B6F,0x0B71,0x0BDF,
	0x0BB9,0x0B5D,0x0BD2,0x0CA2,0x0CD8,0x0CE9,0x0D1A,0x0DB1,
	0x0D50,0x0CDB,0x0CC4,0x0D90,0x0E48,0x0ED8,0x0F62,0x0FB8,
	0x0FBA,0x0F4B,0x0F43,0x1010,0x11DF,0x12B6,0x12D1,0x125D,
	0x122A,0x11F8,0x123C,0x12F9,0x13F0,0x14FA,0x15AF,0x15D0,
	0x1515,0x14FD,0x1511,0x14C7,0x14E0,0x159F,0x1583,0x137A,
	0x12F5,0x1294,0x1246,0x12D4,0x13C7,0x131C,0x1136,0x0DD7,
	0x0A31,0x0662,0x028A,0xFD46,0xF6C2,0xF032,0xECF8,0xEFD2,
	0xF810,0x01FC,0x0BD3,0x14F5,0x1D04,0x24A9,0x2D54,0x362C,
	0x3CC4,0x3F42,0x3D43,0x374E,0x3013,0x2834,0x1FC7,0x1787,
	0x0F31,0x08D9,0x04B3,0x0238,0x0033,0xFF0D,0xFE30,0xFE5F,
	0xFF6B,0x0181,0x0527,0x065C,0x048F,0x0259,0x00AB,0x0052,
	0x0119,0x02BF,0x04EF,0x088B,0x0CDA,0x1159,0x15E0,0x19EC,
	0x1DF1,0x2117,0x21CF,0x2199,0x2133,0x1D8D,0x170A,0x1029,
	0x08CD,0x0197,0xFAEA,0xF590,0xF1FD,0xEF90,0xED45,0xEC2B,
	0xECD8,0xEF7B,0xF377,0xF710,0xFA70,0xFCB8,0xFF3F,0x01C1,
	0x035F,0x041E,0x045C,0x04B3,0x051C,0x0553,0x052C,0x05C2,
	0x0657,0x0672,0x063D,0x062E,0x05BA,0x045C,0x0277,0xFFD5,
	0xFC51,0xF7B2,0xF2ED,0xEF02,0xEC5A,0xE9C4,0xE666,0xE4AF,
	0xE47E,0xE5E3,0xE816,0xEB0B,0xEDDE,0xF13E,0xF4D8,0xF8EF,
	0xFC38,0xFEF1,0x0117,0x01BC,0x00CA,0x004A,0xFFEF,0xFD19,
	0xFD28,0xFB66,0xF892,0xF6DD,0xF5AE,0xF457,0xF329,0xF1B1,
	0xF037,0xEF55,0xEE9D,0xED3C,0xEB57,0xE930,0xE7BE,0xE6B5,
	0xE6AF,0xE76D,0xE8AD,0xEA35,0xEB3A,0xECDE,0xEF2E,0xF261,
	0xF5D5,0xF8B5,0xFA9E,0xFBEF,0xFCAC,0xFC90,0xFB52,0xFA13,
	0xF8C6,0xF76F,0xF557,0xF318,0xF094,0xEDF3,0xEC24,0xEA8C,
	0xEA2D,0xEA4C,0xEA05,0xE962,0xE8DB,0xE9DA,0xEB4B,0xEC08,
	0xEBBD,0xEBEC,0xED34,0xEE6D,0xEFD2,0xF10E,0xF214,0xF31C,
	0xF3B1,0xF4EE,0xF67A,0xF8A6,0xFB06,0xFC4E,0xFA7A,0xF9DD,
	0xF977,0xF82B,0xF62C,0xF474,0xF2A9,0xF0D5,0xEF04,0xEDB4,
	0xED76,0xECCF,0xEBD6,0xEB8F,0xEC85,0xEE03,0xEF38,0xEF02,
	0xEF6B,0xF213,0xF3BA,0xF448,0xF4F9,0xF6B8,0xF71D,0xF65A,
	0xF63C,0xF6B6,0xF7AC,0xF848,0xF7EC,0xF6B1,0xF64C,0xF6D5,
	0xF695,0xF560,0xF3F5,0xF294,0xF1F5,0xF166,0xF127,0xEFE5,
	0xEF1E,0xED74,0xEB7A,0xECA3,0xEF75,0xF159,0xF1BD,0xF115,
	0xF0AA,0xF163,0xF418,0xF6F6,0xF7D8,0xF79E,0xF6C0,0xF693,
	0xF65E,0xF6A8,0xF6E9,0xF5B6,0xF4C6,0xF458,0xF460,0xF439,
	0xF258,0xED9C,0xE63E,0xDD91,0xD57D,0xCDF6,0xC400,0xBE42,
	0xBE62,0xBE4A,0xBE67,0xBF20,0xBE61,0xCDFB,0xECF3,0x0375,
	0x15B4,0x297E,0x3B7B,0x3E3F,0x3E3C,0x3E85,0x3E58,0x3D9A,
	0x3E62,0x3144,0x19A5,0x0544,0xF2CA,0xE41C,0xDA6A,0xD5A4,
	0xD2FE,0xD064,0xCD88,0xCCDC,0xD0A4,0xD834,0xE10D,0xE75D,
	0xE7A5,0xE2B5,0xDC9B,0xDA89,0xDF3C,0xE901,0xF526,0x0115,
	0x0B62,0x153C,0x2030,0x2BB8,0x3674,0x3D94,0x3F80,0x3EBD,
	0x3DCA,0x360E,0x2677,0x13B0,0xFEAA,0xEB5A,0xDC8C,0xD261,
	0xCB01,0xC5FC,0xC16F,0xBFE6,0xC12B,0xC841,0xD47D,0xE28F,
	0xEE97,0xF75B,0xFD03,0x019E,0x057A,0x08DA,0x0CE4,0x104E,
	0x131C,0x15C1,0x179A,0x193C,0x19D4,0x19C2,0x1996,0x1A68,
	0x1A82,0x1952,0x153F,0x0C4B,0x002E,0xF3DA,0xE9AF,0xE194,
	0xDAAC,0xD4C2,0xD01C,0xCD45,0xCD01,0xCFC6,0xD60B,0xDFF4,
	0xEAE5,0xF5C5,0x003F,0x09F6,0x128D,0x1870,0x1BC9,0x1CAC,
	0x1D15,0x1CD6,0x1BA5,0x18B5,0x14B1,0x0F30,0x0813,0x0264,
	0xFF06,0xFD15,0xFBB8,0xF99E,0xF5FF,0xF0FA,0xEC47,0xE8AE,
	0xE55D,0xE340,0xE1F1,0xE16E,0xE173,0xE1F4,0xE407,0xE87A,
	0xEEC2,0xF4F3,0xFCAF,0x0506,0x0C93,0x12ED,0x180B,0x1AF1,
	0x1BD2,0x1AAA,0x1921,0x1687,0x1341,0x0E79,0x081C,0x0123,
	0xFA82,0xF54C,0xF1F1,0xEFF3,0xEE75,0xECE6,0xEB79,0xEAA9,
	0xEB1D,0xED40,0xF047,0xF0C8,0xF1FB,0xF3AF,0xF5DB,0xF8FC,
	0xFC8D,0xFFB1,0x023F,0x05C1,0x0A38,0x0F2B,0x12B1,0x1435,
	0x1529,0x14C6,0x140A,0x12EC,0x1125,0x0E38,0x099B,0x035D,
	0xFCC8,0xF775,0xF3D9,0xF1DB,0xF075,0xEF52,0xEDA9,0xED4F,
	0xEE9B,0xF0FE,0xF43B,0xF788,0xFAD4,0xFE11,0x0147,0x039B,
	0x048B,0x05CC,0x0895,0x0AC5,0x0BFE,0x0C68,0x0D11,0x0D7B,
	0x0C7B,0x0B37,0x0A26,0x097F,0x090A,0x0725,0x037B,0x003F,
	0xFD1A,0xF99F,0xF65C,0xF489,0xF3DE,0xF38B,0xF330,0xF2D1,
	0xF245,0xF3F2,0xF6BE,0xF997,0xFCD1,0x0089,0x03C8,0x068B,
	0x07D6,0x08EA,0x0A7B,0x0B8D,0x0C44,0x0C81,0x0AB3,0x097B,
	0x0A43,0x06FE,0x0401,0x01F1,0xFF47,0xF973,0xEFBF,0xE41F,
	0xD8AF,0xCC34,0xC115,0xBF7B,0xBF5C,0xBF32,0xBF61,0xC055,
	0xBF8B,0xD574,0xF981,0x13D2,0x2CC8,0x3DFE,0x3F2D,0x3F34,
	0x3F83,0x3F60,0x3F59,0x3F22,0x3E81,0x3E97,0x2C49,0x11B0,
	0xFC6A,0xEAF7,0xDE80,0xD6FF,0xD241,0xCE65,0xCBAD,0xCC52,
	0xD1FA,0xDB2B,0xE3BA,0xE73B,0xE57F,0xE045,0xDC27,0xDCD4,
	0xE353,0xEF77,0xFD82,0x0AEB,0x18B2,0x26A2,0x360E,0x3ECF,
	0x3F08,0x3F3C,0x3F64,0x3F83,0x4010,0x40CE,0x378D,0x1DDA,
	0x051B,0xEEF1,0xDD82,0xD0E9,0xC6B7,0xC0C3,0xC034,0xC08A,
	0xC017,0xC816,0xD712,0xE625,0xF3B4,0xFDCB,0x055E,0x0B3F,
	0x1150,0x16EE,0x1A52,0x1CC6,0x207B,0x23DA,0x265E,0x2864,
	0x29A6,0x2A9B,0x2A96,0x2A21,0x2927,0x264C,0x1F0B,0x1383,
	0x047D,0xF603,0xE949,0xDE67,0xD53C,0xCCE3,0xC664,0xC37C,
	0xC425,0xC834,0xD14C,0xDE50,0xEB3F,0xF756,0x0396,0x0F6D,
	0x19F4,0x21F8,0x268C,0x2794,0x26B8,0x2525,0x22DB,0x1FA4,
	0x1ABE,0x14F5,0x0EB7,0x08EA,0x0401,0x0107,0xFDDF,0xF9EB,
	0xF4D9,0xEE8E,0xE946,0xE553,0xE228,0xDEC0,0xDB5A,0xD933,
	0xD976,0xDB72,0xDFCC,0xE5D5,0xEDA9,0xF62C,0xFE1C,0x0689,
	0x0FC6,0x1824,0x1ED2,0x225A,0x2381,0x229C,0x207D,0x1C9E,
	0x17AC,0x114A,0x09B2,0x01E3,0xFA25,0xF42E,0xEFD8,0xEC54,
	0xE972,0xE74C,0xE661,0xE65B,0xE6EE,0xE7D4,0xE993,0xEB9B,
	0xEDD4,0xEFCC,0xF2FB,0xF6FD,0xFB06,0xFE93,0x02FC,0x0866,
	0x0DFD,0x11B3,0x151E,0x17C6,0x1909,0x1A90,0x1A7C,0x153E,
	0x1286,0x0E9D,0x090C,0x025E,0xFC86,0xF6AC,0xF208,0xED93,
	0xEA40,0xE899,0xE885,0xE9AA,0xEB4C,0xEDDE,0xF0FF,0xF501,
	0xF8B9,0xFBDD,0xFF12,0x029F,0x05FC,0x082D,0x0A62,0x0C4C,
	0x0DC0,0x0EBA,0x0F28,0x0F74,0x0F5A,0x0F61,0x0EF5,0x0D64,
	0x0A5E,0x068C,0x02A2,0xFEF0,0xFBE5,0xF933,0xF649,0xF2BD,
	0xEF44,0xECD5,0xEBCE,0xEC50,0xEEC4,0xF1C3,0xF50D,0xF800,
	0xFB41,0xFEA9,0x022A,0x0580,0x082C,0x0B2F,0x0DC4,0x0EB9,
	0x0E63,0x0D53,0x0C56,0x0AF5,0x08D8,0x060F,0x0294,0xFF1E,
	0xF77C,0xEBC8,0xDECC,0xD34A,0xC665,0xBEC8,0xBEF7,0xBED9,
	0xBEBB,0xBF16,0xBFEA,0xC025,0xD964,0xFC08,0x1665,0x308E,
	0x3ECF,0x3E7D,0x3F43,0x3F7E,0x3F5E,0x3F45,0x3EFF,0x3EBA,
	0x3E57,0x2860,0x0D07,0xF796,0xE868,0xDF47,0xDAB5,0xD67A,
	0xD157,0xCCC5,0xCD30,0xD375,0xDDA1,0xE593,0xE7AA,0xE344,
	0xDD39,0xDB32,0xDD63,0xE588,0xF1EF,0xFF14,0x0D3F,0x1C23,
	0x2C27,0x3B60,0x401B,0x3FF9,0x4077,0x40A9,0x408E,0x4036,
	0x40FA,0x352D,0x1A66,0x00B4,0xEB9C,0xDB03,0xCFB6,0xC6DC,
	0xC1A1,0xC0DB,0xC111,0xC16A,0xCB3C,0xDA99,0xE92D,0xF5BD,
	0xFED5,0x05ED,0x0BE8,0x111E,0x159A,0x19B7,0x1D4F,0x209E,
	0x2456,0x2852,0x2AB2,0x2B6E,0x2B5E,0x2B9A,0x2BF0,0x2AF8,
	0x270E,0x1EB6,0x12D4,0x0474,0xF54F,0xE7B7,0xDC6F,0xD316,
	0xCBFC,0xC756,0xC54B,0xC6B0,0xCB70,0xD3D0,0xDF8C,0xECFE,
	0xFB1F,0x08EB,0x14DA,0x1DB2,0x238A,0x267E,0x27D3,0x284E,
	0x27AD,0x25C7,0x21B1,0x1C1F,0x15FA,0x0FD1,0x096D,0x0746,
	0x0456,0xFFB3,0xFC1C,0xF741,0xF1D0,0xEC3F,0xE6C1,0xE1AE,
	0xDDF9,0xDBA3,0xDAEF,0xDBF3,0xDECD,0xE2F0,0xE7F3,0xEDE0,
	0xF663,0x010C,0x0BFD,0x15FB,0x1D58,0x2202,0x2432,0x250F,
	0x2474,0x2271,0x1EC9,0x195F,0x125C,0x0A53,0x020A,0xFA88,
	0xF50B,0xF132,0xED83,0xEA34,0xE915,0xE90C,0xE935,0xE8C7,
	0xE8C8,0xE9F3,0xEC49,0xEF1A,0xF21B,0xF598,0xF949,0xFCB8,
	0x004B,0x048E,0x091F,0x0F06,0x142E,0x1803,0x1A0B,0x1AF4,
	0x1A5C,0x183F,0x15CB,0x13AD,0x107C,0x0A57,0x03F7,0xFD10,
	0xF694,0xF103,0xEC8C,0xE9A2,0xE86E,0xE8C5,0xE9CB,0xEB86,
	0xEDA7,0xF06F,0xF411,0xF855,0xFC09,0x0039,0x02F6,0x04CF,
	0x0859,0x0B56,0x0C2B,0x0D04,0x0E0D,0x0E6A,0x0F5C,0x0FA5,
	0x0E8D,0x0D0A,0x0A03,0x061A,0x02CC,0x0046,0xFDED,0xFA28,
	0xF567,0xF100,0xED6F,0xEBC0,0xEB36,0xEBA5,0xECBF,0xEEC0,
	0xF004,0xF14A,0xF5A6,0xFB02,0xFEF8,0x0267,0x0580,0x086C,
	0x0A7B,0x0B85,0x0B98,0x0B52,0x0B03,0x09FA,0x08BC,0x0709,
	0x04FB,0x0305,0xFFDA,0xFA2B,0xF169,0xE58C,0xD972,0xCE47,
	0xC224,0xBDEC,0xBE2A,0xBE10,0xBE22,0xBED6,0xBED4,0xC3B1,
	0xE4D5,0x049D,0x1D6D,0x35D3,0x3EB4,0x3E02,0x3E76,0x3E55,
	0x3E49,0x3E49,0x3D96,0x3E4A,0x377D,0x1C10,0x026F,0xEE43,
	0xE083,0xD968,0xD43F,0xCF18,0xCA03,0xC6A5,0xC860,0xD11D,
	0xDD05,0xE56A,0xE5D9,0xDFB9,0xD8A0,0xD68D,0xDB34,0xE5EC,
	0xF3E6,0x0313,0x10D6,0x1ECD,0x2D26,0x3B01,0x3EAB,0x3EE4,
	0x3EFB,0x3EBE,0x3ED2,0x3E92,0x3CB2,0x28CD,0x0CCF,0xF3F1,
	0xE159,0xD283,0xC7F9,0xC06D,0xBF39,0xBF45,0xBFA9,0xBF8F,
	0xCA23,0xDB38,0xEA01,0xF56E,0xFE5C,0x0519,0x0B04,0x1022,
	0x1452,0x1893,0x1C2D,0x1FC8,0x2346,0x2657,0x2766,0x2742,
	0x26E7,0x2766,0x2818,0x2799,0x235D,0x1957,0x0B71,0xFBAE,
	0xECB9,0xE098,0xD78D,0xCFB1,0xC87A,0xC342,0xC0D8,0xC2A6,
	0xC9B6,0xD4B6,0xE1FD,0xEFBB,0xFD9D,0x0AA6,0x156C,0x1DB6,
	0x22ED,0x25B9,0x27C6,0x28A4,0x2712,0x23F6,0x1E9A,0x18B5,
	0x122C,0x0BE6,0x0729,0x0466,0x0174,0xFBA8,0xF62F,0xF100,
	0xEB90,0xE6C6,0xE1FB,0xDE28,0xDC02,0xDAF6,0xDA09,0xD9BF,
	0xDC33,0xE0B7,0xE75A,0xEFCF,0xF97D,0x0463,0x0E8D,0x170C,
	0x1B70,0x1FB5,0x243B,0x2601,0x24F9,0x21EF,0x1CF4,0x15BC,
	0x0DC2,0x05F7,0xFF28,0xF939,0xF465,0xF04C,0xED39,0xEB49,
	0xE9B8,0xE911,0xE930,0xE99A,0xEA99,0xED16,0xEFFC,0xF284,
	0xF4E7,0xF7C4,0xF8BC,0xFBCC,0x00CF,0x06FD,0x0CAD,0x1154,
	0x13D5,0x15E8,0x17E8,0x19D9,0x1B19,0x1A6F,0x182D,0x13FC,
	0x0D36,0x05E4,0xFFDA,0xFA2C,0xF491,0xEFBD,0xEC52,0xEAF0,
	0xEA31,0xE9FD,0xEAA4,0xEC19,0xEE7F,0xF2BA,0xF775,0xFD14,
	0x0188,0x03F8,0x0531,0x06CA,0x0998,0x0D32,0x10B4,0x11F9,
	0x11B6,0x10CE,0x100A,0x0F63,0x0EC6,0x0E3C,0x0C97,0x0988,
	0x05E6,0x0222,0xFE62,0xFA80,0xF601,0xF217,0xEF79,0xEDFD,
	0xED6D,0xEDB6,0xEEC2,0xEFCB,0xF0F9,0xF38C,0xF834,0xFDF7,
	0x02D4,0x0589,0x07BA,0x09FC,0x0C1F,0x0CDB,0x0DBC,0x0E1B,
	0x0E65,0x0D73,0x0B62,0x08D5,0x074F,0x02EA,0xFF08,0xFAB6,
	0xF0E8,0xE609,0xDA94,0xCCEA,0xC0D9,0xBFB7,0xBFA0,0xBF78,
	0xBF88,0xC089,0xBF4B,0xCB3B,0xEF1C,0x0BBA,0x2627,0x3B81,
	0x3F45,0x3F1D,0x3F8A,0x3F69,0x3F4B,0x3F2A,0x3E8D,0x3F14,
	0x3230,0x15F7,0xFF4B,0xED5F,0xE12F,0xD8E7,0xD295,0xCD66,
	0xC9A2,0xC971,0xCDE9,0xD6EF,0xE048,0xE5D8,0xE44C,0xDE4E,
	0xD8D7,0xD8F3,0xDF7C,0xEA6D,0xF7BA,0x05D9,0x145E,0x229F,
	0x321C,0x3DCE,0x3F2D,0x3F11,0x3F24,0x3F38,0x3E90,0x3F44,
	0x397D,0x204F,0x083A,0xF397,0xE0D5,0xD2AD,0xC715,0xC0BA,
	0xC062,0xC080,0xC012,0xC2AB,0xD0C5,0xE028,0xED67,0xF809,
	0x0085,0x07B9,0x0D98,0x12AF,0x1696,0x19A2,0x1C90,0x20E7,
	0x259C,0x2752,0x275A,0x27D5,0x28E4,0x297C,0x2924,0x2646,
	0x1FF9,0x1536,0x06FD,0xF821,0xEB22,0xDFD6,0xD5A9,0xCCDA,
	0xC5CC,0xC205,0xC1D0,0xC617,0xCE1D,0xD8C0,0xE546,0xF2EA,
	0xFF62,0x0BCB,0x17E6,0x2006,0x2495,0x264D,0x26AE,0x269C,
	0x2572,0x22BD,0x1D61,0x1660,0x0F9A,0x0A2B,0x062F,0x01FA,
	0xFE92,0xFA14,0xF4A5,0xEF80,0xEA94,0xE5C0,0xE0CB,0xDC47,
	0xD8E5,0xD746,0xD811,0xDA3C,0xDD91,0xE292,0xE8E4,0xF103,
	0xFB14,0x0586,0x0EFB,0x16D7,0x1CF6,0x2141,0x23C6,0x2340,
	0x2103,0x1C90,0x1742,0x11A3,0x0AFD,0x041E,0xFC8A,0xF57B,
	0xEF17,0xEAFE,0xE815,0xE718,0xE722,0xE768,0xE72E,0xE6A7,
	0xE6C2,0xE85C,0xEAFB,0xEE06,0xF168,0xF549,0xF971,0xFD61,
	0x0112,0x0536,0x09F1,0x0F37,0x139E,0x1701,0x19BC,0x1B22,
	0x191F,0x1585,0x1103,0x0C07,0x087C,0x04FF,0xFCEC,0xF76C,
	0xF1D7,0xECD6,0xE92B,0xE761,0xE6C5,0xE82B,0xE9CB,0xEC17,
	0xEEF1,0xF1EA,0xF52E,0xF853,0xFC80,0x00F4,0x052E,0x0857,
	0x0AD9,0x0C6B,0x0D58,0x0E2A,0x0EE9,0x0FB3,0x1013,0x100F,
	0x0F52,0x0D60,0x09D7,0x0681,0x0233,0xFE52,0xFB22,0xF8E3,
	0xF646,0xF281,0xEF30,0xEBEB,0xEA98,0xEAFC,0xED4A,0xF0E6,
	0xF4A2,0xF821,0xFB01,0xFCB7,0xFF93,0x034B,0x07E7,0x0B3C,
	0x0D9B,0x0E43,0x0DB1,0x0CE1,0x0BCC,0x0AFD,0x09C9,0x08AB,
	0x06B8,0x02AA,0xFB34,0xF0CE,0xE2D6,0xD464,0xC753,0xBEE3,
	0xBEDA,0xBE97,0xBE82,0xBEED,0xC003,0xBEF7,0xD159,0xF59B,
	0x113D,0x2B5F,0x3D47,0x3EC5,0x3F07,0x3F3F,0x3F55,0x3F1A,
	0x3E89,0x3E5B,0x3EB7,0x2C77,0x1017,0xFA97,0xEA07,0xE034,
	0xDAEC,0xD69F,0xD1B8,0xCD5B,0xCCD7,0xD1D1,0xDAA8,0xE2D4,
	0xE66B,0xE3EC,0xDE42,0xDA3E,0xDB0D,0xE23F,0xED9B,0xFB4B,
	0x0B29,0x199B,0x27E5,0x3848,0x3FB5,0x3F8E,0x3FF6,0x3FF0,
	0x4009,0x3F91,0x4057,0x3850,0x1DF6,0x03E7,0xED1F,0xDBC9,
	0xCF60,0xC675,0xC129,0xC0E9,0xC14A,0xC0E4,0xC621,0xD4B9,
	0xE3C6,0xF182,0xFC57,0x03FA,0x0A14,0x0ED2,0x127D,0x169E,
	0x1A9F,0x1ECE,0x2290,0x251F,0x2787,0x2939,0x29C9,0x2A66,
	0x2A68,0x2992,0x2604,0x1EB1,0x13AE,0x05B2,0xF680,0xE8A3,
	0xDC85,0xD241,0xCACA,0xC5D0,0xC357,0xC3E9,0xC80C,0xCFD3,
	0xDAF7,0xE78E,0xF58B,0x0332,0x0FFB,0x1A0F,0x20C3,0x2489,
	0x263E,0x269A,0x2648,0x24DF,0x217E,0x1C8C,0x15F6,0x0F6A,
	0x0AC8,0x069F,0x0316,0x0096,0xFC3B,0xF561,0xF1A4,0xEC67,
	0xE65B,0xE18B,0xDD88,0xDAA3,0xD9EF,0xDAC9,0xDD49,0xE0A2,
	0xE58D,0xEB8C,0xF35A,0xFD32,0x088D,0x12EE,0x1ACD,0x1F8E,
	0x21FC,0x22D9,0x224C,0x207D,0x1D2F,0x186A,0x11B6,0x0A3C,
	0x0249,0xFB44,0xF50B,0xF05C,0xED15,0xEA48,0xE871,0xE797,
	0xE749,0xE709,0xE671,0xE754,0xE908,0xEB5F,0xEF07,0xF28A,
	0xF649,0xF9DA,0xFD06,0x008B,0x051C,0x0A96,0x10D2,0x15A8,
	0x188F,0x18F8,0x185E,0x16C7,0x1404,0x1051,0x0C95,0x08C0,
	0x02DD,0xFB7E,0xF60D,0xF28F,0xEDE0,0xEA87,0xE87C,0xE84F,
	0xE9EA,0xEBA0,0xED90,0xEFEB,0xF32F,0xF6BD,0xFA6D,0xFE7A,
	0x0332,0x0758,0x0A0E,0x0AAB,0x0B0B,0x0BF2,0x0DA1,0x104C,
	0x11CD,0x1119,0x0FDD,0x0E22,0x0AD4,0x07B6,0x0564,0x02DA,
	0xFFB0,0xFBE4,0xF7AF,0xF40C,0xF0DF,0xED94,0xEBDE,0xEAFD,
	0xEC25,0xEE72,0xF0FE,0xF37B,0xF622,0xF8AC,0xFC0C,0xFEDC,
	0x01CE,0x06D4,0x0B32,0x0CFB,0x0D15,0x0CA4,0x0BF7,0x0B87,
	0x0A68,0x0967,0x07C9,0x054A,0x0156,0xFC4D,0xF465,0xEA53,
	0xE042,0xD612,0xCB54,0xC011,0xBDF1,0xBE02,0xBE02,0xBEA0,
	0xBE74,0xC2B6,0xE0E8,0xFD46,0x12EA,0x2792,0x3B13,0x3E3E,
	0x3E08,0x3E5A,0x3E57,0x3E3A,0x3D9E,0x3E3B,0x343F,0x1BFE,
	0x0714,0xF5CD,0xE9E1,0xE26A,0xDD1B,0xD82B,0xD3B0,0xCFFE,
	0xD07F,0xD646,0xDED1,0xE65C,0xE8BC,0xE488,0xDD73,0xDA2D,
	0xDD8D,0xE6F6,0xF340,0xFFE2,0x0BB3,0x1682,0x224D,0x2EED,
	0x3BB9,0x3EBE,0x3E70,0x3E93,0x3DFF,0x3EC5,0x39D1,0x2581,
	0x1038,0xFC05,0xEB04,0xDD6C,0xD5C6,0xCD02,0xC543,0xC1AA,
	0xC086,0xC59D,0xD02D,0xDE07,0xEA51,0xF4CE,0xFC69,0x01F9,
	0x05B4,0x0A69,0x0F9C,0x14A7,0x1883,0x1B67,0x1DC1,0x1F87,
	0x20DC,0x2174,0x2202,0x22AC,0x23AE,0x22ED,0x1F09,0x16A2,
	0x0A74,0xFD7A,0xF198,0xE7F9,0xDFEE,0xD8AC,0xD222,0xCD31,
	0xCAB3,0xCBA9,0xD102,0xD97C,0xE3EF,0xEF32,0xFA72,0x0500,
	0x0E8F,0x1639,0x1AB6,0x1D6D,0x1F3C,0x20AB,0x2122,0x1FAE,
	0x1B6A,0x1602,0x10F6,0x0BFF,0x084A,0x05B8,0x03F3,0x00F8,
	0xFCC3,0xF6BA,0xF10D,0xEC38,0xE6E5,0xE31C,0xE0CB,0xDF54,
	0xDEAD,0xDEF3,0xE059,0xE3C1,0xE8F6,0xF036,0xF845,0x00AA,
	0x08C0,0x1005,0x15D5,0x19B4,0x1BBC,0x1D0E,0x1D31,0x1B04,
	0x1788,0x138C,0x0D9C,0x0638,0xFF6E,0xF9F5,0xF5A3,0xF341,
	0xF13B,0xEE02,0xEBA9,0xE9E9,0xE9D6,0xEAFF,0xEC35,0xEE54,
	0xF0D5,0xF26E,0xF3F6,0xF631,0xF8FC,0xFC9A,0x00F6,0x0575,
	0x08B1,0x0D07,0x1110,0x1330,0x145D,0x1510,0x150C,0x1418,
	0x1265,0x0FE1,0x0BF9,0x0713,0x0106,0xFBBC,0xF82E,0xF56B,
	0xF212,0xEF6D,0xED4B,0xED07,0xEE22,0xEF33,0xF155,0xF3E3,
	0xF76F,0xFB43,0xFE31,0x0159,0x039A,0x059C,0x0728,0x0922,
	0x0B4E,0x0D7C,0x0E64,0x0E01,0x0D2C,0x0D08,0x0CD6,0x0B6F,
	0x099D,0x079F,0x04F6,0x01B8,0xFEB6,0xFB7A,0xF840,0xF545,
	0xF231,0xF033,0xEFEE,0xF071,0xF08D,0xF0B6,0xF203,0xF4BF,
	0xF843,0xFBE7,0xFFBD,0x02E5,0x0595,0x0710,0x0865,0x098D,
	0x0A93,0x0BD2,0x0BCE,0x0AB0,0x092D,0x0785,0x0591,0x0411,
	0x01A7,0xFE48,0xFB16,0xF735,0xF110,0xEB8E,0xE865,0xE09F,
	0xD7DE,0xD0AB,0xCDBF,0xD15B,0xDA81,0xE6FC,0xF393,0xFEB1,
	0x07F4,0x109A,0x1B0D,0x264D,0x2FB3,0x34D8,0x34B0,0x2FB3,
	0x2900,0x20DC,0x1827,0x0F35,0x06AA,0xFF23,0xFA13,0xF612,
	0xF327,0xF058,0xEDBD,0xEBE9,0xEB71,0xEDA3,0xF068,0xF22E,
	0xF1F8,0xEFE9,0xEDD4,0xEE2A,0xF0F3,0xF512,0xF9C9,0xFF21,
	0x051F,0x0ADB,0x1018,0x15D5,0x1B1A,0x1F9C,0x2244,0x2269,
	0x2079,0x1D8C,0x181B,0x0F87,0x0675,0xFE55,0xF7D7,0xF250,
	0xED76,0xE941,0xE868,0xE73E,0xE743,0xE97C,0xED89,0xF1E1,
	0xF5BA,0xF8D6,0xFBB3,0xFFA4,0x02C5,0x05A3,0x074D,0x08A2,
	0x0AB6,0x0C67,0x0E21,0x1002,0x114F,0x115A,0x1169,0x11B8,
	0x10E0,0x0F30,0x0D5F,0x09E6,0x052A,0x0020,0xFAB3,0xF606,
	0xF24A,0xEEDD,0xEBB4,0xE985,0xE87B,0xE994,0xEC44,0xEFA7,
	0xF352,0xF6FB,0xFB42,0xFFBC,0x044F,0x07BD,0x09D0,0x0C6F,
	0x0DF5,0x0E65,0x0DF7,0x0D28,0x0C85,0x0B49,0x0931,0x070B,
	0x0538,0x0333,0x0197,0xFFCB,0xFE02,0xFC49,0xF98A,0xF7FD,
	0xF667,0xF4B4,0xF345,0xF1C9,0xF0EB,0xF05C,0xF0E5,0xF2A9,
	0xF4A8,0xF766,0xFA49,0xFCCA,0xFF15,0x0127,0x02CA,0x0476,
	0x053B,0x0537,0x04A9,0x03D4,0x032E,0x0246,0x0106,0x0005,
	0xFEAB,0xFD49,0xFC0D,0xFAAF,0xF985,0xF869,0xF773,0xF667,
	0xF54F,0xF474,0xF330,0xF281,0xF184,0xF0A8,0xEFC4,0xEF20,
	0xEE39,0xED88,0xECF7,0xEC88,0xEC3E,0xEB88,0xEAB7,0xEA12,
	0xE9E2,0xE950,0xE8EE,0xE86C,0xE7B6,0xE7D6,0xE6EA,0xE5E5,
	0xE561,0xE53D,0xE3E3,0xE374,0xE459,0xE221,0xE285,0xE2F4,
	0xE2A2,0xE2BE,0xE2E0,0xE2EB,0xE314,0xE306,0xE319,0xE34A,
	0xE338,0xE33A,0xE34D,0xE416,0xE432,0xE45E,0xE4F0,0xE543,
	0xE5F3,0xE603,0xE666,0xE6B3,0xE701,0xE716,0xE775,0xE75A,
	0xE717,0xE741,0xE7B3,0xE854,0xE88F,0xE8E1,0xE954,0xEA29,
	0xEA13,0xEA44,0xEAD3,0xEBBC,0xEBCC,0xEC1B,0xEC9E,0xED10,
	0xEDD0,0xEE46,0xEEB1,0xEF8D,0xF047,0xF0F9,0xF1B1,0xF292,
	0xF378,0xF3D9,0xF440,0xF447,0xF48B,0xF4F3,0xF591,0xF616,
	0xF63A,0xF69E,0xF6FB,0xF631,0xF4EF,0xF59F,0xF67E,0xF6F7,
	0xF774,0xF7D4,0xF842,0xF867,0xF8EE,0xF9BC,0xFA3E,0xFAA3,
	0xFADE,0xFBB5,0xFC88,0xFD66,0xFE06,0xFED1,0xFEC7,0xFECF,
	0xFF92,0x008E,0x0134,0x0117,0x014C,0x01B2,0x0210,0x02F8,
	0x037B,0x0412,0x04AB,0x0494,0x04CB,0x0534,0x0531,0x051A,
	0x0539,0x0569,0x05A6,0x05E5,0x0681,0x0702,0x077F,0x08A5,
	0x081A,0x07AC,0x081F,0x0880,0x08FB,0x0969,0x09B9,0x09CF,
	0x0A6E,0x0B57,0x0BF3,0x0CAA,0x0CDB,0x0DA2,0x0DF7,0x0DB9,
	0x0E37,0x0E23,0x0DCF,0x0DF5,0x0E58,0x0DEF,0x0DE0,0x0DC7,
	0x0DE0,0x0DDC,0x0E56,0x0E51,0x0E4B,0x0E4E,0x0DD4,0x0DBB,
	0x0DF3,0x0E56,0x0EE5,0x0F12,0x0EDA,0x0EDF,0x0EB6,0x0EE5,
	0x0F1F,0x0F07,0x0F5A,0x0F42,0x0F49,0x0F9F,0x0FA1,0x0F57,
	0x0EFC,0x0F12,0x0F1A,0x0F32,0x0F5F,0x0F62,0x0F3D,0x0EE4,
	0x0EC5,0x0EB0,0x0E84,0x0E68,0x0EB2,0x0EB0,0x0E90,0x0EAE,
	0x0E85,0x0E56,0x0E79,0x0E92,0x0EDE,0x0E8B,0x0E98,0x0ED6,
	0x0EC2,0x0EF4,0x0F30,0x0F9D,0x0DD9,0x0F6D,0x0F9B,0x0E80,
	0x0ED6,0x0ECC,0x0ED0,0x0E94,0x0E73,0x0E4D,0x0DB8,0x0DA9,
	0x0D4C,0x0D72,0x0DD3,0x0DEF,0x0DAA,0x0D9A,0x0D2B,0x0CBB,
	0x0CB9,0x0C9D,0x0C60,0x0C39,0x0C08,0x0C66,0x0C3F,0x0BF9,
	0x0C31,0x0BEC,0x0BFE,0x0BE8,0x0B91,0x0BB5,0x0BB0,0x0B85,
	0x0B94,0x0B2B,0x0B68,0x0B7B,0x0B71,0x0B2E,0x0B58,0x0B2A,
	0x0B74,0x0B6A,0x0AFF,0x0ABF,0x0ABC,0x0A76,0x0A11,0x0A11,
	0x09FC,0x09F2,0x09C2,0x09AA,0x0987,0x0979,0x0978,0x0989,
	0x0981,0x0AB7,0x0C31,0x0B77,0x0B5F,0x0ADB,0x0A7C,0x0A55,
	0x0A44,0x0A29,0x0AB7,0x0AB3,0x0A91,0x0A35,0x09F3,0x09DE,
	0x098D,0x094D,0x0985,0x0957,0x089A,0x0822,0x08A0,0x0916,
	0x0871,0x07BD,0x0818,0x07D6,0x0770,0x0765,0x070A,0x06CB,
	0x069A,0x0663,0x0683,0x061B,0x061F,0x0611,0x05FD,0x05D4,
	0x057E,0x0571,0x055D,0x0550,0x0529,0x0550,0x04C5,0x0398,
	0x043C,0x0538,0x0508,0x053D,0x054F,0x0540,0x04E7,0x04DD,
	0x04D6,0x0444,0x034C,0x030D,0x0318,0x0294,0x023B,0x021E,
	0x0200,0x0248,0x020E,0x0208,0x01E5,0x01C6,0x01DA,0x01AA,
	0x01BF,0x01C0,0x0214,0x024A,0x0233,0x0203,0x020F,0x0228,
	0x01FC,0x01B9,0x01DF,0x01C8,0x01D7,0x01DA,0x0198,0x01CB,
	0x01D9,0x0185,0x0172,0x013A,0x0157,0x020C,0x01FE,0x01C1,
	0x019A,0x0177,0x0160,0x0163,0x01A2,0x01A1,0x0170,0x0133,
	0x00D0,0x00F8,0x009B,0x00B3,0xFFB1,0xFF9F,0xFFAB,0xFF82,
	0xFEBF,0xFCB9,0xFCF6,0xFD2B,0xFD94,0xFDAE,0xFDD8,0xFDEB,
	0xFDF7,0xFDC5,0xFDE7,0xFDF6,0xFE34,0xFE32,0xFE39,0xFE7E,
	0xFF07,0xFEFE,0xFF68,0xFF18,0xFE92,0xFF04,0xFF08,0xFEEA,
	0xFEE4,0xFEAD,0xFF04,0xFF4D,0xFF75,0xFF82,0xFF3B,0xFF21,
	0xFF50,0xFF85,0xFF68,0xFF85,0xFFC4,0xFFBC,0xFFA7,0xFFCE,
	0xFF98,0xFF9C,0xFFBF,0xFFCD,0x0105,0x01B4,0x0124,0x0146,
	0x00C6,0x0058,0x009D,0x01B2,0x0316,0x04BC,0x0557,0x05F2,
	0x0709,0x071C,0x07DC,0x08D0,0x08E2,0x0930,0x098E,0x0935,
	0x08D8,0x08AF,0x08FF,0x08ED,0x091E,0x098B,0x09ED,0x09A3,
	0x091F,0x0924,0x090A,0x0995,0x0A1E,0x0A5C,0x0B83,0x0C7E,
	0x0D04,0x0D74,0x0DC1,0x0E14,0x0EAE,0x0F05,0x0FC1,0x1156,
	0x1249,0x1259,0x11B2,0x10CB,0x10C0,0x11A5,0x12BE,0x1390,
	0x1492,0x14ED,0x14AB,0x148D,0x1508,0x15C2,0x1684,0x1713,
	0x16F6,0x16BA,0x16AB,0x1703,0x16F7,0x1711,0x16EB,0x16BD,
	0x16BF,0x1718,0x176D,0x16E7,0x16D3,0x16B9,0x16A8,0x16D5,
	0x16EC,0x1510,0x1681,0x163A,0x1468,0x1463,0x148C,0x1488,
	0x144C,0x13DD,0x13E7,0x1424,0x13AA,0x12CC,0x128E,0x12DF,
	0x12A5,0x11CC,0x1100,0x10AA,0x1020,0x0F7B,0x0F76,0x0FB0,
	0x0F5E,0x0E5E,0x0DE3,0x0D92,0x0CBD,0x0B9F,0x0B22,0x0B9D,
	0x0BFC,0x0BD8,0x0B1F,0x0A09,0x0957,0x0909,0x08C6,0x08D0,
	0x094C,0x092C,0x084B,0x06ED,0x0577,0x04F3,0x04D2,0x0502,
	0x0495,0x04B9,0x047B,0x03F2,0x02B2,0x017D,0x01A0,0x0237,
	0x0243,0x01B1,0x00EC,0x002D,0xFF7B,0xFE64,0xFF0A,0x0148,
	0x00AB,0x0056,0xFFEC,0xFFF7,0xFF7B,0xFE43,0xFD8A,0xFD92,
	0xFD6F,0xFD75,0xFD32,0xFD0C,0xFBB3,0xF9B8,0xF788,0xF411,
	0xEEDB,0xE7F4,0xDFFF,0xD81D,0xCD62,0xC250,0xBFBE,0xBFF8,
	0xCABB,0xE0CC,0xF764,0x09CA,0x1583,0x1A8D,0x1BB9,0x1D26,
	0x1F8C,0x2046,0x1E0A,0x1735,0x0E9C,0x0703,0x0226,0x000F,
	0xFFBF,0x01B5,0x04D8,0x05CC,0x02D2,0xFC71,0xF18B,0xE408,
	0xD740,0xCEFB,0xCC35,0xCE37,0xD137,0xD41A,0xD73D,0xDCBA,
	0xE5FB,0xF2A3,0xFF08,0x0886,0x0F4C,0x1151,0x0EBC,0x09A2,
	0x0430,0x006B,0xFEFB,0xFF91,0x01EC,0x03F6,0x0427,0x0159,
	0xFCCD,0xF8CD,0xF5CB,0xF28D,0xEE0F,0xE7DB,0xDF94,0xD6FE,
	0xCFD2,0xCBF1,0xCD17,0xD2DD,0xD9F5,0xE190,0xE8F4,0xEFA2,
	0xF4E2,0xF81F,0xF9E7,0xFBCE,0xFE0F,0x003E,0x00D0,0xFF56,
	0xFD2B,0xFB35,0xFAA1,0xFBB7,0xFD7D,0xFF9F,0x000B,0xFCFD,
	0xF724,0xF024,0xE99D,0xE3E4,0xDF4E,0xDB96,0xD951,0xD8A0,
	0xD866,0xDA07,0xDCDC,0xE0B3,0xE5C0,0xEACF,0xEF76,0xF37B,
	0xF8AF,0xF8FD,0xF7C0,0xF8A3,0xF87F,0xF94A,0xFB1D,0xFDC7,
	0xFF37,0x007B,0x0046,0xFE4D,0xFBBA,0xF97B,0xF708,0xF48D,
	0xF19C,0xED14,0xE842,0xE322,0xE041,0xDF5C,0xE097,0xE350,
	0xE653,0xE8AB,0xEB14,0xED96,0xEF87,0xF15B,0xF323,0xF560,
	0xF7F4,0xF977,0xF9C9,0xF9EA,0xFADB,0xFC76,0xFE47,0x0033,
	0x019F,0x017F,0xFFFF,0xFDAF,0xFB32,0xF849,0xF463,0xF0FF,
	0xEE88,0xECB0,0xEB17,0xE97F,0xE894,0xE8DD,0xEA19,0xEC4E,
	0xEED0,0xF0FD,0xF284,0xF35A,0xF43B,0xF53B,0xF62B,0xF769,
	0xF77A,0xF7E8,0xFA67,0xFC3B,0xFDF8,0xFE9D,0xFE5C,0xFD8B,
	0xFD4E,0xFD3E,0xFC79,0xFB3E,0xF85C,0xF486,0xF132,0xEEF5,
	0xEE86,0xEEEF,0xEFE7,0xEF4C,0xEF24,0xF044,0xF12A,0xF1DF,
	0xF396,0xF5A6,0xF6D3,0xF816,0xF8F8,0xF9C6,0xFB0E,0xFCC5,
	0xFE3F,0xFF7C,0x0064,0x01E9,0x0326,0x0305,0x027D,0x0160,
	0x0014,0xFE14,0xFBF8,0xFB33,0xFB3C,0xF8EB,0xF692,0xF4EC,
	0xF46F,0xF580,0xF5A9,0xF5E6,0xF652,0xF710,0xF7F0,0xF9A5,
	0xFA2A,0xFB07,0xFC09,0xFD4E,0xFE77,0xFF53,0x0103,0x0209,
	0x0257,0x0212,0x01E8,0x02A2,0x03A3,0x0356,0x01E4,0x0009,
	0xFE13,0xFB60,0xF605,0xEC71,0xDF2D,0xCD53,0xC0A5,0xC0B1,
	0xC045,0xC025,0xC050,0xC1B6,0xC01B,0xD2F5,0x099C,0x31CD,
	0x3F88,0x3F63,0x3FE8,0x4026,0x3FED,0x4011,0x3F57,0x4037,
	0x39E1,0x285C,0x1F61,0x1D41,0x20D1,0x273D,0x2BD7,0x2A62,
	0x2094,0x0D82,0xF224,0xD1E5,0xC080,0xC0A0,0xC015,0xC02B,
	0xC00A,0xC072,0xC0B6,0xCEB1,0xE917,0x0755,0x268E,0x3CFD,
	0x3F57,0x3EE0,0x404B,0x394A,0x30AC,0x2C9C,0x2A90,0x2ABF,
	0x2D44,0x2F95,0x2E82,0x29AB,0x2208,0x18F2,0x0EA2,0x02DA,
	0xF554,0xE51A,0xD138,0xC167,0xBFA8,0xBFF4,0xC036,0xC049,
	0xCCA1,0xE032,0xF10F,0xFFE3,0x0BCA,0x1574,0x1CB2,0x21E4,
	0x254E,0x268A,0x25E8,0x2470,0x223E,0x2033,0x2064,0x22B5,
	0x267B,0x27D3,0x2551,0x1DBD,0x10D9,0x0086,0xEFB3,0xE0F3,
	0xD5EE,0xCE0D,0xC7D4,0xC44A,0xC467,0xC89F,0xD118,0xDCD8,
	0xE98F,0xF541,0xFF46,0x076C,0x0DB6,0x1171,0x14C6,0x155C,
	0x1526,0x1772,0x1B8F,0x2029,0x23B1,0x2517,0x2471,0x2173,
	0x1C6A,0x16C2,0x0FD5,0x06CE,0xFB7F,0xEEF1,0xE369,0xDA67,
	0xD519,0xD2DF,0xD52F,0xDAFB,0xE02C,0xE57F,0xEB23,0xF123,
	0xF724,0xFCC9,0x0136,0x04E9,0x080B,0x0A62,0x0CEE,0x1005,
	0x13CC,0x181C,0x1B00,0x1CE0,0x1DBB,0x1C7E,0x1982,0x1417,
	0x0C29,0x03A0,0xFB48,0xF205,0xEA7E,0xE671,0xE38B,0xE125,
	0xDFF9,0xE0F5,0xE436,0xE8A1,0xED2A,0xF18B,0xF4E4,0xF6AB,
	0xF8EC,0xFBC0,0xFE3E,0x0203,0x05BA,0x0986,0x0D00,0x1018,
	0x12F9,0x14F2,0x15DA,0x1579,0x1336,0x0F2C,0x0A2E,0x04F7,
	0xFECC,0xF811,0xF23B,0xEDD6,0xEAB4,0xE8B7,0xE82C,0xE8C2,
	0xEA85,0xEC72,0xEDB2,0xEF8D,0xF231,0xF519,0xF7DB,0xFA31,
	0xFC6B,0xFF2A,0x0290,0x0644,0x0A40,0x0D5F,0x1012,0x1256,
	0x13D9,0x13AF,0x118B,0x0EA1,0x0B78,0x0765,0x02B7,0xFE2F,
	0xF9D0,0xF623,0xF2A0,0xF08C,0xF057,0xF0FB,0xF1F9,0xF143,
	0xF15C,0xF22D,0xF3BD,0xF5D5,0xF811,0xFA64,0xFBF5,0xFEE1,
	0x02D3,0x0394,0x086F,0x0BCB,0x0D4D,0x0EB5,0x0FAF,0x0F7D,
	0x0F1F,0x0DC6,0x0ACB,0x06E9,0x014B,0xF8D5,0xEBC4,0xDB20,
	0xC7AC,0xBF3D,0xBF6A,0xBF2B,0xBF24,0xBF5E,0xC120,0xBFBC,
	0xDD39,0x1298,0x35AD,0x3EBD,0x3EB5,0x3F21,0x3F3D,0x3F64,
	0x3F36,0x3EFC,0x3F5B,0x3D23,0x303D,0x2936,0x28DF,0x2C20,
	0x3037,0x31DA,0x2DEA,0x21A9,0x0B1E,0xEBEC,0xCA83,0xBFA6,
	0xC02F,0xBFAC,0xBF95,0xC002,0xC025,0xC0F2,0xD1A9,0xEF02,
	0x0F10,0x2CEE,0x3DCC,0x3F1B,0x3F35,0x3F92,0x3A35,0x3276,
	0x2DFB,0x2D81,0x2F44,0x323A,0x3444,0x335A,0x2DC5,0x241D,
	0x186A,0x0C26,0xFFBA,0xF0F0,0xDF2F,0xCAC8,0xBF94,0xBF82,
	0xBF75,0xC019,0xC09A,0xCDD1,0xE188,0xF22E,0xFF9F,0x0BAB,
	0x1601,0x1DF3,0x23A4,0x275C,0x2955,0x2942,0x283A,0x270A,
	0x268C,0x2781,0x2A34,0x2D2F,0x2E09,0x2995,0x1FAC,0x10DE,
	0xFFA2,0xEE34,0xDF49,0xD52B,0xCD05,0xC6F1,0xC40D,0xC5A8,
	0xCB4F,0xD387,0xDDF5,0xE9D7,0xF6F5,0x02EC,0x0B5F,0x0FA1,
	0x11D9,0x13B5,0x156F,0x17BE,0x1C01,0x21CA,0x260D,0x278C,
	0x2787,0x2658,0x2482,0x2060,0x18E2,0x0F4F,0x03E0,0xF820,
	0xEC50,0xE268,0xDA28,0xD496,0xD25B,0xD352,0xD7DF,0xDE6E,
	0xE5E2,0xED05,0xF325,0xF831,0xFC7D,0x004B,0x04E9,0x0918,
	0x0D84,0x1184,0x14FB,0x1813,0x1B3A,0x1E1A,0x205F,0x2094,
	0x1F04,0x1AF0,0x14F4,0x0DA5,0x04E7,0xFBBB,0xF343,0xEBFC,
	0xE687,0xE2B5,0xE0FC,0xE127,0xE30F,0xE55D,0xE89E,0xEC06,
	0xF06C,0xF43B,0xF80E,0xFC66,0xFFE4,0x02A2,0x05B8,0x0940,
	0x0BBE,0x1238,0x16B0,0x18FE,0x1B32,0x1B5F,0x19B2,0x165F,
	0x11FA,0x0CED,0x070C,0x00D7,0xFAAA,0xF564,0xF055,0xEC2E,
	0xE9E2,0xE9C9,0xEA95,0xEBD0,0xEE02,0xF02A,0xF167,0xF299,
	0xF483,0xF71C,0xFA4B,0xFD78,0x00EE,0x04A1,0x0879,0x0BCE,
	0x0EDB,0x110D,0x12DA,0x13D9,0x13FC,0x12FD,0x0FC5,0x0BE4,
	0x06C7,0x0167,0xFCA4,0xF923,0xF695,0xF465,0xF2E4,0xF125,
	0xEFCA,0xEF9F,0xEFCD,0xF0AB,0xF23D,0xF464,0xF667,0xF808,
	0xF97C,0xFAF6,0xFD6C,0x00F3,0x058B,0x0B39,0x0FCF,0x10AF,
	0x11AB,0x11FD,0x1151,0x1091,0x0F03,0x0C5A,0x08C2,0x050D,
	0xFF22,0xF531,0xE64A,0xD300,0xC229,0xBFA4,0xBFC4,0xBF32,
	0xBF58,0xBFBA,0xC10F,0xC2D0,0xEBAA,0x205A,0x3BFF,0x3E9A,
	0x3ED4,0x3F31,0x3F2F,0x3F27,0x3EEE,0x3EAA,0x3F0A,0x3AF4,
	0x2F11,0x2A23,0x29A7,0x2C11,0x2ECE,0x2F5C,0x299D,0x1AC2,
	0x020C,0xE1EA,0xC466,0xBE74,0xBF19,0xBF37,0xBF46,0xBFAE,
	0xBF61,0xC436,0xDA02,0xF717,0x1693,0x331A,0x3E4C,0x3DDB,
	0x3DF7,0x3E50,0x39E3,0x333F,0x304C,0x2FCD,0x3129,0x33F4,
	0x35BE,0x32BE,0x2B9D,0x209F,0x146D,0x085D,0xFB58,0xEC5E,
	0xD9FA,0xC545,0xBE38,0xBEC2,0xBEB9,0xBEA7,0xC13B,0xD22C,
	0xE48F,0xF451,0x01B6,0x0D1F,0x16FD,0x1E95,0x2335,0x257A,
	0x26E1,0x273D,0x265F,0x2508,0x23C3,0x23FA,0x2637,0x28E7,
	0x291B,0x248A,0x1969,0x083A,0xF5E8,0xE59F,0xD80F,0xCE77,
	0xC6D7,0xC1DA,0xC016,0xC23F,0xC889,0xD24C,0xDDF0,0xEAB8,
	0xF6FC,0x01A0,0x0986,0x0E4C,0x1075,0x10F5,0x101C,0x149A,
	0x18FA,0x1E96,0x24F4,0x25AD,0x2413,0x215A,0x1DC2,0x193A,
	0x1333,0x0AD2,0x0065,0xF370,0xE5E3,0xDB11,0xD417,0xD01A,
	0xCF79,0xD21B,0xD79E,0xDE9C,0xE5B5,0xEC4C,0xF128,0xF57C,
	0xFA3C,0xFFFC,0x0608,0x0ADC,0x0DBA,0x0F4F,0x10A5,0x136E,
	0x18C6,0x1E93,0x21DA,0x219E,0x1E32,0x1840,0x10C7,0x08BB,
	0x006C,0xF836,0xF067,0xE9AF,0xE4AA,0xE119,0xDF46,0xDF2B,
	0xE052,0xE330,0xE7FA,0xEE00,0xF328,0xF604,0xF7E7,0xF9DB,
	0xFBF0,0xFFA3,0x04A2,0x097B,0x0DC2,0x11CE,0x1482,0x14F5,
	0x15C1,0x166A,0x14A7,0x118C,0x0D82,0x088E,0x0215,0xFA94,
	0xF3AE,0xEDF5,0xE9B5,0xE76C,0xE69F,0xE73B,0xE88C,0xE9F2,
	0xEB6A,0xED33,0xEDAE,0xEFD2,0xF3EF,0xF74C,0xF9C8,0xFCCF,
	0x0013,0x03D0,0x078F,0x0B8B,0x0F73,0x1248,0x1382,0x137C,
	0x122F,0x1066,0x0D29,0x0866,0x02E8,0xFE3E,0xFAC8,0xF819,
	0xF5DB,0xF2ED,0xF0E5,0xF00D,0xEF01,0xEFCB,0xF125,0xF1F3,
	0xF232,0xF2FE,0xF4B4,0xF754,0xF9E2,0xFCA0,0x0079,0x03E1,
	0x0767,0x0B37,0x0E51,0x10C7,0x1233,0x11BA,0x10DD,0x0F7F,
	0x0E04,0x0BE2,0x084A,0x0355,0xFB9E,0xEFD1,0xE139,0xCFA2,
	0xC192,0xC08A,0xC044,0xC037,0xC058,0xC12A,0xC10F,0xCA4F,
	0xFC12,0x2B19,0x3EB8,0x3F41,0x4004,0x4030,0x402D,0x4019,
	0x3FED,0x3F92,0x401E,0x37B8,0x2BCC,0x286C,0x2958,0x2D1B,
	0x311A,0x30E2,0x282C,0x1593,0xFA06,0xD90B,0xC20A,0xC055,
	0xC032,0xC000,0xC00E,0xC099,0xC059,0xC79F,0xE066,0xFF03,
	0x1E91,0x3796,0x3F55,0x3F3E,0x3F82,0x3F8A,0x3B15,0x3454,
	0x3158,0x32CC,0x338B,0x35C2,0x366F,0x3219,0x2983,0x1E38,
	0x1295,0x06DD,0xF984,0xE953,0xD59E,0xC303,0xBF8B,0xBFF0,
	0xC015,0xBF94,0xC5BB,0xD8ED,0xEA26,0xF8B8,0x0583,0x109F,
	0x19D7,0x2132,0x25E7,0x28AC,0x294D,0x2870,0x2677,0x24CE,
	0x240C,0x256C,0x2873,0x2A80,0x29AD,0x2312,0x15FD,0x046C,
	0xF2C5,0xE35B,0xD764,0xCE83,0xC799,0xC2D4,0xC09B,0xC272,
	0xCA36,0xD5F7,0xE354,0xEFB4,0xFA5B,0x0393,0x0AFC,0x0F92,
	0x120C,0x1316,0x13B6,0x163E,0x1B65,0x2324,0x2799,0x2836,
	0x2632,0x2290,0x1E8D,0x19B5,0x12F5,0x0939,0xFDC5,0xF062,
	0xE3CD,0xD9CC,0xD32D,0xD0BE,0xD0BC,0xD32E,0xD7BA,0xDE48,
	0xE561,0xECA0,0xF332,0xF808,0xFBC4,0x0059,0x04C5,0x0900,
	0x0D4E,0x0FDA,0x120B,0x147A,0x1789,0x1B5D,0x1E56,0x1E3E,
	0x1AF6,0x154E,0x0E04,0x05B5,0xFCCB,0xF434,0xEC17,0xE520,
	0xE0C0,0xDDCC,0xDC40,0xDC91,0xDF19,0xE23C,0xE65E,0xEBB5,
	0xF0C6,0xF412,0xF650,0xF8F7,0xFC33,0xFFC8,0x03DE,0x08DB,
	0x0D2D,0x0F56,0x1184,0x141C,0x16A6,0x16B9,0x1408,0x0FFB,
	0x0AFE,0x05E9,0xFFD9,0xF957,0xF31E,0xEDF5,0xE9B2,0xE70E,
	0xE5A5,0xE5F1,0xE754,0xE8B7,0xEA22,0xEB8F,0xEE21,0xF16E,
	0xF46C,0xF6EE,0xF921,0xFC16,0x003D,0x0403,0x074D,0x0AC1,
	0x0D76,0x0F97,0x1160,0x1298,0x11E2,0x0F45,0x0AB5,0x05A4,
	0x0147,0xFDAB,0xF9C4,0xF5C2,0xF27F,0xF022,0xEE4E,0xEC8D,
	0xEC65,0xEE0C,0xEF61,0xF0FC,0xF1A7,0xF324,0xF47A,0xF6AE,
	0xF942,0xFCA7,0xFF91,0x0311,0x06C1,0x099F,0x0D25,0x10C5,
	0x0FA7,0x0FE2,0x0F3D,0x0E06,0x0CD3,0x0A43,0x04B5,0xFB54,
	0xED9B,0xDCD9,0xC94C,0xBF20,0xBF82,0xBF01,0xBF36,0xBF60,
	0xC0BA,0xBF31,0xD313,0x0906,0x3076,0x3E5F,0x3E94,0x3F3F,
	0x3F66,0x3F62,0x3F43,0x3F04,0x3F2E,0x3E8C,0x347C,0x2C03,
	0x2983,0x2AA1,0x2E76,0x3165,0x300B,0x2569,0x1064,0xF234,
	0xCFF1,0xBFA9,0xC055,0xBFD9,0xBFFA,0xBFEF,0xC04E,0xC051,
	0xCCB8,0xE868,0x07A6,0x2597,0x39DB,0x3F33,0x3F24,0x3FF2,
	0x3CD6,0x3593,0x30A3,0x2E23,0x2E6D,0x31D9,0x34C4,0x3323,
	0x2F1A,0x2646,0x1B2C,0x0E85,0x01B9,0xF37B,0xE2FC,0xCE54,
	0xBFC1,0xBF6A,0xBF3B,0xBF95,0xBF35,0xC849,0xDB8E,0xEC22,
	0xFB01,0x0719,0x1176,0x1A64,0x20C0,0x23EA,0x2486,0x24D1,
	0x2568,0x2575,0x2587,0x2527,0x2694,0x2929,0x2B38,0x296F,
	0x2154,0x1390,0x0275,0xF07E,0xE0AA,0xD488,0xCB79,0xC5A5,
	0xC285,0xC292,0xC809,0xCF27,0xD8ED,0xE4F9,0xF178,0xFCC3,
	0x0547,0x0B31,0x0ECE,0x1089,0x116E,0x13B3,0x17AD,0x1D24,
	0x22F9,0x2763,0x290F,0x27E0,0x23FD,0x1F76,0x1958,0x11C2,
	0x08B5,0xFCBA,0xEF69,0xE313,0xD92F,0xD2CB,0xD083,0xD283,
	0xD679,0xDC4C,0xE267,0xE94F,0xEFDE,0xF567,0xF97B,0xFD8E,
	0x01C6,0x0690,0x0B3E,0x0F07,0x1257,0x146B,0x16CC,0x1A43,
	0x1E42,0x210A,0x20BE,0x1D56,0x1691,0x0D96,0x0463,0xFBF4,
	0xF43B,0xECD0,0xE664,0xE221,0xDF30,0xDE8F,0xDEE6,0xE0E5,
	0xE46B,0xE939,0xEE84,0xF2A4,0xF59D,0xF8F6,0xFB90,0xFDBE,
	0x009B,0x053F,0x0B45,0x103A,0x133C,0x1591,0x17B4,0x178C,
	0x18BD,0x172B,0x1243,0x0D66,0x079F,0x0072,0xF9D1,0xF402,
	0xEEEA,0xEAE8,0xE8B0,0xE85D,0xE94D,0xEA13,0xEAF2,0xEC91,
	0xEE83,0xF091,0xF2D8,0xF598,0xF936,0xFC4F,0xFF46,0x0220,
	0x05D3,0x0A44,0x0E0B,0x10EF,0x134F,0x1461,0x1481,0x128B,
	0x0F9D,0x0B64,0x067F,0x01E2,0xFD8C,0xF9F6,0xF6F9,0xF442,
	0xF106,0xEE28,0xECEC,0xED74,0xEEE0,0xF0B7,0xF19B,0xF1AA,
	0xF244,0xF409,0xF681,0xF940,0xFC22,0xFF5A,0x03C7,0x0766,
	0x0A77,0x0C93,0x0DB3,0x0DE4,0x0F3E,0x101C,0x0E15,0x0C06,
	0x0965,0x04DD,0xFE49,0xF42C,0xE69D,0xD677,0xC4A8,0xBF8E,
	0xBFF6,0xBF76,0xBFA0,0xBFF7,0xC145,0xC10A,0xDFD5,0x1564,
	0x36B9,0x3F51,0x3F1D,0x3F42,0x3F03,0x3F77,0x3F1A,0x3EB0,
	0x3F34,0x3BEE,0x2EDE,0x2756,0x269A,0x2951,0x2CE5,0x2EBD,
	0x2AB3,0x1D1D,0x0591,0xE5BA,0xC6DA,0xBEE3,0xBF7F,0xBEBE,
	0xBEFC,0xBF09,0xBEEC,0xBFB6,0xCF6B,0xECFB,0x0E10,0x2BC0,
	0x3D24,0x3E8E,0x3E68,0x3F0D,0x3A95,0x3358,0x2FBE,0x2EBC,
	0x2F53,0x31A8,0x3414,0x32EA,0x2CAF,0x21C8,0x157F,0x098B,
	0xFDAA,0xEFA9,0xDD54,0xC747,0xBE14,0xBECE,0xBE9A,0xBECA,
	0xBF69,0xCE4C,0xE0D9,0xEFF8,0xFD27,0x095E,0x1497,0x1C8D,
	0x21B1,0x2497,0x262B,0x2683,0x2608,0x250C,0x2401,0x2452,
	0x261D,0x28DB,0x2A66,0x27A3,0x1D0D,0x0CC1,0xFA1D,0xE90C,
	0xDB0A,0xD086,0xC8DF,0xC3FE,0xC12A,0xC179,0xC630,0xCF51,
	0xDBA7,0xE878,0xF469,0xFEAE,0x0752,0x0C80,0x0EA0,0x106A,
	0x1293,0x1549,0x197E,0x1EE8,0x23B3,0x25A8,0x2775,0x248E,
	0x1F9A,0x1C03,0x153F,0x0CEE,0x02AC,0xF649,0xE8A4,0xDD0A,
	0xD418,0xCFF9,0xCFCA,0xD2CD,0xD6DA,0xDBE4,0xE21A,0xE887,
	0xEF0E,0xF528,0xFA92,0xFEA9,0x02BA,0x0702,0x0B4F,0x0EED,
	0x1227,0x14FC,0x1811,0x1B5C,0x1DD0,0x1F42,0x1DE0,0x198A,
	0x1241,0x0974,0x004E,0xF83C,0xF098,0xE9B5,0xE46C,0xE09B,
	0xDE82,0xDE00,0xDF3F,0xE29B,0xE7CA,0xEC76,0xF01F,0xF363,
	0xF644,0xF94C,0xFC77,0xFFFD,0x0492,0x0942,0x0D33,0x1111,
	0x150E,0x17D0,0x197A,0x19C7,0x18B7,0x15A1,0x0FE4,0x09D5,
	0x0446,0xFD4D,0xF5EA,0xEF88,0xEB6F,0xE934,0xE835,0xE879,
	0xE877,0xE83E,0xE8B2,0xEA5D,0xED84,0xF16C,0xF4F8,0xF7ED,
	0xF9BB,0xFAAC,0xFD8F,0x0265,0x0790,0x0BF2,0x0F81,0x11F0,
	0x132B,0x1365,0x12E6,0x10B9,0x0DE7,0x09ED,0x05C1,0x01C5,
	0xFD51,0xF8EB,0xF4FE,0xF13F,0xEEE4,0xEE2D,0xEEA7,0xEFA9,
	0xF11A,0xF218,0xF2EB,0xF25F,0xF3EF,0xF640,0xF88E,0xFB7F,
	0xFEF0,0x0301,0x066A,0x08B5,0x0B68,0x0E55,0x1004,0x10FE,
	0x11D8,0x11B0,0x1011,0x0CA6,0x077A,0x0294,0xFD6B,0xF610,
	0xEB7E,0xDEBC,0xCFA3,0xC265,0xC07B,0xC09C,0xC087,0xC121,
	0xC0B0,0xCB9E,0xF1EF,0x143D,0x2BE4,0x38E5,0x3EDB,0x4017,
	0x4017,0x4042,0x3FDD,0x402A,0x3AB0,0x2D2C,0x23D5,0x1F7E,
	0x1F77,0x2258,0x2534,0x2488,0x1E86,0x11B4,0xFE62,0xE6F5,
	0xCFC0,0xC1B1,0xC051,0xC048,0xC03F,0xC04B,0xC636,0xD157,
	0xE0C9,0xF647,0x0DDE,0x22D8,0x3078,0x350E,0x327E,0x2DA3,
	0x2898,0x25CF,0x24E6,0x251D,0x2653,0x288C,0x2756,0x241C,
	0x20E5,0x18DF,0x0FCD,0x06C7,0xFCF7,0xF174,0xE325,0xD330,
	0xC558,0xC045,0xC010,0xC53D,0xD12A,0xDE34,0xEAAF,0xF57C,
	0xFEDB,0x0774,0x1025,0x1736,0x1B10,0x1CBB,0x1D50,0x1D5B,
	0x1CE6,0x1D48,0x1D66,0x1E2C,0x1F79,0x2057,0x1F43,0x1B58,
	0x13AD,0x07FB,0xFA18,0xED82,0xE458,0xDCD3,0xD75F,0xD3B5,
	0xD1C3,0xD229,0xD660,0xDE48,0xE81A,0xF185,0xF8A0,0xFE73,
	0x03E7,0x088A,0x0B98,0x0D99,0x0E4E,0x0F6C,0x11F5,0x1550,
	0x1869,0x1AD3,0x1C1B,0x1B45,0x19D4,0x1516,0x0F03,0x0934,
	0x0124,0xF78C,0xEDB8,0xE53D,0xDFFF,0xDD4A,0xDD40,0xDF02,
	0xE230,0xE591,0xE98F,0xEE49,0xF3F5,0xF8FB,0xFC1A,0xFDF2,
	0x008A,0x04CB,0x085B,0x0B03,0x0DF8,0x10A0,0x1285,0x1456,
	0x1573,0x15C7,0x1491,0x1129,0x0C37,0x05D8,0xFF1F,0xF8CD,
	0xF267,0xECFB,0xE913,0xE661,0xE55F,0xE522,0xE608,0xE8B2,
	0xEBF1,0xEDED,0xF07A,0xF476,0xF78A,0xFA30,0xFCB8,0xFFC0,
	0x02C9,0x05E4,0x08B2,0x0B81,0x0E3E,0x100E,0x10D4,0x106D,
	0x0DE4,0x0BC0,0x0944,0x0557,0x005C,0xFADC,0xF627,0xF2B6,
	0xEFE5,0xED7C,0xEC1A,0xEBCC,0xEB7C,0xEBA0,0xED33,0xEFAD,
	0xF1DD,0xF2F5,0xF3D3,0xF598,0xF86A,0xFBA6,0xFF06,0x01F8,
	0x0486,0x06E3,0x0904,0x0AA7,0x0C6E,0x0DEA,0x0D7B,0x0B71,
	0x088B,0x05C4,0x0267,0xFE95,0xFB63,0xF909,0xF720,0xF5C2,
	0xF43E,0xF338,0xF262,0xF1B0,0xF1C7,0xF23A,0xF3A0,0xF527,
	0xF666,0xF856,0xFA3B,0xFB7D,0xFD9D,0x000F,0x0342,0x0660,
	0x08FF,0x0A7B,0x0AF2,0x0A79,0x0912,0x089E,0x08EB,0x052E,
	0x039F,0x012A,0xFD7C,0xF9D3,0xF5C3,0xF0C2,0xEBB9,0xE7ED,
	0xE56C,0xE4B9,0xE580,0xE9F0,0xEFC6,0xF5D8,0xFBB0,0x012C,
	0x05B8,0x08EC,0x0B42,0x0CA9,0x0DC0,0x0E6A,0x0E26,0x0D5C,
	0x0D29,0x0CCD,0x0CE3,0x0C1A,0x0B71,0x0AA9,0x097C,0x0787,
	0x048D,0x014E,0xFDDA,0xFA55,0xF718,0xF516,0xF441,0xF345,
	0xF252,0xF17F,0xF0DD,0xF08A,0xF02B,0xF103,0xF21E,0xF393,
	0xF47E,0xF531,0xF5F6,0xF6C2,0xF705,0xF789,0xF7BB,0xF721,
	0xF722,0xF703,0xF722,0xF677,0xF492,0xF21C,0xEF58,0xEE9B,
	0xEDB7,0xECD3,0xEC54,0xEB10,0xEA60,0xE9B2,0xE987,0xE937,
	0xE930,0xE92A,0xE8B3,0xE855,0xE85F,0xE893,0xE84D,0xE8B4,
	0xE809,0xE744,0xE82E,0xE8C9,0xE8BF,0xE8C1,0xE8DB,0xE8C1,
	0xE895,0xE8D4,0xE8C2,0xE894,0xE874,0xE7E2,0xE737,0xE6C9,
	0xE6D8,0xE6F7,0xE789,0xE793,0xE786,0xE7AC,0xE7F6,0xE7FA,
	0xE7B7,0xE8DF,0xE96B,0xE8EB,0xE93B,0xE99E,0xEA00,0xEAC2,
	0xEB7B,0xEC43,0xED27,0xEDC4,0xEF2D,0xF01A,0xF015,0xF039,
	0xF137,0xF149,0xF153,0xF192,0xF19E,0xF21F,0xF249,0xF23A,
	0xF295,0xF2C5,0xF324,0xF2EE,0xF2F3,0xF32B,0xF3A4,0xF3DA,
	0xF3EE,0xF4D7,0xF507,0xF57C,0xF647,0xF722,0xF7CA,0xF842,
	0xF8A7,0xF90A,0xF9C2,0xF9EC,0xFA85,0xFB17,0xFB31,0xFB9A,
	0xFBFD,0xFC51,0xFC56,0xFC8F,0xFCF4,0xFD5C,0xFD71,0xFD0E,
	0xFD30,0xFD3D,0xFDDD,0xFE3C,0xFE64,0xFED6,0xFF61,0xFFC7,
	0x0023,0x006B,0x00A5,0x0134,0x01B7,0x024C,0x02F3,0x02E1,
	0x0310,0x03D2,0x041E,0x047B,0x0564,0x061A,0x04CB,0x06B6,
	0x06DB,0x05D4,0x0635,0x0681,0x0777,0x07CE,0x0808,0x0828,
	0x080C,0x07B4,0x07BE,0x07BC,0x07D9,0x0873,0x0889,0x08FC,
	0x0923,0x092B,0x0908,0x0970,0x0985,0x0A1D,0x0A5B,0x0A97,
	0x0AFE,0x0AE3,0x0AE3,0x0AF6,0x0B33,0x0B66,0x0B7D,0x0BEC,
	0x0C1C,0x0BDF,0x0C05,0x0BC2,0x0B88,0x0BE0,0x0C74,0x0CB1,
	0x0CC4,0x0CB7,0x0D11,0x0C93,0x0C7A,0x0C9F,0x0C2F,0x0C81,
	0x0CEE,0x0CAB,0x0C8A,0x0CA2,0x0D4C,0x0D41,0x0D4E,0x0D55,
	0x0D66,0x0DBD,0x0E03,0x0F72,0x1115,0x1041,0x1004,0x101C,
	0x1026,0x0FEE,0x0FAC,0x0FBB,0x0F58,0x0F45,0x0F43,0x0F69,
	0x0F88,0x0FAA,0x0F51,0x0F03,0x0EAE,0x0EAA,0x0E4E,0x0DD0,
	0x0EC9,0x0F64,0x0E86,0x0E28,0x0E59,0x0DE3,0x0DB3,0x0DDD,
	0x0DBC,0x0D5E,0x0D53,0x0D64,0x0CED,0x0CCC,0x0CB2,0x0CCC,
	0x0CB5,0x0CF8,0x0CF5,0x0D0E,0x0CA8,0x0C6C,0x0C5D,0x0C48,
	0x0BE0,0x0B0F,0x0BE6,0x0C9B,0x0C8D,0x0C56,0x0C1F,0x0BBE,
	0x0B92,0x0B5B,0x0B42,0x0B16,0x0AC8,0x09FB,0x0987,0x08F4,
	0x0853,0x08D5,0x0901,0x08C6,0x08A2,0x0865,0x080F,0x081C,
	0x0824,0x082F,0x0861,0x087A,0x0867,0x086F,0x081C,0x0803,
	0x07D9,0x0815,0x0829,0x0830,0x0824,0x07EB,0x07F8,0x07BC,
	0x076F,0x071A,0x06EE,0x0746,0x0748,0x0737,0x072D,0x06EE,
	0x06C4,0x06AB,0x06B3,0x06E0,0x06C1,0x0686,0x0684,0x0687,
	0x068E,0x0674,0x0627,0x0674,0x068D,0x0655,0x0647,0x060A,
	0x05AB,0x05A2,0x0574,0x05B4,0x0592,0x0569,0x05DC,0x05EA,
	0x05BD,0x0585,0x057B,0x0584,0x04D2,0x06AB,0x0644,0x04FE,
	0x0606,0x05A3,0x05EE,0x0612,0x05A6,0x0557,0x0576,0x0536,
	0x050E,0x0519,0x050F,0x04D6,0x0501,0x0519,0x04E4,0x048A,
	0x0430,0x046D,0x0479,0x04A6,0x049A,0x046D,0x047E,0x04AE,
	0x04BF,0x049C,0x046F,0x048B,0x048F,0x044B,0x0422,0x03EA,
	0x042E,0x0444,0x03C8,0x0429,0x0438,0x03E9,0x0392,0x0385,
	0x041D,0x043B,0x040A,0x0450,0x048D,0x0446,0x0398,0x03F6,
	0x040B,0x03A4,0x03D5,0x038E,0x03FC,0x03B9,0x0354,0x0348,
	0x0351,0x033F,0x02F2,0x02CD,0x0241,0x00AF,0xFFB7,0xFFC0,
	0xFFA5,0xFF91,0xFF8C,0xFFD6,0x004D,0x00AA,0x00BC,0x009D,
	0x00F0,0x012F,0x0110,0x00FF,0x018D,0x020C,0x02DC,0x03ED,
	0x0470,0x053A,0x064A,0x0743,0x080E,0x0899,0x08DC,0x08C2,
	0x08CA,0x08E8,0x08B3,0x08FB,0x096D,0x0988,0x0981,0x09BB,
	0x0A05,0x0A51,0x0A48,0x0A5A,0x0A5E,0x0AFB,0x0BC6,0x0CA9,
	0x0D10,0x0EA6,0x10CD,0x1050,0x103F,0x1076,0x112B,0x11A9,
	0x122E,0x12A0,0x1320,0x13B3,0x1416,0x1492,0x1505,0x1593,
	0x1621,0x160E,0x15C6,0x1571,0x14F1,0x146A,0x154B,0x1640,
	0x1614,0x163A,0x1730,0x1737,0x1676,0x166D,0x1639,0x1633,
	0x15EC,0x1528,0x147B,0x1429,0x13EE,0x1463,0x144B,0x14ED,
	0x1511,0x1465,0x13B0,0x136C,0x12FF,0x12DA,0x1229,0x10F4,
	0x11C7,0x124D,0x11F3,0x1160,0x10C2,0x1087,0x1074,0x0FCF,
	0x0F02,0x0EF3,0x0DBB,0x0CB4,0x0C82,0x0BD6,0x0C08,0x0C49,
	0x0BE7,0x0BA6,0x0B0A,0x0A20,0x08E6,0x07F6,0x07ED,0x0808,
	0x086C,0x0851,0x07CC,0x0761,0x0713,0x066C,0x0540,0x0514,
	0x04C1,0x0442,0x03BA,0x02AB,0x01FB,0x0173,0x00D3,0xFFC0,
	0xFE2A,0xFBA0,0xF78D,0xF1F4,0xEABD,0xE27A,0xD9A2,0xD226,
	0xCDC8,0xCE26,0xD3EB,0xDF50,0xEDED,0xFDFF,0x0D1D,0x183E,
	0x1E49,0x1EB9,0x1A27,0x12D3,0x09F4,0x017B,0xFC1F,0xFA88,
	0xFCD4,0x0359,0x0CA4,0x178B,0x21C2,0x2941,0x2C4B,0x2A18,
	0x22EB,0x1759,0x090C,0xFDBC,0xF115,0xE83C,0xE4D5,0xE30D,
	0xE468,0xE6D6,0xE9CC,0xEBBC,0xEDB0,0xEE51,0xEDA4,0xEC22,
	0xEA73,0xE7DD,0xE58B,0xE41E,0xE3D0,0xE3D6,0xE4DC,0xE7CF,
	0xEAAE,0xEE6C,0xF28F,0xF69E,0xFB06,0x0010,0x051B,0x09E9,
	0x0D89,0x0F49,0x0F0B,0x0C80,0x07FD,0x0306,0xFE0C,0xF99A,
	0xF6DE,0xF5B3,0xF606,0xF7D2,0xF9D8,0xFB4C,0xFBE1,0xFBA4,
	0xF9BE,0xF5B6,0xF058,0xEA00,0xE3C1,0xDDBF,0xD97C,0xD780,
	0xD8D8,0xDCA3,0xE134,0xE5AB,0xEA93,0xEECE,0xF12F,0xF1DA,
	0xF184,0xF16E,0xF0C7,0xEDDC,0xED6E,0xEEEB,0xF01D,0xF20D,
	0xF45A,0xF750,0xF9EA,0xFCAC,0xFE98,0x0045,0x00BB,0x002D,
	0xFF5B,0xFD57,0xFAAE,0xF7D9,0xF558,0xF33C,0xEFBB,0xED33,
	0xEBB0,0xEA10,0xE969,0xE940,0xE9B2,0xEADC,0xEBF6,0xEC46,
	0xEBC5,0xEB2E,0xEA2E,0xE8B1,0xE725,0xE604,0xE57F,0xE65F,
	0xE7D3,0xE98A,0xECA8,0xF096,0xF3F3,0xF66B,0xF975,0xFC49,
	0xFC1D,0xFB92,0xFB0D,0xFA88,0xFA43,0xFA40,0xF9E1,0xF9AF,
	0xFA75,0xFACE,0xFB8C,0xFB87,0xFB9F,0xFC0F,0xFB93,0xF9F7,
	0xF88B,0xF724,0xF578,0xF3B2,0xF191,0xEF8C,0xEE3E,0xEDE1,
	0xECAD,0xEC41,0xEC22,0xED27,0xEE58,0xEF26,0xF099,0xF211,
	0xF323,0xF32E,0xF2D3,0xF277,0xF2E8,0xF388,0xF471,0xF596,
	0xF6E2,0xF84E,0xF975,0xFA85,0xFBCA,0xFCBC,0xFD64,0xFD8C,
	0xFDD4,0xFD1F,0xFC1D,0xFAD7,0xF9E5,0xF8DC,0xF7EF,0xF775,
	0xF728,0xF6D2,0xF67D,0xF614,0xF567,0xF503,0xF4A2,0xF411,
	0xF3F4,0xF3C5,0xF31C,0xF2C2,0xF264,0xF12C,0xF176,0xF26F,
	0xF2FD,0xF3F5,0xF599,0xF4F3,0xF5E7,0xF8F3,0xF8A9,0xF9C7,
	0xFB48,0xFC4F,0xFC8E,0xFBE0,0xFBBF,0xFBA6,0xFB56,0xFAF6,
	0xFC1D,0xFD5D,0xFE6B,0xFF4F,0xFFC0,0xFFBB,0xFF55,0xFE99,
	0xFD4D,0xFB7D,0xF91E,0xF510,0xEF0D,0xE722,0xDCEB,0xCF84,
	0xC1D3,0xBF2D,0xBF94,0xBF34,0xBF46,0xBF79,0xC040,0xC0A2,
	0xD90E,0x01AC,0x2535,0x3BE9,0x3EBC,0x3E5C,0x3E2F,0x2EC3,
	0x18F0,0x07A5,0xFD89,0xFD3B,0x0729,0x199D,0x3312,0x3F54,
	0x3EB7,0x3F29,0x3F44,0x3EBE,0x3E90,0x3BD4,0x2255,0x0315,
	0xEAAA,0xDBA0,0xD315,0xD18F,0xD544,0xDC2F,0xE364,0xE8A7,
	0xEC0B,0xEBE5,0xE918,0xE513,0xE012,0xDA18,0xD566,0xD331,
	0xD2B7,0xD50B,0xD965,0xE017,0xE7B2,0xF115,0xFC71,0x07C8,
	0x13CE,0x2110,0x2D65,0x3765,0x3E01,0x3F0A,0x3E03,0x36AC,
	0x2CD1,0x21F7,0x173A,0x0E86,0x0958,0x07E2,0x0940,0x0D15,
	0x1295,0x16E8,0x17B2,0x14BE,0x0E33,0x02C4,0xF30E,0xE2A7,
	0xD479,0xC8EB,0xC20D,0xBFCB,0xC2EF,0xCA81,0xD4D7,0xE021,
	0xEA23,0xF20F,0xF727,0xFA19,0xFAD3,0xF99F,0xF896,0xF784,
	0xF7FC,0xF9DD,0xFDC7,0x0331,0x09DC,0x1132,0x1865,0x1E60,
	0x2296,0x24C0,0x2591,0x23FC,0x20B9,0x1C2B,0x161F,0x0FBA,
	0x088A,0x01A9,0xFB34,0xF546,0xF0D5,0xEDFB,0xEC42,0xEB99,
	0xEBD6,0xECD4,0xECFE,0xECEB,0xEBE2,0xE9CB,0xE6C7,0xE3A9,
	0xE051,0xDE07,0xDDBF,0xDF73,0xE2D3,0xE7C4,0xEF1F,0xF74F,
	0xFF7E,0x0693,0x0C19,0x0FDA,0x11DC,0x1212,0x1106,0x0F5E,
	0x0D51,0x0C2D,0x0AE9,0x0B02,0x0C03,0x0D82,0x0E71,0x0EEF,
	0x0FA4,0x0E82,0x0DBA,0x0BAB,0x0552,0x0141,0xFBBD,0xF681,
	0xF1ED,0xEE70,0xEB9A,0xEA2D,0xE968,0xE9E4,0xEB1B,0xECCE,
	0xEF12,0xF0D3,0xF2EF,0xF4A1,0xF63B,0xF730,0xF7FF,0xF904,
	0xFA3E,0xFB8A,0xFDA7,0x0017,0x0299,0x0616,0x0910,0x0BBC,
	0x0E25,0x1091,0x1224,0x12D0,0x12C9,0x1241,0x109C,0x0E95,
	0x0C51,0x09CE,0x0790,0x0525,0x02C7,0x00B6,0xFF0E,0xFDF8,
	0xFCF8,0xFBF5,0xFB4C,0xFA40,0xF8DE,0xF784,0xF5B4,0xF421,
	0xF35C,0xF2A5,0xF268,0xF20D,0xF2BC,0xF463,0xF654,0xF897,
	0xFB21,0xFDBD,0xFF5A,0xFF7E,0x01B0,0x0355,0x0465,0x0489,
	0x049A,0x04B6,0x0590,0x066A,0x069D,0x0754,0x0866,0x08DF,
	0x093F,0x08C2,0x0800,0x06D8,0x054F,0x01DC,0xFCAD,0xF7A3,
	0xF031,0xE555,0xD797,0xC721,0xBF5F,0xBFE3,0xBF84,0xBF7A,
	0xBFBD,0xC02D,0xC108,0xC1B8,0xE113,0x1032,0x34B7,0x3FBD,
	0x3F06,0x3F3B,0x400C,0x33FC,0x1B91,0x0B20,0x044F,0x0672,
	0x132C,0x2C72,0x3ECF,0x3F6F,0x3FE4,0x400C,0x4008,0x3FB1,
	0x3F28,0x3F7A,0x2897,0x05EC,0xEC6B,0xDB08,0xD26E,0xD257,
	0xD6AD,0xDDD1,0xE487,0xE971,0xEB8E,0xEA8C,0xE70E,0xE186,
	0xDB2E,0xD4DA,0xCFBF,0xCD49,0xCD5B,0xD011,0xD5DC,0xDDAF,
	0xE743,0xF2F6,0x0045,0x0E9C,0x1DEC,0x2DB7,0x3C34,0x4045,
	0x3FFA,0x4023,0x3FDF,0x3FCE,0x3646,0x285F,0x1D1F,0x14AA,
	0x106E,0x105F,0x13FB,0x18C3,0x1D96,0x20C5,0x2041,0x1AEF,
	0x105D,0x01C9,0xF05D,0xDE94,0xCD40,0xC1B7,0xC049,0xC098,
	0xC01B,0xC615,0xD312,0xDFDA,0xEA44,0xF25F,0xF87A,0xFAF9,
	0xFB2C,0xFA9B,0xF9C7,0xF80E,0xFBB0,0xFF1B,0x0331,0x0AB0,
	0x12C0,0x1AFC,0x2250,0x2871,0x2D08,0x2F00,0x2E4F,0x2C4D,
	0x2862,0x2399,0x1D3D,0x15E6,0x0E29,0x062E,0xFE3A,0xF700,
	0xF148,0xEDCB,0xEC5C,0xEC8C,0xED61,0xEDC9,0xED91,0xECFA,
	0xEA47,0xE70C,0xE3A2,0xE027,0xDD0F,0xDB2A,0xDAE6,0xDD41,
	0xE218,0xE8C0,0xF1C3,0xFB48,0x0496,0x0C2A,0x1181,0x14E2,
	0x16A8,0x1695,0x159A,0x1460,0x12EC,0x11A4,0x112D,0x10EB,
	0x1175,0x12C8,0x13EF,0x149A,0x1484,0x133F,0x10DC,0x0CF5,
	0x095B,0x053A,0xFE76,0xF822,0xF2C1,0xEEB9,0xEB11,0xE8A6,
	0xE71F,0xE6F4,0xE87E,0xEAAA,0xED80,0xF03C,0xF2C4,0xF47B,
	0xF5C3,0xF63A,0xF6B9,0xF7B3,0xF8C8,0xFB63,0xFDC9,0xFFDC,
	0x030B,0x0710,0x0A44,0x0E01,0x11A9,0x148C,0x170C,0x177F,
	0x1676,0x14A0,0x11E2,0x0E87,0x0AB2,0x076B,0x04FF,0x027B,
	0x00E5,0xFF88,0xFDFC,0xFC85,0xFB6A,0xF98B,0xF717,0xF629,
	0xF4CB,0xF2CA,0xF073,0xEE29,0xED0C,0xEC71,0xECDD,0xED99,
	0xEED3,0xF01C,0xF1E8,0xF4A7,0xF72E,0xFA0C,0xFD4A,0x0028,
	0x029B,0x041A,0x0536,0x05E9,0x0657,0x0695,0x0669,0x070D,
	0x07F1,0x0884,0x0954,0x09D3,0x0A03,0x0961,0x08C7,0x0703,
	0x041A,0xFF74,0xF86D,0xEE9D,0xE279,0xD2EE,0xC1EA,0xBE1E,
	0xBE9B,0xBE50,0xBE3E,0xBE4C,0xBF3C,0xBF1A,0xC476,0xEABB,
	0x17CA,0x37D7,0x3E24,0x3DB2,0x3DFA,0x3C42,0x2827,0x123D,
	0x03D5,0xFF1F,0x05F1,0x177E,0x32E3,0x3EC5,0x3DF9,0x3E7A,
	0x3EB8,0x3E89,0x3DEB,0x3DF8,0x3B2C,0x1E50,0xFC5C,0xE486,
	0xD54C,0xCEBB,0xD1B6,0xD5FD,0xDCB1,0xE3DF,0xE781,0xE83C,
	0xE65B,0xE28A,0xDC3B,0xD54D,0xCEB9,0xC9E0,0xC77D,0xC824,
	0xCBCD,0xD2FD,0xDBBF,0xE642,0xF2CE,0x00E2,0x1056,0x1FEC,
	0x2F4B,0x3C1F,0x3F53,0x3F18,0x3F16,0x3F56,0x3C85,0x3042,
	0x2356,0x18C5,0x11C4,0x0F39,0x1055,0x149B,0x19F9,0x1E94,
	0x20D6,0x1ED0,0x1775,0x0BA1,0xFC48,0xEA3F,0xD87E,0xC850,
	0xC06C,0xC010,0xC005,0xC000,0xC7B7,0xD4AE,0xE0A8,0xEA28,
	0xF123,0xF589,0xF782,0xF763,0xF6E5,0xF664,0xF74B,0xF9BC,
	0xFD62,0x0270,0x07DC,0x0F73,0x1855,0x1FD5,0x2687,0x2B54,
	0x2D26,0x2D2D,0x2ACF,0x2663,0x20F8,0x1A79,0x1324,0x0B56,
	0x035F,0xFB9E,0xF4DC,0xF04E,0xED25,0xEAA4,0xEA8A,0xEC2F,
	0xECDB,0xEC9A,0xEB44,0xE88B,0xE517,0xE111,0xDCFA,0xDA48,
	0xD950,0xD9D8,0xDCCF,0xE1EB,0xE98A,0xF2B9,0xFC0B,0x04F4,
	0x0CA5,0x1368,0x171E,0x17D0,0x1709,0x16B5,0x148C,0x119C,
	0x107D,0x111A,0x127F,0x140C,0x1581,0x16A6,0x1748,0x16EB,
	0x14F3,0x11DB,0x0DD6,0x0864,0x02A6,0xFC9C,0xF6D2,0xF21C,
	0xEE67,0xEB84,0xE999,0xE8BF,0xE8B0,0xE973,0xEAD9,0xECD9,
	0xEED9,0xF104,0xF334,0xF569,0xF718,0xF84F,0xF9B0,0xFB1B,
	0xFC60,0xFDF6,0x0081,0x0385,0x073B,0x0B9B,0x0FC7,0x13C0,
	0x1695,0x1834,0x18F2,0x180B,0x15DC,0x1355,0x1086,0x0D4F,
	0x0A2C,0x0726,0x04E4,0x02BC,0x016D,0x0014,0xFEC2,0xFD77,
	0xFBD1,0xF9E8,0xF7BC,0xF4FD,0xF273,0xF091,0xEF38,0xEEAC,
	0xEE92,0xEF6F,0xF060,0xF1AA,0xF2D6,0xF595,0xF8D7,0xFB4C,
	0xFE04,0x01E2,0x0343,0x0568,0x08AC,0x08B1,0x0909,0x09A0,
	0x09F2,0x0A2C,0x0ADC,0x0C09,0x0D4D,0x0DC4,0x0E1C,0x0DFC,
	0x0DBA,0x0C95,0x0B32,0x091F,0x0585,0xFF89,0xF73B,0xEC65,
	0xDF65,0xCE68,0xC075,0xBF81,0xBF5D,0xBF36,0xBF51,0xBF47,
	0xC094,0xBF9D,0xCCE9,0xF9EA,0x24DB,0x3CE0,0x3EBB,0x3E76,
	0x3F33,0x3A94,0x243A,0x104E,0x04EC,0x038A,0x0D6A,0x22A0,
	0x3AFA,0x3F76,0x3EF0,0x3F5C,0x3F6D,0x3F25,0x3E2E,0x3F30,
	0x36C0,0x1403,0xF555,0xDF92,0xD313,0xCF96,0xD2F4,0xD98A,
	0xE1B6,0xE6A9,0xE914,0xE972,0xE69F,0xE19E,0xDBCB,0xD582,
	0xCF0A,0xCA51,0xC887,0xCA5A,0xCEFB,0xD61D,0xDF11,0xEA20,
	0xF6F5,0x0504,0x142F,0x2383,0x33FE,0x3F4F,0x3F61,0x3F36,
	0x3F19,0x3F85,0x3A13,0x2BD3,0x1EF8,0x1519,0x0F7B,0x0E1A,
	0x1029,0x146B,0x1900,0x1D1F,0x1E11,0x1AFC,0x12F8,0x05DB,
	0xF4DF,0xE24C,0xD029,0xC22F,0xBF18,0xBEEA,0xBEB8,0xC06E,
	0xCAD0,0xD71D,0xE211,0xEB4C,0xF162,0xF4C9,0xF68F,0xF660,
	0xF596,0xF529,0xF60D,0xF82C,0xFBC2,0x023B,0x0A09,0x128B,
	0x1ACD,0x2233,0x2790,0x29F5,0x2A95,0x2A38,0x2806,0x243E,
	0x1F48,0x18C5,0x1142,0x0808,0xFEDA,0xF685,0xF049,0xEB88,
	0xE8AF,0xE821,0xE8C3,0xE9F3,0xEA6B,0xE9F3,0xE89F,0xE5AC,
	0xE1EB,0xDDF5,0xD9F9,0xD75E,0xD62F,0xD700,0xDA05,0xE023,
	0xE86C,0xF1B9,0xFB5A,0x0447,0x0BBB,0x10D0,0x13C4,0x1439,
	0x1362,0x120F,0x10A1,0x0F6F,0x0EE4,0x0F32,0x1018,0x113C,
	0x1246,0x1245,0x1221,0x1155,0x0F28,0x0BBE,0x0754,0x0244,
	0xFBB9,0xF6CA,0xF2F3,0xEC3D,0xE98E,0xE6EA,0xE4A1,0xE3DD,
	0xE3EA,0xE469,0xE672,0xE906,0xEBCE,0xEEF9,0xF1A7,0xF3F8,
	0xF58B,0xF690,0xF734,0xF82A,0xF9E0,0xFC89,0xFF6F,0x02DF,
	0x06F6,0x0ABE,0x0E83,0x119E,0x1474,0x15D9,0x1685,0x164C,
	0x1442,0x11A5,0x0E8E,0x0AB1,0x06D8,0x0426,0x020E,0x0069,
	0xFF3C,0xFDC8,0xFC37,0xFAF8,0xF942,0xF7C9,0xF59B,0xF3DC,
	0xF241,0xF01E,0xEE7F,0xEDC2,0xED77,0xEDBA,0xEE83,0xEFF4,
	0xF32E,0xF708,0xFA29,0xFC61,0xFF03,0x016F,0x02FD,0x042E,
	0x05A0,0x0662,0x05FB,0x07B5,0x0897,0x08D4,0x0976,0x09CE,
	0x0A25,0x0AF6,0x0C10,0x0BE1,0x0AD1,0x0963,0x07DA,0x04D9,
	0x0077,0xFAA3,0xF2F0,0xE94C,0xDBB6,0xC8C3,0xBF2F,0xBFCC,
	0xBF59,0xBF33,0xBF70,0xBFB6,0xC0D5,0xC015,0xD656,0x0557,
	0x2D51,0x3EE3,0x3ECC,0x3EF9,0x3FD9,0x3597,0x1DFB,0x0C19,
	0x029C,0x0410,0x1110,0x29CE,0x3E80,0x402D,0x406C,0x400A,
	0x3FD7,0x3F96,0x3EB7,0x3FF4,0x2F04,0x0B0A,0xEFBC,0xDCD5,
	0xD325,0xD1A7,0xD526,0xDBE5,0xE2CC,0xE773,0xE9C4,0xE936,
	0xE5BE,0xE0E5,0xDA53,0xD3E2,0xCE97,0xCB67,0xCAC5,0xCCE6,
	0xD1B1,0xD948,0xE303,0xEE3D,0xFA92,0x0925,0x190E,0x2952,
	0x3903,0x4076,0x401C,0x4035,0x3FED,0x4032,0x37D2,0x29BA,
	0x1D86,0x143C,0x0F27,0x0EAC,0x1282,0x1817,0x1DFF,0x224F,
	0x22C4,0x1DED,0x1385,0x042D,0xF216,0xDF07,0xCCE1,0xC138,
	0xC052,0xC093,0xC012,0xC38D,0xCF8F,0xDB9B,0xE61A,0xEE54,
	0xF411,0xF6A8,0xF729,0xF645,0xF5D0,0xF637,0xF7B4,0xFAF1,
	0x00CB,0x07CA,0x0DA0,0x1768,0x1F4F,0x24EC,0x2A6C,0x2DB2,
	0x2E7B,0x2D64,0x2A85,0x2674,0x2040,0x183A,0x0FCB,0x0750,
	0xFEC1,0xF6B4,0xF0A1,0xEC54,0xE9BF,0xE96D,0xEA55,0xEC3B,
	0xED9A,0xED2C,0xEB6D,0xE834,0xE3AC,0xDEB4,0xDABF,0xD7E7,
	0xD760,0xD9C8,0xDEA3,0xE576,0xED93,0xF6EE,0x006D,0x0972,
	0x1083,0x14FF,0x172F,0x1723,0x15AE,0x134E,0x115A,0x0FF5,
	0x0FD0,0x1014,0x11C7,0x136B,0x148C,0x14B4,0x1404,0x126E,
	0x0FF7,0x0C7F,0x07FD,0x0295,0xFD25,0xF745,0xF164,0xED84,
	0xEB7B,0xE7D3,0xE625,0xE5D6,0xE66F,0xE82B,0xEA93,0xECC9,
	0xEEF9,0xF179,0xF420,0xF5BD,0xF70D,0xF7D3,0xF874,0xF93A,
	0xFA97,0xFD08,0xFFFE,0x03B1,0x091C,0x0E2D,0x1137,0x144A,
	0x171B,0x177C,0x16B7,0x15BA,0x135B,0x1057,0x0CF4,0x0908,
	0x05A3,0x02EB,0x00CC,0xFFAA,0xFE36,0xFDBB,0xFCA4,0xFAE5,
	0xF870,0xF5E0,0xF31C,0xF093,0xEDA8,0xEB82,0xEBE8,0xEC35,
	0xEBDD,0xECB4,0xEDBD,0xEF36,0xF183,0xF434,0xF774,0xFA38,
	0xFC96,0xFEDA,0x0164,0x02DB,0x0461,0x0559,0x0614,0x06A9,
	0x070B,0x073E,0x0728,0x075C,0x07D9,0x08C5,0x091E,0x0965,
	0x08DE,0x07BD,0x05DF,0x01C4,0xFB34,0xF19D,0xE5CA,0xD5C4,
	0xC3DB,0xBE1F,0xBE7E,0xBE31,0xBE56,0xBE62,0xBEC5,0xBFA8,
	0xC0A5,0xE212,0x0FC5,0x3314,0x3E11,0x3D93,0x3DBE,0x3D89,
	0x2ABD,0x1394,0x0420,0xFE60,0x0368,0x138E,0x2E55,0x3E55,
	0x3E08,0x3EA6,0x3E91,0x3E73,0x3DF3,0x3D63,0x3DAD,0x25AC,
	0x0201,0xE7BB,0xD681,0xCF0B,0xCEB7,0xD3BF,0xDBA0,0xE262,
	0xE660,0xEA1C,0xE77C,0xE2A7,0xDE06,0xD72E,0xD0D2,0xCB05,
	0xC78C,0xC6CE,0xC9A2,0xCF12,0xD76E,0xE20D,0xEF04,0xFDFF,
	0x0CF8,0x1C91,0x2BB5,0x39AD,0x3F40,0x3F36,0x3F4B,0x3F3B,
	0x3DF1,0x3302,0x2544,0x1A1F,0x129B,0x0E95,0x0EB4,0x1334,
	0x1940,0x1E72,0x2184,0x1FF5,0x1A19,0x0ECA,0xFF14,0xED4E,
	0xDB30,0xCADF,0xC093,0xBFEA,0xC017,0xBFD1,0xC55E,0xD200,
	0xDDF1,0xE88A,0xF12D,0xF6F2,0xF8FD,0xF909,0xF82D,0xF6E2,
	0xF674,0xF7D0,0xFB75,0x0140,0x08C2,0x115A,0x19B5,0x2170,
	0x27CF,0x2AA1,0x2C92,0x2DA4,0x2C24,0x2882,0x22C4,0x1BDF,
	0x1470,0x0C5D,0x03CD,0xFBE8,0xF532,0xF043,0xED40,0xEB83,
	0xEB4B,0xEBDB,0xECED,0xECF2,0xEA17,0xE7FB,0xE588,0xE204,
	0xDDA2,0xD9C3,0xD7C8,0xD772,0xD986,0xDE7F,0xE5CA,0xEF0D,
	0xF94B,0x02DE,0x0B44,0x11BE,0x153B,0x16AC,0x1655,0x14D1,
	0x1317,0x1194,0x10D7,0x0FFA,0x10A5,0x11FB,0x1294,0x136E,
	0x146C,0x14A7,0x13BD,0x1100,0x0C78,0x06A5,0xFFFC,0xFA3A,
	0xF4FE,0xF05B,0xECB0,0xEAA3,0xE8BA,0xE71E,0xE6A1,0xE7C3,
	0xE927,0xEB2C,0xED94,0xF026,0xF257,0xF3C3,0xF4CB,0xF5AC,
	0xF6BC,0xF7DA,0xF94D,0xFBB5,0xFF1F,0x0268,0x059D,0x0884,
	0x0BED,0x0FC5,0x12E8,0x14E8,0x1613,0x1654,0x1525,0x1281,
	0x0F20,0x0B93,0x0875,0x0561,0x02A1,0x00C4,0xFF41,0xFE3D,
	0xFD28,0xFBAF,0xFAE9,0xF996,0xF860,0xF678,0xF3E6,0xF17A,
	0xEECE,0xEC34,0xEA9D,0xEA87,0xEB55,0xED44,0xF06D,0xF45D,
	0xF7F4,0xFB29,0xFDDA,0xFF8F,0x01B6,0x031F,0x0401,0x051D,
	0x070D,0x05D5,0x067A,0x08C7,0x08B9,0x0A8E,0x0C27,0x0C8A,
	0x0D46,0x0DAE,0x0D41,0x0B82,0x08E5,0x0644,0x02F7,0xFE20,
	0xF75E,0xEF0C,0xE513,0xD7BC,0xC6DD,0xBF10,0xBF9D,0xBF53,
	0xBF33,0xBF4B,0xC05D,0xBF5E,0xCA29,0xF153,0x16B9,0x347E,
	0x3EB5,0x3E28,0x3F32,0x377B,0x22A6,0x10BB,0x0481,0x00CB,
	0x07E5,0x1843,0x3110,0x3F12,0x3EB2,0x3F07,0x3F19,0x3F05,
	0x3E6D,0x3F1B,0x3632,0x1739,0xFC03,0xE7DF,0xDB43,0xD61D,
	0xD713,0xDB03,0xE0B2,0xE5C5,0xE900,0xE9B2,0xE7E0,0xE656,
	0xE124,0xDAA7,0xD472,0xD0AD,0xCF94,0xD024,0xD397,0xD960,
	0xE0A6,0xEA0C,0xF462,0x006B,0x0E68,0x1D34,0x2B63,0x3867,
	0x3F7F,0x3F52,0x3F30,0x3E68,0x3625,0x2A21,0x1EFF,0x1678,
	0x10EF,0x0E5A,0x0F5B,0x1325,0x17AE,0x1BAA,0x1D7F,0x1BBE,
	0x150F,0x09AF,0xFAB6,0xE9D9,0xD912,0xCAC6,0xC1AB,0xBF64,
	0xC060,0xC667,0xCFCA,0xD912,0xE2A7,0xEC34,0xF23C,0xF5A1,
	0xF75B,0xF7EC,0xF77D,0xF70F,0xF7ED,0xFA3A,0xFDB6,0x025C,
	0x0870,0x0FA5,0x16A7,0x1BFA,0x208A,0x239F,0x2575,0x2591,
	0x2421,0x2115,0x1D00,0x1725,0x102F,0x08BE,0x00D6,0xF994,
	0xF34E,0xEEB4,0xEC09,0xEAD8,0xEB1C,0xEB3C,0xEBEB,0xEC5B,
	0xEC2A,0xEAE7,0xE849,0xE491,0xE0AB,0xDD30,0xDAA9,0xD9E8,
	0xDC1F,0xE1A1,0xE8BB,0xF12C,0xF9E5,0x021C,0x09AE,0x0ED6,
	0x1196,0x1308,0x12CB,0x119B,0x0F8B,0x0D52,0x0BFB,0x0B35,
	0x0BC7,0x0D38,0x0EBA,0x1004,0x102F,0x0FDC,0x0E51,0x0B49,
	0x0715,0x026E,0xFDD3,0xF906,0xF3CD,0xEEEB,0xEB75,0xE83F,
	0xE703,0xE74B,0xE557,0xE731,0xE933,0xEAEB,0xED12,0xEF4A,
	0xF11E,0xF396,0xF502,0xF678,0xF76C,0xF838,0xF950,0xFA59,
	0xFC9A,0xFFA8,0x041A,0x084B,0x0C39,0x0FD1,0x1313,0x1448,
	0x13F5,0x1350,0x1193,0x0F6B,0x0C26,0x0886,0x0521,0x02C8,
	0x00C9,0xFF98,0xFEE8,0xFED8,0xFEB0,0xFD75,0xFBF4,0xF9E6,
	0xF7B7,0xF4FC,0xF260,0xF084,0xEFE4,0xEFD7,0xEFC8,0xEFB6,
	0xF078,0xF1E2,0xF351,0xF53E,0xF7E8,0xFB1D,0xFE69,0x00FB,
	0x02BD,0x04EC,0x0702,0x07AF,0x0825,0x0905,0x09AF,0x0997,
	0x07F4,0x06BA,0x0813,0x08EC,0x0969,0x0999,0x0987,0x0948,
	0x086C,0x05D7,0x02EF,0xFF56,0xFB5D,0xF61A,0xEFBC,0xE96E,
	0xE2F8,0xDBEF,0xD528,0xCF5B,0xCCB9,0xCF42,0xD657,0xE079,
	0xED99,0xFB7B,0x086D,0x1140,0x15C8,0x161F,0x12C7,0x0D5B,
	0x07A2,0x0348,0x018B,0x02F2,0x0868,0x1075,0x19E7,0x2424,
	0x2CD9,0x32C2,0x34E5,0x30E1,0x289D,0x1E80,0x1271,0x068A,
	0xFD06,0xF6DB,0xF3D1,0xF2D4,0xF407,0xF6D0,0xF8D4,0xFA34,
	0xFA5A,0xF9AD,0xF842,0xF5D4,0xF298,0xEFE8,0xEDA2,0xEC2B,
	0xEB3F,0xEC0F,0xEDF7,0xF101,0xF4B6,0xF91C,0xFE81,0x045E,
	0x0953,0x0DDF,0x127F,0x160B,0x180B,0x1890,0x177D,0x157C,
	0x12E1,0x0FF6,0x0D70,0x0B58,0x0A49,0x09F2,0x0A1F,0x0BBA,
	0x0D27,0x0D6F,0x0C57,0x0A17,0x0652,0x0117,0xFB56,0xF5D1,
	0xF0C7,0xECD0,0xEA34,0xE8CE,0xE941,0xEABD,0xED1B,0xF08A,
	0xF43D,0xF7EC,0xFA5D,0xFB89,0xFC00,0xFBF0,0xFB35,0xFACE,
	0xFBAD,0xFDC3,0xFF23,0x0196,0x0466,0x0712,0x09F6,0x0DA4,
	0x0F88,0x0F77,0x1230,0x126F,0x1073,0x0E97,0x0C2B,0x099F,
	0x075B,0x052F,0x02FF,0x01B4,0x00A7,0xFF0C,0xFD4C,0xFC50,
	0xFB38,0xFA01,0xF8DC,0xF729,0xF5C7,0xF42C,0xF264,0xF04E,
	0xEE94,0xEDB1,0xEE57,0xEFA5,0xF10C,0xF274,0xF3E9,0xF519,
	0xF649,0xF741,0xF7FA,0xF895,0xF8FE,0xF8EA,0xF8D9,0xF882,
	0xF803,0xF749,0xF68A,0xF5E0,0xF563,0xF504,0xF498,0xF3F1,
	0xF361,0xF2DC,0xF1FD,0xF0B3,0xEF8E,0xEEB8,0xEDBD,0xECBF,
	0xEBE6,0xEB48,0xEACA,0xEA6E,0xEA2C,0xEA3A,0xEB47,0xEBE0,
	0xEA4D,0xE9B4,0xE8D8,0xE7FB,0xE7B5,0xE795,0xE7A6,0xE79D,
	0xE7BB,0xE7D3,0xE82B,0xE82D,0xE827,0xE7C4,0xE7AE,0xE7D2,
	0xE791,0xE784,0xE796,0xE834,0xE891,0xE81D,0xE797,0xE84D,
	0xE819,0xE7EE,0xE81E,0xE7FD,0xE7D0,0xE826,0xE836,0xE7FD,
	0xE842,0xE83A,0xE8C9,0xE8DA,0xE8EF,0xE8EF,0xE92E,0xE989,
	0xEA16,0xEA5F,0xEACC,0xE9B9,0xEAF1,0xEC48,0xECA4,0xED0D,
	0xED8A,0xEDFF,0xEE62,0xEF1A,0xEFCF,0xF0B8,0xF114,0xF0E7,
	0xF151,0xF1BC,0xF176,0xF19B,0xF26F,0xF2D7,0xF342,0xF437,
	0xF4CC,0xF52E,0xF59C,0xF5A2,0xF61B,0xF698,0xF695,0xF6ED,
	0xF73B,0xF7B3,0xF842,0xF887,0xF91C,0xF9C0,0xF9CC,0xFA4F,
	0xFA93,0xFAE0,0xFB07,0xFB7D,0xFBD3,0xFC9A,0xFCEC,0xFDC1,
	0xFEA0,0xFEB1,0xFF07,0xFF62,0xFFD9,0x007D,0x00D5,0x0134,
	0x0190,0x01A6,0x020C,0x0284,0x02CF,0x0305,0x034E,0x0403,
	0x048D,0x04E3,0x04EB,0x04FC,0x0545,0x0548,0x05C8,0x05A9,
	0x05E6,0x06A5,0x074A,0x072A,0x06EC,0x077F,0x07CC,0x0749,
	0x0958,0x07D4,0x07C4,0x08BA,0x0851,0x0885,0x094F,0x09A4,
	0x0977,0x0A56,0x0AC2,0x0B22,0x0B01,0x0B2A,0x0AD4,0x0AD1,
	0x0B8B,0x0BA0,0x0BB1,0x0C23,0x0CA6,0x0C4C,0x0C82,0x0C29,
	0x0C35,0x0C6D,0x0C8C,0x0D22,0x0D89,0x0D84,0x0D79,0x0D7E,
	0x0D56,0x0D01,0x0D21,0x0D4D,0x0D22,0x0D41,0x0D78,0x0DE7,
	0x0E24,0x0DC5,0x0D67,0x0D77,0x0D89,0x0D7D,0x0DD9,0x0E10,
	0x0EAC,0x0ED4,0x0E4D,0x0E2A,0x0E5A,0x0E4A,0x0EF5,0x0EFC,
	0x0F2B,0x0FC5,0x0F66,0x0EF6,0x0F18,0x0F01,0x0E43,0x0E0D,
	0x0C6C,0x0C9F,0x0CE3,0x0CB5,0x0C98,0x0C5D,0x0C8B,0x0C33,
	0x0BE2,0x0C2A,0x0CA3,0x0C78,0x0C54,0x0C5C,0x0CB0,0x0C8E,
	0x0C83,0x0CB5,0x0CEE,0x0C21,0x0C29,0x0C9E,0x0D07,0x0C91,
	0x0CBC,0x0D0A,0x0D01,0x0CF7,0x0CDD,0x0CB0,0x0CCA,0x0CE6,
	0x0CEC,0x0CCA,0x0D1A,0x0CA5,0x0CA8,0x0CA4,0x0CA7,0x0CBE,
	0x0CBF,0x0CE2,0x0C88,0x0D29,0x0DD0,0x0C9B,0x0C3E,0x0C3C,
	0x0C68,0x0C3A,0x0C38,0x0C30,0x0C02,0x0C2B,0x0C7B,0x0D0B,
	0x0D49,0x0D7C,0x0DC1,0x0D87,0x0D1F,0x0D28,0x0CA6,0x0C3E,
	0x0C0A,0x0BD1,0x0BD3,0x0B67,0x0B32,0x0B76,0x0B55,0x0B4D,
	0x0AF2,0x0AD5,0x0AB1,0x0AF7,0x0B24,0x0AD0,0x0AAD,0x0A13,
	0x0960,0x093E,0x09AC,0x09AC,0x09CE,0x09A2,0x098B,0x09AA,
	0x0915,0x0899,0x0853,0x0859,0x081F,0x082E,0x0863,0x084E,
	0x07C3,0x071A,0x06D7,0x073B,0x0727,0x076E,0x079F,0x0766,
	0x078C,0x0716,0x0733,0x075E,0x079D,0x07BE,0x073D,0x06D7,
	0x0685,0x06B3,0x05EF,0x0605,0x0639,0x061E,0x0603,0x06BD,
	0x04DB,0x052B,0x0677,0x050C,0x04B2,0x057A,0x057F,0x050C,
	0x0516,0x054D,0x055E,0x04F2,0x048B,0x0445,0x043D,0x045D,
	0x044E,0x0408,0x03D9,0x03C8,0x03A7,0x03B3,0x03C3,0x0340,
	0x0329,0x034F,0x037E,0x0384,0x0382,0x032A,0x02E1,0x02B6,
	0x02A9,0x029C,0x02B5,0x0298,0x0254,0x025D,0x0258,0x0260,
	0x025D,0x01DE,0x01AE,0x018D,0x0145,0x018A,0x01B4,0x01B5,
	0x0180,0x0186,0x0164,0x0155,0x0140,0x010D,0x00E9,0x0112,
	0x010A,0x0118,0x010A,0x0107,0x00FD,0x00F1,0x0382,0x0378,
	0x030E,0x02B2,0x0273,0x0209,0x01E3,0x0220,0x0239,0x0207,
	0x0248,0x0224,0x01AD,0x0168,0x0152,0x012A,0x013B,0x0118,
	0x00CE,0xFFC3,0xFFB2,0xFF71,0xFFA8,0xFF53,0xFF5B,0xFF06,
	0xFEA6,0xFFC2,0xFFAA,0xFED4,0xFE61,0xFECB,0xFE74,0xFE87,
	0xFEEC,0xFE93,0xFE7D,0xFE76,0xFE04,0xFE0E,0xFE2E,0xFE16,
	0xFE3E,0xFE1B,0xFE26,0xFE04,0xFE34,0xFDEC,0xFE04,0xFE5D,
	0xFE60,0xFDDB,0xFC9D,0xFDB2,0xFEC6,0xFE94,0xFE41,0xFE5B,
	0xFE5D,0xFE14,0xFDF3,0xFDD3,0xFDA0,0xFCFA,0xFCDA,0xFCF3,
	0xFC21,0xFBFA,0xFC3A,0xFC13,0xFC37,0xFC1B,0xFC1F,0xFBF6,
	0xFBCD,0xFBCB,0xFC1F,0xFC1F,0xFC36,0xFC4D,0xFC63,0xFC77,
	0xFCAB,0xFCB7,0xFCC9,0xFCE0,0xFCD0,0xFCCF,0xFCC0,0xFCEC,
	0xFCE2,0xFCEA,0xFC90,0xFC69,0xFC89,0xFCA9,0xFCCE,0xFCF7,
	0xFD3C,0xFD86,0xFDB5,0xFE07,0xFE1B,0xFE3C,0xFEB3,0xFF28,
	0xFFC8,0x00AE,0x015B,0x0215,0x02AA,0x0305,0x03A7,0x0437,
	0x04D8,0x04A8,0x050D,0x04CF,0x0540,0x0535,0x0585,0x0577,
	0x064B,0x068E,0x0699,0x0758,0x0762,0x06F7,0x0921,0x0809,
	0x0845,0x08E0,0x088B,0x0910,0x09EF,0x0B1C,0x0BDE,0x0C3E,
	0x0D1E,0x0DF3,0x0E61,0x0EFD,0x0F7C,0x0FF9,0x10B8,0x1127,
	0x1183,0x122F,0x130D,0x138B,0x1449,0x151C,0x158F,0x15BE,
	0x15F9,0x15F5,0x15EF,0x1651,0x1676,0x1650,0x1657,0x1645,
	0x1613,0x1599,0x14DE,0x13E6,0x1348,0x118D,0x0F9D,0x0DC5,
	0x0B5F,0x088F,0x0621,0x03E0,0x0266,0x0168,0x01B2,0x02EF,
	0x05E1,0x09BE,0x0DE6,0x1207,0x1615,0x19A7,0x1CD7,0x1FB0,
	0x2213,0x237F,0x24B3,0x2496,0x2427,0x22AD,0x1FAC,0x1E4D,
	0x1E4F,0x1D4B,0x1C7B,0x1C78,0x1C60,0x1BBF,0x1B5D,0x1AB1,
	0x19F6,0x1944,0x18DE,0x1848,0x179E,0x16F2,0x15F3,0x151B,
	0x1340,0x1092,0x0EB1,0x0CF5,0x0AB4,0x074D,0x04A9,0x0200,
	0xFECC,0xFBDA,0xF966,0xF766,0xF648,0xF5F2,0xF64E,0xF74B,
	0xF8F0,0xF9DB,0xFAEB,0xFC68,0xFDC8,0xFF35,0xFF81,0x0056,
	0x011D,0x0204,0x02AD,0x00F0,0x001B,0x002F,0x0058,0x006C,
	0x00AA,0x00C8,0x01AC,0x020D,0x0283,0x033C,0x0357,0x038B,
	0x0450,0x04A6,0x04EB,0x054C,0x0562,0x0556,0x0503,0x047F,
	0x03CC,0x02AC,0x00E3,0xFED9,0xFCD4,0xFAB2,0xF867,0xF65A,
	0xF488,0xF343,0xF1D2,0xF108,0xF03C,0xEFEA,0xEFB9,0xEFD4,
	0xEFBB,0xEFBC,0xEF84,0xEEF0,0xEF15,0xEF8D,0xEFA4,0xEF90,
	0xEF9A,0xEFAC,0xEF86,0xEF7E,0xEF89,0xF03F,0xEFA9,0xEFAB,
	0xEFFE,0xEFFE,0xF068,0xF0AD,0xF168,0xF1FF,0xF2E2,0xF38E,
	0xF410,0xF4F6,0xF5C4,0xF6F2,0xF748,0xF84F,0xF914,0xF898,
	0xF755,0xF711,0xF698,0xF58C,0xF476,0xF467,0xF229,0xF22E,
	0xF2E8,0xF11A,0xF070,0xEFDC,0xEF18,0xEE7D,0xEDFE,0xEE17,
	0xEE4D,0xEE9A,0xEE95,0xEE24,0xEDC0,0xEDC4,0xECFC,0xEC97,
	0xECE7,0xED27,0xECC0,0xECA0,0xECA5,0xECA1,0xEC68,0xEC47,
	0xEBFB,0xEC38,0xEC9A,0xECAF,0xED5A,0xEDF4,0xEEB1,0xEEED,
	0xEF5D,0xF131,0xF23E,0xF309,0xF3C0,0xF482,0xF486,0xF4D3,
	0xF4C4,0xF45C,0xF428,0xF415,0xF404,0xF458,0xF460,0xF467,
	0xF442,0xF3D4,0xF361,0xF2F2,0xF2B5,0xF277,0xF283,0xF2BC,
	0xF29D,0xF2A1,0xF2C5,0xF33C,0xF571,0xF483,0xF3FF,0xF39A,
	0xF313,0xF2A3,0xF1C9,0xF15A,0xF0E9,0xF0DC,0xF0A7,0xF085,
	0xF098,0xF11D,0xF139,0xF190,0xF214,0xF1F2,0xF1FF,0xF1D1,
	0xF2A2,0xF3AA,0xF385,0xF3D7,0xF4AA,0xF556,0xF581,0xF59F,
	0xF530,0xF524,0xF50E,0xF469,0xF308,0xF0F1,0xEDAF,0xE9D5,
	0xE490,0xDE86,0xD797,0xCFDB,0xC7D9,0xC02E,0xBEB7,0xBEFB,
	0xBEF5,0xBECD,0xBE51,0xC39C,0xD0B8,0xDE48,0xEC58,0xFA16,
	0x0681,0x116B,0x1A51,0x206F,0x2479,0x268A,0x2715,0x25CE,
	0x2395,0x2197,0x1F34,0x1D4E,0x1C0C,0x1B3D,0x1AE7,0x1AC4,
	0x1A0F,0x19C1,0x196F,0x1929,0x1933,0x1946,0x1928,0x191C,
	0x1931,0x1860,0x16A0,0x141B,0x1062,0x0B24,0x0481,0xFD40,
	0xF583,0xED21,0xE4F6,0xDD5C,0xD69C,0xD111,0xCD52,0xCB62,
	0xCAF2,0xCCBA,0xD00D,0xD496,0xD978,0xDEFA,0xE417,0xE895,
	0xEC76,0xEFE4,0xF2FA,0xF599,0xF7D6,0xF973,0xFB0B,0xFC91,
	0xFD86,0xFEF0,0x007F,0x022B,0x0435,0x05A7,0x079E,0x0A56,
	0x0C5A,0x0E04,0x102A,0x12AA,0x141B,0x1723,0x19A2,0x192A,
	0x1AD3,0x1A0F,0x184A,0x15AC,0x12F8,0x0EBB,0x0A49,0x0589,
	0x009B,0xFBAD,0xF6E3,0xF26F,0xEE60,0xEBC3,0xE9B4,0xE86F,
	0xE77A,0xE798,0xE7DD,0xE87A,0xE92D,0xE946,0xE9EA,0xEA7A,
	0xEB1C,0xEBF0,0xECED,0xEDC3,0xEEAE,0xEF4C,0xF009,0xF05A,
	0xF0AF,0xF16B,0xF276,0xF449,0xF653,0xF88E,0xFB70,0xFE6B,
	0x0139,0x03F4,0x06B1,0x0933,0x0B70,0x0DB4,0x1007,0x11AE,
	0x12C1,0x12DC,0x122D,0x1106,0x0FAC,0x0DEB,0x0BAD,0x0969,
	0x078C,0x05AA,0x035B,0x01A6,0x000A,0xFD30,0xFA6E,0xFA07,
	0xF946,0xF83D,0xF788,0xF70D,0xF622,0xF516,0xF481,0xF376,
	0xF24A,0xF1A0,0xF176,0xF13D,0xF0BC,0xF013,0xEFCB,0xF055,
	0xF012,0xEFDC,0xF0BC,0xF1E2,0xF2F0,0xF486,0xF650,0xF85E,
	0xFAEC,0xFD45,0xFF35,0x013B,0x028F,0x04DB,0x0713,0x084F,
	0x0934,0x09F9,0x0AEC,0x0AC3,0x0AAD,0x0AB6,0x0AD2,0x0A2A,
	0x09ED,0x0B00,0x09EA,0x087C,0x07A1,0x071A,0x0679,0x05F1,
	0x0536,0x0490,0x045F,0x03F5,0x0382,0x02B1,0x01A7,0x00CD,
	0xFFAC,0xFE28,0xFD00,0xFC21,0xFADF,0xFA27,0xF967,0xF8DE,
	0xF886,0xF7F1,0xF811,0xF84F,0xF849,0xF896,0xF954,0xF9A0,
	0xFA2A,0xFB26,0xFBDF,0xFCC7,0xFE07,0xFF5A,0x0043,0x012C,
	0x0210,0x0313,0x0392,0x036B,0x03B7,0x03C7,0x034B,0x0215,
	0xFFF6,0xFC7A,0xF8F6,0xF3F0,0xED41,0xE50D,0xDB5B,0xD04E,
	0xC4B2,0xBFF1,0xC02A,0xBFE2,0xBFE9,0xC047,0xC008,0xC317,
	0xD345,0xE4C3,0xF727,0x08B5,0x18E4,0x2712,0x31D6,0x3990,
	0x3E47,0x3F87,0x3FB4,0x3F4A,0x3CCC,0x397B,0x3524,0x34E0,
	0x33A4,0x32C8,0x3298,0x3255,0x31B6,0x30EE,0x302F,0x2F69,
	0x2EB0,0x2E84,0x2E7A,0x2E2C,0x2D35,0x2BA4,0x28EB,0x251B,
	0x200A,0x1983,0x1193,0x0818,0xFD9A,0xF302,0xE7C2,0xDCF8,
	0xD37D,0xCC55,0xC845,0xC672,0xC6DD,0xC9CF,0xCE97,0xD457,
	0xDA58,0xE06C,0xE6B8,0xECC5,0xF1FE,0xF5E7,0xF92A,0xFC4F,
	0xFEC9,0x009D,0x01D0,0x0347,0x051F,0x0742,0x0938,0x0AA9,
	0x0CF3,0x0F7D,0x1191,0x132F,0x157E,0x1828,0x1B44,0x1E41,
	0x214A,0x2465,0x26E5,0x2A21,0x2B53,0x29AF,0x27C8,0x2479,
	0x1F8C,0x19E0,0x13B2,0x0CC5,0x0620,0xFF61,0xF977,0xF415,
	0xEFD4,0xECBF,0xEA58,0xE84F,0xE6DC,0xE609,0xE577,0xE503,
	0xE6C1,0xE7C3,0xE855,0xE92C,0xEA43,0xEB50,0xEC33,0xEC6C,
	0xEC87,0xECEE,0xED84,0xEE60,0xEF83,0xF08C,0xF206,0xF46C,
	0xF66B,0xF925,0xFC5E,0xFFCC,0x0372,0x0722,0x0B6E,0x0FFA,
	0x1227,0x13CA,0x16C7,0x1940,0x1A62,0x1A68,0x19C8,0x185A,
	0x1691,0x141B,0x1135,0x0DAD,0x0AD0,0x088C,0x05BD,0x0275,
	0x005B,0xFE69,0xFCE0,0xFAF4,0xF961,0xF857,0xF6EF,0xF5D0,
	0xF519,0xF48D,0xF3EA,0xF2F5,0xF1BE,0xF03B,0xEEF1,0xEE21,
	0xEDA3,0xECEE,0xEC65,0xEBF5,0xEC17,0xEC15,0xEC72,0xED4E,
	0xEEFE,0xF177,0xF427,0xF6AA,0xF977,0xFCBE,0xFF84,0x01AB,
	0x03BC,0x0592,0x0733,0x0945,0x0A73,0x0B14,0x0BA4,0x0B7B,
	0x0B7F,0x0B2D,0x0ABB,0x0AA0,0x0A78,0x094F,0x086A,0x07A9,
	0x065D,0x05AF,0x049A,0x0445,0x03B3,0x0320,0x02E2,0x025A,
	0x0093,0xFEEF,0xFDA0,0xFB8C,0xF9C1,0xFA2B,0xF74E,0xF589,
	0xF573,0xF494,0xF369,0xF27D,0xF21B,0xF1F2,0xF26B,0xF267,
	0xF2EB,0xF383,0xF4DE,0xF5BC,0xF64B,0xF77F,0xF960,0xFACC,
	0xFC18,0xFDAD,0xFF1E,0x008E,0x0137,0x0207,0x0271,0x02DC,
	0x036E,0x03B1,0x0347,0x0241,0x0029,0xFD28,0xF8BA,0xF396,
	0xEC8B,0xE3AA,0xD9C5,0xCE2C,0xC34B,0xBF7A,0xBF9B,0xBF7F,
	0xBF91,0xBFD9,0xBF8C,0xC719,0xD8C9,0xEA60,0xFC2F,0x0D05,
	0x1C2B,0x28B7,0x32CD,0x3992,0x3D6C,0x3EB1,0x3DF1,0x3BBC,
	0x38CD,0x35F5,0x3351,0x3172,0x2FF6,0x2D7C,0x2D41,0x2E22,
	0x2E33,0x2D88,0x2C6F,0x2BD3,0x2B83,0x2B59,0x2B83,0x2B0F,
	0x2A29,0x289E,0x261A,0x221C,0x1CEC,0x1672,0x0EAF,0x051E,
	0xF8BC,0xEDC3,0xE38E,0xD9C5,0xD0B0,0xCA5A,0xC711,0xC65D,
	0xC7AF,0xCAF1,0xCF93,0xD593,0xDBEA,0xE244,0xE87C,0xEE0D,
	0xF302,0xF748,0xFA2D,0xFC8E,0xFEA4,0x0045,0x020B,0x037B,
	0x066A,0x094E,0x0A51,0x0BE5,0x0DE1,0x0FDF,0x11F6,0x1414,
	0x15FA,0x1869,0x1B69,0x1EA4,0x21CE,0x248B,0x2745,0x29C6,
	0x29D1,0x28C4,0x26C9,0x23DB,0x1F09,0x1947,0x1276,0x0B64,
	0x0464,0xFD53,0xF742,0xF27F,0xEE77,0xEB26,0xE963,0xE8BC,
	0xE7FA,0xE7B7,0xE79B,0xE831,0xE918,0xE9F8,0xEA92,0xEB8F,
	0xEC76,0xED46,0xEDF9,0xEDE0,0xEE7D,0xEF39,0xEFF8,0xF14F,
	0xF2F3,0xF457,0xF62D,0xF7BE,0xF9DF,0xFCC0,0xFEB8,0x015A,
	0x0519,0x0910,0x0D27,0x109B,0x140A,0x1710,0x18E8,0x1A34,
	0x1B00,0x1AC9,0x1A7B,0x193D,0x1735,0x1450,0x111B,0x0DAF,
	0x0B57,0x08AF,0x05CC,0x03D6,0x02E5,0xFF0F,0xFE1E,0xFE19,
	0xFB81,0xFA62,0xF95B,0xF7D1,0xF6A1,0xF5E1,0xF52A,0xF3E8,
	0xF273,0xF19E,0xF08D,0xEFC4,0xEEBC,0xEE40,0xEE4B,0xEE4A,
	0xEE5A,0xEE8C,0xEF3B,0xF010,0xF150,0xF299,0xF507,0xF755,
	0xF9BF,0xFCE5,0x003B,0x0327,0x0571,0x079A,0x0951,0x0AE8,
	0x0B40,0x0B79,0x0C38,0x0C5D,0x0C37,0x0BFE,0x0B9A,0x0AFC,
	0x0A4A,0x0972,0x08F8,0x08B2,0x080C,0x0747,0x06B8,0x05DB,
	0x04D8,0x0401,0x02AF,0x0156,0x0006,0xFF20,0xFE06,0xFCCA,
	0xFBAC,0xFAA7,0xF9BD,0xFA94,0xF92F,0xF7D7,0xF699,0xF568,
	0xF4F8,0xF4B7,0xF4BB,0xF488,0xF4AA,0xF5BF,0xF74B,0xF889,
	0xF9A3,0xFADB,0xFC72,0xFD88,0xFE91,0xFF62,0x0056,0x021F,
	0x03D5,0x0399,0x03D4,0x0466,0x0433,0x02D3,0x013B,0xFF0C,
	0xFBB5,0xF721,0xF14F,0xE9AC,0xE0A4,0xD58F,0xC9B6,0xC01A,
	0xBEF5,0xBEEA,0xBED8,0xBF32,0xBF40,0xBFBB,0xCBB1,0xDD35,
	0xEDE6,0x005D,0x123E,0x20E8,0x2C80,0x3562,0x3B84,0x3E01,
	0x3DE0,0x3C40,0x399B,0x35E3,0x3242,0x301F,0x2EB7,0x2D60,
	0x2C79,0x2C35,0x2BCD,0x2B32,0x2A67,0x2911,0x28BF,0x2932,
	0x295E,0x299D,0x29E2,0x295B,0x276F,0x2412,0x1F41,0x18C8,
	0x111F,0x0836,0xFE0C,0xF351,0xE89A,0xDE25,0xD490,0xCC8F,
	0xC6BE,0xC3A5,0xC393,0xC575,0xC9FA,0xD00C,0xD652,0xDCDF,
	0xE338,0xE916,0xEE60,0xF2A3,0xF626,0xF94F,0xFBDC,0xFDFF,
	0xFF32,0x0054,0x01EA,0x03E5,0x05BC,0x07B2,0x0A53,0x0C8C,
	0x0EFB,0x1139,0x1360,0x15D5,0x1800,0x1AB2,0x1DF7,0x20CE,
	0x22DD,0x24D9,0x2655,0x25B6,0x254F,0x2379,0x1D69,0x19D9,
	0x140B,0x0D30,0x0619,0xFF19,0xF875,0xF2A0,0xEDD3,0xEA56,
	0xE832,0xE701,0xE64D,0xE636,0xE66F,0xE6C2,0xE77D,0xE826,
	0xE8BA,0xE974,0xEA9D,0xEB07,0xEB80,0xEBED,0xECBF,0xED5A,
	0xEE2C,0xEF5F,0xF08F,0xF1FC,0xF37C,0xF4C5,0xF65F,0xF8AB,
	0xFB69,0xFE6B,0x01D9,0x05C4,0x09E0,0x0DB9,0x1120,0x1411,
	0x16CD,0x1853,0x192D,0x1961,0x18FE,0x186B,0x1673,0x1418,
	0x1144,0x0E7D,0x0BA1,0x084D,0x0586,0x0348,0x0109,0xFED5,
	0xFD80,0xFCE5,0xFBA4,0xFA75,0xF7EA,0xF52A,0xF4F2,0xF428,
	0xF332,0xF210,0xF182,0xF0E6,0xEF7E,0xEE61,0xED79,0xECD3,
	0xEC62,0xEC34,0xEC6A,0xED61,0xEE21,0xEF1E,0xF136,0xF1CE,
	0xF2CE,0xF601,0xF8CC,0xFB4A,0xFE16,0x011F,0x03AA,0x0602,
	0x086B,0x0A0B,0x0AE9,0x0BEE,0x0CF6,0x0D76,0x0D5E,0x0D26,
	0x0C72,0x0BD2,0x0B2D,0x0A96,0x09A3,0x09B3,0x0922,0x08E2,
	0x0983,0x080D,0x0603,0x04F2,0x03B7,0x02A9,0x01B0,0x00DB,
	0xFFC3,0xFE36,0xFCFD,0xFBFC,0xFAC6,0xF961,0xF831,0xF763,
	0xF617,0xF52B,0xF4A2,0xF434,0xF462,0xF47B,0xF4D2,0xF57C,
	0xF609,0xF799,0xF90F,0xFA1F,0xFB36,0xFBDE,0xFD42,0xFE6C,
	0xFF92,0x003A,0x00B8,0x01A9,0x02B5,0x034F,0x03C2,0x0482,
	0x045D,0x033C,0x011B,0xFDA0,0xFA1B,0xF598,0xEED1,0xE6A9,
	0xDD8F,0xD2E7,0xC669,0xBFDD,0xC026,0xBFF6,0xBFCC,0xBFF5,
	0xC025,0xC1C6,0xCF0A,0xE03D,0xF1DE,0x033D,0x1374,0x21AB,
	0x2D21,0x3646,0x3BD0,0x3E88,0x3EF9,0x3D01,0x3913,0x35CF,
	0x32C6,0x308C,0x2F4A,0x2F39,0x2DEA,0x2CD1,0x2EC9,0x2DCC,
	0x2C9C,0x2C9D,0x2CA7,0x2C7C,0x2C94,0x2C97,0x2C05,0x2B07,
	0x2868,0x24A7,0x1F6B,0x18D3,0x1123,0x0861,0xFE71,0xF378,
	0xE857,0xDE26,0xD522,0xCD68,0xC822,0xC5F0,0xC635,0xC8D7,
	0xCD0A,0xD2D1,0xD916,0xDEEB,0xE4F8,0xEAC3,0xEF74,0xF445,
	0xF822,0xFB39,0xFD52,0xFF57,0x00D6,0x01E8,0x02FA,0x0480,
	0x0642,0x0877,0x0A86,0x0D50,0x0FED,0x1233,0x1457,0x1689,
	0x193B,0x1C78,0x1FAF,0x227B,0x24C6,0x2630,0x26E8,0x2650,
	0x24BD,0x223F,0x202E,0x1BD8,0x14E2,0x0E21,0x074B,0x0039,
	0xF986,0xF3DB,0xEF68,0xEBA6,0xE8E7,0xE726,0xE661,0xE5FC,
	0xE673,0xE663,0xE6C4,0xE753,0xE7F8,0xE824,0xE80D,0xE991,
	0xEA45,0xEA36,0xEABF,0xEC2F,0xECDC,0xEE2D,0xEF3E,0xF058,
	0xF1EB,0xF343,0xF53D,0xF7A2,0xF9E9,0xFCC7,0x004F,0x0424,
	0x0810,0x0BBB,0x0F76,0x12C8,0x1527,0x16BC,0x1796,0x171C,
	0x14E4,0x14BB,0x13D5,0x11D0,0x0F26,0x0C4C,0x09C1,0x073D,
	0x0499,0x020A,0xFF77,0xFDBE,0xFC24,0xFA7F,0xF8FF,0xF7B3,
	0xF62F,0xF4E7,0xF381,0xF263,0xF1BB,0xF0A5,0xEFA5,0xEEA1,
	0xED92,0xED03,0xEC0C,0xEB5A,0xEAF5,0xEA7F,0xEA20,0xEAAE,
	0xEB5B,0xEC14,0xEDA3,0xEFB1,0xF246,0xF471,0xF731,0xFA6A,
	0xFDA1,0x0021,0x0284,0x0486,0x069B,0x082F,0x08BF,0x0982,
	0x0A79,0x0AAD,0x0A88,0x0A0E,0x0A6B,0x0A16,0x0976,0x08CF,
	0x082A,0x082B,0x07E4,0x073E,0x0691,0x05F4,0x0543,0x0395,
	0x0250,0x00F8,0x009F,0xFF94,0xFE11,0xFCD4,0xFC89,0xFADD,
	0xF900,0xF7A0,0xF5F6,0xF48A,0xF4EB,0xF2A9,0xF24B,0xF2F5,
	0xF2E1,0xF35F,0xF479,0xF507,0xF5BA,0xF74C,0xF899,0xFA44,
	0xFB13,0xFC20,0xFCEC,0xFE3C,0xFF00,0xFFF3,0x011D,0x0210,
	0x033C,0x03B0,0x0409,0x0417,0x03FC,0x02CD,0x0040,0xFD68,
	0xF9AB,0xF4B3,0xEDB5,0xE50E,0xDB57,0xD08C,0xC481,0xBF67,
	0xBFB0,0xBF6E,0xBF76,0xC006,0xBFA9,0xC3B7,0xD3DE,0xE55A,
	0xF708,0x0808,0x182D,0x25E6,0x302A,0x3776,0x3C44,0x3E8D,
	0x3E31,0x3BEF,0x38CE,0x35B4,0x32FC,0x30BE,0x2F75,0x2F71,
	0x2F11,0x2E92,0x2DE6,0x2D09,0x2B91,0x2AE3,0x2A98,0x2AF1,
	0x2BDC,0x2BED,0x2ADC,0x28FB,0x266E,0x22C1,0x1D99,0x1722,
	0x0F54,0x05ED,0xFB8D,0xF0E5,0xE5F4,0xDC1E,0xD2E9,0xCA7D,
	0xC64E,0xC526,0xC5E0,0xC8A5,0xCDAC,0xD3B2,0xD9AB,0xE08D,
	0xE6BD,0xECA4,0xF200,0xF587,0xF93D,0xFBFB,0xFDCA,0xFF63,
	0x012B,0x02B9,0x048C,0x05FA,0x07F2,0x0A94,0x0C7C,0x0F99,
	0x11C8,0x12FE,0x14BF,0x1710,0x19A4,0x1C88,0x1FE2,0x22D3,
	0x2512,0x2692,0x2728,0x26D3,0x24C0,0x21F7,0x1E61,0x1927,
	0x1286,0x0B9D,0x04B8,0xFE6D,0xF844,0xF2EB,0xEE6A,0xEAD9,
	0xE8E4,0xE7C9,0xE760,0xE731,0xE6E0,0xE711,0xE73D,0xE793,
	0xE7FC,0xE8F4,0xE9AB,0xEA31,0xEACA,0xEB04,0xEB60,0xEC6A,
	0xECF4,0xEDD7,0xEF8E,0xF152,0xF325,0xF4AD,0xF703,0xF983,
	0xFC30,0xFEEB,0x0255,0x0662,0x0A51,0x0E0A,0x10E6,0x13C5,
	0x1635,0x1774,0x1864,0x18E3,0x18EE,0x17CB,0x15DE,0x1343,
	0x106F,0x0CF4,0x09EB,0x078E,0x050C,0x02AA,0x0036,0xFF87,
	0xFDE8,0xFC17,0xFB4A,0xFA87,0xF6F8,0xF685,0xF630,0xF3FC,
	0xF2EE,0xF219,0xF0B8,0xEF7D,0xEE34,0xEDA2,0xECD3,0xEBDE,
	0xEB86,0xEB5A,0xEB96,0xEC04,0xECEB,0xEE36,0xEFE9,0xF1D6,
	0xF41A,0xF665,0xF916,0xFC0B,0xFE97,0x00C8,0x0384,0x05D5,
	0x07EF,0x0987,0x0A65,0x0B5A,0x0B9C,0x0B7F,0x0BA6,0x0B7D,
	0x0B6F,0x0B0B,0x0A69,0x09C6,0x094B,0x08EB,0x0897,0x07BA,
	0x06A8,0x05F3,0x0526,0x03FD,0x02E2,0x019F,0x003B,0xFE9D,
	0xFD49,0xFBC7,0xFA90,0xF946,0xF819,0xF64B,0xF488,0xF39B,
	0xF2EC,0xF29B,0xF3C6,0xF31F,0xF34D,0xF33F,0xF33F,0xF3E0,
	0xF4D1,0xF649,0xF77E,0xF883,0xFA07,0xFB46,0xFC2D,0xFD19,
	0xFDFF,0xFEBD,0xFF8D,0x0046,0x013A,0x01FB,0x02CC,0x0354,
	0x01E6,0xFEFC,0xFB9C,0xF6CF,0xF0D9,0xE9A0,0xE0C1,0xD6A1,
	0xCAF8,0xC0F9,0xBF14,0xBF4C,0xBEFE,0xBF3B,0xBF54,0xBF0F,
	0xC743,0xD8A5,0xE9D7,0xFB96,0x0C50,0x1B42,0x2802,0x3074,
	0x379D,0x3C64,0x3DB4,0x3C67,0x39EE,0x3636,0x331A,0x30EA,
	0x2F70,0x2E2B,0x2DA7,0x2CF7,0x2C2E,0x2B38,0x29D6,0x2931,
	0x28D0,0x2848,0x28A3,0x2912,0x28E2,0x282B,0x2707,0x23E9,
	0x1FA5,0x19F6,0x12A6,0x0A41,0x00A6,0xF642,0xEBA5,0xE118,
	0xD729,0xCEEC,0xC937,0xC5D6,0xC52F,0xC6A1,0xCA37,0xCF8A,
	0xD591,0xDBF3,0xE22D,0xE7E3,0xED0D,0xF186,0xF54F,0xF8A9,
	0xFB6B,0xFDDD,0xFF57,0x0096,0x01C1,0x03A1,0x0569,0x0741,
	0x08EB,0x0AFE,0x0D0D,0x0EE4,0x112B,0x13CB,0x165E,0x1911,
	0x1C7B,0x1FB5,0x2280,0x244C,0x2555,0x2589,0x241F,0x2179,
	0x1E6F,0x1A35,0x145E,0x0FF6,0x0A06,0x019B,0xFBD2,0xF537,
	0xF060,0xECBD,0xEA02,0xE7B8,0xE709,0xE6A8,0xE67E,0xE6D6,
	0xE743,0xE7DF,0xE84A,0xE8F6,0xE954,0xEA11,0xEB00,0xEB79,
	0xEBF0,0xECC4,0xEDAA,0xEEA8,0xEF75,0xF0A0,0xF255,0xF43A,
	0xF63D,0xF85A,0xFABE,0xFDE8,0x0127,0x0486,0x0883,0x0BB8,
	0x0EE0,0x11FA,0x14D5,0x173D,0x18B8,0x1972,0x1927,0x17D4,
	0x1620,0x148D,0x1295,0x101D,0x0D4F,0x0A4B,0x07A3,0x051D,
	0x02C5,0x009C,0xFED2,0xFD86,0xFC5F,0xFB86,0xFA85,0xF97A,
	0xF856,0xF6E8,0xF52F,0xF2E5,0xF090,0xEFCA,0xEEF1,0xEE2E,
	0xEDA2,0xECED,0xEC69,0xEC17,0xEC33,0xECCB,0xEDE2,0xEECB,
	0xEFD0,0xF0E6,0xF297,0xF45B,0xF68C,0xF9C6,0xFBFE,0xFE83,
	0x0252,0x052D,0x0704,0x08DB,0x0A45,0x0B45,0x0BBD,0x0C36,
	0x0BC6,0x0BCE,0x0B7B,0x0B09,0x0A86,0x0A13,0x09F7,0x09E0,
	0x096D,0x0937,0x089B,0x07AF,0x06EF,0x0584,0x044B,0x0404,
	0x01EE,0x0046,0xFEC8,0xFD7E,0xFC36,0xFB1F,0xF9D4,0xF87A,
	0xF7CE,0xF6D9,0xF64A,0xF53B,0xF4D8,0xF545,0xF5B0,0xF597,
	0xF549,0xF559,0xF638,0xF792,0xF8BB,0xFA13,0xFB28,0xFC81,
	0xFDBE,0xFF12,0xFFE2,0x00D0,0x014E,0x0217,0x0288,0x02D2,
	0x03C0,0x0459,0x048E,0x04A4,0x0495,0x03F7,0x01D4,0xFFAE,
	0xFD43,0xFA01,0xF51F,0xEEF5,0xE8D9,0xE32F,0xDDC2,0xD93A,
	0xD726,0xD7FF,0xDB78,0xE00B,0xE6ED,0xEF50,0xF7EA,0x005D,
	0x07F0,0x0E39,0x137E,0x1724,0x1966,0x1A78,0x1AA7,0x1969,
	0x182B,0x1689,0x1550,0x1423,0x1400,0x1373,0x134D,0x13B9,
	0x1385,0x1357,0x1333,0x1256,0x10AC,0x127E,0x1220,0x1267,
	0x135B,0x13C7,0x1361,0x11F7,0x1060,0x0DB6,0x0A0D,0x05A7,
	0x013F,0xFCBD,0xF782,0xF261,0xEE06,0xEAD1,0xE7B8,0xE596,
	0xE568,0xE69D,0xE84E,0xEB17,0xEDF7,0xF100,0xF409,0xF640,
	0xF7F4,0xF990,0xFB4F,0xFC57,0xFCF8,0xFDEC,0xFE6E,0xFF50,
	0x0022,0x00C1,0x0135,0x0179,0x02B9,0x03AD,0x046D,0x0526,
	0x05D9,0x06AF,0x078E,0x08D7,0x0AB5,0x0C71,0x0E38,0x0FA9,
	0x102E,0x1070,0x0F9E,0x0E6E,0x0C83,0x0A02,0x084F,0x052E,
	0x0242,0x014B,0xFF41,0xFB74,0xF950,0xF784,0xF5E0,0xF4E0,
	0xF43E,0xF496,0xF45E,0xF449,0xF467,0xF528,0xF59A,0xF613,
	0xF66C,0xF6C4,0xF756,0xF793,0xF6F9,0xF697,0xF76F,0xF793,
	0xF70A,0xF6EF,0xF7FC,0xF8D9,0xF97B,0xFA66,0xFB57,0xFCEB,
	0xFE4C,0xFF6B,0x00F2,0x02B6,0x0421,0x05B3,0x06C5,0x07DC,
	0x0881,0x0908,0x090B,0x08BA,0x0834,0x0768,0x05B9,0x039E,
	0x03D3,0x034F,0x0209,0x0101,0x0096,0xFF74,0xFE62,0xFDA0,
	0xFD04,0xFC37,0xFBB3,0xFAE1,0xFA9D,0xFA44,0xF97B,0xF90F,
	0xF858,0xF789,0xF6D3,0xF65B,0xF5F3,0xF54B,0xF550,0xF59D,
	0xF594,0xF533,0xF53A,0xF5A3,0xF5F6,0xF65B,0xF6C8,0xF72B,
	0xF73F,0xF79E,0xF7DD,0xF7C9,0xF7E2,0xF7BC,0xF757,0xF6BB,
	0xF681,0xF61F,0xF5BF,0xF577,0xF40C,0xF15E,0xEE22,0xEA10,
	0xE6FA,0xE465,0xE2F4,0xE293,0xE3E8,0xE59C,0xE76B,0xE8F8,
	0xE9EF,0xEA88,0xEAE2,0xEACD,0xEABC,0xEA8E,0xE9CE,0xE965,
	0xE8DC,0xE8D3,0xE87E,0xE86D,0xE8AF,0xE984,0xE96F,0xE958,
	0xE950,0xE90A,0xE8B7,0xEACD,0xE90F,0xE8FF,0xE9F4,0xE969,
	0xE9D9,0xEA4C,0xEA3E,0xEA05,0xEA40,0xEA14,0xEA09,0xE9E6,
	0xEA20,0xEA1B,0xE9F6,0xEA94,0xEB33,0xEB65,0xEBB5,0xEC44,
	0xED1C,0xED8D,0xEDE9,0xEE3D,0xED98,0xED90,0xED40,0xED29,
	0xEC97,0xECAB,0xED10,0xED55,0xEE55,0xEEEA,0xF003,0xF10D,
	0xF0FA,0xF107,0xF1B8,0xF1E2,0xF229,0xF210,0xF1DA,0xF223,
	0xF257,0xF302,0xF395,0xF43F,0xF49D,0xF53F,0xF57B,0xF5F8,
	0xF6BD,0xF73F,0xF7BA,0xF88F,0xF929,0xF9C7,0xF9FA,0xFA86,
	0xFA88,0xFAB5,0xFA45,0xF8A0,0xF911,0xF9E2,0xFA16,0xFB36,
	0xFC4B,0xFCBC,0xFCF0,0xFD50,0xFDFC,0xFE56,0xFEAB,0xFF53,
	0xFF89,0xFFF1,0x0067,0x00B5,0x00FC,0x0123,0x006F,0x00F8,
	0x0247,0x02D7,0x0318,0x043B,0x0531,0x05DD,0x0636,0x0618,
	0x0603,0x0642,0x060D,0x0607,0x05C6,0x05FC,0x0676,0x06E5,
	0x0769,0x080B,0x08C8,0x0945,0x096A,0x0994,0x0A5B,0x0AF1,
	0x0A01,0x09DB,0x0A56,0x0A99,0x0A52,0x0A7B,0x0A65,0x0ABB,
	0x0B27,0x0BB1,0x0C2D,0x0C55,0x0D36,0x0E1F,0x0E43,0x0E38,
	0x0DC4,0x0D49,0x0D1D,0x0CE5,0x0CBD,0x0CED,0x0D38,0x0D23,
	0x0D9E,0x0DB0,0x0DB2,0x0DFA,0x0DBE,0x0DC7,0x0DD3,0x0E11,
	0x0DC6,0x0D9B,0x0E07,0x0E59,0x0E66,0x0E50,0x0E41,0x0E4F,
	0x0E15,0x0DDF,0x0E02,0x0E3E,0x0E9C,0x0E51,0x0EB9,0x0EA4,
	0x0E76,0x0E7F,0x0E65,0x0E1F,0x0DD0,0x0E28,0x0E7B,0x0EC2,
	0x0F08,0x0ECB,0x0E39,0x0E52,0x0E5B,0x0E9C,0x0E9F,0x0E6F,
	0x0E6F,0x0E38,0x0E21,0x0DF4,0x0DA0,0x0D83,0x0DC2,0x0E07,
	0x0D91,0x0DB9,0x0E4C,0x0C6D,0x0D4C,0x0E6C,0x0D58,0x0DA4,
	0x0D88,0x0D50,0x0CFB,0x0CC8,0x0D0F,0x0D33,0x0DA8,0x0E2C,
	0x0DF3,0x0DC6,0x0DE8,0x0D7F,0x0CF7,0x0D18,0x0CFB,0x0CB4,
	0x0CCD,0x0CD8,0x0CCD,0x0CAC,0x0C9A,0x0C4D,0x0C09,0x0BE2,
	0x0BEC,0x0C5E,0x0C88,0x0C0A,0x0B98,0x0B3A,0x0B3E,0x0B2D,
	0x0AD2,0x0AEA,0x0AFC,0x0AAB,0x0A86,0x0A79,0x0A56,0x0A68,
	0x0A44,0x09BE,0x0960,0x0997,0x09CD,0x098A,0x094B,0x095C,
	0x0956,0x0963,0x090C,0x090E,0x08AD,0x088B,0x08A6,0x08B0,
	0x08E2,0x0ABE,0x0A3E,0x09A5,0x09C7,0x09A8,0x09A4,0x09FF,
	0x09B0,0x09BB,0x09D3,0x0940,0x08DD,0x08CE,0x08EE,0x08BD,
	0x0823,0x0816,0x0808,0x07D3,0x0713,0x0758,0x07A8,0x06F8,
	0x065C,0x06B4,0x06B3,0x05CE,0x0556,0x0520,0x054D,0x0561,
	0x057F,0x053A,0x0547,0x04D1,0x048D,0x04B5,0x048F,0x045F,
	0x04B8,0x0514,0x04AD,0x0470,0x04EF,0x04A5,0x02F2,0x03A9,
	0x04A5,0x04CD,0x04FF,0x0530,0x052E,0x04B3,0x042A,0x041E,
	0x03B7,0x0352,0x0350,0x03B8,0x03A4,0x02A5,0x0269,0x0203,
	0x0168,0x0184,0x0195,0x01D9,0x01B1,0x01A8,0x01BA,0x01B4,
	0x01DF,0x01AC,0x01C9,0x019F,0x01CE,0x01F2,0x01F6,0x01CF,
	0x0147,0x009F,0x00E6,0x012A,0x0137,0x01D2,0x01B7,0x0119,
	0x00EF,0x00CC,0x00AC,0xFFE0,0xFFE4,0xFF4E,0xFD39,0xFD40,
	0xFDC5,0xFDC6,0xFDFE,0xFE5A,0xFE62,0xFE4E,0xFE85,0xFEE8,
	0xFE98,0xFE89,0xFF81,0xFFED,0x0068,0x014E,0x0248,0x02FB,
	0x033B,0x027D,0x0393,0x0581,0x06B6,0x06E2,0x07AF,0x0906,
	0x09CE,0x09FF,0x0A88,0x0B16,0x0AFB,0x0B2E,0x0B00,0x0B10,
	0x0B07,0x0AD8,0x0AFC,0x0B87,0x0C06,0x0C8F,0x0CD5,0x0D5E,
	0x0DC7,0x0F0E,0x100B,0x0FAE,0x0F9C,0x0FE4,0x100A,0x108E,
	0x1152,0x1205,0x132C,0x143A,0x1524,0x164F,0x16C8,0x16BF,
	0x16DB,0x165C,0x1607,0x1663,0x170C,0x1788,0x18DE,0x198C,
	0x192B,0x18FB,0x18F4,0x18CD,0x18FD,0x1901,0x18DB,0x18EA,
	0x1923,0x1910,0x18F5,0x18A7,0x18E4,0x1954,0x192B,0x18AB,
	0x1801,0x1786,0x16E4,0x1687,0x1675,0x168E,0x16D3,0x170C,
	0x16A7,0x162C,0x163A,0x15BF,0x1494,0x141F,0x139A,0x134D,
	0x12DA,0x124E,0x1232,0x1238,0x120F,0x1189,0x10E8,0x10A2,
	0x102B,0x0F0E,0x0E23,0x0E0F,0x0DC6,0x0D67,0x0D68,0x0D48,
	0x0CB8,0x0C67,0x0BED,0x0B78,0x0B1C,0x0B2D,0x087E,0x08AC,
	0x0A25,0x0921,0x08C4,0x08CE,0x0843,0x073C,0x0642,0x053B,
	0x043B,0x0377,0x031A,0x02E3,0x0271,0x028A,0x02ED,0x02B3,
	0x01A9,0x010C,0x006F,0x000D,0xFF92,0xFEAC,0xFE9A,0xFE95,
	0xFE41,0xFE04,0xFD8E,0xFD11,0xFD49,0xFCFB,0xFC7E,0xFBF6,
	0xFB56,0xFA84,0xFA0F,0xF9B3,0xF925,0xF8E5,0xF84B,0xF715,
	0xF514,0xF27D,0xEEF6,0xEB3C,0xE714,0xE308,0xDF77,0xDD3C,
	0xDC79,0xDE1A,0xE111,0xE5B5,0xEAAC,0xEE93,0xF1A7,0xF386,
	0xF3A3,0xF303,0xF251,0xF247,0xF3F9,0xF340,0xF3AF,0xF4EF,
	0xF66F,0xF82D,0xFA8A,0xFD97,0x0037,0x0217,0x0421,0x062B,
	0x0794,0x092F,0x0A46,0x0AC3,0x0B2A,0x0A7E,0x0857,0x0565,
	0x0365,0x01DB,0xFF0C,0xFCF5,0xFCE5,0xFD85,0xFE6D,0xFF31,
	0xFFA9,0x002C,0xFF0F,0xFCF3,0xFA60,0xF77B,0xF464,0xF148,
	0xEE3C,0xEBE5,0xE9F9,0xE8A1,0xE7F5,0xE742,0xE6A6,0xE667,
	0xE626,0xE529,0xE533,0xE608,0xE5F9,0xE65C,0xE759,0xE7BB,
	0xE803,0xE78E,0xE6D7,0xE61A,0xE584,0xE54F,0xE60B,0xE74F,
	0xE88D,0xEADA,0xED3A,0xEF7B,0xF176,0xF33B,0xF403,0xF46F,
	0xF56E,0xF616,0xF633,0xF68A,0xF721,0xF73F,0xF759,0xF797,
	0xF814,0xF865,0xF8C7,0xF92E,0xF9DC,0xF9FB,0xF9D3,0xF995,
	0xF9D1,0xF965,0xF8DD,0xF864,0xF771,0xF656,0xF431,0xF247,
	0xF0CF,0xEFDB,0xEEB9,0xEE77,0xEE7D,0xEECD,0xEEAC,0xEE5E,
	0xEDB3,0xECE3,0xEBB1,0xEACE,0xEA30,0xE99D,0xE937,0xE944,
	0xE8AA,0xE86E,0xE84C,0xE891,0xE93D,0xE9B4,0xEA7F,0xEBB3,
	0xEC83,0xECE5,0xEE4C,0xEF73,0xEFCD,0xF20D,0xF356,0xF234,
	0xF3A3,0xF381,0xF38C,0xF3B1,0xF409,0xF465,0xF588,0xF64D,
	0xF799,0xF8CC,0xF99A,0xF9F9,0xFADA,0xFB11,0xFA9C,0xFA87,
	0xFA51,0xF9F5,0xF999,0xF971,0xF94E,0xF904,0xF82A,0xF7A1,
	0xF77A,0xF6E4,0xF65D,0xF5FC,0xF61A,0xF68B,0xF68E,0xF5C9,
	0xF5B5,0xF5B8,0xF52C,0xF407,0xF30C,0xF2D6,0xF260,0xF187,
	0xF126,0xF1D1,0xF2B9,0xF359,0xF312,0xF34B,0xF410,0xF433,
	0xF403,0xF42F,0xF48C,0xF53A,0xF563,0xF57D,0xF5C6,0xF675,
	0xF6FF,0xF774,0xF7D1,0xF858,0xF8E3,0xF81A,0xF739,0xF7FF,
	0xF8C6,0xF91E,0xF9D2,0xFA60,0xFADF,0xFB90,0xFC05,0xFC20,
	0xFC56,0xFC9C,0xFCBF,0xFCDD,0xFC83,0xFCA4,0xFCCA,0xFD8B,
	0xFD19,0xFCD9,0xFDEF,0xFE20,0xFE02,0xFD93,0xFDFA,0xFDAB,
	0xFCA8,0xFC3B,0xFB8E,0xFA76,0xF9EA,0xF9C4,0xFA41,0xFAC9,
	0xFA91,0xF980,0xF700,0xF369,0xEEAB,0xE81A,0xE066,0xD7AB,
	0xCE01,0xC527,0xC029,0xBFF7,0xC020,0xBFD9,0xC411,0xD20A,
	0xDF00,0xEA24,0xF31A,0xF829,0xFA15,0xF9D7,0xF87C,0xF78F,
	0xF784,0xF7FD,0xF965,0xFD2E,0x02C8,0x09EE,0x121D,0x1A4C,
	0x2229,0x2970,0x2F80,0x34CA,0x3925,0x3D78,0x402E,0x4070,
	0x403D,0x4046,0x3C1E,0x3539,0x2EC3,0x28F0,0x24B0,0x2229,
	0x2169,0x223C,0x23AB,0x24D9,0x253E,0x24B3,0x22A0,0x1E14,
	0x175C,0x0EE9,0x05F6,0xFD52,0xF524,0xEE59,0xE955,0xE699,
	0xE40E,0xE23F,0xE0A2,0xDF89,0xDF67,0xDFE6,0xE08C,0xE1E4,
	0xE328,0xE3C2,0xE44E,0xE3D5,0xE32B,0xE293,0xE218,0xE0A0,
	0xE053,0xE18C,0xE3BC,0xE73F,0xECB6,0xF26F,0xF7F9,0x013F,
	0x06DD,0x0AAB,0x0E16,0x100F,0x1048,0x1007,0x1021,0x110D,
	0x122D,0x1303,0x1429,0x1555,0x1658,0x1734,0x17EC,0x1929,
	0x1A27,0x1AF0,0x1B21,0x1A6B,0x1962,0x17F6,0x1607,0x1307,
	0x0F51,0x0B53,0x06EB,0x01D1,0xFDAC,0xFAE9,0xF8F2,0xF776,
	0xF6CA,0xF5E4,0xF526,0xF412,0xF2C8,0xF143,0xEF79,0xEDBE,
	0xEBAA,0xE939,0xE725,0xE50C,0xE403,0xE3CB,0xE44A,0xE4BA,
	0xE64A,0xE7EF,0xE970,0xEB48,0xECF1,0xEF93,0xF2FE,0xF57E,
	0xF7B1,0xF9E5,0xFB78,0xFE30,0xFF4A,0xFF8B,0x0061,0x01A7,
	0x034B,0x0534,0x086A,0x0AE6,0x0CAF,0x0E77,0x100C,0x11BE,
	0x12B9,0x1252,0x1240,0x121F,0x116D,0x103B,0x0F06,0x0E36,
	0x0E44,0x0D0A,0x0AA8,0x0974,0x0809,0x0637,0x04E3,0x0440,
	0x0401,0x0330,0x0216,0x0092,0xFEFC,0xFCCB,0xFA3E,0xF820,
	0xF66D,0xF534,0xF40E,0xF2DA,0xF1E5,0xF1D4,0xF27B,0xF2FF,
	0xF286,0xF1CF,0xF34A,0xF42D,0xF3B9,0xF406,0xF4BE,0xF52F,
	0xF5EF,0xF6D6,0xF76E,0xF84D,0xF8EE,0xF90A,0xFA28,0xFACE,
	0xFC07,0xFDA1,0xFF54,0x00B9,0x028C,0x03F3,0x04ED,0x053C,
	0x05B2,0x05F5,0x0624,0x0646,0x0656,0x068C,0x06DD,0x0749,
	0x0771,0x0792,0x0775,0x0768,0x06F2,0x0634,0x05A6,0x04E1,
	0x0413,0x03BE,0x02FF,0x024A,0x0140,0xFFCE,0xFE9C,0xFD86,
	0xFCC4,0xFBA1,0xFA89,0xF98B,0xF844,0xF6D5,0xF410,0xF093,
	0xEBA8,0xE545,0xDCF6,0xD30D,0xC7BB,0xBF7D,0xBE74,0xBE83,
	0xBECA,0xBE5F,0xC516,0xD3D1,0xDFF4,0xEB3B,0xF413,0xF9AB,
	0xFAE0,0xFA7B,0xF9B3,0xF84D,0xF737,0xF9E8,0xFB18,0x0035,
	0x0810,0x1021,0x195C,0x2264,0x2A35,0x30F6,0x36AE,0x3BC2,
	0x3F14,0x3F06,0x3F26,0x3F4A,0x3F1D,0x3EDE,0x3F11,0x3A86,
	0x32F6,0x2D12,0x28E7,0x2661,0x2563,0x25F4,0x26EC,0x280E,
	0x2894,0x27EC,0x2528,0x1FFC,0x1805,0x0EC2,0x0503,0xFBF5,
	0xF40E,0xED5D,0xE89B,0xE4EE,0xE2BD,0xE0FE,0xDF36,0xDE7F,
	0xDEB0,0xDF1E,0xDF9D,0xE09B,0xE1CF,0xE28C,0xE25C,0xE25A,
	0xE242,0xE223,0xE1B8,0xE10B,0xE184,0xE32A,0xE57A,0xE938,
	0xEE66,0xF4B9,0xFBD5,0x0279,0x0794,0x0A30,0x0D70,0x0FA6,
	0x1084,0x114A,0x1265,0x1376,0x1489,0x14E4,0x15BC,0x1719,
	0x1893,0x19F2,0x1B86,0x1D43,0x1DD2,0x1E17,0x1DB7,0x1C6D,
	0x1A4C,0x1892,0x16C0,0x13F3,0x105D,0x0CBD,0x0868,0x02E4,
	0xFEE6,0xFB85,0xF927,0xF7C2,0xF737,0xF709,0xF638,0xF4CC,
	0xF37D,0xF196,0xEF9C,0xED7D,0xEB3E,0xE933,0xE788,0xE5E8,
	0xE59A,0xE5F9,0xE594,0xE671,0xE74E,0xE978,0xEB97,0xEDF3,
	0xEFD7,0xF247,0xF54B,0xF83E,0xFB51,0xFDD5,0xFFC4,0x022F,
	0x0321,0x0344,0x0435,0x0533,0x0660,0x087A,0x0B5C,0x0EB1,
	0x113A,0x1321,0x1463,0x1540,0x1554,0x14EE,0x14C6,0x144A,
	0x1407,0x137A,0x120E,0x10D2,0x0FED,0x0E7B,0x0D01,0x0B9E,
	0x0A9B,0x097A,0x080E,0x0672,0x04EB,0x03D7,0x02DF,0x0139,
	0xFF2D,0xFD60,0xFB61,0xF94C,0xF76B,0xF5DB,0xF3F9,0xF324,
	0xF269,0xF1F3,0xF1D5,0xF1FE,0xF24A,0xF30C,0xF38E,0xF3E6,
	0xF466,0xF414,0xF478,0xF549,0xF636,0xF73D,0xF80D,0xF8C3,
	0xF9CE,0xFB58,0xFC5F,0xFE02,0x004D,0x005D,0x02BD,0x0576,
	0x05D5,0x073E,0x0831,0x08DB,0x097E,0x09CC,0x0ABA,0x0B09,
	0x0AEE,0x0A82,0x0A08,0x09B7,0x099F,0x0993,0x09E8,0x09D4,
	0x09A8,0x0918,0x0898,0x0812,0x0736,0x0617,0x051E,0x0448,
	0x0306,0x01AD,0x0047,0xFF73,0xFEFC,0xFDDC,0xFC88,0xFB79,
	0xF957,0xF58A,0xF0E2,0xEBED,0xE4BF,0xDB8F,0xD18B,0xC64C,
	0xBFE1,0xBF53,0xBF58,0xBF9A,0xBFBE,0xC83D,0xD71C,0xE439,
	0xEF08,0xF6A0,0xFA55,0xFB24,0xFA15,0xF829,0xF6F8,0xF714,
	0xF859,0xFB8E,0x0210,0x0B8D,0x140B,0x1CD7,0x2526,0x2CC5,
	0x3377,0x3905,0x3DAF,0x3FCE,0x3FE4,0x3FBE,0x3FDA,0x3FBE,
	0x3FA5,0x3EE4,0x37FB,0x3079,0x2AEE,0x2740,0x255C,0x262F,
	0x2838,0x28B6,0x28D6,0x28A4,0x268D,0x2264,0x1C3A,0x1469,
	0x0AE0,0x00DA,0xF748,0xEF6C,0xE966,0xE4D1,0xE172,0xDF5F,
	0xDE44,0xDD59,0xDC82,0xDB9D,0xDB75,0xDC83,0xDDC7,0xDE8E,
	0xDE73,0xDF78,0xE027,0xDF23,0xDD92,0xDCCD,0xDD24,0xDDE3,
	0xDFB6,0xE283,0xE6F8,0xEC82,0xF32B,0xF9EC,0x006D,0x05BE,
	0x0A30,0x0D31,0x0EA1,0x0F56,0x0F83,0x0F76,0x0FE3,0x10A2,
	0x1202,0x1357,0x147D,0x1616,0x1780,0x1890,0x19D5,0x1A80,
	0x1A71,0x1A1E,0x1914,0x174A,0x1518,0x129A,0x0F67,0x0BC6,
	0x0749,0x026A,0xFE34,0xFAEB,0xF7BB,0xF553,0xF43A,0xF3DB,
	0xF2CD,0xF111,0xEF71,0xEE30,0xEC96,0xEAB7,0xE90A,0xE72E,
	0xE53A,0xE344,0xE18F,0xE0C1,0xE106,0xE17C,0xE2A3,0xE40D,
	0xE5B0,0xE777,0xE994,0xEBF9,0xEE10,0xF0DF,0xF466,0xF6E5,
	0xF818,0xFA01,0xFBB9,0xFB67,0xFD1A,0xFEBC,0xFF28,0x02AC,
	0x04D9,0x071B,0x096D,0x0C15,0x0D9F,0x0F28,0x1007,0x1110,
	0x1122,0x10E6,0x101D,0x0EFA,0x0E7A,0x0D5D,0x0C20,0x0AB0,
	0x096D,0x0898,0x0726,0x056D,0x0413,0x0339,0x0243,0x0157,
	0x0041,0xFECD,0xFCF3,0xFB6F,0xF986,0xF7DA,0xF617,0xF4C9,
	0xF307,0xF1A9,0xF0CB,0xF00D,0xF03F,0xF0DA,0xF14B,0xF1DF,
	0xF2AD,0xF2FB,0xF3A4,0xF397,0xF378,0xF3A9,0xF465,0xF4E2,
	0xF55B,0xF637,0xF78C,0xF8A4,0xFA2C,0xFBA0,0xFDD6,0xFFD2,
	0x015C,0x029E,0x03FA,0x04E4,0x0464,0x03E2,0x0613,0x07A4,
	0x086F,0x0889,0x08AB,0x08EF,0x0912,0x08D8,0x088B,0x092D,
	0x09DA,0x09D9,0x0A15,0x09CF,0x0978,0x0909,0x087F,0x0687,
	0x0560,0x04DE,0x03D1,0x01D4,0x0086,0xFFE0,0xFFBE,0xFEE3,
	0xFE25,0xFD6F,0xFC61,0xFAE8,0xF86E,0xF4DD,0xF068,0xEA71,
	0xE36D,0xDAC5,0xD028,0xC4E7,0xC027,0xC03B,0xC02E,0xC020,
	0xC246,0xCDFA,0xDB7C,0xE82A,0xF25D,0xF8C4,0xFC0E,0xFCB3,
	0xFB65,0xF958,0xF892,0xF95E,0xFBF1,0xFF7E,0x05DE,0x0E63,
	0x16D2,0x1F7A,0x2808,0x2F82,0x361A,0x3C02,0x4022,0x409D,
	0x4085,0x409E,0x4087,0x4080,0x4069,0x3ECF,0x3819,0x3163,
	0x2BD7,0x285C,0x271F,0x2731,0x283F,0x2983,0x29D7,0x293C,
	0x2709,0x2300,0x1C07,0x13E0,0x0AB3,0x012C,0xF804,0xEFCB,
	0xE9F5,0xE62A,0xE34F,0xE182,0xE01A,0xDF0E,0xDE93,0xDED0,
	0xDED5,0xDFD8,0xE11F,0xE1FD,0xE25F,0xE255,0xE10C,0xE032,
	0xDF23,0xDE23,0xDE9F,0xE01C,0xE261,0xE61D,0xEA47,0xF057,
	0xF7B1,0xFE88,0x04BD,0x0B33,0x0EFD,0x1017,0x13AA,0x13CC,
	0x12AD,0x132E,0x1356,0x13F2,0x14FB,0x16B4,0x188C,0x1973,
	0x1A79,0x1BBA,0x1CF0,0x1DB9,0x1DD5,0x1D7C,0x1C40,0x19F7,
	0x16F5,0x13BB,0x105B,0x0C7D,0x0844,0x03EB,0xFF6A,0xFBB4,
	0xF8D7,0xF637,0xF4FE,0xF471,0xF427,0xF3E6,0xF337,0xF18E,
	0xEF74,0xED25,0xEA67,0xE7E9,0xE5F4,0xE46D,0xE302,0xE1E8,
	0xE1ED,0xE2CE,0xE43B,0xE65B,0xE884,0xEAC5,0xED2D,0xEF4B,
	0xF1BB,0xF467,0xF6B8,0xF8FE,0xFB2B,0xFC92,0xFDE2,0xFEC1,
	0xFFCD,0x0131,0x041E,0x06E7,0x091C,0x0B3D,0x0D81,0x0F56,
	0x113F,0x1358,0x1422,0x14F6,0x14F0,0x13EC,0x1264,0x105B,
	0x0F23,0x0DE9,0x0CE4,0x0B9E,0x0A79,0x08C1,0x0743,0x0682,
	0x056F,0x0405,0x02DC,0x026A,0x011B,0xFFAF,0xFDAE,0xFB84,
	0xF8D1,0xF605,0xF386,0xF1CB,0xEFF2,0xEEBC,0xEDF6,0xED86,
	0xEDDE,0xEE2F,0xEEE0,0xEF95,0xEFC3,0xF045,0xF0A8,0xEFD6,
	0xEF96,0xF0F7,0xF20D,0xF28B,0xF38C,0xF51B,0xF696,0xF782,
	0xF882,0xF99C,0xFA93,0xFBFE,0xFDA3,0xFFC8,0x017A,0x0322,
	0x0490,0x056F,0x0631,0x0676,0x060F,0x058F,0x05B6,0x063E,
	0x0650,0x063B,0x06C7,0x0761,0x0806,0x0855,0x0874,0x07CC,
	0x0736,0x05EE,0x047A,0x0361,0x0287,0x011A,0xFFB9,0xFEC8,
	0xFDFF,0xFCCE,0xFBEF,0xFAE7,0xF9F9,0xF914,0xF821,0xF67B,
	0xF402,0xF0B8,0xEC0C,0xE5E2,0xDE1A,0xD47B,0xC8E1,0xBFBD,
	0xBEA4,0xBE92,0xBEC4,0xBEA7,0xC0C5,0xCD6A,0xDB82,0xE75D,
	0xF140,0xF6EE,0xF9BC,0xFA1E,0xF905,0xF77E,0xF606,0xF593,
	0xF80C,0xFD02,0x032B,0x0B45,0x1673,0x1DB5,0x25EE,0x2DB2,
	0x3352,0x3933,0x3E22,0x3F01,0x3F06,0x3F20,0x3F34,0x3EFC,
	0x3F19,0x3B31,0x33E5,0x2DD8,0x28FB,0x2641,0x2532,0x2557,
	0x2692,0x27BA,0x2834,0x2788,0x253F,0x2075,0x195E,0x106E,
	0x06C6,0xFCF7,0xF449,0xED7B,0xE7D1,0xE42F,0xE1A4,0xE015,
	0xDEB9,0xDDAF,0xDD82,0xDDE3,0xDEF3,0xE00F,0xE0D5,0xE1FA,
	0xE24B,0xE1FD,0xE184,0xE0BC,0xDFCE,0xDF9A,0xDFE6,0xE0E5,
	0xE30D,0xE6C0,0xEC3D,0xF291,0xF978,0x00DE,0x0765,0x0C4D,
	0x0FBB,0x11D4,0x131B,0x132B,0x1130,0x1111,0x1223,0x1302,
	0x13DC,0x14D8,0x1689,0x1843,0x19B0,0x1A85,0x1B34,0x1BE5,
	0x1BE9,0x1B3D,0x1AAD,0x193C,0x168C,0x1359,0x0F0F,0x08EA,
	0x0490,0x00BC,0xFC85,0xF8E9,0xF6D3,0xF5A7,0xF4C2,0xF465,
	0xF432,0xF3A6,0xF298,0xF078,0xEE54,0xEBDA,0xE94F,0xE70D,
	0xE555,0xE3F5,0xE326,0xE2D4,0xE375,0xE460,0xE5A1,0xE80C,
	0xEA46,0xEB3F,0xEC85,0xEEBD,0xF1EE,0xF4A6,0xF7A7,0xFA28,
	0xFBFE,0xFDCA,0xFF34,0x0004,0x011B,0x0240,0x0434,0x0609,
	0x0831,0x0AC7,0x0DB9,0x0FD5,0x11E0,0x143D,0x1556,0x1519,
	0x1475,0x1319,0x118E,0x1055,0x0EEC,0x0D9D,0x0CC2,0x0C6D,
	0x0BAE,0x0A40,0x0883,0x06C9,0x0544,0x03F3,0x02A3,0x01B5,
	0x00BE,0xFF78,0xFDF2,0xFB65,0xF95C,0xF74A,0xF504,0xF306,
	0xF185,0xF06F,0xEF5E,0xEEE1,0xEF15,0xF065,0xF132,0xF1A7,
	0xF20B,0xF2A4,0xF361,0xF3A4,0xF3AC,0xF455,0xF522,0xF5EB,
	0xF6CA,0xF758,0xF89F,0xFA96,0xFC54,0xFD9A,0xFEE3,0x00BD,
	0x025E,0x03AC,0x04ED,0x0744,0x06A5,0x0805,0x0A6E,0x0994,
	0x095A,0x0923,0x08BE,0x088B,0x0808,0x085E,0x08CA,0x0891,
	0x08A5,0x0832,0x084A,0x0801,0x07A7,0x0724,0x0681,0x0571,
	0x040B,0x029F,0x00F6,0xFFB8,0xFF18,0xFE08,0xFCA1,0xFBBC,
	0xFAEA,0xF9DC,0xF7B7,0xF445,0xF019,0xEBB5,0xE530,0xDC97,
	0xD259,0xC790,0xC050,0xBF59,0xBF6F,0xBF9C,0xBF4E,0xC3DF,
	0xD205,0xDF5C,0xEB5D,0xF44B,0xF8DC,0xFA6B,0xF9B0,0xF834,
	0xF687,0xF5C8,0xF696,0xF987,0xFEBB,0x05CA,0x0E51,0x17F4,
	0x214A,0x2A63,0x3378,0x38D9,0x3DBD,0x4030,0x400C,0x4000,
	0x3FE8,0x3FDF,0x3FC1,0x3F77,0x3A59,0x3353,0x2D9B,0x28C1,
	0x2606,0x253F,0x25C9,0x2750,0x28D2,0x2931,0x28FD,0x2639,
	0x1F72,0x1656,0x0CF8,0x02A5,0xF864,0xF04F,0xE9E1,0xE4F8,
	0xE202,0xDFCA,0xDEAA,0xDE02,0xDD92,0xDD04,0xDCC7,0xDDA9,
	0xDE3E,0xDEAE,0xDF60,0xDF8A,0xDF62,0xDF4D,0xDE82,0xDD10,
	0xDCD4,0xDE34,0xDFA1,0xE23A,0xE651,0xEBE6,0xF2FC,0xFA85,
	0x01C1,0x077C,0x0BE0,0x0EE2,0x1088,0x1116,0x102C,0x103F,
	0x10A0,0x1123,0x11CB,0x12B3,0x1492,0x16CE,0x18A8,0x19DD,
	0x1B0A,0x1B51,0x1B3B,0x1AF8,0x19E8,0x1855,0x16B5,0x1376,
	0x0FA3,0x0B79,0x0732,0x030E,0xFF26,0xFB9A,0xF86F,0xF655,
	0xF4BE,0xF36E,0xF247,0xF201,0xF19B,0xF05B,0xEEAE,0xEC46,
	0xE97C,0xE6AE,0xE3F0,0xE271,0xE19E,0xE139,0xE173,0xE1C1,
	0xE1FC,0xE2BB,0xE46F,0xE64D,0xE917,0xEC65,0xEF32,0xF1A1,
	0xF34C,0xF49C,0xF62E,0xF793,0xF8F6,0xFAAF,0xFCC6,0xFE45,
	0x001B,0x01D5,0x026E,0x05F6,0x094C,0x0A02,0x0D4E,0x0F1C,
	0x106C,0x1116,0x112A,0x104F,0x0FDA,0x0F12,0x0E87,0x0D65,
	0x0BF3,0x0A7D,0x08B9,0x0777,0x0619,0x0519,0x04AF,0x04A0,
	0x0395,0x021A,0x0091,0xFEB0,0xFC76,0xFA87,0xF8FD,0xF796,
	0xF635,0xF4A5,0xF2D8,0xF0EE,0xEFA1,0xEEFD,0xEE92,0xEEB7,
	0xEF19,0xEFDD,0xF0AD,0xF0FB,0xF0E7,0xF150,0xF251,0xF30C,
	0xF3F1,0xF448,0xF45B,0xF514,0xF5F9,0xF699,0xF862,0xFA8C,
	0xFCC6,0xFE44,0xFF70,0x011D,0x02A1,0x03A4,0x0435,0x04D9,
	0x067F,0x07E6,0x0857,0x073A,0x05F8,0x06D2,0x06B8,0x06C1,
	0x06FE,0x0773,0x0758,0x076E,0x0727,0x0701,0x0759,0x06DB,
	0x05D3,0x04D0,0x0438,0x02B2,0x0089,0xFF82,0xFE26,0xFD30,
	0xFDB5,0xFDF0,0xFCE7,0xFC26,0xFB83,0xF9E5,0xF75A,0xF4BD,
	0xF1D7,0xEDBC,0xE87F,0xE210,0xDA74,0xD237,0xCAF1,0xC57C,
	0xC3DF,0xC62C,0xCCB6,0xD5D2,0xDFAD,0xE96D,0xF1F8,0xF911,
	0xFBAE,0xFBD6,0xFB6D,0xFA8C,0xF92E,0xF8F7,0xFA18,0xFCF1,
	0x0145,0x07A5,0x0F0D,0x16E8,0x1DCF,0x241A,0x29A3,0x2E04,
	0x31E0,0x34D0,0x3768,0x3907,0x3933,0x3827,0x352D,0x30F6,
	0x2C24,0x275C,0x23A1,0x20C5,0x1EE2,0x1E0F,0x1E5D,0x1F1F,
	0x1F42,0x1F09,0x1D7A,0x1A19,0x1546,0x0F3D,0x081F,0x00E4,
	0xF99C,0xF364,0xEEC2,0xEB1C,0xE8F8,0xE750,0xE6C9,0xE67C,
	0xE5E3,0xE53F,0xE5A5,0xE640,0xE6DF,0xE7B9,0xE81E,0xE8B4,
	0xE822,0xE720,0xE62D,0xE5C5,0xE5E3,0xE736,0xE9E4,0xECCF,
	0xF0CA,0xF46F,0xF98F,0xFEF2,0x03BB,0x070F,0x0A7F,0x0D59,
	0x0E78,0x0E7F,0x0F52,0x0F0F,0x0DBD,0x0FD4,0x1021,0x10E9,
	0x12D3,0x143D,0x1502,0x157C,0x164B,0x16F2,0x16F8,0x1719,
	0x1622,0x14F6,0x130C,0x102D,0x0CDE,0x09A3,0x0687,0x0306,
	0xFFF9,0xFD93,0xFB74,0xF9E3,0xF8E1,0xF84F,0xF7DB,0xF772,
	0xF6EE,0xF5E7,0xF444,0xF20B,0xEFDE,0xEE0C,0xEC19,0xEA9F,
	0xE9F8,0xE9C4,0xE9FB,0xEA97,0xEB7D,0xECFA,0xEE3D,0xEFE1,
	0xF1CF,0xF3AA,0xF648,0xF7E4,0xF8E3,0xFA26,0xFB84,0xFCA4,
	0xFDEB,0xFEF5,0x003C,0x0164,0x024B,0x0347,0x047A,0x067D,
	0x08F1,0x0C98,0x0F2B,0x0FC2,0x1066,0x10C0,0x1052,0x0F4B,
	0x0E24,0x0D06,0x0C4B,0x0B42,0x0A89,0x09BE,0x0936,0x0895,
	0x07F7,0x0743,0x063D,0x04A4,0x0335,0x0119,0x002F,0xFE9A,
	0xFC70,0xFB25,0xFA8B,0xF911,0xF7AB,0xF642,0xF4BF,0xF377,
	0xF225,0xF1C0,0xF1C1,0xF1EF,0xF20C,0xF238,0xF2B4,0xF319,
	0xF374,0xF414,0xF49D,0xF4DF,0xF527,0xF556,0xF49E,0xF401,
	0xF635,0xF875,0xFA8B,0xFC62,0xFE01,0xFF71,0x0090,0x00C6,
	0x00DC,0x00E1,0x011B,0x021E,0x02D5,0x0298,0x034A,0x0465,
	0x04D7,0x0515,0x0543,0x0587,0x0537,0x04BB,0x042E,0x03F0,
	0x03EB,0x0402,0x040D,0x044B,0x03BD,0x032B,0x01EB,0x0072,
	0xFF50,0xFE82,0xFE0C,0xFD48,0xFCD2,0xFCD1,0xFC6F,0xFBA5,
	0xFAB6,0xF9E2,0xF8D1,0xF72C,0xF5CD,0xF4BD,0xF2DE,0xF070,
	0xEDB9,0xEB92,0xE92F,0xE792,0xE725,0xE86F,0xEB24,0xEEBD,
	0xF236,0xF54B,0xF77F,0xF8DF,0xF9D4,0xFA56,0xFA43,0xFADB,
	0xFB22,0xFBB4,0xFCA1,0xFDD8,0xFF9E,0x02C8,0x0518,0x0827,
	0x0AFE,0x0C9C,0x0DF3,0x118A,0x1173,0x12B2,0x1443,0x1456,
	0x1484,0x13A2,0x125A,0x108D,0x0F0B,0x0D5E,0x0BFB,0x0ACA,
	0x0AFC,0x0B20,0x0B06,0x0AFA,0x0AA5,0x0A0B,0x08A6,0x06E6,
	0x0498,0x027D,0x0056,0xFE58,0xFC2E,0xF9DA,0xF837,0xF786,
	0xF6BB,0xF5B6,0xF552,0xF4F9,0xF4E5,0xF523,0xF542,0xF522,
	0xF565,0xF5DE,0xF601,0xF5BB,0xF5D8,0xF5E7,0xF5D2,0xF5D8,
	0xF67E,0xF785,0xF8A4,0xF9CD,0xFB27,0xFD31,0xFF0F,0x0065,
	0x016B,0x0225,0x0326,0x037A,0x03D5,0x043D,0x045B,0x0426,
	0x03A6,0x02F4,0x01A8,0xFF3C,0xFE4B,0xFE17,0xFD80,0xFCF0,
	0xFC97,0xFB90,0xFA55,0xF8C1,0xF7D5,0xF7A6,0xF738,0xF73B,
	0xF688,0xF5E4,0xF594,0xF4F7,0xF405,0xF37B,0xF1D5,0xF117,
	0xF172,0xF0A7,0xEFBC,0xEF2C,0xEE81,0xEE02,0xED48,0xECBF,
	0xEC27,0xEB4E,0xEAA4,0xEA20,0xE9C4,0xE959,0xE897,0xE820,
	0xE7B3,0xE76C,0xE726,0xE71F,0xE729,0xE6F4,0xE7A8,0xE87E,
	0xE763,0xE687,0xE614,0xE619,0xE5D7,0xE5FF,0xE5E6,0xE5C3,
	0xE63C,0xE6E1,0xE760,0xE788,0xE80B,0xE8A6,0xE88D,0xE850,
	0xE898,0xE8D2,0xE92F,0xE96E,0xE9A2,0xEA0F,0xE999,0xE95B,
	0xE9BA,0xEA02,0xEA5C,0xEAC5,0xEAF1,0xEB39,0xEB7A,0xEB94,
	0xEBB8,0xEC3B,0xECAA,0xED23,0xED64,0xEDE5,0xEDEF,0xEE29,
	0xEEB2,0xEF98,0xEFE6,0xF04F,0xF0D5,0xF0BA,0xF101,0xF14D,
	0xF1D0,0xF228,0xF2BF,0xF363,0xF3EF,0xF49C,0xF4EF,0xF5C9,
	0xF69B,0xF6C4,0xF728,0xF753,0xF7D4,0xF883,0xF8AB,0xF94D,
	0xF9CB,0xF9FC,0xFA7F,0xFB2D,0xFB9E,0xFB4D,0xFC17,0xFCCB,
	0xFCF0,0xFD7E,0xFED9,0xFD92,0xFE0B,0xFFA9,0xFEC0,0xFEC7,
	0xFF79,0xFFE7,0xFFFE,0x008C,0x0147,0x01B9,0x01B6,0x0218,
	0x0249,0x0237,0x027F,0x02EE,0x0357,0x03B4,0x03B9,0x0426,
	0x0459,0x04B4,0x051D,0x05A6,0x05CA,0x05F0,0x0667,0x06BF,
	0x0749,0x0739,0x0768,0x07C8,0x07FA,0x0848,0x08B1,0x0957,
	0x0958,0x0927,0x09D1,0x0A14,0x0A2D,0x0A95,0x0ABE,0x0B0F,
	0x0AF6,0x0AE2,0x0B01,0x0B34,0x0BA1,0x0BC5,0x0BF7,0x0C0B,
	0x0BDB,0x0C06,0x0BD1,0x0BC0,0x0C42,0x0C48,0x0CC7,0x0D09,
	0x0D83,0x0FA6,0x0F30,0x0ECB,0x0EE6,0x0ECE,0x0EB9,0x0ECB,
	0x0EBA,0x0EB1,0x0EB7,0x0F02,0x0EE6,0x0ED3,0x0F02,0x0EFD,
	0x0EDB,0x0EFE,0x0F71,0x0F8E,0x0ECE,0x0F11,0x0FE2,0x0F83,
	0x0E92,0x0ED6,0x0F26,0x0EB9,0x0EC9,0x0E92,0x0E73,0x0E7F,
	0x0E39,0x0E17,0x0E3A,0x0DEC,0x0E0B,0x0DFB,0x0DCA,0x0DD0,
	0x0DAC,0x0D50,0x0D86,0x0D7B,0x0D2B,0x0BCD,0x0CE6,0x0DA9,
	0x0DB6,0x0DAF,0x0D46,0x0D03,0x0CB4,0x0CE1,0x0D13,0x0CDA,
	0x0CB7,0x0C4B,0x0C01,0x0BDB,0x0BCF,0x0AFA,0x0B28,0x0AF1,
	0x0AF1,0x0AFA,0x0B47,0x0B42,0x0AF6,0x0AF5,0x0AD5,0x0B04,
	0x0B41,0x0B4A,0x0B12,0x0AF1,0x0AD1,0x0A65,0x0A8F,0x0ACC,
	0x0AB8,0x0A86,0x0AD9,0x0A2E,0x09D1,0x09B1,0x099B,0x09B4,
	0x09D5,0x09CB,0x0A1A,0x0A27,0x09BA,0x0983,0x0967,0x0943,
	0x0925,0x08E6,0x08E9,0x0892,0x083D,0x0851,0x0820,0x0800,
	0x07F6,0x07EA,0x0809,0x080D,0x0843,0x07CC,0x0791,0x0730,
	0x07BD,0x0801,0x0803,0x0789,0x07DA,0x0783,0x06FB,0x0755,
	0x07CF,0x06FA,0x0801,0x087D,0x0634,0x0746,0x0724,0x06FC,
	0x06F9,0x06DE,0x06CB,0x06E8,0x0648,0x06A3,0x0732,0x0768,
	0x077C,0x06C5,0x06AE,0x06B3,0x06E8,0x06DE,0x0712,0x067A,
	0x069A,0x0665,0x067B,0x068F,0x066D,0x0631,0x0603,0x05E9,
	0x05C3,0x05FE,0x0618,0x05F2,0x05E8,0x05D1,0x05CA,0x0592,
	0x05B6,0x05F5,0x05F9,0x056D,0x053B,0x04C0,0x04DE,0x0523,
	0x0551,0x0537,0x04D9,0x04B6,0x0494,0x045F,0x04D3,0x04C9,
	0x04B1,0x04D1,0x048A,0x046D,0x0423,0x03E6,0x037F,0x0315,
	0x0323,0x02E6,0x01DF,0x00A2,0x0103,0x00E2,0x0098,0x00F3,
	0x0105,0x0151,0x0197,0x01A0,0x01C5,0x0178,0x01A5,0x01BB,
	0x01CB,0x021D,0x0266,0x0294,0x02BE,0x024B,0x0180,0x0209,
	0x0280,0x0273,0x0233,0x0255,0x0259,0x01D6,0x01F1,0x01B7,
	0x01BD,0x0231,0x0248,0x02A0,0x0280,0x01EB,0x01AD,0x01DB,
	0x024C,0x02D4,0x02A5,0x0267,0x038C,0x02F4,0x0176,0x017B,
	0x018C,0x0146,0x015E,0x0219,0x01E9,0x01F9,0x019A,0x01C6,
	0x0222,0x0295,0x032F,0x0370,0x041C,0x042F,0x037B,0x0308,
	0x02E1,0x02B2,0x02B9,0x02C5,0x02CB,0x0287,0x020B,0x020F,
	0x019F,0x0189,0x01B7,0x01BE,0x01BB,0x01C2,0x0193,0x0191,
	0x010E,0x0150,0x013F,0x0150,0x01B3,0x015D,0x00ED,0x0092,
	0x00A3,0x0093,0xFEE3,0xFF41,0xFF01,0xFEB3,0xFEE5,0xFED6,
	0xFF01,0xFF4F,0xFF53,0xFEFE,0xFED8,0xFE95,0xFE59,0xFE55,
	0xFE5B,0xFE8A,0xFE8D,0xFEDF,0xFEE3,0xFE94,0xFEA4,0xFE31,
	0xFDF8,0xFE3B,0xFE56,0xFE6F,0xFE6C,0xFE1B,0xFD8D,0xFDC9,
	0xFE00,0xFDF7,0xFE5B,0xFE50,0xFE5F,0xFE76,0xFE25,0xFE5D,
	0xFE82,0xFE7E,0xFE7A,0xFEC9,0xFF03,0xFF21,0xFF22,0xFF1B,
	0xFF0C,0xFEF6,0xFF0C,0xFF3A,0xFFEC,0x01D3,0x0373,0x0442,
	0x045F,0x03F9,0x0451,0x0533,0x07AA,0x07F5,0x077C,0x078F,
	0x0727,0x06C7,0x06CF,0x06DB,0x070F,0x075B,0x073C,0x06FF,
	0x0766,0x07ED,0x087A,0x08BE,0x0910,0x088A,0x07BD,0x070C,
	0x08E8,0x0BF5,0x0D90,0x0DB7,0x0DFB,0x0DF4,0x0D1D,0x0DA5,
	0x0E57,0x0F54,0x10E0,0x11E3,0x1169,0x117C,0x1172,0x11C9,
	0x1282,0x1399,0x143C,0x1437,0x140A,0x1404,0x1492,0x1512,
	0x1582,0x13B8,0x1261,0x1227,0x1114,0x0EC9,0x0BA0,0x06E8,
	0x00B4,0xFA64,0xF6FC,0xF8C2,0xFF89,0x08E2,0x129F,0x19EA,
	0x1C68,0x1BCC,0x18F0,0x166C,0x1532,0x1607,0x17CC,0x1A48,
	0x1DCF,0x21EC,0x24ED,0x26DA,0x28E8,0x2A68,0x2B2F,0x2A8C,
	0x28C8,0x2597,0x208B,0x198E,0x1365,0x0E1B,0x0B2A,0x0AB9,
	0x0C93,0x0F3E,0x107F,0x0F40,0x0C54,0x0827,0x0372,0xFF1A,
	0xFC5D,0xFAE9,0xFB78,0xFCBD,0xFE99,0x00E9,0x03BD,0x063F,
	0x0873,0x0A8E,0x0D09,0x0F19,0x0FD4,0x0EDC,0x0D14,0x0B3F,
	0x0A09,0x09F5,0x0B83,0x0DDA,0x10CC,0x12C8,0x1315,0x11AF,
	0x0EE3,0x0B2A,0x07A5,0x0420,0xFF49,0xFD44,0xFD5B,0xFA5F,
	0xFA30,0xF8AA,0xF71B,0xF6C0,0xF6C8,0xF66C,0xF671,0xF5F8,
	0xF48B,0xF25B,0xEFD7,0xEF0B,0xEF8C,0xF136,0xF35E,0xF641,
	0xF924,0xFBEC,0xFD88,0xFE34,0xFDD6,0xFD4A,0xFCCD,0xFC11,
	0xFC79,0xFCFB,0xFD7B,0xFD71,0xFD65,0xFCE7,0xFCF0,0xFCAD,
	0xFC53,0xFBF4,0xFACB,0xF8CB,0xF54A,0xF18B,0xEECE,0xED3C,
	0xEC52,0xEC60,0xED47,0xEE29,0xEE5B,0xED7C,0xEC98,0xEC34,
	0xEC6F,0xEC6A,0xEC5B,0xEC9F,0xED23,0xEDBD,0xEE4F,0xEFEF,
	0xF1BD,0xF32C,0xF4AA,0xF5E9,0xF728,0xF727,0xF55E,0xF506,
	0xF46F,0xF39B,0xF2E6,0xF2D5,0xF370,0xF3FE,0xF443,0xF386,
	0xF32B,0xF263,0xF0C6,0xEF9A,0xEEA9,0xED8B,0xEC6D,0xEBC7,
	0xEB09,0xE97C,0xEA55,0xEA99,0xEAA6,0xEB62,0xECD2,0xED15,
	0xED2A,0xEDCD,0xEE38,0xEE57,0xEDE7,0xED49,0xEE69,0xEFE5,
	0xF171,0xF2E2,0xF402,0xF556,0xF668,0xF654,0xF657,0xF6B1,
	0xF65D,0xF6EB,0xF616,0xF527,0xF4F4,0xF4B7,0xF431,0xF3B3,
	0xF319,0xF2DB,0xF2B6,0xF27E,0xF2C3,0xF288,0xF1BC,0xF10E,
	0xEFFB,0xEEDD,0xEEF0,0xEFC9,0xF088,0xF1B1,0xF299,0xF2E3,
	0xF2A8,0xF2C1,0xF2A6,0xF31E,0xF422,0xF508,0xF5CE,0xF626,
	0xF5F0,0xF5B4,0xF677,0xF778,0xF807,0xF843,0xF84F,0xF856,
	0xF7FB,0xF7E1,0xF792,0xF6CE,0xF5D6,0xF58A,0xF592,0xF56B,
	0xF5BC,0xF5BA,0xF575,0xF413,0xF29C,0xF286,0xF2B3,0xF2CB,
	0xF27A,0xF251,0xF22D,0xF206,0xF0A0,0xEE66,0xEAE7,0xE589,
	0xDCB6,0xD111,0xC3F9,0xBFA6,0xBFFE,0xC02A,0xC003,0xC313,
	0xDA25,0xF30B,0x0360,0x0A4B,0x0961,0x032B,0xFAE0,0xF9C9,
	0xFC55,0x0260,0x0C12,0x15BB,0x1E45,0x2687,0x2D51,0x30F8,
	0x334A,0x3482,0x337C,0x2EE2,0x2575,0x17B8,0x07F8,0xF8B6,
	0xECF8,0xE81F,0xE9F1,0xEFFA,0xF663,0xF944,0xF6BD,0xEF84,
	0xE5CD,0xDBA0,0xD3AC,0xCECB,0xCD93,0xCFDF,0xD442,0xDA94,
	0xE1DF,0xE9D8,0xF1E9,0xFA6A,0x02DA,0x0A1C,0x0F2F,0x122D,
	0x1178,0x0DFD,0x0A37,0x083D,0x0A05,0x0F6C,0x1683,0x1D60,
	0x222E,0x2303,0x1F68,0x18CA,0x10A9,0x085F,0xFFFE,0xF819,
	0xF294,0xEF0B,0xECE9,0xECD5,0xECFB,0xEB39,0xEB00,0xEB0D,
	0xEB9D,0xEBC6,0xEB35,0xE8BC,0xE4D0,0xE18E,0xE10F,0xE3C5,
	0xE948,0xF0BE,0xF913,0x00F5,0x0751,0x0B5B,0x0D84,0x0EA3,
	0x105A,0x0FEB,0x0DAF,0x0C6E,0x0CC1,0x0D1E,0x0E1B,0x0ED2,
	0x0EBF,0x0E51,0x0D75,0x0C60,0x0A2B,0x070A,0x01F3,0xFBDE,
	0xF444,0xEE36,0xEA87,0xE929,0xE99C,0xEA5C,0xEB36,0xECB0,
	0xECEA,0xEC88,0xED8B,0xEEEC,0xEEBD,0xEE1B,0xEE46,0xEF7E,
	0xF27C,0xF646,0xFA59,0xFDF0,0x015F,0x0499,0x07D8,0x09FF,
	0x0B26,0x0C08,0x0BA0,0x09F6,0x079F,0x067E,0x05D1,0x05BA,
	0x0616,0x059E,0x04F9,0x0415,0x02DD,0x017F,0xFE7A,0xFA7D,
	0xF6B7,0xF3BC,0xF10B,0xEEFA,0xEE76,0xEF47,0xEF85,0xEF0C,
	0xEFAF,0xF146,0xF31A,0xF4DF,0xF5EC,0xF6DC,0xF7E1,0xF839,
	0xF930,0xFAC0,0xFCAD,0xFF1C,0x0218,0x0533,0x07A0,0x0999,
	0x0AA4,0x0AAF,0x0A34,0x0931,0x080A,0x06E5,0x05A8,0x04AA,
	0x03FB,0x0337,0x0210,0x0129,0xFF6C,0xFDDF,0xFCCD,0xFBE3,
	0xFA23,0xF849,0xF6C8,0xF5A4,0xF385,0xF453,0xF357,0xF353,
	0xF5CA,0xF752,0xF915,0xFA66,0xFB4D,0xFBEA,0xFCF0,0xFD73,
	0xFE9E,0xFFE0,0x01E4,0x0383,0x050B,0x0658,0x070E,0x0785,
	0x0720,0x0728,0x07FA,0x08BF,0x08C0,0x0752,0x05B2,0x041D,
	0x026A,0x00E8,0x0028,0x002A,0x0043,0xFF5E,0xFEC4,0xFE29,
	0xFD56,0xFC00,0xFA65,0xF998,0xF9A3,0xF938,0xF8F9,0xF95F,
	0xF9A6,0xF7C1,0xF229,0xE904,0xDDD0,0xD0DB,0xC310,0xBF85,
	0xBFF7,0xC03A,0xBF97,0xCAA3,0xE9F8,0x0730,0x1A9F,0x20CE,
	0x1BE4,0x1266,0x0AF3,0x09E0,0x0E67,0x15BD,0x1EAB,0x288D,
	0x317D,0x3A71,0x3ED5,0x3EAF,0x3ECE,0x3E87,0x3EBE,0x3C28,
	0x3082,0x21C2,0x1001,0xFE40,0xF06E,0xEA44,0xECC4,0xF56A,
	0xFD86,0x0231,0x0024,0xF547,0xE7AB,0xDBBD,0xD3BD,0xD03B,
	0xD10A,0xD482,0xD9A4,0xE0C6,0xE9D2,0xF416,0xFF9B,0x0A34,
	0x1319,0x19D1,0x1DAE,0x1EF4,0x1DE0,0x1ABC,0x1747,0x1523,
	0x16AE,0x1C3C,0x2356,0x2B94,0x31FB,0x32E6,0x2DDA,0x23DA,
	0x17F7,0x0CC0,0x039F,0xFC46,0xF65D,0xF1E4,0xEE50,0xECCF,
	0xEC4F,0xEC9A,0xED8B,0xEE33,0xEDBA,0xEC23,0xEA32,0xE863,
	0xE65F,0xE483,0xE34F,0xE4ED,0xEA45,0xF32A,0xFE59,0x0920,
	0x113F,0x1672,0x1773,0x1689,0x15A8,0x14C8,0x1536,0x1556,
	0x158A,0x1531,0x1529,0x1501,0x150D,0x1527,0x149E,0x1275,
	0x0E1B,0x08A7,0x0258,0xFB7F,0xF4EE,0xEE55,0xE8AC,0xE62D,
	0xE647,0xE919,0xEC66,0xEED3,0xF010,0xEF7A,0xEE18,0xED1A,
	0xED6D,0xEEC3,0xF17C,0xF427,0xF789,0xFAC9,0xFDE6,0x01C6,
	0x0752,0x0C79,0x1091,0x133D,0x154F,0x1474,0x12D0,0x11B3,
	0x0E17,0x0C40,0x0BBA,0x0B46,0x0AD3,0x0A98,0x0A7E,0x088D,
	0x05AF,0x02A2,0xFF5E,0xFBB6,0xF7AE,0xF3C8,0xF12C,0xEF15,
	0xEDAF,0xEDA8,0xEEA0,0xF029,0xF1CF,0xF3A6,0xF540,0xF742,
	0xF888,0xF949,0xF974,0xFA02,0xFB96,0xFDF4,0x004E,0x030D,
	0x0699,0x09EC,0x0BD6,0x0CCC,0x0DE5,0x0E26,0x0E46,0x0D82,
	0x0C87,0x0A91,0x082C,0x05F1,0x03B7,0x023E,0x01E6,0x014F,
	0x0035,0xFF12,0xFE03,0xFC2C,0xF9C7,0xF690,0xF3BF,0xF1EB,
	0xF1A7,0xF27C,0xF3DC,0xF702,0xF832,0xF8FF,0xF9E5,0xFB34,
	0xFD78,0x0025,0x016C,0x018E,0x0232,0x034F,0x04A9,0x0585,
	0x0637,0x07CF,0x08F8,0x0A7D,0x0C2E,0x0CFC,0x0CE0,0x0B88,
	0x09E0,0x0764,0x04F8,0x03B4,0x02E4,0x01D6,0x0112,0x001E,
	0xFF2D,0xFDE2,0xFD1E,0xFC47,0xFB78,0xFA1A,0xF8E3,0xF774,
	0xF6F8,0xF6F5,0xF6E1,0xF67F,0xF57D,0xF31F,0xEE77,0xE6D6,
	0xDB28,0xCD67,0xC11D,0xBF19,0xBF6B,0xBFC5,0xBFEF,0xD38D,
	0xF3F8,0x0D3D,0x1C30,0x1EDB,0x18A5,0x0FCF,0x0A87,0x0A57,
	0x0FDA,0x1860,0x21C7,0x2B2A,0x334C,0x3AF8,0x3DF1,0x3DE0,
	0x3E00,0x3DAC,0x3E05,0x399C,0x2B86,0x1A99,0x07A4,0xF70E,
	0xEC7C,0xEA2A,0xEED7,0xF6F0,0xFE11,0xFF10,0xF93B,0xEE99,
	0xE283,0xD86F,0xD224,0xCF80,0xCFA1,0xD2F8,0xD885,0xE07C,
	0xEA1F,0xF4FD,0xFFDA,0x0A50,0x12D0,0x18D6,0x1BFF,0x1CEC,
	0x1A79,0x1601,0x1268,0x120A,0x1566,0x1B77,0x23B6,0x2ACA,
	0x2E85,0x2CB6,0x2593,0x1C09,0x11DF,0x086A,0xFFAF,0xF7C2,
	0xF107,0xEC9E,0xE952,0xE652,0xE646,0xE905,0xE87C,0xEA6F,
	0xEB1C,0xE9DE,0xE7CF,0xE4C9,0xE1BF,0xE005,0xE0DF,0xE59F,
	0xECC6,0xF5BB,0x0075,0x0996,0x0FF7,0x1367,0x14F3,0x1567,
	0x1557,0x1526,0x1472,0x13ED,0x1308,0x12DC,0x12A9,0x130B,
	0x134F,0x13C5,0x1376,0x117F,0x0D27,0x07E0,0x013D,0xF948,
	0xF1F6,0xEC03,0xE88F,0xE7DB,0xE8C3,0xEA78,0xECE4,0xEE46,
	0xEF05,0xEF2B,0xEEFC,0xEF30,0xEFDB,0xF134,0xF2BA,0xF506,
	0xF78F,0xFAB7,0xFEDD,0x0373,0x0869,0x0D62,0x1141,0x1350,
	0x139C,0x12E4,0x11AF,0x0F7A,0x0C1F,0x087D,0x077D,0x0747,
	0x0686,0x0611,0x05A3,0x04C3,0x02BB,0xFFAA,0xFBD0,0xF815,
	0xF442,0xF043,0xED5B,0xEC63,0xECAE,0xED27,0xEDE4,0xEE9D,
	0xEF35,0xF12D,0xF42B,0xF648,0xF82C,0xFA4F,0xFB47,0xFB1F,
	0xFCAA,0xFF31,0x0194,0x04BA,0x080D,0x0B48,0x0DDD,0x0F4D,
	0x0F66,0x0F17,0x0DFD,0x0D31,0x0B7B,0x09DD,0x0874,0x06AD,
	0x066D,0x0595,0x0305,0x0168,0xFFF6,0xFE12,0xFC6F,0xFB2A,
	0xF971,0xF800,0xF695,0xF57D,0xF454,0xF3D9,0xF4CB,0xF6A6,
	0xF7FB,0xF9C5,0xFB92,0xFCFF,0xFE36,0xFF59,0x002F,0x00F9,
	0x0273,0x04A1,0x0664,0x07A2,0x0864,0x0965,0x0A92,0x0AE3,
	0x0B3C,0x0B74,0x0ADB,0x09A0,0x08CA,0x0847,0x0760,0x056B,
	0x02F7,0x00CA,0xFF08,0xFE58,0xFE0E,0xFD8F,0xFCDC,0xFBCF,
	0xFA1C,0xF8AE,0xF7DF,0xF7F4,0xF7DB,0xF737,0xF6DE,0xF5A2,
	0xF225,0xEBE0,0xE363,0xD732,0xC7B6,0xBFEF,0xC00A,0xC06E,
	0xC079,0xC36E,0xDD06,0xFC42,0x125D,0x1CF1,0x1C3C,0x153A,
	0x0E39,0x0ABC,0x0D70,0x14BC,0x1DAB,0x254C,0x3027,0x393B,
	0x3E8B,0x3FA6,0x3F97,0x3F90,0x3F45,0x3F2B,0x37DC,0x2858,
	0x16EF,0x04A1,0xF4FA,0xEC25,0xEBAB,0xF1D1,0xF9D5,0xFF57,
	0xFECA,0xF7F5,0xED2A,0xE150,0xD712,0xD0FE,0xCE66,0xD00A,
	0xD517,0xDCFD,0xE63D,0xF040,0xFA45,0x041D,0x0D48,0x156A,
	0x1C20,0x2010,0x2055,0x1CAF,0x17AD,0x1431,0x1438,0x18AB,
	0x20DE,0x29D6,0x2FE3,0x30EF,0x2D23,0x260D,0x1CB8,0x122A,
	0x07F0,0xFE2E,0xF698,0xF08F,0xEC1D,0xEA5B,0xE96E,0xE8C5,
	0xE8FE,0xE9E5,0xEC67,0xEE7A,0xEC78,0xE9B1,0xE6CA,0xE362,
	0xE1B6,0xE368,0xE980,0xF309,0xFCDE,0x0593,0x0CAF,0x121F,
	0x1545,0x16EF,0x170A,0x16F4,0x1713,0x15D1,0x13DA,0x142C,
	0x14AE,0x1450,0x13F9,0x149A,0x13E8,0x1243,0x0F7E,0x0AC4,
	0x042B,0xFD7F,0xF626,0xEECE,0xE947,0xE640,0xE627,0xE7F4,
	0xEA0C,0xEB68,0xEBEF,0xEB7F,0xEB24,0xEBC2,0xED04,0xEDEE,
	0xED9A,0xEF43,0xF1F0,0xF4D8,0xF957,0xFF60,0x0572,0x0A1A,
	0x0D2D,0x0F59,0x10A9,0x1118,0x106B,0x0E77,0x0B8B,0x08C9,
	0x0755,0x0672,0x06B4,0x071A,0x06BE,0x04DA,0x0211,0xFECF,
	0xFB9F,0xF8C1,0xF574,0xF1C5,0xEEC5,0xEBFB,0xEA21,0xE9B7,
	0xEB26,0xED11,0xEE71,0xEFBB,0xF167,0xF32A,0xF47B,0xF5AC,
	0xF69A,0xF7BD,0xF8BF,0xFA21,0xFC52,0x0006,0x0418,0x071F,
	0x08EF,0x0AC2,0x0BFB,0x0CA7,0x0C11,0x0AF6,0x0965,0x07FB,
	0x0621,0x0491,0x036E,0x02A0,0x01B6,0x0064,0xFEC5,0xFCC8,
	0xFB3F,0xF8C4,0xF70D,0xF4B0,0xF249,0xF09F,0xF08C,0xF03A,
	0xF098,0xF1F0,0xF365,0xF3BC,0xF6F2,0xF787,0xF7C4,0xFA03,
	0xFAAC,0xFC55,0xFE0E,0xFFD3,0x00BB,0x022E,0x0354,0x04F2,
	0x0703,0x08B9,0x09C9,0x09F5,0x09B2,0x090F,0x07DA,0x0636,
	0x0512,0x0372,0x01AF,0x002F,0xFF88,0xFEBE,0xFD83,0xFC87,
	0xFBA8,0xFA74,0xF95E,0xF8C2,0xF7CB,0xF6C6,0xF629,0xF5FB,
	0xF5BA,0xF63C,0xF676,0xF536,0xF185,0xEA85,0xE075,0xD3F9,
	0xC53A,0xBF5B,0xBFC9,0xC009,0xBF9D,0xC5D4,0xE44A,0x02AE,
	0x17B1,0x1F62,0x1C02,0x12FF,0x0B29,0x094A,0x0D4A,0x1518,
	0x1E40,0x270A,0x2F1F,0x3799,0x3D45,0x3E2C,0x3E4A,0x3E47,
	0x3E7B,0x3CF1,0x318C,0x221A,0x1040,0xFDB7,0xEF60,0xE84A,
	0xEA34,0xF34C,0xFCD4,0x016F,0xFEAA,0xF4DF,0xE7E1,0xDAF8,
	0xD2D1,0xD09B,0xD18D,0xD356,0xD7A3,0xDE86,0xE760,0xF1AD,
	0xFCE2,0x07BD,0x117D,0x1882,0x1D0F,0x1EEE,0x1E02,0x1A6F,
	0x161A,0x12E1,0x13ED,0x19D0,0x22A2,0x2B7B,0x3146,0x31E3,
	0x2D6A,0x229E,0x171D,0x0CE5,0x0418,0xFC73,0xF562,0xEF9E,
	0xEB23,0xE973,0xE99C,0xEAAC,0xEB50,0xEBF6,0xECAF,0xEBF4,
	0xEABE,0xE909,0xE606,0xE2DD,0xE13E,0xE3AC,0xEA29,0xF3B2,
	0xFE89,0x088E,0x1009,0x13E6,0x155E,0x155F,0x1560,0x153A,
	0x14EC,0x1435,0x1379,0x1333,0x13F3,0x14D7,0x14D0,0x142A,
	0x124E,0x1013,0x0D6D,0x09EA,0x0498,0xFD8A,0xF5D0,0xEEE0,
	0xE976,0xE686,0xE701,0xE978,0xEBF5,0xEDDA,0xEEE7,0xEEE9,
	0xEE27,0xEE13,0xEE39,0xEF12,0xF083,0xF269,0xF514,0xF8FA,
	0xFCEF,0x01A0,0x0666,0x0BE2,0x0FDC,0x129F,0x139C,0x141F,
	0x1361,0x10A7,0x0DCA,0x0C29,0x0976,0x0884,0x0AB1,0x09F0,
	0x0976,0x0891,0x058E,0x018D,0xFDDB,0xFA1B,0xF656,0xF2B5,
	0xF01B,0xEDD9,0xEBE8,0xEB6B,0xEC59,0xEE76,0xF05E,0xF23B,
	0xF48F,0xF653,0xF764,0xF7E9,0xF848,0xF962,0xFADA,0xFCAF,
	0xFEAB,0x0184,0x0583,0x08FD,0x0BEF,0x0DA1,0x0E64,0x0E48,
	0x0D1C,0x0BD9,0x0A9D,0x08C0,0x0677,0x04AB,0x0318,0x0241,
	0x021F,0x0163,0xFFCF,0xFDC2,0xFBA7,0xF9CF,0xF7D9,0xF605,
	0xF476,0xF2A9,0xF1DA,0xF11F,0xF0F0,0xF207,0xF482,0xF734,
	0xF8E4,0xFB0E,0xFE0F,0xFF24,0xFFF7,0x0104,0x02B4,0x033B,
	0x037F,0x043F,0x05BB,0x07AA,0x0975,0x0A20,0x0A86,0x0A4F,
	0x0A14,0x0944,0x086E,0x0791,0x0677,0x03CD,0x015B,0x0053,
	0xFF47,0xFE1F,0xFDF2,0xFD8A,0xFC44,0xFAC7,0xF998,0xF8E2,
	0xF812,0xF794,0xF77A,0xF707,0xF662,0xF5D6,0xF510,0xF358,
	0xEF08,0xE731,0xDD2F,0xCFEC,0xC196,0xBEC9,0xBF60,0xBF3D,
	0xBE06,0xCB38,0xEB74,0x06E2,0x1925,0x1EC3,0x19A2,0x1035,
	0x09DD,0x08D5,0x0D4B,0x152E,0x1EDA,0x28BC,0x3068,0x3841,
	0x3D87,0x3DDF,0x3DD8,0x3DA8,0x3E08,0x3A7F,0x2E00,0x1E3D,
	0x0BB1,0xFA17,0xEDC1,0xE8D9,0xEBDF,0xF3A7,0xFC87,0x0025,
	0xFC22,0xF1CD,0xE4E3,0xD955,0xD193,0xCE81,0xCF67,0xD2AC,
	0xD78E,0xDE6D,0xE79B,0xF223,0xFD48,0x0751,0x0F87,0x162B,
	0x1A6E,0x1C26,0x1ADE,0x1719,0x1313,0x1134,0x1265,0x180D,
	0x206A,0x28E7,0x2DF9,0x2D4F,0x2733,0x1DD1,0x129A,0x07C9,
	0xFEBD,0xF71A,0xF197,0xEC74,0xE8EE,0xE741,0xE672,0xE605,
	0xE67A,0xE714,0xE6C8,0xE744,0xE85D,0xE46C,0xE21F,0xDFD6,
	0xDECB,0xE162,0xE877,0xF1F2,0xFCDA,0x0692,0x0DC0,0x12C8,
	0x1462,0x1422,0x1322,0x124C,0x122C,0x121D,0x121D,0x121C,
	0x1207,0x120C,0x1207,0x11A9,0x10ED,0x0F27,0x0C74,0x0759,
	0x010F,0xF9D2,0xF315,0xECFE,0xE841,0xE63B,0xE630,0xE856,
	0xEA57,0xECDA,0xEE84,0xEEA7,0xED9F,0xEC54,0xEC03,0xED33,
	0xEF43,0xF23B,0xF5A1,0xF8E4,0xFCBF,0x01B0,0x06F2,0x0B95,
	0x0F32,0x11A9,0x12A5,0x1249,0x1146,0x0F85,0x0D94,0x0BEF,
	0x09DE,0x087A,0x07FC,0x0735,0x05AF,0x04E7,0x02D2,0xFEE3,
	0xFA3B,0xF597,0xF27E,0xF0EC,0xEEE6,0xECD9,0xEB65,0xEAF0,
	0xEAFD,0xEBF4,0xEE84,0xF205,0xF485,0xF632,0xF661,0xF68D,
	0xF80D,0xF993,0xFA96,0xFC65,0xFFA2,0x0376,0x06C4,0x0A06,
	0x0CD0,0x0E4B,0x0E6D,0x0D8A,0x0CE0,0x0CA6,0x0BBA,0x0A82,
	0x0950,0x072A,0x04DA,0x02FC,0x0156,0xFFB8,0xFF03,0xFF5C,
	0xFE69,0xFC05,0xF949,0xF6FE,0xF469,0xF22B,0xF130,0xF112,
	0xF24A,0xF4A5,0xF6EB,0xF8BB,0xFA7C,0xFBE1,0xFD5B,0xFEE4,
	0x002A,0x0182,0x02F7,0x03E3,0x04F9,0x05B4,0x06E1,0x07E1,
	0x08BB,0x0A4D,0x0B8F,0x0C3D,0x0BFB,0x0AE9,0x0992,0x077C,
	0x0537,0x0322,0x0162,0x0060,0x0067,0x0073,0xFFE8,0xFE8C,
	0xFCF5,0xFB5B,0xFA3F,0xF9BA,0xF92C,0xF891,0xF7C2,0xF7B9,
	0xF753,0xF5A3,0xF2A6,0xED3F,0xE5E0,0xDC40,0xCF09,0xC1EB,
	0xBFC6,0xC08D,0xC01C,0xC395,0xDC89,0xFA2F,0x10EC,0x1C6D,
	0x1D67,0x16CE,0x0F0D,0x0AEF,0x0C43,0x1278,0x1AFB,0x240E,
	0x2C99,0x33EC,0x3BB7,0x3FDA,0x3EBA,0x3F7A,0x3FD7,0x3D02,
	0x335E,0x270C,0x17AD,0x064C,0xF6E5,0xEDD5,0xEC82,0xF1E1,
	0xF9CB,0xFF5E,0xFFDF,0xF993,0xEF05,0xE3D3,0xDAF6,0xD5F4,
	0xD402,0xD536,0xD860,0xDDF1,0xE663,0xF068,0xFAB6,0x0472,
	0x0CD3,0x139E,0x18C5,0x1C25,0x1CAB,0x1ABA,0x1721,0x133A,
	0x1232,0x14FF,0x1C00,0x23E9,0x2A0C,0x2BCE,0x28F1,0x222F,
	0x185E,0x0E56,0x04F1,0xFCA0,0xF5E1,0xF0E8,0xED5F,0xEBD1,
	0xEAC5,0xEA20,0xE991,0xE9A8,0xE9FC,0xEA93,0xEAB6,0xE9D5,
	0xE83F,0xE6A5,0xE565,0xE489,0xE8B5,0xF0F5,0xFB03,0x040F,
	0x0B0B,0x0FE1,0x134D,0x1476,0x1417,0x13ED,0x13B6,0x1343,
	0x122E,0x11AD,0x1269,0x132D,0x12C2,0x1138,0x10EC,0x10AF,
	0x0DF6,0x0A48,0x05B9,0xFEF4,0xF7E4,0xF07F,0xEA80,0xE7ED,
	0xE7F1,0xE9B2,0xEB90,0xEC85,0xECFE,0xEDED,0xEDF3,0xEDE4,
	0xEE10,0xEED6,0xEFE4,0xF07E,0xF236,0xF5D9,0xF9B7,0xFCD6,
	0x0239,0x07E2,0x0C1B,0x0F0E,0x107C,0x10AB,0x1037,0x0EAA,
	0x0BB7,0x0942,0x07DC,0x07C9,0x07C7,0x069B,0x05AF,0x0500,
	0x02DB,0x0019,0xFCAA,0xF8E2,0xF57C,0xF220,0xEF47,0xED42,
	0xEC3A,0xEB90,0xEB2D,0xEC24,0xEDE9,0xF003,0xF24C,0xF49E,
	0xF5ED,0xF643,0xF64E,0xF6FA,0xF845,0xFA48,0xFCCB,0xFF8D,
	0x01DB,0x04BE,0x0743,0x093A,0x0A9B,0x0AC3,0x0A7F,0x099E,
	0x082B,0x0696,0x0523,0x03A3,0x0208,0x00C0,0xFFB2,0xFEEE,
	0xFDEB,0xFC5B,0xFAD3,0xF92D,0xF6C8,0xF474,0xF249,0xF0F8,
	0xEFA0,0xEF04,0xEF05,0xEFE3,0xF1C6,0xF41B,0xF55C,0xF745,
	0xF915,0xFA46,0xFA12,0xFCBA,0xFD70,0xFD99,0xFFE2,0x00AA,
	0x02C7,0x0531,0x060F,0x0680,0x075F,0x07A2,0x07D5,0x072F,
	0x069E,0x05CE,0x046C,0x0257,0x006A,0xFF44,0xFE99,0xFE60,
	0xFDC6,0xFCFB,0xFBC7,0xFA5E,0xF9AE,0xF8ED,0xF7D4,0xF6F3,
	0xF639,0xF62B,0xF624,0xF6EA,0xF838,0xF897,0xF73A,0xF4FE,
	0xF302,0xF0B9,0xED8F,0xE980,0xE5A5,0xE397,0xE5A9,0xECAC,
	0xF6BC,0x01CF,0x0A36,0x0DB2,0x0CB5,0x096D,0x06F8,0x0617,
	0x06B5,0x0897,0x0AB8,0x0CEF,0x0EDC,0x10BF,0x1309,0x1499,
	0x1504,0x1429,0x123D,0x0E26,0x0A98,0x0754,0x01A2,0xFB06,
	0xF511,0xF227,0xF2B4,0xF62B,0xFA1E,0xFD34,0xFD3A,0xFA2E,
	0xF64C,0xF28C,0xF13C,0xF152,0xF1B1,0xF2DE,0xF399,0xF5E0,
	0xF9BF,0xFDB6,0x013D,0x04AC,0x0763,0x0948,0x0B4E,0x0C92,
	0x0CF3,0x0C45,0x0A1D,0x07EC,0x06B9,0x0799,0x094F,0x0BE6,
	0x0E05,0x0E02,0x0C83,0x09E7,0x06FF,0x0374,0x00CA,0xFE77,
	0xFA1B,0xF7E3,0xF712,0xF6D3,0xF75B,0xF8AF,0xF940,0xF925,
	0xF8A7,0xF951,0xFA8B,0xFB64,0xFAB3,0xFA44,0xF9E9,0xF9CF,
	0xFB53,0xFD9D,0x00DF,0x046C,0x079A,0x0959,0x09B5,0x0991,
	0x0945,0x0828,0x06A0,0x0603,0x0581,0x05A4,0x05C2,0x063E,
	0x068D,0x0587,0x044B,0x032F,0x0257,0x01DB,0x00AD,0xFEC3,
	0xFC34,0xF9FB,0xF7E2,0xF67C,0xF68C,0xF77C,0xF91E,0xFA38,
	0xFA8B,0xFA30,0xF9C2,0xF974,0xF8E1,0xF85F,0xF821,0xF871,
	0xF8B0,0xF87E,0xF843,0xF7C9,0xF739,0xF6C4,0xF63D,0xF680,
	0xF69D,0xF5A0,0xF454,0xF2F8,0xF208,0xF063,0xEFBF,0xEF67,
	0xEFAC,0xEF7D,0xF006,0xEEF1,0xEDED,0xEF22,0xECE4,0xEBE5,
	0xEBC2,0xEB6B,0xEABD,0xEA33,0xE9B9,0xE945,0xE909,0xE8B2,
	0xE835,0xE81B,0xE82B,0xE793,0xE776,0xE747,0xE70C,0xE73A,
	0xE759,0xE73F,0xE73E,0xE75F,0xE78C,0xE79E,0xE752,0xE76A,
	0xE774,0xE7B3,0xE7A0,0xE7A5,0xE797,0xE79F,0xE77F,0xE75A,
	0xE7AD,0xE7C1,0xE7F4,0xE85E,0xE8E2,0xE8CE,0xE8E5,0xE88E,
	0xE8CE,0xE90E,0xE97F,0xEA15,0xEAB5,0xEB46,0xEB49,0xEB97,
	0xEBD5,0xEC5C,0xECB3,0xED43,0xED63,0xED74,0xEDF2,0xEE96,
	0xEF7C,0xF1FE,0xF2AD,0xF279,0xF349,0xF3C5,0xF418,0xF473,
	0xF4CD,0xF528,0xF4D3,0xF516,0xF600,0xF67B,0xF6CC,0xF72D,
	0xF78A,0xF82E,0xF8A5,0xF8D9,0xF8C7,0xF903,0xFA03,0xFA22,
	0xF9AE,0xF9F5,0xFA9C,0xFA92,0xFB5D,0xFB8E,0xFBEB,0xFC9C,
	0xFCEC,0xFD08,0xFDAF,0xFD8A,0xFE00,0xFE96,0xFED7,0xFF39,
	0xFFC8,0x002E,0x0072,0x011A,0x0179,0x01F9,0x018F,0x0154,
	0x02FA,0x03FA,0x0419,0x047D,0x048A,0x04C6,0x0547,0x0547,
	0x0593,0x058E,0x0586,0x061C,0x05C5,0x052C,0x057D,0x05AF,
	0x05AB,0x05FA,0x066F,0x06B3,0x06EC,0x0737,0x079A,0x07A2,
	0x07E6,0x07E7,0x0826,0x087E,0x089E,0x08EF,0x0918,0x08E0,
	0x0969,0x0996,0x0961,0x0976,0x09E8,0x0A65,0x0A51,0x0A0F,
	0x0A8D,0x0AD4,0x0AAF,0x0ACB,0x0B43,0x0B81,0x0B49,0x0B63,
	0x0BAC,0x0BD2,0x0BBC,0x0B75,0x0BB1,0x0BE0,0x0C03,0x0C15,
	0x0C1B,0x0C1B,0x0BAB,0x0BD2,0x0BF9,0x0C36,0x0C4C,0x0C5C,
	0x0C79,0x0CD2,0x0C63,0x0CB4,0x0D20,0x0D55,0x0D95,0x0E1C,
	0x0E3C,0x0D47,0x0D3F,0x0F19,0x0CEE,0x0D8C,0x0EA9,0x0E74,
	0x0E1B,0x0E28,0x0DE9,0x0E2A,0x0DC9,0x0D95,0x0E47,0x0E8F,
	0x0E61,0x0E4C,0x0E7F,0x0E73,0x0E34,0x0E1C,0x0E26,0x0E75,
	0x0E1E,0x0E34,0x0DE5,0x0DFF,0x0D9B,0x0D4F,0x0D5F,0x0D86,
	0x0D85,0x0D73,0x0D7B,0x0D8E,0x0D56,0x0CC3,0x0D0F,0x0CDF,
	0x0CE8,0x0D14,0x0D37,0x0D34,0x0CC4,0x0C46,0x0C80,0x0CE0,
	0x0CC7,0x0CEC,0x0CBA,0x0CB3,0x0C2E,0x0C5A,0x0C6B,0x0C5A,
	0x0CB3,0x0C9C,0x0C29,0x0C0C,0x0C35,0x0BD2,0x0BBF,0x0BDB,
	0x0BA9,0x0B24,0x0A2F,0x0896,0x0862,0x0848,0x0842,0x0884,
	0x091C,0x090B,0x08E6,0x089F,0x0874,0x08B9,0x0893,0x0849,
	0x08A3,0x08AF,0x0885,0x0861,0x08FD,0x089A,0x0764,0x07CB,
	0x0867,0x083F,0x087A,0x0856,0x0887,0x08A0,0x0842,0x07EE,
	0x0840,0x0843,0x082E,0x0806,0x0800,0x07DA,0x0792,0x07B0,
	0x076A,0x07A0,0x0749,0x0763,0x079E,0x071C,0x0882,0x0882,
	0x073C,0x06D9,0x06B8,0x0679,0x0691,0x0695,0x0623,0x0638,
	0x063C,0x06DE,0x0722,0x0734,0x072B,0x0759,0x074F,0x0725,
	0x068B,0x0632,0x0684,0x067B,0x0646,0x066A,0x066A,0x061C,
	0x0603,0x05F5,0x05D2,0x054A,0x04FE,0x04ED,0x04D3,0x048D,
	0x049A,0x0489,0x0468,0x0440,0x042A,0x045D,0x041C,0x03D4,
	0x03F5,0x0454,0x03E8,0x03AF,0x037E,0x0348,0x032D,0x030C,
	0x035B,0x0350,0x0324,0x02EB,0x0310,0x02C8,0x02DA,0x0323,
	0x02A2,0x026F,0x02D9,0x0329,0x0320,0x0308,0x0310,0x02E8,
	0x023E,0x01FC,0x023E,0x026A,0x01CC,0x01C5,0x0201,0x01E7,
	0x0184,0x01DA,0x0231,0x00D3,0x019F,0x0266,0x017A,0x01AA,
	0x0186,0x017C,0x0153,0x0139,0x015D,0x016A,0x011C,0x009B,
	0x00EB,0x0130,0x0139,0x0102,0x00AB,0x00B6,0x0109,0x0109,
	0x00A7,0x00B5,0x00A3,0x0090,0x0088,0xFFFB,0x0221,0x0224,
	0x0213,0x02AC,0x0435,0x05E7,0x06C3,0x06F3,0x0702,0x0701,
	0x073F,0x074E,0x07A5,0x0797,0x0799,0x0783,0x07DE,0x08DD,
	0x099F,0x09D8,0x0916,0x0935,0x0A01,0x0B78,0x0D2C,0x0DCF,
	0x0E07,0x0DE4,0x0E49,0x0E83,0x0F73,0x103D,0x1135,0x11E9,
	0x126B,0x1293,0x1273,0x1292,0x1366,0x14FD,0x1532,0x14A5,
	0x13F6,0x14A1,0x15E9,0x16D3,0x163B,0x15D5,0x15EF,0x1640,
	0x16B8,0x16E2,0x1749,0x1773,0x174A,0x1723,0x16FB,0x1750,
	0x1781,0x16FB,0x163E,0x14A1,0x1451,0x1432,0x14B2,0x1541,
	0x150A,0x143C,0x13E6,0x14A9,0x1514,0x146A,0x13CE,0x1396,
	0x1393,0x12D0,0x1213,0x11E2,0x128E,0x12F9,0x11C4,0x10A3,
	0x1054,0x1057,0x0FF2,0x101E,0x107C,0x1080,0x1003,0x0E7E,
	0x0DF2,0x0F03,0x1046,0x100F,0x0E6F,0x0D24,0x0CD5,0x0C52,
	0x0C21,0x0C4F,0x0C9E,0x0C02,0x0A77,0x095D,0x0ACA,0x0BBE,
	0x0A13,0x0831,0x06FD,0x0710,0x07B0,0x06D8,0x0433,0x010E,
	0xFF0C,0xFE4D,0xFCE7,0xF81F,0xF219,0xED74,0xEB5C,0xEC7B,
	0xEF07,0xF050,0xEFB1,0xEF69,0xF0EB,0xF578,0xFAEC,0xFEBA,
	0xFFF8,0x0037,0x0050,0x0106,0x0265,0x02EA,0x03A0,0x03C1,
	0x0431,0x05F5,0x07E8,0x09C0,0x0B78,0x0D3F,0x0FE5,0x1278,
	0x1488,0x152C,0x1483,0x1324,0x1191,0x0FAC,0x0DB0,0x0B5C,
	0x089F,0x0590,0x02AF,0x008D,0xFF05,0xFD67,0xFC02,0xFA74,
	0xF98D,0xF860,0xF6D7,0xF4F9,0xF2BD,0xF088,0xEEDD,0xECD9,
	0xEACD,0xE839,0xE56A,0xE340,0xE2B0,0xE3F3,0xE529,0xE4FB,
	0xE466,0xE593,0xE824,0xE8D3,0xEB8A,0xED82,0xEDF0,0xEEF5,
	0xEEDB,0xEF1E,0xF0CD,0xF22E,0xF2D1,0xF363,0xF46B,0xF574,
	0xF654,0xF795,0xF91E,0xFACB,0xFBE0,0xFC50,0xFD48,0xFDFD,
	0xFDC3,0xFC17,0xFA08,0xF902,0xF8D8,0xF8E9,0xF75D,0xF4B0,
	0xF205,0xF0E6,0xF10E,0xF0ED,0xF127,0xF06E,0xEE72,0xEBC2,
	0xEA41,0xEB4A,0xEC18,0xEAB5,0xE7BF,0xE569,0xE4E8,0xE544,
	0xE4AE,0xE3F7,0xE2B3,0xE311,0xE4B6,0xE63A,0xE743,0xE6D0,
	0xE65D,0xE739,0xE9E7,0xEC75,0xED45,0xEC0D,0xEB44,0xEC94,
	0xEFB8,0xF3B0,0xF446,0xF3EA,0xF40B,0xF422,0xF5B7,0xF842,
	0xF9E7,0xFA8C,0xFA57,0xF9EF,0xF9EA,0xFA96,0xFB1A,0xFACC,
	0xFA2C,0xF967,0xF87B,0xF739,0xF64D,0xF6A2,0xF728,0xF586,
	0xF3D8,0xF364,0xF32F,0xF31E,0xF335,0xF26B,0xF160,0xF09C,
	0xEFE1,0xEF56,0xEF9B,0xEF35,0xEEC7,0xEDFB,0xED87,0xEDAE,
	0xEEF4,0xEFD5,0xEF0F,0xEDE9,0xEEE0,0xF051,0xF082,0xF1A6,
	0xF26D,0xF241,0xF273,0xF303,0xF448,0xF569,0xF573,0xF4E4,
	0xF47E,0xF4D8,0xF663,0xF7C5,0xF7BC,0xF695,0xF68E,0xF828,
	0xF9D5,0xFA2A,0xF960,0xF8BA,0xF7F7,0xF875,0xF926,0xF947,
	0xF801,0xF6A0,0xF6B9,0xF760,0xF7D2,0xF733,0xF623,0xF584,
	0xF5AF,0xF5BD,0xF574,0xF512,0xF4D1,0xF419,0xF39B,0xF3BC,
	0xF3EA,0xF3E1,0xF35D,0xF2E5,0xF2DD,0xF3B4,0xF45F,0xF489,
	0xF4B3,0xF4CD,0xF50B,0xF553,0xF5B2,0xF6A1,0xF7D4,0xF8C8,
	0xF824,0xF6C2,0xF6B0,0xF822,0xF974,0xFA05,0xF986,0xF880,
	0xF831,0xF64A,0xF356,0xEFFD,0xED43,0xE8C2,0xE105,0xD6DE,
	0xCC2B,0xC2E2,0xC12B,0xC3C9,0xC83F,0xCE18,0xD02F,0xD19F,
	0xD6F1,0xE188,0xECC4,0xF5FE,0xFB88,0xFEF4,0x006C,0x0151,
	0x0208,0x041F,0x07D0,0x0A9E,0x0E14,0x11ED,0x1736,0x1C27,
	0x20E6,0x2607,0x2D63,0x35AB,0x3BA8,0x3C93,0x3942,0x350D,
	0x328C,0x30AE,0x2DF1,0x28E4,0x21EB,0x1A85,0x143A,0x103E,
	0x0E9E,0x0DE5,0x0C8E,0x090F,0x05D1,0x032B,0x00CA,0xFD7F,
	0xF8D7,0xF475,0xF061,0xEB83,0xE667,0xE0F1,0xDCC9,0xDA11,
	0xD926,0xDA19,0xDC99,0xDF7A,0xE0E3,0xE305,0xE70F,0xEC64,
	0xF125,0xF3E2,0xF445,0xF4DF,0xF705,0xF8B3,0xFA47,0xFC18,
	0xFEC6,0x01D8,0x04A0,0x0788,0x0B13,0x1001,0x13A3,0x166C,
	0x191A,0x1BBD,0x1DD1,0x1DB8,0x1CDE,0x1B20,0x1958,0x16FF,
	0x1373,0x10A8,0x0F50,0x0D90,0x0998,0x05C3,0x0415,0x041C,
	0x0438,0x02D4,0x0003,0xFD91,0xFADD,0xF7F0,0xF5B0,0xF409,
	0xF198,0xEE52,0xEABA,0xE7F6,0xE71F,0xE77F,0xE8BA,0xE84E,
	0xE92A,0xEAC9,0xECD7,0xEDF0,0xEF8E,0xF262,0xF50B,0xF747,
	0xF937,0xFA8A,0xFB4B,0xFC67,0xFE72,0x00CC,0x02F6,0x0543,
	0x06BB,0x0811,0x0A04,0x0C86,0x0F5F,0x10DC,0x124E,0x1361,
	0x1383,0x1335,0x12D8,0x1196,0x0F7D,0x0D2A,0x0BE3,0x0B36,
	0x099A,0x0797,0x0520,0x0363,0x02DF,0x0252,0x01B2,0x002E,
	0xFE64,0xFC65,0xFAAD,0xF8CB,0xF7C4,0xF6F1,0xF526,0xF2F8,
	0xF108,0xEFC8,0xEFD7,0xF097,0xF12E,0xF0B5,0xF136,0xF2E9,
	0xF4AD,0xF574,0xF600,0xF6FA,0xF88C,0xFA43,0xFB9E,0xFCEE,
	0xFD25,0xFDD3,0xFE48,0xFFD3,0x0190,0x03F5,0x052B,0x0531,
	0x05CA,0x0803,0x0938,0x0985,0x0BF4,0x0AE0,0x0A3E,0x0A6E,
	0x0A49,0x09DB,0x0922,0x07DD,0x066F,0x0524,0x045F,0x040A,
	0x0337,0x0138,0x0024,0x0040,0x000A,0xFEFA,0xFD9C,0xFC1D,
	0xFB1B,0xFA69,0xF958,0xF8F0,0xF7CF,0xF676,0xF592,0xF593,
	0xF6B6,0xF76A,0xF74C,0xF6B8,0xF6A8,0xF7CC,0xF9BD,0xFADD,
	0xFB10,0xFB52,0xFC17,0xFCFD,0xFD6D,0xFD8D,0xFE73,0xFFC7,
	0x00EA,0x013C,0x015A,0x01DD,0x01B5,0x0020,0xFD23,0xFA14,
	0xF6FA,0xF1D9,0xE95D,0xDDE1,0xD2A7,0xCB85,0xCAD4,0xCF43,
	0xD5CA,0xD93D,0xD94F,0xDB8B,0xE2E6,0xEDE6,0xF887,0xFFB9,
	0x0375,0x0579,0x0745,0x08E2,0x094E,0x098F,0x0B89,0x0F4E,
	0x13B3,0x175D,0x19FF,0x1D28,0x224F,0x2AE9,0x33DD,0x39CE,
	0x3C9D,0x3C29,0x38E6,0x36D6,0x3566,0x3316,0x2E41,0x2741,
	0x205A,0x1B20,0x1705,0x12F5,0x0F10,0x0C80,0x0BD7,0x0B76,
	0x0A84,0x07EA,0x03A8,0xFF23,0xFB09,0xF6FF,0xF31D,0xEFAA,
	0xEA1A,0xE3C5,0xDF8D,0xDE42,0xDE3D,0xDEEC,0xE010,0xE1FE,
	0xE43F,0xE75E,0xEB65,0xEFC7,0xF297,0xF427,0xF629,0xF987,
	0xFCE8,0xFE15,0xFD65,0xFD16,0xFF80,0x0379,0x073C,0x09FF,
	0x0C48,0x0EBC,0x11D9,0x160B,0x1A03,0x1CBD,0x1D3F,0x1C93,
	0x1B82,0x1A6C,0x1912,0x1616,0x12CA,0x1003,0x0DC8,0x0B50,
	0x0853,0x05F4,0x04BC,0x0330,0x01EB,0x0098,0xFF3A,0xFDA9,
	0xFAE4,0xF73F,0xF4E5,0xF319,0xF0CD,0xEDF0,0xEAC8,0xE879,
	0xE724,0xE68C,0xE6B6,0xE764,0xE8E1,0xEA75,0xEBBB,0xEDBF,
	0xF06F,0xF257,0xF39C,0xF5B2,0xF76D,0xF8F2,0xFA10,0xFB07,
	0xFBE2,0xFD8A,0x0158,0x00BB,0x02D0,0x05DF,0x0809,0x0993,
	0x0B8A,0x0D5A,0x0EE7,0x0F60,0x0EF2,0x0F31,0x0F70,0x0EC4,
	0x0CA4,0x0AD6,0x0981,0x08A0,0x07EF,0x063C,0x04A2,0x0320,
	0x0208,0x0120,0xFFE7,0xFED6,0xFDD4,0xFCD4,0xFB17,0xF8F8,
	0xF707,0xF55C,0xF435,0xF40F,0xF36E,0xF1F5,0xF101,0xF14D,
	0xF21E,0xF22B,0xF2C6,0xF43D,0xF63C,0xF743,0xF7AF,0xF859,
	0xF9BB,0xFB09,0xFBFB,0xFCC2,0xFE47,0x001C,0x00EF,0x0134,
	0x028A,0x045C,0x0651,0x0716,0x0771,0x08C7,0x0A91,0x0BED,
	0x0B9E,0x0994,0x07CB,0x0858,0x0909,0x0819,0x06C4,0x05AC,
	0x052E,0x0491,0x03CE,0x0309,0x0260,0x01CC,0x0130,0x009D,
	0xFFD0,0xFEAC,0xFD71,0xFD18,0xFC78,0xFA9E,0xF975,0xF89A,
	0xF85C,0xF8B3,0xF88D,0xF76C,0xF676,0xF735,0xF830,0xF8C9,
	0xF973,0xFAD2,0xFB6C,0xFAD6,0xFB22,0xFC9D,0xFE5D,0xFE72,
	0xFEAE,0xFFA5,0x0061,0x00C7,0x0069,0x0196,0x0326,0x01CC,
	0xFE81,0xFA84,0xF72C,0xF409,0xEF14,0xE5D3,0xDA0E,0xCFFD,
	0xCB28,0xCC5D,0xD0FE,0xD659,0xD9C5,0xDABB,0xDD40,0xE56F,
	0xF096,0xFB96,0x02BF,0x0535,0x05AF,0x072D,0x0896,0x09FA,
	0x0BCF,0x0E03,0x10A5,0x143A,0x17F5,0x1C05,0x2089,0x25D4,
	0x2D67,0x3554,0x3B13,0x3CF3,0x3BB2,0x3893,0x35E7,0x3415,
	0x3200,0x2D2F,0x257C,0x1D4C,0x1780,0x14AA,0x12D5,0x1020,
	0x0C85,0x0A41,0x0972,0x08C0,0x066B,0x0224,0xFD03,0xF9A8,
	0xF682,0xF2C6,0xEDDD,0xE78E,0xE272,0xDF1D,0xDDC8,0xDEB5,
	0xDFF1,0xE0D2,0xE253,0xE4C0,0xE8ED,0xEE51,0xF1AB,0xF428,
	0xF773,0xFA8B,0xFAD4,0xFCC6,0xFE66,0xFE5C,0x00BA,0x0367,
	0x0628,0x0905,0x0B7C,0x0E96,0x11D1,0x15DB,0x199E,0x1B72,
	0x1CA7,0x1D36,0x1D65,0x1D05,0x1A96,0x1709,0x14D2,0x12D3,
	0x10F6,0x0E38,0x0AF6,0x079C,0x0590,0x0574,0x04AF,0x030E,
	0x0094,0xFE60,0xFBD9,0xFA0C,0xF7E8,0xF509,0xF23E,0xEF1D,
	0xEC52,0xEACB,0xEA27,0xE947,0xE80E,0xE737,0xE7E8,0xE9F5,
	0xECDD,0xEF83,0xF146,0xF1C7,0xF202,0xF465,0xF7D9,0xFAA8,
	0xFB32,0xFA79,0xFB11,0xFC89,0xFF32,0x01E1,0x031E,0x0529,
	0x0949,0x0B82,0x0D4E,0x0E24,0x0EB7,0x0F81,0x1077,0x1186,
	0x1185,0x0FD2,0x0DE1,0x0C37,0x0BCE,0x0B56,0x0AAC,0x08C1,
	0x0684,0x0452,0x0305,0x01EB,0x028C,0x02B1,0x0009,0xFCBF,
	0xFB0F,0xFA8F,0xF9DC,0xF824,0xF5C2,0xF3CD,0xF26A,0xF1F9,
	0xF284,0xF200,0xF175,0xF19C,0xF262,0xF389,0xF50F,0xF68C,
	0xF712,0xF787,0xF885,0xFA11,0xFB07,0xFA6C,0xFB41,0xFD47,
	0xFECD,0xFFF0,0x0132,0x01AB,0x02B4,0x03B2,0x0489,0x0645,
	0x074B,0x07A3,0x0795,0x06B8,0x0631,0x072F,0x084C,0x07A8,
	0x05B3,0x03C4,0x032B,0x035D,0x039A,0x0329,0x01E3,0x0062,
	0xFF63,0xFF1E,0xFF91,0xFF91,0xFE57,0xFC51,0xFAB4,0xFA2B,
	0xF9BC,0xF8FA,0xF7DB,0xF6A7,0xF60F,0xF5E0,0xF687,0xF64C,
	0xF634,0xF5F9,0xF6C3,0xF817,0xF97F,0xF9E5,0xF9B5,0xFA70,
	0xFB07,0xFBBC,0xFC4F,0xFCCE,0xFD50,0xFD9D,0xFE77,0xFF9D,
	0x00BC,0x0148,0x00F1,0x0018,0xFD4C,0xFA3D,0xF66E,0xF2E7,
	0xECB4,0xE250,0xD613,0xCC33,0xC818,0xCAAE,0xD047,0xD4E1,
	0xD524,0xD7AE,0xDC80,0xE4D9,0xF225,0xFBDE,0x01DE,0x037D,
	0x044E,0x05B1,0x081F,0x09E0,0x0AE5,0x0C2B,0x0F5D,0x13B4,
	0x1833,0x1CC0,0x210B,0x26EE,0x2E30,0x361C,0x3C0A,0x3E65,
	0x3CB9,0x392A,0x35AC,0x33EC,0x318A,0x2CB0,0x2558,0x1DF9,
	0x184F,0x1475,0x11B0,0x0EF1,0x0D2E,0x0C3E,0x0B70,0x0948,
	0x05BC,0x01CF,0xFD98,0xFA17,0xF628,0xF1F2,0xED60,0xE76C,
	0xE164,0xDD7F,0xDCDB,0xDE57,0xE00F,0xE113,0xE2C1,0xE59C,
	0xE98C,0xEE50,0xF1C2,0xF4A9,0xF774,0xF99F,0xFB85,0xFC74,
	0xFCD0,0xFC3C,0xFC31,0xFFB1,0x0365,0x0702,0x0A09,0x0C8F,
	0x0F6F,0x1320,0x1726,0x1A4A,0x1B89,0x1B1C,0x1A54,0x1A21,
	0x189A,0x1564,0x11F4,0x0FE0,0x0D27,0x0A60,0x07E6,0x0523,
	0x02C3,0x0151,0x00EF,0x0037,0xFF46,0xFDDA,0xFA83,0xF740,
	0xF4D4,0xF354,0xF202,0xEF0C,0xEBAB,0xE89E,0xE78C,0xE627,
	0xE580,0xE629,0xE7A3,0xE9A1,0xEBB1,0xEE2A,0xEE90,0xEF21,
	0xF18D,0xF536,0xF89E,0xFA71,0xF9F5,0xF8BF,0xF95F,0xFC22,
	0x0035,0x036D,0x0553,0x06A7,0x0781,0x090C,0x0B83,0x0E8B,
	0x1088,0x1194,0x117F,0x110C,0x1095,0x0FF8,0x0E2A,0x0C7F,
	0x0B86,0x0AE1,0x09DC,0x07E4,0x0565,0x035C,0x0229,0x015F,
	0x0246,0x02AA,0x00E5,0xFCB8,0xF930,0xF7FB,0xF935,0xF9DB,
	0xF846,0xF516,0xF1E3,0xF095,0xF085,0xF17F,0xF271,0xF313,
	0xF2E1,0xF364,0xF4D6,0xF5DB,0xF608,0xF6E8,0xF904,0xFB48,
	0xFC85,0xFBF8,0xFBA7,0xFC95,0xFDBF,0xFF9E,0x016F,0x02CA,
	0x03E0,0x03E4,0x0488,0x054D,0x0817,0x0A49,0x09E9,0x0961,
	0x09C6,0x0920,0x082E,0x09EA,0x080F,0x066E,0x0625,0x057A,
	0x055F,0x046B,0x02D7,0x0168,0x00F1,0x0137,0x00D9,0xFF9E,
	0xFDA7,0xFBBF,0xFA87,0xFA54,0xFA05,0xF919,0xF7A8,0xF600,
	0xF593,0xF619,0xF629,0xF61D,0xF5D0,0xF64A,0xF76F,0xF7D3,
	0xF7C9,0xF850,0xF969,0xFA38,0xFB25,0xFC45,0xFC95,0xFC9D,
	0xFC3D,0xFCE9,0xFEF5,0x015F,0x02DE,0x0190,0xFFB2,0xFE7C,
	0xFCBB,0xF9BE,0xF63C,0xF177,0xEA44,0xDF3F,0xD295,0xCA3E,
	0xC960,0xCD4B,0xD1E2,0xD43A,0xD59A,0xD8EA,0xDFAB,0xEB33,
	0xF6A8,0xFEAE,0x0320,0x050D,0x06B6,0x081A,0x092C,0x09BD,
	0x0AAD,0x0D42,0x115B,0x15B2,0x1905,0x1C56,0x2178,0x283B,
	0x30BD,0x37EE,0x3B8F,0x3B86,0x3A9E,0x3857,0x3578,0x327B,
	0x2E65,0x28A1,0x2287,0x1BE5,0x1614,0x11C8,0x0EDB,0x0D62,
	0x0C53,0x0A85,0x08E7,0x0702,0x0456,0xFF61,0xFA84,0xF789,
	0xF496,0xEFB0,0xE963,0xE31E,0xDE15,0xDB90,0xDBFC,0xDD6C,
	0xDF7D,0xE1AE,0xE3A6,0xE642,0xE9D2,0xEE2B,0xF193,0xF3F9,
	0xF69E,0xF9F3,0xFBCC,0xFB2A,0xFA0C,0xFAC5,0xFD6A,0x016F,
	0x0592,0x0826,0x095F,0x0ADF,0x0E3F,0x136C,0x189B,0x1B27,
	0x1B3F,0x19C1,0x18D1,0x188E,0x1839,0x1587,0x114D,0x0D97,
	0x0BA9,0x0A76,0x07E1,0x0442,0x011F,0xFFFB,0x0015,0x000A,
	0xFF01,0xFC53,0xF867,0xF4C4,0xF27A,0xF1B2,0xF0CF,0xEE5D,
	0xE9DB,0xE596,0xE40F,0xE44C,0xE542,0xE65E,0xE6FA,0xE819,
	0xEA48,0xEC9B,0xEE57,0xEFBA,0xF16E,0xF387,0xF5E4,0xF8FD,
	0xF9EE,0xF984,0xF952,0xFAE5,0xFE0A,0x01DC,0x04E8,0x055A,
	0x05B7,0x0889,0x08F2,0x0BD6,0x0E9D,0x0EF6,0x0EAC,0x0DD8,
	0x0CF2,0x0CAC,0x0C24,0x0A57,0x0824,0x06A7,0x06B5,0x0655,
	0x04A8,0x01D2,0xFF76,0xFF3D,0xFFBA,0xFFB3,0xFD98,0xFB2B,
	0xF919,0xF775,0xF676,0xF662,0xF556,0xF33D,0xF0F9,0xEFB9,
	0xF04F,0xF10F,0xF0AE,0xEFE0,0xF115,0xF374,0xF54E,0xF625,
	0xF61D,0xF64F,0xF7FE,0xFAC6,0xFC9F,0xFD6E,0xFD76,0xFD9E,
	0xFE01,0xFFF8,0x029B,0x04F7,0x05CD,0x0554,0x0670,0x08E9,
	0x0AA7,0x0A85,0x09DF,0x0A32,0x0B46,0x0BC0,0x0B36,0x09E2,
	0x07A4,0x0486,0x03FF,0x055D,0x0607,0x046E,0x01B2,0x0005,
	0x0068,0x0195,0x00E8,0xFEFF,0xFD5E,0xFB5E,0xFAC7,0xFAE9,
	0xFB26,0xFA57,0xF926,0xF7F5,0xF6D2,0xF795,0xF807,0xF752,
	0xF701,0xF840,0xF9BE,0xFA3A,0xFA89,0xFABA,0xFAC9,0xFB66,
	0xFC81,0xFE6C,0x0037,0x0035,0xFE9D,0xFE0A,0xFFD9,0x0300,
	0x049A,0x0346,0xFF15,0xFB04,0xF991,0xF725,0xF1CE,0xE8EC,
	0xDD70,0xD22C,0xCAD9,0xCAD5,0xCFB1,0xD404,0xD68B,0xD8AE,
	0xDCE3,0xE4DC,0xEF30,0xF8FF,0xFFA3,0x0488,0x07E8,0x09FC,
	0x0A5B,0x09E9,0x0A67,0x0CC4,0x1080,0x1528,0x1993,0x1CF9,
	0x1F96,0x237B,0x2AE0,0x348B,0x3C13,0x3DB1,0x3B1B,0x3859,
	0x3762,0x3697,0x33BA,0x2DA2,0x263E,0x1FB3,0x1A68,0x166E,
	0x1358,0x107C,0x0D41,0x0A86,0x09F5,0x09CE,0x0798,0x02F3,
	0xFDBF,0xF9E7,0xF77F,0xF414,0xEE6B,0xE7CA,0xE26E,0xDEB9,
	0xDD33,0xDD9E,0xDEF0,0xE029,0xE123,0xE2DC,0xE72D,0xECE9,
	0xF134,0xF33A,0xF3E6,0xF655,0xFA4E,0xFD40,0xFD67,0xFCC7,
	0xFDF1,0xFEAD,0x03E0,0x0937,0x0AC3,0x0BD3,0x0D86,0x113A,
	0x1673,0x1B7A,0x1D67,0x1B71,0x1836,0x177C,0x188E,0x1842,
	0x14EC,0x0FDD,0x0B5D,0x08BF,0x0822,0x07A4,0x0575,0x0250,
	0x001C,0xFF5B,0xFF09,0xFE66,0xFBAD,0xF7BE,0xF47E,0xF2F2,
	0xF272,0xF053,0xEC1A,0xE7A2,0xE5A6,0xE68F,0xE80C,0xE838,
	0xE76C,0xE758,0xE8DB,0xEBAC,0xEE94,0xF0B3,0xF19A,0xF1D2,
	0xF2EB,0xF603,0xF899,0xF97E,0xF8E5,0xF944,0xFBA4,0xFEEB,
	0x018E,0x02F8,0x03CE,0x04BB,0x0696,0x0A34,0x0E91,0x11AD,
	0x0FDC,0x0D50,0x0D20,0x0DFA,0x0DD4,0x0BE4,0x0990,0x07D0,
	0x06DA,0x05C5,0x0416,0x028A,0x00FA,0xFF71,0xFF15,0xFF64,
	0xFEE0,0xFC1E,0xF7BA,0xF6DF,0xF7EB,0xF6F2,0xF482,0xF1A5,
	0xEF81,0xEF08,0xEF7F,0xEFBA,0xEFA1,0xEFA9,0xF00F,0xEFEA,
	0xF0F6,0xF347,0xF5DE,0xF5FE,0xF50B,0xF4C2,0xF752,0xFA44,
	0xFB2E,0xFABE,0xFB8C,0xFD3C,0xFE7E,0x0055,0x0200,0x02F6,
	0x03B1,0x04A6,0x0640,0x090C,0x09F0,0x092A,0x075F,0x05FC,
	0x0688,0x07C5,0x07B2,0x05A1,0x037F,0x0250,0x01AC,0x01B2,
	0x019D,0x0177,0xFFC7,0xFD87,0xFC2D,0xFC8D,0xFD6F,0xFCEE,
	0xFA5F,0xF800,0xF732,0xF80E,0xF826,0xF6ED,0xF52A,0xF410,
	0xF41C,0xF59D,0xF6B8,0xF6F0,0xF5EA,0xF4F0,0xF511,0xF72D,
	0xFA69,0xFB8B,0xFA28,0xF8B5,0xF96A,0xFB50,0xFDBE,0xFEC7,
	0xFE5C,0xFE02,0xFF02,0x00E9,0x01F7,0x0116,0xFF36,0xFC5D,
	0xFA9D,0xFA16,0xF6E8,0xEE91,0xE3DD,0xDB44,0xD9DC,0xDDBA,
	0xE232,0xE352,0xE1F1,0xE125,0xE522,0xED94,0xF6C6,0xFB94,
	0xFF9E,0x00D2,0x00F4,0x044B,0x0579,0x04C3,0x037F,0x0522,
	0x0981,0x0EB2,0x1106,0x1141,0x11D7,0x162A,0x1DF2,0x257D,
	0x2971,0x2966,0x277E,0x2547,0x24B6,0x2510,0x2390,0x1F18,
	0x1932,0x143B,0x1116,0x0F48,0x0C90,0x0A18,0x0849,0x08AD,
	0x0996,0x08A5,0x0564,0x0167,0xFE7B,0xFCF9,0xFBF4,0xF97F,
	0xF4E2,0xEF00,0xEAA6,0xE8CD,0xE9AF,0xEB3C,0xEB2A,0xEA77,
	0xEAE8,0xEE46,0xF247,0xF55E,0xF66F,0xF77D,0xF985,0xFBD0,
	0xFDD7,0xFE7F,0xFE42,0xFDC5,0xFE7B,0x0129,0x04C9,0x0656,
	0x054B,0x0513,0x08FC,0x0CCC,0x0FCD,0x1169,0x11EE,0x117A,
	0x10F5,0x111B,0x1132,0x104C,0x0DA6,0x0ABE,0x0933,0x0831,
	0x06FA,0x04EC,0x0338,0x0188,0x018F,0x0232,0x0194,0xFF28,
	0xFCCD,0xFAEB,0xF96C,0xF867,0xF816,0xF63E,0xF2A1,0xEF21,
	0xEE41,0xF033,0xF168,0xF09A,0xF012,0xF127,0xF2B2,0xF442,
	0xF592,0xF660,0xF760,0xF89A,0xFA87,0xFB67,0xFC20,0xFBDC,
	0xFADD,0xFB9E,0xFDF4,0x00E0,0x0225,0x0266,0x0313,0x0525,
	0x0809,0x0A02,0x0BCC,0x0C92,0x0BE8,0x0B10,0x0A90,0x0A93,
	0x0A8B,0x096E,0x07FB,0x0652,0x0584,0x0524,0x04E4,0x0377,
	0x01A7,0x00A6,0x00F1,0x0148,0x00B4,0xFEF6,0xFD49,0xFBD9,
	0xFAFE,0xFB1F,0xFB09,0xF9AC,0xF7A2,0xF5FD,0xF5C1,0xF642,
	0xF6B5,0xF6D4,0xF6E1,0xF761,0xF820,0xF849,0xF87C,0xF967,
	0xFABA,0xFBFB,0xFBDF,0xFBD3,0xFC36,0xFCD1,0xFD8C,0xFE8F,
	0x0032,0x01B3,0x01EE,0x018F,0x0143,0x0243,0x0472,0x0689,
	0x067F,0x05A8,0x0457,0x0477,0x05A5,0x0643,0x057B,0x0481,
	0x02B3,0x0179,0x0415,0x03BD,0x0188,0xFFE8,0xFE97,0xFEC6,
	0x0006,0x0016,0xFE60,0xFBD4,0xF9E2,0xFA53,0xFB7A,0xFBBD,
	0xFB16,0xF9AB,0xF873,0xF833,0xF8C4,0xF933,0xF95C,0xF841,
	0xF872,0xF9C9,0xFAE2,0xFAF2,0xF988,0xF927,0xFAE5,0xFD7E,
	0xFE75,0xFD7E,0xFC1B,0xFBE9,0xFD9D,0xFF20,0x0063,0x005D,
	0xFF3F,0xFDCB,0xFDE5,0xFEDF,0xFFC8,0xFED9,0xFC13,0xF8FE,
	0xF708,0xF742,0xF7D8,0xF7DB,0xF7BB,0xF70A,0xF745,0xF914,
	0xFB32,0xFCBF,0xFD99,0xFDFB,0xFF42,0x0024,0x01E5,0x0227,
	0x017D,0x01C1,0x01EE,0x01B7,0x0183,0x0181,0x01F2,0x02B0,
	0x0482,0x06A6,0x0827,0x0859,0x07AD,0x07FB,0x08EA,0x08DA,
	0x07FE,0x066C,0x05DF,0x066E,0x0516,0x030B,0x01C5,0x01EA,
	0x0174,0x0126,0x0133,0x01D6,0x01BA,0x0083,0xFF62,0xFEE9,
	0xFF7B,0xFF80,0xFD88,0xFC00,0xFBF3,0xFBB4,0xFAB0,0xF9A3,
	0xF90D,0xF952,0xF9AA,0xF89C,0xF748,0xF83B,0xF8FF,0xF8B1,
	0xF81E,0xF763,0xF6D8,0xF5FB,0xF522,0xF406,0xF34C,0xF253,
	0xF14F,0xF0D8,0xF098,0xF19B,0xF272,0xF2C2,0xF308,0xF35E,
	0xF433,0xF3EE,0xF38B,0xF38F,0xF35E,0xF3DF,0xF429,0xF3A4,
	0xF2EE,0xF274,0xF242,0xF218,0xF1B2,0xF16C,0xF0E0,0xF075,
	0xEF82,0xEECD,0xEEC1,0xEE2B,0xED37,0xECE8,0xECC5,0xEBF5,
	0xEB6A,0xEB00,0xEAA0,0xEA4B,0xE9E1,0xE9D0,0xE9E5,0xE970,
	0xE961,0xE910,0xE8EE,0xE8F2,0xE8BD,0xE84F,0xE82B,0xE811,
	0xE7C1,0xE797,0xE7D2,0xE7A8,0xE799,0xE77B,0xE812,0xE843,
	0xE830,0xE86F,0xE8C1,0xE83D,0xE873,0xE958,0xE96F,0xE9BF,
	0xEB8D,0xE9D8,0xEA91,0xEB6D,0xEB61,0xEB74,0xEB71,0xEB98,
	0xEC08,0xECD1,0xED24,0xED87,0xEDC7,0xEE1C,0xEE51,0xEF15,
	0xEFB0,0xEFF5,0xEFDB,0xEFE8,0xF09F,0xF19A,0xF218,0xF213,
	0xF230,0xF2E2,0xF33B,0xF42D,0xF4E6,0xF4ED,0xF54A,0xF579,
	0xF606,0xF692,0xF713,0xF73D,0xF770,0xF7F0,0xF8C1,0xF96B,
	0xF9B3,0xF9BD,0xFA59,0xFABD,0xFB46,0xFBE1,0xFC01,0xFC26,
	0xFC69,0xFCE5,0xFD8E,0xFDE5,0xFEB5,0xFF19,0xFF1C,0xFF69,
	0x005B,0x011C,0x0130,0x0193,0x01B4,0x01FE,0x01D6,0x0165,
	0x000F,0x0041,0x00E5,0x01A8,0x0266,0x02EE,0x0315,0x0317,
	0x0355,0x03D8,0x043A,0x04C3,0x04B4,0x0512,0x05B5,0x064D,
	0x064D,0x06E0,0x074A,0x0680,0x06F8,0x07D9,0x0848,0x083D,
	0x08AF,0x08F5,0x090A,0x09B4,0x0A20,0x0A00,0x0A39,0x0A63,
	0x0A96,0x0B67,0x0C06,0x0BAD,0x0B93,0x0BEB,0x0C2D,0x0C24,
	0x0C8E,0x0CCF,0x0C91,0x0DC0,0x0DE0,0x0CAB,0x0CC4,0x0D2B,
	0x0DB4,0x0DFD,0x0E2F,0x0E1F,0x0DDE,0x0DF0,0x0E35,0x0ED8,
	0x0F38,0x0F61,0x0FFF,0x102B,0x0FBF,0x0F7C,0x0F5D,0x0F54,
	0x0FCC,0x0FC7,0x0F93,0x0F52,0x0F96,0x0FB4,0x0FC0,0x0F9D,
	0x0F8A,0x0F65,0x0F4C,0x0F46,0x0F63,0x0F95,0x0F41,0x0EB0,
	0x0E81,0x0EB4,0x0EAC,0x0E99,0x0EAB,0x0E89,0x0E58,0x0E22,
	0x0E27,0x0E25,0x0E03,0x0D9C,0x0D70,0x0D3E,0x0D32,0x0D22,
	0x0D1F,0x0CE2,0x0CA8,0x0CFD,0x0D2C,0x0D0B,0x0CED,0x0CD0,
	0x0CCA,0x0CE6,0x0CF4,0x0CDF,0x0CB8,0x0C7E,0x0C4A,0x0CA9,
	0x0C99,0x0BF7,0x0BCB,0x0C11,0x0C30,0x0C0B,0x0C61,0x0C94,
	0x0A4F,0x0A81,0x0BC4,0x0ADD,0x0B7E,0x0BB8,0x0B53,0x0B0D,
	0x0B27,0x0B54,0x0B25,0x0B3F,0x0AD1,0x0AA0,0x0A55,0x0A89,
	0x0AEC,0x0AB4,0x0AAA,0x0AB5,0x0AAC,0x0ACD,0x0A90,0x0A36,
	0x0A22,0x09FB,0x09E6,0x098C,0x0959,0x098F,0x09C3,0x094F,
	0x0890,0x086B,0x08E1,0x08D6,0x08B5,0x0904,0x08BD,0x0886,
	0x08AB,0x08CD,0x086D,0x085B,0x0824,0x07F0,0x07D7,0x07BF,
	0x07AF,0x0779,0x0769,0x079E,0x07AC,0x075C,0x06A2,0x0619,
	0x0640,0x069D,0x06CD,0x06BA,0x06E2,0x0777,0x08A5,0x082F,
	0x085D,0x0815,0x07E1,0x07A5,0x0779,0x0734,0x0723,0x074E,
	0x07BA,0x078E,0x0753,0x06D4,0x06C9,0x064F,0x064B,0x0604,
	0x05C5,0x0547,0x0623,0x0696,0x05CC,0x0527,0x0532,0x0551,
	0x04CE,0x04B9,0x04FF,0x04FA,0x0476,0x043A,0x048A,0x04A5,
	0x0475,0x049E,0x0422,0x042A,0x03FF,0x03EC,0x03AF,0x036C,
	0x0370,0x03A5,0x0390,0x0280,0x02DA,0x03B3,0x0408,0x03D4,
	0x035E,0x030A,0x02DE,0x02CA,0x0279,0x0262,0x01DD,0x0196,
	0x0186,0x010C,0x009D,0x00AA,0x009D,0xFFEC,0xFF38,0xFD51,
	0xFD8E,0xFDD4,0xFDDE,0xFDC9,0xFDD0,0xFE4A,0xFF14,0xFFC4,
	0xFF3B,0xFE95,0xFF00,0x0079,0x0236,0x02DF,0x0255,0x01CB,
	0x02A3,0x0451,0x055C,0x065D,0x0761,0x07D3,0x07EC,0x089F,
	0x097A,0x099B,0x0A01,0x09E7,0x0A6C,0x0B08,0x0B68,0x0AF5,
	0x0A75,0x0B43,0x0CC6,0x0E80,0x0DA1,0x0C12,0x0B85,0x0CFC,
	0x0EF1,0x10C4,0x12B6,0x1166,0x10E0,0x1126,0x11FE,0x1359,
	0x1350,0x1259,0x132A,0x1501,0x15B0,0x15A0,0x1522,0x15AB,
	0x1774,0x194C,0x1997,0x196A,0x1915,0x1820,0x1814,0x190A,
	0x1AC5,0x1B0B,0x194B,0x1820,0x1957,0x1AB2,0x1A3B,0x18E2,
	0x18E8,0x1999,0x1A40,0x1969,0x186C,0x1822,0x186D,0x1841,
	0x17E7,0x1795,0x17BF,0x171E,0x157A,0x1579,0x1692,0x16C3,
	0x155E,0x1366,0x1319,0x1458,0x14CC,0x13F1,0x11BF,0x10AC,
	0x1152,0x11D7,0x116F,0x109B,0x1062,0x1041,0x0F77,0x0E6E,
	0x0E59,0x0F3B,0x0F52,0x0D7C,0x0BE3,0x0B6E,0x0BD0,0x0C46,
	0x0A5A,0x0942,0x09B3,0x09FC,0x0982,0x089A,0x07DB,0x0484,
	0x0386,0x02B9,0xFFCB,0xFCC8,0xF759,0xF0D1,0xEC45,0xEC17,
	0xEEE1,0xF08B,0xF077,0xEFB2,0xEFE1,0xF195,0xF306,0xF41F,
	0xF3D8,0xF2BF,0xF104,0xEEDC,0xEE8E,0xEF4A,0xF012,0xF2EE,
	0xF6F8,0xFB0D,0xFE19,0xFF73,0x0115,0x03E7,0x06AC,0x081C,
	0x0838,0x07A5,0x06D3,0x06A2,0x0767,0x0A25,0x0CBB,0x0E63,
	0x0F19,0x1090,0x13C3,0x15A7,0x155A,0x1384,0x123D,0x1219,
	0x1170,0x0F98,0x0D3A,0x0ADC,0x0995,0x0A45,0x0BFA,0x0C06,
	0x0A37,0x0776,0x0630,0x05CA,0x062F,0x050B,0xFFC0,0xFB8A,
	0xF92C,0xF74A,0xF511,0xF32C,0xF1C7,0xF031,0xEF15,0xEEDE,
	0xEE80,0xECC9,0xEA8D,0xE858,0xE6AE,0xE61A,0xE485,0xE13B,
	0xDF09,0xE072,0xE21E,0xE1FB,0xE0E9,0xE184,0xE277,0xE3A6,
	0xE4E4,0xE51C,0xE4BA,0xE486,0xE439,0xE4AC,0xE5AE,0xE685,
	0xE78D,0xE858,0xEA18,0xEC76,0xEF54,0xF0CE,0xF145,0xF247,
	0xF429,0xF575,0xF536,0xF519,0xF583,0xF644,0xF7AE,0xF9DD,
	0xFB12,0xFA79,0xF983,0xFA25,0xFBFF,0xFD6D,0xFD64,0xFB6D,
	0xF898,0xF78B,0xF947,0xFA98,0xF954,0xF660,0xF489,0xF4A6,
	0xF620,0xF78B,0xF771,0xF588,0xF332,0xF23F,0xF2D7,0xF2A1,
	0xF0F4,0xEEAA,0xED75,0xED3B,0xED5E,0xEC31,0xEA5A,0xE9EA,
	0xEA56,0xEAFC,0xEB0F,0xEADF,0xE98E,0xE739,0xE624,0xE72B,
	0xE8D7,0xE890,0xE635,0xE463,0xE4FA,0xE66D,0xE7F8,0xE92C,
	0xE950,0xE927,0xE8CB,0xE9EB,0xEBD0,0xEC5D,0xEBC4,0xEAA7,
	0xEB45,0xED8C,0xEF07,0xEEE1,0xEE60,0xEFED,0xF28B,0xF415,
	0xF455,0xF3CE,0xF489,0xF62D,0xF728,0xF606,0xF7E5,0xF85D,
	0xF76E,0xF861,0xF830,0xF8D5,0xF9DC,0xFA21,0xFA5A,0xFB66,
	0xFB09,0xFA5A,0xF97F,0xF94E,0xFA50,0xFAAB,0xF9DD,0xF8FC,
	0xF81D,0xF7DD,0xF80F,0xF826,0xF879,0xF8A0,0xF852,0xF6DF,
	0xF649,0xF58E,0xF4E8,0xF46C,0xF430,0xF539,0xF4C3,0xF2D4,
	0xF150,0xF1C4,0xF394,0xF4E2,0xF48D,0xF328,0xF21D,0xF1F6,
	0xF21E,0xF2D1,0xF447,0xF46A,0xF366,0xF255,0xF284,0xF3C5,
	0xF4B7,0xF5CD,0xF6C8,0xF6B5,0xF66B,0xF6C5,0xF718,0xF73E,
	0xF6F8,0xF5C4,0xF303,0xEE0D,0xE7BF,0xE17D,0xD858,0xCC9D,
	0xC1D4,0xBEB5,0xBEDB,0xBFF0,0xC7AC,0xCB83,0xCC04,0xCC8D,
	0xCF87,0xD44B,0xD87B,0xDA30,0xD81D,0xD3C5,0xD0EE,0xD258,
	0xD800,0xDDC5,0xE3EF,0xED1F,0xF844,0x02A8,0x09D2,0x0E79,
	0x1316,0x18EC,0x1F0E,0x2285,0x2213,0x2020,0x2045,0x244E,
	0x2BBD,0x3407,0x3AAF,0x3F35,0x3FEF,0x3FFF,0x4007,0x3FF8,
	0x4009,0x4059,0x40AD,0x4029,0x3CAF,0x381D,0x358F,0x34FE,
	0x35F2,0x3624,0x3544,0x32B6,0x2E3A,0x2A11,0x2695,0x23E2,
	0x1F55,0x1763,0x0DA2,0x059A,0x001B,0xFC94,0xFA37,0xF804,
	0xF579,0xF252,0xEF4B,0xECF7,0xEADF,0xE7A2,0xE3D6,0xDF5A,
	0xDBA8,0xD7E2,0xD446,0xD1D4,0xD116,0xD2DF,0xD4B8,0xD615,
	0xD79B,0xD8F3,0xDAE0,0xDC4A,0xDE0D,0xDFE8,0xE0F7,0xE0B3,
	0xE101,0xE312,0xE662,0xE936,0xEC65,0xF04E,0xF5FE,0xFBB3,
	0xFED4,0x00E0,0x0381,0x0745,0x0ABE,0x0C2E,0x0C8B,0x0D91,
	0x0F55,0x112F,0x1314,0x158A,0x17EB,0x1AAB,0x1BFE,0x1C6D,
	0x1C8B,0x1DD4,0x1D47,0x1B69,0x1A03,0x19D7,0x179C,0x13DA,
	0x1384,0x11D3,0x1115,0x1111,0x0F79,0x0E26,0x0C4E,0x09CF,
	0x0684,0x03C5,0x01CE,0xFF1D,0xFB9A,0xF773,0xF47B,0xF344,
	0xF175,0xF031,0xEFC2,0xEF67,0xEE3A,0xEBB6,0xEA46,0xE9CD,
	0xE88C,0xE69E,0xE545,0xE543,0xE54F,0xE42B,0xE310,0xE387,
	0xE557,0xE6DF,0xE83E,0xE991,0xEAD1,0xEBD0,0xECAB,0xEDD1,
	0xEF69,0xF057,0xF11F,0xF255,0xF4A0,0xF73F,0xF873,0xF97B,
	0xFBBB,0xFEC3,0x022A,0x0490,0x059D,0x0562,0x0608,0x07D4,
	0x09A9,0x0A69,0x0B0F,0x0B92,0x0E96,0x107E,0x10A1,0x1116,
	0x113E,0x116F,0x11D3,0x11C2,0x113F,0x0F68,0x0DE5,0x0D31,
	0x0CBC,0x0CA7,0x0BEB,0x09C1,0x072B,0x069C,0x079D,0x0786,
	0x0601,0x0428,0x019B,0xFF83,0xFF54,0xFEDC,0xFCE3,0xFAD0,
	0xF963,0xF8AB,0xF845,0xF784,0xF66F,0xF601,0xF607,0xF60C,
	0xF52D,0xF3E5,0xF29F,0xF22C,0xF2B7,0xF360,0xF354,0xF31E,
	0xF2AE,0xF238,0xF338,0xF657,0xF7D1,0xF6EF,0xF737,0xF8EA,
	0xFB12,0xFB41,0xF9CB,0xF9C0,0xFAD9,0xFA82,0xF748,0xF19B,
	0xE9B1,0xE1B7,0xD83A,0xCCAA,0xC1CC,0xBE42,0xBE14,0xC164,
	0xCBD3,0xD1F9,0xD31B,0xD201,0xD3C8,0xDA09,0xE035,0xE20F,
	0xDD82,0xD738,0xD460,0xD6DB,0xDD1F,0xE4AC,0xEDFC,0xF874,
	0x0329,0x0C89,0x1446,0x1B0D,0x20C1,0x253C,0x28DF,0x2B9D,
	0x2C41,0x2AEF,0x2A11,0x2DB0,0x3699,0x3DD8,0x3E4F,0x3E84,
	0x3EA3,0x3E92,0x3E88,0x3E7E,0x3EA4,0x3E8F,0x3E4F,0x3E58,
	0x3E86,0x3E20,0x3C0F,0x3B87,0x3B88,0x3A35,0x3947,0x3886,
	0x35EE,0x3081,0x2A89,0x24B0,0x1E23,0x1684,0x0F2C,0x04AB,
	0xFEC0,0xFBE0,0xF8DF,0xF627,0xF382,0xF192,0xEFC4,0xEDEA,
	0xE982,0xE574,0xE14E,0xDD2B,0xD90A,0xD4D0,0xD0EB,0xCE7B,
	0xCEA3,0xD024,0xD2E8,0xD576,0xD7BC,0xD9F4,0xDBD6,0xDCF7,
	0xDE67,0xDFEB,0xE19D,0xE299,0xE27C,0xE2C9,0xE5A2,0xEAC6,
	0xF09B,0xF612,0xFA7D,0xFED5,0x02BA,0x05D0,0x09C3,0x0D24,
	0x0EC0,0x0F18,0x0F17,0x107F,0x1368,0x1583,0x16B8,0x18CB,
	0x1C3F,0x1FA0,0x20EB,0x20E6,0x20D1,0x219D,0x21D7,0x2075,
	0x1D54,0x1AAB,0x18F0,0x17AB,0x15F3,0x138B,0x1056,0x0F13,
	0x0D66,0x0C98,0x0BE0,0x09FE,0x065A,0x018B,0xFDB8,0xFB40,
	0xF8B5,0xF500,0xF170,0xEF4C,0xEF0A,0xEE20,0xEC04,0xEB44,
	0xEAC0,0xE966,0xE894,0xE72D,0xE5C6,0xE3C0,0xE19A,0xE067,
	0xE0B3,0xE2C1,0xE396,0xE2B0,0xE25D,0xE43C,0xE7AD,0xEA9C,
	0xEBE2,0xEC0E,0xEC7E,0xED14,0xEEB4,0xF0DA,0xF2BC,0xF412,
	0xF591,0xF8DE,0xFBB1,0xFCBE,0xFE60,0x0073,0x02E9,0x05AF,
	0x0815,0x08E5,0x0926,0x0991,0x0A92,0x0C69,0x0E7C,0x1056,
	0x114E,0x10C3,0x10FC,0x11D2,0x12E9,0x1372,0x131E,0x1263,
	0x115C,0x10B2,0x100C,0x0E81,0x0D10,0x0BC0,0x0B1A,0x0B69,
	0x0ACD,0x0910,0x0694,0x0482,0x03BE,0x03F9,0x02E6,0x00EA,
	0xFEE7,0xFCBD,0xFADD,0xF90C,0xF84F,0xF800,0xF7C3,0xF69B,
	0xF551,0xF3F4,0xF2EF,0xF2D1,0xF39E,0xF45E,0xF3A6,0xF179,
	0xEFFD,0xF085,0xF2C7,0xF3B8,0xF351,0xF297,0xF345,0xF500,
	0xF6F1,0xF7BD,0xF822,0xF87F,0xF908,0xFA15,0xFB6A,0xFC1D,
	0xFC0B,0xF9A4,0xF51B,0xEF94,0xEA11,0xE3DF,0xD81E,0xCB7F,
	0xC1D3,0xBFDB,0xBFB0,0xC65A,0xCFEF,0xD2DA,0xD2B6,0xD448,
	0xD953,0xDF24,0xE1AA,0xE005,0xDD05,0xDA1E,0xD93B,0xDACE,
	0xDE64,0xE584,0xEFD3,0xFC2C,0x081B,0x1094,0x15DD,0x1991,
	0x2001,0x27F6,0x2D8E,0x2DA5,0x2A74,0x2880,0x2AAB,0x310F,
	0x3A17,0x3F20,0x3F03,0x3F34,0x3F4F,0x3F4B,0x3F36,0x3F4B,
	0x3F38,0x3F3C,0x3F2D,0x3F28,0x3F3B,0x3DB9,0x3AE3,0x3BCD,
	0x3D81,0x3E9E,0x3CD7,0x37BC,0x3209,0x2E24,0x2ABC,0x25E5,
	0x1EB3,0x14D0,0x0B1A,0x04F2,0x01CE,0xFD63,0xFA6F,0xF872,
	0xF69F,0xF40D,0xF0DC,0xECDE,0xE8E3,0xE582,0xE235,0xDE2B,
	0xD908,0xD3E5,0xD074,0xCE8D,0xCF34,0xD188,0xD429,0xD5B3,
	0xD82E,0xDA03,0xDABF,0xDB05,0xDC62,0xDEC1,0xE0CB,0xE1D3,
	0xE143,0xE12D,0xE458,0xEA12,0xF0A4,0xF57B,0xF8BC,0xFC8B,
	0x0084,0x0446,0x0744,0x0AAA,0x0C5B,0x0CF1,0x0D8D,0x0F1C,
	0x10CF,0x11BF,0x1490,0x1804,0x1AE5,0x1D9B,0x1F96,0x1FDF,
	0x1F06,0x1E2E,0x1DC4,0x1C9F,0x1A59,0x17EC,0x1542,0x1290,
	0x0F62,0x0E5F,0x0EC6,0x0EB9,0x0DB8,0x0B0F,0x075E,0x0470,
	0x026A,0x001C,0xFD16,0xF99C,0xF5B7,0xF28D,0xF045,0xEF0F,
	0xEDE3,0xEC87,0xEB2C,0xE9EF,0xE98D,0xE90A,0xE69E,0xE399,
	0xE233,0xE212,0xE24D,0xE1CD,0xDFA3,0xDE62,0xDEBE,0xE0C9,
	0xE333,0xE57B,0xE679,0xE72E,0xE83A,0xEA81,0xED08,0xEE7E,
	0xEE33,0xEE63,0xF02B,0xF30D,0xF614,0xF7AB,0xF8CB,0xFA4E,
	0xFCEA,0x00A1,0x03AC,0x0619,0x0639,0x0616,0x078B,0x0996,
	0x0AB0,0x0B84,0x0B84,0x0B9D,0x0C57,0x0F75,0x10B6,0x0F73,
	0x100D,0x0F6B,0x0FA1,0x100C,0x0FAA,0x0E32,0x0D0B,0x0B99,
	0x0A56,0x0955,0x090E,0x083E,0x06EF,0x05CA,0x048A,0x03D5,
	0x02FB,0x00EC,0xFE7F,0xFD7F,0xFD58,0xFC25,0xF972,0xF71E,
	0xF648,0xF5CD,0xF5EA,0xF609,0xF4E0,0xF320,0xF1BF,0xF213,
	0xF40A,0xF48F,0xF2D1,0xF0DD,0xF054,0xF1A0,0xF360,0xF3D5,
	0xF359,0xF321,0xF3F6,0xF4C8,0xF555,0xF6A5,0xF809,0xF914,
	0xF9D7,0xFA1E,0xFA60,0xFA64,0xF7E1,0xF312,0xED59,0xE79D,
	0xDFCC,0xD3D4,0xC548,0xBFA1,0xBFE3,0xBF01,0xC702,0xCFA7,
	0xD19A,0xD0CF,0xD1EC,0xD717,0xDE42,0xE225,0xE087,0xDAEC,
	0xD5E2,0xD575,0xD96B,0xE112,0xEA40,0xF57F,0x00B9,0x0A80,
	0x116F,0x174A,0x1D75,0x23AB,0x298B,0x2E47,0x2F31,0x2BE6,
	0x28C3,0x2B38,0x3381,0x3D56,0x3FB8,0x3FB0,0x3FCA,0x3FE5,
	0x3FD9,0x3FE3,0x3FD6,0x3FE5,0x3FDC,0x3FE0,0x4004,0x3FE7,
	0x4053,0x3FCF,0x3D65,0x3CCD,0x3CE8,0x3C4E,0x38A4,0x3267,
	0x2C39,0x273A,0x231A,0x1CDE,0x1411,0x09CD,0x01EB,0xFD54,
	0xFB1F,0xF8CE,0xF66F,0xF477,0xF211,0xEF2F,0xEB32,0xE5FB,
	0xE1F7,0xDEFD,0xDB8B,0xD78E,0xD280,0xCEE6,0xCD23,0xCDBC,
	0xD083,0xD40E,0xD76F,0xD975,0xD9E4,0xDA6A,0xDC02,0xDE5D,
	0xDFBD,0xE01E,0xE059,0xE15E,0xE3DE,0xE750,0xEBB6,0xF148,
	0xF723,0xFC81,0x0146,0x0478,0x06A2,0x07E6,0x0AA4,0x0E3E,
	0x10FE,0x118F,0x10A1,0x10BF,0x1393,0x1826,0x1C6C,0x1EDF,
	0x2005,0x20BF,0x20C0,0x209A,0x2100,0x2086,0x1E99,0x1B6D,
	0x19CB,0x182B,0x1605,0x1371,0x1263,0x11A9,0x1222,0x1417,
	0x0FBD,0x0A3A,0x0657,0x0436,0x0377,0x0199,0xFD10,0xF7C2,
	0xF384,0xF1EE,0xF110,0xEFA9,0xEE9C,0xEE18,0xEC87,0xEA72,
	0xE865,0xE7E5,0xE738,0xE494,0xE261,0xE14D,0xE17B,0xE189,
	0xE0E9,0xDFCD,0xE14E,0xE4B4,0xE7B5,0xE933,0xE91A,0xE904,
	0xE9E3,0xEBE2,0xEE34,0xEFCC,0xF013,0xEFEE,0xF11E,0xF36B,
	0xF736,0xFAB3,0xFD7B,0xFEDA,0x0067,0x02D7,0x0561,0x06C8,
	0x0714,0x07CC,0x091F,0x0993,0x0963,0x0A38,0x0C00,0x0D65,
	0x0E10,0x0EC0,0x101C,0x13A1,0x140E,0x11CD,0x108C,0x1033,
	0x0F73,0x0DE2,0x0C89,0x0B5E,0x0A4A,0x0841,0x06E3,0x06EB,
	0x06CE,0x0670,0x0524,0x0374,0x015A,0xFEC0,0xFC33,0xFAD9,
	0xFB48,0xFA45,0xF7AA,0xF585,0xF3BD,0xF203,0xF25A,0xF36C,
	0xF379,0xF236,0xF0DD,0xEFF6,0xEFB2,0xEF6A,0xEF29,0xEEEE,
	0xEF20,0xEF04,0xEEA8,0xEF54,0xF0A5,0xF22F,0xF344,0xF3F4,
	0xF413,0xF4A9,0xF6EF,0xF7D8,0xF7A1,0xF823,0xF9A8,0xF95C,
	0xF601,0xF145,0xEB67,0xE42A,0xDA21,0xCE3A,0xC232,0xBE12,
	0xBE25,0xBF8F,0xC903,0xCF62,0xD0C1,0xD03C,0xD1DF,0xD6B4,
	0xDC8A,0xE03A,0xDE9F,0xD8F0,0xD3A2,0xD401,0xD9FD,0xE22C,
	0xEAEA,0xF4D1,0xFFB4,0x09C5,0x1137,0x1717,0x1CC1,0x2295,
	0x271E,0x2990,0x2946,0x287C,0x285C,0x2ADE,0x31BC,0x3A7D,
	0x3E71,0x3E44,0x3E5F,0x3EA1,0x3EAA,0x3E7D,0x3E85,0x3E96,
	0x3E94,0x3E74,0x3E76,0x3DA9,0x39A8,0x3786,0x3784,0x3884,
	0x390F,0x3780,0x331C,0x2DCA,0x2879,0x23FB,0x1EF9,0x17B2,
	0x0E0A,0x04DC,0xFE79,0xFA51,0xF83B,0xF7CB,0xF318,0xF0D6,
	0xEEF6,0xEBD4,0xE75F,0xE2C9,0xDF46,0xDCCA,0xD95A,0xD471,
	0xCF8E,0xCBC8,0xCBA2,0xCE72,0xD2EC,0xD619,0xD6AC,0xD5E4,
	0xD76F,0xDB05,0xDDD6,0xDF25,0xDEE9,0xDEC0,0xE044,0xE24D,
	0xE450,0xE7B7,0xEBF5,0xF1EC,0xF822,0xFD3D,0x00CE,0x034A,
	0x04D7,0x0703,0x0B2A,0x0F18,0x1136,0x0FF1,0x0E2D,0x0F86,
	0x14BF,0x1A86,0x1CB8,0x1CD0,0x1D54,0x1EEC,0x202E,0x20B7,
	0x1FEE,0x1E19,0x1C26,0x1A50,0x194E,0x1876,0x15BF,0x129B,
	0x10F7,0x11EE,0x12AA,0x107F,0x0B9E,0x065F,0x047C,0x036A,
	0x0138,0xFDBF,0xF97C,0xF5E4,0xF370,0xF299,0xF116,0xEE76,
	0xEB84,0xEA5E,0xEB31,0xEBBC,0xEA3A,0xE6B5,0xE483,0xE395,
	0xE3AF,0xE3FF,0xE406,0xE30E,0xE1F4,0xE2A3,0xE4CB,0xE74B,
	0xEA1F,0xEAA5,0xEA3A,0xEB11,0xECFF,0xEF86,0xF11E,0xF24C,
	0xF356,0xF50C,0xF65D,0xF7C8,0xF9F1,0xFC77,0xFFD9,0x024B,
	0x0516,0x068F,0x068E,0x0756,0x08E2,0x0B64,0x0CDE,0x0DCA,
	0x0D76,0x0D2F,0x0E60,0x0FD5,0x107B,0x10F0,0x1218,0x134F,
	0x1327,0x12B7,0x1120,0x0F2C,0x0E18,0x0DD1,0x0D42,0x0C63,
	0x0B1A,0x0943,0x0733,0x0655,0x0697,0x063F,0x046D,0x01BF,
	0xFFBA,0xFED3,0xFE6E,0xFD29,0xFAB0,0xF88E,0xF740,0xF6EB,
	0xF6C9,0xF59C,0xF3B9,0xF2C3,0xF316,0xF41D,0xF4A0,0xF32B,
	0xF101,0xF002,0xF061,0xF203,0xF312,0xF293,0xF0B2,0xF025,
	0xF25B,0xF59E,0xF6B0,0xF595,0xF509,0xF67E,0xF929,0xFAA0,
	0xFA18,0xF9C1,0xF9C5,0xF939,0xF6AF,0xF22E,0xEAC3,0xE276,
	0xD8F9,0xCCF7,0xC200,0xC02A,0xC048,0xC243,0xCD9B,0xD446,
	0xD422,0xD3CA,0xD5A1,0xDA2E,0xDFB9,0xE264,0xDFF7,0xD9F4,
	0xD578,0xD61D,0xDBDE,0xE533,0xEF67,0xF9BB,0x03CE,0x0C8F,
	0x13CE,0x199C,0x1F71,0x253B,0x2A13,0x2C7E,0x2B9C,0x29D5,
	0x2A06,0x2D81,0x3541,0x3D90,0x3F5C,0x3F6C,0x3F67,0x3F3B,
	0x3F47,0x3F51,0x3F46,0x3F42,0x3F40,0x3F4B,0x3F37,0x3DED,
	0x3D56,0x3C98,0x3B80,0x3A95,0x39A3,0x37D4,0x33AA,0x2E33,
	0x28CD,0x2396,0x1D09,0x15A5,0x0D15,0x0404,0xFCC0,0xF89B,
	0xF73C,0xF67C,0xF486,0xF2A7,0xEE9C,0xEBF2,0xE94E,0xE4FC,
	0xE05A,0xDB94,0xD714,0xD35A,0xD0A5,0xCF34,0xCE81,0xCEE8,
	0xD0F7,0xD446,0xD6FB,0xD86D,0xD967,0xDA32,0xDAFE,0xDD70,
	0xDF6A,0xDFD6,0xE037,0xE1A3,0xE3F3,0xE7FD,0xECF4,0xF288,
	0xF76D,0xFC33,0x0008,0x02DA,0x0522,0x0770,0x09F7,0x0C20,
	0x0DA9,0x0EA5,0x0F3D,0x10A9,0x12F1,0x166F,0x1AB6,0x1D1C,
	0x1D79,0x1E38,0x1E75,0x1E48,0x1EA7,0x1E0E,0x1B94,0x188A,
	0x162E,0x14A0,0x1320,0x1175,0x1017,0x0F81,0x0E30,0x0BA4,
	0x08E8,0x062E,0x039D,0x00EC,0xFDBB,0xF9D5,0xF616,0xF38A,
	0xF109,0xEE3D,0xEC51,0xEBA1,0xEB1F,0xEA16,0xE837,0xE63F,
	0xE4CC,0xE3EA,0xE34D,0xE23A,0xE032,0xDEB5,0xDD99,0xDE4E,
	0xDFEA,0xE167,0xE228,0xE260,0xE2FB,0xE4D6,0xE771,0xE8DE,
	0xE90A,0xE986,0xEAC0,0xED22,0xEF20,0xF03E,0xF161,0xF3BB,
	0xF711,0xFA01,0xFC22,0xFDEB,0x000E,0x01E9,0x0455,0x05C8,
	0x06BB,0x072D,0x07EB,0x08B8,0x09DC,0x0B2D,0x0C5C,0x0CBE,
	0x0D40,0x0E06,0x0E9A,0x0E0C,0x0F0F,0x0D7B,0x0B66,0x0C74,
	0x0BA4,0x0ABE,0x0934,0x0792,0x066C,0x065D,0x05D6,0x0552,
	0x0403,0x0256,0x016E,0x0002,0xFEAF,0xFD99,0xFC9F,0xFAA8,
	0xF8B5,0xF6AE,0xF594,0xF573,0xF551,0xF4D3,0xF3EF,0xF25A,
	0xF1B0,0xF1F0,0xF176,0xF1A6,0xF250,0xF1F9,0xF0FE,0xEF79,
	0xEF9C,0xF200,0xF429,0xF4C5,0xF392,0xF2A4,0xF3CD,0xF5AE,
	0xF79B,0xF8FF,0xF9DE,0xFA2B,0xFA4A,0xFA42,0xF941,0xF696,
	0xF1D1,0xEC9D,0xE690,0xDD99,0xD215,0xC7FF,0xC51C,0xCAE3,
	0xD3DC,0xD9F9,0xDBB7,0xDB13,0xDA9D,0xDDDF,0xE489,0xE8AD,
	0xE761,0xE1E4,0xDDDD,0xDDBE,0xE149,0xE74B,0xEDDB,0xF4F1,
	0xFDA6,0x0701,0x0F62,0x1597,0x19FE,0x1E73,0x23A6,0x26E8,
	0x2786,0x2645,0x24EB,0x2638,0x2B75,0x32E8,0x3A09,0x3EBE,
	0x3FBA,0x3FAE,0x3FC1,0x3FD4,0x3F91,0x3FB9,0x3FD9,0x3F6E,
	0x3B9A,0x381F,0x350B,0x3304,0x3234,0x3285,0x330F,0x3238,
	0x30A1,0x2B75,0x2560,0x217D,0x1E25,0x1866,0x1055,0x07A3,
	0x007C,0xFD17,0xFC3F,0xFB75,0xF89F,0xF4AC,0xF2C8,0xF23A,
	0xF12C,0xEEDD,0xEA52,0xE4ED,0xE042,0xDDA7,0xDC4A,0xDAA8,
	0xD7BF,0xD610,0xD7C1,0xDBFB,0xDFB7,0xE124,0xE124,0xE13A,
	0xE384,0xE660,0xE798,0xE70B,0xE602,0xE6BA,0xE9A7,0xEDEC,
	0xF23A,0xF5F4,0xF8C3,0xFC26,0x0065,0x0513,0x08DB,0x0A04,
	0x0A38,0x0B13,0x0D12,0x0ECA,0x0F3B,0x0F38,0x1044,0x135D,
	0x1752,0x19AF,0x1946,0x18D2,0x19C7,0x1BEC,0x1CD9,0x1B79,
	0x1855,0x14D0,0x12E0,0x12F8,0x134B,0x11CC,0x0E99,0x0CE3,
	0x0C3B,0x0D53,0x0D07,0x0B66,0x0598,0x0082,0x0079,0xFFB0,
	0xFE05,0xF9F7,0xF4AE,0xF101,0xF10F,0xF25A,0xF209,0xEF99,
	0xED06,0xEC93,0xECDC,0xEC15,0xE9CD,0xE727,0xE679,0xE6DD,
	0xE758,0xE751,0xE61E,0xE49D,0xE4D7,0xE75D,0xEB5E,0xEE89,
	0xEE1F,0xEBF6,0xEB3B,0xED8E,0xF1EA,0xF51F,0xF4AF,0xF2DF,
	0xF2D4,0xF5DC,0xF9B1,0xFCBD,0xFE21,0xFEE0,0xFFD4,0x0184,
	0x03AA,0x054A,0x0602,0x061E,0x064D,0x080C,0x09EB,0x0A15,
	0x08F8,0x08D6,0x0ADA,0x0D59,0x0D61,0x0BDB,0x0B17,0x0B39,
	0x0BA9,0x0B1E,0x0C6B,0x0C3E,0x0A40,0x091D,0x087B,0x07D0,
	0x067B,0x05D1,0x0521,0x0482,0x0368,0x01D6,0x007E,0xFFC0,
	0xFE40,0xFBF5,0xFA4B,0xF9D5,0xF929,0xF7D9,0xF6A0,0xF63C,
	0xF50C,0xF467,0xF512,0xF590,0xF496,0xF367,0xF1CE,0xF108,
	0xF1AC,0xF273,0xF2E9,0xF288,0xF208,0xF284,0xF3D1,0xF501,
	0xF577,0xF542,0xF68E,0xF863,0xF8BD,0xF8E1,0xF9AE,0xF96C,
	0xF9AC,0xFB37,0xFB16,0xFAA0,0xF956,0xF822,0xF60D,0xF2DD,
	0xEE78,0xEA75,0xE958,0xEC0F,0xF016,0xF30A,0xF2FA,0xF1B3,
	0xF1AD,0xF444,0xF7BB,0xF860,0xF6D5,0xF4F8,0xF3E8,0xF45E,
	0xF590,0xF714,0xF8C2,0xFB89,0xFF4A,0x028E,0x053B,0x0738,
	0x087D,0x093E,0x0A61,0x0BC7,0x0C50,0x0B8E,0x09CF,0x0986,
	0x0B83,0x0ED9,0x104F,0x103A,0x1113,0x135E,0x15AC,0x16A1,
	0x149A,0x124D,0x111F,0x10C0,0x103A,0x0F08,0x0D7C,0x0C27,
	0x0BB0,0x0BB7,0x0B94,0x0C1D,0x0BB0,0x09B4,0x07DB,0x0664,
	0x0527,0x0309,0xFFC7,0xFC81,0xFAF6,0xFAC6,0xF9C6,0xF797,
	0xF710,0xF841,0xF86B,0xF7B6,0xF747,0xF3AD,0xF40B,0xF509,
	0xF43F,0xF276,0xF106,0xEF1A,0xEF0C,0xF0AD,0xF250,0xF386,
	0xF39D,0xF3B3,0xF49D,0xF5E7,0xF666,0xF6BD,0xF6BB,0xF727,
	0xF7F8,0xF8BF,0xF955,0xF962,0xF95C,0xFA6C,0xFE18,0x013E,
	0x02E4,0x022E,0x0124,0x01B4,0x042F,0x05F7,0x05A3,0x042E,
	0x0325,0x03C8,0x0578,0x0745,0x0884,0x081E,0x0774,0x07E5,
	0x0973,0x0B22,0x0AE7,0x08B9,0x06E8,0x0657,0x06D2,0x0666,
	0x0524,0x0417,0x0372,0x02E5,0x02AC,0x01BD,0x006A,0xFF22,
	0xFDF8,0xFD1E,0xFBC5,0xF930,0xF4F6,0xF416,0xF4AE,0xF679,
	0xF793,0xF660,0xF528,0xF4AD,0xF5C7,0xF6CE,0xF702,0xF66E,
	0xF553,0xF529,0xF587,0xF55D,0xF520,0xF4CD,0xF38F,0xF224,
	0xF233,0xF2A4,0xF238,0xF13B,0xF0AA,0xF07E,0xEFCD,0xEF8D,
	0xEECA,0xEDE7,0xEDC7,0xED89,0xED11,0xEC99,0xEC42,0xEBA0,
	0xEB82,0xEB73,0xEB59,0xEAF4,0xEA65,0xE9BF,0xE99E,0xEA90,
	0xEA93,0xE949,0xE8BC,0xE87D,0xE8A3,0xE909,0xE8D3,0xE853,
	0xE850,0xE819,0xE8C2,0xE8FD,0xE937,0xE954,0xE95A,0xE8CB,
	0xE8D8,0xE90D,0xE9A4,0xE940,0xE943,0xE95F,0xE97B,0xEA0B,
	0xEA37,0xEA3E,0xEA58,0xEA7C,0xEA7D,0xEB26,0xEBA5,0xEBB6,
	0xEC41,0xECF2,0xEDAF,0xEDD0,0xEDC4,0xEDF3,0xEE92,0xEF61,
	0xF018,0xF08E,0xF08A,0xF054,0xF0B6,0xF178,0xF225,0xF291,
	0xF29F,0xF2C3,0xF32E,0xF3C1,0xF405,0xF4E4,0xF552,0xF567,
	0xF5AB,0xF5FC,0xF67C,0xF6C5,0xF744,0xF788,0xF825,0xF8EE,
	0xF918,0xF93C,0xF98E,0xF9E7,0xFA61,0xFA03,0xFA65,0xFACF,
	0xFB29,0xFB1F,0xFB9B,0xFCF1,0xFB59,0xFCA1,0xFD8D,0xFCBB,
	0xFDA6,0xFE2D,0xFE3F,0xFE79,0xFEEC,0xFF47,0xFFE5,0x003F,
	0x007B,0x00EF,0x0138,0x01E6,0x0235,0x026D,0x026D,0x02B5,
	0x0344,0x03D1,0x044A,0x0475,0x0483,0x04E5,0x0507,0x059A,
	0x05A8,0x05A8,0x05CE,0x064D,0x0670,0x06D1,0x06F8,0x06D3,
	0x0717,0x078A,0x07F8,0x0819,0x0865,0x08EB,0x08C5,0x08B4,
	0x095E,0x09E9,0x0A23,0x09DD,0x09E2,0x09FC,0x09F7,0x0A18,
	0x0A7E,0x0AA5,0x0A96,0x0A72,0x0A9A,0x0AC7,0x0B66,0x0BC8,
	0x0C27,0x0D14,0x0F20,0x0E4E,0x0E40,0x0E57,0x0E1B,0x0E1F,
	0x0E62,0x0EDC,0x0F28,0x0E83,0x0E63,0x0EA7,0x0ED7,0x0E8F,
	0x0EC9,0x0EC2,0x0EA2,0x0E78,0x0E40,0x0E1E,0x0EC5,0x0EFE,
	0x0DFC,0x0D84,0x0E0A,0x0DFE,0x0DDD,0x0E1F,0x0DA2,0x0DD8,
	0x0DFC,0x0DDB,0x0DD1,0x0D8F,0x0D63,0x0DD6,0x0D86,0x0D64,
	0x0D68,0x0D57,0x0D02,0x0D0A,0x0D0D,0x0DA1,0x0D45,0x0C08,
	0x0C81,0x0D61,0x0D29,0x0CFE,0x0CC8,0x0C99,0x0C86,0x0CCF,
	0x0D38,0x0CB0,0x0BA4,0x0B08,0x0AF8,0x0A6F,0x0A07,0x0A7B,
	0x0A80,0x0A3B,0x0A0A,0x0A6A,0x0A79,0x0A9A,0x0A5F,0x0A0F,
	0x09F2,0x0A46,0x0A3C,0x0A3C,0x0A2A,0x09FA,0x0A33,0x09ED,
	0x0A00,0x09DD,0x09AD,0x095C,0x0905,0x092D,0x0933,0x08FD,
	0x0923,0x0942,0x08E6,0x0876,0x08C8,0x090F,0x08D2,0x0913,
	0x094A,0x094E,0x090D,0x08F2,0x08E0,0x0863,0x0823,0x0831,
	0x0838,0x081C,0x07F4,0x0819,0x079D,0x0797,0x0779,0x07AF,
	0x0778,0x074F,0x070B,0x0700,0x070D,0x0773,0x0717,0x073E,
	0x0746,0x0777,0x0709,0x08C9,0x082E,0x06E0,0x07D9,0x075B,
	0x0754,0x0748,0x077B,0x06E7,0x0778,0x0753,0x0743,0x06FD,
	0x06CA,0x073A,0x074D,0x070F,0x06B8,0x0767,0x06E6,0x06AD,
	0x06E4,0x0746,0x0732,0x0715,0x066A,0x061C,0x065E,0x06A3,
	0x068C,0x0601,0x05BE,0x061B,0x064D,0x063A,0x067E,0x0675,
	0x062D,0x05F0,0x0601,0x0688,0x0688,0x061F,0x05B4,0x058A,
	0x0544,0x0561,0x05A2,0x05B7,0x0540,0x04F5,0x0555,0x055A,
	0x0546,0x0574,0x0532,0x04D3,0x0466,0x040F,0x0443,0x04BB,
	0x0485,0x04E2,0x0436,0x02CF,0x0178,0x01E8,0x0209,0x022B,
	0x0212,0x02A5,0x02D6,0x0342,0x0333,0x02C7,0x02F9,0x02DF,
	0x02FA,0x02FF,0x02EF,0x0330,0x0342,0x036E,0x028B,0x0250,
	0x02F6,0x039F,0x0378,0x0373,0x0322,0x02FB,0x027A,0x01FC,
	0x0294,0x02E2,0x02CE,0x02F0,0x02D9,0x027A,0x0243,0x021E,
	0x0268,0x0279,0x026F,0x0235,0x0228,0x0203,0x026C,0x038E,
	0x02BA,0x0207,0x021C,0x01E1,0x020E,0x0248,0x01F3,0x0221,
	0x0206,0x0203,0x02A3,0x0345,0x0350,0x0383,0x0349,0x02B3,
	0x02AD,0x02E4,0x02ED,0x02CE,0x026A,0x0244,0x0209,0x0271,
	0x0244,0x021F,0x0256,0x0284,0x0295,0x022E,0x0168,0x00FB,
	0x0117,0x00F0,0x0108,0x0142,0x0111,0x00C0,0xFFDE,0xFFE9,
	0xFFB6,0xFF90,0xFF9A,0xFF8D,0xFFDA,0xFFE3,0xFF38,0xFEE6,
	0xFF40,0xFF79,0xFF81,0xFF66,0xFF98,0x0076,0x0108,0x01CE,
	0x02AB,0x0324,0x0375,0x0429,0x0569,0x07C3,0x0A03,0x0B24,
	0x0BC9,0x0C08,0x0C5F,0x0CF1,0x0D33,0x0CE9,0x0C6F,0x0C63,
	0x0C35,0x0C7E,0x0CA8,0x0D0B,0x0C92,0x0C69,0x0CB0,0x0D16,
	0x0DED,0x0DF0,0x0DC8,0x0E5B,0x0F8B,0x1128,0x116D,0x10CC,
	0x1124,0x1190,0x1288,0x1388,0x13EA,0x13F0,0x1389,0x145C,
	0x1665,0x1684,0x170C,0x1701,0x168E,0x1600,0x1588,0x1491,
	0x1350,0x12C3,0x12D9,0x134F,0x1167,0x0C65,0x06E7,0x0371,
	0x0347,0x04A5,0x0535,0x03F4,0x02FD,0x02C0,0x03BF,0x0743,
	0x0C77,0x1125,0x1526,0x1933,0x1CFA,0x1FEB,0x2291,0x250D,
	0x2892,0x2BBE,0x2CD1,0x2C68,0x2A96,0x27A6,0x2537,0x2392,
	0x2191,0x1FEA,0x1D3A,0x197A,0x14EC,0x1066,0x0EE0,0x0F2F,
	0x0EA9,0x0D1E,0x0AF2,0x08DD,0x07AD,0x06CF,0x0547,0x048D,
	0x03AF,0x0214,0x002B,0xFDA2,0xFBDB,0xFAFE,0xFA36,0xF9D2,
	0xF931,0xF8D6,0xF960,0xF9DA,0xFA68,0xFB1B,0xFCC6,0x004E,
	0x037F,0x0518,0x05D7,0x06EA,0x0902,0x0B76,0x0D40,0x0E37,
	0x0E2F,0x0DC8,0x0C59,0x0AB7,0x08B7,0x074D,0x06E2,0x0523,
	0x021E,0xFF5C,0xFD26,0xFB5B,0xF9F8,0xF899,0xF6AE,0xF4F2,
	0xF3C3,0xF341,0xF327,0xF275,0xF110,0xEF84,0xEFB5,0xF0DF,
	0xF152,0xF053,0xEE4A,0xED40,0xED6D,0xEE87,0xEFAA,0xF0CB,
	0xF068,0xF01D,0xF010,0xF171,0xF39C,0xF60F,0xF73C,0xF798,
	0xF7D4,0xFB50,0xFBDE,0xFAC7,0xFBD6,0xFC62,0xFE04,0xFE43,
	0xFCC3,0xFB01,0xFA2F,0xF908,0xF800,0xF706,0xF71A,0xF5DA,
	0xF2F5,0xF0B7,0xEF5C,0xEF3D,0xEEDE,0xEE01,0xECE1,0xEC5E,
	0xEB9B,0xEAD1,0xEA69,0xEADD,0xEB24,0xEAEA,0xEAF8,0xEB57,
	0xEC00,0xEC28,0xEB87,0xEB1F,0xEC59,0xEE33,0xEF0F,0xEF92,
	0xEF66,0xEF55,0xEFA1,0xF128,0xF308,0xF491,0xF539,0xF4EB,
	0xF468,0xF49F,0xF55F,0xF68B,0xF71C,0xF688,0xF57A,0xF44E,
	0xF377,0xF38A,0xF340,0xF1F8,0xF0D6,0xEFF9,0xEF18,0xEDC2,
	0xEC9C,0xEAA3,0xE991,0xE9B7,0xE98D,0xE946,0xE963,0xE9B2,
	0xE996,0xE94E,0xE9A4,0xEAE1,0xEBFF,0xEBE9,0xEB7F,0xEC11,
	0xED18,0xEE2C,0xEF3E,0xEFEF,0xEF36,0xEF88,0xF17F,0xF28F,
	0xF289,0xF30A,0xF3C3,0xF3D3,0xF446,0xF55A,0xF5DC,0xF62A,
	0xF609,0xF560,0xF584,0xF620,0xF5CE,0xF4F2,0xF4FF,0xF5BA,
	0xF5AE,0xF403,0xF2F1,0xF2D6,0xF310,0xF3FD,0xF25F,0xF147,
	0xF158,0xF093,0xF011,0xF08E,0xF1C2,0xF26E,0xF215,0xF1A7,
	0xF1A8,0xF2CC,0xF427,0xF5C1,0xF5FF,0xF538,0xF541,0xF5DA,
	0xF619,0xF643,0xF4AF,0xF0DB,0xED0B,0xEBA8,0xEACD,0xE73B,
	0xDEA6,0xD150,0xC400,0xC073,0xC097,0xC069,0xC068,0xC039,
	0xC062,0xC09B,0xC1F8,0xD01C,0xE271,0xF1CF,0xFEB1,0x0C12,
	0x1A43,0x273D,0x326E,0x3C93,0x401E,0x3FBC,0x4011,0x4001,
	0x3FB1,0x400A,0x3D79,0x364B,0x311D,0x2B56,0x22F5,0x183A,
	0x0D5D,0x05F7,0x0222,0x0000,0xFDE7,0xFAF6,0xF6E8,0xF311,
	0xEFB4,0xECFC,0xEBA0,0xEA52,0xE926,0xE5F1,0xE13A,0xDC5F,
	0xD8DE,0xD4A6,0xD2D2,0xD578,0xD63F,0xD737,0xD8B0,0xDA75,
	0xDF45,0xE6DA,0xEFA3,0xF947,0x0252,0x0A70,0x11BA,0x17B3,
	0x1DD5,0x24D4,0x2B5B,0x2F80,0x2FB8,0x2D3D,0x2A4C,0x2717,
	0x238C,0x1F96,0x19CF,0x134B,0x0C53,0x05C9,0x0030,0xFACD,
	0xF605,0xF1FA,0xEEF2,0xEC93,0xEA99,0xE878,0xE688,0xE51E,
	0xE448,0xE40B,0xE451,0xE457,0xE341,0xE182,0xE060,0xE074,
	0xE1F5,0xE38F,0xE587,0xE7DC,0xE93E,0xEAFB,0xEE7C,0xF3F9,
	0xF9F5,0xFE91,0x0370,0x0830,0x0CC5,0x10C6,0x147E,0x19D8,
	0x1CDD,0x1DCF,0x1DFB,0x1CF5,0x1AAE,0x17CA,0x1478,0x112C,
	0x0DF8,0x0ACC,0x066E,0x012A,0xFB7E,0xF73D,0xF4D6,0xF33D,
	0xF12B,0xEE90,0xEB79,0xE9FA,0xEABF,0xEA51,0xE97E,0xE9EB,
	0xEA1E,0xEA11,0xEB51,0xECA2,0xED0C,0xED4D,0xEDDA,0xEFF7,
	0xF2BF,0xF506,0xF723,0xF87E,0xFA05,0xFC91,0xFF71,0x0379,
	0x0708,0x0985,0x0AFE,0x0C59,0x0C7D,0x0DD0,0x106C,0x11E8,
	0x122B,0x1109,0x0ED5,0x0C4D,0x0A16,0x0806,0x060C,0x039E,
	0x009C,0xFDEB,0xFA6F,0xF603,0xF2D0,0xF1D2,0xF1A4,0xF185,
	0xEFF9,0xEDCC,0xECBC,0xECE6,0xEE6C,0xEF96,0xF040,0xF068,
	0xF0A7,0xF1F1,0xF421,0xF5D6,0xF6A1,0xF746,0xF890,0xFAA0,
	0xFCF3,0xFE9D,0xFFD8,0x00F3,0x01E5,0x0449,0x0745,0x091A,
	0x0891,0x080A,0x08D0,0x0AFE,0x0C91,0x0C00,0x0991,0x0762,
	0x06FE,0x06A7,0x05FF,0x0486,0x020B,0xFE9F,0xFC43,0xFA8F,
	0xFA0C,0xF8F8,0xF6BF,0xF50B,0xF488,0xF479,0xF442,0xF3A9,
	0xF31D,0xF3FD,0xF55D,0xF6B6,0xF75F,0xF7B3,0xF864,0xF881,
	0xFA22,0xFD8A,0xFD6B,0xFF01,0xFE2F,0xF9F5,0xF496,0xF079,
	0xEF2A,0xEFA2,0xEBF6,0xDCC8,0xC70E,0xBF14,0xBFAF,0xBF4B,
	0xBF5A,0xBF34,0xBEF9,0xBF60,0xBFAC,0xC0FD,0xD2CC,0xEA5B,
	0xFE56,0x10AD,0x220A,0x3471,0x3F0C,0x3EF3,0x3F35,0x3F62,
	0x3F4A,0x3F6D,0x3F65,0x3F68,0x3F5D,0x3F63,0x3F3C,0x3F0F,
	0x3E54,0x3155,0x1EF6,0x11A8,0x0A68,0x07D5,0x06F9,0x044B,
	0xFE1C,0xF6EA,0xF226,0xF10D,0xF0C0,0xEE76,0xEAE4,0xE72F,
	0xE3CA,0xDF37,0xD8DA,0xD278,0xCE42,0xCD45,0xCF67,0xD2C8,
	0xD437,0xD320,0xD5BC,0xDCEB,0xE8CA,0xF79B,0x051D,0x0F53,
	0x16E5,0x1F0D,0x2976,0x34C4,0x3D7F,0x3EFF,0x3EC8,0x3EFC,
	0x3F36,0x3F19,0x3A5B,0x3268,0x2A7F,0x243C,0x1E4A,0x1697,
	0x0CA3,0x01F8,0xFA52,0xF652,0xF501,0xF356,0xEF26,0xE9AE,
	0xE4FB,0xE38D,0xE4EB,0xE6D0,0xE6B9,0xE4A7,0xE1E2,0xE0BA,
	0xE0DC,0xE0C8,0xE014,0xE028,0xE34D,0xE644,0xE812,0xEAA6,
	0xEDAA,0xF1EA,0xF7EA,0xFFEB,0x0829,0x0F7A,0x14FD,0x19E0,
	0x1EAB,0x23A8,0x28AA,0x2C89,0x2D70,0x2C65,0x29D5,0x2618,
	0x226A,0x1E70,0x1916,0x1337,0x0D59,0x087E,0x0390,0xFD14,
	0xF683,0xF194,0xEE5D,0xEDD1,0xED71,0xEBA5,0xE892,0xE574,
	0xE536,0xE7B0,0xE9CA,0xEA2F,0xE962,0xE8F6,0xEA2A,0xEC5B,
	0xEDBE,0xEF13,0xF0EE,0xF374,0xF596,0xF78A,0xFB60,0xFF38,
	0x021D,0x04A4,0x0826,0x0CCE,0x118D,0x1484,0x15B0,0x16DA,
	0x18A3,0x1AE3,0x1B6B,0x1A37,0x1877,0x15D5,0x121D,0x0F17,
	0x0C8A,0x0997,0x050B,0x009F,0xFCD4,0xF90A,0xF655,0xF438,
	0xF2B8,0xEE99,0xEE3E,0xEDCA,0xEC80,0xECD2,0xED1D,0xEDA4,
	0xEEC4,0xEFB1,0xF06E,0xF1BC,0xF31E,0xF48E,0xF6AB,0xF829,
	0xF9B8,0xFBB6,0xFD94,0xFF60,0x0198,0x0443,0x0645,0x07CD,
	0x093F,0x0B7A,0x0DC3,0x0F27,0x1008,0x10D1,0x10D1,0x104A,
	0x0F92,0x0EA0,0x0D5F,0x0BCA,0x09DD,0x0714,0x0452,0x01FA,
	0xFF53,0xFCB9,0xFA5E,0xF8F8,0xF731,0xF4A4,0xF2B9,0xF1CE,
	0xF1E7,0xF213,0xF1E1,0xF1C5,0xF261,0xF386,0xF4C3,0xF54B,
	0xF5D3,0xF6B4,0xF84A,0xFA3B,0xFC3C,0xFDEC,0xFF55,0x010C,
	0xFFC6,0xFD72,0xF954,0xF582,0xF3DB,0xF1A9,0xEA6F,0xDABC,
	0xC6F8,0xBFD1,0xC033,0xBFC8,0xBFC2,0xBFAD,0xBFB2,0xC010,
	0xBFE3,0xC3FB,0xD979,0xF1A6,0x0500,0x14BB,0x23F6,0x358F,
	0x3F0F,0x3ED9,0x3F34,0x3F4B,0x3F1A,0x3F1F,0x3F02,0x3F05,
	0x3F01,0x3EF9,0x3EA2,0x3EEB,0x3B9F,0x2C76,0x1BA3,0x0E8E,
	0x0802,0x06DA,0x0736,0x03E9,0xFC0B,0xF538,0xF254,0xF1B5,
	0xF14C,0xEFB2,0xEC04,0xE796,0xE282,0xDCF9,0xD7AD,0xD213,
	0xCDEA,0xCC7D,0xCD64,0xCFDE,0xD2C9,0xD455,0xD695,0xDCA3,
	0xE7DF,0xF7BE,0x0517,0x0EB3,0x1682,0x1E86,0x2806,0x3234,
	0x3A82,0x3E07,0x3E23,0x3E56,0x3D5E,0x394A,0x33DD,0x2CF4,
	0x255F,0x1E07,0x1715,0x0FF2,0x0716,0xFD1C,0xF46F,0xF01E,
	0xEF72,0xEECC,0xEB10,0xE536,0xE07F,0xDEF6,0xE0A5,0xE227,
	0xE179,0xDF2E,0xDCE1,0xDBCB,0xDC04,0xDC76,0xDC70,0xDC95,
	0xDE2F,0xE0BD,0xE439,0xE763,0xEAE8,0xEF58,0xF5BA,0xFCE0,
	0x049A,0x0B4B,0x1124,0x157A,0x1A5F,0x1F89,0x235D,0x2419,
	0x26DF,0x267E,0x2352,0x2102,0x1C59,0x180B,0x13C0,0x0F03,
	0x0917,0x03D5,0xFE11,0xF8C9,0xF3A9,0xEFCD,0xEDCB,0xEC2D,
	0xEA04,0xE781,0xE611,0xE5B5,0xE64A,0xE6C0,0xE745,0xE775,
	0xE869,0xE9CC,0xEAC2,0xEB00,0xEBDD,0xEDD1,0xEFBA,0xF2BF,
	0xF589,0xF83B,0xFAE8,0xFD3E,0x0047,0x046A,0x09FE,0x0E8E,
	0x10CB,0x1259,0x147E,0x1706,0x18EE,0x19EA,0x1A31,0x1946,
	0x1728,0x1437,0x119C,0x0F56,0x0BC7,0x06EB,0x02BE,0xFFC0,
	0xFD2F,0xF95E,0xF564,0xF25C,0xF03A,0xEEFD,0xEE79,0xED6E,
	0xEB72,0xE9D0,0xEA74,0xEB28,0xEC8B,0xEE0E,0xEF79,0xF0FC,
	0xF266,0xF3B4,0xF524,0xF638,0xF836,0xFA78,0xFCBC,0xFEC2,
	0x00CB,0x02EB,0x04F9,0x059C,0x07CC,0x0B0F,0x0D74,0x0E27,
	0x0E92,0x0F6C,0x104A,0x0FEF,0x0F98,0x0F78,0x0E4F,0x0C6A,
	0x09FC,0x0713,0x042D,0x021F,0x00B4,0xFF4C,0xFCD2,0xF93C,
	0xF63F,0xF4F4,0xF474,0xF425,0xF4B9,0xF375,0xF260,0xF1EE,
	0xF271,0xF3B1,0xF563,0xF68D,0xF7A2,0xF95B,0xFB6B,0xFD48,
	0xFDF0,0xFF1B,0x0242,0x044E,0x024B,0xFD27,0xF74A,0xF3FD,
	0xF449,0xF342,0xEA03,0xD666,0xC315,0xC0AB,0xC0F9,0xC074,
	0xC07C,0xC075,0xC077,0xC0F2,0xC068,0xCA1E,0xE07F,0xF437,
	0x0615,0x18A2,0x2BDC,0x3C21,0x4010,0x3FFE,0x4026,0x4028,
	0x4028,0x4017,0x4007,0x3FF5,0x3FDA,0x3FD3,0x3F7D,0x4004,
	0x399C,0x2904,0x19F4,0x0FDF,0x0B46,0x08F5,0x0600,0x0177,
	0xFCFC,0xF9CA,0xF6BA,0xF399,0xEFF5,0xED87,0xEB1A,0xE8FD,
	0xE5A9,0xDF85,0xD6E2,0xD089,0xCE05,0xCFD2,0xD3D4,0xD6C2,
	0xD5A5,0xD52E,0xDBF5,0xE581,0xF2D4,0x0021,0x0A53,0x1325,
	0x1C1B,0x2679,0x30F1,0x39A3,0x3EB4,0x3F70,0x3F8B,0x3F5C,
	0x3FA3,0x3D4E,0x3523,0x2D76,0x268B,0x2096,0x19B0,0x10DC,
	0x06BF,0xFDD0,0xF7BA,0xF467,0xF2E4,0xEFC0,0xEA2C,0xE5AE,
	0xE426,0xE41E,0xE4C2,0xE35E,0xE14B,0xE005,0xDFD4,0xDF4E,
	0xDEA7,0xDD77,0xDD81,0xDED2,0xE0EF,0xE3F0,0xE721,0xE9D5,
	0xEC92,0xF122,0xF835,0x00DF,0x08CF,0x0E36,0x1277,0x16BE,
	0x1C16,0x2209,0x2620,0x2753,0x2684,0x24D4,0x2592,0x243A,
	0x1FA3,0x1A01,0x13E1,0x0EF5,0x0A05,0x042B,0xFDD5,0xF7E1,
	0xF2FD,0xEF32,0xED5A,0xEC2A,0xEA75,0xE745,0xE419,0xE487,
	0xE65A,0xE74A,0xE746,0xE6C6,0xE66D,0xE70A,0xE8B6,0xEA86,
	0xEBBF,0xED55,0xEF30,0xF0E2,0xF3DD,0xF73C,0xFA45,0xFCE0,
	0xFFF4,0x04A1,0x0969,0x0CBB,0x0E08,0x1024,0x1384,0x1683,
	0x17DB,0x17B7,0x166C,0x1491,0x12D2,0x125C,0x0FC7,0x0C1F,
	0x081A,0x040C,0x006E,0xFCEE,0xF92F,0xF533,0xF176,0xEEA0,
	0xEDF0,0xED43,0xEAEC,0xE8BD,0xE7D1,0xE8D2,0xEA5B,0xEAD3,
	0xEB13,0xECAE,0xEE8E,0xEF6B,0xF05E,0xF236,0xF4F3,0xF6E3,
	0xF807,0xF9B3,0xFB7B,0xFD6F,0xFF25,0x0098,0x0313,0x0642,
	0x088D,0x09D1,0x0A33,0x0ABB,0x0BF7,0x0D47,0x0E86,0x0E72,
	0x0CDE,0x0B5B,0x09D1,0x084E,0x0702,0x04EC,0x02F1,0x0065,
	0xFD07,0xFA24,0xF883,0xF6C6,0xF527,0xF3BA,0xF28D,0xF1CA,
	0xF110,0xF101,0xF083,0xF020,0xF0A0,0xF248,0xF45F,0xF547,
	0xF55B,0xF591,0xF6B8,0xF878,0xFADF,0xFCC2,0xFC0A,0xF96B,
	0xF5F3,0xEEEC,0xED72,0xEE89,0xEBAD,0xE07F,0xCB41,0xBF18,
	0xBF9F,0xBF39,0xBF0E,0xBF1C,0xBF09,0xBF5D,0xBFE5,0xBFBE,
	0xCDB4,0xE6BF,0xFB28,0x0C14,0x1BEC,0x2E9F,0x3D26,0x3F27,
	0x3F3B,0x3F3E,0x3F5B,0x3F5B,0x3F61,0x3F48,0x3F60,0x3F57,
	0x3F59,0x3F13,0x3E7D,0x32FF,0x2232,0x12DF,0x097B,0x0753,
	0x0703,0x044A,0xFE13,0xF7AD,0xF3E7,0xF248,0xF038,0xED08,
	0xEAB0,0xE8CD,0xE63A,0xE126,0xDA80,0xD3BE,0xCF5E,0xCE33,
	0xD054,0xD437,0xD6EE,0xD6B4,0xD6BC,0xDBFC,0xE7A5,0xF5E4,
	0x01CE,0x0BC4,0x1456,0x1CA2,0x2620,0x30B9,0x39DF,0x3E6A,
	0x3EB4,0x3ED2,0x3EF9,0x3D27,0x37AB,0x30B2,0x28F2,0x2211,
	0x1C6F,0x1668,0x0C6D,0xFFEE,0xF6FB,0xF34A,0xF2A8,0xF14A,
	0xED5F,0xE7DE,0xE396,0xE1D8,0xE257,0xE390,0xE469,0xE3DD,
	0xE145,0xDEAF,0xDE5D,0xDFA4,0xE097,0xE039,0xE09B,0xE32F,
	0xE773,0xEB4C,0xED3D,0xF0B9,0xF662,0xFD5A,0x052D,0x0C5E,
	0x120E,0x1640,0x19F3,0x1E1D,0x23B1,0x28D2,0x2BD7,0x2AC2,
	0x274B,0x2471,0x2279,0x1F44,0x1A31,0x1410,0x0E99,0x0957,
	0x0361,0xFD24,0xF712,0xF2AE,0xF08F,0xEF94,0xED87,0xEA5A,
	0xE761,0xE540,0xE5D9,0xE765,0xE8F4,0xE9B0,0xE949,0xE95D,
	0xE9B8,0xEB54,0xED70,0xEF5E,0xF087,0xF274,0xF507,0xF782,
	0xFA4F,0xFD12,0x008A,0x0470,0x089E,0x0C1B,0x0EA9,0x1105,
	0x1340,0x15A4,0x175D,0x17B2,0x17EB,0x17CF,0x16E1,0x14A2,
	0x1109,0x0E34,0x0B82,0x0811,0x0406,0xFFF7,0xFC4B,0xF913,
	0xF618,0xF23D,0xF00B,0xEE80,0xED4F,0xEC9E,0xECA2,0xED43,
	0xEB1C,0xECA8,0xEE38,0xEE86,0xF110,0xF33F,0xF3BE,0xF3A8,
	0xF449,0xF627,0xF927,0xFB68,0xFD6F,0xFED0,0xFF7D,0x0076,
	0x02BF,0x066A,0x08B9,0x09C8,0x0A72,0x0B41,0x0D01,0x0EBC,
	0x0EAF,0x0DF0,0x0D63,0x0D47,0x0C6A,0x0AAE,0x0856,0x058A,
	0x02F4,0x00E2,0xFFE6,0xFDC9,0xFA42,0xF6D9,0xF4A5,0xF42A,
	0xF427,0xF29E,0xF0AB,0xEF88,0xEF95,0xF0AE,0xF1BA,0xF17A,
	0xF1A8,0xF348,0xF4E9,0xF659,0xF72B,0xF802,0xF9B2,0xFB2C,
	0xFD2F,0xFEC4,0xFEB8,0xFB48,0xF589,0xF219,0xF40C,0xF334,
	0xED1D,0xDDCC,0xC869,0xBFDF,0xC08C,0xC010,0xC00D,0xBFE9,
	0xBFE7,0xC032,0xC02C,0xC1AF,0xD3EB,0xEB23,0xFE6F,0x1000,
	0x20DE,0x332A,0x3ECC,0x3FA6,0x3F74,0x3F52,0x3F65,0x3F4F,
	0x3F4C,0x3F48,0x3F1D,0x3F1B,0x3EEB,0x3ED5,0x3D79,0x305C,
	0x1E72,0x0F87,0x07D5,0x075C,0x0747,0x03D5,0xFCF2,0xF67F,
	0xF313,0xF19F,0xEF8E,0xEBA5,0xEA78,0xE8F1,0xE4E0,0xDF21,
	0xD89C,0xD293,0xCE4E,0xCD07,0xCEB3,0xD1FC,0xD342,0xD35E,
	0xD58B,0xDC2F,0xE799,0xF563,0x0202,0x0C78,0x1619,0x1F6F,
	0x2866,0x3086,0x3882,0x3DBD,0x3E09,0x3E0B,0x3E31,0x3C50,
	0x35F9,0x2F6B,0x286E,0x21E4,0x1BA8,0x12F6,0x08E0,0xFFBE,
	0xF90C,0xF4CB,0xF173,0xEE9D,0xEBC3,0xE874,0xE579,0xE298,
	0xE1AD,0xE214,0xE241,0xE217,0xE033,0xDE67,0xDD0A,0xDC79,
	0xDCBA,0xDDAE,0xDFAC,0xE24F,0xE4A2,0xE672,0xE9BF,0xEF10,
	0xF5BA,0xFCC1,0x0319,0x0A16,0x0FC8,0x14F2,0x1977,0x1E10,
	0x231B,0x26D9,0x2769,0x25C1,0x234C,0x20B5,0x1CBC,0x1A5C,
	0x1568,0x0E53,0x09B7,0x0336,0xFDC5,0xF95A,0xF48E,0xEF75,
	0xEC27,0xEA69,0xE98F,0xE7B3,0xE585,0xE3A3,0xE39D,0xE529,
	0xE668,0xE6A3,0xE636,0xE727,0xE834,0xE9DF,0xEB44,0xEC71,
	0xEDAA,0xEF96,0xF27A,0xF5C3,0xF930,0xFBAE,0xFEE0,0x0262,
	0x06FF,0x0B2D,0x0E5B,0x10DC,0x12E6,0x150D,0x170F,0x1811,
	0x1823,0x17B5,0x1611,0x13B3,0x10AF,0x0DEB,0x0AEA,0x0775,
	0x03C6,0xFFCB,0xFC14,0xF921,0xF701,0xF43B,0xF10C,0xEEA3,
	0xED08,0xECEF,0xED8D,0xED99,0xECEE,0xEC6A,0xECFE,0xECCC,
	0xEE40,0xF03F,0xF13F,0xF27F,0xF3A4,0xF501,0xF71C,0xF977,
	0xFB0E,0xFD06,0xFF1C,0x01B1,0x03FB,0x0515,0x068A,0x0988,
	0x0CC6,0x0EBB,0x0DA6,0x0CCD,0x0E3A,0x0FED,0x0F99,0x0EC9,
	0x0DA7,0x0BD1,0x0967,0x06EE,0x051B,0x03E1,0x01A5,0xFE92,
	0xFB44,0xF941,0xF85A,0xF784,0xF5BE,0xF3B8,0xF28B,0xF2FD,
	0xF3A7,0xF39F,0xF3F2,0xF4FB,0xF4BC,0xF58C,0xF77B,0xF958,
	0xFA5C,0xFAC6,0xFB6F,0xFD40,0xFF7A,0x014C,0x00B4,0xFC9A,
	0xF784,0xF50F,0xF517,0xF35A,0xEA97,0xD8E4,0xC4D1,0xC08D,
	0xC11A,0xC0BA,0xC070,0xC059,0xC08A,0xC10A,0xC092,0xC58A,
	0xDA6C,0xEFEB,0x02B0,0x1484,0x26EF,0x3915,0x405F,0x3FE9,
	0x403C,0x4043,0x403D,0x401A,0x402C,0x401C,0x4021,0x4005,
	0x3FBB,0x403C,0x3BE6,0x2B72,0x1B9C,0x0F54,0x09BE,0x080C,
	0x0640,0x01A1,0xFBF8,0xF701,0xF3BD,0xF1B3,0xEF54,0xEC88,
	0xEA2C,0xE7BC,0xE4E2,0xDEF4,0xD76A,0xD019,0xCCD4,0xCE20,
	0xD249,0xD47A,0xD482,0xD4CA,0xD841,0xE15F,0xEF83,0xFC9E,
	0x0704,0x120F,0x19BD,0x2298,0x2C3A,0x357F,0x3CFD,0x3FA8,
	0x3F62,0x3FAB,0x3F34,0x3B43,0x356E,0x2E1F,0x2718,0x20BE,
	0x199C,0x1111,0x078F,0xFE44,0xF736,0xF272,0xEF60,0xEDC4,
	0xEB67,0xE7A3,0xE2C4,0xE037,0xE0FF,0xE249,0xE205,0xE0AF,
	0xDEE9,0xDDBD,0xDD06,0xDC0D,0xDBE3,0xDD3E,0xDF16,0xE144,
	0xE3F4,0xE736,0xEBBF,0xF077,0xF578,0xFC5E,0x0474,0x0B97,
	0x115D,0x15D2,0x1A35,0x1F35,0x22DE,0x254F,0x261F,0x2588,
	0x2392,0x1FC1,0x1B51,0x1778,0x12FC,0x0FD7,0x0A8D,0x041F,
	0xFE56,0xF899,0xF385,0xEFF2,0xEDC7,0xEBBE,0xE9D9,0xE7C3,
	0xE681,0xE670,0xE6BD,0xE6F3,0xE73A,0xE731,0xE7BF,0xE957,
	0xEA5E,0xEADF,0xEC70,0xED71,0xEED6,0xF19D,0xF495,0xF713,
	0xFA51,0xFD80,0x0026,0x035B,0x0714,0x0BDC,0x1023,0x1230,
	0x1375,0x14DC,0x16F1,0x185C,0x17D8,0x1693,0x1571,0x1316,
	0x0FE9,0x0C5B,0x07EF,0x0432,0x01F4,0xFE3F,0xFA2F,0xF6AF,
	0xF3B5,0xF102,0xEE9A,0xED36,0xEC6F,0xEB5A,0xE9E3,0xE99A,
	0xEA71,0xEAD2,0xEB98,0xEC60,0xED7C,0xEFA4,0xF17F,0xF242,
	0xF344,0xF4C1,0xF70F,0xF9BE,0xFBA9,0xFD26,0xFF80,0x0145,
	0x0369,0x0597,0x07ED,0x09B4,0x0A8A,0x0BA6,0x0D53,0x0E8D,
	0x0ED8,0x0D9D,0x0BF7,0x0B79,0x0B5A,0x09F6,0x0710,0x034F,
	0x0057,0xFECD,0xFD8D,0xFB37,0xF841,0xF53B,0xF2C3,0xF152,
	0xF146,0xF153,0xF0A7,0xEEE8,0xEE64,0xEF3B,0xF080,0xF18B,
	0xF1CE,0xF25B,0xF34E,0xF549,0xF6CF,0xF7FE,0xF852,0xF8E7,
	0xFAFB,0xFC8C,0xFB59,0xF882,0xF703,0xF7B9,0xF8C2,0xF759,
	0xEDB2,0xE4E2,0xDEFE,0xDD83,0xE08D,0xE41B,0xE318,0xDFA3,
	0xDDA2,0xE1DB,0xEB9C,0xF58C,0xFD81,0x0394,0x0A0E,0x1170,
	0x1870,0x1E36,0x232F,0x27BC,0x2B1C,0x2C6C,0x2C55,0x2A50,
	0x257F,0x1F57,0x1A63,0x1905,0x1806,0x1423,0x0C97,0x0576,
	0x0181,0x0103,0x015E,0x009F,0xFF23,0xFD77,0xFBD7,0xFAE1,
	0xFAF8,0xFB30,0xFAD7,0xF994,0xF82A,0xF74A,0xF6E8,0xF3F5,
	0xEF80,0xED40,0xEE65,0xF14C,0xF2CA,0xF1F9,0xF173,0xF2D6,
	0xF685,0xFC61,0x0283,0x070A,0x0A12,0x0BED,0x0D89,0x0FE4,
	0x14CC,0x1740,0x178F,0x17A2,0x1846,0x1836,0x1505,0x10B2,
	0x0DCB,0x0BF0,0x0A7D,0x0820,0x045C,0x0004,0xFC9A,0xFA0A,
	0xF9CF,0xFA06,0xF932,0xF898,0xF6C6,0xF4C4,0xF472,0xF611,
	0xF7D4,0xF792,0xF66C,0xF575,0xF588,0xF624,0xF601,0xF51E,
	0xF523,0xF6DD,0xF881,0xF95F,0xFA14,0xFAE4,0xFC2F,0xFEEC,
	0x01CB,0x04FC,0x0912,0x0AC0,0x09FF,0x0ADA,0x0D8F,0x0FF0,
	0x1043,0x0F9A,0x0EFA,0x0E34,0x0D7D,0x0C18,0x09B2,0x07A7,
	0x063A,0x0536,0x033D,0x0047,0xFD2A,0xFAE9,0xF9FE,0xF9AE,
	0xF8F8,0xF826,0xF74F,0xF6D6,0xF6F8,0xF760,0xF7EA,0xF85F,
	0xF826,0xF7CD,0xF810,0xF8FC,0xFA13,0xFA66,0xFA8B,0xFB0B,
	0xFC46,0xFDB5,0xFE90,0xFEA5,0xFF4F,0x00E7,0x029B,0x03AC,
	0x0519,0x0603,0x06D6,0x07D8,0x0901,0x09AC,0x0955,0x0837,
	0x073C,0x0723,0x07A5,0x06B7,0x046C,0x0237,0x0102,0x002B,
	0xFF3D,0xFD8A,0xFC24,0xFB7F,0xFAA9,0xF9F8,0xF8B0,0xF84C,
	0xF82C,0xF85D,0xF849,0xF77B,0xF6E7,0xF716,0xF764,0xF509,
	0xF610,0xF6DC,0xF579,0xF553,0xF4CE,0xF474,0xF473,0xF3F8,
	0xF221,0xEE90,0xEC6B,0xEDC7,0xF138,0xF3BF,0xF3CE,0xF1A3,
	0xEFBD,0xF076,0xF2BF,0xF48D,0xF489,0xF411,0xF39C,0xF3E2,
	0xF439,0xF461,0xF3EC,0xF31E,0xF2AA,0xF257,0xF1B5,0xF0A1,
	0xEFBF,0xEF49,0xEEC6,0xEE58,0xEE51,0xEDD1,0xED6E,0xECB0,
	0xEC7A,0xEC47,0xEC35,0xEC5D,0xEC0E,0xEBD1,0xEB74,0xEB2F,
	0xEAAA,0xEA7C,0xEAB2,0xEA48,0xE9EC,0xEA07,0xE9C1,0xE991,
	0xE931,0xE98C,0xEA12,0xEA7F,0xEBC9,0xEDD8,0xECAD,0xEC4A,
	0xEC00,0xEBC5,0xEBE6,0xEBDE,0xEB93,0xEB78,0xEB84,0xEAE9,
	0xEAF0,0xEBC9,0xEC32,0xEC55,0xEC64,0xEC84,0xEC6E,0xEC36,
	0xEC30,0xECFF,0xEDA7,0xED4A,0xED17,0xED7E,0xED4C,0xED73,
	0xEDEF,0xEE55,0xEF1C,0xEF67,0xEFE7,0xF0B4,0xF111,0xF10B,
	0xF1C0,0xF270,0xF2E6,0xF2C4,0xF33E,0xF379,0xF3C0,0xF3E9,
	0xF466,0xF45F,0xF3B9,0xF4C5,0xF679,0xF6EB,0xF6DC,0xF715,
	0xF7B8,0xF86D,0xF89F,0xF8D1,0xF952,0xF90F,0xF8CF,0xF95A,
	0xF95C,0xF8FE,0xF981,0xF9FB,0xFABB,0xFB2B,0xFB52,0xFBA0,
	0xFC28,0xFC9E,0xFD0A,0xFDC9,0xFE2C,0xFEB8,0xFEC5,0xFED9,
	0xFF5E,0xFF77,0xFFFB,0x0053,0x00D7,0x0153,0x017F,0x01B9,
	0x01FE,0x0218,0x02B0,0x0335,0x03A2,0x03E0,0x03F7,0x0419,
	0x0440,0x04AF,0x04B1,0x050B,0x056E,0x059C,0x0562,0x05CD,
	0x0617,0x067C,0x068F,0x072A,0x0797,0x0794,0x07B7,0x0788,
	0x0768,0x0756,0x0804,0x087A,0x090F,0x0923,0x08F0,0x0933,
	0x0995,0x09FC,0x0A7B,0x0AD0,0x0B28,0x0A67,0x0C07,0x0BBF,
	0x0B3B,0x0C56,0x0BD0,0x0C4A,0x0C7C,0x0C9A,0x0C63,0x0CD4,
	0x0C9B,0x0D0F,0x0D01,0x0D1E,0x0D43,0x0D4D,0x0D82,0x0D47,
	0x0CFA,0x0D5B,0x0D98,0x0D8B,0x0DB2,0x0DF3,0x0DBD,0x0DB3,
	0x0DF1,0x0E17,0x0E30,0x0E41,0x0E28,0x0E04,0x0E2C,0x0E45,
	0x0DF0,0x0E19,0x0E71,0x0E94,0x0EB3,0x0EE2,0x0EF2,0x0ED4,
	0x0F0E,0x0EEB,0x0EAC,0x0ED2,0x0EA9,0x0E42,0x0E09,0x0E75,
	0x0EB6,0x0EAA,0x0E7D,0x0EDE,0x0EF1,0x0E5C,0x0E2F,0x0E2E,
	0x0DE4,0x0DD1,0x0DD6,0x0D9C,0x0D3C,0x0CAE,0x0AB8,0x0A1A,
	0x0AE2,0x0AF0,0x0B30,0x0BB1,0x0B95,0x0B6D,0x0B31,0x0B2F,
	0x0B4E,0x0BA7,0x0BD9,0x0BBF,0x0B95,0x0B95,0x0B88,0x0B8E,
	0x0C41,0x0B9F,0x0BA3,0x0C54,0x0C26,0x0BCB,0x0BAF,0x0BFB,
	0x0C13,0x0BEA,0x0BF1,0x0C26,0x0C22,0x0C1E,0x0C01,0x0C26,
	0x0C14,0x0C0E,0x0BE4,0x0BD1,0x0BA8,0x0B75,0x0B2A,0x0B29,
	0x0ABD,0x0B6C,0x0CDF,0x0BE9,0x0AA0,0x0A0C,0x0A33,0x0A51,
	0x0A79,0x0A71,0x0A2A,0x0A59,0x0A61,0x0AAD,0x0A88,0x0A88,
	0x0AFE,0x0B4B,0x0B9B,0x0B54,0x0A96,0x0A34,0x09C7,0x09F3,
	0x0A00,0x0A03,0x09FF,0x095D,0x0913,0x090C,0x092B,0x098E,
	0x0995,0x0975,0x08EF,0x0880,0x0863,0x07D3,0x07D8,0x0785,
	0x0733,0x072F,0x076E,0x0799,0x0769,0x0735,0x06DC,0x0697,
	0x06BE,0x06ED,0x06CA,0x06BA,0x0695,0x060F,0x060F,0x0679,
	0x0693,0x068E,0x065A,0x0637,0x0624,0x0616,0x05AF,0x05B0,
	0x05E2,0x05B4,0x0588,0x05B3,0x053D,0x0517,0x0493,0x0483,
	0x03E0,0x041F,0x0463,0x0424,0x03CA,0x0465,0x0346,0x0236,
	0x045C,0x03C9,0x033B,0x03A8,0x0361,0x0334,0x030C,0x02AD,
	0x02D6,0x02A8,0x0234,0x0274,0x02C3,0x02B7,0x022F,0x01FA,
	0x0256,0x0269,0x02A0,0x0290,0x02B2,0x028D,0x0217,0x024B,
	0x01FB,0x01DA,0x01B0,0x01A4,0x013E,0x0125,0x017D,0x015B,
	0x017B,0x013A,0x0148,0x0127,0x010F,0x010C,0x0136,0x0159,
	0x015E,0x0103,0x011D,0x013E,0x011B,0x00F6,0x00C9,0x008E,
	0xFEE4,0xFF54,0xFF5E,0xFF20,0xFED8,0xFEA3,0xFEB4,0xFEED,
	0xFEED,0xFEFD,0xFEC1,0xFE8A,0xFEE5,0xFECB,0xFEE1,0xFEC5,
	0xFEF0,0xFEB7,0xFE64,0xFE5B,0xFE67,0xFE99,0xFD42,0xFDCA,
	0xFEB7,0xFE85,0xFEB7,0xFEDF,0xFE98,0xFEAA,0xFEBB,0xFEA2,
	0xFE55,0xFD5B,0xFD39,0xFCDC,0xFC53,0xFBF8,0xFC81,0xFC71,
	0xFC36,0xFC4A,0xFC81,0xFC65,0xFC3E,0xFC99,0xFCB8,0xFCB4,
	0xFCEA,0xFD0C,0xFCE9,0xFD3C,0xFD22,0xFCB6,0xFC9A,0xFCA0,
	0xFCE0,0xFCFA,0xFD0D,0xFD75,0xFDBE,0xFD8A,0xFDD3,0xFE4C,
	0xFF4D,0x007C,0x0101,0x01A0,0x023C,0x02F1,0x0337,0x0349,
	0x042A,0x0502,0x0587,0x0654,0x068F,0x066A,0x064A,0x069E,
	0x070A,0x077D,0x07B1,0x07DA,0x0848,0x0806,0x07EC,0x0897,
	0x097A,0x09A1,0x09F1,0x0A53,0x0B91,0x0BF3,0x0C7F,0x0D60,
	0x0DEB,0x0D57,0x0F6A,0x0F8C,0x0F32,0x114B,0x11A8,0x1183,
	0x115F,0x1192,0x11F7,0x1350,0x1398,0x13CB,0x13FD,0x1466,
	0x14F9,0x14D3,0x14FC,0x157A,0x15F5,0x1646,0x1694,0x1613,
	0x1613,0x1652,0x169C,0x161A,0x1627,0x165F,0x168B,0x16B4,
	0x16EA,0x1726,0x16F7,0x16B0,0x15BF,0x15D1,0x1612,0x1685,
	0x1663,0x15F2,0x15C9,0x158D,0x1539,0x1499,0x1439,0x141E,
	0x13E0,0x13A0,0x136D,0x1336,0x135C,0x12AA,0x1207,0x118A,
	0x113B,0x112A,0x114D,0x1144,0x113B,0x10DC,0x1004,0x0EC7,
	0x0E1A,0x0D16,0x0B28,0x0A1A,0x0A6F,0x0AE8,0x0B39,0x0A18,
	0x08B4,0x07EC,0x0814,0x081A,0x082B,0x0813,0x0712,0x05AC,
	0x0402,0x025D,0x012D,0x010C,0x00DC,0xFD7D,0xF968,0xF638,
	0xF2AD,0xEF2C,0xECF3,0xEBAC,0xEB05,0xEA54,0xE9E7,0xE92D,
	0xE929,0xE9C6,0xEBB4,0xEE83,0xF201,0xF678,0xFBA4,0x00B3,
	0x04CA,0x0866,0x0BA7,0x0EEB,0x1424,0x184D,0x1B45,0x1E11,
	0x1F66,0x1F4D,0x1E44,0x1D16,0x1BD9,0x1A26,0x1840,0x1622,
	0x13D7,0x10BB,0x0CB1,0x08C4,0x05E0,0x0229,0xFE50,0xFBA5,
	0xF8FD,0xF69C,0xF528,0xF34F,0xF0BC,0xEEC8,0xEDE6,0xED28,
	0xEC3A,0xEC51,0xECB9,0xEC19,0xEAB1,0xE996,0xE8E3,0xE8EB,
	0xE91C,0xE916,0xE8D3,0xE84A,0xE7D6,0xE7D0,0xE869,0xE901,
	0xE9FD,0xEA92,0xEABF,0xEB93,0xED8E,0xEFEE,0xF2D8,0xF527,
	0xF70B,0xF8B8,0xF9A9,0xFB94,0xFDF3,0x003C,0x0223,0x0327,
	0x037C,0x0363,0x0380,0x036D,0x0316,0x0267,0x00D4,0xFEDE,
	0xFCF9,0xFB4B,0xF9D3,0xF73E,0xF49A,0xF20B,0xEEE3,0xECA3,
	0xEB51,0xEBD0,0xE9F3,0xE749,0xE7A3,0xE560,0xE3F9,0xE407,
	0xE4B1,0xE5D5,0xE68D,0xE6AF,0xE63E,0xE642,0xE74E,0xE7E5,
	0xE821,0xE881,0xE976,0xEB4E,0xECDD,0xED57,0xED6D,0xED70,
	0xEDF3,0xEEB6,0xF009,0xF18E,0xF35D,0xF4D3,0xF52A,0xF4F6,
	0xF61A,0xF759,0xF804,0xF902,0xFA3C,0xFACA,0xFB73,0xFB94,
	0xFBE7,0xFC4C,0xFB87,0xFAD8,0xFA8B,0xFA2C,0xFA05,0xF951,
	0xF7DD,0xF67D,0xF480,0xF2F9,0xF1BE,0xF0F3,0xEFF6,0xEEF7,
	0xEE0B,0xED41,0xEBCD,0xEA86,0xEA6A,0xEA34,0xEA5E,0xEAA9,
	0xECE6,0xED58,0xED41,0xED48,0xED71,0xEDEE,0xEEB7,0xEF38,
	0xF02E,0xF170,0xF360,0xF491,0xF4B0,0xF494,0xF4CD,0xF56E,
	0xF647,0xF734,0xF847,0xF842,0xF82C,0xF94B,0xF925,0xF8B4,
	0xF9B3,0xFA9F,0xFAE7,0xFAFF,0xFAB0,0xFA14,0xFA61,0xFAD8,
	0xFAE7,0xFA73,0xF9B0,0xFA5E,0xFA2D,0xF900,0xF87F,0xF867,
	0xF7EA,0xF662,0xF54A,0xF53D,0xF46E,0xF482,0xF461,0xF419,
	0xF3AD,0xF2A7,0xF1DC,0xF1B6,0xF20B,0xF20F,0xF1E8,0xF1DC,
	0xF172,0xF13A,0xF17D,0xF1ED,0xF1AB,0xF269,0xF31F,0xF3A2,
	0xF402,0xF4B4,0xF5AD,0xF609,0xF685,0xF762,0xF810,0xF876,
	0xF8CB,0xF83D,0xF608,0xF38A,0xF1DB,0xF0E2,0xF0A8,0xEEEA,
	0xE94E,0xE051,0xD61E,0xCD75,0xC7ED,0xC5F5,0xC589,0xC479,
	0xC21F,0xBF2C,0xBE89,0xBE5E,0xC1DF,0xC9B0,0xD265,0xDC4D,
	0xE70B,0xF22A,0xFD2B,0x0806,0x12B8,0x1CF6,0x2670,0x2FB0,
	0x3970,0x3E32,0x3E1A,0x3E4D,0x3E5A,0x3E2F,0x3E4E,0x3E76,
	0x3E64,0x3E83,0x3C56,0x355C,0x2C91,0x22A0,0x19CE,0x12DE,
	0x0BF1,0x0614,0x0193,0xFA73,0xF66F,0xF34B,0xEF64,0xEC38,
	0xE94E,0xE68F,0xE568,0xE59B,0xE654,0xE77A,0xE72D,0xE609,
	0xE40A,0xE282,0xE1C9,0xE261,0xE384,0xE444,0xE3E9,0xE331,
	0xE265,0xE2A0,0xE42D,0xE69A,0xE9CE,0xECFA,0xF069,0xF3F0,
	0xF7DD,0xFC99,0x0254,0x07AF,0x0CA8,0x1165,0x1698,0x1C83,
	0x215C,0x2517,0x277B,0x2855,0x27DA,0x27BF,0x2839,0x2871,
	0x270A,0x23E5,0x1EFC,0x197E,0x14C4,0x1023,0x0B61,0x06E4,
	0x020A,0xFC5D,0xF742,0xF313,0xEF7B,0xEC6E,0xE951,0xE63D,
	0xE457,0xE2F1,0xE12C,0xE222,0xE23C,0xE250,0xE2ED,0xE36D,
	0xE4DE,0xE6D9,0xE977,0xEBDF,0xED96,0xEE54,0xEEF6,0xF0BB,
	0xF2E8,0xF52E,0xF744,0xF986,0xFADF,0xFBF8,0xFEAF,0x013B,
	0x02E4,0x0483,0x066F,0x086E,0x0AA2,0x0E00,0x10A3,0x1234,
	0x12B0,0x12DA,0x1355,0x13F7,0x14CB,0x1519,0x1543,0x13D7,
	0x1162,0x0EC1,0x0C60,0x0A8A,0x08BA,0x074C,0x0348,0xFF3E,
	0xFC54,0xF97E,0xF6F1,0xF4A5,0xF1ED,0xEF7E,0xEE09,0xED63,
	0xED74,0xED84,0xED8E,0xED38,0xED93,0xEDA8,0xEEE3,0xF09C,
	0xF220,0xF3E6,0xF5C2,0xF774,0xF918,0xFA88,0xFC11,0xFE05,
	0xFF7A,0x0168,0x02B2,0x03A4,0x04CB,0x0592,0x0660,0x0785,
	0x089D,0x0977,0x09BE,0x09F0,0x0AA0,0x0C19,0x0D22,0x0D1A,
	0x0CB1,0x0BCE,0x0B63,0x0B38,0x0B73,0x0BD6,0x0BB1,0x09FF,
	0x075C,0x055E,0x042F,0x03DD,0x033A,0x020C,0x00A7,0xFE1F,
	0xFB82,0xF995,0xF8BB,0xF833,0xF7F0,0xF793,0xF6D7,0xF55A,
	0xF47E,0xF45D,0xF4A6,0xF467,0xF47B,0xF591,0xF69F,0xF7C5,
	0xF987,0xFB75,0xFA2B,0xFBD8,0xFD22,0xFD6C,0xFF92,0x01FA,
	0x039A,0x040B,0x03E6,0x03AC,0x03B7,0x037E,0x01D8,0xFF52,
	0xFDBD,0xFCE5,0xFB52,0xF7DC,0xF09C,0xE69E,0xDB15,0xD165,
	0xCB7B,0xC903,0xC84E,0xC6F7,0xC399,0xC067,0xBF94,0xBF9D,
	0xC49F,0xCDB5,0xD7C0,0xE307,0xEE52,0xF9CD,0x0622,0x12B6,
	0x1ED2,0x2A30,0x3544,0x3DC3,0x3F0A,0x3EF6,0x3F46,0x3F41,
	0x3F34,0x3F2D,0x3F12,0x3F1E,0x3F22,0x3ED8,0x3EE4,0x3D95,
	0x350C,0x2B09,0x21AC,0x18F9,0x1144,0x0A5E,0x046C,0x0035,
	0xFD43,0xF806,0xF3B8,0xF013,0xEDAF,0xEBA9,0xE9F0,0xE97B,
	0xE9EE,0xEA14,0xE97C,0xE80E,0xE6C9,0xE59D,0xE4A9,0xE374,
	0xE360,0xE417,0xE42D,0xE36E,0xE36D,0xE40B,0xE51F,0xE653,
	0xE955,0xEC64,0xF10E,0xF6E1,0xFB5A,0xFFC4,0x04AA,0x0A74,
	0x10A0,0x1668,0x1B63,0x2034,0x2501,0x2896,0x2B2F,0x2D10,
	0x2E7F,0x2E5D,0x2CB7,0x2AB2,0x283A,0x24B6,0x2149,0x1D81,
	0x185D,0x12A2,0x0CE6,0x074C,0x01C9,0xFCD2,0xF755,0xF207,
	0xED2E,0xE9F2,0xE7F8,0xE574,0xE273,0xE186,0xE10F,0xE124,
	0xE161,0xE1CE,0xE2FE,0xE3FC,0xE520,0xE67E,0xE853,0xEA62,
	0xEC6C,0xEDC8,0xEF39,0xF123,0xF2D5,0xF46F,0xF65F,0xF867,
	0xFA83,0xFC68,0xFE38,0x0036,0x02D7,0x05CA,0x0855,0x0AAA,
	0x0C59,0x0E54,0x1042,0x121C,0x136F,0x145C,0x1603,0x176A,
	0x16D5,0x15AA,0x14BA,0x13CB,0x12BD,0x1067,0x0E47,0x0BEE,
	0x091D,0x05BF,0x0219,0xFEE8,0xFBF8,0xF8EA,0xF55B,0xF2B4,
	0xF062,0xEEED,0xED67,0xEC65,0xEAD0,0xE9AF,0xE91C,0xE9CD,
	0xE9F2,0xECCC,0xEDB3,0xED7B,0xEFA6,0xF04E,0xF1A4,0xF368,
	0xF668,0xF8C8,0xFAA8,0xFC03,0xFD9F,0xFE91,0x0043,0x0207,
	0x03DA,0x0544,0x0602,0x073F,0x082C,0x096F,0x09F0,0x0A74,
	0x0A73,0x0A8A,0x0B42,0x0C84,0x0D7A,0x0D31,0x0BED,0x0A97,
	0x09C1,0x08E3,0x08F7,0x08B0,0x07FA,0x0677,0x0455,0x0238,
	0x0079,0xFF2D,0xFDA6,0xFC0C,0xF9ED,0xF851,0xF6FA,0xF623,
	0xF537,0xF366,0xF17B,0xF05E,0xF01C,0xF0F3,0xF1B9,0xF261,
	0xF2E1,0xF35C,0xF397,0xF39E,0xF4A4,0xF626,0xF8C1,0xFACF,
	0xFB9B,0xFB0C,0xFBDE,0xFE4A,0xFF4C,0x0005,0x010F,0x0254,
	0x031A,0x02A6,0x0064,0xFD41,0xFB7A,0xFA87,0xF900,0xF59D,
	0xEDEE,0xE359,0xD8C0,0xD0C7,0xCA95,0xC7C2,0xC786,0xC636,
	0xC31A,0xC00E,0xBF92,0xC116,0xC82B,0xD144,0xDB2A,0xE696,
	0xF238,0xFE74,0x0B14,0x178F,0x2359,0x2DAA,0x37C2,0x3F0A,
	0x3FDC,0x3FD6,0x3FFC,0x4001,0x4023,0x40AB,0x4010,0x3FE4,
	0x3FD2,0x3FAA,0x3FDE,0x3DBC,0x33F4,0x28F8,0x1F0B,0x17B4,
	0x11FF,0x0C0C,0x05D8,0x00D4,0xFCE8,0xF8D8,0xF4F1,0xF172,
	0xEE3A,0xEC17,0xEB57,0xEBAD,0xEC73,0xED77,0xEC8F,0xEA77,
	0xE6C6,0xE48A,0xE3F8,0xE444,0xE589,0xE5E1,0xE54B,0xE3EE,
	0xE23D,0xE1FE,0xE3D0,0xE6F3,0xEAF0,0xEEA0,0xF23D,0xF668,
	0xFAF6,0x0073,0x0670,0x0C66,0x11E7,0x16BC,0x1BC8,0x2108,
	0x266E,0x2A83,0x2CA6,0x2D38,0x2D1C,0x2CFE,0x2C8B,0x2B56,
	0x28DC,0x2521,0x2031,0x1AF2,0x159E,0x1007,0x0AAF,0x04CF,
	0xFF02,0xF9CE,0xF55E,0xF16F,0xEE78,0xEB07,0xE740,0xE43A,
	0xE30D,0xE13F,0xE12F,0xE4A6,0xE4C7,0xE464,0xE4B5,0xE53A,
	0xE691,0xE874,0xEA60,0xEC96,0xEE8C,0xF05C,0xF1D7,0xF2A7,
	0xF420,0xF630,0xF7FB,0xF98D,0xFBC6,0xFE5B,0x00E9,0x02EB,
	0x04B0,0x0680,0x0802,0x0980,0x0C01,0x0F88,0x12BB,0x14B5,
	0x1597,0x155D,0x153B,0x15E2,0x15FC,0x160B,0x15E2,0x14DC,
	0x12DF,0x0FC4,0x0CB7,0x0A91,0x07F7,0x046C,0x0084,0xFCEA,
	0xFABE,0xF84F,0xF560,0xF24F,0xEF5D,0xEC7E,0xEA34,0xE9A3,
	0xE9F4,0xEAD6,0xEAA7,0xE94D,0xE8AD,0xE9E1,0xEC3A,0xF093,
	0xF2AD,0xF3DC,0xF511,0xF5E9,0xF70B,0xF8FD,0xFB50,0xFDA0,
	0xFF11,0x0059,0x01A3,0x032C,0x04C2,0x0651,0x072B,0x0721,
	0x07C8,0x0937,0x0A00,0x0B21,0x0C72,0x0C19,0x0BA4,0x0BE9,
	0x0C22,0x0BF7,0x0C14,0x0BD9,0x0B0A,0x0A30,0x098D,0x08A2,
	0x072B,0x050F,0x0364,0x0192,0x008F,0xFF76,0xFE62,0xFC61,
	0xFA36,0xF821,0xF634,0xF536,0xF3B9,0xF2FF,0xF3A5,0xF3A2,
	0xF2E0,0xF214,0xF1DA,0xF203,0xF32A,0xF491,0xF5AF,0xF614,
	0xF71F,0xF7F2,0xF954,0xF99C,0xFAA3,0xFC63,0xFE77,0x003F,
	0x018B,0x0279,0x02A5,0x025E,0x008B,0xFDBC,0xFBA7,0xFAF3,
	0xFB09,0xF9E1,0xF48E,0xEB7D,0xDFF5,0xD48C,0xCCBB,0xC98B,
	0xC8DC,0xC832,0xC5E8,0xC29A,0xBFF0,0xBEB7,0xC1F6,0xC970,
	0xD32F,0xDDBD,0xE8CC,0xF4D3,0x013F,0x0D73,0x193B,0x23BF,
	0x2E29,0x3922,0x3E66,0x3E65,0x3E9B,0x3EC4,0x3E84,0x3E87,
	0x3E82,0x3EA5,0x3E87,0x3E59,0x3E41,0x3E16,0x371F,0x2C98,
	0x227E,0x196D,0x119C,0x0B27,0x0535,0xFFE0,0xFB13,0xF68C,
	0xF2E3,0xF0CF,0xEBD3,0xE94A,0xE790,0xE7AB,0xE876,0xE996,
	0xE99C,0xE83D,0xE691,0xE453,0xE2DD,0xE224,0xE2F7,0xE3AF,
	0xE3B7,0xE311,0xE2FB,0xE33E,0xE40A,0xE47B,0xE6BC,0xEA68,
	0xEEC5,0xF400,0xF920,0xFEB7,0x03E7,0x0872,0x0D31,0x12B6,
	0x18D2,0x1F55,0x24C3,0x297E,0x2CC1,0x2EBE,0x2F48,0x2E66,
	0x2D59,0x2C1C,0x2ADF,0x288B,0x24C1,0x1F7E,0x19DE,0x1435,
	0x0E1A,0x0847,0x029D,0xFE13,0xF936,0xF4A5,0xF00D,0xEC58,
	0xE9B2,0xE687,0xE429,0xE346,0xE303,0xE32C,0xE342,0xE3C0,
	0xE3C8,0xE290,0xE39B,0xE51A,0xE727,0xE9EB,0xEC44,0xED91,
	0xEED7,0xF0BA,0xF27C,0xF45C,0xF5EC,0xF737,0xF960,0xFB85,
	0xFDE3,0x0013,0x02FE,0x0516,0x05E6,0x0809,0x0AA2,0x0D2A,
	0x0F93,0x11EF,0x13F8,0x14FD,0x1658,0x160C,0x158C,0x160F,
	0x1612,0x1598,0x1409,0x11DF,0x0FD0,0x0D5B,0x0A19,0x069B,
	0x0303,0x0021,0xFDA0,0xFACD,0xF929,0xF5FA,0xF24A,0xEEDA,
	0xEC04,0xEAA9,0xEA73,0xEA74,0xEA89,0xEB26,0xEBA1,0xEBE3,
	0xEBFF,0xED5E,0xEFD1,0xF371,0xF50B,0xF62E,0xF795,0xF91E,
	0xFAAC,0xFC1D,0xFE3B,0x0013,0x0162,0x0205,0x0422,0x05F5,
	0x0747,0x080A,0x0809,0x07E7,0x083B,0x0938,0x0A37,0x0B4A,
	0x0BC1,0x0BA8,0x0B24,0x0ABE,0x0A78,0x0AE2,0x0B58,0x0AA5,
	0x08FC,0x0802,0x06DF,0x05C4,0x04BF,0x0384,0x01B9,0xFF8A,
	0xFD63,0xFB79,0xFAB2,0xFA79,0xF8A4,0xF610,0xF499,0xF39E,
	0xF265,0xF1B7,0xF1DD,0xF2E6,0xF349,0xF208,0xF0DE,0xF1A9,
	0xF378,0xF4FE,0xF5B4,0xF6B0,0xF8A6,0xFA49,0xFAE5,0xFBFD,
	0xFE7F,0xFDDB,0xFFD8,0x01AA,0x01DE,0x03A7,0x0489,0x0390,
	0x0101,0xFE4A,0xFC50,0xFB8E,0xFB41,0xF94A,0xF38C,0xE8FC,
	0xDCDD,0xD1F2,0xCB62,0xC8FC,0xC8A8,0xC74F,0xC417,0xC069,
	0xBF9E,0xBF87,0xC27F,0xCB1B,0xD4EC,0xDF6B,0xEA4A,0xF658,
	0x0358,0x1036,0x1BD4,0x2621,0x3011,0x3A04,0x3EF7,0x3F24,
	0x3F21,0x3F46,0x3F22,0x3F48,0x3F3F,0x3F12,0x3F50,0x3F12,
	0x3F0C,0x3DC4,0x34A2,0x29B8,0x2031,0x1815,0x10E5,0x0AAA,
	0x0479,0xFEC6,0xF9AA,0xF5B0,0xF234,0xEE80,0xEC93,0xEC01,
	0xEA16,0xE990,0xE9F2,0xEA9A,0xEA67,0xE8BF,0xE5CA,0xE3DC,
	0xE344,0xE31C,0xE386,0xE3E5,0xE37E,0xE357,0xE29D,0xE1F7,
	0xE2AB,0xE462,0xE780,0xEBEE,0xF099,0xF4F7,0xF927,0xFDE5,
	0x0238,0x0749,0x0DB7,0x1415,0x19CB,0x1F79,0x2443,0x2789,
	0x29A0,0x2AF9,0x2C18,0x2C0E,0x2BBC,0x2A79,0x2906,0x260E,
	0x219C,0x1BFD,0x1672,0x1023,0x094A,0x0520,0x00FE,0xFC57,
	0xF718,0xF200,0xEC83,0xE83A,0xE556,0xE393,0xE275,0xE13B,
	0xDFFE,0xDFAB,0xDF54,0xDEC7,0xDF33,0xE0AE,0xE274,0xE424,
	0xE57D,0xE6CB,0xE867,0xE9E0,0xEB19,0xECBD,0xEEA8,0xF07C,
	0xF260,0xF42F,0xF5BB,0xF7CC,0xFA8D,0xFC9C,0xFE7F,0x00BD,
	0x0352,0x05EB,0x07E3,0x0A3D,0x0CC4,0x0EFE,0x108F,0x116E,
	0x1252,0x12C8,0x1262,0x1215,0x11E9,0x11A4,0x103E,0x0DB2,
	0x0A65,0x07A7,0x04F3,0x01F9,0xFF3D,0xFCF3,0xF9CF,0xF5FF,
	0xF1FA,0xEEFB,0xED3E,0xEB8A,0xE9AE,0xE7DD,0xE78E,0xE70D,
	0xE6E7,0xE733,0xE82D,0xE8AE,0xE9C7,0xEB89,0xED1B,0xEE31,
	0xF1F0,0xF3A3,0xF3E7,0xF664,0xF77C,0xF9A0,0xFB9C,0xFD99,
	0xFF24,0x010E,0x025D,0x0360,0x03EF,0x04E3,0x05E6,0x06C3,
	0x0814,0x099D,0x0B18,0x0B9E,0x0B58,0x0ACE,0x0B3A,0x0C0E,
	0x0C95,0x0CAE,0x0CFF,0x0D06,0x0B84,0x093E,0x0729,0x0694,
	0x05F8,0x055D,0x0392,0x019E,0xFFDD,0xFE17,0xFBF5,0xFA54,
	0xF8DE,0xF746,0xF5D8,0xF4E2,0xF4AB,0xF4AD,0xF405,0xF31F,
	0xF301,0xF2BA,0xF2E6,0xF433,0xF5FC,0xF782,0xF8AE,0xF93D,
	0xFA1E,0xFB45,0xFC79,0xFE27,0xFFB9,0x0131,0x02D7,0x040C,
	0x032C,0x02C9,0x0349,0x026D,0x0067,0xFDBE,0xFC62,0xFC05,
	0xFB00,0xF788,0xF01A,0xE548,0xD9AB,0xD041,0xCACB,0xC886,
	0xC7E8,0xC6E4,0xC451,0xC014,0xBF16,0xBFC8,0xC4EF,0xCD94,
	0xD834,0xE3A5,0xEF3D,0xFB33,0x075F,0x1361,0x1EE2,0x2922,
	0x3427,0x3DFF,0x3FC6,0x3FA8,0x4015,0x3FF2,0x3FFD,0x3FED,
	0x400B,0x401C,0x3FE3,0x3FE7,0x40A9,0x3E34,0x3381,0x295C,
	0x20FA,0x18E2,0x11DC,0x0BF3,0x0655,0x0138,0xFC2D,0xF7B4,
	0xF3AE,0xF05D,0xEE28,0xEC51,0xEB8D,0xEB40,0xEBBA,0xEB2D,
	0xE9E8,0xE7C3,0xE605,0xE4DB,0xE3F6,0xE3CE,0xE451,0xE4B6,
	0xE409,0xE2FC,0xE21E,0xE1F9,0xE33E,0xE5B2,0xE87D,0xEC0F,
	0xF0BC,0xF5B0,0xF9FE,0xFED8,0x0418,0x09AE,0x0F40,0x1541,
	0x1B20,0x2061,0x24E3,0x2837,0x2B30,0x2D18,0x2D77,0x2CE6,
	0x2BDE,0x2A84,0x28A5,0x2541,0x2169,0x1CD2,0x1764,0x110A,
	0x0AD3,0x0596,0x00EE,0xFC61,0xF794,0xF2F9,0xEE72,0xEAF6,
	0xE7B6,0xE55B,0xE370,0xE2A7,0xE1E6,0xE1B1,0xE22C,0xE400,
	0xE34A,0xE39F,0xE66E,0xE6CF,0xE8B7,0xEB8E,0xED61,0xEE80,
	0xEFD3,0xF109,0xF260,0xF3FF,0xF6B0,0xF978,0xFB8B,0xFCE4,
	0xFE27,0x0046,0x02A9,0x0569,0x07FF,0x0A71,0x0CAC,0x0E1D,
	0x0F9A,0x11AE,0x13B0,0x158F,0x15CF,0x1577,0x153C,0x14DD,
	0x14F9,0x142C,0x1238,0x0FB1,0x0C8C,0x0957,0x065D,0x040A,
	0x0234,0xFF9C,0xFB5C,0xF6F1,0xF324,0xEFE7,0xEE6A,0xED4D,
	0xEBD7,0xEA48,0xE89B,0xE743,0xE705,0xE767,0xE7D4,0xE921,
	0xEA43,0xEC07,0xEDD5,0xEF38,0xF0AD,0xF25F,0xF702,0xF93B,
	0xFACE,0xFCE8,0xFEF4,0x001D,0x0110,0x01F8,0x0387,0x04F0,
	0x05EF,0x070E,0x084F,0x0929,0x0A2D,0x0ACC,0x0B46,0x0BA9,
	0x0BBD,0x0AE5,0x0B3E,0x0C72,0x0C80,0x0B61,0x0AC7,0x0A23,
	0x08A1,0x0711,0x05E5,0x0526,0x0441,0x0214,0xFF9D,0xFDCA,
	0xFC31,0xFB73,0xF975,0xF71B,0xF582,0xF456,0xF31F,0xF1CF,
	0xF0D7,0xF0A1,0xF08F,0xEEAB,0xED70,0xEEE8,0xF091,0xF1B3,
	0xF269,0xF2F2,0xF3D3,0xF57D,0xF726,0xF85A,0xF953,0xFA3B,
	0xFB21,0xFC4B,0xFD3B,0xFEEE,0x00B5,0x0107,0xFE9F,0xFC2C,
	0xFA53,0xF9B1,0xFA5E,0xF99F,0xF5BF,0xEE10,0xE455,0xDA23,
	0xD320,0xD027,0xCFDE,0xCF45,0xCCA1,0xC904,0xC618,0xC55B,
	0xC8BA,0xCED3,0xD6AB,0xDF37,0xE7D7,0xF1F3,0xFCF6,0x088A,
	0x1383,0x1CAF,0x24F5,0x2D63,0x3712,0x3E0D,0x3E6E,0x3E4C,
	0x3E74,0x3E79,0x3EA3,0x3EA6,0x3E65,0x3E66,0x3DBE,0x37F1,
	0x2FE6,0x276D,0x1F16,0x16CB,0x101E,0x0A6E,0x054E,0xFFF7,
	0xFBAB,0xF867,0xF5CA,0xF25D,0xEFD6,0xED7B,0xEAFE,0xEB2D,
	0xECF4,0xEB9A,0xECA7,0xEC1B,0xEA20,0xE814,0xE694,0xE5D3,
	0xE6C5,0xE704,0xE72B,0xE720,0xE6A5,0xE665,0xE641,0xE779,
	0xE99E,0xECEB,0xF04D,0xF3FE,0xF851,0xFD36,0x01B8,0x05B6,
	0x0A61,0x0F42,0x1491,0x19AA,0x1E86,0x225A,0x2552,0x26D5,
	0x2780,0x280F,0x282C,0x27D5,0x2601,0x23D8,0x202F,0x1C2A,
	0x1745,0x1263,0x0D6F,0x08CD,0x03EC,0xFF74,0xFB37,0xF6CE,
	0xF301,0xEF7D,0xEC8F,0xEA01,0xE809,0xE6B3,0xE5CA,0xE63A,
	0xE700,0xE773,0xE79F,0xE826,0xE8DC,0xEA45,0xEB9D,0xEC34,
	0xEC80,0xEE2D,0xEF1D,0xEFB5,0xF12B,0xF2E6,0xF4DA,0xF6F5,
	0xF8B0,0xFA6F,0xFB8C,0xFC8C,0xFE46,0x00A2,0x02E9,0x050D,
	0x06EA,0x09C2,0x0B89,0x0C81,0x0E81,0x1040,0x10EB,0x113F,
	0x111F,0x118B,0x11F4,0x1274,0x1117,0x0EF5,0x0CD8,0x0AAE,
	0x0871,0x0622,0x03A7,0x01B3,0xFEC4,0xFB9C,0xF91D,0xF683,
	0xF44D,0xF2A4,0xF11D,0xF0BA,0xEFA1,0xEDB4,0xED93,0xED9C,
	0xEDB9,0xEE18,0xEED4,0xEFA3,0xF041,0xF215,0xF4B4,0xF741,
	0xF8E9,0xFA0F,0xFBEE,0xFD29,0xFE5F,0xFFAD,0x0139,0x0252,
	0x03C4,0x0523,0x060B,0x06FE,0x077B,0x07FC,0x089F,0x0951,
	0x09FA,0x0AB7,0x0B3E,0x0B6F,0x0B85,0x0B3B,0x0A63,0x0974,
	0x0988,0x0A28,0x0A60,0x096A,0x07B1,0x05F2,0x04A8,0x039F,
	0x0260,0x012B,0x003C,0xFEDF,0xFCC7,0xFA89,0xF975,0xF8FE,
	0xF7D6,0xF637,0xF512,0xF47A,0xF48F,0xF46D,0xF3C5,0xF3BD,
	0xF46E,0xF4E0,0xF578,0xF63D,0xF83E,0xF941,0xF9BC,0xF9F1,
	0xFAD2,0xFB95,0xFD73,0xFFA4,0x00FB,0x022D,0x037F,0x0428,
	0x024C,0x0415,0x04C0,0x0370,0x034B,0x0316,0x02C6,0x024D,
	0x0044,0xFC6C,0xF821,0xF442,0xF189,0xEFC8,0xEF67,0xEEE9,
	0xED52,0xEB5E,0xE98A,0xE930,0xEA7A,0xECCA,0xEF58,0xF299,
	0xF6D2,0xFA77,0xFE05,0x01B4,0x0583,0x0959,0x0CFD,0x1050,
	0x13A5,0x175B,0x1AAB,0x1C82,0x1C85,0x1B06,0x199F,0x18C3,
	0x185B,0x17A1,0x15D0,0x1334,0x101B,0x0C8C,0x09BD,0x07A6,
	0x056D,0x02FB,0x00C5,0xFF29,0xFE61,0xFD1E,0xFBC7,0xFB20,
	0xFA52,0xF9C2,0xF935,0xF8AF,0xF935,0xFAF8,0xFC6A,0xFAB4,
	0xF9AF,0xF927,0xF85C,0xF74B,0xF725,0xF761,0xF712,0xF6B0,
	0xF668,0xF669,0xF642,0xF618,0xF664,0xF738,0xF909,0xFB59,
	0xFC84,0xFD20,0xFF29,0x0098,0x0144,0x0343,0x0669,0x0859,
	0x09CC,0x0AC5,0x0BDC,0x0CDE,0x0CF3,0x0CFF,0x0D26,0x0CCE,
	0x0BCF,0x0B64,0x0A1B,0x08DB,0x06F1,0x049A,0x026E,0x0081,
	0xFF09,0xFEBC,0xFD37,0xFB08,0xF9FB,0xF919,0xF7C3,0xF6C1,
	0xF617,0xF5CD,0xF648,0xF644,0xF5FB,0xF551,0xF4D0,0xF511,
	0xF4D8,0xF4CA,0xF501,0xF5CB,0xF5E9,0xF628,0xF5E7,0xF5B1,
	0xF5C2,0xF56C,0xF50E,0xF4F4,0xF520,0xF55A,0xF4ED,0xF51E,
	0xF4C5,0xF485,0xF456,0xF27B,0xEE6F,0xE922,0xE523,0xE419,
	0xE57A,0xE757,0xE873,0xE771,0xE467,0xE1B6,0xE000,0xDFD8,
	0xE05B,0xE12E,0xE194,0xE1A6,0xE146,0xE154,0xE173,0xE157,
	0xE174,0xE105,0xE10C,0xE122,0xE1B8,0xE1C4,0xE186,0xE17E,
	0xE0FB,0xE0C1,0xE067,0xE0CE,0xE17C,0xE224,0xE23E,0xE254,
	0xE292,0xE385,0xE3D0,0xE439,0xE50C,0xE5BD,0xE5A6,0xE7E9,
	0xE778,0xE712,0xE8C2,0xE83B,0xE899,0xE96F,0xEA26,0xEB08,
	0xEC0A,0xEC11,0xEC77,0xEC57,0xEC49,0xEC79,0xED5C,0xEE7B,
	0xEF55,0xEFB3,0xEFCF,0xF024,0xF03C,0xF0DF,0xF1B2,0xF2BB,
	0xF359,0xF39B,0xF401,0xF443,0xF4CA,0xF4EE,0xF553,0xF5EF,
	0xF64A,0xF6B6,0xF74E,0xF7B8,0xF81D,0xF842,0xF855,0xF8D1,
	0xF984,0xFA82,0xFB49,0xFBD6,0xFBB6,0xFBFE,0xFC5D,0xFCCC,
	0xFD44,0xFE10,0xFECC,0xFF13,0xFF3D,0xFFD0,0x001D,0x0094,
	0x011B,0x0128,0x0192,0x0225,0x0281,0x0315,0x0317,0x01B4,
	0x01A4,0x02E8,0x02F6,0x0316,0x02CA,0x02CA,0x0349,0x03AD,
	0x03F0,0x0476,0x04EE,0x0596,0x05E0,0x0637,0x0685,0x06D9,
	0x07A0,0x08A3,0x0823,0x078D,0x08CF,0x0958,0x093E,0x096F,
	0x09E3,0x0A20,0x0A20,0x0A6F,0x0AEA,0x0B99,0x0B7A,0x0BBC,
	0x0C82,0x0CD2,0x0D51,0x0DF2,0x0E08,0x0DB1,0x0DC4,0x0E1B,
	0x0E9B,0x0E55,0x0E95,0x0F7B,0x0E41,0x0E0E,0x0E0E,0x0E3B,
	0x0E9B,0x0ED2,0x0ED2,0x0ED9,0x0F48,0x0FFF,0x10DC,0x10B2,
	0x10B4,0x112B,0x108D,0x0FF9,0x0FCD,0x1013,0x1034,0x1063,
	0x1093,0x10AF,0x10EE,0x111C,0x111F,0x114F,0x116C,0x1157,
	0x1128,0x1143,0x1153,0x1089,0x1016,0x1005,0x1010,0x1030,
	0x10D8,0x1137,0x1117,0x113A,0x10CB,0x1070,0x1005,0x0F9D,
	0x0FC6,0x103F,0x1066,0x0FDA,0x0F61,0x0F29,0x0F20,0x0F91,
	0x0F51,0x0F9F,0x0FED,0x0FCD,0x0F81,0x0F04,0x0EC4,0x0E6C,
	0x0E63,0x0E27,0x0E45,0x0E7B,0x0E6E,0x0E69,0x0E64,0x0EA0,
	0x0E4D,0x0DA0,0x0DE7,0x0DE0,0x0D8C,0x0D74,0x0DD0,0x0C28,
	0x0B7C,0x0D60,0x0C92,0x0C80,0x0CF1,0x0CCD,0x0C7C,0x0C13,
	0x0BC9,0x0BE8,0x0BE6,0x0BE3,0x0B2D,0x0B44,0x0B2C,0x0B06,
	0x0AC6,0x0ACD,0x0ABE,0x0AD3,0x0ACB,0x0A67,0x09ED,0x0986,
	0x09C5,0x09D5,0x0952,0x0957,0x0999,0x096E,0x0912,0x08FE,
	0x08DC,0x08BA,0x08AE,0x08E3,0x08B1,0x087D,0x0827,0x07F5,
	0x0795,0x07CB,0x076D,0x0773,0x07D8,0x077E,0x07B2,0x0724,
	0x0702,0x0724,0x0757,0x06CD,0x0705,0x06D4,0x06B5,0x06BC,
	0x0626,0x0625,0x065B,0x068A,0x06C2,0x095A,0x0976,0x0894,
	0x0884,0x082E,0x0789,0x076E,0x0762,0x078B,0x07BF,0x07BF,
	0x07A3,0x073B,0x06A3,0x0688,0x067A,0x0624,0x05CF,0x05C6,
	0x0586,0x0567,0x05EF,0x05BC,0x050F,0x050F,0x053B,0x04B0,
	0x04F4,0x04CB,0x04A9,0x0463,0x0414,0x0397,0x039E,0x0381,
	0x034E,0x0331,0x034D,0x0306,0x02DF,0x0305,0x02C9,0x02B0,
	0x0293,0x02D8,0x01E5,0x012C,0x026F,0x0307,0x0276,0x0249,
	0x0223,0x01EB,0x0197,0x0188,0x0159,0x00CB,0x00C2,0x00D6,
	0x007F,0xFF78,0xFF14,0xFF1E,0xFE79,0xFF0B,0xFFC2,0xFF37,
	0xFEA9,0xFEF0,0xFEE3,0xFE85,0xFE76,0xFE33,0xFE75,0xFE9B,
	0xFE6F,0xFEBF,0xFEC4,0xFE96,0xFEA5,0xFDCC,0xFE0A,0xFDF3,
	0xFE13,0xFE47,0xFDFD,0xFDDA,0xFE53,0xFDED,0xFCB8,0xFD4F,
	0xFE5A,0xFEA4,0xFE6F,0xFE3F,0xFE92,0xFE36,0xFE09,0xFE4C,
	0xFE3B,0xFD8D,0xFD07,0xFD26,0xFCDE,0xFC2B,0xFC2C,0xFC5C,
	0xFC89,0xFC34,0xFC7E,0xFC9F,0xFC9F,0xFCD4,0xFCF5,0xFD0D,
	0xFD1E,0xFD09,0xFD31,0xFD6E,0xFDA7,0xFD8F,0xFDBC,0xFD88,
	0xFD67,0xFDA5,0xFD7B,0xFD7B,0xFD90,0xFD60,0xFD30,0xFD34,
	0xFD5D,0xFD39,0xFD5C,0xFD4A,0xFD7C,0xFD9F,0xFD74,0xFD99,
	0xFDAE,0xFD89,0xFDDD,0xFD83,0xFD1E,0xFD3C,0xFD83,0xFD47,
	0xFD35,0xFD34,0xFD59,0xFD56,0xFD57,0xFD1A,0xFD9C,0xFD83,
	0xFDDE,0xFDFA,0xFE0F,0xFEB0,0xFFC4,0x0057,0x00A1,0x010A,
	0x0297,0x02C8,0x04D3,0x05CE,0x049B,0x0678,0x0750,0x08C8,
	0x0A2E,0x0B1F,0x0B5E,0x0C27,0x0C0B,0x0CAC,0x0CE3,0x0CF5,
	0x0D24,0x0D2C,0x0DA6,0x0DBD,0x0DE6,0x0DE1,0x0E2F,0x0E6A,
	0x0F20,0x0FF4,0x107F,0x102B,0x0FA2,0x1071,0x11AB,0x130E,
	0x143B,0x14CC,0x148C,0x1439,0x1466,0x1578,0x165F,0x16D1,
	0x1747,0x1785,0x17A6,0x17C9,0x182F,0x18F8,0x1988,0x19A6,
	0x19EF,0x19F3,0x1A77,0x1B34,0x1AFD,0x1AF8,0x1A78,0x1AD3,
	0x1B0E,0x1B21,0x1A6A,0x1A49,0x1ADE,0x1AFD,0x1A02,0x18DF,
	0x190D,0x1A09,0x18FD,0x1770,0x1744,0x170B,0x1730,0x1706,
	0x16CD,0x16CA,0x1688,0x15B7,0x14E1,0x14FD,0x156E,0x14CD,
	0x13BA,0x131F,0x137D,0x142E,0x14B0,0x133C,0x11A0,0x1201,
	0x122D,0x1218,0x1224,0x1221,0x1114,0x1032,0x0F8F,0x0F86,
	0x1020,0x107A,0x0F25,0x0D19,0x0C49,0x0D27,0x0DD4,0x0D45,
	0x0BC8,0x0AEB,0x0A77,0x0AEB,0x0AAB,0x0A78,0x0B86,0x09B0,
	0x073E,0x066F,0x077E,0x0865,0x076C,0x05C7,0x03FC,0x034E,
	0x0417,0x0528,0x0558,0x04E4,0x046B,0x032B,0x0256,0x0253,
	0x0263,0x0172,0x0089,0xFFCD,0xFFB3,0xFF8E,0xFEB4,0xFDD1,
	0xFC50,0xFAF0,0xF904,0xF6B8,0xF41B,0xF020,0xEAE3,0xE593,
	0xE1E3,0xE0E9,0xE121,0xE2BD,0xE46D,0xE52C,0xE50F,0xE538,
	0xE6BD,0xE96E,0xEC29,0xEE5E,0xEF07,0xEDD5,0xEC38,0xEB7F,
	0xEB91,0xEC29,0xED41,0xEEC5,0xF13E,0xF426,0xF709,0xF99E,
	0xFC43,0xFF4F,0x02D0,0x063C,0x08DF,0x0AC2,0x0B1C,0x09ED,
	0x0897,0x08B5,0x097E,0x09BC,0x08F0,0x094C,0x09B6,0x09C6,
	0x09BB,0x0ABC,0x0B7F,0x0AD7,0x0CFC,0x0B8B,0x09D5,0x08C6,
	0x061A,0x02D8,0xFFD7,0xFDDF,0xFBE3,0xF99B,0xF6B7,0xF45C,
	0xF253,0xF0C2,0xEF64,0xEE91,0xEE59,0xED53,0xEBC7,0xEA6D,
	0xE8BD,0xE6E6,0xE539,0xE336,0xE0FA,0xDEF8,0xDD85,0xDC5C,
	0xDB6E,0xDAEC,0xDA90,0xDA56,0xDAE6,0xDC0A,0xDD43,0xDE25,
	0xDF87,0xDFF4,0xDFED,0xDFEA,0xE07E,0xE180,0xE282,0xE322,
	0xE32C,0xE3A1,0xE495,0xE5A9,0xE72D,0xE8CD,0xEBA5,0xEE21,
	0xEF97,0xF044,0xF102,0xF267,0xF438,0xF4F3,0xF4DC,0xF5BB,
	0xF8F6,0xFA16,0xF8AD,0xF8CE,0xF963,0xFA93,0xFB25,0xFAF2,
	0xFB1D,0xFB0E,0xFB40,0xFB40,0xFB81,0xFB91,0xFB83,0xFA9B,
	0xF8ED,0xF6BD,0xF5BE,0xF511,0xF456,0xF442,0xF32E,0xF13B,
	0xF0AA,0xF003,0xEEAE,0xEE61,0xEE14,0xED57,0xEC9D,0xEC80,
	0xEC77,0xEB4E,0xE8F7,0xE730,0xE71B,0xE810,0xE877,0xE7C1,
	0xE675,0xE5E1,0xE5E5,0xE6D6,0xE7D4,0xE81B,0xE822,0xE8E2,
	0xE8BD,0xE945,0xEA8F,0xEB90,0xEBA4,0xEB41,0xEBE2,0xEC85,
	0xECDB,0xED60,0xEE53,0xEEFB,0xEF46,0xF04B,0xF1C4,0xF32A,
	0xF3EC,0xF42A,0xF545,0xF6F3,0xF809,0xF876,0xF7BB,0xF7C6,
	0xF85C,0xF9D4,0xFAF2,0xFABA,0xFA72,0xFA2A,0xFA36,0xFAEA,
	0xFB5B,0xFB8F,0xFB50,0xFACE,0xFA64,0xFA82,0xFB52,0xFB3E,
	0xF99B,0xF8D2,0xF907,0xF9C9,0xF97D,0xF8D7,0xF7F1,0xF6FC,
	0xF68E,0xF65B,0xF6B3,0xF764,0xF694,0xF56D,0xF463,0xF4C6,
	0xF570,0xF4DA,0xF3D8,0xF2EE,0xF31F,0xF30A,0xF32E,0xF2BE,
	0xF2DA,0xF2DC,0xF372,0xF4E2,0xF597,0xF4FD,0xF4AC,0xF4B0,
	0xF4E9,0xF669,0xF94B,0xF77D,0xF6BB,0xF748,0xF7F0,0xF921,
	0xF9CF,0xFA2F,0xFA52,0xFB6E,0xFBB8,0xFBA7,0xFB41,0xFB6C,
	0xFB4F,0xFB87,0xFB70,0xFBA9,0xFBD4,0xFB0C,0xFA8C,0xFAE6,
	0xFBEC,0xFD78,0xFE48,0xFE34,0xFE83,0xFEDA,0xFEF2,0xFFD2,
	0x002A,0xFF98,0xFF52,0xFF9A,0x0012,0x00A8,0x0078,0x0028,
	0xFF80,0xFF99,0x007A,0x0117,0x015C,0x01AC,0x01B2,0x0130,
	0x00B7,0x0049,0x0033,0xFF7E,0xFE24,0xFD9B,0xFD2E,0xFCB7,
	0xFB9C,0xFAA9,0xFA04,0xF93C,0xF8C2,0xF830,0xF7A7,0xF6D2,
	0xF604,0xF4F8,0xF299,0xF262,0xF330,0xF305,0xF23E,0xF1B9,
	0xF19A,0xF0FA,0xF069,0xEFC2,0xEF57,0xEF31,0xEEE3,0xEEB1,
	0xEE1F,0xED95,0xED88,0xED39,0xECB8,0xEB4D,0xEB6F,0xEBB4,
	0xEADD,0xE9B3,0xE952,0xE978,0xE963,0xE92D,0xE8F9,0xE8A4,
	0xE86E,0xE81B,0xE7E4,0xE804,0xE811,0xE863,0xE859,0xE7BC,
	0xE7EA,0xE75A,0xE766,0xE7B2,0xE7D0,0xE8F1,0xE960,0xE7E8,
	0xE77F,0xE76D,0xE776,0xE7C0,0xE889,0xE8C5,0xE910,0xE8CF,
	0xE93B,0xE9A2,0xE9D5,0xEA3B,0xEB14,0xEB7C,0xEB6F,0xEBA0,
	0xEBF7,0xEC3D,0xECA8,0xED1A,0xED27,0xED74,0xEE12,0xEE41,
	0xEEB8,0xEEEF,0xEF21,0xEFB0,0xF05C,0xF122,0xF191,0xF1D0,
	0xF1FD,0xF289,0xF2D8,0xF3B2,0xF4AA,0xF508,0xF535,0xF538,
	0xF541,0xF574,0xF62E,0xF6B0,0xF70B,0xF73F,0xF7C5,0xF85E,
	0xF8C9,0xF935,0xF992,0xFA1E,0xFA9E,0xFAF1,0xFB44,0xFBEE,
	0xFBF4,0xFC43,0xFCD6,0xFD67,0xFDCC,0xFE87,0xFEAD,0xFE9F,
	0xFEAD,0xFF5B,0x0009,0xFFDE,0xFFDB,0x00BD,0x0109,0x0108,
	0x0163,0x02B2,0x0174,0x0232,0x0401,0x031E,0x03D5,0x04AE,
	0x04EB,0x0535,0x0577,0x0588,0x0600,0x0650,0x064D,0x06C6,
	0x06CC,0x0752,0x076F,0x07EB,0x0862,0x089F,0x08BE,0x08FE,
	0x0907,0x093D,0x0986,0x09D7,0x09F2,0x0A1F,0x09F2,0x0A59,
	0x0A88,0x0AF2,0x0B5E,0x0B79,0x0BC2,0x0BF3,0x0C16,0x0C84,
	0x0C80,0x0CC7,0x0C53,0x0BFB,0x0C74,0x0CBF,0x0D22,0x0D32,
	0x0CFC,0x0D45,0x0D43,0x0CF8,0x0D33,0x0D5C,0x0D7C,0x0D6F,
	0x0D16,0x0D8F,0x0DC0,0x0DD3,0x0DD0,0x0E49,0x0EB6,0x0FBB,
	0x11C5,0x1111,0x10CA,0x1073,0x109A,0x10D4,0x1094,0x106D,
	0x1076,0x1084,0x1053,0x0FF9,0x1070,0x10DA,0x108F,0x1039,
	0x101A,0x0FFB,0x0FF6,0x0F3A,0x0FC9,0x1087,0x0FE8,0x0F31,
	0x0F80,0x0F72,0x0F3C,0x0F6A,0x0F14,0x0F1E,0x0F6E,0x0F62,
	0x0F61,0x0F57,0x0EA9,0x0EA7,0x0EB0,0x0F15,0x0F7B,0x0F68,
	0x0F26,0x0E92,0x0E43,0x0EB2,0x0ECC,0x0DB4,0x0DBC,0x0ED1,
	0x0E97,0x0E83,0x0E3D,0x0E3B,0x0E6D,0x0E41,0x0E02,0x0DC4,
	0x0D53,0x0D27,0x0D28,0x0CDD,0x0C7F,0x0CB5,0x0C47,0x0C53,
	0x0C63,0x0BEB,0x0BE2,0x0BDE,0x0C1D,0x0BD6,0x0B54,0x0B42,
	0x0B47,0x0B39,0x0AD7,0x0ABA,0x0AB1,0x0A4C,0x09C4,0x09CC,
	0x0A6B,0x0A7F,0x0A0D,0x09FB,0x09F9,0x09DF,0x09C3,0x099A,
	0x093B,0x0922,0x092C,0x0917,0x0923,0x0987,0x0985,0x091C,
	0x0910,0x0922,0x095E,0x0934,0x0970,0x0936,0x08CC,0x08F5,
	0x0902,0x08AF,0x0894,0x0888,0x081B,0x0890,0x087D,0x0870,
	0x083D,0x0801,0x0863,0x0907,0x08BD,0x084F,0x081F,0x086D,
	0x0771,0x0895,0x091A,0x0756,0x0832,0x080E,0x07CD,0x0793,
	0x0806,0x07B8,0x076F,0x0780,0x07B9,0x0785,0x07A6,0x0727,
	0x071B,0x0767,0x0793,0x07E7,0x07CF,0x07A8,0x074D,0x071F,
	0x06C3,0x06D5,0x06EF,0x06F0,0x0707,0x0701,0x0732,0x0722,
	0x06D3,0x0710,0x06EB,0x06B2,0x06CC,0x06C7,0x06AE,0x06C4,
	0x06D2,0x0700,0x06B7,0x068A,0x064D,0x065E,0x0634,0x0610,
	0x0650,0x0615,0x05EA,0x0625,0x061B,0x064C,0x0628,0x05F9,
	0x061B,0x060D,0x059C,0x05AB,0x056B,0x0546,0x05A2,0x055E,
	0x04BB,0x039B,0x0258,0x02C3,0x02FA,0x02D6,0x02EF,0x0306,
	0x0311,0x0375,0x0370,0x03AB,0x03F3,0x03A9,0x03C6,0x03A6,
	0x0362,0x0351,0x0351,0x0362,0x0300,0x0310,0x0386,0x0383,
	0x0336,0x02EA,0x0339,0x032B,0x0328,0x036B,0x038B,0x03AA,
	0x039A,0x0370,0x039A,0x0368,0x0365,0x03BA,0x03EC,0x03E8,
	0x0375,0x034F,0x0334,0x036A,0x0343,0x04B7,0x0440,0x0363,
	0x0319,0x0234,0x0251,0x02A3,0x02C8,0x0270,0x029D,0x02F4,
	0x0366,0x037E,0x037C,0x041E,0x043A,0x0423,0x03E5,0x0377,
	0x035F,0x0362,0x0360,0x034D,0x0365,0x038D,0x035F,0x0347,
	0x02F2,0x02C6,0x026E,0x0259,0x023A,0x0235,0x0247,0x02A9,
	0x0284,0x021B,0x018C,0x0184,0x01DE,0x0218,0x01C2,0x01EB,
	0x01FC,0x0156,0x013C,0x0161,0x016A,0x014D,0x0143,0x0123,
	0x00DB,0x0122,0x0112,0x012C,0x0105,0x0149,0x0179,0x0170,
	0x0101,0x00FE,0x009F,0x007B,0x0094,0xFFC1,0x0014,0x0063,
	0x0093,0x002F,0x0037,0x0081,0x0148,0x01FE,0x0212,0x0225,
	0x0262,0x02C8,0x03B5,0x048F,0x04AE,0x043D,0x0428,0x0531,
	0x06F0,0x0759,0x075E,0x0836,0x099F,0x0BA2,0x0D15,0x0E04,
	0x0EC8,0x0F09,0x0F72,0x0FAA,0x0FF7,0x0FE1,0x0F65,0x0F2A,
	0x0F54,0x1092,0x1102,0x10A0,0x0F56,0x0E8F,0x0EF3,0x1044,
	0x108B,0x0F8F,0x0F4A,0x0FB7,0x1077,0x11B1,0x12D1,0x1308,
	0x1289,0x12B6,0x1411,0x151C,0x156F,0x1577,0x152A,0x1540,
	0x15E1,0x171F,0x1866,0x18A6,0x1866,0x187A,0x1934,0x1996,
	0x18A1,0x17D4,0x1721,0x184D,0x1B26,0x1D89,0x1AF4,0x17DC,
	0x18B1,0x18F5,0x1A9E,0x1B2A,0x19F7,0x185D,0x1793,0x1787,
	0x185E,0x19A1,0x1AAB,0x1A4A,0x1889,0x17C1,0x17CE,0x1759,
	0x14D2,0x108F,0x0D0F,0x09DD,0x0556,0xFE72,0xF839,0xF4E5,
	0xF728,0xFDC0,0x0452,0x064D,0x02D1,0xFBB2,0xF528,0xF26F,
	0xF3F9,0xF718,0xF8D1,0xF992,0xFB83,0xFF5B,0x03DE,0x06AD,
	0x0713,0x07DB,0x086C,0x0879,0x0828,0x0855,0x09DE,0x0DF9,
	0x150D,0x1CB5,0x21AB,0x2200,0x1E71,0x1B1C,0x1B1F,0x1EE1,
	0x22ED,0x2442,0x2341,0x22F8,0x270C,0x2AEA,0x2DA9,0x2E32,
	0x2BC8,0x27C7,0x244C,0x2166,0x1EC0,0x1DA5,0x1E05,0x1F15,
	0x203F,0x1F68,0x1C20,0x1709,0x11FB,0x0DFD,0x0B83,0x08EC,
	0x064A,0x038E,0xFF81,0xFC70,0xFCCD,0xFD51,0xFB4F,0xF74A,
	0xF233,0xEE43,0xEA55,0xE6B3,0xE483,0xE4B0,0xE5AD,0xE5ED,
	0xE428,0xE2AA,0xE119,0xDF56,0xDDD7,0xDD1E,0xDCFD,0xDD59,
	0xDC9A,0xDAD2,0xDB8E,0xE028,0xE321,0xE3BC,0xE2F2,0xE2B7,
	0xE357,0xE3EC,0xE42A,0xE54A,0xE70B,0xE970,0xEB6F,0xEC78,
	0xED62,0xEEC5,0xEFF0,0xF127,0xF2C6,0xF43C,0xF4C7,0xF4BB,
	0xF51E,0xF6E0,0xF934,0xFB56,0xFBC8,0xFB61,0xFA74,0xF959,
	0xF8D0,0xF899,0xF8E4,0xF944,0xF924,0xF7DF,0xF65D,0xF529,
	0xF553,0xF5D1,0xF54E,0xF375,0xF0F3,0xEE58,0xEC4E,0xEBFE,
	0xECCF,0xED3D,0xEC1E,0xEA1D,0xE8A6,0xE7AE,0xE633,0xE47E,
	0xE26D,0xE1A6,0xE1D4,0xE169,0xE0CB,0xE052,0xDFB0,0xDEEF,
	0xDE56,0xDEA6,0xDFA3,0xDEC7,0xDCF0,0xDC85,0xDDDF,0xE048,
	0xE1A9,0xE12E,0xE1A9,0xE34F,0xE3A9,0xE3EC,0xE48F,0xE296,
	0xE4B3,0xE6C3,0xE8BD,0xEAB3,0xEB63,0xEB3B,0xEBC3,0xED68,
	0xEFF5,0xF206,0xF128,0xF001,0xEFBE,0xF1A0,0xF42A,0xF615,
	0xF73A,0xF770,0xF70B,0xF6A7,0xF761,0xF825,0xF885,0xF833,
	0xF823,0xF892,0xF8C2,0xF7DB,0xF6E9,0xF76D,0xF920,0xFA5A,
	0xF947,0xF6E9,0xF3F9,0xF385,0xF4B0,0xF662,0xF6EA,0xF618,
	0xF3F3,0xF284,0xF223,0xF2BA,0xF31F,0xF217,0xF101,0xF093,
	0xF0C1,0xF06F,0xEF99,0xEEEE,0xEF22,0xEF2B,0xEF46,0xEFA4,
	0xEF5C,0xEE35,0xECFA,0xEC91,0xEDC2,0xEE4D,0xED18,0xECDE,
	0xED0B,0xEDA1,0xEDE6,0xEE8E,0xEEF0,0xEF90,0xF09C,0xF136,
	0xF238,0xF2A0,0xF2AE,0xF281,0xF243,0xF338,0xF3A2,0xF35D,
	0xF12F,0xEE67,0xEDAE,0xEF42,0xF237,0xF510,0xF693,0xF6D3,
	0xF5DF,0xF4C5,0xF313,0xF28A,0xF3E4,0xF625,0xF7FD,0xF829,
	0xF7DA,0xF83C,0xFA7F,0xFC79,0xFD7D,0xFD10,0xFBF2,0xFAF6,
	0xFB77,0xFE09,0xFFDC,0xFFF0,0x005C,0x0159,0x0324,0x0412,
	0x0385,0x0231,0x0115,0x0113,0x0303,0x0504,0x0611,0x065F,
	0x05F6,0x060F,0x06D6,0x06ED,0x05E9,0x04B4,0x0300,0x0252,
	0x025F,0x0334,0x0465,0x049F,0x0406,0x039D,0x035B,0x029F,
	0x00F8,0xFE91,0xFD7B,0xFE66,0xFF77,0xFF41,0xFD7A,0xFBF3,
	0xFC57,0xFD7F,0xFE77,0xFD4C,0xFACC,0xF7E8,0xF6EF,0xF847,
	0xF9F0,0xFA9A,0xFAFB,0xFB34,0xFADB,0xF99E,0xF986,0xF9DA,
	0xF973,0xF905,0xF8E3,0xF9D5,0xFA9F,0xFA12,0xF97F,0xFA62,
	0xFD08,0xFED7,0xFE89,0xFCE2,0xFBFE,0xFC2B,0xFCDB,0xFCC5,
	0xFCE3,0xFD09,0xFC25,0xFBDE,0xFB8B,0xFAD0,0xF80F,0xF8EE,
	0xF898,0xF70E,0xF729,0xF782,0xF7ED,0xF797,0xF72B,0xF786,
	0xF7E0,0xF778,0xF70D,0xF6D7,0xF676,0xF5DA,0xF53D,0xF4D2,
	0xF4EC,0xF4C1,0xF416,0xF39B,0xF2EF,0xF235,0xF1F4,0xF179,
	0xF0DC,0xF017,0xEF0E,0xEE7B,0xEE2E,0xED69,0xED1B,0xEC3E,
	0xEB91,0xEB32,0xEAAE,0xEA05,0xE9EE,0xE999,0xE8B1,0xE84E,
	0xE7DE,0xE763,0xE708,0xE6C4,0xE6BF,0xE617,0xE595,0xE597,
	0xE54E,0xE53E,0xE56E,0xE562,0xE570,0xE542,0xE54A,0xE4E7,
	0xE508,0xE576,0xE5D0,0xE72A,0xE8F7,0xE85F,0xE8B3,0xE88C,
	0xE896,0xE885,0xE876,0xE8CE,0xE8F9,0xE96F,0xE9D9,0xEA02,
	0xEA17,0xEA1B,0xEA9B,0xEAE8,0xEB32,0xEBD0,0xEC0D,0xEC10,
	0xED36,0xED95,0xED5B,0xED89,0xEE41,0xEE47,0xEEA9,0xEF51,
	0xEF9A,0xEFF0,0xF04C,0xF0A8,0xF168,0xF1D1,0xF20E,0xF264,
	0xF28F,0xF34B,0xF3B2,0xF444,0xF4D6,0xF50C,0xF545,0xF594,
	0xF5A7,0xF514,0xF65F,0xF7A8,0xF7FC,0xF8B7,0xF8CC,0xF922,
	0xF99A,0xF9C3,0xFA07,0xF9FA,0xFA48,0xFB09,0xFB60,0xFBC2,
	0xFBF3,0xFCD1,0xFD0E,0xFD31,0xFD69,0xFDC1,0xFE12,0xFE97,
	0xFF76,0xFFC8,0x000F,0x006F,0x009E,0x0135,0x01DB,0x0248,
	0x0244,0x025C,0x02BA,0x0306,0x0338,0x03DD,0x045D,0x045D,
	0x04A1,0x0576,0x0601,0x05EE,0x061F,0x065F,0x0698,0x0732,
	0x078D,0x07BB,0x07E8,0x0820,0x085A,0x088C,0x08FF,0x0928,
	0x0943,0x0985,0x0999,0x09D3,0x0A42,0x0A59,0x0A72,0x0B0F,
	0x0B01,0x0BCE,0x0BB4,0x0B98,0x0B66,0x0B57,0x0BB0,0x0CBE,
	0x0C82,0x0C68,0x0CD3,0x0D3B,0x0C74,0x0E9C,0x0E30,0x0D37,
	0x0E3C,0x0DC2,0x0E6F,0x0E7B,0x0E97,0x0EA1,0x0EA3,0x0E72,
	0x0F01,0x0F2F,0x0F68,0x0F2E,0x0F23,0x0F74,0x0FA5,0x0FDB,
	0x0FF3,0x1047,0x0FFF,0x1017,0x1002,0x0FF8,0x101D,0x0FFC,
	0x0FE8,0x1033,0x1076,0x1076,0x106F,0x103F,0x1081,0x103B,
	0x1092,0x10E2,0x10E1,0x10C5,0x10CD,0x10FD,0x1115,0x10F9,
	0x1091,0x1107,0x1140,0x1167,0x1133,0x111C,0x10AA,0x108D,
	0x10AC,0x1115,0x10ED,0x10E7,0x110E,0x10F9,0x10B4,0x1090,
	0x10B3,0x1080,0x1060,0x105C,0x0F81,0x0DA1,0x0CD0,0x0D64,
	0x0DDF,0x0DF9,0x0DF2,0x0DEA,0x0E09,0x0DB4,0x0DB3,0x0DD7,
	0x0D8A,0x0D68,0x0D53,0x0D79,0x0DB0,0x0DDA,0x0DE7,0x0DCC,
	0x0CA8,0x0C3E,0x0D1B,0x0D7C,0x0CC3,0x0CDB,0x0D0C,0x0CC4,
	0x0CFB,0x0D43,0x0CF2,0x0D1B,0x0CC4,0x0C8E,0x0C79,0x0C3D,
	0x0C54,0x0C9C,0x0CFB,0x0D64,0x0D85,0x0CD1,0x0C49,0x0BB6,
	0x0CCA,0x0D5D,0x0BCF,0x0BD3,0x0B9E,0x0B3B,0x0B86,0x0BD8,
	0x0B73,0x0BA6,0x0B7A,0x0B98,0x0BFE,0x0BDB,0x0B95,0x0C7F,
	0x0CA3,0x0C66,0x0C81,0x0C45,0x0C34,0x0C12,0x0BCC,0x0BA0,
	0x0B9E,0x0B46,0x0B2B,0x0AFE,0x0B27,0x0B22,0x0AE4,0x0A6C,
	0x0A4E,0x09F0,0x099E,0x097F,0x098D,0x0954,0x08C0,0x0856,
	0x0860,0x0841,0x088B,0x08AA,0x086A,0x082C,0x0801,0x07FE,
	0x07C3,0x07DA,0x07CF,0x07AB,0x073D,0x06CB,0x0714,0x0744,
	0x06BF,0x0682,0x0655,0x0606,0x05F9,0x0642,0x062D,0x0607,
	0x05DF,0x05CB,0x0595,0x0517,0x054F,0x0572,0x04D5,0x0459,
	0x049A,0x046B,0x0489,0x0443,0x0513,0x041D,0x03EE,0x05C5,
	0x0498,0x0442,0x04B3,0x04C3,0x047D,0x0490,0x0442,0x0448,
	0x03E4,0x03F4,0x0418,0x0411,0x03B4,0x03C4,0x03D2,0x03A4,
	0x03E6,0x03F1,0x041E,0x03D1,0x0359,0x0363,0x03BE,0x0344,
	0x0390,0x0325,0x0323,0x0330,0x0306,0x02B7,0x02CF,0x02EB,
	0x02B2,0x02B7,0x02A4,0x024B,0x0241,0x01E0,0x01F6,0x022C,
	0x022B,0x01DE,0x01DC,0x01DE,0x01B7,0x01E7,0x022A,0x0210,
	0x01D5,0x0144,0x0152,0x0165,0x018F,0x018B,0x01B2,0x01BF,
	0x0192,0x01D9,0x026B,0x047E,0x0484,0x03C4,0x0390,0x0327,
	0x036E,0x03B7,0x0338,0x035D,0x032E,0x02F0,0x02D9,0x029B,
	0x02AB,0x0325,0x028D,0x024D,0x0207,0x01D3,0x0152,0x0112,
	0x01E9,0x01AA,0x0110,0x0109,0x0147,0x00C7,0x00E6,0x00C0,
	0xFF40,0xFFBA,0xFF3F,0xFF71,0xFF3A,0xFF03,0xFF01,0xFF05,
	0xFE90,0xFE96,0xFE5F,0xFE83,0xFE92,0xFE5E,0xFE46,0xFE40,
	0xFDF6,0xFDBF,0xFD80,0xFDDF,0xFE56,0xFD0C,0xFC00,0xFD5A,
	0xFDFA,0xFDD9,0xFDEE,0xFDD4,0xFDBD,0xFD21,0xFD20,0xFD32,
	0xFCB2,0xFC38,0xFBC8,0xFBD6,0xFB6D,0xFB66,0xFB47,0xFB83,
	0xFB71,0xFB18,0xFB41,0xFB1B,0xFAEC,0xFADC,0xFAFB,0xFAFE,
	0xFB16,0xFAE4,0xFB0E,0xFB3D,0xFB3B,0xFBF5,0xFC49,0xFCA5,
	0xFD23,0xFD33,0xFDAE,0xFE2A,0xFE56,0xFEC2,0xFF5F,0x0038,
	0x01F5,0x03B2,0x04B1,0x0534,0x0571,0x05A6,0x0577,0x059A,
	0x05F5,0x0585,0x0599,0x05F9,0x05E2,0x060B,0x05B7,0x0581,
	0x0506,0x055A,0x0614,0x05FD,0x0633,0x0688,0x07B1,0x0908,
	0x09F1,0x0A1A,0x0B2E,0x0C2F,0x0CAF,0x0BF8,0x0C8E,0x0D91,
	0x0E51,0x0E32,0x10F6,0x105C,0x1022,0x1105,0x10FF,0x1196,
	0x1296,0x1304,0x12B3,0x13C1,0x141D,0x1461,0x13E6,0x1431,
	0x148A,0x14BC,0x14EC,0x1571,0x1606,0x1645,0x16CB,0x16C0,
	0x16B0,0x164C,0x15C9,0x15C2,0x1627,0x16CF,0x1701,0x16CB,
	0x167C,0x165D,0x1612,0x157A,0x15A1,0x15DA,0x1545,0x14C5,
	0x12FE,0x1086,0x0D1B,0x084D,0x02DF,0xFD93,0xF825,0xF638,
	0xF92B,0x003F,0x0997,0x1007,0x1187,0x0CEE,0x03B8,0xF9BF,
	0xF303,0xF2DD,0xFA1D,0x0685,0x13B5,0x1DB3,0x21E5,0x1F8F,
	0x1830,0x0E6F,0x057E,0x038D,0x084F,0x1163,0x1C2D,0x25DA,
	0x2B91,0x2A6F,0x23FD,0x1B36,0x12B6,0x0DEF,0x0D93,0x1138,
	0x172E,0x1C4B,0x1EA4,0x1D90,0x1956,0x11E9,0x0B58,0x063B,
	0x02B3,0x013A,0x0167,0x01C9,0x01DD,0x01C3,0x00B6,0xFE50,
	0xFAEF,0xF6F8,0xF409,0xF1F4,0xEFBD,0xEECE,0xEF06,0xEFFD,
	0xF15D,0xF271,0xF31D,0xF3B6,0xF31B,0xF2C9,0xF291,0xF0ED,
	0xF0F6,0xF19D,0xF311,0xF605,0xF9F3,0xFD4A,0xFFE2,0x00A4,
	0xFF99,0xFDE8,0xFC70,0xFC48,0xFDD2,0x0002,0x02E5,0x05BD,
	0x0716,0x0726,0x062D,0x039A,0x009F,0xFDA8,0xFC24,0xFBC3,
	0xFC48,0xFD48,0xFE79,0xFEEA,0xFD90,0xFA7B,0xF6E4,0xF3A0,
	0xF12A,0xEEE2,0xEE0B,0xEE88,0xEF2F,0xEEE5,0xEDC4,0xECEF,
	0xECA5,0xEB23,0xE94B,0xE818,0xE733,0xE6EC,0xE713,0xE7D9,
	0xE9E1,0xEB95,0xEC57,0xEC07,0xEC35,0xEC64,0xEBBF,0xEB45,
	0xEBEF,0xED19,0xEE5F,0xF05B,0xF2B2,0xF448,0xF572,0xF538,
	0xF46E,0xF351,0xF2AA,0xF1CB,0xF19E,0xF2F1,0xF510,0xF775,
	0xF953,0xFA83,0xF71E,0xF5F3,0xF48B,0xF0C2,0xEFE5,0xF024,
	0xF1CA,0xF3AE,0xF464,0xF3FA,0xF205,0xEF8C,0xED53,0xEB8C,
	0xEABA,0xEA97,0xEB2C,0xEB86,0xEC07,0xEC46,0xEB9C,0xEAC0,
	0xE979,0xE8AD,0xE845,0xE8A0,0xE906,0xE9DA,0xEB38,0xEC16,
	0xECA4,0xED1A,0xED97,0xEEEC,0xEF67,0xEF9A,0xEFF1,0xF04F,
	0xF0AA,0xF12E,0xF22D,0xF3DF,0xF555,0xF5B0,0xF564,0xF57C,
	0xF5C9,0xF581,0xF4C1,0xF541,0xF60D,0xF6A0,0xF71E,0xF74B,
	0xF780,0xF758,0xF639,0xF4A3,0xF3B0,0xF445,0xF4AC,0xF58A,
	0xF85C,0xF89A,0xF824,0xF6E9,0xF573,0xF46D,0xF380,0xF2A4,
	0xF21E,0xF2D2,0xF440,0xF529,0xF4F0,0xF4DD,0xF48D,0xF2F2,
	0xF215,0xF20A,0xF2BE,0xF327,0xF417,0xF561,0xF599,0xF5CF,
	0xF6B0,0xF671,0xF553,0xF5CC,0xF696,0xF6D1,0xF70F,0xF7CF,
	0xF912,0xFA1D,0xF961,0xF833,0xF56D,0xEFF4,0xE64C,0xD8DC,
	0xC8ED,0xBF3C,0xBF4B,0xBF8D,0xC007,0xD08A,0xE9B1,0xFADB,
	0xFD36,0xEF2D,0xD434,0xC089,0xC01D,0xBF44,0xC7E4,0xECCF,
	0x1126,0x2AF8,0x3422,0x2AAF,0x141F,0xFB4B,0xEA40,0xE77F,
	0xF591,0x11D2,0x33DF,0x3E46,0x3D26,0x3D33,0x3DD2,0x2BBC,
	0x11FF,0x068C,0x09E5,0x19C3,0x2F5F,0x3D2F,0x3D85,0x3DCF,
	0x3332,0x1D6D,0x0A04,0xFC36,0xF53D,0xF4DC,0xF931,0xFF63,
	0x037C,0x02EE,0xFD51,0xF468,0xEA36,0xE067,0xD95A,0xD5F1,
	0xD510,0xD5D9,0xD6DB,0xD888,0xDC0A,0xE08E,0xE54B,0xE87E,
	0xE8DB,0xE5F6,0xE0FB,0xDD04,0xDC68,0xE0E0,0xEAB4,0xF766,
	0x041A,0x0D81,0x1193,0x10CA,0x0BCD,0x0500,0x0014,0xFF74,
	0x03D7,0x0F7A,0x1C46,0x253F,0x2BE5,0x2A14,0x21FF,0x16B9,
	0x0C48,0x05E9,0x05AE,0x09FA,0x117C,0x170B,0x18DA,0x16D8,
	0x10A2,0x07B5,0xFD3B,0xF4CC,0xEF72,0xEDB4,0xEF20,0xF1FE,
	0xF4BE,0xF60D,0xF435,0xEF0E,0xE989,0xE465,0xE038,0xDE2B,
	0xDE4C,0xE064,0xE3EA,0xE79C,0xEB92,0xEE2B,0xEF18,0xEEE9,
	0xEDC6,0xECCE,0xECF5,0xEEA5,0xF20A,0xF6A7,0xFBB4,0x008C,
	0x04DE,0x0828,0x0934,0x08E1,0x07EE,0x06E5,0x0660,0x07AA,
	0x0A4B,0x0E15,0x126B,0x15B8,0x1645,0x13E2,0x101B,0x0BA5,
	0x0844,0x04AA,0x0359,0x04C4,0x0627,0x0706,0x064A,0x04B2,
	0x01F3,0xFDC0,0xF89A,0xF485,0xF1CC,0xF113,0xF1E1,0xF351,
	0xF4DF,0xF5A6,0xF4E6,0xF38D,0xF03D,0xEDA4,0xECCE,0xEC7E,
	0xED12,0xEF15,0xF220,0xF561,0xF814,0xF996,0xFA64,0xFA1A,
	0xF941,0xF85B,0xF92F,0xFBA7,0xFEE6,0x02C7,0x0608,0x083D,
	0x09A1,0x096F,0x08EE,0x08C0,0x0915,0x0A85,0x09FA,0x0963,
	0x0A8C,0x0C45,0x0D4D,0x0DED,0x0DB4,0x0C29,0x097F,0x0650,
	0x04D9,0x0422,0x0471,0x05B2,0x06BF,0x0641,0x04FA,0x0313,
	0x003B,0xFD66,0xFB01,0xF948,0xF817,0xF844,0xF904,0xFA10,
	0xFAAF,0xFA66,0xF904,0xF6BC,0xF4B7,0xF43E,0xF510,0xF6FF,
	0xF8B8,0xFA79,0xFBC5,0xFC96,0xFCAF,0xFC6B,0xFCDB,0xFE09,
	0xFF5E,0x0002,0x00AF,0x017D,0x02D4,0x030A,0x021D,0xFE68,
	0xF6CA,0xEA79,0xD834,0xC53F,0xBFD8,0xC096,0xC07E,0xC25D,
	0xDCB8,0xFC00,0x0D49,0x09DB,0xF117,0xCCF7,0xBFBA,0xC1FB,
	0xC00C,0xCF9E,0x016D,0x2D78,0x3DF7,0x3E5C,0x379B,0x1856,
	0xFA3F,0xE8D8,0xEB0C,0x0502,0x2C92,0x3F87,0x3EBC,0x3F9B,
	0x3E92,0x4001,0x32F0,0x1750,0x0E78,0x1830,0x2FC2,0x3EF9,
	0x3F09,0x3EF1,0x3F13,0x3CD6,0x2718,0x0EEC,0x0008,0xFA00,
	0xFC59,0x030F,0x0A64,0x0EDD,0x0C98,0x03FE,0xF7E1,0xEADB,
	0xDF5C,0xD6CD,0xD25B,0xD0A0,0xD1D7,0xD4EF,0xD94F,0xDEDE,
	0xE4F0,0xE971,0xEA3F,0xE719,0xE1AA,0xDBE9,0xD85C,0xDA02,
	0xE22B,0xEFF8,0x0080,0x0F35,0x1793,0x193D,0x14F1,0x0D07,
	0x04A3,0x0067,0x02F5,0x0C5F,0x1A3B,0x293D,0x34BB,0x3A8A,
	0x3743,0x2AB1,0x1BF8,0x0F70,0x099F,0x0B19,0x1299,0x1C44,
	0x2428,0x26DB,0x21D8,0x16AD,0x082F,0xFB72,0xF254,0xED5A,
	0xEDFB,0xF254,0xF716,0xF9AE,0xFA50,0xF5A8,0xEDD6,0xE4E1,
	0xDDCA,0xD9C8,0xD9C7,0xDCF7,0xE1A5,0xE643,0xEA00,0xEBDC,
	0xEC0E,0xEB8D,0xEB43,0xEAFC,0xEB86,0xED45,0xF029,0xF499,
	0xF93E,0xFDC5,0x0332,0x0801,0x0A89,0x0B4E,0x0C5D,0x0BB7,
	0x0A78,0x09E2,0x0B08,0x0E11,0x124A,0x16D2,0x1A05,0x1AAC,
	0x181D,0x13A7,0x0DA6,0x0711,0x032F,0x02D8,0x0481,0x07CF,
	0x0ABD,0x0B55,0x08F6,0x038D,0xFC2E,0xF4E8,0xEFB1,0xED30,
	0xEDAE,0xEFD1,0xF345,0xF5FF,0xF6AD,0xF4F2,0xF057,0xEAB6,
	0xE649,0xE4B4,0xE569,0xE898,0xEE14,0xF2B9,0xF57C,0xF60F,
	0xF53D,0xF418,0xF2FE,0xF375,0xF566,0xF7BE,0xFB43,0xFF36,
	0x028E,0x0515,0x05F6,0x05EF,0x05F9,0x065C,0x070C,0x0874,
	0x09B8,0x0B2C,0x0B82,0x0B1E,0x0A95,0x0AE2,0x0AEF,0x0B2A,
	0x0B08,0x09F2,0x0824,0x05CA,0x02E5,0x01A8,0x015C,0x007D,
	0xFF86,0x011F,0xFE0E,0xFC68,0xFB29,0xF927,0xF72E,0xF58F,
	0xF449,0xF44D,0xF54B,0xF600,0xF728,0xF739,0xF638,0xF50F,
	0xF44E,0xF3E2,0xF49F,0xF5F1,0xF759,0xF950,0xFA70,0xFB6B,
	0xFC3E,0xFD5A,0xFECE,0xFFF0,0x00C0,0x019A,0x01F0,0x0293,
	0x0313,0x0374,0x02C4,0xFECF,0xF64A,0xE871,0xD5ED,0xC397,
	0xBF55,0xC043,0xBFAA,0xC722,0xE5C1,0x017F,0x0E32,0x067F,
	0xEA04,0xC73A,0xBF4E,0xC1B4,0xBFD2,0xD8D7,0x0C45,0x32BF,
	0x3DD1,0x3E49,0x3089,0x0FEA,0xF532,0xE8BD,0xF0D2,0x0C6E,
	0x32B3,0x3E92,0x3D39,0x3E38,0x3DB4,0x3EBB,0x2A7A,0x11BE,
	0x0E7C,0x1BF7,0x3484,0x3EF9,0x3E55,0x3E61,0x3EFE,0x371E,
	0x1F61,0x0BA3,0x001F,0xFBDA,0xFD27,0x0361,0x0A2B,0x0D59,
	0x0A45,0x01F5,0xF698,0xEA12,0xDF41,0xD842,0xD489,0xD3A6,
	0xD49B,0xD703,0xDA44,0xDF54,0xE562,0xEB13,0xED54,0xEACF,
	0xE45F,0xDD4C,0xD91F,0xDA5D,0xE4E6,0xF435,0x03CC,0x113C,
	0x18F4,0x1A0A,0x14E6,0x0C6D,0x04C3,0x017A,0x04BA,0x0F2F,
	0x1EBD,0x2E25,0x392F,0x3D2C,0x36D9,0x2A0C,0x1B0B,0x0EE8,
	0x09FE,0x0D37,0x164A,0x201B,0x264E,0x269A,0x2053,0x1553,
	0x07E9,0xFB55,0xF24F,0xEE97,0xEF12,0xF30A,0xF826,0xFB97,
	0xFA5E,0xF506,0xED6F,0xE4DF,0xDE10,0xDAE7,0xDB7E,0xDE6F,
	0xE22A,0xE5B4,0xE89A,0xEB3A,0xED21,0xEE3D,0xEDCD,0xED40,
	0xEC6A,0xEC2E,0xEDD6,0xF1E4,0xF87F,0xFF56,0x0577,0x09E8,
	0x0CC4,0x0DCC,0x0CA5,0x0AD7,0x08FE,0x0827,0x0917,0x0C52,
	0x1208,0x17DA,0x1B9A,0x1BFB,0x1909,0x1371,0x0C93,0x0791,
	0x05DA,0x04A6,0x07B5,0x0B80,0x0C6E,0x0C4B,0x090D,0x03AC,
	0xFD70,0xF76C,0xF310,0xF09E,0xF0A7,0xF1E5,0xF3BE,0xF4DE,
	0xF4D4,0xF36D,0xF0C5,0xED86,0xEB20,0xE987,0xE8DA,0xEA06,
	0xECDE,0xF042,0xF37E,0xF5B4,0xF6C5,0xF710,0xF6F7,0xF6D2,
	0xF75D,0xF872,0xFA8B,0xFD0C,0x0001,0x03A5,0x067D,0x0862,
	0x09F7,0x0A0E,0x0997,0x08FB,0x088E,0x0906,0x0994,0x0A7D,
	0x0C37,0x0D9E,0x0D8A,0x0C1E,0x0ACC,0x0942,0x0753,0x0539,
	0x034A,0x0221,0x013F,0x011C,0x00D5,0x0087,0x00DC,0x0185,
	0xFE6D,0xFB70,0xF8F6,0xF734,0xF5E4,0xF608,0xF6ED,0xF7B8,
	0xF7E4,0xF78E,0xF732,0xF6BE,0xF5A8,0xF532,0xF531,0xF574,
	0xF6AE,0xF891,0xFAAB,0xFD4F,0xFE67,0xFD28,0xFC2C,0xFCC9,
	0xFDCC,0xFF75,0x01DA,0x0401,0x053F,0x048E,0x018C,0xFBA4,
	0xF118,0xE210,0xCE73,0xC010,0xBF52,0xBFE6,0xBEE0,0xCE48,
	0xEED0,0x05E5,0x0C79,0xFCFB,0xDA4D,0xC07A,0xBFFB,0xC0AA,
	0xC133,0xE502,0x16DE,0x37B1,0x3D0F,0x3D47,0x2760,0x058B,
	0xEC87,0xE454,0xF189,0x11D8,0x36F4,0x3E2F,0x3D56,0x3DA4,
	0x3D86,0x3B32,0x1FFB,0x0CC7,0x0DB1,0x1F65,0x3889,0x3E49,
	0x3D7C,0x3D98,0x3E23,0x30FB,0x17C2,0x0506,0xFA18,0xF811,
	0xFCE5,0x0533,0x0B9C,0x0CA3,0x079A,0xFD4F,0xEFF8,0xE31B,
	0xD9A8,0xD4F6,0xD2D8,0xD2B6,0xD3CA,0xD66D,0xDADF,0xE057,
	0xE5EC,0xE9EB,0xEA83,0xE6C4,0xE09B,0xDB5D,0xD8F0,0xDCA8,
	0xE723,0xF5BF,0x05EF,0x122D,0x18CF,0x185B,0x1237,0x0987,
	0x01E5,0xFFDB,0x05AE,0x11CA,0x219D,0x3008,0x38C0,0x37CD,
	0x30A3,0x2368,0x136F,0x0B50,0x08BF,0x0D67,0x1677,0x200E,
	0x25D3,0x253A,0x1D23,0x0F98,0x00F1,0xF52C,0xEE4F,0xED59,
	0xF07E,0xF5EE,0xFAED,0xFB40,0xF73F,0xEFBA,0xE818,0xE111,
	0xDC10,0xDA7E,0xDC6B,0xE09A,0xE49D,0xE7B0,0xEA00,0xEBAF,
	0xEBFB,0xEBE3,0xEC05,0xECBA,0xED9E,0xEEE1,0xF12E,0xF4FE,
	0xFA2F,0xFFE3,0x05B9,0x09E6,0x0C50,0x0C7A,0x0B7D,0x09AC,
	0x087C,0x0901,0x0B79,0x0FE1,0x145C,0x18D7,0x1B11,0x1A5E,
	0x16E9,0x11BC,0x0B8C,0x073C,0x0506,0x056F,0x07C2,0x0A9F,
	0x0BA5,0x0946,0x0598,0xFF08,0xF801,0xF1F7,0xEEC6,0xEE85,
	0xF030,0xF259,0xF3A0,0xF3FA,0xF2D9,0xEF9E,0xEC83,0xE974,
	0xE6EB,0xE669,0xE78E,0xE995,0xED60,0xF1FE,0xF49D,0xF538,
	0xF51C,0xF502,0xF528,0xF5D5,0xF77C,0xF982,0xFC1C,0xFF0C,
	0x02A4,0x0611,0x07DE,0x08B8,0x0919,0x0933,0x08FA,0x084A,
	0x0846,0x0A26,0x0BA7,0x0CF0,0x0F1A,0x0F10,0x0E10,0x0CD4,
	0x0AB3,0x0859,0x066D,0x0461,0x0293,0x0232,0x0366,0x04D8,
	0x04F4,0x03FB,0x0200,0xFEE0,0xFB97,0xF8C5,0xF7C8,0xF7FA,
	0xF8EE,0xF950,0xF898,0xF7AE,0xF750,0xF676,0xF5A2,0xF57C,
	0xF59D,0xF5C9,0xF678,0xF7D5,0xF9B5,0xFB43,0xFC38,0xFC6C,
	0xFC7E,0xFD43,0xFE87,0x0015,0x01CF,0x035F,0x03EB,0x03E4,
	0x02BF,0xFF4B,0xF91D,0xEEB4,0xDF4D,0xCB2D,0xC01C,0xC07F,
	0xC0CD,0xC0F0,0xD620,0xF6D1,0x0ABA,0x0B9D,0xF677,0xD247,
	0xC008,0xC1FC,0xC070,0xC8D3,0xF5E4,0x23EC,0x3C0F,0x3E65,
	0x3AAC,0x1F14,0xFEB4,0xE941,0xE709,0xF9A7,0x1FFF,0x3E77,
	0x3F30,0x3EAE,0x3F1D,0x405B,0x3645,0x1889,0x0CA2,0x12C6,
	0x2841,0x3CEF,0x3F57,0x3F0D,0x3F08,0x3E12,0x2B98,0x12A0,
	0x0155,0xF866,0xF84E,0xFEB5,0x0764,0x0DC6,0x0D7D,0x064B,
	0xFA18,0xEC9F,0xE0DA,0xD8B5,0xD425,0xD254,0xD1F2,0xD353,
	0xD678,0xDBBA,0xE238,0xE828,0xEB5A,0xE9CE,0xE45F,0xDD62,
	0xD82F,0xD810,0xDEEA,0xEBCF,0xFB39,0x09B6,0x13A6,0x189D,
	0x1705,0x1017,0x06AF,0x004B,0xFFF4,0x063C,0x125C,0x2202,
	0x2F9E,0x36BC,0x34CD,0x2AF7,0x1D55,0x10DE,0x0A9A,0x09AC,
	0x0DD8,0x1686,0x1F78,0x2373,0x21A9,0x19E0,0x0D40,0xFFF1,
	0xF410,0xEC7A,0xEA8A,0xEE27,0xF3E7,0xF897,0xF9E0,0xF73A,
	0xF0B4,0xE744,0xDF22,0xDB2C,0xD9CE,0xDAEA,0xDE4F,0xE298,
	0xE65A,0xE96E,0xEB5C,0xEC60,0xECAC,0xEC51,0xEC2F,0xEC3F,
	0xECF3,0xEFBD,0xF4D8,0xFACF,0x00BD,0x06DA,0x0B29,0x0D76,
	0x0CE6,0x0AEB,0x08FC,0x06D3,0x060E,0x09DD,0x0F53,0x156F,
	0x1A36,0x1C1B,0x1A9C,0x1597,0x0F24,0x08C9,0x03AC,0x01A7,
	0x02B5,0x056F,0x074D,0x07EC,0x06DE,0x0386,0xFE80,0xF869,
	0xF250,0xEDC4,0xEBC0,0xEBB6,0xED1F,0xEFF0,0xF264,0xF2ED,
	0xF09C,0xECEC,0xE90F,0xE652,0xE54C,0xE608,0xE8DA,0xECAF,
	0xF02C,0xF256,0xF40B,0xF548,0xF5EE,0xF55A,0xF54F,0xF5DF,
	0xF6BE,0xF917,0xFC32,0x000B,0x03FA,0x06BC,0x0870,0x090A,
	0x0848,0x0796,0x06CD,0x067F,0x0692,0x07AA,0x0A47,0x0C9F,
	0x0D8F,0x0D7F,0x0C6B,0x09BA,0x0604,0x01ED,0x0003,0xFFD1,
	0x017E,0x031F,0x047A,0x03C3,0x01AD,0xFDF4,0xF971,0xF688,
	0xF72D,0xF52D,0xF5B5,0xF725,0xF764,0xF7C7,0xF728,0xF637,
	0xF54A,0xF49B,0xF34C,0xF371,0xF435,0xF603,0xF817,0xFA1E,
	0xFB9D,0xFC7A,0xFCB0,0xFCA2,0xFCF8,0xFDE7,0xFF48,0x0065,
	0x01D8,0x0334,0x04EE,0x0591,0x044A,0xFFC8,0xF73D,0xEA2D,
	0xD8A5,0xC5C5,0xBF55,0xC04F,0xBFCE,0xC392,0xDDC8,0xFAF9,
	0x0B69,0x07F2,0xEEEA,0xCBC5,0xBF86,0xC1AD,0xBF9F,0xCFD7,
	0x017B,0x2C61,0x3D23,0x3EA0,0x3632,0x15A9,0xF89A,0xE81E,
	0xEB7E,0x02F1,0x2AE9,0x3FCF,0x3E9E,0x3F67,0x3E79,0x3FBF,
	0x2D54,0x111F,0x0A9E,0x157E,0x2F2D,0x3EED,0x3E3D,0x3E27,
	0x3ED3,0x3A4C,0x228C,0x0C7A,0xFF06,0xFA11,0xFD0A,0x0400,
	0x0B60,0x0F5D,0x0C82,0x02E5,0xF699,0xEA13,0xDEE7,0xD7A9,
	0xD4D8,0xD471,0xD4E6,0xD605,0xD892,0xDCEB,0xE390,0xE97A,
	0xEC55,0xEAA0,0xE51D,0xDE59,0xD9FE,0xDAFC,0xE2B8,0xEFE9,
	0xFF70,0x0D98,0x178A,0x1C08,0x198C,0x0FBE,0x0641,0x005C,
	0x015C,0x0A1B,0x196B,0x2A40,0x378E,0x3C45,0x3789,0x2B28,
	0x1BB1,0x0F35,0x0A12,0x0BAD,0x1305,0x1D11,0x24AC,0x26BC,
	0x21BF,0x16D9,0x08AB,0xFB64,0xF224,0xEDDD,0xEEFE,0xF37F,
	0xF8AA,0xFB79,0xFA59,0xF4E7,0xECAE,0xE47D,0xDE98,0xDC2A,
	0xDC95,0xDF36,0xE2AC,0xE55D,0xE81B,0xEA8B,0xEC9A,0xEDD4,
	0xEE0E,0xED30,0xEC60,0xECA0,0xEE8B,0xF253,0xF73B,0xFCD7,
	0x0246,0x0711,0x0A8A,0x0C20,0x0C5B,0x0B9E,0x09A8,0x07D0,
	0x086C,0x0B3A,0x1028,0x1643,0x1A42,0x1B30,0x1833,0x12FB,
	0x0CB8,0x0617,0x02FC,0x0329,0x04F2,0x074A,0x0980,0x0AB3,
	0x06DB,0x0383,0xFDE4,0xF563,0xEF72,0xECC5,0xECE3,0xEF59,
	0xF2AD,0xF4D9,0xF481,0xF148,0xEC7B,0xE8B1,0xE68E,0xE5BB,
	0xE6AF,0xE964,0xEC6E,0xEF4B,0xF17F,0xF2E9,0xF423,0xF462,
	0xF43C,0xF483,0xF5E5,0xF808,0xFA2D,0xFC6D,0xFEEF,0x0160,
	0x03C7,0x05CE,0x07CA,0x09CD,0x0A73,0x09B2,0x083F,0x070A,
	0x0734,0x088D,0x0ADF,0x0CD1,0x0DEB,0x0DED,0x0BFA,0x091C,
	0x0626,0x0361,0x00E7,0xFFB7,0xFFC9,0x005A,0x0111,0x01D9,
	0x00FC,0xFED6,0xFB5C,0xF785,0xF40A,0xF2E9,0xF4EA,0xF596,
	0xF767,0xF922,0xFA0A,0xF889,0xF6AB,0xF597,0xF407,0xF2D5,
	0xF3B1,0xF5C4,0xF804,0xFA2B,0xFBBB,0xFCFB,0xFD92,0xFD8B,
	0xFD1E,0xFCE8,0xFE8B,0x00A6,0x0119,0x021A,0x03D2,0x0455,
	0x031E,0xFEB2,0xF5E7,0xE960,0xD8DA,0xC5EE,0xBEF5,0xC02A,
	0xBF5D,0xCC91,0xEA02,0x02F6,0x0DA5,0x0414,0xE7F0,0xC771,
	0xBF22,0xC10C,0xC09E,0xDBF4,0x0AA0,0x2F14,0x3D25,0x3C6C,
	0x2820,0x098D,0xF06F,0xE54C,0xED3D,0x0703,0x2C88,0x3E80,
	0x3D70,0x3D7F,0x3D6F,0x3B02,0x2166,0x0BCC,0x083B,0x148B,
	0x2C12,0x3CB9,0x3D9B,0x3D3C,0x3E2D,0x31A3,0x18FF,0x05ED,
	0xFA5C,0xF733,0xFAE0,0x0214,0x0887,0x0AF3,0x081C,0xFFD5,
	0xF4AC,0xE8C5,0xDE7D,0xD80C,0xD4D6,0xD45B,0xD5A2,0xD875,
	0xDCFF,0xE1DF,0xE659,0xE9FF,0xEB15,0xE881,0xE349,0xDDDD,
	0xDB4D,0xDD33,0xE457,0xF11A,0xFFA9,0x0C54,0x1466,0x1618,
	0x115D,0x093D,0x0125,0xFD13,0x001A,0x09E8,0x17E4,0x2606,
	0x2FC6,0x32C3,0x2CEA,0x210D,0x13DD,0x09A4,0x04AF,0x0969,
	0x10FF,0x1824,0x1F55,0x209F,0x1B7C,0x1121,0x0414,0xF849,
	0xF149,0xEE7A,0xF04D,0xF40C,0xF8CD,0xFB68,0xFA0C,0xF528,
	0xEE29,0xE6E0,0xE0F8,0xDE58,0xDEE0,0xE1ED,0xE568,0xE8E7,
	0xEB93,0xEE28,0xEF93,0xF057,0xF090,0xEFEF,0xEF59,0xEEA6,
	0xEF59,0xF21E,0xF736,0xFDDD,0x046A,0x0950,0x0C05,0x0CCC,
	0x0B1F,0x086A,0x0667,0x057E,0x06D8,0x0A99,0x0FAF,0x1620,
	0x1A25,0x1A8C,0x1768,0x1185,0x09DA,0x0423,0x01FA,0x0372,
	0x072E,0x0AE5,0x0C14,0x0B13,0x07D4,0x024A,0xFC10,0xF582,
	0xF0BE,0xEF25,0xEE93,0xF087,0xF35C,0xF63B,0xF666,0xF403,
	0xF084,0xED0E,0xEA43,0xE8DB,0xE961,0xEBEC,0xEEFD,0xF1D0,
	0xF3EB,0xF6BF,0xF785,0xF78B,0xF830,0xF769,0xF63E,0xF6CF,
	0xF9B8,0xFD9E,0x024D,0x0639,0x0882,0x0940,0x08D5,0x0845,
	0x07B9,0x0708,0x068F,0x06DC,0x0871,0x0AE9,0x0D50,0x0EB6,
	0x0F41,0x0E0F,0x0B7D,0x089F,0x0458,0x01C2,0x010F,0x0175,
	0x02BA,0x0470,0x0597,0x04E7,0x0256,0xFE95,0xFA9D,0xF6F6,
	0xF4C4,0xF529,0xF744,0xF999,0xFBCC,0xFC98,0xFC46,0xFA32,
	0xF7B5,0xF5CD,0xF46D,0xF48B,0xF603,0xF830,0xFADE,0xFD5D,
	0xFF6C,0x00CE,0x00CE,0xFFE8,0xFEAC,0xFDA3,0xFDCE,0xFFCF,
	0x0245,0x050F,0x06CF,0x06BF,0x0460,0xFF1E,0xF85B,0xF08B,
	0xE842,0xE1D3,0xDFD4,0xE4ED,0xEFD5,0xFD5B,0x0879,0x0C05,
	0x0557,0xF6E7,0xE674,0xDAF7,0xDA41,0xE498,0xF5BC,0x09BD,
	0x19B3,0x1FE4,0x1B6F,0x0F3E,0x00FD,0xF608,0xF1D2,0xF698,
	0x0313,0x137A,0x2453,0x2DED,0x2DA6,0x2443,0x167E,0x081E,
	0xFF89,0x0135,0x07C6,0x1257,0x1C61,0x2124,0x203C,0x1A42,
	0x110D,0x0750,0xFF81,0xFBC6,0xFC12,0xFE7D,0x01FB,0x04B7,
	0x05B9,0x03C9,0xFF1F,0xFA3B,0xF64B,0xF3F5,0xF238,0xF077,
	0xEF69,0xEF45,0xEF87,0xF15A,0xF513,0xF8B2,0xFA91,0xFA68,
	0xF79F,0xF3DA,0xF028,0xEF4B,0xF16B,0xF53B,0xFAC8,0x00C6,
	0x0582,0x0814,0x0743,0x0476,0x0041,0xFC49,0xFA93,0xFC14,
	0x014C,0x0843,0x0E7E,0x11B9,0x1142,0x0DC7,0x085D,0x027F,
	0xFEA0,0xFDC7,0xFFEF,0x03DE,0x083B,0x0C99,0x0E3E,0x0B66,
	0x0682,0x00BD,0xFBB2,0xF80F,0xF71A,0xF89A,0xFB78,0xFE1B,
	0xFF76,0xFED6,0xFC4E,0xF8A3,0xF4EC,0xF31B,0xF26B,0xF269,
	0xF2D5,0xF452,0xF7A6,0xF9C8,0xF9EB,0xFA24,0xF9D9,0xF7D7,
	0xF65E,0xF63A,0xF7B0,0xF9DF,0xFBDA,0xFD46,0xFE9F,0x00EB,
	0x023F,0x030B,0x0354,0x02EC,0x018C,0x0061,0x002F,0x01A8,
	0x045A,0x06E2,0x07CF,0x0727,0x0732,0x0633,0x0404,0x01D9,
	0x00D1,0x00C8,0x01B3,0x0265,0x035E,0x0332,0x0221,0x00CA,
	0xFED2,0xFC46,0xFAEE,0xF9BE,0xF8BD,0xF7F4,0xF732,0xF6B6,
	0xF645,0xF5CC,0xF4C9,0xF3EA,0xF2C2,0xF1BE,0xF0D7,0xF0C3,
	0xF245,0xF509,0xF7AD,0xF908,0xF88E,0xF7D3,0xF70F,0xF6E6,
	0xF741,0xF7CE,0xF837,0xF864,0xF81B,0xF7BF,0xF7EA,0xF77C,
	0xF6FB,0xF695,0xF656,0xF565,0xF475,0xF406,0xF35F,0xF313,
	0xF2A4,0xF20B,0xF161,0xF0D6,0xF013,0xEF54,0xEE27,0xED4E,
	0xEC4C,0xEBF7,0xEB5C,0xEB97,0xEB25,0xEADD,0xEA10,0xE8DD,
	0xE87E,0xE899,0xE7FA,0xE77B,0xE78D,0xE710,0xE682,0xE807,
	0xE5E1,0xE627,0xE6D3,0xE68A,0xE649,0xE677,0xE615,0xE636,
	0xE649,0xE648,0xE6A0,0xE6BD,0xE6FB,0xE6FC,0xE78C,0xE79E,
	0xE7A3,0xE805,0xE89B,0xE88B,0xE8FD,0xE95F,0xE990,0xE9EF,
	0xE9F8,0xE9FB,0xEA24,0xEA44,0xEABE,0xEB3D,0xEBD2,0xEC16,
	0xEC88,0xED18,0xED43,0xEDD6,0xEE41,0xEE26,0xEE4C,0xEEB7,
	0xEF65,0xF003,0xF08A,0xF125,0xF15E,0xF171,0xF1E9,0xF23C,
	0xF29D,0xF302,0xF3B2,0xF438,0xF4B5,0xF52D,0xF5C8,0xF5FE,
	0xF683,0xF71F,0xF7FA,0xF843,0xF8C6,0xF92A,0xF906,0xF796,
	0xF7D6,0xF8EA,0xF9BD,0xFA22,0xFB5C,0xFBEA,0xFBFB,0xFC3C,
	0xFC7E,0xFD3A,0xFD8C,0xFDED,0xFEBC,0xFF29,0xFFDB,0x004A,
	0x00CA,0x00DA,0x0087,0x0158,0x027A,0x0262,0x021B,0x02F1,
	0x03A7,0x0409,0x0454,0x0493,0x04AF,0x04DC,0x0545,0x05E3,
	0x0633,0x0638,0x0649,0x06AF,0x070C,0x07C3,0x0837,0x088E,
	0x08CD,0x088E,0x0946,0x09F3,0x0928,0x08E9,0x093E,0x0970,
	0x09D2,0x09D9,0x0A2B,0x0AB3,0x0AD2,0x0B6E,0x0C56,0x0CCF,
	0x0D65,0x0DF1,0x0DA4,0x0DA1,0x0DB5,0x0DE9,0x0DE0,0x0E42,
	0x0E86,0x0E32,0x0E3D,0x0E6F,0x0DE4,0x0DFB,0x0E51,0x0E39,
	0x0E5B,0x0E31,0x0E00,0x0E04,0x0D8A,0x0D69,0x0DE1,0x0DB6,
	0x0DB1,0x0E15,0x0DDA,0x0D5E,0x0D7E,0x0D2A,0x0D6A,0x0E0B,
	0x0E9F,0x0ED6,0x0E7C,0x0E1D,0x0DB7,0x0D83,0x0D8A,0x0E00,
	0x0DCC,0x0DD0,0x0DF2,0x0DE4,0x0DE1,0x0DE9,0x0DDB,0x0E10,
	0x0E7A,0x0E90,0x0E14,0x0DFF,0x0E19,0x0DE8,0x0E05,0x0E27,
	0x0D09,0x0CDF,0x0D3F,0x0D45,0x0D44,0x0D19,0x0D96,0x0B8C,
	0x0C3C,0x0D8D,0x0CB9,0x0CF2,0x0D03,0x0C7E,0x0CE3,0x0CB8,
	0x0CAA,0x0CB5,0x0CC6,0x0CC1,0x0C6B,0x0C43,0x0C46,0x0C74,
	0x0C68,0x0C11,0x0BB5,0x0BD6,0x0C19,0x0BC3,0x0BC6,0x0BDF,
	0x0C2F,0x0C7A,0x0BF7,0x0C06,0x0B9B,0x0B64,0x0B2D,0x0ABF,
	0x0AA9,0x0AD3,0x0ADD,0x0B0A,0x0AB5,0x0A66,0x09E1,0x09E3,
	0x0A22,0x09E2,0x0A28,0x09E7,0x0964,0x0960,0x0952,0x0907,
	0x08DE,0x08E7,0x0934,0x0926,0x08ED,0x08EE,0x0934,0x08CA,
	0x08A3,0x0920,0x0962,0x09CC,0x0A2D,0x0BC8,0x0ADD,0x0A67,
	0x0A1F,0x09BB,0x09A7,0x09B2,0x09CB,0x0977,0x090F,0x08A7,
	0x08B8,0x08B7,0x089B,0x08C2,0x08E4,0x08C8,0x0858,0x0795,
	0x074D,0x07EA,0x0830,0x07B1,0x0774,0x07C8,0x0766,0x0702,
	0x06B5,0x06B2,0x0687,0x0683,0x0638,0x0630,0x0623,0x05FB,
	0x0607,0x05A5,0x05A7,0x05BF,0x05B0,0x05AF,0x059D,0x0539,
	0x053A,0x0492,0x038D,0x0457,0x058C,0x05B9,0x0568,0x04E0,
	0x049F,0x040E,0x0432,0x043D,0x0424,0x03C7,0x0347,0x030D,
	0x025E,0x01FC,0x0269,0x022C,0x0262,0x02A7,0x0299,0x029A,
	0x0235,0x01B3,0x01A8,0x018F,0x01D9,0x0253,0x024C,0x023B,
	0x01FD,0x01E8,0x01B8,0x0184,0x01AC,0x01D5,0x021E,0x01CB,
	0x0206,0x021D,0x01AA,0x0177,0x0197,0x01D9,0x01EF,0x01DE,
	0x01B0,0x019E,0x0193,0x0134,0x00EE,0x0160,0x01FF,0x01E1,
	0x017E,0x0197,0x0138,0x011B,0x0113,0x0155,0x0173,0x0175,
	0x0115,0x00EA,0x011E,0x0136,0x0158,0x00ED,0x00BA,0x0109,
	0x014C,0x0101,0x0105,0x0150,0x0143,0x00EB,0x0264,0x0264,
	0x0112,0x0225,0x012F,0x00D1,0x00B1,0x010E,0x0122,0x017E,
	0x0196,0x0196,0x0169,0x0129,0x015F,0x0144,0x013B,0x00EF,
	0x00D3,0x00A4,0x0080,0xFEFA,0xFF8F,0x0167,0x042D,0x05FC,
	0x0544,0x06D9,0x04EB,0x0261,0x022C,0x0191,0x01C6,0x01EA,
	0x0205,0x012B,0x002B,0x002A,0x0130,0x01E2,0x02A1,0x0303,
	0x02EC,0x02E5,0x041F,0x05CD,0x0714,0x076C,0x0554,0x02FB,
	0x02C2,0x0502,0x093D,0x0E11,0x10C4,0x1047,0x0F51,0x0F2A,
	0x0E49,0x0D5C,0x0F0B,0x1240,0x14F8,0x1586,0x15D1,0x1626,
	0x160C,0x143B,0x1169,0x1111,0x1352,0x15CD,0x1681,0x165B,
	0x181C,0x1B0F,0x1BE5,0x1A55,0x19BF,0x1B79,0x1C65,0x1AE6,
	0x1B2E,0x1F80,0x23A2,0x2292,0x1E65,0x1C07,0x1C39,0x1C5D,
	0x1C89,0x1B7B,0x1BC2,0x1B35,0x188B,0x1661,0x16DA,0x19E8,
	0x1CBC,0x1C46,0x18DF,0x1717,0x1818,0x198C,0x1B4C,0x1D2A,
	0x1ED6,0x1DA4,0x199F,0x1514,0x1197,0x11FC,0x1459,0x1581,
	0x15C8,0x15F1,0x1538,0x1341,0x12A4,0x1495,0x15E3,0x14B8,
	0x13D2,0x136D,0x1363,0x125E,0x103E,0x0EBE,0x0E5F,0x0DA3,
	0x0B0B,0x0932,0x0B00,0x0D8B,0x0E2E,0x0E5C,0x0D64,0x0D64,
	0x0B77,0x07B2,0x0607,0x0852,0x0B1A,0x0B38,0x098A,0x0933,
	0x090B,0x0746,0x049E,0x02F6,0x03DA,0x0670,0x07E3,0x0788,
	0x0721,0x07C5,0x068F,0x029B,0xFF47,0xFF38,0x011F,0x0275,
	0x0318,0x02DD,0x0229,0x0024,0xFC4F,0xF8AE,0xF6F5,0xF817,
	0xFB49,0xFE13,0xFF2D,0xFF7B,0xFF04,0xFCF1,0xF9A3,0xF672,
	0xF658,0xF8BF,0xFB1E,0xFBF9,0xFB80,0xF9D3,0xF772,0xF494,
	0xF2DE,0xF374,0xF456,0xF4F8,0xF3C3,0xF2B2,0xF2F0,0xF42D,
	0xF525,0xF4FD,0xF4B1,0xF37F,0xF1F0,0xF11F,0xF1A8,0xF30D,
	0xF433,0xF44F,0xF211,0xEFA1,0xEFEA,0xF007,0xEFB5,0xEF54,
	0xEF41,0xED41,0xECD8,0xF020,0xF00D,0xF00F,0xF051,0xF04B,
	0xEF0F,0xED63,0xECD2,0xEE74,0xF119,0xF1DE,0xF026,0xED6D,
	0xEB0B,0xE988,0xE8ED,0xE96D,0xED1F,0xF10E,0xF12C,0xEE75,
	0xED4C,0xED92,0xED74,0xEC7A,0xEBDB,0xECE4,0xEE63,0xEEA1,
	0xEDDB,0xED38,0xEE02,0xEE6A,0xEBB7,0xE930,0xE9B2,0xEC93,
	0xEE8A,0xEF1A,0xEEBC,0xEF24,0xEEEA,0xEE07,0xED38,0xEDC8,
	0xEF0F,0xEEA6,0xEC1C,0xE9D3,0xEA8A,0xED6B,0xEECB,0xEE09,
	0xECA1,0xEB20,0xEA23,0xE9A8,0xEAD8,0xEE4E,0xF176,0xF367,
	0xF188,0xEFDF,0xEED4,0xEEE6,0xF072,0xF1BB,0xF16D,0xEF41,
	0xEDDF,0xEE89,0xEEBB,0xEE61,0xEE23,0xEEEF,0xEEE5,0xED8D,
	0xECA1,0xEE6F,0xF11D,0xF2D7,0xF36E,0xF286,0xF146,0xEF4F,
	0xED1A,0xECAF,0xEF19,0xF096,0xF098,0xF014,0xEFA0,0xF078,
	0xF075,0xEFAC,0xEEBB,0xEF04,0xEFA7,0xEF9E,0xF0D7,0xF382,
	0xF555,0xF545,0xF36B,0xF16A,0xEFAF,0xEEE9,0xF047,0xF1F8,
	0xF3F3,0xF556,0xF4A4,0xF286,0xF097,0xF005,0xF03E,0xF060,
	0xF0C2,0xF209,0xF368,0xF397,0xF381,0xF2DF,0xF27A,0xF221,
	0xF16D,0xF1C2,0xF2F0,0xF58E,0xF780,0xF75E,0xF673,0xF472,
	0xF31B,0xF220,0xF18E,0xF254,0xF466,0xF5DB,0xF5C8,0xF4FE,
	0xF4A1,0xF403,0xF324,0xF2B9,0xF349,0xF530,0xF701,0xF7FC,
	0xF8D2,0xF948,0xF7D8,0xF57F,0xF3CB,0xF3DC,0xF4F2,0xF69A,
	0xF807,0xF7FB,0xF802,0xF710,0xF54C,0xF4B1,0xF5C5,0xF78C,
	0xF8A5,0xF943,0xF9B7,0xFA31,0xFA8C,0xFA54,0xF9F8,0xF9F0,
	0xF94F,0xF8C5,0xF92C,0xFA56,0xFAF0,0xFB4D,0xFA93,0xF8FF,
	0xF8E1,0xF9CA,0xF88F,0xFB5C,0xFC38,0xFC28,0xFBE2,0xFBB2,
	0xFB5C,0xFB80,0xFBCF,0xFBAD,0xFB3B,0xFAA0,0xFADF,0xFAD1,
	0xFB2D,0xFB67,0xFBB0,0xFB19,0xFA83,0xF9FE,0xFA06,0xFB30,
	0xFC29,0xFCEE,0xFD22,0xFCBC,0xFBD1,0xFB15,0xFB27,0xFC05,
	0xFD31,0xFDA8,0xFD00,0xFC2B,0xFB7B,0xFAE5,0xFADC,0xFAC3,
	0xFA9C,0xFA60,0xFAC4,0xFA6F,0xFA85,0xFA10,0xF962,0xF8FF,
	0xF8AE,0xF7C2,0xF6A6,0xF5EA,0xF56C,0xF494,0xF3E7,0xF372,
	0xF2E5,0xF236,0xF19C,0xF1BB,0xF1EF,0xF218,0xF218,0xF21B,
	0xF0B4,0xEEC6,0xEF3A,0xEFCF,0xEFBA,0xEF2E,0xEF07,0xEF02,
	0xEEEB,0xEE05,0xED5C,0xECDB,0xEC91,0xEC11,0xEB68,0xEB47,
	0xEB50,0xEB28,0xEADF,0xE9CC,0xE8C3,0xE8C7,0xE943,0xE8F9,
	0xE8A8,0xE81A,0xE82F,0xE823,0xE826,0xE80B,0xE80F,0xE82E,
	0xE815,0xE860,0xE82D,0xE82E,0xE821,0xE80D,0xE7E5,0xE81D,
	0xE836,0xE895,0xE8DD,0xE8AF,0xEA1D,0xEA42,0xE967,0xE929,
	0xE9C7,0xEA59,0xEA75,0xEACB,0xEB40,0xEB7D,0xEB88,0xEBFA,
	0xECD0,0xED63,0xEDFE,0xEE8E,0xEE5C,0xEEA3,0xEF64,0xEFE2,
	0xF05B,0xF07D,0xF0FB,0xF1B1,0xF1A8,0xF1F1,0xF2C9,0xF33F,
	0xF312,0xF322,0xF3B3,0xF3C1,0xF402,0xF457,0xF4FC,0xF5A9,
	0xF643,0xF6D5,0xF704,0xF745,0xF7A5,0xF81B,0xF85D,0xF893,
	0xF969,0xF9A6,0xF9DC,0xF9EB,0xFA1B,0xFA69,0xFAFD,0xFB65,
	0xFBDF,0xFCCD,0xFD26,0xFD56,0xFDC3,0xFE35,0xFE5F,0xFEA1,
	0xFEB8,0xFF34,0xFFA3,0x0007,0x0071,0x0058,0x0062,0x00F7,
	0x018C,0x0224,0x01E3,0x02D9,0x037A,0x0409,0x0430,0x047D,
	0x04FD,0x0324,0x0501,0x05A1,0x051A,0x05C2,0x065E,0x0680,
	0x06FC,0x0717,0x0706,0x0742,0x07C6,0x07F2,0x0873,0x08BE,
	0x08E6,0x0918,0x0978,0x09A2,0x09D5,0x09FC,0x0A7B,0x0A94,
	0x0AEC,0x0AE6,0x0B34,0x0B18,0x0B34,0x0B9B,0x0BC6,0x0C08,
	0x0C9E,0x0CC2,0x0C98,0x0CB5,0x0CC3,0x0CED,0x0D25,0x0D21,
	0x0D59,0x0D65,0x0D65,0x0D70,0x0D38,0x0D22,0x0D15,0x0D65,
	0x0D80,0x0D4A,0x0D89,0x0D81,0x0E06,0x0E16,0x0DC6,0x0DF4,
	0x0E3E,0x0E43,0x0E8D,0x0E9F,0x0EAD,0x0ED8,0x1058,0x11A4,
	0x1061,0x1076,0x10F9,0x110F,0x10ED,0x1086,0x1090,0x108A,
	0x1094,0x1087,0x1049,0x1084,0x1085,0x1066,0x0FF4,0x102A,
	0x0FDE,0x0F31,0x0EDD,0x0FDB,0x107B,0x0FD4,0x0FB2,0x1017,
	0x0F95,0x0F4C,0x0F44,0x0EF3,0x0EE5,0x0ED9,0x0EFE,0x0F2C,
	0x0F20,0x0EE9,0x0ED6,0x0EB8,0x0EAC,0x0E76,0x0E91,0x0E22,
	0x0DFD,0x0DC1,0x0DE4,0x0D4C,0x0BED,0x0D1D,0x0DB9,0x0DDE,
	0x0E07,0x0DFD,0x0DE6,0x0D9C,0x0D47,0x0D08,0x0C6F,0x0C55,
	0x0C68,0x0C2B,0x0B56,0x0B27,0x0B43,0x0B5C,0x0B73,0x0B6E,
	0x0B2F,0x0B48,0x0AF9,0x0B15,0x0ACA,0x0A8D,0x0A7C,0x0A88,
	0x0AAD,0x0AAD,0x0ABF,0x0ABF,0x0A79,0x0A6E,0x0A21,0x0A8D,
	0x0AA8,0x0A78,0x0A45,0x09DD,0x097C,0x099A,0x09C1,0x0A10,
	0x0A12,0x0A32,0x0A00,0x09E9,0x0A25,0x09F2,0x09C0,0x0996,
	0x0952,0x097E,0x0993,0x09CB,0x09C6,0x09E3,0x098B,0x092D,
	0x08D4,0x0941,0x08E6,0x0839,0x0866,0x087D,0x088A,0x07F0,
	0x07F6,0x0885,0x0918,0x08DC,0x08B3,0x08BA,0x0878,0x078E,
	0x08E4,0x0826,0x071E,0x0859,0x07CD,0x07D5,0x078F,0x07CB,
	0x0760,0x0779,0x0730,0x077A,0x0785,0x0767,0x0762,0x0758,
	0x0742,0x074A,0x06C5,0x069D,0x06B8,0x0668,0x064C,0x065E,
	0x068E,0x0653,0x0663,0x0633,0x05F6,0x057F,0x0593,0x05A2,
	0x05C6,0x05DF,0x05AC,0x05A6,0x05AD,0x05D6,0x05E2,0x05E6,
	0x0586,0x057B,0x057F,0x0574,0x0599,0x053C,0x056C,0x0560,
	0x0554,0x054B,0x0541,0x053C,0x0517,0x04B2,0x04B7,0x04EF,
	0x04D6,0x052C,0x053A,0x04AA,0x0498,0x0518,0x04C9,0x0439,
	0x0285,0x01E7,0x0287,0x029D,0x028F,0x02B7,0x031A,0x032C,
	0x02DB,0x0262,0x0251,0x0272,0x020C,0x02AF,0x0337,0x0359,
	0x0323,0x035A,0x0370,0x020F,0x0220,0x02FA,0x030F,0x0257,
	0x0261,0x02CD,0x02EE,0x02E8,0x0319,0x02C4,0x0338,0x02F9,
	0x02F5,0x02EC,0x028A,0x02D7,0x02D1,0x0296,0x02B2,0x02FC,
	0x02FA,0x0317,0x02CF,0x0312,0x02F8,0x01AD,0x0159,0x018C,
	0x01F8,0x0202,0x0207,0x0240,0x0238,0x0220,0x0267,0x02C6,
	0x0341,0x039F,0x03F6,0x0430,0x03F1,0x03B0,0x03AF,0x03EF,
	0x03BF,0x035F,0x033E,0x02EC,0x0280,0x02C0,0x026F,0x029C,
	0x02CB,0x025A,0x0223,0x01BF,0x016B,0x0169,0x0150,0x0155,
	0x012C,0x010F,0x00CD,0x00A7,0x00F9,0x009F,0x009A,0x00A5,
	0x00E4,0x00BA,0x0073,0xF8EC,0xF548,0xFD45,0x024A,0xFA38,
	0xF3AC,0xFE87,0x0E67,0x0DE3,0x0286,0x03B7,0x0C5D,0x0F7A,
	0x0F75,0x1004,0x12E2,0x1228,0x0BCC,0x088C,0x0C93,0x0FB1,
	0x0C61,0x05A0,0x06DC,0x0CEC,0x0BD0,0x07AE,0x0774,0x0EEE,
	0x11BC,0x0D2D,0x0B86,0x12C6,0x1840,0x1397,0x0B9A,0x0D5F,
	0x1844,0x1C18,0x16E8,0x13E8,0x17CA,0x1CA3,0x19BD,0x1396,
	0x16D3,0x1DA8,0x1D83,0x18E7,0x1884,0x1DF8,0x20C2,0x1CC1,
	0x1902,0x1B35,0x1FB7,0x2005,0x1D92,0x1A03,0x1AE2,0x209A,
	0x21DC,0x1C12,0x1946,0x1AB1,0x1D20,0x1F4A,0x1E6A,0x1B6D,
	0x1B3F,0x1DB9,0x1CBB,0x1898,0x1728,0x19EF,0x1D1B,0x1B9F,
	0x17F9,0x1585,0x194A,0x1CDE,0x1A68,0x161D,0x1457,0x1722,
	0x1B1D,0x19C8,0x14FF,0x138C,0x17A4,0x1A09,0x1630,0x12A9,
	0x128B,0x13AA,0x1365,0x10CC,0x11CC,0x14DC,0x1324,0x0EE9,
	0x0D1F,0x1041,0x13FA,0x102F,0x093C,0x07AE,0x0CBA,0x11CF,
	0x0DE1,0x0605,0x067A,0x0A4F,0x0A24,0x0788,0x05CF,0x0851,
	0x098B,0x038D,0xFEE3,0x029E,0x079C,0x04A8,0x0010,0xFFE9,
	0x02D4,0x03CC,0x00ED,0xFDB6,0xFDC5,0x00A4,0x0178,0xFE73,
	0xFDDF,0xFE73,0xFBF6,0xF9D0,0xFAF0,0xFD1D,0xFDC3,0xFCD7,
	0xF99B,0xF917,0xFC42,0xFBB0,0xF602,0xF5C2,0xF7B9,0xF83B,
	0xFACA,0xFB4A,0xF7E8,0xF51D,0xF5C5,0xF7F8,0xF712,0xF508,
	0xF61A,0xF68A,0xF3B9,0xF1CE,0xF272,0xF3C5,0xF40B,0xF3B6,
	0xF37C,0xF286,0xF1CE,0xF179,0xF0B2,0xF0EB,0xF109,0xF05A,
	0xEFB4,0xF0C6,0xF16D,0xEF59,0xEEB1,0xF041,0xF101,0xF0EA,
	0xEFF4,0xEE0E,0xED93,0xEEF1,0xF007,0xF0DE,0xF06C,0xED87,
	0xEAA0,0xEB94,0xF0B5,0xF2BF,0xEFEF,0xED08,0xECB6,0xECB3,
	0xEBE9,0xEDC5,0xEF20,0xEE1D,0xEE02,0xEDED,0xEC38,0xEBE1,
	0xEF36,0xF17E,0xEEDC,0xEAE7,0xEED4,0xF49C,0xF20E,0xE9C2,
	0xE935,0xF226,0xF5E4,0xEEB9,0xE9EA,0xEF2C,0xF318,0xEF2A,
	0xEA29,0xECE6,0xF2A5,0xF377,0xEE88,0xEA0A,0xEBF8,0xF0EE,
	0xF19B,0xEDD5,0xECBE,0xEF64,0xF176,0xEEEB,0xEA72,0xEBCF,
	0xF0DE,0xF1FE,0xEF22,0xEE14,0xF02F,0xF066,0xEC1A,0xEA6B,
	0xEFBC,0xF48C,0xF130,0xEA45,0xE9C7,0xF06D,0xF461,0xEF24,
	0xEA79,0xEE01,0xF260,0xF010,0xEB40,0xEC5A,0xF2BD,0xF2D3,
	0xED03,0xEBB4,0xF01F,0xF2D1,0xEF34,0xEAC2,0xEC44,0xF248,
	0xF374,0xED54,0xEA53,0xEEFC,0xF348,0xEFF9,0xED25,0xF0C5,
	0xF3F7,0xF157,0xECE9,0xED5B,0xF2F8,0xF424,0xEF4E,0xECEA,
	0xF0D6,0xF4A5,0xF2A3,0xEDDD,0xEE63,0xF2E8,0xF44E,0xF275,
	0xF10F,0xF20C,0xF246,0xF0B5,0xEFA6,0xF280,0xF55C,0xF46B,
	0xF18F,0xF0F3,0xF34C,0xF4E4,0xF2E4,0xF1A1,0xF259,0xF3CD,
	0xF481,0xF40C,0xF394,0xF365,0xF321,0xF34A,0xF508,0xF63A,
	0xF5B9,0xF3D8,0xF248,0xF356,0xF5C0,0xF774,0xF622,0xF4C0,
	0xF539,0xF662,0xF596,0xF73B,0xF7DA,0xF501,0xF5FC,0xF6A1,
	0xF7F9,0xF89C,0xF82F,0xF5FB,0xF647,0xF781,0xF8F5,0xF877,
	0xF7BB,0xF718,0xF76A,0xF7A3,0xF760,0xF774,0xF7FF,0xF81A,
	0xF727,0xF6A5,0xF835,0xFA4C,0xFA40,0xF76A,0xF614,0xF8AC,
	0xFB47,0xFACB,0xF8D9,0xF8C3,0xF95F,0xF941,0xF930,0xF9EE,
	0xFAC3,0xFA6E,0xFA2A,0xFA83,0xFB33,0xFAD2,0xF93E,0xF883,
	0xFA6E,0xFCAE,0xFD03,0xFBD4,0xFB19,0xFB1E,0xFB7F,0xFB9D,
	0xFC3F,0xFCE7,0xFCB9,0xFB61,0xFA74,0xFB86,0xFCC3,0xFC9D,
	0xFBDF,0xFC25,0xFD10,0xFC0C,0xFA60,0xF9E0,0xF96E,0xFA5A,
	0xFB55,0xFC46,0xFCE5,0xFD52,0xFCEB,0xFB50,0xFAE6,0xFC11,
	0xFD8F,0xFE72,0xFD83,0xFC9E,0xFCC4,0xFDDD,0xFD41,0xFC84,
	0xFD8E,0xFDF2,0xFD3F,0xFCC6,0xFC48,0xFBAA,0xFAB9,0xFA21,
	0xF9CA,0xFA6D,0xFABD,0xFA03,0xF957,0xF85C,0xF79F,0xF852,
	0xF959,0xF88C,0xF716,0xF639,0xF66B,0xF717,0xF80F,0xF88A,
	0xF6EE,0xF625,0xF666,0xF708,0xF6E9,0xF613,0xF4FE,0xF45D,
	0xF3C7,0xF374,0xF3CE,0xF34C,0xF27D,0xF24F,0xF1A8,0xF117,
	0xF07C,0xEFB3,0xEF09,0xEE6C,0xEE0E,0xED4E,0xECDB,0xEC7A,
	0xEBE5,0xEB48,0xEB57,0xEB22,0xEA71,0xE9AA,0xE956,0xE91E,
	0xE8F7,0xE8D8,0xE861,0xE7D3,0xE78B,0xE799,0xE75A,0xE71C,
	0xE73B,0xE727,0xE719,0xE72B,0xE793,0xE79E,0xE7C1,0xE79A,
	0xE7F1,0xE851,0xE88C,0xE8BC,0xE862,0xE83A,0xE8A0,0xE960,
	0xE9AB,0xEA47,0xEA80,0xEA6C,0xEAB6,0xEAEA,0xEB46,0xEBC5,
	0xEBC7,0xEC23,0xECA4,0xED1B,0xED32,0xECF4,0xED7F,0xEE19,
	0xEE69,0xEF20,0xF0B0,0xF02B,0xEF37,0xF19B,0xF1A8,0xF23A,
	0xF32B,0xF349,0xF364,0xF36E,0xF40A,0xF4A1,0xF4E2,0xF50F,
	0xF5C6,0xF611,0xF64C,0xF6CB,0xF743,0xF791,0xF7F1,0xF83D,
	0xF8E9,0xF9A9,0xFA09,0xFA15,0xFA7E,0xFB4F,0xFBDF,0xFC4D,
	0xFC92,0xFC54,0xFCA9,0xFD27,0xFD61,0xFE55,0xFF4A,0xFF54,
	0xFFA2,0xFFF3,0x0041,0x0085,0x00FC,0x01A4,0x0231,0x021F,
	0x0290,0x029C,0x036C,0x042F,0x049B,0x04C8,0x04DE,0x050A,
	0x0587,0x05BB,0x05B8,0x0615,0x064D,0x067A,0x078F,0x07E3,
	0x082E,0x0A45,0x0AA9,0x09FA,0x0A7C,0x0AE4,0x0B64,0x0B37,
	0x0AF6,0x0B04,0x0B4D,0x0BB6,0x0C11,0x0BCA,0x0BC6,0x0BED,
	0x0BF5,0x0C0E,0x0C29,0x0C41,0x0C07,0x0BB5,0x0D0A,0x0DA1,
	0x0CE4,0x0D37,0x0D77,0x0D45,0x0DB3,0x0DE9,0x0DE0,0x0DE9,
	0x0E35,0x0DED,0x0E1C,0x0E66,0x0E56,0x0DC9,0x0DF5,0x0E17,
	0x0EAF,0x0EA7,0x0E3D,0x0E2D,0x0DD9,0x0E0A,0x0DB0,0x0D5B,
	0x0EE1,0x0F97,0x0F6A,0x0FAB,0x0F8F,0x0F8C,0x0F42,0x0ED9,
	0x0EB9,0x0EA4,0x0E46,0x0E03,0x0DE9,0x0D41,0x0D10,0x0D62,
	0x0DC3,0x0DCD,0x0DAF,0x0D65,0x0CFD,0x0CF0,0x0D59,0x0D6A,
	0x0D49,0x0D36,0x0D38,0x0D41,0x0D5A,0x0DC5,0x0DAA,0x0D31,
	0x0D68,0x0D92,0x0DD2,0x0DE1,0x0D55,0x0CE4,0x0D2F,0x0D50,
	0x0D95,0x0DAA,0x0D66,0x0D2D,0x0D4C,0x0D50,0x0D45,0x0D12,
	0x0D1F,0x0D3C,0x0D3C,0x0D1B,0x0D23,0x0D2A,0x0CDD,0x0C64,
	0x0C67,0x0C96,0x0CB2,0x0CCA,0x0CAB,0x0C4C,0x0BF6,0x0BC2,
	0x0BAA,0x0BA9,0x0B8C,0x0B30,0x0BD0,0x0C97,0x0C3E,0x0BE4,
	0x0BFC,0x0BAD,0x0BB8,0x0D5C,0x0B82,0x0BA0,0x0BF9,0x0BE0,
	0x0BC9,0x0BE3,0x0BF1,0x0B90,0x0BC6,0x0BA9,0x0B79,0x0B32,
	0x0B7F,0x0B38,0x0ABE,0x0AAB,0x0B22,0x0B39,0x0B04,0x0B03,
	0x0AF1,0x0AF5,0x0AF0,0x0AA3,0x0A15,0x0A09,0x09D8,0x0A04,
	0x0A12,0x09E4,0x09FE,0x09EE,0x0998,0x0940,0x095A,0x0999,
	0x099D,0x096C,0x097B,0x0954,0x0990,0x095F,0x0914,0x0937,
	0x0943,0x0921,0x08F9,0x08C9,0x088E,0x08A7,0x088C,0x0839,
	0x0867,0x0861,0x0838,0x07EC,0x0828,0x0834,0x0851,0x082E,
	0x07E7,0x07B5,0x06F2,0x04C9,0x04F3,0x05CB,0x066E,0x0617,
	0x0591,0x056A,0x0557,0x0546,0x0525,0x0535,0x057C,0x05BC,
	0x05A9,0x0535,0x0537,0x04FE,0x0557,0x04FB,0x0433,0x04A5,
	0x054D,0x0557,0x04D0,0x04D3,0x0560,0x0536,0x0568,0x0589,
	0x0581,0x059D,0x059B,0x04F2,0x0509,0x050B,0x0534,0x05BF,
	0x056D,0x0538,0x052C,0x0532,0x04F4,0x04BF,0x0571,0x061C,
	0x04DE,0x0421,0x03E5,0x03F9,0x0431,0x047A,0x044B,0x0488,
	0x0489,0x04F6,0x05B0,0x0565,0x0595,0x063A,0x05EB,0x05C6,
	0x05EA,0x05CE,0x0599,0x05AB,0x05B5,0x05C9,0x05C5,0x0562,
	0x0559,0x0561,0x0552,0x0540,0x04A9,0x047F,0x043F,0x0433,
	0x0419,0x0388,0x0375,0x0347,0x0335,0x0328,0x0330,0x0328,
	0x039E,0x0392,0x0347,0x0320,0x02F3,0x02E8,0x0299,0x0282,
	0x02B2,0x0272,0x0272,0x0275,0x0246,0x0253,0x0269,0x0244,
	0x01BB,0x01CD,0x01B8,0x0214,0x020E,0x01A7,0x0197,0x016D,
	0x0114,0x014B,0x0162,0x0197,0x012B,0x00BE,0x0111,0x0107,
	0x0119,0x0146,0x01E6,0x0007,0x005A,0x0043,0x0088,0x00A2,
	0x01D6,0x0159,0x0044,0x001D,0x004D,0x00B2,0x00C9,0x0085,
	0x0054,0x00AD,0x00A8,0x00F4,0x011E,0x0176,0x01FA,0x0227,
	0x01EB,0x0197,0x01C8,0x0200,0x01B0,0x01B1,0x01D9,0x019D,
	0x017D,0x01CF,0x01BB,0x0161,0x017A,0x01CA,0x020A,0x02DD,
	0x037C,0x03F3,0x04A2,0x0584,0x0687,0x06F7,0x06DE,0x0595,
	0x04DA,0x06B6,0x0A71,0x0E09,0x119D,0x13A6,0x1461,0x14DF,
	0x1512,0x14D7,0x15A1,0x1756,0x18CB,0x1A0C,0x1ABA,0x1B81,
	0x1B2A,0x1932,0x1756,0x162B,0x1650,0x172F,0x18E8,0x1C3F,
	0x1E63,0x1E35,0x1B1E,0x18A6,0x1834,0x18B4,0x1902,0x1A84,
	0x1CD7,0x1E9C,0x1E73,0x1CE8,0x1A73,0x1858,0x1B85,0x1CC2,
	0x1C2E,0x1D68,0x1E81,0x1E4E,0x1BE2,0x196B,0x180A,0x1749,
	0x17B1,0x1946,0x1BFE,0x1ECB,0x1F4B,0x1DAA,0x1A5C,0x166C,
	0x12FF,0x11E5,0x1326,0x165E,0x1AF2,0x1D9E,0x1D18,0x1997,
	0x1420,0x101F,0x0E5A,0x0F33,0x11C7,0x14E2,0x163C,0x157D,
	0x1395,0x12F3,0x1252,0x10CA,0x0F1C,0x0E6F,0x0DDE,0x0DB2,
	0x0E0A,0x0FE5,0x1199,0x1135,0x0E6F,0x0B0B,0x087F,0x076B,
	0x0838,0x0A39,0x0CE8,0x0D9C,0x0B86,0x08AD,0x0647,0x0560,
	0x04D3,0x04B5,0x06F5,0x09A0,0x0972,0x083C,0x0641,0x0483,
	0x026F,0x0012,0xFF2E,0x0130,0x0415,0x0596,0x0511,0x02DA,
	0x0092,0xFD74,0xFA7E,0xF996,0xFB32,0xFD60,0xFE1B,0xFE28,
	0xFDE1,0xFD18,0xFC2D,0xFAEA,0xF841,0xF690,0xF5CF,0xF546,
	0xF658,0xF94C,0xFBBA,0xFC49,0xFA19,0xF69A,0xF381,0xF21D,
	0xF1C8,0xF325,0xF5ED,0xF818,0xF782,0xF576,0xF438,0xF278,
	0xF08F,0xF0E7,0xF15E,0xF0B7,0xF0BB,0xF0DA,0xF1FD,0xF411,
	0xF48B,0xF250,0xEEE7,0xEC4B,0xEBD5,0xECE7,0xEE9A,0xF0C9,
	0xF1FE,0xF112,0xEED5,0xED4B,0xED28,0xEE49,0xEE87,0xED80,
	0xEC28,0xEC1D,0xED35,0xEF17,0xF0A0,0xF135,0xF023,0xED3B,
	0xEA0C,0xE944,0xEB07,0xEE10,0xF034,0xF059,0xEEFF,0xECC3,
	0xEB60,0xEB0C,0xEBDF,0xECAC,0xEC37,0xEB80,0xEAEE,0xEBC5,
	0xED99,0xEF5D,0xEF50,0xEDDE,0xEB70,0xE97D,0xE94C,0xEA8D,
	0xECB4,0xEE9A,0xEEDF,0xED2D,0xEB23,0xEAA0,0xEB9D,0xED3A,
	0xEE2A,0xED7B,0xECB9,0xEB63,0xEB30,0xEC37,0xEE6D,0xEF73,
	0xEE73,0xECF6,0xEB4B,0xEABA,0xEEA7,0xEF8B,0xEF8F,0xEFB2,
	0xEDB7,0xEC30,0xEC1A,0xEDCB,0xEFE2,0xF118,0xF08D,0xEF6A,
	0xEE3E,0xEE2B,0xEF45,0xF105,0xF202,0xF13A,0xEFC2,0xEE87,
	0xEEC0,0xEF6C,0xF065,0xF0E0,0xF154,0xF18C,0xF17C,0xF181,
	0xF136,0xF101,0xF08B,0xEEFF,0xEDD4,0xEEF7,0xF13C,0xF384,
	0xF44D,0xF3B2,0xF258,0xF0A9,0xEF87,0xEF35,0xF07E,0xF2B9,
	0xF41F,0xF3D8,0xF2B7,0xF1C2,0xF188,0xF163,0xF1F6,0xF2C4,
	0xF39E,0xF434,0xF45C,0xF382,0xF379,0xF384,0xF2BE,0xF19F,
	0xF1E6,0xF3A4,0xF5B5,0xF65B,0xF494,0xF2E7,0xF172,0xEFBB,
	0xEF7E,0xF0F0,0xF35C,0xF50A,0xF608,0xF62C,0xF63A,0xF524,
	0xF3D5,0xF351,0xF3B1,0xF45E,0xF52D,0xF653,0xF773,0xF6F5,
	0xF6D8,0xF71F,0xF6AE,0xF5AA,0xF5B6,0xF685,0xF7FB,0xF8D2,
	0xF889,0xF7FF,0xF727,0xF6A4,0xF685,0xF78A,0xF82B,0xF917,
	0xF94D,0xF95F,0xF9B3,0xF971,0xF93C,0xF8FA,0xF81C,0xF8C8,
	0xFA4D,0xF9FF,0xFAB5,0xFB26,0xFAB8,0xF9AA,0xF92C,0xF8A0,
	0xF8D8,0xF986,0xF9D2,0xFAB0,0xFB67,0xFC64,0xFD21,0xFCC2,
	0xFCFC,0xFCD0,0xFC16,0xFB42,0xFB33,0xFBC1,0xFC74,0xFC69,
	0xFC82,0xFCF6,0xFD16,0xFCAD,0xFC5A,0xFC0B,0xFC29,0xFBCB,
	0xFB41,0xFB2A,0xFBAE,0xFD1E,0xFDE4,0xFDCA,0xFCFF,0xFC40,
	0xFAEC,0xFA1A,0xFA57,0xFB74,0xFD2A,0xFDC4,0xFD2E,0xFC25,
	0xFC5B,0xFC91,0xFBBD,0xFB4B,0xFB6F,0xFB33,0xFB3D,0xFADD,
	0xFAED,0xFAEB,0xFA34,0xF922,0xF863,0xF836,0xF76B,0xF682,
	0xF60A,0xF50B,0xF421,0xF447,0xF418,0xF3F8,0xF472,0xF4C2,
	0xF3A2,0xF2F2,0xF281,0xF2CD,0xF19C,0xF2BC,0xF4CF,0xF349,
	0xF33D,0xF2D7,0xF20C,0xF177,0xF0F0,0xF07B,0xF017,0xEF58,
	0xEECE,0xEE23,0xED8F,0xED3A,0xEC5B,0xEB89,0xEB83,0xEB3E,
	0xEB27,0xEA75,0xE9DF,0xE962,0xE841,0xE7B6,0xE779,0xE73F,
	0xE768,0xE7CB,0xE732,0xE6C3,0xE6C6,0xE60D,0xE5B0,0xE5DE,
	0xE5AB,0xE580,0xE581,0xE5BC,0xE5EC,0xE5B8,0xE61A,0xE5E4,
	0xE561,0xE53D,0xE59E,0xE61D,0xE687,0xE6FB,0xE6C5,0xE6FF,
	0xE732,0xE76D,0xE762,0xE7CF,0xE804,0xE856,0xE88B,0xE8EE,
	0xE9B1,0xEB13,0xED83,0xED66,0xED10,0xED7E,0xEDE2,0xEE4A,
	0xEE6C,0xEEC5,0xEF60,0xEFAE,0xEFCF,0xF01B,0xF0CF,0xF0F7,
	0xF17F,0xF1C2,0xF204,0xF24D,0xF2A8,0xF294,0xF35C,0xF43A,
	0xF463,0xF46D,0xF534,0xF620,0xF68A,0xF70A,0xF757,0xF7D8,
	0xF7E0,0xF7D0,0xF877,0xF8EE,0xF950,0xF9E4,0xFA56,0xFABA,
	0xFAD9,0xFB66,0xFBF1,0xFC43,0xFC25,0xFC91,0xFCF6,0xFC6E,
	0xFCD3,0xFED2,0xFF65,0xFF80,0x0001,0x0010,0x005D,0x00FF,
	0x01CB,0x0225,0x0230,0x0216,0x0200,0x0267,0x0213,0x028F,
	0x0338,0x0382,0x03FD,0x0408,0x0464,0x04F1,0x0552,0x05A7,
	0x05C6,0x0664,0x0686,0x0714,0x0764,0x0780,0x078A,0x0804,
	0x0832,0x0862,0x08CF,0x098C,0x0990,0x08F8,0x08F2,0x0908,
	0x09C9,0x0A21,0x0ACA,0x0B3B,0x0B68,0x0B73,0x0B7E,0x0BCD,
	0x0BDE,0x0C0E,0x0BDF,0x0BF1,0x0C8A,0x0CAB,0x0CDC,0x0D70,
	0x0D52,0x0D29,0x0D28,0x0DDF,0x0DEF,0x0DF5,0x0DC5,0x0DC2,
	0x0DEB,0x0DCB,0x0E3D,0x0E69,0x0E6F,0x0F38,0x0F71,0x0F33,
	0x0F06,0x0F13,0x0E1D,0x0F89,0x107A,0x0EE1,0x0FF5,0x102B,
	0x1036,0x0FB7,0x105C,0x0FDD,0x0FC5,0x0FE7,0x1053,0x108D,
	0x10A0,0x10A4,0x105F,0x102F,0x0FFB,0x1045,0x1050,0x107C,
	0x1077,0x1083,0x1052,0x106F,0x1059,0x102B,0x1030,0x106E,
	0x10C8,0x10CB,0x10A3,0x108E,0x10D4,0x1087,0x10A5,0x1030,
	0x0FE2,0x0FF7,0x101E,0x1060,0x107B,0x102E,0x0FE2,0x0FB4,
	0x0F6D,0x0F99,0x0FAF,0x0FB6,0x0F64,0x0F4D,0x0F43,0x0F3D,
	0x0F41,0x0F3B,0x0EDF,0x0ED3,0x0EF8,0x0EDD,0x0F08,0x0E99,
	0x0E75,0x0DCB,0x0D75,0x0C75,0x0B05,0x0BB7,0x0C67,0x0CC8,
	0x0CA9,0x0C35,0x0BDD,0x0BCD,0x0BAA,0x0BDF,0x0BF6,0x0BD1,
	0x0BD5,0x0BB5,0x0B5C,0x0B61,0x0B7A,0x0C13,0x0B58,0x0AA1,
	0x0B25,0x0B6A,0x0AD4,0x0AD6,0x0AE8,0x0B20,0x0B53,0x0BCA,
	0x0BD5,0x0B97,0x0B89,0x0B71,0x0B7A,0x0B4F,0x0B5B,0x0BB3,
	0x0BC3,0x0BA0,0x0B73,0x0B32,0x0B36,0x0AD3,0x0A50,0x0BA5,
	0x0BB4,0x0A9A,0x09D0,0x0946,0x0915,0x0921,0x0994,0x09F6,
	0x0A3F,0x0A43,0x0ABA,0x0A67,0x09EE,0x0AB4,0x0B1D,0x0AC3,
	0x0A5E,0x0A3F,0x09DF,0x09A9,0x0960,0x0951,0x091D,0x0929,
	0x0915,0x0927,0x08FD,0x08EA,0x08A9,0x0849,0x082B,0x07D7,
	0x07B9,0x0805,0x07BA,0x0771,0x0740,0x06D0,0x067B,0x06E2,
	0x06D2,0x06E1,0x073C,0x0703,0x06A5,0x0669,0x062E,0x0651,
	0x0643,0x0657,0x067F,0x0635,0x05C0,0x058C,0x057E,0x05A2,
	0x0569,0x0527,0x054D,0x055F,0x05A3,0x0541,0x059C,0x0504,
	0x046A,0x0439,0x04DA,0x04EC,0x0495,0x0386,0x03A2,0x03DB,
	0x0393,0x0392,0x0495,0x0452,0x02BF,0x041D,0x038B,0x02CB,
	0x0306,0x0311,0x0307,0x0366,0x02F3,0x02C6,0x0272,0x023F,
	0x0247,0x0249,0x028E,0x0308,0x0313,0x02B5,0x02A5,0x0265,
	0x02A5,0x0230,0x02D5,0x0338,0x030E,0x028A,0x0249,0x0209,
	0x019F,0x01D4,0x01BC,0x0239,0x023C,0x0218,0x022A,0x01C1,
	0x01AC,0x01A0,0x015C,0x0175,0x0190,0x0219,0x01F2,0x0190,
	0x017B,0x017A,0x015F,0x012F,0x011B,0x0126,0x0112,0x00DB,
	0x00FC,0x009B,0x00BF,0x00CA,0x0106,0x00D0,0x008D,0x00F9,
	0x0104,0x029B,0x03D1,0x02D2,0x02F5,0x0315,0x026A,0x0202,
	0x01E3,0x01D5,0x01C6,0x0162,0x0174,0x018C,0x0162,0x01A2,
	0x015D,0x00D3,0x00FB,0x0134,0x00B5,0x00E9,0x01FB,0x020A,
	0x011D,0x00D4,0x00DB,0x007E,0xFF2C,0xFDAA,0xFC87,0xFDBE,
	0xFE1A,0xFE3F,0xFE46,0xFE28,0xFE47,0xFE65,0xFE0A,0xFE1C,
	0xFE4F,0xFE34,0xFE41,0xFEC3,0xFF49,0xFF27,0xFF4D,0xFF5B,
	0xFEF7,0xFED9,0x0050,0x016F,0x01D9,0x0237,0x02EB,0x0348,
	0x03F7,0x057A,0x062C,0x0755,0x08DF,0x09D7,0x0AAE,0x0B22,
	0x0BC3,0x0C2F,0x0C16,0x0C3C,0x0C93,0x0CD4,0x0CB4,0x0C3B,
	0x0CBF,0x0F25,0x0F24,0x0EE8,0x0ECE,0x0F0E,0x0FD2,0x1016,
	0x1033,0x10A4,0x10DE,0x114B,0x12CB,0x14A9,0x166C,0x1726,
	0x1674,0x154B,0x15AA,0x1698,0x1862,0x1920,0x1871,0x17E6,
	0x1735,0x173B,0x182E,0x1941,0x1A5C,0x1B19,0x1A7C,0x198E,
	0x18E4,0x18C1,0x184A,0x1808,0x17F7,0x198B,0x1B01,0x1ADA,
	0x1972,0x1829,0x17A3,0x1794,0x1818,0x1868,0x18A5,0x17DF,
	0x16B5,0x1620,0x15EA,0x164F,0x1622,0x15B8,0x1542,0x1519,
	0x1459,0x131A,0x1222,0x1172,0x113A,0x124B,0x13B8,0x1430,
	0x130B,0x10ED,0x0F1A,0x0E0E,0x0E91,0x0F43,0x1001,0x0ED9,
	0x0DB2,0x0CAE,0x0C1F,0x0CB5,0x0D83,0x0B3B,0x0886,0x0A25,
	0x0A0B,0x094D,0x08E2,0x07ED,0x06F3,0x041D,0xFF14,0xF9A1,
	0xF3B3,0xEDF7,0xE9C6,0xE8EE,0xEDFC,0xF7B7,0x018B,0x072C,
	0x06C1,0x01F6,0xFB66,0xF6BC,0xF658,0xFB05,0x0266,0x09B2,
	0x0F54,0x12CE,0x1481,0x14E3,0x13D0,0x1135,0x0E65,0x0C96,
	0x0ABB,0x083F,0x057D,0x03FE,0x0473,0x0634,0x0810,0x0845,
	0x04B3,0xFD1D,0xF3D2,0xEC5A,0xE910,0xE974,0xEBDF,0xEE7D,
	0xF080,0xF124,0xF082,0xEDF8,0xEBB6,0xE9E8,0xE93F,0xEA3D,
	0xEC29,0xEED5,0xF1E3,0xF616,0xF8BE,0xFA8D,0xFE27,0x00FB,
	0x018F,0xFFFD,0xFCE3,0xFA49,0xF958,0xFAD4,0xFDEB,0x00FD,
	0x0296,0x01EE,0xFF66,0xFB83,0xF70E,0xF336,0xEFCA,0xEDF6,
	0xEE76,0xEE12,0xED94,0xED5D,0xED18,0xEA6C,0xE833,0xE6A6,
	0xE688,0xE70A,0xE6AC,0xE5F8,0xE586,0xE5FC,0xE84C,0xECB5,
	0xF0EF,0xF2C2,0xF203,0xF09C,0xEFB5,0xEF8A,0xF122,0xF317,
	0xF439,0xF514,0xF786,0xF930,0xF9A2,0xF95A,0xF885,0xF69E,
	0xF4D8,0xF369,0xF1DE,0xF073,0xEF81,0xEF0D,0xEEE2,0xEDAE,
	0xED15,0xEC8D,0xEABB,0xE88A,0xE6AD,0xE595,0xE582,0xE639,
	0xE6FC,0xE80F,0xE8DE,0xE9EF,0xEAEA,0xEC1A,0xEC8C,0xEC98,
	0xECAC,0xED0A,0xEE6D,0xEFA2,0xF135,0xF341,0xF544,0xF5F1,
	0xF5AB,0xF5F4,0xF666,0xF64C,0xF51D,0xF456,0xF3E7,0xF3EB,
	0xF3EE,0xF3F1,0xF499,0xF44E,0xF30B,0xF1C0,0xF090,0xF047,
	0xEF55,0xEDE5,0xECC0,0xECBE,0xEDEC,0xEF9D,0xF05E,0xEF49,
	0xEE21,0xEDF6,0xEE13,0xEF2B,0xF085,0xF205,0xF334,0xF376,
	0xF30D,0xF4B9,0xF703,0xF851,0xF7BF,0xF94E,0xF875,0xF932,
	0xF974,0xF7E4,0xF757,0xF87D,0xF9F0,0xFAFA,0xFB75,0xFA4D,
	0xF885,0xF587,0xF4A3,0xF4F5,0xF5D0,0xF55B,0xF475,0xF417,
	0xF412,0xF3C3,0xF328,0xF2BE,0xF2F1,0xF33C,0xF298,0xF2AD,
	0xF37A,0xF397,0xF362,0xF405,0xF526,0xF706,0xF820,0xF83C,
	0xF824,0xF785,0xF781,0xF7FF,0xF94D,0xFA32,0xFA9E,0xFB2F,
	0xFBA9,0xFB7E,0xFB15,0xFA4B,0xFA24,0xFA3A,0xFA04,0xF9D9,
	0xFA1E,0xFA72,0xF9C3,0xF8BA,0xF7D3,0xF805,0xF867,0xF8A9,
	0xF80C,0xF77B,0xF6CF,0xF6F0,0xF752,0xF64D,0xF686,0xF510,
	0xF0BC,0xE9E6,0xDFC3,0xD1A9,0xC259,0xBEBF,0xBF6E,0xBF22,
	0xC2A4,0xDC4C,0xF87C,0x06CF,0x0500,0xF661,0xE684,0xDE62,
	0xE25C,0xF2D6,0x088E,0x1C48,0x2A52,0x340C,0x39AB,0x3B8D,
	0x3A57,0x3664,0x3055,0x29CB,0x22D3,0x1C7E,0x1876,0x187A,
	0x1C30,0x22AB,0x263E,0x2345,0x1650,0x0185,0xEAFC,0xDA1D,
	0xD3CD,0xD74C,0xDECF,0xE744,0xEC24,0xEC1B,0xE94B,0xE60D,
	0xE323,0xE108,0xE161,0xE414,0xE865,0xEEDC,0xF700,0x012A,
	0x0C43,0x16EA,0x1F9E,0x235F,0x21CB,0x1BE9,0x14D6,0x102D,
	0x1137,0x1784,0x202E,0x2715,0x2934,0x2594,0x1CFA,0x1250,
	0x0842,0x008D,0xFAC4,0xF681,0xF315,0xF128,0xF03A,0xEFE0,
	0xEF1D,0xEE26,0xEBFD,0xE916,0xE565,0xE0C3,0xDD0E,0xDC04,
	0xDEC9,0xE54A,0xEF84,0xFA49,0x0225,0x048E,0x02B1,0xFFF7,
	0xFEEE,0x007E,0x051F,0x0AB2,0x1009,0x1417,0x170F,0x185D,
	0x1960,0x1935,0x161B,0x115F,0x0C94,0x0864,0x0442,0x0094,
	0xFE83,0xFD89,0xFD6C,0xFE31,0xFDC2,0xF8F9,0xF420,0xED6D,
	0xE62E,0xE379,0xE430,0xE7A0,0xEC3A,0xEF75,0xF173,0xF292,
	0xF361,0xF40E,0xF52E,0xF6E8,0xF9BC,0xFC9F,0xFEF3,0x0144,
	0x0442,0x0874,0x0CE1,0x101B,0x11C7,0x1208,0x102A,0x0D71,
	0x096A,0x0728,0x0698,0x07BD,0x0919,0x0858,0x0688,0x0390,
	0x0027,0xFBE1,0xF768,0xF469,0xF219,0xF043,0xEF24,0xEEE8,
	0xF04F,0xF137,0xF17D,0xF1CF,0xF25F,0xF27C,0xF266,0xF1AB,
	0xF239,0xF49C,0xF87C,0xFC84,0xFFAD,0x0272,0x0472,0x058F,
	0x0619,0x06B9,0x07C8,0x09A6,0x098D,0x0A78,0x0B9F,0x0C7F,
	0x0C6C,0x0B66,0x09C7,0x0852,0x0655,0x0405,0x0140,0xFE4F,
	0xFBF2,0xFAF4,0xFA8F,0xFA7D,0xFA92,0xF960,0xF784,0xF6C9,
	0xF63F,0xF4F8,0xF417,0xF43B,0xF510,0xF75A,0xFA57,0xFC75,
	0xFE08,0xFEE2,0xFF41,0xFF8F,0x0063,0x0189,0x02F1,0x03C5,
	0x0529,0x0689,0x07DB,0x08F6,0x0958,0x08BB,0x0841,0x06B4,
	0x0450,0x0387,0x0389,0x02E1,0x0219,0x01DF,0x0109,0xFFC6,
	0xFE74,0xFCF1,0xFB4D,0xF9C5,0xF832,0xF6BC,0xF572,0xF499,
	0xF5F2,0xF735,0xF5E2,0xEFB2,0xE524,0xD7DC,0xC7C3,0xBE98,
	0xBE46,0xBF15,0xBE14,0xC9C7,0xEBDC,0x060D,0x10B1,0x0942,
	0xF6A7,0xE65F,0xE220,0xED35,0x026F,0x1A13,0x2C37,0x3921,
	0x3E52,0x3E17,0x3E31,0x3E68,0x3C53,0x34BB,0x2D52,0x251E,
	0x1E45,0x1A71,0x1B39,0x1FAA,0x257B,0x27CF,0x211A,0x101C,
	0xF7A3,0xDFA0,0xD07B,0xCD98,0xD477,0xDFB6,0xE8E9,0xED33,
	0xEC7A,0xE7EA,0xE362,0xE138,0xE180,0xE38A,0xE7BB,0xECF1,
	0xF4D2,0xFF2B,0x09C6,0x133A,0x1EEA,0x26C0,0x2858,0x270F,
	0x203D,0x1910,0x152B,0x1727,0x1E0E,0x2705,0x2D5E,0x2E3D,
	0x27B4,0x1C23,0x0FB9,0x05A9,0xFEAD,0xF91A,0xF542,0xF237,
	0xF0EC,0xEF2C,0xEDEA,0xED29,0xEC54,0xEAA4,0xE741,0xE2D2,
	0xDEB6,0xDD4C,0xDED5,0xE368,0xEB7D,0xF5C6,0xFF83,0x0614,
	0x07E9,0x0758,0x0635,0x05F9,0x083D,0x0C8C,0x1214,0x16EF,
	0x1A0D,0x1C39,0x1DF2,0x1DD6,0x1C28,0x1802,0x12A1,0x0D2D,
	0x07BD,0x0334,0xFFDC,0xFE75,0xFE5D,0xFDEA,0xFCFC,0xFB16,
	0xF6D0,0xF014,0xE94D,0xE402,0xE1AD,0xE2E4,0xE7FE,0xEC5E,
	0xEF36,0xF070,0xF1E8,0xF43F,0xF693,0xF877,0xF9AD,0xFB0A,
	0xFD34,0x0011,0x04D3,0x0A37,0x0E94,0x121C,0x1402,0x1343,
	0x1217,0x1109,0x0E59,0x0AB3,0x086C,0x0829,0x09E4,0x0B69,
	0x0AEA,0x07AE,0x02D6,0xFDC4,0xF9AD,0xF6C0,0xF428,0xF236,
	0xF0CA,0xF03B,0xF0B2,0xF1C3,0xF2C0,0xF374,0xF418,0xF47D,
	0xF5E8,0xF5C1,0xF545,0xF632,0xF870,0xFC9D,0x018A,0x05EB,
	0x095F,0x0B38,0x0B7C,0x0B78,0x0BE7,0x0CA2,0x0E10,0x0F78,
	0x0FBB,0x0FD5,0x0F88,0x0E84,0x0D8F,0x0C50,0x0A57,0x07CB,
	0x0516,0x0276,0xFFEF,0xFD8E,0xFB9B,0xFAE6,0xFB10,0xFBF1,
	0xFC2E,0xFA84,0xF780,0xF53D,0xF4A8,0xF5E2,0xF83A,0xFABB,
	0xFC71,0xFD67,0xFE45,0x0002,0x01C1,0x0364,0x057F,0x0699,
	0x0739,0x0797,0x0840,0x0937,0x0A39,0x0AFB,0x0BBF,0x0C5F,
	0x0C8A,0x0C06,0x0A08,0x06E7,0x0481,0x0364,0x032A,0x0388,
	0x02F0,0x016E,0xFF1A,0xFD52,0xFBFC,0xFAD3,0xF9CA,0xF991,
	0xF94A,0xF898,0xF8BD,0xF9F4,0xFA40,0xF8CF,0xF7E5,0xF1B7,
	0xE7B9,0xDAE8,0xC9BE,0xBFC5,0xC009,0xC095,0xC0DB,0xD73F,
	0xFA58,0x108F,0x14F8,0x0882,0xF51A,0xE7EF,0xE7AC,0xF4FD,
	0x0A8D,0x20B5,0x321F,0x3CC4,0x3F43,0x3F52,0x3F64,0x3F56,
	0x3B59,0x331B,0x2B83,0x243E,0x1EF1,0x1B67,0x1C5C,0x2114,
	0x272D,0x2812,0x1FB1,0x0D45,0xF4E6,0xDDFB,0xD02E,0xCF58,
	0xD887,0xE4A4,0xED7E,0xF146,0xF002,0xEADF,0xE4AF,0xE129,
	0xE1BD,0xE5C8,0xEAA2,0xF04E,0xF898,0x02BE,0x0DB5,0x17FF,
	0x210D,0x2824,0x2BF5,0x28F4,0x2057,0x1896,0x159B,0x18FA,
	0x206C,0x292D,0x2E47,0x2DA4,0x25E4,0x1AAF,0x0EDA,0x047D,
	0xFC21,0xF6AE,0xF337,0xF1E1,0xF1C3,0xF13D,0xEFBE,0xEE79,
	0xEBE9,0xE88B,0xE580,0xE2AA,0xDFA7,0xDE76,0xDF75,0xE461,
	0xED9A,0xF8EA,0x02A6,0x07DB,0x0871,0x072A,0x04E7,0x042C,
	0x0641,0x0A95,0x1055,0x1574,0x1954,0x1C4D,0x1CFC,0x1A56,
	0x15B0,0x1215,0x0DB5,0x08A5,0x035D,0xFF3A,0xFCDA,0xFB96,
	0xFB75,0xFBAB,0xFA1E,0xF68D,0xF118,0xEA13,0xE342,0xDF3B,
	0xDEBB,0xE1F1,0xE5F9,0xE9C4,0xEC2D,0xEE9A,0xF122,0xF3BA,
	0xF4C6,0xF4A7,0xF4ED,0xF67A,0xFA5E,0xFF7A,0x04B6,0x08F9,
	0x0B98,0x0C6F,0x0D80,0x0EB4,0x0F0C,0x0D02,0x094D,0x05F9,
	0x0415,0x0409,0x0508,0x0554,0x0478,0x01DA,0xFD81,0xFA33,
	0xF763,0xF3CC,0xEF24,0xEB9D,0xEAB1,0xEC9B,0xEEB9,0xEF88,
	0xEF1F,0xEED9,0xEE86,0xEE48,0xEF38,0xF0E0,0xF25C,0xF3AE,
	0xF5EF,0xF967,0xFD45,0x006E,0x02E4,0x04C2,0x067C,0x0719,
	0x075D,0x0771,0x0619,0x0526,0x07DA,0x07D6,0x089A,0x090F,
	0x0785,0x05BF,0x031F,0xFFBE,0xFCE7,0xFBA0,0xF9BE,0xF7A6,
	0xF63C,0xF73F,0xF817,0xF792,0xF4B8,0xF1DF,0xF0F4,0xF176,
	0xF280,0xF359,0xF4D5,0xF574,0xF5BB,0xF742,0xFA13,0xFD57,
	0xFF2B,0xFF85,0xFF33,0xFF8A,0x0100,0x02E3,0x0394,0x0508,
	0x0746,0x08BC,0x0932,0x08BE,0x079D,0x066D,0x049B,0x02C8,
	0x0210,0x01BD,0x0171,0x006A,0xFF1A,0xFDB2,0xFCB6,0xFB11,
	0xF9BE,0xF8D8,0xF86C,0xF811,0xF720,0xF64B,0xF668,0xF7CC,
	0xF89B,0xF784,0xF46A,0xED72,0xE0CE,0xD131,0xC20B,0xBEBF,
	0xBF6F,0xBF54,0xC239,0xDE70,0xFE0A,0x0F8D,0x0F3B,0x006A,
	0xEF0D,0xE538,0xE854,0xF72D,0x0D71,0x2370,0x3486,0x3D8D,
	0x3F1D,0x3F77,0x3F2F,0x3F54,0x3A66,0x314A,0x288A,0x20FD,
	0x1B9B,0x1AE4,0x1F12,0x265C,0x2BC4,0x2873,0x1A8D,0x044C,
	0xEC95,0xDA06,0xD180,0xD404,0xDDD1,0xE83E,0xEE75,0xF1D6,
	0xF043,0xEB25,0xE706,0xE468,0xE44B,0xE6CD,0xEB51,0xF1F0,
	0xFB58,0x06AB,0x133B,0x1E8E,0x2729,0x2B79,0x2AEC,0x24C2,
	0x1CFB,0x1714,0x16AA,0x1B6F,0x235A,0x2B34,0x2FD9,0x2E3A,
	0x25A6,0x188A,0x0BE7,0x0221,0xFB52,0xF724,0xF51A,0xF3BE,
	0xF269,0xF12B,0xF07B,0xF07B,0xEF72,0xEC58,0xE771,0xE215,
	0xDF04,0xDF4A,0xE30E,0xEA52,0xF3F8,0xFDB3,0x057E,0x09D3,
	0x0ACD,0x0912,0x067C,0x0547,0x07A0,0x0D49,0x1499,0x1A91,
	0x1E2E,0x1F9C,0x1F44,0x1D13,0x1968,0x14F5,0x106A,0x0BB2,
	0x06B8,0x02A1,0x0049,0xFF62,0xFEB6,0xFD57,0xFBE7,0xF95C,
	0xF466,0xEDC8,0xE850,0xE597,0xE3C1,0xE64D,0xEAEC,0xEE73,
	0xF32A,0xF60F,0xF753,0xF835,0xF90C,0xF9C1,0xFB6A,0xFDE8,
	0x01B2,0x0537,0x092A,0x0CC4,0x103B,0x1354,0x1457,0x13C7,
	0x11E9,0x0FC6,0x0CF0,0x0A85,0x09BC,0x09E9,0x097C,0x089A,
	0x07AB,0x05EC,0x026D,0xFD59,0xF886,0xF51A,0xF2EA,0xF0C7,
	0xF08E,0xF0B8,0xF162,0xF195,0xF22B,0xF2AE,0xF325,0xF33E,
	0xF3F2,0xF47C,0xF5F4,0xF799,0xF9E1,0xFCF1,0x0082,0x04F1,
	0x083F,0x09D7,0x09CC,0x08EE,0x078E,0x0745,0x08D3,0x0B15,
	0x0CBE,0x0D0E,0x0DBC,0x0C2A,0x0AE0,0x087C,0x062C,0x0377,
	0x00F3,0xFEBC,0xFC30,0xFA7F,0xF9C2,0xF92D,0xF8BC,0xF86D,
	0xF83D,0xF84B,0xF6B1,0xF4CB,0xF3B2,0xF3DA,0xF5C4,0xF810,
	0xF97F,0xFB5A,0xFE66,0xFFDD,0x001D,0xFFCB,0x005C,0x01B8,
	0x0422,0x05BE,0x0773,0x0884,0x083D,0x0784,0x06ED,0x0773,
	0x07F0,0x06FE,0x04AB,0x0228,0x003E,0xFFE8,0xFF04,0xFCEC,
	0xFCDB,0xFCE7,0xFC04,0xFA99,0xF807,0xF5FF,0xF52E,0xF4FB,
	0xF4D4,0xF3FC,0xF474,0xF4F4,0xF3AA,0xEE08,0xE4D2,0xD8D1,
	0xC908,0xBEC1,0xBE35,0xBEBD,0xBE54,0xC47C,0xE323,0x0172,
	0x103C,0x0BBD,0xF95F,0xE7A9,0xE145,0xE98A,0xFC7D,0x1330,
	0x2751,0x36B2,0x3DB7,0x3E26,0x3E17,0x3E5B,0x3CE1,0x3437,
	0x2B3D,0x244F,0x1E76,0x1A42,0x197A,0x1D7E,0x243F,0x280B,
	0x235C,0x1339,0xFBAC,0xE2A4,0xD150,0xCBF4,0xD258,0xDE43,
	0xE86D,0xED01,0xECD7,0xEA0D,0xE6F3,0xE3E8,0xE0A8,0xDFAB,
	0xE20A,0xE87C,0xF21C,0xFD62,0x08AC,0x138B,0x1BE3,0x22D4,
	0x274D,0x2706,0x20AC,0x1975,0x12B5,0x1069,0x1853,0x2274,
	0x2A6F,0x2C36,0x2728,0x1CA8,0x1035,0x0410,0xFBB1,0xF631,
	0xF211,0xEFA7,0xEE41,0xEE44,0xEDFA,0xED68,0xEB53,0xE8CA,
	0xE5CF,0xE2D6,0xDF1D,0xDC5C,0xDCF0,0xE145,0xE965,0xF335,
	0xFD04,0x0409,0x07AC,0x079B,0x05BB,0x0419,0x0510,0x0897,
	0x0D08,0x1228,0x1715,0x1BA6,0x1D88,0x1C5B,0x1904,0x14C3,
	0x1013,0x0BC5,0x0788,0x034B,0xFFAE,0xFCED,0xFB8F,0xFB23,
	0xFB55,0xFA09,0xF586,0xEF23,0xE894,0xE41D,0xE292,0xE3B4,
	0xE62B,0xE928,0xEC3B,0xEDCC,0xF064,0xF3B8,0xF4F1,0xF4F3,
	0xF576,0xF721,0xFA07,0xFE34,0x02E4,0x0758,0x0AD1,0x0D70,
	0x1001,0x11DB,0x118A,0x0FAD,0x0C06,0x09B3,0x07BA,0x06ED,
	0x0810,0x087E,0x07D9,0x059B,0x0248,0xFDFA,0xF9EA,0xF63C,
	0xF2F5,0xF0CD,0xEF72,0xEF51,0xF010,0xF0D7,0xF1DA,0xF2E1,
	0xF3B0,0xF41F,0xF401,0xF421,0xF543,0xF63A,0xF83F,0xFCDC,
	0x002A,0x0441,0x07FE,0x0A6D,0x0A8C,0x0A3A,0x0A09,0x09EC,
	0x0A18,0x0B13,0x0CCC,0x0E06,0x0DB9,0x0D77,0x0CBF,0x0AE8,
	0x080A,0x04CE,0x01AC,0xFF72,0xFD7F,0xFBC2,0xFA2C,0xF9E2,
	0xF96A,0xF90C,0xF899,0xF81D,0xF6B4,0xF48E,0xF2C4,0xF311,
	0xF51B,0xF705,0xF851,0xF9F3,0xFC10,0xFE42,0x0019,0x0129,
	0x01D4,0x02C1,0x03E3,0x0478,0x04E1,0x0613,0x0732,0x08BA,
	0x09F9,0x0A7F,0x0A7C,0x08E7,0x0615,0x0394,0x0223,0x014A,
	0x00F4,0x0089,0xFFF3,0xFF7B,0xFF08,0xFD7B,0xFB94,0xF965,
	0xF7C9,0xF603,0xF637,0xF772,0xF7E6,0xF723,0xF685,0xF61D,
	0xF4BE,0xF11A,0xE990,0xDC51,0xC9AC,0xC0BB,0xC00C,0xC06E,
	0xBFC9,0xCF19,0xF1D7,0x0BD3,0x14ED,0x0B23,0xF75D,0xE6AE,
	0xE28B,0xED81,0x0303,0x1A8E,0x2DF1,0x3A76,0x3EE7,0x3F44,
	0x3F36,0x3F47,0x3B37,0x32E7,0x2AE8,0x23BC,0x1D77,0x1923,
	0x1934,0x1E66,0x257E,0x28A9,0x21DE,0x1012,0xF7AB,0xDF77,
	0xCEF5,0xCB99,0xD3D8,0xE0D7,0xEB56,0xEFCB,0xEE72,0xEA95,
	0xE5AF,0xE219,0xE0FC,0xE268,0xE6B9,0xECA4,0xF48D,0xFE8E,
	0x09AA,0x14A7,0x1ECE,0x25B6,0x27D2,0x253A,0x1EC3,0x169D,
	0x11FA,0x14D9,0x1C45,0x257C,0x2D6B,0x2F65,0x2947,0x1D47,
	0x0F67,0x044E,0xFC4A,0xF750,0xF446,0xF1E1,0xF0C0,0xF00A,
	0xEFE1,0xEF2B,0xED91,0xEA7A,0xE5DF,0xE186,0xDF25,0xDD69,
	0xDDE6,0xE2E5,0xEBDD,0xF67F,0x00C4,0x0736,0x08A9,0x0669,
	0x037B,0x0247,0x0469,0x0948,0x0EE3,0x13F0,0x17C1,0x1A5C,
	0x1BE4,0x1B41,0x1864,0x132C,0x0D35,0x079C,0x02C8,0xFF3A,
	0xFE5D,0xFD0F,0xFB45,0xF9E2,0xF90A,0xF776,0xF492,0xEEC8,
	0xE6F3,0xDFAB,0xDC8C,0xDF4A,0xE57F,0xEB01,0xEF62,0xF07D,
	0xF0E5,0xF22F,0xF31A,0xF435,0xF55E,0xF7F8,0xFBA1,0x0064,
	0x052F,0x0933,0x0C69,0x0E6E,0x1005,0x1108,0x1154,0x0F67,
	0x0C1F,0x0872,0x05F1,0x0579,0x0724,0x08DF,0x090B,0x0624,
	0x013A,0xFC95,0xF851,0xF4F3,0xF201,0xEF5D,0xEE65,0xEEDB,
	0xF073,0xF22D,0xF36D,0xF37B,0xF240,0xF126,0xF1B6,0xF333,
	0xF50C,0xF663,0xF77B,0xFA3D,0xFEAB,0x0394,0x06E3,0x0888,
	0x0893,0x07B2,0x07E0,0x087F,0x09F0,0x0AAE,0x0A0F,0x09EC,
	0x0A9B,0x0ABA,0x09D8,0x09D4,0x0480,0x00F8,0xFE7B,0xFC30,
	0xFB94,0xFB34,0xFA07,0xF89B,0xF77F,0xF68E,0xF6CD,0xF69B,
	0xF634,0xF49C,0xF3E2,0xF445,0xF54A,0xF678,0xF827,0xFA33,
	0xFCDA,0xFF24,0x001A,0x010B,0x01B4,0x0252,0x02B3,0x03C5,
	0x0575,0x07BF,0x0890,0x088B,0x083C,0x087F,0x08B5,0x07CB,
	0x05F7,0x0436,0x02B9,0x01D5,0x011B,0x0088,0xFFB9,0xFE48,
	0xFCBA,0xFBC1,0xFB1A,0xFA43,0xF877,0xF6B3,0xF5CF,0xF5E7,
	0xF753,0xF930,0xFA20,0xF909,0xF59E,0xEF99,0xE786,0xDD07,
	0xCFC9,0xC24F,0xBF9F,0xBEDF,0xC396,0xDC63,0xF882,0x0BCD,
	0x0EB9,0x030B,0xF2D5,0xE879,0xE998,0xF5FC,0x0841,0x1A7E,
	0x2866,0x318C,0x377A,0x39D3,0x3987,0x3517,0x2D88,0x2695,
	0x20D1,0x1BDD,0x173E,0x14EF,0x15C8,0x19C0,0x1F1A,0x20DB,
	0x19A3,0x093C,0xF3D4,0xE106,0xD723,0xD86D,0xE13B,0xEB8E,
	0xF1C6,0xF394,0xF288,0xEFE6,0xECDE,0xEA4B,0xE970,0xEB3D,
	0xEE69,0xF483,0xFC32,0x0418,0x0BEF,0x1415,0x1BEF,0x2202,
	0x242F,0x20BD,0x18D7,0x10E6,0x0E57,0x12D5,0x1AE1,0x22EA,
	0x273C,0x2514,0x1DC8,0x13FA,0x0A2C,0x023D,0xFC00,0xF6AC,
	0xF3A6,0xF346,0xF3C2,0xF352,0xF192,0xEF9C,0xEEAF,0xEE0C,
	0xEC29,0xE8BD,0xE4AC,0xE270,0xE3C6,0xE930,0xF18D,0xFB27,
	0x02BF,0x06CD,0x0737,0x05B2,0x043C,0x0377,0x0479,0x073E,
	0x0BAC,0x10B4,0x14BB,0x16B6,0x16BD,0x15B4,0x134C,0x0EF5,
	0x0AFC,0x06F3,0x0309,0xFED1,0xFC05,0xFB83,0xFC03,0xFC20,
	0xFAEA,0xF882,0xF544,0xF07B,0xEB13,0xE76C,0xE65C,0xE77E,
	0xEB04,0xEFD2,0xF42A,0xF584,0xF7BA,0xF89F,0xF6F9,0xF794,
	0xF974,0xFC1F,0xFEF3,0x0147,0x04A2,0x07B5,0x0AC8,0x0D43,
	0x0E39,0x0E12,0x0D69,0x0BCC,0x08A7,0x05BF,0x0487,0x04E9,
	0x04D5,0x0487,0x0358,0x01E1,0xFF27,0xFC27,0xF842,0xF514,
	0xF338,0xF1CC,0xF09B,0xF0CA,0xF210,0xF313,0xF31D,0xF2F8,
	0xF364,0xF431,0xF4C6,0xF507,0xF535,0xF67F,0xF8F5,0xFBC5,
	0xFEE7,0x01E7,0x04BD,0x0697,0x0778,0x06CA,0x0564,0x0522,
	0x05AA,0x0616,0x0754,0x084E,0x08C4,0x081A,0x05FD,0x03EE,
	0x0366,0x0389,0x00A4,0xFE85,0xFCF9,0xFB83,0xFA2C,0xF9AA,
	0xF969,0xF938,0xF893,0xF7B4,0xF6FD,0xF63F,0xF56A,0xF508,
	0xF545,0xF6EC,0xF986,0xFC00,0xFDC2,0xFFE5,0x00FA,0x00A5,
	0xFFF0,0x005A,0x0153,0x02DE,0x04D0,0x0576,0x05A8,0x0616,
	0x05DC,0x0634,0x0608,0x04B5,0x03B1,0x01EB,0x0089,0xFF13,
	0xFDFE,0xFD9D,0xFD52,0xFC91,0xFC6D,0xFB79,0xF970,0xF7A2,
	0xF76E,0xF6D4,0xF6A2,0xF74A,0xF6B6,0xF6B2,0xF795,0xF813,
	0xF6A7,0xF25A,0xECEC,0xE791,0xE23A,0xDF16,0xE1FC,0xE994,
	0xF4A5,0xFF3F,0x0563,0x056F,0x015A,0xFBF6,0xF90D,0xFA2C,
	0xFF39,0x05F0,0x0BA9,0x0FB1,0x12C3,0x1569,0x16F5,0x168B,
	0x1406,0x100D,0x0C3F,0x08EB,0x0626,0x03D8,0x03AA,0x050B,
	0x06CE,0x07FF,0x07F9,0x04BB,0xFE92,0xF631,0xEF28,0xED13,
	0xEF42,0xF2E8,0xF61D,0xF84E,0xF8FC,0xF90A,0xF8FB,0xF943,
	0xF99C,0xF8BC,0xF817,0xF97F,0xFCFB,0x00A7,0x04EC,0x088E,
	0x0AB6,0x0C26,0x0CD7,0x0C9E,0x0BE7,0x09D6,0x072C,0x0651,
	0x067C,0x06E5,0x0ADF,0x0D47,0x0B17,0x096D,0x053F,0x0186,
	0xFF25,0xFD6D,0xFBBB,0xFA6F,0xF969,0xF8BE,0xF7F1,0xF729,
	0xF687,0xF58A,0xF48C,0xF358,0xF22A,0xF141,0xF113,0xF1CD,
	0xF364,0xF5C8,0xF884,0xFB19,0xFBF4,0xFBE7,0xFC15,0xFC3C,
	0xFC53,0xFCA1,0xFCC8,0xFD4C,0xFDA6,0xFDDB,0xFDFF,0xFDCF,
	0xFD28,0xFBF3,0xFB64,0xFAB8,0xF999,0xF8A7,0xF77F,0xF6A3,
	0xF5E5,0xF53C,0xF45E,0xF3C8,0xF2CF,0xF1DE,0xF082,0xEF85,
	0xEF25,0xEE60,0xEDFD,0xED5B,0xED58,0xEC93,0xEC13,0xEBB8,
	0xEB60,0xEADE,0xE8C8,0xE6EB,0xE74F,0xE752,0xE7A1,0xE7DD,
	0xE7F0,0xE80A,0xE82C,0xE77B,0xE70E,0xE6BD,0xE67F,0xE679,
	0xE637,0xE5ED,0xE609,0xE650,0xE6F3,0xE641,0xE587,0xE610,
	0xE6B7,0xE674,0xE69C,0xE6F1,0xE708,0xE6F0,0xE771,0xE7D6,
	0xE86E,0xE881,0xE8AE,0xE93B,0xE9C1,0xE9E4,0xEA61,0xEB12,
	0xEB4B,0xEBCB,0xEC1C,0xEC9D,0xED37,0xEDD4,0xEF2D,0xEE76,
	0xEE35,0xEEAF,0xEEC6,0xEF45,0xEFE8,0xF079,0xF0A2,0xF122,
	0xF214,0xF2F5,0xF3ED,0xF455,0xF54F,0xF5D0,0xF59A,0xF5BE,
	0xF5EB,0xF656,0xF694,0xF6E7,0xF7D7,0xF85F,0xF866,0xF898,
	0xF8CC,0xF971,0xFA11,0xFAB5,0xFAEF,0xFB77,0xFBE6,0xFC82,
	0xFCFE,0xFD22,0xFD62,0xFE36,0xFE67,0xFEDA,0xFF7D,0xFFB2,
	0xFFB5,0x0000,0x005C,0x00CB,0x0127,0x0185,0x0234,0x0278,
	0x025B,0x0292,0x029D,0x031D,0x0358,0x039B,0x03AE,0x03D7,
	0x0411,0x04C1,0x04C7,0x0520,0x052D,0x05E0,0x0652,0x0669,
	0x0692,0x06A7,0x06CD,0x074F,0x071F,0x07F8,0x0842,0x0883,
	0x08BC,0x0954,0x08C1,0x07FB,0x0A23,0x09A0,0x09AC,0x0A7F,
	0x0A77,0x0A9A,0x0A9D,0x0AA6,0x0AAF,0x0ACB,0x0B23,0x0B2C,
	0x0B31,0x0B2A,0x0B17,0x0B40,0x0B71,0x0B5F,0x0B91,0x0C02,
	0x0C6C,0x0C12,0x0C27,0x0C3C,0x0C2B,0x0CD4,0x0CF5,0x0CF8,
	0x0D44,0x0D14,0x0CB0,0x0C98,0x0CEB,0x0D10,0x0D24,0x0D43,
	0x0D30,0x0CFA,0x0CF6,0x0D34,0x0D45,0x0DB6,0x0D7B,0x0D7C,
	0x0D46,0x0DA1,0x0D81,0x0D07,0x0D5C,0x0D88,0x0DA6,0x0D53,
	0x0D65,0x0D29,0x0D02,0x0CE8,0x0CF7,0x0CFC,0x0D6D,0x0DAB,
	0x0F4F,0x100A,0x0F5C,0x0EF4,0x0EDB,0x0EBF,0x0E96,0x0E77,
	0x0E8A,0x0EBE,0x0E6D,0x0E62,0x0E64,0x0E50,0x0E93,0x0E6C,
	0x0DF2,0x0E32,0x0DF7,0x0D3C,0x0D28,0x0DCD,0x0DDF,0x0CFE,
	0x0CF6,0x0D2F,0x0C8E,0x0C8E,0x0CB6,0x0CC6,0x0C90,0x0C6A,
	0x0C0A,0x0BEC,0x0BCA,0x0BAC,0x0BA2,0x0BA4,0x0B26,0x0B2F,
	0x0AFD,0x0AC9,0x0ABA,0x0AB5,0x0ABC,0x09FC,0x095D,0x0A77,
	0x0AF3,0x0AD2,0x0AC8,0x0AE2,0x0A87,0x0AD2,0x0AC1,0x0A48,
	0x09D1,0x0944,0x08C6,0x0900,0x0830,0x07FC,0x0855,0x081E,
	0x082C,0x0821,0x07AA,0x07E0,0x07E8,0x07BA,0x07AF,0x07CA,
	0x0778,0x0769,0x07B5,0x076F,0x07E6,0x0820,0x079A,0x0762,
	0x0774,0x073B,0x06F4,0x06CD,0x06F3,0x0707,0x073E,0x0770,
	0x06F2,0x06C2,0x06FC,0x0678,0x0635,0x0632,0x05B3,0x05F3,
	0x05FF,0x0632,0x065E,0x05F6,0x05F3,0x061C,0x0631,0x05F7,
	0x05AC,0x0550,0x0512,0x0471,0x0422,0x041F,0x0442,0x041D,
	0x0413,0x0433,0x0429,0x0433,0x046C,0x0435,0x0415,0x0426,
	0x03AC,0x035D,0x05A5,0x040E,0x0471,0x04FE,0x0430,0x03F5,
	0x03ED,0x03EB,0x03BA,0x0408,0x03F5,0x0428,0x0409,0x03F6,
	0x03DB,0x0416,0x03F0,0x0372,0x0391,0x03D6,0x03B6,0x0355,
	0x0379,0x03BF,0x03EB,0x03D9,0x0382,0x036B,0x03C8,0x03C3,
	0x03CF,0x0384,0x0300,0x0307,0x035F,0x038C,0x0319,0x0350,
	0x0291,0x02BE,0x02D0,0x02A1,0x02D1,0x02CE,0x028D,0x0290,
	0x0296,0x0209,0x0226,0x021E,0x025E,0x0209,0x021F,0x01DA,
	0x01C3,0x01CB,0x0246,0x01F0,0x01D1,0x0191,0x01AB,0x01DC,
	0x01D1,0x0109,0xFF3A,0x008F,0xFF91,0xFFAB,0xFFF6,0xFF82,
	0xFFB0,0xFF42,0xFF56,0xFEEC,0xFE83,0xFEAA,0xFEDF,0xFEE4,
	0xFEFC,0xFF1C,0xFF25,0xFF5D,0xFED8,0xFF23,0xFEF1,0xFECF,
	0xFEF2,0xFF11,0xFE8E,0xFDEE,0xFEEE,0xFF49,0xFF35,0xFF6D,
	0xFF9B,0xFF5B,0xFF80,0xFF70,0xFF84,0xFF45,0xFECB,0xFF2E,
	0xFEAC,0xFDBE,0xFD9D,0xFDD4,0xFDDA,0xFDCC,0xFDFE,0xFDF0,
	0xFDE0,0xFDEA,0xFDDD,0xFD7E,0xFD9E,0xFDC0,0xFDA7,0xFD94,
	0xFDD0,0xFE58,0xFEB3,0xFE91,0xFDEF,0xFE3F,0xFE46,0xFE9D,
	0xFEBD,0xFE44,0xFE62,0xFE89,0xFEC4,0xFEAC,0xFED1,0xFEF1,
	0xFF31,0xFF0C,0xFECB,0xFEF8,0xFF19,0xFF22,0xFEE1,0xFED5,
	0xFF21,0xFF3D,0xFEF7,0xFEEC,0xFEDA,0xFEA8,0xFE5A,0xFE8A,
	0xFE8C,0xFE3F,0xFDFE,0xFE4D,0xFE23,0xFE81,0xFEA9,0xFE93,
	0xFEB1,0xFEBE,0xFE47,0xFE3A,0xFE68,0xFDBC,0xFE07,0xFF6E,
	0xFDA4,0xFE8F,0xFEDD,0xFE48,0xFE01,0xFE84,0xFE4C,0xFE3D,
	0xFE45,0xFE74,0xFEBE,0xFE7C,0xFE76,0xFE67,0xFE9C,0xFE93,
	0xFEDC,0xFEBD,0xFEBA,0xFEDC,0xFE84,0xFE0B,0xFE24,0xFE2B,
	0xFDB4,0xFD4B,0xFCE9,0xFD07,0xFCB7,0xFCAD,0xFC84,0xFC6A,
	0xFC37,0xFC32,0xFC09,0xFBC9,0xFC19,0xFBB2,0xFB48,0xFB63,
	0xFB7E,0xFB10,0xFB31,0xFB3C,0xFAE4,0xFAC5,0xFACF,0xFABC,
	0xFAF0,0xFABD,0xFAC9,0xFAA9,0xFA98,0xFA78,0xFA21,0xFA13,
	0xFA63,0xFA18,0xF9DE,0xF9C4,0xFA0E,0xFA40,0xF8B7,0xF70C,
	0xF774,0xF796,0xF7C3,0xF823,0xF888,0xF8A1,0xF8EF,0xF8FF,
	0xF8D5,0xF8CF,0xF8EA,0xF8B3,0xF8AD,0xF8D8,0xF91C,0xF950,
	0xF9BB,0xF9BA,0xF8D6,0xF9A0,0xFA6B,0xFA7E,0xFA5A,0xFAD0,
	0xFAB3,0xFA96,0xFAFF,0xFB31,0xFB96,0xFB95,0xFB85,0xFC1A,
	0xFC18,0xFC45,0xFC46,0xFC67,0xFC3D,0xFC8A,0xFCE2,0xFD31,
	0xFD47,0xFD38,0xFE79,0xFE43,0xFD00,0xFD12,0xFD33,0xFDC6,
	0xFDEA,0xFDD7,0xFD86,0xFE1B,0xFE67,0xFE91,0xFF08,0xFF7E,
	0x0026,0x00BB,0x0064,0x008F,0x0057,0x0018,0x004C,0x001E,
	0x002F,0x0047,0x004C,0x0085,0x0054,0x007E,0x00CD,0x00E2,
	0x00BF,0x00FF,0x014A,0x0150,0x0128,0x0107,0x00B4,0x011C,
	0x016F,0x0155,0x0185,0x0165,0x0124,0x0107,0x010B,0x011B,
	0x0109,0x0125,0x0111,0x0171,0x019B,0x0164,0x0169,0x0166,
	0x013A,0x0138,0x0157,0x0165,0x01CF,0x0200,0x0223,0x0252,
	0x023D,0x0243,0x0234,0x02B2,0x02DC,0x02D3,0x0280,0x0255,
	0x027D,0x02C7,0x0311,0x02FD,0x02B5,0x0344,0x03C5,0x01E2,
	0x0337,0x040C,0x0301,0x0320,0x033C,0x02EA,0x02C3,0x02D8,
	0x031B,0x031B,0x02F8,0x02CC,0x02C7,0x027F,0x027B,0x027C,
	0x0271,0x027B,0x02A7,0x02E0,0x028D,0x0252,0x0252,0x0278,
	0x0276,0x023C,0x021C,0x025A,0x0230,0x01FF,0x0209,0x0262,
	0x01FC,0x02A4,0x028E,0x0224,0x0222,0x0295,0x0280,0x0234,
	0x020F,0x0206,0x020E,0x01DA,0x01D0,0x01C5,0x01EF,0x01DD,
	0x0192,0x0167,0x0197,0x01D4,0x017F,0x01C0,0x01DC,0x01FF,
	0x01BC,0x01AA,0x01D3,0x0245,0x032B,0x0575,0x0463,0x03CF,
	0x036E,0x0350,0x036B,0x0334,0x0332,0x0311,0x02EA,0x0286,
	0x02A0,0x025F,0x022F,0x0210,0x0201,0x01EF,0x01F9,0x018F,
	0x011D,0x01F5,0x0272,0x0191,0x0123,0x0189,0x0189,0x019E,
	0x0189,0x013A,0x014E,0x0165,0x0128,0x0118,0x0103,0x00CA,
	0x011D,0x0096,0x0026,0x001F,0x0036,0x0037,0xFFFA,0xFFB7,
	0x0029,0xFFD9,0xFED0,0xFF0C,0xFFFE,0x0062,0x00A6,0x00AD,
	0x0081,0x0038,0x0017,0xFFD3,0xFF95,0xFEFE,0xFED9,0xFF44,
	0xFE6C,0xFE3A,0xFE45,0xFE76,0xFE0A,0xFE10,0xFE03,0xFE2E,
	0xFE26,0xFE5C,0xFE4F,0xFE39,0xFE26,0xFE33,0xFEA8,0xFE97,
	0xFE73,0xFEA0,0xFE4D,0xFE34,0xFE14,0xFE53,0xFE81,0xFE4F,
	0xFE60,0xFE56,0xFE1E,0xFE5D,0xFE01,0xFE12,0xFE69,0xFE5E,
	0xFE66,0xFE79,0xFEB2,0xFE8B,0xFE63,0xFE3B,0xFE7F,0xFE7B,
	0xFE31,0xFE1B,0xFE2F,0xFE5E,0xFDAE,0xFDC1,0xFDE5,0xFDC0,
	0xFDE9,0xFD81,0xFDF2,0xFE21,0xFE15,0xFDDE,0xFDBD,0xFDFD,
	0xFE6F,0xFE53,0xFE8D,0xFEB7,0xFEC7,0xFDBC,0xFFC8,0xFF3A,
	0xFE13,0xFF2D,0xFF17,0xFF24,0xFF3C,0xFF67,0xFF7E,0xFF92,
	0xFF7C,0xFF8B,0xFF88,0xFF7D,0xFF7C,0x000F,0xFFEF,0xFFBD,
	0xFFED,0x004C,0x0047,0xFFF3,0x003E,0x003C,0xFFD5,0xFFDE,
	0xFF8D,0xFFD3,0xFFE8,0xFFE2,0xFFC1,0xFFF1,0xFFEB,0x0022,
	0x000C,0x0058,0x0042,0xFFE3,0xFFEF,0x001B,0x0048,0x0052,
	0x00A6,0x00DC,0x00A2,0x003F,0x0000,0x0048,0x0015,0x0018,
	0x004A,0x0095,0x004B,0x00D2,0x00BC,0x0051,0x0098,0x0078,
	0x005E,0x0062,0x005E,0x0070,0x0026,0xFFE9,0xFE33,0xFD11,
	0xFDF1,0xFE44,0xFE8A,0xFEB5,0xFEB2,0xFEAB,0xFED7,0xFEF6,
	0xFEDF,0xFF12,0xFF1C,0xFF79,0xFF9F,0xFF81,0xFF66,0xFFA2,
	0x0037,0xFF79,0xFF0A,0xFFC2,0xFFEA,0xFFE4,0x000A,0x001E,
	0xFFFD,0x002B,0x0026,0x0024,0x004A,0x004B,0x0088,0x0077,
	0x002B,0x0048,0x0079,0x007B,0x00D2,0x0106,0x00CB,0x00F6,
	0x010D,0x010A,0x01FA,0x00FE,0xFFFD,0xFF99,0xFFFB,0x0013,
	0x0016,0xFFEE,0xFFF5,0x0054,0x00C7,0x015E,0x0153,0x01AF,
	0x0249,0x020C,0x01AE,0x0171,0x016F,0x01BA,0x01E5,0x0238,
	0x022F,0x01B2,0x00FF,0x0139,0x0131,0x014E,0x0102,0x00E5,
	0x00C1,0x00CB,0x00B7,0x00AA,0x0095,0x0095,0x0084,0x0056,
	0x004A,0x0097,0x0095,0x0077,0x00C6,0x005F,0xFFF6,0x000D,
	0x004F,0x003A,0x0065,0x0065,0x0051,0x0029,0x0024,0xFFAF,
	0xFF82,0xFF5B,0xFF31,0xFF22,0xFF51,0xFF9E,0xFF8F,0xFF7A,
	0xFF43,0xFF5C,0xFF37,0xFFB4,0xFF7E,0xFF60,0xFF83,0xFF5D,
	0xFEFF,0xFF56,0xFF91,0xFF46,0xFF4E,0x000A,0xFF5D,0xFEB9,
	0x00B7,0xFF7E,0xFEFD,0xFF14,0xFF1D,0xFF22,0xFF15,0xFECB,
	0xFEA2,0xFEE5,0xFEB2,0xFE7B,0xFE66,0xFE54,0xFE23,0xFE6D,
	0xFE52,0xFE1E,0xFE48,0xFE7D,0xFEAC,0xFE81,0xFE75,0xFE9D,
	0xFE7C,0xFE6C,0xFE89,0xFEA6,0xFEB3,0xFE9D,0xFE65,0xFEA2,
	0xFE92,0xFEBD,0xFE9A,0xFE94,0xFE94,0xFF0B,0xFEDF,0xFE5E,
	0xFE39,0xFE2B,0xFE55,0xFE8E,0xFE6F,0xFE49,0xFDB2,0xFE2F,
	0xFE58,0xFE03,0xFDE7,0xFE1E,0xFE22,0xFDFA,0xFDCF,0xFE1A,
	0xFE22,0xFDC5,0xFE6B,0xFECF,0x00C5,0x0119,0x00A1,0x002E,
	0x003E,0x0018,0xFFFF,0x0012,0xFF8F,0xFFDA,0xFFB9,0xFFD6,
	0x0009,0xFFAC,0xFF97,0xFFB6,0xFFB9,0xFF8B,0xFFAF,0xFF61,
	0xFF4B,0x003A,0xFFD6,0xFEE6,0xFF42,0xFF54,0xFEC2,0xFE90,
	0xFE64,0xFECD,0xFF0A,0xFEFC,0xFED7,0xFF0F,0xFEB3,0xFE9A,
	0xFE71,0xFE3E,0xFE5A,0xFE64,0xFE6A,0xFE47,0xFE39,0xFE0B,
	0xFE0E,0xFD66,0xFD10,0xFE62,0xFEB2,0xFE86,0xFE92,0xFE44,
	0xFE3E,0xFE49,0xFE7D,0xFE10,0xFE3A,0xFDD7,0xFDAD,0xFD6B,
	0xFCA1,0xFCC4,0xFD39,0xFD4B,0xFCB9,0xFCBD,0xFCE0,0xFCBF,
	0xFCA5,0xFCAB,0xFD08,0xFCCD,0xFCAB,0xFCFB,0xFCFE,0xFCE9,
	0xFD03,0xFCB3,0xFCEA,0xFD24,0xFD48,0xFD9B,0xFDA2,0xFDB5,
	0xFDD3,0xFDD1,0xFDEB,0xFDC4,0xFD83,0xFD40,0xFD0F,0xFD4E,
	0xFD6A,0xFD4F,0xFD1E,0xFD65,0xFD47,0xFD59,0xFD89,0xFD6D,
	0xFDAB,0xFDB2,0xFD73,0xFD35,0xFD21,0xFD31,0xFD9D,0xFDEB,
	0xFE0D,0xFDB0,0xFDB4,0xFDBE,0xFDC7,0xFD84,0xFDD6,0xFE05,
	0xFE3F,0xFDD4,0xFE03,0xFE64,0xFDEE,0xFE38,0xFFE4,0xFDFE,
	0xFE85,0xFEF5,0xFED3,0xFF1C,0xFF57,0xFF5D,0xFF53,0xFF5B,
	0xFF34,0xFF79,0xFFAF,0xFFB4,0xFFEA,0x004B,0xFFFF,0xFFE8,
	0xFF8A,0xFF76,0xFF5B,0xFF4D,0xFF97,0xFF88,0xFFC1,0xFF98,
	0xFFDF,0xFFA6,0xFF88,0xFFD0,0xFFD2,0xFFCD,0xFFD9,0x002D,
	0x0016,0xFFF8,0xFFA3,0xFFDD,0xFFBF,0xFFBF,0xFFAD,0xFFB7,
	0xFFD5,0xFFEC,0xFFE2,0xFF7C,0xFF73,0xFF3C,0xFF8C,0xFF52,
	0xFF35,0xFF72,0xFF5C,0xFF60,0xFEEF,0xFEDC,0xFF39,0xFF3F,
	0xFECA,0xFF2C,0xFF0F,0xFEFE,0xFF04,0xFE54,0xFC45,0xFCC0,
	0xFCFD,0xFCFC,0xFD4E,0xFD75,0xFD97,0xFDC6,0xFDD8,0xFDBB,
	0xFD83,0xFDCA,0xFDD9,0xFDFF,0xFE40,0xFE1A,0xFE4A,0xFECA,
	0xFE8D,0xFDA9,0xFE51,0xFF20,0xFEE6,0xFEE1,0xFF12,0xFED7,
	0xFE9B,0xFF16,0xFECC,0xFECB,0xFF48,0xFF40,0xFF3E,0xFF5F,
	0xFF55,0xFF9A,0xFFC5,0xFFCF,0xFFB6,0xFFA6,0xFFA6,0x0018,
	0xFFB7,0x00C9,0x0105,0xFFC8,0xFF83,0xFF8A,0xFFB4,0xFFA1,
	0xFFEC,0x001A,0x0022,0x0045,0x00FA,0x0142,0x0130,0x01BB,
	0x0241,0x021E,0x01BB,0x01FE,0x0198,0x018D,0x0169,0x014D,
	0x015B,0x0176,0x016B,0x0155,0x00FB,0x00FA,0x0121,0x00EF,
	0x0120,0x0137,0x00DF,0x00AC,0x0086,0x00E6,0x00E1,0x00BD,
	0x00E8,0x00D5,0x00D4,0x00AE,0x0091,0x00F8,0x00E7,0x00CA,
	0x008A,0x005B,0x0065,0x0086,0x0070,0x005D,0x002F,0xFFF9,
	0xFFCA,0xFFF5,0xFFE1,0xFFCC,0x0061,0x004A,0x003C,0x0026,
	0x000B,0x002F,0x0049,0xFFFE,0x003D,0x0020,0xFFC6,0xFF93,
	0xFF97,0xFFC5,0xFFDB,0xFFAB,0x000C,0x001B,0xFE66,0xFFD0,
	0x002D,0xFF08,0xFF4E,0xFF73,0xFF6F,0xFF59,0xFF4B,0xFEFC,
	0xFF1F,0xFEEA,0xFF28,0xFEF9,0xFF06,0xFF14,0xFF18,0xFEBA,
	0xFED0,0xFE8B,0xFE69,0xFE9C,0xFE69,0xFE65,0xFE8F,0xFEE8,
	0xFEE3,0xFEE0,0xFEBF,0xFEBB,0xFEB6,0xFE9F,0xFE74,0xFEA3,
	0xFEC1,0xFEB6,0xFE3F,0xFE6B,0xFED7,0xFF0E,0xFECB,0xFEFC,
	0xFF27,0xFED4,0xFF1B,0xFF17,0xFF05,0xFEED,0xFEE2,0xFEF8,
	0xFF57,0xFF8F,0xFF63,0xFEE0,0xFF16,0xFF01,0xFF18,0xFEEB,
	0xFEF4,0xFF44,0xFF65,0x0099,0x0233,0x0174,0x0115,0x00D1,
	0x00D5,0x00E1,0x00C4,0x00BF,0x00D7,0x00D2,0x0087,0x0086,
	0x00A4,0x00CE,0x006A,0x0016,0x0040,0x0059,0xFFF1,0xFF8E,
	0x000A,0x0079,0xFFA6,0xFF29,0xFF9C,0xFFB6,0xFF68,0xFF32,
	0xFEE3,0xFF20,0xFF46,0xFF5A,0xFF1D,0xFEE5,0xFEC0,0xFEDD,
	0xFEC6,0xFEDD,0xFEAF,0xFE83,0xFE55,0xFE21,0xFE2F,0xFEAA,
	0xFD85,0xFCE6,0xFE4A,0xFEE5,0xFF20,0xFEA8,0xFEAB,0xFEB2,
	0xFE3B,0xFE1B,0xFDF3,0xFDC1,0xFD80,0xFCFC,0xFD30,0xFCEC,
	0xFC72,0xFC88,0xFCAA,0xFCEF,0xFCBC,0xFC78,0xFC46,0xFCB4,
	0xFC9C,0xFC58,0xFCDC,0xFCFD,0xFCE9,0xFD08,0xFD20,0xFD7F,
	0xFD4E,0xFD2C,0xFD37,0xFD16,0xFD69,0xFD6D,0xFD08,0xFD7A,
	0xFDC4,0xFDD7,0xFDF0,0xFDFE,0xFDD5,0xFD9A,0xFD7D,0xFDA8,
	0xFDC4,0xFDC0,0xFDB1,0xFDB3,0xFE1D,0xFE20,0xFDF3,0xFE48,
	0xFE2A,0xFDE9,0xFE00,0xFE10,0xFE1A,0xFE13,0xFE0E,0xFDC5,
	0xFD60,0xFD64,0xFD8E,0xFE04,0xFE21,0xFE10,0xFDED,0xFE58,
	0xFDB7,0xFDF7,0xFE0C,0xFE2D,0xFD70,0xFF33,0xFE8A,0xFD2D,
	0xFE60,0xFE2A,0xFDFF,0xFDBC,0xFDF9,0xFDF7,0xFE44,0xFE27,
	0xFE5A,0xFE74,0xFEB6,0xFE78,0xFEA6,0xFEE3,0xFEF9,0xFF1A,
	0xFEFE,0xFF16,0xFED9,0xFF56,0xFF31,0xFF44,0xFF9D,0xFFA7,
	0xFF60,0xFF02,0xFEC4,0xFEC3,0xFED6,0xFE63,0xFED2,0xFEE9,
	0xFEDB,0xFE8F,0xFEB7,0xFE9A,0xFEBC,0xFF05,0xFF25,0xFF6C,
	0xFF54,0xFEFF,0xFF47,0xFF45,0xFEB8,0xFEEB,0xFEDB,0xFECC,
	0xFEEF,0xFEE7,0xFED8,0xFEBC,0xFEBE,0xFEE2,0xFEEB,0xFEC7,
	0xFE6A,0xFE65,0xFE88,0xFEE8,0xFE4F,0xFC40,0xFB95,0xFCD8,
	0xFCF9,0xFCD5,0xFD07,0xFD1E,0xFD60,0xFD74,0xFD79,0xFD59,
	0xFD8E,0xFD4B,0xFD85,0xFDC3,0xFE0B,0xFE2C,0xFE2E,0xFEB5,
	0xFE4D,0xFDE6,0xFE61,0xFE83,0xFE76,0xFEA2,0xFEB9,0xFEEE,
	0xFFB0,0xFFA1,0xFF74,0xFFE7,0x0005,0x0015,0x0041,0x000E,
	0x001C,0x0045,0x0041,0x006D,0x0077,0x00A4,0x005D,0x0108,
	0x01D9,0x00B6,0x000D,0xFFF8,0xFFDD,0x0002,0x0035,0x00AB,
	0x00D4,0x00C8,0x00B7,0x00AF,0x00D2,0x010B,0x0143,0x01F2,
	0x01F0,0x01A2,0x01C3,0x0193,0x01CB,0x01CA,0x0209,0x01C4,
	0x0198,0x01A5,0x01CF,0x01C0,0x019C,0x01B6,0x01D8,0x0150,
	0x0143,0x015E,0x011F,0x0108,0x00C5,0x00A6,0x00AA,0x00F3,
	0x00E5,0x010A,0x0105,0x00D7,0x00C8,0x006E,0x0045,0x0080,
	0x008A,0x0089,0x0063,0x006A,0x0029,0x001D,0x0047,0x0048,
	0x0042,0x001F,0xFFED,0x003D,0x0038,0x0000,0xFFD1,0x002C,
	0x0050,0x0023,0xFFF5,0xFFE1,0xFFC8,0xFFC9,0xFF59,0xFF11,
	0xFFB9,0x001B,0xFFEB,0xFFAE,0x00BE,0xFEF9,0xFE98,0x008B,
	0xFFC6,0xFF7A,0xFFD8,0xFFB2,0xFFB3,0xFFDA,0xFFCB,0xFFD2,
	0xFFB6,0xFF91,0xFFDC,0xFFC3,0xFFB2,0xFFAD,0xFFBA,0xFF9F,
	0xFFBF,0xFFEF,0xFFB8,0xFF7F,0xFF69,0xFF7D,0xFF98,0xFF6E,
	0xFF04,0xFF31,0xFF90,0xFF90,0xFF79,0xFF9F,0xFF66,0xFECF,
	0xFEFF,0xFF50,0xFF92,0xFFBA,0xFFDF,0x0054,0x0010,0xFF60,
	0xFFB7,0xFFF5,0xFFB7,0xFF93,0xFF3B,0xFF51,0xFF2E,0xFEED,
	0xFF16,0xFF2F,0xFF35,0xFEEF,0xFF23,0xFEEA,0xFF25,0xFF4B,
	0xFF09,0xFF3D,0xFFC4,0x01AA,0x01E9,0x0146,0x014C,0x00F6,
	0x00C1,0x00BD,0x00B2,0x009B,0x0096,0x00EB,0x00B3,0x00C3,
	0x0035,0x002D,0x003F,0x0063,0xFFEE,0xFFE9,0xFF87,0xFF9E,
	0x0042,0xFF8B,0xFE92,0xFF29,0xFFA3,0xFF2C,0xFF2C,0xFF25,
	0xFEFF,0xFEE5,0xFEBF,0xFE9A,0xFEA7,0xFE66,0xFE21,0xFE6D,
	0xFEA6,0xFE9E,0xFEA2,0xFE9F,0xFE70,0xFE0B,0xFE51,0xFE6E,
	0xFDA1,0xFD97,0xFE51,0xFE73,0xFE9F,0xFE63,0xFE2D,0xFDE1,
	0xFDFF,0xFE5B,0xFE72,0xFDAC,0xFD2E,0xFCFC,0xFD13,0xFCAF,
	0xFCC6,0xFCFA,0xFCEC,0xFCF9,0xFCDA,0xFCF5,0xFCAC,0xFD06,
	0xFD75,0xFD36,0xFD5D,0xFCD0,0xFCD8,0xFD4C,0xFCF4,0xFCEE,
	0xFCEF,0xFD27,0xFCD3,0xFCC4,0xFC6E,0xFCEE,0xFC90,0xFC87,
	0xFD03,0xFD18,0xFCD4,0xFCE9,0xFD4F,0xFD54,0xFD3C,0xFD1A,
	0xFD48,0xFD4A,0xFD50,0xFD29,0xFD02,0xFD06,0xFCFD,0xFD52,
	0xFD0B,0xFCD6,0xFD33,0xFD02,0xFD26,0xFD0D,0xFD5A,0xFCF1,
	0xFC71,0xFCDE,0xFD0B,0xFD6C,0xFD3D,0xFCCA,0xFCF5,0xFDE8,
	0xFDA6,0xFDD6,0xFE1F,0xFD96,0xFD9F,0xFF29,0xFD10,0xFDB8,
	0xFDD7,0xFDD1,0xFDC6,0xFDF1,0xFDCE,0xFDC8,0xFE1D,0xFE2F,
	0xFE2A,0xFDD6,0xFDFB,0xFE44,0xFEAC,0xFE2B,0xFE85,0xFEC7,
	0xFEF4,0xFE9C,0xFEDB,0xFEBD,0xFE88,0xFE93,0xFE9D,0xFE7E,
	0xFE7F,0xFEB4,0xFE6D,0xFE74,0xFE79,0xFE95,0xFEA1,0xFEBF,
	0xFE7B,0xFE94,0xFE86,0xFEDA,0xFEB9,0xFE5F,0xFE9F,0xFE8F,
	0xFE67,0xFEBF,0xFE75,0xFE84,0xFF18,0xFF10,0xFEB2,0xFF02,
	0xFF4C,0xFEE3,0xFF24,0xFF3C,0xFF30,0xFF89,0xFFC0,0x0030,
	0xFFD8,0xFFBE,0xFFCA,0xFFA6,0xFE8B,0xFCAB,0xFCD4,0xFD09,
	0xFD2B,0xFDB2,0xFE14,0xFE41,0xFE3B,0xFE34,0xFE4B,0xFE39,
	0xFE1C,0xFDF4,0xFE3A,0xFE01,0xFE4B,0xFE25,0xFF08,0xFEFA,
	0xFE5A,0xFEA1,0xFF5D,0xFF54,0xFF68,0xFFC8,0xFFCE,0xFFBF,
	0xFFBE,0xFFD2,0x0000,0x0002,0xFFF2,0x0005,0x000E,0x0056,
	0x000F,0xFFFC,0x0006,0x0088,0x004C,0x0008,0x0059,0x0075,
	0x0130,0x0176,0x0095,0x0019,0x005F,0x002F,0x0071,0x00A5,
	0x00BE,0x0111,0x015C,0x01D1,0x01B6,0x01C8,0x021B,0x028C,
	0x02A7,0x023B,0x0211,0x022C,0x01F7,0x01DC,0x0241,0x020F,
	0x01F7,0x01F5,0x01B9,0x017C,0x0184,0x0147,0x0163,0x015E,
	0x0195,0x01F1,0x0167,0x0165,0x016A,0x0140,0x0113,0x010E,
	0x0107,0x0117,0x0155,0x0119,0x0145,0x0100,0x0103,0x00B5,
	0x00D5,0x010C,0x00B4,0x0083,0x007E,0x0068,0x0023,0x006A,
	0x0095,0x008F,0x0082,0x0071,0x0085,0x00A8,0x0061,0x00B1,
	0x00B3,0x008E,0x007D,0x0034,0x0076,0x00B0,0x0024,0x0010,
	0x0067,0x001C,0x004E,0x00B6,0x00A8,0xFED0,0x0053,0x003C,
	0xFF99,0xFFEB,0x003D,0x0005,0xFFF2,0xFFE0,0x0012,0x0040,
	0x003B,0x000D,0xFFEC,0xFFC5,0xFFEC,0xFFC9,0xFFFA,0xFFC5,
	0xFFC0,0xFFAF,0xFFE5,0x0056,0xFFEB,0xFF95,0xFF74,0xFFBD,
	0xFF8E,0xFF66,0xFF80,0xFF27,0xFF57,0xFFA1,0xFFAA,0xFF7B,
	0xFF69,0xFF76,0xFF8F,0xFFB4,0xFF75,0xFF68,0xFF20,0xFEF8,
	0xFF09,0xFF39,0xFF52,0xFF1D,0xFF19,0xFEA1,0xFED2,0xFEB0,
	0xFECD,0xFEB3,0xFE68,0xFE92,0xFE6D,0xFEC7,0xFEB7,0xFEDA,
	0xFF0B,0xFF4B,0x0060,0x0200,0x00F6,0x00CD,0x0060,0x0026,
	0x004E,0x0057,0x002A,0x000C,0x003B,0xFFF9,0xFFD1,0xFFA2,
	0xFFBD,0xFFE0,0xFF84,0xFFB3,0xFFBF,0xFF9B,0xFF2E,0xFFE6,
	0x0032,0xFF32,0xFE87,0xFED9,0xFEBE,0xFEB8,0xFE8E,0xFE95,
	0xFEC9,0xFE8D,0xFE75,0xFE64,0xFEA0,0xFE7E,0xFE85,0xFE23,
	0xFE30,0xFE8D,0xFE9A,0xFEAD,0xFE7C,0xFED1,0xFF27,0xFE6C,
	0xFD3E,0xFE13,0xFEFD,0xFF3C,0xFF7A,0xFF2F,0xFF05,0xFEE6,
	0xFEE5,0xFEEC,0xFE46,0xFDAB,0xFDA4,0xFD91,0xFCFA,0xFCAE,
	0xFD08,0xFD27,0xFCFB,0xFCB4,0xFCCA,0xFC7D,0xFC66,0xFC7D,
	0xFC8B,0xFC7F,0xFCBA,0xFCAF,0xFCF4,0xFD49,0xFD29,0xFD3D,
	0xFD35,0xFCFD,0xFD2F,0xFD6B,0xFD97,0xFDBE,0xFDD7,0xFDD0,
	0xFD9A,0xFDAB,0xFD60,0xFD88,0xFDB7,0xFD61,0xFD81,0xFD92,
	0xFD84,0xFD7A,0xFD6B,0xFDD5,0xFDD8,0xFD7D,0xFD88,0xFDB1,
	0xFD9D,0xFD47,0xFD4D,0xFD59,0xFD80,0xFD74,0xFD99,0xFD27,
	0xFD21,0xFD35,0xFD51,0xFD60,0xFD28,0xFD81,0xFE1B,0xFE0D,
	0xFE31,0xFE59,0xFE58,0xFD8B,0xFF6D,0xFE5B,0xFDB9,0xFED5,
	0xFE80,0xFE2C,0xFE76,0xFE7F,0xFE79,0xFF03,0xFEC8,0xFF02,
	0xFEA7,0xFE77,0xFEDB,0xFEE3,0xFEB3,0xFECF,0xFF01,0xFF00,
	0xFF93,0xFF6C,0xFF09,0xFEDF,0xFEDF,0xFF22,0xFF3A,0xFF03,
	0xFF35,0xFF64,0xFEA8,0xFF02,0xFF48,0xFF56,0xFF38,0xFF0F,
	0xFF1A,0xFF16,0xFEEF,0xFF10,0xFF1C,0xFF19,0xFF25,0xFF32,
	0xFF86,0xFFA5,0xFFA4,0xFFC9,0x000D,0xFFD8,0xFF74,0xFF75,
	0xFFD4,0xFFEA,0xFF9F,0xFF62,0xFF5D,0xFF68,0xFF96,0xFF61,
	0xFF6E,0xFF81,0xFF65,0xFEFB,0xFCDF,0xFBEE,0xFCE2,0xFD33,
	0xFD2D,0xFD46,0xFD68,0xFD88,0xFD93,0xFDA5,0xFDEA,0xFE31,
	0xFE31,0xFE2F,0xFE0D,0xFE6F,0xFEA0,0xFEF1,0xFF82,0xFE6B,
	0xFE46,0xFF13,0xFF60,0xFF3A,0xFF82,0xFFB3,0xFF47,0xFF46,
	0xFFE9,0xFF68,0xFFA0,0xFFBA,0x0007,0x004B,0x001C,0x0025,
	0xFFDA,0xFFB7,0x0022,0x005D,0x0047,0x0094,0x0046,0x00C4,
	0x01D5,0x00DD,0x001D,0xFFE7,0x000C,0xFFD1,0x000B,0x005D,
	0x0061,0x00A0,0x00D7,0x0196,0x017E,0x0190,0x0201,0x01C2,
	0x0175,0x0176,0x018A,0x0160,0x0150,0x014F,0x00FF,0x0100,
	0x00EA,0x0106,0x00F1,0x0101,0x010D,0x00ED,0x00C5,0x00C3,
	0x008E,0x0090,0x0082,0x00DE,0x0093,0x005D,0x0063,0x0029,
	0x000B,0xFFA3,0xFF78,0xFF51,0xFFC4,0xFFE1,0xFFBC,0xFF63,
	0xFF86,0xFF95,0xFF42,0xFF34,0xFF66,0xFF43,0xFF29,0xFFA6,
	0xFF3D,0xFEEB,0xFF4C,0xFF5C,0xFF36,0xFF57,0xFF6F,0xFFB5,
	0xFF4C,0xFF37,0xFF6D,0xFFAE,0xFF56,0xFF38,0xFF49,0xFF58,
	0xFF6B,0xFF2D,0xFF35,0x0024,0xFF00,0xFE4F,0x0017,0xFF55,
	0xFF4B,0xFFD1,0xFF8C,0xFF94,0xFF62,0xFF5F,0xFEFF,0xFF62,
	0xFF5D,0xFF66,0xFF18,0xFF2A,0xFF38,0xFF1F,0xFEF2,0xFEE3,
	0xFEE7,0xFF14,0xFED3,0xFECF,0xFF22,0xFECB,0xFECC,0xFEFC,
	0xFF0F,0xFECE,0xFECD,0xFEA3,0xFEB8,0xFEF6,0xFED3,0xFED4,
	0xFE94,0xFECE,0xFE7E,0xFEA8,0xFEEB,0xFEF8,0xFF02,0xFF28,
	0xFF41,0xFF08,0xFEDD,0xFEDD,0xFEEE,0xFEF6,0xFEB9,0xFED7,
	0xFEDC,0xFED3,0xFEFF,0xFE60,0xFE60,0xFE42,0xFE47,0xFE90,
	0xFEBC,0xFEEC,0x012C,0x0169,0x0097,0x0096,0x0068,0x0051,
	0x0032,0x0038,0x006C,0x0070,0x004E,0x00D9,0x0099,0x0034,
	0x0065,0x0045,0x0008,0xFFFC,0xFF9D,0xFF0A,0xFF06,0xFFD7,
	0xFFCA,0xFF02,0xFEFF,0xFF2E,0xFF06,0xFF15,0xFEB5,0xFEEB,
	0xFF18,0xFEDC,0xFE92,0xFEF4,0xFE94,0xFEB6,0xFEAB,0xFEA7,
	0xFEB5,0xFE92,0xFEE4,0xFF05,0xFE60,0xFE82,0xFE95,0xFD9D,
	0xFCDA,0xFE12,0xFE79,0xFEC5,0xFEDE,0xFE6D,0xFEAA,0xFE65,
	0xFE23,0xFDE1,0xFDAE,0xFD4C,0xFD95,0xFCF1,0xFC88,0xFCE3,
	0xFCA3,0xFCA9,0xFC97,0xFCBC,0xFCDA,0xFCB4,0xFC82,0xFCDB,
	0xFD15,0xFD63,0xFD86,0xFD42,0xFD1F,0xFD98,0xFDFB,0xFDFA,
	0xFDDC,0xFDFC,0xFE00,0xFE30,0xFE41,0xFE40,0xFE3C,0xFE2A,
	0xFE59,0xFE27,0xFE31,0xFE36,0xFE2F,0xFE69,0xFE63,0xFE36,
	0xFE2B,0xFE1F,0xFE6F,0xFE44,0xFE35,0xFE65,0xFE7B,0xFE3E,
	0xFE56,0xFE5B,0xFE09,0xFDEF,0xFDF4,0xFDED,0xFDCE,0xFD98,
	0xFDFC,0xFE57,0xFE83,0xFE78,0xFE78,0xFF01,0xFEF9,0xFE89,
	0xFEE0,0xFF53,0xFE94,0xFF05,0x008B,0xFEDB,0xFFA0,0xFFCF,
	0xFF7E,0xFF6B,0xFF47,0xFF2E,0xFF60,0xFF9A,0xFFA1,0xFFE1,
	0xFFA1,0x0035,0x002F,0x0054,0xFFC2,0x001A,0x0027,0x0022,
	0x0026,0x001B,0x0045,0x0035,0x0031,0xFFF6,0x0077,0x00A1,
	0x009D,0x00C3,0x0115,0x0155,0x0189,0x0256,0x037D,0x04C9,
	0x0566,0x0608,0x06AC,0x0711,0x0780,0x08E5,0x0A97,0x0BB4,
	0x0C72,0x0D20,0x0D95,0x0E20,0x0DF0,0x0DD4,0x0E18,0x0DF7,
	0x0E5A,0x0EC0,0x0F54,0x0F98,0x0F3D,0x0EF2,0x0F57,0x0F92,
	0x1083,0x11B9,0x11D7,0x1043,0x0E15,0x0F18,0x1033,0x11D7,
	0x12EB,0x13BA,0x148A,0x1531,0x1525,0x14FE,0x1487,0x14B1,
	0x15A9,0x16F3,0x1828,0x1935,0x191E,0x197E,0x1944,0x18C3,
	0x18CF,0x18C6,0x1951,0x19D8,0x1A51,0x1ABB,0x1AB5,0x1B6A,
	0x1B7C,0x1B55,0x1B0B,0x1B26,0x1BA8,0x1AB1,0x190A,0x18C2,
	0x1A47,0x1B87,0x1B2E,0x19F4,0x1964,0x18FF,0x18D8,0x19E4,
	0x18C4,0x174D,0x171D,0x16D8,0x1741,0x1710,0x1699,0x1566,
	0x1473,0x1486,0x15FB,0x16C7,0x15F6,0x152D,0x13EF,0x1240,
	0x1088,0x0D55,0x04EE,0xF57A,0xDC88,0xC45B,0xC0BC,0xC0D5,
	0xC0BD,0xC256,0xC09B,0xD5E5,0x0B8D,0x2677,0x1D26,0xFC65,
	0xDA25,0xC9C1,0xD56E,0xF7B7,0x248E,0x3F16,0x3F71,0x402A,
	0x4048,0x4049,0x4049,0x4010,0x4026,0x4030,0x4007,0x403C,
	0x3F66,0x3DC1,0x4020,0x402B,0x3F65,0x3F66,0x34D8,0x0B65,
	0xD98E,0xC093,0xC19D,0xC03D,0xC38C,0xD464,0xDE06,0xDD27,
	0xD5E8,0xCB78,0xC26B,0xC025,0xC075,0xC076,0xCA1D,0xDB09,
	0xED81,0xFFAA,0x1173,0x22CE,0x3120,0x3CF2,0x3E37,0x3338,
	0x2460,0x1981,0x18BF,0x2497,0x375C,0x3FA6,0x3EE0,0x3F9B,
	0x35AB,0x1CB3,0x06F2,0xF4E1,0xE890,0xE160,0xDDEA,0xDBE4,
	0xDA09,0xD78B,0xD362,0xCDAA,0xC70C,0xC190,0xBF9F,0xBF9B,
	0xBF92,0xBFB2,0xBFF5,0xBFD2,0xCEA3,0xE3E2,0xF281,0xF8F5,
	0xF7C8,0xF3AF,0xF06C,0xF1CB,0xF8AE,0x03BF,0x0FC7,0x19B7,
	0x2171,0x2594,0x2544,0x2055,0x18D5,0x1098,0x0899,0x0094,
	0xF838,0xF19C,0xEE21,0xEC9F,0xEBF7,0xEA29,0xE5D5,0xDEA7,
	0xD469,0xC94B,0xC22E,0xC080,0xC0A2,0xC030,0xC312,0xCBD7,
	0xD294,0xD701,0xD901,0xD965,0xDA6C,0xDBA0,0xDE76,0xE402,
	0xEBBE,0xF3D7,0xFBDD,0x0319,0x094A,0x0E0F,0x11C5,0x11AC,
	0x0DAA,0x08B0,0x04C5,0x0188,0xFF9C,0xFFEC,0x011A,0x0155,
	0xFF0D,0xFA1D,0xF309,0xEA94,0xE173,0xD995,0xD476,0xD228,
	0xD299,0xD357,0xD3B1,0xD3F6,0xD479,0xD55E,0xD511,0xD43B,
	0xD59E,0xD713,0xD85B,0xDBEC,0xE20C,0xEA2B,0xF1E8,0xF790,
	0xFB84,0xFDF7,0xFEB1,0xFF1B,0xFF95,0xFF95,0x0024,0x0197,
	0x02E7,0x0546,0x0742,0x06D4,0x0365,0xFE59,0xF9F8,0xF629,
	0xF1DE,0xED22,0xE98D,0xE744,0xE606,0xE580,0xE497,0xE3EE,
	0xE1B8,0xDE98,0xDBDE,0xDAFF,0xDB68,0xDC82,0xDDBD,0xE06F,
	0xE4C9,0xE954,0xED9B,0xF0A6,0xF32E,0xF426,0xF4E5,0xF680,
	0xF910,0xFCBE,0xFFF8,0x01AA,0x03A4,0x0623,0x07CA,0x0760,
	0x055C,0x0310,0x00F0,0xFE1D,0xFB21,0xF9C5,0xF933,0xF8EA,
	0xF73A,0xF507,0xF2EE,0xF07F,0xED1E,0xEA47,0xE7F6,0xE774,
	0xE78A,0xE736,0xE639,0xE8B0,0xE933,0xE964,0xE9EF,0xE69F,
	0xE0F5,0xD90F,0xD0EF,0xCADF,0xCB7B,0xD3C1,0xE35C,0xF5F1,
	0x0521,0x0AFA,0x0747,0xFE5B,0xF6C7,0xF461,0xF7FC,0x019E,
	0x0CD1,0x168B,0x1CFE,0x2036,0x20DB,0x1FE1,0x1D79,0x1959,
	0x13E9,0x0D73,0x070D,0x027B,0x008D,0x00A6,0x036B,0x07BB,
	0x0A2F,0x0759,0xFDB7,0xF073,0xE4DD,0xDE82,0xDE0E,0xE2BF,
	0xE9DF,0xEFD5,0xF2F3,0xF3A0,0xF40B,0xF458,0xF3E9,0xF255,
	0xF1FF,0xF44B,0xF856,0xFD63,0x01FE,0x0702,0x0CAE,0x11E9,
	0x15D6,0x16E7,0x13E1,0x0C81,0x05E2,0x0244,0x0296,0x0652,
	0x0B0E,0x0E12,0x0E0B,0x0ADE,0x0510,0xFE80,0xF85D,0xF3A9,
	0xF129,0xF002,0xEEE8,0xEE39,0xEE46,0xEEB7,0xEE5B,0xEE1C,
	0xEE94,0xEE9A,0xED30,0xEB54,0xE9EF,0xE8E9,0xE8A5,0xE94F,
	0xE925,0xE97F,0xE983,0xE7C9,0xE3EC,0xDFA5,0xDD1D,0xDD36,
	0xDE66,0xE065,0xE287,0xE3AE,0xE469,0xE455,0xE45D,0xE4F6,
	0xE2C4,0xE150,0xE095,0xE04B,0xDFE0,0xDFAC,0xDFAB,0xDFDE,
	0xDFF5,0xE090,0xE120,0xE17B,0xE10C,0xE1C4,0xE1D0,0xE180,
	0xE1E0,0xE286,0xE38E,0xE461,0xE4C4,0xE520,0xE5C4,0xE65E,
	0xE6A4,0xE70B,0xE7DA,0xE86F,0xE8EB,0xE96E,0xEA19,0xEAA3,
	0xEB5A,0xEBFA,0xEC19,0xEC48,0xECDE,0xED1A,0xED08,0xED26,
	0xEDEF,0xEE77,0xEF3D,0xEFB8,0xEFD4,0xEFE1,0xF00A,0xF046,
	0xF074,0xF0F9,0xF14E,0xF1FD,0xF29A,0xF367,0xF3DD,0xF45F,
	0xF4D7,0xF540,0xF63A,0xF6E5,0xF794,0xF80B,0xF89E,0xF922,
	0xFA37,0xFAF6,0xFBE9,0xFCAF,0xFCE0,0xFD05,0xFDA9,0xFE4D,
	0xFEFB,0xFF37,0x007C,0xFF6C,0xFFA3,0x01C1,0x0108,0x013B,
	0x01A0,0x0189,0x018D,0x017E,0x0209,0x0237,0x0267,0x02C8,
	0x0333,0x0343,0x0364,0x03DF,0x0435,0x04A6,0x0494,0x04CF,
	0x05A8,0x05E7,0x0666,0x06EF,0x075F,0x07AD,0x0809,0x0850,
	0x08DC,0x0933,0x09AD,0x09F4,0x0A3F,0x0A63,0x0A87,0x0B13,
	0x0B5B,0x0BC2,0x0BA4,0x0BA1,0x0BE5,0x0C5D,0x0C28,0x0C01,
	0x0BC7,0x0B82,0x0B7B,0x0BA1,0x0BF8,0x0BF7,0x0C26,0x0C3F,
	0x0C41,0x0C72,0x0CAC,0x0CB3,0x0D00,0x0CCF,0x0D21,0x0DF0,
	0x0E9F,0x114A,0x1187,0x1102,0x10F2,0x10FE,0x112B,0x1136,
	0x10C3,0x10BD,0x10D9,0x1100,0x1110,0x1139,0x112A,0x1151,
	0x119D,0x1178,0x1134,0x1160,0x10A8,0x10CA,0x1144,0x10BF,
	0x1050,0x1090,0x10BE,0x1077,0x1069,0x1002,0x1023,0x1050,
	0x1042,0x101E,0x0FFD,0x0FC0,0x0F8B,0x0F45,0x0F5C,0x0F86,
	0x0FFF,0x0FB8,0x0F95,0x0F86,0x0F56,0x0F83,0x0EA2,0x0E28,
	0x0F9D,0x104E,0x1003,0x0FCE,0x1020,0x0F90,0x0F55,0x0F55,
	0x0EF6,0x0EBA,0x0E72,0x0E5C,0x0E64,0x0D57,0x0D40,0x0D34,
	0x0D01,0x0D4E,0x0D65,0x0D46,0x0D01,0x0CA3,0x0C3A,0x0C5A,
	0x0C42,0x0C64,0x0CE7,0x0CD4,0x0C73,0x0C83,0x0C87,0x0C67,
	0x0C4C,0x0C48,0x0CD6,0x0CC5,0x0C57,0x0C3F,0x0BF6,0x0BCE,
	0x0B82,0x0B69,0x0BBB,0x0BB2,0x0B2B,0x0AF3,0x0A87,0x0A8C,
	0x0AA3,0x0A50,0x0A79,0x0A62,0x0A28,0x09FF,0x0A07,0x09F8,
	0x09D5,0x09B5,0x0995,0x09B7,0x09BB,0x092A,0x089D,0x0886,
	0x08B3,0x08E6,0x08E2,0x0894,0x0933,0x08FD,0x0893,0x0890,
	0x0909,0x086D,0x08B4,0x09D0,0x07F5,0x08B5,0x095A,0x093C,
	0x08AF,0x091D,0x0924,0x0974,0x0945,0x08C6,0x08DB,0x0903,
	0x08B0,0x0820,0x08C3,0x0896,0x08A2,0x0800,0x081E,0x083B,
	0x07FA,0x07C4,0x07F1,0x07DA,0x07CA,0x07E2,0x07CD,0x079F,
	0x0749,0x07E9,0x07F5,0x081C,0x07DB,0x078D,0x0761,0x074D,
	0x06EF,0x06C1,0x071B,0x0723,0x074F,0x0716,0x0760,0x075E,
	0x06D9,0x06AC,0x06CD,0x0655,0x0651,0x0648,0x065B,0x05FF,
	0x05BD,0x05B8,0x05D8,0x0612,0x0609,0x05C9,0x0576,0x0531,
	0x04C4,0x04ED,0x0427,0x02A6,0x0319,0x0302,0x0312,0x035C,
	0x0328,0x0337,0x0336,0x035A,0x0302,0x02B5,0x0352,0x032C,
	0x031A,0x031D,0x0366,0x03B3,0x0491,0x03AE,0x0279,0x02B2,
	0x0386,0x03CC,0x03A0,0x03C6,0x046E,0x0419,0x0410,0x0404,
	0x0422,0x0449,0x03C9,0x0413,0x0427,0x0403,0x042F,0x0404,
	0x0415,0x03D1,0x039C,0x03E7,0x03C0,0x034E,0x0439,0x0442,
	0x031E,0x02D2,0x02B7,0x02E7,0x02E6,0x02BB,0x02DF,0x0314,
	0x0305,0x0388,0x03F9,0x0428,0x0437,0x049B,0x0443,0x0424,
	0x0415,0x0411,0x03C2,0x0399,0x03EA,0x03A1,0x0371,0x02C9,
	0x02B0,0x02B5,0x02AE,0x02C6,0x0296,0x024C,0x0223,0x01F6,
	0x01DC,0x01DD,0x01E6,0x01D5,0x01A1,0x01A0,0x0176,0x00F2,
	0x0116,0x0133,0x00F1,0x00F2,0x011D,0x0176,0x00FC,0x00E9,
	0x00F8,0x00E7,0xFFFC,0xFFCB,0x00B0,0x016E,0x019C,0x01CC,
	0x01FD,0x027F,0x02DF,0x02CF,0x02B9,0x034C,0x04C5,0x06FC,
	0x08AA,0x0950,0x0965,0x0981,0x09B2,0x09A9,0x09A1,0x09BE,
	0x09B1,0x0969,0x092C,0x090D,0x08F3,0x08BD,0x08B8,0x08F1,
	0x0A3B,0x0B5F,0x0BA2,0x0B8E,0x0A8A,0x0946,0x09B5,0x0AA9,
	0x0C08,0x0D9D,0x0E68,0x0D9D,0x0D36,0x0E0D,0x0F82,0x10EC,
	0x138B,0x134E,0x1306,0x12C7,0x12C6,0x135D,0x145B,0x1406,
	0x1377,0x14BE,0x1704,0x17C6,0x16BF,0x151A,0x1457,0x14FB,
	0x15DF,0x1753,0x186E,0x17C4,0x16C3,0x15BB,0x1522,0x1556,
	0x15D1,0x15F2,0x160F,0x16EE,0x16B0,0x1581,0x139D,0x1248,
	0x1265,0x1401,0x15C4,0x16A5,0x1564,0x1262,0x0F7D,0x0EFC,
	0x1160,0x13F8,0x1478,0x12A7,0x1063,0x0E59,0x0F36,0x10A9,
	0x108B,0x0F29,0x0E28,0x0E5F,0x0F59,0x0FBC,0x0E20,0x0B5E,
	0x096A,0x09A4,0x0B6B,0x0C4F,0x0B58,0x09E1,0x07C3,0x058F,
	0x0567,0x0669,0x0774,0x07DC,0x07A2,0x0659,0x050B,0x03C4,
	0x03D3,0x03D8,0x03DB,0x0432,0x04E4,0x053B,0x049F,0x02D7,
	0x00AD,0x002B,0x00A1,0x01FD,0x02BB,0x0200,0xFFCB,0xFDE7,
	0xFCDB,0xFD9C,0xFE97,0xFEE7,0xFE79,0xFDF6,0xFDE5,0xFDCD,
	0xFC65,0xFB3E,0xFAE1,0xFB00,0xFB81,0xFBEA,0xFBA2,0xFA9C,
	0xF982,0xF955,0xF91A,0xF96F,0xF9A4,0xF9E5,0xF9D2,0xF90F,
	0xF798,0xF677,0xF768,0xF9BD,0xFA19,0xF8B7,0xF77F,0xF7B9,
	0xF743,0xF76D,0xF790,0xF628,0xF812,0xF7AA,0xF651,0xF603,
	0xF63B,0xF45A,0xF2AC,0xF378,0xF666,0xF902,0xF8CA,0xF615,
	0xF2F3,0xF1C8,0xF257,0xF498,0xF75D,0xF88E,0xF6D1,0xF3F8,
	0xF1CF,0xF176,0xF2A7,0xF42D,0xF5A7,0xF696,0xF714,0xF614,
	0xF389,0xEFE2,0xEF0F,0xF03C,0xF235,0xF453,0xF678,0xF783,
	0xF4F5,0xF095,0xEE77,0xEF34,0xF0D5,0xF24C,0xF336,0xF494,
	0xF468,0xF204,0xEF52,0xEFEE,0xF1A8,0xF235,0xF184,0xF10E,
	0xF1C8,0xF2CC,0xF1D5,0xEF34,0xEDB9,0xEE4E,0xF0B8,0xF375,
	0xF533,0xF3BF,0xEF6C,0xEAE6,0xE776,0xE885,0xED59,0xF0FC,
	0xF18C,0xF06A,0xF03E,0xF085,0xF01A,0xEF09,0xEE28,0xEDE5,
	0xED14,0xED27,0xEEEA,0xF256,0xF418,0xF36A,0xF193,0xEF39,
	0xEEE0,0xF008,0xF0E6,0xF154,0xF0B7,0xF0D2,0xF13B,0xF1FF,
	0xF367,0xF45B,0xF362,0xEFC8,0xED1C,0xEE43,0xF22B,0xF4B6,
	0xF556,0xF46B,0xF342,0xF200,0xF169,0xF29B,0xF2A1,0xF1D9,
	0xEFF4,0xEF92,0xF1F0,0xF5C3,0xF7AC,0xF6E7,0xF5C2,0xF4D3,
	0xF34B,0xF10D,0xF092,0xF312,0xF5E7,0xF6AE,0xF693,0xF778,
	0xF91F,0xF8E5,0xF5F9,0xF30A,0xF227,0xF2AB,0xF36F,0xF4F8,
	0xF7BB,0xF9F3,0xF9B9,0xF63E,0xF24D,0xF1FB,0xF462,0xF6AF,
	0xF771,0xF76D,0xF6E0,0xF5B5,0xF43F,0xF49A,0xF83A,0xFBF3,
	0xFC85,0xF967,0xF4F9,0xF211,0xF25A,0xF35E,0xF57F,0xF8EB,
	0xFB3B,0xFAFF,0xF853,0xF674,0xF579,0xF45B,0xF3BE,0xF607,
	0xF93E,0xF9CF,0xF730,0xF53B,0xF5C7,0xF7E7,0xF95A,0xF8CF,
	0xF836,0xF71E,0xF52E,0xF48D,0xF72E,0xFBEF,0xFF04,0xFDC5,
	0xFA2B,0xF5FA,0xF570,0xFA40,0xFACA,0xF9CE,0xF974,0xF8F2,
	0xF9BA,0xFBBD,0xFED7,0x0090,0xFC9B,0xF5C6,0xF2DF,0xF5BB,
	0xFA27,0xFCFF,0xFD9A,0xFD3F,0xFCEC,0xFB07,0xF8D4,0xF878,
	0xF8FF,0xF8DD,0xF956,0xFAC9,0xFC65,0xFBEC,0xFAF1,0xFB4D,
	0xFD39,0xFE78,0xFE23,0xFD9B,0xFD20,0xFBE8,0xF976,0xF7CA,
	0xF97F,0xFEA3,0x03D5,0x0563,0x02E6,0xFF56,0xFBCD,0xF827,
	0xF764,0xFA56,0xFEF6,0x0155,0x0042,0xFE2A,0xFE38,0xFF22,
	0xFE8D,0xFDE2,0xFE63,0xFE9F,0xFCD9,0xFB29,0xFB89,0xFFD1,
	0x0125,0xFE86,0xFE2E,0x00F6,0x03A4,0x0410,0x0359,0x0234,
	0xFF81,0xFA51,0xF70F,0xFA31,0x00DC,0x065D,0x0742,0x055B,
	0x0241,0xFFC1,0xFD6D,0xFBC0,0xFC1B,0xFC21,0xFC2F,0xFEF7,
	0x03E2,0x05B8,0x036B,0xFE6B,0xFC20,0xFD0B,0xFE07,0xFDAE,
	0xFC33,0xFA0D,0xF85C,0xF904,0xFDA4,0x044C,0x074D,0x048E,
	0xFDAA,0xF82D,0xF760,0xF855,0xF8A6,0xFA83,0xFF50,0x020A,
	0x01E4,0x0062,0xFDA7,0xFAE8,0xFA43,0xFCCD,0x00EB,0x0303,
	0xFF95,0xF8D7,0xF424,0xF51B,0xFA36,0xFFFC,0x041D,0x04CB,
	0x0121,0xFA5A,0xF4F6,0xF445,0xF81F,0xFC63,0xFF5F,0x00C3,
	0x00C4,0xFF80,0xFD54,0xFAA1,0xF934,0xF910,0xF991,0xF9DF,
	0xFB3F,0xFE00,0xFFEF,0xFF6A,0xFD68,0xFBC3,0xFBBA,0xFAEF,
	0xFABF,0xFBE0,0xFD5B,0xFDE8,0xFBD6,0xFB02,0xFDB4,0x017A,
	0x01E3,0xFFF8,0xFCB8,0xF95D,0xF7D1,0xF8DC,0xFB67,0xFE4B,
	0x0013,0x0077,0x0153,0x02C0,0x017D,0xFD41,0xF81A,0xF54B,
	0xF6FB,0xFC41,0x0072,0x021D,0x0108,0x0012,0xFF2B,0xFE75,
	0xFE7C,0x00EF,0xFEB5,0xFBE7,0xF9EA,0xF869,0xFB0D,0x0010,
	0x03D8,0x0508,0x0473,0x01D9,0xFFC9,0xFD55,0xFB6B,0xF9F3,
	0xF9BF,0xFB86,0xFFEE,0x0541,0x083D,0x06A3,0x0202,0xFD38,
	0xFC50,0xFEE7,0xFFE9,0xFEA0,0xFC7A,0xFC44,0xFF3B,0x0324,
	0x05ED,0x06A2,0x053F,0x01FA,0xFE50,0xFCD6,0xFCDB,0xFD3A,
	0xFE32,0x0136,0x04DC,0x07C1,0x0754,0x0541,0x02C1,0xFFC1,
	0xFC68,0xFBE5,0xFF1C,0x028A,0x0340,0x01E8,0x02AE,0x04F8,
	0x0616,0x0487,0x02F1,0x0290,0x00A0,0xFD32,0xFC43,0xFF10,
	0x0206,0x0080,0xFF85,0x00DD,0x0318,0x02E0,0x00D3,0xFF69,
	0xFECA,0xFD91,0xFB66,0xFA4F,0xFBEF,0x001C,0x02BB,0x0321,
	0x0257,0x01DD,0x0293,0x0272,0x0056,0xFEA3,0xFCF3,0xFAA6,
	0xFA11,0xFCE9,0x01F3,0x05ED,0x080E,0x076E,0x048C,0x0164,
	0xFDDC,0xFBF3,0xFB9A,0xFD41,0xFE98,0x0036,0x03FA,0x0871,
	0x09B6,0x068B,0x027F,0xFFAB,0xFE7B,0xFC5F,0xFAE9,0xFD47,
	0x0209,0x05A9,0x064F,0x050A,0x0229,0xFF05,0xFE5E,0x00C2,
	0x03D1,0x04CC,0x03E6,0x02CA,0x01A4,0x014C,0x0188,0x031D,
	0x04C1,0x0494,0x0394,0x03AC,0x04FE,0x0367,0xFFBC,0xFE68,
	0x00E9,0x031A,0x030B,0x0240,0x033B,0x03B9,0x020B,0x0137,
	0x0256,0x0334,0x0033,0xFCA2,0xFCEC,0x01D7,0x04A4,0x048C,
	0x0366,0x022F,0x00C2,0xFEF0,0xFE35,0xFFBC,0x0146,0x01F7,
	0x01B4,0x020E,0x02A3,0x0154,0xFFA6,0xFF9A,0x01D0,0x0402,
	0x04F9,0x0468,0x01C4,0xFE0C,0xFC0B,0xFE4D,0x02C8,0x0649,
	0x073F,0x05B2,0x030D,0xFF5E,0xFB9A,0xFA08,0xFC7A,0x00AE,
	0x04D6,0x06E7,0x084B,0x0630,0xFF5F,0xFBAF,0xFC6A,0x00B6,
	0x0522,0x0614,0x02C5,0xFD38,0xFAF2,0xFDA5,0x0379,0x0841,
	0x0928,0x0619,0x013D,0xFDA2,0xFCF4,0xFEDB,0x0075,0xFFC7,
	0xFF58,0x0105,0x0446,0x0736,0x085C,0x05DB,0xFF75,0xF927,
	0xF7DA,0xFBD4,0x0154,0x041E,0x039F,0x018C,0x0037,0x0056,
	0x0193,0x02BC,0x0229,0xFF4B,0xFCCF,0xFB7C,0xFC4B,0xFDF6,
	0x005C,0x036F,0x054C,0x0482,0x0281,0xFFF7,0xFD55,0xFB39,
	0xFBF7,0xFEFB,0x0156,0x020F,0x00EB,0xFED9,0xFDB2,0x00B9,
	0x03B1,0x0561,0x0418,0x00F2,0xFE2B,0xFD81,0xFE0D,0xFE27,
	0xFE93,0xFF8F,0x023D,0x06B9,0x0A44,0x0854,0x0180,0xFA01,
	0xF62F,0xF954,0x0074,0x07F5,0x09EE,0x04C7,0xFF12,0xFEDD,
	0x013B,0x0344,0x0361,0x0005,0xFB74,0xF955,0xFCA6,0x0300,
	0x0747,0x0604,0x01F9,0xFD2A,0xFC36,0xFED7,0x0197,0x01E9,
	0xFFE7,0xFD90,0xFD3C,0xFEF0,0x0079,0x025F,0x03A0,0x02DD,
	0x0216,0x01E0,0xFFAD,0xFB78,0xF852,0xF9E2,0xFFEE,0x0636,
	0x08EB,0x0650,0xFEE3,0xF730,0xF4DB,0xF885,0xFE97,0x01F4,
	0x013C,0xFF05,0xFDCC,0xFE25,0xFD80,0xFC9F,0xFDD4,0xFF91,
	0x0199,0x0214,0x002D,0xFCEC,0xF9FA,0xF88F,0xFA3E,0xFF30,
	0x03E0,0x04E2,0x01E6,0xFD17,0xF938,0xF98A,0xFC2D,0xFEE0,
	0x003F,0xFF4D,0xFC55,0xF955,0xF948,0xFC8F,0x016C,0x04A9,
	0x04C0,0x0224,0xFDC0,0xF9B8,0xF81F,0xFA4A,0xFF5C,0x02E7,
	0x0178,0xFDD5,0xFC6B,0xFDD6,0x00C2,0x02AF,0x0325,0x00B4,
	0xFB67,0xF6F3,0xF714,0xFBB1,0x01DD,0x063F,0x0694,0x0340,
	0xFFC8,0xF978,0xF320,0xF699,0xFE5D,0x0518,0x0594,0x024B,
	0xFF34,0xFCFA,0xFC21,0xFCB2,0xFDF6,0xFF90,0x004B,0xFFA6,
	0xFFDF,0xFF2E,0xFDB3,0xFAB6,0xFA85,0x0030,0x0754,0x09BB,
	0x04B3,0xFB90,0xF510,0xF48C,0xF873,0xFF87,0x066D,0x0A02,
	0x084C,0x0240,0xFB80,0xF807,0xF92E,0xFCF5,0x01AE,0x0498,
	0x0493,0x00B8,0xFB4F,0xF848,0xFA61,0xFED5,0x02B8,0x04CE,
	0x04AD,0x013E,0xFC19,0xF87D,0xF7C7,0xFA8F,0xFF7A,0x0486,
	0x07AC,0x060F,0xFFBB,0xF93E,0xF724,0xFAA6,0x0090,0x04AF,
	0x03C9,0xFFAA,0xFBC4,0xF834,0xF7EA,0xFAB0,0xFFA6,0x044B,
	0x05EF,0x0407,0xFEDA,0xF881,0xF4B6,0xF563,0xFA41,0x009E,
	0x04D4,0x04B3,0x0312,0xFFD5,0xFD76,0xFDB7,0xFD7A,0xFDA6,
	0xFEE1,0x017E,0x02F6,0x0275,0xFF60,0xFB9C,0xFBAD,0x0070,
	0x06C0,0x0A03,0x077F,0xFF4D,0xF634,0xF330,0xF910,0x03B4,
	0x0AE4,0x09FF,0x0465,0xFFF1,0xFF88,0xFF24,0xFEE4,0x0043,
	0x00F5,0x006E,0x009C,0x0237,0x039A,0x0319,0x02CE,0x03BC,
	0x04F9,0x0460,0x0300,0x0095,0xFE70,0xFDEE,0x00B2,0x05E4,
	0x095D,0x0857,0x05AB,0x0359,0x02BB,0x01A1,0xFFDA,0xFFB5,
	0x01F6,0x056A,0x0843,0x089B,0x0767,0x0473,0x0092,0xFF27,
	0x0154,0x053D,0x061C,0x039B,0x01B5,0x02F1,0x0608,0x07E1,
	0x06C2,0x0368,0xFF5B,0xFCB4,0xFD38,0x024D,0x08B1,0x0BAA,
	0x08AD,0x01A2,0xFC8E,0xFC79,0xFF6F,0x0304,0x04A4,0x0532,
	0x0483,0x01EA,0xFEFE,0xFEE9,0x01F1,0x0504,0x0537,0x043E,
	0x0361,0x0171,0xFD37,0xF9FD,0xFA99,0xFFF4,0x07BF,0x0CC6,
	0x0A10,0x01C0,0xFD0B,0xF8EA,0xF985,0xFED8,0x0597,0x089C,
	0x0480,0xFD25,0xFAC6,0xFF66,0x0443,0x0469,0x01E7,0x00BC,
	0x00A2,0x0017,0xFE12,0xFBF1,0xFBB9,0xFCD4,0xFF66,0x03FD,
	0x0868,0x08D5,0x0263,0xF7E0,0xF2EA,0xF752,0xFFD4,0x05A4,
	0x068C,0x026B,0xFD30,0xFA4C,0xFB77,0xFF19,0x024D,0x0323,
	0x0088,0xFC4F,0xFAC6,0xFCE1,0xFFA1,0x0063,0xFF3C,0x0014,
	0x0362,0x058A,0x023A,0xFC4B,0xF90A,0xF967,0xFC31,0x003E,
	0x0443,0x052F,0x027A,0xFCD0,0xF9BC,0xFB32,0x0030,0x0289,
	0x01A7,0x0153,0x02AB,0x0313,0x00C3,0xFCF2,0xFBEC,0xFF08,
	0x026F,0x041D,0x032A,0x0173,0xFEDF,0xFCD9,0xFC68,0xFE47,
	0x01A6,0x0392,0x0380,0x038A,0x02A5,0x0177,0xFF93,0xFB58,
	0xF8D3,0xFC7D,0x0330,0x0653,0x049F,0x00B8,0xFCA4,0xFA9E,
	0xFBB1,0xFF3D,0x020D,0x021E,0xFF6C,0xFC4C,0xFBB6,0xFE50,
	0x00DF,0x0182,0x0024,0xFE45,0xFC67,0xFC33,0xFBB1,0xFBBF,
	0xFCE1,0xFE91,0x006B,0x0292,0x035C,0x012A,0xFDA1,0xFB0B,
	0xFA08,0xFA42,0xFB8A,0xFE15,0xFF75,0xFE8E,0xFD4F,0xFD97,
	0xFF36,0x0027,0xFEE9,0xFC1F,0xFA4B,0xFB13,0xFDB3,0xFE7A,
	0xFD1C,0xFB69,0xFBEC,0xFE5A,0x0079,0x00D9,0xFFC3,0xFD72,
	0xFBE0,0xFCA7,0xFEBE,0x004C,0xFEDD,0xFA67,0xF724,0xF97E,
	0x0060,0x0550,0x050A,0x01C5,0xFE1E,0xFB8C,0xFAD6,0xFA87,
	0xFAA2,0xFA73,0xFB30,0xFFB8,0x066D,0x08F5,0x042C,0xFBC1,
	0xF620,0xF618,0xFA4B,0xFE8F,0x0137,0x013B,0x0066,0xFFC1,
	0x0176,0x02B0,0x0102,0xFBAF,0xF837,0xF9DC,0xFFEE,0x0563,
	0x0796,0x00D2,0xFAD1,0xF914,0xFB57,0x01C2,0x0698,0x069B,
	0x022B,0xFBC8,0xF714,0xF71D,0xFAA7,0x00BA,0x0629,0x07CE,
	0x067C,0x0350,0xFED3,0xFB09,0xF879,0xF82E,0xFB43,0x00AA,
	0x05FA,0x068E,0x0322,0xFE31,0xFBC1,0xFD56,0x00D6,0x0350,
	0x0225,0xFE9E,0xFB0E,0xFA9F,0xFE38,0x03A8,0x05F8,0x040E,
	0x000C,0xFD64,0xFC73,0xFD41,0xFE17,0xFEC8,0x0037,0x0263,
	0x0343,0x01A6,0xFF18,0xFD6A,0xFE3F,0x01F4,0x04F1,0x0405,
	0xFF5E,0xFA4C,0xF85E,0xFAB0,0xFF38,0x0396,0x0603,0x0580,
	0x017B,0xFD9E,0xFA75,0xF790,0xF6DE,0xF80B,0xFB7D,0xFF6B,
	0x02AB,0x02A0,0xFFCF,0xFD7C,0xFDA2,0xFF39,0xFF8C,0xFD23,
	0xF97E,0xF907,0xFBB4,0xFEEF,0x0168,0x0121,0xFEAE,0xFDE0,
	0xFFAB,0x0107,0x0078,0xFE93,0xFBD8,0xF946,0xF907,0xFD5A,
	0x0362,0x066C,0x04CD,0x004B,0xFD53,0xFC2F,0xFCB9,0xFE6D,
	0xFFAF,0xFFB6,0xFDD7,0xFEB7,0x0100,0x02E6,0x0484,0x03F8,
	0x01FC,0x001C,0xFF29,0xFE73,0xFD85,0xFD12,0xFE18,0xFFB2,
	0x0172,0x0510,0x0879,0x0759,0x0292,0xFED3,0xFDAA,0xFDF2,
	0xFD32,0xFDD6,0xFFEA,0x0207,0x048F,0x066C,0x06A0,0x0500,
	0x01AD,0xFD02,0xFA23,0xFA61,0xFE37,0x02A7,0x042C,0x0283,
	0x008A,0x0062,0x01DE,0x0328,0x0309,0x01E8,0xFECC,0xFB48,
	0xF8D6,0xF96A,0xFDD8,0x03F0,0x07CF,0x06D5,0x03DE,0x0178,
	0xFE52,0xFA2C,0xF7E5,0xFB09,0x018A,0x05B9,0x04E9,0x00DC,
	0xFE55,0xFE45,0xFFE1,0x02D3,0x0662,0x07A7,0x04E2,0xFD9A,
	0xF7A8,0xF76C,0xFC53,0x020E,0x0632,0x07FB,0x07FD,0x04EF,
	0xFD92,0xFC38,0xFE90,0xFF35,0xFF50,0xFE74,0xFF4A,0x027C,
	0x0522,0x04C1,0x023D,0x00C8,0x01A9,0x025D,0x0119,0xFE35,
	0xFCDD,0xFCDD,0xFE46,0x0183,0x05AF,0x080A,0x06A5,0x01EF,
	0xFD55,0xFB97,0xFBE2,0xFB7C,0xFC09,0xFF06,0x02BB,0x058C,
	0x0549,0x0365,0x0171,0xFF42,0xFCFF,0xFBF9,0xFC6E,0xFCA7,
	0xFCCB,0xFE01,0x010E,0x0485,0x065E,0x054C,0x0222,0xFEAD,
	0xFC1C,0xF9E2,0xF7F5,0xF887,0xFBA2,0x00CA,0x06C7,0x0B84,
	0x0B18,0x03E7,0xF9D5,0xF2EB,0xF427,0xFB8A,0x0436,0x05EC,
	0x053F,0x045B,0x0323,0x00C9,0xFF90,0x00D3,0x02CC,0x038A,
	0x0245,0xFEE4,0xFA4F,0xF6BB,0xF7BE,0xFF2E,0x0A7E,0x11DE,
	0x0F02,0x0323,0xF65F,0xEEAF,0xEE5F,0xF5BA,0x018D,0x0A24,
	0x0C91,0x0919,0x0228,0xFCC5,0xF9A4,0xF935,0xFA69,0xFD62,
	0x00E0,0x02EB,0x00A3,0xFB70,0xF7BC,0xF96F,0x0037,0x06AA,
	0x093D,0x06FE,0xFF72,0xF44F,0xEE2E,0xEF54,0xF76B,0x03CC,
	0x0CD3,0x0D37,0x0574,0xFAEF,0xF406,0xF359,0xF654,0xFBE2,
	0x01C4,0x02E0,0xFEFC,0xFADD,0xF9FD,0xFB4E,0xFB7F,0xFBDF,
	0xFEC1,0x01BA,0x0014,0xF9C3,0xF4CC,0xF451,0xF7F1,0xFCEF,
	0x0438,0x09B0,0x07D1,0xFE5F,0xF356,0xEE39,0xF2F6,0xFC54,
	0x045A,0x0856,0x062B,0xFF9A,0xF8C7,0xF63C,0xF90E,0xFCC1,
	0xFEE5,0x00C0,0x015C,0xFFDD,0xFC0B,0xF83F,0xF8B5,0xFC54,
	0x00DD,0x03DF,0x029E,0xFD96,0xF777,0xF3A7,0xF630,0xFF3C,
	0x06F2,0x0833,0x02D9,0xFC4C,0xF766,0xF4CD,0xF4F7,0xF9BE,
	0x0097,0x04C9,0x031A,0xFF62,0xFDC7,0xFD24,0xFA91,0xFA1F,
	0xFC78,0xFF73,0x0372,0x027D,0xFE96,0xFBB4,0xFB16,0xFAFC,
	0xFBDB,0xFF31,0x037D,0x03A0,0xFEB6,0xF9D5,0xFAAB,0xFF4E,
	0x0154,0xFFFD,0xFEFF,0xFF7E,0xFF24,0xFE4B,0xFEAB,0x00F5,
	0x01D2,0x010A,0x004A,0xFF9B,0xFE9C,0xFCC2,0xFC55,0xFE52,
	0x0163,0x0274,0x00A7,0xFF96,0x00E7,0x01B5,0x0173,0x0074,
	0xFF64,0xFF0A,0xFF0B,0xFF85,0xFFC2,0xFFA2,0xFF30,0xFF46,
	0x00BD,0x0432,0x0705,0x05BF,0xFFA6,0xF8EA,0xF5DF,0xF9D0,
	0x01CE,0x081F,0x0856,0x030E,0xFD44,0xFA32,0xFB50,0xFE0A,
	0x00DE,0x0244,0xFFA3,0xFBE1,0xFA2B,0xFA33,0xFA9F,0xFBD7,
	0xFF4C,0x0451,0x08B6,0x0813,0x017D,0xF880,0xF366,0xF501,
	0xFB5D,0x0314,0x0858,0x0850,0x03DA,0xFD4D,0xF909,0xF9B4,
	0xFCF7,0xFFCC,0x0219,0x0472,0x03C8,0xFF7E,0xFB20,0xFA53,
	0xFE33,0x02E5,0x05B6,0x068D,0x044F,0xFEE9,0xF9FB,0xF902,
	0xFDA5,0x0305,0x052E,0x05D6,0x0354,0x017F,0x00A3,0xFE47,
	0xFC22,0xFC48,0xFDF4,0x00F6,0x03AF,0x054A,0x0385,0xFDFB,
	0xF93B,0xFB5B,0x031A,0x0934,0x08D6,0x0243,0xFBAB,0xF97B,
	0xFBCD,0x0009,0x04BD,0x0742,0x0459,0xFEE7,0xFD11,0xFF03,
	0x0186,0x00A1,0xFE9F,0xFF51,0x0267,0x03BA,0x011E,0xFCBF,
	0xF8FC,0xF902,0xFDE2,0x0558,0x0A59,0x07E1,0xFE00,0xF567,
	0xF506,0xFB38,0x018C,0x0538,0x04BD,0x013E,0xFCF7,0xFA74,
	0xFBD5,0xFFC7,0x01CA,0x011B,0x00F6,0x0200,0x00CA,0xFC9E,
	0xF96D,0xF9D8,0xFDBA,0x022D,0x04CA,0x0519,0x0340,0xFE64,
	0xF98B,0xF7DB,0xFA8F,0xFF4E,0x01FF,0x0252,0x03A7,0x03A9,
	0xFFA7,0xFCCE,0xF91B,0xF9B6,0xFE3E,0x0279,0x056A,0x04BB,
	0x0151,0xFD3B,0xFB40,0xFD38,0x0064,0x0335,0x0304,0x0128,
	0xFEED,0xFD32,0xFBC4,0xFC20,0xFE84,0x00BE,0x01D8,0x036F,
	0x04E6,0x03A4,0xFEEE,0xFA2B,0xF890,0xFAE2,0xFF7D,0x0338,
	0x03DD,0x0235,0x0135,0x0039,0xFFB6,0xFF59,0xFF56,0xFEF4,
	0xFE33,0xFF04,0x0076,0x009D,0xFE91,0xFD74,0xFEE2,0x01E8,
	0x0532,0x05B1,0x02C1,0xFD06,0xF758,0xF5EF,0xFB8A,0x041C,
	0x0908,0x06F8,0x018D,0xFE50,0xFE31,0x0086,0x0123,0x00E6,
	0x01B2,0x01EC,0x01C4,0x02FB,0x0472,0x03CC,0x00AB,0xFF07,
	0x0140,0x04A5,0x0547,0x01F4,0xFCFA,0xF995,0xF94B,0xFD0D,
	0x031F,0x08B3,0x0ADF,0x065A,0xFE90,0xF958,0xF8DB,0xFA04,
	0xFCAE,0x0028,0x03FE,0x060A,0x046F,0x00BE,0xFD9E,0xFC1C,
	0xFD42,0xFF37,0x0003,0xFF93,0xFEBA,0xFDCE,0xFC3A,0xFC23,
	0xFE71,0x024F,0x0378,0x0167,0xFFA8,0xFC6A,0xF978,0xF887,
	0xFB11,0xFFE7,0x0422,0x03D6,0x00C2,0xFDCA,0xFCD6,0xFC8B,
	0xFBA7,0xFA5C,0xFA31,0xFB9D,0xFDA0,0xFFD7,0x00C7,0x0035,
	0xFD11,0xF940,0xF7D4,0xFAAE,0xFEB0,0x00AD,0xFEA5,0xFA6A,
	0xF833,0xF9A0,0xFE1F,0x01E1,0x02BC,0x005B,0xFC18,0xF8C1,
	0xF87B,0xFA4B,0xFBA5,0xFC25,0xFCBF,0xFDF0,0xFFB2,0x0082,
	0xFF77,0xFBD6,0xF8CB,0xF8B7,0xFA47,0xFCB1,0xFED5,0xFF1C,
	0xFDA6,0xFB85,0xFBA4,0xFDD7,0xFFE2,0xFF8B,0xFCF9,0xF9E8,
	0xF7A1,0xF7D1,0xF98E,0xFD41,0x0056,0x0236,0x0209,0xFFA0,
	0xFCF9,0xFB35,0xF9D9,0xF9D9,0xFBE4,0xFE0E,0xFF5D,0x01D5,
	0x0058,0x0013,0x0075,0xFF63,0xFEAA,0xFEE8,0xFECA,0xFDC4,
	0xFCB0,0xFBF3,0xFCCB,0xFEED,0x0231,0x045C,0x047B,0x0270,
	0xFF23,0xFB9A,0xF99D,0xFB14,0xFE9F,0x0135,0x01AE,0x014E,
	0x00E5,0x00EA,0x0065,0xFF21,0xFEEE,0x000A,0x00B5,0x004F,
	0xFEB5,0xFDD4,0xFE91,0xFF7B,0x0183,0x0410,0x061C,0x04AC,
	0x001C,0xFB7C,0xFA43,0xFC63,0xFFA3,0x02C4,0x0508,0x054D,
	0x02C4,0xFEEC,0xFCBA,0xFCD9,0xFEC4,0x0087,0x013A,0x0024,
	0xFEB8,0xFE24,0xFD91,0xFE57,0x0021,0x016F,0x011B,0xFD9B,
	0xFB54,0xFA9A,0xFAEC,0xFC35,0xFDDE,0xFF48,0x000B,0xFFE4,
	0xFEA9,0xFD7B,0xFD36,0xFD75,0xFE4B,0xFED2,0xFF9D,0xFF19,
	0xFDFF,0xFC6C,0xFBB9,0xFDA8,0x009D,0x01B3,0x0120,0xFF65,
	0xFD5B,0xFCB9,0xFD92,0xFF4E,0x0104,0x01AF,0x00C5,0x007D,
	0x0089,0x0033,0xFF8C,0xFFEC,0x0089,0x00B9,0x0099,0xFFFF,
	0x00DE,0x0167,0x02A3,0x020E,0xFFC2,0xFF4B,0xFF70,0xFF74,
	0xFEBB,0xFE60,0xFEB5,0xFF76,0x004E,0x014A,0x0232,0x023A,
	0x0169,0x0013,0xFE6D,0xFF22,0x00D1,0x0240,0x0261,0x018F,
	0x009B,0xFFFD,0x000B,0x0072,0x0167,0x0180,0x009E,0xFF5A,
	0xFE9C,0xFED8,0xFF83,0x002E,0x00DA,0x0148,0x0137,0xFFFD,
	0xFE91,0xFD38,0xFCE0,0xFDEA,0xFF31,0x001A,0x0045,0x0075,
	0x008B,0xFFEE,0xFF42,0xFE51,0xFEAA,0xFF46,0x002F,0x0051,
	0xFFFF,0xFF19,0xFEE0,0xFF3D,0xFF66,0x00A0,0x0199,0x015B,
	0xFF6A,0xFDA6,0xFDA7,0xFF42,0xFFF8,0x006C,0x010B,0x0107,
	0x0030,0xFF5E,0xFF1E,0xFEC5,0xFED7,0xFF2B,0xFFE7,0xFE2C,
	0xFF12,0xFF6D,0xFD76,0xFCD5,0xFC72,0xFC36,0xFCC8,0xFC75,
	0xFB89,0xFA57,0xF991,0xF8EB,0xF8D8,0xF98D,0xF9E8,0xF964,
	0xF85A,0xF748,0xF71B,0xF71E,0xF6B6,0xF541,0xF4B0,0xF5DD,
	0xF6D6,0xF6A2,0xF5A6,0xF4D1,0xF41A,0xF3D3,0xF3AE,0xF336,
	0xF267,0xF1B5,0xF0A8,0xEFD2,0xEFBD,0xEF62,0xEECF,0xEE33,
	0xED64,0xECAF,0xEBD1,0xEB5A,0xEAFE,0xEAB1,0xE9F8,0xE9B7,
	0xE9FC,0xE934,0xE8CD,0xE8FA,0xE8DD,0xE87D,0xE7DC,0xE7E8,
	0xE7A9,0xE7BB,0xE75D,0xE6FC,0xE7D8,0xEA61,0xE9A2,0xE90A,
	0xE8B2,0xE866,0xE847,0xE7EA,0xE80E,0xE835,0xE7DF,0xE7DE,
	0xE82E,0xE897,0xE905,0xE8FC,0xE926,0xE93D,0xE99B,0xE974,
	0xE8FE,0xE9D8,0xEAC8,0xEA45,0xEA08,0xEAF4,0xEB8F,0xEB80,
	0xEBDD,0xEC4C,0xEC97,0xED0F,0xED3B,0xEDB2,0xEE19,0xEE54,
	0xEEE2,0xEF0F,0xEF57,0xEF82,0xF00E,0xF06C,0xF14D,0xF1CE,
	0xF261,0xF2E4,0xF235,0xF2E2,0xF473,0xF4F8,0xF539,0xF585,
	0xF5B4,0xF65C,0xF6B0,0xF6E8,0xF757,0xF744,0xF76B,0xF81D,
	0xF7FE,0xF789,0xF841,0xF899,0xF91E,0xF9C7,0xFA29,0xFAC1,
	0xFAFE,0xFB13,0xFBC5,0xFC39,0xFD0C,0xFD81,0xFDFA,0xFE36,
	0xFE10,0xFE6E,0xFF11,0xFF97,0xFFBA,0x0010,0x00CB,0x010A,
	0x0172,0x01C5,0x01C2,0x025A,0x031C,0x0364,0x038D,0x0410,
	0x046A,0x04CE,0x0509,0x0536,0x05A4,0x05B3,0x05C9,0x0607,
	0x0621,0x068F,0x06CA,0x06A5,0x06C9,0x0742,0x075D,0x0784,
	0x0811,0x0802,0x0804,0x0831,0x08BA,0x089E,0x08F5,0x0935,
	0x0A10,0x09F9,0x09C7,0x0A75,0x0AA3,0x0A09,0x0B37,0x0BBB,
	0x0A7C,0x0BD8,0x0BDB,0x0BF9,0x0C53,0x0CAC,0x0C33,0x0C62,
	0x0CA2,0x0CFC,0x0D24,0x0D2C,0x0D37,0x0D30,0x0D84,0x0D4E,
	0x0D75,0x0D3B,0x0DBF,0x0DC9,0x0D96,0x0DD7,0x0E47,0x0E7E,
	0x0E61,0x0E97,0x0E3F,0x0E5F,0x0E51,0x0E7C,0x0E99,0x0F0F,
	0x0F0A,0x0EE6,0x0EC2,0x0EC9,0x0EB6,0x0E9F,0x0EEA,0x0EE2,
	0x0F2B,0x0EB1,0x0E8A,0x0EC4,0x0EEE,0x0EED,0x0E87,0x0E6F,
	0x0E45,0x0E54,0x0E75,0x0E83,0x0E58,0x0E8B,0x0EB9,0x0E86,
	0x0E78,0x0ED3,0x0EB8,0x0EB1,0x0E8D,0x0E1E,0x0CD1,0x0B6A,
	0x0C61,0x0C76,0x0C59,0x0C31,0x0C0B,0x0C7E,0x0C6C,0x0C55,
	0x0C2F,0x0C06,0x0B8A,0x0BEE,0x0C3E,0x0BDD,0x0C13,0x0C5E,
	0x0CDC,0x0C3E,0x0B60,0x0C14,0x0C92,0x0C1D,0x0C29,0x0C59,
	0x0C10,0x0BB9,0x0C1A,0x0BE2,0x0BD6,0x0BBF,0x0C06,0x0C16,
	0x0BE1,0x0B28,0x0B3B,0x0B44,0x0B4D,0x0B27,0x0AF1,0x0AC9,
	0x0AB9,0x0AEC,0x0B84,0x0A2C,0x0992,0x09B1,0x096D,0x0972,
	0x09C1,0x09D0,0x0984,0x09BB,0x09E0,0x0A35,0x0A91,0x0A7B,
	0x0AC6,0x0B17,0x0AB9,0x0A46,0x0A50,0x0A26,0x0A17,0x09FB,
	0x09EC,0x09D2,0x0972,0x0901,0x0965,0x095B,0x0936,0x090B,
	0x08C7,0x0871,0x0812,0x082E,0x0826,0x0820,0x0816,0x0821,
	0x07CB,0x07EB,0x0816,0x07F1,0x078D,0x0773,0x070E,0x06DA,
	0x069B,0x06AF,0x06A4,0x064C,0x0651,0x0635,0x05BE,0x05C0,
	0x05A4,0x0531,0x0570,0x0555,0x050C,0x051C,0x04FB,0x0578,
	0x0598,0x05A9,0x0590,0x058A,0x04EB,0x04D6,0x04C4,0x04BC,
	0x045D,0x0464,0x048A,0x04AC,0x047E,0x052B,0x0455,0x030B,
	0x051B,0x0444,0x03B4,0x041B,0x03FF,0x03A6,0x03AC,0x03FC,
	0x03F9,0x03A2,0x0330,0x037C,0x036B,0x032B,0x02EA,0x030E,
	0x02F1,0x0303,0x02E3,0x0344,0x0356,0x02B3,0x0261,0x0263,
	0x0265,0x02A7,0x02B7,0x0246,0x026D,0x020E,0x0234,0x0288,
	0x0235,0x01FE,0x01BC,0x016E,0x015A,0x017A,0x01B5,0x016D,
	0x0122,0x011A,0x00F0,0x012B,0x013B,0x016B,0x00E9,0x00D2,
	0x00C6,0x00D6,0x00DA,0x010F,0x0130,0x00E5,0x0096,0x00D2,
	0x008E,0x00AB,0x008C,0x00A8,0x00E4,0x00B7,0x0082,0x009B,
	0x00F0,0x0114,0x00C2,0x00B9,0x00D1,0x00B4,0x0101,0x011B,
	0x013C,0x00EA,0x00DB,0x01D8,0x00FF,0x0059,0x0014,0x000D,
	0x0043,0x0031,0x0075,0xF775,0xF2BE,0xF8D7,0xFC70,0xFD28,
	0xFC4C,0xFD71,0x01EB,0x0735,0x080D,0x0364,0xFDFE,0xFCAC,
	0xFDF5,0x0096,0x0301,0x050F,0x0590,0x0317,0x00BD,0x00CE,
	0x02F8,0x03F2,0x02AF,0x0153,0x0224,0x038F,0x03B5,0x0255,
	0x0157,0x016B,0x0342,0x0537,0x0641,0x058A,0x0322,0xFFF6,
	0xFE83,0xFFB2,0x02F8,0x0531,0x04F8,0x0363,0x0184,0x00DA,
	0x006C,0x0064,0x00CA,0x00EA,0x00FE,0x00A9,0x00D1,0x010E,
	0x0126,0x008C,0x0035,0x00F5,0x0244,0x01DF,0x00F0,0xFF53,
	0xFE7A,0xFED4,0x0095,0x020A,0x02E4,0x02A4,0x0211,0xFF44,
	0xFE4A,0x0096,0x0060,0x007F,0x0089,0x005E,0x00CC,0x011E,
	0x00C3,0x0029,0xFF84,0xFF6B,0xFF56,0xFF67,0xFF32,0xFE58,
	0xFE10,0xFDF4,0xFE45,0xFF26,0xFFCB,0xFFB9,0xFED2,0xFE06,
	0xFDB2,0xFD53,0xFDA0,0xFE59,0xFE96,0xFEC3,0xFF0D,0xFF17,
	0xFF03,0xFEC4,0xFE98,0xFEA0,0xFE97,0xFED4,0xFEAB,0xFE5E,
	0xFE89,0xFE8A,0xFE7F,0xFECE,0xFEFE,0xFF26,0xFF10,0xFE72,
	0xFD81,0xFD5B,0xFD70,0xFDB7,0xFDED,0xFE91,0xFEAA,0xFEC3,
	0xFEAE,0xFDF4,0xFE14,0xFE43,0xFEA8,0x008D,0x009C,0x0044,
	0xFFA9,0xFF70,0xFF69,0xFF49,0xFF4D,0xFFAF,0xFFD3,0xFF70,
	0xFF27,0xFF0C,0xFED8,0xFF02,0xFF72,0xFF99,0xFF7A,0xFFB0,
	0xFE8A,0xFE66,0xFF32,0xFEEA,0xFDFB,0xFDC0,0xFEB1,0xFEAE,
	0xFEAA,0xFE80,0xFE9A,0xFE52,0xFDEF,0xFDDB,0xFE20,0xFDF2,
	0xFDF4,0xFDBD,0xFD9F,0xFDAC,0xFDF3,0xFDF1,0xFDDC,0xFDD2,
	0xFDD2,0xFDDE,0xFCEE,0xFC15,0xFCF3,0xFDA0,0xFDD4,0xFE11,
	0xFE2D,0xFE6E,0xFE86,0xFDE2,0xFD88,0xFD42,0xFD2C,0xFD37,
	0xFD22,0xFC92,0xFC8D,0xFC44,0xFC64,0xFC63,0xFC53,0xFC69,
	0xFC55,0xFBF5,0xFBF9,0xFC2D,0xFC45,0xFC91,0xFCA5,0xFCFE,
	0xFD05,0xFD2B,0xFD14,0xFCBD,0xFC8F,0xFCD9,0xFCD4,0xFC56,
	0xFCCC,0xFD00,0xFCE6,0xFCCF,0xFC66,0xFCD5,0xFCFE,0xFCDB,
	0xFCFC,0xFD1D,0xFCD4,0xFCB2,0xFCA2,0xFC88,0xFD31,0xFD89,
	0xFD37,0xFD0C,0xFCED,0xFCCC,0xFD55,0xFDA0,0xFE19,0xFDFF,
	0xFDCF,0xFD7B,0xFD78,0xFDAE,0xFDF3,0xFE00,0xFDDD,0xFDBB,
	0xFE74,0xFEAB,0xFE7A,0xFE7E,0xFEC2,0xFE7D,0xFE92,0x0076,
	0xFEB9,0xFEF5,0xFF36,0xFF30,0xFF3A,0xFFB4,0xFFE3,0xFFB0,
	0xFF83,0xFF7E,0xFF38,0xFEE6,0xFF81,0xFF62,0xFF5B,0xFF4B,
	0xFF16,0xFEFB,0xFF76,0xFF7B,0xFFA3,0xFFB4,0xFF4E,0xFF41,
	0xFFA6,0xFF8A,0xFF84,0xFF4D,0xFFA8,0x0000,0xFFEA,0xFFE6,
	0xFFFD,0xFFF2,0xFF9E,0xFF7B,0xFF9F,0xFFDD,0xFFF6,0x000C,
	0x0008,0xFFD5,0xFFA0,0xFFE0,0xFFF4,0xFFDA,0xFFE5,0x000E,
	0xFFF9,0xFFA6,0x0002,0x0014,0x0042,0xFFE1,0x0047,0x0042,
	0xFFCB,0xFFBB,0x0005,0xFFFD,0xFFEC,0xFFE3,0xFEC9,0xFCFA,
	0xFDAF,0xFDF3,0xFE03,0xFE0F,0xFE8F,0xFE81,0xFE88,0xFEBA,
	0xFF08,0xFF20,0xFF0F,0xFEC0,0xFEDE,0xFF07,0xFEEB,0xFEE6,
	0xFF87,0xFFB2,0xFE81,0xFEED,0xFF97,0xFF71,0xFFEC,0xFFF2,
	0xFFC4,0xFFBD,0x0001,0x0014,0x0039,0x0055,0x0047,0x002E,
	0x0043,0xFFFE,0xFFDA,0xFFDC,0xFFDC,0x00C8,0x00C0,0x00BA,
	0x00D7,0x00B0,0x01CE,0x013A,0xFFFE,0xFFDB,0xFFDD,0xFFF5,
	0x0037,0x007F,0x005C,0x0047,0x0043,0x0106,0x01DB,0x01E4,
	0x0249,0x0291,0x021F,0x01B2,0x01C0,0x018C,0x01A4,0x01F8,
	0x0228,0x01D3,0x01C1,0x01A0,0x0175,0x014C,0x0148,0x0132,
	0x016E,0x0169,0x010B,0x0113,0x0142,0x00F3,0x00C8,0x00B8,
	0x00D2,0x0096,0x0091,0x006B,0x005B,0x0053,0x002E,0x0017,
	0x0054,0x0062,0xFFF2,0xFFA7,0xFF90,0xFFD7,0xFFC8,0x0021,
	0x0062,0x001E,0xFF8A,0x0013,0xFFAC,0xFF83,0xFF9B,0xFFC2,
	0xFFE8,0xFFCE,0xFFC4,0xFFB3,0xFFFE,0x000D,0x0075,0x0022,
	0xFF36,0xFF2E,0xFF73,0xFF7E,0xFF99,0xFFE7,0x0030,0xFE60,
	0xFF55,0x005F,0xFF1E,0xFF3D,0xFF2E,0xFEFD,0xFF10,0xFF05,
	0xFEBD,0xFEBE,0xFF01,0xFEFF,0xFF53,0xFF43,0xFF57,0xFF82,
	0xFFA1,0xFF60,0xFF7F,0xFFC8,0x002C,0xFF9F,0xFF45,0xFF77,
	0xFFA9,0xFFDE,0xFF49,0xFF5A,0xFF24,0xFF03,0xFF11,0xFED2,
	0xFE64,0xFEF2,0xFEB6,0xFEC7,0xFF2F,0xFF1A,0xFF0A,0xFF19,
	0xFED8,0xFEF1,0xFF09,0xFF2B,0xFF3A,0xFF0A,0xFEC5,0xFEC6,
	0xFF28,0xFF0E,0xFF1E,0xFEDE,0xFEBF,0xFE6E,0xFE5A,0xFE4F,
	0xFF13,0xFF23,0xFEDB,0xFEED,0x0077,0x0227,0x0112,0x0102,
	0x00AD,0x006B,0x007D,0x00A0,0x006E,0x003D,0x000E,0x0027,
	0x0009,0xFFF2,0x0008,0xFFF9,0xFFDF,0xFFA7,0xFF71,0xFF08,
	0xFEEC,0xFFE0,0x0048,0xFFDC,0xFF48,0xFF6E,0xFEF0,0xFEE5,
	0xFF1C,0xFEE4,0xFF35,0xFF76,0xFF65,0xFF0B,0xFE92,0xFE75,
	0xFEC0,0xFEC1,0xFEE2,0xFEB2,0xFEE8,0xFEB8,0xFEB1,0xFE68,
	0xFEBB,0xFE76,0xFD29,0xFD54,0xFE68,0xFE8F,0xFEA5,0xFE32,
	0xFDD0,0xFDAC,0xFDB2,0xFDEF,0xFD90,0xFD49,0xFCF6,0xFCC0,
	0xFC44,0xFBE1,0xFC53,0xFCB8,0xFCDC,0xFC92,0xFC4B,0xFC26,
	0xFBE8,0xFC66,0xFC7D,0xFC50,0xFC53,0xFC21,0xFCD4,0xFCC4,
	0xFCB6,0xFCE4,0xFCA6,0xFCDD,0xFD0A,0xFD32,0xFD95,0xFD6D,
	0xFD2E,0xFCED,0xFD2A,0xFD82,0xFD45,0xFD25,0xFD0B,0xFCD6,
	0xFC68,0xFCE0,0xFD01,0xFCCF,0xFCB7,0xFCD4,0xFD1A,0xFD03,
	0xFD35,0xFCFF,0xFCAD,0xFC5A,0xFCC7,0xFCBD,0xFCC5,0xFCF7,
	0xFCEB,0xFC53,0xFC9C,0xFD50,0xFE0E,0xFDAF,0xFD5B,0xFD12,
	0xFDCA,0xFE2A,0xFE4A,0xFE5B,0xFE6D,0xFDDC,0xFF91,0xFE96,
	0xFDD6,0xFEE7,0xFE4F,0xFE61,0xFE75,0xFEA8,0xFECD,0xFF03,
	0xFEED,0xFEA4,0xFEA4,0xFEBE,0xFEE1,0xFF07,0xFF8F,0xFF8F,
	0xFF98,0xFF1B,0xFF47,0xFF6F,0xFFD7,0xFF9F,0xFFBD,0xFFD8,
	0xFFD4,0xFFF5,0xFFC0,0xFFC8,0x0004,0x002E,0x004B,0x0021,
	0x0027,0x001B,0xFFE6,0xFFBB,0x002D,0x0083,0x0024,0x0008,
	0x0042,0x0068,0x004B,0xFFE6,0x0006,0xFFFB,0xFFD6,0xFF7F,
	0xFF6C,0xFEFC,0xFECB,0xFEB5,0xFEBF,0xFEB4,0xFEE0,0xFECB,
	0xFE7D,0xFE0B,0xFDCB,0xFDC4,0xFD5F,0xFD27,0xFB18,0xFA27,
	0xFAAA,0xFAD9,0xFB0B,0xFADD,0xFB07,0xFACD,0xFAAE,0xFA6C,
	0xFA7F,0xFA9C,0xFA85,0xFA74,0xFA9F,0xFAD1,0xFAA4,0xFAAD,
	0xFB45,0xFA6F,0xFA3C,0xFB93,0xFB70,0xFB29,0xFB24,0xFB85,
	0xFB97,0xFB98,0xFB66,0xFBD3,0xFC04,0xFC19,0xFBE4,0xFBD5,
	0xFBE7,0xFBD0,0xFBF8,0xFBC4,0xFBE7,0xFC2C,0xFC1C,0xFC1D,
	0xFC33,0xFCE8,0xFE07,0xFD28,0xFC67,0xFC6C,0xFC68,0xFD13,
	0xFCE8,0xFD05,0xFCF0,0xFD64,0xFDB2,0xFE2F,0xFE6D,0xFEA2,
	0xFF36,0xFEDD,0xFEC5,0xFE54,0xFE5B,0xFE4B,0xFE71,0xFE48,
	0xFEC0,0xFEA6,0xFEB0,0xFEAC,0xFED8,0xFF57,0xFF20,0xFECF,
	0xFEB0,0xFED8,0xFE8B,0xFE78,0xFE7E,0xFE61,0xFE84,0xFE2E,
	0xFE55,0xFEC4,0xFED9,0xFEAE,0xFEB8,0xFF18,0xFEF1,0xFEF4,
	0xFF2B,0xFF3B,0xFEF6,0xFEC0,0xFF37,0xFF59,0xFF4E,0xFF48,
	0xFF62,0xFF68,0xFF94,0xFFBB,0xFFCB,0xFFEF,0x001E,0xFFF0,
	0xFFD9,0x0005,0x0020,0x0057,0xFFAA,0xFFE2,0x0014,0x000C,
	0x0008,0x005F,0x0079,0x004C,0x0079,0x0154,0x003C,0xFF88,
	0x01CC,0x00B8,0x007E,0x0121,0x00D8,0x00BD,0x00CA,0x00EC,
	0x00B8,0x00CB,0x00B3,0x00C8,0x00F4,0x0097,0x00EF,0x0120,
	0x010B,0x0114,0x0123,0x011A,0x00EC,0x00B3,0x0108,0x012F,
	0x0125,0x0152,0x019A,0x0181,0x01F2,0x020E,0x015C,0x0198,
	0x0187,0x01AD,0x01D3,0x01D1,0x0203,0x01D8,0x01A7,0x01B6,
	0x01CC,0x01D2,0x01A6,0x01B3,0x0191,0x01D1,0x016F,0x019E,
	0x0185,0x0176,0x014C,0x0135,0x01A8,0x01B0,0x0193,0x0192,
	0x0223,0x0221,0x0201,0x02BE,0x05A0,0x0539,0x0490,0x0452,
	0x0409,0x0419,0x0420,0x03E1,0x03E4,0x03D7,0x03E8,0x03C1,
	0x0377,0x03E7,0x03B5,0x03A8,0x038F,0x03B7,0x037A,0x030F,
	0x02CD,0x03B2,0x037E,0x026E,0x0278,0x02F0,0x02AB,0x027F,
	0x0260,0x0256,0x0211,0x01D2,0x01F0,0x01F3,0x0189,0x01D3,
	0x0227,0x01E6,0x01AD,0x01AD,0x0182,0x0184,0x0127,0x017F,
	0x01C9,0x00BA,0x0037,0x0166,0x01D3,0x01A9,0x0187,0x0181,
	0x012A,0x013B,0x0142,0x00ED,0x0098,0x0043,0x0033,0xFFF2,
	0xFF49,0xFEFC,0xFF44,0xFF78,0xFFAF,0xFF89,0xFF0D,0xFF43,
	0xFF3E,0xFF3B,0xFF39,0xFF3C,0xFF4E,0xFF62,0xFF80,0xFEED,
	0xFF16,0xFEE9,0xFEC8,0xFED7,0xFE81,0xFE52,0xFE9E,0xFE67,
	0xFE39,0xFE3A,0xFE99,0xFECD,0xFE88,0xFE50,0xFE81,0xFE92,
	0xFE5A,0xFE8A,0xFE1F,0xFE31,0xFE69,0xFE39,0xFE57,0xFE8E,
	0xFE38,0xFE0A,0xFDE8,0xFDBC,0xFDCA,0xFDBC,0xFDAE,0xFDAD,
	0xFD79,0xFD8D,0xFDBE,0xFDB3,0xFE03,0xFE26,0xFE2B,0xFEB6,
	0xFEE5,0xFE61,0xFE5B,0xFE8A,0xFDEC,0xFE4F,0xFFBE,0xFDF1,
	0xFE97,0xFEE7,0xFE85,0xFE85,0xFE81,0xFE56,0xFE86,0xFEC9,
	0xFE5C,0xFE87,0xFF0D,0xFF29,0xFECB,0xFEB6,0xFEDB,0xFEF4,
	0xFEC7,0xFEAD,0xFF3A,0xFF05,0xFEEA,0xFF2D,0xFF7D,0xFF88,
	0x0005,0xFFC7,0x0035,0x003B,0xFFBF,0xFFB0,0x0003,0x0018,
	0x0020,0x0033,0x0088,0x006F,0x0041,0x0011,0xFFE3,0x0013,
	0xFFF3,0xFFD6,0xFF90,0xFF87,0xFFAB,0xFF77,0xFF9C,0xFF82,
	0xFFC7,0x0012,0xFFDF,0x0018,0xFFE4,0xFF93,0x004E,0x0025,
	0xFFEC,0x0003,0x0039,0x0094,0x007D,0xFEDB,0xFD31,0xFDAA,
	0xFDD1,0xFDE8,0xFE2E,0xFE3D,0xFE75,0xFE44,0xFE1D,0xFE1A,
	0xFE75,0xFEB8,0xFE9F,0xFEF9,0xFF2C,0xFF78,0xFF73,0x001E,
	0x0004,0xFEF5,0xFF6C,0xFFCC,0xFF9E,0xFF9C,0x0002,0x0040,
	0xFFE7,0x0017,0x003E,0x0025,0x009C,0x0073,0x008C,0x00A7,
	0x0062,0x00B8,0x0125,0x00A6,0x007D,0x00AA,0x00AA,0x007E,
	0x008B,0x014B,0x016F,0x0050,0x0005,0x0032,0x0043,0x0083,
	0x00C4,0x00AF,0x0108,0x0123,0x017B,0x01FC,0x01FC,0x0276,
	0x0251,0x0226,0x025D,0x0247,0x01DC,0x01A5,0x01D0,0x0208,
	0x01A3,0x017F,0x0182,0x0169,0x0185,0x017B,0x0172,0x0163,
	0x0132,0x00F3,0x0118,0x00C9,0x0097,0x00ED,0x00B5,0x00AA,
	0x0086,0x0069,0x00B7,0x00A5,0x007C,0x0057,0x0046,0x0034,
	0xFFF4,0x0027,0x000A,0x0005,0xFFB5,0xFFB1,0xFF94,0xFFAD,
	0xFFB5,0xFFA8,0xFFB4,0x0003,0x0005,0xFFE8,0xFFFB,0xFFD3,
	0x0005,0x002E,0x003D,0xFFD7,0xFFF5,0xFFDE,0xFF99,0xFF32,
	0xFF63,0xFFBA,0xFF6B,0xFF61,0xFFBA,0xFFEA,0xFE07,0xFFD0,
	0x0045,0xFEE1,0xFF38,0xFF7D,0xFF8B,0xFFFF,0x001F,0xFFD5,
	0xFFBE,0xFFEC,0xFF8A,0xFF0A,0xFF34,0xFF4E,0xFF43,0xFF3C,
	0xFF78,0xFF3B,0xFF21,0xFF34,0xFF64,0xFF09,0xFF37,0xFF1C,
	0xFF21,0xFEFA,0xFED3,0xFEF2,0xFF1D,0xFF4A,0xFF2B,0xFF46,
	0xFF6D,0xFF5A,0xFF53,0xFF3B,0xFEF5,0xFF39,0xFF38,0xFF4C,
	0xFF5F,0xFF5C,0xFF7E,0xFF6F,0xFF83,0xFF57,0xFF5D,0xFFAD,
	0xFFB8,0xFFDE,0xFFB5,0xFF70,0xFF9B,0xFFA6,0xFFA8,0xFFA3,
	0xFFE4,0x0000,0x0014,0x0172,0x032E,0x0257,0x01DD,0x01D4,
	0x01BE,0x013E,0x0123,0x0116,0x00D6,0x00C4,0x009D,0x0099,
	0x00C4,0x00A2,0x0095,0x0067,0xFFF6,0xFFD5,0xFF79,0xFF23,
	0xFFDC,0x004F,0xFF98,0xFF14,0xFF74,0xFF32,0xFF3E,0xFF16,
	0xFEFB,0xFF41,0xFF79,0xFF40,0xFF53,0xFEF4,0xFE47,0xFE7F,
	0xFE92,0xFE93,0xFE5B,0xFE82,0xFE79,0xFE57,0xFE25,0xFE32,
	0xFDC1,0xFCBD,0xFDA3,0xFEB7,0xFEB9,0xFE3A,0xFE21,0xFDE5,
	0xFDAF,0xFDF5,0xFE20,0xFD8E,0xFCE8,0xFD0A,0xFCC7,0xFC43,
	0xFBEF,0xFC09,0xFBD1,0xFB83,0xFBB5,0xFB7B,0xFB62,0xFB84,
	0xFB6B,0xFB27,0xFB86,0xFBB9,0xFBE6,0xFBEF,0xFC0D,0xFC24,
	0xFC87,0xFCA8,0xFC5E,0xFC82,0xFC9E,0xFC59,0xFC4A,0xFC06,
	0xFC05,0xFC0E,0xFC4F,0xFCA9,0xFC97,0xFC85,0xFC84,0xFC61,
	0xFC7C,0xFD20,0xFCF8,0xFCE2,0xFD25,0xFD14,0xFD1E,0xFD6A,
	0xFD97,0xFD6E,0xFD49,0xFD67,0xFDEF,0xFDB8,0xFD57,0xFD96,
	0xFD1E,0xFD7E,0xFD9E,0xFDBF,0xFDCA,0xFDDE,0xFDD7,0xFE5B,
	0xFE21,0xFE1C,0xFE1D,0xFE40,0xFD6A,0xFF39,0xFE7D,0xFD62,
	0xFE7A,0xFE18,0xFE1F,0xFE74,0xFEBB,0xFE79,0xFE82,0xFEA1,
	0xFEA3,0xFE63,0xFEA8,0xFE8A,0xFE9C,0xFEDD,0xFEEC,0xFEE6,
	0xFEA2,0xFE7B,0xFE8E,0xFEC9,0xFE8F,0xFE9B,0xFE79,0xFE8C,
	0xFEBD,0xFE9A,0xFE89,0xFEA6,0xFE72,0xFE9F,0xFEE2,0xFE99,
	0xFECD,0xFF0F,0xFEE3,0xFE98,0xFEC4,0xFEB0,0xFE89,0xFE97,
	0xFF0A,0xFEE8,0xFEB0,0xFF02,0xFEC9,0xFEDC,0xFECD,0xFECE,
	0xFF0D,0xFEDE,0xFEA1,0xFEAC,0xFE58,0xFE97,0xFEB1,0xFF00,
	0xFF64,0xFF1B,0xFED9,0xFF05,0xFEB6,0xFCB0,0xFC1A,0xFCF7,
	0xFD13,0xFCD6,0xFD10,0xFD92,0xFD8C,0xFD7C,0xFD8D,0xFDA7,
	0xFDAE,0xFE16,0xFDEE,0xFE04,0xFE25,0xFE0D,0xFE6A,0xFF33,
	0xFE2B,0xFE23,0xFEE9,0xFF2D,0xFF0E,0xFF26,0xFF5C,0xFF6F,
	0xFF87,0xFF44,0xFF66,0xFFB3,0xFFB2,0xFFCC,0xFFED,0xFFF6,
	0x0027,0x0024,0x0034,0x0000,0xFFF3,0x0009,0xFFE1,0x006E,
	0x0186,0x0067,0xFFDD,0xFFDC,0xFFE2,0xFF9F,0x0027,0x0083,
	0x007B,0x0022,0x0045,0x0115,0x0181,0x018C,0x01DA,0x02B0,
	0x0288,0x0240,0x0226,0x020D,0x01F6,0x01E7,0x023E,0x01F6,
	0x01EA,0x01F7,0x01C5,0x01C9,0x0219,0x022D,0x01EF,0x019A,
	0x01A9,0x01A0,0x01BF,0x018C,0x016A,0x012D,0x013E,0x0114,
	0x012E,0x00ED,0x010E,0x00E4,0x0108,0x00D6,0x00B1,0x00A6,
	0x007B,0x0064,0x0071,0x0079,0x0050,0x0077,0x007F,0x0065,
	0x0090,0x0080,0x0021,0x0018,0xFFF7,0x0010,0xFFEB,0xFFE2,
	0x002D,0x001F,0x0016,0x0020,0x0009,0xFFFA,0xFFA5,0xFF7C,
	0xFFC1,0xFFAE,0xFFB8,0xFFF1,0x008F,0xFF91,0xFF65,0x0125,
	0xFFE8,0xFF96,0xFFC3,0xFFA4,0xFF62,0xFF95,0xFFA1,0xFF77,
	0xFF8E,0xFF75,0xFF62,0xFF95,0xFF89,0xFF81,0xFF30,0xFF14,
	0xFFA5,0xFFA0,0xFF81,0xFF96,0xFFBF,0xFFBB,0xFFB7,0xFF5D,
	0xFF55,0xFF58,0xFF5A,0xFF54,0xFF60,0xFEFC,0xFEED,0xFF03,
	0xFF50,0xFEBF,0xFE9E,0xFED7,0xFEBE,0xFEEA,0xFED1,0xFF02,
	0xFEE7,0xFED6,0xFEE3,0xFEF2,0xFE88,0xFE7F,0xFEA7,0xFE9A,
	0xFE82,0xFEA5,0xFEB9,0xFEAC,0xFEE5,0xFEBC,0xFEB8,0xFED2,
	0xFF45,0xFF2E,0xFF9A,0x0217,0x029D,0x01CA,0x014B,0x0113,
	0x00D2,0x00DC,0x00A7,0x0088,0x0045,0x004C,0x0016,0x0004,
	0xFFBA,0xFFAD,0xFFB5,0xFFB6,0xFFAB,0xFFCE,0xFF11,0xFF6B,
	0x0055,0xFF96,0xFEEE,0xFF08,0xFF7D,0xFF4E,0xFF4D,0xFF0F,
	0xFF52,0xFF25,0xFEE1,0xFEB5,0xFEA5,0xFEC5,0xFEB9,0xFE7B,
	0xFE0B,0xFDE5,0xFDD2,0xFDEC,0xFDFD,0xFD87,0xFDE9,0xFD74,
	0xFC37,0xFD99,0xFE2B,0xFE22,0xFE33,0xFE38,0xFE0C,0xFDFA,
	0xFDF7,0xFE08,0xFDC1,0xFD46,0xFCF7,0xFCA3,0xFCC3,0xFC3C,
	0xFC34,0xFC66,0xFC18,0xFBDC,0xFC12,0xFBE2,0xFBF3,0xFC18,
	0xFC7A,0xFC4D,0xFC79,0xFC6C,0xFC3B,0xFCC7,0xFCA7,0xFC79,
	0xFCA3,0xFC8C,0xFC3D,0xFC88,0xFC10,0xFC58,0xFC98,0xFC57,
	0xFC6C,0xFC86,0xFC32,0xFC0B,0xFBF8,0xFC1C,0xFC03,0xFC21,
	0xFC57,0xFCA0,0xFC45,0xFC29,0xFC34,0xFC67,0xFC9C,0xFC43,
	0xFC5E,0xFCA4,0xFC65,0xFC79,0xFC46,0xFC30,0xFBF9,0xFBA0,
	0xFBC4,0xFC1F,0xFC27,0xFC70,0xFC9F,0xFC68,0xFCC9,0xFD90,
	0xFD72,0xFD67,0xFD90,0xFD11,0xFD85,0xFF00,0xFD10,0xFDDF,
	0xFE40,0xFDFB,0xFDFF,0xFE8B,0xFE3E,0xFE5C,0xFEBC,0xFED9,
	0xFEEA,0xFEC7,0xFEDD,0xFEB4,0xFF15,0xFF4D,0xFF3A,0xFEF5,
	0xFF47,0xFF6B,0xFF58,0xFF40,0xFF2C,0xFF34,0xFF6A,0xFF01,
	0xFEE3,0xFF1C,0xFEF3,0xFEC6,0xFF0E,0xFF3E,0xFF2A,0xFEE8,
	0xFF39,0xFF4E,0xFF65,0xFF61,0xFF92,0xFFBC,0xFF60,0xFF63,
	0xFF40,0xFFA8,0xFFA3,0xFF59,0xFF8B,0xFF9B,0xFFC2,0xFFB2,
	0xFF95,0xFF61,0xFF79,0xFF9F,0xFFAB,0xFF54,0xFF80,0xFF51,
	0xFF50,0xFF3E,0xFEDD,0xFF10,0xFE2E,0xFC72,0xFD19,0xFD50,
	0xFDD5,0xFDC0,0xFD7E,0xFDA0,0xFD8E,0xFDA1,0xFDBF,0xFD91,
	0xFDDA,0xFE0C,0xFE51,0xFE66,0xFE6F,0xFE21,0xFEB5,0xFEBB,
	0xFDC7,0xFE2F,0xFF0D,0xFF1F,0xFED6,0xFED8,0xFF20,0xFF07,
	0xFF83,0xFF34,0xFF12,0xFF49,0xFF5B,0xFFAB,0xFF9E,0xFFD7,
	0x001A,0x002E,0x0015,0x0036,0x0002,0x0011,0x0004,0x0011,
	0x0139,0x0095,0xFFC3,0xFFC8,0xFFA6,0xFFBD,0xFFE8,0x0025,
	0x005A,0x0006,0x0009,0x00CF,0x013C,0x0118,0x0152,0x01C3,
	0x015A,0x0125,0x0160,0x0157,0x0134,0x0151,0x017D,0x0168,
	0x0156,0x016F,0x0115,0x012C,0x010D,0x00FA,0x0145,0x0153,
	0x0188,0x013B,0x00EE,0x0105,0x0109,0x00BC,0x00ED,0x006D,
	0x006C,0x003A,0x003E,0x00BF,0x00BB,0x00D0,0x0102,0x00BE,
	0x009C,0x00B0,0x0044,0x0009,0xFFE0,0x002E,0xFFFD,0x0023,
	0x002C,0x0038,0x0099,0x0081,0x0096,0x00A9,0x00EC,0x00F4,
	0x00AC,0x00A4,0x00D5,0x00EE,0x00C0,0x0065,0x004D,0x001B,
	0x0083,0x0031,0xFFE0,0x0087,0x00A6,0xFEAE,0x0054,0x003D,
	0xFF7F,0x0009,0x000E,0x0056,0xFFD3,0xFFD7,0xFFFA,0x0021,
	0x002B,0x0014,0x0073,0x0018,0xFFD0,0xFF9E,0xFFA4,0xFFC2,
	0xFFEF,0x0019,0xFFB5,0xFFE1,0x003C,0x006D,0x003C,0x000B,
	0x002D,0xFFF5,0xFFC0,0xFFC6,0xFFF6,0x0018,0x0008,0xFFD6,
	0xFFC6,0xFFE2,0x0031,0x004E,0x0011,0xFF79,0xFF5E,0xFFAD,
	0xFFE6,0xFFA2,0xFF68,0xFFC9,0xFF97,0xFF75,0xFF51,0xFF29,
	0xFF19,0xFF36,0xFF41,0xFEF1,0xFEBB,0xFEDF,0xFEF5,0xFEFD,
	0xFF65,0xFF55,0x00F4,0x0284,0x026A,0x021A,0x0176,0x016A,
	0x0136,0x0131,0x00E5,0x0088,0x0094,0x0037,0x0039,0xFFF4,
	0xFFE8,0xFFFE,0xFFCA,0xFFC1,0xFFDE,0xFFD7,0xFF13,0xFFA6,
	0xFFC2,0xFF15,0xFEBF,0xFF00,0xFEDD,0xFE9B,0xFE72,0xFE67,
	0xFE97,0xFEC6,0xFE89,0xFE80,0xFEC4,0xFE9A,0xFE88,0xFEB6,
	0xFE89,0xFE93,0xFE92,0xFE6D,0xFE1E,0xFE4B,0xFF1B,0xFEB8,
	0xFD6A,0xFE1F,0xFF0C,0xFEE2,0xFED5,0xFEE0,0xFEBA,0xFEBC,
	0xFE55,0xFE13,0xFDB7,0xFD4D,0xFD63,0xFD17,0xFC5E,0xFBE0,
	0xFC24,0xFC8D,0xFC77,0xFC8A,0xFC63,0xFC5B,0xFC3A,0xFC4E,
	0xFC81,0xFC7A,0xFCA9,0xFC88,0xFC42,0xFC56,0xFCD5,0xFCC4,
	0xFCAC,0xFC88,0xFCD3,0xFCE5,0xFD04,0xFD4E,0xFD34,0xFCCF,
	0xFD32,0xFD7C,0xFD20,0xFD4D,0xFDBF,0xFD68,0xFD51,0xFD36,
	0xFD40,0xFD57,0xFD4D,0xFD87,0xFD58,0xFD41,0xFD1B,0xFD62,
	0xFDCC,0xFDCF,0xFDE7,0xFDE1,0xFDEC,0xFD9A,0xFD7C,0xFD2D,
	0xFDA9,0xFDF1,0xFE13,0xFDD6,0xFDF2,0xFDD0,0xFE41,0xFE40,
	0xFE35,0xFE75,0xFE6A,0xFD96,0xFF5B,0xFEA4,0xFE15,0xFEE2,
	0xFE93,0xFED1,0xFEBD,0xFEB3,0xFE67,0xFEF4,0xFEEE,0xFF20,
	0xFF3E,0xFF46,0xFF32,0xFF23,0xFF09,0xFF11,0xFF00,0xFEBA,
	0xFEEB,0xFE91,0xFEB9,0xFEB5,0xFEF3,0xFEC7,0xFEB9,0xFED9,
	0xFECC,0xFF16,0xFEEE,0xFED7,0xFF40,0xFF38,0xFF48,0xFF73,
	0xFF7A,0xFF56,0xFF77,0xFF60,0xFF84,0xFF7D,0xFFD4,0xFF91,
	0xFFCC,0x001B,0x0045,0xFFB9,0xFFB1,0xFFC2,0xFFDA,0x000C,
	0xFFF4,0x003C,0x0063,0x0017,0x0001,0x007F,0x00A3,0x0075,
	0x001C,0xFFF2,0x0006,0xFFA5,0xFDDF,0xFD72,0xFE1D,0xFE54,
	0xFE6D,0xFE8E,0xFED5,0xFEE3,0xFF20,0xFF07,0xFF46,0xFF62,
	0xFF81,0xFFA6,0xFFC7,0x0003,0xFFF4,0x000B,0x0049,0xFF71,
	0xFF14,0xFFED,0x0008,0xFFFF,0xFFBD,0xFFB6,0xFFB0,0xFFAC,
	0x000F,0xFFF0,0x001C,0x000B,0x004D,0x005E,0x0044,0x0040,
	0x00E6,0x00BE,0x0045,0x002D,0x001E,0x003F,0x000F,0x0049,
	0x013B,0x0012,0xFF56,0xFF78,0xFFA4,0xFFAF,0xFF83,0xFF48,
	0xFF31,0xFF6A,0xFFE5,0x0077,0x0053,0x00A5,0x010F,0x00D0,
	0x00EE,0x0111,0x00FD,0x00C4,0x00F9,0x00D8,0x00BB,0x00A1,
	0x00C4,0x00AA,0x00D1,0x00B0,0x009C,0x006F,0x002B,0x0000,
	0xFFFB,0x0028,0x0011,0xFFDA,0x0021,0x0049,0x001A,0x0067,
	0x005A,0x0000,0xFFBC,0xFF91,0xFFC0,0xFF97,0xFF8D,0xFF4B,
	0xFF5F,0xFFA2,0xFF8C,0xFF6F,0xFF56,0xFF59,0xFF3D,0xFF7A,
	0xFF33,0xFF0E,0xFF66,0xFFC9,0xFFB1,0xFFA1,0xFF67,0xFF85,
	0xFF72,0xFF91,0xFF6A,0xFFBD,0xFFB3,0xFF82,0xFF34,0xFF46,
	0xFEFE,0xFF05,0xFF74,0x0034,0xFF34,0xFEC8,0x0085,0xFF65,
	0xFF65,0xFF7E,0xFF6D,0xFFC5,0xFF9F,0xFF82,0xFF87,0xFFB3,
	0xFF97,0xFF8A,0xFF71,0xFF1E,0xFEEA,0xFF21,0xFF3A,0xFFD0,
	0xFFEB,0xFFA0,0xFF36,0xFF12,0xFEFF,0xFEDD,0xFF13,0xFF3A,
	0xFF46,0xFF12,0xFEDA,0xFEEC,0xFF12,0xFF3F,0xFF16,0xFE85,
	0xFE7F,0xFEB8,0xFEC9,0xFEB7,0xFE9F,0xFEEC,0xFE9B,0xFE7F,
	0xFE0D,0xFE51,0xFE4C,0xFE35,0xFE21,0xFE5C,0xFE1A,0xFE55,
	0xFE56,0xFE5A,0xFE47,0xFE1E,0xFE48,0xFE9A,0xFEC1,0xFEFB,
	0xFF91,0xFFA3,0x020A,0x0208,0x0159,0x012A,0x00AE,0x00A2,
	0x00CA,0x0097,0x004C,0x0038,0x002F,0x0024,0x004E,0x005E,
	0x0006,0xFFC2,0xFFBE,0xFF87,0xFF79,0xFF08,0xFF4A,0x001E,
	0xFF9A,0xFF15,0xFF8F,0x0008,0xFF69,0xFF48,0xFF6C,0xFF64,
	0xFF44,0xFF8C,0xFF8D,0xFF98,0xFF57,0xFF31,0xFF57,0xFF70,
	0xFF38,0xFF49,0xFF73,0xFF67,0xFF31,0xFF75,0xFF58,0xFEA5,
	0xFE39,0xFEFF,0xFF68,0xFF27,0xFF2F,0xFEF8,0xFED2,0xFED5,
	0xFE93,0xFE2F,0xFDF0,0xFDCB,0xFDE7,0xFD84,0xFCB3,0xFCD4,
	0xFCEB,0xFD16,0xFD21,0xFCF9,0xFCF3,0xFCA1,0xFCAF,0xFCA9,
	0xFC97,0xFCB1,0xFCE3,0xFCFE,0xFCE8,0xFD30,0xFD74,0xFD74,
	0xFD6B,0xFD29,0xFDA8,0xFDBB,0xFD2F,0xFD84,0xFD9F,0xFD70,
	0xFD42,0xFD5D,0xFD3A,0xFD2A,0xFD2F,0xFD45,0xFD11,0xFD40,
	0xFD32,0xFD54,0xFD51,0xFDA0,0xFE0E,0xFE08,0xFE73,0xFF31,
	0x0039,0x014F,0x0264,0x032B,0x0372,0x02B8,0x0134,0x0027,
	0x0163,0x03A2,0x0685,0x0A9E,0x0E57,0x10AE,0x116E,0x11B6,
	0x1250,0x129F,0x12D4,0x14A9,0x1795,0x1713,0x1817,0x1755,
	0x1689,0x178F,0x1906,0x1869,0x1684,0x14F7,0x1603,0x1974,
	0x1C54,0x1E24,0x1DEA,0x1BE0,0x18B6,0x1940,0x1DC3,0x214D,
	0x1FDD,0x1B45,0x17B2,0x1779,0x1A22,0x1DAA,0x1F59,0x1F01,
	0x1E93,0x1D67,0x1C99,0x1CAA,0x1C6B,0x1AB8,0x18E6,0x1864,
	0x19F2,0x1C67,0x1DAE,0x1D23,0x1CF1,0x1E32,0x1E05,0x1B8B,
	0x17D9,0x1571,0x1559,0x1660,0x1753,0x1887,0x1A04,0x1AA8,
	0x19C8,0x17C5,0x1712,0x16D4,0x1552,0x1128,0x0DB6,0x0E96,
	0x120F,0x1441,0x1444,0x1303,0x1092,0x0E59,0x0B79,0x0A86,
	0x0C37,0x0C9E,0x0A16,0x07FF,0x0A1F,0x0D17,0x0D29,0x0A4D,
	0x0837,0x07B8,0x07F0,0x0791,0x0828,0x08FA,0x06E0,0x023B,
	0x0143,0x0473,0x07C6,0x07A7,0x0513,0x019E,0xFFC2,0xFFDE,
	0x0149,0x0434,0x0573,0x03FD,0x0126,0xFECF,0xFD1D,0xFBF3,
	0xFBB1,0xFCEC,0x0057,0x027B,0x016A,0xFD2D,0xF8C7,0xF80B,
	0xF876,0xFA61,0xFE0E,0x002D,0xFE0E,0xF93E,0xF487,0xF39B,
	0xF52D,0xF809,0xFBC5,0xFEC7,0xFEC0,0xFBBD,0xF6E1,0xF2DA,
	0xF27E,0xF57C,0xF8CD,0xFC2E,0xFCDC,0xF933,0xF429,0xF077,
	0xF149,0xF5BB,0xF9AE,0xF952,0xF68A,0xF2F4,0xF083,0xEF92,
	0xF07E,0xF305,0xF656,0xF7F6,0xF797,0xF52F,0xF1BA,0xEE95,
	0xEC9C,0xECDD,0xF06B,0xF4EB,0xF620,0xF3E5,0xF0B8,0xEED8,
	0xEE39,0xEEFD,0xF08F,0xF197,0xF14B,0xEE97,0xEB90,0xEB0C,
	0xED39,0xF036,0xF1B1,0xF165,0xF02F,0xEE7F,0xEC89,0xEB2E,
	0xEB1D,0xEBAE,0xED4F,0xEF73,0xF101,0xF0D6,0xEFD2,0xEDAC,
	0xEBD8,0xEBD6,0xEDE7,0xEF63,0xEE82,0xEF93,0xEE1A,0xECE9,
	0xEE91,0xF0E8,0xF1B2,0xF02E,0xEDEA,0xEC8F,0xEBF4,0xEC07,
	0xED9B,0xEF38,0xEFBE,0xEF9E,0xF053,0xF24F,0xF1B2,0xEE55,
	0xEBA2,0xEAA2,0xEC27,0xEE81,0xF05F,0xF182,0xF10A,0xEF13,
	0xED3C,0xED2A,0xEE4B,0xEE9B,0xEDAC,0xED56,0xEEC4,0xF0A6,
	0xF0B9,0xEF00,0xECA8,0xEBA8,0xEC8B,0xEECA,0xF1A6,0xF224,
	0xEF61,0xEBD3,0xEB1C,0xECB4,0xEF42,0xF150,0xF196,0xF082,
	0xEEBA,0xED92,0xEDEC,0xEFF3,0xF225,0xF236,0xF01F,0xEFED,
	0xF170,0xF3EE,0xF460,0xF292,0xF20D,0xF265,0xF3F9,0xF60A,
	0xF663,0xF429,0xF055,0xEDAD,0xEEB1,0xF280,0xF670,0xF7D1,
	0xF618,0xF343,0xF11B,0xF04F,0xF113,0xF28C,0xF4A1,0xF4FD,
	0xF384,0xF28E,0xF2B7,0xF3BB,0xF4A6,0xF50F,0xF4B4,0xF4A0,
	0xF4B7,0xF455,0xF325,0xF2A2,0xF377,0xF56A,0xF680,0xF663,
	0xF50F,0xF45B,0xF48D,0xF564,0xF68E,0xF761,0xF641,0xF41F,
	0xF475,0xF5DA,0xF6CB,0xF737,0xF764,0xF6D8,0xF5DE,0xF62C,
	0xF71B,0xF7DB,0xF7B3,0xF72D,0xF64C,0xF4DF,0xF486,0xF4D0,
	0xF52F,0xF663,0xF71D,0xF700,0xF6CB,0xF750,0xF753,0xF611,
	0xF557,0xF5D5,0xF752,0xF8B3,0xF8DB,0xF880,0xF72C,0xF5E4,
	0xF57F,0xF6D9,0xF933,0xFB01,0xFAE3,0xF8C8,0xF6C7,0xF5AE,
	0xF65D,0xF794,0xF978,0xFB4F,0xFBF4,0xFAF7,0xF979,0xF87B,
	0xF7F8,0xF856,0xF94A,0xFAEB,0xFC8D,0xFCAA,0xFB30,0xF979,
	0xF80E,0xF7EF,0xF8F3,0xFB67,0xFD25,0xFCFE,0xFA82,0xF828,
	0xF6E4,0xF848,0xFA74,0xFC37,0xFD61,0xFDA0,0xFBA4,0xFA22,
	0xF951,0xF993,0xF9FB,0xFC8C,0xFC7C,0xFC59,0xFDC4,0xFCCF,
	0xFC46,0xFAC5,0xFA0B,0xFA9B,0xFC12,0xFD1D,0xFDB2,0xFD0D,
	0xFC2A,0xFB3A,0xFB08,0xFC0D,0xFD1C,0xFD9A,0xFC55,0xFB15,
	0xFB10,0xFCCE,0xFE07,0xFDC9,0xFCD6,0xFC80,0xFC80,0xFC5E,
	0xFC7E,0xFC05,0xFB96,0xFABD,0xFAD4,0xFB00,0xFB33,0xFA4B,
	0xF8FF,0xF786,0xF6C9,0xF60E,0xF548,0xF496,0xF3C7,0xF357,
	0xF361,0xF3AC,0xF393,0xF38E,0xF343,0xF33F,0xF331,0xF33A,
	0xF384,0xF3B3,0xF361,0xF2EA,0xF290,0xF2E6,0xF33A,0xF35E,
	0xF31A,0xF28A,0xF1B3,0xEF69,0xEE51,0xEE90,0xEECF,0xEE2D,
	0xED95,0xED5B,0xED3C,0xECA0,0xEC39,0xEBDE,0xEBE0,0xEB45,
	0xEAD4,0xEA55,0xEA2B,0xEA05,0xEA67,0xEAB2,0xE9AC,0xE946,
	0xEA4A,0xEA3A,0xE9E0,0xE9D3,0xE9F8,0xE95F,0xE927,0xE958,
	0xE97F,0xE9F6,0xE9D9,0xE9E2,0xEA1E,0xEA17,0xE9DA,0xEA39,
	0xEA51,0xEA45,0xEACD,0xEAD2,0xEB0D,0xEB42,0xEC0D,0xED0C,
	0xEC34,0xEBDD,0xEBFC,0xEC77,0xED00,0xED5B,0xED98,0xEDE0,
	0xEEA3,0xEF7D,0xF01D,0xF113,0xF17D,0xF267,0xF28C,0xF2AB,
	0xF2FA,0xF328,0xF376,0xF3D8,0xF4C4,0xF51B,0xF509,0xF56D,
	0xF597,0xF656,0xF6DF,0xF7A4,0xF7E8,0xF801,0xF7D5,0xF860,
	0xF8A4,0xF91E,0xF9C0,0xF9C7,0xFA47,0xFA66,0xFAE5,0xFB34,
	0xFB7F,0xFC0D,0xFC55,0xFC76,0xFCF5,0xFD8A,0xFDB9,0xFDB9,
	0xFDFE,0xFE31,0xFE8F,0xFED6,0xFF1C,0xFFB4,0x0024,0x0059,
	0x00DA,0x014A,0x014A,0x01A7,0x020B,0x0286,0x0302,0x033E,
	0x0425,0x0450,0x04AE,0x04D7,0x04F4,0x04B3,0x0577,0x05DC,
	0x0651,0x06A5,0x0765,0x0702,0x06A1,0x084D,0x07DD,0x07E3,
	0x087A,0x086A,0x08F4,0x0998,0x09B4,0x09A0,0x09B3,0x09FB,
	0x09FC,0x0A00,0x0A40,0x0AB6,0x0AE1,0x0B56,0x0AE6,0x0B39,
	0x0B99,0x0BD2,0x0BE8,0x0BD5,0x0C28,0x0C4F,0x0C89,0x0CEC,
	0x0D04,0x0CFE,0x0D07,0x0CFF,0x0CE4,0x0D00,0x0D4B,0x0D65,
	0x0DA6,0x0D99,0x0D96,0x0DA9,0x0DD4,0x0DE6,0x0DB9,0x0D98,
	0x0E06,0x0E1D,0x0E36,0x0EB7,0x0EB7,0x0EB0,0x0EE0,0x0F03,
	0x0EBE,0x0EA0,0x0E75,0x0EA6,0x0EE0,0x0ED3,0x0EF1,0x0F2D,
	0x1004,0x1230,0x11ED,0x11BF,0x118D,0x10E2,0x10B8,0x10EF,
	0x10D8,0x10CF,0x10A6,0x1093,0x107B,0x10D9,0x10C4,0x10F7,
	0x10FB,0x1091,0x1069,0x1055,0x0FC7,0x1082,0x1156,0x10C5,
	0x1008,0x0FFA,0x0FE9,0x0FB7,0x0FA5,0x0FE3,0x0FD9,0x0F8A,
	0x0F99,0x0F9D,0x0F61,0x0F11,0x0F3C,0x0EDB,0x0ECC,0x0E89,
	0x0E6F,0x0E68,0x0E2A,0x0DCB,0x0DE6,0x0DB3,0x0C9A,0x0CCC,
	0x0DD2,0x0E59,0x0E03,0x0DA9,0x0D6B,0x0D22,0x0D60,0x0D60,
	0x0D01,0x0C58,0x0BAA,0x0B63,0x0B03,0x0A58,0x0AA0,0x0ADB,
	0x0A74,0x0A85,0x0AB5,0x0AAF,0x0A7D,0x0A5B,0x0A2B,0x0A38,
	0x0999,0x0974,0x09F8,0x09DC,0x0963,0x099F,0x0957,0x0958,
	0x097A,0x095C,0x093F,0x0916,0x08D9,0x08D6,0x08CF,0x0907,
	0x0905,0x08F3,0x08C9,0x089F,0x08BD,0x0809,0x0830,0x084F,
	0x0834,0x07EB,0x07A7,0x07CC,0x07B0,0x0780,0x0763,0x0715,
	0x077E,0x0729,0x06B3,0x069A,0x06C8,0x0695,0x0649,0x0667,
	0x0683,0x0640,0x0652,0x0637,0x068C,0x06C5,0x0651,0x061B,
	0x064D,0x05A4,0x065D,0x0813,0x05DF,0x0607,0x062A,0x0643,
	0x0638,0x0687,0x067B,0x0668,0x061E,0x060E,0x0664,0x066E,
	0x0634,0x05DC,0x0632,0x0679,0x068D,0x0646,0x063F,0x0620,
	0x05B4,0x0584,0x05D2,0x05C1,0x05B4,0x0592,0x05C8,0x05CD,
	0x05F7,0x05A6,0x0520,0x0513,0x0513,0x051C,0x0550,0x051A,
	0x04A0,0x0480,0x04AB,0x04D1,0x04EB,0x04FB,0x047B,0x0467,
	0x0434,0x03D3,0x040D,0x045A,0x0436,0x0412,0x0434,0x0477,
	0x046F,0x0433,0x043A,0x047A,0x0451,0x0442,0x0455,0x03FC,
	0x0434,0x040D,0x02B5,0x0118,0x01A6,0x01F8,0x01F5,0x01DE,
	0x01E6,0x01EA,0x01C2,0x0194,0x0160,0x0156,0x01A1,0x01F2,
	0x022B,0x0220,0x0223,0x021F,0x0287,0x0215,0x01A9,0x01F8,
	0x020C,0x01E2,0x01AA,0x0200,0x0264,0x0229,0x0267,0x0229,
	0x01FA,0x01ED,0x01E1,0x0231,0x021E,0x0223,0x0224,0x024A,
	0x0221,0x0233,0x01CD,0x01D2,0x0186,0x0126,0x0258,0x025C,
	0x0194,0x0179,0x0184,0x0187,0x0182,0x01B0,0x018C,0x01B7,
	0x01DC,0x01F7,0x027F,0x0291,0x029A,0x02D3,0x02D1,0x0316,
	0x02B4,0x0280,0x0241,0x025F,0x0271,0x0278,0x02DB,0x0283,
	0x0285,0x02AB,0x0263,0x01DB,0x01A6,0x01D3,0x0218,0x01DC,
	0x01C0,0x01CB,0x0190,0x017A,0x019B,0x0166,0x015C,0x011C,
	0x0123,0x012D,0x0129,0x00B9,0x00B5,0x00A7,0xFEFB,0xFEFC,
	0xFF11,0xFF09,0xFF65,0xFF81,0xFFC2,0xFFA0,0xFFDD,0x0065,
	0x00CE,0x0139,0x0177,0x0178,0x01BA,0x026E,0x0284,0x0208,
	0x0203,0x029C,0x033B,0x048F,0x05DA,0x06CB,0x06F0,0x06B1,
	0x06C0,0x06EF,0x06E6,0x0754,0x07B1,0x07BA,0x076D,0x073A,
	0x07A9,0x0851,0x090E,0x0965,0x098D,0x096C,0x08C8,0x0896,
	0x08B6,0x09F2,0x0AD7,0x0B5D,0x0BE7,0x0CA3,0x0C7B,0x0C05,
	0x0C0F,0x0D4D,0x0F0C,0x0FBE,0x0FB8,0x0FA0,0x103C,0x10A9,
	0x1061,0x115F,0x1356,0x14B1,0x14E0,0x142C,0x14CE,0x156D,
	0x1522,0x1485,0x150F,0x16B2,0x177B,0x17C7,0x17C0,0x180B,
	0x1676,0x178D,0x183A,0x173D,0x17B9,0x184E,0x1841,0x17D8,
	0x1774,0x1796,0x17A6,0x1775,0x16CB,0x1665,0x1640,0x1649,
	0x16EE,0x1745,0x1681,0x1557,0x153E,0x1549,0x158E,0x1541,
	0x14A5,0x1466,0x143C,0x1437,0x1386,0x12E2,0x1279,0x12B1,
	0x1285,0x125A,0x11AA,0x106A,0x0F92,0x0E96,0x0E1F,0x0D4C,
	0x0BF9,0x09DD,0x06B7,0x0319,0x015B,0x0174,0x0330,0x062A,
	0x0912,0x0A6A,0x099A,0x07C4,0x0673,0x05E2,0x0704,0x0953,
	0x0B48,0x0C86,0x0CC0,0x0CCA,0x0D18,0x0E5B,0x0FDC,0x0FF1,
	0x1082,0x1007,0x0E11,0x0B93,0x09BD,0x08BD,0x07FA,0x079D,
	0x0820,0x07B4,0x0593,0x0239,0xFEC0,0xFC73,0xFB7A,0xFB3A,
	0xFBB6,0xFBA1,0xFBA4,0xF9CE,0xF66E,0xF566,0xF666,0xF745,
	0xF7A9,0xF822,0xF89B,0xF8AA,0xF897,0xF8C2,0xF916,0xF950,
	0xFA56,0xFB48,0xFBEA,0xFCAC,0xFC42,0xFB1C,0xFA15,0xF950,
	0xF951,0xFB16,0xFB83,0xF9B3,0xF888,0xF6A8,0xF591,0xF4CA,
	0xF489,0xF49F,0xF478,0xF3B5,0xF1F7,0xF016,0xEE44,0xED6E,
	0xED08,0xEC97,0xEC9C,0xED8B,0xEDC3,0xECE5,0xEBDC,0xEC08,
	0xEC6C,0xECCF,0xEDDF,0xEF6B,0xF058,0xEFC0,0xEEE9,0xEED8,
	0xF045,0xF1D4,0xF33F,0xF3A4,0xF31C,0xF25C,0xF1AA,0xF146,
	0xF12E,0xF14A,0xF16C,0xF193,0xF18C,0xF0F2,0xEF7E,0xEDEB,
	0xECDB,0xEBEA,0xEC43,0xED64,0xED68,0xEC75,0xEB15,0xEA1C,
	0xEA09,0xEA44,0xEB08,0xEB80,0xEB85,0xEB4A,0xEBA9,0xEBDA,
	0xEB8D,0xEB83,0xEB6D,0xEC45,0xEE3F,0xEFED,0xF06E,0xF00E,
	0xEF4C,0xEF63,0xEF2B,0xF03F,0xF2A2,0xF3AF,0xF1CC,0xF1B5,
	0xF06A,0xEF80,0xF12D,0xF154,0xF179,0xF151,0xF132,0xF003,
	0xEF1F,0xEE51,0xEE07,0xEE02,0xEE5B,0xEF6E,0xF049,0xEFAA,
	0xEDAA,0xED0F,0xED7F,0xEEC3,0xEF91,0xEFCA,0xEF49,0xEFAC,
	0xEFF9,0xF00E,0xF0A8,0xF1E5,0xF2E4,0xF312,0xF32B,0xF425,
	0xF50B,0xF4E8,0xF3FC,0xF31D,0xF3A8,0xF48A,0xF578,0xF5FD,
	0xF679,0xF607,0xF3F5,0xF241,0xF249,0xF38B,0xF4ED,0xF51D,
	0xF40B,0xF307,0xF26A,0xF221,0xF20F,0xF26A,0xF2D6,0xF330,
	0xF342,0xF418,0xF43B,0xF3AC,0xF30C,0xF351,0xF41C,0xF3B3,
	0xF3A3,0xF474,0xF41D,0xF434,0xF457,0xF492,0xF509,0xF656,
	0xF77E,0xF774,0xF6F5,0xF615,0xF5F1,0xF674,0xF742,0xF784,
	0xF809,0xF8D5,0xF809,0xF6CE,0xF657,0xF702,0xF75D,0xF7C3,
	0xF827,0xF84B,0xF887,0xF811,0xF737,0xF6B8,0xF71A,0xF79E,
	0xF6F7,0xF3C0,0xEDA5,0xE4F7,0xDB5E,0xD16D,0xC9B4,0xC63A,
	0xCA6D,0xD5C4,0xE4B3,0xF232,0xF686,0xF42C,0xEE43,0xEB46,
	0xEE25,0xF794,0x0302,0x0D26,0x1357,0x16D8,0x1962,0x1CC1,
	0x2159,0x267B,0x2963,0x2947,0x2682,0x220E,0x1D8B,0x18BE,
	0x147F,0x11E4,0x111E,0x112D,0x0F51,0x094E,0xFFF7,0xF5BE,
	0xEE4B,0xEB58,0xEBB1,0xED9F,0xED68,0xEA96,0xE633,0xE415,
	0xE5CA,0xE997,0xED40,0xF021,0xF285,0xF4ED,0xF7CE,0xFB0A,
	0xFE87,0x026E,0x0716,0x0BB1,0x1009,0x13FA,0x1618,0x15B6,
	0x141C,0x1350,0x14FB,0x173B,0x17FE,0x161C,0x118E,0x0CF7,
	0x09BB,0x073A,0x04F1,0x0325,0x007B,0xFBD6,0xF785,0xF3E8,
	0xF136,0xEE96,0xECE8,0xEC3A,0xEC56,0xEC7D,0xED74,0xEBC1,
	0xEBC7,0xEE16,0xEFB9,0xF3A7,0xF7E8,0xFA9C,0xFC50,0xFDC5,
	0xFF9B,0x0230,0x05A2,0x091E,0x0C4B,0x0DE0,0x0E27,0x0DD2,
	0x0DA5,0x0DAF,0x0DBF,0x0DA3,0x0CD6,0x0BB0,0x0A3B,0x0766,
	0x03C6,0x0059,0xFDD8,0xFC41,0xFB34,0xF988,0xF6C6,0xF31C,
	0xF010,0xEEC4,0xEF88,0xF14D,0xF23F,0xF144,0xF066,0xF07A,
	0xF16E,0xF271,0xF4FF,0xF7E6,0xFAF9,0xFD06,0xFE8B,0x003C,
	0x01F1,0x0357,0x0470,0x0608,0x08C1,0x0B6D,0x0B96,0x09E1,
	0x080F,0x0757,0x07AA,0x085E,0x08AE,0x0998,0x07A7,0x03DB,
	0x010D,0xFFA7,0xFF26,0xFDCC,0xFB4C,0xF981,0xF8D7,0xF8A4,
	0xF7D0,0xF5EA,0xF3FD,0xF3F4,0xF5AA,0xF6FD,0xF7A1,0xF7F3,
	0xF7C4,0xF80C,0xF9D0,0xFBAB,0xFDA5,0x0023,0x0139,0x0175,
	0x0254,0x03B8,0x04FB,0x05A3,0x0658,0x06B7,0x06EB,0x066D,
	0x061C,0x04CF,0x03E5,0x02F7,0x0245,0x0242,0x01BB,0x00A2,
	0xFE6E,0xFC85,0xFA9B,0xF972,0xF970,0xF8C8,0xF8DD,0xF93E,
	0xF8E3,0xF7A5,0xF683,0xF663,0xF777,0xF85A,0xF95D,0xFA8E,
	0xFAB2,0xF933,0xF942,0xFB1C,0xFE2E,0x0017,0x00AC,0x00E4,
	0x017C,0x0237,0x024E,0x0266,0x0303,0x0375,0x0385,0x0389,
	0x03D1,0x03C1,0x02F1,0x012E,0xFF6F,0xFEEE,0xFF62,0xFFC6,
	0xFE75,0xFC6C,0xFA7F,0xF95B,0xF8E9,0xF957,0xF9BC,0xF9E9,
	0xF9CF,0xF911,0xF89E,0xF7D6,0xF5E7,0xF2DE,0xED63,0xE57B,
	0xDCD5,0xD46A,0xCDAD,0xCB64,0xCFFC,0xDC8B,0xED0A,0xFA57,
	0xFF3E,0xFB37,0xF443,0xF10B,0xF4CE,0xFFC0,0x0C78,0x1653,
	0x1C0C,0x1E77,0x1EBC,0x2113,0x2472,0x25B1,0x2776,0x2902,
	0x25DA,0x235E,0x1D8E,0x15D5,0x1063,0x0EC1,0x1001,0x1188,
	0x0EFA,0x0858,0xFDED,0xF31D,0xEC88,0xEB9A,0xEE99,0xF025,
	0xEEF1,0xEC34,0xEA1F,0xE95E,0xEA13,0xEBE9,0xEF58,0xF4AE,
	0xF9C0,0xFD6D,0xFF31,0x0002,0x0182,0x04EC,0x0B14,0x12D6,
	0x189E,0x1AF2,0x1994,0x15FA,0x14B1,0x15F9,0x186C,0x198C,
	0x191B,0x168F,0x127A,0x0EB0,0x0AE0,0x0705,0x038B,0x0072,
	0xFE3A,0xFC80,0xFA14,0xF5E3,0xF0D4,0xED09,0xEC76,0xEDAD,
	0xEFDB,0xF13B,0xF177,0xF065,0xEF8B,0xF093,0xF2AE,0xF52C,
	0xF928,0xFCA4,0xFFE6,0x0253,0x039C,0x0593,0x0817,0x0AF4,
	0x0D36,0x0EAE,0x1016,0x103D,0x0F6D,0x0DB1,0x0CF1,0x0C8A,
	0x0CB0,0x0B2F,0x07DD,0x05C1,0x03BF,0x00D1,0xFE10,0xFBCF,
	0xFA86,0xF8EF,0xF708,0xF51B,0xF3C1,0xF2C0,0xF223,0xF1D0,
	0xF1E0,0xF2CE,0xF3BF,0xF51C,0xF680,0xF87F,0xF99A,0xFB12,
	0xFD6E,0x0004,0x03C8,0x0556,0x0570,0x069A,0x080E,0x09B5,
	0x0B30,0x0C38,0x0CA4,0x0C61,0x0B77,0x0AFB,0x0B7C,0x0B6B,
	0x0ABC,0x096B,0x0758,0x0567,0x02A4,0x00B6,0xFF25,0xFEBE,
	0xFE20,0xFBF2,0xF937,0xF783,0xF733,0xF7D8,0xF863,0xF88C,
	0xF815,0xF810,0xF8FC,0xFA0F,0xFB8B,0xFC32,0xFD17,0xFEBA,
	0x01A0,0x04C2,0x0632,0x05E9,0x05B5,0x05CA,0x0750,0x08E7,
	0x0A9C,0x0B3D,0x0A84,0x08F5,0x07C0,0x06D9,0x06FF,0x06F0,
	0x05A8,0x044F,0x02DB,0x019A,0xFFE2,0xFE3B,0xFCF6,0xFCB1,
	0xFCEE,0xFCFB,0xFC12,0xFAA7,0xF930,0xF8C5,0xF8B4,0xF993,
	0xFB0A,0xFD0C,0xFDA6,0xFCD2,0xFCB2,0xFEC9,0x00FF,0x0139,
	0x03C8,0x052C,0x0511,0x0670,0x0653,0x05E2,0x061F,0x0661,
	0x0722,0x07E1,0x08C4,0x086F,0x05FC,0x03A9,0x02D5,0x03BC,
	0x04FE,0x0485,0x02E9,0x008D,0xFEC3,0xFDB9,0xFD96,0xFD8E,
	0xFD5D,0xFD2D,0xFC2A,0xFBEC,0xFC2E,0xFC96,0xFC21,0xFAAC,
	0xF842,0xF4B8,0xEF24,0xE7E2,0xDE93,0xD4A9,0xCE39,0xCE41,
	0xD5F2,0xE515,0xF532,0xFF53,0x00AB,0xFB2C,0xF577,0xF4E7,
	0xFB0E,0x0519,0x1036,0x18F3,0x1DE1,0x1F8E,0x20EB,0x2338,
	0x2626,0x2923,0x2ADB,0x2AF8,0x2993,0x2579,0x1D36,0x16D7,
	0x13C9,0x1450,0x1597,0x1458,0x0EB6,0x0552,0xFB33,0xF360,
	0xF04E,0xF0B4,0xF1BA,0xF1A8,0xEFE1,0xECA8,0xEA2F,0xE959,
	0xEAD7,0xEEF4,0xF38D,0xF692,0xF95D,0xFBF2,0xFD99,0xFF74,
	0x02EE,0x0806,0x0E3E,0x13A6,0x16EF,0x17A2,0x1651,0x14E7,
	0x14CE,0x15EC,0x17D4,0x1920,0x182B,0x1483,0x0ECA,0x0981,
	0x06D4,0x0418,0x0153,0xFFEB,0xFDC1,0xF950,0xF3FF,0xEFBC,
	0xED3F,0xEC8B,0xEC6B,0xED66,0xEDD2,0xECC6,0xEBB7,0xEB24,
	0xEB09,0xEC9F,0xEFE3,0xF408,0xF897,0xFBB2,0xFD01,0xFD45,
	0xFE78,0x0188,0x05CA,0x08FE,0x0B7F,0x0C28,0x0BE5,0x0B0B,
	0x0A3C,0x09C3,0x0A3A,0x0A00,0x0868,0x068F,0x048E,0x0265,
	0xFF45,0xFBBF,0xF908,0xF753,0xF689,0xF628,0xF3EF,0xF109,
	0xEE69,0xEC9D,0xECD8,0xEE69,0xEF9B,0xF024,0xF091,0xF150,
	0xF2FF,0xF42D,0xF5A9,0xF7BA,0xF99E,0xFBBC,0xFF1A,0x0241,
	0x03C7,0x032E,0x0306,0x041C,0x073F,0x09D7,0x0A9D,0x09A7,
	0x082F,0x06C8,0x054A,0x0574,0x05A1,0x040E,0x03FE,0x018B,
	0xFEAB,0xFD5E,0xFAAD,0xF875,0xF7F8,0xF814,0xF809,0xF810,
	0xF6F7,0xF520,0xF31D,0xF2D9,0xF4A4,0xF7DB,0xFA37,0xFA76,
	0xF989,0xF934,0xFA99,0xFCF1,0xFF8F,0x013C,0x02B0,0x03E0,
	0x0561,0x06A6,0x06F5,0x06A3,0x0605,0x061D,0x06FF,0x0802,
	0x0833,0x06F8,0x0484,0x02B1,0x0235,0x02DF,0x0310,0x01D4,
	0x005D,0xFDD5,0xFB80,0xFA20,0xF9B5,0xF9F0,0xF9D4,0xF9C3,
	0xF9D6,0xFA25,0xF99A,0xF8CE,0xF851,0xF965,0xFB75,0xFD33,
	0xFE1C,0xFE9D,0xFF4A,0x0062,0x00C3,0x00D5,0x008D,0x01CB,
	0x0386,0x041E,0x03EE,0x03F2,0x03F8,0x0378,0x02FA,0x02FB,
	0x03B2,0x0396,0x02CA,0x01EF,0x00EE,0xFF85,0xFE7A,0xFDF3,
	0xFE35,0xFD48,0xFCA6,0xFCE4,0xFC84,0xFB68,0xFACA,0xFA5C,
	0xFAAD,0xFBDD,0xFB82,0xF84F,0xF239,0xEA83,0xE24B,0xDA1D,
	0xD1F7,0xCDE1,0xD0B6,0xDAD4,0xE8F9,0xF696,0xFE86,0xFF11,
	0xF9B1,0xF5A2,0xF83A,0xFF24,0x0A0C,0x140E,0x1A5F,0x1D93,
	0x1FAF,0x2242,0x2602,0x2A1F,0x2D03,0x2CF2,0x2A24,0x25AF,
	0x2076,0x1BA1,0x17DB,0x15ED,0x14C8,0x13B5,0x102D,0x09FC,
	0x019B,0xF93A,0xF341,0xEFBB,0xEF05,0xEF2C,0xEF6C,0xEE41,
	0xEBC7,0xE9DA,0xE9AD,0xEC60,0xF061,0xF496,0xF826,0xFA94,
	0xFC9A,0xFE68,0x00F4,0x059E,0x0B9D,0x11A1,0x157A,0x1711,
	0x169D,0x15CA,0x153A,0x161B,0x17CA,0x18FC,0x186D,0x159E,
	0x117C,0x0D7B,0x0A7B,0x084A,0x066F,0x03F4,0x00C1,0xFC9A,
	0xF879,0xF46D,0xF141,0xEF58,0xEE7C,0xEF04,0xEF60,0xEF02,
	0xEDFB,0xED21,0xED2D,0xEE90,0xF1A5,0xF745,0xFA8B,0xFCE0,
	0xFF9F,0xFE9D,0x009B,0x0426,0x08A8,0x0C98,0x0F5F,0x1067,
	0x0FC9,0x0F74,0x0F73,0x0F4D,0x0F28,0x0F48,0x0E95,0x0D5B,
	0x0B1F,0x074D,0x035C,0x0099,0xFEB6,0xFDDC,0xFD15,0xFB8F,
	0xF8D4,0xF4F2,0xF191,0xF040,0xF0CE,0xF235,0xF3B8,0xF470,
	0xF40F,0xF333,0xF31B,0xF49A,0xF798,0xFA82,0xFD93,0x0022,
	0x01B8,0x0293,0x02F4,0x0422,0x062C,0x0870,0x0A81,0x0C0C,
	0x0C4C,0x0B47,0x0957,0x07B2,0x0759,0x0805,0x08A7,0x0731,
	0x045D,0x0113,0xFEEB,0xFDF4,0xFF36,0xFE18,0xFCC4,0xFB6C,
	0xF9E4,0xF8C0,0xF69B,0xF4E4,0xF3DA,0xF51C,0xF700,0xF90E,
	0xFA9E,0xF9DD,0xF859,0xF7FC,0xF978,0xFC67,0xFFA6,0x0151,
	0x0242,0x02C6,0x0290,0x02A3,0x03FB,0x05DB,0x067A,0x06FE,
	0x06E6,0x0640,0x0577,0x0474,0x034E,0x027B,0x01C9,0x01BD,
	0x015B,0x0087,0xFDE8,0xFB47,0xF97D,0xF8AB,0xF89E,0xF975,
	0xF8E4,0xF6BB,0xF5F5,0xF6F5,0xF79E,0xF88C,0xF92F,0xF94F,
	0xF9BA,0xFA66,0xFBD2,0xFCB9,0xFC6C,0xFBDA,0xFC80,0xFE1E,
	0xFFD1,0x0173,0x01CE,0x015E,0x0102,0x0154,0x0232,0x0354,
	0x03B9,0x02A9,0x0182,0x0134,0x011E,0x0095,0xFF39,0xFE0F,
	0xFDB2,0xFDD3,0xFCEE,0xFBE4,0xFAFF,0xF9A5,0xF837,0xF87E,
	0xF93F,0xF97A,0xF920,0xF841,0xF7DC,0xF763,0xF5EF,0xF340,
	0xEE77,0xE734,0xDDCE,0xD388,0xCA77,0xC5DA,0xCA14,0xD86B,
	0xECA0,0xFE77,0x06B5,0x0373,0xF971,0xF0C7,0xEF4A,0xF61F,
	0x0297,0x0FC1,0x1A1D,0x2003,0x23AF,0x26A7,0x280E,0x2846,
	0x269D,0x2464,0x225A,0x1F29,0x193C,0x1330,0x1013,0x0DE8,
	0x11FF,0x14DB,0x13A0,0x0C6E,0xFF80,0xF1A2,0xE795,0xE3E6,
	0xE69A,0xEBE2,0xEFB2,0xF11A,0xEF8F,0xEDCA,0xEBDF,0xEBB7,
	0xEDA8,0xF0F1,0xF557,0xF979,0xFCC7,0xFF4E,0x0256,0x06AE,
	0x0C92,0x137C,0x190E,0x1AC5,0x1925,0x1567,0x11D6,0x10F8,
	0x130E,0x1613,0x17ED,0x1804,0x1595,0x1150,0x0B13,0x0495,
	0xFF62,0xFCD4,0xFB93,0xFA83,0xF822,0xF51E,0xF13A,0xEE07,
	0xED0D,0xEDB1,0xEFA7,0xF097,0xEFAA,0xED7E,0xEC7D,0xEDB9,
	0xF0EB,0xF565,0xFA37,0xFE3D,0x0166,0x027D,0x0283,0x0444,
	0x05B8,0x06E9,0x0941,0x0C41,0x0F4E,0x10CB,0x0FB6,0x0DBE,
	0x0C59,0x0C32,0x0BD4,0x0B68,0x0941,0x05BA,0x022F,0xFFD0,
	0xFD89,0xFB35,0xFA3F,0xF8B9,0xF68F,0xF4CD,0xF43E,0xF328,
	0xF15D,0xEF55,0xEE51,0xEFFB,0xF343,0xF57E,0xF700,0xF7E7,
	0xF8F3,0xF9DA,0xFBFE,0xFE66,0x0142,0x034F,0x03FF,0x0508,
	0x073A,0x0A7F,0x0A95,0x0970,0x09E7,0x0B1B,0x0BC9,0x0AFC,
	0x0961,0x075D,0x057C,0x03E0,0x03F0,0x0399,0x0228,0x00FB,
	0xFEED,0xFBEB,0xFA36,0xF92A,0xF7FD,0xF724,0xF580,0xF503,
	0xF54B,0xF5D1,0xF65F,0xF6D9,0xF77A,0xF88B,0xF9CA,0xFB1B,
	0xFC92,0xFE00,0xFECE,0xFFFF,0x01A4,0x0361,0x045B,0x04FD,
	0x05B4,0x0640,0x075D,0x07FB,0x0877,0x0851,0x0753,0x05F5,
	0x0484,0x0455,0x043E,0x03DB,0x024F,0xFF59,0xFD46,0xFCB2,
	0xFC4F,0xFB7E,0xFA2C,0xF940,0xF888,0xF7B0,0xF785,0xF75D,
	0xF846,0xF90D,0xF942,0xF959,0xFA3B,0xFB10,0xFC79,0xFD46,
	0xFE02,0xFEBE,0xFFD1,0x012A,0x032A,0x03DF,0x02E6,0x0589,
	0x05C2,0x04C4,0x0559,0x058E,0x0517,0x047C,0x036A,0x02D8,
	0x02B6,0x0228,0x0186,0x0125,0x0031,0xFE83,0xFC9A,0xFB0A,
	0xFB61,0xFC04,0xFC69,0xFB98,0xFA39,0xF98E,0xFA3A,0xFABC,
	0xFB62,0xFB22,0xF8F5,0xF4CB,0xEE11,0xE61D,0xDC7A,0xD271,
	0xC9EE,0xC810,0xD0B6,0xE3B5,0xF950,0x08C9,0x0CF9,0x05B1,
	0xF98D,0xF086,0xF025,0xF835,0x05C5,0x1320,0x1E09,0x25C3,
	0x2B73,0x2EC2,0x2ED7,0x2B9D,0x2651,0x20CE,0x1C38,0x1767,
	0x12F1,0x10D8,0x11E2,0x172F,0x1C88,0x1C39,0x15F5,0x0912,
	0xF8D6,0xEA57,0xE251,0xE1DE,0xE6C9,0xEE08,0xF2C2,0xF4D9,
	0xF4FD,0xF3BB,0xF10F,0xEE0A,0xEC36,0xED01,0xF04C,0xF4F5,
	0xFBB8,0x018A,0x06D6,0x0D29,0x1430,0x1992,0x1C33,0x19B0,
	0x12EF,0x0C62,0x0A3D,0x0D61,0x135F,0x1913,0x1BFA,0x1B19,
	0x165F,0x0F52,0x07C3,0x01BD,0xFCB2,0xF809,0xF554,0xF4DD,
	0xF4C3,0xF38F,0xF262,0xF192,0xF173,0xF115,0xF005,0xECF8,
	0xE969,0xE6E5,0xE736,0xEB2C,0xF21B,0xF968,0xFEC6,0x0123,
	0x0182,0x01B3,0x010E,0x0140,0x0220,0x03F8,0x0782,0x0B84,
	0x0ED7,0x1018,0x0F8D,0x0E28,0x0CB6,0x0AC3,0x08E1,0x0587,
	0x00FC,0xFC9F,0xFA3A,0xFA40,0xFBF3,0xFD56,0xFC34,0xF88C,
	0xF3F4,0xF003,0xECD4,0xEA6C,0xE988,0xEA89,0xECE4,0xEF8B,
	0xF28A,0xF4D4,0xF60D,0xF5E6,0xF5CC,0xF729,0xF939,0xFB83,
	0xFD08,0xFE48,0x0035,0x0317,0x0647,0x08AD,0x09FB,0x0A01,
	0x0904,0x073E,0x0417,0x024B,0x01AA,0x01F4,0x02DE,0x03A7,
	0x02CA,0x0177,0xFF0D,0xFB47,0xF784,0xF7C1,0xF507,0xF39D,
	0xF3B3,0xF319,0xF3D3,0xF487,0xF57B,0xF63A,0xF69D,0xF688,
	0xF68A,0xF654,0xF754,0xF8A1,0xF9B6,0xFB5C,0xFDD9,0x0065,
	0x0353,0x05D3,0x06CE,0x0628,0x040F,0x0274,0x0213,0x042A,
	0x0652,0x077F,0x0681,0x052B,0x0373,0x02CA,0x0258,0x0197,
	0xFFDC,0xFD5C,0xFB55,0xFAC6,0xFA7D,0xFA87,0xF9F4,0xF9A5,
	0xF973,0xF900,0xF95A,0xF9BE,0xF933,0xF787,0xF698,0xF6FB,
	0xF8FC,0xFC75,0xFEDE,0x000C,0xFFA7,0xFF5F,0xFF5C,0x0095,
	0x02CA,0x0448,0x04EB,0x04E7,0x0472,0x033C,0x0349,0x0442,
	0x03CA,0x0311,0x02A2,0x02E9,0x0295,0x01A8,0x0014,0xFE00,
	0xFD63,0xFDD7,0xFE89,0xFEB3,0xFD1C,0xFABF,0xF8EB,0xF8FF,
	0xF96E,0xFAB6,0xFBD8,0xFB1D,0xF8DD,0xF68F,0xF388,0xEEFA,
	0xE8E8,0xE1CD,0xDA52,0xD594,0xD72D,0xE097,0xEF78,0xFE15,
	0x0732,0x0883,0x0301,0xFA9C,0xF47B,0xF4D4,0xFC93,0x07C1,
	0x13C2,0x1DEE,0x220B,0x2371,0x2362,0x217D,0x1E67,0x1B8B,
	0x1838,0x151B,0x11EF,0x0F08,0x0E5E,0x0FFE,0x12B8,0x1507,
	0x137D,0x0CFD,0x02F4,0xF742,0xEDCE,0xE9BB,0xEAF1,0xEF4D,
	0xF4E2,0xF87C,0xFA2F,0xF917,0xF624,0xF41C,0xF347,0xF329,
	0xF3AE,0xF5C9,0xF9B6,0xFF09,0x053B,0x0B0D,0x1064,0x1393,
	0x14F5,0x142E,0x115D,0x0E6C,0x0C4F,0x0C2C,0x0E27,0x10E1,
	0x13AE,0x15A5,0x152C,0x11AC,0x0B4E,0x0465,0xFE54,0xFA3D,
	0xF8AA,0xF87C,0xF8A4,0xF857,0xF7A1,0xF680,0xF61B,0xF615,
	0xF51F,0xF2B3,0xEFD6,0xEDEC,0xEE52,0xF0F5,0xF4CA,0xF93D,
	0xFE39,0x025F,0x03DC,0x0410,0x0467,0x0246,0x01F8,0x0471,
	0x05A0,0x08D7,0x0BC8,0x0DDE,0x0EBA,0x0DFF,0x0C4E,0x0AAD,
	0x086B,0x0613,0x03A1,0x0141,0xFF5D,0xFE74,0xFD9C,0xFD59,
	0xFDC2,0xFD60,0xFBBB,0xF8B2,0xF523,0xF24A,0xF0C4,0xF13A,
	0xF2E9,0xF580,0xF7BC,0xF91B,0xFA16,0xFB1D,0xFB3E,0xFB15,
	0xFBA6,0xFCC8,0xFE84,0x005D,0x01F8,0x0342,0x04E1,0x0673,
	0x07A3,0x081D,0x0859,0x07C5,0x0611,0x044B,0x038B,0x034F,
	0x03EA,0x03A2,0x025D,0x0136,0x0025,0xFE7E,0xFC1B,0xF9C0,
	0xF7CF,0xF70F,0xF802,0xFA37,0xFA2D,0xF994,0xF907,0xF8E9,
	0xF8B3,0xF91C,0xF981,0xFA4F,0xFAD4,0xFB15,0xFB99,0xFC9B,
	0xFEB8,0x0159,0x0263,0x0370,0x03F0,0x0378,0x0283,0x02C5,
	0x041E,0x042E,0x03EB,0x04A2,0x054F,0x04B0,0x0327,0x01B5,
	0x00C3,0x0015,0xFF9A,0xFECC,0xFDB8,0xFC68,0xFB89,0xF9FB,
	0xF99D,0xFA47,0xFAFF,0xFB14,0xF9B1,0xF87D,0xF7ED,0xF7EA,
	0xF783,0xF82B,0xFAB7,0xFD12,0xFE62,0xFE66,0xFDC4,0xFD38,
	0xFDB0,0xFEC4,0x007B,0x01D7,0x02C8,0x032F,0x01B9,0xFF72,
	0x0050,0x01B2,0x0228,0x01F4,0x0104,0xFFD6,0xFE98,0xFE82,
	0xFF0F,0xFEDB,0xFD7A,0xFC08,0xFBE0,0xFC8E,0xFCA5,0xFBA2,
	0xF9F7,0xF927,0xF8DF,0xF94F,0xF97B,0xF997,0xF9A7,0xF943,
	0xF86E,0xF7F7,0xF7F3,0xF7F7,0xF6C3,0xF455,0xF1BA,0xF06B,
	0xF20E,0xF59C,0xFB5A,0x0053,0x031B,0x02C7,0x006C,0xFDAA,
	0xFBE5,0xFC60,0xFF48,0x0287,0x053E,0x0720,0x0877,0x0848,
	0x0824,0x073E,0x0576,0x04A0,0x03A8,0x026E,0x0181,0x0097,
	0xFFD2,0x001C,0x0096,0x00AF,0x027C,0x025F,0xFDAC,0xFA7B,
	0xF6F5,0xF590,0xF63D,0xF937,0xFBCD,0xFD99,0xFDB6,0xFD50,
	0xFC63,0xFBB7,0xFBB2,0xFC2D,0xFDB4,0xFF23,0x0058,0x0059,
	0x00A6,0x0205,0x0406,0x05FE,0x0733,0x06A9,0x048E,0x029F,
	0x0169,0x01F4,0x02FA,0x0362,0x0325,0x0368,0x0407,0x039B,
	0x01EB,0xFF1D,0xFCEA,0xFBD2,0xFBE5,0xFD1F,0xFDB2,0xFD40,
	0xFBBA,0xFA5E,0xFA08,0xFADC,0xFB53,0xFB4C,0xF9FE,0xF93A,
	0xF93D,0xF8F2,0xF91B,0xF920,0xF974,0xF957,0xF90F,0xF89C,
	0xF7E6,0xF735,0xF657,0xF599,0xF53D,0xF5BE,0xF7DC,0xF866,
	0xF7CE,0xF73A,0xF6CA,0xF6CC,0xF682,0xF5CC,0xF4F7,0xF42A,
	0xF388,0xF329,0xF384,0xF390,0xF336,0xF29B,0xF299,0xF13B,
	0xF03B,0xF0DC,0xF0DA,0xF00B,0xEF3B,0xEF12,0xEF50,0xEE2E,
	0xEE05,0xEDCC,0xED6C,0xECB2,0xEC75,0xEC96,0xEC16,0xEB79,
	0xEB33,0xEB3C,0xEB26,0xEB2C,0xEAE0,0xEA9D,0xEA53,0xEA1C,
	0xEAD8,0xEA96,0xE932,0xE8C5,0xE8F5,0xE906,0xE92F,0xE919,
	0xE8BB,0xE8DC,0xE939,0xE98B,0xE9B7,0xEA0F,0xEAE1,0xEB30,
	0xEB1C,0xEB9A,0xEBB7,0xEBBE,0xEBD3,0xEC42,0xEC23,0xEC46,
	0xECAA,0xED2C,0xED4D,0xED4C,0xEDF8,0xEE81,0xEF08,0xEF5A,
	0xEF80,0xEFCE,0xF00C,0xF0A6,0xF0F2,0xF159,0xF161,0xF1A2,
	0xF225,0xF23C,0xF29E,0xF30D,0xF349,0xF3B1,0xF3EB,0xF3FB,
	0xF472,0xF51C,0xF556,0xF5B6,0xF5F9,0xF684,0xF709,0xF758,
	0xF773,0xF7DB,0xF863,0xF904,0xF975,0xFA23,0xFAA8,0xFB2B,
	0xFB9C,0xFC17,0xFC11,0xFD17,0xFD48,0xFD87,0xFD7D,0xFDDD,
	0xFEAF,0xFF58,0xFF4A,0x004A,0x003D,0xFF01,0x0134,0x014E,
	0x00C0,0x017D,0x0200,0x0229,0x026B,0x02D6,0x0381,0x0368,
	0x0394,0x03C0,0x0437,0x044E,0x04AC,0x0508,0x0569,0x058A,
	0x05D6,0x0601,0x0646,0x06C5,0x06D9,0x06E8,0x0711,0x0750,
	0x0786,0x07E2,0x0844,0x08A0,0x08EC,0x095A,0x0934,0x0960,
	0x093A,0x0965,0x0939,0x095F,0x0996,0x09F7,0x0A4D,0x0A9E,
	0x0A9C,0x0A54,0x0A6D,0x0A77,0x0A56,0x0A67,0x0AC4,0x0AE2,
	0x0AB0,0x0AC0,0x0B20,0x0AF7,0x0B3F,0x0B69,0x0B9D,0x0BD6,
	0x0BB1,0x0C18,0x0DAC,0x0EC1,0x0E71,0x0E69,0x0E6D,0x0E29,
	0x0DE3,0x0DDD,0x0E25,0x0E08,0x0E0B,0x0E63,0x0E4B,0x0E35,
	0x0E60,0x0E73,0x0EB1,0x0E7C,0x0E2E,0x0DAF,0x0DBF,0x0EAF,
	0x0E7E,0x0DBA,0x0D70,0x0E2F,0x0E38,0x0E11,0x0E00,0x0DC8,
	0x0DE7,0x0E00,0x0D54,0x0D51,0x0D7F,0x0DC0,0x0D7B,0x0D5D,
	0x0D90,0x0D38,0x0D5F,0x0D5A,0x0D53,0x0D79,0x0D74,0x0CF7,
	0x0BCF,0x0CBD,0x0D89,0x0D7D,0x0D54,0x0D57,0x0D43,0x0D68,
	0x0D44,0x0D04,0x0C89,0x0BC8,0x0B55,0x0B04,0x0A30,0x0A18,
	0x0A3E,0x0A66,0x0A82,0x0A48,0x09D5,0x0A2D,0x0A3A,0x0A42,
	0x0A00,0x0A2D,0x09C7,0x0964,0x0940,0x0914,0x08F8,0x08E2,
	0x08D9,0x0927,0x08FA,0x08E9,0x08B7,0x08EA,0x08E7,0x0916,
	0x0909,0x088B,0x088A,0x08C1,0x08CE,0x089F,0x085E,0x085F,
	0x082D,0x0805,0x083D,0x0864,0x080E,0x07C5,0x07BA,0x07A0,
	0x07A3,0x07B8,0x07ED,0x0788,0x0713,0x06F1,0x0713,0x0642,
	0x06CE,0x0708,0x0716,0x0767,0x06EA,0x06DE,0x078D,0x07C3,
	0x0765,0x078D,0x0719,0x0650,0x0834,0x0728,0x0644,0x0743,
	0x06B6,0x06AC,0x06D6,0x06DD,0x06F6,0x0703,0x06D5,0x0704,
	0x06F4,0x0697,0x067F,0x0703,0x06D9,0x0695,0x06A6,0x0688,
	0x0673,0x0620,0x0643,0x0624,0x062C,0x05FB,0x05B3,0x0592,
	0x05AE,0x05F3,0x05F4,0x0617,0x05ED,0x05E3,0x0522,0x053D,
	0x04E1,0x049E,0x04B9,0x0490,0x0480,0x045C,0x0486,0x0447,
	0x040B,0x03E8,0x0440,0x0428,0x0460,0x03FB,0x0415,0x040B,
	0x03EF,0x0405,0x0417,0x040C,0x03EA,0x03B8,0x03F6,0x03D5,
	0x034C,0x0364,0x0393,0x0287,0x00AB,0x00A2,0x0111,0x012D,
	0x00DF,0x009C,0x00C8,0x00E7,0x00C1,0x00F4,0x00E0,0x0089,
	0x0080,0xFFD1,0xFFBC,0xFF67,0xFF2B,0xFF07,0xFF30,0xFFEE,
	0x00A4,0x010C,0x0220,0x0295,0x027F,0x0217,0x02D3,0x0578,
	0x07F4,0x08F5,0x08D5,0x08C8,0x089D,0x0861,0x084D,0x0881,
	0x0880,0x07F2,0x07A9,0x0755,0x075F,0x0741,0x0796,0x0869,
	0x0984,0x09D7,0x09A4,0x09E6,0x09BE,0x0928,0x0909,0x0ADC,
	0x0CDC,0x0E10,0x0CF8,0x0AB9,0x0944,0x093F,0x0A95,0x0D1C,
	0x0FAE,0x1127,0x10BE,0x1002,0x1269,0x12DC,0x1431,0x1569,
	0x157B,0x16F5,0x16E3,0x14F2,0x1394,0x13E3,0x14BB,0x1551,
	0x16E3,0x189B,0x176C,0x148C,0x1511,0x1640,0x16E2,0x1722,
	0x182F,0x190E,0x17CF,0x1703,0x16C6,0x1738,0x173D,0x1667,
	0x14B4,0x1479,0x15D4,0x1513,0x1237,0x11A9,0x13B3,0x14C6,
	0x12A7,0x10DD,0x129C,0x1333,0x1100,0x0F6F,0x10CA,0x1301,
	0x1157,0x0CDF,0x0CAE,0x0E7B,0x0DC3,0x0AEB,0x0965,0x0989,
	0x08F3,0x05A7,0x02D5,0x02BD,0x03BB,0x0325,0x01DC,0x00D0,
	0x018A,0x032A,0x035F,0x038D,0x045F,0x065B,0x074B,0x075F,
	0x075F,0x0772,0x0693,0x0581,0x0578,0x06A0,0x078E,0x076F,
	0x0662,0x0553,0x0595,0x0703,0x081F,0x082B,0x07BB,0x075C,
	0x06F4,0x0658,0x05BF,0x0519,0x044E,0x0348,0x024A,0x010E,
	0xFF48,0xFD5E,0xFBB3,0xFAB5,0xFACC,0xFA1A,0xF8CC,0xF700,
	0xF61D,0xF5FF,0xF653,0xF5F3,0xF55C,0xF531,0xF497,0xF413,
	0xF369,0xF318,0xF2CD,0xF1A6,0xF0F3,0xF1C3,0xF21B,0xF2A9,
	0xF257,0xF1DC,0xF18E,0xF242,0xF229,0xF436,0xF648,0xF542,
	0xF5A8,0xF567,0xF604,0xF73A,0xF7AB,0xF6A5,0xF67A,0xF662,
	0xF679,0xF73E,0xF72B,0xF663,0xF5B7,0xF529,0xF55C,0xF638,
	0xF679,0xF5AA,0xF42C,0xF363,0xF3EB,0xF4A8,0xF44F,0xF2E2,
	0xF19F,0xF1BB,0xF213,0xF19B,0xF088,0xEF43,0xEEFB,0xEE74,
	0xEE75,0xEEB5,0xEEF0,0xEE8D,0xEDE1,0xEDA3,0xEE0A,0xEF02,
	0xEEFC,0xEE72,0xED3E,0xECD3,0xEFBF,0xF169,0xEEE9,0xEE95,
	0xF222,0xF296,0xEF28,0xEDF9,0xF104,0xF51C,0xF585,0xF080,
	0xEE02,0xF32A,0xF8B9,0xF652,0xEFC9,0xEF5F,0xF3B3,0xF63B,
	0xF2A4,0xF01C,0xF368,0xF6F7,0xF3A9,0xEE4C,0xF04E,0xF5F2,
	0xF5B6,0xEFD7,0xEEE8,0xF53E,0xF7A4,0xF220,0xEC59,0xEE0B,
	0xF313,0xF5B6,0xF2D4,0xEE9D,0xEF83,0xF0D4,0xEF7F,0xEFD9,
	0xF0EF,0xF14B,0xF04E,0xF0D7,0xF208,0xF01D,0xEE43,0xF0A7,
	0xF386,0xF338,0xF222,0xF122,0xF146,0xF3EF,0xF6AB,0xF46A,
	0xF085,0xF1C2,0xF634,0xF7D9,0xF472,0xF31E,0xF569,0xF775,
	0xF501,0xF491,0xF677,0xF789,0xF888,0xF96D,0xF8A2,0xF80C,
	0xF8CD,0xF8A1,0xF712,0xF570,0xF918,0xFC68,0xF8A3,0xF47C,
	0xF5C3,0xF961,0xF8E7,0xF5F0,0xF6F2,0xFB96,0xFB0B,0xF54C,
	0xF34A,0xF702,0xFA08,0xF653,0xF270,0xF7BD,0xFCE3,0xF8C8,
	0xF25B,0xF20D,0xF8B8,0xFC8F,0xF796,0xF1B2,0xF436,0xFB6A,
	0xFB1B,0xF41F,0xF3C6,0xFB4B,0xFC89,0xF775,0xF6EE,0xFA6B,
	0xFA95,0xF741,0xF66C,0xF9D7,0xFC28,0xF954,0xF522,0xF548,
	0xF83E,0xF7CC,0xF389,0xEF78,0xEEA8,0xED4E,0xEA79,0xE87A,
	0xEA4B,0xECEA,0xECE6,0xEB81,0xED5C,0xF169,0xF2B1,0xF51C,
	0xF6B6,0xFA73,0xFEA0,0xFF54,0xFDEC,0xFDF9,0x004E,0x020C,
	0x0261,0x028D,0x0340,0x0394,0x029A,0x0256,0x0409,0x06A3,
	0x0834,0x0800,0x0842,0x0951,0x09F8,0x09D7,0x0978,0x094C,
	0x0949,0x08BD,0x06C8,0x0416,0x015A,0xFE58,0xFC20,0xFBAA,
	0xFB96,0xFADD,0xF8A1,0xF530,0xF327,0xF473,0xF66B,0xF6F6,
	0xF693,0xF533,0xF49B,0xF4A8,0xF4F1,0xF4B7,0xF461,0xF417,
	0xF35E,0xF3AE,0xF4C0,0xF52F,0xF416,0xF365,0xF449,0xF6FF,
	0xFA93,0xFC6F,0xFC60,0xFD66,0xFF67,0x00B5,0x03BD,0x0547,
	0x0579,0x04EE,0x0484,0x0489,0x0489,0x048B,0x04EB,0x04C3,
	0x0476,0x049D,0x049F,0x038F,0x01B0,0x0118,0x01C1,0x040D,
	0x04FD,0x02E0,0xFFE9,0xFEC7,0xFF23,0xFE88,0xFE03,0xFD0A,
	0xFBEB,0xFA81,0xF89C,0xF728,0xF749,0xF778,0xF701,0xF611,
	0xF635,0xF744,0xF787,0xF72A,0xF644,0xF64F,0xF7A7,0xF7A1,
	0xF69C,0xF82F,0xFCE0,0xFDAC,0xF81B,0xF4E1,0xFD48,0x06ED,
	0x028F,0xF838,0xF763,0xFF72,0x057F,0xFF12,0xFA32,0x01A6,
	0x091C,0xFFEC,0xF7C3,0x0175,0x0ACF,0x0441,0xF9BD,0xFEC0,
	0x095E,0x0492,0xF827,0xFB2B,0x0833,0x07FF,0xFAE6,0xF58B,
	0xFD86,0x059C,0xFF85,0xF6B2,0xFB88,0x034C,0x007D,0xF669,
	0xF546,0xFCDF,0x0036,0xFA39,0xF32F,0xF6CE,0xFEBC,0xFD53,
	0xF838,0xF813,0xFC46,0xFE0D,0xF8AF,0xF510,0xFC48,0x03CA,
	0xFCEF,0xF52C,0xFA4F,0x017C,0x00A9,0xFD09,0xFF7A,0x0354,
	0x0104,0xFCD9,0xFD17,0x003C,0x0426,0x05FA,0x0101,0xFFAD,
	0x030B,0x0311,0x02E0,0x017A,0x00F8,0x072D,0x04DF,0x00DF,
	0x027D,0x037D,0x0211,0xFFE9,0x007A,0x01AC,0x0175,0x0014,
	0xFC2A,0xFCEE,0x02EA,0x03E4,0xFEE0,0xFC1E,0xFF0B,0x01B3,
	0xFEA3,0xFB06,0xFAF0,0x015A,0x037B,0xFDB4,0xF99F,0xFC86,
	0x0357,0x03E8,0xFA0B,0xF573,0x014C,0x0AF4,0x0131,0xF4AF,
	0xFCCC,0x0B48,0x0760,0xF7DA,0xF63E,0x07FE,0x114B,0x0224,
	0xF454,0xFCA6,0x0A6C,0x0652,0xF5D5,0xF3CF,0xFF03,0x00C0,
	0xF23F,0xE864,0xF0F5,0xFBC2,0xF815,0xEE9F,0xF024,0xFAB7,
	0xFD6E,0xF6A3,0xF5F2,0x0043,0x0869,0x032C,0xFD00,0x0085,
	0x07F9,0x08AB,0x02A5,0x0179,0x07CE,0x0CCE,0x095D,0x044B,
	0x059C,0x0B6B,0x0CF7,0x0B0A,0x0BC5,0x0FD6,0x12B9,0x0FC0,
	0x0CA6,0x0F0A,0x1212,0x0FAF,0x0B1C,0x0A09,0x0BCA,0x0A65,
	0x0584,0x0184,0x0128,0x02A8,0x0158,0xFF52,0xFE90,0xFEF7,
	0xFD8F,0xFBC1,0xFBC7,0xFE0B,0xFF05,0xFD09,0xFB41,0xFB74,
	0xFD76,0xFCE1,0xF98B,0xF890,0xFA31,0xFB67,0xFA66,0xF934,
	0xFA91,0xFCFF,0xFDF1,0xFEC4,0x00F0,0x03E5,0x0525,0x048E,
	0x04C9,0x0708,0x09BB,0x09DD,0x0855,0x07C4,0x087F,0x0933,
	0x084A,0x078F,0x0808,0x0868,0x0721,0x05FC,0x0659,0x07AB,
	0x06F6,0x0549,0x04E9,0x0572,0x0628,0x04A9,0x021F,0x00CD,
	0x0085,0x001C,0xFF9E,0xFE41,0xFD6C,0xFC4B,0xFA9C,0xF996,
	0xFA10,0xFB2E,0xFAD1,0xF9A0,0xF8DC,0xF8E6,0xF999,0xF995,
	0xF7C2,0xF846,0xFBBD,0xFD60,0xFCFE,0xFC27,0xFBA2,0xFCA1,
	0xFC02,0xFAFA,0xFD1A,0x01D3,0x03DA,0xFDB9,0xF924,0xFEE5,
	0x06A3,0x051D,0xFF40,0xFFA5,0x0714,0x07CF,0x005F,0xFD8B,
	0x05A2,0x0EC4,0x05AD,0xF9CA,0xFFF2,0x0C4F,0x07AC,0xFA63,
	0xFC63,0x0A37,0x0BBF,0xFD50,0xF44A,0x00B6,0x0CC1,0x029E,
	0xF4D4,0xFADD,0x0ADE,0x0821,0xF640,0xF269,0x025C,0x07F7,
	0xFB94,0xF491,0xFADA,0x02F9,0x002D,0xF7E3,0xF96D,0x0276,
	0x04B1,0xFFB8,0xFB01,0xFB55,0x003A,0x03DC,0x021B,0x00C5,
	0x02D0,0x0090,0xFEA0,0x033E,0x0649,0x041C,0x0137,0xFFD8,
	0x00B9,0x03F1,0x0599,0x016A,0xFFD2,0x03DA,0x0776,0x0643,
	0xFEEC,0xFDC0,0x05BD,0x0DEE,0x07C7,0xFF2A,0xFE93,0x07D6,
	0x0855,0xFEDA,0xFB87,0x0290,0x099A,0x0591,0xFA06,0xFA0D,
	0x0595,0x0756,0xFBCE,0xF636,0xFE52,0x0432,0xFFD2,0xF9F6,
	0xFC46,0x03A2,0x0293,0xFBC1,0xF9D4,0xFE0A,0x0166,0xFE0B,
	0xFA3C,0xFEB9,0x046F,0x01F0,0xF9BD,0xFAFD,0x03D0,0x0277,
	0xF9AF,0xFC83,0x07A2,0x074C,0xFB6D,0xF72C,0xFF76,0x04E9,
	0xFC1B,0xF382,0xF5C5,0xF9F6,0xF63F,0xEDBF,0xECB3,0xF3C6,
	0xF716,0xF27B,0xEEF3,0xF395,0xF9A9,0xFA32,0xF7A3,0xFA32,
	0x0206,0x0566,0x02EB,0x015C,0x03D1,0x0706,0x0636,0x044C,
	0x063F,0x09FC,0x097A,0x0588,0x04CF,0x0892,0x0C9E,0x0CC4,
	0x0BC3,0x0D16,0x0F70,0x0EDC,0x0B85,0x0AEF,0x0D2E,0x0DA9,
	0x0ACA,0x077B,0x0633,0x0533,0x023E,0xFEAA,0xFDC8,0xFF44,
	0xFF73,0xFCA5,0xF95C,0xF8DA,0xF975,0xF98A,0xF99C,0xFAA4,
	0xFBD6,0xF9FD,0xF6C9,0xF58C,0xF747,0xF8F1,0xF889,0xF707,
	0xF660,0xF6C8,0xF783,0xF80F,0xF89C,0xF997,0xFB51,0xFCAD,
	0xFF29,0x0123,0x01FE,0x00D7,0x0255,0x03CF,0x0460,0x0768,
	0x0642,0x04BE,0x03C4,0x03E8,0x046F,0x053F,0x0565,0x04AA,
	0x03D5,0x03EA,0x0531,0x059F,0x04EF,0x0398,0x037B,0x0437,
	0x050C,0x0468,0x02AD,0x0130,0xFFA7,0xFEC1,0xFE47,0xFE30,
	0xFD60,0xFBA0,0xF9C1,0xFA0D,0xFAC1,0xFB5B,0xFAEE,0xFA3C,
	0xFA24,0xFAB1,0xFBF4,0xFB43,0xFA1C,0xFD2E,0xFD97,0xFB80,
	0xFD7C,0xFEC9,0xFB23,0xF952,0xFEB8,0x04ED,0x0089,0xF8EF,
	0xFE50,0x06D8,0x0665,0x0163,0x0140,0x049A,0x074D,0x07D8,
	0x0361,0x019A,0x0888,0x0B8B,0x043B,0xFC5B,0xFDB9,0x0344,
	0x055A,0x0230,0xFD72,0x011E,0x062D,0x0258,0xF98C,0xFACE,
	0x04B1,0x090A,0x0098,0xF621,0xF9AB,0x078A,0x0709,0xF943,
	0xF665,0xFEB7,0x013B,0xFD37,0xFBDE,0xFE3F,0xFDEB,0xFB20,
	0xFD43,0xFEE4,0xFD23,0xFD6C,0xFDE2,0xFF68,0x0343,0x02AF,
	0xFE59,0xFD30,0x012C,0x0444,0xFFFE,0xFCD3,0x013D,0x0889,
	0x0668,0xFE3E,0xFBE0,0x03EE,0x0B52,0x05D2,0xFBB2,0xFCA8,
	0x0968,0x0ED6,0x02F5,0xF8A2,0x02AB,0x11A7,0x0C04,0xFBB1,
	0xFA1E,0x092D,0x0FB5,0x03DC,0xF6D5,0xFD36,0x0C07,0x0AB0,
	0xFB8B,0xF734,0x02AA,0x0B3B,0x0111,0xF641,0xFE44,0x07C2,
	0x0208,0xF7BE,0xF8E8,0x0437,0x073E,0xFDAF,0xF812,0xFF18,
	0x05F6,0x0106,0xF8A4,0xFBB1,0x03A3,0x0287,0xFC28,0xFC54,
	0x03AC,0x0765,0xFFD5,0xF9F1,0x02AF,0x0B6A,0x0580,0xFB6D,
	0xFD0C,0x055F,0x049C,0xFAA5,0xF694,0xFCC8,0xFF63,0xF637,
	0xEC94,0xEF32,0xF73C,0xF7EF,0xF21C,0xF0B0,0xF6AB,0xFB24,
	0xF914,0xF81F,0xFE6D,0x0636,0x0532,0xFFE0,0x0363,0x088B,
	0x09F4,0x0610,0x03E8,0x077F,0x0B17,0x09C7,0x065E,0x0700,
	0x0AE5,0x0CF5,0x0B8E,0x0BF4,0x0F6B,0x1194,0x0FE7,0x0DCA,
	0x0ED7,0x110F,0x103C,0x0C7F,0x09DE,0x0A11,0x0A18,0x06FF,
	0x0284,0x002E,0xFFFB,0xFF52,0xFDE4,0xFD9C,0xFE12,0xFCB6,
	0xFA02,0xF907,0xFAA5,0xFCBB,0xFCF7,0xFA80,0xF89B,0xF8BD,
	0xF96F,0xF8BC,0xF7D0,0xF7C8,0xF87A,0xF980,0xF983,0xF955,
	0xF944,0xF9C4,0xFB53,0xFDEA,0x0096,0x0269,0x0280,0x01B4,
	0x0297,0x04DF,0x08F5,0x0A86,0x096B,0x08B9,0x0806,0x0717,
	0x06B4,0x0746,0x07C8,0x078A,0x075C,0x070D,0x070E,0x0654,
	0x0542,0x0487,0x04DB,0x05A8,0x05D3,0x03EC,0x0198,0x011D,
	0x0043,0xFF9B,0xFF32,0xFED6,0xFCE0,0xFA59,0xF8D5,0xF8F8,
	0xF9D5,0xF9DC,0xF89C,0xF774,0xF827,0xF9DD,0xF920,0xF643,
	0xF8A9,0xFDA6,0xFB39,0xF4DA,0xF765,0xFFB9,0x00CE,0xF967,
	0xF617,0xF882,0xFF79,0x021E,0xFE31,0xFCDF,0xFDD6,0x013D,
	0x0327,0xFEED,0xFE9E,0x01D3,0x027C,0x025D,0xFF97,0xFF71,
	0x029B,0x009B,0xFD4C,0x0029,0x034B,0xFE94,0xF79C,0xF9DA,
	0x0073,0x01A0,0xFC8B,0xF719,0xF9FE,0xFFEB,0xFF2F,0xFB73,
	0xF9DC,0xFBED,0xFC41,0xFA4B,0xF80F,0xF89B,0xFA75,0xF99B,
	0xF71D,0xF62F,0xF5E4,0xF581,0xF911,0xFCE2,0xF8BD,0xF213,
	0xF673,0xFFE2,0xFE9B,0xF4C4,0xF497,0x0135,0x0467,0xF7E5,
	0xF331,0xFBD7,0x0404,0x028D,0xF88D,0xF652,0x006D,0x0737,
	0xFE5C,0xF695,0xFE89,0x05CB,0x02BE,0xFD7B,0xFD70,0x01CC,
	0x0177,0xFCA4,0xFCAC,0x02B2,0x0613,0xFB68,0xF418,0xFD13,
	0x0789,0x00F9,0xF702,0xF83B,0x0013,0x00EE,0xF77E,0xF5B7,
	0x00D0,0x0537,0xF86B,0xF1BD,0xFE16,0x08AF,0xFEA1,0xF0D9,
	0xF65F,0x0293,0x0344,0xFA43,0xF5E5,0xFA3C,0xFEAD,0xFDAD,
	0xFB37,0xFC24,0xFF5D,0xFF57,0xFD8A,0xFEB4,0xFF1A,0xFFD8,
	0x0382,0x0338,0xFE81,0xFCD3,0xFF52,0x000F,0xFBCE,0xF833,
	0xF863,0xF8D2,0xF4DA,0xEEF5,0xED89,0xF05C,0xF356,0xF2D9,
	0xF1D0,0xF39A,0xF65C,0xF757,0xF90E,0xFCED,0x0207,0x03CE,
	0x0218,0x0197,0x044B,0x0620,0x03DC,0x02DA,0x02D6,0x04CC,
	0x06BA,0x0664,0x0550,0x05CC,0x07DA,0x09AA,0x0B66,0x0D5B,
	0x0DD4,0x0D06,0x0BCB,0x0BF7,0x0D20,0x0E30,0x0BE5,0x07F3,
	0x0608,0x05F0,0x04DF,0x02D2,0x00B3,0xFF17,0xFDD2,0xFD44,
	0xFCFD,0xFCAE,0xFCBC,0xFBC4,0xFB04,0xFB49,0xFC40,0xFC82,
	0xFB8E,0xF9CE,0xF8FC,0xF9DA,0xFAB3,0xFA49,0xF8DC,0xF8FE,
	0xF97C,0xF957,0xFA1E,0xFBA6,0xFD59,0xFE4A,0xFEB5,0xFF73,
	0x014A,0x03A3,0x05FB,0x077B,0x080B,0x0899,0x09CB,0x094B,
	0x089E,0x0890,0x08BA,0x0960,0x09BA,0x0974,0x083D,0x06B0,
	0x063D,0x0772,0x089B,0x091C,0x0846,0x0710,0x062F,0x05B5,
	0x052F,0x0408,0x02C8,0x01D3,0x01AF,0x00B0,0xFEE2,0xFC95,
	0xFB0B,0xFAC6,0xFB2B,0xFBAD,0xFC58,0xFBEA,0xFA73,0xF952,
	0xF9F7,0xF96E,0xFAE2,0x00C5,0x02FD,0xFD5B,0xF8BE,0xFA71,
	0xFE66,0xFF9C,0xFFEA,0x000D,0xFE94,0xFF10,0x025B,0x049B,
	0x0147,0xFDA2,0xFF2B,0x05B4,0x08AD,0x04C3,0x035A,0x058F,
	0x042B,0x0201,0x0518,0x0BBB,0x0666,0xFF9A,0x0224,0x07E4,
	0x0610,0xFEB5,0xFDE0,0x0416,0x05F8,0x0027,0xFA0A,0xFB86,
	0x02DB,0x053D,0xFE3F,0xF7F1,0xFB12,0x03D2,0x01D3,0xF6D9,
	0xF23D,0xFBDE,0x03FE,0xFE1A,0xF67B,0xF897,0xFEAD,0xFBFE,
	0xF63A,0xF8FE,0xFFFA,0x0037,0xFA36,0xF8B3,0xFE37,0x03C1,
	0x0086,0xF91E,0xFB06,0x037A,0x0630,0x0013,0xF96F,0xFFB0,
	0x0980,0x04A4,0xFC3D,0xFDC8,0x05A9,0x06CD,0xFD7C,0xFAA8,
	0x049D,0x08F0,0xFE1F,0xF627,0xFF96,0x0970,0x03A2,0xF86E,
	0xFBC1,0x0882,0x09C7,0xFD88,0xF7E7,0x00EF,0x0A68,0x0390,
	0xF7F0,0xFA34,0x0389,0x01F8,0xFACD,0xFD36,0x0289,0xFE2E,
	0xF7D3,0xF9ED,0x01D6,0x054B,0xFE67,0xF57A,0xFB1D,0x05A7,
	0x02BC,0xF6C8,0xF8B7,0x05A1,0x06F4,0xF93A,0xF342,0xFF53,
	0x099A,0x019C,0xF775,0xFDDA,0x086F,0x04F2,0xF99E,0xF863,
	0x010B,0x044B,0xFC49,0xF5A3,0xF78E,0xF9AD,0xF341,0xEACA,
	0xEDFB,0xF767,0xF8BB,0xF0E0,0xED84,0xF387,0xFAD3,0xFBE6,
	0xFAD5,0xFDCA,0x02CD,0x0389,0x015A,0x014E,0x050F,0x076A,
	0x04E2,0x02CA,0x0526,0x093E,0x0905,0x04AC,0x034D,0x06EE,
	0x0B63,0x0C97,0x0C6F,0x0CE2,0x0D0C,0x0C27,0x0B5D,0x0CD6,
	0x0F7B,0x0E65,0x0A1B,0x06A2,0x066A,0x060E,0x0378,0x0038,
	0xFE41,0xFDBA,0xFD30,0xFC27,0xFB11,0xFA92,0xF9AD,0xF873,
	0xF85A,0xF9EB,0xFABE,0xF966,0xF6B7,0xF56E,0xF641,0xF763,
	0xF716,0xF5EC,0xF597,0xF5FA,0xF647,0xF62B,0xF647,0xF7AA,
	0xF946,0xFB2F,0xFCE5,0xFE35,0xFFB2,0x0110,0x00FB,0x01A8,
	0x0337,0x04C5,0x043D,0x0535,0x0456,0x0310,0x040F,0x0428,
	0x04C4,0x0510,0x0435,0x0348,0x0409,0x04FF,0x0539,0x0416,
	0x02F5,0x02B7,0x02E9,0x029C,0x01BE,0x0019,0xFE31,0xFD53,
	0xFC99,0xFC76,0xFBD4,0xFA73,0xF834,0xF751,0xF821,0xF9B1,
	0xF9F1,0xF878,0xF6F3,0xF76D,0xF8AD,0xF7C8,0xF862,0xFB63,
	0xFDFA,0xFBAD,0xF5B1,0xF8F9,0xFFEC,0xFE34,0xF874,0xFB2C,
	0x0248,0x0284,0xFA8B,0xF92E,0x01E4,0x055A,0x02C4,0x024B,
	0x0544,0x052E,0x01E1,0x000F,0x0191,0x0663,0x07F8,0x03E9,
	0x005A,0x03FA,0x0657,0xFEAE,0xF9B5,0x01E2,0x0761,0xFF89,
	0xF8FE,0xFEFF,0x0510,0xFFEA,0xF6C3,0xF99A,0x0563,0x035A,
	0xF4E7,0xF479,0x0246,0x040C,0xF6BE,0xF421,0xFE81,0x025C,
	0xF84A,0xF1F8,0xFA0D,0x0334,0x0105,0xF86F,0xF823,0x0164,
	0x03D0,0xF9CD,0xF4A8,0xFDE5,0x076E,0x0575,0xFD25,0xFBDA,
	0x021C,0x04BB,0x00C0,0xFDA5,0x01BF,0x03B4,0x0169,0x029E,
	0x02D8,0x00FA,0x0066,0x01C2,0x0351,0x0545,0x0331,0xFE5C,
	0xFF94,0x0574,0x0835,0x0305,0xFD77,0x00F7,0x066E,0x029D,
	0xFC15,0xFF7F,0x04A8,0x010E,0xFBFB,0xFD4F,0x0410,0x058F,
	0xFE7E,0xFAB5,0xFFD8,0x02B9,0xFC90,0xF952,0x0129,0x062F,
	0x003F,0xF89D,0xF8E9,0xFFC5,0x0271,0xFDA7,0xFAFB,0x0189,
	0x05E1,0xFFC9,0xFA1D,0xFDF9,0x0380,0x01F2,0xFF98,0x013E,
	0x0339,0x01E7,0xFF0A,0xFE5D,0xFF12,0xFE86,0xFBCF,0xF91B,
	0xF75E,0xF481,0xF056,0xEE91,0xF09A,0xF2A6,0xF245,0xF0CE,
	0xF1B1,0xF4D5,0xF802,0xF957,0xFB76,0xFED8,0x01D2,0x0239,
	0x01F4,0x02E8,0x0582,0x0597,0x0436,0x05CB,0x0618,0x06BA,
	0x06DC,0x0634,0x06B5,0x0894,0x0A9B,0x0B7F,0x0CAE,0x0D85,
	0x0D74,0x0CD0,0x0C99,0x0D68,0x0E26,0x0C96,0x093B,0x0608,
	0x051D,0x0528,0x034F,0x00B9,0xFE7B,0xFC93,0xFBEB,0xFB66,
	0xFB30,0xFAF8,0xFAA1,0xFA42,0xF9E0,0xFA22,0xFAE8,0xFA73,
	0xF9B7,0xF94F,0xF929,0xF849,0xF6F9,0xF6A1,0xF741,0xF7CA,
	0xF7DC,0xF7BA,0xF85E,0xF947,0xFB0F,0xFC54,0xFDBE,0xFFD6,
	0x0155,0x01FC,0x021D,0x0344,0x056A,0x06E3,0x06AE,0x05E7,
	0x05EE,0x083C,0x08F0,0x07BD,0x073E,0x077D,0x07E0,0x07FE,
	0x07BE,0x06AC,0x058D,0x0572,0x0615,0x0666,0x05BD,0x04B9,
	0x02D4,0x00DB,0xFF96,0xFF60,0xFEAC,0xFDC6,0xFCFC,0xFB06,
	0xF9BB,0xF9B4,0xFA9B,0xF9F6,0xF929,0xF8DA,0xF919,0xF9BB,
	0xFA14,0xF91C,0xF9D8,0xFBE3,0xFACB,0xFA48,0xFC20,0xFC83,
	0xFCFC,0xFBE0,0xFA69,0xFC8E,0x013C,0x01AE,0xFD19,0xFA78,
	0x005C,0x053E,0x0286,0xFF60,0x02AF,0x0722,0x0528,0x0069,
	0x0184,0x059F,0x0413,0xFF13,0xFE90,0x02E9,0x048F,0xFF62,
	0xFAF0,0xFE95,0x0128,0xFE65,0xFC35,0xFD93,0xFEBB,0xFCCC,
	0xFA84,0xFA3B,0xFD3C,0xFE62,0xFA5F,0xF725,0xF8B5,0xFC8F,
	0xFB19,0xF780,0xF765,0xF847,0xF881,0xF908,0xF9B3,0xF914,
	0xF8EB,0xF95B,0xF9F4,0xF996,0xFA3A,0xFCDD,0xFD3A,0xF9AD,
	0xF8F6,0xFE89,0x0139,0xFC32,0xF91C,0xFE1C,0x049A,0x00ED,
	0xF9C5,0xFB38,0x02B6,0x04E3,0xFEC2,0xFC79,0x00FA,0x043C,
	0x01CE,0xFD1E,0xFDA7,0x0339,0x0343,0xFE5E,0xFC6C,0x0092,
	0x043F,0x007C,0xFBA8,0xFF9A,0x0224,0x008F,0xFBA1,0xFB2E,
	0x0059,0x025F,0xFD33,0xF949,0xFCE9,0x01F0,0xFF8F,0xF920,
	0xF971,0xFEB1,0x0056,0xFCAA,0xFB1D,0xFCEF,0xFEB7,0xFDD6,
	0xFC43,0xFD66,0xFF56,0xFF7B,0xFCE7,0xFADF,0xFDC4,0x01F1,
	0x00D7,0xFDA1,0xFDF7,0x0009,0x0085,0xFED9,0xFE05,0xFEE7,
	0xFF4E,0xFDE3,0xFC37,0xFBC9,0xFB9C,0xF9E6,0xF84A,0xF978,
	0xFB22,0xFB55,0xFA21,0xF9DF,0xFB35,0xFD19,0xFDF6,0xFE94,
	0x002B,0x00C5,0x00F1,0x008A,0x0109,0x01DD,0x0219,0x0198,
	0x01A4,0x0293,0x023F,0xFF3C,0xFF23,0x0004,0x01E6,0x0307,
	0x02D9,0x02BC,0x0356,0x0421,0x04A9,0x04EC,0x04DD,0x0448,
	0x0338,0x0273,0x0255,0x01E2,0x016D,0xFFF3,0xFE14,0xFE24,
	0xFEBD,0xFE67,0xFD3D,0xFC7F,0xFCC1,0xFD64,0xFDAF,0xFDB9,
	0xFE07,0xFCEB,0xFBD1,0xFC76,0xFD3F,0xFE3E,0xFD62,0xFBB2,
	0xFB42,0xFC51,0xFCD0,0xFD4E,0xFD1E,0xFCB2,0xFD4B,0xFE4E,
	0xFFCF,0x010C,0xFFFA,0xFF71,0x0082,0x0203,0x0282,0x0292,
	0x03C9,0x0452,0x039B,0x0253,0x0350,0x05DC,0x0663,0x046D,
	0x025B,0x02B5,0x04AB,0x059B,0x04A7,0x0295,0x025D,0x03EE,
	0x04F8,0x0472,0x02CA,0x01BC,0x00E9,0x0039,0x0064,0x0139,
	0x0119,0xFFE1,0xFDF8,0xFD14,0xFE62,0xFECA,0xFEC9,0xFF54,
	0xFF48,0xFE6D,0xFDD0,0xFE24,0xFF07,0xFF7C,0xFF99,0xFFFC,
	0xFFE4,0xFF6F,0xFE97,0xFDAD,0xFDC6,0xFED7,0x002D,0x0033,
	0xFF4E,0xFFB2,0xFFFB,0x0014,0xFFAF,0x004B,0x0215,0x0306,
	0x01C9,0x0113,0x019C,0x019D,0x0102,0x00BB,0x012C,0x00C8,
	0x0006,0xFFF4,0x001F,0xFD9A,0xFD6B,0xFD30,0xFBE3,0xFBB4,
	0xFAB4,0xF952,0xF7FA,0xF7A2,0xF825,0xF897,0xF95A,0xF940,
	0xF7DA,0xF60B,0xF548,0xF57A,0xF653,0xF663,0xF587,0xF427,
	0xF400,0xF3EE,0xF391,0xF2DA,0xF2AE,0xF26C,0xF23C,0xF1BD,
	0xF13A,0xF09C,0xEFE3,0xEF45,0xEEAA,0xEE9A,0xEE16,0xED56,
	0xEC4A,0xEBB6,0xEB43,0xEB25,0xEAD7,0xEA79,0xEA01,0xE974,
	0xE920,0xE943,0xE902,0xE90B,0xE92E,0xE85B,0xE815,0xE7CB,
	0xE7A6,0xE756,0xE76A,0xE709,0xE6F7,0xE71F,0xE73A,0xE71D,
	0xE7CB,0xEA15,0xE90A,0xE8AE,0xE896,0xE8FD,0xE984,0xE90F,
	0xE8CF,0xE94F,0xE9A6,0xE9C7,0xE9CD,0xE996,0xEA0D,0xEA38,
	0xEA48,0xEAB3,0xEB58,0xEB1F,0xEB02,0xEC59,0xED1C,0xED73,
	0xED1A,0xED92,0xEE37,0xEF54,0xEF99,0xEF9E,0xEFDE,0xEFBD,
	0xEFF9,0xF02F,0xF070,0xF13A,0xF1DA,0xF24D,0xF256,0xF23B,
	0xF2B9,0xF38C,0xF41A,0xF495,0xF54D,0xF4EA,0xF40B,0xF52B,
	0xF640,0xF6D2,0xF6DC,0xF75C,0xF7B1,0xF82C,0xF8C8,0xF8FE,
	0xF929,0xF8F2,0xF8E1,0xF9BD,0xF9A1,0xF966,0xF9B9,0xF9F5,
	0xFA18,0xFA51,0xFB53,0xFC05,0xFC25,0xFCAB,0xFCDE,0xFD5D,
	0xFDFA,0xFE55,0xFEC5,0xFFA1,0x0006,0x0010,0x0057,0x00E3,
	0x00C5,0x0140,0x019F,0x01F9,0x0235,0x0286,0x02B6,0x02B2,
	0x02BE,0x0338,0x03CC,0x0498,0x0500,0x051B,0x04FF,0x04E5,
	0x0570,0x05DD,0x064B,0x069D,0x06FD,0x0799,0x0789,0x0764,
	0x0798,0x07E0,0x0823,0x0875,0x08E6,0x0892,0x08A7,0x08E6,
	0x0980,0x0998,0x099A,0x0A07,0x0B40,0x0B1C,0x0B50,0x0BD6,
	0x0C50,0x0B76,0x0C91,0x0CD3,0x0B6E,0x0CBF,0x0C99,0x0C18,
	0x0C4D,0x0C97,0x0CB0,0x0D63,0x0D42,0x0D5C,0x0D78,0x0D4F,
	0x0D1A,0x0CEC,0x0D19,0x0D9B,0x0DEC,0x0D75,0x0D72,0x0CEF,
	0x0D5A,0x0DB3,0x0E0C,0x0E46,0x0E4D,0x0E4C,0x0E1F,0x0E19,
	0x0DEE,0x0E58,0x0E53,0x0E66,0x0E4E,0x0E05,0x0E07,0x0DEF,
	0x0E1B,0x0E4A,0x0E2C,0x0E1C,0x0E7F,0x0DEE,0x0DED,0x0DDD,
	0x0DBB,0x0DE6,0x0E8E,0x0E47,0x0DA3,0x0D46,0x0D8F,0x0DA6,
	0x0DEB,0x0DE4,0x0E07,0x0E10,0x0DF2,0x0DC4,0x0D86,0x0DB8,
	0x0D8B,0x0CD0,0x0B49,0x0A84,0x0B3E,0x0B52,0x0B85,0x0B9F,
	0x0BC9,0x0B67,0x0B46,0x0ABF,0x0A8E,0x0ACB,0x0AE1,0x0AF4,
	0x0AF3,0x0AF6,0x0B0F,0x0AD9,0x0B07,0x0A59,0x0A2B,0x0AF6,
	0x0B36,0x0AAF,0x0AB8,0x0AD4,0x0AA2,0x0A85,0x0AEC,0x0B05,
	0x0B37,0x0AA4,0x0A83,0x0A78,0x0A98,0x0A74,0x0A62,0x0A49,
	0x09F9,0x0A35,0x0A08,0x0997,0x098B,0x0A37,0x0B72,0x0A29,
	0x093C,0x08EE,0x0973,0x0956,0x0954,0x092A,0x092A,0x0936,
	0x0959,0x09DC,0x0A0D,0x0A44,0x0ABB,0x0AEA,0x0AB3,0x0AB2,
	0x0A28,0x09DB,0x09D5,0x0A11,0x09BA,0x09A6,0x0988,0x0979,
	0x0921,0x08F6,0x0939,0x0918,0x08E6,0x0876,0x08AD,0x0877,
	0x084E,0x0850,0x07E1,0x07CF,0x07F1,0x07D4,0x07D6,0x0799,
	0x077C,0x0760,0x0707,0x06AB,0x06B4,0x067B,0x069E,0x0672,
	0x063A,0x05F9,0x054B,0x0533,0x058A,0x05BE,0x05C4,0x0546,
	0x0541,0x0537,0x052A,0x0560,0x04FC,0x04C7,0x048B,0x044F,
	0x0422,0x0465,0x045F,0x0463,0x0432,0x044E,0x043D,0x03CE,
	0x03D5,0x04F8,0x0392,0x028B,0x0486,0x0405,0x03E0,0x03B0,
	0x038D,0x0321,0x02F3,0x02C1,0x030E,0x0306,0x0303,0x0307,
	0x02E8,0x02A4,0x02D8,0x02A5,0x029A,0x0275,0x0296,0x02CA,
	0x0282,0x0276,0x0267,0x02A2,0x02AA,0x02CB,0x0276,0x0253,
	0x01C5,0x015F,0x0146,0x00E5,0x014E,0x0154,0x0153,0x0139,
	0x0132,0x0161,0x013A,0x013F,0x014A,0x0120,0x00D2,0x00C1,
	0x0100,0x00DA,0x00B7,0x00EB,0x00FF,0x0124,0x0155,0x013A,
	0x0152,0x00E1,0x00A3,0xFFA6,0xFFD4,0xFFC1,0xFF74,0xFF7D,
	0xFF83,0xFF86,0xFFAB,0x0005,0x006A,0x0023,0x0015,0x009E,
	0x0203,0x0343,0x03AD,0x0362,0x032D,0x0417,0x0601,0x075B,
	0x08B0,0x0A37,0x0B12,0x0BAC,0x0B80,0x0BD4,0x0BF4,0x0B5F,
	0x09BF,0x09C3,0x0A50,0x0AA1,0x0AA7,0x0A60,0x09E0,0x0A0A,
	0x0B41,0x0CE5,0x0E15,0x0D74,0x0B97,0x0AFB,0x0C25,0x0E2D,
	0x0F81,0x0FDF,0x1029,0x104B,0x11C3,0x11D2,0x1111,0x12A2,
	0x141D,0x1375,0x131C,0x1590,0x1726,0x158A,0x1348,0x13F3,
	0x16EC,0x1813,0x1735,0x17E1,0x191E,0x18B0,0x171F,0x15FA,
	0x16D7,0x186B,0x1907,0x198D,0x1923,0x17BB,0x1761,0x1749,
	0x16F1,0x16A1,0x1781,0x18F7,0x1994,0x1812,0x15E4,0x1614,
	0x17B5,0x182A,0x17C5,0x168C,0x1626,0x1660,0x1613,0x15A7,
	0x1572,0x154F,0x13A9,0x1269,0x136A,0x147B,0x149A,0x1209,
	0x0FC8,0x10BD,0x121E,0x1170,0x1069,0x108A,0x11B3,0x1026,
	0x0C6B,0x0B9F,0x0D9E,0x0E7B,0x0D67,0x0B38,0x0AE5,0x0B90,
	0x0ABE,0x0911,0x0821,0x0902,0x0ADB,0x0AF3,0x0887,0x0603,
	0x06B6,0x07B9,0x0591,0x0392,0x03C4,0x0667,0x07AE,0x0492,
	0x01CF,0x02F4,0x0544,0x02DF,0xFE13,0xFF3B,0x04E2,0x0596,
	0xFFE0,0xFCC3,0xFE50,0xFFBE,0xFE61,0xFC02,0xFDCE,0x01ED,
	0xFF38,0xFAD7,0xF8A7,0xF9BE,0xFCF7,0xFCBE,0xFAA1,0xFACE,
	0xFC66,0xFC18,0xF8B3,0xF5CA,0xF6A5,0xF9D8,0xFAD6,0xF7FF,
	0xF5EA,0xF5EF,0xF5C7,0xF513,0xF40D,0xF376,0xF506,0xF816,
	0xF8B1,0xF543,0xF173,0xF125,0xF381,0xF648,0xF588,0xF383,
	0xF328,0xF537,0xF39E,0xF018,0xF01D,0xF361,0xF529,0xF34A,
	0xF255,0xF492,0xF513,0xF125,0xEC54,0xEE6F,0xF473,0xF4BC,
	0xF148,0xF12C,0xF429,0xF2E2,0xED8F,0xECC0,0xF0B8,0xF26A,
	0xF096,0xEF6B,0xF10D,0xF343,0xF185,0xEE98,0xEF59,0xF49A,
	0xF7DF,0xF314,0xEEBB,0xF22F,0xF5A0,0xF0C4,0xEADA,0xEE12,
	0xF74C,0xF861,0xF029,0xEC82,0xF209,0xF5AF,0xF040,0xEB24,
	0xEFC3,0xF5F0,0xF53B,0xEF1E,0xEB34,0xEFC4,0xF548,0xF0AE,
	0xEB5D,0xEF7C,0xF5AB,0xF3B5,0xECF6,0xEC22,0xF28A,0xF441,
	0xEE3F,0xEC41,0xF1EC,0xF672,0xF06F,0xE959,0xEDA5,0xF5A1,
	0xF250,0xE9E5,0xEC87,0xF5E2,0xF5BC,0xEABF,0xE76B,0xF08D,
	0xF799,0xF34E,0xECAF,0xEFAA,0xF65F,0xF2AE,0xEA78,0xEB7D,
	0xF16B,0xF39F,0xEFDB,0xEB75,0xEE4B,0xF561,0xF4D3,0xED6D,
	0xEB1D,0xF178,0xF647,0xF1A3,0xEC4F,0xEF81,0xF446,0xF2AB,
	0xEDC3,0xED32,0xF1BA,0xF745,0xF739,0xF10F,0xEFA7,0xF354,
	0xF3E9,0xF043,0xED98,0xF203,0xF8CD,0xF759,0xEEA9,0xEC44,
	0xF3C8,0xF960,0xF4A6,0xEF15,0xF1D6,0xF9BB,0xFA36,0xF0DA,
	0xEA86,0xEFAF,0xF881,0xF7FC,0xF20B,0xF2A3,0xF65F,0xF490,
	0xF0A9,0xF127,0xF5DE,0xF893,0xF549,0xF25F,0xF4CB,0xF727,
	0xF493,0xF35B,0xF311,0xF656,0xFA25,0xF86F,0xF593,0xF708,
	0xF5EE,0xF36D,0xF519,0xF767,0xF94A,0xF872,0xF70D,0xF672,
	0xF777,0xF811,0xF806,0xF5A4,0xF615,0xFB00,0xFDE7,0xF7C3,
	0xF208,0xF4E1,0xFA39,0xFA00,0xF646,0xF7EA,0xFC27,0xFBD2,
	0xF6A4,0xF459,0xF879,0xFDEB,0xFBAC,0xF4D2,0xF5A0,0xFC55,
	0xFF39,0xFB6D,0xF648,0xF629,0xFCBF,0x00B8,0xFB9C,0xF5A5,
	0xF7EE,0x003C,0xFF79,0xF5C3,0xF227,0xFDFD,0x0633,0xFBD2,
	0xF129,0xFA02,0x04B9,0xFE06,0xF3AC,0xF6B7,0x0093,0x0185,
	0xF8E6,0xF819,0x00E7,0x0326,0xFACE,0xF519,0xFB60,0x0172,
	0xFC7B,0xF298,0xF3A3,0xFD9A,0xFFB8,0xF503,0xF0D7,0xFD06,
	0x06E0,0xFD1A,0xF220,0xF6F8,0x0188,0xFF2C,0xF3B1,0xF335,
	0xFFAF,0x0559,0xFCA0,0xF55B,0xF780,0xFCBB,0xFFE9,0xFEEA,
	0xFCB8,0xFB8D,0xFC7C,0xFF59,0xFB1D,0xF4A7,0xFA1C,0x0642,
	0x0646,0xFB08,0xF6A0,0xFD14,0x0265,0xFF9E,0xFB9D,0xFB56,
	0xFFB5,0x0297,0x0117,0xFDB6,0xFBC5,0xFDFF,0x015C,0xFFD8,
	0xFC9A,0x015A,0x0564,0x00B7,0xFB23,0xFC05,0x00F9,0x02CA,
	0x00F0,0x00A0,0x013D,0x0076,0x017F,0x0067,0xFBAA,0xFCCC,
	0x0577,0x06CB,0xFCF4,0xF9BA,0x0424,0x08ED,0xFC6A,0xF600,
	0xFF90,0x0947,0x0768,0xFE68,0xFAEC,0xFF57,0x00E5,0xFDCF,
	0xFF03,0x0343,0x01AC,0xFD46,0xFEFA,0x02A9,0x009A,0xFAA4,
	0xFD36,0x05B8,0x05DC,0xFDCA,0xFADE,0xFF3C,0x02C4,0xFF95,
	0xFD34,0xFE2F,0x0183,0x047B,0x02EF,0xFEE4,0xFD7F,0xFFC8,
	0x01D3,0x016A,0x00F3,0x01E7,0x04D5,0x0387,0xFD34,0xFBCA,
	0x00FD,0x043E,0x01F5,0xFF53,0x0297,0x0672,0x036F,0xFB0C,
	0xFA26,0x0220,0x050B,0x0283,0xFF82,0xFFC2,0x039B,0x035F,
	0xFC10,0xF9C3,0x03B5,0x0AA3,0x00AE,0xF82D,0xFE3D,0x04C4,
	0x026D,0xFDA0,0xFCD2,0x0002,0x0578,0x06C2,0x0048,0xFB33,
	0xFE0A,0x01DD,0x008C,0xFDBA,0xFEF9,0x00D7,0x0294,0xFDCE,
	0xF919,0xFC0C,0x0232,0x0561,0x023F,0xFC45,0xFBE1,0x0182,
	0x0296,0xFD5A,0xFD35,0x040C,0x0604,0x0006,0xFC46,0xFE13,
	0x0061,0xFF47,0xFEE2,0x021B,0x03B8,0x0138,0xFF22,0xFFC2,
	0xFEB9,0xFDC2,0x0142,0x034A,0x009A,0xFFE8,0xFFF5,0x0178,
	0x04C3,0x0378,0xFDDD,0xFCE8,0x006B,0x0325,0x0395,0x0216,
	0x0214,0x03A0,0xFFBC,0xFC39,0x021B,0x0823,0x0570,0xFE6D,
	0xFD75,0x0216,0x0368,0xFD91,0xFD1C,0x0722,0x0A92,0x014B,
	0xFA53,0xFD19,0x0391,0x054D,0xFE78,0xFCC3,0x0501,0x06E6,
	0x0077,0xFC44,0xFE67,0x034E,0x0540,0x01D0,0xFD4D,0x00B3,
	0x0811,0x03C3,0xF74A,0xF7B5,0x05FE,0x0BCB,0x0072,0xF892,
	0x021D,0x0CCD,0x028C,0xF3C5,0xF8AC,0x0A66,0x0C6B,0xFB65,
	0xF3C9,0xFED7,0x07DD,0xFE84,0xF363,0xF7FF,0x04BD,0x0758,
	0xFB6A,0xF480,0xFBE6,0x02B3,0xFF26,0xF8A0,0xFB96,0x05C9,
	0x052B,0xF94E,0xF6C9,0x0077,0x04BA,0xFCB6,0xF98A,0x0017,
	0x051E,0xFE57,0xF685,0xFA90,0x020D,0x00A5,0xFB68,0xFC94,
	0x0209,0x027E,0xFE11,0xFA20,0xFB17,0x013E,0x02BC,0xFC7F,
	0xFC8A,0x01FC,0x032E,0xFDC1,0xF9E5,0xFCF8,0x0158,0x003B,
	0xFA59,0xFA96,0x0192,0x053D,0xFDF9,0xF777,0xFD35,0x04F9,
	0x040F,0xFDD1,0xFC84,0x00F9,0x04AE,0x0236,0xF9F3,0xF886,
	0xFE6C,0x052C,0x03A9,0xFF63,0xFE6B,0x00CB,0x003A,0xFC3E,
	0xFE53,0x007A,0x015A,0x0174,0xFF58,0xFFAC,0x024A,0x00D7,
	0xFB8B,0xFD20,0x03FB,0x045F,0xFC18,0xF8E9,0x001A,0x0504,
	0xFF34,0xFB47,0x01CF,0x05A8,0xFFA1,0xFCB1,0x0288,0x0444,
	0xFD99,0xFC23,0x003E,0x03BD,0x03B4,0x021B,0xFEB4,0xFF16,
	0x0330,0x0170,0xFECF,0x00A1,0x01C0,0x0133,0x002B,0xFF1D,
	0x0104,0x027C,0xFFD0,0xFE6E,0x02E4,0x0525,0x0203,0xFFA1,
	0xFDAD,0xFFD1,0x03AF,0x0195,0xFF1C,0x036A,0x052B,0xFF53,
	0xFAD0,0xFB9D,0xFDE4,0x0115,0x01D3,0xFFC6,0xFCB8,0xFD56,
	0xFF62,0xFE05,0xFBD4,0xFE14,0x039A,0x063B,0x02C2,0xFCC5,
	0xFC9C,0x013B,0x02BE,0x004D,0xFF42,0x00C8,0x012B,0x02AB,
	0x0426,0x01E1,0xFD7F,0xFBFD,0x0117,0x06E2,0x073B,0x013D,
	0xFA33,0xFC0F,0x0527,0x061E,0xFC2D,0xFB04,0x07A5,0x0DDE,
	0xFEBE,0xF226,0xFEE0,0x0CB1,0x0395,0xF660,0xFE01,0x0CD4,
	0x0927,0xFBA4,0xF945,0x02C7,0x0661,0x0197,0xFFBE,0x043D,
	0x08A7,0x0626,0xFE8F,0xFD45,0x02AB,0x0A21,0x09DB,0x011E,
	0x0077,0x079B,0x07C3,0xFCEC,0xFB56,0x0701,0x0C8E,0x02BA,
	0xFA01,0x0108,0x0A2F,0x0537,0xFC96,0x0106,0x0AEB,0x0AF6,
	0x0050,0xFA11,0x000F,0x074B,0x05F0,0xFE42,0xFBDB,0x04BA,
	0x0A8D,0x03FC,0xFB92,0xFDD4,0x0521,0x051D,0x0175,0x01AD,
	0x0250,0x02EE,0x02B3,0x005F,0xFF0F,0xFF61,0x02EE,0x0743,
	0x03BA,0xFE91,0x013D,0x04BB,0x019D,0xFC30,0xFC31,0x0360,
	0x07F3,0x0518,0xFE6B,0xFD6C,0x017F,0x0418,0x015B,0xFB1A,
	0xFFE8,0x07E9,0x0499,0xFA86,0xF955,0x0425,0x096C,0x0170,
	0xFB5A,0x01D4,0x0A10,0x03B0,0xF688,0xF9C2,0x0813,0x0873,
	0xFAF1,0xF8A2,0x06B7,0x0D51,0xFE2D,0xF31C,0x0012,0x0CFF,
	0x0760,0xFAD4,0xFAA8,0x0616,0x0677,0xFC36,0xFA47,0x0586,
	0x0A3C,0xFFB2,0xFA10,0x01FE,0x0A02,0x0447,0xF854,0xF732,
	0x0344,0x0BEF,0x03D9,0xF8D5,0xFB72,0x0505,0x04C7,0xFC8A,
	0xFB8C,0x0433,0x07B1,0xFE07,0xF7BB,0xFEB4,0x067C,0x04F6,
	0xFD7F,0xFD4C,0x04CE,0x07B6,0x0027,0xFA61,0xFF45,0x0769,
	0x059D,0x0042,0x02EA,0x058E,0x02AE,0xFF69,0xFD69,0x01A7,
	0x07E4,0x0464,0xFB61,0xFD77,0x0804,0x07E6,0xF980,0xF58B,
	0x033F,0x094C,0xFEA1,0xF73F,0x0081,0x098F,0x03DF,0xF979,
	0xF91A,0x005B,0x0285,0xFDDF,0xFC9F,0xFFBB,0xFFF1,0xFE8E,
	0xFDBB,0xFD6B,0xFEAE,0x028C,0x025A,0xFBCB,0xF776,0xFD99,
	0x01FF,0xFB6C,0xF76C,0xFC04,0x01FB,0x0388,0xFEF9,0xF8CB,
	0xF9E1,0x0281,0x01B6,0xF8F8,0xF835,0x0299,0x0632,0xFAEF,
	0xF21C,0xF8A3,0x0249,0xFEC1,0xF754,0xFAF9,0x034A,0x005F,
	0xF569,0xF44F,0xFDA1,0x0058,0xFCC1,0xF96D,0xF930,0xFD10,
	0x017F,0xFE85,0xF642,0xF73B,0x02CF,0x0640,0xFBA0,0xF4A5,
	0xFB62,0x0323,0xFE86,0xF4BA,0xF816,0x052C,0x067A,0xF891,
	0xF108,0xFB56,0x0623,0x01BE,0xF67C,0xF76B,0x0399,0x0510,
	0xF83D,0xF4CA,0xFF82,0x05AC,0xFDD7,0xF4C8,0xF9BF,0x0480,
	0x02CD,0xF94F,0xF7EA,0xFD68,0xFFC3,0xFF74,0xFF1B,0xFE76,
	0xFCCB,0xFC5A,0xFFF6,0xFDF1,0xF948,0xFA8E,0xFEBC,0xFF75,
	0xFFD6,0xFE64,0xF90C,0xFB58,0x0276,0x0265,0xFAD7,0xF970,
	0x0049,0x01D3,0xFBA0,0xF939,0xFD6B,0x036A,0x01DD,0xFBA2,
	0xFBE0,0x02B4,0x04D3,0xFE98,0xF992,0xFA72,0xFD81,0xFE91,
	0xFFA6,0x025E,0x01B0,0xFE49,0xFCB2,0xFD4B,0xFD38,0xFEFC,
	0x01AD,0x02E1,0x028E,0x0009,0xFCF7,0xFADF,0xFD86,0x0427,
	0x0511,0xFD51,0xFCF3,0x04D6,0x0601,0xFB71,0xF7D7,0x02D3,
	0x099C,0x0263,0xFA85,0xFCE5,0x0334,0x0362,0xFE04,0xFDC1,
	0x0525,0x0656,0xFE7B,0xFDB2,0x01C7,0x02A2,0xFD42,0xFA25,
	0x0088,0x056C,0x0244,0xFD40,0xFCB0,0x002B,0x0428,0x003E,
	0xF9ED,0xFD88,0x051D,0x0506,0xFF96,0xFF52,0x021A,0x0287,
	0xFE58,0xFA85,0x0126,0x08AC,0x02CE,0xFA35,0xFDC0,0x0859,
	0x06A3,0xFC5B,0xFC0C,0x05B7,0x07A5,0x005B,0xFC3C,0xFFDD,
	0x044E,0x02D5,0xFF50,0x0026,0x03B5,0x01C6,0xFBB2,0xFC73,
	0x01FB,0x03E6,0x016D,0x00DE,0x0652,0x0571,0xFB86,0xF9AF,
	0x01F3,0x0345,0xFDAB,0xFD0D,0x04CA,0x098B,0x011B,0xF935,
	0x0199,0x09E4,0x0795,0x0104,0xFEA5,0x0483,0x08E4,0x01BF,
	0xFA0F,0xFE7E,0x0700,0x0750,0xFEEF,0xFCDA,0x04A5,0x0565,
	0xFD80,0xFB60,0x026F,0x041B,0x0007,0xFE2A,0x01CD,0x041B,
	0xFFFA,0xFEC2,0xFF00,0x00D7,0x0388,0x02CF,0xFFE6,0xFE95,
	0xFEE3,0xFEE6,0xFECF,0x0115,0x043E,0x017E,0xFD0F,0xFF11,
	0x033B,0x0249,0xFE2C,0xFB80,0x0072,0x05ED,0x04AA,0x0010,
	0xFDB8,0xFE47,0xFE09,0x0019,0x02F1,0x04CD,0x0550,0x020F,
	0xFAE6,0xFA15,0x0017,0x0575,0x009F,0xFAF9,0xFE42,0x0531,
	0x06C6,0xFEC8,0xF90D,0xFE7B,0x0836,0x0644,0xFCD8,0xF970,
	0xFDC3,0x01F6,0x005E,0xFE6F,0x0011,0x028D,0x0184,0xFC7D,
	0xFBBF,0x0259,0x0385,0xFD0D,0xF959,0xFC3E,0x0134,0x03F6,
	0x0118,0xFB00,0xFAE2,0x00F3,0x02CD,0xFE5D,0xFC34,0x014D,
	0x04C1,0x01D4,0xFD6C,0xFC55,0xFDED,0xFF4B,0x0102,0x0351,
	0x03EA,0xFD56,0xF940,0xFE21,0x04E0,0x0061,0xFBC0,0xFEA6,
	0x00F4,0x0118,0xFD5F,0xFAD4,0xFD7E,0x02A6,0x02AF,0xFD59,
	0xFD5C,0x026C,0x015C,0xF9CF,0xFAC3,0x019B,0x06F5,0x05D8,
	0xFEA2,0xFAC4,0x0122,0x07DF,0x0243,0xF93F,0xFA64,0x06BF,
	0x09BF,0xFBDA,0xF5C1,0x02D7,0x0AFD,0xFDC8,0xF26E,0xFF13,
	0x0EA7,0x0799,0xF578,0xF39A,0x0224,0x08CD,0xFE4C,0xF872,
	0x02AE,0x08F1,0xFEB4,0xF6BC,0xFDC6,0x06FD,0x0484,0xFC8F,
	0xF941,0x0005,0x0508,0x0010,0xF98C,0xFC0F,0x032F,0x0497,
	0x01AA,0xFE9B,0xFEA4,0x00A4,0xFF31,0xFCFF,0xFE85,0x001E,
	0xFF6A,0xFFB0,0x01F1,0x02AB,0xFE42,0xFAF9,0xFD99,0x016A,
	0x0000,0xFBCE,0xFAA6,0xFD60,0xFE0D,0xF9E5,0xF90E,0xFE71,
	0x0359,0xFDA2,0xF834,0xFE8F,0x0289,0xFC3D,0xF629,0xFA6B,
	0x03C6,0x01FA,0xF7FE,0xFA22,0x0464,0x0347,0xF90C,0xF4F0,
	0xFE72,0x0874,0x025B,0xF6CA,0xF6AC,0xFE8F,0x017D,0xFB4D,
	0xF764,0xFE1D,0x06D7,0x0387,0xFA39,0xF90E,0x00A7,0x01CD,
	0xF92D,0xF5AE,0xFEEC,0x063E,0x0207,0xF7E4,0xF903,0x03E0,
	0x0526,0xFBC2,0xF872,0xFFF3,0x05B3,0xFE13,0xF5D1,0xFCA2,
	0x04E6,0xFEC2,0xF47E,0xF8C1,0x0799,0x0ADE,0xFD00,0xF447,
	0xFF32,0x07FB,0xFF0F,0xF916,0x003C,0x0623,0x0028,0xF55B,
	0xF85C,0x0583,0x07DF,0xFD26,0xF73A,0xFF50,0x070A,0x0369,
	0xFC84,0xF9E1,0xFE9F,0x04BA,0x0316,0xFC34,0xFB4A,0x02AE,
	0x01FE,0xFA75,0xFBBD,0x0210,0x0084,0xFAE1,0xFCFD,0x003E,
	0xFE0A,0xFC07,0xFF59,0x0036,0xFC04,0xFB9B,0x00C6,0x0392,
	0x0133,0xFDBE,0xFAFA,0xFACA,0x0132,0x0611,0x01C2,0xFB58,
	0xFB3C,0xFE28,0xFFD6,0xFF2C,0x000A,0x0044,0xFDAB,0xFAC5,
	0xFEAC,0x035D,0x0020,0xF81C,0xF879,0x0020,0x011C,0xFB9D,
	0xFA4E,0xFDC1,0xFD8B,0xFCCA,0xFB20,0xFB6D,0xFFE7,0x00B4,
	0xFBA2,0xF799,0xFB9E,0x00CE,0xFF04,0xFB2F,0xFE7A,0x0219,
	0xFCB2,0xF872,0xFF1B,0x026D,0xFA6E,0xF5DD,0xFD0D,0x0535,
	0x0341,0xF9C0,0xF6FF,0xFFDB,0x04D4,0xFFF6,0xFB36,0xFD67,
	0x02EB,0x0297,0xFC8E,0xFA41,0xFCE4,0xFFE0,0x024D,0x008F,
	0xFD43,0xFE00,0x02A3,0x01DE,0xFBF2,0xF8B9,0xFB46,0x00D7,
	0x02C8,0xFF1C,0xFD3A,0x0193,0x0317,0xFBA9,0xF87B,0x0169,
	0x0A02,0x0734,0xFF20,0xFCE0,0x01F9,0x0304,0xFE67,0xFF9E,
	0x06DC,0x07A1,0xFEC4,0xF9EB,0x0317,0x07EC,0xFF8B,0xFBA9,
	0x0290,0x08E3,0x043A,0xFB14,0xFBD9,0x0481,0x07F0,0x0072,
	0xFBA6,0x0289,0x07CA,0x0296,0xFBBD,0xFDA6,0x05D7,0x05E4,
	0xFF50,0x003B,0x05AE,0x0449,0xFD00,0xFC94,0x0509,0x07DA,
	0xFDD2,0xF885,0x02CC,0x0C2A,0x0399,0xF971,0xFC14,0x031E,
	0x05B4,0xFF8D,0xFC7E,0x0475,0x066B,0xFFB0,0xFC5C,0xFE39,
	0x0194,0x04C0,0x02E1,0xFD62,0xFD07,0x0593,0x07FE,0xFF26,
	0xF5DA,0xFC07,0x08DE,0x097F,0x00AB,0xFBF5,0xFF75,0x028E,
	0xFED6,0xF9BA,0xFF04,0x07D2,0x054E,0xFB6F,0xFAFA,0x03B5,
	0x0620,0xFDCC,0xF94A,0x00F3,0x0729,0x041D,0xFC65,0xFAFC,
	0x01F0,0x05C0,0x0266,0x008B,0x02BF,0x02FB,0xFF53,0xFF56,
	0x0077,0xFE47,0xFF88,0x04D8,0x044D,0xFBAE,0xFA10,0x0381,
	0x070F,0xFDAF,0xF520,0xFBB2,0x077A,0x0584,0xFBE7,0xFA2D,
	0x007D,0x033F,0xFD14,0xF966,0x000C,0x0591,0x0298,0xFC89,
	0xFB73,0x005A,0x02FD,0x00BA,0xFF8E,0x01C9,0x04F3,0x02FB,
	0xFE93,0xFE81,0x017A,0x018E,0x01C8,0x037C,0x0295,0xFD8B,
	0xFEC7,0x03C8,0x0356,0xFE62,0xFE0F,0x031A,0x04AE,0x0062,
	0xFDE8,0x005C,0x011E,0xFD92,0xFEB9,0x0470,0x0395,0xFD4F,
	0xFCC9,0xFF63,0x01D7,0x017B,0xFE08,0xFFC9,0x037A,0x021E,
	0xFD56,0xFD6B,0x0086,0xFEE0,0xFB4F,0xFC8B,0x00F2,0x04BE,
	0x01B3,0xFB43,0xFC30,0x006D,0xFF5C,0xFB2D,0xFBA9,0x028D,
	0x050B,0xFE2C,0xF81C,0xFC32,0x0085,0xFD74,0xFB65,0xFD47,
	0xFFA4,0xFD0C,0xF6BB,0xF7C6,0x00A1,0x0243,0xFA7B,0xF711,
	0xFDCE,0x0264,0xFCFD,0xF637,0xF65C,0xFF3E,0x02F7,0xFC11,
	0xF609,0xFAEE,0x006B,0xFBC0,0xF804,0xFB95,0xFD7F,0xFC24,
	0xFCB1,0xFF53,0xFD48,0xF9AA,0xF9B2,0xFD51,0x014A,0xFEBB,
	0xFAC1,0xFB9C,0xFCA4,0xFBFA,0xFB64,0xFC94,0xFDEC,0xFFBF,
	0xFFB8,0xFB30,0xF8E6,0xFF3A,0x03D5,0xFDD8,0xF5CB,0xF759,
	0x016D,0x04F2,0xFD0E,0xF7EE,0xFE29,0x030D,0xFDF2,0xF96D,
	0xFDCD,0x0445,0x0226,0xFA92,0xF964,0x01AE,0x03DC,0xFD67,
	0xFA9C,0xFE29,0x0417,0x028A,0xFAD0,0xF845,0xFEDA,0x037D,
	0x00F8,0xFC8F,0xFD77,0x025A,0x042F,0xFDBE,0xF727,0xFAC9,
	0x03F4,0x0374,0xFAD1,0xFA12,0x02A2,0x042C,0xFB0D,0xF5B1,
	0xFD9D,0x053D,0x01B7,0xF89F,0xFAF4,0x03B2,0x0298,0xF7E7,
	0xF610,0x0359,0x0BAB,0x0157,0xF683,0xFBAB,0x0611,0x039B,
	0xF79B,0xF716,0x0548,0x0B4B,0x0049,0xF5DF,0xF94B,0x03D0,
	0x049B,0xFA1B,0xF80F,0x0388,0x0972,0x019E,0xF6ED,0xF9C6,
	0x0762,0x0A0A,0xFC98,0xF633,0x01F6,0x0862,0xFE5D,0xF4FB,
	0xF892,0x0322,0x0597,0xFD5B,0xF80E,0xFE3D,0x05C3,0xFFB0,
	0xF751,0xFAE7,0x02DF,0x0424,0xFD5C,0xF80D,0xFCFF,0x0525,
	0x012B,0xF6D5,0xFA2F,0x0570,0x0637,0xFAC4,0xF5E5,0xFF2E,
	0x05C3,0x0088,0xF7F9,0xFB09,0x062E,0x0704,0xFB69,0xF59B,
	0xFE8B,0x07B2,0x02F0,0xF945,0xFC6F,0x05D6,0x04F8,0xF992,
	0xF6F8,0x01E2,0x0838,0x01D8,0xF9BB,0xFCE5,0x03D2,0x029A,
	0xFAD6,0xF9B5,0x02FB,0x07BC,0xFF7A,0xF95B,0x00B9,0x0AF8,
	0x0712,0xFBC2,0xFB10,0x047D,0x0A92,0x04BE,0xFC81,0xFE50,
	0x05B9,0x0598,0xFEF3,0xFCCD,0x01CD,0x0617,0x0349,0xFE61,
	0x0045,0x04B2,0x02D6,0xFD12,0xFD6F,0x04EA,0x07E7,0xFFFC,
	0xF9A1,0xFFE0,0x07C2,0x0342,0xFAFE,0xFC85,0x03FB,0x0648,
	0x003C,0xFA56,0xFD18,0x032A,0x0323,0xFE15,0xFBC1,0x00CF,
	0x04FB,0xFF7D,0xFAE3,0xFE0C,0x01F2,0x01BD,0xFEA3,0xFE03,
	0x002C,0x01C0,0x0139,0xFEC3,0xFD22,0xFE99,0x005D,0xFF9B,
	0x0091,0x0132,0xFE34,0xFB0D,0xFF0B,0x027B,0x0101,0xFFDD,
	0xFD67,0xFE7D,0x01A2,0x00B6,0xFD75,0xFD46,0xFF58,0x004E,
	0xFE92,0xFCB6,0xFF39,0x026C,0xFFCB,0xFA96,0xFACE,0x00A3,
	0x031B,0xFF53,0xFD2E,0xFFB8,0x0111,0xFF5B,0xFE20,0xFE2A,
	0xFFC2,0x0046,0xFEC4,0xFEBA,0x006E,0xFF42,0xFBEF,0xFABB,
	0xFEE9,0x02C1,0x0126,0xFBED,0xFB0C,0xFF8F,0x0063,0xFCEB,
	0xFA19,0xFCE0,0x0274,0x0263,0xFCC8,0xFAA6,0xFE31,0x00FD,
	0xFECC,0xFB75,0xFD5D,0x021C,0x02A1,0xFD3F,0xF947,0xFC53,
	0x0082,0x00B4,0xFFC7,0x02AD,0x02E4,0x00DD,0xFF2B,0xFFE5,
	0x0127,0xFFDD,0xFF13,0x01BB,0x038D,0x0089,0xFC4E,0xFDF7,
	0x01FE,0x0283,0x0051,0x00E8,0x030C,0x0218,0xFD95,0xFC80,
	0x0019,0x017B,0xFECF,0xFED9,0x0194,0x0282,0xFF89,0xFBB4,
	0xFC81,0x004D,0x029B,0x0121,0xFEF9,0xFE4A,0xFF0F,0xFEB7,
	0xFD2E,0xFE3B,0x028C,0x04FC,0x00F6,0xFBF6,0xFD10,0x00B3,
	0xFF39,0xFBDB,0xFD7C,0x01E8,0x03D4,0x0132,0xFCD0,0xFD1B,
	0x00C0,0x0167,0xFEC2,0xFCE8,0xFF13,0x0289,0xFFEE,0xFAEC,
	0xFAED,0xFE7C,0xFFD3,0xFD5E,0xFC45,0xFEEC,0x00BD,0xFDEA,
	0xFAB2,0xFB79,0xFDF8,0xFE65,0xFD52,0xFDE3,0x003F,0x002D,
	0xFC4D,0xFA9D,0xFD2A,0xFFC9,0xFFBC,0xFDC1,0xFD1B,0xFE7E,
	0xFF32,0xFD40,0xFB47,0xFC1B,0xFE86,0xFF45,0xFD93,0xFD57,
	0xFE58,0xFE50,0xFBEF,0xFB40,0xFE14,0x0044,0xFF6D,0xFD88,
	0xFD0B,0xFD8F,0xFCFF,0xFC27,0xFD1E,0xFEE9,0xFF04,0xFCEF,
	0xFC04,0xFD49,0xFE53,0xFD75,0xFCD3,0xFDFA,0x0057,0x009C,
	0xFE7A,0xFCCE,0xFCD8,0xFD73,0xFDAD,0xFFF0,0xFF58,0x00E8,
	0xFFCA,0xFD1E,0xFC7A,0xFE54,0xFFFA,0xFFC2,0xFEC1,0xFE5F,
	0xFEDA,0xFE59,0xFD24,0xFCD7,0xFF1B,0x0016,0xFF9C,0xFE41,
	0xFDBC,0xFCA3,0xFBD3,0xFC2B,0xFCE6,0xFE0F,0xFDF0,0xFCC7,
	0xFB4D,0xFADA,0xFA9E,0xF9E7,0xF91C,0xF889,0xF86D,0xF782,
	0xF673,0xF57B,0xF4E3,0xF41F,0xF39A,0xF3FB,0xF54A,0xF5E7,
	0xF4BF,0xF283,0xF130,0xF172,0xF271,0xF2E9,0xF2F2,0xF2CA,
	0xF302,0xF2AF,0xF2B4,0xF22B,0xF215,0xF19A,0xF12D,0xF0C6,
	0xF090,0xF020,0xEFA0,0xEEEC,0xEDFB,0xEC63,0xEC4F,0xEC17,
	0xEBD2,0xEBE1,0xEB56,0xEB18,0xEAA0,0xEA33,0xE9E1,0xE995,
	0xE8D4,0xE8EC,0xE94E,0xE90B,0xE8EB,0xE8C6,0xE952,0xE912,
	0xE814,0xE893,0xE8FC,0xE89C,0xE84A,0xE808,0xE850,0xE85B,
	0xE8A4,0xE8CA,0xE8E3,0xE937,0xE97F,0xE970,0xE921,0xE929,
	0xE94D,0xE98D,0xE9EE,0xEA17,0xEA5B,0xEA84,0xEA83,0xEADB,
	0xEC64,0xEC95,0xEC39,0xEC0D,0xEC3E,0xECE2,0xED0A,0xED9A,
	0xEE05,0xEEE7,0xEF9E,0xF05C,0xF159,0xF1EB,0xF2A5,0xF372,
	0xF366,0xF36A,0xF41B,0xF492,0xF503,0xF5DD,0xF622,0xF6BE,
	0xF6DC,0xF774,0xF827,0xF8BD,0xF8F9,0xF906,0xF9B3,0xFA24,
	0xFA69,0xFAC3,0xFB60,0xFBCE,0xFC13,0xFC3C,0xFC9A,0xFCDA,
	0xFD07,0xFD4A,0xFDDE,0xFE22,0xFE1F,0xFE95,0xFEF7,0xFF7F,
	0xFFD9,0xFFD2,0xFFF4,0xFFF9,0x0083,0x00E1,0x0150,0x016D,
	0x01B7,0x01FA,0x028B,0x02F7,0x0339,0x0389,0x039C,0x042E,
	0x04CB,0x0507,0x054A,0x0549,0x0588,0x0628,0x0681,0x0719,
	0x0788,0x07D4,0x077C,0x082B,0x08D0,0x075B,0x0956,0x0A10,
	0x091D,0x0973,0x09E3,0x0A15,0x0A91,0x0AAB,0x0ABF,0x0AEE,
	0x0B14,0x0B09,0x0BB4,0x0BEB,0x0BEC,0x0BDD,0x0C15,0x0C54,
	0x0C7C,0x0CBB,0x0C74,0x0C65,0x0C7C,0x0CB8,0x0CC1,0x0CBD,
	0x0C95,0x0C87,0x0C86,0x0C9B,0x0CC0,0x0CDE,0x0C59,0x0C3D,
	0x0C92,0x0D08,0x0D00,0x0CF6,0x0D2B,0x0D42,0x0D7C,0x0D77,
	0x0D5B,0x0D57,0x0D5F,0x0D63,0x0D63,0x0E22,0x0E7C,0x0E8A,
	0x0E60,0x0E21,0x0E72,0x0E7C,0x0EB2,0x0ED4,0x0EA8,0x0ED2,
	0x0E9C,0x0E8B,0x0FD1,0x1136,0x105A,0x1053,0x0FF5,0x0FC7,
	0x0F95,0x0F99,0x0F4D,0x0F1F,0x0EF5,0x0EDF,0x0EAB,0x0E74,
	0x0E7F,0x0E4D,0x0E1C,0x0DB5,0x0D85,0x0DA7,0x0D34,0x0DD0,
	0x0DBF,0x0CE6,0x0C2E,0x0C66,0x0C7A,0x0CAA,0x0CD9,0x0CD9,
	0x0C47,0x0C5E,0x0C73,0x0C8A,0x0C74,0x0C6E,0x0C69,0x0C40,
	0x0C20,0x0BD3,0x0B79,0x0B28,0x0AF2,0x0AB2,0x0B69,0x0AFE,
	0x0965,0x09FE,0x0AB3,0x0A6B,0x0A3A,0x0A44,0x0A03,0x0A56,
	0x0A0B,0x09B3,0x0906,0x086B,0x07C3,0x07DC,0x0788,0x0718,
	0x070F,0x06FB,0x06EB,0x067D,0x064C,0x0685,0x06BC,0x0685,
	0x0701,0x0704,0x06D2,0x06C1,0x06DD,0x06AD,0x06F0,0x06D2,
	0x0699,0x0664,0x06B4,0x06BD,0x064C,0x065F,0x061B,0x0654,
	0x067E,0x06BD,0x0679,0x062C,0x0633,0x061C,0x05AE,0x0588,
	0x05BC,0x061A,0x05D4,0x0568,0x0512,0x04F6,0x04E1,0x049A,
	0x0468,0x04AC,0x04D2,0x04AC,0x0474,0x041F,0x044B,0x0468,
	0x048C,0x046D,0x0477,0x0406,0x03BF,0x040E,0x04D0,0x0511,
	0x053F,0x050C,0x04F6,0x043D,0x05D6,0x0506,0x03F1,0x051B,
	0x04DF,0x04F3,0x04BC,0x04DC,0x044C,0x0491,0x03FE,0x03BC,
	0x0403,0x0434,0x03FA,0x0374,0x03DC,0x03F6,0x0397,0x0380,
	0x0391,0x039E,0x03D8,0x039C,0x0359,0x0321,0x0348,0x0331,
	0x031F,0x0329,0x033B,0x0333,0x030D,0x0340,0x0314,0x02E3,
	0x02D0,0x02B0,0x02A7,0x02F2,0x02F0,0x030E,0x032C,0x0361,
	0x032C,0x0335,0x033C,0x0350,0x0367,0x0330,0x034C,0x0356,
	0x02C8,0x02F4,0x0365,0x034D,0x0345,0x0301,0x0355,0x033C,
	0x02E7,0x02D0,0x02C1,0x0279,0x00B4,0xFF8E,0xFF1C,0xFFC5,
	0xFFF6,0xFFAA,0xFFB6,0xFFCE,0xFFAC,0x00B4,0x01D8,0x0243,
	0x032D,0x03FD,0x03E4,0x023C,0x00DB,0x0197,0x04A2,0x0711,
	0x0748,0x0763,0x07EB,0x0768,0x05AF,0x0531,0x05FF,0x04B5,
	0x03DD,0x03CE,0x0414,0x0442,0x03EA,0x032D,0x0305,0x03D7,
	0x04EC,0x0575,0x0642,0x078C,0x08D0,0x08D7,0x07B9,0x0887,
	0x0ACB,0x0C9F,0x0CCE,0x0BC3,0x0B46,0x0BD9,0x0C62,0x0D47,
	0x0F8A,0x124C,0x143A,0x13D4,0x129A,0x1154,0x1126,0x1212,
	0x1454,0x170C,0x18D2,0x18FE,0x16A0,0x1575,0x170C,0x190B,
	0x1A3F,0x199A,0x1837,0x178A,0x17A1,0x18A3,0x192D,0x190C,
	0x186B,0x1833,0x17D1,0x1798,0x16D4,0x166B,0x1769,0x184A,
	0x1845,0x1691,0x145A,0x1301,0x133E,0x1569,0x17F5,0x190E,
	0x17B9,0x14E9,0x117F,0x1061,0x121E,0x14E5,0x15F1,0x14CB,
	0x1267,0x11A7,0x1093,0x107C,0x139C,0x1294,0x103F,0x0DAC,
	0x0A6B,0x088F,0x08CF,0x0BDC,0x0FBB,0x1244,0x11A1,0x0DF3,
	0x092A,0x04DE,0x03E6,0x072C,0x0BE6,0x0E79,0x0D96,0x0B45,
	0x0954,0x085C,0x0829,0x08D2,0x0A1E,0x0AF2,0x0A4C,0x08D9,
	0x07DB,0x08BB,0x0A89,0x0C51,0x0D0B,0x0BC7,0x0879,0x04EF,
	0x03FF,0x05CC,0x089C,0x09EB,0x09E3,0x088F,0x06BC,0x04D0,
	0x02EA,0x01A5,0x0160,0x019E,0x020F,0x0214,0x01BF,0x0123,
	0xFF7A,0xFDBA,0xFC86,0xFC24,0xFBB5,0xFB42,0xFA7C,0xFA3F,
	0xFC41,0xFC84,0xFBB8,0xFB0A,0xF9D8,0xF857,0xF67E,0xF60A,
	0xF672,0xF682,0xF6F5,0xF642,0xF597,0xF554,0xF534,0xF571,
	0xF55A,0xF47E,0xF3E0,0xF2EA,0xF2A6,0xF3F3,0xF439,0xF515,
	0xF6F2,0xF75C,0xF5D2,0xF424,0xF29A,0xF217,0xF309,0xF539,
	0xF73D,0xF77B,0xF57C,0xF3CC,0xF404,0xF548,0xF5E9,0xF4D5,
	0xF3A1,0xF3A7,0xF413,0xF4EC,0xF4C1,0xF2D2,0xF250,0xF366,
	0xF41E,0xF4E9,0xF4CA,0xF28E,0xF09C,0xF09A,0xF219,0xF2BF,
	0xF1A2,0xEFF7,0xEE50,0xED16,0xECED,0xEDA9,0xED47,0xEB36,
	0xEA8F,0xED01,0xF0C1,0xF26A,0xF0EE,0xEDA4,0xEA90,0xE754,
	0xE663,0xEA03,0xF173,0xF635,0xF463,0xEEAA,0xE9AF,0xE94D,
	0xECCE,0xF25F,0xF570,0xF2A3,0xEB41,0xE56B,0xE7C5,0xF1F0,
	0xFA74,0xFAA7,0xF44C,0xED04,0xE9D2,0xEAFD,0xEF29,0xF453,
	0xF5A3,0xF2CD,0xF019,0xF14C,0xF43D,0xF431,0xEF84,0xECA6,
	0xF0F7,0xF804,0xF821,0xF17A,0xEA8D,0xE98F,0xEE13,0xF46A,
	0xF8AD,0xF7F5,0xF249,0xEC7A,0xE987,0xEB60,0xF046,0xF41F,
	0xF4B3,0xF45F,0xF471,0xEEF8,0xEB04,0xEA79,0xEFD7,0xF6FD,
	0xFA2B,0xF71B,0xF167,0xEBE3,0xEA05,0xECEF,0xF164,0xF5F8,
	0xF845,0xF66B,0xF0C2,0xED43,0xEDD4,0xEF12,0xF05D,0xF1CC,
	0xF324,0xF54A,0xF6E6,0xF511,0xEFB4,0xEB76,0xEE80,0xF4C2,
	0xF846,0xF759,0xF39D,0xF048,0xF113,0xF548,0xF8AD,0xF767,
	0xF3EE,0xF20D,0xF2FA,0xF512,0xF5DF,0xF46B,0xF2EE,0xF39C,
	0xF70F,0xF8DB,0xF77C,0xF5F4,0xF53B,0xF563,0xF6B1,0xF84C,
	0xF730,0xF39A,0xF17C,0xF450,0xFAC7,0xFE71,0xFBD5,0xF458,
	0xECF9,0xE893,0xE71F,0xE8F6,0xEAC7,0xEC2A,0xEDCD,0xEF3F,
	0xF053,0xEF53,0xEC38,0xE865,0xE6ED,0xE965,0xECAD,0xEE59,
	0xEE74,0xF040,0xF3ED,0xF867,0xF919,0xF673,0xF428,0xF2EC,
	0xF3AC,0xF74B,0xFCF1,0x010F,0x0264,0x0246,0x02D9,0x045B,
	0x0517,0x02D9,0x0075,0x006F,0x03BA,0x084D,0x0BF4,0x0D1F,
	0x0BC1,0x096D,0x072C,0x065E,0x0608,0x06C4,0x0514,0x0304,
	0x0402,0x068C,0x0813,0x0600,0x027F,0xFF0F,0xFDAE,0xFDA1,
	0xFD92,0xFCC2,0xFC3D,0xFCBE,0xFE1C,0xFDC7,0xFC9A,0xFB3F,
	0xF8FD,0xF63B,0xF52F,0xF628,0xF72E,0xF78E,0xF796,0xF868,
	0xFAB5,0xFBC8,0xF9E9,0xF742,0xF533,0xF565,0xF7DE,0xFB29,
	0xFDD8,0xFEDD,0xFE37,0xFDBC,0xFE14,0xFEF0,0xFF59,0xFEBB,
	0xFE62,0xFF29,0x01DE,0x0490,0x0566,0x0487,0x0388,0x0380,
	0x03F8,0x04CC,0x052D,0x0512,0x04A1,0x03CF,0x043F,0x063F,
	0x08DF,0x0877,0x0585,0x0205,0x0080,0x00DF,0x01F4,0x02A7,
	0x038E,0x0385,0x021B,0xFFDA,0xFE13,0xFD6B,0xFC7F,0xFBE3,
	0xFCFF,0xFC20,0xF8DE,0xFA59,0xFE43,0x00A5,0x010A,0xFDF6,
	0xF915,0xF47B,0xF25D,0xF4F0,0xFAEA,0x0060,0x014F,0xFE1C,
	0xFB38,0xFC03,0x005A,0x036E,0x00CE,0xF88B,0xEFAA,0xEF48,
	0xFB36,0x0C4B,0x15B2,0x0FF0,0x0028,0xF1BB,0xEF00,0xF75C,
	0x0183,0x05C2,0x0663,0x088B,0x0BAA,0x0AAD,0x048E,0xFBA3,
	0xF59B,0xF767,0x0063,0x09EC,0x0D2A,0x0935,0x02E6,0xFEEE,
	0x0092,0x05E7,0x08E6,0x0451,0xFAEE,0xF36E,0xF2CC,0xFADA,
	0x07CA,0x1116,0x11D8,0x0A7B,0xFFE6,0xF66D,0xEEFC,0xEC5E,
	0xF23F,0x000D,0x1161,0x18B6,0x108E,0x00FF,0xF552,0xF323,
	0xF84E,0xFCD8,0xFCAB,0xFA16,0xFB6E,0x01D1,0x07CE,0x08C2,
	0x067A,0x022B,0xFCBD,0xF5F9,0xF34F,0xF482,0xF9B6,0x0246,
	0x0C34,0x10C3,0x0DA5,0x045C,0xF90F,0xF2AA,0xF4F1,0xFD11,
	0x064F,0x0B44,0x088F,0x017F,0xFCB8,0xFDD5,0x0229,0x0696,
	0x07FB,0x0496,0xFC12,0xF5EE,0xF625,0x00AC,0x0CFE,0x0E8F,
	0x0611,0xFC59,0xF77F,0xF91E,0xFF0F,0x0741,0x09C2,0x02F2,
	0xF7D2,0xF25A,0xF612,0xFD0B,0xFEE3,0xFA3C,0xF318,0xEE33,
	0xEC4C,0xEDA8,0xF224,0xF815,0xFBBA,0xFADA,0xF682,0xF20D,
	0xEF14,0xED78,0xEF07,0xF587,0xFE37,0x0358,0x01FE,0xFCEC,
	0xF983,0xFAF2,0xFF24,0x022C,0x03C3,0x03E2,0x033B,0x0357,
	0x05AC,0x0980,0x0C5C,0x0CD9,0x0B95,0x09EA,0x099B,0x09D5,
	0x09E6,0x0B89,0x0E3F,0x10D2,0x10E4,0x0EA2,0x0BB2,0x090E,
	0x07D6,0x0899,0x0A92,0x0AF4,0x0899,0x0534,0x032A,0x044D,
	0x0649,0x063D,0x03AB,0x002E,0xFD19,0xFB90,0xFBA8,0xFD54,
	0xFE2E,0xFFD1,0xFD61,0xF9D3,0xF95C,0xF771,0xF5FA,0xF581,
	0xF75F,0xFA55,0xFC15,0xFB18,0xF880,0xF6C4,0xF6F8,0xF8B8,
	0xFB27,0xFC7D,0xFC83,0xFB82,0xFB65,0xFC34,0xFDFF,0x001A,
	0x017F,0x025C,0x02DE,0x0232,0x0067,0xFF59,0x014A,0x053B,
	0x087B,0x0959,0x06EF,0x043D,0x030F,0x04B4,0x070B,0x0872,
	0x0800,0x06A5,0x05D0,0x05B7,0x061A,0x05F7,0x04E0,0x045D,
	0x04E7,0x049D,0x02BA,0x00D6,0xFFDB,0x00DD,0x01D5,0x01AF,
	0x00A5,0xFF30,0xFD3A,0xFB1D,0xFB09,0xFCF0,0xFCFF,0xFA62,
	0xFA3A,0xFD97,0x00E7,0xFFCC,0xF88B,0xF09E,0xECA7,0xF120,
	0xFC8C,0x071C,0x0A4E,0x04FE,0xFA52,0xEFF7,0xED05,0xF511,
	0x0279,0x0A21,0x05FA,0xFCE0,0xF7FD,0xFB1E,0x02A1,0x099D,
	0x0CD6,0x0933,0xFE74,0xF237,0xF03D,0xFD94,0x1053,0x1B04,
	0x17DC,0x0A50,0xFB5B,0xF299,0xF3AF,0xFE37,0x0B25,0x1260,
	0x0FB8,0x076F,0xFFBF,0xFC75,0xFEB0,0x0009,0x00A9,0x00E6,
	0x03F9,0x062D,0x01FC,0xFB4C,0xFA2A,0x00F7,0x0983,0x0A75,
	0x0070,0xF2BA,0xEDC5,0xF6E8,0x0758,0x131A,0x111B,0x0219,
	0xF1E1,0xED40,0xF75A,0x0596,0x09DC,0x013E,0xF817,0xFA44,
	0x0370,0x0736,0x01CD,0xF94B,0xF7F0,0x004B,0x0AAF,0x0B34,
	0xFFA6,0xF2AC,0xF1A4,0xFD9A,0x0CED,0x1412,0x0E95,0x0158,
	0xF5C3,0xF258,0xF9E8,0x05D3,0x0C5F,0x0C97,0x0A69,0x0771,
	0xFFF9,0xF74B,0xF6AC,0xFF1D,0x0811,0x0B81,0x0A1E,0x05CF,
	0xFE5B,0xF7C8,0xFA07,0x0512,0x0DFE,0x0957,0xFA4D,0xF0C1,
	0xF5B6,0x0239,0x0C47,0x0DCC,0x06D6,0xFC0E,0xF2A2,0xF0BA,
	0xF618,0xF8EA,0xF7A7,0xF619,0xF508,0xF966,0xFD81,0xFB19,
	0xF5A1,0xF22F,0xF32D,0xF5B5,0xF6A8,0xF47A,0xF2CF,0xF528,
	0xFC06,0x03F6,0x0773,0x0392,0xFAAC,0xF525,0xF7B5,0xFFDD,
	0x0715,0x0A08,0x09A0,0x08E6,0x098F,0x0AB0,0x0B34,0x0A7A,
	0x096B,0x09B2,0x0BA2,0x0DE8,0x0E82,0x0E05,0x0E05,0x0FAC,
	0x11F2,0x11AB,0x0CC0,0x0630,0x026F,0x044D,0x08FC,0x0D23,
	0x0DE1,0x0B00,0x06AF,0x0320,0x00AD,0xFF39,0xFD51,0xFC69,
	0xFDC4,0xFFC0,0x00AC,0xFF62,0xFC3E,0xF9B9,0xF877,0xFAB4,
	0xFB67,0xFA32,0xF860,0xF777,0xF827,0xFA6D,0xFCCB,0xFDE4,
	0xFC92,0xFA56,0xF7CE,0xF665,0xF631,0xF89A,0xFC5A,0xFF72,
	0x0125,0x0195,0xFFE8,0xFE39,0xFE76,0xFEFB,0xFFDA,0x0198,
	0x02BC,0x0371,0x050E,0x06AE,0x079C,0x06D3,0x0590,0x04FC,
	0x0474,0x0382,0x03D9,0x0534,0x06E0,0x0845,0x08A6,0x0784,
	0x04F4,0x02A6,0x0246,0x02A5,0x00D1,0x0076,0x014A,0x01DF,
	0x01F3,0x0190,0x013E,0x0057,0xFE45,0xFB1E,0xF8F7,0xF96E,
	0xFA4C,0xF8E5,0xF79D,0xFA77,0x009F,0x0237,0xFC69,0xF2DB,
	0xEB5B,0xEB7E,0xF201,0xF925,0xFF1A,0x009D,0xFE66,0xFBE9,
	0xFAEB,0xF994,0xF593,0xF19B,0xF146,0xF5E8,0xFDE8,0x03EE,
	0x04B9,0x0102,0xFE4A,0xFE98,0xFF51,0xFE83,0xFCE5,0xFA6A,
	0xF7C7,0xF95F,0x0205,0x0CF3,0x1116,0x0A41,0xFDBE,0xF40E,
	0xF259,0xF8C3,0x0033,0x043E,0x0589,0x05BD,0x0550,0x0294,
	0xFD5C,0xF9F6,0xF981,0xFB35,0xFF25,0x03FF,0x03F4,0xFBF5,
	0xF302,0xF253,0xFC5E,0x072C,0x07A7,0xFDF9,0xF178,0xEBA7,
	0xF39A,0x02E0,0x09A8,0x07EC,0xFCAD,0xEF83,0xEA4F,0xF205,
	0x000B,0x0A02,0x0A07,0x0005,0xF39F,0xEF57,0xF654,0x00C9,
	0x0625,0x0483,0x001D,0xFCDF,0xFD85,0x00DA,0x0335,0x01DC,
	0xFE76,0xFC79,0xFC53,0xFC3F,0xFE10,0x0327,0x0888,0x0BD1,
	0x0A89,0x0398,0xF915,0xF26C,0xF489,0xFF22,0x0D9B,0x16C4,
	0x11CF,0x0136,0xF361,0xF31E,0xFE7E,0x0930,0x0B81,0x05D3,
	0xFD21,0xF79B,0xF948,0x0108,0x07E1,0x0A73,0x08FA,0x0398,
	0xFC76,0xF66E,0xF436,0xF63D,0xFB03,0xFF97,0xFFFC,0xFAD7,
	0xF1E3,0xEC48,0xEFEF,0xF812,0xFDF6,0xFC61,0xF595,0xEFA4,
	0xEEA9,0xF221,0xF8E9,0xFEFA,0x01FF,0x014B,0xFE37,0xFB68,
	0xFB52,0xFD72,0x0083,0x0457,0x082B,0x0BAA,0x0BC6,0x08C0,
	0x0640,0x0757,0x0B2D,0x0FA6,0x11E3,0x1155,0x0E9A,0x0BF0,
	0x0C27,0x0FBD,0x1357,0x14A8,0x129E,0x0F07,0x0BD3,0x0A14,
	0x0A7D,0x0CD9,0x0F62,0x1069,0x0D36,0x0958,0x05EC,0x0391,
	0x027B,0x02D7,0x0408,0x053E,0x03FA,0x00B8,0xFD74,0xFC00,
	0xFCFE,0xFF2E,0x001E,0x0012,0xFD7A,0xFA4D,0xF79D,0xF761,
	0xF9E4,0xFD4E,0xFEA6,0xFD89,0xFB52,0xF94E,0xF8B4,0xF9C6,
	0xFBF3,0xFECD,0x00AB,0x00A4,0xFEB8,0xFCD7,0xFD5B,0xFFDC,
	0x036A,0x0574,0x0561,0x0402,0x0300,0x02A2,0x038B,0x05AE,
	0x0732,0x0801,0x0730,0x06D2,0x0762,0x07B2,0x06F4,0x05FF,
	0x0610,0x073F,0x07B7,0x0720,0x0535,0x0385,0x030A,0x0341,
	0x0473,0x050E,0x047F,0x02B5,0x0065,0xFFA3,0x0009,0x0092,
	0xFF3E,0xFD7F,0xFD29,0xFBF9,0xFA35,0xF9C4,0xFC18,0xFFAE,
	0x01C7,0xFF05,0xFA40,0xF26D,0xEE82,0xF30E,0xFBCC,0x027C,
	0x01FD,0xFC27,0xF865,0xF91E,0xFB0E,0xF906,0xF71C,0xF9D9,
	0xFE31,0x00EF,0x015D,0x0086,0xFDAE,0xFBA2,0xFC1A,0x0090,
	0x057E,0x075E,0x03ED,0xFDD4,0xF899,0xF8D0,0x0063,0x09DC,
	0x0F31,0x0E0A,0x0519,0xF985,0xF252,0xF4AE,0xFD33,0x060E,
	0x0CD0,0x0FC5,0x0B30,0xFE9A,0xF254,0xF02F,0xF9A4,0x0590,
	0x0A91,0x065C,0xFE28,0xF7C5,0xF4F6,0xF7E4,0x006F,0x0883,
	0x08CD,0xFEF8,0xF178,0xEA8D,0xEEE7,0xFBDF,0x0CEE,0x16D3,
	0x0EFC,0xFAD4,0xEA7B,0xE84C,0xF3A4,0x0202,0x0AC5,0x0A01,
	0x03E6,0xFD8A,0xFA43,0xFB41,0xFED3,0x02E5,0x049F,0x0191,
	0xFC78,0xF9FB,0xFB2D,0xFFD5,0x0633,0x0C01,0x0D38,0x0592,
	0xF9BF,0xF4AC,0xF9A5,0x02FA,0x0839,0x0577,0xFFC8,0xFE7E,
	0x02B1,0x0746,0x074A,0x00E9,0xF969,0xF517,0xF63B,0xFD73,
	0x069D,0x0BB1,0x081A,0x0157,0xFC3A,0xF99D,0xF816,0xF758,
	0xFA06,0xFEF0,0x01CA,0x00DA,0x0044,0x0093,0xFE30,0xF5F9,
	0xEC46,0xE680,0xE634,0xEB37,0xF30B,0xFB6F,0x00C6,0xFF52,
	0xF747,0xEE73,0xEA32,0xEAA1,0xED2E,0xF0B0,0xF625,0xFC96,
	0x0139,0x01C7,0xFFB5,0xFD5E,0xFBCD,0xFB14,0xFA50,0xFB29,
	0xFEB4,0x03CE,0x08B8,0x0CBD,0x0ECD,0x0EE7,0x0B83,0x05B5,
	0x022F,0x031C,0x05E6,0x09A4,0x0D23,0x0FDD,0x10DC,0x0F16,
	0x0BDC,0x0987,0x0725,0x049D,0x0227,0x0168,0x03BC,0x06EB,
	0x0838,0x06FC,0x049D,0x01C4,0xFF47,0xFB74,0xF83E,0xF716,
	0xF7CD,0xF97C,0xFBE3,0xFD66,0xFDC7,0xFACA,0xF676,0xF334,
	0xF559,0xF539,0xF446,0xF5B8,0xF67B,0xF8A0,0xFA12,0xFA1F,
	0xF9C3,0xF91E,0xF7E6,0xF784,0xF787,0xF9D7,0xFB7E,0xFC98,
	0xFE8B,0x0137,0x02FD,0x02A5,0x006F,0xFD8A,0xFD1C,0xFF0C,
	0x029F,0x057E,0x071D,0x0753,0x06FC,0x0675,0x0569,0x03D2,
	0x0296,0x0295,0x0351,0x0570,0x07B8,0x0858,0x06FD,0x0556,
	0x044F,0x0405,0x034E,0x0136,0xFF79,0xFFB3,0x01B5,0x03CC,
	0x03BE,0x017E,0xFDFB,0xFC0B,0xFD3F,0xFDE9,0xFC83,0xF9C4,
	0xF83E,0xF8DA,0xFCDA,0x01F9,0x0423,0xFFA8,0xF675,0xEE10,
	0xEAD7,0xF186,0xFF06,0x08F3,0x08AB,0x0071,0xF6E5,0xEFB8,
	0xEE25,0xF39D,0xFD1E,0x0459,0x05FE,0x0495,0x0158,0xFB6A,
	0xF650,0xF7E5,0xFFC9,0x07DA,0x0BB6,0x0909,0x01B0,0xFA4F,
	0xF63B,0xF804,0x005C,0x0B97,0x11A3,0x0DEF,0x0427,0xFCFA,
	0xFC26,0xFD7A,0xFF46,0x02B6,0x066E,0x08A2,0x090A,0x06FD,
	0x01F6,0xFB2B,0xF6AC,0xFB59,0x0631,0x0CD4,0x0992,0xFD08,
	0xF1CF,0xF163,0xF8E0,0x00EC,0x064D,0x0760,0x0397,0xFBBB,
	0xF66B,0xF90D,0xFF77,0x0211,0xFF25,0xFA46,0xF7B9,0xF841,
	0xFAF6,0x011A,0x0915,0x0CF0,0x07E3,0xF9D3,0xEC18,0xE921,
	0xF3FC,0x0399,0x0DE9,0x0FEE,0x0C8A,0x04F0,0xF9A0,0xF0B6,
	0xF058,0xFA52,0x076D,0x0E54,0x0B9E,0x040F,0xFDD9,0xFD7C,
	0x0280,0x07E1,0x083F,0xFFDE,0xF348,0xEFB5,0xFCF2,0x1087,
	0x182E,0x1024,0x0171,0xF75A,0xF59E,0xFA8E,0xFF21,0xFF92,
	0xFEFC,0x00B5,0x056A,0x09CD,0x07A4,0xFE60,0xF655,0xF781,
	0xFE3D,0x01D2,0xFAF9,0xEF5F,0xE875,0xEC21,0xF81F,0x038B,
	0x040E,0xFBEC,0xF16D,0xE8AA,0xEA0B,0xF148,0xF6CB,0xF860,
	0xF8FA,0xFBC1,0xFE6C,0xFE1A,0xF9AC,0xF58F,0xF63A,0xFB99,
	0x01C0,0x0473,0x035B,0x00D9,0x0196,0x0656,0x0BFD,0x0E92,
	0x0BCB,0x05E0,0x0350,0x0613,0x0C48,0x1126,0x11D7,0x10EF,
	0x102B,0x0F6A,0x0D76,0x0AA3,0x082C,0x079D,0x08B6,0x0B4C,
	0x0D6C,0x0CAC,0x08D2,0x04B7,0x02D7,0x0432,0x0529,0x02B9,
	0xFDF5,0xFA98,0xFA9D,0xFDAB,0x00CE,0x01C4,0xFEA1,0xF9FF,
	0xF5E2,0xF443,0xF53B,0xF6E6,0xF7CF,0xF8E4,0xFC17,0xFD33,
	0xFBE5,0xF8E9,0xF678,0xF681,0xF911,0xFB85,0xFBF2,0xFBA0,
	0xFAEB,0xFB01,0xFD26,0x0084,0x02DB,0x0276,0xFF78,0xFC96,
	0xFCE8,0x0042,0x04D2,0x06E7,0x05CA,0x04A9,0x051F,0x058D,
	0x055B,0x0508,0x0459,0x042E,0x0573,0x079D,0x0911,0x07B8,
	0x04A0,0x02E9,0x0378,0x04F0,0x0490,0x02D1,0x014A,0x0091,
	0x008D,0x0150,0x01FF,0x00D0,0xFFBC,0xFF49,0xFD9B,0xFC19,
	0xFBA0,0xFA7F,0xF868,0xF861,0xFC7E,0x01A1,0xFFBA,0xF840,
	0xF164,0xEEE9,0xF1C4,0xF965,0xFF80,0xFF6F,0xFA45,0xF3BC,
	0xF1EE,0xF7F2,0xFF78,0x0098,0xFA85,0xF3F9,0xF316,0xF77A,
	0xFD52,0x033A,0x083E,0x0804,0x0114,0xF822,0xF4E7,0xF81B,
	0xFD92,0x015C,0x0484,0x07AD,0x06F4,0x00F1,0xF968,0xF8FC,
	0x0113,0x0901,0x0A1B,0x04EE,0xFD49,0xF878,0xF6CF,0xF95C,
	0x0076,0x099D,0x0EC5,0x0BBD,0x0017,0xF27B,0xEBDF,0xF0C8,
	0xFBAE,0x05D3,0x099F,0x05A5,0xFCCB,0xF4CC,0xF281,0xF3D3,
	0xF683,0xFA41,0xFEC5,0x0240,0x01E6,0xFE1D,0xF8B0,0xF817,
	0xFAE3,0xF95E,0xF6E9,0xF496,0xF8BE,0x004C,0x042E,0x02DF,
	0x00D0,0xFFF1,0xFEBA,0xFB18,0xF4D9,0xF236,0xF768,0x02E0,
	0x0BC6,0x0C03,0x058F,0xFF0C,0xFB64,0xF955,0xFBF6,0x0178,
	0x039D,0x00B3,0xFE91,0x025B,0x091A,0x0968,0x023B,0xFB70,
	0xF9C6,0xFADD,0xFD9D,0x01FB,0x0842,0x0C17,0x0764,0xFDA4,
	0xF875,0xFBE5,0x00FE,0x0045,0xFC3C,0xFE4E,0x0444,0x062C,
	0x0250,0xFDF6,0xFD02,0xFC82,0xF995,0xF674,0xF614,0xF588,
	0xF23F,0xF075,0xF43B,0xFB85,0xFF62,0xFAEC,0xF356,0xEE32,
	0xEBF6,0xEDAA,0xF035,0xF4A8,0xFA0D,0xFCDF,0xFC6B,0xFAAC,
	0xF964,0xF928,0xF962,0xFBBA,0xFFD4,0x0290,0x02DA,0x0146,
	0x02AE,0x0789,0x0B9B,0x0C0B,0x0A33,0x0775,0x0584,0x05D6,
	0x08DC,0x0DD1,0x116F,0x123D,0x10A4,0x0EC7,0x0C86,0x0A17,
	0x083A,0x07E2,0x0961,0x0B81,0x0C81,0x0B98,0x0A0E,0x06B4,
	0x037B,0x01BE,0x019F,0x038D,0x0263,0xFFAB,0xFE5C,0xFE1E,
	0xFEAA,0xFE7B,0xFCBA,0xFADD,0xF9C3,0xF920,0xF91F,0xF835,
	0xF7AB,0xF8EA,0xFB0F,0xFBFF,0xFC0C,0xFB5E,0xF99F,0xF7B3,
	0xF77A,0xF893,0xFADC,0xFC43,0xFD19,0xFD4C,0xFE6F,0xFFC6,
	0x0015,0xFF91,0xFED4,0xFEB1,0x0003,0x0251,0x046A,0x0512,
	0x04F5,0x05D5,0x071A,0x06CA,0x063E,0x0642,0x05F6,0x05F9,
	0x0661,0x06E7,0x07F0,0x07DF,0x0722,0x0610,0x0552,0x052F,
	0x0475,0x0313,0x0201,0x01A5,0x022E,0x02D4,0x02E0,0x021F,
	0x0134,0xFF95,0xFD04,0xFAFE,0xFB19,0xFBEC,0xFC45,0xFBB0,
	0xFBF7,0xFD5A,0xFE8C,0xFCC5,0xF831,0xF41C,0xF532,0xF8B5,
	0xF9A4,0xFBCB,0xFAC5,0xFAA5,0xFC23,0xFCDA,0xFCE1,0xFB78,
	0xF906,0xF781,0xF7EF,0xFB74,0xFFAB,0x025E,0x01B4,0xFFBF,
	0xFF59,0xFFC5,0xFFA3,0xFE6D,0xFD93,0xFDAC,0xFF6D,0x02B3,
	0x06A7,0x0829,0x0736,0x05F3,0x03B9,0x005A,0xFC9A,0xFB2A,
	0xFCE2,0x01E9,0x07C5,0x0BB7,0x0B3D,0x045B,0xFA94,0xF524,
	0xF805,0xFF4D,0x0379,0x02C5,0x0047,0xFF47,0xFF07,0xFE1E,
	0xFD26,0xFCB7,0xFC3B,0xFC3A,0xFCB7,0xFD2A,0xFC72,0xF997,
	0xF7F0,0xF9C3,0xFE93,0x0327,0x0396,0x0007,0xF9F3,0xF42C,
	0xF596,0xFCAD,0x04F2,0x089D,0x07EB,0x03B7,0xFCD1,0xF6E3,
	0xF4F9,0xF8F3,0x0210,0x0B0A,0x0CD7,0x0696,0xFD15,0xF5FF,
	0xF59D,0xFC82,0x06E0,0x0C96,0x094A,0x0037,0xF88A,0xF7AB,
	0xFE88,0x06FB,0x0BCB,0x0A21,0x0337,0xFC04,0xF8F4,0xFA55,
	0xFE9D,0x034C,0x05DD,0x0599,0x0267,0xFEFE,0xFCD9,0xFBD4,
	0xFD08,0xFF4F,0xFF9F,0xFDA7,0xFD9E,0xFD6C,0xFD74,0xFDF3,
	0xFE3A,0xFD0A,0xFA27,0xF5B7,0xF33F,0xF3FA,0xF771,0xFBA0,
	0xFEC5,0xFE2C,0xFB22,0xF714,0xF39B,0xF37D,0xF5D0,0xF966,
	0xFC40,0xFE4B,0xFF68,0xFEE6,0xFCF2,0xFB26,0xFC92,0xFF52,
	0x0129,0x013F,0xFFF3,0xFF2C,0x003C,0x0389,0x06AE,0x08BD,
	0x07D5,0x04B2,0x0135,0x003C,0x0246,0x0584,0x07F0,0x08C7,
	0x07ED,0x0679,0x04B7,0x0367,0x0304,0x031B,0x0312,0x0322,
	0x031C,0x02F2,0x01EE,0x012A,0x0138,0x00F3,0x002A,0xFF18,
	0xFD8C,0xFB2E,0xF914,0xFA26,0xFD3B,0x0017,0xFFD6,0xFD19,
	0xFADC,0xF9E3,0xF914,0xF8B6,0xF902,0xF9CA,0xFB11,0xFE9D,
	0xFF4C,0xFEEF,0xFDB8,0xF9BC,0xF833,0xFA7A,0xFE0E,0xFF40,
	0xFE6F,0xFCBD,0xFD01,0xFF1F,0x015D,0x01A8,0x0126,0x00A9,
	0x006B,0x0079,0xFFD5,0x0021,0x0106,0x0218,0x02CA,0x03EF,
	0x04F5,0x04AF,0x028E,0x0046,0xFF8B,0x0140,0x02AE,0x03CB,
	0x047C,0x0411,0x03A8,0x020B,0x007A,0xFFD8,0x0036,0x002E,
	0x000C,0x0033,0x00F1,0x0037,0xFDD7,0xFBED,0xFC9B,0xFF0D,
	0xFFCD,0xFE31,0xFB9B,0xFA8B,0xFB77,0xFC44,0xFDAC,0xFEF0,
	0xFEB6,0xFC80,0xFAD0,0xFA18,0xFABE,0xFB4B,0xFB4A,0xFA7B,
	0xFB59,0xFC74,0xFB0A,0xF8AD,0xF818,0xF9B7,0xFB2A,0xFB83,
	0xFA79,0xF91A,0xF86A,0xF868,0xF8B0,0xF8B8,0xF812,0xF797,
	0xF760,0xF6A4,0xF50B,0xF4C4,0xF4C0,0xF37A,0xF364,0xF56B,
	0xF760,0xF6C2,0xF504,0xF40C,0xF407,0xF4B0,0xF4D0,0xF4DE,
	0xF4D1,0xF3D0,0xF31D,0xF395,0xF3C3,0xF37A,0xF320,0xF281,
	0xF22B,0xF165,0xF1A5,0xF196,0xEF9D,0xEED0,0xEE3C,0xEE0C,
	0xEE40,0xEDC6,0xED1E,0xEC9A,0xEC7B,0xEC70,0xEC6F,0xEC2A,
	0xEBF3,0xEC12,0xEBF9,0xEC00,0xEC01,0xEB22,0xEA9E,0xEA4F,
	0xEA10,0xEA6A,0xEA6C,0xEA39,0xE9E4,0xE99A,0xE964,0xE991,
	0xE990,0xEA35,0xE9FF,0xEA03,0xEA74,0xEA29,0xEA40,0xEA9B,
	0xEA9D,0xEA88,0xEB3C,0xEB82,0xEBB9,0xEBB4,0xEB7E,0xEBC0,
	0xEC0F,0xEC52,0xEC94,0xECBC,0xECE9,0xED4D,0xEDF9,0xEE6C,
	0xEEB4,0xEE9A,0xEED3,0xEF48,0xEF80,0xEFD1,0xF03B,0xF102,
	0xF187,0xF191,0xF210,0xF29C,0xF2E2,0xF34E,0xF3AA,0xF3B4,
	0xF44D,0xF4A5,0xF55E,0xF5D8,0xF5FF,0xF6B3,0xF797,0xF689,
	0xF680,0xF8A9,0xF7FA,0xF885,0xF921,0xF95C,0xF9E3,0xFA34,
	0xFA93,0xFA91,0xFAD8,0xFBAD,0xFC87,0xFD09,0xFD94,0xFE0C,
	0xFE2B,0xFE3A,0xFE6C,0xFEA6,0xFEEE,0xFFAC,0x002E,0x0085,
	0x0095,0x00BD,0x010E,0x013F,0x015C,0x0213,0x028E,0x029F,
	0x0248,0x029D,0x02E6,0x034D,0x0396,0x03E6,0x0412,0x0445,
	0x04A6,0x04F4,0x0541,0x0599,0x05DE,0x0658,0x06EE,0x06DA,
	0x0730,0x0741,0x0797,0x07F8,0x0812,0x0845,0x088F,0x08F3,
	0x094F,0x095C,0x09BD,0x0A39,0x0B0F,0x0D26,0x0D40,0x0D19,
	0x0D34,0x0CF9,0x0CC1,0x0C7E,0x0CDF,0x0D13,0x0D4F,0x0D17,
	0x0D02,0x0CE6,0x0CFE,0x0D58,0x0D49,0x0DB0,0x0D94,0x0D77,
	0x0CEB,0x0D3B,0x0E7A,0x0E0C,0x0D08,0x0D04,0x0CD3,0x0CCB,
	0x0CF9,0x0CEE,0x0CF9,0x0CDD,0x0CAF,0x0D3F,0x0DAA,0x0D6E,
	0x0DDE,0x0D98,0x0D53,0x0CAD,0x0CBB,0x0D2F,0x0D6B,0x0D0F,
	0x0D4E,0x0D49,0x0C07,0x0C53,0x0CF3,0x0D16,0x0D15,0x0D43,
	0x0D2B,0x0D00,0x0D08,0x0CBE,0x0C4A,0x0C19,0x0BAD,0x0BA4,
	0x0B44,0x0A82,0x0AF5,0x0ADB,0x0A8E,0x0A6C,0x0A64,0x0A3D,
	0x0A7F,0x0A87,0x0A75,0x0A97,0x0A9C,0x0A2F,0x0A28,0x0AA3,
	0x0AB8,0x0AEF,0x0B10,0x0AAB,0x0A87,0x0A95,0x0A9F,0x0A9E,
	0x0AA5,0x0AD8,0x0A82,0x0A3F,0x0A35,0x0A11,0x0A76,0x0A3E,
	0x0A1F,0x09DB,0x09B2,0x0A16,0x09FD,0x09F5,0x09CE,0x093E,
	0x096E,0x09AB,0x09D5,0x098C,0x090D,0x0919,0x08FB,0x08EB,
	0x08C1,0x0878,0x0846,0x07ED,0x07E0,0x085C,0x083A,0x0813,
	0x0882,0x08B5,0x08B8,0x08F8,0x08EF,0x079F,0x0825,0x0958,
	0x0793,0x089B,0x088D,0x084C,0x07F9,0x0815,0x084F,0x0842,
	0x0836,0x07CF,0x0767,0x078D,0x07A5,0x0767,0x07FE,0x076A,
	0x075E,0x070A,0x075F,0x07A0,0x07C6,0x07BA,0x076D,0x0730,
	0x0719,0x071B,0x0777,0x07AD,0x0789,0x0767,0x06FD,0x06D7,
	0x069D,0x0678,0x06BB,0x0684,0x0666,0x0643,0x061F,0x056E,
	0x055F,0x0598,0x05CD,0x062B,0x065E,0x060F,0x059F,0x0572,
	0x0586,0x05A3,0x05A9,0x05D0,0x05E2,0x0576,0x0542,0x0525,
	0x0533,0x051E,0x0527,0x0533,0x053D,0x04C7,0x0328,0x013B,
	0x0208,0x0236,0x0259,0x0293,0x02FB,0x02E1,0x0268,0x0239,
	0x0201,0x01F7,0x0212,0x02A2,0x0290,0x02BF,0x02C0,0x024B,
	0x02F1,0x0293,0x01E3,0x02BE,0x033B,0x02DB,0x0236,0x025E,
	0x0279,0x0269,0x02EE,0x02D5,0x02B5,0x0304,0x02F2,0x02F3,
	0x0346,0x0370,0x032F,0x02BA,0x0294,0x0304,0x0305,0x0301,
	0x02CE,0x02AE,0x0436,0x03A5,0x0277,0x024B,0x0243,0x0206,
	0x0283,0x028F,0x0220,0x0264,0x02AD,0x0317,0x0334,0x02F1,
	0x0388,0x0376,0x033E,0x0336,0x02EF,0x02FA,0x0311,0x02F3,
	0x02BC,0x025A,0x0253,0x02B9,0x029F,0x02C5,0x02DA,0x02AB,
	0x02BE,0x02E0,0x029F,0x0216,0x0238,0x023D,0x0205,0x01F2,
	0x0214,0x01BD,0x01E3,0x01A8,0x014E,0x00F9,0x00D6,0x00BA,
	0x0122,0x0139,0x00F8,0x00B0,0x009D,0x006F,0xFFFE,0x006A,
	0x00D9,0x0086,0x00DA,0x023B,0x0337,0x0365,0x035E,0x0320,
	0x032F,0x040F,0x0591,0x073D,0x07DE,0x084E,0x0869,0x0892,
	0x0874,0x0853,0x0848,0x08A8,0x0946,0x095A,0x092B,0x09CE,
	0x0A4E,0x0A6D,0x0ABD,0x0B7B,0x0C3B,0x0C19,0x0BC7,0x0C21,
	0x0D44,0x0DA6,0x0E6F,0x0EC4,0x0F76,0x0FE1,0x0F95,0x0F0A,
	0x0EDA,0x0EEA,0x0F07,0x10FF,0x13D0,0x151E,0x1408,0x1220,
	0x1250,0x1313,0x141D,0x15F4,0x174E,0x1825,0x178A,0x163B,
	0x14BB,0x146F,0x160F,0x18BF,0x1972,0x185A,0x16D4,0x162A,
	0x169C,0x17B2,0x18A4,0x189B,0x1838,0x1859,0x16A2,0x1493,
	0x146D,0x156F,0x1672,0x17A6,0x1828,0x174F,0x14CB,0x11C6,
	0x1127,0x130A,0x14A6,0x149B,0x1322,0x119F,0x10FF,0x10BF,
	0x110C,0x1145,0x11FA,0x1218,0x10A3,0x0D9C,0x0BD6,0x0D8A,
	0x0EDA,0x0EE3,0x0DE9,0x0CDD,0x0B4F,0x0A02,0x099D,0x0AB8,
	0x0A77,0x08A3,0x0735,0x079F,0x0731,0x05CF,0x03EC,0x02D4,
	0x037A,0x0443,0x03AD,0x02EE,0x01B9,0x00EA,0x013E,0x0294,
	0x039D,0x02C4,0xFF92,0xFCC1,0xFC7B,0xFE1D,0x0056,0x0180,
	0x0151,0x007C,0xFF98,0xFD99,0xFC4C,0xFB84,0xFBBD,0xFD16,
	0xFE9A,0xFE77,0xFDBE,0xFB53,0xF80E,0xF7AF,0xFA04,0xFC8C,
	0xFD84,0xFB17,0xF65C,0xF3B1,0xF49D,0xF813,0xFB8C,0xFD0B,
	0xFB71,0xF69F,0xF16A,0xEF54,0xF174,0xF633,0xFA42,0xFA89,
	0xF7C3,0xF483,0xF27D,0xF2B4,0xF36A,0xF39B,0xF378,0xF3FA,
	0xF53D,0xF5D2,0xF654,0xF1EE,0xF12D,0xF32B,0xF4FD,0xF5D8,
	0xF417,0xF0F5,0xEE2C,0xEF42,0xF411,0xF840,0xF839,0xF4BB,
	0xF0FD,0xF035,0xF0C7,0xF18D,0xF251,0xF3BA,0xF574,0xF5B7,
	0xF42B,0xF179,0xEFDA,0xEFC9,0xF149,0xF2E4,0xF350,0xF2B6,
	0xF1D5,0xF163,0xF1F0,0xF348,0xF3FB,0xF28E,0xEEAC,0xEBD7,
	0xEC63,0xF038,0xF5E7,0xF9AC,0xF809,0xF2B9,0xED03,0xE9C0,
	0xEABB,0xEEAB,0xF284,0xF529,0xF65E,0xF61C,0xF3C2,0xF03A,
	0xEDD7,0xED6B,0xEF14,0xF10D,0xF22D,0xF21E,0xF165,0xF0DF,
	0xF096,0xF14F,0xF0E5,0xF224,0xF113,0xED00,0xE89E,0xE814,
	0xEC62,0xF238,0xF637,0xF688,0xF368,0xEE66,0xEA29,0xE8DA,
	0xEB1B,0xEEBC,0xF1D1,0xF4DC,0xF7B6,0xF72E,0xF2BF,0xEC59,
	0xE9CA,0xEC87,0xF144,0xF42C,0xF4CE,0xF4A2,0xF336,0xF0B2,
	0xEFD1,0xF1AC,0xF3D6,0xF38E,0xF199,0xF03A,0xF191,0xF441,
	0xF51B,0xF338,0xF10C,0xF218,0xF432,0xF567,0xF301,0xF026,
	0xF123,0xF307,0xF4E1,0xF5D9,0xF586,0xF28E,0xEF7B,0xF0CC,
	0xF608,0xFB1C,0xFA8B,0xF499,0xEF93,0xEFDA,0xF50C,0xF96B,
	0xF9BB,0xF7D5,0xF6FE,0xF71A,0xF6DA,0xF57C,0xF3E9,0xF286,
	0xF23F,0xF4E0,0xFA4D,0xFE37,0xFBC4,0xF45D,0xEE2A,0xEEE7,
	0xF51C,0xFADA,0xFB96,0xF968,0xF7BA,0xF776,0xF69D,0xF60C,
	0xF78C,0xF903,0xF8D5,0xF866,0xF7A0,0xF6A0,0xF4E5,0xF42C,
	0xF628,0xFA20,0xFCA7,0xFC08,0xF947,0xF6C6,0xF4D5,0xF34D,
	0xF3EA,0xF894,0xFD9B,0xFF16,0xFC5B,0xF7D4,0xF47B,0xF354,
	0xF56A,0xF9D9,0xFFAD,0x0240,0xFF2D,0xF8A2,0xF3AE,0xF36A,
	0xF737,0xFCEB,0xFF86,0x010B,0xFD61,0xF733,0xF7C5,0xFD27,
	0x0135,0x009E,0xFCBC,0xF885,0xF5B8,0xF59F,0xF987,0xFFDD,
	0x04D5,0x0570,0x01A5,0xFC5A,0xF722,0xF34C,0xF23B,0xF790,
	0x0233,0x09D9,0x080D,0xFE8B,0xF5A1,0xF387,0xF7B0,0xFD96,
	0x039E,0x06CC,0x030D,0xFBB6,0xF6A0,0xF830,0xFEE1,0x0300,
	0x0186,0xFF12,0xFDCC,0xFDC2,0xFDDB,0xFE12,0xFFA6,0x00D7,
	0xFEF9,0xFC4D,0xFC54,0xFE80,0xFF4B,0xFE87,0xFE6D,0x007E,
	0x0221,0xFF45,0xFB03,0xFAD8,0xFF4B,0x0344,0x0274,0xFE9D,
	0xFD74,0xFD75,0xFF95,0x0302,0x05C1,0x058E,0x01F6,0xFDA8,
	0xFC10,0xFD59,0xFE0B,0xFD71,0xFEAA,0x02F1,0x076A,0x077E,
	0x0366,0xFED6,0xFACB,0xF795,0xF880,0xFE97,0x0529,0x085C,
	0x05C7,0xFE51,0xF89B,0xF972,0xFCFA,0xFFDD,0x011E,0x019C,
	0xFFF4,0xFB33,0xF76E,0xFA89,0x0176,0x05AA,0x0325,0xFCD4,
	0xF790,0xF5C1,0xF795,0xFC7B,0x01EB,0x03F2,0x0283,0xFEBF,
	0xF9F4,0xF85D,0xF978,0xFB8C,0xFE25,0x00A8,0x0211,0x00B2,
	0xFC01,0xF990,0xFBC4,0xFFE5,0x003F,0xFC2C,0xF5D7,0xF2B4,
	0xF49E,0xFBAB,0x0470,0x08D8,0x0470,0xF984,0xEF31,0xED64,
	0xF509,0x0019,0x04CD,0x00A8,0xFAA3,0xF94C,0xFAF8,0xFC54,
	0xFCAA,0xFBFA,0xFA1D,0xF81D,0xF82C,0xF9F5,0xFD97,0x0145,
	0x01FE,0xFFA6,0xFB50,0xF633,0xF365,0xF659,0xFD25,0x01CB,
	0x0177,0xFD68,0xF9D1,0xF961,0xFC71,0xFFF9,0xFF5F,0xFBFE,
	0xF8E3,0xF83F,0xFAD3,0xFDE9,0xFFB0,0x012E,0x0291,0x01CE,
	0xFDC4,0xF906,0xF684,0xF770,0xFC06,0x025B,0x04F8,0x02AA,
	0xFEC0,0xFECE,0xFE6E,0xFBDB,0xFAEB,0xFA2E,0xFDDF,0x0338,
	0x04E8,0x0126,0xFC8C,0xFB80,0xFED7,0x0224,0x01F8,0xFED3,
	0xFC09,0xFCBA,0x00DF,0x0513,0x049B,0x0088,0xFB4B,0xF934,
	0xFB74,0x017B,0x069D,0x0676,0x02DE,0x00B9,0x0067,0xFE73,
	0xFBC2,0xFAE8,0xFE15,0x02B3,0x04BB,0x0426,0x0358,0x01CB,
	0xFECC,0xFC7D,0xFDBD,0x0207,0x044A,0x01CA,0xFC19,0xFAA1,
	0x001B,0x0665,0x0837,0x05F1,0x017F,0xFC8C,0xF7FB,0xF74F,
	0xFCD1,0x0472,0x09AC,0x0A40,0x078E,0x0348,0xFC2D,0xF53D,
	0xF3D6,0xFADA,0x0604,0x0CF2,0x0A7F,0x0287,0xFAAB,0xF64E,
	0xF7FA,0xFF68,0x064F,0x0527,0xFDE8,0xF8C3,0xFBE5,0x02C7,
	0x0714,0x07E8,0x058D,0x002B,0xF7AD,0xF28E,0xF59C,0xFF69,
	0x0A99,0x0F32,0x0BD8,0x0364,0xFA64,0xF50D,0xF5BE,0xFC62,
	0x05A6,0x0B1E,0x0968,0x03C1,0xFF0C,0xFD33,0xFDD1,0x0137,
	0x04C9,0x0555,0x0277,0xFC8C,0xF97E,0xFD67,0x0399,0x09B5,
	0x0A97,0x0536,0xFD53,0xF868,0xF84F,0xFC2C,0x01DD,0x05F8,
	0x0643,0x0375,0x0132,0x0167,0x0370,0x055C,0x0654,0x040C,
	0xFF58,0xFBB6,0xFD99,0x03CE,0x08B1,0x0904,0x0544,0x0077,
	0xFE3B,0xFF7B,0x02C0,0x053F,0x03F0,0xFF9B,0xFCF3,0xFF55,
	0x05E6,0x08E0,0x0542,0x004A,0xFFEF,0x02D0,0x038A,0x0107,
	0xFE34,0xFDA2,0xFFDB,0x045C,0x0A1D,0x0BD4,0x05DC,0xFC1F,
	0xF78E,0xFBF4,0x03B2,0x06F1,0x046F,0x02E1,0x04F6,0x068B,
	0x0393,0xFF34,0xFDF4,0xFF18,0x0186,0x034B,0x04A5,0x0429,
	0x01B2,0x0057,0x02D0,0x0632,0x06DA,0x0369,0xFE23,0xFBC4,
	0xFD50,0xFE96,0xFFB3,0x05D3,0x0A19,0x0B2A,0x06FB,0xFFBE,
	0xFA96,0xF9FB,0xFDCB,0x0391,0x0748,0x06A6,0x0301,0xFE56,
	0xFC31,0xFEE4,0x04D1,0x072E,0x03A7,0xFEC3,0xFE07,0xFFC2,
	0xFF9D,0x0022,0x02EB,0x0642,0x05E7,0x0242,0xFD3F,0xFA3E,
	0xFBCF,0x009D,0x0553,0x0753,0x0600,0x0149,0xFB82,0xF880,
	0xFC05,0x0306,0x0790,0x068A,0x008D,0xFA77,0xF996,0xFDC4,
	0x044A,0x08D5,0x08A6,0x03BB,0xFC9D,0xF709,0xF892,0xFFF5,
	0x0748,0x0971,0x04C6,0xFDDE,0xF91C,0xFA88,0x013F,0x0A65,
	0x0D69,0x0837,0xFF4A,0xF772,0xF7C2,0x00F3,0x0C1D,0x1093,
	0x0A8A,0x0024,0xF97B,0xFAE0,0xFFDF,0x0386,0x044D,0x038D,
	0x02D6,0x02E3,0x037D,0x04B7,0x03F2,0xFF89,0xFBA2,0xFC0A,
	0xFF4D,0x00A9,0x0128,0x02E9,0x0565,0x05B1,0x01F6,0xFD9B,
	0xFBFF,0xFC29,0xFE68,0x027E,0x05CF,0x0430,0xFF73,0xFD61,
	0xFFE5,0x0394,0x042F,0xFF1B,0xF866,0xF5D0,0xFA69,0x02B1,
	0x099D,0x0938,0x01BA,0xF9BC,0xF74C,0xFA0A,0xFD54,0xFE4A,
	0xFF08,0x011F,0x031C,0x0150,0xFC74,0xF79F,0xF61A,0xF85E,
	0xFD10,0xFFDD,0xFEAA,0xFC21,0xFBA8,0xFCCD,0xFE3E,0xFEF0,
	0xFE78,0xFBFD,0xF7CA,0xF65C,0xFA54,0xFFCF,0x00EF,0xFE96,
	0xFDBA,0xFE9F,0xFD8D,0xFA0E,0xF845,0xF9EE,0xFCBA,0xFE18,
	0xFF3E,0x00FC,0x0111,0xFE71,0xFC2E,0xFD66,0xFFF6,0xFE99,
	0xFA06,0xF718,0xF91F,0xFDF8,0x0323,0x0699,0x0657,0x01EF,
	0xFAE7,0xF39D,0xF22C,0xF75F,0xFEDC,0x0506,0x0678,0x03BB,
	0xFF3F,0xFBD6,0xFB1D,0xFBB2,0xFCA1,0xFF86,0x01FB,0x009A,
	0xFCC5,0xFBBA,0xFC00,0x0254,0x07E8,0x08BC,0x04A6,0xFCF8,
	0xF512,0xF2F4,0xF74E,0xFFD7,0x07C7,0x0AD1,0x09AF,0x05BF,
	0x005B,0xF9A7,0xF4E5,0xF491,0xF901,0xFF27,0x0500,0x08D1,
	0x0A51,0x0736,0x0002,0xF9B2,0xF83B,0xFAF2,0xFD3D,0xFDC0,
	0xFE12,0xFFD4,0x034D,0x0551,0x0474,0x0138,0xFEB9,0xFD7D,
	0xFDDF,0xFD1E,0xFA8F,0xF92F,0xFC18,0x0329,0x09C7,0x0C7B,
	0x089A,0xFF5B,0xF6A4,0xF3D0,0xF78B,0xFEEF,0x05F2,0x07BF,
	0x04E5,0x0129,0xFF8F,0xFF73,0xFE4D,0xFD1E,0xFCDF,0xFEEF,
	0x014E,0x00BB,0xFE7D,0xFBA9,0xFB9A,0x0078,0x05B7,0x04E2,
	0xFCBA,0xF485,0xF2E3,0xF8E3,0x02A5,0x08AF,0x07CB,0x01BB,
	0xFB1F,0xF7BD,0xF93E,0xFD60,0x0081,0x0301,0x0445,0x03B9,
	0x0119,0xFC9A,0xF989,0xFB7F,0x02A4,0x0A09,0x0B88,0x060E,
	0xFBD8,0xF40B,0xF431,0xFDFB,0x0A22,0x1038,0x0CAB,0x03D5,
	0xFC60,0xF99F,0xF989,0xFAF9,0xFF2B,0x0633,0x0BAC,0x0CD8,
	0x0730,0xFDBA,0xF73E,0xF9F2,0x0343,0x0A04,0x077A,0xFFBB,
	0xFA94,0xFCDD,0x050E,0x0C70,0x0C7B,0x05E5,0xFC60,0xF741,
	0xF979,0x0134,0x0916,0x0C79,0x0997,0x043C,0xFF7D,0xFBD4,
	0xF9AC,0xFB46,0x00E7,0x070E,0x09DE,0x0651,0xFF05,0xFA0E,
	0xFB41,0x000B,0x0564,0x07FC,0x059F,0xFF10,0xF8FA,0xF859,
	0xFE59,0x05B3,0x0A4A,0x0AA8,0x05BE,0xFCE9,0xF5A4,0xF4A0,
	0xFB76,0x04BB,0x0AE3,0x0AE4,0x05BA,0xFED8,0xF9D7,0xF939,
	0xFD4D,0x02B5,0x057E,0x054A,0x02A7,0xFF57,0xFB79,0xFAD2,
	0xFF3F,0x06F2,0x0A88,0x0616,0xFE2C,0xF969,0xFA3C,0xFE1C,
	0x02F8,0x04A6,0x0679,0x0350,0xFE0A,0xFEAB,0x028B,0x0323,
	0x000C,0xFC4A,0xFC38,0x0006,0x0367,0x04CE,0x05BD,0x04CB,
	0x031B,0x0180,0x004B,0xFEC8,0xFC35,0xF9D8,0xFB6A,0x01A7,
	0x08F2,0x0CCB,0x0A37,0x0355,0xFCC8,0xF983,0xFA5E,0xFDEB,
	0x0047,0x0194,0x02CF,0x0493,0x057E,0x05AB,0x0475,0x0190,
	0xFD38,0xFA20,0xF9DA,0xFDEE,0x0406,0x0738,0x0504,0x006F,
	0xFCBC,0xFC47,0xFE74,0x00D0,0x0123,0x0017,0xFF2E,0xFEE7,
	0xFDFC,0xFD2F,0xFD69,0xFE7D,0xFF05,0xFE29,0xFFFA,0x0444,
	0x0373,0xFFFF,0xFD88,0xFF1E,0x01A0,0x0059,0xFDC9,0xFDBC,
	0x013F,0x0487,0x03DD,0xFF12,0xFA12,0xF819,0xFB0E,0x01C1,
	0x0704,0x0791,0x0231,0xFA6E,0xF56B,0xF633,0xFC51,0x0352,
	0x060E,0x0453,0xFFFA,0xFC84,0xFB5C,0xFAAA,0xFAD2,0xFD46,
	0x006B,0x0111,0xFEFA,0xFC37,0xFCBE,0xFFCB,0x035B,0x0353,
	0xFDF6,0xF7F6,0xF52E,0xF811,0xFEC4,0x052A,0x0612,0x00F8,
	0xFCA5,0xFD45,0x014C,0x0233,0xFCF2,0xF666,0xF7DC,0xFF7F,
	0x056F,0x0534,0xFFE7,0xFC3E,0xFAF6,0xFAE0,0xFA31,0xF9CB,
	0xFB50,0xFD38,0xFFEB,0x036F,0x04C5,0x0090,0xF88B,0xF4ED,
	0xF82A,0xFD2B,0x0000,0x009A,0x0175,0x0144,0xFF85,0xFE6D,
	0xFE6F,0xFD96,0xFAD2,0xF94E,0xFBA9,0x0179,0x0567,0x0438,
	0x002E,0xFCD0,0xFA3D,0xFA73,0xFBC5,0xFED9,0x00EC,0x007A,
	0xFE8B,0xFDCC,0xFE71,0xFFCD,0x0068,0xFEB7,0xFB9F,0xF926,
	0xF8EB,0xFB7C,0x005F,0x04C7,0x0571,0x0001,0xF907,0xF6C6,
	0xF922,0xFCB6,0xFFF7,0x0106,0x0015,0xFEAD,0xFDD9,0xFDF8,
	0x0013,0xFDFF,0xFB30,0xFCD8,0xFEB0,0x0034,0xFDB2,0xF8EB,
	0xF7E5,0xFE79,0x06C4,0x099D,0x030F,0xF770,0xF11D,0xF588,
	0xFFC0,0x07BC,0x07F5,0x01A1,0xFC40,0xFB86,0xFE1C,0xFF7B,
	0xFD8D,0xFAF9,0xFC08,0x0048,0x0439,0x03C7,0xFE86,0xFA59,
	0xFB70,0x0072,0x03B0,0x0186,0xFCCF,0xFAF3,0xFF52,0x05AC,
	0x07C3,0x0337,0xFC5C,0xF815,0xF8E6,0xFD4C,0x02C5,0x0674,
	0x061D,0x039E,0x010B,0xFFD5,0xFFC2,0xFEC6,0xFC91,0xFAFE,
	0xFD01,0x0173,0x04DA,0x05EF,0x062F,0x0528,0x01A0,0xFD43,
	0xF8D5,0xF730,0xF934,0xFC1A,0x00D1,0x04C6,0x043E,0x015E,
	0xFF5D,0xFE23,0xFC21,0xF953,0xF8B9,0xFB0F,0xFDF6,0xFF2C,
	0xFF1D,0x0058,0x03F6,0x05F7,0x0386,0xFCFE,0xF5B6,0xF266,
	0xF588,0xFD08,0x0688,0x0D17,0x0D11,0x0570,0xFA50,0xF2C6,
	0xF29C,0xF763,0xFCF4,0x01B1,0x0541,0x075A,0x0781,0x0503,
	0x0076,0xFB15,0xF71C,0xF6F2,0xFA5C,0xFD7B,0x0122,0x058E,
	0x0889,0x07BA,0x02E8,0xFAB5,0xF4B2,0xF45F,0xFA11,0x0367,
	0x0A74,0x0A08,0x0374,0xFE63,0xFF3F,0x0347,0x04E8,0x02ED,
	0xFF00,0xFB5B,0xFA1A,0xFCED,0x0303,0x08EC,0x0AF7,0x08DA,
	0x03D5,0xFC93,0xF5D8,0xF3DB,0xF8C6,0x0326,0x0C46,0x0ED8,
	0x0A6E,0x01E3,0xF9B7,0xF62E,0xF7D9,0xFF14,0x0748,0x09A6,
	0x04EC,0xFEF9,0xFCDC,0xFEB7,0x00D7,0x0238,0x0261,0x021B,
	0x019C,0x00DF,0xFE8B,0xFC8A,0xFD07,0x0123,0x06E3,0x095E,
	0x04F0,0xFBCF,0xF446,0xF671,0x0148,0x0BC8,0x0EA3,0x08CC,
	0xFFE2,0xF96F,0xF690,0xF83B,0xFCAA,0x0250,0x076D,0x0A5D,
	0x077E,0x0203,0xFEC1,0xFA51,0xF9C0,0xFD4E,0x01D9,0x0596,
	0x0655,0x0360,0xFE48,0xFC9F,0xFF34,0x0228,0x02B8,0x00D8,
	0xFF09,0xFCA5,0xFA7A,0xFB48,0x012E,0x08A6,0x09AA,0x0311,
	0xFA60,0xF594,0xF7F4,0xFF3B,0x0507,0x0715,0x0468,0xFF1C,
	0xFBCC,0xFBB7,0xFE8F,0x0071,0xFF62,0xFDF7,0xFE7F,0x0091,
	0x0133,0x0080,0xFF7D,0xFED8,0xFD0D,0xFACD,0xFAF4,0xFE61,
	0x0114,0x00E8,0xFF0E,0xFEF7,0x0087,0xFF53,0xFC41,0xFB1F,
	0xFCCA,0xFE8F,0xFE2C,0xFF3D,0x032A,0x0596,0x03F9,0xFE26,
	0xFAB0,0xFB2C,0xFCDC,0xFFC3,0x0494,0x083E,0x0676,0xFEE7,
	0xF919,0xFAB8,0x007C,0x04F7,0x057A,0x029E,0xFF94,0xFC8C,
	0xF9C9,0xFA36,0xFFCF,0x07AD,0x09A6,0x0499,0xFCF0,0xF6F6,
	0xF511,0xFA13,0x0420,0x0D82,0x0E11,0x038B,0xF62F,0xF155,
	0xF808,0x025D,0x07F8,0x06D8,0x02B3,0xFF75,0xFF33,0xFF2D,
	0xFE16,0xFE3A,0xFF10,0xFFBB,0x01E8,0x03F9,0x01B0,0xFD17,
	0xFBCD,0xFFC9,0x054E,0x0526,0xFD6C,0xF664,0xF74F,0xFE8F,
	0x03BA,0x02B0,0xFDA9,0xFB46,0xFC3E,0xFE62,0xFEC3,0xFDBE,
	0xFC53,0xFB1D,0xFA13,0xFC1F,0xFFFC,0x016F,0xFF20,0xFB8D,
	0xFAC5,0xFD31,0xFF41,0xFEF9,0xFD11,0xFBFC,0xFC73,0xFCA3,
	0xFBFC,0xFCE3,0xFFF4,0x0286,0x0243,0xFF94,0xFBE9,0xF98D,
	0xF9ED,0xFD1F,0x019C,0x0367,0x00C7,0xFA28,0xF65B,0xFA46,
	0x0285,0x0778,0x046C,0xFD64,0xF8E0,0xF7FB,0xF9CA,0xFE0F,
	0x02D2,0x0367,0xFE6F,0xFA63,0xFC05,0x0024,0x0146,0xFDFC,
	0xF9DF,0xF8E2,0xFA64,0xFC6E,0x005E,0x04D6,0x042D,0xFF5B,
	0xFC24,0xF93C,0xFB8F,0xFC43,0xFADF,0xFCED,0x035E,0x0785,
	0x04B2,0xFD85,0xF819,0xF84D,0xFBD3,0xFF60,0x0183,0x016D,
	0xFFF4,0xFF9B,0x014F,0x0347,0x0159,0xFB7B,0xF4EB,0xF421,
	0xFB5D,0x0485,0x0876,0x05B4,0x0123,0xFF33,0xFF43,0xFE14,
	0xFB71,0xF894,0xF88F,0xFC5F,0x02D4,0x0787,0x0684,0x0162,
	0xFC8A,0xFC45,0x0014,0x0232,0xFE35,0xF7F3,0xF5CE,0xFB77,
	0x063B,0x0D7C,0x0B77,0x0135,0xF5C3,0xF1DF,0xF60E,0xFD95,
	0x023C,0x01C2,0x011E,0x0360,0x04DA,0x020E,0xFC36,0xF75C,
	0xF753,0xFD06,0xFF95,0xFC41,0xF8C6,0xF85C,0xFC61,0x01D5,
	0x05BF,0x03CA,0xFD83,0xF794,0xF501,0xF7ED,0xFCE8,0x003B,
	0x013C,0x030C,0x030C,0xFF94,0xFB8A,0xF908,0xFA6D,0xFDE2,
	0xFFA3,0xFE15,0xFC02,0xFD89,0x0195,0x04AE,0x0432,0x00F9,
	0xFCD5,0xF8B0,0xF83A,0xFD2C,0x039B,0x06CE,0x052E,0x022C,
	0xFFF4,0xFE85,0xFC23,0xFC1A,0xFD1B,0xFF8A,0x01E0,0x02EC,
	0x035A,0x017B,0xFD88,0xFBA3,0xFEB4,0x0410,0x05F3,0x0276,
	0xFDE2,0xFD94,0x0161,0x04AA,0x0590,0x058C,0x0430,0x0172,
	0xFD67,0xFA84,0xFAF0,0xFEE7,0x04C9,0x09F3,0x09B2,0x0440,
	0xFC8D,0xF80D,0xFA52,0x014A,0x0692,0x05B5,0xFFC2,0xFBC7,
	0xFD92,0x01F7,0x044C,0x0461,0x02B4,0x002B,0xFD6E,0xFB59,
	0xFB80,0xFEBF,0x03C1,0x08A4,0x096E,0x0476,0xFC4C,0xF528,
	0xF473,0xFC7B,0x07AA,0x0DBA,0x092C,0xFE8C,0xF908,0xFABB,
	0xFFB6,0x03A0,0x0448,0x02CF,0x00AF,0xFE4A,0xFD7A,0xFDBC,
	0xFF67,0x0270,0x05D4,0x082E,0x0592,0xFEDB,0xF837,0xF5F1,
	0xF9E8,0x055C,0x0CFB,0x0B0D,0x02D9,0xFAD3,0xF823,0xFA67,
	0xFE43,0x0100,0x01CF,0x0252,0x024F,0x01CA,0x0012,0xFDA4,
	0xFD2C,0xFE69,0xFFF2,0x0052,0xFE5E,0xFC2C,0xFCEE,0x0065,
	0x047E,0x0555,0x0169,0xFB35,0xF73A,0xF7CA,0xFC65,0x015D,
	0x0489,0x045B,0x018B,0xFE9B,0xFCB1,0xFADC,0xF92A,0xFA6E,
	0xFD96,0x00E8,0x0212,0xFF79,0xFD2B,0xFC4D,0xFDA7,0xFFBF,
	0x00C5,0xFF65,0xFBE4,0xF9E1,0xFA20,0xFC87,0x00A2,0x03B8,
	0x0459,0x01B4,0xFC82,0xF8AA,0xF919,0xFDD8,0x03DD,0x06C9,
	0x06F8,0x02E0,0xFDDD,0xFCE9,0xFF4E,0x0204,0x0237,0x0135,
	0x00E5,0x00D3,0x0137,0x01F2,0x0296,0x0188,0xFF00,0xFD89,
	0xFE61,0x00E2,0x0354,0x0291,0x004B,0x000E,0x0177,0x01F0,
	0x010D,0xFFDE,0xFF81,0xFEB5,0xFDDC,0xFE60,0x016B,0x03E4,
	0x0387,0x01BF,0x0039,0xFEC4,0xFCF7,0xFB97,0xFCD6,0xFF9F,
	0x0264,0x03F6,0x0320,0x0067,0xFF67,0xFE4E,0xFC2E,0xFB26,
	0xFC41,0xFEC5,0x0185,0x0285,0x01A5,0x0021,0xFE38,0xFBFF,
	0xFA09,0xF93A,0xFB3A,0xFF0E,0x017A,0x01CD,0xFF73,0xFC52,
	0xFAD9,0xFBFD,0xFEC5,0x002E,0xFE81,0xFB82,0xF92B,0xF9D4,
	0xFCFB,0x013B,0x03E9,0x0314,0xFEA2,0xFA6E,0xF8DF,0xF903,
	0xF9C2,0xFC5A,0xFF92,0x0280,0x0410,0x01D4,0xFCCD,0xF7D8,
	0xF786,0xFAB3,0xFE32,0x003E,0x004D,0xFEFE,0xFE1A,0xFDF0,
	0xFE46,0xFE1D,0xFD24,0xFB71,0xFB15,0xFD10,0xFEF5,0xFEE9,
	0xFCE5,0xFB6F,0xFB99,0xFDF2,0x004B,0x0058,0xFDA0,0xFA11,
	0xF89C,0xFB39,0x0018,0x0332,0x0265,0xFE8D,0xFA28,0xFACE,
	0xFBE7,0xFEBF,0x0296,0x01A4,0xFE65,0xFC46,0xFD3C,0xFF61,
	0xFFF7,0xFF1E,0xFEAC,0xFF18,0xFF50,0xFE87,0xFD92,0xFD5C,
	0xFD8C,0xFEC0,0x0080,0x014D,0x003A,0xFEE3,0xFD86,0xFE27,
	0xFF16,0xFFF2,0xFFFA,0xFF3A,0xFEE5,0xFF96,0x00FD,0x01AB,
	0x0193,0xFF91,0xFE1C,0xFDF4,0xFF3F,0x017B,0x0307,0x0205,
	0x004B,0xFF1B,0xFF54,0x000C,0x00A1,0x00DE,0x0034,0xFF28,
	0xFE35,0xFDA7,0xFD87,0xFEEF,0x012A,0x034D,0x032F,0x00A3,
	0xFD8C,0xFC3A,0xFD0F,0xFE44,0xFEDE,0xFF3E,0x0005,0xFE9D,
	0xFD67,0xFD4C,0xFD10,0xFC50,0xFB06,0xFA86,0xFBD9,0xFE88,
	0x0059,0xFF72,0xFE08,0xFCFB,0xFD1E,0xFE02,0xFEF8,0xFED6,
	0xFE32,0xFE12,0xFCE9,0xFD47,0xFF75,0x0022,0xFF58,0xFE8C,
	0xFEE2,0xFFF8,0x008C,0xFF47,0xFD95,0xFDC5,0xFFAD,0x02A1,
	0x0348,0x013B,0xFE14,0xFBE8,0xFBED,0xFEAC,0x02A8,0x0457,
	0x0348,0x002A,0xFE46,0xFEB5,0xFEFB,0xFFE2,0x00FE,0x01CA,
	0x01D8,0x00E3,0xFF45,0xFDA1,0xFCF4,0xFF2A,0x02E5,0x04E3,
	0x0366,0xFFF1,0xFCD5,0xFC35,0xFEED,0x0273,0x0448,0x03C6,
	0x0164,0xFEB7,0xFCD3,0xFD9E,0xFFA7,0x0116,0x0163,0x00F7,
	0x0066,0x001E,0xFF74,0xFE72,0xFE87,0x0048,0x0150,0x00D4,
	0xFF6B,0xFE87,0xFEDD,0xFFAC,0x0081,0x0149,0x0116,0xFFF1,
	0xFF11,0xFEA0,0xFEE9,0xFF66,0xFFF4,0xFFD1,0x0015,0x0083,
	0x00A1,0x0000,0xFF1F,0xFEFD,0xFFE8,0xFFFA,0xFF04,0xFE82,
	0xFE9C,0xFFD3,0x00F8,0x017A,0x018D,0x00A4,0xFF3A,0xFDD3,
	0xFDF0,0xFE9F,0xFF49,0xFF27,0xFE26,0xFD95,0xFD9F,0xFBF5,
	0xFAA1,0xFB64,0xF951,0xF851,0xF78F,0xF6AE,0xF613,0xF68E,
	0xF743,0xF7E1,0xF840,0xF78A,0xF6C6,0xF5F9,0xF540,0xF522,
	0xF52F,0xF573,0xF53E,0xF529,0xF499,0xF39E,0xF2A1,0xF1AC,
	0xF168,0xF163,0xF09C,0xEFD6,0xEF21,0xEE69,0xEDD8,0xED58,
	0xED3E,0xECA9,0xEC1E,0xEB5A,0xEB11,0xEA6C,0xE9D7,0xE975,
	0xE923,0xE924,0xE895,0xE87B,0xE869,0xE847,0xE74B,0xE6B0,
	0xE709,0xE73C,0xE747,0xE6DC,0xE6D1,0xE6B4,0xE6AD,0xE67A,
	0xE67B,0xE682,0xE6C4,0xE707,0xE773,0xE9C4,0xE9EA,0xE980,
	0xE963,0xE9A4,0xEA07,0xEA06,0xEA5D,0xE9D8,0xE9FF,0xEA64,
	0xEADF,0xEB7C,0xEB83,0xEBD8,0xEBC7,0xEBFA,0xEC53,0xECB4,
	0xECCD,0xEDC5,0xEEEF,0xEEC7,0xEEA7,0xEF57,0xEFCA,0xEF6B,
	0xEF96,0xF00A,0xF059,0xF0A7,0xF166,0xF20A,0xF25F,0xF2AB,
	0xF348,0xF41A,0xF423,0xF447,0xF491,0xF472,0xF4CD,0xF555,
	0xF61A,0xF662,0xF5C3,0xF56A,0xF74B,0xF7E0,0xF7D4,0xF87E,
	0xF8D1,0xF91D,0xF9C7,0xF9D1,0xF99C,0xFA04,0xFAA9,0xFB53,
	0xFADE,0xFA7B,0xFB1C,0xFB79,0xFBEB,0xFC8E,0xFD38,0xFD94,
	0xFD69,0xFD94,0xFE21,0xFE65,0xFF30,0xFFC5,0xFFB4,0x001F,
	0x00EB,0x0150,0x0173,0x01ED,0x0270,0x0297,0x02DD,0x0350,
	0x0366,0x03EF,0x0413,0x0471,0x04D5,0x0510,0x0583,0x05B8,
	0x05DA,0x0602,0x05FE,0x0662,0x06E2,0x06FE,0x072C,0x0777,
	0x07B3,0x080C,0x0878,0x0843,0x0808,0x0830,0x08D2,0x0964,
	0x0921,0x090B,0x093F,0x0971,0x0991,0x0A36,0x0A71,0x0A3D,
	0x0A79,0x0A93,0x0A86,0x0AE9,0x0BB5,0x0B64,0x0C01,0x0D5E,
	0x0B64,0x0BE2,0x0C21,0x0BC1,0x0B89,0x0C07,0x0BC1,0x0C69,
	0x0CC1,0x0CAE,0x0C9E,0x0C9F,0x0CD7,0x0D1C,0x0DD5,0x0D92,
	0x0D35,0x0CFA,0x0D30,0x0D79,0x0DCA,0x0DD6,0x0D86,0x0DD4,
	0x0DD6,0x0DE1,0x0DE5,0x0DD0,0x0DCD,0x0D7F,0x0D6E,0x0E09,
	0x0E41,0x0DDB,0x0D85,0x0D1A,0x0D16,0x0D3A,0x0D29,0x0D2C,
	0x0D0D,0x0CBE,0x0CBC,0x0D1D,0x0D28,0x0D05,0x0D17,0x0D3D,
	0x0D3C,0x0D66,0x0D7A,0x0D69,0x0D16,0x0C8E,0x0CE4,0x0D22,
	0x0D22,0x0D00,0x0CD6,0x0C6E,0x0C45,0x0C48,0x0B53,0x0952,
	0x0A13,0x0A24,0x0A7B,0x0AA8,0x0AC8,0x0A9B,0x0A3E,0x09FE,
	0x0A87,0x0A59,0x0A58,0x0A7C,0x0A33,0x0A02,0x0A41,0x0A3D,
	0x0ADE,0x0A9A,0x09BC,0x0A50,0x0B0A,0x0ACF,0x0AA8,0x0A91,
	0x0ABC,0x0A65,0x0A81,0x0AA5,0x0AB0,0x0AAD,0x0A6B,0x0A7C,
	0x0AA2,0x0A70,0x0AC5,0x0AFB,0x0A9E,0x0A66,0x0AA9,0x0AF2,
	0x0ABF,0x0A7E,0x0B3D,0x0B1C,0x0A01,0x09D7,0x099E,0x0967,
	0x095B,0x096A,0x0924,0x0972,0x0989,0x09B9,0x0A8F,0x0A48,
	0x0A2B,0x0A49,0x0A2E,0x0A3D,0x0A2A,0x0A0B,0x0A09,0x09FF,
	0x0993,0x094D,0x0962,0x095A,0x09BE,0x09C2,0x0935,0x0935,
	0x08D7,0x0873,0x083C,0x0849,0x07CF,0x07F3,0x0818,0x0793,
	0x0748,0x071A,0x06D9,0x0710,0x06BF,0x06AB,0x06AA,0x0667,
	0x06D5,0x069C,0x0684,0x06D3,0x066A,0x05F2,0x0639,0x0644,
	0x0637,0x064D,0x0605,0x05D6,0x05C8,0x061B,0x0657,0x0659,
	0x05F4,0x060D,0x05A4,0x057D,0x058B,0x0586,0x055A,0x0579,
	0x0519,0x0511,0x0562,0x04F4,0x0498,0x04D6,0x04A2,0x02AA,
	0x0470,0x04A8,0x044D,0x0470,0x042D,0x03DC,0x03F1,0x03CB,
	0x03CF,0x03AB,0x0336,0x033E,0x02DA,0x02FB,0x033B,0x032B,
	0x030E,0x034C,0x0334,0x0357,0x031D,0x02BF,0x02AC,0x02A3,
	0x0310,0x031F,0x0351,0x033F,0x02D6,0x0278,0x0266,0x0241,
	0x0256,0x01F4,0x0230,0x01FC,0x019C,0x01CD,0x01ED,0x0219,
	0x01E9,0x018E,0x0190,0x0183,0x0165,0x0142,0x0111,0x00F6,
	0x015C,0x0147,0x014D,0x0137,0x014B,0x015E,0x00F1,0x00F5,
	0x00B9,0x00FE,0x012E,0x0162,0x02B6,0x0452,0x0334,0x02AE,
	0x02A2,0x029A,0x02A2,0x023E,0x01C0,0x01ED,0x01B4,0x01B2,
	0x01B1,0x0217,0x01D8,0x0212,0x01BD,0x0151,0x011E,0x00E0,
	0xFFC8,0x0040,0x002E,0x0062,0x0061,0x00F7,0x01E8,0x0363,
	0x0399,0x042E,0x045E,0x04DC,0x058E,0x05F5,0x0701,0x08C2,
	0x09D5,0x0ABE,0x0AB7,0x0AB6,0x0B78,0x0BA8,0x0B9D,0x0B67,
	0x0AEC,0x0976,0x0953,0x09D1,0x0A34,0x0A4F,0x0AAE,0x0AD5,
	0x0A64,0x0B1E,0x0C6B,0x0D9C,0x0E18,0x0E0C,0x0E60,0x0E6F,
	0x0EA4,0x0ED7,0x0FFA,0x11BB,0x10AB,0x1029,0x0FF3,0x0EF3,
	0x0DA5,0x0CF1,0x0D8F,0x0E7D,0x0FDD,0x119E,0x1295,0x1373,
	0x135E,0x136D,0x1408,0x14F5,0x1614,0x1702,0x1785,0x17CD,
	0x179E,0x16E5,0x16B8,0x1708,0x187F,0x19C3,0x19C2,0x1AC9,
	0x1B8D,0x1BCF,0x1B5A,0x1B31,0x1BB4,0x1C6B,0x1C4F,0x1C91,
	0x1CAB,0x1BE1,0x1AD0,0x1A58,0x19DD,0x1990,0x18F8,0x188F,
	0x1802,0x17F4,0x1782,0x168A,0x1663,0x15FD,0x154B,0x1400,
	0x123C,0x10D9,0x100D,0x0F99,0x0E72,0x0D52,0x0C35,0x0B5F,
	0x0A0C,0x0925,0x090F,0x0954,0x0879,0x076A,0x072F,0x0717,
	0x0714,0x0672,0x056A,0x0501,0x04B8,0x0404,0x0321,0x0372,
	0x03D7,0x03AE,0x02FA,0x022B,0x0209,0x024F,0x02EA,0x0360,
	0x03D0,0x039C,0x031D,0x01DB,0x0134,0x00E7,0x016F,0x018A,
	0x015C,0x0166,0x017D,0x00A9,0x003F,0xFFBC,0xFF80,0xFF85,
	0x0093,0xFF18,0xFF06,0xFFBB,0xFD7C,0xFBE0,0xFBBE,0xFBA4,
	0xFBDE,0xFB2D,0xFA1B,0xF90E,0xF82B,0xF7C5,0xF771,0xF688,
	0xF5AE,0xF59E,0xF616,0xF59E,0xF477,0xF415,0xF3C5,0xF2E0,
	0xF213,0xF1EC,0xF24C,0xF272,0xF234,0xF2B4,0xF2E2,0xF2A6,
	0xF1A4,0xF0CB,0xF17B,0xF210,0xF12B,0xF01E,0xF044,0xF1D1,
	0xF253,0xF1D9,0xF140,0xF178,0xF183,0xF0F2,0xF108,0xF324,
	0xF51E,0xF50E,0xF335,0xF0C5,0xEF08,0xEEE8,0xEFBC,0xF228,
	0xF471,0xF4DB,0xF365,0xF13E,0xF002,0xF016,0xF0D1,0xF3A8,
	0xF411,0xF3F6,0xF3EF,0xF3DF,0xF3A1,0xF2D9,0xF14A,0xEF5F,
	0xEE15,0xEE2C,0xEFE2,0xF28C,0xF3FF,0xF2F5,0xEFF4,0xEDC7,
	0xECD6,0xED43,0xEE28,0xF018,0xF205,0xF197,0xEF02,0xED13,
	0xEC1E,0xEC02,0xED2C,0xEDE1,0xEF1B,0xF116,0xF19A,0xF061,
	0xEF9F,0xEE94,0xEE8E,0xEE5A,0xEE17,0xEED3,0xF0A0,0xF25D,
	0xF130,0xEF0C,0xEE32,0xEEBC,0xEE8C,0xEFCA,0xF210,0xF311,
	0xF300,0xF15A,0xF047,0xF01A,0xF09E,0xF11A,0xF11F,0xEFFC,
	0xEF12,0xF025,0xF1A9,0xF11B,0xF03A,0xF01E,0xF096,0xF162,
	0xF220,0xF295,0xF22E,0xF0DE,0xEF99,0xEEDD,0xEFD2,0xF12A,
	0xF1CA,0xF061,0xEE11,0xECB1,0xED4C,0xEE7D,0xEE97,0xECB6,
	0xE8A3,0xE236,0xDB38,0xD57D,0xD367,0xD4B8,0xD669,0xD881,
	0xDAB8,0xDD1B,0xDFB9,0xE207,0xE474,0xE82C,0xEBF2,0xEEE0,
	0xF136,0xF348,0xF453,0xF425,0xF2B5,0xF262,0xF372,0xF5AD,
	0xF98F,0xFDEE,0x032D,0x073A,0x09CB,0x0CA9,0x0F6A,0x1291,
	0x14CC,0x15DF,0x1670,0x1679,0x1536,0x1335,0x1100,0x0E01,
	0x0D0C,0x0C16,0x090F,0x0AB6,0x0C3B,0x0C7E,0x0BA3,0x09BC,
	0x07A8,0x05F0,0x03C6,0x0228,0x0085,0xFDE1,0xFA73,0xF619,
	0xF239,0xEF3F,0xED59,0xEBDA,0xEAC8,0xEA5A,0xEB21,0xEC1E,
	0xEC8C,0xED33,0xEDA7,0xED55,0xEC3C,0xEC37,0xED18,0xEE93,
	0xEF2E,0xEE3D,0xED46,0xEC81,0xECCF,0xEEB3,0xF1F0,0xF55B,
	0xF7F3,0xF9C7,0xFB77,0xFCBE,0xFE69,0x0053,0x0296,0x03F3,
	0x0484,0x050D,0x056E,0x05F9,0x05A0,0x050A,0x0558,0x05E3,
	0x06E5,0x0785,0x085B,0x09DC,0x0A38,0x0993,0x07BC,0x0613,
	0x03CD,0x020A,0x01DA,0x00EC,0xFFE6,0xFE0B,0xFBD6,0xF95E,
	0xF7B7,0xF70E,0xF717,0xF75C,0xF752,0xF6B3,0xF5D8,0xF4EB,
	0xF42F,0xF3B1,0xF30B,0xF0D2,0xEF3D,0xF022,0xF16C,0xF224,
	0xF278,0xF2E1,0xF35A,0xF40F,0xF5BD,0xF6C3,0xF792,0xF6FB,
	0xF531,0xF462,0xF54B,0xF807,0xFBE7,0xFF13,0x001C,0x005F,
	0xFFA7,0xFF89,0x004C,0x0166,0x03D9,0x055B,0x0650,0x0740,
	0x07BA,0x06FF,0x0533,0x03AD,0x02A5,0x0361,0x058A,0x0928,
	0x0BED,0x0B8E,0x0981,0x0742,0x04B7,0x0307,0x0306,0x053F,
	0x079C,0x07A3,0x0624,0x0483,0x0376,0x0162,0xFE84,0xFC2B,
	0xFCA7,0xFDCD,0xFDFE,0xFDDF,0xFD39,0xFC5A,0xFA23,0xF711,
	0xF463,0xF4EA,0xF836,0xFCB8,0xFEB8,0xFE17,0xFC6B,0xF9E8,
	0xF790,0xF757,0xF96F,0xFCDE,0xFF07,0xFDE0,0xFB66,0xFB3D,
	0xFC37,0xFC5C,0xFC7A,0xFDD6,0x004E,0x0186,0x0214,0x0491,
	0x0671,0x05B7,0x0192,0xFD87,0xFCA6,0x0064,0x05BB,0x08D7,
	0x0876,0x06E8,0x03CF,0xFF81,0xFD91,0x001B,0x05A1,0x08BE,
	0x067C,0x018A,0x02E0,0x02A1,0xFFB8,0xFE66,0xFF62,0x00F0,
	0x0087,0xFEED,0xFE7F,0xFFF0,0x00F7,0xFFAD,0xFCDC,0xFABC,
	0xF983,0xF6FC,0xF225,0xECF4,0xE663,0xDE29,0xD522,0xCE5E,
	0xCDDE,0xD235,0xD7CB,0xDD1F,0xE1A9,0xE59B,0xE942,0xEC76,
	0xF0DA,0xF644,0xFB83,0xFE21,0xFF0A,0xFF71,0xFFB2,0xFF7D,
	0xFFB0,0x01E8,0x0563,0x0AA0,0x1112,0x1888,0x1FE7,0x261D,
	0x29BC,0x2BC0,0x2DE7,0x3056,0x323B,0x32E8,0x3222,0x2FA3,
	0x2BF7,0x276B,0x22FB,0x208A,0x1FDB,0x1FC9,0x20A8,0x2158,
	0x20D7,0x1FCB,0x1DC5,0x1AAB,0x16A6,0x12DF,0x0EBF,0x0A79,
	0x05D6,0x0114,0xFC07,0xF5EF,0xF05D,0xEC60,0xEA12,0xE997,
	0xEA40,0xEA25,0xEA2F,0xEB4C,0xEB4F,0xEA5C,0xEA0F,0xE9F9,
	0xE9C3,0xE9FD,0xE9A8,0xE9B3,0xE9A9,0xE96E,0xE9CE,0xEB4C,
	0xEDE3,0xF1EF,0xF669,0xF9F2,0xFD3B,0x0093,0x037E,0x0640,
	0x0961,0x0B92,0x0CC7,0x0D0F,0x0C4F,0x0D56,0x0E97,0x0F75,
	0x0FBA,0x1053,0x1149,0x11E4,0x1268,0x1293,0x1319,0x13B5,
	0x143C,0x1318,0x1073,0x0E2E,0x0BDE,0x0902,0x061E,0x0358,
	0x01C5,0x0023,0xFE15,0xFB20,0xF93E,0xF821,0xF772,0xF6CD,
	0xF686,0xF541,0xF324,0xF19A,0xF094,0xEFF4,0xEF24,0xEDB9,
	0xEC11,0xEA79,0xE945,0xE90C,0xEAE4,0xED25,0xEEDA,0xEFD1,
	0xF070,0xF0FA,0xF171,0xF315,0xF5CF,0xF7DB,0xF808,0xF791,
	0xF8EE,0xFBDB,0xFDFA,0xFDF2,0xFDC9,0x0000,0x0298,0x03EC,
	0x04EB,0x076F,0x0AA6,0x0BF6,0x0CAC,0x0C1E,0x0B14,0x0969,
	0x08D0,0x08E2,0x0979,0x0A06,0x0A94,0x0B1C,0x09F4,0x06DD,
	0x052F,0x01BD,0x012B,0x03F1,0x06B6,0x0845,0x0637,0x017F,
	0xFC72,0xF8F7,0xF719,0xF825,0xF9F1,0xFA68,0xF896,0xF575,
	0xF36D,0xF486,0xF65E,0xF6DA,0xF6F5,0xF729,0xF787,0xF6BA,
	0xF597,0xF533,0xF5C7,0xF5A3,0xF535,0xF5CC,0xF8EA,0xFD1C,
	0xFD97,0xFBDD,0xFA7E,0xFAC8,0xFB9B,0xFD95,0x016E,0x05B3,
	0x06A5,0x03AB,0x00B5,0x003B,0x025D,0x0480,0x05C2,0x05D9,
	0x06DA,0x07C2,0x07CC,0x07D6,0x08E4,0x0A68,0x0A09,0x068E,
	0x04BF,0x06C2,0x089F,0x0837,0x05B5,0x042B,0x02F7,0x011A,
	0xFEDC,0x000A,0x0246,0x024B,0x0013,0xFC60,0xFA27,0xFB0E,
	0xFCFE,0xFC61,0xF947,0xF5F9,0xF392,0xF07D,0xEC53,0xE762,
	0xE0C9,0xD842,0xCF76,0xC917,0xCA47,0xD155,0xD843,0xDCF7,
	0xDF9F,0xE20C,0xE4FA,0xE919,0xEF48,0xF647,0xFB7E,0xFDE3,
	0xFDEA,0xFDFB,0xFF09,0x00FD,0x02FE,0x0506,0x0821,0x0D1D,
	0x141F,0x1CC2,0x2476,0x2A6C,0x2D79,0x2CEF,0x2D7D,0x3092,
	0x3451,0x3625,0x357E,0x3180,0x2C9B,0x27CD,0x2497,0x2410,
	0x246E,0x2401,0x2381,0x2171,0x1F97,0x1EFA,0x1DE0,0x1B3A,
	0x1701,0x1253,0x0D8B,0x08B7,0x046E,0x00B6,0xFC38,0xF605,
	0xEFDB,0xEB18,0xE8B5,0xE8A3,0xE9F2,0xEB4C,0xEB2F,0xEA3D,
	0xE92B,0xE88A,0xE8C1,0xEA17,0xEB15,0xEA50,0xE947,0xE968,
	0xEA65,0xEBCD,0xED5B,0xEF50,0xF193,0xF451,0xF74C,0xFBCB,
	0x0197,0x06AE,0x08FE,0x09FC,0x0B38,0x0CD9,0x0F2E,0x115C,
	0x12A3,0x132E,0x12C2,0x1265,0x12AA,0x1377,0x1502,0x169A,
	0x1775,0x173E,0x16C1,0x1765,0x1805,0x1702,0x14CF,0x1285,
	0x0DAA,0x0B89,0x0AB5,0x0839,0x06DA,0x0460,0x0092,0xFCB6,
	0xFA61,0xF99F,0xF999,0xF9E8,0xF84A,0xF588,0xF2E8,0xF1A6,
	0xF1A3,0xF268,0xF20D,0xF0A6,0xEE6F,0xEBE8,0xE977,0xE97F,
	0xEC7D,0xEF5F,0xEFC4,0xEE1A,0xEDBB,0xEFF8,0xF275,0xF543,
	0xF961,0xFDE8,0xFECD,0xFCB7,0xFB95,0xFDF2,0x007F,0x001F,
	0xFEFD,0x00B2,0x03AB,0x0590,0x062D,0x06EB,0x0951,0x0AFC,
	0x0AEE,0x0B24,0x0C9C,0x0F44,0x106E,0x0ECD,0x0C55,0x0AC6,
	0x099B,0x085B,0x07CA,0x0971,0x0A94,0x0867,0x05FB,0x01B1,
	0x0025,0x01B0,0x03CD,0x04F3,0x03F8,0x0273,0xFF2D,0xFC24,
	0xFA6D,0xF9B6,0xF8AD,0xF5AA,0xF36A,0xF292,0xF3F6,0xF59A,
	0xF63F,0xF540,0xF46D,0xF407,0xF3C7,0xF56C,0xF95A,0xFB90,
	0xFA86,0xF871,0xF7FE,0xF90A,0xFA35,0xFAB0,0xF9EF,0xF8D9,
	0xF8A8,0xF9CC,0xFCC0,0x00EC,0x04CE,0x0665,0x045F,0x01B2,
	0x00EB,0x0254,0x0545,0x071E,0x086D,0x09AE,0x08D3,0x064E,
	0x04FB,0x05D6,0x0747,0x0766,0x060A,0x04C0,0x03DC,0x041D,
	0x0576,0x05BD,0x0337,0x0023,0xFD59,0xFBBA,0xFB43,0xFC37,
	0xFCFD,0xFCBD,0xFADD,0xF886,0xF7F7,0xF8C9,0xF981,0xF855,
	0xF4AB,0xEF22,0xE8BF,0xE193,0xD9EB,0xD233,0xCBF4,0xC817,
	0xC78B,0xCB19,0xD1E0,0xD89E,0xDE1D,0xE167,0xE418,0xE7C0,
	0xED5E,0xF402,0xF95B,0xFC45,0xFCC9,0xFB6D,0xFA12,0xFB12,
	0xFD83,0x01B6,0x06DC,0x0C53,0x127D,0x19C3,0x207C,0x2680,
	0x2B60,0x2E5A,0x2F95,0x3059,0x311B,0x311D,0x3006,0x2CF1,
	0x2874,0x23A5,0x1F88,0x1D52,0x1D0A,0x1DC6,0x1D7E,0x1DD8,
	0x1CC7,0x190F,0x17ED,0x1592,0x128D,0x0ECB,0x09DD,0x0427,
	0xFF33,0xF9B9,0xF4C1,0xEFEC,0xEB60,0xE7BC,0xE57B,0xE52C,
	0xE691,0xE8DB,0xE9D0,0xE999,0xE87F,0xE802,0xE84F,0xE923,
	0xE9B5,0xE9AE,0xE94B,0xE8FB,0xE922,0xE9F2,0xEB57,0xED76,
	0xF03C,0xF3ED,0xF93C,0xFDFB,0x021D,0x05F6,0x0912,0x0AD9,
	0x0C17,0x0DA0,0x0FB6,0x11A4,0x1206,0x1212,0x11A0,0x10DA,
	0x10A0,0x115E,0x12F3,0x14A2,0x160E,0x1689,0x16B8,0x16B2,
	0x15D3,0x13B3,0x113A,0x0F4C,0x0D8F,0x0B16,0x07C2,0x038B,
	0xFF90,0xFD0C,0xFA65,0xF8DE,0xF80C,0xF74D,0xF653,0xF561,
	0xF407,0xF29F,0xF17E,0xF03C,0xF001,0xEECF,0xEC6D,0xEAB1,
	0xE901,0xE8DA,0xE8D2,0xE957,0xEB80,0xEDC4,0xEF24,0xF0C7,
	0xF20A,0xF303,0xF342,0xF427,0xF5A1,0xF97B,0xFDB7,0xFFDC,
	0x005B,0x0045,0xFFFF,0x005B,0x01D7,0x0346,0x0557,0x083A,
	0x0B1F,0x0B8C,0x0A9F,0x0BF1,0x0E1A,0x0EEE,0x0E2F,0x0C72,
	0x0BE3,0x0C9A,0x0D0B,0x0D9A,0x0EDB,0x0E92,0x0A6C,0x04EE,
	0x02CD,0x053D,0x07DE,0x07D8,0x06D9,0x0591,0x0281,0xFEE0,
	0xFDDC,0x0059,0x025A,0x0063,0xFC65,0xF940,0xF81D,0xF837,
	0xF77F,0xF6C5,0xF704,0xF6E9,0xF6EF,0xF641,0xF683,0xF78F,
	0xF685,0xF462,0xF418,0xF726,0xFBEE,0xFE75,0xFD7B,0xFA37,
	0xF783,0xF7AB,0xFA38,0xFEDA,0x0286,0x03BE,0x0284,0x014A,
	0x014B,0x0300,0x058F,0x062C,0x0565,0x0524,0x057E,0x079A,
	0x0B32,0x0DA1,0x0C7D,0x0789,0x028E,0x01A0,0x05B9,0x0AF0,
	0x0D61,0x0C5A,0x097C,0x05B6,0x02D1,0x02CA,0x053F,0x05BA,
	0x02D4,0x01B9,0xFE36,0xFC5A,0xFE0A,0xFF3F,0xFEAD,0xFB2B,
	0xF658,0xF3A6,0xF3A0,0xF4B0,0xF3D3,0xEF12,0xE631,0xD9E7,
	0xCED0,0xC8E3,0xC960,0xCE4F,0xD3E4,0xD857,0xDBA4,0xDE26,
	0xE17F,0xE63F,0xEBE4,0xF16C,0xF589,0xF99E,0xFD12,0xFF20,
	0x0075,0x0010,0xFF68,0xFEFD,0x0189,0x0766,0x0FBA,0x1887,
	0x2041,0x25D8,0x27EC,0x291D,0x2B18,0x2EE4,0x3294,0x3490,
	0x3471,0x31DF,0x2D4F,0x2824,0x23F6,0x214C,0x1FA1,0x1E22,
	0x1D31,0x1D28,0x1D87,0x1CF0,0x1B31,0x19C5,0x1657,0x1165,
	0x0D83,0x0A93,0x0794,0x032E,0xFCB3,0xF572,0xEF4D,0xEB19,
	0xE8C4,0xE801,0xE811,0xE8BF,0xE945,0xE8E0,0xE859,0xE86B,
	0xE85D,0xE879,0xE98A,0xE9B0,0xE929,0xE8FB,0xE994,0xE963,
	0xE9EC,0xEB07,0xED1D,0xF01D,0xF42A,0xF86E,0xFCF7,0x00FC,
	0x0428,0x0706,0x0928,0x0AED,0x0C6B,0x0E18,0x0F2E,0x1008,
	0x108D,0x0FA3,0x0F96,0x1125,0x117A,0x11E6,0x133F,0x149C,
	0x15C7,0x1603,0x15BE,0x14EE,0x12B7,0x0FD8,0x0D09,0x0B1A,
	0x095C,0x0635,0x02D0,0xFF80,0xFC8C,0xFA1F,0xF822,0xF636,
	0xF4E0,0xF48C,0xF431,0xF284,0xF045,0xEEF8,0xEE48,0xED71,
	0xEC90,0xECEC,0xEE1A,0xEDC0,0xEBDA,0xE95B,0xE731,0xE6E6,
	0xE86C,0xEBF9,0xEFC5,0xF214,0xF1CA,0xF066,0xEFBA,0xF167,
	0xF540,0xF843,0xF9FB,0xFB91,0xFCA1,0xFD56,0xFEF2,0x01A0,
	0x039E,0x0408,0x0418,0x04E1,0x0635,0x075B,0x07C5,0x0824,
	0x08B7,0x0964,0x09E3,0x0BB2,0x0CDE,0x0BE2,0x082D,0x0592,
	0x04AE,0x0438,0x048D,0x05AF,0x05DB,0x030B,0xFF36,0xFF3D,
	0xFD1C,0xFD58,0xFDD0,0xFBED,0xFAD5,0xF9B9,0xF8F1,0xF8F8,
	0xF935,0xF8E1,0xF65F,0xF253,0xEF80,0xEF2B,0xF1BA,0xF509,
	0xF7C6,0xF8DD,0xF779,0xF3E2,0xF06B,0xEFF1,0xF20E,0xF600,
	0xF8F2,0xFBFA,0xFD34,0xFB7D,0xF7BC,0xF542,0xF75A,0xFC18,
	0xFFB9,0x00D6,0x02F6,0x04D4,0x045C,0x020F,0x0108,0x020D,
	0x0438,0x05B9,0x06F2,0x08E6,0x0AA9,0x0B1A,0x093B,0x06C9,
	0x04C0,0x03C8,0x03D7,0x043A,0x059A,0x0729,0x077D,0x067E,
	0x0427,0x023B,0x016C,0x0172,0x0198,0x01DF,0x00B8,0xFD89,
	0xFBC5,0xFB76,0xFB8A,0xF9D5,0xF5DE,0xF248,0xEFCE,0xEDA8,
	0xEB24,0xE7C3,0xE268,0xDA34,0xD017,0xC819,0xC712,0xCC5E,
	0xD4C2,0xDBF6,0xDED3,0xE169,0xE3B4,0xE5DF,0xE950,0xEFCF,
	0xF67A,0xFACE,0xFD3C,0xFDEC,0xFE12,0xFEE7,0x0041,0x0242,
	0x062E,0x0B97,0x1295,0x1A77,0x2240,0x2846,0x2BB0,0x2C60,
	0x2D2D,0x2FF8,0x3220,0x33AF,0x33B8,0x316E,0x2D92,0x287A,
	0x239F,0x2150,0x215C,0x2204,0x216C,0x2090,0x1FE0,0x1E8B,
	0x1CB0,0x1A7F,0x16BC,0x124D,0x0DE9,0x092B,0x0450,0x0004,
	0xFBCF,0xF6A2,0xF0CB,0xEBDC,0xE8F5,0xE80D,0xE8BB,0xEA1F,
	0xEAEF,0xEA07,0xE8C9,0xE824,0xE83F,0xE8F1,0xE982,0xE98F,
	0xE9AA,0xE93B,0xE8ED,0xE9BA,0xEB37,0xED4D,0xEF4B,0xF206,
	0xF553,0xF955,0xFE3B,0x02C4,0x060D,0x0837,0x090D,0x0A56,
	0x0C10,0x0DFB,0x0FEB,0x111F,0x11A7,0x1156,0x10E7,0x1118,
	0x124B,0x1368,0x1497,0x156F,0x167F,0x168D,0x15A2,0x13F9,
	0x11B8,0x0F3A,0x0D66,0x0B5C,0x098D,0x079B,0x05D5,0x00E7,
	0xFE4A,0xFCB6,0xF9AC,0xF91B,0xF8B7,0xF870,0xF842,0xF686,
	0xF2ED,0xF033,0xEF52,0xEFB3,0xF088,0xF027,0xEDDB,0xEA9C,
	0xE843,0xE802,0xE9BF,0xEBE6,0xEDDC,0xF05B,0xF1C1,0xF2B4,
	0xF3F7,0xF5C7,0xF6E2,0xF6AE,0xF623,0xF790,0xFA2F,0xFD99,
	0x00F3,0x0305,0x0428,0x040E,0x0383,0x03F3,0x05A1,0x0770,
	0x08BD,0x0A64,0x0C04,0x0D69,0x0DA3,0x0C1A,0x09E3,0x08DB,
	0x08D7,0x0867,0x0847,0x09A4,0x0B13,0x09DD,0x05EC,0x0296,
	0x01FF,0x0365,0x03CD,0x02F1,0x02C8,0x0455,0x01A2,0xFDEB,
	0xFBF9,0xFBFF,0xFC81,0xFA6D,0xF78C,0xF7A3,0xF951,0xFA79,
	0xFA3D,0xF8F1,0xF6AC,0xF424,0xF34A,0xF445,0xF646,0xF788,
	0xF5AB,0xF434,0xF4CA,0xF5E6,0xF7D2,0xFA2A,0xFBA6,0xFCD0,
	0xFD18,0xFCA5,0xFE1B,0xFFD9,0x0164,0x01D8,0x00F5,0xFED3,
	0xFE69,0x0001,0x0220,0x03D0,0x04E1,0x049C,0x03CF,0x0387,
	0x0496,0x06F8,0x08E1,0x0A77,0x0A4B,0x082B,0x05D1,0x038B,
	0x0175,0x0024,0x0103,0x0293,0x01B0,0xFF70,0xFED4,0xFEFF,
	0xFD13,0xF9F5,0xFA8C,0xFD5A,0xFE1E,0xFCB0,0xFBC9,0xFB90,
	0xF989,0xF504,0xEF64,0xEADE,0xE717,0xE1ED,0xDB1F,0xD42B,
	0xCED3,0xCB65,0xCA24,0xCC74,0xD2F0,0xDA16,0xE00C,0xE3C9,
	0xE6E9,0xEAA9,0xEE9B,0xF17B,0xF4A1,0xF815,0xFAA0,0xFB2E,
	0xFAE5,0xFC03,0xFED4,0x0282,0x06AE,0x0BFB,0x12C1,0x1A23,
	0x209D,0x262A,0x2AFD,0x2DD5,0x2EEB,0x2F23,0x2F05,0x2EB6,
	0x2DB8,0x2B66,0x2845,0x24C2,0x21D5,0x1F63,0x1E09,0x1DA6,
	0x1DF2,0x1D82,0x1C90,0x1B5B,0x1903,0x1528,0x1261,0x0E9C,
	0x0810,0x03B2,0xFE49,0xF932,0xF479,0xF04F,0xEC56,0xE91F,
	0xE6A6,0xE558,0xE5CA,0xE741,0xE854,0xE857,0xE87E,0xE7B1,
	0xE6B0,0xE572,0xE573,0xE67F,0xE776,0xE721,0xE701,0xE736,
	0xE866,0xEAC9,0xEDD8,0xF1E7,0xF6A3,0xFB29,0xFE92,0x01AC,
	0x0441,0x067C,0x088B,0x0A54,0x0BC7,0x0C9B,0x0D95,0x0E7D,
	0x0F17,0x0F66,0x103E,0x110C,0x1196,0x12B1,0x1405,0x1509,
	0x1581,0x152E,0x1413,0x129D,0x1075,0x0E64,0x0C85,0x0A2A,
	0x078F,0x0461,0x0175,0xFF02,0xFD33,0xFB89,0xF89A,0xF610,
	0xF591,0xF493,0xF2F4,0xF1E3,0xF123,0xEFA9,0xED78,0xEB46,
	0xEA68,0xEAB7,0xEBE2,0xECCC,0xEC4B,0xEA9C,0xE976,0xE9A0,
	0xEB17,0xEC60,0xEE04,0xF0ED,0xF336,0xF413,0xF572,0xF7B4,
	0xF9F2,0xFC05,0xFD10,0xFCC6,0xFC82,0xFE7A,0x023F,0x056A,
	0x0640,0x0679,0x0775,0x0865,0x090E,0x0A4C,0x0C26,0x0D9C,
	0x0E17,0x0E09,0x0F14,0x0E44,0x0C38,0x09E1,0x07A7,0x06FF,
	0x0823,0x0A12,0x0B4D,0x0B2B,0x080C,0x044B,0x01AB,0x013E,
	0x0271,0x03A5,0x0381,0x0235,0xFF16,0xFAC2,0xF7FD,0xF7F1,
	0xF929,0xF8F7,0xF74A,0xF5D4,0xF62A,0xF680,0xF669,0xF5EF,
	0xF5A4,0xF571,0xF593,0xF508,0xF627,0xF8DD,0xFA08,0xF96A,
	0xF7D4,0xF6E7,0xF69D,0xF769,0xF939,0xFC8E,0xFFBF,0x0102,
	0x00F6,0x0190,0x0319,0x04AA,0x047F,0x038D,0x02F4,0x039F,
	0x0475,0x0577,0x07AC,0x0924,0x0839,0x0597,0x038B,0x0445,
	0x06C1,0x0884,0x0892,0x078D,0x062B,0x050B,0x0496,0x0524,
	0x05B9,0x0571,0x0371,0x0087,0xFF22,0xFFFB,0xFFD0,0xFE9D,
	0xFFF1,0xFDA5,0xFAE7,0xF9E7,0xFA1D,0xFA14,0xF882,0xF4DF,
	0xEFDF,0xEA8C,0xE688,0xE454,0xE429,0xE5F3,0xE7AB,0xE877,
	0xE962,0xEBE1,0xEF5D,0xF2A6,0xF553,0xF79B,0xFA3D,0xFCB8,
	0xFE87,0xFFB5,0x0079,0x00D5,0x007B,0x00E4,0x02A5,0x0588,
	0x0938,0x0CE5,0x104C,0x12E7,0x14B8,0x168A,0x18CF,0x1AAD,
	0x1BC3,0x1C82,0x1C95,0x1B21,0x18F2,0x16E7,0x1526,0x1386,
	0x1227,0x1189,0x1122,0x1101,0x1060,0x0F81,0x0EBB,0x0D87,
	0x0C15,0x09DC,0x0837,0x06D7,0x061E,0x0384,0xFF14,0xFC1A,
	0xFA2D,0xF827,0xF5BA,0xF4F4,0xF496,0xF415,0xF3E5,0xF40C,
	0xF4A8,0xF4BA,0xF467,0xF470,0xF4A1,0xF4AF,0xF492,0xF3C4,
	0xF302,0xF3B8,0xF3A8,0xF41D,0xF5E3,0xF8D3,0xFACE,0xFBE7,
	0xFD25,0xFE5C,0xFFE8,0x01CA,0x0393,0x05C5,0x0756,0x0833,
	0x07A1,0x0721,0x070C,0x077A,0x07FB,0x0857,0x0936,0x0A21,
	0x0A6A,0x09BB,0x08A4,0x0910,0x09BD,0x09AB,0x0974,0x0971,
	0x07FE,0x05BE,0x0398,0x015E,0xFFB2,0xFDFD,0xFCAA,0xFBE2,
	0xFA61,0xF935,0xF831,0xF795,0xF707,0xF64D,0xF57A,0xF447,
	0xF3DF,0xF42D,0xF437,0xF3A5,0xF352,0xF2DC,0xF1B4,0xF08F,
	0xF07A,0xF1A3,0xF243,0xF2B3,0xF35F,0xF431,0xF549,0xF679,
	0xF72F,0xF81C,0xF9B9,0xFAF5,0xFBA2,0xFBF7,0xFC57,0xFCFA,
	0xFDA9,0xFE69,0xFE6B,0xFFA9,0x00CD,0x00B2,0x0155,0x0242,
	0x032D,0x0408,0x0448,0x044A,0x0414,0x0404,0x03F4,0x03C6,
	0x03A2,0x0282,0x0216,0x013F,0x00B9,0x0045,0x004F,0x00AC,
	0x00C3,0xFFD0,0xFEF4,0xFE15,0xFCCB,0xFBF7,0xFD97,0xFB99,
	0xFB3D,0xFAFD,0xF9B1,0xF8BA,0xF86E,0xF849,0xF7A9,0xF775,
	0xF803,0xF842,0xF83F,0xF86C,0xF874,0xF949,0xF970,0xF940,
	0xF90E,0xF925,0xF975,0xF9C6,0xF9B9,0xF996,0xFA07,0xFA29,
	0xF9CC,0xF999,0xF971,0xF90C,0xF936,0xF8B0,0xF7BD,0xF74F,
	0xF6E3,0xF66A,0xF645,0xF5D4,0xF598,0xF551,0xF4EB,0xF4C2,
	0xF4B3,0xF538,0xF50E,0xF50B,0xF4E1,0xF46E,0xF43E,0xF3BA,
	0xF367,0xF35E,0xF357,0xF2B3,0xF228,0xF1B9,0xF143,0xF09F,
	0xF047,0xEFE1,0xEF79,0xEF32,0xEE79,0xED67,0xEB00,0xEA4C,
	0xE9F5,0xE938,0xE905,0xE8CC,0xE8E5,0xE8F2,0xE845,0xE82E,
	0xE817,0xE7F9,0xE7CB,0xE7EA,0xE7DF,0xE7E4,0xE7DA,0xE86B,
	0xE858,0xE74E,0xE7AD,0xE8A7,0xE85E,0xE892,0xE8FD,0xE95E,
	0xE970,0xE98A,0xE9A8,0xE9B4,0xE9F3,0xEA34,0xEAF6,0xEB5F,
	0xEB5F,0xEB1E,0xEB78,0xEBBE,0xEBE4,0xEC67,0xECB9,0xED66,
	0xEDB4,0xEF15,0xEF63,0xEE92,0xEE9D,0xEF0E,0xEF61,0xEFBF,
	0xF05C,0xF0B3,0xF171,0xF20A,0xF2C0,0xF36F,0xF39A,0xF3C3,
	0xF4BA,0xF506,0xF568,0xF5F8,0xF698,0xF6AF,0xF6B5,0xF704,
	0xF7F0,0xF8A4,0xF8D9,0xF8EE,0xF97A,0xF9BD,0xF9CD,0xFA63,
	0xFA84,0xFAF9,0xFB4D,0xFB95,0xFBE8,0xFC47,0xFD04,0xFD8B,
	0xFDD0,0xFE21,0xFE35,0xFEC7,0xFF33,0xFFC0,0xFFDD,0xFFD6,
	0x000C,0x0080,0x0093,0x00C1,0x0107,0x013C,0x0192,0x0201,
	0x01FE,0x0261,0x02C8,0x032E,0x032D,0x0359,0x03AD,0x03E5,
	0x042A,0x0495,0x051B,0x0568,0x05CC,0x0648,0x061D,0x067F,
	0x06CF,0x0716,0x0740,0x0733,0x077E,0x085E,0x06A2,0x07D2,
	0x0961,0x0871,0x08BD,0x0959,0x099D,0x0991,0x09E3,0x0A91,
	0x0ACA,0x0AD1,0x0AB3,0x0B0F,0x0B6A,0x0BAA,0x0BA4,0x0BCB,
	0x0BD2,0x0BBC,0x0BE3,0x0C37,0x0C54,0x0C94,0x0C91,0x0CF8,
	0x0D14,0x0CD2,0x0CE1,0x0CAE,0x0CD3,0x0CCD,0x0CEC,0x0D81,
	0x0D65,0x0D5E,0x0D31,0x0D26,0x0D80,0x0D9B,0x0D71,0x0DAD,
	0x0DDC,0x0DD6,0x0D9D,0x0DCF,0x0E08,0x0DFC,0x0DDB,0x0E13,
	0x0E6A,0x0EB3,0x0E86,0x0E0E,0x0DF8,0x0E39,0x0EB8,0x0E9E,
	0x0E63,0x0E75,0x0EB6,0x0F74,0x117D,0x10CE,0x108A,0x106B,
	0x106C,0x103D,0x103E,0x0FD8,0x0F98,0x0FAE,0x0FBC,0x0F78,
	0x0F63,0x0F55,0x0F5D,0x0EFD,0x0EC3,0x0E63,0x0E22,0x0D85,
	0x0E31,0x0E86,0x0DCE,0x0CEB,0x0D23,0x0D45,0x0CC4,0x0D3A,
	0x0D1E,0x0D56,0x0D2D,0x0CCF,0x0CB3,0x0CB0,0x0C0C,0x0C61,
	0x0C57,0x0C9E,0x0C70,0x0BCF,0x0B9A,0x0B96,0x0B30,0x0BA5,
	0x0BBA,0x0A40,0x0A86,0x0B5D,0x0B3D,0x0AD6,0x0AF6,0x0AC7,
	0x0AFA,0x0B0A,0x0ADE,0x0A68,0x097C,0x0958,0x08F1,0x0872,
	0x0821,0x086A,0x08B8,0x08F5,0x082B,0x07DC,0x07BD,0x0761,
	0x079A,0x0790,0x07DC,0x0825,0x07E4,0x07FB,0x0836,0x0769,
	0x076D,0x07BF,0x079F,0x0780,0x0798,0x076F,0x0766,0x06E2,
	0x067D,0x06A8,0x06E8,0x06D8,0x066D,0x061E,0x0632,0x0614,
	0x05DB,0x059C,0x059B,0x0593,0x0592,0x054E,0x053C,0x04C5,
	0x04A6,0x04B7,0x047E,0x0414,0x040B,0x044E,0x042B,0x03DA,
	0x03AD,0x03E5,0x03FC,0x03A4,0x0394,0x039B,0x03B0,0x0445,
	0x0418,0x03ED,0x03E1,0x03D9,0x0323,0x0476,0x04D1,0x0366,
	0x03F8,0x035C,0x0386,0x0380,0x038A,0x038A,0x03F5,0x0433,
	0x0442,0x0407,0x03DC,0x03B1,0x03E3,0x0432,0x0414,0x0425,
	0x0421,0x0440,0x0423,0x0429,0x03CC,0x03B8,0x0365,0x038C,
	0x03C9,0x038A,0x0397,0x032B,0x033B,0x035E,0x0350,0x0315,
	0x02AF,0x020F,0x0241,0x0265,0x0223,0x0238,0x026D,0x0265,
	0x022B,0x021A,0x01BA,0x01FD,0x01EE,0x01FE,0x0217,0x0231,
	0x0226,0x0233,0x0228,0x023F,0x0213,0x01E7,0x0183,0x0167,
	0x0199,0x01AC,0x01B5,0x0175,0x00E9,0xFF14,0xFE03,0xFED7,
	0x002E,0x0072,0x00C3,0x01B9,0x0219,0x0284,0x0368,0x0443,
	0x0583,0x0606,0x05C1,0x0560,0x0554,0x0582,0x064B,0x069D,
	0x072F,0x0764,0x070D,0x0829,0x075E,0x0622,0x061E,0x06E9,
	0x07AD,0x0815,0x0860,0x08ED,0x08AF,0x08F2,0x09B7,0x0AF6,
	0x0B8D,0x0CC8,0x0E58,0x0FD2,0x10EC,0x10F7,0x1069,0x108C,
	0x1116,0x11C7,0x1285,0x13B9,0x14BB,0x148A,0x13E3,0x13EF,
	0x1520,0x16BE,0x1725,0x1794,0x1808,0x187D,0x190A,0x191B,
	0x18CE,0x192A,0x18F7,0x1822,0x17D2,0x1893,0x1A11,0x1A73,
	0x190A,0x1771,0x166C,0x16D8,0x17F7,0x18DE,0x1915,0x18DD,
	0x1811,0x168B,0x1567,0x1528,0x1522,0x151C,0x1522,0x1556,
	0x1530,0x1450,0x13BA,0x13B9,0x13C0,0x1379,0x136A,0x1326,
	0x137E,0x1386,0x1309,0x121D,0x1162,0x1094,0x1122,0x1096,
	0x0EE3,0x1081,0x0F97,0x0EEA,0x0F37,0x0F4B,0x0F60,0x0FA8,
	0x0F22,0x0E05,0x0D02,0x0C7A,0x0C49,0x0D1E,0x0D05,0x0BEC,
	0x0AD3,0x0A24,0x09DA,0x0990,0x08CD,0x089D,0x08DA,0x08E0,
	0x0818,0x0759,0x06C2,0x052B,0x0407,0x0409,0x048C,0x04E6,
	0x04C5,0x03FF,0x027D,0x00E2,0x0011,0x004D,0x00A3,0x0071,
	0x0075,0x005A,0xFFCB,0xFF38,0xFEA3,0xFE75,0xFD65,0xFC51,
	0xFBC7,0xFB73,0xFBEF,0xFC8D,0xFD2C,0xFD3A,0xFC10,0xF97B,
	0xF76A,0xF7BC,0xF989,0xFAC9,0xFAEE,0xFCF5,0xFD78,0xFB07,
	0xF895,0xF7D7,0xF92B,0xFA80,0xFA1E,0xF8ED,0xF865,0xF956,
	0xF985,0xF89E,0xF6D2,0xF684,0xF648,0xF594,0xF5B8,0xF68E,
	0xF6AE,0xF53D,0xF3C2,0xF2E5,0xF359,0xF57E,0xF6A3,0xF587,
	0xF42E,0xF378,0xF1D0,0xF0D4,0xF19F,0xF340,0xF332,0xF0EE,
	0xEF76,0xEF96,0xF0EE,0xF14B,0xF04B,0xEFD4,0xEFD5,0xEF3E,
	0xEE69,0xEF24,0xEFDE,0xEF56,0xEEF8,0xEDE2,0xEDC9,0xEEC6,
	0xEF9B,0xEFB7,0xEFC7,0xEFFA,0xEF1C,0xEDC3,0xEC83,0xEC78,
	0xED97,0xEEB0,0xEF36,0xEE82,0xEDA7,0xEC9E,0xEB85,0xEA6B,
	0xEB3A,0xED93,0xEF5E,0xEF9D,0xEFA6,0xEEB4,0xED40,0xEC2D,
	0xEBB5,0xEC4C,0xECF7,0xEDA1,0xEDB7,0xEDE8,0xEF92,0xF07B,
	0xEF3A,0xED4A,0xED25,0xEE26,0xEED0,0xEF64,0xF085,0xF0D7,
	0xEF95,0xED3E,0xEB77,0xEC26,0xEDD7,0xEEC7,0xEED4,0xEF8F,
	0xEF96,0xEEF4,0xEE52,0xEE8E,0xEECE,0xEF83,0xF027,0xF05E,
	0xF13E,0xF2F3,0xF26A,0xF04A,0xED19,0xEC69,0xED20,0xEDCB,
	0xEF13,0xF175,0xF33A,0xF3C6,0xF2B3,0xF117,0xF02A,0xF234,
	0xEFC9,0xF004,0xF287,0xF4D5,0xF641,0xF54D,0xF2E4,0xF112,
	0xEF9E,0xEE67,0xEFAA,0xF35C,0xF7F3,0xF922,0xF712,0xF3B1,
	0xF128,0xEFFA,0xF075,0xF25D,0xF5D9,0xF8A6,0xF820,0xF635,
	0xF517,0xF4D9,0xF4F6,0xF53F,0xF560,0xF5FD,0xF67B,0xF61F,
	0xF603,0xF714,0xF7F8,0xF6DD,0xF53B,0xF3E1,0xF43A,0xF6B0,
	0xF99A,0xFACF,0xFA77,0xF8FD,0xF801,0xF6FF,0xF678,0xF72F,
	0xF8BB,0xF81A,0xF680,0xF5FC,0xF73F,0xF88B,0xF94A,0xF953,
	0xF91E,0xF954,0xF994,0xF933,0xF861,0xF8CE,0xF8F2,0xF6F9,
	0xF5E9,0xF5E0,0xF746,0xF7F9,0xF6E2,0xF57C,0xF649,0xF892,
	0xF8E1,0xF84F,0xF86C,0xF94B,0xF9EE,0xF964,0xF89A,0xF93C,
	0xFA8E,0xFA5C,0xF7F4,0xF76A,0xF87A,0xF8DD,0xF967,0xFB4F,
	0xFD7E,0xFD44,0xFBED,0xFAC6,0xFA00,0xFA95,0xFBFE,0xFC3A,
	0xFB34,0xFABD,0xFB2F,0xFBBD,0xFBD2,0xFC79,0xFDCE,0xFEA6,
	0xFE87,0xFD28,0xFCB8,0xFD53,0xFD24,0xFD3C,0xFC9A,0xFB5B,
	0xFBD2,0xFD04,0xFD9C,0xFC6C,0xFBA4,0xFC7E,0xFE76,0x0037,
	0x0114,0x025C,0x02A0,0x00D4,0xFD57,0xFA5D,0xF984,0xFB54,
	0xFF45,0x027A,0x0407,0x036E,0xFFDF,0xFC34,0xFB02,0xFD03,
	0xFF94,0x01BC,0x0371,0x0377,0x0298,0x012F,0xFF4C,0xFD69,
	0xFCE8,0xFD83,0xFE98,0x00AA,0x0246,0x0252,0x00AC,0xFE84,
	0xFCB4,0xFC81,0xFE17,0x00C1,0x0292,0x0374,0x0289,0x01E8,
	0x0190,0x00D3,0x004A,0xFFD5,0xFE84,0xFD3A,0xFD12,0xFDF3,
	0xFF18,0xFEE0,0xFDD0,0xFE13,0xFF27,0x0143,0x0461,0x056B,
	0x0381,0xFF84,0xFD40,0xFD1E,0xFDCF,0xFFC4,0x0101,0xFDA0,
	0xFD37,0xFDAE,0xFDAB,0xFFC9,0x013E,0x00D4,0xFFEB,0xFEFE,
	0xFF49,0x0144,0x037D,0x03F8,0x0305,0x00C8,0xFF90,0xFF3A,
	0xFF61,0xFF50,0xFE35,0xFDB7,0xFD4D,0xFC29,0xFCFD,0xFFDD,
	0x0381,0x048F,0x0396,0x0216,0x0033,0xFF76,0xFFBC,0xFF33,
	0xFDF7,0xFE28,0xFF35,0xFF9D,0xFF1E,0xFE2C,0xFDA0,0xFCC5,
	0xFC2D,0xFDAF,0x0281,0x0600,0x063F,0x032B,0xFF42,0xFD03,
	0xFD5F,0xFF01,0x0205,0x03EB,0x02A1,0xFEF6,0xFB2F,0xF8EA,
	0xF9E7,0xFD55,0xFFC2,0x005E,0x0227,0x05E5,0x0501,0x0251,
	0x00BE,0x0131,0x0268,0x011C,0xFF2E,0xFF1C,0xFFEB,0xFF1B,
	0xFD48,0xFBAD,0xFC86,0xFFEA,0x01E6,0x02A2,0x039D,0x04F2,
	0x03B5,0x0126,0xFF2E,0xFFA7,0x0207,0x035A,0x0143,0xFEB5,
	0xFE57,0xFDD9,0xFC14,0xFC36,0xFF53,0x0312,0x043C,0x02AD,
	0x025C,0x0264,0x020E,0x002C,0xFE68,0xFE30,0xFF1B,0x0035,
	0x013A,0x00D2,0xFE5D,0xFC6F,0xFCEB,0xFDD3,0xFF7C,0x022C,
	0x053F,0x0715,0x060F,0x02E1,0x0044,0xFEA7,0xFD02,0xFAFB,
	0xF941,0xF9DB,0xFDD8,0x0048,0x002D,0xFE47,0xFD1E,0xFCE4,
	0xFBC9,0xFBD6,0xFE1D,0x0124,0x0251,0x0153,0xFFD9,0xFFC9,
	0xFF62,0xFCB4,0xF9E1,0xF9E9,0xFC34,0xFF08,0x00C0,0x0007,
	0xFEA7,0xFC8F,0xFB0F,0xFAA1,0xFBF4,0xFF2F,0x01F1,0x0201,
	0xFF8A,0xFD57,0xFDFC,0xFEBC,0xFDFF,0xFD32,0xFD30,0xFCC5,
	0xFAE0,0xF968,0xFA90,0xFDEF,0x002F,0xFF0A,0xFCDA,0xFC44,
	0xFE32,0xFF66,0xFF94,0xFE77,0xFDF7,0xFD02,0xFBB4,0xFB83,
	0xFF49,0x0253,0x01AC,0xFE9C,0xFD3C,0xFCBE,0xFE86,0xFF10,
	0xFE05,0x00DB,0x0153,0xFFCA,0xFD31,0xFC22,0xFCAD,0xFE91,
	0xFFCB,0x0157,0x0313,0x03D9,0x023C,0xFEF6,0xFCDD,0xFD1F,
	0xFF56,0xFFB6,0xFE6D,0xFE78,0x004B,0x00D5,0xFEE1,0xFD54,
	0xFEDB,0x0150,0x0066,0xFFE4,0x0278,0x05AD,0x0490,0x001A,
	0xFD4B,0xFE5B,0xFFA9,0xFED4,0xFF7F,0x0215,0x03E0,0x0207,
	0xFF82,0x002A,0x0219,0x01AD,0xFF46,0xFEAD,0x0168,0x040C,
	0x04BC,0x0374,0x0263,0x0141,0xFE58,0xFA87,0xFA1C,0xFF01,
	0x0406,0x048D,0x0211,0x00EF,0x01C6,0x00CD,0xFDCC,0xFD82,
	0x0176,0x02DE,0x0130,0xFF3D,0xFED7,0xFDDE,0xFB16,0xF97D,
	0xFB38,0xFE92,0x0067,0x017B,0x0289,0x02B1,0x0088,0xFD2E,
	0xFC74,0xFE26,0x000D,0x0364,0x05DC,0x062C,0x0470,0x0022,
	0xFC10,0xFB63,0xFDFB,0x0151,0x04B1,0x06B5,0x06B6,0x03F3,
	0xFF35,0xFC5D,0xFC01,0xFE8E,0x0268,0x0652,0x072D,0x058A,
	0x01CC,0xFDBE,0xFCAF,0xFC83,0xFFA0,0x030B,0x04D3,0x04DC,
	0x0384,0x02AB,0x01D7,0x0132,0x00B6,0x01D3,0x0330,0x0435,
	0x05CC,0x0680,0x0551,0x0215,0xFE54,0xFD65,0x0054,0x03F8,
	0x061A,0x0699,0x0657,0x0597,0x026B,0xFF86,0xFFC0,0x01C9,
	0x0368,0x0477,0x05EC,0x06CC,0x0677,0x03E4,0x00D2,0xFE98,
	0xFEC6,0x00DC,0x02D8,0x0524,0x0772,0x088F,0x0705,0x0308,
	0x001A,0xFF12,0xFECA,0xFF26,0x0144,0x0480,0x0618,0x052B,
	0x0237,0xFE85,0xFBFD,0xFC13,0xFE70,0x01FD,0x0448,0x04EB,
	0x04DF,0x0328,0x014E,0x010D,0x0118,0x0173,0x0187,0x019B,
	0x0177,0x00E2,0x001D,0x0016,0x010A,0x01A5,0x0036,0xFE84,
	0x017D,0x0240,0x0205,0x01E5,0x025D,0x02DC,0x0213,0x00BA,
	0x00B7,0x0169,0x0165,0x0168,0x014A,0x01DF,0x024E,0x0116,
	0xFEFD,0xFE21,0xFF0F,0x008E,0x0230,0x0328,0x032E,0x0159,
	0xFEF3,0xFD30,0xFE18,0x00F0,0x0450,0x0656,0x0571,0x01DD,
	0xFE73,0xFD17,0xFE34,0x00BA,0x029A,0x032B,0x0264,0x0026,
	0xFCF3,0xFB24,0xFC12,0xFE89,0x0003,0x0026,0x0092,0x0249,
	0x0327,0x00D6,0xFE5D,0xFE09,0xFF4A,0xFF91,0xFF31,0x003D,
	0x0281,0x02B7,0xFFEA,0xFD03,0xFE59,0x00B4,0x0240,0x042C,
	0x05A9,0x0671,0x0557,0x016C,0xFCD0,0xFB54,0xFD40,0x0033,
	0x02DD,0x0435,0x03F7,0x0156,0xFCE7,0xFA50,0xFC88,0x0091,
	0x03DD,0x0604,0x0538,0x0355,0x00DD,0xFE21,0xFC6C,0xFC8B,
	0xFD4F,0xFDBF,0xFDCB,0xFEEE,0x0068,0xFFED,0xFC7A,0xF971,
	0xF8AB,0xFB71,0xFF43,0x0287,0x04E4,0x05E2,0x03CE,0xFFCE,
	0xFC0D,0xF8F6,0xF7A6,0xF9E5,0xFD90,0xFFC3,0x0012,0xFF3A,
	0xFD93,0xFBD6,0xF99B,0xF9FD,0xFD58,0x020E,0x0571,0x05CE,
	0x01C1,0xFCBC,0xF802,0xF5FC,0xF80B,0xFC4F,0xFFA4,0xFF18,
	0xFB9B,0xF8FF,0xF8F2,0xFA8C,0xFC7E,0xFE4F,0x0095,0x0272,
	0x025A,0x01E3,0x01F9,0x00E9,0xFD27,0xF97B,0xF7DC,0xF8D4,
	0xFB5B,0xFE2C,0xFFF2,0xFF98,0xFDA0,0xFBC3,0xFB0E,0xFBCD,
	0xFEA2,0x0224,0x0362,0x00DB,0xFD81,0xFC8D,0xFC22,0xFB72,
	0xFB34,0xFB6A,0xFB8A,0xFB94,0xFC06,0xFCDC,0xFDE2,0xFE7B,
	0xFE34,0xFD6C,0xFDB7,0xFF1F,0x019F,0x02C9,0x01CD,0xFEFD,
	0xFCE5,0xFA9B,0xF9A4,0xFBE8,0xFE2B,0xFFAD,0x027D,0xFF97,
	0xFCD2,0xFBA4,0xFBF0,0xFE6F,0x0183,0x0283,0x00FC,0xFF66,
	0xFDC3,0xFD8D,0xFD9B,0xFF05,0xFFE5,0xFF9A,0xFCDD,0xFA95,
	0xFBE9,0xFEC0,0x017D,0x02D9,0x02A9,0x00C6,0xFE0D,0xFC46,
	0xFC92,0xFE17,0xFF09,0xFEE4,0xFDC0,0xFCE1,0xFD0A,0xFF94,
	0x020F,0x0249,0x0012,0xFDEC,0xFDE9,0xFFE2,0x0269,0x03AB,
	0x0149,0xFD96,0xFB99,0xFBB1,0xFDA4,0x0073,0x0350,0x0409,
	0x0179,0xFE3D,0xFE7B,0x010B,0x032A,0x03CD,0x02C7,0x0268,
	0x01AC,0x00E0,0x00D1,0x021F,0x0204,0xFE16,0xF95B,0xF8FF,
	0xFB40,0xFEA2,0x00BC,0x0104,0x0132,0x00AD,0xFFCC,0xFF97,
	0x00E0,0x01D6,0x0054,0xFE29,0xFD80,0xFEEF,0x00DF,0x01F3,
	0x02E1,0x0207,0x0063,0xFF16,0xFF02,0x0004,0x0178,0x026A,
	0x031B,0x03DE,0x02C8,0x0110,0x004F,0xFF5D,0xFE89,0xFEB3,
	0x0010,0x01BD,0x0311,0x03DB,0x03D4,0x01DE,0xFFDC,0xFFAE,
	0x019A,0x044B,0x0538,0x03D1,0x029E,0x0150,0x004F,0x0044,
	0x01E0,0x02B3,0x007E,0xFE19,0xFE62,0x002B,0x01E8,0x0336,
	0x0450,0x048A,0x0477,0x0452,0x0512,0x064F,0x0664,0x0421,
	0x009C,0xFF9D,0x0154,0x0354,0x02FE,0x0191,0x0046,0xFF8A,
	0xFED6,0xFF33,0x0096,0x02DB,0x03D3,0x0301,0x02AD,0x0405,
	0x057B,0x05E6,0x038C,0xFFE4,0xFD35,0xFC88,0xFDD3,0xFFA1,
	0x00AF,0x014E,0x018E,0x006D,0xFFE9,0x0105,0x0351,0x04ED,
	0x0557,0x0561,0x04A6,0x02E3,0x01CF,0x00B1,0xFF5F,0xFDB0,
	0xFCAA,0xFDE2,0x00F1,0x0320,0x0460,0x042F,0x02EC,0x01A5,
	0x0151,0x03A5,0x0738,0x0908,0x07B2,0x0314,0xFB61,0xF942,
	0xFB13,0xFE9B,0x022B,0x02EE,0x01B1,0x008F,0xFF01,0xFEC9,
	0x0152,0x0462,0x053C,0x038F,0x018F,0x0000,0xFF62,0xFFE2,
	0x0022,0xFEDC,0xFCBB,0xFBF4,0xFCC8,0xFF2F,0x01E8,0x02C8,
	0x011D,0xFE99,0xFCB5,0xFD06,0x0064,0x047A,0x058F,0x0337,
	0xFEF9,0xFC34,0xFB17,0xFB3F,0xFE19,0x0168,0x0207,0xFFD5,
	0xFEB2,0xFF72,0xFF92,0xFDE4,0xFD3B,0xFE7E,0x0023,0xFFFB,
	0xFFCF,0x016D,0x0244,0xFFBA,0xFC03,0xFB60,0xFD43,0xFEC2,
	0xFF91,0x0050,0x0183,0x01EB,0x0127,0xFE33,0xFE47,0x01C4,
	0x03A6,0x032C,0x025C,0x02F3,0x026E,0xFFB8,0xFD02,0xFD55,
	0x0042,0x0272,0x017B,0x003B,0x009B,0x00A7,0xFE9A,0xFCF5,
	0x00FC,0x04F3,0x039F,0x004A,0xFFE3,0x010C,0x0006,0xFE22,
	0xFD25,0xFE56,0xFFCE,0xFFFF,0x00A9,0x02FC,0x03D9,0x00B5,
	0xFBFB,0xF9DC,0xFB3E,0xFECD,0x023C,0x055D,0x0679,0x0480,
	0xFF51,0xF8EA,0xF7E4,0xFCCF,0x01AE,0x0517,0x061F,0x0589,
	0x0299,0xFE4C,0xFB01,0xF9A4,0xF9AB,0xFB72,0xFE35,0x0000,
	0x0009,0xFE62,0xFB40,0xF850,0xF866,0xFB6E,0xFEAD,0x0146,
	0x02B0,0x0124,0xFCA1,0xF770,0xF545,0xF707,0xFA4E,0xFD8D,
	0xFFCF,0x00D1,0xFF3C,0xFC8D,0xF948,0xF8E0,0xFB92,0xFE87,
	0xFFD1,0xFEF6,0xFE4E,0xFD6A,0xFB9F,0xF9C1,0xFA09,0xFBF7,
	0xFDED,0xFE6C,0xFEC9,0xFF0D,0xFD9B,0xFACF,0xF883,0xF805,
	0xFABC,0xFF0E,0x01EE,0x028D,0x018C,0xFF62,0xFD37,0xFBC8,
	0xFB20,0xFBFF,0xFD8C,0xFE86,0xFDDD,0xFBE4,0xFAEA,0xFBA3,
	0xFBD6,0xFCE9,0xFDC8,0xFECA,0xFDC4,0xFE7B,0xFE94,0xFE6B,
	0x005A,0x0035,0xFF5B,0xFD50,0xFBAD,0xFB84,0xFD17,0xFEC2,
	0xFEE6,0xFD82,0xFD0F,0xFEA2,0x00AC,0x0146,0x00B1,0xFFC6,
	0xFF02,0xFF32,0x0000,0x007B,0x013C,0x008B,0xFD9B,0xFA17,
	0xF79E,0xF89B,0xFCA5,0x008B,0x021C,0x0175,0x00BA,0xFF4B,
	0xFE8D,0xFE7E,0xFFAE,0x0239,0x0219,0xFFC3,0xFE04,0xFDA8,
	0xFED9,0xFF15,0xFDDF,0xFD75,0xFDFF,0xFDFD,0xFDF1,0x0019,
	0x02B1,0x0362,0x0258,0xFF9C,0xFD1B,0xFC2D,0xFBB6,0xFBF1,
	0xFCCD,0xFF52,0x020D,0x01DA,0xFF06,0xFBD1,0xFB2D,0xFC67,
	0xFC59,0xFD23,0xFF16,0x0090,0xFF98,0xFD78,0xFBBE,0xFA65,
	0xF987,0xF99F,0xFB4E,0xFF30,0x02B8,0x0322,0xFFE9,0xFC2F,
	0xF969,0xF95C,0xFB7A,0xFF0E,0x0296,0x042A,0x01D1,0xFD9B,
	0xFB3D,0xFBEB,0xFD5C,0xFDD8,0xFEA0,0x0172,0x03BE,0x0262,
	0xFFD7,0xFF36,0xFF93,0xFED6,0xFDBD,0xFE60,0x01F6,0x04BE,
	0x04CB,0x040E,0x01CC,0xFF8A,0xFCB7,0xFAAF,0xFB1C,0xFDAC,
	0x00AA,0x01E5,0x021A,0x0214,0x029D,0x02A2,0x0203,0x02EA,
	0x051C,0x060D,0x04C3,0x020D,0x00F0,0x0172,0x0067,0xFE0F,
	0xFD11,0xFE67,0xFFE4,0x00BE,0x02AF,0x05AC,0x06FE,0x04B1,
	0x0136,0xFF5E,0xFFB1,0x00AA,0x01B7,0x038E,0x0541,0x0426,
	0x00EC,0xFDE0,0xFDBC,0xFEAE,0xFF49,0xFEFE,0xFF80,0x0221,
	0x046B,0x0469,0x02DE,0x015A,0x0006,0xFF12,0xFEB1,0x0022,
	0x0383,0x065F,0x0633,0x01B0,0xFD11,0xFB94,0xFC88,0xFDD7,
	0x0030,0x0372,0x0593,0x043F,0x0075,0xFD22,0xFC8C,0xFD5D,
	0xFE93,0x00EB,0x054C,0x0887,0x076F,0x01E1,0xFCB9,0xFD8F,
	0xFCD5,0xFCC0,0xFE56,0x010E,0x0390,0x03F2,0x00C0,0xFD4D,
	0xFC58,0xFD7D,0xFE5F,0xFF1B,0x02B8,0x05E8,0x05A3,0x0186,
	0xFDBC,0xFD0A,0xFE7E,0xFEE7,0xFE2A,0xFEEC,0xFFE7,0xFEC7,
	0xFBD6,0xFB6C,0xFDA1,0xFF60,0xFFCA,0xFFE5,0x0142,0x0348,
	0x0348,0x00C8,0xFF8A,0xFFBA,0xFF73,0xFDD1,0xFC9F,0xFD19,
	0xFDF0,0xFD67,0xFBD6,0xFB10,0xFC8A,0xFF65,0x022E,0x0391,
	0x02AE,0x013D,0x003A,0xFF88,0xFE9F,0xFE37,0xFE0E,0xFD87,
	0xFBF8,0xFCB1,0x0010,0x0491,0x04A9,0x00B8,0xFDB9,0xFE3E,
	0x00A7,0x0427,0x0735,0x0736,0x03B4,0xFFA0,0xFC25,0xFB3D,
	0xFD10,0x0091,0x0289,0x019D,0xFF29,0xFD37,0xFBDB,0xFCDB,
	0x00DA,0x0488,0x0546,0x0376,0x0126,0xFFA0,0xFF8E,0xFF6F,
	0xFEB6,0xFE4E,0xFD99,0xFBEC,0xFA6E,0xFB10,0xFE6A,0x0093,
	0xFF90,0xFDE0,0xFDDF,0xFFAB,0x0117,0x0166,0x003E,0xFEA3,
	0xFBDA,0xFA09,0xFBF6,0xFE89,0x004D,0xFFFE,0xFC35,0xF880,
	0xF7B3,0xFB25,0xFF51,0x00C9,0x00B2,0x003D,0xFF43,0xFD70,
	0xFC7D,0xFC6E,0xFC20,0xFAF3,0xF9CC,0xFA08,0xFA78,0xFA6E,
	0xFA9F,0xFACD,0xFAA1,0xFA00,0xFA23,0xFD1B,0x00B7,0x02A7,
	0x02B7,0x01F2,0xFF05,0xFABD,0xF72C,0xF6C9,0xF949,0xFCDE,
	0xFE92,0xFE6C,0xFE4A,0xFDB3,0xFCB9,0xFCB7,0xFE73,0x015C,
	0x03A2,0x0456,0x038E,0x0277,0x0024,0xFC15,0xF739,0xF54F,
	0xF830,0xFCB3,0xFFC1,0x00A1,0xFF92,0xFD20,0xFB34,0xFADF,
	0xFD0A,0x0260,0x0556,0x050E,0x02D3,0xFF81,0xFC14,0xF948,
	0xF856,0xF9CB,0xFC2E,0xFE04,0xFD7B,0xFDE4,0xFC18,0xFD30,
	0xFE0B,0xFE4F,0x0076,0x02F5,0x02F8,0x00E8,0xFF1E,0xFDAD,
	0xFCFD,0xFC5E,0xFC7C,0xFD11,0xFD60,0xFBBF,0xFB0E,0xFCB8,
	0xFFA5,0x00C6,0x0002,0x005A,0x0116,0x0066,0xFEDA,0xFE89,
	0xFFE5,0x00E8,0xFF57,0xFCD3,0xFC03,0xFC39,0xFC2E,0xFB66,
	0xFC28,0xFE6C,0x0099,0x010B,0x0107,0x01FC,0x0204,0x0102,
	0x0011,0x00BC,0x02CB,0x0375,0x0136,0xFDD4,0xFB6E,0xFAEE,
	0xFA4B,0xFA3C,0xFC79,0xFF02,0x0052,0x000C,0x002D,0x0149,
	0x0235,0x022E,0x009E,0xFEC0,0xFD49,0xFBF1,0xFBDA,0xFB8C,
	0xFB4B,0xFBA1,0xFAA9,0xF989,0xFA8E,0xFDC1,0x0038,0x0014,
	0xFF75,0xFFB6,0xFFD3,0xFF00,0xFE08,0xFF3E,0x00F3,0xFF3D,
	0xFB6E,0xFAFC,0xFDA8,0xFEB3,0xFD16,0xFC45,0xFE2D,0x0053,
	0xFFF3,0xFFA5,0x0234,0x05AF,0x049F,0x0076,0xFE03,0xFEF3,
	0xFFFE,0xFFCD,0x00AB,0x02CF,0x0378,0x0162,0xFDAF,0xFCC1,
	0xFF45,0x00CB,0xFFCF,0x00C1,0x0234,0x02A4,0x0098,0xFEA3,
	0xFEEE,0x013D,0x033D,0x0400,0x0388,0x0327,0x02C7,0x0274,
	0x0115,0x0053,0x018A,0x02E0,0x0374,0x02CE,0x028C,0x0343,
	0x0324,0x01B8,0x016D,0x02AC,0x036F,0x0335,0x02D8,0x030D,
	0x0301,0x010E,0xFEEA,0xFEB7,0x0095,0x0205,0x0128,0x001D,
	0x004D,0x010A,0x00D0,0x00FF,0x0280,0x04D8,0x04EA,0x023C,
	0xFF79,0xFED8,0xFF8F,0xFFFE,0x004D,0x009A,0x002E,0xFE3A,
	0xFCA0,0xFD36,0xFFBE,0x01E0,0x0302,0x03FB,0x044C,0x0468,
	0x036A,0x01A1,0x006E,0x0004,0xFF6E,0xFEEA,0xFF4C,0x0049,
	0x00E8,0xFF83,0xFE2A,0xFEA0,0x0106,0x00B6,0x036F,0x05F3,
	0x04AE,0x0308,0x005E,0xFDCF,0xFD94,0xFF9A,0x0156,0x009A,
	0xFEA9,0xFE50,0xFF46,0xFF46,0xFF19,0xFF4F,0x0018,0x0152,
	0x0232,0x027B,0x02B0,0x02D2,0x01F6,0xFF5D,0xFDDA,0xFDBB,
	0xFEB3,0x0003,0x0055,0x0044,0xFFFA,0xFF46,0xFE2F,0xFEE9,
	0x00E4,0x02F4,0x037F,0x0350,0x01DE,0xFF7A,0xFE4D,0xFEDE,
	0xFFA4,0xFF58,0xFF80,0xFF86,0xFFAC,0xFF4A,0xFF3D,0xFFE0,
	0x00F0,0x0150,0x014C,0x01CD,0x02DB,0x021F,0xFFE3,0xFE2F,
	0xFE5E,0xFF7E,0x0126,0x033F,0x0322,0x02F2,0x0184,0x0115,
	0x01C5,0x0376,0x0511,0x0431,0x02B3,0x0153,0x00B2,0x00AE,
	0x00D3,0x008F,0x00B3,0x0035,0xFFDA,0xFFE8,0x0054,0x0214,
	0x0256,0x0017,0xFE06,0xFD91,0xFECF,0x0111,0x01E0,0x0176,
	0xFFB7,0xFE5A,0xFE02,0xFE26,0xFE36,0xFE28,0xFEA0,0xFE0D,
	0xFD26,0xFCDB,0xFE41,0xFFDB,0xFFC3,0xFDC8,0xFD49,0xFD7E,
	0xFD27,0xFE78,0xFF6F,0xFFE1,0xFFBD,0xFE4C,0xFCC6,0xFD35,
	0xFEC7,0xFF2A,0xFD66,0xFBCA,0xFBD6,0xFC9C,0xFC17,0xFBFF,
	0xFCE2,0xFD00,0xFC29,0xFB06,0xFAF8,0xFBAD,0xFC35,0xFC36,
	0xFB64,0xFB0A,0xFB94,0xFC16,0xFBA6,0xFB02,0xFA9C,0xFAE2,
	0xFB21,0xFBCB,0xFD03,0xFE06,0xFE6A,0xFDCA,0xFCFF,0xFCE7,
	0xFCBE,0xFC17,0xFC12,0xFD26,0xFD65,0xFD52,0xFD2D,0xFCF0,
	0xFC5A,0xFBB4,0xFB69,0xFCA5,0xFE2D,0xFECB,0xFE95,0xFDC9,
	0xFD2C,0xFC38,0xFAD4,0xFB38,0xFCB0,0xFD7D,0xFDCD,0xFCE5,
	0xFC2D,0xFB1E,0xFAD4,0xFB17,0xFBA2,0xFD5D,0xFEFC,0xFE65,
	0xFDD6,0xFDD4,0xFDE7,0xFC9F,0xFE14,0xFEC8,0xFE27,0xFF63,
	0xFEAE,0xFE1E,0xFDDB,0xFD80,0xFCDC,0xFDB7,0xFEA4,0xFF49,
	0xFF09,0xFE40,0xFDC6,0xFD62,0xFDA3,0xFDA9,0xFDA7,0xFDAF,
	0xFEAB,0xFEBC,0xFEDC,0xFEA2,0xFEA4,0xFDD1,0xFD43,0xFD63,
	0xFD8D,0xFE70,0xFF73,0x000A,0xFFC9,0xFF31,0xFDD5,0xFD0C,
	0xFD16,0xFDFF,0xFF16,0xFF3C,0xFEDA,0xFECC,0xFE47,0xFD36,
	0xFC95,0xFD7C,0xFE13,0xFE32,0xFE68,0xFE69,0xFE29,0xFDA0,
	0xFCCD,0xFCB3,0xFD59,0xFD70,0xFE6F,0xFF7F,0xFF72,0xFEDF,
	0xFD44,0xFC5D,0xFC71,0xFD68,0xFCEA,0xFC5E,0xFCAD,0xFC16,
	0xFB8A,0xFAD2,0xFABC,0xFB22,0xFB52,0xFAE3,0xFA5D,0xFA6B,
	0xF9F7,0xF93D,0xF90B,0xF851,0xF770,0xF6CA,0xF68B,0xF577,
	0xF565,0xF608,0xF4EA,0xF37E,0xF348,0xF3B9,0xF3C2,0xF429,
	0xF50B,0xF547,0xF528,0xF43B,0xF39F,0xF396,0xF3A1,0xF34B,
	0xF320,0xF322,0xF2D0,0xF252,0xF180,0xF0FE,0xF0CD,0xF0CA,
	0xF1A7,0xF04D,0xEF16,0xEEC6,0xEE5F,0xED9C,0xECD4,0xEC55,
	0xEC75,0xEC6F,0xEC6E,0xECD7,0xEC8F,0xEC28,0xEC36,0xEC00,
	0xEB7B,0xEBA0,0xEB9D,0xEB1B,0xEAFA,0xEAFF,0xEABB,0xEA5F,
	0xEA4D,0xEA2B,0xEA45,0xEA3C,0xEA4E,0xEA3F,0xEA2C,0xEA42,
	0xEA3E,0xE9C4,0xE9F4,0xEA6D,0xEAA4,0xEAF7,0xEB46,0xEB19,
	0xEB56,0xEB53,0xEB6E,0xEBE8,0xEC3D,0xEC89,0xECF6,0xED3F,
	0xED44,0xED73,0xED97,0xEE09,0xEE5E,0xEEEF,0xEF67,0xEFC8,
	0xF07C,0xF118,0xF18C,0xF193,0xF1C6,0xF261,0xF24F,0xF35D,
	0xF44D,0xF4AA,0xF4A8,0xF52F,0xF557,0xF56C,0xF56E,0xF646,
	0xF705,0xF77D,0xF798,0xF860,0xF7C3,0xF736,0xF976,0xF8F1,
	0xF9C9,0xFAB9,0xFAF1,0xFB73,0xFBBF,0xFC0C,0xFC4D,0xFC3F,
	0xFC85,0xFCE2,0xFD6B,0xFDE8,0xFE17,0xFE74,0xFEAA,0xFF16,
	0xFF8F,0xFFE1,0x0084,0x00E9,0x0149,0x0179,0x01CC,0x01AB,
	0x0205,0x029B,0x02AF,0x02FE,0x03A8,0x0421,0x0434,0x043D,
	0x044A,0x044A,0x04C8,0x057C,0x05F6,0x05CF,0x05A6,0x05C9,
	0x05E5,0x0649,0x0692,0x06CA,0x0722,0x0748,0x077E,0x0796,
	0x07FC,0x0810,0x080C,0x0859,0x08BE,0x091E,0x098B,0x099D,
	0x09C4,0x0A42,0x0C86,0x0D67,0x0D32,0x0D10,0x0D01,0x0C5D,
	0x0BF8,0x0C23,0x0C74,0x0CB2,0x0D04,0x0D40,0x0D86,0x0D76,
	0x0D5B,0x0DB2,0x0D90,0x0D6D,0x0D40,0x0CEB,0x0D42,0x0E8E,
	0x0E91,0x0DA3,0x0D4A,0x0DEA,0x0D80,0x0D89,0x0D9F,0x0DB4,
	0x0D9A,0x0DA1,0x0D59,0x0D7A,0x0D8D,0x0DDD,0x0DD9,0x0DCA,
	0x0DD6,0x0DB4,0x0DAD,0x0DD0,0x0D95,0x0D89,0x0E0E,0x0D8B,
	0x0C91,0x0D74,0x0DF4,0x0DAE,0x0DB9,0x0D6E,0x0D56,0x0D78,
	0x0DCE,0x0DA8,0x0D3F,0x0CEC,0x0CC6,0x0C43,0x0B23,0x0B96,
	0x0BF3,0x0BA3,0x0B8F,0x0B26,0x0AC7,0x0B00,0x0B62,0x0B7D,
	0x0B44,0x0B73,0x0B43,0x0AFF,0x0AE5,0x0B0B,0x0B52,0x0B69,
	0x0B79,0x0B1C,0x0AF5,0x0AE4,0x0AFE,0x0B13,0x0B86,0x0BD5,
	0x0B77,0x0AF1,0x0AAA,0x0A74,0x09F4,0x09F6,0x0A70,0x0ABB,
	0x0AB1,0x0A05,0x0987,0x0926,0x092B,0x0907,0x0883,0x08B8,
	0x08EE,0x08B6,0x08A9,0x085F,0x085E,0x085E,0x07FF,0x0817,
	0x08A5,0x08AC,0x08A7,0x0857,0x07F0,0x085B,0x0899,0x088C,
	0x08E0,0x0921,0x083A,0x07FC,0x09A6,0x0791,0x0824,0x0851,
	0x085A,0x0811,0x07F9,0x07B8,0x07BA,0x07BA,0x07C6,0x07E0,
	0x079E,0x07F3,0x0836,0x0894,0x0812,0x07D0,0x07B9,0x077F,
	0x0754,0x0783,0x07A5,0x07C9,0x07C2,0x0792,0x07F1,0x0776,
	0x0726,0x06D0,0x06F7,0x0734,0x06DF,0x06AA,0x06B2,0x0662,
	0x0615,0x0648,0x05E2,0x0633,0x05F1,0x05A3,0x0575,0x05DC,
	0x056F,0x0589,0x05B7,0x05CF,0x05E9,0x05BD,0x05D6,0x0588,
	0x0530,0x054E,0x054D,0x0577,0x05C0,0x058D,0x0582,0x0576,
	0x04EA,0x04AD,0x046F,0x03A0,0x023E,0x023A,0x0265,0x0219,
	0x01FD,0x0221,0x0293,0x028F,0x02AB,0x027D,0x028E,0x026D,
	0x02B0,0x02D0,0x02BE,0x02E3,0x02D4,0x0362,0x0338,0x0238,
	0x02C3,0x0370,0x02F9,0x02AE,0x030F,0x0330,0x02E4,0x0347,
	0x02FA,0x02E2,0x02B9,0x02BC,0x0353,0x0339,0x0321,0x0344,
	0x0398,0x041A,0x03CD,0x0329,0x0324,0x035D,0x0356,0x041E,
	0x0467,0x0381,0x0293,0x0271,0x0277,0x026B,0x02CC,0x0300,
	0x02E5,0x0288,0x029E,0x02EE,0x0341,0x036A,0x0400,0x0382,
	0x0351,0x0360,0x0342,0x02FC,0x02D4,0x02A2,0x0286,0x0259,
	0x02A6,0x029F,0x02AA,0x0282,0x0210,0x0206,0x0254,0x0240,
	0x022D,0x01EA,0x01E0,0x0189,0x0155,0x0185,0x0203,0x01DD,
	0x0189,0x019C,0x0112,0x00DD,0x00E6,0x00FE,0x010A,0x00A7,
	0x00A1,0x00B2,0x00B5,0x00A9,0x00DA,0x0080,0x0078,0x00AA,
	0x00A7,0x00B1,0x0095,0x0078,0x007C,0x00B0,0x0094,0x0091,
	0xFF9D,0xFF9E,0xFF96,0xFFB4,0xFF7E,0xFEA3,0xFE47,0xFE2E,
	0xFEC1,0xFFD4,0x0062,0x00D3,0x014F,0x0193,0x0227,0x037F,
	0x04D1,0x059C,0x05A6,0x060D,0x06DD,0x06EE,0x06E7,0x06D3,
	0x068B,0x06F7,0x070E,0x075C,0x078C,0x07EB,0x0815,0x0858,
	0x09A4,0x0B75,0x0B18,0x0B25,0x0BE9,0x0C89,0x0C5D,0x0CE1,
	0x0E0D,0x0F11,0x0F7A,0x1003,0x10D1,0x119F,0x1155,0x10F7,
	0x1196,0x1298,0x1357,0x132F,0x12F2,0x1539,0x1671,0x1597,
	0x14AF,0x14D2,0x1491,0x147C,0x14F5,0x152D,0x1538,0x1503,
	0x155A,0x1660,0x16C9,0x167F,0x158E,0x14FF,0x1560,0x1553,
	0x14D4,0x1466,0x13F5,0x13DC,0x144C,0x14AD,0x141E,0x1382,
	0x13E0,0x1469,0x14AD,0x142E,0x138A,0x131D,0x129B,0x1253,
	0x132C,0x135A,0x12A1,0x1182,0x0F8F,0x0F14,0x1040,0x1157,
	0x10BA,0x0F41,0x0E3B,0x0E39,0x0E66,0x0D99,0x0D2F,0x0E22,
	0x0EBB,0x0DB1,0x0CDB,0x0CF4,0x0CF6,0x0BE5,0x0A30,0x09A8,
	0x0AAC,0x0B3B,0x0A09,0x0824,0x06D0,0x063B,0x060A,0x06BA,
	0x0729,0x0728,0x0636,0x03FA,0x029B,0x02B8,0x036A,0x0277,
	0x0078,0xFF55,0xFEBC,0xFCD5,0xFA12,0xF79A,0xF6C4,0xF892,
	0xFB42,0xFC89,0xFC27,0xFA81,0xF900,0xF797,0xF81B,0xF9E4,
	0xFB1C,0xFA9A,0xF8ED,0xF8A6,0xFA76,0xFB87,0xFBB8,0xFC9F,
	0xFECA,0xFFEB,0x01D5,0xFFA0,0xFB57,0xFB94,0xFBD8,0xFD9B,
	0xFFA1,0x0095,0xFFA8,0xFD26,0xFB8A,0xFCA6,0xFEAB,0xFF2F,
	0xFD4B,0xFAC0,0xF8EB,0xF813,0xF7CA,0xF763,0xF6F5,0xF6A7,
	0xF71C,0xF694,0xF50E,0xF284,0xF098,0xF085,0xF126,0xF147,
	0xF01C,0xEE55,0xED79,0xEE1D,0xEEBB,0xEF63,0xEFB3,0xEF11,
	0xEE51,0xEE00,0xEE2E,0xEE20,0xEE82,0xEEFC,0xEF77,0xEFA8,
	0xEF63,0xF015,0xF1CB,0xF321,0xF374,0xF392,0xF2E2,0xF25D,
	0xF218,0xF277,0xF3E5,0xF4ED,0xF524,0xF472,0xF3B2,0xF3B1,
	0xF403,0xF3C7,0xF23F,0xF136,0xF14B,0xF08F,0xF0C7,0xF0A6,
	0xF0E4,0xF096,0xF07F,0xF0DA,0xF11E,0xF096,0xEF9E,0xEE65,
	0xECF5,0xEC66,0xED4C,0xEF0B,0xEFB1,0xEDF1,0xECB1,0xED40,
	0xEE6F,0xEEF3,0xEEF2,0xEF16,0xEE7A,0xED73,0xEDF7,0xEFB4,
	0xF147,0xF035,0xEE73,0xEEA1,0xF12B,0xF332,0xF3FF,0xF3E2,
	0xF250,0xF1F2,0xF2D4,0xF44C,0xF4D3,0xF5BE,0xF741,0xF5E3,
	0xF58A,0xF5DE,0xF632,0xF645,0xF6FC,0xF795,0xF72F,0xF68E,
	0xF665,0xF750,0xF74F,0xF6F0,0xF84D,0xFA3F,0xFA78,0xF7E2,
	0xF4C2,0xF4CF,0xF6DC,0xF709,0xF5A0,0xF59D,0xF5DE,0xF56F,
	0xF4BE,0xF536,0xF604,0xF61C,0xF5B4,0xF5BF,0xF582,0xF4E8,
	0xF4C3,0xF479,0xF431,0xF4AE,0xF519,0xF4E7,0xF675,0xF77E,
	0xF660,0xF505,0xF60C,0xF722,0xF72D,0xF65F,0xF667,0xF7ED,
	0xF7F4,0xF773,0xF7FA,0xF926,0xF8AA,0xF6C0,0xF71E,0xF9C7,
	0xFAAA,0xF952,0xF7A2,0xF7C4,0xF8FC,0xF965,0xF889,0xF8C1,
	0xF9CD,0xF9BC,0xF88D,0xF845,0xF967,0xFA3C,0xF8B2,0xF6BD,
	0xF75B,0xFAAB,0xFA72,0xF6F6,0xF6AF,0xF716,0xF846,0xF852,
	0xF7B5,0xF8E8,0xF9F1,0xF7B8,0xF513,0xF594,0xF88B,0xFA6A,
	0xF817,0xF603,0xF7B6,0xFA6D,0xF982,0xF699,0xF72D,0xFAB7,
	0xFBEB,0xF89F,0xF6A8,0xF90D,0xFC19,0xFAC3,0xF749,0xF8A0,
	0xFC4F,0xFD68,0xF9D6,0xF61B,0xF5FB,0xF621,0xF280,0xECCB,
	0xEA5C,0xEB82,0xEDAB,0xF024,0xF301,0xF50D,0xF561,0xF346,
	0xF204,0xF3F0,0xF62F,0xF6A4,0xF43B,0xF290,0xF46A,0xF88B,
	0xFBCA,0xFE8A,0x0181,0x04AA,0x05F2,0x05A0,0x0500,0x04C6,
	0x06E6,0x083E,0x0954,0x0B32,0x0B50,0x0A20,0x099D,0x0B8D,
	0x0E62,0x0F99,0x0E2B,0x0B13,0x0864,0x062C,0x0475,0x03AD,
	0x0371,0x02DB,0x0227,0x0152,0x0155,0x0169,0xFF58,0xFC23,
	0xFA84,0xFA0A,0xF925,0xF775,0xF472,0xF333,0xF493,0xF63C,
	0xF6ED,0xF719,0xF697,0xF6AE,0xF6A0,0xF6A4,0xF61F,0xF5F7,
	0xF610,0xF613,0xF70E,0xF98C,0xFBE9,0xFB97,0xFBA2,0xFDD7,
	0xFFC7,0x013C,0x015F,0x0088,0x0007,0xFFFD,0x0104,0x02C2,
	0x02E6,0x029D,0x02F6,0x0331,0x02AC,0x02B6,0x02C8,0x0226,
	0x00F1,0xFF8A,0xFE81,0xFED3,0xFF93,0xFF58,0xFE75,0xFD98,
	0xFD5D,0xFD69,0xFCE0,0xFBDC,0xFB32,0xF9AA,0xF86F,0xF862,
	0xF900,0xF944,0xF82F,0xF729,0xF6E6,0xF7F3,0xF93F,0xF8DF,
	0xF7AC,0xF5DB,0xF519,0xF706,0xF94D,0xF99C,0xF83E,0xF928,
	0xFAFC,0xFAF2,0xFB1E,0xFCD4,0xFE9B,0xFF09,0xFE44,0xFE4D,
	0xFF9B,0xFFEB,0xFE48,0xFE02,0x0042,0x0345,0x042A,0x024A,
	0x0137,0x0277,0x0296,0x023C,0x02C6,0x03F7,0x03F6,0x0136,
	0xFE6E,0xFFE6,0x044E,0x0222,0x0093,0xFFFF,0xFFD0,0xFFF5,
	0xFFDE,0xFDE1,0xFC2F,0xFC05,0xFD54,0xFD80,0xFBAC,0xFC65,
	0xFD90,0xFC53,0xFA70,0xFB92,0xFD60,0xFCDA,0xFAA4,0xF9AC,
	0xFACE,0xFC11,0xFBED,0xFB5A,0xFC86,0xFE3C,0xFE60,0xFC82,
	0xFC6C,0xFE93,0x0038,0xFED8,0xFD21,0xFF50,0x01DB,0x0051,
	0xFDFD,0x011C,0x0661,0x0635,0x00F9,0xFEB6,0x01FE,0x05C1,
	0x033F,0xFF95,0x01AC,0x05A1,0x03C1,0xFF0D,0x0022,0x03BB,
	0x03F0,0x013B,0xFFA9,0x024B,0x036B,0xFFC9,0xFD7A,0xFEFF,
	0x00A6,0xFF9A,0xFC9E,0xFDA5,0xFF2D,0xFCE9,0xFB02,0xFCDD,
	0x003B,0xFFB7,0xFD18,0xFC6B,0xFE97,0xFEFF,0xFD82,0xFE29,
	0x0076,0x0143,0x0011,0xFF80,0x00CF,0x0213,0x0177,0xFF38,
	0xFF9F,0x027A,0x04DF,0x03A6,0x000B,0xFE2B,0xFF01,0xFF37,
	0xFD53,0xFA23,0xF74E,0xF498,0xF2C8,0xF3F3,0xF855,0xFD1D,
	0xFE91,0xFCC7,0xFBB9,0xFB87,0xFB32,0xFBFC,0xFC75,0xFBBC,
	0xFCA3,0xFD97,0xFE7B,0x00BD,0x0490,0x0765,0x0994,0x0B4E,
	0x0CA0,0x0C89,0x0A71,0x0998,0x0AEC,0x0CE1,0x0EAD,0x0F38,
	0x0F7E,0x1011,0x10C4,0x110B,0x113C,0x11AE,0x10A7,0x0D3A,
	0x08D5,0x066E,0x064E,0x07C6,0x0883,0x07B1,0x0628,0x0485,
	0x033B,0x0245,0x021D,0x01A2,0xFFD3,0xFD0D,0xFADA,0xFA31,
	0xFA17,0xF9C7,0xF9C8,0xFB23,0xFD29,0xFE54,0xFD08,0xFA4E,
	0xF91C,0xF93B,0xFAA5,0xFC78,0xFD66,0xFDC1,0xFD12,0xFCAD,
	0xFEDC,0x0234,0x04A5,0x0542,0x051D,0x0512,0x04D7,0x03B5,
	0x0352,0x038F,0x054E,0x0747,0x08F5,0x094F,0x0854,0x06AB,
	0x06A2,0x07F5,0x078C,0x08CD,0x0753,0x038A,0x0313,0x040B,
	0x0512,0x053D,0x047C,0x0335,0x0251,0x0225,0x01DA,0x00D4,
	0xFE9F,0xFC71,0xFBE8,0xFCE5,0xFDE5,0xFDB7,0xFBFE,0xFAB6,
	0xFBB3,0xFD9F,0xFE0C,0xFC51,0xFA62,0xFAE1,0xFBD5,0xFC01,
	0xFC50,0xFE1D,0xFE81,0xFDFC,0xFE5E,0x009F,0x02B1,0x0170,
	0xFF7C,0xFF78,0x00AE,0x01D4,0x0260,0x027A,0x0108,0x007E,
	0x0306,0x05CB,0x059F,0x0370,0x01EF,0x0247,0x0438,0x050D,
	0x036C,0x00BE,0x003C,0x01E4,0x025C,0x016A,0x014C,0x0306,
	0x046E,0x0125,0x0073,0x0157,0x0077,0xFED4,0xFDBB,0xFEAB,
	0x0000,0xFF3E,0xFD09,0xFD7D,0xFE84,0xFD75,0xFB74,0xFC10,
	0xFD7B,0xFD42,0xFB7A,0xF9BC,0xFB9C,0xFE4C,0xFE56,0xFC9B,
	0xFD80,0xFFB8,0x0077,0xFE3F,0xFC38,0xFDC8,0x00A6,0x0088,
	0xFE22,0xFE7E,0x015C,0x02FD,0x004E,0xFDCE,0x0093,0x0533,
	0x0478,0x0016,0xFE33,0x008C,0x01EA,0x000F,0xFECB,0x005C,
	0x01BF,0x004A,0xFE13,0xFE26,0x00EF,0x0200,0xFFAB,0xFD0C,
	0xFCAA,0xFCF0,0xFBFE,0xFB56,0xFCCA,0xFDF2,0xFBF4,0xF976,
	0xF9E6,0xFD28,0xFDF1,0xFB00,0xF892,0xF987,0xFC0D,0xFC08,
	0xFA5A,0xFAD4,0xFCD7,0xFDFA,0xFD5C,0xFD3C,0xFE17,0xFE0E,
	0xFD1B,0xFDF4,0x000B,0x005D,0xFE7A,0xFD0F,0xFDD9,0xFF84,
	0xFF5A,0xFD9B,0xFC8D,0xFABA,0xF695,0xF304,0xF170,0xF0F6,
	0xF093,0xF11E,0xF3D6,0xF795,0xFA74,0xF964,0xF680,0xF51F,
	0xF624,0xF840,0xF910,0xF7F8,0xF72C,0xF819,0xFAB4,0xFE19,
	0x01B2,0x0402,0x054F,0x06A1,0x0742,0x0798,0x06EA,0x04E4,
	0x0340,0x0756,0x0A61,0x0B0A,0x0BCB,0x0AD9,0x0B3F,0x0D0D,
	0x0E46,0x0D61,0x0B70,0x0851,0x059E,0x040B,0x04E6,0x057B,
	0x04C9,0x03DD,0x0393,0x040D,0x03B5,0x0220,0xFFC9,0xFDEB,
	0xFD30,0xFC86,0xFA1F,0xF7F2,0xF790,0xF8A8,0xFA81,0xFBE0,
	0xFB9F,0xFA8A,0xFA8C,0xFA5D,0xFA82,0xFA86,0xF9A5,0xF8FB,
	0xFA2D,0xFCBC,0xFEAB,0xFFB3,0x001A,0x0166,0x02DE,0x049F,
	0x04D0,0x042E,0x039B,0x0381,0x03F3,0x04D3,0x061E,0x0790,
	0x08D0,0x091D,0x08C6,0x0847,0x0811,0x07AF,0x0724,0x069A,
	0x0626,0x03BE,0x0147,0x005C,0x002C,0x015F,0x0305,0x0312,
	0x016D,0xFF38,0xFCF4,0xFBC6,0xFC30,0xFCE9,0xFD17,0xFD1A,
	0xFC48,0xFB5E,0xFAEF,0xFBDD,0xFBA5,0xFB8A,0xFC76,0xFC49,
	0xFB68,0xFC42,0xFC03,0xFA55,0xFB01,0xFE63,0xFFC3,0xFF6E,
	0x001C,0x02F1,0x030F,0xFF34,0xFE61,0x034D,0x06CD,0x04B9,
	0x0162,0x0151,0x03FD,0x05CB,0x0556,0x065A,0x0747,0x0776,
	0x0603,0x049A,0x04EC,0x04FD,0x0376,0x02F4,0x0575,0x07CB,
	0x0604,0x032B,0x037C,0x0607,0x0722,0x04B9,0x016E,0x01C5,
	0x0309,0x0118,0xFEF1,0xFF7D,0x01F2,0x025C,0xFFD4,0xFDB7,
	0xFF7F,0x0289,0x01BB,0xFE9C,0xFEB3,0x0060,0xFF83,0xFDAD,
	0xFE7F,0x01C1,0x02D5,0x0033,0xFF5A,0x0210,0x03CE,0x01CC,
	0x0041,0x0196,0x03EE,0x03A5,0x018E,0x014A,0x0399,0x0487,
	0x0378,0x0317,0x049F,0x0673,0x0424,0x011C,0x0221,0x0451,
	0x0471,0x02CD,0x02BD,0x048B,0x0505,0x0279,0x0148,0x0319,
	0x04CD,0x0204,0xFE6A,0x000C,0x03CA,0x022E,0xFCC2,0xFB7E,
	0x0130,0x0325,0xFFA7,0xFDA9,0xFCAE,0xFEDA,0xFE55,0xFAFE,
	0xFBDA,0xFFA0,0xFF70,0xFBD0,0xFACD,0xFD93,0x00BB,0xFF82,
	0xFB95,0xFB6F,0xFFED,0x0248,0xFE9F,0xFA69,0xFB8E,0x002D,
	0x0151,0xFF98,0xFE98,0xFFAF,0x00AC,0xFE64,0xFB2B,0xFA45,
	0xF9A7,0xF5B3,0xEFF7,0xEDB3,0xF08A,0xF507,0xF77C,0xF839,
	0xF8E0,0xF8EE,0xF7C8,0xF66D,0xF6FE,0xF8CB,0xF901,0xF835,
	0xF7F4,0xFA30,0xFE17,0x00F9,0x02C6,0x0574,0x089F,0x09F2,
	0x086C,0x065D,0x05CC,0x0722,0x0894,0x0925,0x0AC1,0x0EF4,
	0x1007,0x0EA1,0x0E40,0x0F07,0x0FCC,0x0E77,0x0C25,0x0A57,
	0x085C,0x063C,0x04A8,0x04B9,0x05DC,0x06B2,0x062B,0x04F5,
	0x0331,0x0105,0xFE3A,0xFD0C,0xFDAF,0xFCE0,0xFAAA,0xF8F3,
	0xF824,0xF846,0xF89E,0xF9B0,0xFADF,0xFBE0,0xFB64,0xF937,
	0xF72B,0xF68E,0xF730,0xF7E9,0xF970,0xFBB2,0xFD64,0xFD72,
	0xFC90,0xFD45,0xFFD6,0x0262,0x0320,0x017D,0x0186,0x0171,
	0x0189,0x0297,0x0451,0x05C4,0x0642,0x05AF,0x056F,0x0576,
	0x0567,0x047D,0x02E2,0x0120,0x00E2,0x0095,0xFFA5,0xFED1,
	0xFE40,0xFEE7,0xFFEC,0xFF9C,0xFEA3,0xFD69,0xFB7F,0xF9EB,
	0xFA06,0xFA56,0xFA0B,0xF87D,0xF70A,0xF6BC,0xF841,0xF9AF,
	0xF9A3,0xF8CA,0xF87C,0xF858,0xF833,0xF843,0xF8B2,0xF912,
	0xF88A,0xF914,0xFB72,0xFCEE,0xFCC3,0xFB4D,0xFB41,0xFE42,
	0x00A9,0x0061,0xFE0F,0xFCCC,0xFE17,0xFF29,0xFEAE,0xFF46,
	0x0262,0x049B,0x01AE,0xFE3D,0xFF3B,0x02EB,0x02E3,0x0129,
	0x0034,0x002D,0xFF81,0xFEAB,0xFEC3,0x0004,0x012A,0x008A,
	0xFF4E,0x0046,0xFF3C,0xFF29,0xFD02,0xFA51,0xFB96,0xFF71,
	0xFF63,0xFB4A,0xF966,0xFB4B,0xFDB1,0xFD9D,0xFCC1,0xFC1E,
	0xFC0E,0xFB1C,0xFA15,0xFABE,0xFC9C,0xFE20,0xFCAB,0xFAE4,
	0xFC41,0x002D,0x0211,0x0024,0xFCE6,0xFCEE,0x0012,0x013D,
	0xFF78,0xFE6E,0xFFD2,0x01DD,0x0283,0x0189,0x0199,0x0298,
	0x028B,0x0183,0x0203,0x029D,0x0254,0x00B4,0xFF83,0x0025,
	0x0125,0x0117,0x0026,0x0020,0x011B,0x0138,0xFF8D,0xFD8C,
	0xFC37,0xFD14,0xFF3A,0xFFCA,0xFE77,0xFD8C,0xFD9B,0xFDF3,
	0xFC47,0xFABA,0xFB8A,0xFBB0,0xFBC1,0xFB6B,0xFB53,0xFA78,
	0xF9D3,0xFA0E,0xFCA5,0xFE6B,0xFD1D,0xFBE8,0xFCC2,0xFE8D,
	0xFDD1,0xFC22,0xFE0A,0xFFDF,0xFFD1,0xFFA3,0xFF1B,0xFE26,
	0xFCFF,0xFC11,0xFB31,0xF8D4,0xF5DA,0xF23F,0xF07B,0xF1B4,
	0xF563,0xF8FC,0xFB07,0xFB9C,0xFB2D,0xF9F9,0xF950,0xF97C,
	0xFA4D,0xFAEC,0xFAF4,0xFB1B,0xFD47,0xFF86,0x020A,0x055E,
	0x08A6,0x0A39,0x0A8C,0x09E7,0x0906,0x08FA,0x08FE,0x09C9,
	0x0B8F,0x0D7D,0x0EE9,0x106B,0x10E3,0x10CE,0x1141,0x118C,
	0x1076,0x0DEF,0x0AC3,0x08AC,0x07A0,0x0753,0x0732,0x0727,
	0x06A3,0x05CF,0x0595,0x0506,0x034F,0x0113,0xFF14,0xFDEF,
	0xFCE1,0xFB50,0xF9E2,0xF96A,0xF9E3,0xFAC0,0xFB8B,0xFD1A,
	0xFD6B,0xFC75,0xFA4F,0xF993,0xFACB,0xFC0F,0xFC34,0xFBCD,
	0xFCF1,0xFF07,0x0089,0x00F8,0x0132,0x0236,0x03F2,0x0442,
	0x03D1,0x035E,0x033C,0x0426,0x04E6,0x0604,0x06ED,0x0775,
	0x073D,0x06D5,0x066C,0x075E,0x08AC,0x07FE,0x0644,0x04C2,
	0x0408,0x027A,0x0444,0x041A,0x02B8,0x026A,0x01C4,0x0105,
	0x006C,0xFF88,0xFE31,0xFD37,0xFBDE,0xFB0D,0xFB2E,0xFB78,
	0xFB35,0xFB04,0xFB05,0xFAF0,0xFB00,0xFB6B,0xFB4D,0xFAA9,
	0xFA37,0xFABB,0xFB43,0xFBF7,0xFC08,0xFC6A,0xFE6C,0xFFD6,
	0xFF0B,0xFEA8,0xFFF5,0x004D,0xFF73,0xFF55,0x0156,0x02D7,
	0x01D2,0x0107,0x028A,0x04D7,0x03DE,0x0269,0x0345,0x04D3,
	0x03A8,0x015C,0x01B8,0x03A4,0x0390,0xFFD7,0xFE24,0x017D,
	0x0309,0x00FE,0xFE9C,0xFED2,0x0108,0x0112,0xFFA4,0xFF3C,
	0xFE47,0xFF07,0xFE45,0xFD43,0xFE4F,0xFF21,0xFF3D,0xFD0D,
	0xFA9A,0xFBEE,0xFEBB,0xFF43,0xFD6A,0xFBB2,0xFC88,0xFE4D,
	0xFE57,0xFBD0,0xFA9B,0xFE4D,0x027F,0x01A9,0xFE16,0xFD9C,
	0xFF68,0xFFA0,0xFEA8,0xFF17,0x0291,0x0400,0x0147,0xFF7B,
	0xFFCB,0x01EB,0x03D4,0x0252,0x00C7,0x01B5,0x0341,0x0229,
	0xFF89,0xFF6C,0x019E,0x029D,0x01DB,0xFF1A,0xFFBB,0x023E,
	0x00E4,0xFD4F,0xFC97,0xFFB8,0x00A3,0xFE0A,0xFBCC,0xFC41,
	0xFD4E,0xFC1D,0xF9CA,0xFABA,0xFD2E,0xFC26,0xF9A0,0xF907,
	0xFB15,0xFC46,0xFA55,0xF967,0xFAF1,0xFD13,0xFC92,0xFACE,
	0xFBA0,0xFD7E,0xFE18,0xFCC7,0xFC78,0xFE54,0xFEAD,0xFD28,
	0xFCCF,0xFE69,0xFE96,0xFD34,0xFBBF,0xFA92,0xF8BE,0xF4F2,
	0xF106,0xEF8F,0xF0A1,0xF26D,0xF456,0xF6C7,0xF9AD,0xFAC3,
	0xF8F7,0xF6BB,0xF63F,0xF712,0xF86A,0xF86E,0xF882,0xF986,
	0xFB4F,0xFCBA,0x0017,0x036C,0x05F8,0x06D9,0x0719,0x0796,
	0x0789,0x05F9,0x053D,0x0559,0x0792,0x0A06,0x0AFD,0x0AC5,
	0x0D78,0x0CD4,0x0BE7,0x0C54,0x0B35,0x09A5,0x07BF,0x0544,
	0x034A,0x02EA,0x0330,0x03AB,0x02CA,0x025F,0x0284,0x0230,
	0x0087,0xFD7D,0xFAAB,0xF84F,0xF776,0xF71F,0xF75E,0xF75D,
	0xF771,0xF7E8,0xF8CB,0xF94F,0xF932,0xF947,0xF8D5,0xF86F,
	0xF7E3,0xF7AA,0xF76C,0xF7BF,0xF949,0xFBE5,0xFE9B,0x00A2,
	0x008C,0xFFE6,0xFF77,0x0051,0x0257,0x02EE,0x01AD,0x003D,
	0x0109,0x033E,0x0514,0x0630,0x05D1,0x0554,0x0559,0x0517,
	0x0525,0x04EF,0x03D3,0x020C,0x00BE,0x0126,0x02B3,0x02B8,
	0xFFB8,0xFD67,0xFD78,0xFE0C,0xFE01,0xFC8B,0xFB03,0xF9F6,
	0xF8F4,0xF873,0xF877,0xF89E,0xF8B4,0xF9BF,0xFA9D,0xFAC0,
	0xFA2B,0xF9DF,0xFA03,0xF8D1,0xF931,0xFA1D,0xFA49,0xF995,
	0xF952,0xFA3E,0xFCF3,0x0024,0x0096,0xFDEB,0xFCC6,0xFEE2,
	0x015A,0x010E,0xFF7D,0x0076,0x0384,0x034B,0xFFC0,0x008A,
	0x04AF,0x062B,0x052E,0x03F7,0x030D,0x03B7,0x02D7,0x006C,
	0xFF98,0x01FE,0x04B3,0x0383,0x012B,0x018E,0x01E7,0x00E2,
	0x015A,0x0244,0x02EF,0x01F5,0xFF9B,0xFD91,0xFE28,0xFFCD,
	0xFF3E,0xFCE8,0xFE4E,0x015B,0x0121,0xFD9E,0xFC0D,0xFE5F,
	0xFFA6,0xFD62,0xFBA5,0xFEBF,0x014D,0xFE98,0xFBF4,0xFDD5,
	0x0155,0x01DB,0xFF0A,0xFE62,0x00F7,0x01D0,0x0095,0xFEFD,
	0xFFE3,0x02D7,0x0363,0x0140,0x00EF,0x02C1,0x03A0,0x0177,
	0xFED3,0x00E5,0x040C,0x0302,0x0017,0xFFD8,0x025D,0x0238,
	0xFF41,0xFE14,0x0061,0x02B3,0x01DE,0xFFBA,0xFF4E,0x0046,
	0x003B,0xFEA5,0xFCEF,0xFE51,0x003D,0xFFA3,0xFD9C,0xFD22,
	0xFCFA,0xFD86,0xFF06,0xFCD3,0xFCD5,0xFDFC,0xFD26,0xFC93,
	0xFDA2,0xFE1A,0xFE68,0xFE2E,0xFE11,0xFE2C,0xFE6D,0xFF75,
	0x0018,0xFF3B,0xFE68,0xFF79,0x00E7,0x00F8,0xFFC5,0xFEEF,
	0xFE21,0xFC03,0xF829,0xF4E2,0xF314,0xF238,0xF1C1,0xF393,
	0xF79C,0xFB3F,0xFC5E,0xFA50,0xF7E6,0xF87C,0xFA1B,0xFADF,
	0xFA55,0xF98C,0xF961,0xFA75,0xFD7B,0x00DF,0x046E,0x0700,
	0x080C,0x0836,0x081E,0x083A,0x0823,0x07DE,0x07E0,0x0924,
	0x0B82,0x0D0B,0x0D5B,0x0D28,0x0D32,0x0DFB,0x106F,0x1027,
	0x0E9C,0x0C4C,0x086B,0x056D,0x0499,0x0613,0x0817,0x081D,
	0x06D1,0x04E5,0x0263,0x00C5,0xFFB8,0xFE79,0xFDAB,0xFD0E,
	0xFB7E,0xF927,0xF84A,0xF91B,0xF942,0xFA4B,0xFC71,0xFDDF,
	0xFC4C,0xF9E5,0xF835,0xF857,0xF9A2,0xFA90,0xFBAA,0xFCC3,
	0xFDD6,0xFF26,0xFFC0,0x00AE,0x0217,0x02A1,0x02BD,0x02D6,
	0x027A,0x02FB,0x0357,0x0316,0x0339,0x0633,0x07B4,0x07B6,
	0x07A1,0x070A,0x0661,0x056E,0x04CD,0x048D,0x03C3,0x0268,
	0x01B7,0x00C3,0x0069,0x0107,0x007D,0xFF85,0xFD4B,0xFBBD,
	0xFB53,0xFAF9,0xFA79,0xF98B,0xF906,0xF839,0xF75D,0xF73C,
	0xF840,0xF876,0xF7EC,0xF70D,0xF73A,0xF801,0xF81A,0xF790,
	0xF75E,0xF805,0xF867,0xF9D0,0xFB39,0xFB28,0xFA33,0xF9FB,
	0xFC26,0xFECC,0xFF59,0xFE4A,0xFE2A,0xFED3,0xFF15,0xFF29,
	0x0055,0x0208,0x00FB,0xFFB0,0x00EC,0x0260,0x021D,0x0014,
	0xFF16,0x0091,0x018C,0x00A1,0xFED7,0xFDA5,0xFDEC,0xFDF4,
	0xFDB0,0xFEC7,0xFEFC,0xFE3B,0xFDA4,0xFD00,0xFC75,0xFD72,
	0xFE80,0xFA6C,0xFB16,0xFD02,0xFD1D,0xFBD3,0xFA00,0xF97C,
	0xFAE9,0xFCC8,0xFCEA,0xFBA4,0xFB59,0xFB9D,0xFB27,0xFB85,
	0xFCC4,0xFE60,0xFD84,0xFCAD,0xFD18,0xFF11,0x0026,0xFF8F,
	0xFE99,0xFE9D,0xFFF3,0x010E,0x00E6,0x0041,0xFFB1,0x004D,
	0x0166,0x022E,0x0125,0x0016,0x002A,0x0134,0x0280,0x02EE,
	0x0141,0xFF1B,0xFE62,0xFEFF,0x006A,0x00DA,0x0056,0xFF64,
	0xFE4F,0xFD50,0xFD5D,0xFF1D,0x002B,0xFEC3,0xFCF2,0xFD3A,
	0xFE4D,0xFE74,0xFC9C,0xFB96,0xFC8A,0xFE64,0xFE9D,0xFCAE,
	0xFA74,0xFA7D,0xF9F5,0xFAC0,0xFCA4,0xFD92,0xFDC0,0xFD21,
	0xFD6D,0xFE09,0xFDE1,0xFE2F,0xFE74,0xFEB1,0xFF48,0x0024,
	0x00A2,0xFFE8,0xFDB0,0xFC37,0xFD81,0xFEEC,0xFE1A,0xFCA1,
	0xFB73,0xFC3D,0xFE33,0x0005,0x003B,0xFFB3,0xFEF2,0xFD46,
	0xFD29,0xFEAF,0xFF79,0xFEDB,0xFDA4,0xFD43,0xFEE7,0x00E0,
	0x01D3,0x014E,0x0086,0x0237,0x0310,0x019F,0x00A7,0x003C,
	0x00C2,0x0106,0x01A2,0x0288,0x0307,0x0306,0x031A,0x03E6,
	0x0497,0x0579,0x0532,0x0347,0x01AD,0x0118,0x01E2,0x0375,
	0x03F7,0x035A,0x0228,0x0206,0x022D,0x0164,0x00BB,0x00E0,
	0x0132,0x00C5,0xFFA4,0xFEB1,0xFE87,0xFEE2,0xFE3A,0xFE26,
	0xFED2,0xFF38,0xFE43,0xFC95,0xFBA9,0xFB66,0xFAE9,0xFA28,
	0xF93E,0xF86D,0xF786,0xF6A7,0xF5DE,0xF536,0xF5D9,0xF68F,
	0xF65A,0xF5E7,0xF528,0xF4EF,0xF560,0xF52E,0xF4C1,0xF52C,
	0xF65A,0xF759,0xF740,0xF699,0xF5C6,0xF594,0xF561,0xF50E,
	0xF491,0xF37E,0xF30B,0xF281,0xF1F2,0xF17F,0xF1A9,0xF12C,
	0xEE6B,0xEF5C,0xEF9F,0xEE55,0xEE26,0xED56,0xECB6,0xEBEA,
	0xEBD7,0xEBF1,0xEBA2,0xEB86,0xEAF3,0xEA84,0xEA26,0xEA11,
	0xE9DC,0xEA15,0xE99C,0xE96B,0xE977,0xE92D,0xE8EB,0xE8F1,
	0xE8F7,0xE955,0xE972,0xE94C,0xE932,0xE93B,0xE8D0,0xE8F8,
	0xE945,0xE9AA,0xE99F,0xE947,0xE923,0xE98E,0xEA49,0xEA5C,
	0xEA53,0xEA6A,0xEAEF,0xEB38,0xEBA9,0xEC28,0xEC3B,0xEC0E,
	0xEC1B,0xED23,0xEDB7,0xEE27,0xEE29,0xEE1F,0xEE13,0xEECD,
	0xEF3F,0xEF39,0xEFA7,0xF012,0xF064,0xF293,0xF4DC,0xF4AF,
	0xF478,0xF480,0xF48B,0xF4FE,0xF554,0xF5AA,0xF5FE,0xF66B,
	0xF667,0xF725,0xF76C,0xF804,0xF870,0xF870,0xF8EE,0xF934,
	0xF946,0xF952,0xFAA8,0xFB50,0xFAD7,0xFB1F,0xFC19,0xFC8A,
	0xFC97,0xFCCF,0xFD26,0xFDAA,0xFE35,0xFE30,0xFE8C,0xFE63,
	0xFEBD,0xFF67,0xFF84,0x0040,0x007D,0x00A5,0x0095,0x0148,
	0x0173,0x01F3,0x020F,0x014E,0x0201,0x02F4,0x0327,0x03FE,
	0x04A8,0x0478,0x04FA,0x04C0,0x0500,0x0547,0x04E0,0x04A8,
	0x0499,0x0407,0x0433,0x04B4,0x0568,0x056D,0x05D0,0x05E9,
	0x05EB,0x063E,0x0680,0x0673,0x06B0,0x06B6,0x0716,0x07CA,
	0x082D,0x085F,0x087B,0x0889,0x0898,0x08A1,0x08D3,0x08ED,
	0x091D,0x096C,0x09CA,0x0A08,0x0AA6,0x0A78,0x0A5C,0x0A62,
	0x0AB1,0x0AEB,0x0B19,0x0B77,0x0B36,0x0B3D,0x0BF2,0x0C2F,
	0x0C20,0x0C17,0x0BD5,0x0BCF,0x0BE0,0x0B92,0x0BB6,0x0BEA,
	0x0BD0,0x0B95,0x0BAA,0x0BF4,0x0C12,0x0C87,0x0C9B,0x0C90,
	0x0CD0,0x0D55,0x0CE7,0x0D14,0x0D63,0x0D8A,0x0C81,0x0E6C,
	0x0D50,0x0C3C,0x0D64,0x0D0C,0x0D1E,0x0D35,0x0CD3,0x0C53,
	0x0C7C,0x0CDA,0x0D19,0x0CE5,0x0D2D,0x0D16,0x0D45,0x0D1A,
	0x0D53,0x0D81,0x0D32,0x0D0F,0x0CD7,0x0C8F,0x0CA3,0x0CCD,
	0x0C5E,0x0CAD,0x0C85,0x0C75,0x0C93,0x0C73,0x0C69,0x0C1B,
	0x0BE7,0x0C05,0x0BD3,0x0BE1,0x0BFF,0x0BC5,0x0BC7,0x0BB3,
	0x0BB9,0x0B94,0x0BA1,0x0BC6,0x0B8A,0x0BA6,0x0B65,0x0B91,
	0x0B75,0x0B9A,0x0B72,0x0BC4,0x0BEA,0x0B7E,0x0B36,0x0AF3,
	0x0AF9,0x0B16,0x0AF4,0x0B44,0x0B1A,0x0ADC,0x0A56,0x08E9,
	0x082F,0x0946,0x092D,0x08E2,0x08B5,0x0896,0x08A7,0x087C,
	0x082C,0x0837,0x085A,0x0892,0x08D4,0x08DB,0x08C1,0x0857,
	0x083F,0x0890,0x07E8,0x07A6,0x0886,0x086C,0x0826,0x082A,
	0x0814,0x0804,0x0811,0x0849,0x07E8,0x07D5,0x07B9,0x07B2,
	0x0758,0x072D,0x07C9,0x0886,0x084C,0x07E7,0x083D,0x07DA,
	0x077C,0x076B,0x0865,0x0909,0x07CC,0x076A,0x0738,0x0710,
	0x06EF,0x0738,0x06F7,0x0734,0x074E,0x0739,0x073D,0x078D,
	0x07A4,0x08AC,0x08B4,0x084E,0x07F2,0x0796,0x073E,0x06F9,
	0x06E5,0x06C3,0x06E1,0x06CD,0x06C9,0x0687,0x0653,0x065D,
	0x061C,0x05C1,0x05AC,0x058A,0x0560,0x0562,0x052E,0x052F,
	0x0510,0x04F1,0x04BE,0x045D,0x047F,0x04B4,0x0471,0x0429,
	0x03E5,0x0379,0x037E,0x03D1,0x037E,0x034F,0x034E,0x0350,
	0x03A6,0x0376,0x0396,0x0359,0x035C,0x034A,0x02F5,0x028D,
	0x02A3,0x02C4,0x02DF,0x0280,0x0245,0x021E,0x0259,0x0202,
	0x0222,0x01FE,0x0210,0x01C9,0x0158,0x01A9,0x0285,0x013B,
	0x00B3,0x0247,0x0160,0x0169,0x024F,0x01FE,0x0179,0x0191,
	0x019E,0x01E1,0x01AC,0x01B7,0x0185,0x0189,0x014B,0x015B,
	0x0146,0x0162,0x0144,0x013B,0x00EF,0x00C7,0x0159,0x0142,
	0x00D3,0x010C,0x00CB,0x00FA,0x00B4,0x0099,0xFFEB,0xFFC4,
	0xFFA8,0xFF9B,0xFEF8,0xFF12,0xFFED,0xFFA0,0xFF16,0xFECA,
	0xFF00,0xFF0B,0xFF07,0xFF3D,0xFED5,0xFEBB,0xFEAE,0xFEF7,
	0xFEDE,0xFE4F,0xFE7B,0xFF2A,0xFF33,0xFF29,0xFED4,0xFE94,
	0xFE5F,0xFE4E,0xFE44,0xFEC9,0xFE02,0xFD92,0xFE6F,0xFEF6,
	0xFED2,0xFEFC,0xFEF4,0xFE83,0xFE80,0xFE74,0xFE8B,0xFDF4,
	0xFD8A,0xFDA9,0xFD49,0xFCD2,0xFCC4,0xFC92,0xFC75,0xFC8E,
	0xFC71,0xFC54,0xFC8B,0xFC78,0xFC96,0xFC99,0xFD05,0xFD2C,
	0xFD8A,0xFD3D,0xFC9D,0xFCF3,0xFD48,0xFD5E,0xFDAB,0xFDF4,
	0xFDC9,0xFDBF,0xFDDB,0xFE2E,0xFDB0,0xFDA6,0xFDFC,0xFE00,
	0xFDD1,0xFDA9,0xFD78,0xFD9F,0xFD8B,0xFDD5,0xFDA5,0xFD3A,
	0xFD88,0xFD51,0xFD0C,0xFD05,0xFD44,0xFD86,0xFD7B,0xFDEE,
	0xFE82,0xFE76,0xFDBD,0xFD78,0xFD63,0xFDA6,0xFD9A,0xFDDB,
	0xFD82,0xFD54,0xFDD7,0xFE11,0xFDC2,0xFE03,0xFE9F,0xFDFF,
	0xFE38,0xFFD0,0xFDE9,0xFE49,0xFE6B,0xFE7A,0xFE6A,0xFE9E,
	0xFEA8,0xFEC7,0xFEAA,0xFEA6,0xFE8B,0xFE8C,0xFE8F,0xFE4A,
	0xFE7F,0xFE5C,0xFEC0,0xFEAD,0xFED3,0xFEE1,0xFEBA,0xFEE1,
	0xFEB5,0xFE6B,0xFE3F,0xFE76,0xFE6A,0xFEDF,0xFF31,0xFEF8,
	0xFEBE,0xFEB2,0xFEE3,0xFF02,0xFEFE,0xFEE1,0xFEAF,0xFEFC,
	0xFF38,0xFF63,0xFF6C,0xFF96,0xFF6D,0xFEF0,0xFF27,0xFF1E,
	0xFF3D,0xFFB9,0xFFD6,0xFFCB,0xFFC5,0xFFBC,0xFFB4,0xFF7A,
	0xFF69,0xFFC1,0xFFE5,0xFF93,0xFF1D,0xFF14,0xFF2B,0xFF37,
	0xFEBB,0xFD63,0xFEC9,0xFF54,0xFEFB,0xFED3,0xFF3C,0x00A3,
	0x01A6,0x0205,0x02CE,0x0491,0x05D8,0x0630,0x06DD,0x0793,
	0x0866,0x08AD,0x094F,0x09F6,0x08F9,0x08F2,0x098E,0x098D,
	0x0906,0x097E,0x0A30,0x0AA1,0x0B6D,0x0B77,0x0ABF,0x0AAB,
	0x0B45,0x0BD2,0x0BA6,0x0C5A,0x0E53,0x1073,0x10DE,0x1037,
	0x0F57,0x0FED,0x10F7,0x11D6,0x13B3,0x1536,0x1469,0x133C,
	0x128B,0x135A,0x150A,0x158D,0x14CD,0x1588,0x174F,0x185E,
	0x17EB,0x17A0,0x1867,0x19F3,0x19C4,0x17F7,0x173B,0x1941,
	0x1B3F,0x1AF5,0x1975,0x18CD,0x1968,0x196F,0x1880,0x182F,
	0x18F6,0x1910,0x1805,0x16F2,0x17FA,0x1938,0x18E5,0x16E3,
	0x1587,0x1641,0x1705,0x15FB,0x14D4,0x14DB,0x1522,0x142D,
	0x12F0,0x127F,0x1330,0x12D6,0x11D0,0x1164,0x118A,0x10CF,
	0x100B,0x0FB3,0x0EEE,0x0E4E,0x0E41,0x0E43,0x0D71,0x0C38,
	0x0BB2,0x0C3E,0x0B82,0x0999,0x098A,0x0B56,0x0BCF,0x0ABB,
	0x08E3,0x078C,0x0614,0x057F,0x0569,0x060B,0x0741,0x080F,
	0x07F6,0x04F5,0x0620,0x0624,0x02A7,0x0142,0x02B9,0x04B3,
	0x0414,0x01F8,0x0189,0x0278,0x014C,0xFEF7,0xFF46,0x017D,
	0x0183,0xFF1C,0xFDA9,0xFD71,0xFD1C,0xFB80,0xFA2B,0xFB03,
	0xFD55,0xFE28,0xFC4F,0xFAAA,0xFAA7,0xFA50,0xF967,0xF855,
	0xF8BD,0xF9E6,0xF9AD,0xF856,0xF72C,0xF6F2,0xF7D7,0xF868,
	0xF69D,0xF52C,0xF58D,0xF640,0xF64B,0xF5DC,0xF545,0xF53E,
	0xF4C6,0xF3AC,0xF338,0xF491,0xF5D0,0xF40A,0xF23E,0xF175,
	0xF206,0xF294,0xF25E,0xF2BD,0xF403,0xF3DA,0xF2A7,0xF331,
	0xF2BB,0xF409,0xF3E6,0xF293,0xF18D,0xF297,0xF4A7,0xF465,
	0xF1D8,0xF0F7,0xF200,0xF312,0xF268,0xF0BD,0xF0E1,0xF299,
	0xF31B,0xF233,0xF100,0xF22C,0xF346,0xF107,0xEFBE,0xF1AE,
	0xF2AE,0xF16D,0xF08C,0xF109,0xF1A1,0xF150,0xF09E,0xF1F3,
	0xF37E,0xF1B9,0xF037,0xF071,0xF0FD,0xF12C,0xF0ED,0xF005,
	0xEF54,0xF144,0xF356,0xF1FE,0xEF40,0xF092,0xF2E9,0xF149,
	0xEEE5,0xEF63,0xF214,0xF3D6,0xF217,0xF035,0xF128,0xF177,
	0xF005,0xEF20,0xF0D1,0xF316,0xF119,0xEE08,0xEE95,0xF172,
	0xF110,0xEDC5,0xEE2B,0xF2AE,0xF39C,0xEFEE,0xED61,0xEF56,
	0xF2D4,0xF10F,0xED9A,0xEE40,0xF23E,0xF3AA,0xF0DD,0xEF95,
	0xF254,0xF35B,0xF09E,0xEE07,0xF08E,0xF56D,0xF53A,0xEFC1,
	0xECA2,0xEFC0,0xF3B8,0xF2E0,0xF0CB,0xF206,0xF3F2,0xF35F,
	0xF0D3,0xF061,0xF332,0xF45D,0xF27A,0xF052,0xF0B8,0xF2E1,
	0xF40F,0xF352,0xF2EC,0xF379,0xF3A4,0xF2D1,0xF1C1,0xF30E,
	0xF5FF,0xF5B5,0xF292,0xF0AA,0xF2FC,0xF499,0xF4C6,0xF457,
	0xF561,0xF52F,0xF416,0xF58B,0xF371,0xF280,0xF41D,0xF59C,
	0xF509,0xF347,0xF2E4,0xF5FE,0xF79F,0xF5EB,0xF4AE,0xF6E5,
	0xF844,0xF4ED,0xF1EF,0xF4F9,0xF9A1,0xF7CF,0xF4AA,0xF50B,
	0xF7DF,0xF89F,0xF646,0xF5B1,0xF7D9,0xF954,0xF819,0xF5D8,
	0xF5B3,0xF865,0xF8CF,0xF593,0xF4F7,0xF8E7,0xFC1C,0xF989,
	0xF4B4,0xF558,0xFA3D,0xFAF9,0xF766,0xF5C4,0xFA5E,0xFCFE,
	0xF980,0xF663,0xF8EF,0xFBF6,0xFA5C,0xF6D8,0xF7D0,0xFC01,
	0xFC35,0xF8C0,0xF752,0xF8FB,0xFA3B,0xFA34,0xF937,0xF93E,
	0xFAC1,0xFB64,0xF8D0,0xF586,0xF625,0xF959,0xFAF0,0xFA0B,
	0xF919,0xFAAB,0xFAEE,0xF934,0xF746,0xF943,0xFCEE,0xFD43,
	0xF944,0xF747,0xFAA8,0xFC88,0xFA80,0xF891,0xFA4F,0xFD97,
	0xFDF6,0xFA88,0xF91A,0xFC3C,0xFE87,0xFB31,0xF8BB,0xFC1E,
	0x0085,0xFEA0,0xFABB,0xFB64,0xFE9F,0xFEB2,0xFB74,0xFA69,
	0xFC2E,0xFF19,0xFEB0,0xFC30,0xFC8F,0xFD88,0xFDC6,0xFD42,
	0xFCA1,0xFEC0,0x0020,0xFD95,0xFC64,0xFD91,0xFF25,0xFF6B,
	0xFFCF,0x01E0,0x030C,0x01B0,0xFFF5,0xFFFD,0x009E,0x0190,
	0x023B,0x021B,0x01A1,0x0155,0x012D,0x0013,0x0115,0x036D,
	0x0298,0xFF12,0xFF35,0x02E0,0x03EB,0xFF6D,0xFCEF,0x004F,
	0x0334,0x0076,0xFCF0,0xFFA0,0x0497,0x01EA,0xFB05,0xFC18,
	0x0352,0x0641,0x0246,0xFDAE,0xFE37,0x015B,0x0202,0xFE82,
	0xFE65,0x0323,0x03D1,0xFFF6,0xFDBA,0x0007,0x0354,0x0255,
	0xFE26,0xFDCA,0x0229,0x04BA,0x0147,0xFD1C,0x006F,0x052E,
	0x02A6,0xFD6F,0xFCDE,0x0152,0x0471,0x0111,0xFD1D,0xFF13,
	0x025C,0x0089,0xFF36,0xFF52,0x03CA,0x054F,0x004C,0xFBE3,
	0xFDB7,0x0265,0x021F,0xFF34,0xFE39,0x00FD,0x03A8,0x0124,
	0xFDB4,0xFF6E,0x0364,0x0148,0xFBCC,0xFD61,0x03D9,0x05DD,
	0x014D,0xFD0F,0xFE93,0x0220,0x015B,0xFF91,0xFFF3,0x01EA,
	0x0155,0xFF2E,0xFDC4,0xFE27,0xFF3D,0x00B0,0x0174,0x00E4,
	0xFF8C,0xFF35,0xFFF9,0x0036,0xFEB5,0xFD71,0xFFAD,0x028A,
	0x00CA,0xFD08,0xFDE4,0x00E4,0x00C8,0xFE67,0xFE20,0xFFAE,
	0x00A0,0xFFE1,0xFDF3,0xFD8B,0xFFDD,0x0107,0x02C8,0x02A9,
	0x0253,0x0277,0x027A,0x0194,0x00A4,0x016A,0x02D2,0x02F8,
	0x00FB,0x010D,0x02E7,0x0223,0x000D,0xFFF6,0x01D2,0x0298,
	0x029C,0x00E1,0xFFCB,0x0012,0xFEDB,0xFF03,0x01F8,0x0331,
	0x0076,0xFED4,0xFE19,0xFE62,0xFF83,0x000A,0xFE82,0xFF08,
	0x01C7,0x0315,0xFF8D,0xFC67,0xFE9A,0x011A,0x0094,0xFF91,
	0xFF56,0x004A,0x01CE,0x00E6,0xFD08,0xFC54,0xFF34,0x0312,
	0x02E2,0xFEE3,0xFDC8,0x0102,0x003F,0xFB44,0xFA34,0x005F,
	0x03A5,0xFEED,0xFA8E,0xFD52,0x01AA,0x0018,0xFA5B,0xFACE,
	0x0024,0x0086,0xFCBF,0xFAE1,0xFD59,0x00A1,0xFE0E,0xFABD,
	0xFD8A,0x00BE,0xFFCB,0xFC5C,0xFBB2,0xFDAD,0xFF29,0xFE10,
	0xFBB3,0xFCBD,0x00EA,0x00FB,0xFC1C,0xFAAE,0xFE59,0x0172,
	0xFFF8,0xFD17,0xFCEE,0xFD7B,0xFDF7,0xFF46,0xFF08,0xFEA0,
	0xFF6B,0xFFBE,0xFE58,0xFE41,0xFEDE,0xFD7C,0xFC67,0xFE58,
	0xFFE4,0xFEDF,0xFC79,0xFD4C,0x0040,0x0063,0xFDB5,0xFBAB,
	0xFDA8,0x01B9,0x0158,0xFD21,0xFB8B,0xFEB7,0x00A4,0xFF23,
	0xFFEF,0x004E,0x010D,0xFEB2,0xFDD3,0xFF5A,0x0032,0xFE01,
	0xFCF6,0xFF72,0x0146,0x00E8,0xFFB0,0x00BE,0x0337,0x00A9,
	0xFCE2,0xFD9C,0x0324,0x0409,0xFFB8,0xFDD7,0xFF6B,0x0053,
	0xFE45,0xFC6B,0xFFF7,0x0489,0x03D1,0xFE8E,0xFBA8,0xFE1F,
	0x0163,0x000D,0xFD1C,0xFDCD,0x00FC,0x0298,0xFFBA,0xFD55,
	0xFE95,0x02BD,0x02A8,0xFEA2,0xFC76,0xFFC1,0x0347,0x00D5,
	0xFD5A,0xFDE9,0x00A1,0x0199,0x0067,0x0036,0x0145,0x00CE,
	0xFE8C,0xFDE8,0xFEE7,0xFFFD,0x00C0,0x0118,0x000D,0xFE8C,
	0xFD6B,0xFF32,0xFF21,0xFD7D,0xFBF9,0xFCC9,0xFFE3,0x0043,
	0xFD02,0xFCA0,0xFF86,0xFFB7,0xFC13,0xFC23,0x014C,0x036C,
	0xFFD8,0xFBE7,0xFD4C,0x01EE,0x02B9,0xFF39,0xFE34,0x01DE,
	0x0318,0x0021,0xFD8A,0xFF5E,0x03BB,0x04BF,0x00DF,0xFF07,
	0x02E9,0x06EF,0x049D,0xFF72,0xFF75,0x0348,0x0505,0x0122,
	0xFF35,0x03F5,0x07BF,0x0502,0xFFBD,0xFF35,0x04A5,0x0646,
	0x0120,0xFEB6,0x0245,0x0584,0x048F,0x00E3,0x0203,0x067B,
	0x0763,0x0365,0x0154,0x03A4,0x0575,0x0457,0x0429,0x04BE,
	0x03CA,0x02A6,0x03BB,0x0576,0x03F7,0x016A,0x0301,0x05F4,
	0x0542,0x020A,0x00E3,0x0399,0x052C,0x0196,0x002F,0x03C6,
	0x0639,0x04B6,0x017E,0x005A,0x02C3,0x0511,0x0350,0xFFAC,
	0x0071,0x0538,0x0527,0xFEC3,0xFCC6,0x03A7,0x08BE,0x03E4,
	0xFDCB,0xFE68,0x0337,0x033C,0xFFB6,0xFEA7,0x010C,0x045B,
	0x03BB,0xFFB6,0xFFF7,0x0444,0x04DA,0x0120,0xFEF8,0x0093,
	0x01BD,0x0275,0x02B5,0x0245,0x00E0,0x006A,0x0173,0x0296,
	0x01C6,0x03AF,0x036F,0x021C,0x024F,0x0090,0xFE2B,0xFF95,
	0x033E,0x0569,0x047F,0x0284,0x0195,0x017B,0x01C7,0x0181,
	0xFFC2,0xFF2D,0x00F3,0x0326,0x0302,0x009A,0xFF18,0x00AE,
	0x01FA,0xFFB8,0xFE66,0x0222,0x0513,0x0167,0xFC69,0xFD93,
	0x0353,0x0295,0xFDD5,0xFDD6,0x015B,0x01DD,0xFE57,0xFC1D,
	0xFE16,0x0138,0x004F,0xFD81,0xFD98,0x00A9,0x00BF,0xFDB8,
	0xFD20,0xFFD1,0x013E,0xFF9E,0xFD67,0xFD95,0xFF89,0xFFC4,
	0xFE58,0xFDA1,0xFE02,0xFEAC,0xFF67,0x0025,0x00D0,0xFF1A,
	0x0057,0x02B5,0x0148,0xFEB6,0xFF59,0x00C8,0xFFA1,0xFD34,
	0xFE15,0x010D,0x01C1,0xFFB1,0xFDFA,0xFDE8,0xFF5F,0x00D8,
	0xFF6C,0xFB7F,0xFCC9,0x00B8,0x011D,0xFE60,0xFD0C,0xFF30,
	0x00C3,0xFD4E,0xFA22,0xFDC7,0x0373,0x021E,0xFAF1,0xF923,
	0xFE69,0x0242,0xFFCB,0xFD06,0xFDE8,0x00AE,0x004E,0xFC4E,
	0xFA35,0xFE90,0x017F,0xFE3C,0xFC78,0xFE61,0x001E,0xFF94,
	0xFD9E,0xFD65,0xFDBE,0xFDC6,0xFED4,0xFF14,0xFDF8,0xFDDC,
	0xFDE0,0xFC73,0xFBAE,0xFD7E,0xFE72,0xFE49,0xFED7,0xFD27,
	0xFC1E,0xFCFE,0xFDDA,0xFDBB,0xFDE7,0xFE25,0xFF03,0x0004,
	0xFEB7,0xFBC0,0xFCAF,0xFF4B,0xFF2A,0xFECF,0xFEC3,0xFEF4,
	0xFF59,0xFF0A,0xFE32,0xFD55,0xFBF1,0xFD75,0x00E9,0x0083,
	0xFE16,0xFE20,0x0062,0x00E3,0xFD87,0xFBCE,0xFF09,0x01CB,
	0xFF00,0xFB88,0xFD1D,0xFFA0,0x0050,0xFF84,0xFED3,0x00C0,
	0x017E,0xFF0E,0xFCF1,0xFEFF,0x0050,0xFDA7,0xFC81,0xFF1A,
	0x02FA,0x028A,0xFDC9,0xFC1A,0x003B,0x03A9,0x001B,0xFCF7,
	0xFD4D,0x01FC,0x03C6,0xFD4A,0xFB4F,0x00E7,0x04DA,0x0144,
	0xFD63,0xFF93,0x040B,0x0365,0xFD41,0xFA6A,0xFF09,0x0444,
	0x0219,0xFDDD,0xFFED,0x0395,0x01D5,0xFC47,0xFB47,0x01C5,
	0x05CD,0x02A7,0xFCB3,0xFC76,0xFFF9,0x003C,0xFCF7,0xFC95,
	0x00E3,0x0337,0x0091,0xFD0B,0xFD99,0x00E1,0x0017,0xFCE1,
	0xFEC1,0x033E,0x01CD,0xFD4B,0xFE71,0x0330,0x02A2,0xFE5C,
	0xFD1F,0x01E8,0x05ED,0x01E2,0xFD8A,0xFFC1,0x02E1,0x0146,
	0xFE1C,0xFFAD,0x04D5,0x0677,0x0192,0xFC9D,0xFD27,0x011F,
	0x012F,0xFC72,0xFAE7,0x0010,0x0408,0x016E,0xFC8A,0xFD53,
	0x0219,0x022A,0xFD5E,0xFCE4,0x015F,0x0384,0xFECD,0xF986,
	0xFC48,0x030A,0x03A5,0xFE50,0xFC23,0x00E9,0x04A7,0x00E5,
	0xFC5C,0xFE54,0x0314,0x043C,0xFEF3,0xFD07,0x02E8,0x0768,
	0x0334,0xFD38,0xFE69,0x044E,0x04EA,0xFF5D,0xFDE8,0x03B9,
	0x06C1,0x00A6,0xFC5A,0x0187,0x05E3,0x0382,0xFE55,0xFE26,
	0x0359,0x057B,0x00F8,0xFCA1,0x01C0,0x07CA,0x04E5,0xFE1E,
	0xFFD6,0x07A4,0x089E,0x018E,0xFDB0,0x0338,0x088A,0x0481,
	0xFEDD,0x004C,0x0626,0x07A7,0x02E3,0x00A6,0x04C5,0x062C,
	0x01B9,0xFFBE,0x0330,0x0622,0x0423,0x01FD,0x0391,0x0605,
	0x0458,0xFF40,0xFF5D,0x0389,0x041D,0x026D,0x0234,0x03AE,
	0x0385,0x007C,0xFF6D,0x02A8,0x03D8,0x0238,0x00FA,0x00ED,
	0x0194,0x0233,0x0104,0xFF1F,0x0107,0x0494,0x03E8,0x00B2,
	0x0052,0x0287,0x02D3,0xFE4E,0xFC2E,0xFFE9,0x0484,0x028C,
	0xFDD6,0xFE9F,0x03BC,0x03AF,0xFDCA,0xFB6E,0x022A,0x0605,
	0x0132,0xFC05,0xFAF6,0xFFA8,0x021E,0x0021,0xFF5B,0x010F,
	0x0268,0xFFE0,0xFBF4,0xFDB4,0x01F6,0x011A,0xFCA4,0xFAFA,
	0xFE01,0x010A,0x013D,0xFFB4,0xFE77,0xFF69,0xFF81,0xFD2A,
	0xFC5D,0xFF1F,0x001F,0xFE90,0xFD1E,0xFD2F,0xFEDC,0x0093,
	0x0038,0xFECA,0xFD25,0xFCDB,0xFE43,0xFDA5,0xFC8E,0xFE3D,
	0x013C,0x005A,0xFCFE,0xFC6E,0xFF7B,0x0101,0xFEAD,0xFB91,
	0xFC4E,0xFF41,0xFF03,0xFC1B,0xFBA6,0xFF89,0x0171,0xFE2A,
	0xFAA0,0xFC04,0x005B,0x0076,0xFCE3,0xFD51,0x0076,0x02C6,
	0x01E7,0xFE7E,0xFDF9,0x0065,0x0042,0xFF29,0xFEB2,0xFF49,
	0xFF5E,0xFF6C,0xFF3A,0xFE3F,0xFCBC,0xFDAF,0x012F,0x01F1,
	0xFD34,0xFAE3,0xFEB8,0x00BB,0xFE4A,0xFB8D,0xFC5C,0xFE57,
	0xFE5A,0xFB6D,0xFC4E,0x0002,0x0051,0xFC02,0xF8EE,0xFCBF,
	0x00AE,0xFE18,0xF9E8,0xFC48,0x00D2,0xFDFE,0xF949,0xFA31,
	0xFEB0,0x0078,0xFC20,0xFA11,0xFE7E,0xFEEF,0xFAD3,0xF99F,
	0xFDD5,0x0071,0xFF65,0xFCAB,0xFBC1,0xFD9F,0xFEE1,0xFCF2,
	0xF8FE,0xF96C,0xFE27,0xFEB2,0xFAD7,0xF9E2,0xFC81,0xFE16,
	0xFBE2,0xF93D,0xFB4E,0xFE27,0xFD05,0xFA8A,0xFB91,0xFDF7,
	0xFD73,0xFA7D,0xF8BE,0xFC44,0x0052,0xFE9C,0xFB2F,0xFB64,
	0xFD0A,0xFDF6,0xFC24,0xFA9F,0xFAE7,0xFCD8,0xFD72,0xFC81,
	0xFC93,0xFDB1,0xFE1D,0xFD5C,0xFAD5,0xFAF7,0xFE79,0x0135,
	0xFE24,0xFA54,0xFB5A,0xFEC2,0x0014,0xFD4D,0xFB6B,0xFE37,
	0x015A,0xFE30,0xF893,0xFA19,0x0055,0x011E,0xFB2F,0xF82C,
	0xFCBE,0x0134,0x0018,0xFD2E,0xFE37,0xFEE1,0xFD9E,0xFD44,
	0xFCAC,0xFF31,0xFFD1,0xFEE4,0xFDE0,0xFF33,0x013F,0x007A,
	0xFDE1,0xFDB8,0xFFFC,0x00C2,0xFE62,0xFC03,0xFEA9,0x01C3,
	0xFF08,0xFBF6,0xFF7F,0x0437,0x028F,0xFCB6,0xFB0F,0xFE0A,
	0xFFB3,0xFCBD,0xFB25,0xFF9E,0x0396,0x012A,0xFC1B,0xFC9E,
	0x00E5,0x008B,0xFB7A,0xF99C,0xFE28,0x0257,0x0016,0xFA94,
	0xFA98,0x00F1,0x0290,0xFD8C,0xFC70,0x00E4,0x03B8,0x0094,
	0xFA3E,0xF97B,0xFE1B,0x00D5,0xFF31,0xFE45,0xFF63,0x016D,
	0x011F,0xFDAF,0xFACB,0xFC5B,0xFF11,0xFE61,0xFB16,0xF982,
	0xFE76,0x00B5,0xFCFC,0xF9AC,0xFB5D,0xFE93,0xFD21,0xF96C,
	0xFB54,0x002B,0xFEF7,0xF94E,0xF854,0xFD90,0x0131,0xFE64,
	0xFD2D,0xFF23,0x004F,0xFEDD,0xFC3D,0xFBBC,0xFD9A,0xFFEF,
	0x0072,0x0045,0x01BB,0x015A,0xFFB4,0xFE0A,0xFCBD,0xFDE0,
	0x002C,0x01CC,0x00B3,0x001A,0x0090,0x00DE,0x00AA,0xFF86,
	0xFF0F,0x005F,0x04A6,0x0502,0xFF6F,0xFDA8,0xFFF3,0x010A,
	0xFF8F,0xFF6F,0x01D5,0x0414,0x0427,0x01C5,0xFF94,0x018D,
	0x03E3,0x02EA,0x0105,0x029F,0x0444,0x03C8,0x03B3,0x050D,
	0x04CD,0x023B,0x0108,0x040C,0x05E0,0x037D,0x00B9,0x0116,
	0x04A8,0x0761,0x0489,0x0072,0x01ED,0x068A,0x0535,0xFFF4,
	0x001A,0x0574,0x07C3,0x0272,0xFD57,0x018E,0x07E7,0x0622,
	0x008E,0x0032,0x03EE,0x05F8,0x02D6,0xFEC8,0xFF42,0x025A,
	0x0389,0x008C,0xFD84,0x0044,0x04E9,0x04A9,0x0138,0xFF1B,
	0x020C,0x0410,0x00A9,0xFE8E,0x0184,0x041F,0x0148,0xFD3B,
	0xFE02,0x0291,0x042B,0x0174,0xFF18,0xFFF6,0x02D4,0x0035,
	0xFF3F,0xFF65,0xFF35,0xFF60,0xFFEB,0x01EC,0x01CA,0xFF68,
	0xFDC6,0xFD91,0xFF19,0x00C1,0x0024,0xFE77,0xFE3B,0xFF61,
	0xFF4E,0xFD38,0xFCFD,0x0120,0x0307,0x004A,0xFE3E,0xFEB3,
	0xFFE9,0xFDF6,0xFBE4,0xFDD3,0x01FF,0x00F6,0xFC8C,0xFCC0,
	0x01D8,0x0338,0xFD91,0xFAF7,0x0048,0x0344,0x006C,0xFC40,
	0xFC5A,0x006F,0x00D3,0xFCF8,0xFCD0,0x013B,0x0312,0xFF5F,
	0xFCE1,0xFDA2,0xFEB0,0xFE12,0xFD89,0xFEC7,0x0133,0x0180,
	0xFF82,0xFED5,0x0010,0xFEF8,0xFF66,0x02B4,0x02FF,0x00D6,
	0x0014,0x02FB,0x03C6,0x000D,0xFD6D,0xFEE9,0x033A,0x04ED,
	0x0215,0xFFAE,0xFFC5,0xFFBD,0xFE40,0xFCD9,0xFEAB,0x011D,
	0x0088,0x008E,0x0182,0x0004,0xFCBD,0xFDD4,0x00AD,0x0066,
	0xFE5D,0xFDD3,0xFEBF,0xFF21,0xFFDA,0xFFEF,0xFEED,0xFD1A,
	0xFE84,0xFFED,0xFE03,0xFD3C,0xFF37,0xFFDD,0xFC44,0xFAE3,
	0xFEA3,0x00F3,0xFD8C,0xFAF4,0xFD6E,0x006D,0xFF77,0xFD02,
	0xFC07,0xFD94,0xFF5C,0xFEED,0xFCE1,0xFAAA,0xFC8B,0x006F,
	0xFEB4,0xFAB6,0xFAEC,0xFEC6,0xFF60,0xFBBE,0xFAAD,0xFCFA,
	0xFF87,0xFDFF,0xFA30,0xFA07,0xFD59,0xFFCA,0xFF0E,0xFC1C,
	0xFAAC,0xFBE4,0xFDCC,0xFD87,0xFC6E,0xFCC7,0xFBF4,0xFBD8,
	0xFD54,0xFF59,0xFFB1,0xFDB8,0xFC2F,0xFC56,0xFCCB,0xFC7C,
	0xFCAA,0xFE05,0xFDE1,0xFCD2,0xFD60,0xFD4C,0xFCD1,0xFDCF,
	0x0031,0xFFA8,0xFBD2,0xFA05,0xFD17,0xFFAD,0xFCA3,0xF8EB,
	0xFC1E,0x00B7,0x004B,0xFCCF,0xFD0B,0x00FA,0x0095,0xFCD6,
	0xFB8D,0xFDD2,0x0047,0xFE6A,0xFC42,0xFC7C,0x00FD,0x0093,
	0xFE28,0x0000,0x0282,0x0200,0xFD52,0xFB3C,0xFE60,0x01BA,
	0xFF72,0xFCF2,0xFE5C,0x0368,0x04AD,0xFFF8,0xFC86,0xFD7A,
	0xFEEC,0xFDDE,0xFC9D,0xFEC8,0x0264,0x0173,0xFD1C,0xFC8B,
	0x0093,0x0291,0xFF98,0xFC9B,0xFE8A,0x0167,0xFF3E,0xFB26,
	0xFB3F,0xFED7,0x00FF,0xFF47,0xFDC1,0xFFEC,0x021D,0x00A3,
	0xFE03,0xFE03,0xFE37,0xFCB5,0xFC14,0xFDA5,0x0088,0x0229,
	0x0173,0xFEF5,0xFD78,0xFDE2,0xFE32,0xFEFF,0xFF40,0xFE45,
	0xFD8F,0xFDEA,0xFF43,0xFF6C,0xFEE7,0xFFE7,0xFEC9,0xFC65,
	0xFB10,0xFC87,0xFF8E,0xFDBD,0xF8BE,0xF83D,0xFC33,0xFF35,
	0xFEF1,0xFE30,0xFF5A,0x0038,0xFDDA,0xFB68,0xFBA8,0xFE28,
	0x0074,0xFEEF,0xFD2E,0xFDCC,0xFFBB,0x0174,0x00E7,0xFEB9,
	0xFE46,0xFEDC,0xFE1B,0xFDD4,0xFF6F,0x00D3,0x00E2,0xFF6E,
	0xFDBD,0xFDF5,0x0179,0x046C,0x035F,0x0038,0xFE2A,0xFDEB,
	0xFDF2,0xFF12,0x0105,0x01AB,0x02CF,0x021A,0x019D,0x020B,
	0x0154,0xFF70,0xFDC8,0xFDCA,0xFF71,0x01AF,0x02F4,0x03E6,
	0x039B,0x0253,0x00BC,0x008B,0x025D,0x0372,0x028F,0x0281,
	0x0341,0x016B,0xFE79,0xFF6A,0x02AE,0x0502,0x044F,0x031F,
	0x02E8,0x024C,0x00C3,0xFF24,0xFF27,0x00C3,0x02B1,0x030D,
	0x029A,0x01E8,0x026A,0x0295,0x01A1,0x0056,0x0097,0x01DA,
	0x0226,0x00E2,0xFF6A,0xFF6A,0xFFCF,0xFFB8,0x005B,0x02DE,
	0x0428,0x0237,0xFFDD,0xFECF,0xFF3E,0xFFF2,0xFFA1,0xFFEF,
	0x014C,0x02F1,0x0243,0xFFF7,0xFEFC,0x0004,0x010A,0x004B,
	0xFFA9,0x0021,0x008B,0xFF46,0xFDA0,0xFFAF,0x0063,0x0078,
	0x00B8,0x0012,0x0143,0x00F1,0xFEFE,0xFE09,0xFF25,0xFFFB,
	0xFF74,0xFEC1,0x0020,0x02AD,0x020B,0xFF50,0xFE6C,0xFFE5,
	0x010A,0x0065,0xFF59,0xFF18,0x0055,0xFFF5,0xFE2B,0xFE10,
	0x007A,0x0295,0x01CB,0x001C,0xFFDD,0x002C,0xFF61,0xFDFD,
	0xFEA0,0x00B1,0x0109,0xFFB5,0xFF31,0x00DA,0x01A4,0xFFC3,
	0xFE20,0xFEE6,0x00CE,0xFFF3,0xFDE2,0xFE40,0x0035,0x0058,
	0xFF9A,0xFFBD,0x0164,0x021E,0x0029,0xFE51,0xFF27,0x0015,
	0xFEA2,0xFDAE,0xFFFA,0x031D,0x045A,0x017F,0x0035,0x01E1,
	0x0256,0x00F3,0x0029,0x01A9,0x02B5,0x0107,0xFEC3,0xFE36,
	0xFF37,0x0010,0x000D,0xFFE5,0xFFA2,0xFF75,0xFF76,0xFE67,
	0xFE97,0x001A,0xFF93,0xFD74,0xFDB7,0xFF8C,0x001A,0xFF65,
	0xFE88,0xFE26,0xFE67,0xFDBB,0xFE3F,0xFF79,0xFFEB,0xFF39,
	0xFD9D,0xFC82,0xFD36,0xFEFC,0xFFBB,0xFF22,0xFED3,0xFEA6,
	0xFE21,0xFCF5,0xFCB3,0xFEAA,0xFF37,0xFE09,0xFDD3,0xFE88,
	0xFF3C,0xFF5C,0xFE94,0xFE23,0xFDC4,0xFD2E,0xFCF7,0xFCE3,
	0xFCE9,0xFD25,0xFC65,0xFB23,0xFAFA,0xFC2C,0xFD9A,0xFDD0,
	0xFC83,0xFB92,0xFBAB,0xFC22,0xFC46,0xFC40,0xFD2F,0xFD42,
	0xFB7A,0xF996,0xFAE9,0xFDED,0xFF84,0xFEB5,0xFCEE,0xFC2A,
	0xFC11,0xFB68,0xFC25,0xFDF9,0xFF00,0xFE2F,0xFC36,0xFBD8,
	0xFD98,0xFF2E,0xFEA8,0xFD1B,0xFC79,0xFCD9,0xFD1A,0xFCD0,
	0xFD2A,0xFD85,0xFD43,0xFCA7,0xFC8E,0xFDF3,0xFF73,0xFFBC,
	0xFEB8,0xFD53,0xFCE6,0xFCF4,0xFC53,0xFBD9,0xFBD3,0xFC73,
	0xFC17,0xFB27,0xFB00,0xFB2E,0xFA00,0xF956,0xF9B1,0xF723,
	0xF70F,0xF657,0xF553,0xF546,0xF54D,0xF50C,0xF5D3,0xF5F1,
	0xF595,0xF4E6,0xF45C,0xF485,0xF4BE,0xF54B,0xF50D,0xF4C3,
	0xF413,0xF405,0xF410,0xF36D,0xF2D7,0xF1F0,0xF166,0xF0E3,
	0xF0DE,0xEFD1,0xEF2C,0xEE6F,0xEE6A,0xEDD5,0xED83,0xECE5,
	0xECA2,0xEC25,0xEB75,0xEB42,0xEA9F,0xEA05,0xE9DF,0xE9AE,
	0xE97A,0xE93A,0xE904,0xE8B3,0xE873,0xE820,0xE83E,0xE81C,
	0xE83F,0xE7F8,0xE815,0xE814,0xE810,0xE7D6,0xE7A9,0xE7F3,
	0xE7E9,0xE7AC,0xE79D,0xE7A3,0xE7DC,0xE6D2,0xE51A,0xE5E6,
	0xE675,0xE70C,0xE7A5,0xE7E9,0xE812,0xE89F,0xE90B,0xE905,
	0xE91B,0xE98A,0xE9CC,0xEAD6,0xEA65,0xEAD3,0xEB9E,0xEC66,
	0xEC93,0xEC21,0xED6D,0xEE2E,0xEE1D,0xEE6B,0xEF3F,0xEFDB,
	0xF084,0xF0C8,0xF128,0xF18B,0xF218,0xF299,0xF31E,0xF3E2,
	0xF43F,0xF463,0xF4DC,0xF5DB,0xF648,0xF6B9,0xF700,0xF785,
	0xF76F,0xF903,0xF9C0,0xF909,0xF907,0xF904,0xF9A8,0xFA36,
	0xFA97,0xFB4F,0xFC25,0xFC85,0xFD17,0xFD9A,0xFE8A,0xFFA9,
	0x0035,0x003D,0x0078,0x0094,0x0103,0x0202,0x0218,0x024B,
	0x02B6,0x0321,0x035F,0x03B2,0x042A,0x047A,0x04AB,0x04E0,
	0x0505,0x056C,0x05DD,0x063F,0x06B3,0x0692,0x068B,0x06DB,
	0x0770,0x078F,0x07BE,0x07A7,0x07FE,0x0827,0x0860,0x086A,
	0x08AA,0x091B,0x0956,0x0992,0x09A5,0x09F2,0x0A2A,0x0A1C,
	0x0A15,0x0A48,0x0AE6,0x0B04,0x0B37,0x0B3C,0x0B78,0x0BC1,
	0x0C46,0x0C8F,0x0CD2,0x0CC1,0x0CD7,0x0CF9,0x0CED,0x0CB6,
	0x0CCB,0x0D65,0x0D77,0x0D04,0x0DBA,0x0E36,0x0C69,0x0DF3,
	0x0E27,0x0D76,0x0DD2,0x0DF8,0x0E2F,0x0EA7,0x0E7B,0x0E21,
	0x0E40,0x0EB5,0x0ED1,0x0EA5,0x0E62,0x0E60,0x0EAA,0x0F19,
	0x0EF1,0x0EEF,0x0F60,0x0F6C,0x0EEF,0x0EDF,0x0F12,0x0F0F,
	0x0F71,0x0F17,0x0F3C,0x0F52,0x0F3C,0x0F3B,0x0F5C,0x0F89,
	0x0F71,0x0F8D,0x0F09,0x0EDA,0x0F08,0x0EC4,0x0EB2,0x0EF3,
	0x0F03,0x0F29,0x0F9F,0x0F2F,0x0EE6,0x0EB2,0x0EA0,0x0E3C,
	0x0DE7,0x0DB3,0x0DB4,0x0D89,0x0DD6,0x0E45,0x0E28,0x0E11,
	0x0DDC,0x0E06,0x0DD2,0x0EE7,0x105D,0x0F7D,0x0F28,0x0ED4,
	0x0EC6,0x0E8C,0x0E1D,0x0DDD,0x0DFB,0x0DDD,0x0D9C,0x0D6F,
	0x0D4E,0x0D72,0x0D43,0x0CC0,0x0C7E,0x0C6B,0x0C2F,0x0C24,
	0x0CE7,0x0CA4,0x0B90,0x0ADB,0x0B1B,0x0B3F,0x0B1C,0x0B3F,
	0x0B16,0x0A96,0x0A60,0x09FE,0x0A18,0x09FE,0x09B1,0x0966,
	0x0971,0x0950,0x0909,0x0901,0x0936,0x0901,0x08F6,0x08C6,
	0x086B,0x074F,0x0804,0x08F5,0x08D7,0x0874,0x0862,0x07EB,
	0x083F,0x0831,0x07B9,0x06F0,0x065C,0x0608,0x05FC,0x0581,
	0x055F,0x0560,0x0591,0x0557,0x04FA,0x0490,0x04A2,0x04A8,
	0x04BE,0x04F9,0x04DA,0x04A8,0x04A9,0x04BA,0x049D,0x0470,
	0x0403,0x041F,0x043C,0x0419,0x0424,0x0423,0x0425,0x046A,
	0x0414,0x03DE,0x0407,0x03DA,0x037A,0x032C,0x02D6,0x02F3,
	0x0359,0x03B0,0x03B9,0x0387,0x035A,0x0367,0x032F,0x032B,
	0x032F,0x0342,0x0321,0x0362,0x0328,0x02E6,0x02C7,0x02D2,
	0x02F6,0x0320,0x0305,0x030C,0x02B3,0x0269,0x024E,0x02B9,
	0x029E,0x0297,0x02DE,0x026E,0x017F,0x0359,0x0201,0x014A,
	0x0276,0x01DE,0x01D1,0x01E1,0x01EA,0x01E9,0x02A2,0x0216,
	0x0276,0x0267,0x028E,0x0260,0x0298,0x026E,0x01CA,0x019D,
	0x0211,0x026F,0x021C,0x01CE,0x016C,0x017A,0x0180,0x01DC,
	0x01B5,0x01B8,0x018C,0x0115,0x0116,0x0140,0x00EE,0x0091,
	0x00AE,0x00CE,0x0089,0x00A9,0x00C5,0x00A6,0xFFAB,0x0016,
	0x00BA,0x00FF,0x022C,0x02F8,0x0343,0x0382,0x039F,0x039A,
	0x0403,0x0532,0x06CD,0x08B2,0x09AA,0x0A6B,0x0AB7,0x0A7E,
	0x0A8D,0x0B2A,0x0B67,0x0B93,0x0B73,0x0BBE,0x0D2C,0x0C50,
	0x0B8D,0x0B51,0x0B7E,0x0C2B,0x0CB3,0x0E16,0x0F7C,0x0FDA,
	0x0F7D,0x0F65,0x0FB6,0x109C,0x12AC,0x13FB,0x1498,0x1500,
	0x14A0,0x1401,0x13A7,0x14A0,0x15A0,0x159C,0x1573,0x165A,
	0x16E5,0x1709,0x16B9,0x1728,0x1751,0x1701,0x16BC,0x1746,
	0x1843,0x18BE,0x1810,0x1733,0x171C,0x177A,0x17AE,0x17D0,
	0x17F2,0x179B,0x177D,0x1719,0x1691,0x1684,0x16F4,0x169C,
	0x16A5,0x1720,0x16E5,0x161D,0x1520,0x14EB,0x152F,0x1504,
	0x146B,0x141E,0x1406,0x1364,0x1294,0x11D9,0x11B0,0x11A0,
	0x10A3,0x101D,0x0FB5,0x0F72,0x0EE3,0x0E16,0x0D5E,0x0D32,
	0x0CB8,0x0D4F,0x0C5E,0x0B14,0x0C80,0x0AD4,0x09D7,0x09E2,
	0x0A0C,0x09CA,0x092B,0x0894,0x081C,0x0781,0x06FF,0x06AF,
	0x06C6,0x062A,0x0540,0x042D,0x036F,0x03C0,0x040A,0x03FD,
	0x0354,0x02B0,0x01D0,0x00F2,0x00FA,0x0135,0x01A8,0x015F,
	0x0081,0x000F,0xFFCA,0xFF68,0xFE5F,0xFDB9,0xFD1E,0xFD3F,
	0xFD77,0xFD46,0xFCCE,0xFC77,0xFC16,0xFB79,0xFAA4,0xFA5F,
	0xFAD6,0xFAFB,0xFA9C,0xFA44,0xF8AF,0xF63C,0xF41F,0xF2A0,
	0xF0F2,0xEF33,0xECE0,0xE9CC,0xE6C4,0xE514,0xE576,0xE656,
	0xE8CA,0xE949,0xE870,0xE843,0xE867,0xE864,0xE822,0xE876,
	0xE8CB,0xE93E,0xE9AD,0xEAE2,0xEBB2,0xEBCA,0xEB36,0xEB06,
	0xEC60,0xEE3F,0xF048,0xF1B8,0xF2F1,0xF4FE,0xF586,0xF596,
	0xF6BA,0xF90A,0xFB09,0xFD0E,0xFD8D,0xFDF4,0xFEC4,0xFFBB,
	0x00B5,0x023C,0x0388,0x0471,0x0575,0x063C,0x07A6,0x08D4,
	0x0993,0x0986,0x08F1,0x095F,0x0A0E,0x0A23,0x0957,0x09FD,
	0x0A1B,0x09AB,0x08AA,0x07C9,0x07A6,0x076F,0x06AE,0x0559,
	0x0405,0x02B9,0x01CA,0x011B,0xFF96,0xFE84,0xFD26,0xFB36,
	0xF98C,0xF82F,0xF7B9,0xF71B,0xF5F1,0xF4AA,0xF26B,0xEFF7,
	0xEE33,0xED1F,0xECA4,0xEC15,0xEB72,0xEA32,0xE878,0xE68D,
	0xE51D,0xE4A3,0xE428,0xE3EB,0xE382,0xE2E0,0xE233,0xE16D,
	0xE0B7,0xE0D9,0xE0D6,0xE0B2,0xE049,0xE04A,0xE0BD,0xE134,
	0xE1A1,0xE15F,0xE0FA,0xE11B,0xE180,0xE26B,0xE337,0xE421,
	0xE4A1,0xE485,0xE45F,0xE4A7,0xE5BB,0xE6AF,0xE7E0,0xE8C2,
	0xE976,0xEA1D,0xEB16,0xECB6,0xEE80,0xEF54,0xF04D,0xF0C0,
	0xF158,0xF202,0xF491,0xF387,0xF476,0xF5F6,0xF632,0xF759,
	0xF7F1,0xF81E,0xF889,0xF91D,0xF966,0xFA88,0xFBAB,0xFC56,
	0xFC2D,0xFC4D,0xFC33,0xFC2D,0xFC6E,0xFCB6,0xFD8B,0xFDF7,
	0xFD2F,0xFBFD,0xFBAB,0xFBAF,0xFBBD,0xFBF9,0xFBF7,0xFBD0,
	0xFABC,0xF990,0xF8FA,0xF91A,0xF90D,0xF8DE,0xF85E,0xF799,
	0xF6D0,0xF617,0xF5AA,0xF64E,0xF6A3,0xF608,0xF43E,0xF31C,
	0xF34D,0xF3A3,0xF39F,0xF354,0xF32C,0xF264,0xF1B0,0xF18E,
	0xF217,0xF2E3,0xF24A,0xF0F2,0xF016,0xF001,0xF0C6,0xF1AA,
	0xF205,0xF138,0xEED1,0xEE33,0xEE18,0xEF24,0xF0F4,0xF21D,
	0xF21D,0xF204,0xF226,0xF217,0xF202,0xF28B,0xF38B,0xF44B,
	0xF43E,0xF482,0xF52D,0xF6B7,0xF771,0xF6CD,0xF719,0xF785,
	0xF7E3,0xF882,0xFA67,0xFB9C,0xFBBF,0xFB9B,0xFB26,0xFB7D,
	0xFC6A,0xFD87,0xFEFC,0xFFED,0xFFB3,0xFFB2,0x0033,0xFFF6,
	0x0077,0x00DF,0x0144,0x01C7,0x0235,0x0385,0x033F,0xFFC5,
	0xFBE1,0xF88F,0xF5D8,0xF2F3,0xEF8A,0xE9CE,0xE215,0xDAF5,
	0xD6AC,0xD601,0xD7F2,0xDA41,0xDBEB,0xDB49,0xD96E,0xD7FF,
	0xD81E,0xDA36,0xDCDD,0xDF63,0xE072,0xE0A9,0xE059,0xE12B,
	0xE246,0xE3BE,0xE57E,0xE79B,0xEAC4,0xEECA,0xF368,0xF7CD,
	0xFB62,0xFE42,0x00AB,0x035C,0x0751,0x0BD2,0x1065,0x149E,
	0x17B2,0x1972,0x1B3E,0x1DB0,0x2125,0x2486,0x2783,0x2A89,
	0x2D01,0x2F67,0x30EE,0x32CE,0x3481,0x355F,0x3608,0x36F8,
	0x3840,0x39F0,0x3A39,0x39CE,0x38D6,0x3737,0x357E,0x347B,
	0x3484,0x34BF,0x339D,0x307B,0x2D86,0x2B61,0x291B,0x26C4,
	0x24BC,0x237C,0x1ED9,0x1CBE,0x1A54,0x1662,0x136A,0x1082,
	0x0D3B,0x0A04,0x0781,0x0479,0x0195,0xFF38,0xFC8A,0xF95B,
	0xF5CB,0xF2B4,0xF0C7,0xEEEA,0xEC9C,0xEA66,0xE84E,0xE627,
	0xE3EE,0xE201,0xE10B,0xE07C,0xDF46,0xDDD7,0xDD13,0xDC90,
	0xDB63,0xDAA6,0xDB1C,0xDBA3,0xDC57,0xDC50,0xDCC9,0xDDA0,
	0xDE95,0xDF24,0xDF45,0xE002,0xE21D,0xE445,0xE5AD,0xE721,
	0xE903,0xEAB3,0xEBC4,0xED11,0xEEDF,0xF1B7,0xF45A,0xF646,
	0xF7D6,0xF951,0xFAD5,0xFC61,0xFE35,0x007F,0x02C1,0x0604,
	0x093F,0x095A,0x0A74,0x0C32,0x0D78,0x0E87,0x0F37,0x1061,
	0x11A6,0x1232,0x12CB,0x12ED,0x1365,0x13C0,0x1434,0x142B,
	0x147B,0x1423,0x1386,0x1245,0x1202,0x11D8,0x1193,0x1136,
	0x1111,0x0F9A,0x0DB3,0x0CB4,0x0C30,0x0B40,0x0A68,0x097A,
	0x0846,0x0670,0x04CB,0x03D5,0x0279,0x017B,0xFFE5,0xFE6A,
	0xFD54,0xFC00,0xFAF7,0xFA86,0xF8CF,0xF5C4,0xF4F1,0xF4A7,
	0xF498,0xF51A,0xF4DF,0xF35B,0xF148,0xF032,0xEF74,0xEEED,
	0xEEAD,0xEEBF,0xEF70,0xEDF6,0xEC0B,0xEB61,0xEC36,0xECDB,
	0xECF2,0xECB5,0xECF4,0xEDE0,0xEEFC,0xEF35,0xEF81,0xEFE9,
	0xF056,0xF186,0xF22F,0xF34C,0xF4DB,0xF647,0xF6B2,0xF665,
	0xF6AF,0xF7FC,0xF967,0xFA71,0xFB3F,0xFC35,0xFC90,0xFD07,
	0xFDB2,0xFECF,0xFFE4,0x00CB,0x01A9,0x02AF,0x034F,0x0440,
	0x04D2,0x0576,0x05FB,0x0670,0x0698,0x0656,0x069F,0x077A,
	0x0800,0x0747,0x04D2,0x0215,0xFE47,0xFA63,0xF684,0xF1C6,
	0xEB7A,0xE3F9,0xDD93,0xDA89,0xD929,0xDA25,0xDB9C,0xDBD7,
	0xDAF2,0xDB41,0xDA07,0xD86F,0xDB3F,0xDD5A,0xDEE8,0xDF5B,
	0xDFCF,0xDFAB,0xE087,0xE105,0xE26D,0xE4D6,0xE78F,0xEA9D,
	0xED8E,0xF207,0xF71B,0xFB79,0xFE21,0x00C7,0x03B9,0x080B,
	0x0CA4,0x10EC,0x14B1,0x1860,0x1AD4,0x1C53,0x1E99,0x2239,
	0x25A1,0x28D6,0x2B80,0x2DBC,0x30D8,0x337E,0x3593,0x3718,
	0x3804,0x38AE,0x3941,0x3A8C,0x3BE5,0x3D0D,0x3D18,0x3C29,
	0x3A74,0x38D1,0x37DD,0x378E,0x3744,0x3628,0x34B5,0x324F,
	0x2FC6,0x2D4B,0x2AA6,0x280F,0x258E,0x2375,0x213F,0x1E99,
	0x1B5A,0x164B,0x1157,0x0E5E,0x0B35,0x08BD,0x0694,0x03C3,
	0x007D,0xFD36,0xF9E7,0xF71E,0xF42B,0xF18C,0xEF9C,0xEDC1,
	0xEBC8,0xE99F,0xE74A,0xE57D,0xE2B9,0xE0AA,0xE03C,0xE019,
	0xDEEB,0xDD99,0xDCFB,0xDCEA,0xDCB7,0xDCD6,0xDC54,0xDC4F,
	0xDC95,0xDCF0,0xDE0E,0xDEC0,0xDFAE,0xE124,0xE278,0xE2D5,
	0xE440,0xE58C,0xE762,0xE903,0xEB4B,0xEE10,0xEEDC,0xEF32,
	0xF081,0xF2BF,0xF591,0xF820,0xF9EC,0xFB88,0xFD3F,0xFF64,
	0x01B7,0x041C,0x067F,0x08C0,0x09D5,0x0A54,0x0BAD,0x0D61,
	0x0F68,0x10B8,0x120C,0x12A2,0x12DD,0x132B,0x13A1,0x14EF,
	0x1600,0x1637,0x15AA,0x153B,0x1455,0x13E3,0x142D,0x146F,
	0x14D7,0x13DD,0x1224,0x110A,0x1064,0x0FCD,0x0F2A,0x0EAE,
	0x0D70,0x0C04,0x0AC4,0x096F,0x08A9,0x080C,0x0755,0x058E,
	0x03B4,0x0203,0x008B,0x0064,0xFFD5,0xFE35,0xFC74,0xFB31,
	0xFA47,0xF953,0xF8B8,0xF7C5,0xF6C3,0xF4F4,0xF3F0,0xF359,
	0xF38B,0xF3C8,0xF3E2,0xF235,0xF0CC,0xF056,0xF0DC,0xF1E7,
	0xF2F6,0xF20C,0xF01D,0xF158,0xF002,0xF02F,0xF1D6,0xF3A1,
	0xF420,0xF36D,0xF2D0,0xF358,0xF40A,0xF540,0xF630,0xF6E6,
	0xF751,0xF776,0xF7E5,0xF8DB,0xFA70,0xFBDA,0xFC21,0xFC66,
	0xFD12,0xFE2E,0xFF7E,0x00AF,0x0175,0x021C,0x027C,0x02F9,
	0x039E,0x04C4,0x061E,0x06CE,0x06A9,0x0659,0x0676,0x0703,
	0x080F,0x08D7,0x08F6,0x0893,0x07FF,0x068D,0x042F,0x0152,
	0xFECD,0xFBE1,0xF73F,0xF0FA,0xE98D,0xE26B,0xDCB5,0xD90E,
	0xD857,0xD9D1,0xDB03,0xDB3D,0xDA69,0xD98A,0xD9EA,0xDCD5,
	0xDE13,0xDE5E,0xDFD1,0xE164,0xE26B,0xE336,0xE374,0xE38E,
	0xE398,0xE4D4,0xE791,0xEBB7,0xF0EA,0xF5D3,0xF928,0xFB59,
	0xFD09,0xFFEB,0x036B,0x083C,0x0E01,0x121F,0x1533,0x179D,
	0x1988,0x1B43,0x1DD9,0x2048,0x235C,0x273B,0x2B67,0x2EEE,
	0x30F4,0x3125,0x31F9,0x32A1,0x33C4,0x359C,0x3821,0x3A81,
	0x3AA6,0x39F7,0x38EC,0x37F4,0x3683,0x351C,0x360E,0x36AF,
	0x35D2,0x341C,0x31C5,0x2F14,0x2C78,0x29E5,0x27BA,0x2518,
	0x225B,0x1FD3,0x1CB8,0x190F,0x15AB,0x1299,0x0F27,0x0B90,
	0x084F,0x05C1,0x03C9,0x0133,0xFE26,0xFA60,0xF6FE,0xF412,
	0xF193,0xEEC8,0xEC8C,0xEA96,0xE89D,0xE6B5,0xE417,0xE208,
	0xE054,0xDE29,0xDBF8,0xDAE8,0xDAB5,0xDB1D,0xDAAB,0xD986,
	0xD868,0xD74A,0xD6BB,0xD775,0xD8A8,0xDA02,0xDB18,0xDBB1,
	0xDB91,0xDC43,0xDD56,0xDF16,0xE10B,0xE336,0xE4CD,0xE627,
	0xE799,0xE93C,0xEB46,0xED23,0xEF19,0xF0F3,0xF2A6,0xF4C7,
	0xF725,0xFA34,0xFC99,0xFD90,0xFDAF,0xFF1C,0x018F,0x03B1,
	0x061A,0x0A1A,0x09E1,0x0A1B,0x0A36,0x0A58,0x0C7E,0x0EED,
	0x1085,0x117F,0x1213,0x1235,0x11E5,0x11F9,0x128D,0x1304,
	0x130D,0x1282,0x1314,0x139E,0x1304,0x120D,0x1086,0x0F71,
	0x0E7A,0x0E1C,0x0E0D,0x0D77,0x0C7E,0x0ACA,0x086A,0x06FC,
	0x0629,0x059C,0x04C9,0x03AA,0x0250,0x0092,0xFF39,0xFDCE,
	0xFCD9,0xFB73,0xF9DA,0xF8F8,0xF801,0xF6CB,0xF61E,0xF4ED,
	0xF3FB,0xF28A,0xF0F9,0xF05B,0xEFE5,0xEF82,0xEFA1,0xEF85,
	0xEEB3,0xEDE0,0xED52,0xED7C,0xEDE5,0xEEAF,0xEF25,0xEF14,
	0xEE2A,0xEC7B,0xECB0,0xEDB2,0xEE9E,0xEF3A,0xEF64,0xF077,
	0xF19C,0xF2A0,0xF3A3,0xF3EA,0xF4CF,0xF5A3,0xF67E,0xF7F7,
	0xF91F,0xFA09,0xFBD3,0xFCCF,0xFC83,0xFDFF,0xFF73,0xFF87,
	0x0098,0x01C2,0x0383,0x04D7,0x0593,0x06DD,0x0712,0x0745,
	0x07E4,0x088F,0x0960,0x0AA8,0x0C00,0x0CE9,0x0C78,0x0B07,
	0x0A02,0x0949,0x0801,0x053B,0x0207,0xFE74,0xF86C,0xF165,
	0xE98B,0xE233,0xDCF2,0xDB2C,0xDB6D,0xDC96,0xDE35,0xDEEE,
	0xDDC2,0xDB9C,0xDB26,0xDD8A,0xE006,0xE22E,0xE409,0xE474,
	0xE457,0xE3BF,0xE379,0xE47B,0xE697,0xE947,0xEC42,0xEFF9,
	0xF42C,0xF831,0xFB64,0xFDBB,0x00E9,0x050C,0x0931,0x0DB9,
	0x11CA,0x15D6,0x192D,0x1C05,0x1DD2,0x1FBB,0x2287,0x2617,
	0x297F,0x2C4F,0x2F9F,0x3267,0x346E,0x35CD,0x36E3,0x3870,
	0x3A63,0x3BD3,0x3CFC,0x3DED,0x3E7F,0x3EB2,0x3DCF,0x3C8E,
	0x3B3E,0x3A3E,0x3937,0x38A8,0x387A,0x3755,0x34D0,0x3165,
	0x2E44,0x2BAC,0x2935,0x2741,0x25DF,0x2362,0x2030,0x1C96,
	0x194A,0x1396,0x11B4,0x1022,0x0BDF,0x08DC,0x05EF,0x02E4,
	0xFF6F,0xFBF8,0xF860,0xF54E,0xF229,0xEF83,0xEDA0,0xEBFC,
	0xEA50,0xE805,0xE4D9,0xE1E4,0xDFC0,0xDEC4,0xDE31,0xDD4B,
	0xDD2F,0xDCAC,0xDB6A,0xD952,0xD7B0,0xD806,0xD956,0xDA35,
	0xDABB,0xDB11,0xDBC0,0xDC62,0xDC8B,0xDD30,0xDEF6,0xE08F,
	0xE209,0xE3CE,0xE552,0xE75F,0xE906,0xEA70,0xEBCB,0xEDB1,
	0xEFA3,0xF18C,0xF41C,0xF647,0xF845,0xFA34,0xFBA5,0xFCD0,
	0xFE48,0x0037,0x0291,0x051B,0x068E,0x0798,0x0A1F,0x0CD6,
	0x0D45,0x0E58,0x0FF4,0x10B3,0x1127,0x11A2,0x126C,0x12F9,
	0x1379,0x13AE,0x13A9,0x1346,0x12ED,0x139F,0x13CD,0x136B,
	0x11F7,0x1027,0x0E51,0x0E3B,0x0E8C,0x0DFA,0x0D01,0x0C1B,
	0x09B3,0x0763,0x0628,0x05A6,0x04EF,0x0437,0x0316,0x0118,
	0xFF45,0xFD9E,0xFD53,0xFC4F,0xFA97,0xF8E9,0xF7E5,0xF72A,
	0xF5C5,0xF447,0xF3DA,0xF2F0,0xF0BF,0xEFA6,0xEFA2,0xEF29,
	0xEF0B,0xEEC5,0xEDDA,0xED55,0xED2E,0xED11,0xEC81,0xEBA2,
	0xEB64,0xEB58,0xEB11,0xEB29,0xEBBC,0xEB6B,0xEBF0,0xECA7,
	0xED6D,0xEE04,0xEEE2,0xEFAA,0xF023,0xF0B4,0xF14D,0xF1AC,
	0xF2AC,0xF3A9,0xF515,0xF688,0xF7A8,0xF860,0xF8FF,0xF9A5,
	0xFA40,0xFB8A,0xFCFB,0xFE64,0xFF7D,0xFFB2,0xFFC7,0x0080,
	0x019F,0x02E7,0x03A0,0x044D,0x04E6,0x0530,0x051B,0x05B5,
	0x0680,0x0696,0x06C1,0x05D5,0x04A5,0x023D,0xFF53,0xFB9F,
	0xF7A7,0xF332,0xEC0F,0xE272,0xDA51,0xD4FA,0xD2FD,0xD443,
	0xD747,0xDAF1,0xDDCB,0xDC5C,0xDB07,0xDBC6,0xDE09,0xE01D,
	0xE342,0xE36F,0xE234,0xE349,0xE1D1,0xE0D8,0xE0E1,0xE1E4,
	0xE35A,0xE69F,0xEC48,0xF362,0xF98F,0xFE0A,0x00F5,0x031C,
	0x05F0,0x0A06,0x0F1E,0x13EC,0x17DB,0x19A6,0x1A14,0x1A14,
	0x1B39,0x1E14,0x21DE,0x2663,0x29FE,0x2D87,0x30A6,0x332F,
	0x34E9,0x364B,0x376E,0x388B,0x392C,0x3A0C,0x3B1D,0x3BF3,
	0x3B3B,0x3890,0x3661,0x3471,0x337C,0x334B,0x3365,0x336A,
	0x3274,0x3094,0x2D5C,0x2A8E,0x2864,0x269E,0x248B,0x217A,
	0x1E25,0x1A9A,0x1754,0x13E9,0x0FEE,0x0BE2,0x081A,0x04D1,
	0x00F4,0xFE1D,0xFCD7,0xFA9A,0xF7B1,0xF48D,0xF15F,0xEEA2,
	0xEC65,0xEA37,0xE88F,0xE6E0,0xE422,0xE17D,0xDF58,0xDD5B,
	0xDBD0,0xDAC3,0xDABC,0xDA6E,0xDA2E,0xDA7B,0xDA41,0xD93D,
	0xD8D1,0xD8B7,0xDA2C,0xDB5E,0xDC2E,0xDC8A,0xDD54,0xDE05,
	0xDF33,0xE0C2,0xE218,0xE35B,0xE4A5,0xE65C,0xE8B9,0xEAF1,
	0xECD8,0xEE82,0xEF9E,0xF22E,0xF4E1,0xF5CF,0xF772,0xF97D,
	0xFBE6,0xFD97,0xFEFA,0x0057,0x0250,0x0421,0x069C,0x090F,
	0x0ADC,0x0BA5,0x0CB2,0x0E01,0x0EFC,0x1097,0x1199,0x1292,
	0x138A,0x13AB,0x1339,0x12C6,0x1324,0x1386,0x139A,0x132D,
	0x13DC,0x1455,0x137A,0x1218,0x10E2,0x1042,0x0F9C,0x0ECD,
	0x0E0B,0x0D2A,0x0C47,0x0AD1,0x08EA,0x0754,0x0624,0x0594,
	0x047B,0x034F,0x01DF,0x004F,0xFFD0,0xFE73,0xFD28,0xFBE8,
	0xFA34,0xF884,0xF774,0xF71F,0xF651,0xF522,0xF3BE,0xF1E5,
	0xF18C,0xF0FE,0xF047,0xF09A,0xF0A2,0xF013,0xEF10,0xEE6F,
	0xEE46,0xEE93,0xEE6C,0xEE49,0xEED5,0xEEE5,0xEF79,0xF0D2,
	0xF07C,0xEF67,0xF1D9,0xF1E0,0xF256,0xF2E1,0xF39A,0xF476,
	0xF536,0xF5C6,0xF696,0xF7AD,0xF8C1,0xF93A,0xF9E8,0xFAB5,
	0xFC0E,0xFD02,0xFD5B,0xFE35,0xFF56,0x00A6,0x0127,0x01F2,
	0x0297,0x0393,0x044E,0x04E3,0x0587,0x06CF,0x0771,0x077E,
	0x07C5,0x0838,0x0911,0x094F,0x094D,0x096A,0x09AD,0x08D1,
	0x0678,0x038B,0x0049,0xFCCA,0xF79E,0xF050,0xE74F,0xDE15,
	0xD633,0xD1E4,0xD1F8,0xD501,0xD9CB,0xDCFB,0xDDBD,0xDD87,
	0xDDDC,0xDF80,0xE235,0xE47E,0xE60A,0xE5B2,0xE561,0xE2FC,
	0xDFCA,0xDEC2,0xDF45,0xE0D8,0xE4A3,0xEA37,0xF0F7,0xF811,
	0xFDEE,0x029B,0x06B2,0x09CB,0x0DAA,0x11EC,0x15EC,0x18AC,
	0x196E,0x1849,0x17D4,0x1999,0x1B7A,0x1DA8,0x2201,0x26F2,
	0x2B3D,0x2FD4,0x33C9,0x3761,0x3A78,0x3C33,0x3C9C,0x3D12,
	0x3CFF,0x3D68,0x3CB8,0x3A78,0x3720,0x33EC,0x31FD,0x31E3,
	0x3277,0x333C,0x32FB,0x33A0,0x3325,0x3164,0x304B,0x2ED6,
	0x2BFA,0x2856,0x247C,0x20A7,0x1BE7,0x17EC,0x13D4,0x0F7F,
	0x0B0F,0x0736,0x03C0,0x02D6,0x0244,0x00D7,0xFE8D,0xFBC4,
	0xF868,0xF4F2,0xF274,0xEFF7,0xED4C,0xEA26,0xE65A,0xE31C,
	0xE06D,0xDDC7,0xDC04,0xDA97,0xD9E6,0xD9EE,0xDAD6,0xDB0E,
	0xDB53,0xDB5E,0xDAA2,0xD9D9,0xD94A,0xD8F0,0xD952,0xD9F2,
	0xD9C9,0xD9F7,0xD9F7,0xDA78,0xDB74,0xDCF8,0xDF24,0xE1C2,
	0xE47C,0xE697,0xE8E4,0xEBCC,0xEE4D,0xEF6F,0xF01C,0xF161,
	0xF2D2,0xF444,0xF59B,0xF76C,0xF9F3,0xFB81,0xFBDC,0xFCF0,
	0xFF92,0x038B,0x06BA,0x0829,0x0A72,0x0CE1,0x0D88,0x0D51,
	0x0F77,0x0E72,0x0F04,0x0F55,0x0EE6,0x0F15,0x0FE4,0x107B,
	0x10D8,0x10EB,0x10F2,0x115D,0x115B,0x1142,0x113B,0x116B,
	0x1085,0x0F62,0x0DF5,0x0C5F,0x0AA4,0x0977,0x0861,0x0763,
	0x06B1,0x04E7,0x032B,0x01F3,0x00F7,0x0031,0xFFC7,0xFF3D,
	0xFE91,0xFD5D,0xFB8E,0xF980,0xF7EB,0xF730,0xF622,0xF4BA,
	0xF313,0xF21A,0xF13A,0xF0AC,0xEFF9,0xEF53,0xEF2E,0xEF50,
	0xEF5F,0xEF08,0xEED0,0xEEB6,0xEF08,0xEEE6,0xEE72,0xED63,
	0xECD1,0xEDB4,0xEECF,0xEF45,0xEF6E,0xEFC8,0xEFFA,0xF050,
	0xEFE7,0xF149,0xF261,0xF31F,0xF3E1,0xF4C2,0xF61F,0xF73A,
	0xF7E9,0xF834,0xF872,0xF93F,0xFA3C,0xFBCA,0xFD1C,0xFE7D,
	0xFF33,0x000A,0x0088,0x012C,0x0332,0x0566,0x056A,0x0528,
	0x05AD,0x05CB,0x0644,0x07C0,0x083E,0x0867,0x0841,0x07E5,
	0x083C,0x08D9,0x09A2,0x0921,0x070D,0x043E,0x0175,0xFE6F,
	0xFA57,0xF4CE,0xEF2D,0xE852,0xE1E1,0xDF7C,0xDFE1,0xE2D2,
	0xE601,0xE7BA,0xE7B8,0xE6F9,0xE74E,0xE978,0xEC42,0xEE00,
	0xEE2E,0xECD7,0xEB2D,0xE8EE,0xE767,0xE6BB,0xE70E,0xE89F,
	0xEAF4,0xEF09,0xF4C7,0xFA32,0xFE1C,0x0087,0x02E4,0x0609,
	0x086C,0x0B53,0x0E55,0x1028,0x10A3,0x101A,0x0F73,0x0FE8,
	0x11DA,0x1557,0x18BB,0x1BDF,0x1F5E,0x22C7,0x25C0,0x27C9,
	0x2A32,0x2BF0,0x2C0A,0x2BD8,0x2B76,0x2B50,0x2B2A,0x29E6,
	0x26F2,0x2488,0x2391,0x23B2,0x24B4,0x25DE,0x2732,0x2724,
	0x25B0,0x2382,0x2289,0x21DB,0x20C9,0x1EF7,0x1C5F,0x1957,
	0x162A,0x11FB,0x0E6F,0x0BDB,0x0A0D,0x081D,0x0680,0x05A6,
	0x0272,0x02AB,0x01ED,0xFEED,0xFCEE,0xFB1B,0xF902,0xF640,
	0xF420,0xF202,0xEF92,0xEC82,0xEA03,0xE859,0xE6EB,0xE5FC,
	0xE566,0xE5EC,0xE6C4,0xE70C,0xE6B9,0xE6D1,0xE712,0xE722,
	0xE66A,0xE5E2,0xE5D9,0xE68B,0xE6D0,0xE649,0xE5A1,0xE61E,
	0xE75A,0xE8C0,0xEA51,0xEC69,0xEEFC,0xF0A8,0xF1A5,0xF333,
	0xF54A,0xF69C,0xF6D5,0xF6F3,0xF807,0xF9B5,0xFB43,0xFC5E,
	0xFCFE,0xFE30,0xFF30,0x0016,0x01B5,0x0400,0x0640,0x079E,
	0x08C7,0x092F,0x097D,0x0A28,0x0AB9,0x0C40,0x0EB5,0x0EBD,
	0x0E24,0x0D7C,0x0D15,0x0D5E,0x0E20,0x0E39,0x0E4D,0x0EF8,
	0x0F2E,0x0F45,0x0E98,0x0DCA,0x0D2A,0x0C8A,0x0B0C,0x09C2,
	0x08A1,0x075E,0x0795,0x06C4,0x04DB,0x03A7,0x02D9,0x01DD,
	0x0129,0x0108,0x00CF,0x005C,0xFF42,0xFE3C,0xFCE0,0xFB8B,
	0xF9E4,0xF972,0xF8C6,0xF7CF,0xF6D9,0xF5BC,0xF4BC,0xF3F4,
	0xF3A8,0xF38C,0xF313,0xF1E4,0xF2AE,0xF399,0xF356,0xF30E,
	0xF350,0xF309,0xF242,0xF1CB,0xF1D4,0xF21B,0xF195,0xF1A2,
	0xF179,0xF148,0xF12A,0xF1CC,0xF2DF,0xF395,0xF3AE,0xF3B9,
	0xF405,0xF536,0xF691,0xF706,0xF6FD,0xF6F3,0xF6EE,0xF7A0,
	0xF8FF,0xFA6E,0xFB0A,0xFB7A,0xFBA5,0xFBE5,0xFCC5,0xFDA9,
	0xFECF,0xFFEE,0x0092,0x00DD,0x00E0,0x01AD,0x024C,0x0312,
	0x02EF,0x027F,0x0234,0x029D,0x03B3,0x04FE,0x051A,0x03E7,
	0x02E8,0x01F2,0x004F,0xFE51,0xFCB9,0xFBC2,0xFACA,0xF93A,
	0xF7BF,0xF74D,0xF7CA,0xF840,0xF83C,0xF8A6,0xF968,0xFA4D,
	0xFA97,0xFB18,0xFA93,0xF9F2,0xF945,0xF8D7,0xF72F,0xF84B,
	0xF80A,0xF75F,0xF89D,0xF8CB,0xF9A4,0xFA79,0xFB7F,0xFC8D,
	0xFE39,0xFEE1,0x0001,0x009E,0x00E5,0x010D,0x0137,0x0127,
	0x011E,0x019F,0x0238,0x02C2,0x02FE,0x03B2,0x049A,0x0599,
	0x06A3,0x07F0,0x090B,0x09A2,0x0952,0x091E,0x09CA,0x0A35,
	0x0AA0,0x0A24,0x0958,0x08ED,0x089F,0x088F,0x0898,0x0941,
	0x09DC,0x09AC,0x0949,0x0967,0x09AB,0x0954,0x08BC,0x085F,
	0x081F,0x0712,0x0621,0x05D4,0x05E8,0x0584,0x04B4,0x0332,
	0x026F,0x027E,0x0236,0x01D0,0x018A,0x00F2,0xFFF6,0xFDB7,
	0xFBCE,0xFB9F,0xFB1C,0xFA89,0xF97B,0xF84A,0xF7CA,0xF737,
	0xF6B5,0xF5CE,0xF4DB,0xF3F3,0xF30E,0xF259,0xF218,0xF242,
	0xF246,0xF209,0xEFEC,0xEEB1,0xEF1E,0xEF47,0xEF25,0xEF1D,
	0xEEF9,0xEE6D,0xEE3A,0xEE32,0xEDEC,0xEDCE,0xEDA8,0xED1A,
	0xED39,0xECE4,0xEC91,0xEC4B,0xEC10,0xEBAB,0xEB55,0xEAEE,
	0xEB14,0xEAB3,0xEAC2,0xEB53,0xEA29,0xE90A,0xE8FB,0xE8F4,
	0xE8E1,0xE8DF,0xE899,0xE86A,0xE8B5,0xE8E4,0xE926,0xE930,
	0xE95C,0xE9FA,0xEA1A,0xE96B,0xE912,0xE8D8,0xE88F,0xE888,
	0xE84D,0xE879,0xE8A4,0xE8D5,0xE8E9,0xE8A7,0xE8EA,0xE8A2,
	0xE862,0xE8AB,0xE91A,0xE998,0xE9CA,0xE9E3,0xEA4D,0xEA30,
	0xEA42,0xEA6F,0xEAAD,0xEAD4,0xEB0A,0xEB1B,0xEB77,0xEBA5,
	0xEBE4,0xEC52,0xECA7,0xECC1,0xED97,0xEE2B,0xEE9B,0xEF90,
	0xF041,0xF05C,0xF035,0xF0B7,0xF18D,0xF285,0xF376,0xF441,
	0xF4BB,0xF4DB,0xF57C,0xF61D,0xF69E,0xF711,0xF7BA,0xF808,
	0xF855,0xF892,0xF8FB,0xF9B3,0xFA46,0xFA7F,0xFB73,0xFB5B,
	0xFABE,0xFD82,0xFD05,0xFC66,0xFD5A,0xFDDA,0xFDE2,0xFE44,
	0xFEC1,0xFEFE,0xFF11,0xFF4C,0xFF77,0xFFFA,0x0006,0x0077,
	0x013A,0x0196,0x01EB,0x01D6,0x0210,0x0290,0x0308,0x031C,
	0x0340,0x03CA,0x0467,0x047D,0x04D9,0x0521,0x0560,0x05C5,
	0x0607,0x0669,0x06EE,0x0750,0x0770,0x07B1,0x082B,0x0823,
	0x0842,0x08B0,0x0910,0x090D,0x0930,0x096F,0x09BD,0x09F2,
	0x0A2D,0x0A87,0x0A61,0x0A72,0x0A74,0x0A97,0x0AC6,0x0AFC,
	0x0B50,0x0B67,0x0B62,0x0BC1,0x0C5F,0x0E61,0x0E50,0x0D1E,
	0x0D4A,0x0D75,0x0D6A,0x0D13,0x0D68,0x0D53,0x0D30,0x0D50,
	0x0D13,0x0D3F,0x0CD3,0x0C9A,0x0C68,0x0CB2,0x0CEB,0x0CE6,
	0x0C92,0x0CED,0x0DD7,0x0DB9,0x0D1E,0x0CF5,0x0D9F,0x0D5F,
	0x0D6E,0x0D87,0x0DA1,0x0E02,0x0DCD,0x0D83,0x0D98,0x0DD6,
	0x0DC3,0x0DBC,0x0DC8,0x0D96,0x0D4B,0x0D78,0x0D91,0x0DC4,
	0x0DA2,0x0DE3,0x0D6A,0x0C32,0x0D1C,0x0DB5,0x0DBE,0x0DE9,
	0x0D99,0x0D30,0x0D1B,0x0CE2,0x0CD7,0x0C29,0x0BB4,0x0B60,
	0x0B60,0x0A8F,0x0AA0,0x0AAA,0x0A91,0x0A91,0x0A2B,0x09EF,
	0x09F6,0x0A61,0x0A63,0x0A1C,0x0A36,0x0A3A,0x0A45,0x0A6B,
	0x0AAB,0x0AE8,0x0AF1,0x0ADF,0x0B14,0x0B15,0x0AEC,0x0AB2,
	0x0AD7,0x0AB2,0x0A73,0x0A99,0x0A99,0x0A95,0x0AAF,0x0A81,
	0x0A48,0x098E,0x098A,0x09BF,0x092F,0x0912,0x0915,0x0951,
	0x0972,0x0937,0x08CC,0x0850,0x0895,0x091A,0x090F,0x08A9,
	0x0896,0x0834,0x083E,0x0889,0x08B6,0x08F7,0x087A,0x0801,
	0x08B7,0x08C5,0x08FC,0x0924,0x0951,0x090B,0x08FA,0x09F0,
	0x0821,0x088A,0x0872,0x0815,0x0851,0x084B,0x07F3,0x07D5,
	0x07A8,0x0769,0x0740,0x0733,0x0789,0x0765,0x07EC,0x074D,
	0x0713,0x06D5,0x069D,0x06F2,0x0762,0x0795,0x0762,0x0736,
	0x072B,0x06BE,0x0693,0x068D,0x061A,0x0680,0x0673,0x06B1,
	0x0658,0x05E5,0x05D9,0x05DB,0x05FC,0x0599,0x0597,0x05A0,
	0x05E6,0x05B3,0x055F,0x056E,0x056E,0x059D,0x05AB,0x058A,
	0x0553,0x052D,0x04D8,0x049A,0x04C3,0x04D3,0x04C8,0x0469,
	0x0473,0x04D2,0x0465,0x03CE,0x03B6,0x0396,0x0279,0x00CF,
	0x0112,0x01EB,0x01D1,0x01F3,0x01F3,0x01C0,0x01A1,0x021B,
	0x0242,0x01C1,0x01D1,0x01AF,0x01EF,0x01EE,0x022F,0x023B,
	0x02B4,0x01E9,0x0100,0x01B2,0x022C,0x022C,0x0209,0x0249,
	0x0257,0x01FE,0x0265,0x02C5,0x025B,0x025F,0x0282,0x02C8,
	0x02D7,0x02AA,0x0281,0x01F7,0x019B,0x01EB,0x0241,0x0252,
	0x02D3,0x0275,0x0313,0x032B,0x01E3,0x01B2,0x01DD,0x0234,
	0x0241,0x0239,0x0238,0x025A,0x027D,0x0291,0x02EC,0x035C,
	0x0369,0x038C,0x0357,0x0323,0x031A,0x0314,0x037C,0x035D,
	0x0332,0x02F9,0x02F8,0x02A2,0x025C,0x0283,0x0288,0x02B8,
	0x034F,0x02CF,0x029D,0x0284,0x0241,0x01FC,0x019D,0x01A5,
	0x01B7,0x0193,0x015F,0x014E,0x014D,0x013E,0x01A3,0x01B6,
	0x017D,0x017C,0x0139,0x0146,0x00D8,0x0095,0x00E1,0x0133,
	0x0136,0x00E1,0x00DE,0x0126,0x0121,0x0106,0x010E,0x00E0,
	0x00FA,0x00FB,0x008A,0xFFD8,0xFFBE,0xFFD6,0xFFFC,0xFFDD,
	0xFFD8,0xFF95,0xFF5F,0xFF97,0xFFD1,0xFFB1,0xFF1D,0xFF15,
	0xFF71,0xFF53,0xFEFF,0xFF4D,0xFFCB,0xFDD4,0xFF1C,0x0124,
	0x00B6,0x00FC,0x0173,0x01F2,0x02F8,0x03D2,0x0449,0x0544,
	0x05AD,0x05B3,0x0617,0x07AC,0x0A21,0x0B12,0x0A7E,0x0A12,
	0x0A68,0x0A72,0x0A3D,0x09C7,0x0977,0x0966,0x09CC,0x0A65,
	0x0AF0,0x0A94,0x097D,0x084F,0x08D2,0x0A4F,0x0C35,0x0C00,
	0x0A35,0x0915,0x09A8,0x0BB4,0x0CF9,0x0D30,0x0CAC,0x0C0F,
	0x0C4F,0x0DCD,0x0F01,0x0E91,0x0D83,0x0E00,0x0EEE,0x106C,
	0x10E8,0x1044,0x0F35,0x0E64,0x0EFC,0x1077,0x11BC,0x11B5,
	0x1112,0x1083,0x117A,0x136A,0x12F6,0x1279,0x11E0,0x11EC,
	0x12A3,0x13D8,0x14BF,0x1445,0x1253,0x110C,0x11A2,0x1394,
	0x14D7,0x13E7,0x1253,0x10E8,0x107A,0x10AC,0x1136,0x1349,
	0x13F0,0x120F,0x0FE8,0x1093,0x115A,0x1152,0x1079,0x0F78,
	0x0FDD,0x10B9,0x10CE,0x0FFE,0x0F10,0x0E4B,0x0F06,0x100C,
	0x10D6,0x10A1,0x0FC5,0x0E60,0x0DAB,0x0DA2,0x0F08,0x0FF1,
	0x0DF2,0x0D77,0x0DC6,0x0C89,0x0D06,0x0D69,0x0D03,0x0C3B,
	0x0BAD,0x0AEF,0x09E5,0x0674,0x021B,0xFED8,0xFB19,0xF7D3,
	0xF612,0xF3FC,0xF357,0xF387,0xF510,0xF6A5,0xF66C,0xF424,
	0xF0E3,0xEDEF,0xED48,0xEE48,0xEF9A,0xF000,0xEEEC,0xEDF9,
	0xEED0,0xF0CB,0xF291,0xF3C9,0xF480,0xF4EA,0xF409,0xF33E,
	0xF45F,0xF634,0xF851,0xF9CE,0xFB05,0xFC57,0xFDAF,0xFE8A,
	0xFFB2,0x0132,0x02A0,0x042D,0x056E,0x063E,0x06C3,0x079A,
	0x0910,0x0A9F,0x0BD7,0x0CB5,0x0D25,0x0D2B,0x0D80,0x0E46,
	0x0F0B,0x0F20,0x0F1A,0x0F28,0x0ED6,0x0F26,0x0EF4,0x0E2A,
	0x0E28,0x0E55,0x0D6C,0x0B92,0x0C95,0x0B9C,0x0918,0x0972,
	0x081A,0x0766,0x06A0,0x05D5,0x045F,0x0306,0x0191,0x005E,
	0xFEA6,0xFCB8,0xFB9E,0xFAB4,0xF915,0xF6E7,0xF52B,0xF37D,
	0xF28D,0xF17E,0xEFF5,0xEE62,0xED45,0xEBCA,0xEA22,0xE929,
	0xE7D6,0xE66B,0xE519,0xE4E6,0xE4CD,0xE4C1,0xE374,0xE1BD,
	0xE0FC,0xE0B0,0xE05F,0xE0D5,0xE11B,0xE078,0xDF44,0xDE8F,
	0xDF96,0xE0FF,0xE147,0xE116,0xE154,0xE1E4,0xE20D,0xE288,
	0xE343,0xE41A,0xE46B,0xE55F,0xE666,0xE7E7,0xE893,0xE7F3,
	0xE867,0xEA0A,0xEB54,0xEBE4,0xEAB0,0xEA73,0xEBD2,0xECA4,
	0xEDDD,0xEF68,0xF052,0xF057,0xF089,0xF0D1,0xF31C,0xF4D7,
	0xF582,0xF501,0xF475,0xF532,0xF72A,0xF8A1,0xF997,0xF83E,
	0xF6F6,0xF80E,0xF95F,0xFA0F,0xF9CC,0xF93C,0xF8FF,0xF91B,
	0xF9D3,0xF9CC,0xF9A2,0xF916,0xF8B7,0xF8DD,0xF929,0xF8A6,
	0xF808,0xF713,0xF6BF,0xF770,0xF793,0xF6BF,0xF587,0xF485,
	0xF589,0xF553,0xF502,0xF531,0xF46E,0xF30A,0xF1EC,0xF1C6,
	0xF295,0xF2E2,0xF2CE,0xF24C,0xF1F2,0xF1BC,0xF207,0xF1AC,
	0xF12E,0xF159,0xF11A,0xF103,0xF182,0xF159,0xF0CF,0xEFD8,
	0xEFC1,0xF0D3,0xF1B7,0xF1E5,0xF0CA,0xF03E,0xF03B,0xF0FA,
	0xF220,0xF360,0xF3B0,0xF38E,0xF318,0xF3B6,0xF4C3,0xF534,
	0xF53B,0xF5AE,0xF6D2,0xF7CC,0xF7AF,0xF772,0xF818,0xF947,
	0xF9C2,0xF9ED,0xFA4A,0xFB3F,0xFADD,0xFA2D,0xFA54,0xFBBC,
	0xFCF0,0xFDAA,0xFDEF,0xFDC9,0xFDDF,0xFE27,0xFE5D,0xFF0E,
	0xFF8E,0xFFAF,0xFF40,0xFF4D,0xFFA8,0xFFE6,0xFE3B,0xFB4E,
	0xF6F0,0xF226,0xED04,0xE71C,0xDF57,0xDA74,0xDCC2,0xDF00,
	0xE289,0xE5C1,0xE4D9,0xE042,0xDA4A,0xD6AC,0xD720,0xD974,
	0xDAED,0xDA80,0xD999,0xDA28,0xDC44,0xDF53,0xE254,0xE533,
	0xE7E1,0xEAD1,0xECB6,0xED22,0xECD0,0xEE2B,0xF1C7,0xF68D,
	0xFCB6,0x0207,0x04A8,0x05D2,0x0706,0x09B8,0x0D7D,0x1226,
	0x161E,0x18D1,0x1A44,0x1ADA,0x1CB2,0x2008,0x23FC,0x2745,
	0x2948,0x2AEF,0x2C73,0x2D52,0x2DC2,0x2E13,0x2F3A,0x302B,
	0x315D,0x31F9,0x31D4,0x311C,0x2F9A,0x2ECA,0x2E01,0x2DBC,
	0x2D48,0x2C1A,0x2BA5,0x292C,0x2608,0x2396,0x2170,0x2048,
	0x1F63,0x1D37,0x1926,0x14F0,0x11A9,0x1014,0x0E9D,0x0C41,
	0x0905,0x05C6,0x02E7,0x005E,0xFD91,0xFA32,0xF862,0xF758,
	0xF4E1,0xF156,0xEE5C,0xEC87,0xEA62,0xE84B,0xE5F5,0xE529,
	0xE50D,0xE425,0xE1A3,0xDF1A,0xDD68,0xDD2E,0xDD45,0xDDCB,
	0xDE11,0xDD7E,0xDC7F,0xDBFD,0xDC16,0xDD5F,0xDF2A,0xDFC1,
	0xDFED,0xE0FC,0xE1A3,0xE274,0xE37D,0xE533,0xE77E,0xE9B8,
	0xEB1C,0xEC73,0xEC71,0xEC62,0xEE40,0xF076,0xF216,0xF459,
	0xF645,0xF78C,0xF86C,0xF8EB,0xFA20,0xFCE1,0x0001,0x020B,
	0x0383,0x039C,0x0435,0x05BF,0x076E,0x091E,0x0A97,0x0B1E,
	0x0BE9,0x0CFC,0x0DB4,0x0DEF,0x0D22,0x0C17,0x0CB0,0x0E12,
	0x0FE3,0x0FF7,0x0E88,0x0C01,0x0A33,0x0A73,0x0BB3,0x0CB0,
	0x0D0F,0x0B9A,0x0927,0x06E8,0x05EC,0x06E0,0x079D,0x0661,
	0x045A,0x020D,0x00C8,0xFF8B,0xFEA2,0xFDB6,0xFD50,0xFC98,
	0xFAE6,0xF902,0xF7B9,0xF71F,0xF6D4,0xF696,0xF585,0xF4D4,
	0xF41A,0xF22F,0xF0C8,0xF0A4,0xF35D,0xF18C,0xF0A3,0xEFD0,
	0xEEC9,0xEE85,0xEEFA,0xEFAB,0xEF91,0xEF34,0xEF75,0xEFF2,
	0xEFE2,0xF034,0xF07A,0xF0E7,0xF0D6,0xF1DA,0xF36A,0xF3FC,
	0xF3A0,0xF2C9,0xF329,0xF54B,0xF7CB,0xF8E2,0xF8FF,0xF937,
	0xF9AB,0xFA2C,0xFB48,0xFCAE,0xFDF3,0xFF16,0xFF7A,0xFFE0,
	0x00E1,0x01F0,0x028D,0x02FD,0x03E6,0x05F9,0x070E,0x06A0,
	0x05A2,0x0561,0x0681,0x083B,0x0934,0x0958,0x08CE,0x07D5,
	0x075D,0x07F2,0x078A,0x0457,0xFE3D,0xF683,0xEF40,0xE8B6,
	0xE378,0xDF53,0xDED3,0xE20F,0xE588,0xE7FD,0xE5B6,0xDFCD,
	0xD98D,0xD5AC,0xD584,0xD800,0xDAFD,0xDBDD,0xDADC,0xD8C8,
	0xD88F,0xDC1E,0xE230,0xE70D,0xEA5F,0xEBB5,0xEB05,0xEA0F,
	0xEB5A,0xEEE7,0xF40A,0xFA4C,0x00F9,0x0624,0x0890,0x0997,
	0x0AAD,0x0D81,0x128A,0x18B4,0x1E8D,0x20B7,0x20CC,0x20A9,
	0x2305,0x2773,0x2CD2,0x31E4,0x34DA,0x359F,0x3575,0x36AD,
	0x3826,0x37EC,0x3891,0x3A8C,0x3C31,0x3DFF,0x3E76,0x3D03,
	0x3A87,0x38D5,0x39CA,0x3C13,0x3C51,0x3A3F,0x375D,0x33B0,
	0x3120,0x2F98,0x2E44,0x2CF7,0x2B0B,0x27E3,0x23C0,0x2062,
	0x1D86,0x1A89,0x176D,0x147E,0x11FC,0x0FAF,0x0C97,0x0865,
	0x0450,0x0117,0xFE3D,0xFBE0,0xF9FA,0xF822,0xF510,0xF186,
	0xEDD5,0xEB27,0xE9C7,0xE8AB,0xE752,0xE57E,0xE3AB,0xE1C5,
	0xE02D,0xDEF9,0xDE32,0xDDC2,0xDD5B,0xDDBE,0xDDFF,0xDDE7,
	0xDD0B,0xDC10,0xDC62,0xDE5B,0xE0AC,0xE23A,0xE2E1,0xE355,
	0xE3AA,0xE4C6,0xE6B2,0xE858,0xEA99,0xEC3A,0xEE12,0xEFBC,
	0xF139,0xF339,0xF551,0xF77E,0xF7A6,0xFBDC,0xFF00,0xFF96,
	0x00B6,0x0108,0x0249,0x04C5,0x0778,0x0A1F,0x0AA5,0x0ABB,
	0x0B6D,0x0C6D,0x0E24,0x1092,0x11FA,0x11C8,0x10D7,0x10C5,
	0x120C,0x13A2,0x1483,0x1406,0x131C,0x12E9,0x1323,0x12F8,
	0x1264,0x1163,0x1026,0x0FE5,0x105D,0x10D6,0x0FCB,0x0D26,
	0x0A42,0x09CD,0x09C0,0x09C5,0x08BB,0x0663,0x039A,0x01C4,
	0x00B5,0x005E,0xFFDE,0xFE86,0xFD10,0xFB88,0xF9D7,0xF8C0,
	0xF794,0xF68D,0xF605,0xF5A8,0xF4EE,0xF408,0xF2D7,0xF119,
	0xEFC8,0xF0EF,0xF40B,0xF428,0xF2E8,0xF0FA,0xEF49,0xEF1C,
	0xEFCA,0xF0AE,0xF12A,0xF0BB,0xF082,0xF051,0xF07C,0xF14B,
	0xF21F,0xF234,0xF244,0xF327,0xF46F,0xF4F7,0xF540,0xF4E3,
	0xF4F4,0xF69F,0xF93C,0xFA83,0xFADF,0xFAC0,0xFA8B,0xFB54,
	0xFCD1,0xFE6B,0xFF61,0xFF80,0xFFD8,0x012C,0x0210,0x0256,
	0x02AF,0x03F0,0x0582,0x0640,0x05D4,0x05E0,0x05B0,0x04EE,
	0x057E,0x07C9,0x093C,0x0941,0x07DC,0x052A,0x00EC,0xFBB9,
	0xF534,0xEDA3,0xE64D,0xE03E,0xDDDD,0xDEE2,0xE330,0xE7CF,
	0xE82E,0xE2E2,0xDC22,0xD7F4,0xD774,0xD913,0xDA07,0xD98C,
	0xD8F6,0xD8D9,0xD9F1,0xDCB2,0xE036,0xE41D,0xE712,0xE856,
	0xE9EE,0xEC09,0xECBA,0xED1F,0xEF48,0xF42F,0xFABD,0x0080,
	0x040E,0x0585,0x0690,0x0900,0x0D59,0x12E3,0x1794,0x1AD2,
	0x1C62,0x1D3D,0x1F25,0x226F,0x2733,0x2B59,0x2DE2,0x2F91,
	0x315D,0x32BA,0x32ED,0x331D,0x33F1,0x35A7,0x3790,0x3946,
	0x39C1,0x3890,0x36B2,0x350C,0x34C9,0x360E,0x369F,0x35C1,
	0x32F2,0x2F14,0x2AD2,0x2AAA,0x29D1,0x26EF,0x259B,0x229A,
	0x2046,0x1D68,0x1A19,0x1667,0x137F,0x10D5,0x0E7F,0x0B95,
	0x08D1,0x0588,0x01C0,0xFE05,0xFB14,0xF9B5,0xF7FC,0xF53E,
	0xF175,0xEEA6,0xECAE,0xEAC8,0xE7C7,0xE51D,0xE334,0xE243,
	0xE15D,0xE0CC,0xDF4C,0xDD17,0xDB64,0xDA4F,0xDB2E,0xDC67,
	0xDCEB,0xDBE4,0xDA68,0xDA0B,0xDB1E,0xDD6B,0xDEF7,0xDF52,
	0xDF93,0xE0DA,0xE237,0xE384,0xE49B,0xE62D,0xE7FC,0xEA02,
	0xEBFC,0xEDE0,0xEFD8,0xF110,0xF1CC,0xF3DE,0xF776,0xFA90,
	0xFCDC,0xFD6C,0xFDD0,0xFDCA,0xFE66,0x00B9,0x0361,0x0568,
	0x0740,0x086F,0x08EA,0x09EA,0x0BEF,0x0D4E,0x0E43,0x0F7D,
	0x1101,0x11FD,0x1193,0x1124,0x120D,0x138C,0x134B,0x131E,
	0x142E,0x13A9,0x124D,0x11E1,0x125B,0x1265,0x10F4,0x0F04,
	0x0E24,0x0E1A,0x0E51,0x0D80,0x0BA0,0x09C0,0x0854,0x0735,
	0x06A5,0x064D,0x0560,0x03B4,0x01D0,0xFFEE,0xFF68,0x0001,
	0xFE3B,0xFC67,0xFB38,0xF9D9,0xF85E,0xF782,0xF668,0xF5CA,
	0xF601,0xF4F9,0xF41E,0xF310,0xF2E8,0xF374,0xF2CD,0xF19B,
	0xF14B,0xF1ED,0xF1E7,0xF149,0xF069,0xF01F,0xF0C6,0xF198,
	0xF23D,0xF27D,0xF297,0xF208,0xF28C,0xF39E,0xF493,0xF55A,
	0xF4EE,0xF4F1,0xF609,0xF788,0xF89B,0xF94B,0xF970,0xFA64,
	0xFB78,0xFCB6,0xFDAA,0xFDF9,0xFDD6,0xFE77,0x0004,0x0213,
	0x02F4,0x0276,0x0238,0x0326,0x04E1,0x0646,0x071F,0x0738,
	0x06E7,0x06B1,0x075E,0x087F,0x096A,0x09B6,0x092A,0x087B,
	0x0761,0x048E,0x0045,0xFA75,0xF41E,0xECD2,0xE5F9,0xE017,
	0xDD46,0xDF4E,0xE5D4,0xE8E4,0xE7B4,0xE492,0xDD53,0xD835,
	0xD700,0xD808,0xDA17,0xDBA8,0xDC3B,0xDB2A,0xDAB7,0xDCCC,
	0xE09C,0xE510,0xE829,0xEA08,0xEB0F,0xEC02,0xED13,0xEE48,
	0xF07B,0xF5A9,0xFC32,0x0244,0x0601,0x0736,0x0896,0x0AE5,
	0x0EDD,0x1404,0x1920,0x1C8F,0x1E42,0x1FBF,0x2164,0x24F3,
	0x2958,0x2D2C,0x2F90,0x3168,0x32E8,0x3476,0x34EB,0x357E,
	0x366F,0x384B,0x39F0,0x3A8C,0x3A88,0x397E,0x383A,0x36F6,
	0x364E,0x36AC,0x371C,0x363E,0x3398,0x2FFE,0x2D46,0x2B96,
	0x2AA9,0x2B90,0x29BD,0x25E4,0x2259,0x1EEC,0x1B4D,0x182D,
	0x15D9,0x13D6,0x1175,0x0DE8,0x0987,0x051A,0x01B9,0xFF7A,
	0xFDBA,0xFBEF,0xF966,0xF65D,0xF205,0xEE16,0xECBF,0xEBE1,
	0xEA51,0xE7E8,0xE5DC,0xE372,0xE1B3,0xDFC1,0xDE52,0xDE26,
	0xDE63,0xDD94,0xDC14,0xDADB,0xDB48,0xDBD8,0xDB2D,0xDA82,
	0xDB70,0xDEAD,0xE021,0xDF12,0xDE38,0xDF76,0xE0CD,0xE28C,
	0xE531,0xE783,0xE989,0xEA67,0xEA46,0xEB32,0xEE08,0xF16E,
	0xF371,0xF352,0xF42C,0xF69A,0xF854,0xF8B4,0xFAF3,0xFD5D,
	0xFF58,0x0090,0x01DA,0x03EB,0x05A2,0x0686,0x0727,0x0840,
	0x0A36,0x0BC0,0x0CC1,0x0D3B,0x0DC8,0x0EB8,0x0EB2,0x0E4F,
	0x0E87,0x1009,0x10A7,0x0FFA,0x0F48,0x0FC3,0x0FEF,0x0F35,
	0x0E5D,0x0D99,0x0CE5,0x0C2A,0x0BBA,0x0AE4,0x0994,0x0832,
	0x06C3,0x0614,0x05A6,0x04F0,0x031B,0x00FE,0xFEF9,0xFE19,
	0xFDFA,0xFDBE,0xFC59,0xFA2F,0xF7E0,0xF61C,0xF58C,0xF637,
	0xF633,0xF48C,0xF226,0xF00C,0xF0B5,0xF17C,0xF0EE,0xEF99,
	0xEEEC,0xEE2F,0xEE2A,0xEF83,0xED8A,0xED9C,0xED7F,0xED1F,
	0xED63,0xEEB5,0xEF4E,0xEF6E,0xEEC4,0xEE78,0xEF19,0xF048,
	0xF17D,0xF1A6,0xF1FE,0xF2C2,0xF3C6,0xF4B0,0xF4F1,0xF556,
	0xF60B,0xF73B,0xF863,0xF988,0xFA28,0xFAB1,0xFB46,0xFC78,
	0xFDD8,0xFF21,0x001C,0x00FE,0x00E8,0x0172,0x028E,0x03DE,
	0x0582,0x0673,0x0682,0x0641,0x0626,0x06F2,0x088A,0x0942,
	0x0973,0x08CE,0x0811,0x07BD,0x0722,0x0524,0x0084,0xF9E1,
	0xF241,0xEA73,0xE341,0xDE8F,0xDE35,0xE26B,0xE8DB,0xEC93,
	0xEAD3,0xE47B,0xDC53,0xD61D,0xD568,0xD7BC,0xDAA4,0xDB42,
	0xD9DC,0xD85F,0xDA2F,0xDF02,0xE4DC,0xE853,0xE955,0xE9C7,
	0xEAC5,0xEBC5,0xECC6,0xEE5C,0xF253,0xF842,0xFE05,0x03FD,
	0x083F,0x09FC,0x0A55,0x0C90,0x109E,0x15E0,0x1A3C,0x1D5F,
	0x1F0B,0x20A9,0x22DE,0x25E7,0x2A7F,0x2FD9,0x3394,0x345E,
	0x3382,0x331C,0x33C3,0x3606,0x37CC,0x3965,0x3B72,0x3C25,
	0x3A7F,0x399B,0x399C,0x3952,0x37A9,0x359B,0x34BF,0x3540,
	0x34A6,0x317A,0x2D1E,0x2A3D,0x29E0,0x2A77,0x2922,0x263F,
	0x21AC,0x1C7F,0x17EF,0x153E,0x1500,0x13B3,0x0FE1,0x0AF0,
	0x06C7,0x0425,0x01C6,0xFEF6,0xFBEF,0xF952,0xF6B0,0xF414,
	0xF0E8,0xEDFE,0xEB78,0xE953,0xE7B0,0xE6C9,0xE64F,0xE440,
	0xE0DF,0xDDD4,0xDD02,0xDDF7,0xDE84,0xDD59,0xDBDF,0xDA5C,
	0xDA03,0xDA25,0xDA89,0xDB87,0xDCAA,0xDC72,0xDCEE,0xDDB5,
	0xDFA1,0xE0CA,0xE122,0xE25D,0xE560,0xE81C,0xE9B9,0xEA6C,
	0xEB06,0xEC6D,0xEEDF,0xF1EB,0xF449,0xF640,0xF737,0xF7A8,
	0xF905,0xFCA2,0x0083,0x00B5,0x02F7,0x048D,0x0520,0x0765,
	0x08E5,0x098A,0x0B32,0x0CC0,0x0E03,0x0EEF,0x0EFF,0x0F2D,
	0x0FEA,0x111D,0x12A9,0x13BC,0x13DA,0x12AC,0x1175,0x119E,
	0x1284,0x132F,0x1271,0x1167,0x106B,0x0FDF,0x0F69,0x0E84,
	0x0D69,0x0C24,0x0B02,0x09CF,0x0936,0x086D,0x0712,0x04E5,
	0x02DD,0x024F,0x027C,0x0203,0x0000,0xFD57,0xFB68,0xFA95,
	0xF9FD,0xF95F,0xF82F,0xF66D,0xF505,0xF430,0xF397,0xF2FD,
	0xF1F2,0xF0EE,0xF01C,0xEF94,0xEF5A,0xEF1A,0xEE45,0xEDAD,
	0xEE9D,0xF08B,0xF008,0xF024,0xEFFA,0xEF19,0xEEA7,0xEEFB,
	0xF007,0xF0C1,0xF02D,0xEFBA,0xF10E,0xF2F6,0xF46E,0xF3D6,
	0xF390,0xF46B,0xF5D1,0xF6FF,0xF73D,0xF856,0xF9A1,0xF950,
	0xF9B0,0xFB95,0xFD66,0xFDD3,0xFDBE,0xFE09,0xFF6A,0x015D,
	0x025D,0x0213,0x01DE,0x020C,0x03CD,0x0543,0x0610,0x064B,
	0x0654,0x0673,0x06FE,0x0761,0x082B,0x0829,0x0595,0x0286,
	0xFFD8,0xFC2C,0xF6E8,0xEF23,0xE4EF,0xDC4C,0xD8E5,0xDCB7,
	0xE46C,0xEB4F,0xEE10,0xEA3C,0xE118,0xD981,0xD54F,0xD40C,
	0xD417,0xD44F,0xD4E4,0xD74B,0xDAE0,0xDFE0,0xE48A,0xE796,
	0xE9F6,0xEA93,0xEA43,0xE999,0xE7D0,0xE6DB,0xE8C1,0xEF22,
	0xF912,0x02A6,0x08CF,0x0A9B,0x0A9D,0x0B1A,0x0C54,0x0EC0,
	0x11D8,0x1437,0x166F,0x1952,0x1DB2,0x23A6,0x297F,0x2E04,
	0x316C,0x3301,0x32B1,0x30E2,0x2EAF,0x2DF6,0x2ED8,0x3223,
	0x36A1,0x3984,0x3A2D,0x39DA,0x38F2,0x379D,0x3626,0x342D,
	0x3271,0x2FFC,0x2D2B,0x2B38,0x2AC9,0x2A40,0x2A1A,0x29DF,
	0x28AB,0x25C3,0x2394,0x1D46,0x15F0,0x1271,0x0FDB,0x0F0B,
	0x0DBA,0x0C21,0x0955,0x06BD,0x038D,0x001E,0xFD3C,0xFA3F,
	0xF60B,0xF130,0xECE3,0xEA7F,0xE8FF,0xE758,0xE6C6,0xE6C1,
	0xE680,0xE4CE,0xE1BB,0xDE11,0xDB57,0xDA2C,0xD99F,0xD97F,
	0xD988,0xD955,0xD906,0xD994,0xDAC0,0xDC3C,0xDCF1,0xDCB6,
	0xDBFE,0xDB98,0xDBF6,0xDCB0,0xDE44,0xE068,0xE3BD,0xE6F5,
	0xE8D6,0xE996,0xEA65,0xEB22,0xECDA,0xEEDF,0xF0FE,0xF2AB,
	0xF47B,0xF689,0xF93D,0xFC7E,0xFF53,0x0153,0x022E,0x0337,
	0x049C,0x0507,0x043A,0x04EC,0x06DF,0x0883,0x0A55,0x0CCA,
	0x0F87,0x1003,0x0F6E,0x0ECF,0x0F40,0x1038,0x1062,0x1080,
	0x10DE,0x10D4,0x11B2,0x1202,0x124E,0x10FD,0x0FEA,0x0FC8,
	0x0FA4,0x0F39,0x0E40,0x0C59,0x0A28,0x08A7,0x08E9,0x09C6,
	0x0B02,0x09AA,0x060D,0x028B,0x006C,0x0042,0x0050,0xFFCB,
	0xFE9B,0xFC62,0xFA95,0xFAE2,0xFAE2,0xFA14,0xF938,0xF5F9,
	0xF45C,0xF532,0xF4F4,0xF333,0xF0B1,0xEF25,0xEF9F,0xF1D1,
	0xF3D3,0xF3F6,0xF19B,0xEE6D,0xED9B,0xEF2B,0xF1E8,0xF332,
	0xF1CF,0xEFFC,0xEF49,0xF049,0xF21D,0xF3CC,0xF46C,0xF3D6,
	0xF34A,0xF47A,0xF614,0xF735,0xF752,0xF721,0xF7D1,0xFACF,
	0xFD73,0xFE03,0xFD0C,0xFBF8,0xFC1F,0xFEBC,0x01E4,0x0350,
	0x0270,0x0140,0x01A9,0x0395,0x05C2,0x06AC,0x064D,0x05E7,
	0x0636,0x0789,0x08FF,0x0971,0x07F4,0x0753,0x08A4,0x0AF0,
	0x0CCC,0x0C1F,0x08D1,0x0512,0x018F,0xFDAB,0xF82A,0xF189,
	0xE8B4,0xE1B3,0xE070,0xE655,0xEEE8,0xF545,0xF4B7,0xEE4E,
	0xE6E4,0xE21B,0xDD87,0xDB99,0xDD38,0xDD47,0xDE98,0xE13F,
	0xE4B8,0xE863,0xEB7F,0xEE14,0xF011,0xF0A7,0xEFC8,0xECD2,
	0xEA73,0xEB15,0xEF24,0xF66C,0xFE78,0x057E,0x0979,0x0B45,
	0x0B55,0x0B17,0x0B7A,0x0D3D,0x0F0E,0x1183,0x1495,0x181B,
	0x1C6F,0x20BC,0x245A,0x2854,0x2BD3,0x2D33,0x2C3E,0x2968,
	0x2714,0x267E,0x27E7,0x2B2B,0x2F49,0x3290,0x33CD,0x3332,
	0x31B1,0x2FC4,0x2D6F,0x2B84,0x2A18,0x2829,0x26A1,0x24F1,
	0x2400,0x2414,0x2460,0x2402,0x2283,0x1F30,0x1B7A,0x171C,
	0x148D,0x1173,0x0F43,0x0E2A,0x0C2C,0x09A2,0x07EC,0x06E6,
	0x04C7,0x018D,0xFE90,0xFB73,0xF782,0xF399,0xF048,0xEEB9,
	0xEDFF,0xEDA4,0xEC8A,0xEB69,0xEB38,0xEA3F,0xE69D,0xE2AB,
	0xE09A,0xE059,0xDFD7,0xDFE8,0xDFD9,0xDF87,0xDF86,0xE023,
	0xE120,0xE230,0xE234,0xE196,0xE0A1,0xE052,0xE130,0xE29F,
	0xE38F,0xE4A6,0xE6D9,0xEA98,0xEDAF,0xED3F,0xEC09,0xED36,
	0xEF9F,0xF183,0xF363,0xF507,0xF6CC,0xF7D4,0xF89D,0xFA56,
	0xFDA7,0x00DE,0x0198,0x00BB,0xFFF0,0x019E,0x0308,0x040E,
	0x0515,0x067C,0x07EA,0x091F,0x0AA5,0x0CBA,0x0D97,0x0CBB,
	0x0B11,0x0A83,0x0BE8,0x0D2D,0x0CF8,0x0BF0,0x0BB1,0x0C1C,
	0x0C55,0x0CEE,0x0D01,0x0C58,0x0AED,0x0958,0x0884,0x0846,
	0x0737,0x0655,0x056C,0x04BF,0x0478,0x0421,0x03A0,0x01FF,
	0x0029,0xFEF9,0xFE63,0xFCFB,0xFB14,0xF958,0xF857,0xF7DF,
	0xF801,0xF7BE,0xF6B0,0xF509,0xF3CD,0xF365,0xF39B,0xF301,
	0xF1B2,0xEF87,0xEF50,0xF0F3,0xF18E,0xF0EC,0xF06C,0xF025,
	0xEF80,0xEFAC,0xF164,0xEF6F,0xF024,0xF0B6,0xF098,0xF108,
	0xF195,0xF18F,0xF1C5,0xF2AF,0xF385,0xF49C,0xF547,0xF55B,
	0xF526,0xF5B6,0xF651,0xF6F0,0xF773,0xF910,0xFAB7,0xFBE9,
	0xFC08,0xFC00,0xFC5E,0xFCF5,0xFD9B,0xFECD,0x0043,0x00D5,
	0x00F2,0x0096,0x00A5,0x01AF,0x0300,0x03C2,0x045F,0x057E,
	0x063F,0x051F,0x0380,0x0347,0x0467,0x059D,0x0665,0x05FC,
	0x03F3,0x009D,0xFD1D,0xFA89,0xFA08,0xF984,0xF8F8,0xF93B,
	0xFA85,0xFC04,0xFCA0,0xFAEB,0xF821,0xF5DB,0xF473,0xF3C9,
	0xF38